<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = get_option( 'stylesheet' );
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'options_framework_theme'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Test data
	$test_array = array(
		'one' => __('One', 'options_framework_theme'),
		'two' => __('Two', 'options_framework_theme'),
		'three' => __('Three', 'options_framework_theme'),
		'four' => __('Four', 'options_framework_theme'),
		'five' => __('Five', 'options_framework_theme')
	);

	// Multicheck Array
	$multicheck_array = array(
		'one' => __('French Toast', 'options_framework_theme'),
		'two' => __('Pancake', 'options_framework_theme'),
		'three' => __('Omelette', 'options_framework_theme'),
		'four' => __('Crepe', 'options_framework_theme'),
		'five' => __('Waffle', 'options_framework_theme')
	);

	// Multicheck Defaults
	$multicheck_defaults = array(
		'one' => '1',
		'five' => '1'
	);

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Typography Defaults
	$typography_defaults = array(
		'size' => '15px',
		'face' => 'georgia',
		'style' => 'bold',
		'color' => '#bada55' );
		
	// Typography Options
	$typography_options = array(
		'sizes' => array( '6','12','14','16','20' ),
		'faces' => array( 'Helvetica Neue' => 'Helvetica Neue','Arial' => 'Arial' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}


	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/images/';

	$options = array();
	
/*------------------------------------------------------------------------------*/
/*	Основные настройки
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Основные настройки',
		'type' => 'heading');

	$options[] = array(
		'name' => 'Логотип',
		'desc' => 'Ссылка на файл изображения (JPEG, PNG, GIF)',
		'id' => 'logo',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => 'Текст',
		'id' => 'logo_text',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'name' => 'Иконка favicon',
		'desc' => 'Ссылка на файл изображения 16x16px (JPEG, PNG, GIF)',
		'id' => 'favicon',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Социальные сервисы',
		'desc' => 'Включить',
		'id' => 'social_on',
		'std' => '1',
		'type' => 'checkbox');
		
	$options[] = array(
		'desc' => 'RSS',
		'id' => 'rss_link',
		'std' => get_bloginfo( 'rss2_url' ),
		'type' => 'text');	

	$options[] = array(
		'desc' => 'ВКонтакте',
		'id' => 'vkontakte_link',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => 'Twitter',
		'id' => 'twitter_link',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => 'Facebook',
		'id' => 'facebook_link',
		'std' => '',
		'type' => 'text');		
		
/*------------------------------------------------------------------------------*/
/*	Внешний вид
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Внешний вид',
		'type' => 'heading');

	$options[] = array(
		'name' => 'Фоновое изображение',
		'desc' => 'Включить',
		'id' => 'bg_image_body_on',
		'std' => '1',
		'type' => 'checkbox');
	
	$options[] = array(
		'desc' => 'Файл изображения (JPEG, PNG, GIF)',
		'id' => 'bg_image_body_my',
		'type' => 'upload');
	
	$options[] = array(
		'name' => 'Цвет фона',
		'id' => 'bg_color_body',
		'std' => '#eaeaea',
		'type' => 'color' );

	$options[] = array(
		'name' => 'Цвет текста',
		'id' => 'text_color',
		'std' => '#555555',
		'type' => 'color' );
		
	$options[] = array(
		'name' => 'Цвет ссылок',
		'id' => 'link_color',
		'std' => '#536773',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover',
		'std' => '#888888',
		'type' => 'color' );
		
    $options[] = array(
		'name' => 'Боковая колонка',
		'desc' => 'Цвет текста',
		'id' => 'text_color_s',
		'std' => '#555555',
		'type' => 'color' );		
		
    $options[] = array(
		'desc' => 'Цвет заголовков виджетов',
		'id' => 'text_color_s_t',
		'std' => '#444444',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_s',
		'std' => '#536773',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_s',
		'std' => '#888888',
		'type' => 'color' );				

	$options[] = array(
	    'name' => 'Цвет заголовков записей',
		'desc' => 'Главная страница, рубрики, метки, архивы, поиск',
		'id' => 'link_color_e_t',
		'std' => '#444444',
		'type' => 'color' );
		
	$options[] = array(
	    'desc' => 'Цвет заголовков при наведении',
		'id' => 'link_color_hover_e_t',
		'std' => '#888888',
		'type' => 'color' );
		
		$options[] = array(
		'desc' => 'Страница записи',
		'id' => 'color_e_t',
		'std' => '#444444',
		'type' => 'color' );
		
	$options[] = array(
		'name' => 'Bottom Left, Bottom Center, Bottom Right',
		'desc' => 'Цвет текста',
		'id' => 'text_color_bottom',
		'std' => '#888888',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Цвет заголовков виджетов',
		'id' => 'color_heading_bottom',
		'std' => '#888888',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_bottom',
		'std' => '#536773',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_bottom',
		'std' => '#888888',
		'type' => 'color' );

	$options[] = array(
		'name' => 'Подвал (Footer)',
		'desc' => 'Цвет текста',
		'id' => 'text_color_f',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_f',
		'std' => '#536773',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_f',
		'std' => '#888888',
		'type' => 'color' );		
		
/*------------------------------------------------------------------------------*/
/*	Настройки макета
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Настройки макета',
		'type' => 'heading' );
		
	$options[] = array(
		'name' => "Боковая колонка",
		'id' => "sidebar",
		'std' => "r_s",
		'type' => "images",
		'options' => array(
			'l_s' => $imagepath . '2cl.png',
			'r_s' => $imagepath . '2cr.png')
	);

	$options[] = array(
		'name' => 'Главная страница',
		'desc' => 'Стандартные записи',
		'id' => 'standart_post_on',
		'std' => '',
		'type' => 'checkbox');			
	
	$options[] = array(
	    'name' => "Заголовок и описание",
		'desc' => 'Рубрики',
		'id' => 'cat_desc_on',
		'std' => '1',
		'type' => 'checkbox');	
		
	$options[] = array(
		'desc' => 'Метки',
		'id' => 'tags_desc_on',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'desc' => 'Страницы',
		'id' => 'page_desc_on',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => 'Похожие записи',
		'desc' => 'Включить',
		'id' => 'related_post_on',
		'std' => '1',
		'type' => 'checkbox');	
		
	$options[] = array(
		'desc' => 'Заголовок',
		'id' => 'related_post_heading',
		'std' => 'Похожие записи',
		'type' => 'text');

	$options[] = array(
		'desc' => 'Количество записей',
		'id' => 'related_post_num',
		'std' => '3',
		'type' => 'text');

    $options[] = array(
		'name' => 'Bottom Left, Bottom Center, Bottom Right',
		'desc' => 'Включить',
		'id' => 'blocks_bottom_on',
		'std' => '1',
		'type' => 'checkbox');			

	$options[] = array(
	    'name' => "Постраничная навигация",
		'desc' => 'Включить',
		'id' => 'pagination_on',
		'std' => '1',
		'type' => 'checkbox');		
		

	return $options;
}

/*
 * This is an example of how to add custom scripts to the options panel.
 * This example shows/hides an option when a checkbox is clicked.
 */

add_action('optionsframework_custom_scripts', 'optionsframework_custom_scripts');

function optionsframework_custom_scripts() { ?>

<script type="text/javascript">
jQuery(document).ready(function($) {

	$('#example_showhidden').click(function() {
  		$('#section-example_text_hidden').fadeToggle(400);
	});

	if ($('#example_showhidden:checked').val() !== undefined) {
		$('#section-example_text_hidden').show();
	}

});
</script>

<?php
}