<?php
class ControllerShippingMoscow extends Controller { 
	private $error = array();
	
	public function index() {  
		$this->load->language('shipping/moscow');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				 
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('moscow', $this->request->post);	

			$this->session->data['success'] = $this->language->get('text_success');
									
			$this->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
		}
		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		
		$this->data['entry_moscow_rate'] = $this->language->get('entry_moscow_rate');
		$this->data['entry_zamkad_rate'] = $this->language->get('entry_zamkad_rate');
		$this->data['entry_max_distance'] = $this->language->get('entry_max_distance');
		
		$this->data['entry_tax_class'] = $this->language->get('entry_tax_class');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_shipping'),
			'href'      => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('shipping/moscow', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('shipping/moscow', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'); 

		$this->load->model('localisation/geo_zone');
		
		if (isset($this->request->post['moscow_moscow_rate'])) {
			$this->data['moscow_moscow_rate'] = $this->request->post['moscow_moscow_rate'];
		} else {
			$this->data['moscow_moscow_rate'] = $this->config->get('moscow_moscow_rate');
		}
		
		if (isset($this->request->post['moscow_zamkad_rate'])) {
			$this->data['moscow_zamkad_rate'] = $this->request->post['moscow_zamkad_rate'];
		} else {
			$this->data['moscow_zamkad_rate'] = $this->config->get('moscow_zamkad_rate');
		}
		
		if (isset($this->request->post['moscow_max_distance'])) {
			$this->data['moscow_max_distance'] = $this->request->post['moscow_max_distance'];
		} else {
			$this->data['moscow_max_distance'] = $this->config->get('moscow_max_distance');
		}

		if (isset($this->request->post['moscow_status'])) {
			$this->data['moscow_status'] = $this->request->post['moscow_status'];
		} else {
			$this->data['moscow_status'] = $this->config->get('moscow_status');
		}		
		
		$this->load->model('localisation/geo_zone');
		
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['moscow_geo_zone_id'])) {
			$this->data['moscow_geo_zone_id'] = $this->request->post['moscow_geo_zone_id'];
		} else {
			$this->data['moscow_geo_zone_id'] = $this->config->get('moscow_geo_zone_id');
		}
		
		if (isset($this->request->post['moscow_tax_class_id'])) {
			$this->data['moscow_tax_class_id'] = $this->request->post['moscow_tax_class_id'];
		} else {
			$this->data['moscow_tax_class_id'] = $this->config->get('moscow_tax_class_id');
		}
		
		if (isset($this->request->post['moscow_status'])) {
			$this->data['moscow_status'] = $this->request->post['moscow_status'];
		} else {
			$this->data['moscow_status'] = $this->config->get('moscow_status');
		}
		
		if (isset($this->request->post['moscow_sort_order'])) {
			$this->data['moscow_sort_order'] = $this->request->post['moscow_sort_order'];
		} else {
			$this->data['moscow_sort_order'] = $this->config->get('moscow_sort_order');
		}	
		
		$this->load->model('localisation/tax_class');
				
		$this->data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

		$this->template = 'shipping/moscow.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
		
	private function validate() {
		if (!$this->user->hasPermission('modify', 'shipping/moscow')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>
