<?php
/*
Plugin Name: Hider
Plugin URI: http://hider.wppage.ru/
Description:
Version: 1.1
Author: Виктор Левчук
Author URI: http://hider.wppage.ru/
*/
define('HIDER_VERSION', '1.1');

include_once('inc/functions.php');
include_once('inc/metabox.php');
include_once('inc/shortcode.php');
include_once('inc/shortcode-settings.php');
include_once('inc/hider-shortcode-settings-js.php');
include_once('inc/updater.php');

function hider_activate()
{
    update_option('hider_version', HIDER_VERSION);

    $upload_dir = wp_upload_dir();
    $hider_folder = $upload_dir['basedir'].'/hider';

    if (!file_exists($hider_folder)) {
        mkdir($hider_folder);
    }
    add_action('init', 'hider_register_image_sizes');

}
register_activation_hook(__FILE__, 'hider_activate');


function hider_admin_menu()
{

    $page_title = 'Hider';
    $menu_title = 'Hider';
    $capability = 'manage_options';
    $menu_slug = 'hider-updater';
    $function = 'hider_updater';
    add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function, '', 7);

    $sub_menu_title = 'Обновление';
    add_submenu_page($menu_slug, $page_title, $sub_menu_title, $capability, $menu_slug, $function);


}
add_action('admin_menu', 'hider_admin_menu' );
add_action('admin_init', 'hider_admin_js_css_init');

add_action('wp_head', 'hider_frontend_css');
add_action('wppage_head', 'hider_frontend_css');

add_action("wp_footer", "hider_frontend_js_lib"); // include jQuery
add_action("wp_footer", "hider_frontend_js"); // for wordpress pages, posts
add_action("wppage_footer", "hider_frontend_js"); // for wppage


add_action('admin_init', 'hider_add_metabox', 1);
add_action('save_post', 'hider_save_metabox', 1, 2);

add_action( 'admin_print_scripts', 'hider_admin_scripts' );


