<?php

function hider_shortcode($atts)
{
    global $post;

    $id = $atts['id'];
    $video_url = get_post_meta($post->ID, '_hider_video_url', true);

    $minutes = get_post_meta($post->ID, '_hider_video_minutes', true);
    $seconds = get_post_meta($post->ID, '_hider_video_seconds', true);


    $hider_video_width = get_post_meta($post->ID, '_hider_video_width', true);
    $hider_video_height = get_post_meta($post->ID, '_hider_video_height', true);
    $size = $hider_video_width . 'x' . $hider_video_height;


    $hider_video_border = get_post_meta($post->ID, '_hider_video_border', true);

    $hider_video_border_size = get_post_meta($post->ID, '_hider_video_border_size', true);
    $skin = get_post_meta($post->ID, '_hider_video_skin', true);



    $time = 0;
    if(!empty($minutes) && $minutes!=0){
        $time = 60*$minutes;
    }
    if(!empty($seconds) && $seconds!=0){
        $time += $seconds;
    }

    $autoplay = get_post_meta($post->ID, '_hider_video_autoplay', true);
    if(!empty($autoplay)){
        $autoplay = 'autoplay="autoplay"';
    }else{
        $autoplay = '';
    }

    $hide_video_controls = get_post_meta( $post->ID, '_hider_video_controls', true);


    $video_data = parse_url($video_url);

    if($video_data['host'] == 'www.youtube.com' ){
        $source = '<source type="video/youtube" src="'.$video_url.'" />';
    }elseif($video_data['host'] == 'www.vimeo.com'){
        $source = '<source type="video/vimeo" src="'.$video_url.'" />';
    }
    else{
        $source = '<source type="video/mp4" src="'.$video_url.'" />';
    }



    $css = '<style type="text/css">';
    if($hide_video_controls == 'hide'){
        $css .= ".mejs-controls{ display:none!important;}";
    }
    $css .= '</style>';


    $js = "
    <script type='text/javascript'>
    jQuery(function($){

    $('#hider-".$id."').mediaelementplayer({
			startVolume: 1,
			enableAutosize: false,
			features: ['playpause','progress','current','duration','tracks','volume','fullscreen'],
			success: function (mediaElement, domObject) {
                // Starting timer
				/*mediaElement.addEventListener(
					'timeupdate',
					function(e) {

						// Variables
						var current = parseInt(mediaElement.currentTime, 10);
						e.preventDefault();

					},
					false
				);*/
				var current = 0;
				mediaElement.addEventListener('timeupdate', function (e) {
				    current = parseInt(mediaElement.currentTime);
				    if(current >= ".$time."){
                        $.ajax({
                                        type: 'GET',
                                        url: ajaxurl,
                                        data: {
                                            action: 'get_hider_content',
                                            page_id: ".$post->ID."
                                        },
                                        success: function (data) {
                                           // console.log(data);
                                            if(!$('#ajax-".$id."').hasClass('loaded')){
                                                $('#ajax-".$id."').html(data).addClass('loaded').slideDown('slow');
                                            }else{
                                                return;
                                            }
                                        },
                                        error: function(errorThrown){
                                            //alert(errorThrown);
                                        }
                                    });
				    }

                }, false);

			}
		}
	);
	 });
	</script>";



    $video_embed = '
    <video id="hider-'.$id.'" width="'.$hider_video_width.'" height="'.$hider_video_height.'" controls="none" preload="none" '.$autoplay.'>
        <!-- MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7 -->
        '. $source .'
        <object width="'.$hider_video_width.'" height="'.$hider_video_height.'" type="application/x-shockwave-flash" data="'.plugins_url("/hider/js/mediaelement/lib/flashmediaelement.swf").'">
            <param name="movie" value="'.plugins_url("/hider/js/mediaelement/lib/flashmediaelement.swf").'" />
            <param name="flashvars" value="controls=false&file='.$video_url.'" />
            <!-- Image as a last resort -->
        </object>
    </video>
    ';

    $html = '';
    $video = '';

    if( $hider_video_border == 'yes'){
        $video .= '<div class="video_wrap video_'. $skin . '_'. $size . '"><div class="v_box size-' . $size . '">';
        $video .= $video_embed;
        $video .= '</div></div>';
    }else{
        $video .= $video_embed;
    }
    
    $html .= '<div class="hider-wrap">' . $video . $js . $css . '<div class="clearfix"></div><div id="ajax-'.$id.'" class="ajax-hider-content"></div></div>';
    return $html;

    
}

/**
 * Add shortcodes
 */

add_shortcode('wppage_hider', 'hider_shortcode');
