<?php
/**
 * Hider Settings
 */

function hider_extra()
{
    global $post;

    add_filter('tiny_mce_before_init', 'hider_tinymce_config', 9999);

    if (version_compare(get_bloginfo('version'), '3.9', '>=')) {
        $tinymce_options = array(
            'quicktags'     => true,
            'media_buttons' => true,
            'editor_height' => 500,
            'textarea_name' => 'hider-content',
            'editor_class'  => 'hider-message-editor'/*,
            'tinymce'       => array(
                'toolbar1' => 'bold italic underline strikethrough | forecolor backcolor | justifyleft justifycenter justifyright | bullist numlist outdent indent |removeformat | link unlink hr',
                'toolbar2' => false,
                'toolbar3' => false
            )*/
        );

    } else {
        $tinymce_options = array(
            'media_buttons' => true,
            'teeny'         => false,
            'quicktags'     => true,
            'textarea_rows' => 40,
            'textarea_name' => 'hider-content',
            'editor_class'  => 'hider-message-editor'/*,
            'tinymce'       => array(
                'theme_advanced_buttons1'   => 'bold,italic,underline,strikethrough,|,forecolor,backcolor,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,outdent,indent,|,removeformat,|,link,unlink,hr',
                'theme_advanced_buttons2'   => 'fontselect,fontsizeselect,formatselect,|,forecolor,backcolor,|,tb_bullets_button,tb_arrows_with_title_button,tb_arrows_button,tb_text_box_button,tb_divide_button',
                'theme_advanced_buttons3'   => '',
                'theme_advanced_buttons4'   => '',
                'theme_advanced_font_sizes' => '10px,11px,12px,13px,14px,15px,16px,17px,18px,19px,20px,21px,22px,23px,24px,25px,26px,27px,28px,29px,30px,32px,42px,48px,52px'

            )*/
        );

    }

    echo '<input type="hidden" name="hider_metabox_noncename" id="hider_metabox_noncename" value="' .
        wp_create_nonce(plugin_basename(__FILE__)) . '" />';

    $hider_video_url = get_post_meta($post->ID, '_hider_video_url', true);
    $hider_video_width = get_post_meta($post->ID, '_hider_video_width', true);
    if (empty($hider_video_width)) $hider_video_width = '640';

    $hider_video_height = get_post_meta($post->ID, '_hider_video_height', true);
    if (empty($hider_video_height)) $hider_video_height = '360';

    $hider_video_autoplay = get_post_meta($post->ID, '_hider_video_autoplay', true);
    if (empty($hider_video_autoplay)) {
        $hider_video_autoplay = 'off';
    }
    $hider_video_controls = get_post_meta($post->ID, '_hider_video_controls', true);

    $hider_width = get_post_meta($post->ID, '_hider_width', true);
    if ($hider_width == '') {
        $hider_width = 400;
    }

    $hider_width_auto = get_post_meta($post->ID, '_hider_width_auto', true);

    $hider_video_border = get_post_meta($post->ID, '_hider_video_border', true);
    if (empty($hider_video_border)) {
        $hider_video_border = 'no';
    }

    $hider_content = get_post_meta($post->ID, '_hider_content', true);
    $hider_bg_color_1 = get_post_meta($post->ID, '_hider_bg_color_1', true);
    if ($hider_bg_color_1 == '') {
        $hider_bg_color_1 = 'ffffff';
    }

    $hider_bg_color_2 = get_post_meta($post->ID, '_hider_bg_color_2', true);
    if ($hider_bg_color_2 == '') {
        $hider_bg_color_2 = 'f2f2f2';
    }

    $hider_border_color = get_post_meta($post->ID, '_hider_border_color', true) ? get_post_meta($post->ID,
        '_hider_border_color', true) : 'cccccc';
    $hider_border_style = get_post_meta($post->ID, '_hider_border_style', true) ? get_post_meta($post->ID,
        '_hider_border_style', true) : 'solid';
    $hider_background_transparent = get_post_meta( $post->ID, '_hider_background_transparent', true);

    $hider_border_width = get_post_meta($post->ID, '_hider_border_width', true);
    if(empty($hider_border_width)) $hider_border_width = '0';

    $hider_border_radius = get_post_meta($post->ID, '_hider_border_radius', true);
    if(empty($hider_border_radius)) $hider_border_radius = '0';
    
    $hider_video_minutes = get_post_meta($post->ID, '_hider_video_minutes', true);
    $hider_video_seconds = get_post_meta($post->ID, '_hider_video_seconds', true);

    $hider_video_border_size = get_post_meta($post->ID, '_hider_video_border_size', true);
    $hider_video_skin = get_post_meta($post->ID, '_hider_video_skin', true);

    $html_bg_color = 'ffffff';
    if (get_post_type() == 'page_selling') {
        if (get_post_meta(get_the_ID(), '_ps_content_background_color', true)) {
            $html_bg_color = get_post_meta(get_the_ID(), '_ps_content_background_color', true);
        }
    }

    $image_dir = plugins_url() . '/hider/i/';

    // set hider content wrap width
    if($hider_width_auto == 'on'){
        $hider_content_wrap_width = 'auto';
    }else{
        $hider_content_wrap_width = $hider_width.'px';
    }


    $editor_base_style = "
    html{ background-color:#$html_bg_color!important;}
    body.hider-content{
        border-color: #" . $hider_border_color . ";
        border-style: " . $hider_border_style . ";
        border-width: " . $hider_border_width . "px;
        border-radius: " . $hider_border_radius . "px;
        width: " . $hider_content_wrap_width . ";";
    if($hider_background_transparent == 'transparent'){
        $editor_base_style .= "
        background: transparent;";
    }else{
        $editor_base_style .= "
        background: #". $hider_bg_color_1 ."; /* Old browsers */
        background: -moz-linear-gradient(top,  #". $hider_bg_color_1 ." 0%, #". $hider_bg_color_2 ." 100%); /* FF3.6+ */
        background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#". $hider_bg_color_1 ."), color-stop(100%,#". $hider_bg_color_2 .")); /* Chrome,Safari4+ */
        background: -webkit-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Chrome10+,Safari5.1+ */
        background: -o-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Opera 11.10+ */
        background: -ms-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* IE10+ */
        background: linear-gradient(to bottom,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* W3C */
        filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#". $hider_bg_color_1 ."', endColorstr='#". $hider_bg_color_2 ."',GradientType=0 ); /* IE6-9 */";
    }
    $editor_base_style .= "
        padding: 20px;
        margin: 30px auto;
        /* Prevent background color leak outs */
        -webkit-background-clip: padding-box; 
        -moz-background-clip: padding; 
        background-clip: padding-box;
        }
    body#tinymce img{
        max-width: 100%;
    }";


    //=====
    $upload_dir = wp_upload_dir();
    $hider_css_file = $upload_dir['basedir'] . '/hider/hider-editor-style-' . $post->ID . '.css';
    $handle = fopen($hider_css_file, 'w') or die('Cannot open file:  ' . $hider_css_file);
    fwrite($handle, $editor_base_style);
    fclose($handle);
    //=====

    ?>
    <script type="text/javascript">
        jQuery(function ($) {
            //tabs
            $('#hider-tabs').tabs({
                autoHeight: false,
                collapsible: false,
                fx: {
                    opacity: 'toggle',
                    duration: 'fast'
                }
            });


            // slider
            $("#hider-slider").slider({
                value:<?php echo $hider_width; ?>,
                min: 200,
                max: 1600,
                step: 10,
                slide: function (event, ui) {
                    $("#hider-width").val(ui.value);
                }
            });
            $("#hider-border-width-slider").slider({
                value:<?php echo $hider_border_width; ?>,
                min: 0,
                max: 30,
                step: 1,
                slide: function (event, ui) {
                    $("input[name=hider_border_width]").val(ui.value);
                }
            });
            $("#hider-border-radius-slider").slider({
                value:<?php echo $hider_border_radius; ?>,
                min: 0,
                max: 100,
                step: 1,
                slide: function (event, ui) {
                    $("input[name=hider_border_radius]").val(ui.value);
                }
            });
            $("#hider-width").val($("#hider-slider").slider("value"));
           // $("input[name=hider_border_width]").val($("#hider-border-radius-width").slider("value"));
           // $("input[name=hider_border_radius]").val($("#hider-border-radius-slider").slider("value"));

        });
    </script>
    <div class="additional p-box p-content hider-wrap">
    <div id="hider-tabs" class="hider-tabs">
    <a class="hider-logo" href="http://hider.wppage.ru/" title="Hider"></a>
    <ul class="hider-tabs-nav">
        <li><a href="#hider-tab-1">Видео</a></li>
        <li><a href="#hider-tab-2">Дизайн</a></li>
        <li><a href="#hider-tab-3">Контент</a></li>
    </ul>
    <div id="hider-tab-1" class="hider-content-box">
        <div class="triangle"></div>
        <div class="hider-content-round">
            <div class="hider-top-nav-bar">
                <input name="save" type="submit" class="button-primary" tabindex="5" accesskey="p"
                       value="Обновить">
            </div>
            <div class="hider-content-panel">
                <div id="hider-video-form">
                    <p>
                        <label for="video-link">Ссылка на видео: <br>
                            <input type="text" id="video-link" name="hider_video_url" class="width_100p"
                                   value="<?php echo $hider_video_url; ?>"/></label>
                    </p>
                    <table style="width: 100%" class="v-top">
                        <tr>
                            <td style="width: 300px">
                                <p>
                                    Время появления контента:<br></p>

                                <p>
                                    <label><input type="number" maxlength="3" size="3" class="width-100" name="hider_video_minutes"
                                                  value="<?php echo $hider_video_minutes; ?>" min="0"> Минуты
                                    </label>
                                </p>
                                <p>
                                    <label> <input type="number" maxlength="2" size="2" class="width-100"
                                                                             name="hider_video_seconds"
                                                                             value="<?php echo $hider_video_seconds; ?>" min="0" max="59"> Секунды
                                    </label>
                                </p>
                            </td>
                            <td>
                                <p>
                                    <label
                                        class="wppage_checkbox <?php echo ($hider_video_autoplay == 'on') ? 'wppage_checked' : ''; ?>">
                                        <input type="checkbox" id="autoplay"
                                               name="hider_video_autoplay" <?php echo ($hider_video_autoplay == 'on') ? 'checked="checked"' : ''; ?>
                                               value="on"/>&nbsp;Автовоспроизведение</label><br>
                                </p>
                                <p>
                                    <label
                                        class="wppage_checkbox <?php echo ($hider_video_controls == 'hide') ? 'wppage_checked' : ''; ?>">
                                        <input type="checkbox" id="hider-video-controls"
                                               name="hider_video_controls" <?php echo ($hider_video_controls == 'hide') ? 'checked="checked"' : ''; ?>
                                               value="hide"/>&nbsp;Убрать панель управление плеером</label><br>
                                </p>

                            </td>
                        </tr>
                    </table>
                    <p>
                        <label class="wppage_checkbox <?php echo ($hider_video_border == 'no') ? 'wppage_checked' : ''; ?>">
                            <input type="radio"
                                   name="hider_video_border"
                                   value="no" <?php if ($hider_video_border == 'no') echo 'checked="checked"'; ?>>Без рамки</label>
                        <label class="wppage_checkbox">
                            <input type="radio" name="hider_video_border"
                                <?php if ($hider_video_border == 'yes') echo 'checked="checked"'; ?>
                                   value="yes">В рамке</label>
                    </p>
                    <div id="hider-video-size-wrap" <?php if($hider_video_border == 'yes') echo 'style="display:none"'; ?>>
                        <p>
                        <label for="video-width">
                            <input type="text" id="hider-video-width" name="hider_video_width"
                                   value="<?php echo $hider_video_width; ?>"
                                   class="width_100"/> Ширина</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <label for="video-height">
                            <input type="text" id="hider-video-height" name="hider_video_height"
                                   value="<?php echo $hider_video_height; ?>"
                                   class="width_100" /> Высота</label>
                    </p>
                    </div>
                    

                    <div class="video_border_sizes">
                        <label
                            class="wppage_radio_v video_border_480 <?php echo ($hider_video_border_size == '480x270') ? 'wppage_checked' : ''; ?>">
                            <input type="radio"
                                   name="hider_video_border_size" <?php echo ($hider_video_border_size == '480x270') ? 'checked="checked"' : ''; ?>
                                   value="480x270"></label>
                        <label
                            class="wppage_radio_v video_border_560 <?php echo ($hider_video_border_size == '560x315') ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_border_size" <?php echo ($hider_video_border_size == '560x315') ? 'checked="checked"' : ''; ?>
                                value="560x315"></label>
                        <label
                            class="wppage_radio_v video_border_640 <?php echo ($hider_video_border_size == '640x360') ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_border_size" <?php echo ($hider_video_border_size == '640x360') ? 'checked="checked"' : ''; ?>
                                value="640x360"></label>
                        <label
                            class="wppage_radio_v video_border_720 <?php echo ($hider_video_border_size == '720x405') ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_border_size" <?php echo ($hider_video_border_size == '720x405') ? 'checked="checked"' : ''; ?>
                                value="720x405"></label>
                    </div>
                    <br>

                    <div class="hider-video-styles video_styles">
                        <label
                            class="wppage_radio_v video_style video_style_1 <?php echo ($hider_video_skin == 1) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="1" <?php echo ($hider_video_skin == 1) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_2 <?php echo ($hider_video_skin == 2) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="2" <?php echo ($hider_video_skin == 2) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_3 <?php echo ($hider_video_skin == 3) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="3" <?php echo ($hider_video_skin == 3) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_4 <?php echo ($hider_video_skin == 4) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="4" <?php echo ($hider_video_skin == 4) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_5 <?php echo ($hider_video_skin == 5) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="5" <?php echo ($hider_video_skin == 5) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_6 <?php echo ($hider_video_skin == 6) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="6" <?php echo ($hider_video_skin == 6) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_7 <?php echo ($hider_video_skin == 7) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="7" <?php echo ($hider_video_skin == 7) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_8 <?php echo ($hider_video_skin == 8) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="8" <?php echo ($hider_video_skin == 8) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_9 <?php echo ($hider_video_skin == 9) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="9" <?php echo ($hider_video_skin == 9) ? 'checked="checked"' : ''; ?>></label>
                        <label
                            class="wppage_radio_v video_style video_style_10 <?php echo ($hider_video_skin == 10) ? 'wppage_checked' : ''; ?>">
                            <input
                                type="radio"
                                name="hider_video_skin"
                                value="10" <?php echo ($hider_video_skin == 10) ? 'checked="checked"' : ''; ?>></label>
                    </div>

                </div>

            </div>
            <div class="clearfix"></div>
            <div class="hider-helper-box"><a target="_blank" href="http://hider.wppage.ru/wppage/how-to-work/">Видео урок</a>
            </div>
        </div>

    </div>
    <div id="hider-tab-2" class="hider-content-box">
        <div class="triangle"></div>
        <div class="hider-content-round">
            <div class="hider-top-nav-bar">
                <input name="save" type="submit" class="button-primary" tabindex="5" accesskey="p"
                       value="Обновить">
            </div>
            <div class="hider-content-panel">
                <div>
                    <p>
                        <label>Ширина:</label>
                        <input type="text" name="hider_width" id="hider-width" size="4"
                               value="<?php echo $hider_width; ?>"/>
                        <span>px</span>
                        <label class="wppage_checkbox hider_width_auto_label <?php if($hider_width_auto == 'on') echo 'wppage_checked'; ?>"><input type="checkbox" name="hider_width_auto" value="on" <?php if($hider_width_auto == 'on') echo 'checked="checked"'; ?>> Автоматически (На всю ширину) </label>
                    </p>

                    <div id="hider-slider"></div>
                    <br class="clearfix">

                    <div class="hider-option-form">
                        <table style="width: 100%" class="v-top">
                            <tr>
                                <td style="width: 150px">
                                    <label>Фон</label>
                                    <p>
                                        <label class="hider-color-box">
                                            <input type="text" id="hider-bg-color-1" name="hider_bg_color_1"
                                                   class="color"
                                                   value="<?php echo
                                                   $hider_bg_color_1; ?>"
                                                />
                                        </label>
                                    </p>
                                    <p>
                                        <label class="hider-color-box">
                                            <input type="text" id="hider-bg-color-2" name="hider_bg_color_2"
                                                   class="color"
                                                   value="<?php echo $hider_bg_color_2; ?>"
                                                />
                                        </label>
                                    </p>
                                    <p>
                                        <label class="wppage_checkbox <?php if($hider_background_transparent == 'transparent') echo 'wppage_checked'; ?>">
                                            <input type="checkbox" id="hider-background-transparent" name="hider_background_transparent"
                                                   value="transparent" <?php if($hider_background_transparent == 'transparent') echo 'checked="checked"'; ?>
                                                />Прозрачный
                                        </label>
                                    </p>
                                </td>
                                <td style="width: 250px">
                                    <label>Цвет рамки</label>
                                    <p>
                                        <label class="hider-color-box">
                                            <input type="text" id="hider-border-color" name="hider_border_color"
                                                   class="color"
                                                   value="<?php
                                                   echo $hider_border_color;
                                                   ?>"
                                                />
                                        </label>
                                    </p>

                                    <label>Тип рамки:</label>
                                    <div class="section hider-border-styles">
                                        <p>
                                            <label class="wppage_radio wppage_radio_border border_solid">
                                                <input
                                                    type="radio"
                                                    name="hider_border_style"
                                                    value="solid"<?php echo ($hider_border_style == 'solid') ? 'checked="checked"' : ''; ?>></label>
                                            <label class="wppage_radio wppage_radio_border border_double">
                                                <input
                                                    type="radio"
                                                    name="hider_border_style"
                                                    value="double"<?php echo ($hider_border_style == 'double') ? 'checked="checked"' : ''; ?>></label>
                                            <label class="wppage_radio wppage_radio_border border_dashed">
                                                <input
                                                    type="radio"
                                                    name="hider_border_style"
                                                    value="dashed" <?php echo ($hider_border_style == 'dashed') ? 'checked="checked"' : ''; ?>></label>
                                            <label class="wppage_radio wppage_radio_border border_dotted">
                                                <input
                                                    type="radio"
                                                    name="hider_border_style"
                                                    value="dotted"<?php echo ($hider_border_style == 'dotted') ? 'checked="checked"' : ''; ?>></label>
                                        </p>
                                    </div>
                                </td>
                                <td>
                                        <label>Толщина рамки: <input name="hider_border_width" value="<?php echo $hider_border_width; ?>" type="text" size="2" maxlength="2"></label><br><br>
                                    <div id="hider-border-width-slider"></div><br>

                                        <label>Радиус закругления: <input name="hider_border_radius" value="<?php echo $hider_border_radius; ?>" type="text" size="2" maxlength="2"></label><br><br>
                                    <div id="hider-border-radius-slider"></div>

                                </td>
                            </tr>

                        </table>

                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="hider-helper-box"><a target="_blank" href="http://hider.wppage.ru/wppage/how-to-work/">Видео урок</a>
            </div>
        </div>
    </div>
    <div id="hider-tab-3" class="hider-content-box">
        <div class="triangle"></div>
        <div class="hider-content-round">
            <div class="hider-top-nav-bar">
                <input name="save" type="submit" class="button-primary" tabindex="5" accesskey="p"
                       value="Обновить">
            </div>
            <div class="hider-content-panel hider-content">
                <?php wp_editor($hider_content, 'hider-content', $tinymce_options); ?>
            </div>
            <div class="hider-helper-box"><a target="_blank" href="http://hider.wppage.ru/wppage/how-to-work/">Видео урок</a>
            </div>

        </div>
    </div>
    </div>
    <div class="clearfix"></div>

    </div>
<?php
}


function hider_save_metabox($post_id, $post)
{


    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
    if (!wp_verify_nonce($_POST['hider_metabox_noncename'], plugin_basename(__FILE__))) {
        return $post->ID;
    }

    // Is the user allowed to edit the post or page?
    if (!current_user_can('edit_post', $post->ID)) {
        return $post->ID;
    }
    // OK, we're authenticated: we need to find and save the data
    // We'll put it into an array to make it easier to loop though.
    $hider_meta['_hider_content'] = $_POST['hider-content'];
    $hider_meta['_hider_border_width'] = $_POST['hider_border_width'];
    $hider_meta['_hider_border_radius'] = $_POST['hider_border_radius'];
    $hider_meta['_hider_border_style'] = $_POST['hider_border_style'];
    $hider_meta['_hider_border_color'] = $_POST['hider_border_color'];
    $hider_meta['_hider_bg_color_1'] = $_POST['hider_bg_color_1'];
    $hider_meta['_hider_bg_color_2'] = $_POST['hider_bg_color_2'];
    $hider_meta['_hider_background_transparent'] = $_POST['hider_background_transparent'];
    $hider_meta['_hider_width'] = $_POST['hider_width'];
    $hider_meta['_hider_width_auto'] = $_POST['hider_width_auto'];
    $hider_meta['_hider_video_url'] = $_POST['hider_video_url'];
    $hider_meta['_hider_video_width'] = $_POST['hider_video_width'];
    $hider_meta['_hider_video_height'] = $_POST['hider_video_height'];
    $hider_meta['_hider_video_autoplay'] = $_POST['hider_video_autoplay'];
    $hider_meta['_hider_video_controls'] = $_POST['hider_video_controls'];
    $hider_meta['_hider_video_border'] = $_POST['hider_video_border'];
    $hider_meta['_hider_video_border_size'] = $_POST['hider_video_border_size'];
    $hider_meta['_hider_video_skin'] = $_POST['hider_video_skin'];
    $hider_meta['_hider_video_size'] = $_POST['hider_video_size'];
    $hider_meta['_hider_video_minutes'] = $_POST['hider_video_minutes'];
    $hider_meta['_hider_video_seconds'] = $_POST['hider_video_seconds'];


    // Add values of $sinus_meta as custom fields

    foreach ($hider_meta as $key => $value) { // Cycle through the $sinus_meta array!
        // if( $post->post_type == 'revision' ) return; // Don't store custom data twice
        $value = implode(',', (array)$value); // If $value is an array, make it a CSV (unlikely)
        if (get_post_meta($post->ID, $key, FALSE)) { // If the custom field already has a value
            update_post_meta($post->ID, $key, $value);
        } else { // If the custom field doesn't have a value
            add_post_meta($post->ID, $key, $value);
        }
        if (!$value) delete_post_meta($post->ID, $key); // Delete if blank
    }

}
