<?php
/**
 * Hider JS.
 */



add_action('admin_footer', 'hider_shortcode_settings_admin_js');

function hider_shortcode_settings_admin_js(){
    $upload_dir = wp_upload_dir();

    ?>

    <script type="text/javascript">
    jQuery(function($){

        function hider_insert_shortcode(shortcode){
            <?php if(version_compare(get_bloginfo('version'), '3.9', '>=')){ ?>
            tinymce.get('hider-content').insertContent(shortcode);
            <?php }else{ ?>
            tinymce.activeEditor.execCommand('mceInsertContent', false, shortcode);
            <?php } ?>
        }
        /**
         *
         */

        function insert_hider(shortcode){
            <?php if(version_compare(get_bloginfo('version'), '3.9', '>=')){ ?>
            tinymce.get('content').insertContent(shortcode);
            <?php }else{ ?>
            tinymce.activeEditor.execCommand('mceInsertContent', false, shortcode);
            <?php } ?>
        }

        /**
         * Insert Trafficbomb shortcode
         */
        $('#hider-mce-button').live('click', function(){
            var d = new Date();
            var hiderID = d.getTime();
            var shortcode = '<p align="center">[wppage_hider id='+ hiderID +' ]</p>';
            insert_hider(shortcode);
        });

        /**
         * show popup window with shortcode settings
         */
        $('.hider-mce-button').bind('click', function () {

            var button_id = $(this).attr('button-id');
            var title = $(this).attr('title');
            tb_show(title, "#TB_inline?width=640&&height=550&inlineId=shortcode-settings-conent");
            $('#TB_ajaxContent').html('');
            $('#TB_ajaxContent').css({'width': '640', 'height': ($('#TB_window').height() - 50) + 'px'}).addClass('wppage-loader');

            $.ajax({
                type: 'GET',
                url: ajaxurl,
                data: {
                    action: "get_hider_shortcode_settings",
                    button: button_id
                },
                success: function (data) {
                    //console.log(data);
                    $('#TB_ajaxContent').html(data).removeClass('wppage-loader');
                },
                error: function(errorThrown){
                    alert(errorThrown);
                }
            });
        });

        // fix thickbox window height
        $(window).resize(function () {
            $('#TB_ajaxContent').css({'width': '640', 'height': ($('#TB_window').height() - 50) + 'px'});
        });

        /**
         * Insert audio shortcode
         */
        $('#hider-audio-submit').live('click', function () {

            var audio_link = $('#audio-link').val();
            if (audio_link == '') {
                alert('Введите ссылку на аудио-файл');
                return false;
                //audio_link = 'null';
            }

            var autoplay = ($('#autoplay:checked').val()) ? 'on' : 'off';
            var audio_color = $('.audio_color:checked').val();
            var shortcode = '<p class="aligncenter">[wpp_uppod audio=' + audio_link + ' color=' + audio_color + ' autoplay=' + autoplay + ']</p>';

            hider_insert_shortcode(shortcode);
            tb_remove();

        });
        /**
         * Insert docs shortcode
         */

        $('#hider-docs-submit').live('click', function () {

            var url = $('#googleform-key').val();
            var src = '';
            if (url.substring(0, 7) == "<iframe") {
                $('#temp-form-code').html(url);
                src = $('#temp-form-code iframe').attr('src');
            } else {
                src = url;
            }
            var height = ($('#googleform-height').val()) ? $('#googleform-height').val() : 500;
            var width = ($('#googleform-width').val()) ? $('#googleform-width').val() : 600;

            var shortcode = '<p class="aligncenter">[wpp_googleform url="' + src + '" width="' + width + '" height="' + height + '"]</p>';

            hider_insert_shortcode(shortcode);
            tb_remove();
        });


        /**
         * Insert review
         */
        $('#hider-review-submit').live('click', function () {

            var shortcode = '';
            var review_style = jQuery('input[name=review_style]:checked').val();

            shortcode = '<table class="wpp_review wpp_review_' + review_style + '"><tr><td class="review_header"></td></tr>' +
                '<tr><td class="review_text"><p>Текст</p></td></tr>' +
                '<tr><td class="review_footer"></td></tr></table>';

            hider_insert_shortcode(shortcode);
            tb_remove();

        });

        /**
         * Insert social buttons shortcode
         */
        $('#hider-social-submit').live('click', function () {

            var sb = '';
            $('.ps_socialbuttons_form input:checked').each(function () {
                if (sb == '') {
                    sb += $(this).val();

                } else {
                    sb += (',' + $(this).val());

                }
            });
            var shortcode = '';
            if (sb == '') shortcode = '';
            else shortcode = '<p class="aligncenter">[wpp_socialbuttons buttons="' + sb + '"]</p>';

            //tinymce.get('content').insertContent(shortcode); // inserts the shortcode into the active editor

            hider_insert_shortcode(shortcode);
            tb_remove();

        });

        /**
         * Insert mail shortcode
         */
        $('#hider-mail-submit').live('click', function () {

            var subscription = $('input[name=wpp_subscription]:checked').val();
            var shortcode = '[wpp_' + subscription + ']';

            hider_insert_shortcode(shortcode);
            tb_remove();

        });

        /**
         * Insert video shortcode
         */
        $('#hider-video-submit').live('click', function () {

            var video = $('#video-link').val();
            var width = $('#video-width').val();
            var height = $('#video-height').val();
            var autoplay = ($('#autoplay:checked').val()) ? 'on' : 'off';
            var size = $('input[name=video_border_size]:checked').val();
            var style = $('input[name=video_border_style]:checked').val();
            var video_border = $('input[name=video_border]:checked').val();
            if (video_border == 'yes') {
                var shortcode = '<p class="aligncenter" style="position: relative; padding: 0; margin: 0 auto;">[wpp_video video=' + video + ' width=' + width + ' height=' + height + ' autoplay=' + autoplay + ' style=' + style + ' size=' + size + ']</p>';
            } else {
                var shortcode = '<p class="aligncenter" style="position: relative; padding: 0; margin: 0 auto;">[wpp_video video=' + video + ' width=' + width + ' height=' + height + ' autoplay=' + autoplay + ']</p>';
            }

            hider_insert_shortcode(shortcode);
            tb_remove();

        });

        /**
         * Insert timer shortcode
         */
        $('#hider-timer-submit').live('click', function() {

            var counter_image = '';
            var c_type = $('input[name=c-type]:checked').val();
            var c_date = $('input[name=c-date]').val();
            var c_time = $('input[name=c-time]').val();
            var c_days = $('input[name=c-days]').val();
            var c_hours = $('input[name=c-hours]').val();
            var c_minutes = $('input[name=c-minutes]').val();
            var c_redirect_fixed = $('input[name=c-redirect-fixed]:checked').val();
            var c_redirect_fixed_url = $('input[name=c-redirect-fixed-url]').val();
            var c_redirect_interval = $('input[name=c-redirect-interval]:checked').val();
            var c_redirect_interval_url = $('input[name=c-redirect-interval-url]').val();
            var c_size = $('input[name=c-size]:checked').val();
            var c_color = $('input[name=c-color]:checked').val();
            var c_skin = $('input[name=c-design]:checked').val();
            var c_image = $('input[name=c-image]:checked').val();
            var cMessage = "Задайте все недостающие параметры:\n";
            var cError = false;


            var d = new Date();
            var counterID = d.getTime();
            counterID = ' id=' + counterID;

            if (c_type == 'fixed') {

                if (c_date == '') {
                    cError = true;
                    cMessage += "- Дату \n";
                } else {
                    c_date = ' date=' + c_date;
                }

                if (c_time == '') {
                    cError = true;
                    cMessage += "- Время \n";
                } else {
                    c_time = ' time=' + c_time;
                }

                if (c_redirect_fixed != '' && c_redirect_fixed == 'redirect') {
                    if (c_redirect_fixed_url != '') {
                        c_redirect = ' redirect=' + c_redirect_fixed_url;
                    } else {
                        cError = true;
                        cMessage += "- Ссылку для переадресации \n";
                    }
                }
                if (c_redirect_fixed != '' && c_redirect_fixed == 'hide') {
                    c_redirect = '';
                }

            }
            if (c_type == 'interval') {
                if (c_redirect_interval != '' && c_redirect_interval == 'redirect') {
                    if (c_redirect_interval_url != '') {
                        c_redirect = ' redirect=' + c_redirect_interval_url;
                    } else {
                        cError = true;
                        cMessage += "- Ссылку для переадресации \n";
                    }
                }
                if (c_redirect_interval != '' && c_redirect_interval == 'renew') {
                    c_redirect = ' renew=true';
                }
                if (c_redirect_interval != '' && c_redirect_interval == 'hide') {
                    c_redirect = '';
                }

                if (c_days == '') {
                    cError = true;
                    cMessage += "- Дни \n";
                } else {
                    c_days = ' days=' + c_days;
                }

                if (c_hours == '') {
                    cError = true;
                    cMessage += "- Часы \n";
                } else {
                    c_hours = ' hours=' + c_hours;
                }

                if (c_minutes == '') {
                    cError = true;
                    cMessage += "- Минуты \n";
                } else {
                    c_minutes = ' minutes=' + c_minutes;
                }

            }


            if (c_size) {
                c_size = ' size=' + c_size;
            }
            if (c_color) {
                c_color = ' color=' + c_color;
            }
            if (c_skin) {
                c_skin = ' skin=' + c_skin;
            }
            if ($('input[name=c-use-image]').is(':checked')) {
                c_image = ' image=' + c_image;
                //counter_image = '<img src="http://static.wppage.ru/wppage/i/timer/' + c_image + '.png"><br>';
            } else {
                c_image = '';
            }
            if (cError) {
                alert(cMessage);
                return false;
            }

            var shortcode = '';
            if (c_type == 'fixed') {
                shortcode = '<p class="aligncenter">[wppage_countdown' + counterID + ' type=' + c_type + c_date + c_time + c_size + c_color + c_skin + c_redirect + c_image + ']</p>';
            } else {
                shortcode = '<p class="aligncenter">[wppage_countdown' + counterID + ' type=' + c_type + c_days + c_hours + c_minutes + c_size + c_color + c_skin + c_redirect + c_image + ']</p>';
            }

            hider_insert_shortcode(shortcode);
            tb_remove();

        });


        /**
         * Insert arrows shortcode
         */
        $('#hider-arrow-submit').live('click', function(){
            var extention = '.png';
            var arrow = $('input[name=arrow]:checked');
            var arrow_name = arrow.val();
            if (arrow.hasClass('gif')) {
                extention = '.gif';
            }
            var shortcode = '<p class="aligncenter"><img class="aligncenter ps_arrow" src="http://static.wppage.ru/wppage/i/arrows/' + arrow_name + extention + '" alt="" /></p>';

            hider_insert_shortcode(shortcode);
            tb_remove();
        });
        /**
         * Insert box shortcode
         */
        $('#hider-box-submit').live('click', function () {

            var text_box_style = $('input[name=text_box_style]:checked').val();
            var shortcode = '<p class="aligncenter"><div class="ps_text_box ps_text_box_' + text_box_style + '"><p class="ps_text_box_text">Текст</p></div></p><p>&nbsp;</p>';

            hider_insert_shortcode(shortcode);
            tb_remove();
        });
        /**
         * Insert list shortcode
         */
        $('#hider-list-submit').live('click', function () {

            var bullets_style = $('input[name=bullet_style]:checked').val();

            var shortcode = '<ul class="ps_ul ps_bullet ps_bullet_' + bullets_style + '"><li>Список</li><li>Список</li></ul>';


            // tinymce.get('trafficbomb_message').insertContent(shortcode); // inserts the shortcode into the active editor
            //tinymce.activeEditor.execCommand('mceInsertContent', false, shortcode);
            hider_insert_shortcode(shortcode);
            tb_remove();

        });
        /**
         * Insert divier sortcode
         */
        $('#hider-divider-submit').live('click', function () {

            var width_1 = width_2 = '';
            width_1 = jQuery('#ps_divide_width').val();
            if (width_1 == '') {
                width_1 = 65;
            }
            width_2 = 100 - width_1;

            var shortcode = '<table width="100%" class="wpp_divider"><tr><td style="width:' + width_1 + '%"><div>текст</div></td><td style="width:' + width_2 + '%"><div>текст</div></td></tr></table>';

            hider_insert_shortcode(shortcode);
            tb_remove();
        });
        /**
         * Insert buy button
         */
        $('#hider-buy-submit').live('click', function () {

            var url = '';
            var shortcode = '';
            var type = $('input.type:checked').val();
            var button_style = $('input[name=button_style]:checked').val();
            var button_size = $('input[name=wpp_button_size]:checked').val();
            var link_type = $('input[name=link-type]:checked').val();
            if (button_size == undefined || button_style == undefined || type == undefined) {
                alert('Виберите размер, вид кнопки');
                return false;
            }

            if (type == 'interkasa') {
                url = '#order_popup';
            }
            else {
                url = $('#external_url').val();
            }

            if (type == 'interkasa') {
                shortcode = '<p class="aligncenter"><input type="button" class="product_cbutton ps_make_order ps_product_button_' + button_size + '_' + button_style + '" value="" /></p><br>'
            } else {
                shortcode = '<p class="aligncenter"><input type="button" formtarget="' + link_type + '" class="product_cbutton ps_external_make_order ps_product_button_' + button_size + '_' + button_style + '" alt="' + url + '"/></p><br>'

            }

            hider_insert_shortcode(shortcode);
            tb_remove();

        });
        /**
         * Insert header
         */
        $('#hider-header-submit').live('click',function(){

            var header = $('input[name=header]:checked').val();
            var shortcode = '<p style="text-align: center"><img class="aligncenter wpp_header" src="http://static.wppage.ru/wppage/i/headers/' + header + '.png" alt="" /></p><p>&nbsp;</p>';

            hider_insert_shortcode(shortcode);
            tb_remove();
        });
        /**
         * Insert satisfaction
         */
        $('#hider-satisfaction-submit').live('click', function () {

            var satisfaction = $('input[name=satisfaction]:checked').val();
            var shortcode = '<p><img class="aligncenter ps_satisfaction" src="http://static.wppage.ru/wppage/i/satisfaction/'+satisfaction+'.png" alt="" /></p>';

            hider_insert_shortcode(shortcode);
            tb_remove();

        });


        /**
         *
         */
        $('.wppage_radio input:checked').each(function () {
            $(this).parent().addClass('wppage_checked');
        });

        $(document).on('change', '.ps_bullets_form input, .p_cbutton input, .ps_satisfaction input, .ps_arrows input, .ps_bonus input, .ps_cbutton input, .ps_timer_image input, .wpp_header input', function () {
            var name = $(this).attr('name');
            $('input[name = ' + name + ']').each(function () {
                $(this).parent().removeClass('wppage_checked');
            });
            $(this).parent().addClass('wppage_checked');
        });

        $('.wppage_radio input:checked, .ps_arrows_title input:checked').each(function () {
            $(this).parent().addClass('wppage_checked');
        });

        $(document).on('change', '.wppage_radio input, .ps_arrows_title input', function () {
            var name = $(this).attr('name');
            $('input[name = ' + name + ']').each(function () {
                $(this).parent().removeClass('wppage_checked');
            });
            $(this).parent().addClass('wppage_checked');
        });


        //======

        var selected_color = 'dark_red';

        $(document).on('click', '.color-nav a', function () {
            $(this).siblings().removeClass('wppage_checked');
            $(this).addClass('wppage_checked');
            selected_color = $(this).attr('color');

            $('.arrows-with-title label').each(function(index){
                $(this).attr('class', 'ps_arrows_title  ps_arrows_title_' + selected_color + '_' + (index+1)).children('input').attr('color',selected_color);
            });
        });


        <?php if(get_post_type() != 'page_selling'){ ?>
        /**
         * wppage radio checker
         */
        $('.wppage_checkbox input:checked, .p_cbutton input:checked').each(function () {
            $(this).parent().addClass('wppage_checked');
        });

        $('.wppage_checkbox input:checkbox').live('change', function () {
            $(this).parent().toggleClass('wppage_checked');
        });

        $('.wppage_checkbox input:radio').live('change', function () {
            $('input[name=' + $(this).attr("name") + ']').each(function () {
                $(this).parent().removeClass('wppage_checked');
            });
            $(this).parent().toggleClass('wppage_checked');
        });
        <?php } ?>


        /**
         *
         */
        $('.wppage_radio_V input:checked').each(function () {
            $(this).parent().addClass('wppage_checked');
        });

        $('.wppage_radio_v input').live('change', function () {
            if ($('input[name=hider_video_border]:checked').val() == 'yes') {
                var name = $(this).attr('name');
                $('input[name = ' + name + ']').each(function () {
                    $(this).parent().removeClass('wppage_checked');
                });
                $(this).parent().addClass('wppage_checked');
            }
        });

        $('input[name=hider_video_border]').live('change', function () {
            if ($(this).val() == 'yes') {
                $('#hider-video-size-wrap').css({'display':'none'});
                $('.video_border_640 > input').click();
                $('.video_styles label:first-child input').click();
            } else {
                $('#hider-video-size-wrap').css({'display':'block'});
                $('.video_border_sizes label, .video_styles > label').removeClass('wppage_checked');
                $('.video_border_sizes input:checked, .video_styles input:checked').removeAttr('checked');
            }
        });
        $('input[name=hider_video_border_size]').live('change', function () {

            if ($('input[name=hider_video_border]:checked').val() == 'yes') {
                if ($(this).val() == '480x270') {
                    $('#hider-video-width').val('480');
                    $('#hider-video-height').val('270');
                }
                if ($(this).val() == '560x315') {
                    $('#hider-video-width').val('560');
                    $('#hider-video-height').val('315');
                }
                if ($(this).val() == '640x360') {
                    $('#hider-video-width').val('640');
                    $('#hider-video-height').val('360');
                }
                if ($(this).val() == '720x405') {
                    $('#hider-video-width').val('720');
                    $('#hider-video-height').val('405');
                }
            }
        });

        /**
         * Ajax update styles
         */
        $('#hider-update-styles').live('click', function(){

            $.ajax({
                type: 'GET',
                url: ajaxurl,
                data: {
                    action: "ajax_update_hider_css_action",
                    post_id: '<?php echo get_the_ID(); ?>',
                    hider_width: $('input[name=hider_width]').val(),
                    hider_bg_color_1: $('input[name=hider_bg_color_1]').val(),
                    hider_bg_color_2: $('input[name=hider_bg_color_2]').val(),
                    hider_border_width: $('select[name=hider_border_width]').val(),
                    hider_border_color: $('input[name=hider_border_color]').val(),
                    hider_border_style: $('input[name=hider_border_style]:checked').val()

                },
                success: function (data) {
                    console.log(data);
                    //$("#hider-content_ifr").contents().find("link").attr("href", theme_name);
                    tinymce.get('hider-content').execCommand("mceRepaint");
                    //hider_reload_editor_css();
                    //document.getElementById('hider-content_ifr').contentDocument.location.reload(true);
                },
                error: function(errorThrown){
                   // alert(errorThrown);
                }
            });
        });
        function hider_reload_editor_css(){
            <?php if(version_compare(get_bloginfo('version'), '3.9', '>=')){ ?>
            tinymce.get('hider_content').StyleSheetLoader.load('<?php echo $upload_dir['baseurl'].'/hider/hider-editor-style-'.get_the_ID().'.css?'.time()?>');
            <?php }else{ ?>
            tinymce.activeEditor.execCommand('mceInsertContent', false, shortcode);
            <?php } ?>
        }

    });
    </script>
<?php }
