<?php

/**
 *
 */

function hider_add_metabox()
{
    add_meta_box('hider_extra_box', 'Hider', 'hider_extra', 'page_selling', 'normal');
    add_meta_box('hider_extra_box', 'Hider', 'hider_extra', 'post', 'normal');
    add_meta_box('hider_extra_box', 'Hider', 'hider_extra', 'page', 'normal');
}

/**
 *
 */

function hider_admin_js_css_init()
{

    wp_enqueue_style('hider-ui-base', plugins_url('/hider/css/jquery.ui.base.css'));
    wp_enqueue_style('hider-ui-core', plugins_url('/hider/css/jquery.ui.core.css'));
    wp_enqueue_style('hider-ui-slider', plugins_url('/hider/css/jquery.ui.slider.css'));
    wp_enqueue_style('hider-admin-styles', plugins_url('/hider/css/admin-styles.css'));
    wp_enqueue_style('hider-style', plugins_url('/hider/css/hider.css'));

    wp_enqueue_script('jquery');
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-ui-widget');
    wp_enqueue_script('jquery-ui-tabs');
    wp_enqueue_script('jquery-ui-slider');
    wp_enqueue_script('jquery-ui-mouse');

    wp_enqueue_script('hider-js-color', plugins_url('/hider/js/jscolor/jscolor.js'));
    wp_enqueue_script('hider-admin-js', plugins_url('/hider/js/hider-admin.js'));

}

/**
 *
 */

function hider_admin_scripts()
{
   echo '<script type="text/javascript"> var plugin_url = "' . WP_PLUGIN_URL . '"; </script>'."\n";
}

/**
 *
 */
add_action('wp_ajax_ajax_update_hider_css_action', 'ajax_update_hider_css');
function ajax_update_hider_css()
{

    $post_id = $_GET['post_id'];
    $html_bg_color = get_post_meta( $post_id , '_ps_content_background_color', true );
    if(empty($html_bg_color)){
        $html_bg_color = 'ffffff';
    }
    $hider_border_color = $_GET['hider_border_color'];
    $hider_border_style = $_GET['hider_border_style'];
    $hider_border_width = $_GET['hider_border_width'];
    $hider_width = $_GET['hider_width'];
    $hider_bg_color_1 = $_GET['hider_bg_color_1'];
    $hider_bg_color_2 = $_GET['hider_bg_color_2'];

    update_post_meta($post_id, '_hider_border_color', $hider_border_color);
    update_post_meta($post_id, '_hider_border_style', $hider_border_style);
    update_post_meta($post_id, '_hider_border_width', $hider_border_width);
    update_post_meta($post_id, '_hider_width', $hider_width);
    update_post_meta($post_id, '_hider_bg_color_1', $hider_bg_color_1);
    update_post_meta($post_id, '_hider_bg_color_2', $hider_bg_color_2);


    // fix border width
    if($hider_border_width == 'none'){
        $border_width = $hider_border_width;
    }else{
        $border_width = $hider_border_width.'px';
    }

    $editor_base_style = "
    html{ background-color:#$html_bg_color!important;}
    body.hider-content{
        border-color: #" . $hider_border_color . ";
        border-style: " . $hider_border_style . ";
        border-width: " . $border_width . ";
        width: " . $hider_width . "px;
        background: #". $hider_bg_color_1 ."; /* Old browsers */
        background: -moz-linear-gradient(top,  #". $hider_bg_color_1 ." 0%, #". $hider_bg_color_2 ." 100%); /* FF3.6+ */
        background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#". $hider_bg_color_1 ."), color-stop(100%,#". $hider_bg_color_2 .")); /* Chrome,Safari4+ */
        background: -webkit-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Chrome10+,Safari5.1+ */
        background: -o-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Opera 11.10+ */
        background: -ms-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* IE10+ */
        background: linear-gradient(to bottom,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* W3C */
        filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#". $hider_bg_color_1 ."', endColorstr='#". $hider_bg_color_2 ."',GradientType=0 ); /* IE6-9 */
        padding: 20px;
        margin: 30px auto;
        }
    body#tinymce img{
        max-width: 100%;
    }";

    $upload_dir = wp_upload_dir();
    $hider_css_file = $upload_dir['basedir'] . '/hider/hider-editor-style-' . $post_id . '.css';
    $handle = fopen($hider_css_file, 'w') or die('Cannot open file:  ' . $hider_css_file);
    fwrite($handle, $editor_base_style);
    fclose($handle);

    echo 'saved';
    die();
}

/**
 *
 */


function hider_tinymce_config($init){

    $upload_dir = wp_upload_dir();

    $init['content_css'] = includes_url( "css/dashicons.min.css" );
    $init['content_css'] .= ', '.includes_url( "js/mediaelement/mediaelementplayer.min.css" );
    $init['content_css'] .= ', '.includes_url( "js/mediaelement/wp-mediaelement.css" );
    $init['content_css'] .= ', '.plugins_url('/hider/css/editor-style.css?'.time());
    $init['content_css'] .= ', '.$upload_dir['baseurl'].'/hider/hider-editor-style-'.get_the_ID().'.css?'.time();

    return $init;
}

/**
 *
 */

function hider_frontend_css(){ ?>

    <link rel="stylesheet" href="<?php echo plugins_url('/hider/css/hider-frontend.css'); ?>" type="text/css" media="all" />
    <link rel="stylesheet" href="<?php echo plugins_url('/hider/js/mediaelement/lib/mediaelementplayer.min.css'); ?>" type="text/css" media="all" />

<?php
}
/**
 *
 */
function hider_frontend_js_lib(){
      wp_enqueue_script('jquery');
}
/**
 *
 */
function hider_frontend_js()
{ ?>
    <!-- hider js -->
    <script type="text/javascript" src="<?php echo plugins_url('/hider/js/mediaelement/lib/mediaelement-and-player.min.js'); ?>"></script>
    <script type="text/javascript">
        var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
        jQuery(function($){
            $('input.ps_external_make_order').live('click', function () {
                window.open($(this).attr('alt'), $(this).attr('formtarget'));
                return false;
            });
        });

    </script>

    <!-- // hider js -->
<?php
}

/**
 *
 */
add_action('wp_ajax_get_hider_content', 'wppage_hider_content');
add_action('wp_ajax_nopriv_get_hider_content', 'wppage_hider_content');
function wppage_hider_content()
{
    $page_id = $_GET['page_id'];

    $hider_width = get_post_meta($page_id, '_hider_width', true);
    $hider_width_auto = get_post_meta($page_id, '_hider_width_auto', true);
    $hider_bg_color_1 = get_post_meta($page_id, '_hider_bg_color_1', true);
    $hider_bg_color_2 = get_post_meta($page_id, '_hider_bg_color_2', true);
    $hider_background_transparent = get_post_meta($page_id, '_hider_background_transparent', true);
    $hider_border_color = get_post_meta($page_id, '_hider_border_color', true);
    $hider_border_style = get_post_meta($page_id, '_hider_border_style', true);
    $hider_border_width = get_post_meta($page_id, '_hider_border_width', true);
    $hider_border_radius = get_post_meta($page_id, '_hider_border_radius', true);
    
    // fix border width
    if($hider_border_width == 'none'){
        $border_width = '0';
    }else{
        $border_width = $hider_border_width.'px';
    }
    // set hider content wrap width
    if($hider_width_auto == 'on'){
        $hider_content_wrap_width = 'auto';
    }else{
        $hider_content_wrap_width = $hider_width.'px';
    }

    $hider_css = "
    <style type='text/css'>
    .wppage-hider{
        border-color: #" . $hider_border_color . ";
        border-style: " . $hider_border_style . ";
        border-width: " . $hider_border_width . "px;
        border-radius: " . $hider_border_radius . "px;
        width: " . $hider_content_wrap_width . ";";
    if($hider_background_transparent == 'transparent'){
        $hider_css .= "
        background: transparent;";
    }else{
        $hider_css .= "
        background: #". $hider_bg_color_1 ."; /* Old browsers */
        background: -moz-linear-gradient(top,  #". $hider_bg_color_1 ." 0%, #". $hider_bg_color_2 ." 100%); /* FF3.6+ */
        background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#". $hider_bg_color_1 ."), color-stop(100%,#". $hider_bg_color_2 .")); /* Chrome,Safari4+ */
        background: -webkit-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Chrome10+,Safari5.1+ */
        background: -o-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* Opera 11.10+ */
        background: -ms-linear-gradient(top,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* IE10+ */
        background: linear-gradient(to bottom,  #". $hider_bg_color_1 ." 0%,#". $hider_bg_color_2 ." 100%); /* W3C */
        filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#". $hider_bg_color_1 ."', endColorstr='#". $hider_bg_color_2 ."',GradientType=0 ); /* IE6-9 */";
    }
    $hider_css .= "
        padding: 20px;
        margin: 30px auto;
        /* Prevent background color leak outs */
        -webkit-background-clip: padding-box;
        -moz-background-clip: padding;
        background-clip: padding-box;
        }
    </style>
    ";

    

    $content = get_post_meta($page_id, '_hider_content', true); ;
    $content = apply_filters('the_content', $content);
    $content = do_shortcode($content);
    echo $hider_css.'<div class="wppage-hider">'.$content.'</div>';
    die();
}


