<?php 
/** 
 * @package JMAP::CPANEL::administrator::components::com_jmap
 * @subpackage views
 * @subpackage cpanel
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' ); 
?>
<!-- CPANEL ICONS -->
<div id="cpanel">
	<?php echo $this->icons; ?>
	
	<div id="updatestatus">
		<?php 
		if(is_object($this->updatesData)) {
			if(version_compare($this->updatesData->latest, $this->currentVersion, '>')) { ?>
				<a href="http://storejoomla.org/extensions/jsitemap_professional.html" target="_blank" alt="storejoomla link">
					<label data-content="<?php echo JText::sprintf('COM_JMAP_GET_LATEST', $this->currentVersion, $this->updatesData->latest, $this->updatesData->relevance);?>" class="label label-danger hasPopover">
						<label class="glyphicon glyphicon-warning-sign"></label>
						<?php echo JText::sprintf('COM_JMAP_OUTDATED', $this->updatesData->latest);?>
					</label>
				</a>
			<?php } else { ?>
				<label data-content="<?php echo JText::sprintf('COM_JMAP_YOUHAVE_LATEST', $this->currentVersion);?>" class="label label-success hasPopover">
					<label class="glyphicon glyphicon-ok-sign"></label>
					<?php echo JText::sprintf('COM_JMAP_UPTODATE', $this->updatesData->latest);?>
				</label>	
			<?php }
		}
		?>
	</div>
	
</div>

<!-- RIGHT ACCORDION -->
<div class="panel-group" id="accordion_cpanel">
	<div class="panel panel-default">
	    <div class="panel-heading accordion-toggle" data-toggle="collapse" data-parent="#accordion_cpanel" data-target="#jmap_status">
			<h4 class="panel-title">
				<?php echo JText::_('COM_JMAP_JMAP_INFO_STATUS');?>
			</h4>
	    </div>
	    <div id="jmap_status"  class="panel-collapse collapse">
			<div class="panel-body">
				<!-- COMPONENT LINKS -->
				<div class="single_container">
		 			<label class="label label-primary"><?php echo JText::_('COM_JMAP_HTML_LINK')?></label>
		 			<input data-role="sitemap_links" class="sitemap_links" type="text" value="<?php echo JFilterOutput::ampReplace($this->livesite . '/index.php?option=com_jmap&view=sitemap');?>" />
		 		</div>
	 			<div class="single_container">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_APPEND_LANG_PARAM');?>"><?php echo JText::_('COM_JMAP_XML_LINK')?></label>
			 		<input data-role="sitemap_links" class="sitemap_links" type="text" value="<?php echo JFilterOutput::ampReplace($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=xml');?>" />
			 		<?php 
			 			$concatenatePingXmlFormat = "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.google.com/webmasters/tools/ping?sitemap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=xml') . "'>" . JText::_('COM_JMAP_PING_GOOGLE') . "</a>";
			 			$concatenatePingXmlFormat .= "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.bing.com/webmaster/ping.aspx?siteMap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=xml') . "'>" . JText::_('COM_JMAP_PING_BING') . "</a>";
			 		?>
			 		<label class="glyphicon glyphicon-flash hasClickPopover" rel="tooltip" title="<?php echo JText::_('COM_JMAP_PING_SITEMAP');?>" data-content="<?php echo $concatenatePingXmlFormat;?>"></label>
			 		<label class="glyphicon glyphicon-pencil" rel="tooltip" title="<?php echo JText::_('COM_JMAP_ROBOTS_SITEMAP_ENTRY');?>" data-role="saveentity"></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_APPEND_LANG_PARAM');?>"><?php echo JText::_('COM_JMAP_XML_IMAGES_LINK')?></label>
			 		<input data-role="sitemap_links" class="sitemap_links" type="text" value="<?php echo JFilterOutput::ampReplace($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=images');?>" />
			 		<?php 
			 			$concatenatePingXmlFormat = "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.google.com/webmasters/tools/ping?sitemap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=images') . "'>" . JText::_('COM_JMAP_PING_GOOGLE') . "</a>";
			 			$concatenatePingXmlFormat .= "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.bing.com/webmaster/ping.aspx?siteMap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=images') . "'>" . JText::_('COM_JMAP_PING_BING') . "</a>";
			 		?>
			 		<label class="glyphicon glyphicon-flash hasClickPopover" rel="tooltip" title="<?php echo JText::_('COM_JMAP_PING_SITEMAP');?>" data-content="<?php echo $concatenatePingXmlFormat;?>"></label>
			 		<label class="glyphicon glyphicon-pencil" rel="tooltip" title="<?php echo JText::_('COM_JMAP_ROBOTS_SITEMAP_ENTRY');?>" data-role="saveentity"></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_APPEND_LANG_PARAM');?>"><?php echo JText::_('COM_JMAP_XML_GNEWS_LINK')?></label>
			 		<input data-role="sitemap_links" class="sitemap_links" type="text" value="<?php echo JFilterOutput::ampReplace($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=gnews');?>" />
			 		<?php 
			 			$concatenatePingXmlFormat = "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.google.com/webmasters/tools/ping?sitemap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=gnews') . "'>" . JText::_('COM_JMAP_PING_GOOGLE') . "</a>";
			 			$concatenatePingXmlFormat .= "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.bing.com/webmaster/ping.aspx?siteMap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=gnews') . "'>" . JText::_('COM_JMAP_PING_BING') . "</a>";
			 		?>
			 		<label class="glyphicon glyphicon-flash hasClickPopover" rel="tooltip" title="<?php echo JText::_('COM_JMAP_PING_SITEMAP');?>" data-content="<?php echo $concatenatePingXmlFormat;?>"></label>
			 		<label class="glyphicon glyphicon-pencil" rel="tooltip" title="<?php echo JText::_('COM_JMAP_ROBOTS_SITEMAP_ENTRY');?>" data-role="saveentity"></label>
		 		</div> 
		 		
		 		<div class="single_container">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_XML_MOBILE_DISCLAIMER');?>"><?php echo JText::_('COM_JMAP_XML_MOBILE_LINK')?></label>
			 		<input data-role="sitemap_links" class="sitemap_links" type="text" value="<?php echo JFilterOutput::ampReplace($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=mobile');?>" />
			 		<?php 
			 			$concatenatePingXmlFormat = "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.google.com/webmasters/tools/ping?sitemap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=mobile') . "'>" . JText::_('COM_JMAP_PING_GOOGLE') . "</a>";
			 			$concatenatePingXmlFormat .= "<a data-role='pinger' class='pinger glyphicon glyphicon-flash' href='http://www.bing.com/webmaster/ping.aspx?siteMap=" . rawurlencode($this->livesite . '/index.php?option=com_jmap&view=sitemap&format=mobile') . "'>" . JText::_('COM_JMAP_PING_BING') . "</a>";
			 		?>
			 		<label class="glyphicon glyphicon-flash hasClickPopover" rel="tooltip" title="<?php echo JText::_('COM_JMAP_PING_SITEMAP');?>" data-content="<?php echo $concatenatePingXmlFormat;?>"></label>
			 		<label class="glyphicon glyphicon-pencil" rel="tooltip" title="<?php echo JText::_('COM_JMAP_ROBOTS_SITEMAP_ENTRY');?>" data-role="saveentity"></label>
		 		</div> 

		 		<!-- LANAGUAGE SELECT LIST -->
		 		<?php if($this->lists['languages']):?>
		 		<div class="single_container language">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_CHOOSE_LANGUAGE');?>"><?php echo JText::_('COM_JMAP_CHOOSE_LANG')?></label>
			 		<?php echo $this->lists['languages'];?>
		 		</div>
		 		<?php endif;?>
		 		
		 		<!-- MENU FILTERS SELECT LIST -->
		 		<?php if($this->lists['menu_datasource_filters']):?>
		 		<div class="single_container language">
			 		<label class="label label-primary hasPopover" data-content="<?php echo JText::_('COM_JMAP_CHOOSE_MENU_DESC');?>"><?php echo JText::_('COM_JMAP_CHOOSE_MENU')?></label>
			 		<?php echo $this->lists['menu_datasource_filters'] ;?>
		 		</div>
		 		<?php endif;?>
		
				<!-- COMPONENT STATUS INDICATOR -->
				<ul class="cpanelinfo nav nav-pills">
				  <li class="active">
				    <a href="javascript:void(0);">
				      <span class="badge pull-right"><?php echo $this->infodata['publishedDataSource']?></span>
				      <?php echo JText::_('COM_JMAP_NUM_PUBLISHED_DATA_SOURCES');?>
				    </a>
				  </li>
				 
				  <li class="active">
				    <a href="javascript:void(0);">
				      <span class="badge pull-right"><?php echo $this->infodata['totalDataSource']?></span>
				      <?php echo JText::_('COM_JMAP_NUM_TOTAL_DATA_SOURCES');?>
				    </a>
				  </li>
				  
				  <li class="active">
				    <a href="javascript:void(0);">
				      <span class="badge pull-right"><?php echo $this->infodata['menuDataSource']?></span>
				      <?php echo JText::_('COM_JMAP_NUM_MENU_DATA_SOURCES');?>
				    </a>
				  </li>
				  
				  <li class="active">
				    <a href="javascript:void(0);">
				      <span class="badge pull-right"><?php echo $this->infodata['userDataSource']?></span>
				      <?php echo JText::_('COM_JMAP_NUM_USER_DATA_SOURCES');?>
				    </a>
				  </li>
				</ul>
			</div>
	    </div>
	</div>
	
	<!-- ABOUT-->
	<div class="panel panel-default">
	    <div class="panel-heading accordion-toggle" data-toggle="collapse" data-parent="#accordion_cpanel" data-target="#jmap_about">
			<h4 class="panel-title">
				<?php echo JText::_('COM_JMAP_ABOUT');?>
			</h4>
	    </div>
	    <div id="jmap_about"  class="panel-collapse collapse">
			<div class="panel-body">
				<div class="single_container">
			 		<label class="label label-warning"><?php echo JText::sprintf('COM_JMAP_VERSION', JText::_('COM_JMAP_VERSION_COMPONENT'));?></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-info"><?php echo JText::_('COM_JMAP_AUTHOR_COMPONENT');?></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-info"><?php echo JText::_('COM_JMAP_SUPPORTLINK');?></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-info"><?php echo JText::_('COM_JMAP_DEMOLINK');?></label>
		 		</div>
		 		
		 		<div class="single_container">
			 		<label class="label label-info"><?php echo JText::_('COM_JMAP_JOOMLAEXTENSIONSLINK');?></label>
		 		</div>
			</div>
	    </div>
	</div>
</div>

<form name="adminForm" id="adminForm" action="index.php">
	<input type="hidden" name="option" value="<?php echo JRequest::getCmd('option');?>"/>
	<input type="hidden" name="task" value=""/>
</form>