<?php
// namespace administrator\components\com_jmap\framework\model;
/**
 * @package JMAP::FRAMEWORK::administrator::components::com_jmap
 * @subpackage framework
 * @subpackage model
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.model');

/**
 * Base model responsibilities
 * 
 * @package JMAP::FRAMEWORK::administrator::components::com_jmap
 * @subpackage framework
 * @subpackage model
 * @since 2.0
 */
interface IJMapModel {
	/**
	 * Counter result set
	 *
	 * @access public
	 * @return int
	 */
	public function getTotal();
	
	/**
	 * Load entity from ORM table
	 * @access public
	 * @param int $id
	 * @return Object&
	 */
	public function loadEntity($id);
	
	/**
	 * Cancel editing entity
	 *
	 * @param int $id
	 * @access public
	 * @return boolean
	 */
	public function cancelEntity($id);

	/**
	 * Delete entity
	 *
	 * @param array $ids
	 * @access public
	 * @return boolean
	 */
	public function deleteEntity($ids);
	
	/**
	 * Storing entity by ORM table
	 *
	 * @access public
	 * @return mixed
	 */
	public function storeEntity();
}

/**
 * Base concrete model for business logic
 * 
 * @package JMAP::FRAMEWORK::administrator::components::com_jmap
 * @subpackage framework
 * @subpackage model
 * @since 2.0
 */
class JMapModel extends JModel implements IJMapModel {
	/**
	 * Application reference
	 * 
	 * @access protected
	 * @var Object
	 */
	protected $app;
	
	/**
	 * Counter result set
	 *
	 * @access public
	 * @return int
	 */
	public function getTotal() {
		// Build query
		$query = $this->buildListQuery ();
		$this->_db->setQuery ( $query );
		$result = count ( $this->_db->loadResultArray () );
	
		return $result;
	}
	
	/**
	 * Load entity from ORM table
	 *
	 * @access public
	 * @param int $id
	 * @return Object&
	 */
	public function loadEntity($id) {
		// load table record
		$table = $this->getTable();
		
		// Check for previously set post data after errors
		$context = implode('.', array($this->getState('option'), $this->getName(), 'errordataload'));
		$sessionData = $this->app->getUserState($context);
	
		try {
			// Give priority to session recovered data
			if(!$sessionData) {
				// Load normally from database
				if(!$table->load($id)) {
					throw new JMapException($this->_db->getErrorMsg (), 'error');
				}
			} else {
				// Recover and bind/load from session
				if(!$table->bind($sessionData, false, true)) {
					throw new JMapException($this->_db->getErrorMsg (), 'error');
				}
				// Delete session data for next request
				$this->app->setUserState($context, null);
			}
		} catch (JMapException $e) {
			$this->setError($e);
			return false;
		} catch (Exception $e) {
			$jmapException = new JMapException($e->getMessage(), 'error');
			$this->setError($jmapException);
			return false;
		}
		return $table;
	}
	
	/**
	 * Cancel editing entity
	 *
	 * @param int $id
	 * @access public
	 * @return boolean
	 */
	public function cancelEntity($id) {
		// New record - do null e return true subito
		if (!$id) {
			return true;
		}

		$table = $this->getTable();
		try {
			if (!$table->load($id)) {
				throw new JMapException($table->getError(), 'error');
			}
			if (!$table->checkin()) {
				throw new JMapException($table->getError(), 'error');
			}
		} catch (JMapException $e) {
			$this->setError($e);
			return false;
		} catch (Exception $e) {
			$jmapException = new JMapException($e->getMessage(), 'error');
			$this->setError($jmapException);
			return false;
		}

		return true;
	}

	/**
	 * Delete entity
	 *
	 * @param array $ids
	 * @access public
	 * @return boolean
	 */
	public function deleteEntity($ids) {
		$table = $this->getTable();

		// Ciclo su ogni entity da cancellare
		foreach ($ids as $id) {
			try {
				if (!$table->delete($id)) {
					throw new JMapException($table->getError(), 'error');
				}
				// Only if table supports ordering
				if(property_exists($table, 'ordering')) {
					$table->reorder();
				}
			} catch (JMapException $e) {
				$this->setError($e);
				return false;
			} catch (Exception $e) {
				$jmapException = new JMapException($e->getMessage(), 'error');
				$this->setError($jmapException);
				return false;
			}
		}
		
		return true;
	}
	
	/**
	 * Storing entity by ORM table
	 *
	 * @access public
	 * @return mixed
	 */
	public function storeEntity() {
		$table = $this->getTable();
		try {
			if (!$table->bind ($_POST, true)) {
				throw new JMapException($table->getError (), 'error');
			}
	
			if (!$table->check ()) {
				throw new JMapException($table->getError (), 'error');
			}
				
			if (! $table->store (false)) {
				throw new JMapException($table->getError (), 'error');
			}
			// Only if table supports ordering
			if(property_exists($table, 'ordering')) {
				$table->reorder();
			}
		} catch(JMapException $e) {
			$this->setError($e);
			return false;
		}  catch(Exception $e) {
			$jmapException = new JMapException($e->getMessage(), 'error');
			$this->setError($jmapException);
			return false;
		}
		return $table;
	}
	
	/**
	 * Class constructor
	 *
	 * @access public
	 * @param $config array
	 * @return Object&
	 */
	public function __construct($config = array()) {
		parent::__construct($config);
		$this->app = JFactory::getApplication();
	}
}