// Turn radios into btn-group
jQuery(function($) {
	$('input[type=radio]~label').addClass('radio btn btn-default');
	$('input[type=radio]').hide();
	$('input[type=radio]:first-child').next('label').css({'border-top-left-radius':'5px', 'border-bottom-left-radius':'5px'});
	$('input[type=radio]~label:last-child').css({'border-top-right-radius':'5px', 'border-bottom-right-radius':'5px'});
	$("input[type=radio]~label:not(.active)").click(
		function() {
			var label = $(this);
			var input = $(label).prev();

			if (!input.prop('checked')) {
				label.parent('div, td, span, fieldset').find("label").removeClass(
						'active btn-success btn-danger btn-primary');
				if (input.val() == '') {
					label.addClass('active btn-primary');
				} else if (input.val() == 0) {
					label.addClass('active btn-danger');
				} else {
					label.addClass('active btn-success');
				}
				input.prop('checked', true);
			}
		});
	$("input[type=radio][checked=checked]").each(
		function() {
			if ($(this).val() == '') {
				$(this).next('label').addClass(
						'active btn-primary');
			} else if ($(this).val() == 0) {
				$(this).next('label').addClass(
						'active btn-danger');
			} else {
				$(this).next('label').addClass(
						'active btn-success');
			}
		});
	
	/**
	 * Enables bootstrap popover
	 */
	$('label.hasPopover, button.hasPopover, div.hasPopover, span.hasPopover').popover({trigger:'hover', placement:'top', html:1});
	
	/**
	 * Enables bootstrap tooltip
	 */
	$('label.hasTip:not([id^=jform]):not([for^=jform])').tooltip({trigger:'hover', placement:'top'});

	
	
	/**
	 * Accordion panels local storage memoize and set open
	 */
	var defaultAccordionObject = {'accordion_cpanel':'jmap_status', 
								  'accordion_help':'jmap_functionalities',
								  'accordion_datasource_details':'datasource_details',
								  'accordion_datasource_excludecats':'datasource_excludecats',
								  'accordion_datasource_excludearticles':'datasource_excludearticles',
								  'accordion_datasource_excludemenu':'datasource_excludemenu',
								  'accordion_datasource_menupriorities':'datasource_menupriorities',
								  'accordion_datasource_parameters':'datasource_parameters',
								  'accordion_datasource_sqlquery':'datasource_sqlquery',
							      'accordion_datasource_xmlparameters':'datasource_xmlparameters',
							      'accordion_datasource_sqlquery_maintable':'datasource_sqlquery_maintable',
							      'accordion_datasource_sqlquery_jointable1':'datasource_sqlquery_jointable1',
							      'accordion_datasource_sqlquery_jointable2':'datasource_sqlquery_jointable2',
							      'accordion_datasource_sqlquery_jointable3':'datasource_sqlquery_jointable3',
							      'accordion_datasource_sqlquery_autogenerated':'datasource_sqlquery_autogenerated',
							      'accordion_datasource_sqlquery_querystring':'datasource_sqlquery_querystring',
							      'accordion_pingomatic_details':'pingomatic_details',
							      'accordion_pingomatic_services':'pingomatic_services'
								 };
	$('div.panel-group').on('shown.bs.collapse', function (event) {
		event.stopPropagation();
		var localStorageAccordion = $.jStorage.get('accordionOpened', defaultAccordionObject);
		localStorageAccordion[this.id] = event.target.id;
		$.jStorage.set('accordionOpened', localStorageAccordion);
		
		// Scroll to accordion header if needed
		if(document.body.scrollHeight > window.innerHeight) {
			$('html, body').animate({ scrollTop: $("#"+event.target.id).prev().offset().top - 50 }, 500);
		}
	}).on('hidden.bs.collapse', function (event) {
		event.stopPropagation();
		var localStorageAccordion = $.jStorage.get('accordionOpened', defaultAccordionObject);
		delete localStorageAccordion[this.id];
		$.jStorage.set('accordionOpened', localStorageAccordion);
	});
	
	$('div.panel-group').on('show.bs.collapse', function (event) {
		// Add open state
		$(event.target).prev().addClass('opened');
	}).on('hidden.bs.collapse', function (event) {
		// Remove open state
		$(event.target).prev().removeClass('opened');
	});
	
	$.each($.jStorage.get('accordionOpened', defaultAccordionObject), function(namespace, element) {
		if($('#'+element, '#'+namespace).length) {
			$('#'+element, '#'+namespace).addClass('in').prev().addClass('opened');
		}
	});
	
	/**
	 * Tab panels local storage memoize and set open
	 */
	var defaultTabObject = {'tab_configuration':'#preferences'};
	$('.nav.nav-tabs').on('shown.bs.tab', function (event) {
		var localStorageTab = $.jStorage.get('tabOpened', defaultTabObject);
		localStorageTab[this.id] = $(event.target).data('target');
		$.jStorage.set('tabOpened', localStorageTab);
	});
	
	$.each($.jStorage.get('tabOpened', defaultTabObject), function(namespace, element) {
		$('a[data-target='+element+']', '#'+namespace).tab('show');
	});
	
	// Replace :: for old legacy Mootools title
	$('#configParams label.hasTip').each(function(indes, elem){
		var currentTitle = $(elem).attr('data-original-title');
		var replacedTitle = currentTitle.replace("::", " - ");
		$(elem).attr('data-original-title', replacedTitle);
	});
});