<?php 
/** 
 * @package JMAP::SOURCES::administrator::components::com_jmap
 * @subpackage views
 * @subpackage help
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' ); 
?>
This section contains explanations for some extra activities and options that can be done with JSitemap PRO.

<h3>Using multicolumns responsive sitemap</h3>
<div>
	JSitemap PRO supports generation of <span class="bold">multicolumns HTML sitemap</span>, where you can have a default max number of 3 columns side by side.
	This is particularly useful when you have many elements and data sources in your sitemap and you want your user have a better visualization
	that doesn't require a very long single column.
	<br/>
	To <span class="bold">activate the multicolumns layout</span> you can simply enable the available setting inside JSitemap configuration, under 'Sitemap Aspect' tab.
	The multicolumns layout <span class="bold">support responsiveness and mobile devices</span>, this means that under certain screen resolution the side by side columns
	will be <span class="bold">stacked to show as a single column</span> to optimize visualization on mobile devices.
	<br/>
	You need to have at least 3 data sources to have 3 different columns.
	<br/>
</div>

<h3>Multilevel tree of folders</h3>
<div>
For 3PD extensions you can choose to let JSitemap <span class="bold">calculate a multilevel tree of nested folders</span> when HTML sitemap is rendered for component items. 
This feature requires that 3PD extensions is supported by wizard and is compatible to let JSitemap have enough informations to generate such a nested tree,
so you may have some 3PD extensions not affected when this option is turned on.

When multilevel tree of folders option is enabled and supported from 3PD extension as for K2 you will see a <span class="bold">full nested and indented tree of folders</span> with unlimited depth.
<br/>
Picture below show comparison for same data source in sitemap generated by K2 items, having 1 single level on the left side and multilevel on the right side.
<br/>
<img src="components/com_jmap/images/documentation/multilevel_tree.jpg" alt="pingomatic links"/>
<br/>

Please note that this setting affects only data source for supported extensions and can be resource expensive, so don't activate it if you have thousands of links in your sitemap. 
Data sources that address categories itself won't be affected by this type of rendering.
</div>

<h3>Specify sitemap priorities for every single menu item</h3>
<div>
Sitemap priorities are defined normally at <span class="bold">data source level</span>, in that you can assign a different priority to a certain data source in your sitemap, being it of type menu, content or user.
However for <span class="bold">menu type</span> data sources it could be needed having chance to specify a <span class="bold">different priority also for every single menu item.</span> 
This can be useful for example to <span class="bold">instruct search engines</span> that your menu link to products is more important than a link to company information or contacts.<br/>

To setup this you will find inside every data source of type menu the releated section as shown in image below.
Assigning or removing priorites from menu items is straightforward, simply select menu item from left dropdown, priority on right dropdown and use assign/remove buttons. 
<br/>
<img src="components/com_jmap/images/documentation/priorities.jpg" alt="menu priorities"/>
<br/>
</div>


<h3>Integrated editor for robots.txt file</h3>
<div>
JSitemap PRO <span class="bold">integrates editor for robots.txt file</span> that let you choose exactly what kind of exclusion and blocks you can define for spiders and bots.
Moreover you can <span class="bold">keep track of every sitemaps entry</span> added clicking on SEO control panel buttons, to let search engines find your sitemaps, or even remove them.<br/>
The button to open robots.txt editor is available in main control panel, and once activate you can edit and save easily robots file, as shown in picture below.<br/>
<img src="components/com_jmap/images/documentation/robotstxt.jpg" alt="pingomatic links"/>
<br/>
</div>

<h3>Filtering data source items</h3>
<div>
Let's suppose you need to <span class="bold">filter a data source</span> for a certain component to show only items that belong to particular categories or you need to create multiple data sources for a component filtering
each data source to show items for a single category linked to menu items available in your Joomla! site.<br/>
This can be easily accomplished using <span class="bold">data source 'WHERE' conditions</span> for the needed table and field. In the picture below is reported example to filter K2 items by multiple categories with IDs 1,2,3.<br/>
Leaving the operator to '=' will include the items with category ID matching one of the following ID, you can also change the operator for example to get items that belong to category with ID greater than a certain value.<br/>
<img src="components/com_jmap/images/documentation/catfilters.jpg" alt="cat filters"/>
</div>

<h3>Having dummy sitemap.xml file</h3>
<div>
As by default the static sitemap.xml file located at your server root is no more necessary using JSitemap. This solution is now deprecated, because too complex to manage,
having to generate a new sitemap and refresh the file manually everytime your sitemap changes.
Moreover having multiple sitemaps that would be quite impossible manage a lot of physical XML files at the root of your server.<br/>

To overcome this limitations JSitemap introduces the new concept of <span class="bold">dynamic generated sitemaps,</span> that uses <span class="bold">direct links to component</span> to produce an XML sitemap <span class="bold">on the fly</span>, 
being it always updated.
However someone could need or like to use a single XML sitemap <span class="bold">mapped as a classical file placed at server root</span>, so in this case having http://mydomain.com/sitemap.xml.<br/>

To have this result you need to edit your .htaccess file as described below, so that also if the link appears as a pysical file on your server, it will be rewritten by .htaccess and Joomla SEF
to execute the dynamic link used by JSitemap to have sitemap generated on the fly instead of static XML file. For this setup, follow these steps:

<h5>STEP 1 - Create menu link to HTML sitemap</h5>
<div>The first step is <span class="bold">create a common menu item that links to HTML format sitemap</span> on your site, assigning an <span class="bold">alias named 'sitemap'</span>, as you see in picture below.</div>
<img src="components/com_jmap/images/documentation/sitemapxml1.jpg" alt="sitemap links"/>

<h5>STEP 2 - Editing .htaccess file</h5>
<div>
Once the alias for 'sitemap' has been created in your site menu, you can <span class="bold">edit .htaccess</span> to have rewrite rule for xml files extensions in the same way already happens for html files.
Open your .htaccess and locate the following line:<br/>
<span style="font-style:italic">RewriteCond %{REQUEST_URI} /component/|(/[^.]*|\.(php|html?|feed|pdf|vcf|raw))$ [NC]</span> <br/>
now what you need to add is the 'xml' extension as a file extension, to make it look in this way: <br/>
<span style="font-style:italic">RewriteCond %{REQUEST_URI} /component/|(/[^.]*|\.(php|html?|<span class="bold">xml</span>|feed|pdf|vcf|raw))$ [NC]</span><br/><br/>

This system could be also replicate for other sitemap formats if yo like, so for example for images sitemap you can have http://mydomain.com/sitemap.images, adding the 'images' extension to .htaccess:<br/>
<span style="font-style:italic">RewriteCond %{REQUEST_URI} /component/|(/[^.]*|\.(php|html?|<span class="bold">xml|images</span>|feed|pdf|vcf|raw))$ [NC]</span>
</div>
</div>

<h3>Embed sitemap in module position</h3>
<div>
	JSitemap PRO can be embedded also inside Joomla! module position in easy way and without need of additional tools, because
	it's integrated with Joomla! native module system.
	<br/>
	In order to proceed to create a new module for JSitemap view you can do the following steps.
	
	<h5>STEP 1 - locate the HTML sitemap link in SEO control panel</h5>

	Your HTML sitemap link will look like this: <span class="bold">http://yourdomain.com/index.php?option=com_jmap&view=sitemap&amp;lang=en</span> <br/>
	In order to use it for module inclusion you have to add an extra string to link <span class="bold">'&tmpl=component'</span>, <br/>
	so that your final link will be in this form:<span class="bold">http://yourdomain.com/index.php?option=com_jmap&view=sitemap&amp;lang=en<span style="color:red">&tmpl=component</span></span>
	
	
	<h5>STEP 2 - Create a new Joomla! module</h5>
	
	In Joomla! module manager create a new module of type "Wrapper" choosing a title and a position are usual, based on
	position you want to be shown your sitemap.<br/>
	In right panel for 'Basic options' paste the final link for HTML sitemap in the first field named 'URL' and save the module.
	Of course you can also fine tune other settings like height, auto height, frame border, etc.
	
	<h5>STEP 3 - Set JSitemap to open link in right way</h5>

	When you embed sitemap in a Joomla! module that can be shown in all or some pages of your site,
	you need to set links target to to your main site window, to avoid opening blank pages.<br/>
	
	To do this you can go in JSitemap configuration, and set 'Open link mode' parameter to 'Parent window'.
	That's all, your module will be visible and will show sitemap contents.
	Please note that for module display only sitemap one column layout is available.
</div>


<h3>Override HTML sitemap layout</h3>
<div>
	JSitemap PRO is also fully customizable for HTML layout, because it's based in Joomla! template files that can be overriden in our template.
	By default it can be rendered in several way and combination, using parameters available in 'Sitemap Aspect' tab. You can choose to show 
	expandable tree of folder or basic sitemap tree, show as multi columns or single column, show expanded by default or keep collapsed and expand by users.
	<br/>
	But if you need some more specific customizations you can work on CSS or make a template override.
	JSitemap PRO is based on this files for rendering of HTML layout:
	<ul>
		<li>For CSS styles - yoursitepath\components\com_jmap\js\jquery.treeview.css</li>
		<li>For template override - yoursitepath/components/com_jmap/views/sitemap/tmpl/default_html.php</li>
		<li>For template override - yoursitepath/components/com_jmap/views/sitemap/tmpl/default_html_content.php</li>
		<li>For template override - yoursitepath/components/com_jmap/views/sitemap/tmpl/default_html_menu.php</li>
		<li>For template override - yoursitepath/components/com_jmap/views/sitemap/tmpl/default_html_user.php</li>
	</ul>
	You can override template files as usual in Joomla! system, placing override in 'html' folder of your current template for
	extension named 'com_jmap'.
</div>