<?php
// namespace components\com_jmap\controllers;
/**
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage controllers
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.controller');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.archive');

/**
 * Main controller class
 *
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage controllers
 * @since 1.0
 */
class JMapControllerSitemap extends JMapController {
	/**
	 * Display the Sitemap
	 * @access public
	 * @return void
	 */
	public function display($cachable = false, $urlparams = false) {
		// Get REQUEST vars all used to makeId for cache handler
		$option = JRequest::getCmd('option');
		$format = JRequest::getVar('format', 'html');
		$language = JRequest::getvar('lang', null);
		$itemid = JRequest::getInt('Itemid', null);
		$xslt = JRequest::getInt('xslt', null);
		
		// Get sitemap model and view core
		$document = JFactory::getDocument();
		$viewType = $document->getType();
		$coreName = $this->getNames();
		$viewLayout = JRequest::getCmd('layout', 'default');

		$view = $this->getView($coreName, $viewType, '', array('base_path' => $this->basePath));

		// Get/Create the model
		if ($model = $this->getModel($coreName, 'JMapModel', array('document_format' => $format))) {
			// Push the model into the view (as default)
			$view->setModel($model, true);
		}

		$model->setState('xslt', $xslt);

		// Set the layout
		$view->setLayout($viewLayout);

		// Display the view checking for cache feature
		$joomlaConfig = JFactory::getConfig();
		$componentConfig = JComponentHelper::getParams($option);
		$cachable = $componentConfig->get('enable_view_cache', false) && $joomlaConfig->get('caching', false);
		if ($cachable) {
			$registeredurlparams = new stdClass();
			$registeredurlparams->lang = 'CMD';
			$registeredurlparams->Itemid = 'INT';
			$registeredurlparams->xslt = 'INT';
			$this->app->registeredurlparams = $registeredurlparams;
			if($format != 'html') {
				$document->setMimeEncoding('application/xml');
			}
			
			$cache = @JFactory::getCache($option, 'view');
			$cache->get($view, 'display');
		} else {
			$view->display($format);
		}
	}

	/**
	 * Export XML sitemap file
	 * @access public
	 * @return void
	 */
	public function exportXML() {
		// Get REQUEST vars
		$option = JRequest::getCmd('option');
		$format = JRequest::getVar('format', 'xml');
		// Manage language file string naming
		$lang = JRequest::getVar('lang', null);
		$langString = $lang ? '_' . $lang : null;
		$Itemid = JRequest::getVar('Itemid', null, 'default', 'INT');
		$ItemidFilter = $Itemid ? '_menuid' . $Itemid : null;

		// Get sitemap model and view core
		$document = JFactory::getDocument();
		$viewType = $document->getType();
		$coreName = $this->getNames();
		$viewLayout = JRequest::getCmd('layout', 'default');

		$view = $this->getView($coreName, $viewType, '', array('base_path' => $this->basePath));
		
		// Get/Create the model
		if ($model = $this->getModel($coreName, 'JMapModel', array('document_format' => $format))) {
			// Push the model into the view (as default)
			$view->setModel($model, true);
		}
		// Set the layout
		$view->setLayout($viewLayout);
		
		$cParams = JComponentHelper::getParams('com_jmap');
		// Start XML buffer
		ob_start();
		$view->display($format, true);
		$xmlSitemap = ob_get_contents();
		ob_end_clean();

		// Choose if split sitemap
		if ($cParams->get('split_sitemap', false)) {
			$splitter = new JMapXmlSplitter($format, $langString);
			$splitter->chunkXMLString($xmlSitemap, 'url', $cParams->get('split_chunks', 5));
			// Check if chunks was generated
			if ($xmlChunkFiles = $splitter->getChunks()) {
				// Create ZIP archive and pass contents of written file to export
				$archiver = JArchive::getAdapter('zip');
				$pathForArchive = JPATH_COMPONENT_ADMINISTRATOR . '/cache/sitemap_' . $format . $langString . $ItemidFilter . '.zip';
				$archiver->create($pathForArchive, $xmlChunkFiles);

				if (!$model->exportXMLSitemap($pathForArchive, $format, 'zip', $langString, $ItemidFilter, 'application/zip', true)) {
					$msg = 'COM_JMAP_ERROR_EXPORTING_SITEMAP';
					$option = JRequest::getVar('option');
					$this->setRedirect("index.php?option=$option&task=sitemap.display", JText::_($msg));
				}
			}
		} else {
			if (!$model->exportXMLSitemap($xmlSitemap, $format, 'xml', $langString, $ItemidFilter, 'application/xml')) {
				$msg = 'COM_JMAP_ERROR_EXPORTING_SITEMAP';
				$option = JRequest::getVar('option');
				$this->setRedirect("index.php?option=$option&task=sitemap.display", JText::_($msg));
			}
		}
	}

	/**
	 * Class Constructor
	 * @access public
	 * @return Object&
	 */
	public function __construct($config = array()) {
		parent::__construct($config);
		$this->registerTask('view', 'display');
	}
}
