// Turn radios into btn-group
jQuery(function($) {
	/**
	 * Enables bootstrap popover
	 */
	$('label.hasPopover, button.hasPopover, div.hasPopover, span.hasPopover').popover({trigger:'hover', placement:'top', html:1});

	/**
	 * Remove empty ordering spans
	 */
	$('.order span').filter(function(){
		var hasChild = !$('a', this).length;
		return hasChild;
	}).remove();
	
	/**
	 * Accordion panels local storage memoize and set open
	 */
	var defaultAccordionObject = {'accordion_cpanel':'jmap_status', 
								  'accordion_help':'jmap_functionalities',
								  'accordion_datasource_details':'datasource_details',
								  'accordion_datasource_excludecats':'datasource_excludecats',
								  'accordion_datasource_excludearticles':'datasource_excludearticles',
								  'accordion_datasource_excludemenu':'datasource_excludemenu',
								  'accordion_datasource_menupriorities':'datasource_menupriorities',
								  'accordion_datasource_parameters':'datasource_parameters',
								  'accordion_datasource_sqlquery':'datasource_sqlquery',
							      'accordion_datasource_xmlparameters':'datasource_xmlparameters',
							      'accordion_datasource_sqlquery_maintable':'datasource_sqlquery_maintable',
							      'accordion_datasource_sqlquery_jointable1':'datasource_sqlquery_jointable1',
							      'accordion_datasource_sqlquery_jointable2':'datasource_sqlquery_jointable2',
							      'accordion_datasource_sqlquery_jointable3':'datasource_sqlquery_jointable3',
							      'accordion_datasource_sqlquery_autogenerated':'datasource_sqlquery_autogenerated',
							      'accordion_datasource_sqlquery_querystring':'datasource_sqlquery_querystring',
							      'accordion_pingomatic_details':'pingomatic_details',
							      'accordion_pingomatic_services':'pingomatic_services'
								 };
	$('div.panel-group').on('show.bs.collapse', function (event) {
		if(!$(event.target).hasClass('panel-collapse')) {
			return;
		}
		event.stopPropagation();
		var localStorageAccordion = $.jStorage.get('accordionOpened', defaultAccordionObject);
		localStorageAccordion[this.id] = event.target.id;
		$.jStorage.set('accordionOpened', localStorageAccordion);
		
		// Scroll to accordion header if needed
		if(document.body.scrollHeight > window.innerHeight) {
			$('html, body').animate({ scrollTop: $("#"+event.target.id).prev().offset().top - 130 }, 500);
		}
		// Add open state
		$(event.target).prev().addClass('opened');
	}).on('hide.bs.collapse', function (event) {
		if(!$(event.target).hasClass('panel-collapse')) {
			return;
		}
		event.stopPropagation();
		var localStorageAccordion = $.jStorage.get('accordionOpened', defaultAccordionObject);
		if(localStorageAccordion[this.id] == event.target.id) {
			delete localStorageAccordion[this.id];
			$.jStorage.set('accordionOpened', localStorageAccordion);
		}
		// Remove open state
		$(event.target).prev().removeClass('opened');
	});
	
	$.each($.jStorage.get('accordionOpened', defaultAccordionObject), function(namespace, element) {
		if($('#'+element, '#'+namespace).length) {
			$('#'+element, '#'+namespace).addClass('in').prev().addClass('opened');
		}
	});
	
	/**
	 * Tab panels local storage memoize and set open
	 */
	var defaultTabObject = {'tab_configuration':'#preferences'};
	$('.nav.nav-tabs').on('shown.bs.tab', function (event) {
		var localStorageTab = $.jStorage.get('tabOpened', defaultTabObject);
		localStorageTab[this.id] = $(event.target).data('element');
		$.jStorage.set('tabOpened', localStorageTab);
	});
	
	$.each($.jStorage.get('tabOpened', defaultTabObject), function(namespace, element) {
		$('a[data-element='+element+']', '#'+namespace).tab('show');
	});
	
	/**
	 *  Hide state select on phone
	 */
	$('#filter_state, #filter_type').addClass('hidden-phone');
});