<?php
// namespace administrator\components\com_jmap\controllers;
/**
 * @package JMAP::CPANEL::administrator::components::com_jmap
 * @subpackage controllers
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

/**
 * CPanel controller
 *
 * @package JMAP::CPANEL::administrator::components::com_jmap
 * @subpackage controllers
 * @since 1.0
 */
class JMapControllerCpanel extends JMapController {
	/**
	 * Show Control Panel
	 * @access public
	 * @return void
	 */
	function display($cachable = false, $urlparams = false) {
		$defaultModel = $this->getModel();
		// Auto-Refresh menu sources
		if(!$defaultModel->syncMenuSources()) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$modelExceptions = $defaultModel->getErrors();
			foreach ($modelExceptions as $exception) {
				$this->app->enqueueMessage($exception->getMessage(), $exception->getErrorLevel());
			}
		}
		
		$view = $this->getView();
		$HTTPClient = new JMapHttp();
		$view->set('httpclient', $HTTPClient);
		
		parent::display ($cachable); 
	}
	
	/**
	 * Edit entity
	 *
	 * @access public
	 * @return void
	 */
	public function editEntity() {
		JRequest::setVar('tmpl', 'component');
		$option = JRequest::getVar('option');
		$cid = JRequest::getVar('cid', array(0), 'method', 'array');
		$idEntity = (int) $cid[0];
		$user = JFactory::getUser();
		$model = $this->getModel();
		$model->setState('option', $option);
	
		// Try to load record from model
		if(!$robotsContent = $model->loadEntity(null)) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$modelExceptions = $model->getErrors();
			foreach ($modelExceptions as $exception) {
				$this->app->enqueueMessage($exception->getMessage(), $exception->getErrorLevel());
			}
			return false;
		}
	
		// Additional model state setting
		$model->setState('option', JRequest::getVar('option'));
	
		// Access check
		if(!$this->allowEdit($model->getState('option'))) {
			$this->app->enqueueMessage(JText::_('COM_JMAP_JERROR_ALERT_NOACCESS'), 'notice');
			return false;
		}
	
		// Get view and pushing model
		$view = $this->getView();
		$view->setModel ( $model, true );
	
		// Call edit view
		$view->editEntity($robotsContent);
	}
	
	/**
	 * Manage entity apply/save after edit entity
	 *
	 * @access public
	 * @return void
	 */
	public function saveEntity() {
		$option = JRequest::getVar('option');
		$data = JRequest::getVar('robots_contents', null, 'REQUEST', 'string');
	
		//Load della  model e bind store
		$model = $this->getModel ();
	
		if(!$result = $model->storeEntity($data)) {
			// Model set exceptions for something gone wrong, so enqueue exceptions and levels on application object then set redirect and exit
			$modelException = $model->getError(null, false);
			$this->app->enqueueMessage($modelException->getMessage(), $modelException->getErrorLevel());
			$this->setRedirect ("index.php?option=$option&task=cpanel.editEntity");
			return false;
		}

		$this->setRedirect ( "index.php?option=$option&task=cpanel.editEntity", JText::_('COM_JMAP_SUCCESS_SAVE_ROBOTS'));
	}
		
	/**
	 * Show suggestions
	 * @access public
	 * @return void
	 */
	public function installerApp() {
		$view = $this->getView();
	
		$view->showInstallerApp();
	}
}