<?php 
/** 
 * @package JMAP::CPANEL::administrator::components::com_jmap
 * @subpackage views
 * @subpackage help
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2014 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' ); 
?> 
<div>
	JSitemap PRO supports <span class="bold">generation of different types of sitemap.</span> Beyond
	the normal <span class="bold">XML sitemap</span> used to indexing your regular web contents by search
	engines, you can generate specific types of sitemap for Google,
	enhancing at a higher level indexing of your site and contents.
	JSitemap PRO supports generation of <span class="bold">'Images sitemap' and 'Google News
	sitemap'</span>, that you can submit directly in XML format using link provided for dynamic generation. <br />
	<h3>Images sitemap</h3>
	With image search, just as with web search, Google's goal is to provide
	the best and most relevant search results to users.  By not listing images in your Sitemap,
	you're telling Google that they have no importance. <br />
	<br />JSitemap PRO can <span class="bold">generate sitemap for images present on your site's pages</span>, to let your site being found through images search
	and let you <span class="bold">exclude images</span> that are not relevant for indexing through a <span class="bold">fine tune system based on filters</span>.<br />
	To show/export XML images sitemap you need to click on 'Show XML Sitemaps' icon in main control panel
	and in the opening lightbox window choose button 'Show XML Images Sitemap' or 'Export XML
	Images Sitemap'. <br />
	<img src="components/com_jmap/images/documentation/lightbox.jpg" alt="lightbox"/>
	<br />
	<br />
	Of course you may not desire to
	include all images that are present on one page, simply because some of
	them could be not relevant for indexing, for example icons provided by
	Joomla! for pdf format or printing.<br />
	<br />To solve this problem JSitemap PRO offers an <span class="bold">advanced filtering system to
	include or exclude images for each single data source</span>, based on <span class="bold">slices of string or paths</span> that
	you can specify comma separated. <br />In the example below for a virtuemart products data source has been
	specified that only images with path including 'virtuemart'
	will be valid for Images Sitemap. 
	Moreover by default it will be ignored
	and excluded those images that are named with 'pdf', 'print', 'email', etc
	that are standard for Joomla! and for this reason are not relevant for sitemap and indexing.
	You can specify whatever rules you need, both for include and exclude
	filters, simply separate them by comma.<br />
	Finally you can choose to  <span class="bold">exclude at all</span> images for a specific data source,
	For example if you don't want to include images of virtuemart products you can 
	switch off parameter for 'Include elements in XML Images sitemap'.
	<br />
	<img src="components/com_jmap/images/documentation/xmlimages.jpg" alt="lightbox"/>
	
	<br /><span class="bold">HEADS UP!</span> Images sitemap generation scans your site's pages looking for
	images contained inside, and once discovered put them into XML format
	that will be accepted by Google. This <span class="bold">could require a lot of time to complete</span> because the spider shipped with JSitemap
	has to crawl all the links in your sitemap. For this reason you should optimize images sitemap leaving
	only important links to be scanned and eventually <span class="bold">limiting the max number of HTTP requests for available sitemap links</span> to be placed <span class="bold">through the provided parameter</span>(See image below).<br/>
	Images sitemap generation could be very resource expensive if you have sitemap with thousands of links,
	and it could require also <span class="bold">settings adjust on your hosting server</span>, for example if HTTP Sockets are not enabled or HTTP connection to same server are not allowed for security reason. 
	You can also enable caching to speed up images sitemap generation, also if first request will need time to generate full sitemap to be cached.
	<br />
	<img src="components/com_jmap/images/documentation/imageslimit.jpg" alt="lightbox"/>
	
	<h3>Google News sitemap</h3>
	If you want to be indexed within Google News, your site must have a particular XML sitemap published specifically for Google News system.<br />
	A big mistake, or rather a missed opportunity, is not creating a Google
	News sitemap. Your articles will still get indexed via regular site
	crawling, but the news sitemap helps to expedite the process. It also
	enables you to segment your news content (i.e. articles and blog posts)
	from other forms of editorial content that are not eligible for
	indexation. With breaking news and trending topics speed counts; don't
	put yourself at a competitive disadvantage. Along those lines also make
	sure that your Google News sitemap is updated immediately whenever new,
	eligible content is published. The other plus of a Google News sitemap
	is it gives you the ability to provide additional information such as
	image-related tags, keywords and genre tags.<br />
	<br />JSitemap PRO does all this work for you and let you create Google News Sitemap  <span class="bold">based on native Joomla! contents.</span> This means that for XML
	generation only content data source will be used for Google News
	sitemap, because it contains the only relevant information accepted by Google for news SERP. 
	So  <span class="bold">it won't	be processed menu links and custom user data sources.</span> 
	For articles included within Google News sitemap will be extracted automatically additional
	informations needed for XML format like: language, genre, access type, etc.<br />
	
	<br /><span class="bold">HEADS UP!</span> In order to let Google accept correctly your Google News sitmap you should have a <span class="bold">registered publication name
	on your Google account</span>, and it must match that on your site that will be used for sitemap.
	For example news from CNN will be shown in Google News search results with registered publication name as 'CNN'(See image below for green text).
	<br/>
	Moreover Google recommends to include inside Google news sitemap articles published in the last two days. For this you can find a parameter in JSitemap configuration under
	tab 'Advanced settings' that let you enable limit to recent 'n days' articles used for Google news, by default 2 days.
	A good strategy if you have just started to submit Google news sitemap on existing site with already a lot of contents, would be initially leave off this parameter to ensure
	indexing of older contents, and after that indexing is complete enable limit to submit sitemap only with most recent articles to be crawled every day.
	<br/>
	<img src="components/com_jmap/images/documentation/cnn_publication.jpg" alt="lightbox"/>
	<br/>
	By default JSitemap PRO to generate Google News sitemap will use your <span class="bold">Joomla! site name</span> as specified in <span class="bold">Joomla! global configuration.</span>
	So for example if you had used 'CNN' to register your Google publication name, your site should be named 'CNN'
	in order to let JSitemap generate correctly Google News sitemap.
	However you can <span class="bold">override this setting</span>, in that JSitemap let you specify a different publication name
	from your site name through the parameter shown in image below. Visit this link to have more information about Google policy for News inclusion and registration.
	<a href="https://support.google.com/webmasters/answer/74288?hl=en" target="_blank" title="gnews info">https://support.google.com/webmasters/answer/74288?hl=en</a>
	<br/>
	<img src="components/com_jmap/images/documentation/publication_setting.jpg" alt="lightbox"/>
	<br/>
	
	<h3>Mobile sitemap</h3>
	In case if your site has a specially formatted version designed for mobile devices, it may be best practice create a separate mobile sitemap and submit it to search engines. 
	That will allow search engines to better serve search requests from mobile devices and lead them to your website pages.
	Mobile sitemap should only contain links to pages with mobile web content, otherwise you should use regular XML sitemap.
	
	You should use Mobile XML sitemap ONLY if you have a mobile version of your site, 
	developed specifically for mobile phones that need mobile contents. 
	It may be useful if you have <span class="bold">www.yoursite.com</span> and a mobile phones version <span class="bold">m.yoursite.com</span> of your site with valid mobile markup. 
	If you don't have a mobile phones version of your site simply <span class="bold">don't use this type of sitemap</span>, 
	search engines <span class="bold">will ignore mobile URLs pointing to pages with contents not valid for mobile phones.</span>
	A Mobile Sitemap can contain only URLs that serve mobile web content. Any URLs that serve only non-mobile web content will be ignored by the Google crawling mechanisms. 
	If you have non-mobile contents, create a standard XML Sitemap for those URLs.
	
	Moreover most <span class="bold">modern devices like Android and iOS smartphones or tablets, don't need a mobile sitemap.</span> They are considered as desktop PC by search engines.
	To target mobile phones you should have a mobile version of your site following special mobile markup:
	<ul>
	<li>XHTML mobile profile (WAP 2.0)</li>
	<li>WML (WAP 1.2)</li>
	<li>cHTML (iMode)</li>
	</ul> 
	If you have this, it will make sense using also a mobile sitemap format for those URLs.
	
	<br />
	<h3>Sitemap splitting</h3>
	With JSItemap PRO you will be able also to <span class="bold">split large sitemaps</span> into
	sub-chunks of fixed records, to manage them and let search engines
	accept all your contents with no limitation. So for example if submitting
	your sitemap to Google or Bing you experiment an error dued to the
	excess of the limit for size or number of links, you can choose to
	enable split functionality in component configuration, and estabilish
	how many links should be included in every chunk.
	<br/>
	When you choose to split sitemap you <span class="bold">need to export an 'zip' archive</span> in order to get all sitemap chunks,
	you can do this simply going to export sitemap section, and instead of a unique XML file an archive will be generated.
	<br/>
	Inside the package you will <span class="bold">find all  multiple XML files</span>
	numbered accordingly to numeric chunks and containing a sub-part of the total records.
	<br/>
	<span class="bold">Splitted sitemap can't be generated dinamically </span>(through links provided in SEO control panel that will generate always full sitemap), 
	so yo have to export the zip archive containing the multiple chunks splitted on different XML files, and once unzipped <span class="bold">position them uploading via FTP to your server root.</span>
	<br/>
	It's important to note that <span class="bold">inside zip archive will be included a special file named starting with 'sitemapindex...xml'.</span>
	This is the <span class="bold">main sitemap index file</span> that include links to all subchunks (according to Google protocol) for splitted sitemap files.
	Once uploaded all files to your server root you <span class="bold">should only submit</span> to Google Webmaster tools the <span class="bold">link to this main index file.</span>
	<br/>
	Otherwise if you don't have a Webmaster tools account you can <span class="bold">add an entry in your robots.txt</span> as follow:
	<p style="font-style:italic">Sitemap: http://mydomain/sitemapindex_xml.xml</p>
	<br />
	<img src="components/com_jmap/images/documentation/splitting.jpg" alt="lightbox"/>
	
	<br />
	<h3>Caching system</h3>
	You can enable cache to <span class="bold">speed up subsequent sitemap generation</span>. Cache is avaiable for <span class="bold">all types of sitemap</span>, 
	and once enabled the very first time a certain sitemap is generated all the <span class="bold">contents will be cached and available in less time for all subsequent requests</span>.<br/>
	Choosing expiration time in Joomla! global configuration you can choose <span class="bold">how long the cached sitemap will be considered as valid.</span> When Joomla! cache time expires cached sitemaps are
	considered stale, and a <span class="bold">new generation/cache process will be started.</span><br/>
	To enable caching system you need to enable the option available inside <span class="bold">JSitemap configuration panel.</span> 
	Ensure to get the green icon that indicates you have enabled Joomla! cache in global configuration.<br/>
	<br />
	<img src="components/com_jmap/images/documentation/caching.jpg" alt="lightbox"/>
	
</div>