<?php
/*------------------------------------------------------------------------
# System - Crossposting Cron
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 The Krotek. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support: support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined("_JEXEC") or die("Restricted access");

class plgSystemCrosspostingCron extends JPlugin
{
	var $running = false;
	
	function onAfterInitialise()
	{
		if (!$this->running) {
			$this->running = true;
			$period = (time() - $this->params->get('lastrun'))/60;
			
			if ($period >= $this->params->get('period')) {
				$this->params->set('lastrun', time());
				$params = $this->params->toString();
				$db = JFactory::getDbo() ;
				$db->setQuery("UPDATE #__extensions SET params=".$db->Quote($params)." WHERE element = 'crosspostingcron'");
				$db->query();
				
				require_once(JPATH_SITE.'/components/com_socialcrossposting/helpers/helper.php');

				$secret = $this->params->get('secret');
				$category = $this->params->get('category');
				$source = $this->params->get('source');
				
				$helper = new SocialCrosspostingHelper();
				$output = $helper->crossPost($secret, $category, $source);
				
				if ($this->params->get('sendreport')) {
					$lang = JFactory::getLanguage();
					$lang->load('com_socialcrossposting', JPATH_SITE);
					
					$config = new JConfig();
					$fname = $config->fromname;
					$fmail = $config->mailfrom;
					$tomail = $this->params->get('tomail');
					$subject = JText::_('COM_SOCIALCROSSPOSTING_REPORT_TITLE');
					
					if (version_compare(JVERSION, '3.0', 'ge')) {
						$mailer = new JMail();
						$status = $mailer->sendMail($fmail, $fname, $tomail, $subject, $output, 1, null, null, null, $fmail, $fname);
					} else {
						$status = JUtility::sendMail($fmail, $fname, $tomail, $subject, $output, 1, null, null, null, $fmail, $fname);
					}
				}
			}
			
			$this->running = false;
		}
		
		return true;		
	}
}

?>