<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class SocialCrosspostingController extends JControllerLegacy
{
	public function display($cachable = false, $urlparams = false)
	{
		$this->getConfig();
		
		parent::display();
		
		return $this;
	}

	public function getConfig()
	{
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		$query = 'SELECT conf_key, conf_value FROM #__crossposting_settings';
		$db->setQuery($query);
		$params = $db->loadAssocList();
		
		$config = array();
		
		if (!empty($params))
		{
			foreach($params as $param)
			{
				$config[$param['conf_key']] = $param['conf_value'];
			}
			
			if (empty($config['secret'])) 
			{
				$config['secret'] = $this->generateSecret(9);
				
				$db->setQuery("UPDATE #__crossposting_settings SET conf_value = ".$db->Quote($config['secret'])." WHERE conf_key = 'secret'");
				$db->query();
			}
		} else {
			$db->setQuery("INSERT INTO #__crossposting_settings (conf_key, conf_value) VALUES ('secret', ".$db->Quote($config['secret']).")");
			$db->query();
			$app->enqueueMessage(JText::_('COM_SOCIALCROSSPOSTING_MESSAGE_NEW_SECRET'), 'warning');
		}
		
		return $config;
	}

	public function generateSecret($length)
	{
		$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
		$chars_length = (strlen($chars) - 1);
		$secret = $chars{rand(0, $chars_length)};

		for ($i = 1; $i < $length; $i++)
		{
			$character = $chars{rand(0, $chars_length)};
			if ($character != $secret{$i - 1}) $secret .=  $character;
		}

		return $secret;
	}

	public function home()
	{
		$this->setRedirect("index.php?option=com_socialcrossposting");
	}
	
	public function publish()
	{
		$cids = JRequest::getVar('cid');
		
		foreach ($cids as $cid) {
			$model = $this->getModel('journal');
			$model->publish($cid);
		}
				
		$this->display();
	}

	public function unpublish()
	{
		$cids = JRequest::getVar('cid');
		
		foreach ($cids as $cid) {
			$model = $this->getModel('journal');
			$model->unpublish($cid);
		}
				
		$this->display();
	}
	
	public function remove()
	{
		$cids = JRequest::getVar('cid');
		
		foreach ($cids as $cid) {
			$model = $this->getModel('journal');
			$model->remove($cid);
		}
				
		$this->display();
	}
}

?>