<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 The Krotek. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined("_JEXEC") or die("Restricted access");

jimport('joomla.html.html');
jimport('joomla.form.formfield');

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::base().'components/com_socialcrossposting/assets/css/style.css');

class JFormFieldVKParams extends JFormField
{
	protected $type = "VKParams";

	protected function getInput()
	{
		$lang = "COM_SOCIALCROSSPOSTING_";

    	$coptions = array(
    		CURLOPT_POST 			=> true,
			CURLOPT_RETURNTRANSFER 	=> true,
 			CURLOPT_HEADER			=> false,
  			CURLOPT_ENCODING		=> "",
    		CURLOPT_USERAGENT 		=> "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0");

		$comparams = JComponentHelper::getParams('com_socialcrossposting');
		$params = $comparams->get("params");
		
		if (isset($params->{$this->fieldname})) $vkparams = $params->{$this->fieldname};
		else $vkparams = "";

		if ($vkparams) {
			$vkclientid = $vkparams->vkclientid;
			$vksecretkey = $vkparams->vksecretkey;

			if (isset($vkparams->vktoken)) $vktoken = $vkparams->vktoken;
			else $vktoken = "";
			if (isset($vkparams->vkuser)) $vkuser = $vkparams->vkuser;
			else $vkuser = "";
			if (isset($vkparams->vkwallid)) $vkwallid = $vkparams->vkwallid;
			else $vkwallid = "";
			if (isset($vkparams->vkwalls)) $vkwalls = (array)$vkparams->vkwalls;
			else $vkwalls = array();
		} else {
			$vkclientid = "";
			$vksecretkey = "";
			$vktoken = "";
			$vkuser = "";
			$vkwallid = "";
			$vkwalls = array();
		} ?>
		<div id="vk-params">
			<ul>
			<ul>
				<li>
					<div class="control-label">
						<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_ENABLE'); ?></strong><br/><?php echo JText::_($lang.'VK_ENABLE_DESC'); ?>">
							<?php echo JText::_($lang.'VK_ENABLE'); ?>
						</label>
					</div>
					<div class="controls">
					<fieldset id="jform_params_vkenable" class="radio btn-group">
						<input id="jform_params_vkenable0" type="radio" <?php if ($vkparams->vkenable) echo 'checked="checked"'; ?> value="1" name="jform[params][<?php echo $this->fieldname; ?>][vkenable]">
						<label for="jform_params_vkenable0" class="btn"><?php echo JText::_('JYES'); ?></label>
						<input id="jform_params_vkenable1" type="radio" <?php if (!$vkparams->vkenable) echo 'checked="checked"'; ?> value="0" name="jform[params][<?php echo $this->fieldname; ?>][vkenable]">
						<label for="jform_params_vkenable1" class="btn"><?php echo JText::_('JNO'); ?></label>
					</fieldset>
					</div>
				</li>			
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_CLIENDTID'); ?></strong><br/><?php echo JText::_($lang.'VK_CLIENDID_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_CLIENDTID'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][vkclientid]" value="<?php echo $vkclientid; ?>" />
				</li>
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_SECRETKEY'); ?></strong><br/><?php echo JText::_($lang.'VK_SECRETKEY_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_SECRETKEY'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][vksecretkey]" value="<?php echo $vksecretkey; ?>" />
				</li>
				<?php

				if (!empty($vkclientid) && !empty($vksecretkey)) {
					$scope = array();
					$scope[] = 'wall';
					$scope[] = 'offline';
					$scope[] = 'groups';
					$scope[] = 'photos';

					$redirect = "http://api.vk.com/blank.html";
			
					if (version_compare(JVERSION, '3', '<')) $tmpl = "&tmpl=component";
					else $tmpl = "";
				
					$loginUrl = "http://api.vk.com/oauth/authorize?client_id=".$vkclientid."&client_secret=".$vksecretkey."&scope=".implode(",", $scope)."&response_type=token&display=popup&redirect_uri=".$redirect;
			
					$helperUrl = JURI::base()."components/com_socialcrossposting/helpers/connect.php?client_id=".$vkclientid."&client_secret=".$vksecretkey."&mode=vklogin".$tmpl;
					$token = $vktoken;
					$userid = $vkuser;
			
					if (isset($_GET['mode'])) $mode = $_GET['mode'];
					else $mode = '';
			
					if (!empty($vktoken) &&  empty($mode)) { ?>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_TOKEN'); ?></strong><br/><?php echo JText::_($lang.'VK_TOKEN_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_TOKEN'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][vktoken]" value="<?php echo $vktoken; ?>" />
					</li>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_USER_ID'); ?></strong><br/><?php echo JText::_($lang.'VK_USER_ID_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_USER_ID'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][vkuser]" value="<?php echo $vkuser; ?>">
					</li>
					<?php } else if ($mode == "vkauthorized") { ?>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_TOKEN'); ?></strong><br/><?php echo JText::_($lang.'VK_TOKEN_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_TOKEN'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][vktoken]" value="" />
					</li>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_USER_ID'); ?></strong><br/><?php echo JText::_($lang.'VK_USER_ID_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_USER_ID'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][vkuser]" value="">
					</li>
					<li style="margin-bottom: 0">
						<span class="vk-params-message"><?php echo JText::_($lang.'VK_ENTER_AND_SAVE'); ?></span>
					</li>
				<?php } else { ?>
					<li style='margin-bottom: 0'>
						<span class='vk-params-message'>
							<a href="<?php echo $helperUrl; ?>" onclick="window.open('<?php echo $loginUrl; ?>'); return true;" title="<?php echo JText::_($lang.'VK_LOGIN'); ?>"><?php echo JText::_($lang.'VK_LOGIN'); ?></a>
						</span>
					</li>
				<?php } ?>
			<?php if (!empty($vktoken) && !empty($vkuser)) { ?>
				<li class='vk-params-title'><?php echo JText::_($lang.'VK_CHOOSE_WALLS'); ?></li>
				<li class='group-item'>
					<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'POST_TO'); ?></strong><br/><?php echo JText::_($lang.'VK_MY_WALL'); ?>"><?php echo JText::_($lang.'VK_MY_WALL'); ?></label>
					<input type='checkbox' name='jform[params][<?php echo $this->fieldname; ?>][vkwalls][]' value='<?php echo $vkuser; ?>'<?php if (in_array($vkuser, $vkwalls)) echo " checked='checked'"; ?>>
				</li>
 				<li class='group-item'>
 					<label class="hasTooltip" title="<strong><?php echo JText::_($lang.'VK_WALLID'); ?></strong><br/><?php echo JText::_($lang.'VK_WALLID_DESC'); ?>" for=""><?php echo JText::_($lang.'VK_WALLID'); ?></label>
 					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][vkwallid]" value="<?php echo $vkwallid; ?>" class="custom-wall" />
 				</li>
				<?php

				$url = "https://api.vkontakte.ru/method/groups.get?";
				
	   			$curl = curl_init();

				curl_setopt_array($curl, $coptions);
        		curl_setopt($curl, CURLOPT_URL, $url);
        		curl_setopt($curl, CURLOPT_POSTFIELDS, "access_token=".$vktoken."&uid=".$vkuser."&extended=1");

        		$result = curl_exec($curl);

        		if ($result === FALSE) { ?>
        			<li class="group-item">
        				<span class="error"><?php echo JText::_($lang.'ERROR_GROUPS').curl_error($curl); ?></span>
        			</li>
        		<?php } else {
  					$user_groups = json_decode($result);
  					unset($user_groups->response[0]);
        		}
				
				curl_close($curl);

				if (!empty($user_groups) && (count($user_groups->response) > 0))
				{
					$groups = "";
					$pages = "";					
					$events = "";

					foreach($user_groups->response as $postpage) {
						$postpage = (array) $postpage;
						
						if ($postpage["type"] == 'group') {
							$groups .= "<li class='group-item'><label class='group-label hasTooltip' title='<strong>".JText::_($lang.'POST_TO')."</strong><br/>".$postpage["name"]."'>".$postpage["name"]."</label><input type='checkbox' class='vk-checkbox' name='jform[params][".$this->fieldname."][vkwalls][]' value='-".$postpage["gid"]."'".(in_array('-'.$postpage["gid"], $vkwalls) ? " checked='checked'" : "")."></li>";
						}

						if ($postpage["type"] == 'page') {
							$pages .= "<li class='group-item'><label class='group-label hasTooltip' title='<strong>".JText::_($lang.'POST_TO')."</strong><br/>".$postpage["name"]."'>".$postpage["name"]."</label><input type='checkbox' class='vk-checkbox' name='jform[params][".$this->fieldname."][vkwalls][]' value='-".$postpage["gid"]."'".(in_array('-'.$postpage["gid"], $vkwalls) ? " checked='checked'" : "")."></li>";
						}
						
						if ($postpage["type"] == 'event') {
							$events .= "<li class='group-item'><label class='group-label hasTooltip' title='<strong>".JText::_($lang.'POST_TO')."</strong><br/>".$postpage["name"]."'>".$postpage["name"]."</label><input type='checkbox' class='vk-checkbox' name='jform[params][".$this->fieldname."][vkwalls][]' value='-".$postpage["gid"]."'".(in_array('-'.$postpage["gid"], $vkwalls) ? " checked='checked'" : "")."></li>";
						}
					} ?>
					<?php if (!empty($groups)) { ?>
						<li class="vk-params-subtitle"><?php echo JText::_($lang.'VK_GROUPS_WALLS'); ?></li>
						<?php echo $groups; ?>
					<?php } ?>
					<?php if (!empty($pages)) { ?>
						<li class="vk-params-subtitle"><?php echo JText::_($lang.'VK_PAGES_WALLS'); ?></li>
						<?php echo $pages; ?>
					<?php } ?>
					<?php if (!empty($events)) { ?>
						<li class="vk-params-subtitle"><?php echo JText::_($lang.'VK_EVENTS_WALLS'); ?></li>
						<?php echo $events; ?>
					<?php } ?>
				<?php } ?>
			<?php } ?>
		<?php } else { ?>
			<li style="margin-bottom: 0"><span class="vk-params-message"><?php echo JText::_($lang.'VK_ENTER_DATA'); ?></span></li>
		<?php } ?>
		</ul>
	</div>
<?php }
}
?>