<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');

class SocialCrosspostingModelJournal extends JModelList
{
	var $db;
	
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$this->db = JFactory::getDBO();
			
			$config['filter_fields'] = array(
				'id', 'article',
				'title', 'title',
				'network', 'network',
				'target', 'target',
				'status', 'status',				
				'date', 'date');
		}

		parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null)
	{
		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$status = $this->getUserStateFromRequest($this->context . '.filter.status', 'filter_status', '', 'string');
		$this->setState('filter.status', $status);

		parent::populateState('date', 'desc');
	}
	
	protected function getListQuery()
	{
		$query = $this->db->getQuery(true);
		$user = JFactory::getUser();

		$query->select($this->getState('list.select', '*'));
		$query->from('#__crossposting_journal');

		$state = $this->getState('filter.status');
		
		if (is_numeric($state)) $query->where('status = '.(int)$state);

		$search = $this->getState('filter.search');

		if (!empty($search)) {
			$search = $this->db->quote('%'.$this->db->escape($search, true).'%', false);
			$query->where('title LIKE '.$search.' OR source LIKE '.$search.' OR network LIKE '.$search.' OR target LIKE '.$search);
		}

		$query->order($this->db->escape($this->getState('list.ordering', 'date')).' '.$this->db->escape($this->getState('list.direction', 'DESC')));

		return $query;
	}
	
	public function publish($cid)
	{
		$this->db->setQuery("UPDATE #__crossposting_journal SET status = '1' WHERE id = ".$this->db->Quote($cid));
		$this->db->query();
	}
	
	public function unpublish($cid)
	{
		$this->db->setQuery("UPDATE #__crossposting_journal SET status = '0' WHERE id = ".$this->db->Quote($cid));
		$this->db->query();
	}
	
	public function remove($cid)
	{
		$this->db->setQuery("DELETE FROM #__crossposting_journal WHERE id = ".$this->db->Quote($cid));
		$this->db->query();
	}		
}

?>