<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class com_socialcrosspostingInstallerScript
{
	function install($parent)
	{
		$parent->getParent()->setRedirectURL('index.php?option=com_socialcrossposting');
	}
 
	function uninstall($parent)
	{
		echo '<p>'.JText::_('COM_SOCIALCROSSPOSTING_UNINSTALL_TEXT').'</p>';
	}
 
	function update($parent)
	{
		$lang = JFactory::getLanguage();
		$lang->load('com_socialcrossposting', JPATH_ADMINISTRATOR);
		
		$db = JFactory::getDBO();
		
		if (method_exists($parent, 'extension_root')) {
			$sqlfile = $parent->getPath('extension_root').'/sql/install.mysql.utf8.sql';
		} else {
			$sqlfile = $parent->getParent()->getPath('extension_root').'/sql/install.mysql.utf8.sql';
		}
		
		$buffer = file_get_contents($sqlfile);
		
		if ($buffer !== false)
		{
			jimport('joomla.installer.helper');
			$queries = JInstallerHelper::splitSql($buffer);
			
			if (count($queries) != 0)
			{
				foreach ($queries as $query)
				{
					$query = trim($query);
					
					if ($query != '' && $query{0} != '#')
					{
						$db->setQuery($query);
						
						try { $db->query(); }
						catch(Exception $e){}
					}
				}
			}
		}
		
		JFactory::getApplication()->enqueueMessage("<p>".JText::_('COM_SOCIALCROSSPOSTING_UPDATE_TEXT')."</p>");
		$parent->getParent()->setRedirectURL('index.php?option=com_socialcrossposting');
	}
 
	function preflight($type, $parent)
	{
		echo '<p>'.JText::_('COM_SOCIALCROSSPOSTING_PREFLIGHT_'.$type.'_TEXT').'</p>';
	}
 
	function postflight($type, $parent)
	{
		$db = JFactory::getDbo();
		
		$query = "SELECT conf_value FROM #__crossposting_settings WHERE conf_key = 'secret'";
		$db->setQuery($query);
		$result = $db->loadResult();
		
		if (empty($result))
		{
			$secret = $this->generateSecret(9);
		
			$query = "INSERT INTO #__crossposting_settings (`conf_key`, `conf_value`) VALUES ('secret', ".$db->Quote($secret).")";
			$db->setQuery($query);
			$db->query();
		}
	}
	
	public function generateSecret($length)
	{
		$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
		$chars_length = (strlen($chars) - 1);
		$secret = $chars{rand(0, $chars_length)};

		for ($i = 1; $i < $length; $i++)
		{
			$character = $chars{rand(0, $chars_length)};
			if ($character != $secret{$i - 1}) $secret .=  $character;
		}

		return $secret;
	}	
}

?>