<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class SocialCrosspostingModelPost extends JModelLegacy
{
	var $params, $vkparams, $fbparams, $lnparams, $facebook, $linkedin, $twitter, $coptions, $db, $lang;
	
	var $fbposted = array();
	var $vkposted = array();
	var $lnposted = array();

	public function __construct()
	{
		$this->db = JFactory::getDBO();
		$this->lang = "COM_SOCIALCROSSPOSTING_";
		$params = JComponentHelper::getParams('com_socialcrossposting');
		$this->params = $params->get("params");

    	$this->coptions = array(
    		CURLOPT_POST 			=> true,
			CURLOPT_RETURNTRANSFER 	=> true,
 			CURLOPT_HEADER			=> false,
  			CURLOPT_ENCODING		=> "",
    		CURLOPT_USERAGENT 		=> "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0");

		$this->vkparams = $this->params->vkparams;
		$this->fbparams = $this->params->fbparams;
		$this->lnparams = $this->params->lnparams;

		if ($this->fbparams->fbenable) {
			require_once(JPATH_SITE."/components/com_socialcrossposting/libraries/facebook/facebook.php");
			$appid = $this->fbparams->fbclientid;
			$secret = $this->fbparams->fbsecretkey;
			$this->facebook = new Facebook(array('appId'  => $appid, 'secret' => $secret, 'cookie' => true));
		}

		if ($this->params->twenable) {
			require_once (JPATH_SITE."/components/com_socialcrossposting/libraries/twitter/helper.php");
			$this->twitter = new tmhOAuth(array(
				'consumer_key' => $this->params->twconsumerkey,
				'consumer_secret' => $this->params->twconsumersecret,
				'user_token' => $this->params->twtoken,
				'user_secret' => $this->params->twtokensecret));
		}
		
		if ($this->lnparams->lnenable) {
			if(!extension_loaded('oauth')) {
				require_once(JPATH_SITE."/components/com_socialcrossposting/libraries/linkedin/OAuth.php");
				if (!class_exists('LinkedIn', false)) require_once (JPATH_SITE."/components/com_socialcrossposting/libraries/linkedin/linkedin.php");
			}
			
			$appkey = $this->lnparams->lnclientid;
			$appsecret = $this->lnparams->lnsecretkey;
			$token = $this->lnparams->lntoken;
			$secret = $this->lnparams->lnsecret;
			
			$this->linkedin = new LinkedIn(array('appKey' => $appkey, 'appSecret' => $appsecret, 'callbackUrl'  => NULL));
			$this->linkedin->setTokenAccess(array('oauth_token' => $token, 'oauth_token_secret' => $secret));
		}

		if ($this->params->ljenable) {
    		require_once(JPATH_SITE."/components/com_socialcrossposting/libraries/livejournal/helper.php");
			$this->livejournal = new IXR_Client("www.livejournal.com", "/interface/xmlrpc");
		}
				
		parent::__construct();
	}

	public function getArticles($category, $source)
	{
		$articles = array();
		$categories = array();
		$excluded = array();
      	$now = JFactory::getDate()->toSql();
		$where = "(introtext LIKE '%{crossposting}%' OR `fulltext` LIKE '%{crossposting}%')";
		
		if (isset($this->params->categories)) $categories = trim($this->params->categories);
		if (isset($this->params->articles)) $excluded = trim($this->params->articles);

		if (!empty($category) && $source == 'content') $where = "catid = ".$this->db->Quote($category);
		
		if (!empty($categories)) {
			if ($this->params->filter == "exclude")	$where .= " AND catid NOT IN (".$categories.")";
			elseif ($this->params->filter == "include")	$where .= " AND catid IN (".$categories.")";
		}

		if (!empty($excluded)) $where .= " AND id NOT IN (".$excluded.")";
		     	
		$query = "SELECT id, catid, title, introtext, `fulltext`, 'content' AS source FROM #__content WHERE ".$where." AND state = '1' AND UNIX_TIMESTAMP(publish_up) < UNIX_TIMESTAMP(".$this->db->Quote($now).")";
		$this->db->setQuery($query);
		$articles = $this->db->loadObjectList();
		
		if (!empty($articles)) {
			if (!class_exists('ContentHelperRoute')) require_once(JPATH_SITE.'/components/com_content/helpers/route.php');
			
			foreach ($articles as $key => $article)	{
				$articles[$key]->networks = new stdClass();
				
				if (isset($this->fbparams->fbenable)) $articles[$key]->networks->fbenable = $this->fbparams->fbenable;
				if (isset($this->params->twenable)) $articles[$key]->networks->twenable = $this->params->twenable;
				if (isset($this->vkparams->vkenable)) $articles[$key]->networks->vkenable = $this->vkparams->vkenable;
				if (isset($this->lnparams->lnenable)) $articles[$key]->networks->lnenable = $this->lnparams->lnenable;
				if (isset($this->params->ljenable)) $articles[$key]->networks->ljenable = $this->params->ljenable;
				
				$articles[$key]->link = ContentHelperRoute::getArticleRoute($article->id, $article->catid);
			}
		}
		
		return $articles;
	}

	public function updateArticle($article)
	{
		$this->db->setQuery("SELECT introtext, `fulltext` FROM #__content WHERE id = ".$this->db->Quote($article->id));
		$text = $this->db->loadObject();
		
		$introtext = str_replace("{crossposting}", "", $text->introtext);
		$fulltext = str_replace("{crossposting}", "", $text->fulltext);		
		
		$this->db->setQuery("UPDATE #__content SET introtext = ".$this->db->Quote($introtext).", `fulltext` = ".$this->db->Quote($fulltext)." WHERE id = ".$this->db->Quote($article->id));
		$this->db->query();
	}
	
	public function updateJournal($article, $network, $target, $status)
	{
		$this->db->setQuery("SELECT * FROM #__crossposting_journal WHERE article = ".$this->db->Quote($article->id)." AND source = ".$this->db->Quote($article->source)." AND network = ".$this->db->Quote($network)." AND target = ".$this->db->Quote($target));
		$entry = $this->db->loadObject();
		
		if ($entry && !$entry->status) {
			$this->db->setQuery("UPDATE #__crossposting_journal SET status = ".$this->db->Quote($status)." WHERE id = ".$this->db->Quote($entry->id));
			$this->db->query();
		} else {
			$this->db->setQuery("INSERT INTO #__crossposting_journal SET article = ".$this->db->Quote($article->id).", title = ".$this->db->Quote($article->title).", source = ".$this->db->Quote($article->source).", network = ".$this->db->Quote($network).", target = ".$this->db->Quote($target).", status = ".$this->db->Quote($status));
			$this->db->query();			
		}
	}
	
	public function checkJournal($article, $network, $target)
	{
		$this->db->setQuery("SELECT status FROM #__crossposting_journal WHERE article = ".$this->db->Quote($article->id)." AND source = ".$this->db->Quote($article->source)." AND network = ".$this->db->Quote($network)." AND target = ".$this->db->Quote($target));
		$status = $this->db->loadResult();
		return $status;
	}	
	
	public function crossPost($article)
	{
		$report	= array();
		$categories = array();
		$this->fbposted = array();
		$this->twposted = array();
		$this->vkposted = array();
		$this->lnposted = array();
		$this->ljposted = array();

		$report['id'] = $article->id;
		$report['title'] = $article->title;
		$report['source'] = $article->source;
		$report['error'] = false;
		$report['networks'] = array();
			
		$title = $article->title;

		$article->post = preg_replace("/{crossposting}/s", "", $article->introtext.$article->fulltext);
				
		$article = $this->parseURLs($article);

		if ($this->params->sef) {
			$app = JApplication::getInstance('site');
			$router = $app->getRouter();
			$uri = $router->build($article->link);
			$article->link = substr(JURI::root(), 0, -1).$uri->toString();
  		}		

		if (mb_strpos($article->link, "/administrator/")) $article->link = str_replace("/administrator/", "/", $article->link);
		
		// Facebook
				
		if ($this->fbparams->fbenable && $article->networks->fbenable) {
			$linkname = $this->params->fblinkname;
			$posttitle = $this->prepareText($title, "fbpretitle");
			$posttext = $this->prepareText($article->post, "fbprepost");
				
			if ($this->params->fblimit && ($this->params->fblimit < 251)) $postlimit = $this->params->fblimit;
			else $postlimit = 251;

			if (mb_strlen($posttext) > $postlimit) $posttext = mb_substr($posttext, 0, $postlimit, "UTF-8")."...";			

			foreach ($this->fbparams->fbwalls as $wall) {
				$token = $this->fbparams->fbtoken;
				$temp = explode("::", $wall);
				$name = $temp[0];
				$fbwall = $temp[1];
				$status = $this->checkJournal($article, 'facebook', $name);
			
				if (!$status) {
					if (empty($fbwall)) continue;

					if ((count($temp) > 2) && in_array("status".$temp[2], $this->fbparams->fbstatuses)) {
						$token = $this->fbparams->fbtokens[$temp[2]];
					}			
					
					$postresult = $this->FBpost("post", $fbwall, array(
						'name' => $linkname,
						'caption' => $posttitle,
						'message' => $posttext,
           				'link' => $article->link,
           				'description' => ' ',
           				'picture' => $article->picture,
           				'access_token' => $token));
				
					if (is_array($postresult) && isset($postresult['curl'])) {
						return $postresult;
					} elseif (isset($postresult['error'])) {
						$name = $postresult['name'];
						$code = $postresult['error']['code'];
						$message = $postresult['error']['message'];
						$report['error'] = true;
						$result['status'] = false;
						$result['post'] = "";
						$result['message'] = sprintf(JText::_($this->lang.'ERROR_FAILED'), $code, $message);
						$this->updateJournal($article, 'facebook', $name, '0');
					} else {
						$result['status'] = true;
						$result['post'] = explode("_", $postresult['id']);
						$result['message'] = JText::_($this->lang.'SUCCESS');
						$this->updateJournal($article, 'facebook', $name, '1');
					}
					
					$this->fbposted[] = array(
						'name' => $name,
						'status' => $result['status'],
						'post' => $result['post'][1],
						'message' => $result['message']);
				}
           	}
			
			if (!empty($this->fbposted)) {
				$report['networks'][] = array(
					'name' => 'Facebook',
					'walls' => $this->fbposted);
			}
		}

		// Twitter

		if ($this->params->twenable && $article->networks->twenable) {
			$twuser = $this->getTWUser();
			$name = $twuser->name;
			$status = $this->checkJournal($article, 'twitter', $name);
			
			if (!$status) {
				$shortURL = $this->tinyURL($article->link);
				$posttitle = $this->prepareText($title, "twpretitle");
				$posttext = $posttitle."  ".$this->prepareText($article->post, "twprepost");
				$postlimit = 136 - mb_strlen($shortURL);
				
				if ($this->params->twpicture && !empty($article->picture)) $postlimit = $postlimit - 23;
					
				if (mb_strlen($posttext) > $postlimit) $posttext = mb_substr($posttext, 0, $postlimit - 3, "UTF-8")."  ".$shortURL;
				
				$postresult = $this->TWpost(array(
       				'status' => $posttext,
       				'media[]' => $article->picture));

				if (is_array($postresult) && isset($postresult['curl'])) {
					return $postresult;
				} elseif ($postresult['code'] != '200') {
					$code = $postresult['code'];
					$response = json_decode($postresult['response']);
					$report['error'] = true;
					$result['status'] = false;
					$result['post'] = "";
					$result['message'] = sprintf(JText::_($this->lang.'ERROR_FAILED'), $code, $response->errors[0]->message);
					$this->updateJournal($article, 'twitter', $name, '0');
				} else {
					$response = json_decode($postresult['response']);
					$result['status'] = true;
					$result['post'] = $response->id;
					$result['message'] = JText::_($this->lang.'SUCCESS');
					$this->updateJournal($article, 'twitter', $name, '1');
				}

				$this->twposted[] = array(
					'name' => $name,
					'status' => $result['status'],
					'post' => $result['post'],
					'message' => $result['message']);
				
				if (!empty($this->twposted)) {
					$report['networks'][] = array(
						'name' => 'Twitter',
						'walls' => $this->twposted);
				}
			}
		}

		// VKontakte

		if ($this->vkparams->vkenable && $article->networks->vkenable) {
			$posttitle = $this->prepareText($title, "vkpretitle");
			$posttext = $this->prepareText($article->post, "vkprepost");			

			if ($this->params->vklimit && ($this->params->vklimit < 750)) $postlimit = $this->params->vklimit;
			else $postlimit = 750;

			if (mb_strlen($posttext) > $postlimit) $posttext = mb_substr($posttext, 0, $postlimit, "UTF-8")."...";

			if (!empty($this->vkparams->vkwallid)) $this->vkparams->vkwalls[] = $this->vkparams->vkwallid;

			foreach ($this->vkparams->vkwalls as $wall) {
				$group = $this->getVKGroup("groups.getById", $wall);
				$name = $group->name;
				$status = $this->checkJournal($article, 'vkontakte', $name);
			
				if (!$status) {
					$attachments = "";
					$postlink = "";
				
					if ($this->params->vkpicture && !empty($article->picture)) {
						$attachments = $this->VKphoto("photos.getWallUploadServer", $article->picture, array(
							'access_token' => $this->vkparams->vktoken,
							'gid' => abs($wall)));
					}
				
					if ($this->params->vkaddlink) {
						$postlink = $article->link;
						if (!empty($attachments)) $attachments .= ",".$postlink;
						else $attachments = $postlink;
					}
			
					$postresult = $this->VKpost("wall.post", array(
						'access_token' => $this->vkparams->vktoken,
						'owner_id' => $wall,
						'message' => $posttext,
						'from_group' => $this->params->vkgroup,
						'signed' => $this->params->vksigned,
						'friends_only' => $this->params->vkfriends,
						'attachments' => $attachments,
						'expires_in' => '0'));
				
					if (is_array($postresult) && isset($postresult['curl'])) {
						return $postresult;
					} elseif (!isset($postresult->response->post_id)) {
						$code = $postresult->error->error_code;
						$message = $postresult->error->error_msg;
						$report['error'] = true;
						$result['status'] = false;
						$result['post'] = "";
						$result['message'] = sprintf(JText::_($this->lang.'ERROR_FAILED'), $code, $message);
						$this->updateJournal($article, 'vkontakte', $name, '0');
					} else {
						$result['status'] = true;
						$result['post'] = $postresult->response->post_id;
						$result['message'] = JText::_($this->lang.'SUCCESS');
						$this->updateJournal($article, 'vkontakte', $name, '1');
					}
					
					$this->vkposted[] = array(
						'name' => $name,
						'status' => $result['status'],
						'post' => $result['post'],
						'message' => $result['message']);
				}
			}
			
			if (!empty($this->vkposted)) {
				$report['networks'][] = array(
					'name' => 'VKontakte',
					'walls' => $this->vkposted);
			}
		}
							
		// LinkedIn

		if ($this->lnparams->lnenable && $article->networks->lnenable)
		{
			$posttitle = $this->prepareText($title, "lnpretitle");
			$posttext = $this->prepareText($article->post, "lnprepost");
			$linkname = strip_tags($this->params->lnlinkname);
			$linkdesc = strip_tags($this->params->lnlinkdesc);
			$urltitle = (!empty($linkname) ? $linkname : $posttitle);
			$urltext = (!empty($linkdesc) ? $linkdesc : $posttext);
			
			if ($this->params->lnlimit && ($this->params->lnlimit < 650)) $postlimit = $this->params->lnlimit;
			else $postlimit = 650;
					
			if ($this->params->decode) {
				$urltitle = html_entity_decode(htmlspecialchars_decode($urltitle, ENT_QUOTES), ENT_QUOTES, 'UTF-8');
				$urltext = html_entity_decode(htmlspecialchars_decode($urltext, ENT_QUOTES), ENT_QUOTES, 'UTF-8');
			}

			if (mb_strlen($posttitle) > 200) $posttitle = mb_substr($posttitle, 0, 197, "UTF-8")."...";
			if (mb_strlen($posttext) > $postlimit) $posttext = mb_substr($posttext, 0, $postlimit, "UTF-8")."...";
			if (mb_strlen($urltitle) > 100) $urltitle = mb_substr($urltitle, 0, 197, "UTF-8")."...";
			if (mb_strlen($urltext) > 200) $urltext = mb_substr($urltext, 0, 253, "UTF-8")."...";
				
			$mywall = $this->getLNWall();

			foreach ($this->lnparams->lnwalls as $wall)	{
				$method = 'post';
				$content = array();
				$content['title'] = $posttitle;
				$content['comment'] = $posttext;

				if (preg_match("::", $wall)) {
					$temp = explode("::", $wall);
					$lnwall = $temp[0];
					$name = $temp[1];
				}

				$status = $this->checkJournal($article, 'linkedin', $name);
			
				if (!$status) {						
					if ($mywall == $lnwall)	{
						$method = 'share';

						if ($this->params->lnpicture) {
							$content['submitted-url'] = $article->link;
							$content['submitted-image-url'] = $article->picture;
							$content['description']	= $urltext;
							$name = JText::_($this->lang.'LN_MY_WALL');
						}
					} else {
						if ($this->params->lnpicture) {
							$content['submitted-url'] = $article->link;
							$content['submitted-image-url']	= $article->picture;
							$content['submitted-url-title']	= $urltitle;
							$content['description']	= $urltext;
						}
					}

					$postresult = $this->LNpost($method, $lnwall, $content);

					if (is_array($postresult) && isset($postresult['curl'])) {
						return $postresult;
					} elseif (isset($postresult["error"])) {
						$code = $postresult["status"];
						$report['error'] = true;
						$result['status'] = false;
						$result['post'] = "";
						$result['message'] = sprintf(JText::_($this->lang.'ERROR_FAILED'), $code, $postresult['error']);
						$this->updateJournal($article, 'linkedin', $name, '0');
					} else {
						$result['status'] = true;
						$result['post'] = "";
						$result['message'] = JText::_($this->lang.'SUCCESS');
						$this->updateJournal($article, 'linkedin', $name, '1');
					}
					
					$this->lnposted[] = array(
						'name' => $name,
						'status' => $result['status'],
						'post' => $result['post'],
						'message' => $result['message']);									
				}
			}
		
			if (!empty($this->lnposted)) {
				$report['networks'][] = array(
					'name' => 'LinkedIn',
					'walls' => $this->lnposted);
			}
		}
  				
		// LiveJournal

		if ($this->params->ljenable && $article->networks->ljenable)
		{
			$blogs = array();
			
			if ($this->params->ljblogs) $blogs = explode(",", $this->params->ljblogs);
			else $blogs[] = $this->params->ljusername;
			
			foreach ($blogs as $blog) {
				$blog = trim($blog);
				$status = $this->checkJournal($article, 'livejournal', $blog);
			
				if (!$status) {				
					$linkname = $this->params->ljlinkname;
					$posttitle = $this->prepareText($title, "ljpretitle");
					$posttext = $this->prepareText($article->post, "ljprepost");

					if ($this->params->ljlimit) $posttext = mb_substr($posttext, 0, $this->params->ljlimit, "UTF-8")."...";
					
					if (!empty($linkname)) $posttext = $posttext."<p><a href='".$article->link."'>".$linkname."</a></p>";

					$postresult = $this->LJpost($blog, $posttext, $posttitle, "");
	
					if (is_array($postresult) && isset($postresult['curl'])) {
						return $postresult;
					} elseif (isset($postresult['error'])) {
						$code = $postresult['error']['code'];
						$message = $postresult['error']['message'];
						$report['error'] = true;
						$result['status'] = false;
						$result['post'] = "";
						$result['message'] = sprintf(JText::_($this->lang.'ERROR_FAILED'), $code, $message);
						$this->updateJournal($article, 'livejournal', $blog, '0');
					} else {
						$result['status'] = true;
						$result['post'] = (isset($postresult['ditemid']) ? $postresult['ditemid'] : "");
						$result['message'] = JText::_($this->lang.'SUCCESS');
						$this->updateJournal($article, 'livejournal', $blog, '1');
					} 
				
					$this->ljposted[] = array(
						'name' => $blog,
						'status' => $result['status'],
						'post' => $result['post'],
						'message' => $result['message']);
				}
			}
			
			if (!empty($this->ljposted)) {				
				$report['networks'][] = array(
					'name' => 'LiveJournal',
					'walls' => $this->ljposted);
			}
		}			
	
		return $report;
	}
	
	public function parseURLs($article)
	{	
		preg_match_all("/<img [^>]*src=[\"|\']([^\"|\']+)/i", $article->post, $images);
		
		if (($this->params->fbpicture || $this->params->vkpicture || $this->params->lnpicture || $this->params->twpicture || $this->params->ljimages) && !empty($images[1]))	{
			foreach ($images[1] as $key => $src) {
				if (!preg_match("/http:\/\//i", $src)) {
					$imagereg = "/".str_replace("/", "\/", $src)."/s";							
					$article->post = preg_replace($imagereg, JUri::root().$src, $article->post);
					if ($key == 0) $article->picture = JUri::root().$src;
				} else {
					if ($key == 0) $article->picture = $src;
				}
			}
		} else {
			$article->post = preg_replace("/<img[^>]+\>/i", "", $article->post);
			$article->picture = "";
		}
		
		if ($this->params->fbcustompic) $article->picture = $this->params->fbcustompic;
		if ($this->params->lncustompic) $article->picture = $this->params->lncustompic;
		if ($this->params->vkcustompic) $article->picture = $this->params->vkcustompic;
		if ($this->params->twcustompic) $article->picture = $this->params->twcustompic;

		preg_match_all("/<a[^>]*href=\"([^\"]*)\"[^>]*>/i", $article->post, $urls);
		
		foreach ($urls[1] as $url) {
			if (!preg_match("/http:\/\//i", $url)) {
				$urlreg = "/href=[\"|\']".str_replace("|", "\|", str_replace("?", "\?", str_replace("/", "\/", $url)))."[\"|\']/s";
				$article->post = preg_replace($urlreg, 'href="'.JUri::root().$url.'"', $article->post);
			}
		}
		
		return $article;
	}

	public function prepareText($text, $param)
	{	
		$config = $this->params->{$param};
		$text = (!empty($config) ? $config."  " : "").$text;
		
		if ($param != "ljprepost") $text = $this->html2txt($text);

		if ($this->params->decode) {
			$text = html_entity_decode(htmlspecialchars_decode($text, ENT_QUOTES), ENT_QUOTES, 'UTF-8');
		}
		
		return $text;
	}
	
	public function html2txt($text)
	{
	    $text = preg_replace ('/<[^>]*>/', ' ', $text);
	    $text = str_replace("\r", '', $text);
    	$text = str_replace("\n", ' ', $text);
    	$text = str_replace("\t", ' ', $text);
	    $text = trim(preg_replace('/ {2,}/', ' ', $text));
   
    	return $text;
	} 	

	public function tinyURL($longURL)
	{
		$url = "http://is.gd/create.php?";

	   	$curl = curl_init();

		curl_setopt_array($curl, $this->coptions);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "format=simple&url=".$longURL);

        $result = curl_exec($curl);

        if ($result === FALSE) {	
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	curl_close($curl);			
  			return $result;
        }
	}

	public function FBpost($method, $wall, $params)
	{
		try {
			$result = $this->facebook->api("/".$wall."/feed/", $method, $params);
		} catch (FacebookApiException $e) {
   			$result = $e->getResult();
		}
		
		return $result;
	}

	public function getTWUser()
	{
		$this->twitter->request('GET', $this->twitter->url('1.1/account/verify_credentials'));
		$postresult = $this->twitter->response;
		return json_decode($postresult['response']);
	}
	
		public function TWpost($tweet)
	{
		if ($this->params->twpicture && !empty($tweet["media[]"])) {
			$method = "update_with_media";
   			copy($tweet["media[]"], dirname(__FILE__)."/temp.jpg");
   			$path = dirname(__FILE__)."/temp.jpg";
			$name  = basename($path);
	   		$tweet["media[]"] = "@{$path};type=image/jpeg;filename={$name}";
	   		unlink($path);
		} else {
			$method = "update";
		}
		
		$this->twitter->request('POST', $this->twitter->url('1.1/statuses/'.$method), $tweet, true, true);
		return $this->twitter->response;
	}

    public function VKphoto($method, $photo, array $params = array())
    {
		$url = 'https://api.vk.com/method/'.$method.'?';
    	$purl = parse_url($photo);
   		copy($photo, dirname(__FILE__)."/temp.jpg");
   		$photo = dirname(__FILE__)."/temp.jpg";
    	
        $curl = curl_init();

		curl_setopt_array($curl, $this->coptions);
		curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $params);

        $response = curl_exec($curl);
        
        if ($response === FALSE) {	
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	$result = json_decode($response);	
        }        

        curl_setopt($curl, CURLOPT_URL, $result->response->upload_url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: multipart/form-data"));
		curl_setopt($curl, CURLOPT_POSTFIELDS, array('photo' => "@".$photo));
        
		$response = curl_exec($curl);
        
        if ($response === FALSE) {	
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	$result = json_decode($response);	
        }
        
		curl_setopt($curl, CURLOPT_URL, 'https://api.vk.com/method/photos.saveWallPhoto?');
		curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			'access_token' => $params['access_token'],
           	'server' => $result->server,
           	'photo' => $result->photo,
           	'hash' => $result->hash,
           	'gid' => abs($params['gid'])));
            
        $response = curl_exec($curl);

        if ($response === FALSE) {	
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	$result = json_decode($response);	
        }
        		
		unlink($photo);

		return $result->response[0]->id;
    }

	public function getVKGroup($method, $wall)
	{	
		$url = 'https://api.vk.com/method/'.$method.'?';
	
	   	$curl = curl_init();

		curl_setopt_array($curl, $this->coptions);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "access_token=".$this->vkparams->vktoken."&gid=".abs($wall)."&fields=name");

        $response = curl_exec($curl);

        if ($response === FALSE) {
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	$result = json_decode($response);
        	curl_close($curl);
        	return $result->response[0];
        }
	}
	
	public function VKpost($method, array $params = array())
	{
		$url = 'https://api.vk.com/method/'.$method.'?';

	   	$curl = curl_init();

		curl_setopt_array($curl, $this->coptions);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($params));

        $response = curl_exec($curl);

        if ($response === FALSE) {	
        	$result['curl']['errno'] = curl_errno($curl);
        	$result['curl']['error'] = curl_error($curl);
        	curl_close($curl);
        	return $result;
        } else {
        	$result = json_decode($response);
        	curl_close($curl);
        	return $result;
        }
	}

	public function getLNWall()
	{	
		$query = LINKEDIN::_URL_API.'/v1/people/~:(id)?format=json';
   		$response = $this->linkedin->fetch('GET', $query);
   		$result = json_decode($response['linkedin']);
		return $result->id;
	}
		
	public function LNpost($method, $wall, $content)
	{
		try {
			if ($method == 'share') $result = $this->linkedin->share('new', $content);
			else $result = $this->linkedin->createPost($wall, $content['title'], $content['comment'], $content);
		} catch(Exception $e) {
			$result['error'] = $e->getMessage();
		}

		return $result;
	}
		
	public function LJpost($blog, $post, $subj, $tags)
	{
		$time_difference = $this->params->ljtimezone;

		if (!$this->livejournal->query('LJ.XMLRPC.getchallenge')) {
    		echo 'Error [' . $this->livejournal->getErrorCode().'] '.$this->livejournal->getErrorMessage();
		} else {
		    $response = $this->livejournal->getResponse();
    		$challenge = $response['challenge'];
        	$year = date("Y", (time() + ($time_difference * 3600)));
        	$month = date("m", (time() + ($time_difference * 3600)));
        	$day = date("d", (time() + ($time_difference * 3600)));
        	$hour = date("H", (time() + ($time_difference * 3600)));
        	$minute = date("i", (time() +($time_difference * 3600)));
        	    		
	    	$args = array();
    		
    		$args['username'] = $this->params->ljusername;
    		$args['auth_method'] = "challenge";
    		$args['auth_challenge'] = $challenge;
    		$args['auth_response'] = md5($challenge.md5($this->params->ljpassword));
    		$args['ver'] = "1";
    		$args['event'] = $post;
    		$args['subject'] = $subj;
    		$args['year'] = $year;
    		$args['mon'] = $month;
    		$args['day'] = $day;
    		$args['hour'] = $hour;
    		$args['min'] = $minute;
        	$args['usejournal'] = $blog;
	    	$args['props'] = array('opt_preformatted' => true, 'opt_backdated' => false, 'taglist' => $tags);
			$args['security'] = "public";
    		
    		$method = "LJ.XMLRPC.postevent";

    		if (!$this->livejournal->query($method, $args)) {
				$response['error']['code'] = $this->livejournal->getErrorCode();
				$response['error']['message'] = $this->livejournal->getErrorMessage();
    		} else {
				$response = $this->livejournal->getResponse();
    		}
 		}
 		
 		return $response;
	}
	
	public function pruneJournal()
	{
		$period = time() - $this->params->autoprune * 24 * 60 * 60;
		$this->db->setQuery("DELETE FROM #__crossposting_journal WHERE UNIX_TIMESTAMP(date) < ".$period."");
		$this->db->query();
		return $this->db->getAffectedRows();
	}
}

?>