<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011 The Krotek. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://www.thekrotek.com
# Support: support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined("_JEXEC") or die("Restricted access");

jimport('joomla.html.html');
jimport('joomla.form.formfield');

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::base().'components/com_socialcrossposting/assets/css/style.css');

class JFormFieldFBParams extends JFormField
{
	protected $type = "FBParams";

	protected function getInput()
	{
		$plg = "COM_SOCIALCROSSPOSTING_";

		$comparams = JComponentHelper::getParams('com_socialcrossposting');
		$params = $comparams->get("params");
		
		if (isset($params->{$this->fieldname})) $fbparams = $params->{$this->fieldname};
		else $fbparams = "";
		
		if (!class_exists('Facebook', false)) {
			require_once (JPATH_SITE.'/components/com_socialcrossposting/libraries/facebook/facebook.php');
		}

		if ($fbparams) {		
			$fbclientid = $fbparams->fbclientid;
			$fbsecretkey = $fbparams->fbsecretkey;

			if (isset($fbparams->fbtoken)) $fbtoken = $fbparams->fbtoken;
			else $fbtoken = '';
			if (isset($fbparams->fbuser)) $fbuser = $fbparams->fbuser;
			else $fbuser = '';
			if (isset($fbparams->fbwallid)) $fbwallid = $fbparams->fbwallid;
			else $fbwallid = '';
			if (isset($fbparams->fbwalls)) $fbwalls = (array)$fbparams->fbwalls;
			else $fbwalls = array();
			if (isset($fbparams->fbstatuses)) $fbstatuses = (array)$fbparams->fbstatuses;
			else $fbstatuses = array();
			if (isset($fbparams->fbtokens)) $fbtokens = (array)$fbparams->fbtokens;
			else $fbtokens = array();
		} else {
			$fbclientid = "";
			$fbsecretkey = "";
			$fbtoken = "";
			$fbuser = "";
			$fbwallid = "";
			$fbwalls = array();
			$fbstatuses = array();
			$fbtokens = array();
		} ?>
		<div id="fb-params">
			<ul>
				<li>
					<div class="control-label">
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_ENABLE'); ?></strong><br/><?php echo JText::_($plg.'FB_ENABLE_DESC'); ?>">
							<?php echo JText::_($plg.'FB_ENABLE'); ?>
						</label>
					</div>
					<div class="controls">
					<fieldset id="jform_params_fbenable" class="radio btn-group">
						<input id="jform_params_fbenable0" type="radio" <?php if ($fbparams->fbenable) echo 'checked="checked"'; ?> value="1" name="jform[params][<?php echo $this->fieldname; ?>][fbenable]">
						<label for="jform_params_fbenable0" class="btn"><?php echo JText::_('JYES'); ?></label>
						<input id="jform_params_fbenable1" type="radio" <?php if (!$fbparams->fbenable) echo 'checked="checked"'; ?> value="0" name="jform[params][<?php echo $this->fieldname; ?>][fbenable]">
						<label for="jform_params_fbenable1" class="btn"><?php echo JText::_('JNO'); ?></label>
					</fieldset>
					</div>
				</li>			
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_CLIENDTID'); ?></strong><br/><?php echo JText::_($plg.'FB_CLIENDID_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_CLIENDTID'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][fbclientid]" value="<?php echo $fbclientid; ?>" />
				</li>
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_SECRETKEY'); ?></strong><br/><?php echo JText::_($plg.'FB_SECRETKEY_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_SECRETKEY'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][fbsecretkey]" value="<?php echo $fbsecretkey; ?>" />
				</li>
				<?php
				if (!empty($fbclientid) && !empty($fbsecretkey)) {
					$facebook = new Facebook(array('appId' => $fbclientid, 'secret' => $fbsecretkey));
			
					if (!empty($fbtoken)) $facebook->setAccessToken($fbtoken);

					$user = $facebook->getUser();

					if ($user) {
						try {
 							$user_profile = $facebook->api('/me');
 							$facebook->setExtendedAccessToken();
   							$fb_access_token = $facebook->getAccessToken();
   						} catch (FacebookApiException $e) {
   				    		error_log($e);
							$user = null;
						}
					}

					$values = array();
					$scope = array();

					$scope[] = 'read_stream';
					$scope[] = 'manage_pages';
					$scope[] = 'publish_stream';
					$scope[] = 'user_groups';
					$scope[] = 'offline_access';			

					$values['scope'] = $scope;
					$loginUrl = $facebook->getLoginUrl($values);

					$code = JRequest::getVar('code');

					if (!empty($code)) { ?>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_TOKEN'); ?></strong><br/><?php echo JText::_($plg.'FB_TOKEN_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_TOKEN'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][fbtoken]" value="<?php echo $fb_access_token; ?>" />
					</li>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_USER_ID'); ?></strong><br/><?php echo JText::_($plg.'FB_USER_ID_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_USER_ID'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][fbuser]" value="<?php echo $user; ?>">
					</li>
					<li style="margin-bottom: 0">
						<span class="fb-params-message"><?php echo JText::_($plg.'FB_SAVE_FIRST'); ?></span>
					</li>
					<?php } else if (!empty($fbtoken)) { ?>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_TOKEN'); ?></strong><br/><?php echo JText::_($plg.'FB_TOKEN_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_TOKEN'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][fbtoken]" value="<?php echo $fbtoken; ?>" />
					</li>
					<li>
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_USER_ID'); ?></strong><br/><?php echo JText::_($plg.'FB_USER_ID_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_USER_ID'); ?></label>
						<input type="text" name="jform[params][<?php echo $this->fieldname ?>][fbuser]" value="<?php echo $fbuser; ?>">
					</li>
					<?php } else { ?>
					<li style="margin-bottom: 0">
						<span class="fb-params-message">
							<a href="<?php echo $loginUrl; ?>" title="<?php echo JText::_($plg.'FB_LOGIN'); ?>">
								<?php echo JText::_($plg.'FB_LOGIN'); ?>
							</a>
						</span>
					</li>
					<?php } ?>
					<?php if (!empty($fbtoken) && !empty($fbuser)) { ?>
					<li class="fb-params-title"><?php echo JText::_($plg.'FB_CHOOSE_WALLS'); ?></li>
					<li class="group-item">
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'POST_TO'); ?></strong><br/><?php echo JText::_($plg.'FB_MY_WALL'); ?>"><?php echo JText::_($plg.'FB_MY_WALL'); ?></label>
						<input type='checkbox' name='jform[params][<?php echo $this->fieldname; ?>][fbwalls][]' value="<?php echo JText::_($plg.'FB_MY_WALL').'::'.$fbuser; ?>"<?php if (in_array(JText::_($plg.'FB_MY_WALL').'::'.$fbuser, $fbwalls)) echo ' checked="checked"'; ?> />
					</li>
 					<li class='group-item'>
 						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'FB_WALLID'); ?></strong><br/><?php echo JText::_($plg.'FB_WALLID_DESC'); ?>" for=""><?php echo JText::_($plg.'FB_WALLID'); ?></label>
 						<input type='checkbox' name='jform[params][<?php echo $this->fieldname; ?>][fbwalls][]' value="<?php echo JText::_($plg.'FB_WALLID').'::'.$fbwallid; ?>"<?php if (in_array(JText::_($plg.'FB_WALLID').'::'.$fbwallid, $fbwalls)) echo ' checked="checked"'; ?> />
 						<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][fbwallid]" value="<?php echo $fbwallid; ?>" class="custom-wall" />
 					</li>
					<?php
					try {
        				$user_groups = $facebook->api('/'.$fbuser.'/groups/', 'GET', array('fbtoken=' => $fbtoken));
					} catch (FacebookApiException $e) {
						error_log($e);
						$page = null;
					}

					if ($user_groups && $user_groups['data'] && is_array($user_groups['data']) && count($user_groups['data']) > 0) { ?>
						<li class="fb-params-subtitle"><?php echo JText::_($plg.'FB_GROUPS_WALLS'); ?></li>
						<?php foreach($user_groups['data'] as $postpage) { ?>
						<li class="group-item">
							<label class="group-label hasTooltip" title="<strong><?php echo JText::_($plg.'POST_TO'); ?></strong><br/><?php echo $postpage['name']; ?>"><?php echo $postpage['name']; ?></label>
							<input type="checkbox" name="jform[params][<?php echo $this->fieldname; ?>][fbwalls][]" value="<?php echo $postpage['name'].'::'.$postpage['id']; ?>" <?php if (in_array($postpage['name'].'::'.$postpage['id'], $fbwalls)) { ?> checked = "checked" <?php } ?>>
						</li>
					<?php } ?>
				<?php } ?>
				<?php 
				try {
					$page = $facebook->api('/'.$fbuser.'/accounts/', array('fbtoken' => $fbtoken));
				} catch (FacebookApiException $e) {
					error_log($e);
					$page = null;
				}

				if ($page && $page['data'] && is_array($page['data']) && count($page['data']) > 0) {
					$pageswalls = "";
					
					foreach($page['data'] as $key => $postpage) {
						if ($postpage['category'] != 'Application') {
							$pageswalls .= "<li class='group-item'>";
							$pageswalls .= "<label class='group-label hasTooltip' title='<strong>".JText::_($plg.'POST_TO')."</strong><br/>".$postpage['name']."'>".$postpage['name']."</label>";
							$pageswalls .= "<input type='checkbox' id='page".$key."' onclick='checkStatus(".$key.")' name='jform[params][".$this->fieldname."][fbwalls][]' value='".$postpage['name']."::".$postpage['id']."::".$key."'".(in_array($postpage['name']."::".$postpage['id']."::".$key, $fbwalls) ? " checked='checked'" : "").">";
							$pageswalls .= "<input type='checkbox' id='status".$key."' name='jform[params][".$this->fieldname."][fbstatuses][]' value='status".$key."'".(in_array("status".$key, $fbstatuses) ? " checked='checked'" : "").(!in_array($postpage['name']."::".$postpage['id']."::".$key, $fbwalls) ? " disabled" : "").">";
							$pageswalls .= "<label class='hasTooltip fb-params-as-status' title='<strong>".JText::_($plg.'FB_PAGE_STATUS')."</strong></br/>".JText::_($plg.'FB_PAGE_STATUS_DESC') ."'>".JText::_($plg.'FB_PAGE_STATUS')."</label>";
							$pageswalls .= "<input type='hidden' name='jform[params][".$this->fieldname."][fbtokens][]' value='".$postpage['access_token']."'>";
							$pageswalls .= "</li>";
						}
					}

					if (!empty($pageswalls)) { ?>
						<script type="text/javascript">

						function checkStatus(id)
						{
							if (document.getElementById("page" + id).checked && document.getElementById("status" + id).disabled) {
								document.getElementById("status" + id).disabled = false;
							} else {
								document.getElementById("status" + id).disabled = true;
								
								if (document.getElementById("status" + id).checked == true) {
									document.getElementById("status" + id).checked = false;
								}
							}
						}
							
						</script>
						<li class='fb-params-subtitle'><?php echo JText::_($plg.'FB_PAGES_WALLS'); ?></li>
						<?php echo $pageswalls; ?>
					<?php } ?>
				<?php } ?>
			<?php } ?>
		<?php } else { ?>
		<li style="margin-bottom: 0"><span class="fb-params-message"><?php echo JText::_($plg.'FB_ENTER_DATA'); ?></span></li>
		<?php } ?>
		</ul>
	</div>
<?php }
}
?>