<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 The Krotek. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://www.thekrotek.com
# Support: support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined("_JEXEC") or die("Restricted access");

jimport('joomla.html.html');
jimport('joomla.form.formfield');

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::base().'components/com_socialcrossposting/assets/css/style.css');

class JFormFieldLNParams extends JFormField
{
	protected $type = "LNParams";

	protected function getInput()
	{
		$plg = "COM_SOCIALCROSSPOSTING_";

		$comparams = JComponentHelper::getParams('com_socialcrossposting');
		$params = $comparams->get("params");

		if (isset($params->{$this->fieldname})) $lnparams = $params->{$this->fieldname};
		else $lnparams = "";	

		if(!extension_loaded('oauth')) {
			require_once (JPATH_SITE.'/components/com_socialcrossposting/libraries/linkedin/OAuth.php');
	
			if (!class_exists('LinkedIn', false)) {
				require_once (JPATH_SITE.'/components/com_socialcrossposting/libraries/linkedin/linkedin.php');
			}
		} else {
			if (JFactory::getApplication()->isAdmin())
    		{
    			if ($lnparams->lnenable) {    
      				JFactory::getApplication()->enqueueMessage('LinkedIn library not compatible with installed PECL OAuth extension. Please disable it to use the LinkedIn.', 'notice');
      			}
    		}
		}

		if ($lnparams) {
			$lnclientid = $lnparams->lnclientid;
			$lnsecretkey = $lnparams->lnsecretkey;
			
			if (isset($lnparams->lntoken)) $lntoken = $lnparams->lntoken;
			else $lntoken = '';
			if (isset($lnparams->lnsecret)) $lnsecret = $lnparams->lnsecret;
			else $lnsecret = '';
			if (isset($lnparams->lnwalls)) $lnwalls = (array) $lnparams->lnwalls;
			else $lnwalls = array();
		} else {
			$lnclientid = "";
			$lnsecretkey = "";
			$lntoken = "";
			$lnsecret = "";
			$vkwalls = array();
		}			
		?>
		<div id="ln-params">
			<ul>
				<li>
					<div class="control-label">
						<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_ENABLE'); ?></strong><br/><?php echo JText::_($plg.'LN_ENABLE_DESC'); ?>">
							<?php echo JText::_($plg.'LN_ENABLE'); ?>
						</label>
					</div>
					<div class="controls">
					<fieldset id="jform_params_lnenable" class="radio btn-group">
						<input id="jform_params_lnenable0" type="radio" <?php if ($lnparams->lnenable) echo 'checked="checked"'; ?> value="1" name="jform[params][<?php echo $this->fieldname; ?>][lnenable]">
						<label for="jform_params_lnenable0" class="btn"><?php echo JText::_('JYES'); ?></label>
						<input id="jform_params_lnenable1" type="radio" <?php if (!$lnparams->lnenable) echo 'checked="checked"'; ?> value="0" name="jform[params][<?php echo $this->fieldname; ?>][lnenable]">
						<label for="jform_params_lnenable1" class="btn"><?php echo JText::_('JNO'); ?></label>
					</fieldset>
					</div>
				</li>			
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_CLIENDTID'); ?></strong><br/><?php echo JText::_($plg.'LN_CLIENDID_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_CLIENDTID'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][lnclientid]" value="<?php echo $lnclientid; ?>" />
				</li>
				<li>
					<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_SECRETKEY'); ?></strong><br/><?php echo JText::_($plg.'LN_SECRETKEY_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_SECRETKEY'); ?></label>
					<input type="text" name="jform[params][<?php echo $this->fieldname; ?>][lnsecretkey]" value="<?php echo $lnsecretkey; ?>" />
				</li>
				<?php
				if (!empty($lnclientid) && !empty($lnsecretkey)) {
		    		$protocol = strpos(strtolower($_SERVER['SERVER_PROTOCOL']), 'https') === FALSE ? 'http' : 'https';
    				$host = $_SERVER['HTTP_HOST'];
    				$uri = $_SERVER['REQUEST_URI'];
					$url = $protocol."://".$host.$uri;

					if (empty($lntoken)) {
						if (class_exists('LinkedIn', false)) {
							$access = array();

							$linkedin = new LinkedIn(array(	'appKey' => $lnclientid,
								'appSecret' => $lnsecretkey,
								'callbackUrl'  => $url)); 

	      					if(!isset($_GET['oauth_verifier'])) {
								$response = $linkedin->retrieveTokenRequest();

    	   						if ($response['success'] === TRUE) {
        							$_SESSION['oauth']['linkedin']['request'] = $response['linkedin'];
			        				$loginURL = LINKEDIN::_URL_AUTH.$response['linkedin']['oauth_token'];
    	   						} else {
       								JFactory::getApplication()->enqueueMessage(JText::_($plg.'ERROR_LN_RTOKEN'), 'notice');
	       						}
							} else {
	       						$response = $linkedin->retrieveTokenAccess($_SESSION['oauth']['linkedin']['request']['oauth_token'], $_SESSION['oauth']['linkedin']['request']['oauth_token_secret'], $_GET['oauth_verifier']);

	        					if($response['success'] === TRUE) {
			        				$access = $response['linkedin'];
        						} else {
			        				JFactory::getApplication()->enqueueMessage(JText::_($plg.'ERROR_LN_ATOKEN'), 'notice');
        						}
      						}

							if (!empty($access)) { ?>
							<li>
								<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_TOKEN'); ?></strong><br/><?php echo JText::_($plg.'LN_TOKEN_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_TOKEN'); ?></label>
								<input type="text" name="jform[params][<?php echo $this->fieldname ?>][lntoken]" value="<?php echo $access['oauth_token']; ?>" />
							</li>
							<li>
								<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_TOKEN_SECRET'); ?></strong><br/><?php echo JText::_($plg.'LN_TOKEN_SECRET_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_TOKEN_SECRET'); ?></label>
								<input type="text" name="jform[params][<?php echo $this->fieldname ?>][lnsecret]" value="<?php echo $access['oauth_token_secret']; ?>">
							</li>				
							<li style="margin-bottom: 0">
								<span class="ln-params-message"><?php echo JText::_($plg.'LN_SAVE_FIRST'); ?></span>
							</li>
							<?php } else { ?>
							<li style="margin-bottom: 0">
								<span class="ln-params-message">
									<a href="<?php echo $loginURL; ?>" title="<?php  echo JText::_($plg.'LN_LOGIN'); ?>">
										<?php echo JText::_($plg.'LN_LOGIN'); ?>
									</a>
								</span>
							</li>
							<?php } ?>
						<?php } ?>
					<?php } else { ?>
					<?php if (class_exists('LinkedIn', false)) {
						$linkedin = new LinkedIn(array(	'appKey' => $lnclientid,
							'appSecret' => $lnsecretkey,
							'callbackUrl'  => $url));
						
							$linkedin->setTokenAccess(array('oauth_token' => $lntoken, 'oauth_token_secret' => $lnsecret)); ?>
						<li>
							<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_TOKEN'); ?></strong><br/><?php echo JText::_($plg.'LN_TOKEN_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_TOKEN'); ?></label>
							<input type="text" name="jform[params][<?php echo $this->fieldname ?>][lntoken]" value="<?php echo $lntoken; ?>" />
						</li>
						<li>
							<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'LN_TOKEN_SECRET'); ?></strong><br/><?php echo JText::_($plg.'LN_TOKEN_SECRET_DESC'); ?>" for=""><?php echo JText::_($plg.'LN_TOKEN_SECRET'); ?></label>
							<input type="text" name="jform[params][<?php echo $this->fieldname ?>][lnsecret]" value="<?php echo $lnsecret; ?>">
						</li>
						<li class='ln-params-title'><?php echo JText::_($plg.'LN_CHOOSE_WALLS'); ?></li>
						<?php
						$query = LINKEDIN::_URL_API.'/v1/people/~:(id)?format=json';
    					$response = $linkedin->fetch('GET', $query);
    					$result = json_decode($response['linkedin']); ?>
						<li class='group-item'>
							<label class="hasTooltip" title="<strong><?php echo JText::_($plg.'POST_TO'); ?></strong><br/><?php echo JText::_($plg.'LN_MY_WALL'); ?>"><?php echo JText::_($plg.'LN_MY_WALL'); ?></label>
							<input type='checkbox' name='jform[params][<?php echo $this->fieldname; ?>][lnwalls][]' value='<?php echo $result->id; ?>'<?php if (in_array($result->id, $lnwalls)) echo " checked='checked'"; ?> >
						</li>
						<?php
						$query = LINKEDIN::_URL_API.'/v1/people/~/group-memberships:(group:(id,name))?format=json';
    					$response = $linkedin->fetch('GET', $query);
    					$result = json_decode($response['linkedin']);
 
 						if (isset($result->status)) { ?>
 						<li class='group-item'>
 							<span class="error"><?php echo JText::_($plg.'ERROR_GROUPS').$result->message; ?></span>
 						</li>
 						<?php } else {
 		    				$groups = "";
    			
    						foreach ($result->values as $postpage) {
    							$postpage = (array) $postpage->group;
    						
								$groups .= "<li class='group-item'><label class='group-label hasTooltip' title='<strong>".JText::_($plg.'POST_TO')."</strong><br/>".$postpage["name"]."'>".$postpage["name"]."</label><input type='checkbox' class='ln-checkbox' name='jform[params][".$this->fieldname."][lnwalls][]' value='".$postpage["id"]."::".$postpage["name"]."'".(in_array($postpage["id"]."::".$postpage["name"], $lnwalls) ? " checked='checked'" : "")."></li>";
	    					}
    			
							if (!empty($groups)) { ?>
								<li class="ln-params-subtitle"><?php echo JText::_($plg.'LN_GROUPS_WALLS'); ?></li>
								<?php echo $groups; ?>
							<?php } ?>
						<?php } ?>
					<?php } ?>
				<?php } ?>
			<?php } else { ?>
				<li style="margin-bottom: 0"><span class="ln-params-message"><?php echo JText::_($plg.'LN_ENTER_DATA'); ?></span></li>
			<?php } ?>
			</ul>
		</div>
<?php }
}
?>