<?php
/*------------------------------------------------------------------------
# Smart Shoutbox
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('The way is shut!');

JHtml::_('behavior.tooltip');

JToolBarHelper::title(JText::_('COM_SOCIALCROSSPOSTING_JOURNAL'), 'generic.png');
JToolBarHelper::preferences('com_socialcrossposting');

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base().'components/com_socialcrossposting/assets/css/style.css');

$user = JFactory::getUser();
$order	= $this->escape($this->state->get('list.ordering'));
$dirn	= $this->escape($this->state->get('list.direction'));
?>
<script type="text/javascript">
Joomla.orderTable = function()
{
	table = document.getElementById("sortTable");
	direction = document.getElementById("directionTable");
	order = table.options[table.selectedIndex].value;

	if (order != '<?php echo $order; ?>') {
		dirn = 'asc';
	} else {
		dirn = direction.options[direction.selectedIndex].value;
	}

	Joomla.tableOrdering(order, dirn, '');
}
</script>
<div id="journal">
<form action="<?php echo JRoute::_('index.php?option=com_socialcrossposting&view=journal'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar)) : ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
		<?php if (!version_compare(JVERSION, '3.0', 'ge')) { ?>
		<fieldset id="filter-bar">
		<? } else { ?>
		<div id="filter-bar" class="btn-toolbar">
		<? } ?>
			<div class="filter-search btn-group pull-left">
				<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" class="hasTooltip" title="<?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_SEARCH'); ?>" />
			</div>
			<div class="btn-group pull-left fltlft">
				<button type="submit" class="btn" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><span class="icon-search"><?php if (!version_compare(JVERSION, '3.0', 'ge')) { echo JText::_('JSEARCH_FILTER_SUBMIT'); } ?></span></button>
				<button type="button" class="btn" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.id('filter_search').value=''; this.form.submit();"><span class="icon-remove"><?php if (!version_compare(JVERSION, '3.0', 'ge')) { echo JText::_('JSEARCH_FILTER_CLEAR'); } ?></span></button>
			</div>
			<div class="btn-group pull-right fltrt">
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>	
			<div class="btn-group pull-right fltrt">
				<select name="directionTable" id="directionTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_ORDERING');?></option>
					<option value="asc" <?php if ($dirn == 'asc') echo 'selected="selected"'; ?>><?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_ORDERING_ASC');?></option>
					<option value="desc" <?php if ($dirn == 'desc') echo 'selected="selected"'; ?>><?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_ORDERING_DESC');?></option>
				</select>
			</div>
			<div class="btn-group pull-right fltrt">
				<select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">
					<option value=""><?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_SORTBY');?></option>
					<?php echo $this->sortfields; ?>
				</select>
			</div>	
			<div class="btn-group pull-right fltrt">
				<select name="filter_status" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_SELECT_STATUS'); ?></option>
					<?php echo $this->statuses; ?>
				</select>
			</div>
		<?php if (!version_compare(JVERSION, '3.0', 'ge')) { ?>
		</fieldset>
		<? } else { ?>
		</div>
		<? } ?>				
		<div class="clearfix clr"> </div>
		<?php if (empty($this->items)) { ?>
			<div class="alert alert-no-items">
				<?php echo JText::_('COM_SOCIALCROSSPOSTING_JOURNAL_NORESULTS'); ?>
			</div>
		<?php } else { ?>
			<table class="table table-striped adminlist">
				<thead>
					<tr>
						<th width="1%">
							<?php if (version_compare(JVERSION, '3.0', 'ge')) { ?>
							<?php echo JHtml::_('grid.checkall'); ?>
							<?php } else { ?>
							<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
							<?php } ?>
						</th>
						<th width="1%" class="nowrap center">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_STATUS', 'status', $dirn, $order); ?>
						</th>				
						<th class="title">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_TITLE', 'title', $dirn, $order); ?>
						</th>
						<th width="10%" class="center">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_SOURCE', 'source', $dirn, $order); ?>
						</th>				
						<th width="5%" class="center">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_NETWORK', 'network', $dirn, $order); ?>
						</th>
						<th width="20%" class="center">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_TARGET', 'target', $dirn, $order); ?>
						</th>
						<th width="10%" class="nowrap center">
							<?php echo JHtml::_('grid.sort', 'COM_SOCIALCROSSPOSTING_JOURNAL_DATE', 'date', $dirn, $order); ?>
						</th>
						<th width="1%" class="center">
							<?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'id', $dirn, $order); ?>
						</th>				
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="8">
							<?php echo $this->pagination->getListFooter(); ?>
						</td>
					</tr>
				</tfoot>
				<tbody>
				<?php foreach ($this->items as $key => $item) { ?>
					<tr class="row<?php echo $key % 2; ?>">
						<td class="center"><?php echo JHtml::_('grid.id', $key, $item->id); ?></td>						
						<td class="center"><?php echo JHtml::_('grid.published', $item->status, $key); ?></td>
						<td><?php echo $this->escape($item->title); ?></td>
						<td class="center"><?php echo ucfirst($this->escape($item->source)); ?></td>
						<td class="center"><?php echo ucfirst($this->escape($item->network)); ?></td>
						<td class="center"><?php echo $this->escape($item->target); ?></td>
						<td class="center"><?php echo JHtml::_('date', $item->date, JText::_('DATE_FORMAT_LC')); ?></td>
						<td class="center"><?php echo (int)$item->id; ?></td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
		<?php } ?>
		<div>
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="filter_order" value="<?php echo $order; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $dirn; ?>" />
			<?php echo JHtml::_('form.token'); ?>
		</div>
	</div>
</form>
</div>