<?php
/*------------------------------------------------------------------------
# Smart Shoutbox
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('The way is shut!');

JToolBarHelper::title(JText::_('COM_SOCIALCROSSPOSTING'), 'generic.png');
JToolBarHelper::preferences('com_socialcrossposting');

$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base().'components/com_socialcrossposting/assets/css/style.css');

$controller = new SocialCrosspostingController();

$config = $controller->getConfig();

$cron = JURI::root().'index.php?option=com_socialcrossposting&task=crosspost&secret='.$config['secret'];
$categories = JURI::root().'index.php?option=com_socialcrossposting&task=crosspost&category=id&source=name&secret='.$config['secret'];

?>
<form action="<?php echo JRoute::_('index.php?option=com_socialcrossposting&view=journal'); ?>" method="post" name="adminForm" id="adminForm">
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>
<div id="crossposting">
	<div class="crossposting-logo">
		<a href="http://thekrotek.com/joomla-extensions/social-crossposting" target="_blank" title="Visit extension's page">
			<img src="<?php echo JURI::base(); ?>/components/com_socialcrossposting/assets/images/logo.png">
		</a>
	</div>	
	<div class="crossposting-description">
		<h3><?php echo JText::_('COM_SOCIALCROSSPOSTING_DESCRIPTION_TITLE'); ?></h3>
		<p><?php echo sprintf(JText::_('COM_SOCIALCROSSPOSTING_DESCRIPTION_TEXT')); ?></p>
	</div>
	<div class="crossposting-usage">
		<h3><?php echo JText::_('COM_SOCIALCROSSPOSTING_USAGE_TITLE'); ?></h3>
		<p><?php echo sprintf(JText::_('COM_SOCIALCROSSPOSTING_USAGE_TEXT')); ?></p>
		<p class="crossposting-warning"><?php echo JText::_('COM_SOCIALCROSSPOSTING_WARNING'); ?></p>
	</div>
	<div class="crossposting-cron">
		<h3><?php echo JText::_('COM_SOCIALCROSSPOSTING_CRON_TITLE'); ?></h3>
		<p><?php echo sprintf(JText::_('COM_SOCIALCROSSPOSTING_CRON_TEXT'), $cron, $config['secret']); ?></p>
	</div>
	<div class="crossposting-bulk">
		<h3><?php echo JText::_('COM_SOCIALCROSSPOSTING_CATEGORIES_TITLE'); ?></h3>
		<p><?php echo sprintf(JText::_('COM_SOCIALCROSSPOSTING_CATEGORIES_TEXT'), $categories); ?></p>
	</div>
	<div class="crossposting-footnone">
		<p><?php echo sprintf(JText::_('COM_SOCIALCROSSPOSTING_FOOTNOTE_ADMIN'), $cron); ?></p>
	</div>
</div>