<?php
/*------------------------------------------------------------------------
# Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 TheKrotek.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');
jimport('joomla.html.parameter');

class SocialCrosspostingHelper
{	
	var $params;
	var $lang;
	
	public function __construct()
	{
		$params = JComponentHelper::getParams('com_socialcrossposting');
		$this->params = $params->get("params");
		$this->lang = "COM_SOCIALCROSSPOSTING_";
	}
	
	public function crossPost($secret, $category, $source)
  	{
		$db = JFactory::getDBO();
		
		$lang = JFactory::getLanguage();
		$lang->load("com_socialcrossposting", JPATH_ADMINISTRATOR);	

		$output = "";
		
		$output .= "<!DOCTYPE HTML>";
		$output .= "<html>";
		$output .= "<head>";
		$output .= "<meta http-equiv='content-type' content='text/html; charset=utf-8' />";
		$output .= "</head>";
		$output .= "<body>";

		$query = "SELECT conf_value FROM #__crossposting_settings WHERE conf_key = 'secret'";
		$db->setQuery($query);
		$check = $db->loadResult();		
		
		if (!empty($secret) && ($secret == $check))
		{
			require_once(JPATH_SITE.'/components/com_socialcrossposting/models/post.php');
			$model = new SocialCrosspostingModelPost();
			$articles = $model->getArticles($category, $source);

			JPluginHelper::importPlugin('crossposting');
			$dispatcher = JDispatcher::getInstance();
			$dispatcher->trigger('onBeforeCrossPost', array(&$articles, $category, $source));
			
			if (!empty($articles))
			{
				if (count($articles) > $this->params->quantity) $articles = array_slice($articles, 0, $this->params->quantity);		

				$output .= "<div style='font-family: Arial,Helvetica,Sans-serif; font-size: 14px;'>";
				$output .= "<h3 style='font-size: 20px;'>".JText::_($this->lang.'REPORT_TITLE')."</h3>";
				$output .= "<p style='font-size: 16px;'>".JText::_($this->lang.'REPORT_PROCESSED')." ".count($articles)."</p>";
				
				$posted = "";
				
				foreach ($articles as $article)
				{
					$report = $model->crossPost($article);
					
					if (!$report['error'])
					{
						$article->introtext = preg_replace("/{crossposting}/s", "", $article->introtext);
						$article->fulltext = preg_replace("/{crossposting}/s", "", $article->fulltext);
						if ($article->source == 'content') $model->updateArticle($article);
						else $dispatcher->trigger('onAfterCrossPost', array($article));
					}
					
					if (!empty($report['networks']))
					{
						$posted .= "<b>".JText::_($this->lang.'ARTICLE')."</b> ".$report['title']." (ID: ".$report['id']."; ";
						$posted .= JText::_($this->lang.'SOURCE')." ".mb_convert_case($report['source'], MB_CASE_TITLE, "UTF-8").")<br>";

						foreach ($report['networks'] as $network)
						{
							$posted .= "<b>".JText::_($this->lang.'NETWORK')."</b> ".$network['name'];
							$posted .= "<ul>";
						
							foreach ($network['walls'] as $wall)
							{
								if ($wall['status']) $color = "#55cc55";
								else $color = "#ff0000";
							
								$posted .= "<li>".$wall['name']." (".JText::_($this->lang.'RESULT')." ";
								$posted .= "<span style='color: ".$color."'>".$wall['message']."</span>";
							
								if (!empty($wall['post'])) $posted .= ", ".JText::_($this->lang.'POST_ID')." ".$wall['post'];
							
								$posted .= ")</li>";
							}
						
							$posted .= "</ul>";
						}
					}
				}	
				
				if (!empty($posted)) {
					$output .= $posted;
					$output .= "</div>";
				} else {
					$output .= "<p>".JText::_($this->lang.'NO_ARTICLES')."</p>";
				}
			} else {
				$output .= "<p>".JText::_($this->lang.'NO_ARTICLES')."</p>";
			}
			
			if ($this->params->autoprune) {
				$pruned = $model->pruneJournal();
				if ($pruned) $output .= "<p><b>".JText::_($this->lang.'PRUNED')."</b> ".$pruned."</p>";
			}
		} else {
			$output .= "<p>".JText::_($this->lang.'ERROR_WRONG_SECRET')."</p>";
		}
		
		$output .= "</body>";
		$output .= "</html>";
		
		return $output;
	}
}
?>