<?php
/*------------------------------------------------------------------------
# Button for Social Crossposting
# ------------------------------------------------------------------------
# The Krotek
# Copyright (C) 2011-2013 The Krotek. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Website: http://thekrotek.com
# Support:  support@thekrotek.com
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die;

class plgButtonCrossposting extends JPlugin
{
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}

	public function onDisplay($name)
	{
		$app = JFactory::getApplication();

		$doc = JFactory::getDocument();
		$template = $app->getTemplate();

		$getContent = $this->_subject->getContent($name);
		$present = JText::_('PLG_CROSSPOSTING_ALREADY_EXISTS', true) ;
		
		$js = "	function insertCrossposting(editor)
				{
					var content = $getContent;
					
					if (content.match(/{crossposting}/i))
					{
						alert('$present');
						return false;
					}
					else
					{
						jInsertEditorText('{crossposting}', editor);
					}
				}";

		$doc->addScriptDeclaration($js);

		$button = new JObject;
		
		$button->set('modal', false);
		$button->set('onclick', "insertCrossposting('".$name."'); return false;");
		$button->set('text', JText::_('PLG_CROSSPOSTING_BUTTON_CROSSPOSTING'));
		$button->set('name', 'share-alt');
		$button->set('link', '#');
		$button->set('class', 'btn');

		return $button;
	}
}

?>