<?php 

// start содержание файла функций

// - убираем мусор из шапки
// - подключаем фон 
// - подключаем стили темы, шрифты google fonts и awesome font
// - подключаем jQuery
// - подключаем скрипт bfi_thumb
// - подключаем миниатюры
// - подключаем произвольное меню
// - подключаем виджеты
// - подключаем анонсы
// - подключаем хлебные крошки от dimox
// - подключаем консоль шаблона

// end содержание файла функций


// убираем мусор из шапки	
function removeHeadLinks() {
  remove_action('wp_head', 'rsd_link');
  remove_action('wp_head', 'wlwmanifest_link');
}
add_action('init', 'removeHeadLinks');
remove_action('wp_head', 'wp_generator');

// подключаем фон

add_theme_support( 'custom-background' );
if ( ! isset( $content_width ) )
	$content_width = 645;


// подключаем стили

function gpr_scripts() {

wp_enqueue_style( 'theme-style', get_stylesheet_uri(), false, '1.0.0');
wp_enqueue_style( 'mmenu', get_template_directory_uri() . '/includes/mmenu/jquery.mmenu.all.css', false, '4.2.5');
wp_enqueue_style( 'roboto', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,300,700&subset=latin,cyrillic', null, '1.0.0' );
wp_enqueue_style( 'tinos', '//fonts.googleapis.com/css?family=Tinos:400,700&subset=latin,cyrillic', null, '1.0.0' );
wp_enqueue_script( 'custom', get_template_directory_uri() . '/js/custom.js',  array('jquery'), '1.0.0', true);
wp_enqueue_script( 'slippry', get_template_directory_uri() . '/js/slippry.js',  array('jquery'), '1.2.1', true);	
wp_enqueue_script( 'flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js',  array('jquery'), '2.2.0', true);	
wp_enqueue_script( 'inview', get_template_directory_uri() . '/js/inview.js',  array('jquery'), '1.0.0.', true);
wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.js',  array('jquery'), '1.4.8.', true);
wp_enqueue_script( 'mmenu', get_template_directory_uri() . '/includes/mmenu/jquery.mmenu.min.all.js',  array('jquery'), '4.2.5', true);	
 

}

	add_action( 'wp_enqueue_scripts', 'gpr_scripts' );
	
	add_editor_style( array( 'css/editor-style.css' ) );
 

function webendev_load_font_awesome() {
	if ( !is_admin() ) { 
       wp_enqueue_style( 'font-awesome', '//netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css', false, '4.1.0' );
	}
}	
add_action( 'wp_enqueue_scripts', 'webendev_load_font_awesome', 99 );



if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
	wp_enqueue_script( 'comment-reply' );


// подключаем bfi_thumb
require_once( 'includes/bfi_thumb.php' );

// подключаем миниатюры	
add_theme_support( 'post-thumbnails' );
the_post_thumbnail('medium');
the_post_thumbnail('large');           
the_post_thumbnail('full');             
 
 
 
//подключаем меню
function register_main_menus() {
	register_nav_menus(
		array(
			'primary-menu' => 'Основное меню',
				'secondary-menu' => 'Мобильное меню'
		)
	);
}
if (function_exists('register_nav_menus')) add_action( 'init', 'register_main_menus' );
add_theme_support( 'post-formats', array( 'aside',  'audio',  'status', 'video', 'image' ) );


//получаем имя рубрики из id 
function cat_id_to_name($id) {
	foreach((array)(get_categories()) as $category) {
    	if ($id == $category->cat_ID) { return $category->cat_name; break; }
	}
}

//подключаем виджеты

function gpress_widgets_init() {


if ( function_exists('register_sidebar') )
        register_sidebar(array(	
     'name' => 'Сайдбар слева',
            'before_title' => '<div class="side-title"><span>',
        'after_title' => '</span></div>',
		'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div><div class="clear"></div>',
    ));
    if ( function_exists('register_sidebar') )
        register_sidebar(array(	
     'name' => 'Сайдбар справа',
            'before_title' => '<div class="side-title"><span>',
        'after_title' => '</span></div>',
	'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div><div class="clear"></div>',
    ));
  if ( function_exists('register_sidebar') )
        register_sidebar(array( 
     'name' => 'Подвал 1',
            'before_title' => '<div class="home-bottom-title">',
        'after_title' => '</div>',
	'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div><div class="clear"></div> ',
    )); 
      if ( function_exists('register_sidebar') )
        register_sidebar(array(	
     'name' => 'Подвал 2',
            'before_title' => '<div class="home-bottom-title">',
        'after_title' => '</div>',
	'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div><div class="clear"></div> ',
    ));
      if ( function_exists('register_sidebar') )
        register_sidebar(array( 
     'name' => 'Подвал 3',
            'before_title' => '<div class="home-bottom-title">',
        'after_title' => '</div>',
  	'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div> <div class="clear"></div>',
    ));
   if ( function_exists('register_sidebar') )
        register_sidebar(array( 
     'name' => 'Подвал 4',
            'before_title' => '<div class="home-bottom-title">',
        'after_title' => '</div>',
	'before_widget' => '<div class="side-blok">',
        'after_widget' => '</div><div class="clear"></div> ',
    ));
    }
    add_action( 'widgets_init', 'gpress_widgets_init' );

 // подключаем анонсы
   function truncate_post($amount,$echo=true,$post='') {
  global $shortname;
  
  if ( $post == '' ) global $post;
    
  $postExcerpt = '';
  $postExcerpt = $post->post_excerpt;
  
  if (get_option($shortname.'_use_excerpt') == 'on' && $postExcerpt <> '') { 
    if ($echo) echo $postExcerpt;
    else return $postExcerpt; 
  } else {
    $truncate = $post->post_content;    
    $truncate = preg_replace('@\[caption[^\]]*?\].*?\[\/caption]@si', '', $truncate);   
    if ( strlen($truncate) <= $amount ) $echo_out = ''; else $echo_out = '...';
    $truncate = apply_filters('the_content', $truncate);
    $truncate = preg_replace('@<script[^>]*?>.*?</script>@si', '', $truncate);
    $truncate = preg_replace('@<style[^>]*?>.*?</style>@si', '', $truncate);
    
    $truncate = strip_tags($truncate);
    
    if ($echo_out == '...') $truncate = substr($truncate, 0, strrpos(substr($truncate, 0, $amount), ' '));
    else $truncate = substr($truncate, 0, $amount);

    if ($echo) echo $truncate,$echo_out;
    else return ($truncate . $echo_out);
  };
}

 // подключаем хлебные крошки от dimox
 
 function dimox_breadcrumbs() {

  $text['home']     = 'Главная страница'; // текст ссылки "Главная"
  $text['category'] = 'Архив рубрики "%s"'; // текст для страницы рубрики
  $text['search']   = 'Результаты поиска по запросу "%s"'; // текст для страницы с результатами поиска
  $text['tag']      = 'Записи с меткой "%s"'; // текст для страницы тега
  $text['author']   = 'Статьи автора %s'; // текст для страницы автора
  $text['404']      = 'Ошибка 404'; // текст для страницы 404

  $show_current   = 0; // 1 - показывать название текущей статьи/страницы/рубрики, 0 - не показывать
  $show_on_home   = 0; // 1 - показывать "хлебные крошки" на главной странице, 0 - не показывать
  $show_home_link = 1; // 1 - показывать ссылку "Главная", 0 - не показывать
  $show_title     = 1; // 1 - показывать подсказку (title) для ссылок, 0 - не показывать
  $delimiter      = ' &raquo; '; // разделить между "крошками"
  $before         = ''; // тег перед текущей "крошкой"
  $after          = ''; // тег после текущей "крошки"
  /* === КОНЕЦ ОПЦИЙ === */

  global $post;
  $home_link    = home_url('/');
  $link_before  = '<span typeof="v:Breadcrumb">';
  $link_after   = '</span>';
  $link_attr    = ' rel="v:url" property="v:title"';
  $link         = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
  $parent_id    = $parent_id_2 = $post->post_parent;
  $frontpage_id = get_option('page_on_front');

  if (is_home() || is_front_page()) {

    if ($show_on_home == 1) echo '<span class="breadcrumbs"><a href="' . $home_link . '">' . $text['home'] . '</a></span>';

  } else {

    echo '<span class="breadcrumbs" xmlns:v="http://rdf.data-vocabulary.org/#">';
    if ($show_home_link == 1) {
      echo sprintf($link, $home_link, $text['home']);
      if ($frontpage_id == 0 || $parent_id != $frontpage_id) echo $delimiter;
    }

    if ( is_category() ) {
      $this_cat = get_category(get_query_var('cat'), false);
      if ($this_cat->parent != 0) {
        $cats = get_category_parents($this_cat->parent, TRUE, $delimiter);
        if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
        $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
        $cats = str_replace('</a>', '</a>' . $link_after, $cats);
        if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
        echo $cats;
      }
      if ($show_current == 1) echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;

    } elseif ( is_search() ) {
      echo $before . sprintf($text['search'], get_search_query()) . $after;

    } elseif ( is_day() ) {
      echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
      echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
      echo $before . get_the_time('d') . $after;

    } elseif ( is_month() ) {
      echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
      echo $before . get_the_time('F') . $after;

    } elseif ( is_year() ) {
      echo $before . get_the_time('Y') . $after;

    } elseif ( is_single() && !is_attachment() ) {
      if ( get_post_type() != 'post' ) {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;
        printf($link, $home_link . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
        if ($show_current == 1) echo $delimiter . $before . get_the_title() . $after;
      } else {
        $cat = get_the_category(); $cat = $cat[0];
        $cats = get_category_parents($cat, TRUE, $delimiter);
        if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
        $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
        $cats = str_replace('</a>', '</a>' . $link_after, $cats);
        if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
        echo $cats;
        if ($show_current == 1) echo $before . get_the_title() . $after;
      }

    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $post_type = get_post_type_object(get_post_type());
      echo $before . $post_type->labels->singular_name . $after;

    } elseif ( is_attachment() ) {
      $parent = get_post($parent_id);
      $cat = get_the_category($parent->ID); $cat = $cat[0];
      $cats = get_category_parents($cat, TRUE, $delimiter);
      $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
      $cats = str_replace('</a>', '</a>' . $link_after, $cats);
      if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
      echo $cats;
      printf($link, get_permalink($parent), $parent->post_title);
      if ($show_current == 1) echo $delimiter . $before . get_the_title() . $after;

    } elseif ( is_page() && !$parent_id ) {
      if ($show_current == 1) echo $before . get_the_title() . $after;

    } elseif ( is_page() && $parent_id ) {
      if ($parent_id != $frontpage_id) {
        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          if ($parent_id != $frontpage_id) {
            $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
          }
          $parent_id = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        for ($i = 0; $i < count($breadcrumbs); $i++) {
          echo $breadcrumbs[$i];
          if ($i != count($breadcrumbs)-1) echo $delimiter;
        }
      }
      if ($show_current == 1) {
        if ($show_home_link == 1 || ($parent_id_2 != 0 && $parent_id_2 != $frontpage_id)) echo $delimiter;
        echo $before . get_the_title() . $after;
      }

    } elseif ( is_tag() ) {
      echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;

    } elseif ( is_author() ) {
      global $author;
      $userdata = get_userdata($author);
      echo $before . sprintf($text['author'], $userdata->display_name) . $after;

    } elseif ( is_404() ) {
      echo $before . $text['404'] . $after;
    }

    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }

    echo '</span><!-- .breadcrumbs -->';

  }
} // end dimox_breadcrumbs()


// консоль шаблона
 
$themename = "Консоль темы ";
$shortname = "gpress";


$cats_array = get_categories('hide_empty=0');
 
$site_cats = array();


foreach ($cats_array as $categs) {
	$site_cats[$categs->cat_ID] = $categs->cat_name;
	$cats_ids[] = $categs->cat_ID;
}

$options = array (
 
array( "name" => $themename." ",
  "type" => "title"),
  
    array( "name" => "Ширина сайта",
  "type" => "section"),
array( "type" => "open"),
 
array( "name" => "Ширина контейнера",
  "desc" => "Выберите вид сайта - вся ширина страницы(100%) или фиксированная ширина ( 1200px или1400px). Особенности применения ширины см. в инструкции к теме",
  "id" => $shortname."_width",
  "type" => "select",
  "options" => array("100%", "1200px", "1400px"),
  "std" => "1200px"),

array( "type" => "close"),

 
array( "name" => "Шапка сайта",
  "type" => "section"),
array( "type" => "open"),

 
array( "name" => "Заголовок сайта",
  "desc" => "Выберите тип заголовка - графический логотип или обычный текст. ",
  "id" => $shortname."_logo",
  "type" => "select",
  "options" => array("Текст", "Логотип"),
  "std" => "Логотип"),

array( "name" => "Если выбран Текст - обычный шрифт",
  "desc" => "В это поле впишите текст для черной  части заголовка.",
  "id" => $shortname."_logo_text_color",
  "type" => "text",
  "std" => "Focus"),

array( "name" => "Если выбран Текст - цветной шрифт",
  "desc" => "В это поле впишите текст для  цветной части заголовка.",
  "id" => $shortname."_logo_text_black",
  "type" => "text",
  "std" => "Point"),

array( "name" => "Если выбран логотип",
  "desc" => "Загрузите логотип через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на него и вставьте в это поле.",
  "id" => $shortname."_logo_url",
  "type" => "text",
  "std" => ""),

array( "name" => "Включить контактную информацию в шапке",
  "desc" => "Включить / отключить контактную информацию в правом верхнем углу",
  "id" => $shortname."_info_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),


array( "name" => "Контакт - email",
  "desc" => "В это поле впишите свой email, можно указать скайп, или написать обычный адрес (улица, номер дома и тп). Разрешен html.",
  "id" => $shortname."_info_text",
  "type" => "text",
  "std" => "адрес почты"),

array( "name" => "Контакт - телефон",
  "desc" => "В это поле впишите контактный телефон. Или другую информацию. Разрешен html.",
  "id" => $shortname."_info_phone",
  "type" => "text",
  "std" => "телефон"),
  
 
array( "type" => "close"),


array( "name" => "Слайдер",
  "type" => "section"),
array( "type" => "open"),

array( "name" => "Выбрать слайдер для статичной Главной",
  "desc" => "Выбрать слайдер на Главной странице - Slippry Slider или Flexy Slider - или вообще отключить слайдер. ",
  "id" => $shortname."_slider_home_loc",
  "type" => "select",
  "options" => array("Slippry", "Flexy", "Отключить"),
  "std" => "Включить"),
  
array( "name" => "Выбрать слайдер для Блога",
  "desc" => "Выбрать слайдер для страницы записей - Slippry Slider или Flexy Slider - или вообще отключить слайдер. ",
  "id" => $shortname."_slider_blog_loc",
  "type" => "select",
  "options" => array("Slippry", "Flexy", "Отключить"),
  "std" => "Включить"),
    
   array( "name" => "Слайд №1 - Заголовок",
	"desc" => "Впишите сюда заголовок слайда.",
	"id" => $shortname."_pageslide_title1",
	"type" => "text",
	"std" => "Заголовок слайда 1"),
	
	 array( "name" => "Слайд №1 - Ссылка на страницу",
	"desc" => "Впишите сюда ссылку на любую страницу сайта, которая откроется при клике на слайд.",
	"id" => $shortname."_pageslide_link1",
	"type" => "text",
	"std" => "#"),
	
	array( "name" => "Слайд №1 - Картинка",
	"desc" => "Возьмите изображение, загрузите его через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на изображение и вставьте в это поле.",
	"id" => $shortname."_pageslide_pic1",
	"type" => "text",
	"std" => ""),
	
	
	 array( "name" => "Слайд №2 - Заголовок",
	"desc" => "Впишите сюда заголовок слайда.",
	"id" => $shortname."_pageslide_title2",
	"type" => "text",
	"std" => "Заголовок слайда 2"),
	
	 array( "name" => "Слайд №2 - Ссылка на страницу",
	"desc" => "Впишите сюда ссылку на любую страницу сайта, которая откроется при клике на слайд.",
	"id" => $shortname."_pageslide_link2",
	"type" => "text",
	"std" => "#"),
	
	array( "name" => "Слайд №2- Картинка",
	"desc" => "Возьмите изображение, загрузите его через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на изображение и вставьте в это поле.",
	"id" => $shortname."_pageslide_pic2",
	"type" => "text",
	"std" => ""),
	
	
	 array( "name" => "Слайд №3 - Заголовок",
	"desc" => "Впишите сюда заголовок слайда.",
	"id" => $shortname."_pageslide_title3",
	"type" => "text",
	"std" => "Заголовок слайда 3"),
	
	 array( "name" => "Слайд №3 - Ссылка на страницу",
	"desc" => "Впишите сюда ссылку на любую страницу сайта, которая откроется при клике на слайд.",
	"id" => $shortname."_pageslide_link3",
	"type" => "text",
	"std" => "#"),
	
	array( "name" => "Слайд №3 - Картинка",
	"desc" => "Возьмите изображение, загрузите его через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на изображение и вставьте в это поле.",
	"id" => $shortname."_pageslide_pic3",
	"type" => "text",
	"std" => ""),
	

			 array( "name" => "Слайд №4 - Заголовок",
	"desc" => "Впишите сюда заголовок слайда.",
	"id" => $shortname."_pageslide_title4",
	"type" => "text",
	"std" => "Заголовок слайда 4"),
	
	 array( "name" => "Слайд №4 - Ссылка на страницу",
	"desc" => "Впишите сюда ссылку на любую страницу сайта, которая откроется при клике на слайд.",
	"id" => $shortname."_pageslide_link4",
	"type" => "text",
	"std" => "#"),
	
	array( "name" => "Слайд №4 - Картинка",
	"desc" => "Возьмите изображение, загрузите его через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на изображение и вставьте в это поле.",
	"id" => $shortname."_pageslide_pic4",
	"type" => "text",
	"std" => ""),

   array( "type" => "close"),
   
   
   array( "name" => "Секция блоков с иконками",
  "type" => "section"),
array( "type" => "open"),

array( "name" => "Включить первую тройку блоков с иконками",
  "desc" => "Включить / отключить. Блоки 1-3",
  "id" => $shortname."_icons13_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
  array( "name" => "Включить вторую тройку блоков с иконками",
  "desc" => "Включить / отключить. Блоки 4-6",
  "id" => $shortname."_icons46_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
 
  
  	 array( "name" => "Блок 1 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
	"id" => $shortname."_icon1_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 1 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon1_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 1 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon1_text",
	"type" => "textarea",
	"std" => ""),
	
 
  
  	 array( "name" => "Блок 2 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
	"id" => $shortname."_icon2_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 2 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon2_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 2 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon2_text",
	"type" => "textarea",
	"std" => ""),
	
	
 
  
  	 array( "name" => "Блок 3 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
	"id" => $shortname."_icon3_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 3 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon3_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 3 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon3_text",
	"type" => "textarea",
	"std" => ""),
	
	
 
  
  	 array( "name" => "Блок 4 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
	"id" => $shortname."_icon4_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 4 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon4_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 4 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon4_text",
	"type" => "textarea",
	"std" => ""),
	
	
 
  
  	 array( "name" => "Блок 5 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
"id" => $shortname."_icon5_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 5 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon5_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 5 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon5_text",
	"type" => "textarea",
	"std" => ""),
	
	
 
  
  	 array( "name" => "Блок 6 - Заголовок",
	"desc" => "Впишите сюда заголовок.",
"id" => $shortname."_icon6_title",
	"type" => "text",
	"std" => "Заголовок"),
	
	  	 array( "name" => "Блок 6 - Иконка",
	"desc" => "Вставьте сюда код иконки.",
	"id" => $shortname."_icon6_ic",
	"type" => "text",
	"std" => ""),
	
		  	 array( "name" => "Блок 6 - Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_icon6_text",
	"type" => "textarea",
	"std" => ""),


   array( "type" => "close"),
   
   
   array( "name" => "Секция с подвижным фоном и кнопкой",
  "type" => "section"),
array( "type" => "open"),


	 	 array( "name" => "Секция с подвижным фоном и кнопкой - включить",
  "desc" => "Включить / отключить",
  "id" => $shortname."_homebox_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),

  		   array( "name" => "Изображение в фоне ",
 "desc" => "Загрузите изображение через <a href='media-new.php' target='_blank'>загрузчик движка</a>, скопируйте ссылку на него и вставьте в это поле. ",
  "id" => $shortname."_homebox_img",
  "type" => "text",
  "std" => "https://farm9.staticflickr.com/8452/7986162162_7aca749ba4_b.jpg"), 

		  	 array( "name" => "Текст",
	"desc" => "Впишите текст.",
	"id" => $shortname."_homebox_text",
	"type" => "textarea",
	"std" => ""),
	
			  	 array( "name" => "Включить кнопку",
	"desc" => "Включить / отключить кнопку",
  "id" => $shortname."_homebox_but",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
  		  	 array( "name" => "Надпись на кнопке",
	"desc" => "Впишите текст.",
	"id" => $shortname."_homebox_but_text",
	"type" => "text",
	"std" => ""),
	
	  		  	 array( "name" => "Ссылка с кнопки",
	"desc" => "Впишите адрес страницы или документа, который должен открываться по клику на кнопку.",
	"id" => $shortname."_homebox_but_url",
	"type" => "text",
	"std" => ""),

   array( "type" => "close"),
   
   
array( "name" => "Избранные записи",
  "type" => "section"),
array( "type" => "open"),

	 	 array( "name" => "Включить / выключить избранные записи",
  "desc" => "Включить / выключить избранные записи",
  "id" => $shortname."_feat_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
   
  	 array( "name" => "Установить рубрику избранных записей",
	"desc" => "Выбрать нужную рубрику для вывода в нижней части Главной",
	"id" => $shortname."_feat_cat",
	  "type" => "select",
	"options" => $site_cats,
	"std" => ""),
	
		array( "name" => "Установить количество статей",
  "desc" => "Укажите количество записей, выводимых в слайдере. Используются последние записи из одной избранной выше рубрики. Количество кратно двум.",
  "id" => $shortname."_feat_count",
  "type" => "select",
  "options" => array("2","4","6", "8", "10"),
  "std" => "2"),
  
    	 array( "name" => "Количество символов в анонсе избранной записи",
	"desc" => "Укажите количество символов в анонсе, фактически, оно определяет его длину. По-умолчанию, 800",
	"id" => $shortname."_feat_word_count",
	"type" => "text",
	"std" => "800"),
  
  		 array( "name" => "Исключить эту рубрику из страницы блога?",
	"desc" => "Исключить / Оставить",
  "id" => $shortname."_feat_excl",
  "type" => "select",
  "options" => array("Исключить", "Оставить"),
  "std" => "Исключить"),

      array( "type" => "close"),
   

array( "name" => "Блог",
  "type" => "section"),
array( "type" => "open"),

array( "name" => "Выключить левый сайдбар",
  "desc" => "Выключить левый сайдбар в блоге, на страницах и в записях",
  "id" => $shortname."_sb_left",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
  array( "name" => "Выключить правый сайдбар",
  "desc" => "Выключить правый  сайдбар в блоге, на страницах и в записях",
  "id" => $shortname."_sb_right",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),

array( "name" => "Ваш пол",
  "desc" => "Ваш пол - М/Ж. В зависимости от выбора, рядом с именем автора будут выводиться разные иконки",
  "id" => $shortname."_sx",
  "type" => "select",
  "options" => array("М", "Ж"),
  "std" => "М"),
  
  array( "name" => "Вид записей",
  "desc" => "Выберите внешний вид записей, один из трех вариантов - обычный пост, анонс с  миниатюрой",
  "id" => $shortname."_post_look",
  "type" => "select",
  "options" => array("Обычный пост", "Анонс и миниатюра"),
  "std" => "Анонс и миниатюра"),
  
  	 array( "name" => "Если выбран анонс - количество символов в анонсе",
	"desc" => "Укажите количество символов в анонсе, фактически, оно определяет его длину. По-умолчанию, 1000",
	"id" => $shortname."_word_count",
	"type" => "text",
	"std" => "1000"),
	
	
		array( "name" => "Внутренняя навигация в блоге",
	"desc" => "Выплывающий блок с навигацией в постах блога",
	"id" => $shortname."_navbox",
	"type" => "select",
	"options" => array("Включить", "Выключить"),
	"std" => "Включить"),
	


   array( "type" => "close"),

 
array( "name" => "Подвал",
  "type" => "section"),
array( "type" => "open"), 

       array( "name" => "Блок виджетов в подвале",
  "desc" => "Включить или отключить блок в подвале, где выводятся виджеты",
  "id" => $shortname."_foot_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
  
   array( "name" => "Cсылка Вход",
  "desc" => "Включить/выключить ссылки Вход и Управление сайтом в подвале сайта ",
  "id" => $shortname."_enter_loc",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),


   array( "type" => "close"),

array( "name" => "Социалка",
  "type" => "section"),
array( "type" => "open"),



  array( "name" => "Включить блок кнопок ваших аккаунтов в соц. сетях",
  "desc" => "Включить/выключить все соцкнопки",
  "id" => $shortname."_social",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),

  
  
    array( "name" => "Тип RSS",
  "desc" => "RSS включен по-умолчанию. Выберите, какой тип RSS использовать - Ваш персональный фид на feedburner* или фид по-умолчанию.",
  "id" => $shortname."_rss_kind",
  "type" => "select",
  "options" => array("feedburner", "По-умолчанию"),
  "std" => "По-умолчанию"),
  
      array( "name" => "* если выбран FeedBurner",
  "desc" => "Если выбрали feedburner, впишите здесь адрес фида. Найти его можно в вашем аккаунте на <a href='http://feedburner.google.com' target='_blank'>feedburner.com</a>, на вкладке Edit Feed Details, самое нижнее поле содержит урл вашего фида (например, http://feeds2.feedburner.com/wpbot). Если используете дефолтный фид, оставьте поле пустым. ",
  "id" => $shortname."_rss_feed",
  "type" => "text",
  "std" => ""), 
  

  array( "name" => "Вконтакте - включить/выключить",
  "desc" => "Включить/выключить  Вконтакте",
  "id" => $shortname."_vk",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
    array( "name" => "Ваш аккаунт Вконтакте",
  "desc" => "Впишите ссылку на Ваш аккаунт Вконтакте, например, http://vkontakte.ru/durov ",
  "id" => $shortname."_vk_link",
  "type" => "text",
  "std" => "http://vkontakte.ru/durov"),   
  
    array( "name" => "Facebook - включить/выключить",
  "desc" => "Включить/выключить  Facebook",
  "id" => $shortname."_fb",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
    array( "name" => "Ваш аккаунт на Facebook",
  "desc" => "Впишите ссылку на Ваш аккаунт в Facebook, например, http://www.facebook.com/zuck ",
  "id" => $shortname."_fb_link",
  "type" => "text",
  "std" => "http://www.facebook.com/zuck"),  
  
      array( "name" => "Google Plus - включить/выключить",
  "desc" => "Включить/выключить  Google Plus",
  "id" => $shortname."_gp",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
      array( "name" => "Ваш аккаунт на Google Plus",
  "desc" => "Впишите ссылку на Ваш аккаунт в Google +, например, https://plus.google.com/113221044857190831842 ",
  "id" => $shortname."_gp_link",
  "type" => "text",
  "std" => "https://plus.google.com/113221044857190831842"),  

      array( "name" => "Youtube - включить/выключить",
  "desc" => "Включить/выключить Youtube",
  "id" => $shortname."_yt",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
      array( "name" => "Ваш аккаунт на Youtube",
  "desc" => "Впишите ссылку на Ваш аккаунт в Youtube, например, http://www.youtube.com/user/Masyanyas ",
  "id" => $shortname."_yt_link",
  "type" => "text",
  "std" => "http://www.youtube.com/user/Masyanyas"),  
  
   array( "name" => "Одноклассники - включить/выключить",
  "desc" => "Включить/выключить Instagram",
  "id" => $shortname."_ok",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
      array( "name" => "Ваш аккаунт в Одноклассниках",
  "desc" => "Впишите ссылку на Ваш аккаунт в Одноклассниках например, http://odnoklassniki.ru/official",
  "id" => $shortname."_ok_link",
  "type" => "text",
  "std" => "http://odnoklassniki.ru/official"),  



      array( "name" => "Instagram - включить/выключить",
  "desc" => "Включить/выключить Instagram",
  "id" => $shortname."_in",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
      array( "name" => "Ваш аккаунт на Instagram",
  "desc" => "Впишите ссылку на Ваш аккаунт в Instagram, например, http://instagram.com/goblin_oper",
  "id" => $shortname."_in_link",
  "type" => "text",
  "std" => "http://instagram.com/goblin_oper"),  
  
  array( "name" => "Twitter - включить/выключить",
  "desc" => "Включить/выключить Twitter",
  "id" => $shortname."_tw",
  "type" => "select",
  "options" => array("Включить", "Выключить"),
  "std" => "Включить"),
  
  array( "name" => "Ваш аккаунт на Твиттере",
  "desc" => "Впишите только название вашего аккаунта в твиттере, например, http://twitter.com/goodwinpress ",
  "id" => $shortname."_tw_link",
  "type" => "text",
  "std" => "http://twitter.com/goodwinpress"), 


array( "type" => "close"),

	array( "name" => "Оформление",
	"type" => "section"),
array( "type" => "open"),


    array( "name" => "Цвет шрифта на сайте",
  "desc" => "По-умолчанию: 333333",
  "id" => $shortname."_font_color",
  "type" => "clr",
  "std" => "333333"), 
  
      array( "name" => "Цвет ссылок",
  "desc" => "По-умолчанию: 5AA8B7",
  "id" => $shortname."_font_hov",
  "type" => "clr",
  "std" => "5AA8B7"), 
  
        array( "name" => "Цветная часть заголовка сайта",
  "desc" => "По-умолчанию: FC7285",
  "id" => $shortname."_logo_a",
  "type" => "clr",
  "std" => "FC7285"), 
  
          array( "name" => "Контактная информация - цвет шрифта",
  "desc" => "По-умолчанию: 333333",
  "id" => $shortname."_contact",
  "type" => "clr",
  "std" => "333333"), 
  
           array( "name" => "Меню в шапке - цвет фона",
  "desc" => "По-умолчанию: 426467",
  "id" => $shortname."_menunav",
  "type" => "clr",
  "std" => "426467"), 
  
             array( "name" => "Меню в шапке - цвет фона дочерних страниц (выпадающее меню)",
  "desc" => "По-умолчанию: 758D80",
  "id" => $shortname."_menunav_second",
  "type" => "clr",
  "std" => "758D80"), 
  
  
       array( "name" => "Меню в шапке - цвет шрифта (объединен с цdетом шрифта меток и социалки)",
  "desc" => "По-умолчанию: FFFFFF",
  "id" => $shortname."_nav_tags",
  "type" => "clr",
  "std" => "FFFFFF"), 
  
         array( "name" => "Меню в шапке - цвет шрифта при наведении мыши (hover)",
  "desc" => "По-умолчанию: FF8997",
  "id" => $shortname."_menunav_hov",
  "type" => "clr",
  "std" => "FF8997"), 
  
           array( "name" => "Цвет заголовков",
  "desc" => "По-умолчанию: 444444",
  "id" => $shortname."_titles_color",
  "type" => "clr",
  "std" => "444444"), 
  
                   array( "name" => "Цвет иконок Font Awesome на статичной Главной",
  "desc" => "По-умолчанию: FF8997",
  "id" => $shortname."_icons_color",
  "type" => "clr",
  "std" => "FF8997"), 
  
             array( "name" => "Кнопки сайта - фон (а также фон меток и социалки)",
  "desc" => "По-умолчанию: 6AB6C4",
  "id" => $shortname."_buttons_color",
  "type" => "clr",
  "std" => "6AB6C4"), 
  
               array( "name" => "Кнопки сайта - цвет шрифта (а также цвет меток и социалки)",
  "desc" => "По-умолчанию: FFFFFF",
  "id" => $shortname."_buttons_font",
  "type" => "clr",
  "std" => "FFFFFF"), 
  
  array( "name" => "Кнопки сайта - фон при наведении мыши (а также цвет меток и социалки)",
  "desc" => "По-умолчанию: FF8997",
  "id" => $shortname."_buttons_hov",
  "type" => "clr",
  "std" => "FF8997"), 
  
    array( "name" => "Подвал - фон",
  "desc" => "По-умолчанию: 222222",
  "id" => $shortname."_footer_color",
  "type" => "clr",
  "std" => "222222"), 
  
      array( "name" => "Подвал - цвет шрифта и ссылок",
  "desc" => "По-умолчанию: F9F9F9",
  "id" => $shortname."_footer_text_color",
  "type" => "clr",
  "std" => "F9F9F9"), 
  
        array( "name" => "Подвал - цвет заголовков",
  "desc" => "По-умолчанию: 999999",
  "id" => $shortname."_footer_titl_color",
  "type" => "clr",
  "std" => "999999"), 


array( "type" => "close"),

);

function mytheme_add_admin() {
 
global $themename, $shortname, $options;
 
if ( $_GET['page'] == basename(__FILE__) ) {
 
  if ( 'save' == $_REQUEST['action'] ) {
 
    foreach ($options as $value) {
    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
 
foreach ($options as $value) {
  if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
 
  header("Location: admin.php?page=functions.php&saved=true");
die;
 
} 
else if( 'reset' == $_REQUEST['action'] ) {
 
  foreach ($options as $value) {
    delete_option( $value['id'] ); }
 
  header("Location: admin.php?page=functions.php&reset=true");
die;
 
}
}
 
add_menu_page($themename, $themename, 'administrator', basename(__FILE__), 'mytheme_admin');
}

function mytheme_add_init() {

$file_dir=get_bloginfo('template_directory');
wp_enqueue_style("functions", $file_dir."/functions/functions.css", false, "1.0", "all");
wp_enqueue_script("rm_script", $file_dir."/functions/rm_script.js", false, "1.0");
wp_enqueue_script("jscolor", $file_dir."/js/jscolor/jscolor.js", false, "1.4.2");
wp_enqueue_style( 'roboto', '//fonts.googleapis.com/css?family=Roboto+Condensed:400,300,700&subset=latin,cyrillic', null, '1.0.0' );
}

function mytheme_admin() {
 
global $themename, $shortname, $options;
$i=0;
 
if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' - настройки сохранены.</strong></p></div>';
if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' - настройки сброшены.</strong></p></div>';
 
?>
<div class="wrap rm_wrap">

<h2><?php echo $themename; ?></h2>
 
<div class="rm_opts">
<form method="post">
<?php foreach ($options as $value) {
switch ( $value['type'] ) {
 
case "open":
?>
 
<?php break;
 
case "close":
?>
 
</div>
</div>
<br />

 
<?php break;

case 'textarea-ed':
?>

<div class="rm_input rm_textarea ed"> 
<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
<p>&nbsp;</p>
<div class="clear"></div>
<?php
          if( get_option($value['id']) != "") {
                $settings = stripslashes(get_option($value['id']));
          }else{
              $settings = $value['std'];
          }
          ?>
          <?php wp_editor($settings,$value['id'],array('wpautop' => true,'media_buttons'=>true)); ?>
 
 
    

        
 <small><?php echo $value['desc']; ?></small> <div class="clearfix"></div>
 
</div>
  
<?php
break;
 
case "title":
?>

<div class="intro_section">
 <h4>Пара слов от Гудвина</h4>
 <div class="clearfix"></div>
 <img src="<?php echo get_template_directory_uri();?>/functions/images/goodwin.jpg" class="good">
<p>Спасибо, что Вы выбрали тему от GoodwinPress.Ru. Вы находитесь на странице настройки шаблона <b>Emulator Pro</b>. В этих блоках Вы можете быстро подготовить тему к работе, без вмешательства в код. </p>
<p>Расширенная и подробная документация  находится в папке шаблона. Найдите папку Инструкция, и откройте файл readme.html, который находится внутри (открывается при помощи любого браузера).</p>
<p>Для настройки, выберите нужный параметр, измените его и нажмите кнопку "Сохранить". Опции, которые Вы меняете, будут записаны в базу данных сайта.</p>
  </div>
 

 
<?php break;
 
case 'text':
?>

<div class="rm_input rm_text">
  <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
  <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" />
 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 
 </div>
 
 
 <?php break;
 
case 'clr':
?>

<div class="rm_input rm_text">
  <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label><div class="clear"></div>
  <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" class="color" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo $value['std']; } ?>" />
 <small><?php echo $value['desc']; ?></small> <div class="clearfix"></div>
 
 </div>
 
 
 
<?php
break;
 
case 'textarea':
?>

<div class="rm_input rm_textarea">
  <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
  <textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id']) ); } else { echo $value['std']; } ?></textarea>
 <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 
 </div>
  
<?php
break;
 
case 'select':
?>

<div class="rm_input rm_select">
  <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
  
<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
<?php foreach ($value['options'] as $option) { ?>
    <option <?php if (get_option( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
</select>

  <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
</div>
<?php
break;
 
case "checkbox":
?>

<div class="rm_input rm_checkbox">
  <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
  
<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />


  <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 </div>
<?php break; 
case "section":

$i++;

?>

<div class="rm_section">
<div class="rm_title"><h3><img src="<?php bloginfo('template_directory')?>/functions/images/trans.png" class="inactive" alt="""><?php echo $value['name']; ?></h3><span class="submit"><input name="save<?php echo $i; ?>" type="submit" class="button-primary" value="Сохранить" />
</span><div class="clearfix"></div></div>
<div class="rm_options">

 
<?php break;
 
}
}
?>
 
 
 </div>
 
 <div class="intro_section">
 <h3>Внимание!</h3><div class="clearfix"></div>
 
 <p>Чтобы вернуть шаблон к первоначальным настройкам, нажмите кнопку "Сброс всех настроек". <b>Это действите необратимо! </b>Вернуть назад сброшенные настройки невозможно. Конечно, это не страшно, но вам придется настраивать  заново шаблон.</p>
 </div>
 
  <input type="hidden" name="action" value="save" />
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" class="out-button" value="СБРОС ВСЕХ НАСТРОЕК" />
<input type="hidden" name="action" value="reset" />
</p>
</form>
 
 


<?php }




add_action('admin_init', 'mytheme_add_init');  
add_action('admin_menu', 'mytheme_add_admin'); 



?>