
	<div class="main_container">
		{* Заголовок страницы *}
{if $keyword}
<h1>Поиск {$keyword|escape}</h1>
{elseif $page}
<h1>{$page->name|escape}</h1>
{else}
<h1>{$category->name|escape} {$brand->name|escape} {$keyword|escape}</h1>
{/if}

<div class="breadcrumb">


{if $category}
	{foreach from=$category->path item=cat}
	<i>&nbsp;»&nbsp;</i><a href="catalog/{$cat->url}">{$cat->name|escape}</a>
	{/foreach}  
	{if $brand}
	<i>&nbsp;»&nbsp;</i><a href="catalog/{$cat->url}/{$brand->url}">{$brand->name|escape}</a>
	{/if}
	{elseif $brand}
	<i>&nbsp;»&nbsp;</i><a href="brands/{$brand->url}">{$brand->name|escape}</a>
	{elseif $keyword}
	<i>&nbsp;»&nbsp;</i>Поиск
	{/if}

</div>




	
<div id="catalog-sections">


	<div class="clear"></div>
</div>

	<!--Каталог товаров-->
{if $products}
		
		<div class="catalog">
			{if $products|count>0}
			<div class="sort js-catalog-sort catalogSort">
				Сортировать по:
				<a {if $sort=='position'} class="down active"{else}class="down"{/if} href="{url sort=position page=null}">умолчанию</a>
	            <a {if $sort=='price'}    class="down active"{else}class="down"{/if} href="{url sort=price page=null}">цене</a>
	            <a {if $sort=='name'}     class="down active"{else}class="down"{/if} href="{url sort=name page=null}">названию</a>
				
				
			</div>
			{/if}

			<div class="products_list js-catalog-list contentViewer">

	

	
	{foreach $products as $product}

	<div id="{$product->id}" class="product_item  {if $product->featured}hits{/if} product">
		<div class="ribbon"></div>

		{if $product->image}
		<div class="picture image">
			<a href="products/{$product->url}"><img src="{$product->image->filename|resize:120:120}" alt="{$product->name|escape}" /></a>
		</div>
		{/if}
		
		<div class="product_title">
			<a data-product="{$product->id}" href="products/{$product->url}">{$product->name|escape}</a>
			{if $product->variants|count > 0}
		<!-- Выбор варианта товара -->
		<form class="variants" action="/cart">
			{foreach $product->variants as $v}
		<input  id="featured_{$v->id}" name="variant" value="{$v->id}" type="radio"  {if $v@first}checked{/if} style="display:none;"/>
		{/foreach}
			<table class="price">
		
				<tr>
		
					<td rowspan="2" class="current_price">{$v->price|convert}</td>
					<td class="old_price">{if $v->compare_price > 0}<span class="compare_price">{$v->compare_price|convert}</span>{/if}</td>
				</tr>
				<tr>
					<td class="currency">{$currency->sign|escape}</td>
				</tr>
		
			</table>
			
		</div>
		
		<input class="btn_buy"  type="submit" value="Купить" />
		</form>
		<!-- Выбор варианта товара (The End) -->
		{else}
			Нет в наличии
		{/if}
	</div>
	{/foreach}


	



			<div class="clear"></div>

			

<div class="pager">
	<div class="wrapper">
		{include file='pagination.tpl'}	
		</div>	
</div>       


					</div></div>
					{else}
Товары не найдены
{/if}	
<!--Каталог товаров (The End)-->
		
 
</div>
			<div class="sidebar">
			 

<div id="catalog-filter" class="catalog_filter_outer catalogFilter">
	<div class="catalog_filter">
		<div class="catalog_filter_inner">
		
		
						
                <div class="filter_group">
        <div class="fg-title">Подбор товаров в разделе</div>
        <h2 class="fg-section-name">{$category->name|escape} {$brand->name|escape} {$keyword|escape}</h2>                
    </div>            
	
	                  {if $category->brands}
                            <div class="filter_group js-brand-list">
                    <h2>Бренд</h2>
                    
                                           
		<a href="catalog/{$category->url}" {if !$brand->id}class="selected"{/if}><label>Все бренды</label></a>
	{foreach name=brands item=b from=$category->brands}
                            <a data-brand="{$b->id}" href="catalog/{$category->url}/{$b->url}" {if $b->id == $brand->id}class="selected"{/if}><label>{$b->name|escape}</label></a>                        
                                {/foreach}  
                                                        </div>
														{/if}
               {if $features}
           {foreach $features as $f}			   
			<div class="filter_group js-group">
				<h2 data-feature="{$f->id}">{$f->name}:</h2>
				
					<a href="{url params=[$f->id=>null, page=>null]}" {if !$smarty.get.$f@key}class="selected"{/if}><label>Все</label></a>
		{foreach $f->options as $o}
		<a href="{url params=[$f->id=>$o->value, page=>null]}" {if $smarty.get.$f@key == $o->value}class="selected"{/if}><label>{$o->value|escape}</label></a>
		{/foreach}
	
				

			</div>
			{/foreach}	
			{/if}
			
			
			
			
		
			
			<div class="filter_reset js-reset"></div>
			<div class="clear"></div>
		
		</div>
	</div>
	
	
	
</div>








 
		</div>
		<div class="clear"></div>


						
               