{* Шаблон корзины *}

{$meta_title = "Корзина" scope=parent}
{if $cart->purchases}
<div class="content basketAdder">
<div class="main_container basket">
	<h1>
	{if $cart->purchases}В корзине {$cart->total_products} {$cart->total_products|plural:'товар':'товаров':'товара'}
{else}Корзина пуста{/if}
	</h1>




<form class="basket_table js-basket basketUI"  name="cart" method="post">
		
	<table class="main-table">


		<tbody>
		{foreach from=$cart->purchases item=purchase}
		<tr class="jsProduct">
			<td>
				<table class="basket_table_item js-item" id="basket2">
					<tbody><tr>
						{$image = $purchase->product->images|first}
		{if $image}
						<td rowspan="2" class="product_picture">
				<a href="products/{$purchase->product->url}"><img alt="" src="{$image->filename|resize:76:76}"></a>
						</td>
						{/if}
						<td colspan="4" class="product_title">
							<div>
								<a href="products/{$purchase->product->url}">{$purchase->product->name|escape}</a>
								<span class="light"></span>
							</div>
						</td>
					</tr>
					<tr>
						<td class="product_params">
						{$purchase->variant->name|escape}	
											</td>
						
						
						<td class="quantity">
							<select name="amounts[{$purchase->variant->id}]" onchange="document.cart.submit();">
			{section name=amounts start=1 loop=$purchase->variant->stock+1 step=1}
			<option value="{$smarty.section.amounts.index}" {if $purchase->amount==$smarty.section.amounts.index}selected{/if}>{$smarty.section.amounts.index} {$settings->units}</option>
			{/section}
		</select>
						</td>
						<td class="product_sum">
							<b data-price="1363" class="js-price">{($purchase->variant->price*$purchase->amount)|convert}</b> &nbsp;{$currency->sign}
						</td>
						<td class="product_delete">
						<a href="cart/remove/{$purchase->variant->id}">
							
							<img src="design/{$settings->theme}/images/delete.png" title="Удалить из корзины" alt="Удалить из корзины">
							</a>
						</td>
					</tr>
				</tbody></table>
			</td>
		</tr>
		{/foreach}
	
	
	
	
	
		
	</tbody></table>
	
		
	<div class="summary">
		<div class="back_to_catalog">
			<a href="/catalog/">Продолжить покупки</a>
		</div>
		<div class="total_sum js-itogo">
			Общая стоимость: <b class="js-total">{$cart->total_price|convert}</b> руб
		</div>
		
		
	</div>
	
{* Доставка *}
{if $deliveries}
<h2>Выберите способ доставки:</h2>
<ul id="deliveries">
	{foreach $deliveries as $delivery}
	<li>
		<div class="checkbox">
			<input type="radio" name="delivery_id" value="{$delivery->id}" {if $delivery_id==$delivery->id}checked{elseif $delivery@first}checked{/if} id="deliveries_{$delivery->id}">
		</div>
		
			<h3>
			<label for="deliveries_{$delivery->id}">
			{$delivery->name}
			{if $cart->total_price < $delivery->free_from && $delivery->price>0}
				({$delivery->price|convert}&nbsp;{$currency->sign})
			{elseif $cart->total_price >= $delivery->free_from}
				(бесплатно)
			{/if}
			</label>
			</h3>
			<div class="description">
			{$delivery->description}
			</div>
	</li>
	{/foreach}
</ul>
{/if}
    
<h2>Адрес получателя</h2>
	
<div class="form cart_form">         
	{if $error}
	<div class="message_error">
		{if $error == 'empty_name'}Введите имя{/if}
		{if $error == 'empty_email'}Введите email{/if}
		{if $error == 'captcha'}Капча введена неверно{/if}
	</div>
	{/if}
	<label>Имя, фамилия</label>
	<input name="name" type="text" value="{$name|escape}" data-format=".+" data-notice="Введите имя"/>
	
	<label>Email</label>
	<input name="email" type="text" value="{$email|escape}" data-format="email" data-notice="Введите email" />

	<label>Телефон</label>
	<input name="phone" type="text" value="{$phone|escape}" />
	
	<label>Адрес доставки</label>
	<input name="address" type="text" value="{$address|escape}"/>

	<label>Комментарий к&nbsp;заказу</label>
	<textarea name="comment" id="order_comment">{$comment|escape}</textarea>
	
	<div class="captcha"><img src="captcha/image.php?{math equation='rand(10,10000)'}" alt='captcha'/></div> 
	<input class="input_captcha" id="comment_captcha" type="text" name="captcha_code" value="" data-format="\d\d\d\d" data-notice="Введите капчу"/>
	

	<div class="summary">
	<input type="submit" value="Оформить заказ" class="btn_basket_order js-order-btn" name="checkout" class="button" value="Оформить заказ">
		</div>
	</div>
   
</form>
{else}
  В корзине нет товаров
{/if}













</div>
<div class="clear"></div>
                    </div>
					
					
					