Number.prototype.nformat = function(delimiter, signed){

    var arr = Math.abs(this).toFixed(2).toString().split('.', 2);
    var wn  = [];
    if ( typeof delimiter !== 'string' ) delimiter = ',';
    for( var i = arr[0].length - 3; i >= 0; i -= 3 )
        wn.push(arr[0].substr(i, 3));
    if ( i == -1 || i == -2 )
		wn.push(arr[0].substr(0, 3 + i));

    arr[0] = (this < 0 ? '-' : signed ? '+' : '') + wn.reverse().join(delimiter);

    return arr[0];
}

wordForm = function(count, form1, form2_4, form5_0){
	form1 = form1 || '';
	form2_4 = form2_4 || 'а';
	form5_0 = form5_0 || "ов";

	var n100 = count % 100,
		n10  = count % 10;

	if ((n100 > 10) && (n100 < 21)) {
		return form5_0;
	} else if ((!n10) || (n10 >= 5)) {
		return form5_0;
	} else if (n10 == 1) {
		return form1;
	}
	return form2_4;
}



$(function(){
    // глобальные настройки ajax
    $.ajaxSetup({
        timeout: 25000
    });

    /* ------------------------------------------------------------------------------------------
        auto init
    ------------------------------------------------------------------------------------------ */

    // Убираем лишний разделитель в меню
    $('.jsTopNav').find('li.active').next('li').addClass('no_sep');

    // Запускаем слайдер на главной
    $('.slider').nivoSlider({
        effect: 'fade',
        directionNav: false,
        controlNav: true,
        captionOpacity: 1
    });

    // Список брендов со скроллом
    $('.jsScrollPane').jScrollPane({
        verticalDragMinHeight: 15,
		verticalDragMaxHeight: 15
    });

    // Сердечки
    $('input.rating').rating();
    $('input.rating').rating('disable');
    $('.jsEnable').find('input.rating').rating('enable');

    // Раскраска таблиц
    $('.jsColorize').find('tr:even').not(':first').addClass('even');

    // Стилизуем checkbox и radio
    $('input[type="checkbox"]').ezMark();

    $('select').chosen({no_results_text: 'нет вариантов'});


    /* ------------------------------------------------------------------------------------------
        events, effects
    ------------------------------------------------------------------------------------------ */
    $.fn.fbox = function () {
        return this.each(function (i, el) {
            var self = $(this),
                modal = self.is('.js-modal');

            self.fancybox({
                showCloseButton: false,
                scrolling: 'no',
                modal: modal,
                onComplete: function(){
                    $('#fancybox-content .popup_middle').each(function(){
                        //$(this).width($(this).width() - 2);
                    });
                },
                onClosed: function(link, num, element){
                    if (element.href) {
                        $(element.href).find('.tooltip').hide();
                        $(element.href).find('.text_input, .textarea_input').removeClass('error');
                    }
                }
            });

            self.addClass('js-fancyboxed');
        });
    };

    // Fancybox
    $('.jsFancybox').fbox();

    $('.js-fancybox').fancybox();

    $(document).on('click', '.jsFancybox', function (ev) {
        var link = $(this);
        if (!link.is('.js-fancyboxed')) {
            ev.preventDefault();
            link.fbox().click();
        }
    });

    $('.jsClosePopup').click(function(){
        $.fancybox.close();
    });

    // Выпадающее мега-меню
    $('.jsCatNav').find('td').hover(function(){
        $(this).addClass('active').find('.dropdown_nav').show();
    }, function(){
        $(this).removeClass('active').find('.dropdown_nav').hide();
    });

    // Плейсхолдеры
    $('.jsPlaceholder').each(function(){
        var self = $(this),
            ph = self.val();

        if (self.attr('data-ph')) {
            ph = self.attr('data-ph');
        }

        if (!$.trim(self.val())) {
            self.val(ph);
        }

        self.focus(function(){
            if (self.val() == ph) {
                self.val('').addClass('focus');
            } else {
                self.addClass('focus');
            }
        });
        self.blur(function(){
            if (self.val() == '') {
                self.val(ph).removeClass('focus');
            } else {
                self.removeClass('focus');
            }
        });
    });

    // Стилизация полей ввода при фокусе
    $(document).on('focus', '.text_input input, .textarea_input textarea', function(){
        $(this).closest('.text_input, .textarea_input').addClass('focused');
    });
    $(document).on('focusout', '.text_input input, .textarea_input textarea', function(){
        $(this).closest('.text_input, .textarea_input').removeClass('focused');
    });

    // Зацикливание формы регистрации для корректного обхода по табу
    $('#reg_form_submit').focus(function(){
        $('#reg_form_name').attr('tabIndex','9');
    });
    $('#reg_form_submit').blur(function(){
        $('#reg_form_name').attr('tabIndex','2');
    });

    $('#reg_form_name').focus(function(){
        $('#reg_form_submit').attr('tabIndex','1');
    });
    $('#reg_form_name').blur(function(){
        $('#reg_form_submit').attr('tabIndex','8');
    });



    /* ------------------------------------------------------------------------------------------
        validation
    ------------------------------------------------------------------------------------------ */

    // хелперы для функции валидации телефона
    function isInteger(s){
        var i;
        for (i = 0; i < s.length; i++){
            var c = s.charAt(i);
            if (((c < "0") || (c > "9"))) return false;
        }
        return true;
    }
    function stripCharsInBag(s, bag){
        var i;
        var returnString = "";
        for (i = 0; i < s.length; i++){
            var c = s.charAt(i);
            if (bag.indexOf(c) == -1) returnString += c;
        }
        return returnString;
    }

    // валидатор для телефона
    $.validator.addMethod("phone", function(phone_number, element) {
        var digits = "0123456789";
        var phoneNumberDelimiters = "()- ext.";
        var validWorldPhoneChars = phoneNumberDelimiters + "+";
        var minDigitsInIPhoneNumber = 6;
        s=stripCharsInBag(phone_number,validWorldPhoneChars);
        return this.optional(element) || (String($.trim(phone_number)).length > 0 && !/[^-+\s\d\(\)]/i.test(phone_number) && /\d\d\d\d\d\d/.test(String($.trim(phone_number)).replace(/[^\d]+/g, '')));
    }, "Please enter a valid phone number");

    // валидаторы для email
    $.validator.addMethod('rightEmail', function( val, el) {return (/^([a-z0-9_\-]+\.)*[a-z0-9_\-]+@([a-z0-9][a-z0-9\-]*[a-z0-9]\.)+[a-z]{2,4}$/i.test(val));}, 'Введите корректный email!' );
    $.validator.addMethod('nonCyrillic', function( val, el) {return (/^[^а-я]*$/i.test(val));}, 'Вы ввели недопустимые символы!' );
    $.validator.addMethod('minimum6', function( val, el) {return (String(val).length >= 6);}, 'Вы ввели недопустимые символы!' );
    $.validator.addMethod('noPlaceholder', function( val, el) {return ($(el).attr('data-ph') != val);}, 'Необходимо ввести значение' );

    $.validator.addClassRules("js-required-non-cyrillic-email", {required: true, email: true, rightEmail: true, nonCyrillic: true, noPlaceholder: true});
    $.validator.addClassRules("js-required-confirmation", {required: true, noPlaceholder: true, equalTo: "#reg_form_PASSWORD"});
    $.validator.addClassRules("js-required-change-confirmation", {required: true, noPlaceholder: true, equalTo: "#auth_change_USER_PASSWORD"});
    $.validator.addClassRules("js-required-settings-confirmation", {required: true, noPlaceholder: true, equalTo: "#profile_settings_NEW_PASSWORD"});
    $.validator.addClassRules("js-required-phone", {required: true, phone: true, noPlaceholder: true});
    $.validator.addClassRules("js-required-password", {required: true, minimum6: true, noPlaceholder: true});
    $.validator.addClassRules("js-no-placeholder", {noPlaceholder: true});

    var orderBackCallFormNamePh = $('#order_back_call_form_name').val();
    var orderBackCallFormPhonePh = $('#order_back_call_form_phone').val();
    var orderBackCallFormTimePh = $('#order_back_call_form_time').val();

    //
    $.validator.addMethod('isPlaceholder', function(val, el){
        switch (val) {
            case orderBackCallFormNamePh:
                return false;
                break;
            case orderBackCallFormPhonePh:
                return false;
                break;
            case orderBackCallFormTimePh:
                return false;
                break;
            default:
                return true;
                break;
            }
    });

    // Отображение подсказок валидации
    $('.jsOrderBackCallForm').delegate('.error', 'mouseover mouseout', function(e){
        if(e.type=='mouseover')
        {
            if ($.browser.msie) {
                $(this).next('.tooltip').stop(false,true).show();
            } else {
                $(this).next('.tooltip').stop(false,true).fadeIn();
            }
        }
        else if(e.type=='mouseout')
        {
            if ($.browser.msie) {
                $(this).next('.tooltip').stop(false,true).hide();
            } else {
                $(this).next('.tooltip').stop(false,true).fadeOut();
            }
        }
    });

    //
    $('#reg_form_name').focus();

    $.extend($.fn.jGrowl.prototype.defaults, {
        closerTemplate: '<div>[ Закрыть все ]</div>'
    });

    // контроллеры
    $('.header .enter_site').authBlock();
    $('.jsRegForm').registerForm();
    $('#headerAuthForm').authForm();
    $('#authorizeBox').authorizeBox();
    $('#rememberForm').rememberForm();
    $('#auth_change_password_popup').changePasswordForm();
	$('.js-catalog').catalog();
	$('.js-tabs').tabs();
	$('#catalog-detail').catalogDetail();
	$('.js-review').reviews();
	$('.js-profile').profileController();
	$('#order_call_popup').contactForm();
	$('.js-basket').basketUI();
	$('.js-basket-str').basketStr();
	$('.content').basketAdder();
	$('.js-search-results').searchResults();
	$('.jsNumberInput').inputInc();
	$('.js-ordering').orderingCtrl();


    if (/change_password=yes/i.test(location.search)) {
        $('#auth_change_password_popup_link').click();
    }
    if (APP.USER.passwordChanged) {
        $('#auth_changed_password_successfully_link').click();
    }

    if ($.isArray(APP.GROWL)) {
        $.each(APP.GROWL, function (i, val) {
            $.jGrowl(val);
        });
    }

    // закрытие fancybox, если само не закрылось
    $(document).on('keydown', function (e) {
        if (e.keyCode == 27 && $('#fancybox-wrap:visible').length) {
            $.fancybox.close();
        }
    });
});

(function (window, jQuery, $, undefined) {

    // блок авторизации в шапке
    $.Controller('APP.AuthBlock',
        {
            pluginName: 'authBlock'
        },
        {
            'form .submit click': function (el, ev) {
                el.closest('form').find('input[type="submit"]').click();
            }
        }
    );


    $.Controller('APP.FormTabber',
        {
            pluginName: 'formTabber',
            start: 1000,
            defaults: {
                exclude: ['file',  'hidden'],
                parents: '',
                start: 1
            }
        },
        {
            init: function () {
                this.o = this.options;
                this.c = this.constructor;

                this.o.start = this.o.start + this.c.start;

                var tabindex = this.o.start + 1;
                this.inputs = this.find('input, select, textarea, a');
                var self = this;
                this.inputs = this.inputs.filter(function (i) {
                    return !!($.inArray($(this).attr('type'),self.o.exclude) === -1);
                });

                this.first = this.o.start;
                var style = ' style="position: absolute; z-index: -10; width: 1px; height: 1px; border: 0;" ';
                var firstEl = this.inputs.first();
                if (this.o.parents) {
                    firstEl = firstEl.closest(this.o.parents);
                }
                firstEl.before('<input type="text" tabindex="' + (this.o.start) + '"' + style + '/>');
                this.inputs.each(function () {
                    $(this).attr('tabindex', tabindex++);
                });
                this.last = tabindex;

                var lastEl = this.inputs.last();
                if (this.o.parents) {
                    lastEl = lastEl.closest(this.o.parents);
                }
                lastEl.after('<input type="text" tabindex="' + tabindex + '"' + style + '/>');

                this.c.start += 100;
            },

            '* focus': function (el, ev) {
                this.checkAndJump(ev.target);
            },

            checkAndJump: function (el) {
                var index = $(el).attr('tabindex');

                if (index == this.first) {
                    this.find('[tabindex="' + (this.last - 1) + '"]').focus();
                } else if (index == this.last) {
                    this.find('[tabindex="' + (this.o.start + 1) + '"]').focus();
                }
            }
        }
    );

    $.Controller('APP.FormValidator',
        {
            pluginName: 'formValidator',
            defaults: {
                validate: {
                    errorPlacement: function (error, element) {},

                    highlight: function (element, errorClass) {
                        $(element).closest('.text_input, .textarea_input').addClass('error');
                        $(element).parents('tr').find('i').show();
                    },

                    unhighlight: function (element, errorClass) {
                        $(element).closest('.text_input, .textarea_input').removeClass('error').next('.tooltip').hide();
                        $(element).parents('tr').find('i').hide();
                        if ($.browser.msie) {
                            $(element).parents('tr').find('.jsError .tooltip').stop(false,true).hide();
                        } else {
                            $(element).parents('tr').find('.jsError .tooltip').stop(false,true).fadeOut();
                        }
                    }
                }
            }
        },
        {
            init: function () {
                this.element.validate(this.options.validate);
                this.element.on('submit', this.proxy(this.onSubmit));
            },

            '.error hover': function (el, ev) {
                if (ev.type == 'mouseenter') {
                    if ($.browser.msie) {
                        el.closest('tr').find('.jsError .tooltip').stop(false,true).show();
                    } else {
                        el.closest('tr').find('.jsError .tooltip').stop(false,true).fadeIn();
                    }

                } else if(ev.type=='mouseleave') {
                    if ($.browser.msie) {
                        el.closest('tr').find('.jsError .tooltip').stop(false,true).hide();
                    } else {
                        el.closest('tr').find('.jsError .tooltip').stop(false,true).fadeOut();
                    }
                }
            },

            onSubmit: function (ev) {
                if (!this.element.valid()) {
                    ev.preventDefault();
                    ev.stopImmediatePropagation();
                }
            }
        }
    );

    $.Controller('APP.RegisterForm',
        {
            pluginName: 'registerForm'
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element;
                this.form.formTabber({exclude: ['file', 'hidden']});
                this.form.formValidator();
                this.inputs = this.find('input[type="text"], input[type="password"]').filter('[name]:visible');
            },

            '{document} ready': function () {
                var input;
                if (this.inputs.closest('.text_input.error').length) {
                    input = this.inputs.closest('.text_input.error').find(this.inputs);
                } else {
                    input = this.inputs;
                }

                setTimeout(function () {input.first().focus();}, 500);
            }
        }
    );

    $.Controller('APP.AuthForm',
        {
            pluginName: 'authForm'
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element.find('form');
                this.form.formTabber({exclude: ['file', 'hidden']});
                this.form.formValidator();
                this.form.on('submit', this.proxy(this.onSubmit));
                this.errors = this.find('.errors');
            },

            onSubmit: function (ev) {
                ev.preventDefault();
                var params = $.extend({t: (new Date()).getTime()}, this.form.formParams());
                $.post(APP.C.P_AJAX + 'auth.php', params, this.proxy(function (res) {
                    if (res.success) {
                        if (params.backurl == decodeURI(location.pathname + location.search)) {
                            location.reload();
                        } else {
                            location = params.backurl;
                        }
                        this.errors.addClass('js-hidden');
                        $.fancybox.close();

                    } else {
                        this.errors.html(res.result.MESSAGE).removeClass('js-hidden');
                    }
                }), 'json');
            }
        }
    );

    $.Controller('APP.AuthorizeBox',
        {
            pluginName: 'authorizeBox'
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element.find('form');
                this.form.formTabber({exclude: ['file', 'hidden']});
                this.form.formValidator();
            }
        }
    );


    $.Controller('APP.RememberForm',
        {
            pluginName: 'rememberForm'
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element.find('form');
                this.form.formTabber({exclude: ['file', 'hidden']});
                this.form.formValidator();
                this.form.on('submit', this.proxy(this.onSubmit));
                this.errors = this.find('.errors');
            },

            onSubmit: function (ev) {
                ev.preventDefault();
                var params = $.extend({t: (new Date()).getTime()}, this.form.formParams());
                $.post(APP.C.P_AJAX + 'remember.php', params, this.proxy(function (res) {
                    if (res.success) {
                        this.errors.html('');
                        $('#auth_changed_password_popup_link').click();

                    } else {
                        this.errors.html(res.message).removeClass('js-hidden');
                    }
                }), 'json');
            }
        }
    );


    $.Controller('APP.ChangePasswordForm',
        {
            pluginName: 'changePasswordForm'
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element.find('form');
                this.form.formTabber({exclude: ['file', 'hidden']});
                this.form.formValidator();
                this.form.on('submit', this.proxy(this.onSubmit));
                this.errors = this.find('.errors');
            },

            onSubmit: function (ev) {
                ev.preventDefault();
                var params = $.extend({t: (new Date()).getTime()}, this.form.formParams());
                $.post(APP.C.P_AJAX + 'change-password.php', params, this.proxy(function (res) {
                    if (res.success) {
                        location = '/';

                    } else {
                        this.errors.html(res.message).removeClass('js-hidden');
                    }
                }), 'json');
            },

            '.jsClosePopup click': function () {
                location = '/';
            }
        }
    );


    $.Controller('APP.Catalog',
        {
            pluginName: 'catalog'
        },
        {
			init: function(){
				this.list = this.find('.js-catalog-list');
				this.list.contentViewer();

				this.find('.js-catalog-sort').catalogSort({'list':this.list});
				$('#catalog-filter').catalogFilter({'list':this.list});
			},

			'.js-ajax-nav click': function(el, e){
				e.preventDefault();

				$.ajax({
					url: el.attr('href'),
					type: 'POST',
					beforeSend: this.proxy(function(data){
						this.list.trigger('showLoader');
					}),
					success: this.proxy(function(data){
						this.list.html(data).trigger('contentShows');
					})
				});
			}
		}
	);


    $.Controller('APP.Catalog.Sort',
        {
            pluginName: 'catalogSort'
        },
        {
			init: function(){
				this.o = this.options;
				this.list = this.o.list;

				this.triggers = this.find('a');

				this.triggers.each(function(i, el){
					var $el = $(el),
						vector = $el.attr('data-vector') || 'DESC';

					$el.data('vector', vector);
				});

			},

			'a click': function(el, e){
				this.triggers.removeClass('active');
				el.addClass('active');

				var vector = el.data('vector');
				if (vector == 'ASC'){
					el.removeClass('up');
					el.addClass('down');
					el.data('vector', 'DESC');
				}
				else{
					el.removeClass('down');
					el.addClass('up');
					el.data('vector', 'ASC');
				}

				$.ajax({
					url: APP.C.P_THIS_DIR,
					data: 'SORT[ORDER]='+el.attr('data-sort')+'&SORT[BY]='+el.data('vector'),
					type: 'POST',
					beforeSend: this.proxy(function(data){
						this.list.trigger('showLoader');
					}),
					success: this.proxy(function(data){
						this.list.html(data).trigger('contentShows');
					})
				});
			}
		}
	);


    $.Controller('APP.Catalog.Filter.Slider',
        {
            pluginName: 'priceSlider',
			defaults:{
				MIN_RANGE: 1,
				MAX_RANGE: 20000
			}
        },
        {
			init: function(){
				this.o = this.options;

				this.slider = this.find('.js-slider-track');
				this.priceFrom 	= this.find('.js-price-from');
				this.priceTo	= this.find('.js-price-to');
				this.slider.slider({
					range: true,
					min: this.o.MIN_RANGE,
					max: this.o.MAX_RANGE,
					values: [ 1, 20000 ],
					slide: this.proxy(function(e, ui) {
						this.priceFrom.val(ui.values[0]);
						this.priceTo.val(ui.values[1]);
					})
				});
				this.slider.find('.ui-slider-handle').filter(':first').addClass('left');
				this.priceFrom.val(1);
				this.priceTo.val(20000);
			},

			'.js-price-from, .js-price-to keydown': function(el, e){
				if ( e.keyCode == 46 || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 27 ||
					(e.keyCode == 65 && e.ctrlKey === true) || (e.keyCode >= 35 && e.keyCode <= 39)) {
						 return;
				}
				else {
					if ((e.keyCode < 48 || e.keyCode > 57) && (e.keyCode < 96 || e.keyCode > 105)) {
						e.preventDefault();
					}
				}
			},

			'.js-price-from keyup': function(el, e){
				var keyCode = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;

				if (keyCode == 13) {
					this.minAligment(el);
					return false;
				}

				var elVal = Number(el.val());
				var toVal = Number(this.priceTo.val());

				if (elVal == 0){
					if (keyCode != 8 && keyCode != 46){
						el.val(this.o.MIN_RANGE);
						elVal = this.o.MIN_RANGE;
					}
					else
						return true;
				}

				if (elVal >= toVal || elVal > this.o.MAX_RANGE) {
					el.val(toVal);
					this.slider.slider('values', [toVal, toVal]);
				} else {
					this.slider.slider('values', [elVal, toVal]);
				}
			},

			'.js-price-to keyup': function(el, e){
				var keyCode = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;

				if (keyCode == 13) {
					this.maxAligment(el);
					return false;
				}

				var elVal = Number(el.val());
				var fromVal = Number(this.priceFrom.val());

				if (elVal == 0){
					if (keyCode != 8 && keyCode != 46){
						el.val(fromVal);
						elVal = fromVal;
					}
					else
						return true;
				}

				if (elVal > this.o.MAX_RANGE){
					el.val(this.o.MAX_RANGE);
					elVal = this.o.MAX_RANGE;
				}
				if (elVal <= fromVal) {
					this.slider.slider('values', [fromVal, fromVal]);
				} else {
					this.slider.slider('values', [fromVal, elVal]);
				}
			},

			'.js-price-to blur': function(el, e){
				this.maxAligment(el);
			},

			'.js-price-from blur': function(el, e){
				this.minAligment(el);
			},

			maxAligment: function(el){
				var elVal = Number(el.val());
				var fromVal = Number(this.priceFrom.val());

				if (elVal == 0 || elVal < fromVal){
					el.val(this.o.MAX_RANGE);
					this.slider.slider('values', [fromVal, el.val()]);
				}
			},

			minAligment: function(el){
				var elVal = Number(el.val());
				var toVal = Number(this.priceTo.val());

				if (elVal == 0){
					el.val(this.o.MIN_RANGE);
					this.slider.slider('values', [this.o.MIN_RANGE, toVal]);
				}
			}
		}
	);


    $.Controller('APP.Catalog.Filter',
        {
            pluginName: 'catalogFilter',
        },
        {
			init: function(){
				this.o = this.options;
				this.list = this.o.list;

				this.find(".js-price-slider").priceSlider();

				this.brandPopupList = this.find('.js-brand-popup-list input');
				this.brandPopupList.on('click', this.proxy(function(e){this.sortBrands(e)}));

				this.brandList = this.find('.js-brand-list input');
				this.brandList.on('click', this.proxy(function(e){this.crossChooz(e)}));

				this.all = this.find('input');
				this.form = this.find('form');

				this.find('.js-brand-ok').click(this.proxy(function(e){
					$.fancybox.close();
				}));
			},

			sortBrands: function(e){
				$el = this.crossChooz(e);
				$el = $el.parents('label').eq(0);

				if ($el.hasClass('js-hidden')){
					$el.show();
					$el.removeClass('js-hidden');
				}
			},

			crossChooz: function(e){
				var $el = $(e.currentTarget),
					$relEl = $($el.attr('rel'));

				if ($el.is(':checked'))
					$relEl.attr('checked', 'checked');
				else
					$relEl.removeAttr('checked');

				$relEl.trigger('change');

				return $relEl;
			},

			'.js-submit click': function(el, e){
				e.preventDefault();
				$.ajax({
					url: APP.C.P_THIS_DIR,
					data: this.form.serialize(),
					type: 'POST',
					beforeSend: this.proxy(function(data){
						this.list.trigger('showLoader');
					}),
					success: this.proxy(function(data){
						this.list.html(data).trigger('contentShows');
					})
				});
			},

			'.js-group input click': function(el){
				if (!el.hasClass('js-all')){
					el.parents('.js-group').find('.js-all').removeAttr('checked').trigger('change');
				}
			},

			'.js-all click': function(el, e){
				el.parents('.js-group').find('input').not(el).removeAttr('checked').trigger('change');
			},

			'.js-reset click': function(){
				this.all.removeAttr('checked').trigger('change');
			}

        }
    );


    $.Controller('APP.Catalog.Detail',
        {
            pluginName: 'catalogDetail'
        },
        {
			init: function(){
				this.viewPort = this.find('.js-view-port');
				this.switchers = this.find('.js-preview');
				this.zoomers = this.find('.js-zoomer');

				this.zoomerList = {};
				this.switchers.each(this.proxy(function(i, el){
					var rel = $(el).attr('rel'),
						$relZoomer = $(rel);

					this.zoomerList[rel] = $relZoomer;
				}));

				this.videoLink = this.find('.js-fancy');
				this.videoLink.fancybox({
					content: $(this.videoLink.attr('data-content')).html()
				});
			},

			'.js-preview click': function(el, e){
				this.switchers.removeClass('active');
				el.addClass('active');

				this.zoomers.removeClass('active');
				this.zoomerList[el.attr('rel')].addClass('active');

				this.viewPort.attr('src', el.attr('data-img'))
			},

            '.js-view-port click': function(el, ev) {

                this.zoomers.filter('.active').trigger('click');
            }
		}
	);


    $.Controller('APP.Catalog.Detail.Reviews',
        {
            pluginName: 'reviews',
        },
        {
			init: function(){
				this.form = this.find('form');

				this.element.contentViewer({'loader':'small'});
			},

			'form submit': function(el, e){
				e.preventDefault();

				$.ajax({
					url: APP.C.P_THIS_DIR,
					data: this.form.serialize(),
					type: 'POST',
					beforeSend: this.proxy(function(data){
						this.element.trigger('showLoader');
					}),
					success: this.proxy(function(data){
						this.element.html(data).trigger('contentShows');
						this.init();
					})
				});
			},

			'.js-ajax-nav click': function(el, e){
				e.preventDefault();

				$.ajax({
					url: el.attr('href'),
					type: 'POST',
					beforeSend: this.proxy(function(data){
						this.element.trigger('showLoader');
					}),
					success: this.proxy(function(data){
						this.element.html(data).trigger('contentShows');
						this.init();
					})
				});
			}
		}
	);


    $.Controller('APP.Tabs',
        {
            pluginName: 'tabs',
        },
        {
			init: function(){
				this.tabContents = this.find('.js-tab-content');
				this.tabSwitchers = this.find('.js-tab-switcher');

				this.tabs = {};
				this.tabSwitchers.each(this.proxy(function(i, el){
					var rel = $(el).attr('rel'),
						$relContent = $(rel);

					this.tabs[rel] = $relContent;
				}));

			},

			'.js-tab-switcher click': function(el, e){
				this.tabSwitchers.removeClass('active');
				el.addClass('active');

				this.tabContents.hide();
				this.tabs[el.attr('rel')].show();
			}
		}
	);


    $.Controller('APP.CommonForm',
        {
            pluginName: 'commonForm',
            path: '',
            excludeTabbers: ['file', 'hidden'],
            defaults: {
                onSubmit: function (res) {if ($.isFunction(this._onSubmit)) {this._onSubmit(res);}},
                format: 'json',
                method: 'post'
            }
        },
        {
            init: function (el) {
                this.o = this.options;
                this.form = this.element.find('form');
                this.form.formTabber({exclude: this.o.excludeTabbers});
                this.form.formValidator();
                this.form.on('submit', this.proxy(this.onSubmit));
                this.errors = this.find('.errors');
                this.path = this.o.path ? this.o.path : this.form.attr('action');
            },

            onSubmit: function (ev) {
                ev.preventDefault();
                var params = $.extend({t: (new Date()).getTime()}, this.form.formParams());
                $[this.o.method](this.path, params, this.proxy(function (res) {
                    this.proxy(this.o.onSubmit, res)();
                }), this.o.format);
            }
        }
    );

    $.Controller('APP.ProfileSettingsBlock',
        {
            pluginName: 'profileSettingsBlock',
            listensTo: ['datasaved']
        },
        {
            init: function (el) {
                this.content = this.find('.js-block-content');
                this.changeLink = this.find('.js-change');
                this.changeLinkText = this.changeLink.text();
                this.blockId = this.element.attr('data-id');
                this.request = null;
                this.state = 'view';
            },

            '.js-change click': function (el, ev) {
                ev.preventDefault();
                this.toggle();
            },

            '.js-block-content datasaved': function (el, ev) {
                this.toggle(true);
            },

            toggle: function (reload) {
                reload = typeof reload !== 'undefined' ? reload : false;

                if (this.element.is('.js-editing')) {
                    if (!reload) {
                        this.stopLoad();
                        if (this.contentBackup && this.contentBackup.length) {
                            this.content.html('');
                            this.content.append(this.contentBackup);
                        }
                    } else {
                        this.loadBlock(false);
                        this.changeLink.html(this.changeLinkText);
                        this.element.removeClass('js-editing')
                    }

                } else {
                    if (!this.element.is('.js-loading')) {
                        this.changeLink.html('отменить');
                        this.element.addClass('js-loading');
                        this.loadBlock(true);

                    } else {
                        this.stopLoad(true);
                    }
                }

                if (!this.element.is('.js-loading')) {
                    if (!this.element.is('.js-editing')) {
                        this.element.addClass('js-editing')
                    } else {
                        this.element.removeClass('js-editing')
                    }
                }
            },

            loadBlock: function (edit) {
                edit = typeof edit !== 'undefined' ? edit : false;
                var path = '/profile/' + this.blockId + '/';

                if (edit) {
                    path += 'edit/';
                }

                this.request = $.get(path, this.proxy(function (res) {
                    this.contentBackup = this.content.children();
                    this.contentBackup.detach();
                    this.request = null;
                    this.content.empty();

                    this.content.html(res);

                    if (!this.element.is('.js-editing')) {
                        this.element.addClass('js-editing');

                        this.find('.js-settings-form').commonForm({
                            onSubmit: function (res) {
                                if (res.success) {
                                    this.element.trigger('datasaved');
                                    $.jGrowl(res.message, {theme: 'success'});

                                } else if (res.errors) {
                                    $.each(res.errors, this.proxy(function (name, val) {
                                        this.find('[name="' + name + '"]').closest('.text_input, .textarea_input').addClass('error').closest('tr').find('.tooltip').html(val);
                                    }));
                                    if (res.message) {
                                        $.jGrowl(res.message, {theme: 'error'});
                                    }
                                }
                            }
                        });

                        setTimeout(this.proxy(function () {

                            this.find('.js-settings-form').find('input, textarea, select').filter(':visible').first().focus();
                            this.find('select').chosen({no_results_text: 'нет вариантов'});
                        }), 0);

                    } else {
                        this.element.removeClass('js-editing');
                    }
                    this.element.removeClass('js-loading');
                }));
            },

            stopLoad: function (abort) {
                abort = typeof abort !== 'undefined' ? abort : false;
                this.changeLink.html(this.changeLinkText);
                this.element.removeClass('js-loading');
                if (abort && this.request) {
                    this.request.abort();
                    this.request = null;
                }

            }
        }
    );

    $.Controller('APP.ProfileController',
        {
            pluginName: 'profileController'
        },
        {
            init: function (el) {
                this.settingsForms = this.find('.js-settings-form').profileSettingsBlock();
                this.find('.js-order-list').ajaxList({params: {page: 'list'}});
            }
        }
    );

    APP.CommonForm('APP.ContactForm',
        {
            pluginName: 'contactForm'
        },
        {
            init: function () {
                this._super();
            },

            _onSubmit: function (res) {

                if (res.success) {
                    $('#order_call_popup_link').click();
                    this.find('[name="order_back_call_form[time]"]').val('');

                } else if (res.errors) {

                    $.each(res.errors, this.proxy(function (field, value) {
                        this.find('[name="' + field + '"]').closest('.text_input, .textarea_input').addClass('error');
                    }));

                } else {
                    this.errors.html('Ошибка при отправке сообщения');
                }
            }
        }
    );


    $.Controller('APP.SearchResults',
        {
            pluginName: 'searchResults'
        },
        {
            init: function (el) {
                this.page = parseInt(this.element.attr('data-page'), 10);
                if (!this.page) {this.page = 1;}
                this.searchType = this.element.attr('data-search-type');
                this.container = this.find('.js-search-list');

                this.pager = this.find('.js-show-more-pager');
                this.pagerId = this.pager.attr('data-pager');
                this.endPage = this.pager.attr('data-end-page');
                this.request = null;
            },

            loadMore: function () {
                this.load(this.page + 1);
            },

            load: function (page) {
                if (this.element.is('.js-loading') && page <= this.endPage) {
                    return;
                }
                var params = {searchType: this.searchType};
                params[this.pagerId] = page;

                this.element.addClass('js-loading');
                this.request = $.get(location.pathname + location.search, params, this.proxy(function (res) {
                    var clear = this.container.find('.clear:last');
                    if (clear.length) {
                        clear.before(res);
                    } else {
                        this.container.append(res);
                    }

                    this.element.removeClass('js-loading');
                    this.page++;
                    if (this.page == this.endPage) {
                        this.pager.remove();
                    }
                }));
            },

            '.js-show-more click': function (el, ev) {
                ev.preventDefault();
                this.loadMore();
            }
        }
    );


	$.Controller('APP.InputInciment',
		{
			pluginName: 'inputInc',
			defaults: {
				maxQ : 999,
				minQ : 1
			}
		},
		{
			init: function(){
				this.o = this.options;

				this.input = this.find('input');
			},

			'.jsNumberInputPlus click': function(el ,e){
				e.preventDefault();

				var val = Number(this.input.val());
				if (val < this.o.maxQ)
					this.input.val(val + 1);

				this.input.trigger('prog.change');
			},

			'.jsNumberInputMinus click': function(el ,e){
				e.preventDefault();

				var val = Number(this.input.val());
				if (val > this.o.minQ)
					this.input.val(val - 1);

				this.input.trigger('prog.change');
			}
		}
	);


	$.Controller('APP.Basket.UI',
		{
			pluginName: 'basketUI',
			defaults: {
				emptyStr : '<p>Ваша корзина пуста</p>',
				exceedNotice : '<div class="exceed-notice">Недостаточно товара на складе</div>'
			},
			listensTo: ['prog.change']
		},
		{
			init: function(){
				this.IDs = [1];

				this.total = this.find('.js-total');
				this.orderBtn = this.find('.js-order-btn');

				this.find('.js-item').each(this.proxy(function(i, el){
					var $price = $(el).find('.js-price'),
						$quantity = $(el).find('.js-quantity'),
						$del = $(el).find('.js-del'),
						price = Number($price.attr('data-price')),
						quntity = Number($quantity.val()),
						basketID = $quantity.attr('data');

					var id = this.getUniqID();
					$(el).attr('id', id);
					$quantity.attr('rel', id);
					$del.attr('rel', id);

					basket.items.add(id, {
									price: price,
									quantity: quntity,
									basketID: basketID
								});


					$del.on("click", this.proxy(this.deleteItem));
				}));

				this.oldVal = 0;

				this.scrollPane = this.find('.js-scroll');
				this.exceedNotice = $(this.options.exceedNotice);
			},

			calc: function($el){

				var elVal = Number($el.val());
				if (elVal > 0){
					var itemID = $el.attr('rel');

					basket.update(itemID, elVal, this.proxy(function(data, total){
						this.total.html(total.nformat(' '));

						if (data.quantity_exceed){
							$el.val(data.cur_quantity);

							$el.after(this.exceedNotice);
							setTimeout(
								this.proxy(function(){
									this.exceedNotice.remove();
								}), 1000);
						}
					}));

				}
			},

			'.js-quantity keyup': function(el, e){
				this.calc(el);
			},

			'.js-quantity prog.change': function(el, e){
				if (Number(el.val()) != 0)
					this.calc(el);
			},

			'.js-quantity keypress': function(el, e){
				var keyCode = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;
				if ( (keyCode >= 46 && keyCode < 58) || (keyCode == 8) || (keyCode == 0) ){
					if (Number(el.val()) != 0)
						this.oldVal = el.val();
				}
				else{
					e.preventDefault();
					e.stopPropagation();
				};
			},

			'.js-quantity focusout': function(el, e){
				$el = $(e.target);
				if (Number($el.val()) == 0)
					$el.val(this.oldVal);
			},

			deleteItem: function(e){
				e.preventDefault();

				var $el = $(e.currentTarget),
					itemID = $el.attr('rel');

				basket.del(itemID, this.proxy(function(data, total){
					if (data.success){
						$('#'+itemID).remove();
					}

					if (total == 0){
						this.element.empty();
						this.element.append(this.options.emptyStr);
					}
					else
						this.total.html(total.nformat(' '));
				}));

			},

			getUniqID: function(){
				var curr = this.IDs[this.IDs.length-1];
				while ($('#basket'+(curr++)).length){}
				this.IDs[this.IDs.length] = curr;
				return 'basket'+curr;
			}
		}
	);


	$.Controller('APP.Basket.String',
		{
			pluginName: 'basketStr'
		},
		{
			init: function(){
				basket.subscribe('update', this.proxy(this.updateStr));
				basket.subscribe('delete', this.proxy(this.updateStr));
			},

			updateStr: function(){
				$.ajax({
					url: APP.C.P_AJAX + 'basket_str.php',
					type: 'POST',
					success: this.proxy(function(data){
						this.element.html(data);
					})
				});
			}
		}
	);


    $.Controller('APP.OrderingController',
		{
            pluginName: 'orderingCtrl',
            listensTo: ['ajaxformloaded', 'ajaxsuccesssubmit']
		},
		{
			init: function(){
                this.tryUpdate();
			},

            '{document} ajaxformloaded': function (el, ev) {
                this.tryUpdate();
            },

            '{document} ajaxsuccesssubmit': function (el, ev) {

            },

            tryUpdate: function () {
                setTimeout(this.proxy(function() {
                    if (this.find('form:not(.js-applied)').length) {
                        this.find('.js-ordering-form').find('select').chosen({no_results_text: 'нет вариантов'});
                        this.find('form').addClass('js-applied');
                        this.find('.js-ordering-form').orderingForm();

                    } else {
                        this.tryUpdate();
                    }
                }), 100);
            }
		}
	);

    APP.CommonForm('APP.OrderingForm',
		{
            pluginName: 'orderingForm'
		},
		{
			init: function(el){
                this._super();
				this.submit = this.find('input[name="submitbutton"]');
			},

            '.js-submit click': function (el, ev) {
                ev.preventDefault();

                if (this.form.valid()) {
                    this.submit.click();
                }
            },

            _onSubmit: function () {

            }
		}
	);

    $.Controller('APP.AjaxList',
		{
            pluginName: 'ajaxList',
            defaults: {
                params: {}
            }
		},
		{
			init: function(el){
                this.list = this.find('.js-ajax-container');
			},

            '.js-ajax-nav click': function(el, e){
				e.preventDefault();

				$.ajax({
					url: el.attr('href'),
                    data: this.options.params,
					type: 'GET',
					success: this.proxy(function(data){
						this.list.html(data);
                        if (this.list.closest('.block').length) {
                            $.scrollTo(this.list.closest('.block'));
                        } else {
                            $.scrollTo(this.list);
                        }
					})
				});
			}
		}
	);


	$.Controller('APP.Basket.Add',
		{
			pluginName: 'basketAdder'
		},
		{
			'.js-add-to-cart click': function(el, e){
				e.preventDefault();

				basket.add(el.attr('data-id'), this.proxy(function(data){
					if (data.success){
						$.fancybox({
							type : 'ajax',
							href : APP.C.P_AJAX + 'basketPopup.php?basketID='+data.basketID,
							showCloseButton: false,
							onComplete: function(){
								$('.js-scroll').jScrollPane({
									verticalDragMinHeight: 39,
									verticalDragMaxHeight: 39,
									autoReinitialise: true
								});
							}
						});
					}
					else if (data.quantity_exceed){
						$.jGrowl('На складе всего '+data.max_quantity+' товар'+wordForm(data.max_quantity)+'. В вашей корзине: '+data.cur_quantity+'.');
					}
					else if (data.NOT_ON_STOCK){
						$.jGrowl('Товара нет на складе.');
					}
				}));
			}
		}
	);


	$.Controller('APP.ContentViewer',
		{
			pluginName: 'contentViewer',
			defaults: {
				loader: 'big'
			},
			listensTo: ['showLoader', 'contentShows']
		},
		{
			init: function(){
				this.el = this.element;
				this.o = this.options;

				this.loader = (this.o.loader == 'big') ? APP.AJAX_LOADER : APP.AJAX_LOADER_SMALL;
				this.wrapper = $('<div />').append(this.loader);
			},

			getParams: function(){
				this.H = this.el.height();
				this.W = this.el.width();
			},

			'showLoader': function(){
				this.getParams();

				this.el.css({'height': this.H+'px'});
				this.el.empty().append(this.wrapper);
			},

			'contentShows': function(){
				this.el.css({'height': 'auto'});
			}
		}
	);

})(window, jQuery, $, undefined);


function CBasket(){

	var self = this;

	this.items = new CBasketItems;

	this.handlers = {
		'update': [],
		'delete': []
	};

	this.subscribe = function(event, callback){
		this.handlers[event].push(callback);
	};

	this.fire = function(event, arg){
		for(var e in this.handlers)
			if (e == event){
				for(var i = 0; i<this.handlers[e].length; i++)
					this.handlers[e][i](Array.prototype.slice.call(arg));

				break;
			}
	};


	this.update = function(itemID, quantity, callback){

		this.updateQuery(itemID, quantity, $.proxy(function(data){

			if (data.success)
				this.items.list[itemID].quantity = quantity;
			else if (data.quantity_exceed)
				this.items.list[itemID].quantity = data.cur_quantity;

			if ( typeof(callback) == 'function'){
				callback(data, this.items.getTotal());
			}

			this.fire('update', arguments);

		}, this));

	}


	this.del = function(itemID, callback){

		this.delQuery(itemID, $.proxy(function(data){
			this.items.del(itemID);

			if ( typeof(callback) == 'function'){
				callback(data, this.items.getTotal());
			}

			this.fire('delete', arguments);
		}, this));

	}


	this.updateQuery = function(itemID, quantity, _callback){
		$.ajax({
			url: '/application/ajax/basket.php',
			data: {
				act: 'update',
				id:	this.items.list[itemID].basketID,
				quantity: quantity
			},
			type: 'POST',
			dataType: 'JSON',
			success: function(data){
				_callback(data);
			}
		});
	};

	this.delQuery = function(itemID, _callback){
		$.ajax({
			url : '/application/ajax/basket.php',
			data: {
				act: 'delete',
				id:	this.items.list[itemID].basketID
			},			
			type: 'POST',
			dataType: 'JSON',
			success: function(data){
				_callback(data);
			}
		});
	};

	this.add = function(prodID, callback){
		$.ajax({
			url: APP.C.THIS_DIR,
			data: {'action':'ADD2BASKET', 'id':prodID},
			type: 'POST',
			dataType: 'JSON',
			success: function(data){
				if ( typeof(callback) == 'function'){
					callback(data);
				}
				self.fire('update', data);
			}
		});
	};
};


CBasketItems = function(){

	this.list = {},
	this.counter = 0,
	this.totalSum = 0,

	this.del = function(id){
		delete this.list[id];
		this.counter--;
		return this.counter;
	},

	this.add = function(id, ob){
		this.list[id] = ob;
		this.counter++;
	},

	this.calc = function(){
		var sum = 0;
		for(var id in this.list){
			sum = sum + this.list[id].price * this.list[id].quantity;
		}
		this.totalSum = sum;
	},

	this.getTotal = function(){
		this.calc();
		return this.totalSum;
	}

};

basket = new CBasket;









