{$meta_title = "Сравнение" scope=parent}
{$canonical="/wishlist" scope=parent}

<div class="innerW">
  <!-- Заголовок страницы -->
  <h1 class="h1Title">Сравнение</h1>
  <ul class="crumbsCenter">
    <!-- Хлебные крошки /-->
    <li><a href="./">Главная</a></li>
    <li>Сравнение</li>                
    <!-- Хлебные крошки #End /-->      
  </ul>  

  {if $compared_products|count}
  <div class="itemsBox">
    <table class="itemsList compare">
      <tr>
        <th></th>
        {foreach $products as $product}
        <td>
          <div class="item">
            <!-- Фото товара -->
            {if $product->image}
            <div class="pic">
                <img src="{$product->image->filename|resize:145:145}" alt="{$product->name|escape}"/>
            </div>
            {/if}
            <!-- Фото товара (The End) -->
            
            <!-- Название товара -->
            <span class="text"><a data-product="{$product->id}" href="products/{$product->url}"> {$product->name|escape} </a></span>
            <!-- Название товара (The End) -->          
            </div>
        </td>
        {/foreach}
      </tr>
      {foreach $features as $k=>$f}
      <tr>      
        <th class="compare_title">{$f}</th>
        {foreach $products as $p}
        <td class="compare_product">{$p->features[$k]->value}</td>
        {/foreach}
      </tr>
      {/foreach}
      <tr>
        <th></th>
        {foreach $products as $product}
        <td>
          <div class="item">
            {if $product->variants|count > 0}
            <!-- Выбор варианта товара -->
            <form class="variants" action="/cart">
                
              {foreach $product->variants as $v}
              
              <input id="featured_{$v->id}" name="variant" value="{$v->id}" type="radio" class="variant_radiobutton" {if $v@first}checked{/if} {if $product->variants|count<2}style="display:none;"{/if}/>

              {if $v->name}<label class="variant_name" for="featured_{$v->id}">{$v->name}</label>{/if}
              
              <span class="price">{if $v->compare_price > 0}<span class="price_old">{$v->compare_price|convert}</span>{/if} {$v->price|convert} <i class="fa fa-rub"></i></span>
                  
              {/foreach}
              
              <img class="korz" src="design/{$settings->theme}/images/korz.png"><input class="buy" type="submit"  value="в корзину" data-result-text="добавлено"/>
            </form>
            <!-- Выбор варианта товара (The End) -->
            
            {else}
                Нет в наличии
            {/if}        
            </div>
        </td>
        {/foreach}
      </tr>
    </table>
  </div>
  {else}
  <h3>Нет товаров для сравнения. <a href="./catalog">Перейти к выбору?</a></h3>
  {/if}

  <div class="clear"></div>
</div>