<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=1200">
	<link rel="stylesheet" href="assets/css/style.css">
	<script type="text/javascript" src="assets/js/jquery-1.10.2.min.js"></script>
	<script type="text/javascript" src="assets/js/TweenMax.min.js"></script>
	<script type="text/javascript" src="js/pieces.wp.animations.js"></script>
   <script type="text/javascript" src="js/pieces.wp.min.js"></script>
	<script type="text/javascript" src="assets/js/angular.min.js"></script>
	<link type="text/css" href="assets/js/jscrollpane/jquery.jscrollpane.css" rel="stylesheet" media="all" />
	<script type="text/javascript" src="assets/js/jscrollpane/jquery.mousewheel.js"></script>
	<script type="text/javascript" src="assets/js/jscrollpane/jquery.jscrollpane.min.js"></script>		
</head>
<body>

<script>


<?php

   if (!isset($_REQUEST["standalone"])) $_REQUEST["standalone"] = "";
   if ($_REQUEST["standalone"])
      echo 'top.pieces_img = "<img src=\"assets/images/pieces-img.jpg\">";';

?>


   function animationsCtrl($scope, $http)
   {
<?php

   echo ($_REQUEST["standalone"]) ? '$scope.standalone = true;' : '$scope.standalone = false;';

?>      
      $scope.type = "in";
      $scope.animations = [];
      $scope.cols = 10;
      $scope.rows = 10;
      $scope.responsive = true;
      $scope.masked = false;
      $scope.event = "start";
      $scope.code = "";

      $scope.events = {
         "start": {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false},
         "mouseover": {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false},
         "mouseout": {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false},
         "click": {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false},
         "visible": {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false}
      };

      $scope.selectResponsive = function(item){
         $scope.responsive = item;
         $scope.createCode();
      };

      $scope.selectEvent = function(item){
         $scope.event = item;
         $scope.playAnimation();
         $scope.createCode();
      };

      $scope.selectMasked = function(item){
         $scope.masked = item;
         $scope.playAnimation();
         $scope.createCode();
      };

      $scope.selectType = function(item){
         $scope.type = item;
         $scope.createCode();
      };

      $scope.selectOrder = function(item){
         $scope.events[$scope.event].order = item;
         $scope.playAnimation();
         $scope.createCode();
      };

      $scope.selectOverwrite = function(item){
         $scope.events[$scope.event].overwrite = item;
         $scope.playAnimation();
         $scope.createCode();
      };

      $scope.selectAnimation = function(item){
         $scope.events[$scope.event].animation = item;
         $scope.playAnimation();
         $scope.createCode();
      };

      $scope.playAnimation = function()
      {
         if ($scope.events[$scope.event].animation === "")
            return false;

         var el = $j(top.pieces_img).removeAttr("style").attr("width", "").attr("height", "").width(600);

         $j(".preview").empty();
         $j(".preview").append(el);
         $j(".preview img").pieces({
            onStart:{
               animation:$scope.events[$scope.event].animation.name,
               speed:$scope.events[$scope.event].speed,
               stagger:$scope.events[$scope.event].stagger,
               order:$scope.events[$scope.event].order,
               delay:$scope.events[$scope.event].delay,
               overwrite:$scope.events[$scope.event].overwrite
            },
            cols:$scope.cols,
            rows:$scope.rows,
            masked:$scope.masked
         });
      };

      $scope.getAnimation = function(name)
      {
         for(a=0; a<$scope.animations.length; a++) {
            if ($scope.animations[a].name == name)
               return $scope.animations[a];
         };

         return null;
      }

      $scope.getData = function()
      {
         var el = $j(top.pieces_img);

         $j.each($scope.events, function(key, value)
         {
            var str = el.attr("data-" + key);
            if (str !== undefined)
            {
               var obj = str.replace(/\s+/g, '').split(",");

               $scope.events[key]["animation"] = $scope.getAnimation(obj[0]);
               $scope.events[key]["speed"] = obj[1];
               $scope.events[key]["stagger"] = obj[2];
               $scope.events[key]["delay"] = obj[3];
               $scope.events[key]["order"] = obj[4];
               $scope.events[key]["overwrite"] = (obj[5] === true);
            }
         });

         var str = el.attr("data-config");
         if (str !== undefined)
         {
            var obj = str.replace(/\s+/g, '').split(",");
            $scope.cols = obj[0];
            $scope.rows = obj[1];
            $scope.responsive = (obj[2] === true);
            $scope.masked = (obj[3] === true);
         }
      };

      $scope.getDataStandAlone = function()
      {
         $scope.events["start"] = (parent.current_settings.onStart !== undefined) ? parent.current_settings.onStart : {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};
         $scope.events["click"] = (parent.current_settings.onClick !== undefined) ? parent.current_settings.onClick : {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};
         $scope.events["mouseover"] = (parent.current_settings.onMouseOver !== undefined) ? parent.current_settings.onMouseOver : {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};
         $scope.events["mouseout"] = (parent.current_settings.onMouseOut !== undefined) ? parent.current_settings.onMouseOut : {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};
         $scope.events["visible"] = (parent.current_settings.onVisible !== undefined) ? parent.current_settings.onVisible : {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};

         $j.each($scope.events, function(key, value) {
            if ($scope.events[key] === undefined)
               $scope.events[key] = {animation: "", order: "forward", speed: 100, stagger: 100, delay: 0, overwrite: false};
            if (($scope.events[key]["animation"] != undefined) && ($scope.events[key]["animation"] != ""))
               $scope.events[key]["animation"] = $scope.getAnimation($scope.events[key]["animation"]);
         });
         
         $scope.cols = (parent.current_settings.cols != undefined) ? parent.current_settings.cols : 10;
         $scope.cols = (parent.current_settings.rows != undefined) ? parent.current_settings.rows : 10;
         $scope.responsive = (parent.current_settings.responsive != undefined) ? parent.current_settings.responsive : true;
         $scope.masked = (parent.current_settings.masked != undefined) ? parent.current_settings.masked : false;
      };

      $scope.createCode = function()
      {
         var el = $j(top.pieces_img);
         var num_anims = 0;

         $j.each($scope.events, function(key, value)
         {
            el.removeAttr("data-" + key);
            if (($scope.events[key].animation != "") && ($scope.events[key].animation != null))
            {
               num_anims++;
               el.attr(
                  "data-" + key, 
                  $scope.events[key].animation.name + "," +
                  $scope.events[key].speed + "," +
                  $scope.events[key].stagger + "," +
                  $scope.events[key].delay + "," +
                  $scope.events[key].order + "," +
                  $scope.events[key].overwrite
               );
            }
         });

         if (num_anims > 0)
         {
            el.attr(
               "data-config", 
               $scope.cols + "," +
               $scope.rows + "," +
               $scope.responsive + "," +
               $scope.masked
            );
         };

         $scope.code = $j('<div>').append(el.clone()).html();
      }


      $scope.createCodeForStandAlone = function()
      {
         $scope.code_stand_alone = {}; 
         var num_anims = 0;

         $j.each($scope.events, function(key, value)
         {
            if (($scope.events[key].animation != "") && ($scope.events[key].animation != null))
            {
               num_anims++;

               var key_name = (key == "start") ? "onStart" :
                              (key == "click") ? "onClick" :
                              (key == "mouseover") ? "onMouseOver" :
                              (key == "mouseout") ? "onMouseOut" :
                              (key == "visible") ? "onVisible" : "";

               $scope.code_stand_alone[key_name] = {
                  "animation": $scope.events[key].animation.name,
                  "speed": $scope.events[key].speed,
                  "stagger": $scope.events[key].stagger,
                  "delay": $scope.events[key].delay,
                  "order": $scope.events[key].order,
                  "overwrite": $scope.events[key].overwrite
               };
            }
         });

         if (num_anims > 0)
         {
            $scope.code_stand_alone["cols"] = $scope.cols;
            $scope.code_stand_alone["rows"] = $scope.rows;
            $scope.code_stand_alone["responsive"] = $scope.responsive;
            $scope.code_stand_alone["masked"] = $scope.masked;
         };
      }

      
      $scope.sendCode = function()
      {
         // Send data to Admin
         if ($scope.standalone)
         {
            $scope.createCodeForStandAlone();
            parent.getDataFromPopUp($scope.code_stand_alone);
            parent.tb_remove();
         }

         // Send data to Tiny
         else
         {
            $scope.createCode();
            parent.insertShortcode($scope.code);
            parent.tinyMCE.activeEditor.windowManager.close(window);
         }
      }

      $scope.isImage = function()
      {
         return $j(top.pieces_img).is("img");
      }
      


      // Initialization
      $scope.animations = pieces_animations;

      if ($scope.standalone)
      {
         $scope.getDataStandAlone();
         $scope.createCodeForStandAlone();
      }
      else
      {
         $scope.getData();
         $scope.createCode();
      }

      var el = $j(top.pieces_img).removeAttr("style").attr("width", "").attr("height", "").width(600);
      $j(".preview").append(el);
      
   }



	$j(document).ready(function()
	{
      TweenMax.set($j("#col_sx, #anim_settings, #event_tabs, #top_settings, .save_btn"), {z:100});

      if (jQuery.isFunction(parent.resizeTB))
         parent.resizeTB();

      $j("#input_cols, #input_rows, #input_speed, #input_stagger, #input_delay").blur(function() {
         angular.element('#animationsCtrl').scope().playAnimation();
         angular.element('#animationsCtrl').scope().createCode();
      });

      $j(".anims").jScrollPane({
         verticalGutter:5,
         mouseWheelSpeed:60,
         maintainPosition:true,
         autoReinitialise:true,
         autoReinitialiseDelay:200,
         hideFocus:true
      });

      angular.module('myApp', []);
      angular.bootstrap(document, ['myApp']);
   });


</script>



<div class="wps">
   <div ng-controller="animationsCtrl" id="animationsCtrl" style="padding:20px;">
  
      <div ng-show="!isImage()" style="width:100%; margin-top:50px; text-align:center; font-size:16px;">
         Please select an image before opening the configurator
      </div>       
      <div style="width:100%;" ng-show="isImage()">
         <div style="float:left; width:100%; padding-bottom:10px;" id="top_settings">
            <h2 class="t0" style="padding-bottom:10px">MasterPiece Configurator <div class="sel" ng-click="sendCode()" style="float:right">SAVE</div> </h2>
            <div style="width:100%">
               <div style="float:left; width:150px;">
                  Columns: <input type="text" ng-model="cols" style="width:40px" id="input_cols">
               </div>
               <div style="float:left; width:130px;">
                  Rows: <input type="text" ng-model="rows" style="width:40px" id="input_rows">
               </div>
               <div style="float:left; width:220px;">
                  Responsive: 
                  <div class="sel" ng-click="selectResponsive(true)" ng-class="{flagd:responsive == true}">YES</div> 
                  <div class="sel" ng-click="selectResponsive(false)" ng-class="{flagd:responsive == false}">NO</div> 
               </div>
               <div style="float:left; width:200px;">
                  *Masked: 
                  <div class="sel" ng-click="selectMasked(true)" ng-class="{flagd:masked == true}">YES</div> 
                  <div class="sel" ng-click="selectMasked(false)" ng-class="{flagd:masked == false}">NO</div>

               </div>
            </div>

         </div>
         <br>* Select Yes to makes the animation pieces remain contained inside the image widht <br> <br>
         <div style="margin-top:40px; float:left; clear:both; width:100%; background:#fff; border:1px solid #aaa;">

            <div style="position:relative; float:left; clear:both; margin:-33px 0 0 0px; width:100%;" id="event_tabs">
               <div class="tab" ng-click="selectEvent('start')" ng-class="{flagd:event == 'start'}">START<span class="blue_bull" ng-show="events.start.animation!=''"> &#9733;</span></div> 
               <div class="tab" ng-click="selectEvent('mouseover')" ng-class="{flagd:event == 'mouseover'}">MOUSE OVER<span class="blue_bull" ng-show="events.mouseover.animation!=''"> &#9733;</span></div> 
               <div class="tab" ng-click="selectEvent('mouseout')" ng-class="{flagd:event == 'mouseout'}">MOUSE OUT<span class="blue_bull" ng-show="events.mouseout.animation!=''"> &#9733;</span></div> 
               <div class="tab" ng-click="selectEvent('click')" ng-class="{flagd:event == 'click'}">CLICK<span class="blue_bull" ng-show="events.click.animation!=''"> &#9733;</span></div> 
               <div class="tab" ng-click="selectEvent('visible')" ng-class="{flagd:event == 'visible'}">VISIBLE<span class="blue_bull" ng-show="events.visible.animation!=''"> &#9733;</span></div> 
            </div>

            <div style="float:left; clear:both; padding:20px;">
               <div style="float:left; clear:both; width:240px;" id="col_sx">

                  <h3 class="t0">Animations</h3>

                  <div id="type_in" class="sel" style="width:29px;" ng-click="selectType('in')" ng-class="{flagd:type == 'in'}">IN</div> 
                  <div class="sel" style="width:29px;" ng-click="selectType('out')" ng-class="{flagd:type == 'out'}">OUT</div> 
                  <div class="sel" style="width:29px;" ng-click="selectType('mid')" ng-class="{flagd:type == 'mid'}">MID</div> 

                  <div class="anims">
                     <div class="anims_wrapper">
                        <div class="anim_item" ng-click="selectAnimation('')" ng-class="{current:events[event].animation == ''}" >
                           - none -
                        </div>
                        <div class="anim_item" ng-repeat="item in animations | filter:{type:type}" ng-click="selectAnimation(item)" ng-class="{current:item == events[event].animation}" >
                           {{item.name}}
                        </div>
                     </div>
                  </div>
               </div>
               
               <div style="float:left; width:600px;">

                  <h3 class="t0">Settings</h3>

                  <div id="anim_settings">
                     <div style="float:left; clear:both; width:100%; margin-top:0px">
                        <div style="float:left; width:160px;">
                           Speed: 
                           <input type="text" ng-model="events[event].speed" style="width:40px" id="input_speed"> %
                        </div>
                        <div style="float:left; width:180px;">
                           Stagger: 
                           <input type="text" ng-model="events[event].stagger" style="width:40px" id="input_stagger"> %
                        </div>
                        <div style="float:left; width:180px;">
                           Delay: 
                           <input type="text" ng-model="events[event].delay" style="width:40px" id="input_delay"> seconds
                        </div>
                     </div>

                     <div style="float:left; clear:both; width:100%; margin-top:20px">
                        <div style="float:left; width:340px;">
                           Order: 
                           <div class="sel" ng-click="selectOrder('forward')" ng-class="{flagd:events[event].order == 'forward'}">FORWARD</div> 
                           <div class="sel" ng-click="selectOrder('reverse')" ng-class="{flagd:events[event].order == 'reverse'}">REVERSE</div> 
                           <div class="sel" ng-click="selectOrder('random')" ng-class="{flagd:events[event].order == 'random'}">RANDOM</div> 
                        </div>
                        <div style="float:left; width:200px;" ng-show="event=='mouseover' || event=='mouseout' || event=='click'">
                           Overwrite: 
                           <div class="sel" ng-click="selectOverwrite(true)" ng-class="{flagd:events[event].overwrite == true}">YES</div> 
                           <div class="sel" ng-click="selectOverwrite(false)" ng-class="{flagd:events[event].overwrite == false}">NO</div> 
                        </div>
                     </div>
                  </div>

                  <div class="preview" style="float:left; clear:both; width:100%; margin-top:20px">
                  </div>

               </div>
            </div>
         </div>
         
         
         <div style="margin-top:20px; float:left; clear:both; width:100%; text-align:right">
            <div class="sel save_btn" ng-click="sendCode()">SAVE</div> 
         </div>
      </div>
   </div>

</div>

</body>
</html>