<?php
/*
Plugin Name: WP MasterPiece
Plugin URI: http://WP-Masterpiece.com
Description: Search Out and then Create Amazing Image Animations on  Demand!
Author: WP-MasterPiece
Version: 1.0.0
Author URI: http://WP-Masterpiece.com
*/



global $wpdb, $wp_version;
define("WP_PIECES_TABLE", $wpdb->prefix . "pieces_plugin");
define('WP_PIECES_SITE', 'http://www.VivekSharmaLive.com/');
if (!defined( 'WP_PIECES_ADMIN_URL'))
	define( 'WP_PIECES_ADMIN_URL', get_option('siteurl') . '/wp-admin/options-general.php?page=pieces-admin');
if (!defined('WP_PIECES_PLUGIN_BASE_PATH'))
	define('WP_PIECES_PLUGIN_BASE_PATH', WP_PLUGIN_URL . "/" . trim(dirname(plugin_basename(__FILE__)), '/'));



function piecesInstall() 
{
	global $wpdb;
	if($wpdb->get_var("show tables like '". WP_PIECES_TABLE . "'") != WP_PIECES_TABLE) 
	{
		$sql = "
			CREATE TABLE " . WP_PIECES_TABLE . " (
			id_pieces mediumint(9) NOT NULL AUTO_INCREMENT,
			selector TEXT NOT NULL,
			animations TEXT NOT NULL,
			PRIMARY KEY (`id_pieces`));";
		$wpdb->query($sql);
	}
}












function piecesGetBehaviors() 
{
	global $wpdb;
	
	$sSql = "select * from " . WP_PIECES_TABLE;
	$data = $wpdb->get_results($sSql);
	if (!empty($data))
	{
		echo "<script>";
		echo '$j(document).ready(function(){';
		foreach ($data as $row) 
		{
			echo '$j("' . $row->selector . '").pieces(' . stripcslashes($row->animations) . ')';
		}
		echo "});";
		echo "</script>";
	}
}

add_action ('wp_head', 'piecesGetBehaviors');



add_action('init', 'addPiecesButton');

function addPiecesButton() {
   if ( current_user_can('edit_posts') &&  current_user_can('edit_pages') )
   {
		add_filter('mce_external_plugins', 'addPiecesPlugin');
		add_filter('mce_buttons', 'registerPiecesButton');
   }
}

function registerPiecesButton($buttons) {
   array_push($buttons, "pieces");
   return $buttons;
}

function addPiecesPlugin($plugin_array) {
   $plugin_array['pieces'] = WP_PIECES_PLUGIN_BASE_PATH . '/configurator.js';
   return $plugin_array;
}




function piecesAddJs() 
{
	wp_enqueue_script('jquery');
	wp_enqueue_script('tweenmax', WP_PIECES_PLUGIN_BASE_PATH.'/assets/js/TweenMax.min.js');
	wp_enqueue_script('pieces_animations', WP_PIECES_PLUGIN_BASE_PATH.'/js/pieces.wp.animations.js');
	wp_enqueue_script('pieces', WP_PIECES_PLUGIN_BASE_PATH.'/js/pieces.wp.min.js');
}




	include 'imageGrabber.php';

function piecesDeactivation() 
{
}


add_action('wp_enqueue_scripts', 'piecesAddJs');
register_activation_hook(__FILE__, 'piecesInstall');
register_deactivation_hook(__FILE__, 'piecesDeactivation');


?><?php
			

add_action("admin_menu", "tutorialvideo_menu_0e90");

function tutorialvideo_menu_0e90(){
	add_options_page("Tutorial Video","Tutorial Video","manage_options","tutorialvideo","tutorialvideo_page");
}
function tutorialvideo_page(){
?>
<center><p style="text-align: center;">
	<span style="font-size:28px;"><strong><span style="background-color:#00ff00;">WP-MasterPiece Tutorial Video</span></strong></span></p>
<p style="text-align: center;">
	&nbsp;</p>
<p style="text-align: center;">
	&nbsp;</p>
<p>
	<iframe allowfullscreen="" frameborder="0" height="515" src="//www.youtube.com/embed/fMwUmMClrqk" width="760"></iframe></p>
</center>
<?php
}
		

add_action("admin_menu", "commissions_menu_1748");

function commissions_menu_1748(){
	add_options_page("Commissions","Commissions","manage_options","commissions","commissions_page");
}
function commissions_page(){
?>
<center><p style="text-align: center;">
	<img alt="" src="http://www.wp-masterpiece.com/demo2/wp-content/uploads/2014/08/yyuuyyuuy.png" style="width: 535px; height: 271px;" /></p>
<p style="text-align: center;">
	&nbsp;</p>
<p style="text-align: center;">
	<span style="font-family:comic sans ms,cursive;"><span style="font-size: 16px;"><strong>If you like WP-MasterPiece and would like to earn some extra cash by telling your</strong></span></span></p>
<p style="text-align: center;">
	<span style="font-family:comic sans ms,cursive;"><span style="font-size: 16px;"><strong>friends and sharing it with people that could use it, then you can apply to be an affiliate! </strong></span></span></p>
<p style="text-align: center;">
	<strong><span style="font-family:comic sans ms,cursive;"><span style="font-size: 16px;">Earn Huge Commissions on an EASY to sell product! </span></span></strong></p>
<p style="text-align: center;">
	&nbsp;</p>
<p style="text-align: center;">
	<a href="http://wp-masterpiece.com/wpmp/jv.html" target="_blank"><span style="font-size:20px;">***SIGN UP TO BE AN AFFILIATE &amp; LEARN MORE HERE***</span></a></p>
<p style="text-align: center;">
	&nbsp;</p>
<p style="text-align: center;">
	<img alt="" src="http://www.wp-masterpiece.com/demo2/wp-content/uploads/2014/08/2014-08-18_0002.png" style="width: 514px; height: 435px;" /></p>
</center>
<?php
}
		
			?>