<?php
if(!defined('MYSTAT_VERSION')){
  throw new Exception('File not exist 404');
}

class myStat{

  protected $driver = false;

  public function getDriver(){
    return $this->driver;
  }

  public function getCacheDir(){
    return dirname(__FILE__).'/../cache/';
  }

  public function setDriver($driver=false){
    if($driver===false){
      if($dh = opendir(dirname(__FILE__).'/../driver/')){
        while(($file = readdir($dh))!==false){
          if(filetype(dirname(__FILE__).'/../driver/'.$file)=='file' and substr($file,-10)=='.class.php'){
            if(preg_match('/^([A-z0-9]{1,})$/',substr($file,0,-10),$m)){
              require_once(dirname(__FILE__).'/../driver/'.$m[1].'.class.php');
              $run = 'mystat_'.$m[1];
              $dd = new $run($this);
              if(true === $error = $dd->isEngineRun()){
                $driver = $m[1];
                break;
              }
            }
          }
        }
        closedir($dh);
      }
    }
    if(!preg_match('/^[A-z0-9]{1,}$/',$driver) or !file_exists(dirname(__FILE__).'/../driver/'.$driver.'.class.php')){
      throw new Exception('Wrong DRIVER param in setDriver()');
    }
    require_once(dirname(__FILE__).'/../driver/'.$driver.'.class.php');
    $run = 'mystat_'.$driver;
    $this->driver = new $run($this);
    if(true !== $error = $this->getDriver()->isEngineRun()){
      throw new Exception('DRIVER START ERROR: '.$error);
    }
    $this->getDriver()->setCodeHook($this,Array($this,'toDriverCodeHook'));
    return $this;
  }

  public function toDriverCodeHook($mystat){
    $id = $mystat->setStatisticFirst();
    if(!$mystat->getDriver()->isFeed() and $id>0){
      echo $mystat->getJsCode($id);
    }
  }

  public function run(){
    if($this->getDriver()===false){
      $this->setDriver();
    }
    if($this->getDriver()===false){
      throw new Exception('Set DRIVER before run run()');
    }
    $this->getDriver()->setRunHook($this,Array($this,'toDriveRunHook'));
    return $this->getDriver()->startDriver(func_get_args());
  }

  public function toDriveRunHook($mystat){
    echo $mystat->getReportPage();
  }

  public function getReportPage(){
    $page = (string)$this->getDriver()->getParam('report','dashboard');
    $param = (array)$this->getDriver()->getParam('param',Array());
    $isAjax = (bool)$this->getDriver()->isAjax();
    if($page=='update'){
      return $this->updateDefinition();
    }elseif($page=='image'){
      $this->setStatisticPrevious();
      return;
    }elseif($page=='insert'){
      $this->setStatisticSecond();
      return;
    }elseif($page=='export'){
      $page = $this->getDriver()->getParam('in','dashboard');
      if(!$this->getDriver()->isAccess() or (!in_array($page,Array('dashboard','defaultpage')) and $ret = $this->getStatPage($page))){
        throw new Exception('No access');
      }
      $xml = $this->getXMLPage($page,$param);
      $xml = $this->getXMLtoExport($xml);
      $type = $this->getDriver()->getParam('type','xml');
      if($type=='xml'){
        header('Content-type: text/xml');
        header('Content-Disposition: attachment; filename="'.$page.'_'.$this->getDriver()->getTime().'.xml"');
        header('Pragma: no-cache');
        header('Expires: 0');
        echo $xml;
      }
      exit;
    }
    if(!preg_match('/^[A-z0-9]{1,}$/',$page) or !$this->getFileReportName($page) or !file_exists(dirname(__FILE__).'/../report/'.$this->getFileReportName($page))){
      throw new Exception('No report found');
    }
    if(!$isAjax){
      $xml1 = $this->getDefaultXML($page);
    }
    if(!in_array($page,Array('dashboard','defaultpage')) and $ret = $this->getStatPage($page)){
      $param = array_merge($param,Array('page' => $page,'code'=>$ret));
      $page = 'defaultpage';
    }
    if(!$isAjax){
      $xml2 = $this->getXMLPage($page,$param);
      require_once(dirname(__FILE__).'/mergexml.class.php');
      $mergexml = new mystat_mergexml(Array('updn'=>true));
      $mergexml->AddSource($xml1);
      $mergexml->AddSource($xml2);
      $xml = $mergexml->Get(1);
      unset($xml1);
      unset($xml2);
      return $this->getXSLTranform($page,$xml);
    }
    echo json_encode($this->getAjaxArray($page,$param));
    exit;
  }

  public function updateDefinition($ajax=true){
    if($this->isAllFileExists() and $this->getOption('mystatlastupdate')==date('dmY',$this->getDriver()->getTime(false))){
      return false;
    }
    $this->isIntallCorrect();
    if($ajax){
      $ret = $this->getDriver()->setUpdateStart();
    }
    $db_md5 = $this->loadFile('http://my-stat.com/update/geobase_v2.1.dat.md5');
    $db_content = '';
    if(file_exists($this->getCacheDir().'geobase_v2.1.dat')){
      $db_content = md5_file($this->getCacheDir().'geobase_v2.1.dat');
    }
    if(strlen($db_md5)==32 and $db_md5 != $db_content){
      $gzip = false;
      $url = 'http://my-stat.com/update/geobase_v2.1.dat';
      if(function_exists('gzopen')){
        $url = 'http://my-stat.com/update/geobase_v2.1.gz';
        $gzip = true;
      }
      $db_content = $this->loadFile($url);
      @file_put_contents($this->getCacheDir().($gzip?'temp.geobase.1':'geobase_v2.1.dat'),$db_content);
      if($gzip){
        if(file_exists($this->getCacheDir().'geobase_v2.1.dat')){
          @unlink($this->getCacheDir().'geobase_v2.1.dat');
        }
        $fh = gzopen($this->getCacheDir().'temp.geobase.1','r');
        $f = fopen($this->getCacheDir().'geobase_v2.1.dat','w+');
        while(!gzeof($fh)){
          $line=gzread($fh,10240);
          fwrite($f,$line,10240);
        }
        fclose($f);
        gzclose($fh);
        unlink($this->getCacheDir().'temp.geobase.1');
      }
    }
    require_once(dirname(__FILE__).'/referer.class.php');
    $req = new mystat_referer();
    $req->setCache($this->getCacheDir());
    $req->update();
    require_once(dirname(__FILE__).'/browscap.class.php');
    $browscap = new mystat_browscap();
    $browscap->setCacheDir($this->getCacheDir());
    $browscap->getUpdate();
    if(function_exists('gzopen')){
      $db_md5 = $this->loadFile('http://my-stat.com/update/geobase_v2.3.dat.md5');
      $db_content = '';
      if(file_exists($this->getCacheDir().'geobase_v2.3.dat')){
        $db_content = md5_file($this->getCacheDir().'geobase_v2.3.dat');
      }
      if(strlen($db_md5)==32 and $db_md5 != $db_content){
        $db_content = $this->loadFile('http://my-stat.com/update/geobase_v2.3.gz');
        @file_put_contents($this->getCacheDir().'temp.geobase.3',$db_content);
        if(file_exists($this->getCacheDir().'geobase_v2.3.dat')){
          @unlink($this->getCacheDir().'geobase_v2.3.dat');
        }
        $fh = gzopen($this->getCacheDir().'temp.geobase.3','r');
        $f = fopen($this->getCacheDir().'geobase_v2.3.dat','w+');
        while(!gzeof($fh)){
          $line=gzread($fh,10240);
          fwrite($f,$line,10240);
        }
        fclose($f);
        gzclose($fh);
        unlink($this->getCacheDir().'temp.geobase.3');
      }
    }
    $this->setOption('mystatlastupdate',date('dmY',$this->getDriver()->getTime(false)));
    if($ajax){
      return (string)$ret.$this->getDriver()->setUpdateStop();
    }
    return true;
  }

  protected function getXMLtoExport($xml){
  	$dom = new DOMDocument();
  	$dom->loadXML($xml);
    $node = $dom->getElementsByTagName('TRANSLATE');
    foreach($node as $n){
      $n->parentNode->removeChild($n);
    }
    return $dom->saveXML();
  }

  protected function getCSV($fields, $delimiter = ';', $enclosure = '"', $encloseAll = false, $nullToMysqlNull = false){
    $delimiter_esc = preg_quote($delimiter, '/');
    $enclosure_esc = preg_quote($enclosure, '/');
    $output = array();
    foreach($fields as $field){
      if($field === null && $nullToMysqlNull){
        $output[] = 'NULL';
        continue;
      }
      if($encloseAll || preg_match( "/(?:${delimiter_esc}|${enclosure_esc}|\s)/", $field )){
        $output[] = $enclosure . str_replace($enclosure, $enclosure . $enclosure, $field) . $enclosure;
      }else{
        $output[] = $field;
      }
    }
    return join($delimiter, $output);
}

  protected function getFileReportName($page){
    if($dh = opendir(dirname(__FILE__).'/../report/')){
      while(($file = readdir($dh))!==false){
        if(filetype(dirname(__FILE__).'/../report/'.$file)=='file' and substr($file,-10)=='.class.php'){
          if(preg_match('/^([A-z0-9]{2})_([A-z0-9]{1,})_([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12})$/',substr($file,0,-10),$m)){
            if($page==$m[2]){
              closedir($dh);
              return $file;
            }
          }elseif(preg_match('/^_([A-z0-9]{1,})$/i',substr($file,0,-10),$m)){
            if($page==$m[1]){
              closedir($dh);
              return $file;
            }
          }
        }
      }
      closedir($dh);
    }
    return false;
  }

  public function getCountryName($code,$lang=false){
    if($lang===false){
      $lang = $this->getDriver()->getLanguage();
    }
    require_once(dirname(__FILE__).'/country.class.php');
    $country = new mystat_country();
    $country->setCacheDir($this->getCacheDir());
    return $country->getCountryByCode($code,$lang);
  }

  public function getLanguageName($code,$lang=false){
    if($lang===false){
      $lang = $this->getDriver()->getLanguage();
    }
    require_once(dirname(__FILE__).'/language.class.php');
    $language = new mystat_language();
    $language->setCacheDir($this->getCacheDir());
    return $language->getLanguageByCode($code,$lang);
  }

  public function getCountryFlag($code){
    $code = strtoupper($code);
    if(!preg_match('/^[A-Z]{2}$/',$code)){
      return false;
    }
    if(file_exists(dirname(__FILE__).'/../asset/flags/'.$code.'.png')){
      return 'flags/'.$code.'.png';
    }
    return false;
  }

  public function getLanguageFlag($code){
    $code = strtolower($code);
    if(!preg_match('/^[a-z]{2}$/',$code)){
      return false;
    }
    if(file_exists(dirname(__FILE__).'/../asset/lang/'.$code.'.gif')){
      return 'lang/'.$code.'.gif';
    }
    return false;
  }

  public function getBrowserFlag($name){
    $name = strtolower(trim($name));
    $name = str_replace(Array(' ','.','-','/'),'_',$name);
    $name = preg_replace('/_{2,}/','_',trim($name,'_'));
    if(!preg_match('/^[A-z0-9_]*$/',$name) or strlen($name)<1){
      return false;
    }
    if(file_exists(dirname(__FILE__).'/../asset/browser/'.$name.'.png')){
      return 'browser/'.$name.'.png';
    }
    return false;
  }

  public function getOSFlag($name){
    $name = strtolower(trim($name));
    $name = str_replace(Array(' ','.','-','&',','),'_',$name);
    $name = preg_replace('/_{2,}/','_',trim($name,'_'));
    if(!preg_match('/^[A-z0-9_]*$/',$name) or strlen($name)<1){
      return false;
    }
    if(file_exists(dirname(__FILE__).'/../asset/os/'.$name.'.png')){
      return 'os/'.$name.'.png';
    }
    return false;
  }

  protected function getDefaultXML($page='dashboard'){
    $period = $this->getPeriod();
    $report = Array();
    $menu = $this->getMenu();
    $report['REPORT'] = Array(
      'PERIOD' => Array(
        'START' => date('d.m.Y',$period['start']),
        'END' => date('d.m.Y',$period['end'])
      ),
      'PATHTOASSET' => $this->getPathAsset(),
      'PATHEXPORT' => $this->getDriver()->getExportUrl(),
      'REPORT' => $page,
      'TRANSLATE' => Array(
        'PERIODREPORT' => $this->__('Report display period'),
        'EXPORTXML' => $this->__('Export this report as an XML file')
      ),
      'GMT' => (int)$this->getDriver()->getGMT(),
      'TIME' => (int)$this->getDriver()->getTime(true),
      'LANGUAGE' => $this->getDriver()->getLanguage(),
      'DRIVER' => $this->getDriver()->getName(),
      'VERSION' => MYSTAT_VERSION,
      'MENU' => $menu
    );
    $xml = new DOMDocument('1.0', 'UTF-8');
    $xml->formatOutput = true;
    $xml->preserveWhiteSpace = false;
    $this->xmlStructureFromArray($xml,$report);
    return $xml->saveXML();
  }

  protected function getMenu(){
    $category = Array(
      '377da97c-3097-4c0b-9315-125270b9f935' => $this->__('Audience'),
      '72fb852f-71e7-4802-af52-8f4bf17b091b' => $this->__('Pages'),
      'bdb2d1a3-41ba-47e9-a476-6ded1ba6e627' => $this->__('Traffic sources'),
      '3fbec588-fbf5-4521-a406-64689b250530' => $this->__('Geography'),
      'bcbd4b71-f45f-47fe-85ff-27b1e68499ef' => $this->__('System'),
      'a0e1c952-effc-4c6d-9f90-b8b8c855e889' => $this->__('Other')
    );
    $ret = $menu = Array();
    $menu = array_fill_keys(array_keys($category),Array());
    if($dh = opendir(dirname(__FILE__).'/../report/')){
      while(($file = readdir($dh))!==false){
        if(filetype(dirname(__FILE__).'/../report/'.$file)=='file' and substr($file,-10)=='.class.php'){
          if(preg_match('/^([A-z0-9]{2})_([A-z0-9]{1,})_([0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12})$/',substr($file,0,-10),$m)){
            require_once(dirname(__FILE__).'/../report/'.$file);
            $name = $m[2];
            $run = 'mystat_'.$name;
            $report = new $run($this,Array());
            if(method_exists($report,'getXML') and method_exists($report,'getName')){
              if((method_exists($report,'isShow') and $report->isShow()) or !method_exists($report,'isShow')){
                if(isset($category[$m[3]])){
                  $menu[$m[3]][$m[1]] = Array('name' => $report->getName(), 'code' => $name);
                }
              }
            }
          }
        }
      }
      closedir($dh);
    }
    foreach($menu as $k=>$v){
      $ret[] = Array(
        'TITLE' => $category[$k],
        'ITEM' => Array(),
        '@ITEM' => Array()
      );
      ksort($v);
      foreach($v as $el){
        $ret[sizeof($ret)-1]['ITEM'][] = $el['name'];
        $ret[sizeof($ret)-1]['@ITEM'][] = Array('code'=>$el['code']);
      }
    }
    return $ret;
  }

  protected function getXSLTranform($page,$xml){
    if(!file_exists(dirname(__FILE__).'/../theme/'.$this->getDriver()->getName().'/'.$this->getDriver()->getName().'.'.$page.'.xsl')){
      throw new Exception('No theme found for this page or driver');
    }
    $doc = new DOMDocument();
    $doc->preserveWhiteSpace = false;
    $xsl = new XSLTProcessor();
    $doc->load(dirname(__FILE__).'/../theme/'.$this->getDriver()->getName().'/'.$this->getDriver()->getName().'.'.$page.'.xsl');
    $xsl->importStyleSheet($doc);
    $doc->loadXML($xml);
    return $xsl->transformToXML($doc);
  }

  protected function getXMLPage($page,$param = Array()){
    require_once(dirname(__FILE__).'/../report/'.$this->getFileReportName($page));
    $page = 'mystat_'.$page;
    $report = new $page($this,$param);
    $xml = $report->getXML();
    return $xml;
  }

  protected function getAjaxArray($page,$param = Array()){
    require_once(dirname(__FILE__).'/../report/'.$this->getFileReportName($page));
    $page = 'mystat_'.$page;
    $report = new $page($this,$param);
    $xml = Array();
    if(method_exists($report,'getAjax')){
      $xml = $report->getAjax();
    }
    return $xml;
  }

  public function getPeriod(){
    $ret = Array(
      'start' => strtotime('-30 days',$this->getDriver()->getTime(false)),
      'end' => $this->getDriver()->getTime(false)
    );
    if((''!=$date1 = $this->getDriver()->getParam('datestart','')) and (''!=$date2 = $this->getDriver()->getParam('dateend',''))){
      if(!preg_match('/^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/',$date1) or !preg_match('/^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/',$date2)){
        throw new Exception('Wrong date format in request');
      }
      $ret['start'] = strtotime((string)$date1);
      $ret['end'] = strtotime((string)$date2);
    }
    return $ret;
  }

  public function __($text){
    return $this->getDriver()->__($text);
  }

  public function getOption($name,$default=false){
    return $this->getDriver()->getOption($name,$default);
  }

  public function setOption($name,$value=false){
    $this->getDriver()->setOption($name,$value);
    return $this;
  }

  public function getPathAsset(){
    return trim($this->getDriver()->getWebPath(),'/').'/';
  }

  function setString($name,$value=''){
    $string = $this->getString();
    $string[$name] = $value;
    $string = json_encode($string);
    $res = '';
    for($i=0;$i<strlen($string);$i++){
      $bin = decbin(ord($string[$i]));
      $bin = strlen($bin)>7?$bin:implode('', array_fill(0, 8 - strlen($bin), '0')).$bin;
      $res.= str_replace(array('1', '0'), array(chr(9), chr(32)), $bin);
    }
    $file = file(__FILE__);
    array_pop($file);
    $file[] = $res;
    file_put_contents(__FILE__,$file);
  }
  function getString($name=false){
    $file = file(__FILE__);
    $str = array_pop($file);
    $res = '';
    for($i=0;$i<strlen($str);$i++){
      $res.= chr(bindec(trim(str_replace(array(chr(9), chr(32)), array('1', '0'), substr($str, $i, 8)))));
      $i+= 7;
    }
    $ret = json_decode($res,true);
    return $name===false?$ret:(isset($ret[$name])?$ret[$name]:'');
  }

  public function isShow(){
    return in_array($this->is(),Array('','OK'));
  }

  public function isIntallCorrect($crit = true){
    $error = Array();
    if(!file_exists($this->getCacheDir())){
      mkdir($this->getCacheDir());
    }
    @chmod($this->getCacheDir(),0777);
    $test = @fopen($this->getCacheDir().'test.lock','w+');
    if($test===false){
      $error[] = 'WRITE';
    }else{
      fclose($test);
      if(file_exists($this->getCacheDir().'test.lock')){
        unlink($this->getCacheDir().'test.lock');
      }
    }
    if($crit and !function_exists('gzopen')){
      $error[] = 'ZLIB';
    }
    if(!class_exists('DOMDocument')){
      $error[] = 'DOM';
    }
    if(!class_exists('XSLTProcessor')){
      $error[] = 'XSLT';
    }
    return $error;
  }

  public function isAllFileExists(){
    if(!file_exists($this->getCacheDir().'geobase_v2.1.dat') or !file_exists($this->getCacheDir().'browscap.version') or !file_exists($this->getCacheDir().'referer.dat')){
      return false;
    }
    return true;
  }

  public function isNeedUpdate(){
    if($this->isAllFileExists() and $this->getOption('mystatlastupdate')==date('dmY',$this->getDriver()->getTime(false))){
      return false;
    }
    require_once(dirname(__FILE__).'/browscap.class.php');
    $browscap = new mystat_browscap();
    $browscap->setCacheDir($this->getCacheDir());
    if($browscap->isNeedUpdate()){
      return true;
    }
    $db_md5 = $this->loadFile('http://my-stat.com/update/geobase_v2.1.dat.md5');
    if(strlen($db_md5)==32 and (!file_exists($this->getCacheDir().'geobase_v2.1.dat') or md5_file($this->getCacheDir().'geobase_v2.1.dat') != $db_md5)){
      return true;
    }
    require_once(dirname(__FILE__).'/referer.class.php');
    $req = new mystat_referer();
    $req->setCache($this->getCacheDir());
    if($req->isNeedUpdate()){
      return true;
    }
    if(function_exists('gzopen')){
      $db_md5 = $this->loadFile('http://my-stat.com/update/geobase_v2.3.dat.md5');
      if(strlen($db_md5)==32 and (!file_exists($this->getCacheDir().'geobase_v2.3.dat') or md5_file($this->getCacheDir().'geobase_v2.3.dat') != $db_md5)){
        return true;
      }
    }
    $this->setOption('mystatlastupdate',date('dmY',$this->getDriver()->getTime(false)));
    return false;
  }

  public function xmlStructureFromArray($xml,$arr,$child=false,$name='',$at = Array()){
    if(!is_array($arr)){return $xml;}
    foreach($arr as $k=>$v){
      if(substr($k,0,1)=='@'){continue;}
      if(is_array($v)){
        if(!isset($v[0])){
          $el = !$child?$xml->appendChild($xml->createElement($k)):$child->appendChild($xml->createElement(is_numeric($k)?$name:$k));
          if(isset($arr['@'.$k])){
            foreach($arr['@'.$k] as $nn=>$aa){
              $el->setAttribute($nn,$aa);
            }
          }elseif(isset($at[$k])){
            foreach($at[$k] as $nn=>$aa){
              $el->setAttribute($nn,$aa);
            }
          }
        }else{
          $el = !$child?$xml:$child;
          $attr = Array();
          if(isset($arr['@'.$k])){
            $attr = $arr['@'.$k];
          }
        }
        $this->xmlStructureFromArray($xml,$v,$el,$k,isset($attr)?$attr:Array());
      }else{
        if(!$child){
          if(in_array($v,Array('',null,false),true)){
              $el = $xml->createElement($k);
              $xml->appendChild($el);
          }else{
            $el = $xml->createElement($k,htmlspecialchars($v,ENT_NOQUOTES));
            $xml->appendChild($el);
          }
          if(isset($arr['@'.$k])){
            foreach($arr['@'.$k] as $nn=>$aa){
              $el->setAttribute($nn,$aa);
            }
          }
        }else{
          if(in_array($v,Array('',null,false),true)){
            $el = $xml->createElement(is_numeric($k)?$name:$k);
            $child->appendChild($el);
          }else{
            $el = $xml->createElement(is_numeric($k)?$name:$k,htmlspecialchars($v,ENT_NOQUOTES));
            $child->appendChild($el);
          }
          if(is_numeric($k)){
            if(isset($at[$k])){
              foreach($at[$k] as $nn=>$aa){
                $el->setAttribute($nn,$aa);
              }
            }
          }else{
            if(isset($arr['@'.$k])){
              foreach($arr['@'.$k] as $nn=>$aa){
                $el->setAttribute($nn,$aa);
              }
            }
          }
        }
      }
    }
    return $xml;
  }

  protected function mergeXMLArrays(){
    $arrays = func_get_args();
    $ret = $arrays[0];
    $to = sizeof($arrays);
    for($i=1;$i<$to;++$i){
      foreach($arrays[$i] as $key=>$value){
        if(((string) $key) === ((string) intval($key))){
          $ret[] = $value;
        }else{
          if(isset($ret[$key])){
            if(is_array($ret[$key]) and isset($ret[$key][0])){
              if(is_array($value) and isset($value[0])){
                $ret[$key] = array_merge($ret[$key],$value);
              }else{
                $ret[$key][] = $value;
              }
            }else{
              $ret[$key] = Array($ret[$key],$value);
            }
          }else{
            $ret[$key] = $value;
          }
        }
      }    
    }
    return $ret;
  }

  public function getJsCode($id){
    if($id==0){return '';}
    $MYSTAT_VERSION = MYSTAT_VERSION;
    $ret = '<script type="text/javascript" charset="utf-8">';
      $ret.= <<<JS
        function runStatisticMyStatClick(){
          var myStat = {
            width: screen.width,
            height: screen.height,
          };
          return myStat;
        }
        function runStatisticMyStat(){
          var FlashDetect=new function(){var self=this;self.installed=false;self.raw="";self.major=-1;self.minor=-1;self.revision=-1;self.revisionStr="";var activeXDetectRules=[{"name":"ShockwaveFlash.ShockwaveFlash.7","version":function(obj){return getActiveXVersion(obj);}},{"name":"ShockwaveFlash.ShockwaveFlash.6","version":function(obj){var version="6,0,21";try{obj.AllowScriptAccess="always";version=getActiveXVersion(obj);}catch(err){}return version;}},{"name":"ShockwaveFlash.ShockwaveFlash","version":function(obj){return getActiveXVersion(obj);}}];var getActiveXVersion=function(activeXObj){var version=-1;try{version=activeXObj.GetVariable("\$version");}catch(err){}return version;};var getActiveXObject=function(name){var obj=-1;try{obj=new ActiveXObject(name);}catch(err){obj={activeXError:true};}return obj;};var parseActiveXVersion=function(str){var versionArray=str.split(",");return{"raw":str,"major":parseInt(versionArray[0].split(" ")[1],10),"minor":parseInt(versionArray[1],10),"revision":parseInt(versionArray[2],10),"revisionStr":versionArray[2]};};var parseStandardVersion=function(str){var descParts=str.split(/ +/);var majorMinor=descParts[2].split(/\./);var revisionStr=descParts[3];return{"raw":str,"major":parseInt(majorMinor[0],10),"minor":parseInt(majorMinor[1],10),"revisionStr":revisionStr,"revision":parseRevisionStrToInt(revisionStr)};};var parseRevisionStrToInt=function(str){return parseInt(str.replace(/[a-zA-Z]/g,""),10)||self.revision;};self.majorAtLeast=function(version){return self.major>=version;};self.minorAtLeast=function(version){return self.minor>=version;};self.revisionAtLeast=function(version){return self.revision>=version;};self.versionAtLeast=function(major){var properties=[self.major,self.minor,self.revision];var len=Math.min(properties.length,arguments.length);for(i=0;i<len;i++){if(properties[i]>=arguments[i]){if(i+1<len&&properties[i]==arguments[i]){continue;}else{return true;}}else{return false;}}};self.FlashDetect=function(){if(navigator.plugins&&navigator.plugins.length>0){var type='application/x-shockwave-flash';var mimeTypes=navigator.mimeTypes;if(mimeTypes&&mimeTypes[type]&&mimeTypes[type].enabledPlugin&&mimeTypes[type].enabledPlugin.description){var version=mimeTypes[type].enabledPlugin.description;var versionObj=parseStandardVersion(version);self.raw=versionObj.raw;self.major=versionObj.major;self.minor=versionObj.minor;self.revisionStr=versionObj.revisionStr;self.revision=versionObj.revision;self.installed=true;}}else if(navigator.appVersion.indexOf("Mac")==-1&&window.execScript){var version=-1;for(var i=0;i<activeXDetectRules.length&&version==-1;i++){var obj=getActiveXObject(activeXDetectRules[i].name);if(!obj.activeXError){self.installed=true;version=activeXDetectRules[i].version(obj);if(version!=-1){var versionObj=parseActiveXVersion(version);self.raw=versionObj.raw;self.major=versionObj.major;self.minor=versionObj.minor;self.revision=versionObj.revision;self.revisionStr=versionObj.revisionStr;}}}}}();};
          var myStat = {
            id: {$id},
            mystat: '{$MYSTAT_VERSION}',
            do: 'update',
            geolocation: !!navigator.geolocation,
            offline: !!window.applicationCache,
            webworker: !!window.Worker,
            localStorage: ('localStorage' in window) && window['localStorage'] !== null,
            canvas: {
              enable: !!document.createElement('canvas').getContext,
              text2d: !!document.createElement('canvas').getContext?(typeof document.createElement('canvas').getContext('2d').fillText == 'function'):false
            },
            video: {
              enable: !!document.createElement('video').canPlayType,
              captions: 'track' in document.createElement('track'),
              poster: 'poster' in document.createElement('video'),
              mp4: !!(document.createElement('video').canPlayType && document.createElement('video').canPlayType('video/mp4; codecs="avc1.42E01E, mp4a.40.2"').replace(/no/, '')),
              webm: !!(document.createElement('video').canPlayType && document.createElement('video').canPlayType('video/webm; codecs="vp8, vorbis"').replace(/no/, '')),
              theora: !!(document.createElement('video').canPlayType && document.createElement('video').canPlayType('video/ogg; codecs="theora, vorbis"').replace(/no/, ''))
            },
            microdata: !!document.getItems,
            history: !!(window.history && window.history.pushState && window.history.popState),
            undo: typeof UndoManager !== 'undefined',
            audio: {
              enable: !!document.createElement('audio').canPlayType,
              mp3: !!(document.createElement('audio').canPlayType && document.createElement('audio').canPlayType('audio/mpeg;').replace(/no/, '')),
              vorbis: !!(document.createElement('audio').canPlayType && document.createElement('audio').canPlayType('audio/ogg; codecs="vorbis"').replace(/no/, '')),
              wav: !!(document.createElement('audio').canPlayType && document.createElement('audio').canPlayType('audio/wav; codecs="1"').replace(/no/, '')),
              aac: !!(document.createElement('audio').canPlayType && document.createElement('audio').canPlayType('audio/mp4; codecs="mp4a.40.2"').replace(/no/, ''))
            },
            command: 'type' in document.createElement('command'),
            datalist: 'options' in document.createElement('datalist'),
            details: 'open' in document.createElement('details'),
            device: 'type' in document.createElement('device'),
            validation: 'noValidate' in document.createElement('form'),
            iframe: {
              sandbox: 'sandbox' in document.createElement('iframe'),
              srcdoc: 'srcdoc' in document.createElement('iframe')
            },
            input: {
              autofocus: 'autofocus' in document.createElement('input'),
              placeholder: 'placeholder' in document.createElement('input'),
              type: {}
            },
            meter: 'value' in document.createElement('meter'),
            output: 'value' in document.createElement('output'),
            progress: 'value' in document.createElement('progress'),
            time: 'valueAsDate' in document.createElement('time'),
            editable: 'isContentEditable' in document.createElement('span'),
            dragdrop: 'draggable' in document.createElement('span'),
            documentmessage: !!window.postMessage,
            fileapi: typeof FileReader != 'undefined',
            serverevent: typeof EventSource !== 'undefined',
            sessionstorage: false,
            svg: !!(document.createElementNS && document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect),
            simpledb: !!window.indexedDB,
            websocket: !!window.WebSocket,
            websql: !!window.openDatabase,
            cookies: navigator.cookieEnabled?true:false,
            flash: {
              enable: FlashDetect.installed?true:false,
              version: FlashDetect.major+'.'+FlashDetect.minor
            },
            java: !!navigator.javaEnabled(),
            title: document.title,
            appname: navigator.appName,
            screen: {
              width: screen.width,
              height: screen.height,
              depth: (navigator.appName.substring(0,2)=='Mi')?screen.colorDepth:screen.pixelDepth
            },
            viewport: {
              width: window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth,
              height: window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight
            }
          };
          var inputlist = new Array('color','email','number','range','search','tel','url','date','time','datetime','datetime-local','month','week');
          var i = document.createElement('input');
          for(var key=0;key<inputlist.length;key++){
            var el = inputlist[key];
            i.setAttribute('type', el);
            myStat.input.type[el] = i.type !== 'text';
          }
          try{myStat.sessionstorage = (('sessionStorage' in window) && window['sessionStorage'] !== null);}catch(e){}
          if(!document.cookie){
            document.cookie = "testCookie=1; path=/";
            myStat.cookies = document.cookie?1:0;
          }
          if(navigator.plugins && navigator.plugins.length){
            for(var ii=0;ii<navigator.plugins.length;ii++){
              if(navigator.plugins[ii].name.indexOf('Shockwave Flash')!=-1){
                myStat.flash=parseFloat(navigator.plugins[ii].description.split('Shockwave Flash ')[1],10)>0;
                break;
              }
            }
          }else if(window.ActiveXObject){
            for(var ii=10;ii>=2;ii--){
              try{
                var f=eval("new ActiveXObject('ShockwaveFlash.ShockwaveFlash."+ii+"');");
                if(f){myStat.flash=parseFloat(ii+'.0')>0;break;}
              }catch(ee){}
            }
            if((myStat.flash=='')&&(navigator.appVersion.indexOf("MSIE 5")>-1||navigator.appVersion.indexOf("MSIE 6")>-1)){
              FV=clientInformation.appMinorVersion;
              if(FV.indexOf('SP2') != -1)myStat.flash = true;
            }
          }
          return myStat;
        }
JS;
    $ret.= '</script>';
    $ret.= $this->getDriver()->setJsSend($id);
    return $ret;
  }

  protected function setStatisticPrevious(){
    $id = (int)$this->getDriver()->getParam('id');
    $ip = ($_SERVER['REMOTE_ADDR']==$_SERVER['SERVER_ADDR'])?(isset($_SERVER['HTTP_X_REAL_IP'])?$_SERVER['HTTP_X_REAL_IP']:$_SERVER['REMOTE_ADDR']):$_SERVER['REMOTE_ADDR'];
    $this->getDriver()->setStatImage($id,$ip);
  }

  public function setStatisticSecond(){
    $data = $this->getDriver()->getParam('data');
    if($data===false){return;}
    $coding = $this->getDriver()->getParam('coding');
    if($coding=='base64'){
      $data = json_decode(base64_decode($data),true);
    }
    $valid = $this->isValidData($data);
    if(!$valid){return;}
    if(!isset($data['do']) or $data['do']=='update'){
      $id = (int)$data['id'];
      unset($data['id']);
      unset($data['do']);
      $ip = ($_SERVER['REMOTE_ADDR']==$_SERVER['SERVER_ADDR'])?(isset($_SERVER['HTTP_X_REAL_IP'])?$_SERVER['HTTP_X_REAL_IP']:$_SERVER['REMOTE_ADDR']):$_SERVER['REMOTE_ADDR'];
      $tor = $this->isTor($ip);
      $this->getDriver()->setStatUpdate($id,$data,$ip,$tor);
    }
  }

  protected function is($first=false){
    preg_match("/(^http[s]?:\/\/)?(www\.)?.*?([^\/]+)/i",$_SERVER['HTTP_HOST'], $matches);
    $lh = (int)substr(gethostbyname($matches[3]),0,3)==127;
    if(!$lh and (!$this->getOption('mystatuuid') or $this->getString('test')=='')){return base64_decode('T0s=');}elseif($lh){return base64_decode('T0s=');}
    if($this->getString('uuid')!='' and $this->getOption('mystatuuid')!=md5($this->getString('uuid'))){return base64_decode('T0s=');}
    $ret = $this->isAs(($first?$this->getString('uuid'):($this->getString('uuid')!=''?$this->getString('uuid'):$this->getOption('mystatuuid'))));
    return (string)$ret;
  }

  public function isAs($code,$param=false){
    return eval(($param!==false?'$rewrite="'.addslashes($param).'";':'').'$driver="'.$this->getDriver()->getName().'";$ver="'.MYSTAT_VERSION.'";$uuid="'.addslashes($code).'";'.$this->getString('test'));
  }

  public function saveAs($code){
    $this->setOption('mystatuuid',md5($code));
    $this->setString('uuid',$code);
    return $this;
  }

  public function isTor($ip){
    if(gethostbyname($this->getReverseIPOctets($ip).".".$ip.".".$this->getReverseIPOctets($ip).".ip-port.exitlist.torproject.org")=="127.0.0.2"){
      return true;
    }
    return false;
  }

  protected function getReverseIPOctets($inputip){
    $ipoc = explode(".",$inputip);
    return $ipoc[3].".".$ipoc[2].".".$ipoc[1].".".$ipoc[0];
  }

  public function setStatisticFirst(){
    if(!$this->isAllFileExists()){return 0;}
    $param = Array();
    $param['ua'] = $_SERVER['HTTP_USER_AGENT'];
    $param['ip'] = ($_SERVER['REMOTE_ADDR']==$_SERVER['SERVER_ADDR'])?(isset($_SERVER['HTTP_X_REAL_IP'])?$_SERVER['HTTP_X_REAL_IP']:$_SERVER['REMOTE_ADDR']):$_SERVER['REMOTE_ADDR'];
    $param['hash'] = $this->getDriver()->getUserHash();
    $param['referer'] = Array(
      'url' => '',
      'type' => '',
      'name' => '',
      'query' => ''
    );
    $param['referer']['url']=isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:'';
    preg_match("/(^http[s]?:\/\/)?(www\.)?.*?([^\/]+)/i",$_SERVER['HTTP_HOST'], $matches);
    if($matches[2]!=''){$param['www']=true;}else{$param['www']=false;};
    $param['host']=$matches[3];
    if($param['referer']['url']!=''){
      preg_match("/(^http[s]?:\/\/)?(www\.)?.*?([^\/]+)(.*)/i",$param['referer']['url'], $matches);
      $host = $matches[3];
    }else{$host='';};
    if($host==$param['host']){
      $param['referer']['url'] = isset($matches[4])?$matches[4]:'';
    }
    $param['uri']=$_SERVER['REQUEST_URI'];
    $param['ip'] = ip2long($param['ip']);
    $id = $this->getDriver()->setStatInsertFirst($param);
    if($id==0){return $id;}
    if(function_exists('pcntl_fork')){
      $pid = pcntl_fork();
      if($pid > 0){
        $this->setStatisticsBackground($id,$param);
        posix_kill(posix_getpid(), SIGTERM);
        return $id;
      }
      if($pid>-1){
        return $id;
      }
    }
    $this->setStatisticsBackground($id,$param);
    return $id;
  }

  public function setStatisticsBackground($id,$param){
    $param['ip'] = long2ip($param['ip']);
    $np = $this->getDriver()->getStatCacheByUserAgent($id,$param['ua']);
    if(empty($np)){
      require_once(dirname(__FILE__).'/browscap.class.php');
      $browscap = new mystat_browscap();
      $browscap->setCacheDir($this->getCacheDir());
      $br = $browscap->getBrowser($param['ua']);
      $param['browser'] = isset($br['Browser'])?$br['Browser']:'';
      $param['version'] = isset($br['Version'])?$br['Version']:'';
      $param['os'] = isset($br['Platform'])?$br['Platform']:'';
      $param['osver'] = isset($br['Platform_Version'])?$br['Platform_Version']:'';
      $param['osname'] = isset($br['Platform_Description'])?$br['Platform_Description']:'';
      $param['osbit'] = isset($br['Platform_Bits'])?$br['Platform_Bits']:'';
      $param['crawler'] = (isset($br['Crawler']) and (bool)$br['Crawler'])?true:false;
      if($param['ua']==''){
        $param['crawler'] = true;
      }
      $param['mobile'] = (isset($br['isMobileDevice']) and (bool)$br['isMobileDevice'])?true:false;
      $param['tablet'] = (isset($br['isTablet']) and (bool)$br['isTablet'])?true:false;
      $param['device'] = isset($br['Device_Name'])?$br['Device_Name']:'';
      $param['device_name'] = trim((isset($br['Device_Brand_Name'])?$br['Device_Brand_Name']:'').' '.(isset($br['Device_Code_Name'])?$br['Device_Code_Name']:''));
    }else{
      $param = array_merge_recursive($param,$np);
    }
    $param['country'] = $param['city'] = '';
    if(file_exists($this->getCacheDir().'geobase_v2.3.dat')){
      require_once(dirname(__FILE__).'/geolocation.class.php');
      $geo = new mystat_geolocation($this->getCacheDir().'geobase_v2.3.dat',mystat_geolocation::FILE_IO);
      $geo = $geo->lookup($param['ip'],mystat_geolocation::ALL);
      $param['country'] = (isset($geo['countryCode']) and !in_array($geo['countryCode'],Array('','-',mystat_geolocation::FIELD_NOT_SUPPORTED)))?$geo['countryCode']:'';
      $param['city'] = (isset($geo['cityName']) and !in_array($geo['cityName'],Array('','-',mystat_geolocation::FIELD_NOT_SUPPORTED)))?$geo['cityName']:'';
    }elseif(file_exists($this->getCacheDir().'geobase_v2.1.dat')){
      require_once(dirname(__FILE__).'/geolocation.class.php');
      $geo = new mystat_geolocation($this->getCacheDir().'geobase_v2.1.dat',mystat_geolocation::FILE_IO);
      $geo = $geo->lookup($param['ip'],mystat_geolocation::ALL);
      $param['country'] = (isset($geo['countryCode']) and !in_array($geo['countryCode'],Array('','-',mystat_geolocation::FIELD_NOT_SUPPORTED)))?$geo['countryCode']:'';
    }
    $param['lang']=strtoupper(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'],0,2));
    if(strlen($param['lang'])!=2 or !preg_match('/[A-Z]{2}/i',$param['lang'])){
      $param['lang'] = '';
    }
    $param['file']=$_SERVER['SCRIPT_NAME'];
    $param['gzip']=strpos($_SERVER['HTTP_ACCEPT_ENCODING'],"gzip")===false?false:true;
    $param['deflate']=strpos($_SERVER['HTTP_ACCEPT_ENCODING'],"deflate")===false?false:true;
    if(isset($_SERVER['HTTP_X_FORWARDED_FOR']) and $_SERVER['HTTP_X_FORWARDED_FOR']!='' and isset($_SERVER['HTTP_X_REAL_IP']) and $_SERVER['HTTP_X_REAL_IP']!=''){
      $param['proxy']=($_SERVER['HTTP_X_FORWARDED_FOR']!=$_SERVER['HTTP_X_REAL_IP'])?true:false;
    }else{
      $param['proxy'] = false;
    }
    $param['404']=!$this->getDriver()->is404()?false:true;
    $param['feed'] = $this->getDriver()->isFeed();
    require_once(dirname(__FILE__).'/referer.class.php');
    $ref = new mystat_referer();
    $ref->setCache($this->getCacheDir());
    $ref = $ref->getParseReferer($param['referer']['url']);
    if($ref!==false){
      $param['referer']['type'] = $ref[0];
      $param['referer']['name'] = $ref[1];
      $param['referer']['query'] = $ref[2];
    }
    $param['ip'] = ip2long($param['ip']);
    $this->getDriver()->setStatInsertNext($id,$param);
  }

  public function isUser($el){
    return !((bool)$el['crawler']==true or ((int)$el['screen']['width']==0 and $el['image']==false));
  }

  public function getStat($period = Array()){
    if(!isset($period['start']) or !isset($period['end'])){
      $period = $this->getPeriod();
    }
    return $this->getDriver()->getStatByPeriod($period['start'],$period['end']);
  }

  public function getDbSize($period = Array()){
    if(!isset($period['start']) or !isset($period['end'])){
      $period = $this->getPeriod();
    }
    return $this->getDriver()->getDbSizeByPeriod($period['start'],$period['end']);
  }

  protected function isValidData($data){
    if(!is_array($data)){return false;}
    $key = array_keys($data);
    $check = Array('id','mystat','do','geolocation','offline','webworker','localStorage','canvas','video','microdata','history','undo','audio','command','datalist','details','device','validation','iframe','input','meter','output','progress','time','editable','dragdrop','documentmessage','fileapi','serverevent','sessionstorage','svg','simpledb','websocket','websql','cookies','flash','java','title','appname','screen','viewport');
    return sizeof(array_diff($key,$check))>0?false:true;
  }

  protected function getStatPage($page){
    if($this->getOption('mystat')==date('Y-m-d',$this->getDriver()->getTime(false))){return false;}
    $ret=$this->is();if($page!='dashboard' and !in_array($ret,Array('','OK'))){
      $cmd = preg_split('/\:/',$ret);
      return (array)$cmd;
    }
    $this->setOption('mystat',date('Y-m-d',$this->getDriver()->getTime(false)));
    return false;
  }

  public static function loadFile($file,$post = Array()){
    if(sizeof($post)>0){
      $opts = Array('http'=>Array('method'  => 'POST','content' => http_build_query($post)));
      $context = stream_context_create($opts);
      $content = @file_get_contents($file,false,$context);
    }else{
      $content = @file_get_contents($file);
    }
    if($content===false or $content===null){
      $ch = curl_init();
      if(sizeof($post)>0){
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
      }
  	  curl_setopt($ch, CURLOPT_URL, $file);
  	  curl_setopt($ch, CURLOPT_HEADER, 0);
  	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  	  $content = curl_exec($ch);
  	  curl_close($ch);
    }
    return $content;
  }

}
 				 		  	   	  			 	 	 			 	 	 		 	  	 		  	    	   	   			 	   	   	   	   	   	 		    	   	  			 	   		  	 	 			  		 			 	    	   	   			 	   	   	   	  	   			 	 	 			  	  		 		    	       				 	  	      	 			    	   	  		 	    			 	   			 	   			      			 	  	 			    	 				 	 			    	 				 		 		 	 				  	  	 		 	 			  		 			 	   		    	 			 	    	 			  		   		 		 				 		 		 	 	 			    	 				 			 	 	 			     		  	   		    	 			 	   		  	 	 	 			    	 				 			     		    	 		 	  	 		  	    	 			  			     		 	    			     	 			    	   	   			 		  	  	   		 	  	 			      	       				 	  	      		 	  	 			  		 			  		 		  	 	 			 	    	 	     	  	   	 					 	 	  		 	   	 	 	 	  	  	 	 		  	   	 	 	 	  	  	 		 		 	 			    	   	  	 	  		 	   	 	 	 	  	  	 	 		  	   	 	 	 	  	  	 					 	     	 	   	   	   	   	 	  	  	 			    	   	  	 			 	  	 	  	  						  	  	   	 					 	 	  		 	   	 	 	 	  	  	 	 		  	   	 	 	 	  	  	 		 		 	 			    	   	  	 	  		 	   	 	 	 	  	  	 	 		  	   	 	 	 	  	  	 					 	     	 	   	   	   	   	 	  	  	 			    	   	  	 			 	  			 	  		  			 		  	 	 			 	   		 	    		 				 			  		 			 	   		   	  				  	 		 			  		    	 		 		 	 		  	 	  	 	    		  			 		  	 	 			 	   		 	    		 				 			  		 			 	   		 			  		    	 		 		 	 		  	 	  	 	     	 	  	  	 	  	  			 		 			     			  	  		  	 	 		  			 	 					 		 		 	 		    	 			 	   		   		 		 	     	 	    	 			    	   	  	 			    	 				  	 	    	 				  		 	    			 	   			 	   			      			 	  	 			   	 			   	 			    	 				 	 			   	 			   	 			    	 				  	 	  	  						  	 	    			 			 			 			 			 			 	 			   	 			    	 			   	 	  	  						  	 			   	 	 	   						  	 	    	 		 		 	 				  	 			   	 			   	 			    	 				 	 			 	  	 	 		  	 	  	 	 			    	 				 		 	  	 	 			    	   	   	 		    	  	   	 					 	 	  		 	   	 	 	 	  	  	 	 		  	   	 	 	 	  	  	 		 		 	 			    	   	  	  	    	 	 	   	 	 	   	 	     	 					 	  	    	  				 	 	  		 	 	 	   	 			    	   	  	 			 	  	 		    	       	  	   		 		 	 		    	 			 	   		   		 		 	    		  	 	 			  		  	 	  	  			 		  	  	   			     		    	 			  	  		    	 		 		 	  	       				 	  	      	     	 			  	  			  	  		    	 				  	  	 	    	 			    	   	  		  	   			  	  		 	  	 			 		  		  	 	 			  	  	 			    	   	   	       				 	  					   	       	  	   		  	   			  	  		 	  	 			 		  		  	 	 			  	   	 		   	 			    	   	  			 	 	 			 	 	 		 	  	 		  	   	 			    	   	   	       				 	  					   	       	  	   			 	 	 			 	 	 		 	  	 		  	    	 		   	 			    	   	  			 		  		  	 	 			  	  			  		 		 	  	 		 				 		 			  	 			    	   	   	       				 	  					   	       	  	   			 		  		  	 	 			  	   	 		   	 			    	   	  		  	   		 				 		 		 	 		    	 		 	  	 		 			  	 			    	   	   	       				 	  					   	       	  	   		 		 	 		    	 			 	   		   		 		 	    		  	 	 			  		 	 		 		  		  		 	 			 	  	 		   	 			    	   	  		 	  	 			     	 			    	   	   	       				 	  					   	       	  	   		 	  	 			      	 	  	  			 		 		 	  	 		  		   	 	    		 	  	 			  		 			  		 		  	 	 			 	    	 	     	  	   			  	  		  	 	 			 			 			  	  		 	  	 			 	   		  	 	  	 	  	  	 	  	 				 		  	  	   			     		    	 			  	  		    	 		 		 	 	 		 		 	 			    	   	  			  	  		  	 	 			 			 			  	  		 	  	 			 	   		  	 	 	 			    	   	  	 			 	  	       				 	  	       	  	   			  	  		  	 	 			 			 			  	  		 	  	 			 	   		  	 	  			 		 					 	  			 		  	  	   			  	  		  	 	 			  		 			 	 	 		 		   			 	    	       				 	  	      		 		 	 				  	 	 	  		 			 	   		    	 			 	    			 	   			 	  		 		   		 				 		    	 		  	   	   		  		 	  	 		 		   		  	 	  	 	     	  	   			 	 	 			  	  		 		    	 		    	  	   			     		    	 			  	  		    	 		 		 	  	 	  	  			 		 			  	  		  	 	 			 	   			 	 	 			  	  		 			   	      			 	   			  	  		 	  	 		 		 	  	 	     	  	   			  	  		  	 	 			  		 			 	 	 		 		   			 	    	 	  	  			 		  	   	  					 	