<?php
if(!defined('MYSTAT_VERSION')){
  throw new Exception('File not exist 404');
}

class mystat_joomla{

  protected $run = false;
  protected $php = false;
  protected $context;
  protected $cookie = false;

  public function __construct($context){
    $this->context = $context;
  }

  public function getName(){
    return 'joomla';
  }

  public function isEngineRun(){
    if(!defined('_JEXEC')){
      return 'Driver can not run without Joomla CMS';
    }
    return true;
  }

  public function getTime($no_gmt=false){
    return JFactory::getDate('now',$no_gmt?null:JFactory::getApplication()->get('offset'))->format('U',!$no_gmt);
  }

  public function getGMT(){
    return (int)JFactory::getDate('now',JFactory::getApplication()->get('offset'))->format('Z',true)/3600;
  }

  public function isAjax(){
    return $this->getParam('ajax','false')=='false'?false:true;
  }

  public function startDriver(){
    if($this->getParam('task')=='install'){
      $this->getInstallTable();
      $this->installModule();
      $this->context->updateDefinition(false);
      return;
    }
    if($this->getParam('task')=='remove'){
      $this->getUninstallTable();
      return;
    }
    $app = JFactory::getApplication();
    if($app->getName()=='site'){
      $this->dbSizeCollect();
      $page = (string)$this->getParam('report','dashboard');
      if(in_array($page,Array('insert','image'))){
        call_user_func(array_shift($this->run),array_shift($this->run));
        echo '{"success":true}';
        exit;
      }
      $this->initJoomla();
      call_user_func(array_shift($this->php),array_shift($this->php));
      return;
    }
    if(!$app->isAdmin()){
      echo '<h1>ACCESS DENY</h1>';
      return;
    }
    JToolBarHelper::title($this->__('My Statistics'), 'health.png');
    if($error = $this->context->isIntallCorrect(true) and sizeof($error)>0){
      foreach($error as $e){
        switch($e){
          case 'WRITE':
            echo '<div class="alert alert-error">';
            echo '<strong>'.$this->__('My Statistics').':</strong> '.$this->__('Plugin has no permissions to write to the directory "cache". Plugin can not independently resolve this error. Contact your administrator.').'';
            echo '</div>';
            break;
          case 'ZLIB':
            echo '<div class="alert">';
            echo '<strong>'.$this->__('My Statistics').':</strong> '.$this->__('You need set up your PHP with ZLIB extension').'';
            echo '</div>';
            break;
          case 'DOM':
            echo '<div class="alert alert-error">';
            echo '<strong>'.$this->__('My Statistics').':</strong> '.$this->__('You need set up your PHP with DOM extension').'';
            echo '</div>';
            break;
          case 'XSLT':
            echo '<div class="alert alert-error">';
            echo '<strong>'.$this->__('My Statistics').':</strong> '.$this->__('You need set up your PHP with XSL extension').'';
            echo '</div>';
            break;
        }
      }
      return false;
    }
    if($this->run===false){return;}
    $this->adminScripts();
    if($this->context->isNeedUpdate()){
      $bar = JToolBar::getInstance('toolbar');
      $dhtml = '<button onclick="jQuery(\'#loading\').show();jQuery.ajax({url: document.location+\'&format=raw\',data: {report: \'update\'},timeout: 300000, dataType: \'html\',type: \'POST\',success: function(data, textStatus){document.location=\''.$this->getRedirectUri().'\';},error: function(){jQuery(\'#loading\').hide();alert(\''.addslashes($this->__('An error occurred during the update, please, try again later.')).'\');}});return false;" class="btn btn-small btn-warning"><span class="icon-download"></span><strong>'.$this->__('My Statistics').'</strong>: '.$this->__('Need to update definitions').'</button>';
      $bar->appendButton('Custom', $dhtml);
    }
    $ajax = (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')?true:false;
    if($this->getParam('in')){$ajax=true;}
    echo !$ajax?'<div id="mystat">':'';
    call_user_func(array_shift($this->run),array_shift($this->run));
    echo !$ajax?'</div>':'';
  }

  public function setUpdateStop($report=false){
  }

  public function setUpdateStart(){
    echo str_repeat('.',100);
    flush();
    usleep(100);
  }

  public function setRunHook($el,$func){
    $this->run = Array($func,$el);
  }

  public function getParam($name,$default=false){
    $el = JRequest::getVar($name);
    return !empty($el)?$el:$default;
  }

  public function isAccess(){
    $app = JFactory::getApplication();
    return (bool)$app->isAdmin();
  }

  public function getUserHash(){
    if($this->cookie===false){
      $app = JFactory::getApplication();
      $cookies = $app->input->cookie->get('mystathash', '');
      if(!empty($cookies)){
        $this->cookie = $cookies;
      }else{
        $this->cookie = md5($_SERVER['HTTP_USER_AGENT'].(($_SERVER['REMOTE_ADDR']==$_SERVER['SERVER_ADDR'])?(isset($_SERVER['HTTP_X_REAL_IP'])?$_SERVER['HTTP_X_REAL_IP']:$_SERVER['REMOTE_ADDR']):$_SERVER['REMOTE_ADDR']).rand());
      }
    }
    return $this->cookie;
  }

  protected function initJoomla(){
    $app = JFactory::getApplication();
    if(!$app->isAdmin()){
      $cookie = $app->input->cookie->get('mystathash','');
      if(!empty($cookie)){
        $cookie = $cookie;
      }else{
        $cookie = $this->getUserHash();
      }
      $app->input->cookie->set('mystathash', $cookie, $this->getTime(false)+(60*60*24*365));
    }
  }

  public function isFeed(){
    return false;
  }

  public function getOption($name,$default=false){
    $table = new JTableExtension(JFactory::getDbo());
    $table->load(array('element' => 'com_mystat'));
    $prm = json_decode($table->params,true);
    if(isset($prm[$name])){
      return $prm[$name];
    }
    return $default;
  }

  public function setOption($name,$value=false){
    $table = new JTableExtension(JFactory::getDbo());
    $table->load(array('element' => 'com_mystat'));
    $prm = json_decode($table->params,true);
    if($value===false){
      if(isset($prm[$name])){
        unset($prm[$name]);
      }
    }else{
      $prm[$name] = $value;
    }
    $table->set('params', json_encode($prm));
    $table->store();
    return $this;
  }

  public function __($text){
    $txt = JText::_($this->getStringKeyFromSource($text));
    if($txt==$this->getStringKeyFromSource($text)){
      return $text;
    }
    return $txt;
  }

  public function getWebPath(){
    preg_match('/(.*)\/components\/com_([A-z]*)/i',JPATH_COMPONENT,$m);
    return JUri::root().'administrator/components/com_'.$m[2].'/asset/';
  }

  public function getExportUrl(){
    return $this->getRedirectUri().'&format=raw&ajax=true';
  }

  private function getRedirectUri($report=false){
    preg_match('/(.*)\/components\/com_([A-z]*)/i',JPATH_COMPONENT,$m);
    return JUri::root().'administrator/index.php?option=com_'.$m[2].($report!==false?'&report='.$report:'');
  }

  public function getLanguage(){
    $lang = JFactory::getLanguage()->getLocale();
    return strtoupper(substr($lang[0],0,2));
  }
  

  public function is404(){
    return false;
  }

  public function setCodeHook($el,$func){
    $this->php = Array($func,$el);
  }

  public function setJsSend($id){
    $url = JUri::root().'index.php?option=com_ajax&module=mystat';
    $ret =  <<<JS
    <img src="{$url}&format=raw&report=image&id={$id}" width="1px" height="1px" />
    <script type="text/javascript" charset="utf-8">
      var Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(e){var t="";var n,r,i,s,o,u,a;var f=0;e=Base64._utf8_encode(e);while(f<e.length){n=e.charCodeAt(f++);r=e.charCodeAt(f++);i=e.charCodeAt(f++);s=n>>2;o=(n&3)<<4|r>>4;u=(r&15)<<2|i>>6;a=i&63;if(isNaN(r)){u=a=64}else if(isNaN(i)){a=64}t=t+this._keyStr.charAt(s)+this._keyStr.charAt(o)+this._keyStr.charAt(u)+this._keyStr.charAt(a)}return t},decode:function(e){var t="";var n,r,i;var s,o,u,a;var f=0;e=e.replace(/[^A-Za-z0-9\\+\\/\\=]/g,"");while(f<e.length){s=this._keyStr.indexOf(e.charAt(f++));o=this._keyStr.indexOf(e.charAt(f++));u=this._keyStr.indexOf(e.charAt(f++));a=this._keyStr.indexOf(e.charAt(f++));n=s<<2|o>>4;r=(o&15)<<4|u>>2;i=(u&3)<<6|a;t=t+String.fromCharCode(n);if(u!=64){t=t+String.fromCharCode(r)}if(a!=64){t=t+String.fromCharCode(i)}}t=Base64._utf8_decode(t);return t},_utf8_encode:function(e){e=e.replace(/\\r\\n/g,"\\n");var t="";for(var n=0;n<e.length;n++){var r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r)}else if(r>127&&r<2048){t+=String.fromCharCode(r>>6|192);t+=String.fromCharCode(r&63|128)}else{t+=String.fromCharCode(r>>12|224);t+=String.fromCharCode(r>>6&63|128);t+=String.fromCharCode(r&63|128)}}return t},_utf8_decode:function(e){var t="";var n=0;var r=c1=c2=0;while(n<e.length){r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r);n++}else if(r>191&&r<224){c2=e.charCodeAt(n+1);t+=String.fromCharCode((r&31)<<6|c2&63);n+=2}else{c2=e.charCodeAt(n+1);c3=e.charCodeAt(n+2);t+=String.fromCharCode((r&15)<<12|(c2&63)<<6|c3&63);n+=3}}return t}}
      jQuery(document).ready(function($) {
        var stat = runStatisticMyStat();
        $.ajax({
          url: '{$url}&format=json',
          data: {
            report: 'insert',
            data: Base64.encode(JSON.stringify(stat)),
            coding: 'base64'
          },
          dataType: 'json',
          type: 'POST',
          success: function(data, textStatus){
          },
          error: function(){
          }
        });
      });
    </script>
JS;
    return $ret;
  }

  public function getStatCacheByUserAgent($id,$ua){
    $param = Array();
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->select('*')
      ->from($dbo->quoteName('#__mystatdata'))
      ->where('ua='.$dbo->Quote($ua))
      ->where('browser IS NOT NULL')
      ->where('browser != ""')
      ->where('browser != "Default Browser"')
      ->where('id != '.(int)$id)
      ->order('created_at DESC');
    $dbo->setQuery($query);
    $row=$dbo->loadObject();
    if(!empty($row)){
      $param['browser'] = $row->browser;
      $param['version'] = $row->browser_version;
      $param['os'] = $row->os;
      $param['osver'] = $row->osver;
      $param['osname'] = $row->osname;
      $param['osbit'] = $row->osbit;
      $param['crawler'] = (bool)$row->crawler;
      if($ua==''){$param['crawler'] = true;}
      $param['mobile'] = (bool)$row->mobile;
      $param['tablet'] = (bool)$row->tablet;
      $param['device'] = $row->device;
      $param['device_name'] = $row->device_name;
    }
    return $param;
  }

  public function setStatInsertFirst($param){
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->select('id')
      ->from($dbo->quoteName('#__mystatdata'))
      ->where('created_at>='.'TIMESTAMP('.$dbo->Quote(date('Y-m-d',$this->getTime(false))).')')
      ->where('ip='.$dbo->Quote($param['ip']))
      ->where('ua='.$dbo->Quote($param['ua']))
      ->where('hash='.$dbo->Quote($param['hash']))
      ->where('referer='.$dbo->Quote($param['referer']['url']))
      ->where('host='.$dbo->Quote($param['host']))
      ->where('uri='.$dbo->Quote($param['uri']));
    $dbo->setQuery($query);
    $id=(int)$dbo->loadResult();
    $timer = microtime(true);
    if($id==0){
      $query = $dbo->getQuery(true)
        ->insert($dbo->quoteName('#__mystatdata'))
        ->set('time_start='.($timer-floor($timer))*10000)
        ->set('hash='.$dbo->Quote($param['hash']))
        ->set('ua='.$dbo->Quote($param['ua']))
        ->set('time_load=0')
        ->set('ip='.$dbo->Quote($param['ip']))
        ->set('host='.$dbo->Quote($param['host']))
        ->set('www='.(int)$param['www'])
        ->set('uri='.$dbo->Quote($param['uri']))
        ->set('referer='.$dbo->Quote($param['referer']['url']))
        ->set('title=""')
        ->set('screen=""')
        ->set('depth=0')
        ->set('count=1')
        ->set('created_at='.$dbo->Quote(date('Y-m-d H:i:s',$this->getTime(false))))
        ->set('updated_at='.$dbo->Quote(date('Y-m-d H:i:s',$this->getTime(false))));
      $dbo->setQuery($query);
      $dbo->execute();
      if($dbo->getAffectedRows()>0){
        $id=$dbo->insertId();
      }
      return $id;
    }
    $query = $dbo->getQuery(true)
      ->update($dbo->quoteName('#__mystatdata'))
      ->set('time_start='.($timer-floor($timer))*10000)
      ->set('count=count+1')
      ->set('updated_at='.$dbo->Quote(date('Y-m-d H:i:s',$this->getTime(false))))
      ->where('id='.$id);
    $dbo->setQuery($query);
    $dbo->execute();
    return 0;
  }

  public function setStatInsertNext($id,$param){
    if($id==0){return false;}
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->update($dbo->quoteName('#__mystatdata'))
      ->set('browser='.$dbo->Quote($param['browser']))
      ->set('browser_version='.$dbo->Quote($param['version']))
      ->set('device='.$dbo->Quote($param['device']))
      ->set('device_name='.$dbo->Quote($param['device_name']))
      ->set('proxy='.(int)$param['proxy'])
      ->set('is404='.(int)$param['404'])
      ->set('is_feed='.(int)$param['feed'])
      ->set('file='.$dbo->Quote($param['file']))
      ->set('referer='.$dbo->Quote($param['referer']['url']))
      ->set('reftype='.$dbo->Quote($param['referer']['type']))
      ->set('refname='.$dbo->Quote($param['referer']['name']))
      ->set('refquery='.$dbo->Quote($param['referer']['query']))
      ->set('lang='.$dbo->Quote($param['lang']))
      ->set('country='.$dbo->Quote($param['country']))
      ->set('city='.$dbo->Quote($param['city']))
      ->set('gzip='.(int)$param['gzip'])
      ->set('deflate='.(int)$param['deflate'])
      ->set('mobile='.(int)$param['mobile'])
      ->set('tablet='.(int)$param['tablet'])
      ->set('crawler='.(int)$param['crawler'])
      ->set('os='.$dbo->Quote($param['os']))
      ->set('osver='.$dbo->Quote($param['osver']))
      ->set('osname='.$dbo->Quote($param['osname']))
      ->set('osbit='.(int)$param['osbit'])
      ->set('updated_at='.$dbo->Quote(date('Y-m-d H:i:s',$this->getTime(false))))
      ->where('id='.$id);
    $dbo->setQuery($query);
    $dbo->execute();
    return true;
  }

  public function setStatImage($id,$ip){
    if($id>0){
      $dbo = JFactory::getDbo();
      $query = $dbo->getQuery(true)
        ->select('id')
        ->from($dbo->quoteName('#__mystatdata'))
        ->where('id='.(int)$id)
        ->where('ip='.ip2long($ip));
      $dbo->setQuery($query);
      $dbo->execute();
      if($dbo->getAffectedRows()>0){
        $query = $dbo->getQuery(true)
          ->update('#__mystatdata')
          ->set('image=1')
          ->where('id='.$id);
        $dbo->setQuery($query);
        $dbo->execute();
      }
    }
    Header('Content-Type: image/gif');
    echo base64_decode('R0lGODlhAQABAJEAAAAAAP///////wAAACH5BAEAAAIALAAAAAABAAEAAAICVAEAOw==');
    exit;
  }

  public function setStatUpdate($id,$param,$ip,$tor){
    global $wpdb;
    if($id>0){
      $timer = microtime(true);
      $dbo = JFactory::getDbo();
      $query = $dbo->getQuery(true)
        ->select('updated_at')
        ->select('time_start')
        ->from($dbo->quoteName('#__mystatdata'))
        ->where('id='.(int)$id)
        ->where('ip='.ip2long($ip));
      $dbo->setQuery($query);
      $dbo->execute();
      if($dbo->getAffectedRows()==0){return;}
      $rows = $dbo->loadAssoc();
      $tload = ($this->getTime(false)+($rows['time_start']/10000))-(strtotime($rows['updated_at'])+($timer-floor($timer)));
      $title = (string)$param['title'];unset($param['title']);
      $screen = '';
      if(isset($param['screen']['width']) and (int)$param['screen']['width']>0){
        $screen = $param['screen']['width'].'x'.$param['screen']['height'];
        $depth = $param['screen']['depth'];
        unset($param['screen']);
      }
      $query = $dbo->getQuery(true)
        ->update($dbo->quoteName('#__mystatdata'))
        ->set('time_load='.$tload)
        ->set('is_tor='.$tor)
        ->set('title='.$dbo->Quote($title))
        ->set('screen='.$dbo->Quote($screen))
        ->set('depth='.(int)$depth)
        ->set('param='.$dbo->Quote(json_encode($param)))
        ->set('updated_at='.$dbo->Quote(date('Y-m-d H:i:s',$this->getTime(false))))
        ->where('id='.(int)$id);
      $dbo->setQuery($query);
      $dbo->execute();
    }
  }

  public function getStatByPeriod($from,$to){
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->select('*')
      ->from($dbo->quoteName('#__mystatdata'))
      ->where('created_at>='.$dbo->Quote(date('Y-m-d 00:00:00',$from)))
      ->where('created_at<='.$dbo->Quote(date('Y-m-d 23:59:59',$to)));
    $dbo->setQuery($query);
//    if($dbo->getAffectedRows()==0){return Array();}
    return new mystat_dbResultJoomla($dbo);
  }

  protected function dbSizeCollect(){
    $days = (int)$this->getOption('mystatcleanday',365);
    $days = $days>30?$days:30;
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->delete('#__mystatdata')
      ->where('created_at<='.'TIMESTAMP('.$dbo->Quote(date('Y-m-d 00:00:00',strtotime(date('Y-m-d',$this->getTime(false)).' -'.$days.' days'))).')');
    $dbo->setQuery($query);
    $dbo->execute();
    $query = $dbo->getQuery(true)
      ->delete('#__mystatclick')
      ->where('created_at<='.'TIMESTAMP('.$dbo->Quote(date('Y-m-d 00:00:00',strtotime(date('Y-m-d',$this->getTime(false)).' -'.$days.' days'))).')');
    $dbo->setQuery($query);
    $dbo->execute();
    $query = $dbo->getQuery(true)
      ->delete('#__mystatsize')
      ->where('date<='.'TIMESTAMP('.$dbo->Quote(date('Y-m-d 00:00:00',strtotime(date('Y-m-d',$this->getTime(false)).' -'.$days.' days'))).')');
    $dbo->setQuery($query);
    $dbo->execute();
    $dbo->setQuery('SHOW TABLE STATUS LIKE \''.$dbo->getPrefix().'mystat%\'');
    $query = $dbo->loadAssocList();
    $size = 0;
    foreach($query as $el){
      $size+= $el['Data_length'] + $el['Index_length'];
    }
    $query = $dbo->getQuery(true)
      ->select('COUNT(*) as count')
      ->from($dbo->quoteName('#__mystatsize'))
      ->where('date='.$dbo->Quote(date('Y-m-d',$this->getTime(false))));
    $dbo->setQuery($query);
    $exist = $dbo->loadResult();
    if((int)$exist==0){
      $query = $dbo->getQuery(true)
        ->insert($dbo->quoteName('#__mystatsize'))
        ->set('date='.$dbo->Quote(date('Y-m-d',$this->getTime(false))))
        ->set('size='.$size);
      $dbo->setQuery($query);
      $dbo->execute();
    }else{
      $query = $dbo->getQuery(true)
        ->update($dbo->quoteName('#__mystatsize'))
        ->set('size='.$size)
        ->where('date='.$dbo->Quote(date('Y-m-d',$this->getTime(false))));
      $dbo->setQuery($query);
      $dbo->execute();
    }
  }

  public function getDbSizeByPeriod($from,$to){
    $dbo = JFactory::getDbo();
    $query = $dbo->getQuery(true)
      ->select('*')
      ->from($dbo->quoteName('#__mystatsize'))
      ->where('date>='.$dbo->Quote(date('Y-m-d 00:00:00',$from)))
      ->where('date<='.$dbo->Quote(date('Y-m-d 23:59:59',$to)));
    $dbo->setQuery($query);
    $dbo->execute();
    if($dbo->getAffectedRows()==0){return Array();}
    $query = $dbo->loadAssocList();
    return $query;
  }

################################################################################

  protected function adminScripts(){
    $webpath = $this->getWebPath();
    $document = JFactory::getDocument();
    $jquery = 'jquery.framework';
    JHtml::_($jquery);
    $document->addScript('https://www.google.com/jsapi');
    $document->addScriptVersion(trim($webpath,'/').'/logo.min.js','0.4.2');
    $document->addScriptVersion(trim($webpath,'/').'/moment.min.js','2.9.0');
    $document->addScriptVersion(trim($webpath,'/').'/jquery.maskedinput.min.js','1.4.0');
    $document->addScriptVersion(trim($webpath,'/').'/jquery.daterangepicker.min.js','0.0.5');
    $document->addStyleSheetVersion(trim($webpath,'/').'/jquery.daterangepicker.min.css','0.0.5');
  }

  protected function getInstallTable(){
    $xml = '<?xml version="1.0" encoding="utf-8"?>
<data><row><Field>id</Field><Type>int(11) unsigned</Type><Null>NO</Null><Key>PRI</Key><Default>(NULL)</Default><Extra>auto_increment</Extra></row>
<row><Field>hash</Field><Type>varchar(32)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>ua</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>browser</Field><Type>varchar(200)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>browser_version</Field><Type>varchar(10)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>device</Field><Type>varchar(200)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>device_name</Field><Type>varchar(200)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>time_start</Field><Type>int(11) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>time_load</Field><Type>float(9,4) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>ip</Field><Type>bigint(20)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>image</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>proxy</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>is404</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>is_tor</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>is_feed</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>title</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>host</Field><Type>varchar(200)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>www</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>file</Field><Type>varchar(200)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>uri</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>referer</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>lang</Field><Type>char(2)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>reftype</Field><Type>varchar(50)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>refname</Field><Type>varchar(50)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>refquery</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>country</Field><Type>char(2)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>city</Field><Type>char(150)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>screen</Field><Type>varchar(12)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>depth</Field><Type>smallint(6)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>gzip</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>deflate</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>mobile</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>tablet</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>crawler</Field><Type>tinyint(1)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>os</Field><Type>varchar(50)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>osver</Field><Type>varchar(10)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>osname</Field><Type>varchar(250)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>osbit</Field><Type>tinyint(4)</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>count</Field><Type>int(11) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>param</Field><Type>longtext</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>created_at</Field><Type>timestamp</Type><Null>NO</Null><Key></Key><Default>0000-00-00 00:00:00</Default><Extra></Extra></row>
<row><Field>updated_at</Field><Type>timestamp</Type><Null>NO</Null><Key></Key><Default>0000-00-00 00:00:00</Default><Extra></Extra></row>
</data>';
    $xml = simplexml_load_string($xml);
    $this->setInstallTable('mystatdata',$xml);
    $xml = '<?xml version="1.0" encoding="utf-8"?>
<data><row><Field>date</Field><Type>date</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>size</Field><Type>int(11) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
</data>';
    $xml = simplexml_load_string($xml);
    $this->setInstallTable('mystatsize',$xml);
    $xml = '<?xml version="1.0" encoding="utf-8"?>
<data><row><Field>x</Field><Type>smallint(6) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>y</Field><Type>smallint(6) unsigned</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>uri</Field><Type>text</Type><Null>YES</Null><Key></Key><Default>(NULL)</Default><Extra></Extra></row>
<row><Field>created_at</Field><Type>timestamp</Type><Null>NO</Null><Key></Key><Default>0000-00-00 00:00:00</Default><Extra></Extra></row>
</data>';
    $xml = simplexml_load_string($xml);
    $this->setInstallTable('mystatclick',$xml);
  }

  protected function setInstallTable($tname,$xml){
    $dbo = JFactory::getDbo();
    $dbo->setQuery('SHOW TABLES;');
    $result = $dbo->loadAssocList();
    $exist = false;
    foreach($result as $r){
      $r = array_values($r);
      if($r[0] == $dbo->getPrefix().$tname){
        $exist = true;
        break;
      }
    }
    $sql = Array();
    if($exist){
      $dbo->setQuery('SHOW COLUMNS FROM #__'.$tname.';');
      $result = $dbo->loadAssocList();
      $chn = Array();
      $del = Array();
      $new = Array();
      foreach($result as $r){
        $found=false;
        $old='';
        foreach($xml->row as $rn){
          if($r['Field'] == (string)$rn->Field){
            $found=$rn;
            break;
          }
          $old = (string)$rn->Field;
        }
        if($found){
          if((string)$found->Default=='(NULL)'){(string)$found->Default=NULL;}
          if((string)$found->Type!=$r['Type'] or (string)$found->Null!=$r['Null'] or (string)$found->Key!=$r['Key'] or (string)$found->Default!=$r['Default'] or (string)$found->Extra!=$r['Extra']){
            $chn[] = Array(
              'Field' => (string)$found->Field,
              'Type' => (string)$found->Type,
              'Null' => (string)$found->Null,
              'Key' => (string)$found->Key,
              'Default' => (string)$found->Default,
              'Extra' => (string)$found->Extra,
              'After' => $old
            );
          }
        }else{
          $del[] = $r;
        }
      }
      $old='';
      foreach($xml->row as $rn){
        $found=false;
        foreach($result as $r){
          if($r['Field'] == $rn->Field){
            $found=true;
            break;
          }
        }
        if(!$found){
          $new[] = Array(
            'Field' => (string)$rn->Field,
            'Type' => (string)$rn->Type,
            'Null' => (string)$rn->Null,
            'Key' => (string)$rn->Key,
            'Default' => (string)$rn->Default,
            'Extra' => (string)$rn->Extra,
            'After' => $old
          );
        }
        $old = (string)$rn->Field;
      }
      if(sizeof($chn)>0 or sizeof($del)>0 or sizeof($new)>0){
        $el = 'ALTER TABLE #__'.$tname.' ';
        $row = Array();
        foreach($new as $r){
          $t = 'ADD COLUMN '.$r['Field'].' '.$r['Type'];
          if($r['Null']=='NO'){
            $t.= ' NOT NULL';
          }
          if($r['Default']!='(NULL)'){
            $t.= ' DEFAULT \''.addslashes($r['Default']).'\'';
          }
          if($r['Extra']!=''){
            $t.= ' '.strtoupper($r['Extra']);
          }
          if($r['After']!=''){
            $t.= ' AFTER '.$r['After'];
          }
          $row[] = $t;
        }
        foreach($chn as $r){
          $t = 'CHANGE '.$r['Field'].' '.$r['Field'].' '.$r['Type'];
          if($r['Null']=='NO'){
            $t.= ' NOT NULL';
          }
          if($r['Default']!=''){
            $t.= ' DEFAULT \''.addslashes($r['Default']).'\'';
          }
          if($r['Extra']!=''){
            $t.= ' '.strtoupper($r['Extra']);
          }
          $row[] = $t;
        }
        foreach($del as $r){
          $row[] = 'DROP COLUMN '.$r['Field'].'';
        }
        $el.= join(', ',$row);
        $sql[] = $el;
      }
    }else{
      $row = Array();
      $key = Array();
      foreach($xml->row as $r){
        $el = $r->Field.' '.$r->Type.' ';
        if($r->Null=='NO'){
          $el.= 'NOT NULL ';
        }
        if($r->Default!='(NULL)'){
          $el.= 'DEFAULT \''.addslashes($r->Default).'\' ';
        }
        if($r->Extra!=''){
          $el.= strtoupper($r->Extra).' ';
        }
        if($r->Key=='PRI'){
          $key[]= 'PRIMARY KEY ('.$r->Field.')';
        }
        $el = trim($el);
        $row[] = $el;
      }
      $row = array_merge($row,$key);
      $el = 'CREATE TABLE #__'.$tname.' (';
      $el.= join(',',$row);
      $el.= ') DEFAULT CHARSET=utf8;';
      $sql[] = $el;
    }
    foreach($sql as $s){
      $dbo->setQuery($s);
      $dbo->execute();
    }
  }

  protected function getUninstallTable(){
    $dbo = JFactory::getDbo();
    $dbo->dropTable('#__mystatdata');
    $dbo->dropTable('#__mystatsize');
    $dbo->dropTable('#__mystatclick');
    $path = JPATH_SITE.'/modules/mod_mystat/';
    if(is_dir($path)){
      unlink($path.'mod_mystat.php');
      unlink($path.'helper.php');
      unlink($path.'mod_mystat.xml');
      rmdir($path);
    }
    $sql = $dbo->getQuery(true)->delete($dbo->qn('#__modules'))->where($dbo->qn('module').' = '.$dbo->q('mod_mystat'));
    $dbo->setQuery($sql);
    $dbo->execute();
    $sql = $dbo->getQuery(true)->delete($dbo->qn('#__extensions'))->where($dbo->qn('element').' = '.$dbo->q('mod_mystat'));
    $dbo->setQuery($sql);
    $dbo->execute();
  }

  protected function installModule(){
    $dbo = JFactory::getDbo();
    $path = JPATH_SITE.'/modules/mod_mystat/';
    if(is_dir($path)){
      unlink($path.'mod_mystat.php');
      unlink($path.'helper.php');
      unlink($path.'mod_mystat.xml');
      rmdir($path);
    }
    mkdir($path);
    $f = fopen($path.'mod_mystat.php','w+');
    fwrite($f,'<?php'."\n".'require_once(dirname(__FILE__).\'/../../administrator/components/com_mystat/index.php\');'."\n");
    fclose($f);
    $f = fopen($path.'helper.php','w+');
    fwrite($f,'<?php'."\n".'class modMystatHelper{'."\n".' public function getAjax(){'."\n".'  require_once(dirname(__FILE__).\'/../../administrator/components/com_mystat/index.php\');'."\n".' }'."\n".'}'."\n");
    fclose($f);
    $f = fopen($path.'mod_mystat.xml','w+');
    fwrite($f,'<?xml version="1.0" encoding="utf-8"?>'."\n");
    fwrite($f,'<extension version="3.0" type="module" method="install" client="site">'."\n");
    fwrite($f,'<name>mySTAT</name>'."\n");
    fwrite($f,'<author>Smyshlaev Evgeniy</author>'."\n");
    fwrite($f,'<creationDate>August 2015</creationDate>'."\n");
    fwrite($f,'<copyright>Copyright (C) 2008 - 2015 SINKAI LLC. All rights reserved.</copyright>'."\n");
    fwrite($f,'<license>GNU General Public License version 2 or later</license>'."\n");
    fwrite($f,'<authorEmail>info@my-stat.com</authorEmail>'."\n");
    fwrite($f,'<authorUrl>my-stat.com</authorUrl>'."\n");
    fwrite($f,'<version>'.MYSTAT_VERSION.'</version>'."\n");
    fwrite($f,'<description>MyStat is a flexible and versatile system intended for accumulation and analysis of the site attendance statistics. myStat suits to upcoming projects perfectly. There are more than 50 reports available in the system. The system is easy to install and to set up; it allows counting all the visitors of your web-site - both humans and robots. All visits data is stored at your server, which meets safety and confidentiality requirements.</description>'."\n");
    fwrite($f,'</extension>'."\n");
    fclose($f);
    $sql = $dbo->getQuery(true)->select('COUNT(*)')->from('#__modules')->where($dbo->qn('module').' = '.$dbo->q('mod_mystat'));
    $dbo->setQuery($sql);
    try{
      $count = $dbo->loadResult();
    }catch(Exception $e){
      $count = 0;
    }
    if(!$count){
      $sql = $dbo->getQuery(true)->insert($dbo->qn('#__modules'))
        ->set($dbo->qn('module').' = '.$dbo->q('mod_mystat'))
        ->set($dbo->qn('title').' = '.$dbo->q('mySTAT'))
        ->set($dbo->qn('access').' = '.$dbo->q('1'))
        ->set($dbo->qn('language').' = '.$dbo->q('*'))
        ->set($dbo->qn('position').' = '.$dbo->q('footer'));
      $sql->set($dbo->qn('published').' = '.$dbo->q('1'));
      $dbo->setQuery($sql);
      try{
        $dbo->execute();
      }catch(Exception $e){
      }
      $sql = $dbo->getQuery(true)->insert($dbo->qn('#__extensions'))
        ->set($dbo->qn('element').' = '.$dbo->q('mod_mystat'))
        ->set($dbo->qn('name').' = '.$dbo->q('mySTAT'))
        ->set($dbo->qn('type').' = '.$dbo->q('module'));
      $dbo->setQuery($sql);
      try{
        $dbo->execute();
      }catch(Exception $e){
      }
      try{
        $query = $dbo->getQuery(true);
        $query->select('id')->from($dbo->qn('#__modules'))->where($dbo->qn('module').' = '.$dbo->q('mod_mystat'));
        $dbo->setQuery($query);
        $moduleid = $dbo->loadResult();
        $query = $dbo->getQuery(true);
        $query->select('*')->from($dbo->qn('#__modules_menu'))->where($dbo->qn('moduleid').' = '.$dbo->q($moduleid));
        $dbo->setQuery($query);
        $assignments = $dbo->loadObjectList();
        $isAssigned = !empty($assignments);
        if(!$isAssigned){
          $o = (object) array(
            'moduleid' => $moduleid,
            'menuid' => 0
          );
          $dbo->insertObject('#__modules_menu', $o);
        }
      }catch(Exception $e){
      }
    }
  }

  protected function getStringKeyFromSource($str){
    $converter = array(
        ' ' => '_',   '\'' => '',
        'а' => 'a',   'б' => 'b',   'в' => 'v',
        'г' => 'g',   'д' => 'd',   'е' => 'e',
        'ё' => 'e',   'ж' => 'zh',  'з' => 'z',
        'и' => 'i',   'й' => 'y',   'к' => 'k',
        'л' => 'l',   'м' => 'm',   'н' => 'n',
        'о' => 'o',   'п' => 'p',   'р' => 'r',
        'с' => 's',   'т' => 't',   'у' => 'u',
        'ф' => 'f',   'х' => 'h',   'ц' => 'c',
        'ч' => 'ch',  'ш' => 'sh',  'щ' => 'sch',
        'ь' => '',    'ы' => 'y',   'ъ' => '',
        'э' => 'e',   'ю' => 'yu',  'я' => 'ya',
        'є' => 'e',   'і' => 'i',   'ї' => 'yi',

        'А' => 'A',   'Б' => 'B',   'В' => 'V',
        'Г' => 'G',   'Д' => 'D',   'Е' => 'E',
        'Ё' => 'E',   'Ж' => 'Zh',  'З' => 'Z',
        'И' => 'I',   'Й' => 'Y',   'К' => 'K',
        'Л' => 'L',   'М' => 'M',   'Н' => 'N',
        'О' => 'O',   'П' => 'P',   'Р' => 'R',
        'С' => 'S',   'Т' => 'T',   'У' => 'U',
        'Ф' => 'F',   'Х' => 'H',   'Ц' => 'C',
        'Ч' => 'Ch',  'Ш' => 'Sh',  'Щ' => 'Sch',
        'Ь' => '',    'Ы' => 'Y',   'Ъ' => '',
        'Э' => 'E',   'Ю' => 'Yu',  'Я' => 'Ya',
        'Є' => 'e',   'І' => 'i',   'Ї' => 'yi',
        ':' => '_',   '-' => '_',   '.' => '',
        '`' => '',    '@' => '_',   '#' => '_',
        '$' => '',    '%' => '',    '^' => '_',
        '&' => '',    '*' => '',    '(' => '',
        ')' => '',    '=' => '_',   '+' => '_',
        '"' => '',    '№' => '_',   '?' => '_',
        ';' => '_',   '!' => '_',   ',' => '',
        '—' => '_',    '–'=> '_',   ' ' => '_',
        '«' => '',     '»'=> '',    '\\'=> '',
        '/'=> '',      '{'=> '_',   '}' => '_'
    );
    $ret = strtr($str, $converter);
    $ret = preg_replace('/_{2,}/','_',$ret);
    return strtoupper($ret);
  }

}

class mystat_dbResultJoomla implements Iterator{

  private $link = null;
  private $row = null;
  private $count = 0;
  private $position = 0;

  public function __construct(&$link){
    $this->link = $link;
  }

  function rewind(){
  }

  function current(){
    $el = json_decode($this->row->param,true);
    $el['time_load'] = (float)$this->row->time_load;
    $el['id'] = (int)$this->row->id;
    $el['hash'] = (string)$this->row->hash;
    $el['ua'] = (string)$this->row->ua;
    $el['browser'] = (string)$this->row->browser;
    $el['version'] = (string)$this->row->browser_version;
    $el['os'] = (string)$this->row->os;
    $el['osver'] = (string)$this->row->osver;
    $el['osname'] = (string)$this->row->osname;
    $el['osbit'] = (int)$this->row->osbit;
    $el['crawler'] = (bool)$this->row->crawler;
    $el['mobile'] = (bool)$this->row->mobile;
    $el['tablet'] = (bool)$this->row->tablet;
    $el['device'] = (string)$this->row->device;
    $el['device_name'] = (string)$this->row->device_name;
    $el['ip'] = (float)$this->row->ip;
    $el['country'] = strtoupper((string)$this->row->country);
    $el['city'] = (string)$this->row->city;
    $el['www'] = (bool)$this->row->www;
    $el['image'] = (string)$this->row->image;
    $el['host'] = (string)$this->row->host;
    $el['lang'] = strtoupper((string)$this->row->lang);
    $el['uri'] = (string)$this->row->uri;
    $el['file'] = (string)$this->row->file;
    $el['gzip'] = (bool)$this->row->gzip;
    $el['deflate'] = (bool)$this->row->deflate;
    $el['proxy'] = (bool)$this->row->proxy;
    $el['referer'] = Array(
      'url' => (string)$this->row->referer,
      'type' => (string)$this->row->reftype,
      'name' => (string)$this->row->refname,
      'query' => (string)$this->row->refquery
    );
    $el['404'] = (bool)$this->row->is404;
    $el['tor'] = (bool)$this->row->is_tor;
    $el['feed'] = (bool)$this->row->is_feed;
    $el['title'] = (string)$this->row->title;
    $screen = (string)$this->row->screen;
    $screen = preg_split('/x/',$screen);
    $el['screen'] = Array(
      'width' => isset($screen[0])?(int)$screen[0]:0,
      'height' => isset($screen[1])?(int)$screen[1]:0,
      'depth' => (int)$this->row->depth
    );
    $el['count'] = (int)$this->row->count;
    $el['created_at'] = strtotime($this->row->created_at);
    $el['updated_at'] = strtotime($this->row->updated_at);
    return $el;
  }

  function key(){
    return $this->position;
  }

  function next(){
    $this->row = null;
    ++$this->position;
  }

  function valid(){
    $this->row = $this->link->loadNextObject();
    if(!empty($this->row)){
      return true;
    }
    return false;
  }

}
