<?php

namespace Andy\AdManager\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Thread extends XFCP_Thread
{
	public function actionIndex(ParameterBag $params)
	{
		// get parent		
		$parent = parent::actionIndex($params);
		
		// get options
		$options = \XF::options();
		
		// get options from Admin CP -> Options -> Ad manager -> Exclude forums
		$excludeForums = $options->adManagerExcludeForums;
		
		// get options from Admin CP -> Options -> Ad manager -> Exclude threads
		$excludeThreads = $options->adManagerExcludeThreads;
		
		// check excludeForums
		if (!empty($excludeForums))
		{
			// get nodeId
			$nodeId = $params->node_id;
			
			// check if currentNodeId is excluded
			if (in_array($nodeId, $excludeForums))
			{
				// define variable
				$adManagerExcludeThread = true;

				// add to parent
				$parent->setParams([
				   'adManagerExcludeThread' => $adManagerExcludeThread
				]);
			}
		}
		
		// check excludeThreads
		if ($excludeThreads != '')
		{
			// remove trailing comma if there is one
			$excludeThreads = rtrim($excludeThreads, ',');

			// put excludeThreads into an array
			$excludeThreadsArray = explode(',', $excludeThreads);

			// get threadId
			$threadId = $params->thread_id;

			// check if threadId is in array
			if (in_array($threadId, $excludeThreadsArray))
			{
				// define variable
				$adManagerExcludeThread = true;
				
				// add to parent
				$parent->setParams([
				   'adManagerExcludeThread' => $adManagerExcludeThread
				]);	
			}
		}

		return $parent;	
	}
}