/**
* @package   BaGallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

(function($){
    $.fn.lazyload = function(options){
        var $elem = this,
            n = Math.floor(Math.random() * 999999999),
            array = new Array(),
            wHeight = $(window).height(),
            scrollElem = window,
            target = $(window);
        if (options.lightbox == 1) {
            scrollElem = target = $(this).closest('.ba-gallery');
        }
        if (!$($elem[0]).attr('data-original')) {
            return false;
        }
        $elem.each(function(ind, el){
            array.push(el);
        });
        this.checkElements = function(){
            var top = $(scrollElem).scrollTop() - wHeight,
                bottom = top + wHeight * 3,
                postArray = new Array();
            if (options.lightbox == 1) {
                top = 0 - wHeight;
                bottom = top + wHeight * 3;
            } else {
                top = window.pageYOffset - wHeight;
                bottom = top + wHeight * 3;
            }
            array.forEach(function(el, ind){
                var obj = $(el),
                    src = obj.attr('data-original'),
                    elemTop = Math.round(obj.offset().top),
                    elemBottom = elemTop + (obj.height());
                if (options.lightbox == 1) {
                    elemTop = Math.round(obj.position().top);
                    elemBottom = elemTop + (obj.height());
                }
                if (el.src == '' && elemTop < bottom && elemBottom > top
                    && obj.closest('.ba-gallery-items')[0].style.display != 'none'){
                    obj.attr('src', src);
                } else {
                    postArray.push(el);
                }
            });
            array = postArray;
            if (array.length == 0) {
                target.off('scroll.lazyload-'+n);
                $(window).off('resize.lazyload-'+n);
            }
        };
        target.on("scroll.lazyload-"+n, this.checkElements);
        $(window).on('resize.lazyload-'+n, function(e){
            wHeight = e.currentTarget.innerHeight;
        });
        
        return this;
    };
})(jQuery);