/*
Navicat MySQL Data Transfer

Source Server         : tutnaidut.com
Source Server Version : 50545
Source Host           : tutnaidut.com:3306
Source Database       : social_bootstrap

Target Server Type    : MYSQL
Target Server Version : 50545
File Encoding         : 65001

Date: 2017-02-15 12:14:58
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `chat`
-- ----------------------------
DROP TABLE IF EXISTS `chat`;
CREATE TABLE `chat` (
  `chat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `message` text,
  `photos` text,
  `date` int(11) DEFAULT NULL,
  `talk_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`chat_id`),
  UNIQUE KEY `wall_id` (`chat_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of chat
-- ----------------------------

-- ----------------------------
-- Table structure for `chat_to_online`
-- ----------------------------
DROP TABLE IF EXISTS `chat_to_online`;
CREATE TABLE `chat_to_online` (
  `user_id` int(11) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of chat_to_online
-- ----------------------------

-- ----------------------------
-- Table structure for `comments`
-- ----------------------------
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `comments_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `photo_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `comment` text,
  `photos` text,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`comments_id`),
  KEY `photo_id` (`photo_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of comments
-- ----------------------------

-- ----------------------------
-- Table structure for `dialogs`
-- ----------------------------
DROP TABLE IF EXISTS `dialogs`;
CREATE TABLE `dialogs` (
  `dialog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_from` int(11) DEFAULT NULL,
  `user_to` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`dialog_id`),
  KEY `user_from` (`user_from`),
  KEY `user_to` (`user_to`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of dialogs
-- ----------------------------

-- ----------------------------
-- Table structure for `friends`
-- ----------------------------
DROP TABLE IF EXISTS `friends`;
CREATE TABLE `friends` (
  `user_id` int(11) DEFAULT NULL,
  `friend_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `status_menu` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`),
  KEY `friend_id` (`friend_id`),
  KEY `status_menu` (`status_menu`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of friends
-- ----------------------------

-- ----------------------------
-- Table structure for `likes`
-- ----------------------------
DROP TABLE IF EXISTS `likes`;
CREATE TABLE `likes` (
  `likes_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `object_type` int(11) DEFAULT NULL,
  `object_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`likes_id`),
  KEY `likes_id` (`likes_id`),
  KEY `user_id` (`user_id`),
  KEY `object_id` (`object_id`),
  KEY `object_type` (`object_type`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of likes
-- ----------------------------

-- ----------------------------
-- Table structure for `messages`
-- ----------------------------
DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_from` int(11) DEFAULT NULL,
  `user_to` int(11) DEFAULT NULL,
  `message` text,
  `photos` text,
  `date` int(11) DEFAULT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of messages
-- ----------------------------

-- ----------------------------
-- Table structure for `net_city`
-- ----------------------------
DROP TABLE IF EXISTS `net_city`;
CREATE TABLE `net_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) DEFAULT NULL,
  `name_ru` varchar(100) DEFAULT NULL,
  `name_en` varchar(100) DEFAULT NULL,
  `region` varchar(2) DEFAULT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  `latitude` varchar(10) DEFAULT NULL,
  `longitude` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `name_ru` (`name_ru`),
  KEY `name_en` (`name_en`)
) ENGINE=MyISAM AUTO_INCREMENT=438354 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of net_city
-- ----------------------------
INSERT INTO `net_city` VALUES ('2198', '23', 'Темекула', 'Temecula', 'CA', '92591', '33.5300', '-117.1035');
INSERT INTO `net_city` VALUES ('2200', '23', 'Фуллертон', 'Fullerton', 'CA', '92835', '33.9019', '-117.9108');
INSERT INTO `net_city` VALUES ('2206', '23', 'Брея', 'Brea', 'CA', '92821', '33.9269', '-117.8612');
INSERT INTO `net_city` VALUES ('2208', '23', 'Джорджтаун', 'Georgetown', 'KY', '40324', '38.2532', '-84.5524');
INSERT INTO `net_city` VALUES ('2213', '23', 'Ист Орора', 'East Aurora', 'NY', '14052', '42.7680', '-78.5801');
INSERT INTO `net_city` VALUES ('2216', '23', 'Кент', 'Kent', 'WA', '98031', '47.4084', '-122.1957');
INSERT INTO `net_city` VALUES ('2218', '23', 'Лагуна Хилс', 'Laguna Hills', 'CA', '92653', '33.6053', '-117.7173');
INSERT INTO `net_city` VALUES ('2219', '23', 'Алисо Вьехо', 'Aliso Viejo', 'CA', '92656', '33.5717', '-117.7289');
INSERT INTO `net_city` VALUES ('2222', '23', 'Ньюарк', 'Newark', 'NJ', '07105', '40.7211', '-74.1470');
INSERT INTO `net_city` VALUES ('2223', '23', 'Ла Пуэнт', 'La Puente', 'CA', '91746', '34.0463', '-117.9849');
INSERT INTO `net_city` VALUES ('2224', '23', 'Йорба Линда', 'Yorba Linda', 'CA', '92887', '33.8879', '-117.7286');
INSERT INTO `net_city` VALUES ('2227', '23', 'Помона', 'Pomona', 'CA', '91766', '34.0390', '-117.7548');
INSERT INTO `net_city` VALUES ('2235', '23', 'Чико', 'Chico', 'CA', '95928', '39.7158', '-121.8147');
INSERT INTO `net_city` VALUES ('2240', '23', 'Нина', 'Neenah', 'WI', '54956', '44.1843', '-88.5305');
INSERT INTO `net_city` VALUES ('2241', '23', 'Шаамбург', 'Schaumburg', 'IL', '60173', '42.0534', '-88.0540');
INSERT INTO `net_city` VALUES ('2244', '23', 'Элгин', 'Elgin', 'IL', '60123', '42.0358', '-88.3801');
INSERT INTO `net_city` VALUES ('2245', '23', 'Итаска', 'Itasca', 'IL', '60143', '41.9708', '-88.0179');
INSERT INTO `net_city` VALUES ('2247', '23', 'Мак-Генри', 'McHenry', 'IL', '60050', '42.3595', '-88.2734');
INSERT INTO `net_city` VALUES ('2248', '23', 'Роллинг Медоус', 'Rolling Meadows', 'IL', '60008', '42.0678', '-88.0185');
INSERT INTO `net_city` VALUES ('2249', '23', 'Линкольншир', 'Lincolnshire', 'IL', '60069', '42.1973', '-87.9241');
INSERT INTO `net_city` VALUES ('2251', '23', 'Стейт Колледж', 'State College', 'PA', '16803', '40.7975', '-77.9021');
INSERT INTO `net_city` VALUES ('2252', '23', 'Вернон Хилс', 'Vernon Hills', 'IL', '60061', '42.2325', '-87.9634');
INSERT INTO `net_city` VALUES ('2253', '23', 'Элизабет', 'Elizabeth', 'NJ', '07201', '40.6728', '-74.1790');
INSERT INTO `net_city` VALUES ('2254', '23', 'Грили', 'Greeley', 'CO', '80634', '40.3996', '-104.8002');
INSERT INTO `net_city` VALUES ('2255', '23', 'Мансфилд', 'Mansfield', 'MA', '02048', '42.0166', '-71.2231');
INSERT INTO `net_city` VALUES ('2258', '23', 'Ноксвилл', 'Knoxville', 'TN', '37918', '36.0582', '-83.9147');
INSERT INTO `net_city` VALUES ('2261', '23', 'Норт Ричленд Хилс', 'North Richland Hills', 'TX', '76180', '32.8659', '-97.2176');
INSERT INTO `net_city` VALUES ('2264', '23', 'Даймонд Спрингс', 'Diamond Springs', 'CA', '95619', '38.6779', '-120.8103');
INSERT INTO `net_city` VALUES ('2266', '23', 'Блумингдейл', 'Bloomingdale', 'IL', '60108', '41.9484', '-88.0947');
INSERT INTO `net_city` VALUES ('2267', '23', 'Арлингтон-Хайтс', 'Arlington Heights', 'IL', '60004', '42.1130', '-87.9807');
INSERT INTO `net_city` VALUES ('2270', '23', 'Уилинг', 'Wheeling', 'IL', '60090', '42.1286', '-87.9237');
INSERT INTO `net_city` VALUES ('2273', '23', 'Пампа', 'Pampa', 'TX', '79065', '35.5418', '-100.8775');
INSERT INTO `net_city` VALUES ('2274', '23', 'Манделей', 'Mundelein', 'IL', '60060', '42.2667', '-88.0508');
INSERT INTO `net_city` VALUES ('2275', '23', 'Баррингтон', 'Barrington', 'IL', '60010', '42.1584', '-88.1592');
INSERT INTO `net_city` VALUES ('2276', '23', 'Декальб', 'DeKalb', 'IL', '60115', '41.8963', '-88.7442');
INSERT INTO `net_city` VALUES ('2280', '23', 'Роквилл', 'Rockville', 'MD', '20850', '39.0892', '-77.1835');
INSERT INTO `net_city` VALUES ('2281', '23', 'Бенсенвилл', 'Bensenville', 'IL', '60106', '41.9619', '-87.9473');
INSERT INTO `net_city` VALUES ('2282', '23', 'Розл', 'Roselle', 'IL', '60172', '41.9792', '-88.0895');
INSERT INTO `net_city` VALUES ('2286', '23', 'Джермантаун', 'Germantown', 'NY', '12526', '42.1261', '-73.8633');
INSERT INTO `net_city` VALUES ('2288', '23', 'Шелберн', 'Shelburne', 'VT', '05482', '44.3960', '-73.2074');
INSERT INTO `net_city` VALUES ('2293', '23', 'Саут-Бёрлингтон', 'South Burlington', 'VT', '05403', '44.4524', '-73.1841');
INSERT INTO `net_city` VALUES ('2296', '23', 'Клифтон Парк', 'Clifton Park', 'NY', '12065', '42.8571', '-73.7993');
INSERT INTO `net_city` VALUES ('2299', '23', 'Смагглерс Нотч', 'Smugglers Notch', 'VT', '05464', '44.6407', '-72.8072');
INSERT INTO `net_city` VALUES ('2301', '23', 'Ист Гринбуш', 'East Greenbush', 'NY', '12061', '42.6012', '-73.6525');
INSERT INTO `net_city` VALUES ('2303', '23', 'Коблскилл', 'Cobleskill', 'NY', '12043', '42.7042', '-74.5278');
INSERT INTO `net_city` VALUES ('2304', '23', 'Скенектади', 'Schenectady', 'NY', '12302', '42.8822', '-73.9916');
INSERT INTO `net_city` VALUES ('2305', '23', 'Воорхеесвилл', 'Voorheesville', 'NY', '12186', '42.6213', '-73.9721');
INSERT INTO `net_city` VALUES ('2308', '23', 'Сомерс', 'Somers', 'NY', '10589', '41.3246', '-73.6976');
INSERT INTO `net_city` VALUES ('2309', '23', 'Колумбия', 'Columbia', 'SC', '29203', '34.0988', '-81.0612');
INSERT INTO `net_city` VALUES ('2310', '23', 'Уэст-Голливуд', 'West Hollywood', 'CA', '90069', '34.0943', '-118.3811');
INSERT INTO `net_city` VALUES ('2311', '23', 'Чатсворт', 'Chatsworth', 'CA', '91311', '34.2868', '-118.6140');
INSERT INTO `net_city` VALUES ('2314', '23', 'Уотертаун', 'Watertown', 'NY', '13601', '43.9786', '-75.9004');
INSERT INTO `net_city` VALUES ('2319', '23', 'Индепенденс', 'Independence', 'MO', '64057', '39.0615', '-94.2657');
INSERT INTO `net_city` VALUES ('2322', '23', 'Эшвилл', 'Asheville', 'NC', '28806', '35.5683', '-82.6272');
INSERT INTO `net_city` VALUES ('2323', '23', 'Хогансберг', 'Hogansburg', 'NY', '13655', '44.9759', '-74.6203');
INSERT INTO `net_city` VALUES ('2324', '23', 'Элизабеттаун', 'Elizabethtown', 'NY', '12932', '44.1827', '-73.6167');
INSERT INTO `net_city` VALUES ('2325', '23', 'Фултонвилл', 'Fultonville', 'NY', '12072', '42.8734', '-74.3587');
INSERT INTO `net_city` VALUES ('2327', '23', 'Саратога-Спрингс', 'Saratoga Springs', 'NY', '12866', '43.0535', '-73.7517');
INSERT INTO `net_city` VALUES ('2328', '23', 'Элизабет', 'Elizabeth', 'IL', '61028', '42.3014', '-90.1534');
INSERT INTO `net_city` VALUES ('2333', '23', 'Колчестер', 'Colchester', 'VT', '05446', '44.5500', '-73.1552');
INSERT INTO `net_city` VALUES ('2334', '23', 'Стоу', 'Stowe', 'VT', '05672', '44.4806', '-72.7177');
INSERT INTO `net_city` VALUES ('2335', '23', 'Эссекс Джанкшен', 'Essex Junction', 'VT', '05452', '44.5327', '-73.0580');
INSERT INTO `net_city` VALUES ('2337', '23', 'Валпараисо', 'Valparaiso', 'IN', '46385', '41.4591', '-87.1390');
INSERT INTO `net_city` VALUES ('2339', '23', 'Меррилвилл', 'Merrillville', 'IN', '46410', '41.4793', '-87.3164');
INSERT INTO `net_city` VALUES ('2340', '23', 'Мантено', 'Manteno', 'IL', '60950', '41.2541', '-87.8912');
INSERT INTO `net_city` VALUES ('2344', '23', 'Харви', 'Harvey', 'IL', '60426', '41.6088', '-87.6739');
INSERT INTO `net_city` VALUES ('2345', '23', 'Шелдон', 'Sheldon', 'IL', '60966', '40.7517', '-87.5896');
INSERT INTO `net_city` VALUES ('2347', '23', 'Нью Баффало', 'New Buffalo', 'MI', '49117', '41.7939', '-86.7405');
INSERT INTO `net_city` VALUES ('2349', '23', 'Канкаки', 'Kankakee', 'IL', '60901', '41.1190', '-87.9259');
INSERT INTO `net_city` VALUES ('2350', '23', 'Чилхауи', 'Chilhowie', 'VA', '24319', '36.7687', '-81.5972');
INSERT INTO `net_city` VALUES ('2351', '23', 'Гейтерсберг', 'Gaithersburg', 'MD', '20878', '39.1148', '-77.2462');
INSERT INTO `net_city` VALUES ('2354', '23', 'Хиллсборо', 'Hillsborough', 'NC', '27278', '36.0755', '-79.0741');
INSERT INTO `net_city` VALUES ('2355', '23', 'Данн', 'Dunn', 'NC', '28334', '35.2763', '-78.5468');
INSERT INTO `net_city` VALUES ('2357', '23', 'Салфер', 'Sulphur', 'OK', '73086', '34.4847', '-96.9586');
INSERT INTO `net_city` VALUES ('2358', '23', 'Новато', 'Novato', 'CA', '94945', '38.1348', '-122.5610');
INSERT INTO `net_city` VALUES ('2360', '23', 'Ангьер', 'Angier', 'NC', '27501', '35.4832', '-78.6798');
INSERT INTO `net_city` VALUES ('2362', '23', 'Варшава', 'Warsaw', 'NC', '28398', '34.9860', '-78.0524');
INSERT INTO `net_city` VALUES ('2363', '23', 'Ривервью', 'Riverview', 'FL', '33569', '27.8223', '-82.2797');
INSERT INTO `net_city` VALUES ('2364', '23', 'Уоллес', 'Wallace', 'NC', '28466', '34.7316', '-77.9353');
INSERT INTO `net_city` VALUES ('2365', '23', 'Килл-Девил-Хиллз', 'Kill Devil Hills', 'NC', '27948', '36.0200', '-75.6699');
INSERT INTO `net_city` VALUES ('2370', '23', 'Дункан', 'Duncan', 'OK', '73533', '34.4926', '-97.8523');
INSERT INTO `net_city` VALUES ('2372', '23', 'Форт Кобб', 'Fort Cobb', 'OK', '73038', '35.1236', '-98.4249');
INSERT INTO `net_city` VALUES ('2373', '23', 'Саутпорт', 'Southport', 'NC', '28461', '33.9970', '-78.0729');
INSERT INTO `net_city` VALUES ('2374', '23', 'Питтсборо', 'Pittsboro', 'NC', '27312', '35.7519', '-79.2248');
INSERT INTO `net_city` VALUES ('2376', '23', 'Андерсон', 'Anderson', 'CA', '96007', '40.4458', '-122.3548');
INSERT INTO `net_city` VALUES ('2378', '23', 'Хайавасси', 'Hiawassee', 'GA', '30546', '34.8915', '-83.6861');
INSERT INTO `net_city` VALUES ('2381', '23', 'Бишоп', 'Bishop', 'CA', '93514', '37.5060', '-118.3114');
INSERT INTO `net_city` VALUES ('2382', '23', 'Уэст Сакраменто', 'West Sacramento', 'CA', '95691', '38.6667', '-121.6293');
INSERT INTO `net_city` VALUES ('2383', '23', 'Агура-Хиллз', 'Agoura Hills', 'CA', '91301', '34.1267', '-118.7648');
INSERT INTO `net_city` VALUES ('2384', '23', 'Гарленд', 'Garland', 'TX', '75041', '32.8756', '-96.6482');
INSERT INTO `net_city` VALUES ('2385', '23', 'Стокбридж', 'Stockbridge', 'GA', '30281', '33.5547', '-84.1872');
INSERT INTO `net_city` VALUES ('2386', '23', 'Дотан', 'Dothan', 'AL', '36301', '31.1503', '-85.4114');
INSERT INTO `net_city` VALUES ('2388', '23', 'Пласервилл', 'Placerville', 'CA', '95667', '38.7365', '-120.8043');
INSERT INTO `net_city` VALUES ('2390', '23', 'Голдсборо', 'Goldsboro', 'NC', '27534', '35.3673', '-77.9122');
INSERT INTO `net_city` VALUES ('2393', '23', 'Хай-Пойнт', 'High Point', 'NC', '27265', '36.0162', '-80.0434');
INSERT INTO `net_city` VALUES ('2394', '23', 'Уилсон', 'Wilson', 'NC', '27893', '35.6800', '-77.9126');
INSERT INTO `net_city` VALUES ('2395', '23', 'Стейтсвилл', 'Statesville', 'NC', '28677', '35.7250', '-80.9069');
INSERT INTO `net_city` VALUES ('2401', '23', 'Ковингтон', 'Covington', 'KY', '41011', '39.0657', '-84.5290');
INSERT INTO `net_city` VALUES ('2403', '23', 'Глазго', 'Glasgow', 'KY', '42141', '36.9376', '-85.9463');
INSERT INTO `net_city` VALUES ('2412', '23', 'Палм-Бич Гарденс', 'Palm Beach Gardens', 'FL', '33410', '26.8457', '-80.0902');
INSERT INTO `net_city` VALUES ('2413', '23', 'Дир Лодж', 'Deer Lodge', 'TN', '37726', '36.2096', '-84.8365');
INSERT INTO `net_city` VALUES ('2414', '23', 'Уайт Хаус', 'White House', 'TN', '37188', '36.4817', '-86.6756');
INSERT INTO `net_city` VALUES ('2416', '23', 'Рино', 'Reno', 'NV', '89502', '39.4896', '-119.7492');
INSERT INTO `net_city` VALUES ('2417', '23', 'Маунт-Плезант', 'Mount Pleasant', 'TN', '38474', '35.5128', '-87.2179');
INSERT INTO `net_city` VALUES ('2418', '23', 'Мейфилд', 'Mayfield', 'KY', '42066', '36.7364', '-88.6388');
INSERT INTO `net_city` VALUES ('2419', '23', 'Колумбия', 'Columbia', 'TN', '38401', '35.6489', '-86.9958');
INSERT INTO `net_city` VALUES ('2420', '23', 'Элизабеттон', 'Elizabethton', 'TN', '37643', '36.4199', '-82.1139');
INSERT INTO `net_city` VALUES ('2421', '23', 'Форт Валли', 'Fort Valley', 'GA', '31030', '32.5724', '-83.8921');
INSERT INTO `net_city` VALUES ('2422', '23', 'Мэдисонвилл', 'Madisonville', 'KY', '42431', '37.3268', '-87.4696');
INSERT INTO `net_city` VALUES ('2423', '23', 'Ла Вергн', 'La Vergne', 'TN', '37086', '36.0212', '-86.5595');
INSERT INTO `net_city` VALUES ('2424', '23', 'Смирна', 'Smyrna', 'TN', '37167', '35.9593', '-86.5420');
INSERT INTO `net_city` VALUES ('2425', '23', 'Холли Спрингс', 'Holly Springs', 'MS', '38635', '34.7746', '-89.4533');
INSERT INTO `net_city` VALUES ('2426', '23', 'Гаррисберг', 'Harrisburg', 'PA', '17111', '40.2762', '-76.7889');
INSERT INTO `net_city` VALUES ('2427', '23', 'Куквилл', 'Cookeville', 'TN', '38506', '36.1920', '-85.4559');
INSERT INTO `net_city` VALUES ('2429', '23', 'Кейв Сити', 'Cave City', 'KY', '42127', '37.1243', '-85.9100');
INSERT INTO `net_city` VALUES ('2431', '23', 'Падака', 'Paducah', 'KY', '42001', '37.0383', '-88.7157');
INSERT INTO `net_city` VALUES ('2433', '23', 'Маунт Джулиет', 'Mount Juliet', 'TN', '37122', '36.1718', '-86.4904');
INSERT INTO `net_city` VALUES ('2435', '23', 'Таллахома', 'Tullahoma', 'TN', '37388', '35.3512', '-86.1838');
INSERT INTO `net_city` VALUES ('2436', '23', 'Мартинсвилл', 'Marysville', 'OH', '43040', '40.2540', '-83.3685');
INSERT INTO `net_city` VALUES ('2437', '23', 'Гудлетсвилл', 'Goodlettsville', 'TN', '37072', '36.3545', '-86.7628');
INSERT INTO `net_city` VALUES ('2438', '23', 'Принстон', 'Princeton', 'NJ', '08540', '40.3756', '-74.6597');
INSERT INTO `net_city` VALUES ('2445', '23', 'Кроссвилл', 'Crossville', 'TN', '38555', '35.8713', '-84.9835');
INSERT INTO `net_city` VALUES ('2447', '23', 'Форт-Брэгг', 'Fort Bragg', 'NC', '28307', '35.1462', '-78.9943');
INSERT INTO `net_city` VALUES ('2449', '23', 'Авила Бич', 'Avila Beach', 'CA', '93424', '35.1800', '-120.7318');
INSERT INTO `net_city` VALUES ('2452', '23', 'Мартин', 'Martin', 'TN', '38237', '36.3838', '-88.8319');
INSERT INTO `net_city` VALUES ('2458', '23', 'Хендерсонвилл', 'Hendersonville', 'NC', '28791', '35.3621', '-82.5082');
INSERT INTO `net_city` VALUES ('2459', '23', 'Хантерсвилл', 'Huntersville', 'NC', '28078', '35.4034', '-80.8611');
INSERT INTO `net_city` VALUES ('2461', '23', 'Ламбертон', 'Lumberton', 'NC', '28358', '34.6008', '-78.9673');
INSERT INTO `net_city` VALUES ('2463', '23', 'Спартанберг', 'Spartanburg', 'SC', '29301', '34.9318', '-82.0102');
INSERT INTO `net_city` VALUES ('2466', '23', 'Ленуар', 'Lenoir', 'NC', '28645', '35.9726', '-81.5513');
INSERT INTO `net_city` VALUES ('2468', '23', 'Равенел', 'Ravenel', 'SC', '29470', '32.8073', '-80.2584');
INSERT INTO `net_city` VALUES ('2470', '23', 'Пидмонт', 'Piedmont', 'SC', '29673', '34.7266', '-82.4598');
INSERT INTO `net_city` VALUES ('2473', '23', 'Кингс Маунтин', 'Kings Mountain', 'NC', '28086', '35.2558', '-81.3707');
INSERT INTO `net_city` VALUES ('2474', '23', 'Маунт Холли', 'Mount Holly', 'NC', '28120', '35.3235', '-81.0215');
INSERT INTO `net_city` VALUES ('2478', '23', 'Мурсвилл', 'Mooresville', 'NC', '28115', '35.5890', '-80.7680');
INSERT INTO `net_city` VALUES ('2483', '23', 'Коновер', 'Conover', 'NC', '28613', '35.7427', '-81.2093');
INSERT INTO `net_city` VALUES ('2486', '23', 'Лоринберг', 'Laurinburg', 'NC', '28352', '34.7678', '-79.4639');
INSERT INTO `net_city` VALUES ('2491', '23', 'Кингспорт', 'Kingsport', 'TN', '37663', '36.4601', '-82.5012');
INSERT INTO `net_city` VALUES ('2492', '23', 'Литлтон', 'Littleton', 'CO', '80126', '39.5347', '-104.9582');
INSERT INTO `net_city` VALUES ('2493', '23', 'Джонсон Сити', 'Johnson City', 'TN', '37615', '36.3891', '-82.4511');
INSERT INTO `net_city` VALUES ('2495', '23', 'Стерлинг Форест', 'Sterling Forest', 'NY', '10979', '41.1826', '-74.3188');
INSERT INTO `net_city` VALUES ('2497', '23', 'Лавс Парк', 'Loves Park', 'IL', '61111', '42.3296', '-88.9995');
INSERT INTO `net_city` VALUES ('2498', '23', 'Трентон', 'Trenton', 'NJ', '08628', '40.2648', '-74.8243');
INSERT INTO `net_city` VALUES ('2499', '23', 'Стэмфорд', 'Stamford', 'CT', '06904', '41.0534', '-73.5387');
INSERT INTO `net_city` VALUES ('2508', '23', 'Кранбери', 'Cranbury', 'NJ', '08512', '40.3179', '-74.5341');
INSERT INTO `net_city` VALUES ('2512', '23', 'Нови', 'Novi', 'MI', '48375', '42.4634', '-83.4646');
INSERT INTO `net_city` VALUES ('2516', '23', 'Уэстамптон', 'Westampton', 'NJ', '08048', '39.9717', '-74.8096');
INSERT INTO `net_city` VALUES ('2518', '23', 'Плейнсборо', 'Plainsboro', 'NJ', '08536', '40.3289', '-74.5857');
INSERT INTO `net_city` VALUES ('2519', '23', 'Норт-Лас-Вегас', 'North Las Vegas', 'NV', '89030', '36.2187', '-115.1293');
INSERT INTO `net_city` VALUES ('2520', '23', 'Мандевилл', 'Mandeville', 'LA', '70471', '30.4184', '-90.0069');
INSERT INTO `net_city` VALUES ('2523', '23', 'Окснард', 'Oxnard', 'CA', '93030', '34.1980', '-119.1726');
INSERT INTO `net_city` VALUES ('2525', '23', 'Сайоссет', 'Syosset', 'NY', '11791', '40.8294', '-73.5052');
INSERT INTO `net_city` VALUES ('2526', '23', 'Кинстон', 'Kinston', 'NC', '28504', '35.2375', '-77.6151');
INSERT INTO `net_city` VALUES ('2530', '23', 'Гамильтон', 'Hamilton', 'NJ', '08550', '40.2830', '-74.6217');
INSERT INTO `net_city` VALUES ('2544', '23', 'Джексон', 'Jackson', 'MI', '49202', '42.2749', '-84.4017');
INSERT INTO `net_city` VALUES ('2545', '23', 'Эдвардс', 'Edwards', 'CA', '93524', '35.2944', '-118.9052');
INSERT INTO `net_city` VALUES ('2546', '23', 'Уокешо', 'Waukesha', 'WI', '53186', '43.0302', '-88.2153');
INSERT INTO `net_city` VALUES ('2548', '23', 'Файрфилд', 'Fairfield', 'OH', '45014', '39.3367', '-84.5496');
INSERT INTO `net_city` VALUES ('2550', '23', 'Марбл Фолс', 'Marble Falls', 'TX', '78654', '30.5632', '-98.1112');
INSERT INTO `net_city` VALUES ('2552', '23', 'Хейуорд', 'Hayward', 'CA', '94544', '37.6393', '-122.0442');
INSERT INTO `net_city` VALUES ('2554', '23', 'Шиллер Парк', 'Schiller Park', 'IL', '60176', '41.9637', '-87.8841');
INSERT INTO `net_city` VALUES ('2555', '23', 'Конкорд', 'Concord', 'CA', '94520', '38.0033', '-122.0318');
INSERT INTO `net_city` VALUES ('2556', '23', 'Стрингтаун', 'Stringtown', 'OK', '74569', '34.4624', '-95.9026');
INSERT INTO `net_city` VALUES ('2558', '23', 'Систерс', 'Sisters', 'OR', '97759', '44.4102', '-121.9283');
INSERT INTO `net_city` VALUES ('2560', '23', 'Уэстлейк', 'Westlake', 'OH', '44145', '41.4446', '-81.9220');
INSERT INTO `net_city` VALUES ('2561', '23', 'Черри Хилл', 'Cherry Hill', 'NJ', '08034', '39.9068', '-74.9966');
INSERT INTO `net_city` VALUES ('2562', '23', 'Эгг Харбор Тауншип', 'Egg Harbor Township', 'NJ', '08234', '39.3870', '-74.6217');
INSERT INTO `net_city` VALUES ('2568', '23', 'Хаммонтон', 'Hammonton', 'NJ', '08037', '39.6363', '-74.7633');
INSERT INTO `net_city` VALUES ('2569', '23', 'Такертон', 'Tuckerton', 'NJ', '08087', '39.5996', '-74.3687');
INSERT INTO `net_city` VALUES ('2570', '23', 'Розберг', 'Roseburg', 'OR', '97470', '43.2179', '-123.4021');
INSERT INTO `net_city` VALUES ('2571', '23', 'Абсекон', 'Absecon', 'NJ', '08201', '39.4209', '-74.4977');
INSERT INTO `net_city` VALUES ('2572', '23', 'Сан Рафаел', 'San Rafael', 'CA', '94901', '37.9719', '-122.5023');
INSERT INTO `net_city` VALUES ('2573', '23', 'Алтуна', 'Altoona', 'PA', '16602', '40.5172', '-78.3662');
INSERT INTO `net_city` VALUES ('2574', '23', 'Чемберсберг', 'Chambersburg', 'PA', '17201', '39.9320', '-77.7069');
INSERT INTO `net_city` VALUES ('2576', '23', 'Беллефонт', 'Bellefonte', 'PA', '16823', '40.9354', '-77.7831');
INSERT INTO `net_city` VALUES ('2578', '23', 'Хаммелстаун', 'Hummelstown', 'PA', '17036', '40.3084', '-76.6954');
INSERT INTO `net_city` VALUES ('2580', '23', 'Берд ин Ханд', 'Bird in Hand', 'PA', '17505', '40.0506', '-76.1703');
INSERT INTO `net_city` VALUES ('2581', '23', 'Клирфилд', 'Clearfield', 'PA', '16830', '41.0559', '-78.4129');
INSERT INTO `net_city` VALUES ('2582', '23', 'Йорк', 'York', 'PA', '17402', '40.0020', '-76.6836');
INSERT INTO `net_city` VALUES ('2583', '23', 'Грец', 'Gratz', 'PA', '17030', '40.6090', '-76.7273');
INSERT INTO `net_city` VALUES ('2586', '23', 'Меканиксберг', 'Mechanicsburg', 'PA', '17055', '40.1814', '-76.9969');
INSERT INTO `net_city` VALUES ('2587', '23', 'Медина', 'Medina', 'OH', '44256', '41.1343', '-81.8559');
INSERT INTO `net_city` VALUES ('2590', '23', 'Уодсворт', 'Wadsworth', 'OH', '44281', '41.0621', '-81.7451');
INSERT INTO `net_city` VALUES ('2591', '23', 'Медфорд', 'Medford', 'OR', '97504', '42.3393', '-122.7987');
INSERT INTO `net_city` VALUES ('2593', '23', 'Нью Касл', 'New Castle', 'PA', '16101', '40.9708', '-80.3010');
INSERT INTO `net_city` VALUES ('2597', '23', 'Бриджвилл', 'Bridgeville', 'PA', '15017', '40.3456', '-80.1342');
INSERT INTO `net_city` VALUES ('2598', '23', 'Перриополис', 'Perryopolis', 'PA', '15473', '40.0702', '-79.7471');
INSERT INTO `net_city` VALUES ('2599', '23', 'Марион', 'Marion', 'IL', '62959', '37.7229', '-88.8852');
INSERT INTO `net_city` VALUES ('2601', '23', 'Деруэнт', 'Derwent', 'OH', '43733', '39.9231', '-81.5443');
INSERT INTO `net_city` VALUES ('2603', '23', 'Фреденс', 'Friedens', 'PA', '15541', '40.0666', '-78.9667');
INSERT INTO `net_city` VALUES ('2604', '23', 'Маунт-Вернон', 'Mount Vernon', 'IL', '62864', '38.3178', '-88.8921');
INSERT INTO `net_city` VALUES ('2605', '23', 'Мерсер', 'Mercer', 'PA', '16137', '41.2225', '-80.2521');
INSERT INTO `net_city` VALUES ('2606', '23', 'Бейтаун', 'Baytown', 'TX', '77520', '29.7709', '-94.9071');
INSERT INTO `net_city` VALUES ('2607', '23', 'Карлинвилл', 'Carlinville', 'IL', '62626', '39.2840', '-89.8698');
INSERT INTO `net_city` VALUES ('2609', '23', 'Панама-Сити', 'Panama City', 'FL', '32408', '30.1521', '-85.7267');
INSERT INTO `net_city` VALUES ('2610', '23', 'Монровилл', 'Monroeville', 'PA', '15146', '40.4235', '-79.7588');
INSERT INTO `net_city` VALUES ('2611', '23', 'Портедж', 'Portage', 'PA', '15946', '40.3631', '-78.6448');
INSERT INTO `net_city` VALUES ('2612', '23', 'Энн-Арбор', 'Ann Arbor', 'MI', '48104', '42.2734', '-83.7133');
INSERT INTO `net_city` VALUES ('2613', '23', 'Моргантаун', 'Morgantown', 'WV', '26505', '39.6456', '-79.9433');
INSERT INTO `net_city` VALUES ('2622', '23', 'Селмер', 'Selmer', 'TN', '38375', '35.1599', '-88.6035');
INSERT INTO `net_city` VALUES ('2624', '23', 'Блу Спрингс', 'Blue Springs', 'MO', '64014', '39.0050', '-94.2499');
INSERT INTO `net_city` VALUES ('2625', '23', 'Ливуд', 'Leawood', 'KS', '66206', '38.9586', '-94.6202');
INSERT INTO `net_city` VALUES ('2628', '23', 'Шейди Ков', 'Shady Cove', 'OR', '97539', '42.6196', '-122.7998');
INSERT INTO `net_city` VALUES ('2629', '23', 'Сейлем', 'Salem', 'OR', '97301', '44.9016', '-122.9223');
INSERT INTO `net_city` VALUES ('2631', '23', 'Топика', 'Topeka', 'KS', '66604', '39.0380', '-95.7278');
INSERT INTO `net_city` VALUES ('2632', '23', 'Реймор', 'Raymore', 'MO', '64083', '38.7970', '-94.4492');
INSERT INTO `net_city` VALUES ('2633', '23', 'Карни', 'Kearney', 'MO', '64060', '39.3753', '-94.3570');
INSERT INTO `net_city` VALUES ('2636', '23', 'Холлистер', 'Hollister', 'MO', '65672', '36.5691', '-93.2248');
INSERT INTO `net_city` VALUES ('2637', '23', 'Шони', 'Shawnee', 'KS', '66216', '39.0147', '-94.7395');
INSERT INTO `net_city` VALUES ('2638', '23', 'Канзас-Сити', 'Kansas City', 'MO', '64153', '39.2884', '-94.7457');
INSERT INTO `net_city` VALUES ('2639', '23', 'Хиггинсвилл', 'Higginsville', 'MO', '64037', '39.0398', '-93.7367');
INSERT INTO `net_city` VALUES ('2644', '23', 'Лоренс', 'Lawrence', 'KS', '66047', '38.8916', '-95.3418');
INSERT INTO `net_city` VALUES ('2645', '23', 'Норт Хайлендс', 'North Highlands', 'CA', '95660', '38.6681', '-121.3736');
INSERT INTO `net_city` VALUES ('2647', '23', 'Похаттан', 'Powhattan', 'KS', '66527', '39.7327', '-95.6760');
INSERT INTO `net_city` VALUES ('2648', '23', 'Станберри', 'Stanberry', 'MO', '64489', '40.2274', '-94.5558');
INSERT INTO `net_city` VALUES ('2650', '23', 'Эмпория', 'Emporia', 'KS', '66801', '38.4270', '-96.2103');
INSERT INTO `net_city` VALUES ('2654', '23', 'Салина', 'Salina', 'KS', '67401', '38.8522', '-97.6142');
INSERT INTO `net_city` VALUES ('2655', '23', 'Моррилтон', 'Morrilton', 'AR', '72110', '35.1717', '-92.7447');
INSERT INTO `net_city` VALUES ('2658', '23', 'Чилликот', 'Chillicothe', 'MO', '64601', '39.8604', '-93.6751');
INSERT INTO `net_city` VALUES ('2659', '23', 'Шеридан', 'Sheridan', 'OR', '97378', '45.1016', '-123.4197');
INSERT INTO `net_city` VALUES ('2661', '23', 'Монетт', 'Monett', 'MO', '65708', '36.9251', '-93.9197');
INSERT INTO `net_city` VALUES ('2666', '23', 'Сент-Джозеф', 'Saint Joseph', 'MO', '64506', '39.7945', '-94.8042');
INSERT INTO `net_city` VALUES ('2668', '23', 'Брокен-Эрроу', 'Broken Arrow', 'OK', '74014', '36.0271', '-95.5576');
INSERT INTO `net_city` VALUES ('2669', '23', 'Лис Саммит', 'Lees Summit', 'MO', '64086', '38.9145', '-94.3006');
INSERT INTO `net_city` VALUES ('2670', '23', 'Орленд Парк', 'Orland Park', 'IL', '60462', '41.6163', '-87.8371');
INSERT INTO `net_city` VALUES ('2671', '23', 'Манхэттен', 'Manhattan', 'KS', '66503', '39.2483', '-96.6849');
INSERT INTO `net_city` VALUES ('2676', '23', 'Харрисонвилл', 'Harrisonville', 'MO', '64701', '38.6089', '-94.3093');
INSERT INTO `net_city` VALUES ('2680', '23', 'Миртл-Бич', 'Myrtle Beach', 'SC', '29579', '33.7527', '-78.9071');
INSERT INTO `net_city` VALUES ('2683', '23', 'Эль-Дорадо', 'El Dorado', 'AR', '71730', '33.1929', '-92.6434');
INSERT INTO `net_city` VALUES ('2685', '23', 'Бунвилл', 'Boonville', 'MO', '65233', '38.9029', '-92.7071');
INSERT INTO `net_city` VALUES ('2686', '23', 'Берлингейм', 'Burlingame', 'CA', '94010', '37.5671', '-122.3710');
INSERT INTO `net_city` VALUES ('2687', '23', 'Фримонт', 'Fremont', 'CA', '94538', '37.5079', '-121.9599');
INSERT INTO `net_city` VALUES ('2690', '23', 'Дублин', 'Dublin', 'CA', '94568', '37.7186', '-121.9164');
INSERT INTO `net_city` VALUES ('2692', '23', 'Пало-Альто', 'Palo Alto', 'CA', '94306', '37.4135', '-122.1312');
INSERT INTO `net_city` VALUES ('2693', '23', 'Уоррингтон', 'Warrington', 'PA', '18976', '40.2489', '-75.1498');
INSERT INTO `net_city` VALUES ('2695', '23', 'Ньюарк', 'Newark', 'CA', '94560', '37.5147', '-122.0423');
INSERT INTO `net_city` VALUES ('2697', '23', 'Темпл', 'Temple', 'TX', '76502', '31.1064', '-97.4071');
INSERT INTO `net_city` VALUES ('2698', '23', 'Робинсон', 'Robinson', 'IL', '62454', '38.9887', '-87.7452');
INSERT INTO `net_city` VALUES ('2699', '23', 'Карлайл', 'Carlyle', 'IL', '62231', '38.6147', '-89.3238');
INSERT INTO `net_city` VALUES ('2700', '23', 'Редвуд Сити', 'Redwood City', 'CA', '94063', '37.4914', '-122.2110');
INSERT INTO `net_city` VALUES ('2701', '23', 'Терре-Хот', 'Terre Haute', 'IN', '47802', '39.3579', '-87.4245');
INSERT INTO `net_city` VALUES ('2702', '23', 'Карбондейл', 'Carbondale', 'IL', '62901', '37.7327', '-89.2034');
INSERT INTO `net_city` VALUES ('2706', '23', 'Шелбивилл', 'Shelbyville', 'IN', '46176', '39.5239', '-85.7853');
INSERT INTO `net_city` VALUES ('2708', '23', 'Лос Альтос', 'Los Altos', 'CA', '94022', '37.3622', '-122.1400');
INSERT INTO `net_city` VALUES ('2710', '23', 'Де Пер', 'De Pere', 'WI', '54115', '44.3906', '-88.0310');
INSERT INTO `net_city` VALUES ('2711', '23', 'Бейлис Харбор', 'Baileys Harbor', 'WI', '54202', '45.0855', '-87.1413');
INSERT INTO `net_city` VALUES ('2718', '23', 'Нью-Хейвен', 'New Haven', 'CT', '06511', '41.3094', '-72.9240');
INSERT INTO `net_city` VALUES ('2721', '23', 'Стерлингтон', 'Sterlington', 'LA', '71280', '32.7245', '-92.1215');
INSERT INTO `net_city` VALUES ('2724', '23', 'Сан Карлос', 'San Carlos', 'CA', '94070', '37.4980', '-122.2672');
INSERT INTO `net_city` VALUES ('2725', '23', 'Норт Хейвен', 'North Haven', 'CT', '06473', '41.3834', '-72.8626');
INSERT INTO `net_city` VALUES ('2726', '23', 'Милбро', 'Millbrae', 'CA', '94030', '37.5981', '-122.4025');
INSERT INTO `net_city` VALUES ('2730', '23', 'Чилокин', 'Chiloquin', 'OR', '97624', '42.7267', '-121.7964');
INSERT INTO `net_city` VALUES ('2732', '23', 'Юнион Сити', 'Union City', 'CA', '94587', '37.5963', '-122.0657');
INSERT INTO `net_city` VALUES ('2733', '23', 'Аллендейл', 'Allendale', 'MO', '64420', '40.4856', '-94.2886');
INSERT INTO `net_city` VALUES ('2736', '23', 'Юджин', 'Eugene', 'OR', '97401', '44.0690', '-123.0825');
INSERT INTO `net_city` VALUES ('2740', '23', 'Коннерсвилл', 'Connersville', 'IN', '47331', '39.6539', '-85.1518');
INSERT INTO `net_city` VALUES ('2743', '23', 'Ашленд', 'Ashland', 'VA', '23005', '37.7563', '-77.4888');
INSERT INTO `net_city` VALUES ('2746', '23', 'Серджант Блафф', 'Sergeant Bluff', 'IA', '51054', '42.3728', '-96.2770');
INSERT INTO `net_city` VALUES ('2748', '23', 'Моргантон', 'Morganton', 'NC', '28655', '35.7612', '-81.7280');
INSERT INTO `net_city` VALUES ('2755', '23', 'Уилметт', 'Wilmette', 'IL', '60091', '42.0772', '-87.7286');
INSERT INTO `net_city` VALUES ('2756', '23', 'Сиу-Сити', 'Sioux City', 'IA', '51106', '42.4632', '-96.3220');
INSERT INTO `net_city` VALUES ('2757', '23', 'Каунсил-Блафс', 'Council Bluffs', 'IA', '51501', '41.2324', '-95.8762');
INSERT INTO `net_city` VALUES ('2759', '23', 'Саутавен', 'Southaven', 'MS', '38671', '34.9489', '-89.9665');
INSERT INTO `net_city` VALUES ('2760', '23', 'Луисвилл', 'Louisville', 'CO', '80027', '39.9558', '-105.1683');
INSERT INTO `net_city` VALUES ('2766', '23', 'Блэр', 'Blair', 'NE', '68008', '41.5380', '-96.1944');
INSERT INTO `net_city` VALUES ('2767', '23', 'Спенсер', 'Spencer', 'IA', '51301', '43.1474', '-95.1425');
INSERT INTO `net_city` VALUES ('2768', '23', 'Блумингтон', 'Bloomington', 'IN', '47403', '39.0790', '-86.6175');
INSERT INTO `net_city` VALUES ('2770', '23', 'Хартленд', 'Hartland', 'WI', '53029', '43.1311', '-88.3359');
INSERT INTO `net_city` VALUES ('2771', '23', 'Денисон', 'Denison', 'IA', '51442', '42.0230', '-95.3634');
INSERT INTO `net_city` VALUES ('2772', '23', 'Ньюпорт', 'Newport', 'OR', '97365', '44.6675', '-124.0155');
INSERT INTO `net_city` VALUES ('2773', '23', 'Кламат Фолс', 'Klamath Falls', 'OR', '97603', '42.1851', '-121.6141');
INSERT INTO `net_city` VALUES ('2776', '23', 'Линтон', 'Linton', 'IN', '47441', '39.0396', '-87.1565');
INSERT INTO `net_city` VALUES ('2777', '23', 'Мохаве Валли', 'Mohave Valley', 'AZ', '86440', '34.8615', '-114.5193');
INSERT INTO `net_city` VALUES ('2778', '23', 'Мейвилл', 'Mayville', 'WI', '53050', '43.4943', '-88.5473');
INSERT INTO `net_city` VALUES ('2786', '23', 'Уиснер', 'Wisner', 'NE', '68791', '41.9849', '-96.8939');
INSERT INTO `net_city` VALUES ('2787', '23', 'Такер', 'Tucker', 'GA', '30084', '33.8560', '-84.2129');
INSERT INTO `net_city` VALUES ('2788', '23', 'Вашингтон', 'Washington', 'GA', '30673', '33.7319', '-82.7083');
INSERT INTO `net_city` VALUES ('2791', '23', 'Чаудрант', 'Choudrant', 'LA', '71227', '32.5584', '-92.4838');
INSERT INTO `net_city` VALUES ('2792', '23', 'Демополис', 'Demopolis', 'AL', '36732', '32.4150', '-87.9151');
INSERT INTO `net_city` VALUES ('2794', '23', 'Хантсвилл', 'Huntsville', 'AL', '35806', '34.7528', '-86.6901');
INSERT INTO `net_city` VALUES ('2796', '23', 'Буффало Гров', 'Buffalo Grove', 'IL', '60089', '42.1695', '-87.9588');
INSERT INTO `net_city` VALUES ('2797', '23', 'Андальюзия', 'Andalusia', 'AL', '36420', '31.2487', '-86.5897');
INSERT INTO `net_city` VALUES ('2798', '23', 'Филадельфия', 'Philadelphia', 'MS', '39350', '32.8056', '-89.1073');
INSERT INTO `net_city` VALUES ('2799', '23', 'Бессемер', 'Bessemer', 'AL', '35020', '33.4023', '-86.9390');
INSERT INTO `net_city` VALUES ('2800', '23', 'Меридиан', 'Meridian', 'MS', '39301', '32.2883', '-88.5880');
INSERT INTO `net_city` VALUES ('2801', '23', 'Пелхэм', 'Pelham', 'AL', '35124', '33.3151', '-86.7560');
INSERT INTO `net_city` VALUES ('2806', '23', 'Декатур', 'Decatur', 'AL', '35601', '34.6065', '-87.0078');
INSERT INTO `net_city` VALUES ('2810', '23', 'Корваллис', 'Corvallis', 'OR', '97333', '44.4698', '-123.3430');
INSERT INTO `net_city` VALUES ('2811', '23', 'Хазелвуд', 'Hazelwood', 'MO', '63042', '38.7890', '-90.3829');
INSERT INTO `net_city` VALUES ('2814', '23', 'Ист Пеория', 'East Peoria', 'IL', '61611', '40.7225', '-89.5303');
INSERT INTO `net_city` VALUES ('2815', '23', 'Ливингстон', 'Livingston', 'TX', '77351', '30.7247', '-94.8230');
INSERT INTO `net_city` VALUES ('2816', '23', 'Конли', 'Conley', 'GA', '30288', '33.6520', '-84.3201');
INSERT INTO `net_city` VALUES ('2818', '23', 'Биг Скай', 'Big Sky', 'MT', '59716', '45.2846', '-111.3683');
INSERT INTO `net_city` VALUES ('2821', '23', 'Дандридж', 'Dandridge', 'TN', '37725', '36.0291', '-83.4547');
INSERT INTO `net_city` VALUES ('2827', '23', 'Гринсберг', 'Greensburg', 'PA', '15601', '40.3356', '-79.5507');
INSERT INTO `net_city` VALUES ('2831', '23', 'Брадентон', 'Bradenton', 'FL', '34202', '27.4138', '-82.3698');
INSERT INTO `net_city` VALUES ('2832', '23', 'Янгстаун', 'Youngstown', 'OH', '44503', '41.1002', '-80.6469');
INSERT INTO `net_city` VALUES ('2833', '23', 'Морроу', 'Morrow', 'GA', '30260', '33.5855', '-84.3279');
INSERT INTO `net_city` VALUES ('2834', '23', 'Айкен', 'Aiken', 'SC', '29801', '33.5982', '-81.6712');
INSERT INTO `net_city` VALUES ('2835', '23', 'Стимбот Спрингс', 'Steamboat Springs', 'CO', '80477', '40.4850', '-106.8317');
INSERT INTO `net_city` VALUES ('2836', '23', 'Вирджиния-Бич', 'Virginia Beach', 'VA', '23464', '36.7968', '-76.1767');
INSERT INTO `net_city` VALUES ('2839', '23', 'Батлер', 'Butler', 'PA', '16001', '40.9140', '-79.9320');
INSERT INTO `net_city` VALUES ('2844', '23', 'Гилкрист', 'Gilchrist', 'OR', '97737', '43.5191', '-121.6481');
INSERT INTO `net_city` VALUES ('2846', '23', 'Ванкувер', 'Vancouver', 'WA', '98683', '45.6023', '-122.5167');
INSERT INTO `net_city` VALUES ('2848', '23', 'Томасвилл', 'Thomasville', 'GA', '31757', '30.8563', '-83.8977');
INSERT INTO `net_city` VALUES ('2849', '23', 'Мэйкон', 'Macon', 'GA', '31217', '32.8293', '-83.4928');
INSERT INTO `net_city` VALUES ('2850', '23', 'Декстер', 'Dexter', 'MO', '63841', '36.7808', '-89.9999');
INSERT INTO `net_city` VALUES ('2852', '23', 'Маунт-Вернон', 'Mount Vernon', 'OH', '43050', '40.3814', '-82.4993');
INSERT INTO `net_city` VALUES ('2855', '23', 'Блафтон', 'Bluffton', 'SC', '29910', '32.2528', '-80.8895');
INSERT INTO `net_city` VALUES ('2856', '23', 'Дриппинг Спрингс', 'Dripping Springs', 'TX', '78620', '30.2257', '-98.1268');
INSERT INTO `net_city` VALUES ('2857', '23', 'Уэст Сейлем', 'West Salem', 'IL', '62476', '38.5300', '-88.0056');
INSERT INTO `net_city` VALUES ('2860', '23', 'Клакамас', 'Clackamas', 'OR', '97015', '45.4133', '-122.4992');
INSERT INTO `net_city` VALUES ('2863', '23', 'Орегон Сити', 'Oregon City', 'OR', '97045', '45.3218', '-122.5231');
INSERT INTO `net_city` VALUES ('2864', '23', 'Уошугал', 'Washougal', 'WA', '98671', '45.6173', '-122.2360');
INSERT INTO `net_city` VALUES ('2867', '23', 'Инглвуд', 'Englewood', 'NJ', '07631', '40.8895', '-73.9718');
INSERT INTO `net_city` VALUES ('2871', '23', 'Джанкшен Сити', 'Junction City', 'OR', '97448', '44.2119', '-123.2850');
INSERT INTO `net_city` VALUES ('2872', '23', 'Уилсонвилл', 'Wilsonville', 'OR', '97070', '45.3084', '-122.7799');
INSERT INTO `net_city` VALUES ('2875', '23', 'Редмонд', 'Redmond', 'OR', '97756', '44.2628', '-121.2268');
INSERT INTO `net_city` VALUES ('2881', '23', 'Лейкхед', 'Lakehead', 'CA', '96051', '40.8892', '-122.3861');
INSERT INTO `net_city` VALUES ('2882', '23', 'Уинтер Парк', 'Winter Park', 'FL', '32792', '28.6079', '-81.3055');
INSERT INTO `net_city` VALUES ('2883', '23', 'Киссимми', 'Kissimmee', 'FL', '34746', '28.2423', '-81.4456');
INSERT INTO `net_city` VALUES ('2884', '23', 'Фицджералд', 'Fitzgerald', 'GA', '31750', '31.7198', '-83.2132');
INSERT INTO `net_city` VALUES ('2885', '23', 'Хагерстаун', 'Hagerstown', 'MD', '21740', '39.6291', '-77.7128');
INSERT INTO `net_city` VALUES ('2886', '23', 'Рипли', 'Ripley', 'WV', '25271', '38.7869', '-81.6817');
INSERT INTO `net_city` VALUES ('2887', '23', 'Терлок', 'Turlock', 'CA', '95382', '37.5372', '-120.8487');
INSERT INTO `net_city` VALUES ('2888', '23', 'Куинси', 'Quincy', 'IL', '62301', '39.9315', '-91.3840');
INSERT INTO `net_city` VALUES ('2889', '23', 'Лейк Мэри', 'Lake Mary', 'FL', '32746', '28.7578', '-81.3397');
INSERT INTO `net_city` VALUES ('2891', '23', 'Окала', 'Ocala', 'FL', '34481', '29.1178', '-82.3122');
INSERT INTO `net_city` VALUES ('2892', '23', 'Мельбурн', 'Melbourne', 'FL', '32904', '28.0782', '-80.7534');
INSERT INTO `net_city` VALUES ('2893', '23', 'Хилсборо', 'Hillsboro', 'OR', '97124', '45.5848', '-122.9117');
INSERT INTO `net_city` VALUES ('2894', '23', 'Калама', 'Kalama', 'WA', '98625', '46.0133', '-122.7080');
INSERT INTO `net_city` VALUES ('2896', '23', 'Грешам', 'Gresham', 'OR', '97030', '45.5076', '-122.4307');
INSERT INTO `net_city` VALUES ('2900', '23', 'Хайалиа', 'Hialeah', 'FL', '33015', '25.9372', '-80.3170');
INSERT INTO `net_city` VALUES ('2901', '23', 'Веро Бич', 'Vero Beach', 'FL', '32963', '27.7085', '-80.3890');
INSERT INTO `net_city` VALUES ('2906', '23', 'Сили', 'Sealy', 'TX', '77474', '29.7784', '-96.1817');
INSERT INTO `net_city` VALUES ('2908', '23', 'Норт Форт Майерс', 'North Fort Myers', 'FL', '33917', '26.7144', '-81.8434');
INSERT INTO `net_city` VALUES ('2909', '23', 'Парсипани', 'Parsippany', 'NJ', '07054', '40.8597', '-74.4026');
INSERT INTO `net_city` VALUES ('2912', '23', 'Шерц', 'Schertz', 'TX', '78154', '29.5892', '-98.2939');
INSERT INTO `net_city` VALUES ('2913', '23', 'Норт Палм Бич', 'North Palm Beach', 'FL', '33408', '26.8542', '-80.0547');
INSERT INTO `net_city` VALUES ('2915', '23', 'Нейплс', 'Naples', 'FL', '34109', '26.2385', '-81.7641');
INSERT INTO `net_city` VALUES ('2916', '23', 'Рочестер', 'Rochester', 'MN', '55902', '43.9621', '-92.5218');
INSERT INTO `net_city` VALUES ('2918', '23', 'Коламбус', 'Columbus', 'GA', '31901', '32.4647', '-84.9884');
INSERT INTO `net_city` VALUES ('2924', '23', 'Полк Сити', 'Polk City', 'FL', '33868', '28.2321', '-81.8115');
INSERT INTO `net_city` VALUES ('2926', '23', 'Дилли', 'Dilley', 'TX', '78017', '28.7416', '-99.2253');
INSERT INTO `net_city` VALUES ('2928', '23', 'Пунта Горда', 'Punta Gorda', 'FL', '33982', '26.9023', '-81.7894');
INSERT INTO `net_city` VALUES ('2930', '23', 'Оберндейл', 'Auburndale', 'FL', '33823', '28.0795', '-81.8037');
INSERT INTO `net_city` VALUES ('2932', '23', 'Лейк Уэльс', 'Lake Wales', 'FL', '33853', '27.8934', '-81.5825');
INSERT INTO `net_city` VALUES ('2935', '23', 'Менденхолл', 'Mendenhall', 'MS', '39114', '31.9373', '-89.8174');
INSERT INTO `net_city` VALUES ('2937', '23', 'Доналдсонвилл', 'Donaldsonville', 'LA', '70346', '30.1361', '-91.0544');
INSERT INTO `net_city` VALUES ('2938', '23', 'Хаммонд', 'Hammond', 'LA', '70401', '30.5315', '-90.4628');
INSERT INTO `net_city` VALUES ('2940', '23', 'Лафайетт', 'Lafayette', 'LA', '70508', '30.1605', '-92.0332');
INSERT INTO `net_city` VALUES ('2942', '23', 'Саут Падре Айленд', 'South Padre Island', 'TX', '78597', '26.2394', '-97.1853');
INSERT INTO `net_city` VALUES ('2944', '23', 'Харви', 'Harvey', 'LA', '70058', '29.8485', '-90.0633');
INSERT INTO `net_city` VALUES ('2947', '23', 'Каламазу', 'Kalamazoo', 'MI', '49004', '42.3541', '-85.5470');
INSERT INTO `net_city` VALUES ('2949', '23', 'Энсинал', 'Encinal', 'TX', '78019', '28.0305', '-99.4187');
INSERT INTO `net_city` VALUES ('2950', '23', 'Лорел', 'Laurel', 'MS', '39440', '31.6909', '-89.1445');
INSERT INTO `net_city` VALUES ('2953', '23', 'Уилламина', 'Willamina', 'OR', '97396', '45.1388', '-123.5121');
INSERT INTO `net_city` VALUES ('2954', '23', 'Нисевилл', 'Niceville', 'FL', '32578', '30.5143', '-86.4630');
INSERT INTO `net_city` VALUES ('2956', '23', 'Виктория', 'Victoria', 'TX', '77905', '28.7466', '-97.0165');
INSERT INTO `net_city` VALUES ('2957', '23', 'Пенсакола', 'Pensacola', 'FL', '32503', '30.4621', '-87.2174');
INSERT INTO `net_city` VALUES ('2961', '23', 'Риджленд', 'Ridgeland', 'MS', '39157', '32.4326', '-90.1556');
INSERT INTO `net_city` VALUES ('2963', '23', 'Нью Иберия', 'New Iberia', 'LA', '70560', '29.9579', '-91.8721');
INSERT INTO `net_city` VALUES ('2964', '23', 'Сибрук', 'Seabrook', 'TX', '77586', '29.5813', '-95.0273');
INSERT INTO `net_city` VALUES ('2965', '23', 'Милсборо', 'Millsboro', 'DE', '19966', '38.5608', '-75.3351');
INSERT INTO `net_city` VALUES ('2966', '23', 'Тревос', 'Trevose', 'PA', '19006', '40.1287', '-75.0597');
INSERT INTO `net_city` VALUES ('2968', '23', 'Уэствилл', 'Westville', 'IL', '61883', '40.0466', '-87.6356');
INSERT INTO `net_city` VALUES ('2969', '23', 'Квинстаун', 'Queenstown', 'MD', '21658', '38.9399', '-76.1332');
INSERT INTO `net_city` VALUES ('2971', '23', 'Делмар', 'Delmar', 'DE', '19940', '38.4864', '-75.5439');
INSERT INTO `net_city` VALUES ('2973', '23', 'Мидлтаун', 'Middletown', 'DE', '19709', '39.4757', '-75.6724');
INSERT INTO `net_city` VALUES ('2975', '23', 'Савидж', 'Savage', 'MD', '20763', '39.1356', '-76.8276');
INSERT INTO `net_city` VALUES ('2976', '23', 'Боулинг Грин', 'Bowling Green', 'KY', '42101', '37.0941', '-86.4286');
INSERT INTO `net_city` VALUES ('2977', '23', 'Лангхорн', 'Langhorne', 'PA', '19047', '40.1804', '-74.8930');
INSERT INTO `net_city` VALUES ('2987', '23', 'Алтамонте Спрингс', 'Altamonte Springs', 'FL', '32714', '28.6653', '-81.4188');
INSERT INTO `net_city` VALUES ('2988', '23', 'Галвестон', 'Galveston', 'TX', '77550', '29.3066', '-94.7723');
INSERT INTO `net_city` VALUES ('2989', '23', 'Уэр', 'Weare', 'NH', '03281', '43.0833', '-71.7223');
INSERT INTO `net_city` VALUES ('2990', '23', 'Паркерсберг', 'Parkersburg', 'WV', '26101', '39.2430', '-81.5772');
INSERT INTO `net_city` VALUES ('2991', '23', 'Бентон Ридж', 'Benton Ridge', 'OH', '45816', '41.0048', '-83.7941');
INSERT INTO `net_city` VALUES ('2992', '23', 'Уэверли', 'Waverly', 'OH', '45690', '39.1527', '-83.0391');
INSERT INTO `net_city` VALUES ('2995', '23', 'Хиллиард', 'Hilliard', 'OH', '43026', '40.0231', '-83.1810');
INSERT INTO `net_city` VALUES ('2996', '23', 'Альва', 'Alva', 'FL', '33920', '26.7416', '-81.6363');
INSERT INTO `net_city` VALUES ('3002', '23', 'Акрон', 'Akron', 'OH', '44333', '41.1537', '-81.6374');
INSERT INTO `net_city` VALUES ('3010', '23', 'Ричмонд', 'Richmond', 'CA', '94804', '37.9255', '-122.3437');
INSERT INTO `net_city` VALUES ('3011', '23', 'Фишерс', 'Fishers', 'IN', '46038', '39.9610', '-85.9837');
INSERT INTO `net_city` VALUES ('3012', '23', 'Грейсон', 'Grayson', 'KY', '41143', '38.3364', '-82.9924');
INSERT INTO `net_city` VALUES ('3016', '23', 'Галлахер', 'Gallagher', 'WV', '25083', '38.0747', '-81.3757');
INSERT INTO `net_city` VALUES ('3019', '23', 'Гров Сити', 'Grove City', 'OH', '43123', '39.8639', '-83.1201');
INSERT INTO `net_city` VALUES ('3020', '23', 'Стоу', 'Stow', 'OH', '44224', '41.1741', '-81.4389');
INSERT INTO `net_city` VALUES ('3023', '23', 'Хамбл', 'Humble', 'TX', '77338', '30.0041', '-95.2984');
INSERT INTO `net_city` VALUES ('3024', '23', 'Техас Сити', 'Texas City', 'TX', '77591', '29.4009', '-95.0005');
INSERT INTO `net_city` VALUES ('3029', '23', 'Окленд', 'Oakland', 'CA', '94621', '37.7350', '-122.2088');
INSERT INTO `net_city` VALUES ('3032', '23', 'Ксения', 'Xenia', 'OH', '45385', '39.6780', '-83.9027');
INSERT INTO `net_city` VALUES ('3033', '23', 'Бекли', 'Beckley', 'WV', '25801', '37.8164', '-81.2329');
INSERT INTO `net_city` VALUES ('3034', '23', 'Канал Уинчестер', 'Canal Winchester', 'OH', '43110', '39.8251', '-82.7958');
INSERT INTO `net_city` VALUES ('3037', '23', 'Рейнолдсберг', 'Reynoldsburg', 'OH', '43068', '39.9548', '-82.7693');
INSERT INTO `net_city` VALUES ('3038', '23', 'Лок Хейвен', 'Lock Haven', 'PA', '17745', '41.3252', '-77.4584');
INSERT INTO `net_city` VALUES ('3039', '23', 'Пайктон', 'Piketon', 'OH', '45661', '39.0485', '-83.1662');
INSERT INTO `net_city` VALUES ('3040', '23', 'Аннаполис Джанкшен', 'Annapolis Junction', 'MD', '20701', '39.1293', '-76.7671');
INSERT INTO `net_city` VALUES ('3043', '23', 'Стаффорд', 'Stafford', 'TX', '77477', '29.6283', '-95.5624');
INSERT INTO `net_city` VALUES ('3045', '23', 'Кливленд', 'Cleveland', 'TX', '77327', '30.3221', '-94.9493');
INSERT INTO `net_city` VALUES ('3046', '23', 'Олбани', 'Albany', 'OR', '97321', '44.6251', '-123.1309');
INSERT INTO `net_city` VALUES ('3048', '23', 'Лортон', 'Lorton', 'VA', '22079', '38.6911', '-77.2060');
INSERT INTO `net_city` VALUES ('3051', '23', 'Киндом Сити', 'Kingdom City', 'MO', '65262', '38.9616', '-91.9341');
INSERT INTO `net_city` VALUES ('3052', '23', 'Чантилли', 'Chantilly', 'VA', '20151', '38.9036', '-77.4512');
INSERT INTO `net_city` VALUES ('3053', '23', 'Кэмп Спрингс', 'Camp Springs', 'MD', '20744', '38.7551', '-76.9805');
INSERT INTO `net_city` VALUES ('3054', '23', 'Вудбридж', 'Woodbridge', 'VA', '22193', '38.6419', '-77.3463');
INSERT INTO `net_city` VALUES ('3055', '23', 'Леонардтаун', 'Leonardtown', 'MD', '20650', '38.2764', '-76.6241');
INSERT INTO `net_city` VALUES ('3060', '23', 'Комптон', 'Compton', 'CA', '90220', '33.8748', '-118.2406');
INSERT INTO `net_city` VALUES ('3064', '23', 'Оберн', 'Auburn', 'MA', '01501', '42.1955', '-71.8463');
INSERT INTO `net_city` VALUES ('3066', '23', 'Аккокик', 'Accokeek', 'MD', '20607', '38.6591', '-77.0367');
INSERT INTO `net_city` VALUES ('3069', '23', 'Чиппева Фолс', 'Chippewa Falls', 'WI', '54729', '44.9617', '-91.4403');
INSERT INTO `net_city` VALUES ('3072', '23', 'Потомак', 'Potomac', 'MD', '20854', '39.0274', '-77.2365');
INSERT INTO `net_city` VALUES ('3073', '23', 'Уолдорф', 'Waldorf', 'MD', '20601', '38.6252', '-76.8780');
INSERT INTO `net_city` VALUES ('3075', '23', 'Брукфилд', 'Brookfield', 'WI', '53005', '43.0606', '-88.0981');
INSERT INTO `net_city` VALUES ('3077', '23', 'Бонита Спрингс', 'Bonita Springs', 'FL', '34134', '26.3633', '-81.8336');
INSERT INTO `net_city` VALUES ('3081', '23', 'Меканиксвилл', 'Mechanicsville', 'VA', '23116', '37.6788', '-77.3265');
INSERT INTO `net_city` VALUES ('3082', '23', 'Эдинберг', 'Edinburg', 'VA', '22824', '38.8439', '-78.6354');
INSERT INTO `net_city` VALUES ('3085', '23', 'Клинтон', 'Clinton', 'MD', '20735', '38.7395', '-76.9118');
INSERT INTO `net_city` VALUES ('3086', '23', 'Миффлайнтаун', 'Mifflintown', 'PA', '17059', '40.5965', '-77.3573');
INSERT INTO `net_city` VALUES ('3089', '23', 'Хопдейл', 'Hopedale', 'IL', '61747', '40.4280', '-89.4353');
INSERT INTO `net_city` VALUES ('3091', '23', 'Уили', 'Wylie', 'TX', '75098', '33.0162', '-96.5382');
INSERT INTO `net_city` VALUES ('3092', '23', 'Смитфилд', 'Smithfield', 'RI', '02917', '41.9040', '-71.5266');
INSERT INTO `net_city` VALUES ('3095', '23', 'Нью Виндзор', 'New Windsor', 'NY', '12553', '41.4468', '-74.0689');
INSERT INTO `net_city` VALUES ('3097', '23', 'Тарритаун', 'Tarrytown', 'NY', '10591', '41.0837', '-73.8397');
INSERT INTO `net_city` VALUES ('3098', '23', 'Рай', 'Rye', 'NY', '10580', '40.9777', '-73.6935');
INSERT INTO `net_city` VALUES ('3099', '23', 'Уайт Плейнс', 'White Plains', 'NY', '10601', '41.0291', '-73.7580');
INSERT INTO `net_city` VALUES ('3100', '23', 'Гаррисон', 'Harrison', 'NY', '10528', '40.9795', '-73.7231');
INSERT INTO `net_city` VALUES ('3101', '23', 'Пикскилл', 'Peekskill', 'NY', '10566', '41.2879', '-73.9170');
INSERT INTO `net_city` VALUES ('3102', '23', 'Кингстон', 'Kingston', 'NY', '12401', '41.9389', '-73.9901');
INSERT INTO `net_city` VALUES ('3104', '23', 'Нью Рошелл', 'New Rochelle', 'NY', '10805', '40.8989', '-73.7814');
INSERT INTO `net_city` VALUES ('3105', '23', 'Брустер', 'Brewster', 'NY', '10509', '41.4172', '-73.5971');
INSERT INTO `net_city` VALUES ('3106', '23', 'Ньюбург', 'Newburgh', 'NY', '12550', '41.5375', '-74.0512');
INSERT INTO `net_city` VALUES ('3108', '23', 'Бейкерсвилл', 'Bakersville', 'NC', '28705', '36.0403', '-82.1599');
INSERT INTO `net_city` VALUES ('3113', '23', 'Колледж Стейшен', 'College Station', 'TX', '77840', '30.6131', '-96.3217');
INSERT INTO `net_city` VALUES ('3115', '23', 'Брентвуд', 'Brentwood', 'NY', '11717', '40.7810', '-73.2522');
INSERT INTO `net_city` VALUES ('3116', '23', 'Хаапподж', 'Hauppauge', 'NY', '11788', '40.8191', '-73.2102');
INSERT INTO `net_city` VALUES ('3117', '23', 'Нанует', 'Nanuet', 'NY', '10954', '41.0965', '-74.0093');
INSERT INTO `net_city` VALUES ('3119', '23', 'Брайрклифф Манор', 'Briarcliff Manor', 'NY', '10510', '41.1468', '-73.8318');
INSERT INTO `net_city` VALUES ('3120', '23', 'Вудбери', 'Woodbury', 'NY', '11797', '40.8181', '-73.4721');
INSERT INTO `net_city` VALUES ('3121', '23', 'Кротон-он-Гудзон', 'Croton-on-Hudson', 'NY', '10562', '41.1879', '-73.8315');
INSERT INTO `net_city` VALUES ('3122', '23', 'Мелвилл', 'Melville', 'NY', '11747', '40.7850', '-73.4062');
INSERT INTO `net_city` VALUES ('3124', '23', 'Сэддл Ривер', 'Saddle River', 'NJ', '07458', '41.0457', '-74.0981');
INSERT INTO `net_city` VALUES ('3126', '23', 'Уэйн', 'Wayne', 'NJ', '07470', '40.9487', '-74.2413');
INSERT INTO `net_city` VALUES ('3127', '23', 'Карлстадт', 'Carlstadt', 'NJ', '07072', '40.8290', '-74.0672');
INSERT INTO `net_city` VALUES ('3130', '23', 'Махва', 'Mahwah', 'NJ', '07430', '41.0780', '-74.1764');
INSERT INTO `net_city` VALUES ('3132', '23', 'Тотова', 'Totowa', 'NJ', '07512', '40.9037', '-74.2247');
INSERT INTO `net_city` VALUES ('3134', '23', 'Хакенсак', 'Hackensack', 'NJ', '07601', '40.8859', '-74.0468');
INSERT INTO `net_city` VALUES ('3135', '23', 'Лейквуд', 'Lakewood', 'NJ', '08701', '40.0721', '-74.2069');
INSERT INTO `net_city` VALUES ('3143', '23', 'Биб', 'Beebe', 'AR', '72012', '35.1144', '-91.9067');
INSERT INTO `net_city` VALUES ('3145', '23', 'Статгарт', 'Stuttgart', 'AR', '72160', '34.4396', '-91.5298');
INSERT INTO `net_city` VALUES ('3146', '23', 'Коллинстон', 'Collinston', 'LA', '71229', '32.6256', '-91.8922');
INSERT INTO `net_city` VALUES ('3147', '23', 'Оуэнсборо', 'Owensboro', 'KY', '42303', '37.7555', '-87.0434');
INSERT INTO `net_city` VALUES ('3148', '23', 'Аркадельфия', 'Arkadelphia', 'AR', '71923', '34.0268', '-93.0644');
INSERT INTO `net_city` VALUES ('3155', '23', 'Скотсберг', 'Scottsburg', 'IN', '47170', '38.6911', '-85.8545');
INSERT INTO `net_city` VALUES ('3156', '23', 'Чаннелвью', 'Channelview', 'TX', '77530', '29.7908', '-95.1091');
INSERT INTO `net_city` VALUES ('3157', '23', 'Нью Бостон', 'New Boston', 'TX', '75570', '33.4593', '-94.4301');
INSERT INTO `net_city` VALUES ('3159', '23', 'Севьервилл', 'Sevierville', 'TN', '37862', '35.7502', '-83.6296');
INSERT INTO `net_city` VALUES ('3160', '23', 'Монро', 'Monroe', 'LA', '71201', '32.5206', '-92.1066');
INSERT INTO `net_city` VALUES ('3161', '23', 'Уэст Монро', 'West Monroe', 'LA', '71292', '32.3938', '-92.2329');
INSERT INTO `net_city` VALUES ('3162', '23', 'Кэмден', 'Camden', 'AR', '71701', '33.6114', '-92.8452');
INSERT INTO `net_city` VALUES ('3163', '23', 'Фармервилл', 'Farmerville', 'LA', '71241', '32.7738', '-92.3409');
INSERT INTO `net_city` VALUES ('3165', '23', 'Секокус', 'Secaucus', 'NJ', '07094', '40.7801', '-74.0633');
INSERT INTO `net_city` VALUES ('3167', '23', 'Берлингтон', 'Burlington', 'WI', '53105', '42.6496', '-88.2985');
INSERT INTO `net_city` VALUES ('3168', '23', 'Чарльз Таун', 'Charles Town', 'WV', '25414', '39.2581', '-77.8705');
INSERT INTO `net_city` VALUES ('3169', '23', 'Чероки', 'Cherokee', 'AL', '35616', '34.7393', '-87.9930');
INSERT INTO `net_city` VALUES ('3171', '23', 'Меркел', 'Merkel', 'TX', '79536', '32.4546', '-100.0233');
INSERT INTO `net_city` VALUES ('3172', '23', 'Кошатта', 'Coushatta', 'LA', '71019', '32.0602', '-93.2691');
INSERT INTO `net_city` VALUES ('3174', '23', 'Калверт Сити', 'Calvert City', 'KY', '42029', '37.0034', '-88.3845');
INSERT INTO `net_city` VALUES ('3176', '23', 'Пасадена', 'Pasadena', 'TX', '77503', '29.7056', '-95.1559');
INSERT INTO `net_city` VALUES ('3177', '23', 'Стар Сити', 'Star City', 'AR', '71667', '33.9432', '-91.8322');
INSERT INTO `net_city` VALUES ('3180', '23', 'Галфпорт', 'Gulfport', 'MS', '39503', '30.4730', '-89.1494');
INSERT INTO `net_city` VALUES ('3182', '23', 'Лиг Сити', 'League City', 'TX', '77573', '29.5075', '-95.0895');
INSERT INTO `net_city` VALUES ('3184', '23', 'Мидленд', 'Midland', 'TX', '79711', '31.9974', '-102.0779');
INSERT INTO `net_city` VALUES ('3185', '23', 'Нью Кастл', 'New Castle', 'DE', '19720', '39.6387', '-75.6195');
INSERT INTO `net_city` VALUES ('3190', '23', 'Кевауни', 'Kewaunee', 'WI', '54216', '44.4368', '-87.5880');
INSERT INTO `net_city` VALUES ('3192', '23', 'Элктон', 'Elkton', 'VA', '22827', '38.3929', '-78.6181');
INSERT INTO `net_city` VALUES ('3195', '23', 'Фолс Черч', 'Falls Church', 'VA', '22041', '38.8472', '-77.1425');
INSERT INTO `net_city` VALUES ('3200', '23', 'Уинтерхейвен', 'Winterhaven', 'CA', '92283', '32.8701', '-114.7223');
INSERT INTO `net_city` VALUES ('3203', '23', 'Юинг', 'Ewing', 'PA', '18977', '40.2855', '-74.8789');
INSERT INTO `net_city` VALUES ('3204', '23', 'Риверсайд', 'Riverside', 'CA', '92501', '33.9936', '-117.3832');
INSERT INTO `net_city` VALUES ('3206', '23', 'Сентервилл', 'Centreville', 'VA', '20120', '38.8557', '-77.4697');
INSERT INTO `net_city` VALUES ('3209', '23', 'Гринсборо', 'Greensboro', 'GA', '30642', '33.5717', '-83.1765');
INSERT INTO `net_city` VALUES ('3213', '23', 'Вудфорд', 'Woodford', 'VA', '22580', '38.1184', '-77.4413');
INSERT INTO `net_city` VALUES ('3216', '23', 'Манси', 'Muncie', 'IN', '47304', '40.2369', '-85.4679');
INSERT INTO `net_city` VALUES ('3218', '23', 'Кокомо', 'Kokomo', 'IN', '46902', '40.4398', '-86.0893');
INSERT INTO `net_city` VALUES ('3219', '23', 'Сеймур', 'Seymour', 'IN', '47274', '38.9385', '-85.8896');
INSERT INTO `net_city` VALUES ('3220', '23', 'Мартинсберг', 'Martinsburg', 'WV', '25401', '39.4632', '-77.9521');
INSERT INTO `net_city` VALUES ('3221', '23', 'Торо', 'Thoreau', 'NM', '87323', '35.4211', '-108.1970');
INSERT INTO `net_city` VALUES ('3222', '23', 'Кротерсвилл', 'Crothersville', 'IN', '47229', '38.8067', '-85.8732');
INSERT INTO `net_city` VALUES ('3223', '23', 'Урбана', 'Urbana', 'IL', '61802', '40.1202', '-88.1551');
INSERT INTO `net_city` VALUES ('3224', '23', 'Апл Валли', 'Apple Valley', 'CA', '92307', '34.5776', '-117.1592');
INSERT INTO `net_city` VALUES ('3226', '23', 'Кармел', 'Carmel', 'IN', '46032', '39.9738', '-86.1765');
INSERT INTO `net_city` VALUES ('3231', '23', 'Шампейн', 'Champaign', 'IL', '61822', '40.1319', '-88.2952');
INSERT INTO `net_city` VALUES ('3232', '23', 'Уинслоу', 'Winslow', 'IN', '47598', '38.3852', '-87.2156');
INSERT INTO `net_city` VALUES ('3236', '23', 'Паоли', 'Paoli', 'IN', '47454', '38.5131', '-86.4552');
INSERT INTO `net_city` VALUES ('3245', '23', 'Норт Вернон', 'North Vernon', 'IN', '47265', '39.0282', '-85.6304');
INSERT INTO `net_city` VALUES ('3248', '23', 'Данбери', 'Danbury', 'TX', '77534', '29.2294', '-95.3212');
INSERT INTO `net_city` VALUES ('3249', '23', 'Каледония', 'Caledonia', 'WI', '53108', '42.8143', '-87.9423');
INSERT INTO `net_city` VALUES ('3251', '23', 'Мидлотиан', 'Midlothian', 'VA', '23113', '37.5415', '-77.6678');
INSERT INTO `net_city` VALUES ('3252', '23', 'Глен Аллен', 'Glen Allen', 'VA', '23060', '37.6610', '-77.5312');
INSERT INTO `net_city` VALUES ('3253', '23', 'Торранс', 'Torrance', 'CA', '90504', '33.8669', '-118.3312');
INSERT INTO `net_city` VALUES ('3254', '23', 'Франктон', 'Frankton', 'IN', '46044', '40.2132', '-85.7848');
INSERT INTO `net_city` VALUES ('3260', '23', 'Дикинсон', 'Dickinson', 'ND', '58601', '46.9153', '-102.8366');
INSERT INTO `net_city` VALUES ('3261', '23', 'Лафайетт', 'Lafayette', 'IN', '47905', '40.4224', '-86.8031');
INSERT INTO `net_city` VALUES ('3264', '23', 'Хомстед', 'Homestead', 'FL', '33033', '25.4903', '-80.4187');
INSERT INTO `net_city` VALUES ('3266', '23', 'Киндер', 'Kinder', 'LA', '70648', '30.5363', '-92.9054');
INSERT INTO `net_city` VALUES ('3268', '23', 'Монтерей Парк', 'Monterey Park', 'CA', '91754', '34.0514', '-118.1456');
INSERT INTO `net_city` VALUES ('3269', '23', 'Милл Валли', 'Mill Valley', 'CA', '94941', '37.8959', '-122.5663');
INSERT INTO `net_city` VALUES ('3271', '23', 'Саисан Сити', 'Suisun City', 'CA', '94585', '38.1699', '-121.9367');
INSERT INTO `net_city` VALUES ('3272', '23', 'Льюис Сентер', 'Lewis Center', 'OH', '43035', '40.1832', '-82.9954');
INSERT INTO `net_city` VALUES ('3274', '23', 'Беллефонтейн', 'Bellefontaine', 'OH', '43311', '40.3726', '-83.7477');
INSERT INTO `net_city` VALUES ('3275', '23', 'Ла Меса', 'La Mesa', 'CA', '91941', '32.7596', '-116.9940');
INSERT INTO `net_city` VALUES ('3279', '23', 'Эксетер', 'Exeter', 'NH', '03833', '42.9661', '-70.9881');
INSERT INTO `net_city` VALUES ('3281', '23', 'Довер', 'Dover', 'NH', '03820', '43.1871', '-70.9100');
INSERT INTO `net_city` VALUES ('3282', '23', 'Манстер', 'Munster', 'IN', '46321', '41.5505', '-87.5026');
INSERT INTO `net_city` VALUES ('3284', '23', 'Фрамингем', 'Framingham', 'MA', '01701', '42.3233', '-71.4352');
INSERT INTO `net_city` VALUES ('3285', '23', 'Кампо', 'Campo', 'CA', '91906', '32.6866', '-116.4752');
INSERT INTO `net_city` VALUES ('3286', '23', 'Грандвилл', 'Grandville', 'MI', '49418', '42.8828', '-85.7828');
INSERT INTO `net_city` VALUES ('3287', '23', 'Лоди', 'Lodi', 'CA', '95240', '38.1165', '-121.1676');
INSERT INTO `net_city` VALUES ('3288', '23', 'Тексбери', 'Tewksbury', 'MA', '01876', '42.6105', '-71.2306');
INSERT INTO `net_city` VALUES ('3289', '23', 'Рейн', 'Rayne', 'LA', '70578', '30.2161', '-92.2675');
INSERT INTO `net_city` VALUES ('3290', '23', 'Броктон', 'Brockton', 'MA', '02302', '42.0858', '-70.9999');
INSERT INTO `net_city` VALUES ('3291', '23', 'Санта Фе Спрингс', 'Santa Fe Springs', 'CA', '90670', '33.9275', '-118.0657');
INSERT INTO `net_city` VALUES ('3292', '23', 'Матаморас', 'Matamoras', 'PA', '18336', '41.3793', '-74.7381');
INSERT INTO `net_city` VALUES ('3295', '23', 'Саутборо', 'Southborough', 'MA', '01772', '42.2966', '-71.5352');
INSERT INTO `net_city` VALUES ('3300', '23', 'Дестин', 'Destin', 'FL', '32541', '30.3981', '-86.4563');
INSERT INTO `net_city` VALUES ('3303', '23', 'Ром', 'Rome', 'GA', '30165', '34.3067', '-85.2700');
INSERT INTO `net_city` VALUES ('3305', '23', 'Прово', 'Provo', 'UT', '84604', '40.3393', '-111.5709');
INSERT INTO `net_city` VALUES ('3306', '23', 'Орем', 'Orem', 'UT', '84057', '40.3143', '-111.7116');
INSERT INTO `net_city` VALUES ('3307', '23', 'Парамус', 'Paramus', 'NJ', '07652', '40.9445', '-74.0700');
INSERT INTO `net_city` VALUES ('3310', '23', 'Морган', 'Morgan', 'UT', '84050', '41.0105', '-111.6782');
INSERT INTO `net_city` VALUES ('3314', '23', 'Бель Эр', 'Bel Air', 'MD', '21014', '39.5382', '-76.3519');
INSERT INTO `net_city` VALUES ('3318', '23', 'Дентон', 'Denton', 'MD', '21629', '38.8475', '-75.7932');
INSERT INTO `net_city` VALUES ('3319', '23', 'Трейсис Ландинг', 'Tracys Landing', 'MD', '20779', '38.7609', '-76.5764');
INSERT INTO `net_city` VALUES ('3322', '23', 'Вудбайн', 'Woodbine', 'MD', '21797', '39.3390', '-77.0640');
INSERT INTO `net_city` VALUES ('3325', '23', 'Эмеривилл', 'Emeryville', 'CA', '94608', '37.8342', '-122.2897');
INSERT INTO `net_city` VALUES ('3328', '23', 'Таусон', 'Towson', 'MD', '21286', '39.4157', '-76.5718');
INSERT INTO `net_city` VALUES ('3329', '23', 'Кембридж', 'Cambridge', 'MD', '21613', '38.4872', '-76.0867');
INSERT INTO `net_city` VALUES ('3330', '23', 'Роздейл', 'Rosedale', 'MD', '21237', '39.3405', '-76.4962');
INSERT INTO `net_city` VALUES ('3331', '23', 'Оверли', 'Overlea', 'MD', '21236', '39.3892', '-76.4920');
INSERT INTO `net_city` VALUES ('3332', '23', 'Янтвилл', 'Yountville', 'CA', '94599', '38.4120', '-122.3611');
INSERT INTO `net_city` VALUES ('3334', '23', 'Морено Валли', 'Moreno Valley', 'CA', '92553', '33.9224', '-117.2476');
INSERT INTO `net_city` VALUES ('3339', '23', 'Хант Валли', 'Hunt Valley', 'MD', '21031', '39.4878', '-76.6567');
INSERT INTO `net_city` VALUES ('3340', '23', 'Дюнкерк', 'Dunkirk', 'MD', '20754', '38.7363', '-76.6468');
INSERT INTO `net_city` VALUES ('3344', '23', 'Мадисон', 'Madison', 'WI', '53718', '43.1082', '-89.2706');
INSERT INTO `net_city` VALUES ('3348', '23', 'Оуингс Милс', 'Owings Mills', 'MD', '21117', '39.4370', '-76.7818');
INSERT INTO `net_city` VALUES ('3351', '23', 'Джессап', 'Jessup', 'MD', '20794', '39.1441', '-76.7817');
INSERT INTO `net_city` VALUES ('3353', '23', 'Эджуотер', 'Edgewater', 'MD', '21037', '38.9109', '-76.5403');
INSERT INTO `net_city` VALUES ('3354', '23', 'Абердин', 'Aberdeen', 'MD', '21001', '39.4984', '-76.1966');
INSERT INTO `net_city` VALUES ('3355', '23', 'Лагуна Бич', 'Laguna Beach', 'CA', '92651', '33.5558', '-117.7858');
INSERT INTO `net_city` VALUES ('3357', '23', 'Сейнт Энтони', 'Saint Anthony', 'ID', '83445', '43.9864', '-111.7959');
INSERT INTO `net_city` VALUES ('3360', '23', 'Ошен Сити', 'Ocean City', 'MD', '21842', '38.3384', '-75.1249');
INSERT INTO `net_city` VALUES ('3361', '23', 'Сайксвилл', 'Sykesville', 'MD', '21784', '39.3941', '-76.9695');
INSERT INTO `net_city` VALUES ('3364', '23', 'Танитаун', 'Taneytown', 'MD', '21787', '39.6575', '-77.1748');
INSERT INTO `net_city` VALUES ('3367', '23', 'Брирфилд', 'Brierfield', 'AL', '35035', '33.0491', '-86.9788');
INSERT INTO `net_city` VALUES ('3368', '23', 'Джэксонвилл Бич', 'Jacksonville Beach', 'FL', '32250', '30.2801', '-81.4050');
INSERT INTO `net_city` VALUES ('3370', '23', 'Манчестер', 'Manchester', 'CT', '06040', '41.7770', '-72.5236');
INSERT INTO `net_city` VALUES ('3374', '23', 'Литлтон', 'Littleton (New Hamsphire)', 'NH', '03561', '44.3381', '-71.8305');
INSERT INTO `net_city` VALUES ('3379', '23', 'Фичберг', 'Fitchburg', 'MA', '01420', '42.5908', '-71.8055');
INSERT INTO `net_city` VALUES ('3380', '23', 'Гранд Риверс', 'Grand Rivers', 'KY', '42045', '37.0803', '-88.2728');
INSERT INTO `net_city` VALUES ('3383', '23', 'Кларк', 'Clark', 'NJ', '07066', '40.6224', '-74.3124');
INSERT INTO `net_city` VALUES ('3384', '23', 'Уэст Йеллоустон', 'West Yellowstone', 'MT', '59758', '44.6929', '-111.2135');
INSERT INTO `net_city` VALUES ('3385', '23', 'Хелена', 'Helena', 'MT', '59601', '46.5172', '-112.1211');
INSERT INTO `net_city` VALUES ('3389', '23', 'Чаттануга', 'Chattanooga', 'TN', '37406', '35.0671', '-85.2456');
INSERT INTO `net_city` VALUES ('3391', '23', 'Норт Огаста', 'North Augusta', 'SC', '29841', '33.5244', '-81.9424');
INSERT INTO `net_city` VALUES ('3393', '23', 'Ламар', 'Lamar', 'SC', '29069', '34.1939', '-80.1024');
INSERT INTO `net_city` VALUES ('3397', '23', 'Чарлстаун', 'Charlestown', 'MA', '02129', '42.3801', '-71.0642');
INSERT INTO `net_city` VALUES ('3399', '23', 'Уинтервилл', 'Winterville', 'GA', '30683', '33.9312', '-83.2595');
INSERT INTO `net_city` VALUES ('3400', '23', 'Уайтуотер', 'Whitewater', 'WI', '53190', '42.8048', '-88.7072');
INSERT INTO `net_city` VALUES ('3401', '23', 'Метуен', 'Methuen', 'MA', '01844', '42.7324', '-71.1862');
INSERT INTO `net_city` VALUES ('3402', '23', 'Хупестон', 'Hoopeston', 'IL', '60942', '40.4680', '-87.6731');
INSERT INTO `net_city` VALUES ('3403', '23', 'Версайллес', 'Versailles', 'KY', '40383', '37.9969', '-84.7466');
INSERT INTO `net_city` VALUES ('3404', '28', 'Санта-Крус', 'Saint Croix', '00', '00850', '17.7342', '-64.7347');
INSERT INTO `net_city` VALUES ('3406', '23', 'Вудс Кросс', 'Woods Cross', 'UT', '84087', '40.8917', '-111.9311');
INSERT INTO `net_city` VALUES ('3409', '23', 'Лоди', 'Lodi', 'NJ', '07644', '40.8783', '-74.0813');
INSERT INTO `net_city` VALUES ('3414', '23', 'Джорданвилль', 'Jordanville', 'NY', '13361', '42.9029', '-74.8802');
INSERT INTO `net_city` VALUES ('3416', '23', 'Мерфрисборо', 'Murfreesboro', 'TN', '37129', '35.9298', '-86.4605');
INSERT INTO `net_city` VALUES ('3423', '23', 'Элко', 'Elko', 'NV', '89801', '40.9527', '-115.7906');
INSERT INTO `net_city` VALUES ('3424', '23', 'Лавина', 'Lavina', 'MT', '59046', '46.4416', '-108.9997');
INSERT INTO `net_city` VALUES ('3426', '23', 'Розуэлл', 'Roswell', 'GA', '30075', '34.0560', '-84.3795');
INSERT INTO `net_city` VALUES ('3430', '23', 'Натик', 'Natick', 'MA', '01760', '42.2873', '-71.3524');
INSERT INTO `net_city` VALUES ('3434', '23', 'Фернандина Бич', 'Fernandina Beach', 'FL', '32034', '30.6005', '-81.5283');
INSERT INTO `net_city` VALUES ('3436', '23', 'Мейтланд', 'Maitland', 'FL', '32751', '28.6294', '-81.3619');
INSERT INTO `net_city` VALUES ('3439', '23', 'Тайрон', 'Tyrone', 'GA', '30290', '33.4647', '-84.5846');
INSERT INTO `net_city` VALUES ('3440', '23', 'Лихай', 'Lehi', 'UT', '84043', '40.3245', '-111.9618');
INSERT INTO `net_city` VALUES ('3441', '23', 'Уэст Джордан', 'West Jordan', 'UT', '84084', '40.6236', '-111.9871');
INSERT INTO `net_city` VALUES ('3442', '23', 'Хартфорд', 'Hartford', 'KS', '66854', '38.2605', '-95.9689');
INSERT INTO `net_city` VALUES ('3444', '23', 'Лейк Форест', 'Lake Forest', 'IL', '60045', '42.2400', '-87.8717');
INSERT INTO `net_city` VALUES ('3451', '23', 'Уолсберг', 'Wallsburg', 'UT', '84082', '40.3636', '-111.4331');
INSERT INTO `net_city` VALUES ('3452', '23', 'Плейнвелл', 'Plainwell', 'MI', '49080', '42.4825', '-85.5787');
INSERT INTO `net_city` VALUES ('3453', '23', 'Арнолд', 'Arnold', 'MO', '63010', '38.4231', '-90.4006');
INSERT INTO `net_city` VALUES ('3456', '23', 'Американ Форк', 'American Fork', 'UT', '84003', '40.3930', '-111.7838');
INSERT INTO `net_city` VALUES ('3457', '23', 'Айдахо-Фолс', 'Idaho Falls', 'ID', '83404', '43.4285', '-112.0041');
INSERT INTO `net_city` VALUES ('3458', '23', 'Бозман', 'Bozeman', 'MT', '59715', '45.7720', '-110.9349');
INSERT INTO `net_city` VALUES ('3459', '23', 'Гардинер', 'Gardiner', 'MT', '59030', '45.1303', '-110.4182');
INSERT INTO `net_city` VALUES ('3460', '23', 'Мидлтаун', 'Middletown', 'OH', '45044', '39.4439', '-84.4168');
INSERT INTO `net_city` VALUES ('3461', '23', 'Либертивилл', 'Libertyville', 'IL', '60048', '42.2833', '-87.9606');
INSERT INTO `net_city` VALUES ('3463', '23', 'Клей Сити', 'Clay City', 'KY', '40312', '37.8430', '-83.9266');
INSERT INTO `net_city` VALUES ('3465', '23', 'Кассвилл', 'Cassville', 'MO', '65625', '36.6839', '-93.8218');
INSERT INTO `net_city` VALUES ('3467', '23', 'Ривертон', 'Riverton', 'UT', '84065', '40.4774', '-112.0082');
INSERT INTO `net_city` VALUES ('3468', '23', 'Маунт-Вернон', 'Mount Vernon', 'IN', '47620', '37.9106', '-87.7815');
INSERT INTO `net_city` VALUES ('3469', '23', 'Норуолк', 'Norwalk', 'IA', '50211', '41.4469', '-93.6887');
INSERT INTO `net_city` VALUES ('3470', '23', 'Клайв', 'Clive', 'IA', '50325', '41.6139', '-93.7855');
INSERT INTO `net_city` VALUES ('3472', '23', 'Бойс', 'Boyce', 'LA', '71409', '31.3065', '-92.6542');
INSERT INTO `net_city` VALUES ('3473', '23', 'Далонега', 'Dahlonega', 'GA', '30533', '34.5728', '-84.0263');
INSERT INTO `net_city` VALUES ('3474', '23', 'Робинсонвилл', 'Robinsonville', 'MS', '38664', '34.7814', '-90.3302');
INSERT INTO `net_city` VALUES ('3477', '23', 'Карлин', 'Carlin', 'NV', '89822', '40.7335', '-116.1063');
INSERT INTO `net_city` VALUES ('3478', '23', 'Блэкфут', 'Blackfoot', 'ID', '83221', '43.2779', '-112.5627');
INSERT INTO `net_city` VALUES ('3480', '23', 'Твейн Харт', 'Twain Harte', 'CA', '95383', '38.0815', '-120.2479');
INSERT INTO `net_city` VALUES ('3482', '23', 'Боксборо', 'Boxborough', 'MA', '01719', '42.4917', '-71.5170');
INSERT INTO `net_city` VALUES ('3483', '23', 'Аткинс', 'Atkins', 'VA', '24311', '36.8836', '-81.3919');
INSERT INTO `net_city` VALUES ('3485', '23', 'Парамп', 'Pahrump', 'NV', '89048', '36.3638', '-116.1500');
INSERT INTO `net_city` VALUES ('3490', '23', 'Маскл Шолс', 'Muscle Shoals', 'AL', '35661', '34.7686', '-87.5583');
INSERT INTO `net_city` VALUES ('3491', '23', 'Шамплейн', 'Champlain', 'NY', '12919', '44.9607', '-73.4360');
INSERT INTO `net_city` VALUES ('3493', '23', 'Уиннемакка', 'Winnemucca', 'NV', '89445', '41.1216', '-118.0537');
INSERT INTO `net_city` VALUES ('3496', '23', 'Харрикейн', 'Hurricane', 'UT', '84737', '37.1385', '-112.9790');
INSERT INTO `net_city` VALUES ('3505', '23', 'Вудбери', 'Woodbury', 'GA', '30293', '32.9841', '-84.6109');
INSERT INTO `net_city` VALUES ('3511', '23', 'Ист Элмхерст', 'East Elmhurst', 'NY', '11369', '40.7638', '-73.8709');
INSERT INTO `net_city` VALUES ('3513', '23', 'Мескит', 'Mesquite', 'NV', '89027', '36.7889', '-114.1431');
INSERT INTO `net_city` VALUES ('3518', '23', 'Футхилл Ранч', 'Foothill Ranch', 'CA', '92610', '33.7041', '-117.6724');
INSERT INTO `net_city` VALUES ('3519', '23', 'Сидар Парк', 'Cedar Park', 'TX', '78613', '30.4998', '-97.8082');
INSERT INTO `net_city` VALUES ('3520', '23', 'Грейнджвилл', 'Grangeville', 'ID', '83530', '45.9035', '-116.1387');
INSERT INTO `net_city` VALUES ('3521', '23', 'Нецперс', 'Nezperce', 'ID', '83543', '46.2826', '-116.2320');
INSERT INTO `net_city` VALUES ('3523', '23', 'Сандпойнт', 'Sandpoint', 'ID', '83864', '48.3432', '-116.4536');
INSERT INTO `net_city` VALUES ('3524', '23', 'Пендлтон', 'Pendleton', 'OR', '97801', '45.7354', '-118.7977');
INSERT INTO `net_city` VALUES ('3525', '23', 'Меридиан', 'Meridian', 'ID', '83642', '43.5992', '-116.4234');
INSERT INTO `net_city` VALUES ('3526', '23', 'Хермистон', 'Hermiston', 'OR', '97838', '45.8504', '-119.2130');
INSERT INTO `net_city` VALUES ('3527', '23', 'Кенневик', 'Kennewick', 'WA', '99336', '46.2131', '-119.1682');
INSERT INTO `net_city` VALUES ('3528', '23', 'Лоренсевилл', 'Lawrenceville', 'GA', '30045', '33.9350', '-83.9538');
INSERT INTO `net_city` VALUES ('3529', '23', 'Куския', 'Kooskia', 'ID', '83539', '46.0857', '-115.8628');
INSERT INTO `net_city` VALUES ('3530', '23', 'Пулман', 'Pullman', 'WA', '99163', '46.7322', '-117.2455');
INSERT INTO `net_city` VALUES ('3532', '23', 'Смирна', 'Smyrna', 'GA', '30080', '33.8633', '-84.4984');
INSERT INTO `net_city` VALUES ('3535', '23', 'Киркленд', 'Kirkland', 'WA', '98033', '47.6727', '-122.1873');
INSERT INTO `net_city` VALUES ('3541', '23', 'Уорсо', 'Warsaw', 'IN', '46580', '41.2023', '-85.8630');
INSERT INTO `net_city` VALUES ('3543', '23', 'Энумкло', 'Enumclaw', 'WA', '98022', '47.1060', '-121.6029');
INSERT INTO `net_city` VALUES ('3545', '23', 'Ньюпорт', 'Newport', 'RI', '02840', '41.4851', '-71.3075');
INSERT INTO `net_city` VALUES ('3546', '23', 'Канонсберг', 'Canonsburg', 'PA', '15317', '40.2713', '-80.1702');
INSERT INTO `net_city` VALUES ('3547', '23', 'Логанвилль', 'Loganville', 'GA', '30052', '33.8042', '-83.8893');
INSERT INTO `net_city` VALUES ('3551', '23', 'Хановер', 'Hanover', 'MD', '21076', '39.1758', '-76.7298');
INSERT INTO `net_city` VALUES ('3552', '23', 'Белкамп', 'Belcamp', 'MD', '21017', '39.4752', '-76.2368');
INSERT INTO `net_city` VALUES ('3553', '23', 'Сейнт Майклс', 'Saint Michaels', 'MD', '21663', '38.7993', '-76.2334');
INSERT INTO `net_city` VALUES ('3554', '23', 'Венис', 'Venice', 'IL', '62090', '38.6703', '-90.1704');
INSERT INTO `net_city` VALUES ('3556', '23', 'Райзинг Сан', 'Rising Sun', 'MD', '21911', '39.6717', '-76.0546');
INSERT INTO `net_city` VALUES ('3557', '23', 'Форт Йетс', 'Fort Yates', 'ND', '58538', '46.1035', '-100.7029');
INSERT INTO `net_city` VALUES ('3560', '23', 'Серритос', 'Cerritos', 'CA', '90703', '33.8661', '-118.0528');
INSERT INTO `net_city` VALUES ('3561', '23', 'Мейблтон', 'Mableton', 'GA', '30126', '33.8119', '-84.5504');
INSERT INTO `net_city` VALUES ('3563', '23', 'Кливленд', 'Cleveland', 'TN', '37311', '35.0978', '-84.9115');
INSERT INTO `net_city` VALUES ('3565', '23', 'Таллахасси', 'Tallahassee', 'FL', '32309', '30.5802', '-84.1266');
INSERT INTO `net_city` VALUES ('3567', '23', 'Ньюберри', 'Newberry', 'FL', '32669', '29.6313', '-82.5814');
INSERT INTO `net_city` VALUES ('3569', '23', 'Ринкон', 'Rincon', 'GA', '31326', '32.2923', '-81.2182');
INSERT INTO `net_city` VALUES ('3572', '23', 'Мидуэй', 'Midway', 'FL', '32343', '30.4924', '-84.4473');
INSERT INTO `net_city` VALUES ('3573', '23', 'Валдоста', 'Valdosta', 'GA', '31601', '30.7461', '-83.3513');
INSERT INTO `net_city` VALUES ('3578', '23', 'Уэксфорд', 'Wexford', 'PA', '15090', '40.6290', '-80.0793');
INSERT INTO `net_city` VALUES ('3580', '23', 'Понт Ведра Бич', 'Ponte Vedra Beach', 'FL', '32082', '30.1023', '-81.3532');
INSERT INTO `net_city` VALUES ('3581', '23', 'Мак-Доно', 'McDonough', 'GA', '30253', '33.4514', '-84.1870');
INSERT INTO `net_city` VALUES ('3583', '23', 'Сейнт Саймонс Айленд', 'Saint Simons Island', 'GA', '31522', '31.2163', '-81.3666');
INSERT INTO `net_city` VALUES ('3601', '23', 'Йетс Сити', 'Yates City', 'IL', '61572', '40.7949', '-90.0430');
INSERT INTO `net_city` VALUES ('3603', '23', 'Дана Пойнт', 'Dana Point', 'CA', '92629', '33.4782', '-117.7064');
INSERT INTO `net_city` VALUES ('3604', '23', 'Кларксвилл', 'Clarksville', 'TN', '37040', '36.4642', '-87.3797');
INSERT INTO `net_city` VALUES ('3606', '23', 'Грин Ков Спрингс', 'Green Cove Springs', 'FL', '32043', '29.9430', '-81.7433');
INSERT INTO `net_city` VALUES ('3608', '23', 'Морристаун', 'Morristown', 'TN', '37813', '36.1856', '-83.2840');
INSERT INTO `net_city` VALUES ('3610', '23', 'Порт Сейнт Джо', 'Port Saint Joe', 'FL', '32456', '29.8409', '-85.2690');
INSERT INTO `net_city` VALUES ('3612', '23', 'Кеноша', 'Kenosha', 'WI', '53144', '42.6227', '-87.9377');
INSERT INTO `net_city` VALUES ('3614', '23', 'Норт Орора', 'North Aurora', 'IL', '60542', '41.8044', '-88.3470');
INSERT INTO `net_city` VALUES ('3615', '23', 'Рейдсвилл', 'Reidsville', 'GA', '30453', '32.0178', '-82.0966');
INSERT INTO `net_city` VALUES ('3617', '23', 'Уиндер', 'Winder', 'GA', '30680', '33.9846', '-83.6978');
INSERT INTO `net_city` VALUES ('3618', '23', 'Дуглас', 'Douglas', 'GA', '31535', '31.4648', '-82.8608');
INSERT INTO `net_city` VALUES ('3620', '23', 'Шарлотсвилл', 'Charlottesville', 'VA', '22911', '38.0980', '-78.3966');
INSERT INTO `net_city` VALUES ('3623', '23', 'Блантстаун', 'Blountstown', 'FL', '32424', '30.4134', '-85.0678');
INSERT INTO `net_city` VALUES ('3624', '23', 'Лагофф', 'Lugoff', 'SC', '29078', '34.1873', '-80.7064');
INSERT INTO `net_city` VALUES ('3625', '23', 'Каривилл', 'Caryville', 'FL', '32427', '30.7207', '-85.8029');
INSERT INTO `net_city` VALUES ('3630', '23', 'Тифтон', 'Tifton', 'GA', '31794', '31.4382', '-83.4391');
INSERT INTO `net_city` VALUES ('3632', '23', 'Данлап', 'Dunlap', 'TN', '37327', '35.4250', '-85.3830');
INSERT INTO `net_city` VALUES ('3634', '23', 'Чуалатин', 'Tualatin', 'OR', '97062', '45.3653', '-122.7579');
INSERT INTO `net_city` VALUES ('3636', '23', 'Гаффни', 'Gaffney', 'SC', '29341', '35.0994', '-81.7048');
INSERT INTO `net_city` VALUES ('3640', '23', 'Батл Граунд', 'Battle Ground', 'WA', '98604', '45.8081', '-122.4816');
INSERT INTO `net_city` VALUES ('3641', '23', 'Сэнди', 'Sandy', 'OR', '97055', '45.3843', '-122.1750');
INSERT INTO `net_city` VALUES ('3642', '23', 'Гаймон', 'Guymon', 'OK', '73942', '36.7477', '-101.5156');
INSERT INTO `net_city` VALUES ('3643', '23', 'Куз Бэй', 'Coos Bay', 'OR', '97420', '43.3740', '-124.1477');
INSERT INTO `net_city` VALUES ('3644', '23', 'Ридспорт', 'Reedsport', 'OR', '97467', '43.7917', '-123.9078');
INSERT INTO `net_city` VALUES ('3652', '23', 'Лейк Блафф', 'Lake Bluff', 'IL', '60044', '42.2853', '-87.8700');
INSERT INTO `net_city` VALUES ('3655', '23', 'Спрингфилд', 'Springfield', 'OR', '97477', '44.0580', '-123.0063');
INSERT INTO `net_city` VALUES ('3657', '23', 'Шервуд', 'Sherwood', 'OR', '97140', '45.3552', '-122.8615');
INSERT INTO `net_city` VALUES ('3658', '23', 'Нью Провиденс', 'New Providence', 'NJ', '07974', '40.6973', '-74.4052');
INSERT INTO `net_city` VALUES ('3661', '23', 'Мешоппен', 'Meshoppen', 'PA', '18630', '41.6719', '-76.0227');
INSERT INTO `net_city` VALUES ('3665', '23', 'Кеннетт Сквер', 'Kennett Square', 'PA', '19348', '39.8671', '-75.7119');
INSERT INTO `net_city` VALUES ('3667', '23', 'Бойертаун', 'Boyertown', 'PA', '19512', '40.3468', '-75.6809');
INSERT INTO `net_city` VALUES ('3668', '23', 'Цинциннати', 'Cincinnati', 'OH', '45223', '39.1666', '-84.5465');
INSERT INTO `net_city` VALUES ('3669', '23', 'Хакеттстаун', 'Hackettstown', 'NJ', '07840', '40.8669', '-74.8220');
INSERT INTO `net_city` VALUES ('3670', '23', 'Конуэй', 'Conway', 'AR', '72032', '35.0640', '-92.3802');
INSERT INTO `net_city` VALUES ('3675', '23', 'Глен Милс', 'Glen Mills', 'PA', '19342', '39.9056', '-75.4874');
INSERT INTO `net_city` VALUES ('3676', '23', 'Динуба', 'Dinuba', 'CA', '93618', '36.5237', '-119.3953');
INSERT INTO `net_city` VALUES ('3677', '23', 'Сентрал Валли', 'Central Valley', 'NY', '10917', '41.3237', '-74.1231');
INSERT INTO `net_city` VALUES ('3679', '23', 'Конкордвилл', 'Concordville', 'PA', '19331', '39.8851', '-75.5202');
INSERT INTO `net_city` VALUES ('3682', '23', 'Маунт Хоп', 'Mount Hope', 'OH', '44660', '40.6240', '-81.7846');
INSERT INTO `net_city` VALUES ('3683', '23', 'Рокфорд', 'Rockford', 'IL', '61103', '42.3423', '-89.0816');
INSERT INTO `net_city` VALUES ('3690', '23', 'Эрлисвилл', 'Earlysville', 'VA', '22936', '38.1570', '-78.4948');
INSERT INTO `net_city` VALUES ('3697', '23', 'Дойлстаун', 'Doylestown', 'PA', '18901', '40.3321', '-75.1179');
INSERT INTO `net_city` VALUES ('3699', '23', 'Уинчестер', 'Winchester', 'KY', '40391', '37.9685', '-84.1460');
INSERT INTO `net_city` VALUES ('3704', '23', 'Форт Нокс', 'Fort Knox', 'KY', '40121', '37.9263', '-85.9481');
INSERT INTO `net_city` VALUES ('3706', '23', 'Хани Брук', 'Honey Brook', 'PA', '19344', '40.0799', '-75.8693');
INSERT INTO `net_city` VALUES ('3708', '23', 'Бранчвилл', 'Branchville', 'NJ', '07890', '41.1283', '-74.6790');
INSERT INTO `net_city` VALUES ('3709', '23', 'Санта-Роза', 'Santa Rosa', 'CA', '95403', '38.5021', '-122.7619');
INSERT INTO `net_city` VALUES ('3710', '23', 'Форт Вашингтон', 'Fort Washington', 'PA', '19034', '40.1370', '-75.2062');
INSERT INTO `net_city` VALUES ('3712', '23', 'Юкайа', 'Ukiah', 'CA', '95482', '39.1266', '-123.2805');
INSERT INTO `net_city` VALUES ('3713', '23', 'Хилсдейл', 'Hillsdale', 'MI', '49242', '41.8619', '-84.6038');
INSERT INTO `net_city` VALUES ('3716', '23', 'Гошен', 'Goshen', 'IN', '46526', '41.5595', '-85.8542');
INSERT INTO `net_city` VALUES ('3720', '23', 'Наполеон', 'Napoleon', 'OH', '43545', '41.4007', '-84.1331');
INSERT INTO `net_city` VALUES ('3721', '23', 'Милбери', 'Millbury', 'OH', '43447', '41.5701', '-83.4303');
INSERT INTO `net_city` VALUES ('3726', '23', 'Уэст Честер', 'West Chester', 'OH', '45069', '39.3376', '-84.4044');
INSERT INTO `net_city` VALUES ('3727', '23', 'Плимут', 'Plymouth', 'MI', '48170', '42.3655', '-83.5367');
INSERT INTO `net_city` VALUES ('3733', '23', 'Ипсиланти', 'Ypsilanti', 'MI', '48197', '42.2061', '-83.6228');
INSERT INTO `net_city` VALUES ('3735', '23', 'Джонсвилл', 'Jonesville', 'MI', '49250', '42.0154', '-84.6086');
INSERT INTO `net_city` VALUES ('3736', '23', 'Уайт Марш', 'White Marsh', 'MD', '21162', '39.3902', '-76.4065');
INSERT INTO `net_city` VALUES ('3737', '23', 'Кантон', 'Canton', 'MI', '48187', '42.3291', '-83.4877');
INSERT INTO `net_city` VALUES ('3740', '23', 'Эйдриан', 'Adrian', 'MI', '49221', '41.8934', '-84.0659');
INSERT INTO `net_city` VALUES ('3741', '23', 'Сандаски', 'Sandusky', 'OH', '44870', '41.4016', '-82.7310');
INSERT INTO `net_city` VALUES ('3746', '23', 'Пайонир', 'Pioneer', 'OH', '43554', '41.6449', '-84.5342');
INSERT INTO `net_city` VALUES ('3748', '23', 'Дефианс', 'Defiance', 'OH', '43512', '41.3606', '-84.3701');
INSERT INTO `net_city` VALUES ('3749', '23', 'Нортвуд', 'Northwood', 'OH', '43619', '41.5961', '-83.4443');
INSERT INTO `net_city` VALUES ('3752', '23', 'Перрисберг', 'Perrysburg', 'OH', '43551', '41.5295', '-83.5656');
INSERT INTO `net_city` VALUES ('3759', '23', 'Сеуикли', 'Sewickley', 'PA', '15143', '40.5775', '-80.1503');
INSERT INTO `net_city` VALUES ('3760', '23', 'Сэнди', 'Sandy', 'UT', '84070', '40.5765', '-111.8938');
INSERT INTO `net_city` VALUES ('3761', '23', 'Блиссфилд', 'Blissfield', 'MI', '49228', '41.8130', '-83.8815');
INSERT INTO `net_city` VALUES ('3762', '23', 'Миссула', 'Missoula', 'MT', '59808', '46.9846', '-114.1213');
INSERT INTO `net_city` VALUES ('3763', '23', 'Сильвания', 'Sylvania', 'OH', '43560', '41.6930', '-83.7273');
INSERT INTO `net_city` VALUES ('3765', '23', 'Линкольн', 'Lincoln', 'RI', '02865', '41.9171', '-71.4423');
INSERT INTO `net_city` VALUES ('3766', '23', 'Шелбивилл', 'Shelbyville', 'KY', '40065', '38.2145', '-85.2053');
INSERT INTO `net_city` VALUES ('3775', '23', 'Спокан', 'Spokane', 'WA', '99202', '47.6567', '-117.3785');
INSERT INTO `net_city` VALUES ('3777', '23', 'Трамбулл', 'Trumbull', 'CT', '06611', '41.2599', '-73.2076');
INSERT INTO `net_city` VALUES ('3779', '23', 'Стратфорд', 'Stratford', 'CT', '06615', '41.1737', '-73.1365');
INSERT INTO `net_city` VALUES ('3780', '23', 'Норт Дартмут', 'North Dartmouth', 'MA', '02747', '41.6623', '-71.0107');
INSERT INTO `net_city` VALUES ('3781', '23', 'Авенел', 'Avenel', 'NJ', '07001', '40.5860', '-74.2713');
INSERT INTO `net_city` VALUES ('3783', '23', 'Данбери', 'Danbury', 'CT', '06810', '41.3781', '-73.4691');
INSERT INTO `net_city` VALUES ('3784', '23', 'Гилфорд', 'Guilford', 'CT', '06437', '41.3387', '-72.6907');
INSERT INTO `net_city` VALUES ('3786', '23', 'Ист-Рутерфорд', 'East Rutherford', 'NJ', '07073', '40.8132', '-74.0738');
INSERT INTO `net_city` VALUES ('3787', '23', 'Милфорд', 'Milford', 'CT', '06460', '41.2241', '-73.0517');
INSERT INTO `net_city` VALUES ('3788', '23', 'Сеймур', 'Seymour', 'CT', '06483', '41.3846', '-73.0943');
INSERT INTO `net_city` VALUES ('3789', '23', 'Уэст Хейвен', 'West Haven', 'CT', '06516', '41.2730', '-72.9574');
INSERT INTO `net_city` VALUES ('3795', '23', 'Ронконкома', 'Ronkonkoma', 'NY', '11779', '40.8156', '-73.1181');
INSERT INTO `net_city` VALUES ('3796', '23', 'Коммек', 'Commack', 'NY', '11725', '40.8393', '-73.2797');
INSERT INTO `net_city` VALUES ('3797', '23', 'Сионсвилл', 'Zionsville', 'IN', '46077', '39.9831', '-86.2876');
INSERT INTO `net_city` VALUES ('3798', '23', 'Холбрук', 'Holbrook', 'NY', '11741', '40.7981', '-73.0680');
INSERT INTO `net_city` VALUES ('3800', '23', 'Бохемия', 'Bohemia', 'NY', '11716', '40.7699', '-73.1263');
INSERT INTO `net_city` VALUES ('3801', '23', 'Холтсвилл', 'Holtsville', 'NY', '11742', '40.8107', '-73.0459');
INSERT INTO `net_city` VALUES ('3803', '23', 'Хамптон Бейс', 'Hampton Bays', 'NY', '11946', '40.8817', '-72.5364');
INSERT INTO `net_city` VALUES ('3804', '23', 'Беркли', 'Berkeley', 'CA', '94702', '37.8646', '-122.2877');
INSERT INTO `net_city` VALUES ('3805', '23', 'Дансвилл', 'Danville', 'CA', '94526', '37.8129', '-121.9743');
INSERT INTO `net_city` VALUES ('3808', '23', 'Шорхэм', 'Shoreham', 'NY', '11786', '40.9441', '-72.8883');
INSERT INTO `net_city` VALUES ('3809', '23', 'Вальехо', 'Vallejo', 'CA', '94591', '38.1165', '-122.2091');
INSERT INTO `net_city` VALUES ('3810', '23', 'Бриджхемптон', 'Bridgehampton', 'NY', '11932', '40.9379', '-72.3009');
INSERT INTO `net_city` VALUES ('3812', '23', 'Саутбери', 'Southbury', 'CT', '06488', '41.4675', '-73.2406');
INSERT INTO `net_city` VALUES ('3814', '23', 'Рокки Хилл', 'Rocky Hill', 'CT', '06067', '41.6577', '-72.6627');
INSERT INTO `net_city` VALUES ('3819', '23', 'Ист Хейвен', 'East Haven', 'CT', '06512', '41.2833', '-72.8653');
INSERT INTO `net_city` VALUES ('3822', '23', 'Эфингем', 'Effingham', 'IL', '62401', '39.1191', '-88.5702');
INSERT INTO `net_city` VALUES ('3826', '23', 'Армонк', 'Armonk', 'NY', '10504', '41.1309', '-73.6942');
INSERT INTO `net_city` VALUES ('3832', '23', 'Фонтана', 'Fontana', 'CA', '92335', '34.0881', '-117.4648');
INSERT INTO `net_city` VALUES ('3833', '23', 'Кромвель', 'Cromwell', 'CT', '06416', '41.6061', '-72.6677');
INSERT INTO `net_city` VALUES ('3834', '23', 'Грэйт Баррингтон', 'Great Barrington', 'MA', '01230', '42.1617', '-73.3277');
INSERT INTO `net_city` VALUES ('3835', '23', 'Норидж', 'Norwich', 'CT', '06360', '41.5507', '-72.0936');
INSERT INTO `net_city` VALUES ('3839', '23', 'Чикопи', 'Chicopee', 'MA', '01020', '42.1861', '-72.5255');
INSERT INTO `net_city` VALUES ('3840', '23', 'Уэст Хартфорд', 'West Hartford', 'CT', '06119', '41.7635', '-72.7266');
INSERT INTO `net_city` VALUES ('3841', '23', 'Уэтерсфилд', 'Wethersfield', 'CT', '06109', '41.7037', '-72.6628');
INSERT INTO `net_city` VALUES ('3843', '23', 'Гротон', 'Groton', 'CT', '06340', '41.3532', '-72.0386');
INSERT INTO `net_city` VALUES ('3844', '23', 'Фэрфилд', 'Fairfield', 'CA', '94533', '38.2832', '-122.0085');
INSERT INTO `net_city` VALUES ('3845', '23', 'Сейнт Клэрсвилл', 'Saint Clairsville', 'OH', '43950', '40.0968', '-80.9174');
INSERT INTO `net_city` VALUES ('3850', '23', 'Виндзор Локс', 'Windsor Locks', 'CT', '06096', '41.9235', '-72.6557');
INSERT INTO `net_city` VALUES ('3851', '23', 'Ханкок', 'Hancock', 'MA', '01201', '42.4728', '-73.2744');
INSERT INTO `net_city` VALUES ('3862', '23', 'Колман', 'Colman', 'SD', '57017', '44.0186', '-96.8287');
INSERT INTO `net_city` VALUES ('3865', '23', 'Аврора', 'Aurora', 'IL', '60504', '41.7590', '-88.2615');
INSERT INTO `net_city` VALUES ('3866', '23', 'Джей', 'Jay', 'FL', '32565', '30.8657', '-86.9838');
INSERT INTO `net_city` VALUES ('3867', '23', 'Василла', 'Wasilla', 'AK', '99654', '61.5235', '-149.5748');
INSERT INTO `net_city` VALUES ('3868', '23', 'Палмер', 'Palmer', 'AK', '99645', '61.6092', '-148.4657');
INSERT INTO `net_city` VALUES ('3871', '23', 'Уэверли', 'Waverly', 'IA', '50677', '42.7804', '-92.4363');
INSERT INTO `net_city` VALUES ('3874', '23', 'Игл Ривер', 'Eagle River', 'AK', '99577', '61.2149', '-149.2583');
INSERT INTO `net_city` VALUES ('3880', '23', 'Мадисон', 'Madison', 'AL', '35758', '34.7135', '-86.7421');
INSERT INTO `net_city` VALUES ('3889', '23', 'Якима', 'Yakima', 'WA', '98907', '46.6021', '-120.5059');
INSERT INTO `net_city` VALUES ('3896', '23', 'Уолла Уолла', 'Walla Walla', 'WA', '99362', '46.1107', '-118.3077');
INSERT INTO `net_city` VALUES ('3897', '23', 'Бриджвью', 'Bridgeview', 'IL', '60455', '41.7398', '-87.8095');
INSERT INTO `net_city` VALUES ('3898', '23', 'Дирфилд', 'Deerfield', 'IL', '60015', '42.1743', '-87.8810');
INSERT INTO `net_city` VALUES ('3899', '23', 'Мариетта', 'Marietta', 'GA', '30062', '34.0017', '-84.4710');
INSERT INTO `net_city` VALUES ('3900', '23', 'Ньюнен', 'Newnan', 'GA', '30263', '33.3734', '-84.8541');
INSERT INTO `net_city` VALUES ('3905', '23', 'Лития Спрингс', 'Lithia Springs', 'GA', '30122', '33.7614', '-84.6371');
INSERT INTO `net_city` VALUES ('3906', '23', 'Клейсвилл', 'Claysville', 'PA', '15323', '40.1087', '-80.4115');
INSERT INTO `net_city` VALUES ('3909', '23', 'Лебанон', 'Lebanon', 'TN', '37087', '36.2788', '-86.2712');
INSERT INTO `net_city` VALUES ('3910', '23', 'Спирит Лейк', 'Spirit Lake', 'IA', '51360', '43.4216', '-95.0932');
INSERT INTO `net_city` VALUES ('3912', '23', 'Пирленд', 'Pearland', 'TX', '77584', '29.5447', '-95.3370');
INSERT INTO `net_city` VALUES ('3913', '23', 'Гранд Айленд', 'Grand Island', 'NE', '68802', '40.9250', '-98.3420');
INSERT INTO `net_city` VALUES ('3917', '23', 'Уолл', 'Wall', 'SD', '57790', '44.1330', '-102.2186');
INSERT INTO `net_city` VALUES ('3918', '23', 'Саут Сиу Сити', 'South Sioux City', 'NE', '68776', '42.4555', '-96.4535');
INSERT INTO `net_city` VALUES ('3920', '23', 'Черривилл', 'Cherryville', 'NC', '28021', '35.3945', '-81.3888');
INSERT INTO `net_city` VALUES ('3921', '23', 'Янктон', 'Yankton', 'SD', '57078', '42.9359', '-97.4405');
INSERT INTO `net_city` VALUES ('3929', '23', 'Барнесвилл', 'Barnesville', 'OH', '43713', '39.9876', '-81.1610');
INSERT INTO `net_city` VALUES ('3938', '23', 'Скотс Валли', 'Scotts Valley', 'CA', '95066', '37.0614', '-122.0118');
INSERT INTO `net_city` VALUES ('3939', '23', 'Тейлорс', 'Taylors', 'SC', '29687', '34.9965', '-82.3287');
INSERT INTO `net_city` VALUES ('3946', '23', 'Мадисон', 'Madison', 'GA', '30650', '33.5908', '-83.4735');
INSERT INTO `net_city` VALUES ('3955', '23', 'Остелл', 'Austell', 'GA', '30168', '33.7814', '-84.5874');
INSERT INTO `net_city` VALUES ('3959', '21', 'Колчестер', 'Colchester', 'E4', '', '51.8833', '0.9000');
INSERT INTO `net_city` VALUES ('3961', '23', 'Сил Бич', 'Seal Beach', 'CA', '90740', '33.7576', '-118.0777');
INSERT INTO `net_city` VALUES ('3963', '23', 'Серпрайз', 'Surprise', 'AZ', '85374', '33.6475', '-112.3884');
INSERT INTO `net_city` VALUES ('3964', '23', 'Барстоу', 'Barstow', 'CA', '92311', '34.9701', '-116.9929');
INSERT INTO `net_city` VALUES ('3965', '23', 'Хемет', 'Hemet', 'CA', '92545', '33.7361', '-117.0583');
INSERT INTO `net_city` VALUES ('3967', '23', 'Риалто', 'Rialto', 'CA', '92376', '34.1020', '-117.3868');
INSERT INTO `net_city` VALUES ('3968', '23', 'Апленд', 'Upland', 'CA', '91786', '34.1040', '-117.6642');
INSERT INTO `net_city` VALUES ('3970', '23', 'Онтарио', 'Ontario', 'CA', '91764', '34.0778', '-117.6261');
INSERT INTO `net_city` VALUES ('3982', '23', 'Скотт', 'Scott', 'MS', '38772', '33.5918', '-91.0743');
INSERT INTO `net_city` VALUES ('3984', '23', 'Лос Банос', 'Los Banos', 'CA', '93635', '36.9036', '-121.0215');
INSERT INTO `net_city` VALUES ('3987', '23', 'Дафни', 'Daphne', 'AL', '36526', '30.6061', '-87.8580');
INSERT INTO `net_city` VALUES ('3992', '23', 'Делрей-Бич', 'Delray Beach', 'FL', '33445', '26.4541', '-80.1041');
INSERT INTO `net_city` VALUES ('3993', '23', 'Дугласвилл', 'Douglasville', 'GA', '30133', '33.7515', '-84.7477');
INSERT INTO `net_city` VALUES ('3994', '23', 'Ривердейл', 'Riverdale', 'GA', '30296', '33.5561', '-84.4522');
INSERT INTO `net_city` VALUES ('3995', '23', 'Стьюбенвилл', 'Steubenville', 'OH', '43952', '40.3968', '-80.6749');
INSERT INTO `net_city` VALUES ('3998', '23', 'Хоторн', 'Hawthorne', 'CA', '90250', '33.9129', '-118.3439');
INSERT INTO `net_city` VALUES ('4001', '23', 'Марина дель Рей', 'Marina del Rey', 'CA', '90292', '33.9777', '-118.4351');
INSERT INTO `net_city` VALUES ('4011', '23', 'Помпано Бич', 'Pompano Beach', 'FL', '33071', '26.2436', '-80.2656');
INSERT INTO `net_city` VALUES ('4012', '23', 'Белмар', 'Belmar', 'NJ', '07719', '40.1658', '-74.0743');
INSERT INTO `net_city` VALUES ('4013', '23', 'Итонтаун', 'Eatontown', 'NJ', '07724', '40.3039', '-74.0703');
INSERT INTO `net_city` VALUES ('4014', '23', 'Эль Дорадо Хилс', 'El Dorado Hills', 'CA', '95762', '38.6839', '-121.0526');
INSERT INTO `net_city` VALUES ('4015', '23', 'Уидспорт', 'Weedsport', 'NY', '13166', '43.0351', '-76.5552');
INSERT INTO `net_city` VALUES ('4018', '23', 'Бернет', 'Burnet', 'TX', '78611', '30.7970', '-98.2445');
INSERT INTO `net_city` VALUES ('4022', '23', 'Хагер', 'Huger', 'SC', '29450', '33.0608', '-79.7927');
INSERT INTO `net_city` VALUES ('4025', '23', 'Хазард', 'Hazard', 'KY', '41701', '37.3092', '-83.0568');
INSERT INTO `net_city` VALUES ('4028', '23', 'Бюлер', 'Buhler', 'KS', '67522', '38.1192', '-97.7469');
INSERT INTO `net_city` VALUES ('4032', '23', 'Фриско', 'Frisco', 'TX', '75034', '33.1499', '-96.8555');
INSERT INTO `net_city` VALUES ('4034', '23', 'Парис', 'Paris', 'TX', '75460', '33.6201', '-95.6003');
INSERT INTO `net_city` VALUES ('4037', '23', 'Техаркана', 'Texarkana', 'TX', '75504', '33.4251', '-94.0477');
INSERT INTO `net_city` VALUES ('4039', '23', 'Эрлангер', 'Erlanger', 'KY', '41018', '39.0163', '-84.5981');
INSERT INTO `net_city` VALUES ('4040', '23', 'Кауфман', 'Kaufman', 'TX', '75142', '32.5686', '-96.2676');
INSERT INTO `net_city` VALUES ('4042', '23', 'Глендейл', 'Glendale', 'AZ', '85308', '33.6669', '-112.1857');
INSERT INTO `net_city` VALUES ('4044', '23', 'Джэксборо', 'Jacksboro', 'TX', '76458', '33.2189', '-98.1728');
INSERT INTO `net_city` VALUES ('4046', '23', 'Спрингфилд', 'Springfield', 'KY', '40069', '37.7300', '-85.2147');
INSERT INTO `net_city` VALUES ('4051', '23', 'Сидар Лейк', 'Cedar Lake', 'IN', '46303', '41.3666', '-87.4672');
INSERT INTO `net_city` VALUES ('4052', '23', 'Маунт Арлингтон', 'Mount Arlington', 'NJ', '07856', '40.9168', '-74.6370');
INSERT INTO `net_city` VALUES ('4056', '23', 'Рокпорт', 'Rockport', 'ME', '04856', '44.1733', '-69.1248');
INSERT INTO `net_city` VALUES ('4058', '23', 'Элк Рапидс', 'Elk Rapids', 'MI', '49629', '44.9141', '-85.3988');
INSERT INTO `net_city` VALUES ('4059', '23', 'Гарден Сити', 'Garden City', 'NY', '11530', '40.7276', '-73.6344');
INSERT INTO `net_city` VALUES ('4062', '23', 'Аламеда', 'Alameda', 'CA', '94501', '37.7735', '-122.2788');
INSERT INTO `net_city` VALUES ('4064', '23', 'Рошелл Парк', 'Rochelle Park', 'NJ', '07662', '40.9057', '-74.0797');
INSERT INTO `net_city` VALUES ('4065', '23', 'Стони Пойнт', 'Stony Point', 'NY', '10980', '41.2544', '-74.0403');
INSERT INTO `net_city` VALUES ('4066', '29', 'Ольде ', 'Oelde', '07', '', '51.8167', '8.1500');
INSERT INTO `net_city` VALUES ('4068', '23', 'Парадайс Валли', 'Paradise Valley', 'AZ', '85253', '33.5422', '-111.9679');
INSERT INTO `net_city` VALUES ('4069', '23', 'Такседо Парк', 'Tuxedo Park', 'NY', '10987', '41.2084', '-74.2150');
INSERT INTO `net_city` VALUES ('4072', '23', 'Гленвью', 'Glenview', 'IL', '60025', '42.0855', '-87.8247');
INSERT INTO `net_city` VALUES ('4073', '23', 'Герни', 'Gurnee', 'IL', '60031', '42.3738', '-87.9440');
INSERT INTO `net_city` VALUES ('4074', '23', 'Уокиган', 'Waukegan', 'IL', '60085', '42.3479', '-87.8671');
INSERT INTO `net_city` VALUES ('4075', '23', 'Роксбери', 'Roxbury', 'VT', '05669', '44.0565', '-72.7437');
INSERT INTO `net_city` VALUES ('4077', '23', 'Эванстон', 'Evanston', 'IL', '60201', '42.0562', '-87.7011');
INSERT INTO `net_city` VALUES ('4078', '23', 'Бойн Сити', 'Boyne City', 'MI', '49712', '45.2011', '-85.0120');
INSERT INTO `net_city` VALUES ('4079', '23', 'Зайон', 'Zion', 'IL', '60099', '42.4563', '-87.8704');
INSERT INTO `net_city` VALUES ('4081', '23', 'Овассо', 'Owasso', 'OK', '74055', '36.2643', '-95.8277');
INSERT INTO `net_city` VALUES ('4087', '23', 'Фишкилл', 'Fishkill', 'NY', '12524', '41.5277', '-73.9072');
INSERT INTO `net_city` VALUES ('4091', '23', 'Лена', 'Lena', 'LA', '71447', '31.4225', '-92.8130');
INSERT INTO `net_city` VALUES ('4092', '23', 'Виксберг', 'Vicksburg', 'MS', '39182', '32.3526', '-90.8779');
INSERT INTO `net_city` VALUES ('4093', '23', 'Ньюкерк', 'Newkirk', 'OK', '74647', '36.9048', '-97.0773');
INSERT INTO `net_city` VALUES ('4096', '23', 'Норт Чикаго', 'North Chicago', 'IL', '60064', '42.3182', '-87.8597');
INSERT INTO `net_city` VALUES ('4097', '23', 'Катона', 'Katonah', 'NY', '10536', '41.2640', '-73.6700');
INSERT INTO `net_city` VALUES ('4099', '23', 'Элмсфорд', 'Elmsford', 'NY', '10523', '41.0612', '-73.8221');
INSERT INTO `net_city` VALUES ('4100', '23', 'Мейсон', 'Mason', 'OH', '45040', '39.3522', '-84.2994');
INSERT INTO `net_city` VALUES ('4102', '23', 'Сканителс Фолс', 'Skaneateles Falls', 'NY', '13153', '42.9931', '-76.4561');
INSERT INTO `net_city` VALUES ('4106', '23', 'Палисейдс', 'Palisades', 'NY', '10964', '41.0178', '-73.9090');
INSERT INTO `net_city` VALUES ('4111', '23', 'Уэст Лафайетт', 'West Lafayette', 'IN', '47906', '40.4763', '-86.9571');
INSERT INTO `net_city` VALUES ('4113', '23', 'Кадиллак', 'Cadillac', 'MI', '49601', '44.2564', '-85.5348');
INSERT INTO `net_city` VALUES ('4114', '23', 'Мидлтаун', 'Middletown', 'RI', '02842', '41.5171', '-71.2789');
INSERT INTO `net_city` VALUES ('4115', '23', 'Фейетвил', 'Fayetteville', 'AR', '72703', '36.1189', '-93.9840');
INSERT INTO `net_city` VALUES ('4116', '23', 'Брансон', 'Branson', 'MO', '65615', '36.6437', '-93.2185');
INSERT INTO `net_city` VALUES ('4119', '23', 'Прайор', 'Pryor', 'OK', '74361', '36.3219', '-95.2826');
INSERT INTO `net_city` VALUES ('4121', '23', 'Гилрой', 'Gilroy', 'CA', '95020', '37.0692', '-121.5567');
INSERT INTO `net_city` VALUES ('4123', '23', 'Уолнат Крик', 'Walnut Creek', 'CA', '94596', '37.8916', '-122.0381');
INSERT INTO `net_city` VALUES ('4124', '23', 'Манисти', 'Manistee', 'MI', '49660', '44.2072', '-86.1957');
INSERT INTO `net_city` VALUES ('4125', '23', 'Ранчо Кордова', 'Rancho Cordova', 'CA', '95670', '38.6027', '-121.2687');
INSERT INTO `net_city` VALUES ('4126', '23', 'Кайл', 'Kyle', 'TX', '78640', '29.9893', '-97.8572');
INSERT INTO `net_city` VALUES ('4128', '23', 'Брайан', 'Bryan', 'TX', '77802', '30.6583', '-96.3238');
INSERT INTO `net_city` VALUES ('4130', '23', 'Юрика Спрингс', 'Eureka Springs', 'AR', '72632', '36.3690', '-93.7483');
INSERT INTO `net_city` VALUES ('4135', '23', 'Марлборо', 'Marlborough', 'MA', '01752', '42.3458', '-71.5506');
INSERT INTO `net_city` VALUES ('4136', '23', 'Уэйко', 'Waco', 'TX', '76706', '31.4789', '-97.0926');
INSERT INTO `net_city` VALUES ('4137', '23', 'Гилберт', 'Gilbert', 'AZ', '85233', '33.3462', '-111.8153');
INSERT INTO `net_city` VALUES ('4139', '23', 'Уимберли', 'Wimberley', 'TX', '78676', '30.0279', '-98.1179');
INSERT INTO `net_city` VALUES ('4141', '23', 'Поулсбо', 'Poulsbo', 'WA', '98370', '47.7537', '-122.6123');
INSERT INTO `net_city` VALUES ('4142', '23', 'Мабтон', 'Mabton', 'WA', '98935', '46.1516', '-120.0982');
INSERT INTO `net_city` VALUES ('4143', '23', 'Вэгонир', 'Wagoner', 'OK', '74467', '35.9612', '-95.3979');
INSERT INTO `net_city` VALUES ('4149', '23', 'Афтон', 'Afton', 'OK', '74331', '36.6296', '-94.9432');
INSERT INTO `net_city` VALUES ('4153', '23', 'Маунтлейк Террас', 'Mountlake Terrace', 'WA', '98043', '47.7936', '-122.3073');
INSERT INTO `net_city` VALUES ('4154', '23', 'Арлингтон', 'Arlington', 'WA', '98223', '48.1853', '-121.6778');
INSERT INTO `net_city` VALUES ('4155', '23', 'Мидленд', 'Midland', 'MI', '48674', '43.6129', '-84.1971');
INSERT INTO `net_city` VALUES ('4156', '23', 'Пеуоки', 'Pewaukee', 'WI', '53072', '43.0804', '-88.2592');
INSERT INTO `net_city` VALUES ('4157', '23', 'Ботелл', 'Bothell', 'WA', '98012', '47.8435', '-122.1957');
INSERT INTO `net_city` VALUES ('4159', '23', 'Хокиам', 'Hoquiam', 'WA', '98550', '47.1130', '-123.9651');
INSERT INTO `net_city` VALUES ('4160', '23', 'Чехалис', 'Chehalis', 'WA', '98532', '46.6271', '-123.0092');
INSERT INTO `net_city` VALUES ('4162', '23', 'Сноквалми', 'Snoqualmie', 'WA', '98065', '47.5336', '-121.7997');
INSERT INTO `net_city` VALUES ('4164', '23', 'Чанат', 'Chanute', 'KS', '66720', '37.6454', '-95.4630');
INSERT INTO `net_city` VALUES ('4165', '23', 'Саут-Портленд', 'South Portland', 'ME', '04106', '43.6253', '-70.2955');
INSERT INTO `net_city` VALUES ('4167', '23', 'Рошарон', 'Rosharon', 'TX', '77583', '29.4185', '-95.4525');
INSERT INTO `net_city` VALUES ('4168', '23', 'Кудахи', 'Cudahy', 'WI', '53110', '42.9480', '-87.8651');
INSERT INTO `net_city` VALUES ('4176', '23', 'Эдмондс', 'Edmonds', 'WA', '98020', '47.8060', '-122.3737');
INSERT INTO `net_city` VALUES ('4177', '23', 'Фонд дю Лак', 'Fond du Lac', 'WI', '54935', '43.7560', '-88.3666');
INSERT INTO `net_city` VALUES ('4180', '23', 'Дженисон', 'Jenison', 'MI', '49428', '42.9156', '-85.8464');
INSERT INTO `net_city` VALUES ('4181', '23', 'Бриджуотер', 'Bridgewater', 'NJ', '08807', '40.5953', '-74.6173');
INSERT INTO `net_city` VALUES ('4182', '23', 'Вудбридж', 'Woodbridge', 'NJ', '07095', '40.5525', '-74.2915');
INSERT INTO `net_city` VALUES ('4186', '23', 'Раритан', 'Raritan', 'NJ', '08869', '40.5715', '-74.6403');
INSERT INTO `net_city` VALUES ('4191', '23', 'Уоррен', 'Warren', 'NJ', '07059', '40.6308', '-74.5122');
INSERT INTO `net_city` VALUES ('4194', '23', 'Апопка', 'Apopka', 'FL', '32703', '28.6616', '-81.5307');
INSERT INTO `net_city` VALUES ('4195', '23', 'Кейпорт', 'Keyport', 'NJ', '07735', '40.4405', '-74.1754');
INSERT INTO `net_city` VALUES ('4196', '23', 'Санд Спрингс', 'Sand Springs', 'OK', '74063', '36.0797', '-96.2178');
INSERT INTO `net_city` VALUES ('4197', '23', 'Глен Гарднер', 'Glen Gardner', 'NJ', '08826', '40.7197', '-74.9057');
INSERT INTO `net_city` VALUES ('4198', '23', 'Филлипсберг', 'Phillipsburg', 'NJ', '08865', '40.6911', '-75.1756');
INSERT INTO `net_city` VALUES ('4200', '23', 'Норт Брансуик', 'North Brunswick', 'NJ', '08902', '40.4360', '-74.4850');
INSERT INTO `net_city` VALUES ('4203', '23', 'Сан Луис Обиспо', 'San Luis Obispo', 'CA', '93405', '35.2790', '-120.6968');
INSERT INTO `net_city` VALUES ('4204', '23', 'Сейрвилл', 'Sayreville', 'NJ', '08872', '40.4619', '-74.3561');
INSERT INTO `net_city` VALUES ('4208', '23', 'Нью Браунфелс', 'New Braunfels', 'TX', '78130', '29.7044', '-98.0742');
INSERT INTO `net_city` VALUES ('4210', '23', 'Уотсонвилл', 'Watsonville', 'CA', '95076', '36.9512', '-121.7240');
INSERT INTO `net_city` VALUES ('4211', '23', 'Тибодо', 'Thibodaux', 'LA', '70301', '29.8028', '-90.7974');
INSERT INTO `net_city` VALUES ('4216', '23', 'Саут Амбой', 'South Amboy', 'NJ', '08879', '40.4832', '-74.2881');
INSERT INTO `net_city` VALUES ('4219', '23', 'Олбани', 'Albany', 'GA', '31707', '31.5983', '-84.2127');
INSERT INTO `net_city` VALUES ('4221', '23', 'Ньюпорт-Ньюс', 'Newport News', 'VA', '23606', '37.0736', '-76.4936');
INSERT INTO `net_city` VALUES ('4223', '23', 'Поукипзи', 'Poughkeepsie', 'NY', '12601', '41.7038', '-73.9218');
INSERT INTO `net_city` VALUES ('4224', '23', 'Лейк Дженива', 'Lake Geneva', 'WI', '53147', '42.5747', '-88.3946');
INSERT INTO `net_city` VALUES ('4225', '23', 'Гластонбери', 'Glastonbury', 'CT', '06033', '41.7039', '-72.5461');
INSERT INTO `net_city` VALUES ('4226', '23', 'Фолмут', 'Falmouth', 'ME', '04105', '43.7516', '-70.2793');
INSERT INTO `net_city` VALUES ('4227', '31', 'Ла-Пас', 'La Paz', '04', '', '-16.5000', '-68.1500');
INSERT INTO `net_city` VALUES ('4228', '23', 'Ньюман', 'Newman', 'CA', '95360', '37.2843', '-121.2016');
INSERT INTO `net_city` VALUES ('4229', '23', 'Юнис', 'Eunice', 'LA', '70535', '30.4750', '-92.4220');
INSERT INTO `net_city` VALUES ('4230', '23', 'Хофман Эстейтс', 'Hoffman Estates', 'IL', '60179', '42.0793', '-88.2237');
INSERT INTO `net_city` VALUES ('4235', '23', 'Вунсокет', 'Woonsocket', 'RI', '02895', '41.9980', '-71.4941');
INSERT INTO `net_city` VALUES ('4236', '23', 'Марксвилл', 'Marksville', 'LA', '71351', '31.1838', '-92.0153');
INSERT INTO `net_city` VALUES ('4238', '23', 'Натчез', 'Natchez', 'MS', '39120', '31.5692', '-91.3289');
INSERT INTO `net_city` VALUES ('4241', '23', 'Маркетт', 'Marquette', 'MI', '49855', '46.6288', '-87.4796');
INSERT INTO `net_city` VALUES ('4242', '23', 'Уиллсборо', 'Willsboro', 'NY', '12996', '44.3765', '-73.4232');
INSERT INTO `net_city` VALUES ('4243', '23', 'Уотервлиет', 'Watervliet', 'NY', '12189', '42.7355', '-73.7204');
INSERT INTO `net_city` VALUES ('4244', '23', 'Квинсбери', 'Queensbury', 'NY', '12804', '43.3523', '-73.6898');
INSERT INTO `net_city` VALUES ('4245', '23', 'Амстердам', 'Amsterdam', 'NY', '12010', '42.9694', '-74.1224');
INSERT INTO `net_city` VALUES ('4247', '23', 'Керрвилл', 'Kerrville', 'TX', '78028', '30.0452', '-99.1682');
INSERT INTO `net_city` VALUES ('4250', '23', 'Карсон', 'Carson', 'CA', '90745', '33.8267', '-118.2607');
INSERT INTO `net_city` VALUES ('4254', '23', 'Авалон', 'Avalon', 'CA', '90704', '33.3890', '-118.4548');
INSERT INTO `net_city` VALUES ('4255', '23', 'Ла Палма', 'La Palma', 'CA', '90623', '33.8508', '-118.0436');
INSERT INTO `net_city` VALUES ('4260', '23', 'Бландон', 'Blandon', 'PA', '19510', '40.4563', '-75.8794');
INSERT INTO `net_city` VALUES ('4261', '23', 'Гардина', 'Gardena', 'CA', '90249', '33.8993', '-118.3169');
INSERT INTO `net_city` VALUES ('4263', '23', 'Лос Аламитос', 'Los Alamitos', 'CA', '90720', '33.7970', '-118.0624');
INSERT INTO `net_city` VALUES ('4266', '23', 'Уоллер', 'Waller', 'TX', '77484', '30.0894', '-95.9285');
INSERT INTO `net_city` VALUES ('4270', '23', 'Калман', 'Cullman', 'AL', '35055', '34.1543', '-86.7474');
INSERT INTO `net_city` VALUES ('4271', '23', 'Норуолк', 'Norwalk', 'CA', '90650', '33.9071', '-118.0767');
INSERT INTO `net_city` VALUES ('4274', '23', 'Редондо-Бич', 'Redondo Beach', 'CA', '90277', '33.8310', '-118.3875');
INSERT INTO `net_city` VALUES ('4279', '23', 'Ориндж', 'Orange', 'TX', '77630', '30.0566', '-93.8754');
INSERT INTO `net_city` VALUES ('4281', '23', 'Айрон Ривер', 'Iron River', 'MI', '49935', '46.1710', '-88.7371');
INSERT INTO `net_city` VALUES ('4282', '23', 'Бернем', 'Burnham', 'ME', '04922', '44.6929', '-69.3846');
INSERT INTO `net_city` VALUES ('4283', '23', 'Эпплтон', 'Appleton', 'WI', '54913', '44.3385', '-88.4042');
INSERT INTO `net_city` VALUES ('4284', '23', 'Меномони Фолс', 'Menomonee Falls', 'WI', '53051', '43.1486', '-88.1246');
INSERT INTO `net_city` VALUES ('4286', '23', 'Кеваскум', 'Kewaskum', 'WI', '53040', '43.5266', '-88.2014');
INSERT INTO `net_city` VALUES ('4287', '23', 'Нью Берлин', 'New Berlin', 'WI', '53151', '42.9734', '-88.1031');
INSERT INTO `net_city` VALUES ('4288', '23', 'Ошкош', 'Oshkosh', 'WI', '54902', '43.9669', '-88.5257');
INSERT INTO `net_city` VALUES ('4289', '23', 'Плезант Прейри', 'Pleasant Prairie', 'WI', '53158', '42.5292', '-87.8845');
INSERT INTO `net_city` VALUES ('4290', '23', 'Килгор', 'Kilgore', 'TX', '75662', '32.3801', '-94.8701');
INSERT INTO `net_city` VALUES ('4291', '23', 'Грин Бэй', 'Green Bay', 'WI', '54304', '44.4889', '-88.0704');
INSERT INTO `net_city` VALUES ('4292', '23', 'Вилла Парк', 'Villa Park', 'IL', '60181', '41.8816', '-87.9761');
INSERT INTO `net_city` VALUES ('4293', '23', 'Ок Крик', 'Oak Creek', 'WI', '53154', '42.8863', '-87.8883');
INSERT INTO `net_city` VALUES ('4294', '23', 'Браун Дир', 'Brown Deer', 'WI', '53092', '43.2214', '-87.9394');
INSERT INTO `net_city` VALUES ('4298', '23', 'Шебойган Фолс', 'Sheboygan Falls', 'WI', '53085', '43.7432', '-87.8511');
INSERT INTO `net_city` VALUES ('4300', '23', 'Эксетер', 'Exeter', 'CA', '93221', '36.2862', '-119.0310');
INSERT INTO `net_city` VALUES ('4301', '23', 'Шибойган', 'Sheboygan', 'WI', '53081', '43.7098', '-87.7478');
INSERT INTO `net_city` VALUES ('4304', '23', 'Окономовок', 'Oconomowoc', 'WI', '53066', '43.1160', '-88.5191');
INSERT INTO `net_city` VALUES ('4305', '23', 'Уэст Бенд', 'West Bend', 'WI', '53095', '43.3840', '-88.1637');
INSERT INTO `net_city` VALUES ('4306', '23', 'Манитовок', 'Manitowoc', 'WI', '54220', '44.1099', '-87.7100');
INSERT INTO `net_city` VALUES ('4310', '23', 'Хоутон', 'Houghton', 'MI', '49931', '47.1544', '-88.6471');
INSERT INTO `net_city` VALUES ('4313', '23', 'Редгранит', 'Redgranite', 'WI', '54970', '44.0693', '-89.0891');
INSERT INTO `net_city` VALUES ('4314', '23', 'Уэбстер', 'Webster', 'TX', '77598', '29.5489', '-95.1391');
INSERT INTO `net_city` VALUES ('4317', '23', 'Билокси', 'Biloxi', 'MS', '39530', '30.4052', '-88.8955');
INSERT INTO `net_city` VALUES ('4319', '23', 'Айронвуд', 'Ironwood', 'MI', '49938', '46.4823', '-90.1540');
INSERT INTO `net_city` VALUES ('4320', '23', 'Айрон Маунтин', 'Iron Mountain', 'MI', '49801', '45.9278', '-87.9944');
INSERT INTO `net_city` VALUES ('4321', '23', 'Кривиц', 'Crivitz', 'WI', '54114', '45.2474', '-88.1259');
INSERT INTO `net_city` VALUES ('4323', '23', 'Элмайра', 'Elmira', 'NY', '14901', '42.0830', '-76.7762');
INSERT INTO `net_city` VALUES ('4327', '23', 'Джейнсвилл', 'Janesville', 'WI', '53546', '42.6674', '-88.9455');
INSERT INTO `net_city` VALUES ('4329', '23', 'Ханфорд', 'Hanford', 'CA', '93230', '36.2760', '-119.6322');
INSERT INTO `net_city` VALUES ('4330', '23', 'Оконто', 'Oconto', 'WI', '54153', '44.8859', '-87.9407');
INSERT INTO `net_city` VALUES ('4338', '23', 'Атенс', 'Athens', 'GA', '30605', '33.9033', '-83.3306');
INSERT INTO `net_city` VALUES ('4341', '23', 'Меквонаго', 'Mukwonago', 'WI', '53149', '42.8886', '-88.3330');
INSERT INTO `net_city` VALUES ('4343', '23', 'Форт Аткинсон', 'Fort Atkinson', 'WI', '53538', '42.8987', '-88.7991');
INSERT INTO `net_city` VALUES ('4344', '23', 'Сассекс', 'Sussex', 'WI', '53089', '43.1488', '-88.2451');
INSERT INTO `net_city` VALUES ('4347', '23', 'Ист Трой', 'East Troy', 'WI', '53120', '42.7945', '-88.3994');
INSERT INTO `net_city` VALUES ('4354', '23', 'Медина', 'Medina', 'NY', '14103', '43.2176', '-78.3604');
INSERT INTO `net_city` VALUES ('4356', '23', 'Локпорт', 'Lockport', 'NY', '14094', '43.1751', '-78.7378');
INSERT INTO `net_city` VALUES ('4360', '23', 'Уэллсвилл', 'Wellsville', 'NY', '14895', '42.0908', '-77.9477');
INSERT INTO `net_city` VALUES ('4361', '23', 'Корри', 'Corry', 'PA', '16407', '41.9144', '-79.6474');
INSERT INTO `net_city` VALUES ('4362', '23', 'Ирвайн', 'Irvine', 'PA', '16329', '41.8665', '-79.2834');
INSERT INTO `net_city` VALUES ('4373', '23', 'Уоррен', 'Warren', 'PA', '16366', '41.8117', '-79.2643');
INSERT INTO `net_city` VALUES ('4374', '23', 'Белвидер', 'Belvidere', 'IL', '61008', '42.2491', '-88.8331');
INSERT INTO `net_city` VALUES ('4375', '23', 'Гранд Айленд', 'Grand Island', 'NY', '14072', '43.0109', '-78.9574');
INSERT INTO `net_city` VALUES ('4376', '23', 'Ангола', 'Angola', 'NY', '14006', '42.6326', '-79.0278');
INSERT INTO `net_city` VALUES ('4380', '23', 'Фредония', 'Fredonia', 'NY', '14063', '42.4080', '-79.3241');
INSERT INTO `net_city` VALUES ('4382', '23', 'Сайкстон', 'Sikeston', 'MO', '63801', '36.8985', '-89.5669');
INSERT INTO `net_city` VALUES ('4383', '23', 'Фелтон', 'Felton', 'DE', '19943', '39.0125', '-75.6051');
INSERT INTO `net_city` VALUES ('4387', '23', 'Фолферриас', 'Falfurrias', 'TX', '78355', '27.2062', '-98.2067');
INSERT INTO `net_city` VALUES ('4388', '23', 'Джонсборо', 'Jonesboro', 'AR', '72401', '35.8864', '-90.6425');
INSERT INTO `net_city` VALUES ('4389', '23', 'Кингсберг', 'Kingsburg', 'CA', '93631', '36.4830', '-119.5065');
INSERT INTO `net_city` VALUES ('4393', '23', 'Чатем', 'Chatham', 'NY', '12037', '42.3478', '-73.5549');
INSERT INTO `net_city` VALUES ('4394', '23', 'Малден', 'Malden', 'MO', '63863', '36.5640', '-89.9699');
INSERT INTO `net_city` VALUES ('4398', '23', 'Буэна Парк', 'Buena Park', 'CA', '90620', '33.8417', '-118.0076');
INSERT INTO `net_city` VALUES ('4405', '23', 'Ковина', 'Covina', 'CA', '91724', '34.0790', '-117.8494');
INSERT INTO `net_city` VALUES ('4406', '23', 'Роленд Хайтс', 'Rowland Heights', 'CA', '91748', '33.9782', '-117.9040');
INSERT INTO `net_city` VALUES ('4411', '23', 'Белтон', 'Belton', 'TX', '76513', '31.0450', '-97.5087');
INSERT INTO `net_city` VALUES ('4417', '23', 'Лейк Элзинор', 'Lake Elsinore', 'CA', '92530', '33.6848', '-117.3724');
INSERT INTO `net_city` VALUES ('4418', '23', 'Мишен Вьехо', 'Mission Viejo', 'CA', '92691', '33.6054', '-117.6675');
INSERT INTO `net_city` VALUES ('4420', '23', 'Чеви Чейз', 'Chevy Chase', 'MD', '20815', '38.9842', '-77.0842');
INSERT INTO `net_city` VALUES ('4422', '23', 'Фредерик', 'Frederick', 'MD', '21704', '39.3427', '-77.3782');
INSERT INTO `net_city` VALUES ('4425', '23', 'Сейнт Джозеф', 'Saint Joseph', 'MI', '49085', '42.0569', '-86.4563');
INSERT INTO `net_city` VALUES ('4429', '23', 'Мидлберг', 'Middleburg', 'VA', '20117', '38.9843', '-77.7489');
INSERT INTO `net_city` VALUES ('4430', '23', 'Нью Маркет', 'New Market', 'MD', '21774', '39.4117', '-77.2704');
INSERT INTO `net_city` VALUES ('4433', '23', 'Белтсвилл', 'Beltsville', 'MD', '20705', '39.0504', '-76.9055');
INSERT INTO `net_city` VALUES ('4434', '23', 'Инвуд', 'Inwood', 'WV', '25428', '39.3796', '-78.0202');
INSERT INTO `net_city` VALUES ('4435', '23', 'Джермантаун', 'Germantown', 'MD', '20876', '39.2070', '-77.2380');
INSERT INTO `net_city` VALUES ('4436', '23', 'Беркли Спрингс', 'Berkeley Springs', 'WV', '25411', '39.5436', '-78.2140');
INSERT INTO `net_city` VALUES ('4438', '23', 'Мирамар Бич', 'Miramar Beach', 'FL', '32550', '30.3909', '-86.3161');
INSERT INTO `net_city` VALUES ('4439', '23', 'Гринбелт', 'Greenbelt', 'MD', '20770', '39.0027', '-76.8807');
INSERT INTO `net_city` VALUES ('4441', '23', 'Блуфилд', 'Bluefield', 'VA', '24605', '37.2281', '-81.3092');
INSERT INTO `net_city` VALUES ('4443', '23', 'Уитсетт', 'Whitsett', 'NC', '27377', '36.0413', '-79.6064');
INSERT INTO `net_city` VALUES ('4446', '23', 'Клеммонс', 'Clemmons', 'NC', '27012', '36.0079', '-80.3697');
INSERT INTO `net_city` VALUES ('4448', '23', 'Даффилд', 'Duffield', 'VA', '24244', '36.7372', '-82.8075');
INSERT INTO `net_city` VALUES ('4451', '23', 'Итманн', 'Itmann', 'WV', '24847', '37.5735', '-81.4182');
INSERT INTO `net_city` VALUES ('4452', '23', 'Финкасл', 'Fincastle', 'VA', '24090', '37.5115', '-79.8846');
INSERT INTO `net_city` VALUES ('4454', '23', 'Иден', 'Eden', 'NC', '27288', '36.5054', '-79.7394');
INSERT INTO `net_city` VALUES ('4455', '23', 'Хондо', 'Hondo', 'TX', '78861', '29.3877', '-99.1683');
INSERT INTO `net_city` VALUES ('4456', '23', 'Лихополис', 'Lithopolis', 'OH', '43136', '39.8028', '-82.8063');
INSERT INTO `net_city` VALUES ('4457', '23', 'Сейлем', 'Salem', 'VA', '24153', '37.2906', '-80.1014');
INSERT INTO `net_city` VALUES ('4459', '23', 'Коберн', 'Coeburn', 'VA', '24230', '36.9810', '-82.4886');
INSERT INTO `net_city` VALUES ('4461', '23', 'Мортон', 'Morton', 'MS', '39117', '32.2967', '-89.6665');
INSERT INTO `net_city` VALUES ('4464', '23', 'Ашеборо', 'Asheboro', 'NC', '27204', '35.7079', '-79.8136');
INSERT INTO `net_city` VALUES ('4467', '23', 'Адванс', 'Advance', 'NC', '27006', '35.9446', '-80.4391');
INSERT INTO `net_city` VALUES ('4468', '23', 'Бёрлингтон', 'Burlington', 'NC', '27215', '35.9894', '-79.5047');
INSERT INTO `net_city` VALUES ('4469', '23', 'Харлинген', 'Harlingen', 'TX', '78550', '26.2454', '-97.6836');
INSERT INTO `net_city` VALUES ('4472', '23', 'Фенуик', 'Fenwick', 'WV', '26202', '38.2240', '-80.6275');
INSERT INTO `net_city` VALUES ('4473', '23', 'Кернерсвилл', 'Kernersville', 'NC', '27284', '36.1172', '-80.0765');
INSERT INTO `net_city` VALUES ('4476', '23', 'Принстон', 'Princeton', 'WV', '24740', '37.3910', '-81.0417');
INSERT INTO `net_city` VALUES ('4477', '23', 'Радфорд', 'Radford', 'VA', '24141', '37.0866', '-80.5439');
INSERT INTO `net_city` VALUES ('4479', '23', 'Крисченсберг', 'Christiansburg', 'VA', '24073', '37.1035', '-80.4207');
INSERT INTO `net_city` VALUES ('4482', '23', 'Бейкер-Сити', 'Baker City', 'OR', '97814', '44.8141', '-117.7453');
INSERT INTO `net_city` VALUES ('4484', '23', 'Декатур', 'Decatur', 'TX', '76234', '33.2859', '-97.5127');
INSERT INTO `net_city` VALUES ('4485', '23', 'Санди Ридж', 'Sandy Ridge', 'NC', '27046', '36.4802', '-80.0972');
INSERT INTO `net_city` VALUES ('4486', '23', 'Грунди', 'Grundy', 'VA', '24614', '37.3137', '-82.0522');
INSERT INTO `net_city` VALUES ('4487', '23', 'Уэст Джефферсон', 'West Jefferson', 'NC', '28694', '36.3546', '-81.4728');
INSERT INTO `net_city` VALUES ('4489', '23', 'Уайз', 'Wise', 'VA', '24293', '37.0024', '-82.5772');
INSERT INTO `net_city` VALUES ('4491', '23', 'Мартинсвилл', 'Martinsville', 'VA', '24112', '36.7266', '-79.8667');
INSERT INTO `net_city` VALUES ('4492', '23', 'Эллистон', 'Elliston', 'VA', '24087', '37.2265', '-80.2537');
INSERT INTO `net_city` VALUES ('4494', '23', 'Уичито-Фолс', 'Wichita Falls', 'TX', '76308', '33.8466', '-98.5301');
INSERT INTO `net_city` VALUES ('4495', '23', 'Кинг', 'King', 'NC', '27021', '36.3220', '-80.3379');
INSERT INTO `net_city` VALUES ('4497', '23', 'Роки Маунт', 'Rocky Mount', 'VA', '24151', '36.9518', '-79.8592');
INSERT INTO `net_city` VALUES ('4504', '23', 'Салинас', 'Salinas', 'CA', '93901', '36.6478', '-121.6259');
INSERT INTO `net_city` VALUES ('4507', '23', 'Ридли', 'Reedley', 'CA', '93654', '36.6590', '-119.4065');
INSERT INTO `net_city` VALUES ('4509', '23', 'Мадера', 'Madera', 'CA', '93637', '36.9127', '-120.1956');
INSERT INTO `net_city` VALUES ('4510', '23', 'Форт Силл', 'Fort Sill', 'OK', '73503', '34.6813', '-98.4925');
INSERT INTO `net_city` VALUES ('4515', '23', 'Фэрли', 'Fairlee', 'VT', '05045', '43.9167', '-72.1881');
INSERT INTO `net_city` VALUES ('4516', '23', 'Чикаша', 'Chickasha', 'OK', '73018', '35.0583', '-97.9347');
INSERT INTO `net_city` VALUES ('4517', '23', 'Оберн', 'Auburn', 'AL', '36830', '32.5329', '-85.5078');
INSERT INTO `net_city` VALUES ('4520', '23', 'Коркоран', 'Corcoran', 'CA', '93212', '36.0787', '-119.5364');
INSERT INTO `net_city` VALUES ('4523', '23', 'Портервилл', 'Porterville', 'CA', '93257', '35.9678', '-118.9199');
INSERT INTO `net_city` VALUES ('4528', '23', 'Шони', 'Shawnee', 'OK', '74801', '35.3143', '-96.9660');
INSERT INTO `net_city` VALUES ('4532', '23', 'Фоулер', 'Fowler', 'CA', '93625', '36.6221', '-119.6716');
INSERT INTO `net_city` VALUES ('4534', '23', 'Стьюарт', 'Stuart', 'FL', '34994', '27.1797', '-80.2430');
INSERT INTO `net_city` VALUES ('4539', '23', 'Колфакс', 'Colfax', 'CA', '95713', '39.0904', '-120.9294');
INSERT INTO `net_city` VALUES ('4550', '23', 'Каньон', 'Canyon', 'TX', '79015', '34.9511', '-101.8972');
INSERT INTO `net_city` VALUES ('4551', '23', 'Уилмингтон', 'Wilmington', 'NC', '28405', '34.2725', '-77.8585');
INSERT INTO `net_city` VALUES ('4553', '23', 'Брадли', 'Bradley', 'IL', '60915', '41.1492', '-87.8608');
INSERT INTO `net_city` VALUES ('4559', '23', 'Роанок Рапидс', 'Roanoke Rapids', 'NC', '27870', '36.4290', '-77.7247');
INSERT INTO `net_city` VALUES ('4560', '23', 'Хендерсон', 'Henderson', 'NC', '27536', '36.3301', '-78.4083');
INSERT INTO `net_city` VALUES ('4562', '23', 'Джефферсонвилл', 'Jeffersonville', 'IN', '47130', '38.3283', '-85.6957');
INSERT INTO `net_city` VALUES ('4565', '23', 'Данвилл', 'Danville', 'KY', '40422', '37.6454', '-84.8171');
INSERT INTO `net_city` VALUES ('4568', '23', 'Луизбург', 'Louisburg', 'NC', '27549', '36.0902', '-78.2154');
INSERT INTO `net_city` VALUES ('4569', '23', 'Розвилл', 'Roseville', 'CA', '95661', '38.7439', '-121.2558');
INSERT INTO `net_city` VALUES ('4570', '23', 'Трейси', 'Tracy', 'CA', '95304', '37.6968', '-121.3981');
INSERT INTO `net_city` VALUES ('4573', '23', 'Силер Сити', 'Siler City', 'NC', '27344', '35.7172', '-79.4460');
INSERT INTO `net_city` VALUES ('4577', '23', 'Смитфилд', 'Smithfield', 'NC', '27577', '35.4813', '-78.3514');
INSERT INTO `net_city` VALUES ('4579', '23', 'Бун', 'Boone', 'NC', '28607', '36.2191', '-81.6563');
INSERT INTO `net_city` VALUES ('4580', '23', 'Апекс', 'Apex', 'NC', '27502', '35.7114', '-78.8862');
INSERT INTO `net_city` VALUES ('4583', '23', 'Шаллотт', 'Shallotte', 'NC', '28470', '33.9814', '-78.4121');
INSERT INTO `net_city` VALUES ('4585', '23', 'Траки', 'Truckee', 'CA', '96161', '39.3338', '-120.2490');
INSERT INTO `net_city` VALUES ('4586', '23', 'Леланд', 'Leland', 'NC', '28451', '34.2432', '-78.0996');
INSERT INTO `net_city` VALUES ('4587', '23', 'Макаллен', 'McAllen', 'TX', '78501', '26.2199', '-98.2390');
INSERT INTO `net_city` VALUES ('4589', '23', 'Лейк Парк', 'Lake Park', 'GA', '31636', '30.7519', '-83.0856');
INSERT INTO `net_city` VALUES ('4590', '23', 'Хоп Милс', 'Hope Mills', 'NC', '28348', '34.9273', '-78.9093');
INSERT INTO `net_city` VALUES ('4592', '23', 'Джонсон Сити', 'Johnson City', 'NY', '13790', '42.1651', '-76.0048');
INSERT INTO `net_city` VALUES ('4595', '23', 'Сансет Бич', 'Sunset Beach', 'NC', '28468', '33.9269', '-78.5219');
INSERT INTO `net_city` VALUES ('4596', '23', 'Напа', 'Napa', 'CA', '94558', '38.5575', '-122.1554');
INSERT INTO `net_city` VALUES ('4597', '23', 'Пайнхерст', 'Pinehurst', 'NC', '28374', '35.1936', '-79.4613');
INSERT INTO `net_city` VALUES ('4598', '23', 'Корпус-Кристи', 'Corpus Christi', 'TX', '78416', '27.7479', '-97.4435');
INSERT INTO `net_city` VALUES ('4600', '23', 'Кантон', 'Canton', 'GA', '30114', '34.2577', '-84.4921');
INSERT INTO `net_city` VALUES ('4607', '23', 'Монтебелло', 'Montebello', 'CA', '90640', '34.0092', '-118.1083');
INSERT INTO `net_city` VALUES ('4610', '23', 'Аркадия', 'Arcadia', 'CA', '91006', '34.1379', '-118.0259');
INSERT INTO `net_city` VALUES ('4611', '23', 'Реддинг', 'Redding', 'CA', '96003', '40.6872', '-122.2593');
INSERT INTO `net_city` VALUES ('4617', '23', 'Дэвис', 'Davis', 'CA', '95616', '38.4829', '-121.6398');
INSERT INTO `net_city` VALUES ('4619', '23', 'Инклайн Виллидж', 'Incline Village', 'NV', '89451', '39.2413', '-119.9292');
INSERT INTO `net_city` VALUES ('4620', '23', 'Брукс', 'Brooks', 'CA', '95606', '38.8081', '-122.1808');
INSERT INTO `net_city` VALUES ('4621', '23', 'Зефир Ков', 'Zephyr Cove', 'NV', '89448', '39.0021', '-119.9560');
INSERT INTO `net_city` VALUES ('4622', '23', 'Арбакл', 'Arbuckle', 'CA', '95912', '39.0274', '-122.0440');
INSERT INTO `net_city` VALUES ('4624', '23', 'Минден', 'Minden', 'NV', '89423', '39.0152', '-119.7506');
INSERT INTO `net_city` VALUES ('4625', '23', 'Диксон', 'Dixon', 'CA', '95620', '38.3900', '-121.8180');
INSERT INTO `net_city` VALUES ('4626', '23', 'Дженоа', 'Genoa', 'NV', '89411', '39.0044', '-119.8471');
INSERT INTO `net_city` VALUES ('4630', '23', 'Уивервилл', 'Weaverville', 'CA', '96093', '40.7438', '-122.9362');
INSERT INTO `net_city` VALUES ('4632', '23', 'Джорджтаун', 'Georgetown', 'SC', '29440', '33.3615', '-79.2759');
INSERT INTO `net_city` VALUES ('4635', '23', 'Норвуд', 'Norwood', 'MA', '02062', '42.1818', '-71.1962');
INSERT INTO `net_city` VALUES ('4639', '23', 'Уэст Колумбия', 'West Columbia', 'SC', '29170', '33.9348', '-81.1444');
INSERT INTO `net_city` VALUES ('4640', '23', 'Флоренс', 'Florence', 'SC', '29501', '34.2125', '-79.8206');
INSERT INTO `net_city` VALUES ('4642', '23', 'Суонси', 'Swansea', 'SC', '29160', '33.7458', '-81.0665');
INSERT INTO `net_city` VALUES ('4643', '23', 'Лексингтон', 'Lexington', 'SC', '29073', '33.9075', '-81.2301');
INSERT INTO `net_city` VALUES ('4644', '23', 'Монкс Корнер', 'Moncks Corner', 'SC', '29461', '33.1180', '-80.0384');
INSERT INTO `net_city` VALUES ('4646', '23', 'Стейтлайн', 'Stateline', 'NV', '89449', '38.9624', '-119.9399');
INSERT INTO `net_city` VALUES ('4647', '23', 'Пажленд', 'Pageland', 'SC', '29728', '34.7487', '-80.4104');
INSERT INTO `net_city` VALUES ('4649', '23', 'Ауэндо', 'Awendaw', 'SC', '29429', '33.0010', '-79.6859');
INSERT INTO `net_city` VALUES ('4650', '23', 'Гровтаун', 'Grovetown', 'GA', '30813', '33.4621', '-82.2220');
INSERT INTO `net_city` VALUES ('4653', '23', 'Нью Порт Ричи', 'New Port Richey', 'FL', '34652', '28.2397', '-82.7388');
INSERT INTO `net_city` VALUES ('4654', '23', 'Гранитевилл', 'Graniteville', 'SC', '29829', '33.5716', '-81.8422');
INSERT INTO `net_city` VALUES ('4655', '23', 'Оринджберг', 'Orangeburg', 'SC', '29115', '33.4885', '-80.8559');
INSERT INTO `net_city` VALUES ('4656', '23', 'Бристоль', 'Bristol', 'TN', '37620', '36.5406', '-82.1757');
INSERT INTO `net_city` VALUES ('4663', '23', 'Бофорт', 'Beaufort', 'SC', '29906', '32.4389', '-80.7466');
INSERT INTO `net_city` VALUES ('4665', '23', 'Андерсон', 'Anderson', 'SC', '29624', '34.4327', '-82.6272');
INSERT INTO `net_city` VALUES ('4667', '23', 'Тиммонсвилл', 'Timmonsville', 'SC', '29161', '34.1097', '-79.9427');
INSERT INTO `net_city` VALUES ('4668', '23', 'Фармингдейл', 'Farmingdale', 'NY', '11735', '40.7334', '-73.4281');
INSERT INTO `net_city` VALUES ('4669', '23', 'Уоллкилл', 'Wallkill', 'NY', '12589', '41.6178', '-74.1060');
INSERT INTO `net_city` VALUES ('4671', '23', 'Полис Айленд', 'Pawleys Island', 'SC', '29585', '33.4425', '-79.1588');
INSERT INTO `net_city` VALUES ('4672', '23', 'Джонс Айленд', 'Johns Island', 'SC', '29455', '32.6725', '-80.0970');
INSERT INTO `net_city` VALUES ('4674', '23', 'Френчтаун', 'Frenchtown', 'NJ', '08825', '40.5144', '-75.0127');
INSERT INTO `net_city` VALUES ('4675', '23', 'Томсон', 'Thomson', 'GA', '30824', '33.4966', '-82.5286');
INSERT INTO `net_city` VALUES ('4676', '23', 'Камас', 'Camas', 'WA', '98607', '45.6452', '-122.3789');
INSERT INTO `net_city` VALUES ('4682', '23', 'Санта-Крус', 'Santa Cruz', 'CA', '95060', '37.0448', '-122.1021');
INSERT INTO `net_city` VALUES ('4683', '23', 'Робертсдейл', 'Robertsdale', 'AL', '36567', '30.6121', '-87.5653');
INSERT INTO `net_city` VALUES ('4684', '23', 'Спаркс', 'Sparks', 'NV', '89431', '39.5398', '-119.7386');
INSERT INTO `net_city` VALUES ('4685', '23', 'Пейнсвилл', 'Painesville', 'OH', '44077', '41.6972', '-81.1974');
INSERT INTO `net_city` VALUES ('4688', '23', 'Кадьяк', 'Kodiak', 'AK', '99615', '57.7900', '-152.4072');
INSERT INTO `net_city` VALUES ('4691', '23', 'Кетчикан', 'Ketchikan', 'AK', '99901', '55.6153', '-131.5848');
INSERT INTO `net_city` VALUES ('4693', '23', 'Барроу', 'Barrow', 'AK', '99723', '71.2850', '-156.7819');
INSERT INTO `net_city` VALUES ('4694', '23', 'Гердвуд', 'Girdwood', 'AK', '99587', '60.9026', '-148.9191');
INSERT INTO `net_city` VALUES ('4695', '23', 'Рокуэй', 'Rockaway', 'NJ', '07866', '40.9590', '-74.4973');
INSERT INTO `net_city` VALUES ('4696', '23', 'Флорхем Парк', 'Florham Park', 'NJ', '07932', '40.7747', '-74.3980');
INSERT INTO `net_city` VALUES ('4697', '23', 'Бадд Лейк', 'Budd Lake', 'NJ', '07828', '40.8838', '-74.7560');
INSERT INTO `net_city` VALUES ('4700', '23', 'Ла Виста', 'La Vista', 'NE', '68128', '41.1765', '-96.0613');
INSERT INTO `net_city` VALUES ('4701', '23', 'Музик', 'Moosic', 'PA', '18507', '41.3610', '-75.6731');
INSERT INTO `net_city` VALUES ('4702', '23', 'Уайт Хейвен', 'White Haven', 'PA', '18661', '41.0942', '-75.7546');
INSERT INTO `net_city` VALUES ('4703', '23', 'Кларкс Саммит', 'Clarks Summit', 'PA', '18411', '41.4486', '-75.7280');
INSERT INTO `net_city` VALUES ('4704', '23', 'Скрентон', 'Scranton', 'PA', '18508', '41.4503', '-75.6582');
INSERT INTO `net_city` VALUES ('4707', '23', 'Денвилл', 'Denville', 'NJ', '07834', '40.8841', '-74.4863');
INSERT INTO `net_city` VALUES ('4708', '23', 'Уилкс-Барре', 'Wilkes-Barre', 'PA', '18706', '41.2029', '-75.9027');
INSERT INTO `net_city` VALUES ('4710', '23', 'Сентер Валли', 'Center Valley', 'PA', '18034', '40.5449', '-75.4026');
INSERT INTO `net_city` VALUES ('4712', '23', 'Манкейто', 'Mankato', 'MN', '56001', '44.1308', '-94.0000');
INSERT INTO `net_city` VALUES ('4714', '23', 'Уильямспорт', 'Williamsport', 'MD', '21795', '39.5791', '-77.8240');
INSERT INTO `net_city` VALUES ('4715', '23', 'Матаван', 'Matawan', 'NJ', '07747', '40.4169', '-74.2579');
INSERT INTO `net_city` VALUES ('4716', '23', 'Хамлин', 'Hamlin', 'PA', '18427', '41.4427', '-75.2583');
INSERT INTO `net_city` VALUES ('4717', '23', 'Пипак', 'Peapack', 'NJ', '07977', '40.7168', '-74.6565');
INSERT INTO `net_city` VALUES ('4719', '23', 'Ист Хановер', 'East Hanover', 'NJ', '07936', '40.8240', '-74.3687');
INSERT INTO `net_city` VALUES ('4720', '23', 'Уиппани', 'Whippany', 'NJ', '07981', '40.8229', '-74.4197');
INSERT INTO `net_city` VALUES ('4721', '23', 'Эббивилл', 'Abbeville', 'LA', '70510', '29.9124', '-92.2110');
INSERT INTO `net_city` VALUES ('4722', '23', 'Лейк Ариель', 'Lake Ariel', 'PA', '18436', '41.4349', '-75.4124');
INSERT INTO `net_city` VALUES ('4723', '23', 'Ричленд', 'Richland', 'WA', '99352', '46.3282', '-119.3222');
INSERT INTO `net_city` VALUES ('4725', '23', 'Баскинг Ридж', 'Basking Ridge', 'NJ', '07920', '40.6761', '-74.5730');
INSERT INTO `net_city` VALUES ('4726', '23', 'Ист-Хартфорд', 'East Hartford', 'CT', '06108', '41.7776', '-72.6214');
INSERT INTO `net_city` VALUES ('4727', '23', 'Бруксайд', 'Brookside', 'NJ', '07926', '40.7943', '-74.5679');
INSERT INTO `net_city` VALUES ('4728', '23', 'Ла Порт', 'La Porte', 'IN', '46350', '41.6206', '-86.7341');
INSERT INTO `net_city` VALUES ('4730', '23', 'Хазлтон', 'Hazleton', 'PA', '18201', '40.9395', '-75.9695');
INSERT INTO `net_city` VALUES ('4733', '23', 'Перселлвилл', 'Purcellville', 'VA', '20132', '39.1796', '-77.7326');
INSERT INTO `net_city` VALUES ('4734', '23', 'Олни', 'Olney', 'MD', '20832', '39.1535', '-77.0753');
INSERT INTO `net_city` VALUES ('4736', '23', 'Хок Пойнт', 'Hawk Point', 'MO', '63349', '38.9797', '-91.1476');
INSERT INTO `net_city` VALUES ('4737', '23', 'Потсвилл', 'Pottsville', 'PA', '17901', '40.6895', '-76.1958');
INSERT INTO `net_city` VALUES ('4738', '23', 'Тованда', 'Towanda', 'PA', '18848', '41.7276', '-76.4601');
INSERT INTO `net_city` VALUES ('4740', '23', 'Пайн Брук', 'Pine Brook', 'NJ', '07058', '40.8658', '-74.3402');
INSERT INTO `net_city` VALUES ('4747', '23', 'Спрингтаун', 'Springtown', 'TX', '76082', '32.9559', '-97.7144');
INSERT INTO `net_city` VALUES ('4748', '23', 'Борджер', 'Borger', 'TX', '79007', '35.6802', '-101.4310');
INSERT INTO `net_city` VALUES ('4749', '23', 'Хьюитт', 'Hewitt', 'TX', '76643', '31.4507', '-97.1909');
INSERT INTO `net_city` VALUES ('4752', '23', 'Абилин', 'Abilene', 'TX', '79603', '32.3418', '-99.9414');
INSERT INTO `net_city` VALUES ('4754', '23', 'Вудуэй', 'Woodway', 'TX', '76712', '31.5105', '-97.2645');
INSERT INTO `net_city` VALUES ('4756', '23', 'Дефорест', 'DeForest', 'WI', '53532', '43.2382', '-89.3365');
INSERT INTO `net_city` VALUES ('4760', '23', 'Азл', 'Azle', 'TX', '76020', '32.9024', '-97.5891');
INSERT INTO `net_city` VALUES ('4764', '23', 'Клберн', 'Cleburne', 'TX', '76033', '32.2847', '-97.5392');
INSERT INTO `net_city` VALUES ('4766', '23', 'Ледьярд', 'Ledyard', 'CT', '06339', '41.4443', '-71.9996');
INSERT INTO `net_city` VALUES ('4767', '23', 'Халберт', 'Hulbert', 'OK', '74441', '35.9709', '-95.1441');
INSERT INTO `net_city` VALUES ('4768', '23', 'Окмулги', 'Okmulgee', 'OK', '74447', '35.6602', '-95.9884');
INSERT INTO `net_city` VALUES ('4769', '23', 'Абернати', 'Abernathy', 'TX', '79311', '33.8828', '-101.8891');
INSERT INTO `net_city` VALUES ('4770', '23', 'Сиско', 'Cisco', 'TX', '76437', '32.3932', '-99.0193');
INSERT INTO `net_city` VALUES ('4773', '23', 'Ламеса', 'Lamesa', 'TX', '79331', '32.6739', '-101.9501');
INSERT INTO `net_city` VALUES ('4774', '23', 'Перри', 'Perry', 'OK', '73077', '36.3041', '-97.2824');
INSERT INTO `net_city` VALUES ('4777', '23', 'Джонс', 'Jones', 'OK', '73049', '35.5893', '-97.2959');
INSERT INTO `net_city` VALUES ('4778', '23', 'Карнеги', 'Carnegie', 'PA', '15106', '40.4067', '-80.1108');
INSERT INTO `net_city` VALUES ('4780', '23', 'Юнионтаун', 'Uniontown', 'PA', '15401', '39.8937', '-79.7492');
INSERT INTO `net_city` VALUES ('4782', '23', 'Фростберг', 'Frostburg', 'MD', '21532', '39.6408', '-78.9680');
INSERT INTO `net_city` VALUES ('4783', '23', 'Эбенсберг', 'Ebensburg', 'PA', '15931', '40.5084', '-78.7846');
INSERT INTO `net_city` VALUES ('4784', '23', 'Латроб', 'Latrobe', 'PA', '15650', '40.2837', '-79.3821');
INSERT INTO `net_city` VALUES ('4786', '23', 'Джонстаун', 'Johnstown', 'PA', '15905', '40.2923', '-78.9834');
INSERT INTO `net_city` VALUES ('4787', '23', 'Уэертон', 'Weirton', 'WV', '26062', '40.4224', '-80.5739');
INSERT INTO `net_city` VALUES ('4788', '23', 'Портерсвилл', 'Portersville', 'PA', '16051', '40.9429', '-80.1470');
INSERT INTO `net_city` VALUES ('4791', '23', 'Лойалханна', 'Loyalhanna', 'PA', '15661', '40.3192', '-79.3545');
INSERT INTO `net_city` VALUES ('4792', '23', 'Форд Сити', 'Ford City', 'PA', '16226', '40.7105', '-79.4774');
INSERT INTO `net_city` VALUES ('4793', '23', 'Грантсвилл', 'Grantsville', 'MD', '21536', '39.6392', '-79.1970');
INSERT INTO `net_city` VALUES ('4795', '23', 'Бедфорд', 'Bedford', 'PA', '15522', '39.9411', '-78.5678');
INSERT INTO `net_city` VALUES ('4796', '23', 'Нью Канаан', 'New Canaan', 'CT', '06840', '41.1625', '-73.5021');
INSERT INTO `net_city` VALUES ('4797', '23', 'Невада Сити', 'Nevada City', 'CA', '95959', '39.3496', '-120.8766');
INSERT INTO `net_city` VALUES ('4798', '23', 'Страсберг', 'Strasburg', 'PA', '17579', '39.9620', '-76.1786');
INSERT INTO `net_city` VALUES ('4801', '23', 'Вудклифф Лейк', 'Woodcliff Lake', 'NJ', '07677', '41.0299', '-74.0548');
INSERT INTO `net_city` VALUES ('4803', '23', 'Эймс', 'Ames', 'IA', '50010', '42.0300', '-93.5905');
INSERT INTO `net_city` VALUES ('4805', '23', 'Титусвилл', 'Titusville', 'PA', '16354', '41.6258', '-79.6964');
INSERT INTO `net_city` VALUES ('4807', '23', 'Хермитедж', 'Hermitage', 'PA', '16148', '41.2292', '-80.4244');
INSERT INTO `net_city` VALUES ('4808', '23', 'Клэртон', 'Clairton', 'PA', '15025', '40.3010', '-79.9242');
INSERT INTO `net_city` VALUES ('4809', '23', 'Ирвин', 'Irwin', 'PA', '15642', '40.3178', '-79.7177');
INSERT INTO `net_city` VALUES ('4810', '23', 'Ойл Сити', 'Oil City', 'PA', '16301', '41.4671', '-79.6673');
INSERT INTO `net_city` VALUES ('4813', '23', 'Марс', 'Mars', 'PA', '16046', '40.6990', '-80.0334');
INSERT INTO `net_city` VALUES ('4817', '23', 'Вашингтон', 'Washington', 'PA', '15301', '40.1582', '-80.2553');
INSERT INTO `net_city` VALUES ('4819', '23', 'Сомерсет', 'Somerset', 'PA', '15501', '40.0379', '-79.1204');
INSERT INTO `net_city` VALUES ('4821', '23', 'Кларксберг', 'Clarksburg', 'WV', '26301', '39.2824', '-80.3687');
INSERT INTO `net_city` VALUES ('4822', '23', 'Петролия', 'Petrolia', 'PA', '16050', '41.0431', '-79.7747');
INSERT INTO `net_city` VALUES ('4823', '23', 'Мидвилл', 'Meadville', 'PA', '16335', '41.6465', '-80.1733');
INSERT INTO `net_city` VALUES ('4824', '23', 'Уэст Мидлсекс', 'West Middlesex', 'PA', '16159', '41.1560', '-80.4838');
INSERT INTO `net_city` VALUES ('4825', '23', 'Лайнсвилл', 'Linesville', 'PA', '16424', '41.6591', '-80.4168');
INSERT INTO `net_city` VALUES ('4826', '23', 'Ньюкомерстаун', 'Newcomerstown', 'OH', '43832', '40.2367', '-81.5734');
INSERT INTO `net_city` VALUES ('4827', '23', 'Уэст Ковина', 'West Covina', 'CA', '91790', '34.0699', '-117.9421');
INSERT INTO `net_city` VALUES ('4828', '23', 'Вустер', 'Worcester', 'MA', '01608', '42.2618', '-71.8028');
INSERT INTO `net_city` VALUES ('4833', '23', 'Лейк Форест', 'Lake Forest', 'CA', '92630', '33.6451', '-117.6786');
INSERT INTO `net_city` VALUES ('4835', '23', 'Мэйсвилл', 'Maysville', 'OK', '73057', '34.8372', '-97.4230');
INSERT INTO `net_city` VALUES ('4838', '23', 'Гарден Сити', 'Garden City', 'KS', '67846', '38.0439', '-100.7561');
INSERT INTO `net_city` VALUES ('4840', '23', 'Херефорд', 'Hereford', 'TX', '79045', '34.8423', '-102.5446');
INSERT INTO `net_city` VALUES ('4841', '23', 'Марлоу', 'Marlow', 'OK', '73055', '34.6451', '-97.9036');
INSERT INTO `net_city` VALUES ('4844', '23', 'Коффивилл', 'Coffeyville', 'KS', '67337', '37.0730', '-95.6184');
INSERT INTO `net_city` VALUES ('4850', '23', 'Хелдтон', 'Healdton', 'OK', '73438', '34.2745', '-97.4923');
INSERT INTO `net_city` VALUES ('4851', '23', 'Ратлифф Сити', 'Ratliff City', 'OK', '73481', '34.4284', '-97.4925');
INSERT INTO `net_city` VALUES ('4858', '23', 'Типтон', 'Tipton', 'OK', '73570', '34.4925', '-99.0808');
INSERT INTO `net_city` VALUES ('4860', '23', 'Ада', 'Ada', 'OK', '74820', '34.8058', '-96.7046');
INSERT INTO `net_city` VALUES ('4863', '23', 'Эдмонт', 'Edmond', 'OK', '73013', '35.6165', '-97.4789');
INSERT INTO `net_city` VALUES ('4865', '23', 'Браунвуд', 'Brownwood', 'TX', '76801', '31.6393', '-98.9770');
INSERT INTO `net_city` VALUES ('4866', '23', 'Карол Стрим', 'Carol Stream', 'IL', '60188', '41.9153', '-88.1287');
INSERT INTO `net_city` VALUES ('4870', '23', 'Сикамор', 'Sycamore', 'IL', '60178', '42.0106', '-88.6671');
INSERT INTO `net_city` VALUES ('4873', '23', 'Райт Сити', 'Wright City', 'MO', '63390', '38.8008', '-91.0487');
INSERT INTO `net_city` VALUES ('4875', '23', 'Ганнибал', 'Hannibal', 'MO', '63401', '39.6834', '-91.4364');
INSERT INTO `net_city` VALUES ('4876', '23', 'Альтон', 'Alton', 'IL', '62002', '38.9455', '-90.1282');
INSERT INTO `net_city` VALUES ('4877', '23', 'Бриз', 'Breese', 'IL', '62230', '38.6464', '-89.5225');
INSERT INTO `net_city` VALUES ('4878', '23', 'Сейнт Питерс', 'Saint Peters', 'MO', '63376', '38.8022', '-90.6270');
INSERT INTO `net_city` VALUES ('4884', '23', 'Осейдж Бич', 'Osage Beach', 'MO', '65065', '38.1122', '-92.6901');
INSERT INTO `net_city` VALUES ('4885', '23', 'Форсайт', 'Forsyth', 'IL', '62535', '39.9361', '-88.9554');
INSERT INTO `net_city` VALUES ('4890', '23', 'Брайтон', 'Brighton', 'CO', '80601', '39.9537', '-104.8001');
INSERT INTO `net_city` VALUES ('4895', '23', 'Мексико', 'Mexico', 'MO', '65265', '39.2193', '-91.8860');
INSERT INTO `net_city` VALUES ('4897', '23', 'Линн', 'Linn', 'MO', '65051', '38.4735', '-91.7953');
INSERT INTO `net_city` VALUES ('4898', '23', 'Сейнт Чарльз', 'Saint Charles', 'MO', '63301', '38.8594', '-90.4758');
INSERT INTO `net_city` VALUES ('4899', '23', 'Беннингтон', 'Bennington', 'VT', '05201', '42.8626', '-73.0998');
INSERT INTO `net_city` VALUES ('4907', '23', 'Лонгмонт', 'Longmont', 'CO', '80503', '40.1791', '-105.1986');
INSERT INTO `net_city` VALUES ('4909', '23', 'Накла', 'Nucla', 'CO', '81424', '38.3462', '-108.4450');
INSERT INTO `net_city` VALUES ('4911', '23', 'Уэстборо', 'Westborough', 'MA', '01581', '42.2658', '-71.6105');
INSERT INTO `net_city` VALUES ('4913', '23', 'Уит Ридж', 'Wheat Ridge', 'CO', '80033', '39.7747', '-105.1033');
INSERT INTO `net_city` VALUES ('4915', '23', 'Голден', 'Golden', 'CO', '80401', '39.7146', '-105.2433');
INSERT INTO `net_city` VALUES ('4920', '23', 'Честер', 'Chester', 'VA', '23831', '37.3398', '-77.4586');
INSERT INTO `net_city` VALUES ('4921', '23', 'Аспен', 'Aspen', 'CO', '81611', '39.1556', '-106.7454');
INSERT INTO `net_city` VALUES ('4923', '23', 'Эйвон', 'Avon', 'CO', '81620', '39.6314', '-106.5222');
INSERT INTO `net_city` VALUES ('4925', '23', 'Виндхам', 'Windham', 'NY', '12496', '42.3286', '-74.2673');
INSERT INTO `net_city` VALUES ('4928', '23', 'Пайн-Ридж', 'Pine Ridge', 'SD', '57770', '43.1146', '-102.5694');
INSERT INTO `net_city` VALUES ('4935', '23', 'Чешир', 'Cheshire', 'CT', '06410', '41.5059', '-72.9081');
INSERT INTO `net_city` VALUES ('4936', '23', 'Тинли Парк', 'Tinley Park', 'IL', '60477', '41.5696', '-87.7994');
INSERT INTO `net_city` VALUES ('4939', '23', 'Норт Бранфорд', 'North Branford', 'CT', '06471', '41.3386', '-72.7391');
INSERT INTO `net_city` VALUES ('4940', '23', 'Симсбери', 'Simsbury', 'CT', '06070', '41.8686', '-72.8234');
INSERT INTO `net_city` VALUES ('4942', '23', 'Уэлч', 'Welch', 'WV', '24801', '37.3956', '-81.5757');
INSERT INTO `net_city` VALUES ('4943', '23', 'Юкка Валли', 'Yucca Valley', 'CA', '92284', '34.1537', '-116.4189');
INSERT INTO `net_city` VALUES ('4944', '23', 'Индио', 'Indio', 'CA', '92203', '33.7557', '-116.2330');
INSERT INTO `net_city` VALUES ('4946', '23', 'Буфорд', 'Buford', 'GA', '30518', '34.1212', '-84.0259');
INSERT INTO `net_city` VALUES ('4949', '23', 'Элк Сити', 'Elk City', 'OK', '73644', '35.3928', '-99.4562');
INSERT INTO `net_city` VALUES ('4952', '23', 'Запата', 'Zapata', 'TX', '78076', '26.9120', '-99.1717');
INSERT INTO `net_city` VALUES ('4961', '23', 'Малакофф', 'Malakoff', 'TX', '75148', '32.1105', '-96.0016');
INSERT INTO `net_city` VALUES ('4963', '23', 'Уиннсборо', 'Winnsboro', 'TX', '75494', '32.9157', '-95.2805');
INSERT INTO `net_city` VALUES ('4964', '23', 'Блумсберг', 'Bloomsburg', 'PA', '17815', '41.0530', '-76.4701');
INSERT INTO `net_city` VALUES ('4967', '23', 'Десото', 'Desoto', 'TX', '75115', '32.6042', '-96.8653');
INSERT INTO `net_city` VALUES ('4968', '23', 'Монета', 'Moneta', 'VA', '24121', '37.2021', '-79.6285');
INSERT INTO `net_city` VALUES ('4969', '23', 'Уилбрахам', 'Wilbraham', 'MA', '01095', '42.1343', '-72.4233');
INSERT INTO `net_city` VALUES ('4970', '23', 'Маседония', 'Macedonia', 'OH', '44056', '41.3134', '-81.4974');
INSERT INTO `net_city` VALUES ('4973', '23', 'Канфилд', 'Canfield', 'OH', '44406', '41.0137', '-80.7706');
INSERT INTO `net_city` VALUES ('4975', '23', 'Солон', 'Solon', 'OH', '44139', '41.3865', '-81.4401');
INSERT INTO `net_city` VALUES ('4977', '23', 'Фэрфилд', 'Fairfield', 'TX', '75840', '31.8035', '-96.0894');
INSERT INTO `net_city` VALUES ('4978', '23', 'Кантон', 'Canton', 'OH', '44710', '40.7901', '-81.4331');
INSERT INTO `net_city` VALUES ('4982', '23', 'Лейк Арроухед', 'Lake Arrowhead', 'CA', '92352', '34.2726', '-117.1968');
INSERT INTO `net_city` VALUES ('4983', '23', 'Патерсон', 'Paterson', 'NJ', '07504', '40.9111', '-74.1425');
INSERT INTO `net_city` VALUES ('4984', '23', 'Олд Лайм', 'Old Lyme', 'CT', '06371', '41.3589', '-72.3396');
INSERT INTO `net_city` VALUES ('4985', '23', 'Стерджен Бэй', 'Sturgeon Bay', 'WI', '54235', '44.7916', '-87.4670');
INSERT INTO `net_city` VALUES ('4988', '23', 'Дирфилд', 'Deerfield', 'MA', '01342', '42.5388', '-72.6031');
INSERT INTO `net_city` VALUES ('4989', '23', 'Бродхед', 'Brodhead', 'WI', '53520', '42.6008', '-89.3665');
INSERT INTO `net_city` VALUES ('4990', '23', 'Тома', 'Tomah', 'WI', '54660', '43.9753', '-90.4849');
INSERT INTO `net_city` VALUES ('4991', '23', 'Мидлтон', 'Middleton', 'WI', '53562', '43.1184', '-89.5207');
INSERT INTO `net_city` VALUES ('4994', '23', 'Висконсин Рапидс', 'Wisconsin Rapids', 'WI', '54494', '44.3360', '-89.7403');
INSERT INTO `net_city` VALUES ('4995', '23', 'Ла-Кросс', 'La Crosse', 'WI', '54601', '43.7982', '-91.1286');
INSERT INTO `net_city` VALUES ('4997', '23', 'Фрипорт', 'Freeport', 'IL', '61032', '42.3238', '-89.6218');
INSERT INTO `net_city` VALUES ('4999', '23', 'Мосайни', 'Mosinee', 'WI', '54455', '44.7350', '-89.6100');
INSERT INTO `net_city` VALUES ('5000', '23', 'Платтевилл', 'Platteville', 'WI', '53818', '42.7526', '-90.4891');
INSERT INTO `net_city` VALUES ('5001', '23', 'Маршфилд', 'Marshfield', 'WI', '54449', '44.6271', '-90.1981');
INSERT INTO `net_city` VALUES ('5002', '23', 'Сан Прейри', 'Sun Prairie', 'WI', '53590', '43.1946', '-89.2025');
INSERT INTO `net_city` VALUES ('5003', '23', 'Банкрофт', 'Bancroft', 'WI', '54921', '44.3096', '-89.5438');
INSERT INTO `net_city` VALUES ('5005', '23', 'Неилсвилл', 'Neillsville', 'WI', '54456', '44.5601', '-90.6708');
INSERT INTO `net_city` VALUES ('5007', '23', 'Белойт', 'Beloit', 'WI', '53511', '42.5584', '-89.1599');
INSERT INTO `net_city` VALUES ('5012', '23', 'Лоди', 'Lodi', 'WI', '53555', '43.3083', '-89.5502');
INSERT INTO `net_city` VALUES ('5013', '23', 'Джисервилл', 'Geyserville', 'CA', '95441', '38.7405', '-123.1337');
INSERT INTO `net_city` VALUES ('5016', '23', 'Уосау', 'Wausau', 'WI', '54401', '45.0033', '-89.7256');
INSERT INTO `net_city` VALUES ('5019', '23', 'Ротсчайлд', 'Rothschild', 'WI', '54474', '44.8843', '-89.6179');
INSERT INTO `net_city` VALUES ('5023', '23', 'Стоутон', 'Stoughton', 'WI', '53589', '42.9252', '-89.1562');
INSERT INTO `net_city` VALUES ('5024', '23', 'Барабу', 'Baraboo', 'WI', '53913', '43.4807', '-89.7399');
INSERT INTO `net_city` VALUES ('5025', '23', 'Мачесни Парк', 'Machesney Park', 'IL', '61115', '42.3631', '-89.0332');
INSERT INTO `net_city` VALUES ('5027', '23', 'Меррилл', 'Merrill', 'WI', '54452', '45.1781', '-89.8336');
INSERT INTO `net_city` VALUES ('5028', '23', 'Массиллон', 'Massillon', 'OH', '44646', '40.8182', '-81.4918');
INSERT INTO `net_city` VALUES ('5029', '23', 'Хантингберг', 'Huntingburg', 'IN', '47542', '38.2929', '-86.9464');
INSERT INTO `net_city` VALUES ('5030', '23', 'Виндзор', 'Windsor', 'CA', '95492', '38.5369', '-122.8123');
INSERT INTO `net_city` VALUES ('5031', '23', 'Эллсворт', 'Ellsworth', 'KS', '67439', '38.7473', '-98.2051');
INSERT INTO `net_city` VALUES ('5035', '23', 'Минеола', 'Mineola', 'NY', '11501', '40.7458', '-73.6390');
INSERT INTO `net_city` VALUES ('5041', '23', 'Уолпол', 'Walpole', 'MA', '02081', '42.1512', '-71.2569');
INSERT INTO `net_city` VALUES ('5045', '23', 'Милфорд', 'Milford', 'MA', '01757', '42.1544', '-71.5210');
INSERT INTO `net_city` VALUES ('5046', '23', 'Франклин', 'Franklin', 'MA', '02038', '42.0876', '-71.4073');
INSERT INTO `net_city` VALUES ('5049', '23', 'Мармора', 'Marmora', 'NJ', '08223', '39.2637', '-74.6608');
INSERT INTO `net_city` VALUES ('5051', '23', 'Этлборо', 'Attleboro', 'MA', '02703', '41.9395', '-71.2943');
INSERT INTO `net_city` VALUES ('5052', '23', 'Актон', 'Acton', 'MA', '01720', '42.4853', '-71.4418');
INSERT INTO `net_city` VALUES ('5053', '23', 'Рентам', 'Wrentham', 'MA', '02093', '42.0543', '-71.3715');
INSERT INTO `net_city` VALUES ('5057', '23', 'Грасс Валли', 'Grass Valley', 'CA', '95949', '39.1110', '-121.1268');
INSERT INTO `net_city` VALUES ('5058', '23', 'Садбери', 'Sudbury', 'MA', '01776', '42.3888', '-71.4225');
INSERT INTO `net_city` VALUES ('5059', '23', 'Портленд', 'Portland', 'ME', '04101', '43.6589', '-70.2615');
INSERT INTO `net_city` VALUES ('5060', '23', 'Твинсберг', 'Twinsburg', 'OH', '44087', '41.3152', '-81.4405');
INSERT INTO `net_city` VALUES ('5062', '23', 'Блэрсден-Граигл', 'Blairsden-graeagle', 'CA', '96103', '39.7884', '-120.6536');
INSERT INTO `net_city` VALUES ('5063', '23', 'Ли', 'Lee', 'MA', '01238', '42.2849', '-73.2142');
INSERT INTO `net_city` VALUES ('5065', '23', 'Юрика', 'Eureka', 'CA', '95501', '40.8004', '-124.1528');
INSERT INTO `net_city` VALUES ('5066', '23', 'Хико', 'Hico', 'WV', '25854', '38.1250', '-80.9829');
INSERT INTO `net_city` VALUES ('5068', '23', 'Маунт Клеменс', 'Mount Clemens', 'MI', '48046', '42.5973', '-82.8780');
INSERT INTO `net_city` VALUES ('5070', '23', 'Фентон', 'Fenton', 'MI', '48430', '42.7705', '-83.7467');
INSERT INTO `net_city` VALUES ('5071', '23', 'Бэд Экс', 'Bad Axe', 'MI', '48413', '43.7944', '-83.0025');
INSERT INTO `net_city` VALUES ('5077', '23', 'Нортвилл', 'Northville', 'MI', '48167', '42.4165', '-83.5297');
INSERT INTO `net_city` VALUES ('5078', '23', 'Розвилл', 'Roseville', 'MI', '48066', '42.5096', '-82.9361');
INSERT INTO `net_city` VALUES ('5082', '23', 'Касс Сити', 'Cass City', 'MI', '48726', '43.6106', '-83.1644');
INSERT INTO `net_city` VALUES ('5084', '23', 'Рочестер', 'Rochester', 'MI', '48306', '42.7286', '-83.1476');
INSERT INTO `net_city` VALUES ('5086', '23', 'Понтиак', 'Pontiac', 'MI', '48342', '42.6440', '-83.2796');
INSERT INTO `net_city` VALUES ('5088', '23', 'Нью Балтимор', 'New Baltimore', 'MI', '48047', '42.6757', '-82.7773');
INSERT INTO `net_city` VALUES ('5089', '23', 'Алпайн', 'Alpine', 'CA', '91901', '32.8002', '-116.7100');
INSERT INTO `net_city` VALUES ('5090', '23', 'Минден Сити', 'Minden City', 'MI', '48456', '43.6775', '-82.7438');
INSERT INTO `net_city` VALUES ('5093', '23', 'Блумфилд Хилс', 'Bloomfield Hills', 'MI', '48302', '42.5848', '-83.2950');
INSERT INTO `net_city` VALUES ('5094', '23', 'Пинол', 'Pinole', 'CA', '94564', '37.9927', '-122.2761');
INSERT INTO `net_city` VALUES ('5098', '23', 'Карролтон', 'Carrollton', 'KY', '41008', '38.6606', '-85.1895');
INSERT INTO `net_city` VALUES ('5099', '23', 'Нампа', 'Nampa', 'ID', '83687', '43.6056', '-116.5415');
INSERT INTO `net_city` VALUES ('5101', '23', 'Роджерс', 'Rogers', 'CT', '06263', '41.8404', '-71.9062');
INSERT INTO `net_city` VALUES ('5103', '23', 'Уоррентон', 'Warrenton', 'MO', '63383', '38.8142', '-91.2076');
INSERT INTO `net_city` VALUES ('5108', '23', 'Саут Эль Монте', 'South El Monte', 'CA', '91733', '34.0469', '-118.0485');
INSERT INTO `net_city` VALUES ('5110', '23', 'Палм Харбор', 'Palm Harbor', 'FL', '34685', '28.0986', '-82.6860');
INSERT INTO `net_city` VALUES ('5113', '23', 'Элкхарт', 'Elkhart', 'IN', '46516', '41.6671', '-85.9659');
INSERT INTO `net_city` VALUES ('5116', '23', 'Хирам', 'Hiram', 'OH', '44234', '41.3321', '-81.1650');
INSERT INTO `net_city` VALUES ('5117', '23', 'Ментор', 'Mentor', 'OH', '44060', '41.6892', '-81.3266');
INSERT INTO `net_city` VALUES ('5118', '23', 'Норт Олмстед', 'North Olmsted', 'OH', '44070', '41.4163', '-81.9225');
INSERT INTO `net_city` VALUES ('5120', '23', 'Чардон', 'Chardon', 'OH', '44024', '41.5779', '-81.1930');
INSERT INTO `net_city` VALUES ('5122', '23', 'Уиклайфф', 'Wickliffe', 'OH', '44092', '41.5985', '-81.4643');
INSERT INTO `net_city` VALUES ('5123', '23', 'Брук Парк', 'Brook Park', 'OH', '44142', '41.4026', '-81.8337');
INSERT INTO `net_city` VALUES ('5124', '23', 'Мейфилд Хайтс', 'Mayfield Heights', 'OH', '44117', '41.5683', '-81.5260');
INSERT INTO `net_city` VALUES ('5130', '23', 'Аштабула', 'Ashtabula', 'OH', '44004', '41.8528', '-80.7905');
INSERT INTO `net_city` VALUES ('5131', '23', 'Сифорд', 'Seaford', 'DE', '19973', '38.6320', '-75.5901');
INSERT INTO `net_city` VALUES ('5140', '23', 'Хелдсберг', 'Healdsburg', 'CA', '95448', '38.6319', '-122.8971');
INSERT INTO `net_city` VALUES ('5146', '23', 'Редуэй', 'Redway', 'CA', '95560', '40.1525', '-123.8925');
INSERT INTO `net_city` VALUES ('5149', '23', 'Дейтона-Бич', 'Daytona Beach', 'FL', '32119', '29.1622', '-81.0075');
INSERT INTO `net_city` VALUES ('5150', '27', 'Дорадо', 'Dorado', '00', '00646', '18.4316', '-66.2614');
INSERT INTO `net_city` VALUES ('5152', '23', 'Сейнт Хелена', 'Saint Helena', 'CA', '94574', '38.5504', '-122.3923');
INSERT INTO `net_city` VALUES ('5153', '23', 'Клирлейк', 'Clearlake', 'CA', '95422', '38.9678', '-122.6477');
INSERT INTO `net_city` VALUES ('5154', '23', 'Атлантик-Сити', 'Atlantic City', 'NJ', '08401', '39.3652', '-74.4378');
INSERT INTO `net_city` VALUES ('5155', '23', 'Петалума', 'Petaluma', 'CA', '94952', '38.2184', '-122.7676');
INSERT INTO `net_city` VALUES ('5158', '23', 'Оушенсайд', 'Oceanside', 'CA', '92056', '33.2004', '-117.2907');
INSERT INTO `net_city` VALUES ('5160', '23', 'Биг Рапидс', 'Big Rapids', 'MI', '49307', '43.6797', '-85.5619');
INSERT INTO `net_city` VALUES ('5161', '23', 'Ларкспер', 'Larkspur', 'CA', '94939', '37.9361', '-122.5367');
INSERT INTO `net_city` VALUES ('5165', '23', 'Сонома', 'Sonoma', 'CA', '95476', '38.2433', '-122.4602');
INSERT INTO `net_city` VALUES ('5167', '23', 'Себастопол', 'Sebastopol', 'CA', '95472', '38.4032', '-122.8633');
INSERT INTO `net_city` VALUES ('5169', '23', 'Пайксвилл', 'Pikesville', 'MD', '21208', '39.3817', '-76.7265');
INSERT INTO `net_city` VALUES ('5170', '23', 'Майами', 'Miami', 'OK', '74354', '36.8994', '-94.8785');
INSERT INTO `net_city` VALUES ('5171', '23', 'Дакула', 'Dacula', 'GA', '30019', '33.9785', '-83.8811');
INSERT INTO `net_city` VALUES ('5172', '23', 'Катуза', 'Catoosa', 'OK', '74015', '36.1922', '-95.7067');
INSERT INTO `net_city` VALUES ('5175', '23', 'Грэйт Бенд', 'Great Bend', 'KS', '67530', '38.3402', '-98.8118');
INSERT INTO `net_city` VALUES ('5177', '23', 'Стилуотер', 'Stillwater', 'OK', '74075', '36.1885', '-97.0574');
INSERT INTO `net_city` VALUES ('5179', '23', 'Дьюи', 'Dewey', 'OK', '74029', '36.8293', '-95.8851');
INSERT INTO `net_city` VALUES ('5180', '23', 'Оксфорд', 'Oxford', 'AL', '36203', '33.5743', '-85.8530');
INSERT INTO `net_city` VALUES ('5181', '23', 'Маскоджи', 'Muskogee', 'OK', '74403', '35.6738', '-95.3056');
INSERT INTO `net_city` VALUES ('5182', '23', 'Кингсленд', 'Kingsland', 'TX', '78639', '30.6878', '-98.4768');
INSERT INTO `net_city` VALUES ('5183', '23', 'Окма', 'Okemah', 'OK', '74859', '35.4646', '-96.3288');
INSERT INTO `net_city` VALUES ('5186', '23', 'Берлсон', 'Burleson', 'TX', '76028', '32.5305', '-97.3076');
INSERT INTO `net_city` VALUES ('5187', '23', 'Неодеша', 'Neodesha', 'KS', '66757', '37.4140', '-95.6889');
INSERT INTO `net_city` VALUES ('5189', '23', 'Кайова', 'Kiowa', 'OK', '74553', '34.6910', '-95.9381');
INSERT INTO `net_city` VALUES ('5190', '23', 'Рехобот Бич', 'Rehoboth Beach', 'DE', '19971', '38.6886', '-75.0733');
INSERT INTO `net_city` VALUES ('5196', '23', 'Хиксвилл', 'Hicksville', 'NY', '11801', '40.7670', '-73.5254');
INSERT INTO `net_city` VALUES ('5198', '23', 'Колледж Пойнт', 'College Point', 'NY', '11356', '40.7842', '-73.8422');
INSERT INTO `net_city` VALUES ('5199', '23', 'Вапато', 'Wapato', 'WA', '98951', '46.4512', '-120.5173');
INSERT INTO `net_city` VALUES ('5202', '23', 'Рокленд', 'Rockland', 'ME', '04841', '44.1272', '-69.1336');
INSERT INTO `net_city` VALUES ('5203', '23', 'Гардинер', 'Gardiner', 'ME', '04345', '44.2168', '-69.8522');
INSERT INTO `net_city` VALUES ('5211', '23', 'Карибу', 'Caribou', 'ME', '04736', '46.9121', '-68.0431');
INSERT INTO `net_city` VALUES ('5212', '23', 'Уолдоборо', 'Waldoboro', 'ME', '04572', '44.1085', '-69.3659');
INSERT INTO `net_city` VALUES ('5213', '23', 'Кеннебанк', 'Kennebunk', 'ME', '04043', '43.3972', '-70.5722');
INSERT INTO `net_city` VALUES ('5215', '23', 'Оберн', 'Auburn', 'ME', '04210', '44.0861', '-70.2434');
INSERT INTO `net_city` VALUES ('5216', '23', 'Брансуик', 'Brunswick', 'ME', '04011', '43.8988', '-69.9725');
INSERT INTO `net_city` VALUES ('5217', '23', 'Бруксвилл', 'Brooksville', 'ME', '04617', '44.3667', '-68.7454');
INSERT INTO `net_city` VALUES ('5218', '23', 'Белфаст', 'Belfast', 'ME', '04915', '44.4735', '-69.0551');
INSERT INTO `net_city` VALUES ('5220', '23', 'Скарборо', 'Scarborough', 'ME', '04074', '43.5923', '-70.3735');
INSERT INTO `net_city` VALUES ('5222', '23', 'Огаста', 'Augusta', 'ME', '04330', '44.4051', '-69.7567');
INSERT INTO `net_city` VALUES ('5223', '23', 'Мадаваска', 'Madawaska', 'ME', '04756', '47.3163', '-68.3007');
INSERT INTO `net_city` VALUES ('5224', '23', 'Форт Кент', 'Fort Kent', 'ME', '04743', '47.1923', '-68.4824');
INSERT INTO `net_city` VALUES ('5225', '23', 'Рексберг', 'Rexburg', 'ID', '83440', '43.7832', '-111.7656');
INSERT INTO `net_city` VALUES ('5226', '23', 'Флоренция', 'Florence', 'KY', '41042', '39.0023', '-84.6569');
INSERT INTO `net_city` VALUES ('5227', '23', 'Гилфорд', 'Guilford', 'ME', '04443', '45.2677', '-69.3302');
INSERT INTO `net_city` VALUES ('5228', '23', 'Седжвик', 'Sedgwick', 'ME', '04676', '44.3502', '-68.6434');
INSERT INTO `net_city` VALUES ('5231', '23', 'Ист Тетфорд', 'East Thetford', 'VT', '05043', '43.8169', '-72.2215');
INSERT INTO `net_city` VALUES ('5234', '23', 'Картерет', 'Carteret', 'NJ', '07008', '40.5817', '-74.2315');
INSERT INTO `net_city` VALUES ('5240', '23', 'Бетпаж', 'Bethpage', 'NY', '11714', '40.7405', '-73.4840');
INSERT INTO `net_city` VALUES ('5241', '23', 'Хилсайд', 'Hillside', 'NJ', '07205', '40.6932', '-74.2294');
INSERT INTO `net_city` VALUES ('5242', '23', 'Кранфорд', 'Cranford', 'NJ', '07016', '40.6559', '-74.3045');
INSERT INTO `net_city` VALUES ('5244', '23', 'Уэст Ориндж', 'West Orange', 'NJ', '07052', '40.7919', '-74.2640');
INSERT INTO `net_city` VALUES ('5245', '23', 'Джесап', 'Jesup', 'IA', '50648', '42.4701', '-92.1033');
INSERT INTO `net_city` VALUES ('5251', '23', 'Шот Хилс', 'Short Hills', 'NJ', '07078', '40.7389', '-74.3307');
INSERT INTO `net_city` VALUES ('5253', '23', 'Камден', 'Camden', 'ME', '04843', '44.2253', '-69.0923');
INSERT INTO `net_city` VALUES ('5254', '23', 'Рауэй', 'Rahway', 'NJ', '07065', '40.6097', '-74.2806');
INSERT INTO `net_city` VALUES ('5261', '23', 'Хобокен', 'Hoboken', 'NJ', '07030', '40.7458', '-74.0321');
INSERT INTO `net_city` VALUES ('5262', '23', 'Уайлдер', 'Wilder', 'KY', '41076', '39.0109', '-84.4335');
INSERT INTO `net_city` VALUES ('5273', '23', 'Синтон', 'Sinton', 'TX', '78387', '28.0482', '-97.4910');
INSERT INTO `net_city` VALUES ('5277', '23', 'Плакемин', 'Plaquemine', 'LA', '70764', '30.1882', '-91.3241');
INSERT INTO `net_city` VALUES ('5279', '23', 'Санфорд', 'Sanford', 'FL', '32771', '28.8301', '-81.3618');
INSERT INTO `net_city` VALUES ('5287', '23', 'Олимпия', 'Olympia', 'WA', '98512', '46.9445', '-123.0493');
INSERT INTO `net_city` VALUES ('5288', '23', 'Тупело', 'Tupelo', 'MS', '38801', '34.2217', '-88.7688');
INSERT INTO `net_city` VALUES ('5289', '23', 'Рио Гранде Сити', 'Rio Grande City', 'TX', '78582', '26.5106', '-98.6534');
INSERT INTO `net_city` VALUES ('5293', '23', 'Молтри', 'Moultrie', 'GA', '31768', '31.1930', '-83.8434');
INSERT INTO `net_city` VALUES ('5295', '23', 'Девенс', 'Devens', 'MA', '01434', '42.5436', '-71.6161');
INSERT INTO `net_city` VALUES ('5297', '23', 'Чилмарк', 'Chilmark', 'MA', '02535', '41.3551', '-70.7273');
INSERT INTO `net_city` VALUES ('5299', '23', 'Уорминстер', 'Warminster', 'PA', '18974', '40.2140', '-75.0730');
INSERT INTO `net_city` VALUES ('5303', '23', 'Саутлейк', 'Southlake', 'TX', '76092', '32.9516', '-97.1515');
INSERT INTO `net_city` VALUES ('5307', '23', 'Литония', 'Lithonia', 'GA', '30038', '33.6589', '-84.1430');
INSERT INTO `net_city` VALUES ('5310', '23', 'Санта Пола', 'Santa Paula', 'CA', '93060', '34.4014', '-119.0753');
INSERT INTO `net_city` VALUES ('5313', '23', 'Клинтон', 'Clinton', 'MS', '39056', '32.3671', '-90.3586');
INSERT INTO `net_city` VALUES ('5314', '23', 'Довер', 'Dover', 'NJ', '07801', '40.9559', '-74.5418');
INSERT INTO `net_city` VALUES ('5316', '23', 'Дюма', 'Dumas', 'AR', '71639', '33.9155', '-91.5232');
INSERT INTO `net_city` VALUES ('5317', '23', 'Стоутон', 'Stoughton', 'MA', '02072', '42.1186', '-71.1033');
INSERT INTO `net_city` VALUES ('5320', '23', 'Потакет', 'Pawtucket', 'RI', '02861', '41.8784', '-71.3539');
INSERT INTO `net_city` VALUES ('5321', '23', 'Батл Крик', 'Battle Creek', 'MI', '49015', '42.2843', '-85.2293');
INSERT INTO `net_city` VALUES ('5322', '23', 'Уэст Ярмут', 'West Yarmouth', 'MA', '02673', '41.6494', '-70.2415');
INSERT INTO `net_city` VALUES ('5323', '23', 'Камберленд', 'Cumberland', 'RI', '02864', '41.9560', '-71.4338');
INSERT INTO `net_city` VALUES ('5324', '23', 'Вайнярд Хейвен', 'Vineyard Haven', 'MA', '02568', '41.4477', '-70.6210');
INSERT INTO `net_city` VALUES ('5325', '23', 'Фэрхейвен', 'Fairhaven', 'MA', '02719', '41.6318', '-70.8801');
INSERT INTO `net_city` VALUES ('5328', '23', 'Норт Этлборо', 'North Attleboro', 'MA', '02761', '41.9834', '-71.3328');
INSERT INTO `net_city` VALUES ('5329', '23', 'Реймондвилл', 'Raymondville', 'MO', '65555', '37.3548', '-91.7584');
INSERT INTO `net_city` VALUES ('5332', '23', 'Смитфилд', 'Smithfield', 'VA', '23430', '37.0058', '-76.6656');
INSERT INTO `net_city` VALUES ('5337', '23', 'Монтвейл', 'Montvale', 'NJ', '07645', '41.0550', '-74.0460');
INSERT INTO `net_city` VALUES ('5339', '23', 'Лейк Зурич', 'Lake Zurich', 'IL', '60047', '42.2008', '-88.0430');
INSERT INTO `net_city` VALUES ('5341', '23', 'Лост Пайнс', 'Lost Pines', 'TX', '78612', '30.0942', '-97.4918');
INSERT INTO `net_city` VALUES ('5343', '23', 'Пенн Ян', 'Penn Yan', 'NY', '14527', '42.6499', '-76.9879');
INSERT INTO `net_city` VALUES ('5344', '23', 'Вуд Дейл', 'Wood Dale', 'IL', '60191', '41.9664', '-87.9811');
INSERT INTO `net_city` VALUES ('5346', '23', 'Глендейл Хайтс', 'Glendale Heights', 'IL', '60139', '41.9214', '-88.0745');
INSERT INTO `net_city` VALUES ('5347', '23', 'Вайоминг', 'Wyoming', 'MN', '55092', '45.3349', '-93.0132');
INSERT INTO `net_city` VALUES ('5350', '23', 'Хаттисберг', 'Hattiesburg', 'MS', '39401', '31.2622', '-89.2723');
INSERT INTO `net_city` VALUES ('5353', '23', 'Фармингтон', 'Farmington', 'NM', '87401', '36.4714', '-108.2510');
INSERT INTO `net_city` VALUES ('5357', '23', 'Анока', 'Anoka', 'MN', '55303', '45.2874', '-93.4336');
INSERT INTO `net_city` VALUES ('5362', '23', 'Уматилла', 'Umatilla', 'FL', '32784', '28.9822', '-81.7351');
INSERT INTO `net_city` VALUES ('5368', '23', 'Конайерс', 'Conyers', 'GA', '30013', '33.6207', '-83.9737');
INSERT INTO `net_city` VALUES ('5370', '23', 'Савани', 'Suwanee', 'GA', '30024', '34.0535', '-84.0659');
INSERT INTO `net_city` VALUES ('5372', '23', 'Эллижей', 'Ellijay', 'GA', '30540', '34.7044', '-84.4253');
INSERT INTO `net_city` VALUES ('5377', '23', 'Долтон', 'Dalton', 'GA', '30721', '34.7982', '-84.9082');
INSERT INTO `net_city` VALUES ('5379', '23', 'Доусонвилль', 'Dawsonville', 'GA', '30534', '34.4630', '-84.1510');
INSERT INTO `net_city` VALUES ('5380', '23', 'Уолска', 'Waleska', 'GA', '30183', '34.3319', '-84.5948');
INSERT INTO `net_city` VALUES ('5384', '23', 'Онейда', 'Oneida', 'TN', '37841', '36.5101', '-84.4693');
INSERT INTO `net_city` VALUES ('5387', '23', 'Кирбивилл', 'Kirbyville', 'TX', '75956', '30.6772', '-94.0052');
INSERT INTO `net_city` VALUES ('5390', '23', 'Уэйкросс', 'Waycross', 'GA', '31501', '31.2177', '-82.3429');
INSERT INTO `net_city` VALUES ('5391', '23', 'Вонор', 'Vonore', 'TN', '37885', '35.4841', '-84.0940');
INSERT INTO `net_city` VALUES ('5394', '23', 'Коммерс', 'Commerce', 'GA', '30599', '34.1306', '-83.5874');
INSERT INTO `net_city` VALUES ('5399', '23', 'Фрихолд', 'Freehold', 'NJ', '07728', '40.2321', '-74.2986');
INSERT INTO `net_city` VALUES ('5401', '23', 'Хаммонд', 'Hammond', 'IN', '46320', '41.6086', '-87.4931');
INSERT INTO `net_city` VALUES ('5402', '23', 'Мерфи', 'Murphy', 'NC', '28906', '35.1397', '-84.0923');
INSERT INTO `net_city` VALUES ('5405', '23', 'Кашьерс', 'Cashiers', 'NC', '28717', '35.0842', '-83.0940');
INSERT INTO `net_city` VALUES ('5411', '23', 'Ньютаун', 'Newtown', 'PA', '18940', '40.2647', '-74.9535');
INSERT INTO `net_city` VALUES ('5414', '23', 'Марион', 'Marion', 'NC', '28752', '35.7387', '-82.0548');
INSERT INTO `net_city` VALUES ('5423', '23', 'Мелвиндейл', 'Melvindale', 'MI', '48122', '42.2812', '-83.1795');
INSERT INTO `net_city` VALUES ('5433', '23', 'Гейлорд', 'Gaylord', 'MI', '49735', '44.9867', '-84.6393');
INSERT INTO `net_city` VALUES ('5434', '23', 'Денисон', 'Denison', 'TX', '75020', '33.7762', '-96.6067');
INSERT INTO `net_city` VALUES ('5436', '23', 'Вайоминг', 'Wyoming', 'MI', '49509', '42.9134', '-85.7053');
INSERT INTO `net_city` VALUES ('5439', '23', 'Иммокали', 'Immokalee', 'FL', '34142', '26.2304', '-81.2215');
INSERT INTO `net_city` VALUES ('5441', '23', 'Уинфилд', 'Winfield', 'AL', '35594', '33.9463', '-87.7828');
INSERT INTO `net_city` VALUES ('5444', '23', 'Файет', 'Fayette', 'AL', '35555', '33.6436', '-87.8275');
INSERT INTO `net_city` VALUES ('5447', '23', 'Элкмонт', 'Elkmont', 'AL', '35620', '34.9266', '-86.9570');
INSERT INTO `net_city` VALUES ('5448', '23', 'Ла Порт', 'La Porte', 'TX', '77571', '29.6883', '-95.0608');
INSERT INTO `net_city` VALUES ('5449', '23', 'Блантсвилл', 'Blountsville', 'AL', '35031', '34.1187', '-86.5621');
INSERT INTO `net_city` VALUES ('5452', '23', 'Крествью', 'Crestview', 'FL', '32536', '30.6367', '-86.6635');
INSERT INTO `net_city` VALUES ('5456', '23', 'Биллингсли', 'Billingsley', 'AL', '36006', '32.6295', '-86.7151');
INSERT INTO `net_city` VALUES ('5458', '23', 'Силакога', 'Sylacauga', 'AL', '35151', '33.1167', '-86.3323');
INSERT INTO `net_city` VALUES ('5466', '23', 'Талласси', 'Tallassee', 'AL', '36078', '32.5554', '-85.9335');
INSERT INTO `net_city` VALUES ('5469', '23', 'Сараленд', 'Saraland', 'AL', '36571', '30.8395', '-88.0968');
INSERT INTO `net_city` VALUES ('5476', '23', 'Алабастер', 'Alabaster', 'AL', '35007', '33.2240', '-86.7730');
INSERT INTO `net_city` VALUES ('5477', '23', 'Бос', 'Boaz', 'AL', '35957', '34.1917', '-86.1934');
INSERT INTO `net_city` VALUES ('5479', '23', 'Джордж Уэст', 'George West', 'TX', '78022', '28.2527', '-98.1074');
INSERT INTO `net_city` VALUES ('5481', '23', 'Трой', 'Troy', 'AL', '36081', '31.9051', '-85.8937');
INSERT INTO `net_city` VALUES ('5483', '23', 'Ридли Парк', 'Ridley Park', 'PA', '19078', '39.8751', '-75.3214');
INSERT INTO `net_city` VALUES ('5486', '23', 'Маунт-Плезант', 'Mount Pleasant', 'MI', '48858', '43.6147', '-84.7927');
INSERT INTO `net_city` VALUES ('5487', '23', 'Маскегон', 'Muskegon', 'MI', '49444', '43.1746', '-86.1834');
INSERT INTO `net_city` VALUES ('5489', '23', 'Платтсбург', 'Plattsburgh', 'NY', '12901', '44.7454', '-73.4628');
INSERT INTO `net_city` VALUES ('5490', '23', 'Дуглас', 'Douglas', 'MI', '49406', '42.6434', '-86.2006');
INSERT INTO `net_city` VALUES ('5492', '23', 'Айония', 'Ionia', 'MI', '48846', '43.0320', '-85.0575');
INSERT INTO `net_city` VALUES ('5493', '23', 'Аллеган', 'Allegan', 'MI', '49010', '42.5602', '-85.8586');
INSERT INTO `net_city` VALUES ('5494', '23', 'Блайтвилл', 'Blytheville', 'AR', '72315', '35.8711', '-89.9046');
INSERT INTO `net_city` VALUES ('5496', '23', 'Хау', 'Howe', 'IN', '46746', '41.7119', '-85.3692');
INSERT INTO `net_city` VALUES ('5501', '23', 'Спринг Лейк', 'Spring Lake', 'MI', '49456', '43.1027', '-86.2239');
INSERT INTO `net_city` VALUES ('5502', '23', 'Уэст Хелена', 'West Helena', 'AR', '72390', '34.5301', '-90.6512');
INSERT INTO `net_city` VALUES ('5507', '23', 'Марениско', 'Marenisco', 'MI', '49947', '46.4405', '-89.6640');
INSERT INTO `net_city` VALUES ('5508', '23', 'Грейлинг', 'Grayling', 'MI', '49738', '44.7143', '-84.6717');
INSERT INTO `net_city` VALUES ('5512', '23', 'Уэстерли', 'Westerly', 'RI', '02891', '41.3617', '-71.8024');
INSERT INTO `net_city` VALUES ('5515', '23', 'Чебойган', 'Cheboygan', 'MI', '49721', '45.5452', '-84.3550');
INSERT INTO `net_city` VALUES ('5516', '23', 'Калиспелл', 'Kalispell', 'MT', '59901', '48.1987', '-114.3857');
INSERT INTO `net_city` VALUES ('5517', '23', 'Неспелем', 'Nespelem', 'WA', '99155', '48.1671', '-118.9748');
INSERT INTO `net_city` VALUES ('5519', '23', 'Чини', 'Cheney', 'WA', '99004', '47.4313', '-117.6292');
INSERT INTO `net_city` VALUES ('5521', '23', 'Либерти Лейк', 'Liberty Lake', 'WA', '99019', '47.6391', '-117.0974');
INSERT INTO `net_city` VALUES ('5523', '23', 'Маунтин Хоум', 'Mountain Home', 'ID', '83647', '43.3640', '-115.5202');
INSERT INTO `net_city` VALUES ('5524', '23', 'Туин-Фолс', 'Twin Falls', 'ID', '83301', '42.4199', '-114.5915');
INSERT INTO `net_city` VALUES ('5526', '23', 'Москоу', 'Moscow', 'ID', '83843', '46.7172', '-116.9179');
INSERT INTO `net_city` VALUES ('5530', '23', 'Уоллис', 'Wallis', 'TX', '77485', '29.6143', '-96.0417');
INSERT INTO `net_city` VALUES ('5531', '23', 'Розалия', 'Rosalia', 'WA', '99170', '47.2599', '-117.3842');
INSERT INTO `net_city` VALUES ('5532', '23', 'Кодак', 'Kodak', 'TN', '37764', '35.9713', '-83.6193');
INSERT INTO `net_city` VALUES ('5539', '23', 'Дауни', 'Downey', 'CA', '90242', '33.9231', '-118.1396');
INSERT INTO `net_city` VALUES ('5543', '23', 'Порт Сейнт Луси', 'Port Saint Lucie', 'FL', '34953', '27.2498', '-80.3797');
INSERT INTO `net_city` VALUES ('5546', '23', 'Линбрук', 'Lynbrook', 'NY', '11563', '40.6578', '-73.6720');
INSERT INTO `net_city` VALUES ('5549', '23', 'Лейк Сити', 'Lake City', 'FL', '32055', '30.2712', '-82.6264');
INSERT INTO `net_city` VALUES ('5560', '23', 'Аксбридж', 'Uxbridge', 'MA', '01569', '42.0628', '-71.6437');
INSERT INTO `net_city` VALUES ('5561', '23', 'Уэллсвилл', 'Wellsville', 'PA', '17365', '40.0593', '-76.9322');
INSERT INTO `net_city` VALUES ('5566', '23', 'Панксатони', 'Punxsutawney', 'PA', '15767', '40.9515', '-78.9778');
INSERT INTO `net_city` VALUES ('5568', '23', 'Грантвилл', 'Grantville', 'PA', '17028', '40.4017', '-76.6544');
INSERT INTO `net_city` VALUES ('5572', '23', 'Хановер', 'Hanover', 'PA', '17331', '39.7968', '-76.9930');
INSERT INTO `net_city` VALUES ('5573', '23', 'Флоренс', 'Florence', 'AL', '35630', '34.8315', '-87.6664');
INSERT INTO `net_city` VALUES ('5575', '23', 'Олив Бранч', 'Olive Branch', 'MS', '38654', '34.9180', '-89.8216');
INSERT INTO `net_city` VALUES ('5577', '23', 'Дайерсберг', 'Dyersburg', 'TN', '38024', '36.0124', '-89.3779');
INSERT INTO `net_city` VALUES ('5582', '23', 'Ки Ларго', 'Key Largo', 'FL', '33037', '25.1842', '-80.3791');
INSERT INTO `net_city` VALUES ('5583', '23', 'Орлеан', 'Orleans', 'MI', '48865', '43.0791', '-85.1049');
INSERT INTO `net_city` VALUES ('5585', '23', 'Гренада', 'Grenada', 'MS', '38901', '33.7404', '-89.8324');
INSERT INTO `net_city` VALUES ('5586', '23', 'Леланд', 'Leland', 'MS', '38756', '33.3934', '-90.8717');
INSERT INTO `net_city` VALUES ('5587', '23', 'Джексон', 'Jackson', 'MS', '38603', '34.8573', '-89.1402');
INSERT INTO `net_city` VALUES ('5590', '23', 'Сенека Фолс', 'Seneca Falls', 'NY', '13148', '42.8685', '-76.7848');
INSERT INTO `net_city` VALUES ('5591', '23', 'Ориндж Парк', 'Orange Park', 'FL', '32073', '30.1672', '-81.7715');
INSERT INTO `net_city` VALUES ('5593', '23', 'Тун', 'Toone', 'TN', '38381', '35.3573', '-88.9773');
INSERT INTO `net_city` VALUES ('5597', '23', 'Аннвилл', 'Annville', 'PA', '17003', '40.3443', '-76.5512');
INSERT INTO `net_city` VALUES ('5600', '23', 'Уильямспорт', 'Williamsport', 'PA', '17702', '41.1703', '-77.0486');
INSERT INTO `net_city` VALUES ('5604', '23', 'Миллингтон', 'Millington', 'TN', '38054', '35.3341', '-89.8706');
INSERT INTO `net_city` VALUES ('5605', '23', 'Эксельсиор Спрингс', 'Excelsior Springs', 'MO', '64024', '39.3180', '-94.2180');
INSERT INTO `net_city` VALUES ('5610', '23', 'Покахонтас', 'Pocahontas', 'AR', '72455', '36.3064', '-90.9772');
INSERT INTO `net_city` VALUES ('5616', '23', 'Хантингдон', 'Huntingdon', 'PA', '16652', '40.5622', '-77.8545');
INSERT INTO `net_city` VALUES ('5617', '23', 'Нью Камберленд', 'New Cumberland', 'PA', '17070', '40.2072', '-76.8478');
INSERT INTO `net_city` VALUES ('5620', '23', 'Нью Холланд', 'New Holland', 'PA', '17557', '40.1086', '-76.0707');
INSERT INTO `net_city` VALUES ('5623', '23', 'Хилсборо', 'Hillsboro', 'OH', '45133', '39.1669', '-83.5655');
INSERT INTO `net_city` VALUES ('5624', '23', 'Хатфилд', 'Hatfield', 'PA', '19440', '40.2865', '-75.2952');
INSERT INTO `net_city` VALUES ('5625', '23', 'Имлер', 'Imler', 'PA', '16655', '40.2591', '-78.4705');
INSERT INTO `net_city` VALUES ('5626', '23', 'Ред Лайон', 'Red Lion', 'PA', '17356', '39.8939', '-76.5580');
INSERT INTO `net_city` VALUES ('5629', '23', 'Ричмонд', 'Richmond', 'IN', '47374', '39.8381', '-84.9054');
INSERT INTO `net_city` VALUES ('5631', '23', 'Элизабеттаун', 'Elizabethtown', 'PA', '17022', '40.1680', '-76.6093');
INSERT INTO `net_city` VALUES ('5633', '23', 'Леола', 'Leola', 'PA', '17540', '40.0944', '-76.1770');
INSERT INTO `net_city` VALUES ('5634', '23', 'Американ Каньон', 'American Canyon', 'CA', '94503', '38.1890', '-122.2541');
INSERT INTO `net_city` VALUES ('5637', '23', 'Рейнолдсвилл', 'Reynoldsville', 'PA', '15851', '41.1158', '-78.9098');
INSERT INTO `net_city` VALUES ('5640', '23', 'Лититц', 'Lititz', 'PA', '17543', '40.1750', '-76.3078');
INSERT INTO `net_city` VALUES ('5641', '23', 'Астор', 'Astor', 'FL', '32102', '29.1613', '-81.5600');
INSERT INTO `net_city` VALUES ('5644', '23', 'Себастиан', 'Sebastian', 'FL', '32958', '27.8007', '-80.4919');
INSERT INTO `net_city` VALUES ('5647', '23', 'Форест ', 'Forest', 'MS', '39074', '32.3322', '-89.4767');
INSERT INTO `net_city` VALUES ('5648', '23', 'Кембридж', 'Cambridge', 'VT', '05444', '44.6579', '-72.9192');
INSERT INTO `net_city` VALUES ('5649', '23', 'Гилбертаун', 'Gilbertown', 'AL', '36908', '31.9066', '-88.2250');
INSERT INTO `net_city` VALUES ('5655', '23', 'Мадисон', 'Madison', 'MS', '39110', '32.5171', '-90.1367');
INSERT INTO `net_city` VALUES ('5656', '23', 'Атмор', 'Atmore', 'AL', '36502', '31.1742', '-87.4985');
INSERT INTO `net_city` VALUES ('5657', '23', 'Меджи', 'Magee', 'MS', '39111', '31.9287', '-89.6469');
INSERT INTO `net_city` VALUES ('5658', '23', 'Стьюарт', 'Stuart', 'VA', '24171', '36.6946', '-80.2309');
INSERT INTO `net_city` VALUES ('5660', '23', 'Локсли', 'Loxley', 'AL', '36551', '30.6388', '-87.7378');
INSERT INTO `net_city` VALUES ('5664', '23', 'Брютон', 'Brewton', 'AL', '36426', '31.1665', '-87.0761');
INSERT INTO `net_city` VALUES ('5665', '23', 'Бэй Минетт', 'Bay Minette', 'AL', '36507', '30.8833', '-87.7263');
INSERT INTO `net_city` VALUES ('5668', '23', 'Бингемтон', 'Binghamton', 'NY', '13905', '42.1794', '-75.9491');
INSERT INTO `net_city` VALUES ('5669', '23', 'Казеновия', 'Cazenovia', 'NY', '13035', '42.9419', '-75.8033');
INSERT INTO `net_city` VALUES ('5673', '23', 'Итака', 'Ithaca', 'NY', '14850', '42.4072', '-76.5159');
INSERT INTO `net_city` VALUES ('5674', '23', 'Плезант Хилл', 'Pleasant Hill', 'CA', '94523', '37.9536', '-122.0780');
INSERT INTO `net_city` VALUES ('5676', '23', 'Канастота', 'Canastota', 'NY', '13032', '43.0715', '-75.7654');
INSERT INTO `net_city` VALUES ('5678', '23', 'Ист Сиракьюс', 'East Syracuse', 'NY', '13057', '43.0892', '-76.0250');
INSERT INTO `net_city` VALUES ('5680', '23', 'Гровленд', 'Groveland', 'CA', '95321', '37.8597', '-119.7680');
INSERT INTO `net_city` VALUES ('5686', '23', 'Ливерпуль', 'Liverpool', 'NY', '13090', '43.1532', '-76.2116');
INSERT INTO `net_city` VALUES ('5687', '23', 'Элликотт Сити', 'Ellicott City', 'MD', '21043', '39.2570', '-76.7946');
INSERT INTO `net_city` VALUES ('5688', '23', 'Конклин', 'Conklin', 'NY', '13748', '42.0454', '-75.8224');
INSERT INTO `net_city` VALUES ('5689', '23', 'Хорсхедс', 'Horseheads', 'NY', '14845', '42.2125', '-76.7868');
INSERT INTO `net_city` VALUES ('5690', '23', 'Финикс', 'Phoenix', 'NY', '13135', '43.2629', '-76.3105');
INSERT INTO `net_city` VALUES ('5691', '23', 'Рио Виста', 'Rio Vista', 'CA', '94571', '38.1885', '-121.7321');
INSERT INTO `net_city` VALUES ('5694', '23', 'Дели', 'Delhi', 'NY', '13753', '42.3179', '-74.9308');
INSERT INTO `net_city` VALUES ('5696', '23', 'Маунт Улла', 'Mount Ulla', 'NC', '28125', '35.6605', '-80.7046');
INSERT INTO `net_city` VALUES ('5699', '23', 'Харрингтон', 'Harrington', 'DE', '19952', '38.9033', '-75.6113');
INSERT INTO `net_city` VALUES ('5700', '23', 'Скотс Милс', 'Scotts Mills', 'OR', '97375', '44.9676', '-122.5780');
INSERT INTO `net_city` VALUES ('5701', '23', 'Флетчер', 'Fletcher', 'NC', '28732', '35.4608', '-82.4715');
INSERT INTO `net_city` VALUES ('5702', '23', 'Прайс', 'Price', 'UT', '84501', '39.5751', '-110.8024');
INSERT INTO `net_city` VALUES ('5703', '23', 'Вакавилл', 'Vacaville', 'CA', '95688', '38.4166', '-122.0101');
INSERT INTO `net_city` VALUES ('5704', '23', 'Дрейпер', 'Draper', 'UT', '84020', '40.4982', '-111.8436');
INSERT INTO `net_city` VALUES ('5714', '23', 'Албия', 'Albia', 'IA', '52531', '41.0336', '-92.8450');
INSERT INTO `net_city` VALUES ('5715', '23', 'Айова Фолс', 'Iowa Falls', 'IA', '50126', '42.5208', '-93.2473');
INSERT INTO `net_city` VALUES ('5716', '23', 'Бун', 'Boone', 'IA', '50036', '42.1019', '-93.8420');
INSERT INTO `net_city` VALUES ('5724', '23', 'Лакота', 'Lakota', 'IA', '50451', '43.4067', '-94.0988');
INSERT INTO `net_city` VALUES ('5726', '23', 'Грунди Сентер', 'Grundy Center', 'IA', '50638', '42.3693', '-92.8075');
INSERT INTO `net_city` VALUES ('5730', '23', 'Шелдон', 'Sheldon', 'IA', '51201', '43.1858', '-95.8807');
INSERT INTO `net_city` VALUES ('5734', '23', 'Ломита', 'Lomita', 'CA', '90717', '33.7919', '-118.3184');
INSERT INTO `net_city` VALUES ('5735', '23', 'Белмаур', 'Bellmawr', 'NJ', '08031', '39.8677', '-75.0907');
INSERT INTO `net_city` VALUES ('5736', '23', 'Ренсселаер', 'Rensselaer', 'NY', '12144', '42.6189', '-73.7065');
INSERT INTO `net_city` VALUES ('5737', '23', 'Малон', 'Malone', 'NY', '12953', '44.7384', '-74.2488');
INSERT INTO `net_city` VALUES ('5738', '23', 'Саранак Лейк', 'Saranac Lake', 'NY', '12983', '44.3511', '-74.1034');
INSERT INTO `net_city` VALUES ('5744', '23', 'Камден Пойнт', 'Camden Point', 'MO', '64018', '39.4573', '-94.7220');
INSERT INTO `net_city` VALUES ('5749', '23', 'Селкирк', 'Selkirk', 'NY', '12158', '42.5357', '-73.8318');
INSERT INTO `net_city` VALUES ('5758', '23', 'Санта-Тереза', 'Santa Teresa', 'NM', '88008', '31.9460', '-106.8082');
INSERT INTO `net_city` VALUES ('5760', '23', 'Глендора', 'Glendora', 'CA', '91740', '34.1189', '-117.8507');
INSERT INTO `net_city` VALUES ('5763', '23', 'Уэйтсфилд', 'Waitsfield', 'VT', '05673', '44.2030', '-72.8428');
INSERT INTO `net_city` VALUES ('5764', '23', 'Мичиган Сити', 'Michigan City', 'IN', '46360', '41.6809', '-86.8658');
INSERT INTO `net_city` VALUES ('5772', '23', 'Линдхерст', 'Lyndhurst', 'NJ', '07071', '40.7923', '-74.1001');
INSERT INTO `net_city` VALUES ('5773', '23', 'Никасио', 'Nicasio', 'CA', '94946', '38.0714', '-122.6799');
INSERT INTO `net_city` VALUES ('5777', '23', 'Кантон', 'Canton', 'MS', '39046', '32.6252', '-90.0229');
INSERT INTO `net_city` VALUES ('5778', '23', 'Неошо', 'Neosho', 'MO', '64850', '36.8541', '-94.3990');
INSERT INTO `net_city` VALUES ('5781', '23', 'Перл', 'Pearl', 'MS', '39208', '32.2539', '-90.0948');
INSERT INTO `net_city` VALUES ('5787', '23', 'Роквилл Сентр', 'Rockville Centre', 'NY', '11570', '40.6659', '-73.6395');
INSERT INTO `net_city` VALUES ('5804', '23', 'Шелбивилл', 'Shelbyville', 'TN', '37160', '35.4615', '-86.4898');
INSERT INTO `net_city` VALUES ('5805', '23', 'Глендейл', 'Glendale', 'KY', '42740', '37.5803', '-85.9433');
INSERT INTO `net_city` VALUES ('5808', '23', 'Скотсвилл', 'Scottsville', 'KY', '42164', '36.7847', '-86.2119');
INSERT INTO `net_city` VALUES ('5811', '23', 'Брюс', 'Bruce', 'MS', '38915', '34.0237', '-89.3680');
INSERT INTO `net_city` VALUES ('5815', '23', 'Франклин', 'Franklin', 'KY', '42134', '36.7301', '-86.5615');
INSERT INTO `net_city` VALUES ('5827', '23', 'Берривилль', 'Berryville', 'VA', '22611', '39.1651', '-77.9759');
INSERT INTO `net_city` VALUES ('5830', '23', 'Биг Сюр', 'Big Sur', 'CA', '93920', '36.0858', '-121.6086');
INSERT INTO `net_city` VALUES ('5832', '23', 'Маунт Эйри', 'Mount Airy', 'MD', '21771', '39.3795', '-77.1656');
INSERT INTO `net_city` VALUES ('5835', '23', 'Такома Парк', 'Takoma Park', 'MD', '20912', '38.9827', '-77.0040');
INSERT INTO `net_city` VALUES ('5841', '23', 'Рутстаун', 'Rootstown', 'OH', '44272', '41.0908', '-81.1844');
INSERT INTO `net_city` VALUES ('5843', '23', 'Лост Крик', 'Lost Creek', 'KY', '41348', '37.4396', '-83.2979');
INSERT INTO `net_city` VALUES ('5847', '23', 'Ист Ливерпуль', 'East Liverpool', 'OH', '43920', '40.6805', '-80.5948');
INSERT INTO `net_city` VALUES ('5853', '23', 'Яколт', 'Yacolt', 'WA', '98675', '45.8380', '-122.3870');
INSERT INTO `net_city` VALUES ('5856', '23', 'Ларго', 'Largo', 'FL', '33774', '27.8846', '-82.8277');
INSERT INTO `net_city` VALUES ('5862', '23', 'Себринг', 'Sebring', 'FL', '33871', '27.4956', '-81.4409');
INSERT INTO `net_city` VALUES ('5871', '23', 'Плант Сити', 'Plant City', 'FL', '33563', '28.0184', '-82.1419');
INSERT INTO `net_city` VALUES ('5872', '23', 'Леканто', 'Lecanto', 'FL', '34461', '28.8001', '-82.4860');
INSERT INTO `net_city` VALUES ('5873', '23', 'Ленд О&#39;Лейкс', 'Land O\' Lakes', 'FL', '34639', '28.2580', '-82.4797');
INSERT INTO `net_city` VALUES ('5875', '23', 'Джэкпот', 'Jackpot', 'NV', '89825', '41.8540', '-114.7561');
INSERT INTO `net_city` VALUES ('5880', '23', 'Маллан', 'Mullan', 'ID', '83846', '47.4697', '-115.7426');
INSERT INTO `net_city` VALUES ('5881', '23', 'Бартау', 'Bartow', 'FL', '33830', '27.8889', '-81.8136');
INSERT INTO `net_city` VALUES ('5885', '23', 'Принс Фредерик', 'Prince Frederick', 'MD', '20678', '38.5185', '-76.5921');
INSERT INTO `net_city` VALUES ('5895', '23', 'Леитчфилд', 'Leitchfield', 'KY', '42754', '37.4564', '-86.3093');
INSERT INTO `net_city` VALUES ('5897', '23', 'Телл Сити', 'Tell City', 'IN', '47586', '38.0336', '-86.6853');
INSERT INTO `net_city` VALUES ('5900', '23', 'Лоренсберг', 'Lawrenceburg', 'KY', '40342', '38.0052', '-84.9830');
INSERT INTO `net_city` VALUES ('5901', '23', 'Принстон', 'Princeton', 'IN', '47670', '38.3353', '-87.5968');
INSERT INTO `net_city` VALUES ('5902', '23', 'Берея', 'Berea', 'KY', '40403', '37.5742', '-84.2700');
INSERT INTO `net_city` VALUES ('5903', '23', 'Блумсдейл', 'Bloomsdale', 'MO', '63627', '38.0381', '-90.2304');
INSERT INTO `net_city` VALUES ('5908', '23', 'Шолс', 'Shoals', 'IN', '47581', '38.6288', '-86.7863');
INSERT INTO `net_city` VALUES ('5909', '23', 'Барборвилл', 'Barbourville', 'KY', '40906', '36.9184', '-83.9049');
INSERT INTO `net_city` VALUES ('5916', '23', 'Шорхэм', 'Shoreham', 'VT', '05770', '43.8751', '-73.3234');
INSERT INTO `net_city` VALUES ('5918', '23', 'Квог', 'Quogue', 'NY', '11959', '40.8232', '-72.6095');
INSERT INTO `net_city` VALUES ('5919', '23', 'Медфорд', 'Medford', 'NY', '11763', '40.8314', '-72.9758');
INSERT INTO `net_city` VALUES ('5920', '23', 'Ранберн', 'Ranburne', 'AL', '36273', '33.5528', '-85.3881');
INSERT INTO `net_city` VALUES ('5921', '23', 'Бэй Шор', 'Bay Shore', 'NY', '11706', '40.7338', '-73.2652');
INSERT INTO `net_city` VALUES ('5922', '23', 'Риверхед', 'Riverhead', 'NY', '11901', '40.9539', '-72.6465');
INSERT INTO `net_city` VALUES ('5923', '23', 'Порт Джефферсон Стейшен', 'Port Jefferson Station', 'NY', '11776', '40.9130', '-73.0432');
INSERT INTO `net_city` VALUES ('5924', '23', 'Ист Сетокет', 'East Setauket', 'NY', '11733', '40.9317', '-73.1142');
INSERT INTO `net_city` VALUES ('5925', '23', 'Монток', 'Montauk', 'NY', '11954', '41.0310', '-71.9807');
INSERT INTO `net_city` VALUES ('5927', '23', 'Фолл-Ривер', 'Fall River', 'MA', '02721', '41.6734', '-71.1511');
INSERT INTO `net_city` VALUES ('5928', '23', 'Ист Провиденс', 'East Providence', 'RI', '02914', '41.8133', '-71.3619');
INSERT INTO `net_city` VALUES ('5929', '23', 'Покатак', 'Pawcatuck', 'CT', '06379', '41.3686', '-71.8637');
INSERT INTO `net_city` VALUES ('5933', '23', 'Бристоль', 'Bristol', 'RI', '02809', '41.6783', '-71.2708');
INSERT INTO `net_city` VALUES ('5934', '23', 'Норт Кингстаун', 'North Kingstown', 'RI', '02852', '41.5877', '-71.4623');
INSERT INTO `net_city` VALUES ('5938', '23', 'Сиконк', 'Seekonk', 'MA', '02771', '41.8387', '-71.3187');
INSERT INTO `net_city` VALUES ('5939', '23', 'Миддлборо', 'Middleboro', 'MA', '02346', '41.8803', '-70.8815');
INSERT INTO `net_city` VALUES ('5941', '23', 'Гианнис', 'Hyannis', 'MA', '02601', '41.6613', '-70.2988');
INSERT INTO `net_city` VALUES ('5943', '23', 'Рагленд', 'Ragland', 'AL', '35131', '33.7299', '-86.1773');
INSERT INTO `net_city` VALUES ('5945', '23', 'Истам', 'Eastham', 'MA', '02642', '41.8375', '-69.9748');
INSERT INTO `net_city` VALUES ('5946', '23', 'Нью-Бедфорд', 'New Bedford', 'MA', '02745', '41.7057', '-70.9469');
INSERT INTO `net_city` VALUES ('5947', '23', 'Мэттапойсетт', 'Mattapoisett', 'MA', '02739', '41.6649', '-70.8109');
INSERT INTO `net_city` VALUES ('5949', '23', 'Даунингтаун', 'Downingtown', 'PA', '19335', '40.0326', '-75.7190');
INSERT INTO `net_city` VALUES ('5952', '23', 'Вудс-Хол', 'Woods Hole', 'MA', '02543', '41.5281', '-70.6535');
INSERT INTO `net_city` VALUES ('5953', '23', 'Джонстон', 'Johnston', 'RI', '02919', '41.8287', '-71.5185');
INSERT INTO `net_city` VALUES ('5955', '23', 'Юба Сити', 'Yuba City', 'CA', '95993', '39.0529', '-121.7329');
INSERT INTO `net_city` VALUES ('5958', '23', 'Грант-Пасс', 'Grants Pass', 'OR', '97526', '42.5386', '-123.3478');
INSERT INTO `net_city` VALUES ('5959', '23', 'Брукингс', 'Brookings', 'OR', '97415', '42.1386', '-124.2464');
INSERT INTO `net_city` VALUES ('5964', '23', 'Дафер', 'Dufur', 'OR', '97021', '45.4047', '-121.1611');
INSERT INTO `net_city` VALUES ('5974', '23', 'Портедж', 'Portage', 'IN', '46368', '41.5933', '-87.1562');
INSERT INTO `net_city` VALUES ('5975', '23', 'Глен Ков', 'Glen Cove', 'NY', '11542', '40.8742', '-73.6232');
INSERT INTO `net_city` VALUES ('5978', '23', 'Чаннахон', 'Channahon', 'IL', '60410', '41.4510', '-88.2014');
INSERT INTO `net_city` VALUES ('5979', '23', 'Хилдейл', 'Hildale', 'UT', '84784', '37.0036', '-112.9669');
INSERT INTO `net_city` VALUES ('5982', '23', 'Минука', 'Minooka', 'IL', '60447', '41.4878', '-88.3254');
INSERT INTO `net_city` VALUES ('5983', '23', 'Ромеовилл', 'Romeoville', 'IL', '60446', '41.6398', '-88.1060');
INSERT INTO `net_city` VALUES ('5984', '23', 'Вудленд', 'Woodland', 'CA', '95695', '38.7144', '-121.8529');
INSERT INTO `net_city` VALUES ('5991', '23', 'Сперривилл', 'Sperryville', 'VA', '22740', '38.6353', '-78.2548');
INSERT INTO `net_city` VALUES ('5992', '23', 'Брендивайн', 'Brandywine', 'MD', '20613', '38.6500', '-76.8257');
INSERT INTO `net_city` VALUES ('5993', '23', 'Эннис', 'Ennis', 'TX', '75119', '32.3242', '-96.5873');
INSERT INTO `net_city` VALUES ('5996', '23', 'Харборсайд', 'Harborside', 'ME', '04642', '44.3341', '-68.8091');
INSERT INTO `net_city` VALUES ('6004', '23', 'Сомерсет', 'Somerset', 'KY', '42501', '37.0550', '-84.4551');
INSERT INTO `net_city` VALUES ('6006', '23', 'Кларксвилл', 'Clarksville', 'IN', '47129', '38.3136', '-85.7716');
INSERT INTO `net_city` VALUES ('6008', '23', 'Растберг', 'Rustburg', 'VA', '24588', '37.2544', '-79.0985');
INSERT INTO `net_city` VALUES ('6010', '23', 'Принс Джордж', 'Prince George', 'VA', '23875', '37.2292', '-77.2518');
INSERT INTO `net_city` VALUES ('6013', '23', 'Риптон', 'Ripton', 'VT', '05766', '43.9834', '-72.9854');
INSERT INTO `net_city` VALUES ('6014', '23', 'Мэдисон Хайтс', 'Madison Heights', 'VA', '24572', '37.4702', '-79.0652');
INSERT INTO `net_city` VALUES ('6015', '23', 'Стонтон', 'Staunton', 'VA', '24401', '38.1361', '-79.0623');
INSERT INTO `net_city` VALUES ('6020', '23', 'Брукнил', 'Brookneal', 'VA', '24528', '37.0754', '-78.9249');
INSERT INTO `net_city` VALUES ('6023', '23', 'Досуэлл', 'Doswell', 'VA', '23047', '37.8516', '-77.4820');
INSERT INTO `net_city` VALUES ('6024', '23', 'Беллфлауэр', 'Bellflower', 'CA', '90706', '33.8880', '-118.1304');
INSERT INTO `net_city` VALUES ('6025', '23', 'Линчберг', 'Lynchburg', 'VA', '24502', '37.3440', '-79.2064');
INSERT INTO `net_city` VALUES ('6027', '23', 'Алтависта', 'Altavista', 'VA', '24517', '37.1493', '-79.2328');
INSERT INTO `net_city` VALUES ('6030', '23', 'Милборо', 'Millboro', 'VA', '24460', '38.0219', '-79.6549');
INSERT INTO `net_city` VALUES ('6031', '23', 'Скотсвилл', 'Scottsville', 'VA', '24590', '37.8536', '-78.4641');
INSERT INTO `net_city` VALUES ('6034', '23', 'Неллисфорд', 'Nellysford', 'VA', '22958', '37.9019', '-78.9043');
INSERT INTO `net_city` VALUES ('6035', '23', 'Аррингтон', 'Arrington', 'VA', '22922', '37.7071', '-78.9376');
INSERT INTO `net_city` VALUES ('6038', '23', 'Ньюбери Парк', 'Newbury Park', 'CA', '91320', '34.1702', '-118.9558');
INSERT INTO `net_city` VALUES ('6046', '23', 'Лавония', 'Lavonia', 'GA', '30553', '34.4168', '-83.0738');
INSERT INTO `net_city` VALUES ('6049', '23', 'Монтроз', 'Montrose', 'CO', '81401', '38.4065', '-107.8902');
INSERT INTO `net_city` VALUES ('6052', '23', 'Фрута', 'Fruita', 'CO', '81521', '39.1910', '-108.7094');
INSERT INTO `net_city` VALUES ('6055', '23', 'Стерлинг', 'Sterling', 'CO', '80751', '40.6351', '-103.2305');
INSERT INTO `net_city` VALUES ('6056', '23', 'Джексон', 'Jackson', 'WY', '83001', '43.4560', '-110.5150');
INSERT INTO `net_city` VALUES ('6060', '23', 'Питтсбург', 'Pittsburg', 'CA', '94565', '38.0051', '-121.8387');
INSERT INTO `net_city` VALUES ('6067', '23', 'Лафайетт', 'Lafayette', 'CA', '94549', '37.9021', '-122.1157');
INSERT INTO `net_city` VALUES ('6068', '23', 'Оберн', 'Auburn', 'CA', '95603', '38.9234', '-121.0705');
INSERT INTO `net_city` VALUES ('6069', '23', 'Гринвуд', 'Greenwood', 'MS', '38930', '33.5236', '-90.1405');
INSERT INTO `net_city` VALUES ('6071', '23', 'Брентвуд', 'Brentwood', 'CA', '94513', '37.8754', '-121.6868');
INSERT INTO `net_city` VALUES ('6081', '23', 'Лаграндж', 'LaGrange', 'GA', '30240', '33.0054', '-85.1063');
INSERT INTO `net_city` VALUES ('6088', '23', 'Линкольн', 'Lincoln', 'CA', '95648', '38.9370', '-121.2519');
INSERT INTO `net_city` VALUES ('6093', '23', 'Нантакет', 'Nantucket', 'MA', '02554', '41.3152', '-70.0090');
INSERT INTO `net_city` VALUES ('6094', '23', 'Вудсток', 'Woodstock', 'GA', '30189', '34.1268', '-84.5740');
INSERT INTO `net_city` VALUES ('6099', '23', 'Картерсвилл', 'Cartersville', 'GA', '30120', '34.2187', '-84.8540');
INSERT INTO `net_city` VALUES ('6102', '23', 'Винн', 'Wynne', 'AR', '72396', '35.2418', '-90.8460');
INSERT INTO `net_city` VALUES ('6103', '23', 'Хантингтон-Бич', 'Huntington Beach', 'CA', '92649', '33.7110', '-118.0438');
INSERT INTO `net_city` VALUES ('6105', '23', 'Мэнсфилд', 'Mansfield', 'OH', '44905', '40.7788', '-82.4572');
INSERT INTO `net_city` VALUES ('6106', '23', 'Франклин', 'Franklin', 'WI', '53132', '42.8869', '-88.0096');
INSERT INTO `net_city` VALUES ('6107', '23', 'Корте Мадера', 'Corte Madera', 'CA', '94925', '37.9257', '-122.5127');
INSERT INTO `net_city` VALUES ('6108', '23', 'Элкхорн', 'Elkhorn', 'WI', '53121', '42.7130', '-88.5429');
INSERT INTO `net_city` VALUES ('6111', '23', 'Ту Риверс', 'Two Rivers', 'WI', '54241', '44.2255', '-87.6144');
INSERT INTO `net_city` VALUES ('6115', '23', 'Эль Монте', 'El Monte', 'CA', '91732', '34.0734', '-118.0139');
INSERT INTO `net_city` VALUES ('6118', '23', 'Стони-Крик', 'Stony Creek', 'VA', '23882', '36.9126', '-77.4403');
INSERT INTO `net_city` VALUES ('6119', '23', 'Вайлвуд', 'Wildwood', 'MO', '63011', '38.6076', '-90.5597');
INSERT INTO `net_city` VALUES ('6120', '23', 'Тэйлорсвилл', 'Taylorville', 'IL', '62568', '39.5546', '-89.2929');
INSERT INTO `net_city` VALUES ('6123', '23', 'Минерал Пойнт', 'Mineral Point', 'MO', '63660', '37.9149', '-90.7077');
INSERT INTO `net_city` VALUES ('6124', '23', 'Шелл Ноб', 'Shell Knob', 'MO', '65747', '36.6276', '-93.4744');
INSERT INTO `net_city` VALUES ('6125', '23', 'Роджерс', 'Rogers', 'AR', '72758', '36.3018', '-94.1215');
INSERT INTO `net_city` VALUES ('6126', '23', 'Боливар', 'Bolivar', 'MO', '65613', '37.6422', '-93.3996');
INSERT INTO `net_city` VALUES ('6127', '23', 'Сайлом-Спрингс', 'Siloam Springs', 'AR', '72761', '36.1690', '-94.4564');
INSERT INTO `net_city` VALUES ('6128', '23', 'Миллер', 'Miller', 'MO', '65707', '37.2306', '-93.8485');
INSERT INTO `net_city` VALUES ('6129', '23', 'Хемфилл', 'Hemphill', 'TX', '75948', '31.3281', '-93.8082');
INSERT INTO `net_city` VALUES ('6135', '23', 'Уэслако', 'Weslaco', 'TX', '78596', '26.1722', '-97.9812');
INSERT INTO `net_city` VALUES ('6136', '23', 'Санданс', 'Sundance', 'UT', '84062', '40.4647', '-111.6332');
INSERT INTO `net_city` VALUES ('6141', '23', 'Ричмонд Хилл', 'Richmond Hill', 'GA', '31324', '31.8546', '-81.2738');
INSERT INTO `net_city` VALUES ('6146', '23', 'Бримфилд', 'Brimfield', 'OH', '44240', '41.1352', '-81.3260');
INSERT INTO `net_city` VALUES ('6148', '23', 'Элк', 'Elk', 'WA', '99009', '48.0130', '-117.2240');
INSERT INTO `net_city` VALUES ('6149', '23', 'Ла Гранде', 'La Grande', 'OR', '97850', '45.3230', '-118.2027');
INSERT INTO `net_city` VALUES ('6151', '23', 'Хавр', 'Havre', 'MT', '59501', '48.5666', '-109.7389');
INSERT INTO `net_city` VALUES ('6153', '23', 'Орофино', 'Orofino', 'ID', '83544', '46.4867', '-116.1268');
INSERT INTO `net_city` VALUES ('6154', '23', 'Грейт-Фолс', 'Great Falls', 'MT', '59405', '47.2994', '-111.3441');
INSERT INTO `net_city` VALUES ('6155', '23', 'Сейнт Марис', 'Saint Maries', 'ID', '83861', '47.2010', '-116.5521');
INSERT INTO `net_city` VALUES ('6156', '23', 'Раунд Хилл', 'Round Hill', 'VA', '20141', '39.1034', '-77.7919');
INSERT INTO `net_city` VALUES ('6157', '23', 'Чапин', 'Chapin', 'SC', '29036', '34.1404', '-81.3369');
INSERT INTO `net_city` VALUES ('6158', '23', 'Самтер', 'Sumter', 'SC', '29150', '33.8808', '-80.3536');
INSERT INTO `net_city` VALUES ('6159', '23', 'Роскоммон', 'Roscommon', 'MI', '48653', '44.4669', '-84.6129');
INSERT INTO `net_city` VALUES ('6162', '23', 'Гранд Хейвен', 'Grand Haven', 'MI', '49417', '43.0161', '-86.1267');
INSERT INTO `net_city` VALUES ('6163', '23', 'Бентон Харбор', 'Benton Harbor', 'MI', '49022', '42.1273', '-86.3073');
INSERT INTO `net_city` VALUES ('6164', '23', 'Оватонна', 'Owatonna', 'MN', '55060', '44.0479', '-93.2260');
INSERT INTO `net_city` VALUES ('6165', '23', 'Райс Лейк', 'Rice Lake', 'WI', '54868', '45.5233', '-91.6999');
INSERT INTO `net_city` VALUES ('6166', '23', 'Аддисон', 'Addison', 'IL', '60101', '41.9310', '-88.0090');
INSERT INTO `net_city` VALUES ('6167', '23', 'Уорренвилл', 'Warrenville', 'IL', '60555', '41.8251', '-88.2049');
INSERT INTO `net_city` VALUES ('6168', '23', 'Глен Эллин', 'Glen Ellyn', 'IL', '60137', '41.8661', '-88.0583');
INSERT INTO `net_city` VALUES ('6171', '23', 'Стейтсборо', 'Statesboro', 'GA', '30458', '32.3729', '-81.8443');
INSERT INTO `net_city` VALUES ('6172', '23', 'Бонифей', 'Bonifay', 'FL', '32425', '30.8257', '-85.7357');
INSERT INTO `net_city` VALUES ('6173', '23', 'Гадсден', 'Gadsden', 'AL', '35903', '34.0379', '-85.8105');
INSERT INTO `net_city` VALUES ('6175', '23', 'Марианна', 'Marianna', 'FL', '32448', '30.6755', '-85.2014');
INSERT INTO `net_city` VALUES ('6176', '23', 'Перри', 'Perry', 'FL', '32347', '30.1883', '-83.5514');
INSERT INTO `net_city` VALUES ('6180', '23', 'Форт Ливенворт', 'Fort Leavenworth', 'KS', '66027', '39.3603', '-94.9151');
INSERT INTO `net_city` VALUES ('6181', '23', 'Монаханс', 'Monahans', 'TX', '79756', '31.5398', '-102.8812');
INSERT INTO `net_city` VALUES ('6188', '23', 'Деннисон', 'Dennison', 'OH', '44621', '40.4276', '-81.2927');
INSERT INTO `net_city` VALUES ('6190', '23', 'Соломон', 'Solomon', 'KS', '67480', '38.9577', '-97.4086');
INSERT INTO `net_city` VALUES ('6197', '23', 'Фаллон', 'Fallon', 'NV', '89406', '39.5049', '-118.2899');
INSERT INTO `net_city` VALUES ('6198', '23', 'Гровер Бич', 'Grover Beach', 'CA', '93433', '35.1212', '-120.6193');
INSERT INTO `net_city` VALUES ('6200', '23', 'Уэстчестер', 'Westchester', 'IL', '60154', '41.8487', '-87.8921');
INSERT INTO `net_city` VALUES ('6201', '23', 'Корнелл', 'Cornell', 'IL', '61319', '41.0251', '-88.7296');
INSERT INTO `net_city` VALUES ('6202', '23', 'Гумбольдт', 'Humboldt', 'TN', '38343', '35.8193', '-88.9522');
INSERT INTO `net_city` VALUES ('6204', '23', 'Трион', 'Tryon', 'NC', '28782', '35.2406', '-82.0487');
INSERT INTO `net_city` VALUES ('6205', '23', 'Оуэнс Кросс Роудс', 'Owens Cross Roads', 'AL', '35763', '34.6340', '-86.4570');
INSERT INTO `net_city` VALUES ('6206', '23', 'О-Клэр', 'Eau Claire', 'WI', '54703', '44.8340', '-91.5729');
INSERT INTO `net_city` VALUES ('6208', '23', 'Нью Ричмонд', 'New Richmond', 'WI', '54017', '45.1261', '-92.5128');
INSERT INTO `net_city` VALUES ('6209', '23', 'Мондови', 'Mondovi', 'WI', '54755', '44.5784', '-91.7148');
INSERT INTO `net_city` VALUES ('6214', '23', 'Висконсин Делс', 'Wisconsin Dells', 'WI', '53965', '43.6964', '-89.7575');
INSERT INTO `net_city` VALUES ('6220', '23', 'Фладвуд', 'Floodwood', 'MN', '55736', '46.9810', '-92.8971');
INSERT INTO `net_city` VALUES ('6226', '23', 'Драмс', 'Drums', 'PA', '18222', '41.0484', '-76.0019');
INSERT INTO `net_city` VALUES ('6233', '23', 'Понтиак', 'Pontiac', 'IL', '61764', '40.8730', '-88.6244');
INSERT INTO `net_city` VALUES ('6236', '23', 'Эджуотер', 'Edgewater', 'NJ', '07020', '40.8269', '-73.9765');
INSERT INTO `net_city` VALUES ('6239', '23', 'Лафокс', 'Lafox', 'IL', '60147', '41.8842', '-88.4325');
INSERT INTO `net_city` VALUES ('6243', '23', 'Пейнтсвилл', 'Paintsville', 'KY', '41240', '37.8156', '-82.7828');
INSERT INTO `net_city` VALUES ('6244', '23', 'Сонора', 'Sonora', 'CA', '95370', '37.9843', '-120.3900');
INSERT INTO `net_city` VALUES ('6246', '23', 'Форрест', 'Forrest', 'IL', '61741', '40.7577', '-88.3961');
INSERT INTO `net_city` VALUES ('6248', '23', 'Ранчо Мираж', 'Rancho Mirage', 'CA', '92270', '33.7854', '-116.4190');
INSERT INTO `net_city` VALUES ('6252', '23', 'Норт Палм Спрингс', 'North Palm Springs', 'CA', '92258', '33.9228', '-116.5431');
INSERT INTO `net_city` VALUES ('6255', '23', 'Линкольн', 'Lincoln', 'IL', '62656', '40.1291', '-89.3641');
INSERT INTO `net_city` VALUES ('6262', '23', 'Касселберри', 'Casselberry', 'FL', '32707', '28.6616', '-81.3120');
INSERT INTO `net_city` VALUES ('6265', '23', 'Конкорд', 'Concord', 'MA', '01742', '42.4586', '-71.3597');
INSERT INTO `net_city` VALUES ('6266', '23', 'Нидхам', 'Needham', 'MA', '02492', '42.2793', '-71.2450');
INSERT INTO `net_city` VALUES ('6270', '23', 'Соломонс', 'Solomons', 'MD', '20688', '38.3346', '-76.4681');
INSERT INTO `net_city` VALUES ('6272', '23', 'Северна Парк', 'Severna Park', 'MD', '21146', '39.0735', '-76.5654');
INSERT INTO `net_city` VALUES ('6275', '23', 'Катонсвилл', 'Catonsville', 'MD', '21228', '39.2694', '-76.7447');
INSERT INTO `net_city` VALUES ('6282', '23', 'Честертаун', 'Chestertown', 'MD', '21620', '39.1934', '-76.0969');
INSERT INTO `net_city` VALUES ('6283', '23', 'Стивенсвилл', 'Stevensville', 'MD', '21666', '38.9380', '-76.3325');
INSERT INTO `net_city` VALUES ('6284', '23', 'Дэвидсонвилл', 'Davidsonville', 'MD', '21035', '38.9392', '-76.6350');
INSERT INTO `net_city` VALUES ('6285', '23', 'Эджвуд', 'Edgewood', 'MD', '21040', '39.4329', '-76.2931');
INSERT INTO `net_city` VALUES ('6289', '23', 'Дил', 'Deale', 'MD', '20751', '38.7872', '-76.5436');
INSERT INTO `net_city` VALUES ('6292', '23', 'Боуи', 'Bowie', 'MD', '20715', '38.9927', '-76.7383');
INSERT INTO `net_city` VALUES ('6294', '23', 'Батсвилл', 'Batesville', 'IN', '47006', '39.2951', '-85.2107');
INSERT INTO `net_city` VALUES ('6295', '23', 'Винсеннес', 'Vincennes', 'IN', '47591', '38.6389', '-87.5276');
INSERT INTO `net_city` VALUES ('6296', '23', 'Уэртингтон', 'Worthington', 'IN', '47471', '39.1464', '-86.9993');
INSERT INTO `net_city` VALUES ('6297', '23', 'Ренсселаер', 'Rensselaer', 'IN', '47978', '40.9943', '-87.1229');
INSERT INTO `net_city` VALUES ('6298', '23', 'Гэри', 'Gary', 'IN', '46402', '41.6080', '-87.3411');
INSERT INTO `net_city` VALUES ('6299', '23', 'Калумет Сити', 'Calumet City', 'IL', '60409', '41.6092', '-87.5534');
INSERT INTO `net_city` VALUES ('6304', '23', 'Алзип', 'Alsip', 'IL', '60803', '41.6714', '-87.7371');
INSERT INTO `net_city` VALUES ('6307', '23', 'Честертон', 'Chesterton', 'IN', '46304', '41.6162', '-87.0489');
INSERT INTO `net_city` VALUES ('6313', '23', 'Порт Гурон', 'Port Huron', 'MI', '48060', '42.9875', '-82.4666');
INSERT INTO `net_city` VALUES ('6318', '23', 'Бэй Сити', 'Bay City', 'MI', '48708', '43.5674', '-83.8221');
INSERT INTO `net_city` VALUES ('6319', '23', 'Лапир', 'Lapeer', 'MI', '48446', '43.0519', '-83.3346');
INSERT INTO `net_city` VALUES ('6325', '23', 'Леуэс', 'Lewes', 'DE', '19958', '38.7259', '-75.1678');
INSERT INTO `net_city` VALUES ('6326', '23', 'Леонард', 'Leonard', 'MI', '48367', '42.8437', '-83.1409');
INSERT INTO `net_city` VALUES ('6331', '23', 'Шелби Тауншип', 'Shelby Township', 'MI', '48094', '42.7364', '-83.0374');
INSERT INTO `net_city` VALUES ('6333', '23', 'Дэвисон', 'Davison', 'MI', '48423', '43.0443', '-83.5192');
INSERT INTO `net_city` VALUES ('6335', '23', 'Кларкстон', 'Clarkston', 'MI', '48346', '42.7237', '-83.4222');
INSERT INTO `net_city` VALUES ('6337', '23', 'Франкония', 'Franconia', 'NH', '03580', '44.1635', '-71.7612');
INSERT INTO `net_city` VALUES ('6345', '23', 'Черч Хилл', 'Church Hill', 'TN', '37642', '36.5532', '-82.7290');
INSERT INTO `net_city` VALUES ('6347', '23', 'Хартсвилл', 'Hartsville', 'SC', '29550', '34.4021', '-80.0767');
INSERT INTO `net_city` VALUES ('6348', '23', 'Ормонд Бич', 'Ormond Beach', 'FL', '32174', '29.3005', '-81.1948');
INSERT INTO `net_city` VALUES ('6349', '23', 'Монро', 'Monroe', 'NC', '28110', '35.0691', '-80.5302');
INSERT INTO `net_city` VALUES ('6353', '23', 'Коралвилл', 'Coralville', 'IA', '52241', '41.6946', '-91.5954');
INSERT INTO `net_city` VALUES ('6358', '23', 'Сан-Бруно', 'San Bruno', 'CA', '94066', '37.6228', '-122.4364');
INSERT INTO `net_city` VALUES ('6369', '23', 'Гаррисон', 'Harrison', 'AR', '72602', '36.2298', '-93.1077');
INSERT INTO `net_city` VALUES ('6372', '23', 'Вайнскотт', 'Wainscott', 'NY', '11975', '40.9368', '-72.2429');
INSERT INTO `net_city` VALUES ('6373', '23', 'Марионвилл', 'Marionville', 'MO', '65705', '37.0558', '-93.6282');
INSERT INTO `net_city` VALUES ('6381', '23', 'Спрингдейл', 'Springdale', 'AR', '72764', '36.1737', '-94.0800');
INSERT INTO `net_city` VALUES ('6382', '23', 'Гейнсвилл', 'Gainesville', 'MO', '65655', '36.6082', '-92.4348');
INSERT INTO `net_city` VALUES ('6384', '23', 'Кимберлинг Сити', 'Kimberling City', 'MO', '65686', '36.6291', '-93.4440');
INSERT INTO `net_city` VALUES ('6385', '23', 'Фармингтон', 'Farmington', 'MO', '63640', '37.7721', '-90.3672');
INSERT INTO `net_city` VALUES ('6387', '23', 'Нью Флоренс', 'New Florence', 'MO', '63363', '38.8832', '-91.4521');
INSERT INTO `net_city` VALUES ('6390', '23', 'Каттава', 'Kuttawa', 'KY', '42055', '37.0753', '-88.1649');
INSERT INTO `net_city` VALUES ('6392', '23', 'Чатем', 'Chatham', 'IL', '62629', '39.6843', '-89.7237');
INSERT INTO `net_city` VALUES ('6396', '23', 'Дю Квойн', 'Du Quoin', 'IL', '62832', '38.0027', '-89.2479');
INSERT INTO `net_city` VALUES ('6399', '23', 'Асбери Парк', 'Asbury Park', 'NJ', '07712', '40.2434', '-74.0387');
INSERT INTO `net_city` VALUES ('6400', '23', 'Томс Ривер', 'Toms River', 'NJ', '08755', '40.0040', '-74.2258');
INSERT INTO `net_city` VALUES ('6401', '23', 'Фармингдейл', 'Farmingdale', 'NJ', '07727', '40.2093', '-74.1588');
INSERT INTO `net_city` VALUES ('6402', '23', 'Хауэлл', 'Howell', 'NJ', '07731', '40.1524', '-74.1978');
INSERT INTO `net_city` VALUES ('6403', '23', 'Атлантик Хайлендс', 'Atlantic Highlands', 'NJ', '07716', '40.4033', '-74.0364');
INSERT INTO `net_city` VALUES ('6405', '23', 'Ред Банк', 'Red Bank', 'NJ', '07701', '40.3603', '-74.0728');
INSERT INTO `net_city` VALUES ('6406', '23', 'Нептьюн', 'Neptune', 'NJ', '07753', '40.2182', '-74.0710');
INSERT INTO `net_city` VALUES ('6411', '23', 'Манасквен', 'Manasquan', 'NJ', '08736', '40.1202', '-74.0673');
INSERT INTO `net_city` VALUES ('6412', '23', 'Пойнт-Плезант-Бич', 'Point Pleasant Beach', 'NJ', '08742', '40.0808', '-74.0492');
INSERT INTO `net_city` VALUES ('6414', '23', 'Пайнвилл', 'Pineville', 'NC', '28134', '35.0776', '-80.8907');
INSERT INTO `net_city` VALUES ('6415', '23', 'Морганвилл', 'Morganville', 'NJ', '07751', '40.3595', '-74.2628');
INSERT INTO `net_city` VALUES ('6416', '23', 'Лонг Бранч', 'Long Branch', 'NJ', '07740', '40.2944', '-73.9932');
INSERT INTO `net_city` VALUES ('6418', '23', 'Сег Харбор', 'Sag Harbor', 'NY', '11963', '40.9967', '-72.3226');
INSERT INTO `net_city` VALUES ('6419', '23', 'Лиссабон', 'Lisbon', 'NH', '03585', '44.2079', '-71.8839');
INSERT INTO `net_city` VALUES ('6420', '23', 'Тауншенд', 'Townshend', 'VT', '05353', '43.0766', '-72.6687');
INSERT INTO `net_city` VALUES ('6421', '23', 'Альтон Бэй', 'Alton Bay', 'NH', '03810', '43.4993', '-71.2751');
INSERT INTO `net_city` VALUES ('6428', '23', 'Кин', 'Keene', 'NH', '03431', '42.9703', '-72.2800');
INSERT INTO `net_city` VALUES ('6429', '23', 'Кэмптон', 'Campton', 'NH', '03223', '43.8896', '-71.6132');
INSERT INTO `net_city` VALUES ('6430', '23', 'Лебанон', 'Lebanon', 'NH', '03766', '43.6361', '-72.2413');
INSERT INTO `net_city` VALUES ('6431', '23', 'Элирия', 'Elyria', 'OH', '44035', '41.3649', '-82.1150');
INSERT INTO `net_city` VALUES ('6438', '23', 'Сейнт Джонсбери', 'Saint Johnsbury', 'VT', '05819', '44.4160', '-71.9849');
INSERT INTO `net_city` VALUES ('6440', '23', 'Паунал', 'Pownal', 'VT', '05261', '42.7905', '-73.2158');
INSERT INTO `net_city` VALUES ('6441', '23', 'Тилтон', 'Tilton', 'NH', '03276', '43.4329', '-71.5682');
INSERT INTO `net_city` VALUES ('6442', '23', 'Уэст Лебанон', 'West Lebanon', 'NH', '03784', '43.6442', '-72.3066');
INSERT INTO `net_city` VALUES ('6444', '23', 'Вудсток', 'Woodstock', 'VT', '05091', '43.6470', '-72.5617');
INSERT INTO `net_city` VALUES ('6445', '23', 'Норидж', 'Norwich', 'VT', '05055', '43.7511', '-72.3142');
INSERT INTO `net_city` VALUES ('6446', '23', 'Честер', 'Chester', 'PA', '19013', '39.8489', '-75.3823');
INSERT INTO `net_city` VALUES ('6447', '23', 'Уортен', 'Warthen', 'GA', '31094', '33.1293', '-82.8057');
INSERT INTO `net_city` VALUES ('6453', '23', 'Аппер Малборо', 'Upper Marlboro', 'MD', '20774', '38.8922', '-76.7681');
INSERT INTO `net_city` VALUES ('6454', '23', 'Юниверсал Сити', 'Universal City', 'TX', '78148', '29.5423', '-98.2964');
INSERT INTO `net_city` VALUES ('6458', '23', 'Сифорд', 'Seaford', 'VA', '23696', '37.1915', '-76.3919');
INSERT INTO `net_city` VALUES ('6459', '23', 'Йорктаун', 'Yorktown', 'VA', '23690', '37.2143', '-76.5173');
INSERT INTO `net_city` VALUES ('6460', '23', 'Портсмут', 'Portsmouth', 'VA', '23704', '36.8233', '-76.3180');
INSERT INTO `net_city` VALUES ('6464', '23', 'Оуквуд', 'Oakwood', 'GA', '30566', '34.2345', '-83.8943');
INSERT INTO `net_city` VALUES ('6465', '23', 'Норфолк', 'Norfolk', 'VA', '23510', '36.8530', '-76.2882');
INSERT INTO `net_city` VALUES ('6467', '23', 'Салуда', 'Saluda', 'VA', '23149', '37.5722', '-76.6133');
INSERT INTO `net_city` VALUES ('6469', '23', 'Колумбайана', 'Columbiana', 'AL', '35051', '33.2227', '-86.6085');
INSERT INTO `net_city` VALUES ('6470', '23', 'Глостер', 'Gloucester', 'VA', '23061', '37.4469', '-76.5531');
INSERT INTO `net_city` VALUES ('6474', '23', 'Килмарнок', 'Kilmarnock', 'VA', '22482', '37.7436', '-76.3523');
INSERT INTO `net_city` VALUES ('6476', '23', 'Суффолк', 'Suffolk', 'VA', '23435', '36.8279', '-76.4800');
INSERT INTO `net_city` VALUES ('6489', '23', 'Бланчестер', 'Blanchester', 'OH', '45107', '39.2831', '-83.9668');
INSERT INTO `net_city` VALUES ('6490', '23', 'Сидни', 'Sidney', 'OH', '45365', '40.2839', '-84.1648');
INSERT INTO `net_city` VALUES ('6499', '23', 'Эрбана', 'Urbana', 'OH', '43078', '40.1183', '-83.7834');
INSERT INTO `net_city` VALUES ('6501', '23', 'Тарзана', 'Tarzana', 'CA', '91356', '34.1553', '-118.5476');
INSERT INTO `net_city` VALUES ('6504', '23', 'Рашвилл', 'Rushville', 'IN', '46173', '39.6032', '-85.4301');
INSERT INTO `net_city` VALUES ('6507', '23', 'Трой', 'Troy', 'OH', '45373', '40.0358', '-84.1775');
INSERT INTO `net_city` VALUES ('6509', '23', 'Спрингборо', 'Springboro', 'OH', '45066', '39.5407', '-84.2212');
INSERT INTO `net_city` VALUES ('6510', '23', 'Белбрук', 'Bellbrook', 'OH', '45305', '39.6339', '-84.0740');
INSERT INTO `net_city` VALUES ('6511', '23', 'Латти', 'Latty', 'OH', '45855', '41.0887', '-84.5852');
INSERT INTO `net_city` VALUES ('6512', '23', 'Энглвуд', 'Englewood', 'OH', '45322', '39.8848', '-84.3321');
INSERT INTO `net_city` VALUES ('6517', '23', 'Килин', 'Killeen', 'TX', '76544', '31.2164', '-97.7418');
INSERT INTO `net_city` VALUES ('6520', '23', 'Вилла Рика', 'Villa Rica', 'GA', '30180', '33.7105', '-84.9112');
INSERT INTO `net_city` VALUES ('6521', '23', 'Плезантвилл', 'Pleasantville', 'NJ', '08232', '39.3914', '-74.5182');
INSERT INTO `net_city` VALUES ('6523', '23', 'Мейс Ландинг', 'Mays Landing', 'NJ', '08330', '39.4543', '-74.7321');
INSERT INTO `net_city` VALUES ('6524', '23', 'Пеннс Гров', 'Penns Grove', 'NJ', '08069', '39.7064', '-75.4498');
INSERT INTO `net_city` VALUES ('6525', '23', 'Уинслоу', 'Winslow', 'NJ', '08095', '39.6573', '-74.8624');
INSERT INTO `net_city` VALUES ('6528', '23', 'Блэквуд', 'Blackwood', 'NJ', '08012', '39.7796', '-75.0505');
INSERT INTO `net_city` VALUES ('6529', '23', 'Милвилл', 'Millville', 'NJ', '08332', '39.3784', '-75.0236');
INSERT INTO `net_city` VALUES ('6532', '23', 'Порт Хадлок', 'Port Hadlock', 'WA', '98339', '48.0047', '-122.7495');
INSERT INTO `net_city` VALUES ('6533', '23', 'Мурфилд', 'Moorefield', 'WV', '26836', '39.0026', '-78.9616');
INSERT INTO `net_city` VALUES ('6534', '23', 'Бойерс', 'Boyers', 'PA', '16020', '41.1108', '-79.8975');
INSERT INTO `net_city` VALUES ('6536', '23', 'Ньюэлл', 'Newell', 'WV', '26050', '40.6046', '-80.6095');
INSERT INTO `net_city` VALUES ('6538', '23', 'Глассборо', 'Glassboro', 'NJ', '08028', '39.6969', '-75.1250');
INSERT INTO `net_city` VALUES ('6539', '23', 'Бриджтон', 'Bridgeton', 'NJ', '08302', '39.4238', '-75.2577');
INSERT INTO `net_city` VALUES ('6541', '23', 'Траутдейл', 'Troutdale', 'VA', '24378', '36.6983', '-81.4562');
INSERT INTO `net_city` VALUES ('6544', '23', 'Чемпион', 'Champion', 'PA', '15622', '40.0303', '-79.3217');
INSERT INTO `net_city` VALUES ('6545', '23', 'Камберленд', 'Cumberland', 'MD', '21502', '39.6351', '-78.7665');
INSERT INTO `net_city` VALUES ('6549', '23', 'Мэдфорд', 'Medford', 'NJ', '08055', '39.8741', '-74.8090');
INSERT INTO `net_city` VALUES ('6550', '23', 'Геттисберг', 'Gettysburg', 'PA', '17325', '39.8418', '-77.2291');
INSERT INTO `net_city` VALUES ('6551', '23', 'Мексия', 'Mexia', 'TX', '76667', '31.6626', '-96.4935');
INSERT INTO `net_city` VALUES ('6552', '23', 'Крессон', 'Cresson', 'TX', '76035', '32.5421', '-97.6009');
INSERT INTO `net_city` VALUES ('6562', '23', 'Уайтхаус Стейшен', 'Whitehouse Station', 'NJ', '08889', '40.6130', '-74.7682');
INSERT INTO `net_city` VALUES ('6570', '23', 'Фордс', 'Fords', 'NJ', '08863', '40.5377', '-74.3111');
INSERT INTO `net_city` VALUES ('6571', '23', 'Фоллбрук', 'Fallbrook', 'CA', '92028', '33.3989', '-117.2957');
INSERT INTO `net_city` VALUES ('6581', '23', 'Лейк Уорт', 'Lake Worth', 'FL', '33462', '26.5792', '-80.0806');
INSERT INTO `net_city` VALUES ('6582', '23', 'Бойнтон Бич', 'Boynton Beach', 'FL', '33426', '26.5282', '-80.0843');
INSERT INTO `net_city` VALUES ('6584', '23', 'Палм-Бич', 'Palm Beach', 'FL', '33480', '26.6779', '-80.0380');
INSERT INTO `net_city` VALUES ('6585', '23', 'Джупитер', 'Jupiter', 'FL', '33477', '26.9197', '-80.0734');
INSERT INTO `net_city` VALUES ('6586', '23', 'Льюис Ран', 'Lewis Run', 'PA', '16738', '41.8200', '-78.6703');
INSERT INTO `net_city` VALUES ('6587', '23', 'Галлатин', 'Gallatin', 'TN', '37066', '36.3913', '-86.4547');
INSERT INTO `net_city` VALUES ('6594', '23', 'Монровилл', 'Monroeville', 'NJ', '08343', '39.6435', '-75.1748');
INSERT INTO `net_city` VALUES ('6595', '23', 'Глостер Сити', 'Gloucester City', 'NJ', '08030', '39.8904', '-75.1152');
INSERT INTO `net_city` VALUES ('6599', '23', 'Раунд Топ', 'Round Top', 'TX', '78954', '30.0498', '-96.6778');
INSERT INTO `net_city` VALUES ('6604', '23', 'Помптон Плейнс', 'Pompton Plains', 'NJ', '07444', '40.9697', '-74.3042');
INSERT INTO `net_city` VALUES ('6606', '23', 'Магнолия', 'Magnolia', 'AR', '71753', '33.2409', '-93.1992');
INSERT INTO `net_city` VALUES ('6608', '23', 'Хасбрак Хайтс', 'Hasbrouck Heights', 'NJ', '07604', '40.8617', '-74.0737');
INSERT INTO `net_city` VALUES ('6613', '23', 'Элленсберг', 'Ellensburg', 'WA', '98926', '46.9790', '-120.4703');
INSERT INTO `net_city` VALUES ('6615', '23', 'Сайпресс', 'Cypress', 'CA', '90630', '33.8188', '-118.0377');
INSERT INTO `net_city` VALUES ('6617', '23', 'Рутерфорд', 'Rutherford', 'NJ', '07070', '40.8259', '-74.1079');
INSERT INTO `net_city` VALUES ('6619', '23', 'Саут Хаккенсак', 'South Hackensack', 'NJ', '07606', '40.8639', '-74.0483');
INSERT INTO `net_city` VALUES ('6634', '23', 'Дель Рио', 'Del Rio', 'TX', '78840', '29.6195', '-100.8089');
INSERT INTO `net_city` VALUES ('6635', '23', 'Пост-Фоллс', 'Post Falls', 'ID', '83854', '47.7892', '-117.0266');
INSERT INTO `net_city` VALUES ('6636', '23', 'Матис', 'Mathis', 'TX', '78368', '28.1087', '-97.8061');
INSERT INTO `net_city` VALUES ('6638', '23', 'Джонсон Сити', 'Johnson City', 'TX', '78636', '30.3157', '-98.3944');
INSERT INTO `net_city` VALUES ('6639', '23', 'Порт Аранзас', 'Port Aransas', 'TX', '78373', '27.7593', '-97.1161');
INSERT INTO `net_city` VALUES ('6641', '23', 'Шепердсвилл', 'Shepherdsville', 'KY', '40165', '37.9633', '-85.7026');
INSERT INTO `net_city` VALUES ('6642', '23', 'Тиффин', 'Tiffin', 'OH', '44883', '41.1245', '-83.1212');
INSERT INTO `net_city` VALUES ('6644', '23', 'Делавэр', 'Delaware', 'OH', '43015', '40.2827', '-83.0559');
INSERT INTO `net_city` VALUES ('6645', '23', 'Халф Мун Бэй', 'Half Moon Bay', 'CA', '94019', '37.4436', '-122.4124');
INSERT INTO `net_city` VALUES ('6652', '23', 'Вабассо', 'Wabasso', 'MN', '56293', '44.4244', '-95.2489');
INSERT INTO `net_city` VALUES ('6653', '23', 'Гранд-Форкс', 'Grand Forks', 'ND', '58208', '47.9253', '-97.0328');
INSERT INTO `net_city` VALUES ('6654', '23', 'Довер', 'Dover', 'OH', '44622', '40.5641', '-81.4836');
INSERT INTO `net_city` VALUES ('6658', '23', 'Монтара', 'Montara', 'CA', '94037', '37.5422', '-122.5161');
INSERT INTO `net_city` VALUES ('6664', '23', 'Ментон', 'Mentone', 'IN', '46539', '41.1658', '-86.0161');
INSERT INTO `net_city` VALUES ('6665', '23', 'Кендаллвилл', 'Kendallville', 'IN', '46755', '41.4464', '-85.2737');
INSERT INTO `net_city` VALUES ('6667', '23', 'Кассополис', 'Cassopolis', 'MI', '49031', '41.8980', '-86.0015');
INSERT INTO `net_city` VALUES ('6680', '23', 'Данвилл', 'Danville', 'IL', '61832', '40.1530', '-87.6459');
INSERT INTO `net_city` VALUES ('6684', '23', 'Колумбия Сити', 'Columbia City', 'IN', '46725', '41.1532', '-85.4810');
INSERT INTO `net_city` VALUES ('6692', '23', 'Саут Хейвен', 'South Haven', 'MI', '49090', '42.4231', '-86.2187');
INSERT INTO `net_city` VALUES ('6695', '23', 'Берн', 'Berne', 'IN', '46711', '40.6588', '-84.9350');
INSERT INTO `net_city` VALUES ('6696', '23', 'Нокс', 'Knox', 'IN', '46534', '41.2810', '-86.6210');
INSERT INTO `net_city` VALUES ('6697', '23', 'Бьюкенен', 'Buchanan', 'MI', '49107', '41.8424', '-86.4234');
INSERT INTO `net_city` VALUES ('6700', '23', 'Доваджиак', 'Dowagiac', 'MI', '49047', '41.9881', '-86.1089');
INSERT INTO `net_city` VALUES ('6701', '23', 'Мишока', 'Mishawaka', 'IN', '46545', '41.6925', '-86.1448');
INSERT INTO `net_city` VALUES ('6702', '23', 'Уинамак', 'Winamac', 'IN', '46996', '41.0458', '-86.6222');
INSERT INTO `net_city` VALUES ('6705', '23', 'Теллико Плейнс', 'Tellico Plains', 'TN', '37385', '35.3420', '-84.2253');
INSERT INTO `net_city` VALUES ('6706', '23', 'Сачес', 'Suches', 'GA', '30572', '34.7479', '-84.0673');
INSERT INTO `net_city` VALUES ('6709', '23', 'Атенс', 'Athens', 'TN', '37303', '35.4239', '-84.6681');
INSERT INTO `net_city` VALUES ('6710', '23', 'Пичтри Сити', 'Peachtree City', 'GA', '30269', '33.3910', '-84.5615');
INSERT INTO `net_city` VALUES ('6712', '23', 'Снеллвилл', 'Snellville', 'GA', '30078', '33.8630', '-84.0076');
INSERT INTO `net_city` VALUES ('6714', '23', 'Оук-Ридж', 'Oak Ridge', 'TN', '37830', '35.9724', '-84.2904');
INSERT INTO `net_city` VALUES ('6720', '23', 'Бренхем', 'Brenham', 'TX', '77833', '30.1991', '-96.3878');
INSERT INTO `net_city` VALUES ('6721', '23', 'Конроу', 'Conroe', 'TX', '77301', '30.3079', '-95.4315');
INSERT INTO `net_city` VALUES ('6723', '23', 'Уартон', 'Wharton', 'TX', '77488', '29.2808', '-96.0768');
INSERT INTO `net_city` VALUES ('6726', '23', 'Электра', 'Electra', 'TX', '76360', '34.0096', '-98.8901');
INSERT INTO `net_city` VALUES ('6727', '23', 'Энглтон', 'Angleton', 'TX', '77515', '29.1851', '-95.4554');
INSERT INTO `net_city` VALUES ('6730', '23', 'Николасвилл', 'Nicholasville', 'KY', '40356', '37.8647', '-84.5642');
INSERT INTO `net_city` VALUES ('6734', '23', 'Гилмер', 'Gilmer', 'TX', '75644', '32.7734', '-94.9889');
INSERT INTO `net_city` VALUES ('6735', '23', 'Оберлин', 'Oberlin', 'LA', '70655', '30.6326', '-92.7305');
INSERT INTO `net_city` VALUES ('6741', '23', 'Лейк Джексон', 'Lake Jackson', 'TX', '77566', '29.0322', '-95.4699');
INSERT INTO `net_city` VALUES ('6743', '23', 'Юлесс', 'Euless', 'TX', '76040', '32.8101', '-97.1061');
INSERT INTO `net_city` VALUES ('6744', '23', 'Корсикана', 'Corsicana', 'TX', '75110', '32.0795', '-96.5114');
INSERT INTO `net_city` VALUES ('6747', '23', 'Кингвуд', 'Kingwood', 'TX', '77339', '30.0540', '-95.2230');
INSERT INTO `net_city` VALUES ('6749', '23', 'Гамильтон', 'Hamilton', 'OH', '45011', '39.4250', '-84.4982');
INSERT INTO `net_city` VALUES ('6750', '23', 'Флемингсберг', 'Flemingsburg', 'KY', '41041', '38.4022', '-83.7229');
INSERT INTO `net_city` VALUES ('6751', '23', 'Пемброк', 'Pembroke', 'MA', '02359', '42.0647', '-70.7986');
INSERT INTO `net_city` VALUES ('6757', '23', 'Хеброн', 'Hebron', 'KY', '41048', '39.0904', '-84.7011');
INSERT INTO `net_city` VALUES ('6763', '23', 'Уайтсборо', 'Whitesboro', 'TX', '76273', '33.7598', '-96.9015');
INSERT INTO `net_city` VALUES ('6764', '23', 'Астория', 'Astoria', 'IL', '61501', '40.2405', '-90.3081');
INSERT INTO `net_city` VALUES ('6765', '23', 'Лиф Ривер', 'Leaf River', 'IL', '61047', '42.1622', '-89.4058');
INSERT INTO `net_city` VALUES ('6766', '23', 'Чилликот', 'Chillicothe', 'IL', '61523', '40.9134', '-89.5326');
INSERT INTO `net_city` VALUES ('6767', '23', 'Варшава', 'Warsaw', 'IL', '62379', '40.2605', '-91.4509');
INSERT INTO `net_city` VALUES ('6769', '23', 'Уошберн', 'Washburn', 'IL', '61570', '40.9094', '-89.2450');
INSERT INTO `net_city` VALUES ('6770', '23', 'Галена', 'Galena', 'IL', '61036', '42.4120', '-90.3817');
INSERT INTO `net_city` VALUES ('6771', '23', 'Диксон', 'Dixon', 'IL', '61021', '41.8157', '-89.4818');
INSERT INTO `net_city` VALUES ('6772', '23', 'Уэст Берлингтон', 'West Burlington', 'IA', '52655', '40.8533', '-91.2107');
INSERT INTO `net_city` VALUES ('6776', '23', 'Тремонт', 'Tremont', 'IL', '61568', '40.5023', '-89.4812');
INSERT INTO `net_city` VALUES ('6780', '23', 'Кевани', 'Kewanee', 'IL', '61443', '41.2608', '-89.9441');
INSERT INTO `net_city` VALUES ('6782', '23', 'Мэттун', 'Mattoon', 'IL', '61938', '39.4885', '-88.3596');
INSERT INTO `net_city` VALUES ('6784', '23', 'Чадвик', 'Chadwick', 'IL', '61014', '41.9774', '-89.8810');
INSERT INTO `net_city` VALUES ('6785', '23', 'Гейлсберг', 'Galesburg', 'IL', '61401', '40.9421', '-90.3780');
INSERT INTO `net_city` VALUES ('6787', '23', 'Ист Дабек', 'East Dubuque', 'IL', '61025', '42.4642', '-90.5615');
INSERT INTO `net_city` VALUES ('6788', '23', 'Данлап', 'Dunlap', 'IL', '61525', '40.8568', '-89.6595');
INSERT INTO `net_city` VALUES ('6789', '23', 'Юрика', 'Eureka', 'IL', '61530', '40.7187', '-89.2533');
INSERT INTO `net_city` VALUES ('6790', '23', 'Моссвилл', 'Mossville', 'IL', '61552', '40.8176', '-89.5636');
INSERT INTO `net_city` VALUES ('6791', '23', 'Маскатин', 'Muscatine', 'IA', '52761', '41.4046', '-91.0321');
INSERT INTO `net_city` VALUES ('6793', '23', 'Фиш Крик', 'Fish Creek', 'WI', '54212', '45.1148', '-87.2168');
INSERT INTO `net_city` VALUES ('6795', '23', 'Нью Колумбия', 'New Columbia', 'PA', '17856', '41.0631', '-76.9805');
INSERT INTO `net_city` VALUES ('6799', '23', 'Фреденсберг', 'Friedensburg', 'PA', '17933', '40.6026', '-76.2408');
INSERT INTO `net_city` VALUES ('6800', '23', 'Интеркорс', 'Intercourse', 'PA', '17534', '40.0376', '-76.1050');
INSERT INTO `net_city` VALUES ('6801', '23', 'Маунт Джой', 'Mount Joy', 'PA', '17552', '40.1142', '-76.5088');
INSERT INTO `net_city` VALUES ('6804', '23', 'Литлстаун', 'Littlestown', 'PA', '17340', '39.7646', '-77.1166');
INSERT INTO `net_city` VALUES ('6807', '23', 'Кэмп Хилл', 'Camp Hill', 'PA', '17011', '40.2379', '-76.9228');
INSERT INTO `net_city` VALUES ('6808', '23', 'Джексонвилл', 'Jacksonville', 'TX', '75766', '31.9454', '-95.2194');
INSERT INTO `net_city` VALUES ('6809', '23', 'Янг Харрис', 'Young Harris', 'GA', '30582', '34.9435', '-83.9063');
INSERT INTO `net_city` VALUES ('6812', '23', 'Лисберг', 'Leesburg', 'FL', '34748', '28.7394', '-81.8555');
INSERT INTO `net_city` VALUES ('6816', '23', 'Лавин', 'Laveen', 'AZ', '85339', '33.3054', '-112.1997');
INSERT INTO `net_city` VALUES ('6818', '23', 'Вентура', 'Ventura', 'CA', '93003', '34.2863', '-119.2267');
INSERT INTO `net_city` VALUES ('6819', '23', 'Колдуотер', 'Coldwater', 'MI', '49036', '41.9015', '-85.0346');
INSERT INTO `net_city` VALUES ('6820', '23', 'Куперсвилл', 'Coopersville', 'MI', '49404', '43.0706', '-85.9733');
INSERT INTO `net_city` VALUES ('6822', '23', 'Янгтаун', 'Youngtown', 'AZ', '85363', '33.5863', '-112.3062');
INSERT INTO `net_city` VALUES ('6824', '23', 'Питерсберг', 'Petersburg', 'VA', '23803', '37.1952', '-77.4597');
INSERT INTO `net_city` VALUES ('6826', '23', 'Маунт Дора', 'Mount Dora', 'FL', '32757', '28.7620', '-81.6300');
INSERT INTO `net_city` VALUES ('6827', '23', 'Тонопа', 'Tonopah', 'AZ', '85354', '33.5778', '-113.0234');
INSERT INTO `net_city` VALUES ('6830', '23', 'Мэттаван', 'Mattawan', 'MI', '49071', '42.2322', '-85.7736');
INSERT INTO `net_city` VALUES ('6831', '23', 'Порт Ориндж', 'Port Orange', 'FL', '32127', '29.1099', '-80.9730');
INSERT INTO `net_city` VALUES ('6833', '23', 'Пидмонт', 'Piedmont', 'OK', '73078', '35.6531', '-97.7629');
INSERT INTO `net_city` VALUES ('6839', '23', 'Бенсон', 'Benson', 'AZ', '85602', '32.1924', '-110.3862');
INSERT INTO `net_city` VALUES ('6840', '23', 'Рокуолл', 'Rockwall', 'TX', '75032', '32.8685', '-96.4031');
INSERT INTO `net_city` VALUES ('6844', '23', 'Пайперсвилл', 'Pipersville', 'PA', '18947', '40.4278', '-75.1147');
INSERT INTO `net_city` VALUES ('6846', '23', 'Болдуин-Парк', 'Baldwin Park', 'CA', '91706', '34.0964', '-117.9668');
INSERT INTO `net_city` VALUES ('6848', '23', 'Нью-Хоп', 'New Hope', 'PA', '18938', '40.3562', '-74.9987');
INSERT INTO `net_city` VALUES ('6851', '23', 'Ист Норритон', 'East Norriton', 'PA', '19002', '40.1843', '-75.2168');
INSERT INTO `net_city` VALUES ('6852', '23', 'Ла Мирада', 'La Mirada', 'CA', '90638', '33.9009', '-118.0073');
INSERT INTO `net_city` VALUES ('6855', '23', 'Покателло', 'Pocatello', 'ID', '83201', '42.9061', '-112.3975');
INSERT INTO `net_city` VALUES ('6858', '23', 'Маммот Лейкс', 'Mammoth Lakes', 'CA', '93546', '37.5870', '-118.8422');
INSERT INTO `net_city` VALUES ('6861', '23', 'Логан', 'Logan', 'UT', '84321', '41.7048', '-111.8709');
INSERT INTO `net_city` VALUES ('6863', '23', 'Мидвейл', 'Midvale', 'UT', '84047', '40.6092', '-111.8819');
INSERT INTO `net_city` VALUES ('6864', '23', 'Кенилворт', 'Kenilworth', 'NJ', '07033', '40.6778', '-74.2917');
INSERT INTO `net_city` VALUES ('6868', '23', 'Мистик', 'Mystic', 'CT', '06355', '41.3749', '-71.9766');
INSERT INTO `net_city` VALUES ('6871', '23', 'Ривс Джанкшен', 'Rives Junction', 'MI', '49277', '42.3781', '-84.4798');
INSERT INTO `net_city` VALUES ('6872', '23', 'Брайан', 'Bryan', 'OH', '43506', '41.4615', '-84.5531');
INSERT INTO `net_city` VALUES ('6875', '23', 'Пембервилл', 'Pemberville', 'OH', '43450', '41.3915', '-83.4888');
INSERT INTO `net_city` VALUES ('6881', '23', 'Фронт Ройал', 'Front Royal', 'VA', '22630', '38.9226', '-78.1337');
INSERT INTO `net_city` VALUES ('6884', '23', 'Рапидан', 'Rapidan', 'VA', '22733', '38.3332', '-78.0462');
INSERT INTO `net_city` VALUES ('6885', '23', 'Бенишия', 'Benicia', 'CA', '94510', '38.1129', '-122.1331');
INSERT INTO `net_city` VALUES ('6887', '23', 'Суитуотер', 'Sweetwater', 'OK', '73666', '35.4731', '-99.8943');
INSERT INTO `net_city` VALUES ('6888', '23', 'Семинол', 'Seminole', 'OK', '74868', '35.2445', '-96.6340');
INSERT INTO `net_city` VALUES ('6891', '23', 'Снайдер', 'Snyder', 'OK', '73566', '34.6234', '-98.9792');
INSERT INTO `net_city` VALUES ('6894', '23', 'Андерсонвилл', 'Andersonville', 'GA', '31711', '32.1831', '-84.0456');
INSERT INTO `net_city` VALUES ('6895', '23', 'Ловетсвилл', 'Lovettsville', 'VA', '20180', '39.2687', '-77.6305');
INSERT INTO `net_city` VALUES ('6897', '23', 'Фэрбанкс', 'Fairbanks', 'AK', '99707', '64.8378', '-147.7164');
INSERT INTO `net_city` VALUES ('6900', '23', 'Гриннелл', 'Grinnell', 'IA', '50112', '41.7217', '-92.7176');
INSERT INTO `net_city` VALUES ('6902', '23', 'Уоткинсвилл', 'Watkinsville', 'GA', '30677', '33.7694', '-83.3897');
INSERT INTO `net_city` VALUES ('6905', '23', 'Пендерграсс', 'Pendergrass', 'GA', '30567', '34.1851', '-83.6760');
INSERT INTO `net_city` VALUES ('6910', '23', 'Токкоа', 'Toccoa', 'GA', '30577', '34.5439', '-83.3082');
INSERT INTO `net_city` VALUES ('6912', '23', 'Алкоа', 'Alcoa', 'TN', '37701', '35.8012', '-83.9853');
INSERT INTO `net_city` VALUES ('6913', '23', 'Хайесвилл', 'Hayesville', 'NC', '28904', '35.0739', '-83.7051');
INSERT INTO `net_city` VALUES ('6914', '23', 'Рабун Гэп', 'Rabun Gap', 'GA', '30568', '34.9523', '-83.4269');
INSERT INTO `net_city` VALUES ('6917', '23', 'Джефферсон-Сити', 'Jefferson City', 'TN', '37760', '36.1015', '-83.4522');
INSERT INTO `net_city` VALUES ('6919', '23', 'Тамаква', 'Tamaqua', 'PA', '18252', '40.7818', '-75.9870');
INSERT INTO `net_city` VALUES ('6920', '23', 'Лейк Хармони', 'Lake Harmony', 'PA', '18624', '41.0499', '-75.6201');
INSERT INTO `net_city` VALUES ('6922', '23', 'Креско', 'Cresco', 'PA', '18326', '41.1457', '-75.2664');
INSERT INTO `net_city` VALUES ('6928', '23', 'Пелл Сити', 'Pell City', 'AL', '35125', '33.6332', '-86.2950');
INSERT INTO `net_city` VALUES ('6929', '23', 'Гантерсвилл', 'Guntersville', 'AL', '35976', '34.3196', '-86.2735');
INSERT INTO `net_city` VALUES ('6932', '23', 'Атенс', 'Athens', 'AL', '35611', '34.7675', '-87.1057');
INSERT INTO `net_city` VALUES ('6934', '23', 'Гленвуд', 'Glenwood', 'MD', '21738', '39.2871', '-77.0269');
INSERT INTO `net_city` VALUES ('6936', '23', 'Элктон', 'Elkton', 'MD', '21921', '39.6172', '-75.8678');
INSERT INTO `net_city` VALUES ('6943', '23', 'Чесапик Бич', 'Chesapeake Beach', 'MD', '20732', '38.6599', '-76.5399');
INSERT INTO `net_city` VALUES ('6944', '23', 'Ньюарк', 'Newark', 'MD', '21841', '38.2510', '-75.2951');
INSERT INTO `net_city` VALUES ('6945', '23', 'Уилмар', 'Willmar', 'MN', '56201', '45.1060', '-95.0278');
INSERT INTO `net_city` VALUES ('6946', '23', 'Уинстед', 'Winsted', 'MN', '55395', '44.9513', '-94.0527');
INSERT INTO `net_city` VALUES ('6948', '23', 'Шейди Дейл', 'Shady Dale', 'GA', '31085', '33.4179', '-83.6384');
INSERT INTO `net_city` VALUES ('6951', '23', 'Нью Глостер', 'New Gloucester', 'ME', '04260', '43.9564', '-70.3024');
INSERT INTO `net_city` VALUES ('6952', '23', 'Миллинокет', 'Millinocket', 'ME', '04462', '45.7226', '-68.7951');
INSERT INTO `net_city` VALUES ('6953', '23', 'Брюэр', 'Brewer', 'ME', '04412', '44.7807', '-68.7351');
INSERT INTO `net_city` VALUES ('6955', '23', 'Империал', 'Imperial', 'NE', '69033', '40.5464', '-101.6854');
INSERT INTO `net_city` VALUES ('6956', '23', 'Кларкс', 'Clarks', 'NE', '68628', '41.2372', '-97.8487');
INSERT INTO `net_city` VALUES ('6958', '23', 'Гауэр', 'Gower', 'MO', '64454', '39.6144', '-94.6043');
INSERT INTO `net_city` VALUES ('6962', '23', 'Канополис', 'Kanopolis', 'KS', '67454', '38.6677', '-98.1281');
INSERT INTO `net_city` VALUES ('6963', '23', 'Саут-Бостон', 'South Boston', 'VA', '24592', '36.6882', '-78.9882');
INSERT INTO `net_city` VALUES ('6965', '23', 'Уайтевилл', 'Wytheville', 'VA', '24382', '36.9498', '-81.1289');
INSERT INTO `net_city` VALUES ('6966', '23', 'Джонсвилл', 'Jonesville', 'NC', '28642', '36.2190', '-80.8126');
INSERT INTO `net_city` VALUES ('6968', '23', 'Блу Ридж', 'Blue Ridge', 'VA', '24064', '37.3618', '-79.7781');
INSERT INTO `net_city` VALUES ('6970', '23', 'Хот Спрингс', 'Hot Springs', 'VA', '24445', '37.9544', '-79.8873');
INSERT INTO `net_city` VALUES ('6972', '23', 'Лоу Мур', 'Low Moor', 'VA', '24457', '37.7887', '-79.8837');
INSERT INTO `net_city` VALUES ('6973', '23', 'Уилксборо', 'Wilkesboro', 'NC', '28697', '36.1425', '-81.1635');
INSERT INTO `net_city` VALUES ('6975', '23', 'Блэксберг', 'Blacksburg', 'VA', '24060', '37.2669', '-80.4325');
INSERT INTO `net_city` VALUES ('6977', '23', 'Дублин', 'Dublin', 'VA', '24084', '37.1283', '-80.5935');
INSERT INTO `net_city` VALUES ('6981', '23', 'Парсонс', 'Parsons', 'TN', '38363', '35.6884', '-88.1098');
INSERT INTO `net_city` VALUES ('6983', '23', 'Колльервилл', 'Collierville', 'TN', '38017', '35.0911', '-89.6510');
INSERT INTO `net_city` VALUES ('6984', '23', 'Джермантаун', 'Germantown', 'TN', '38138', '35.0844', '-89.8104');
INSERT INTO `net_city` VALUES ('6985', '23', 'Уэст Мемфис', 'West Memphis', 'AR', '72301', '35.1385', '-90.1532');
INSERT INTO `net_city` VALUES ('6989', '23', 'Уолнат', 'Walnut', 'MS', '38683', '34.8909', '-88.8506');
INSERT INTO `net_city` VALUES ('6991', '23', 'Плантерсвилл', 'Plantersville', 'MS', '38862', '34.1666', '-88.6196');
INSERT INTO `net_city` VALUES ('6992', '23', 'Уиллоуби', 'Willoughby', 'OH', '44094', '41.6384', '-81.3787');
INSERT INTO `net_city` VALUES ('6994', '23', 'Гровпорт', 'Groveport', 'OH', '43125', '39.8437', '-82.8933');
INSERT INTO `net_city` VALUES ('6996', '23', 'Чагрин Фолс', 'Chagrin Falls', 'OH', '44023', '41.3864', '-81.3042');
INSERT INTO `net_city` VALUES ('6997', '23', 'Стивенс Пойнт', 'Stevens Point', 'WI', '54481', '44.5526', '-89.5167');
INSERT INTO `net_city` VALUES ('6999', '23', 'Эйвон', 'Avon', 'OH', '44011', '41.4485', '-82.0186');
INSERT INTO `net_city` VALUES ('7000', '23', 'Коннеот', 'Conneaut', 'OH', '44030', '41.8909', '-80.6164');
INSERT INTO `net_city` VALUES ('7001', '23', 'Халси', 'Halsey', 'OR', '97348', '44.3867', '-123.1173');
INSERT INTO `net_city` VALUES ('7002', '23', 'Вудберн', 'Woodburn', 'OR', '97071', '45.1369', '-122.8224');
INSERT INTO `net_city` VALUES ('7005', '23', 'Виктор', 'Victor', 'NY', '14564', '42.9858', '-77.4280');
INSERT INTO `net_city` VALUES ('7007', '23', 'Шугаркрик', 'Sugarcreek', 'OH', '44681', '40.4855', '-81.6751');
INSERT INTO `net_city` VALUES ('7008', '23', 'Кайахога-Фоллз', 'Cuyahoga Falls', 'OH', '44223', '41.1684', '-81.5312');
INSERT INTO `net_city` VALUES ('7010', '23', 'Вустер', 'Wooster', 'OH', '44691', '40.8077', '-81.9730');
INSERT INTO `net_city` VALUES ('7012', '23', 'Гарреттсвилл', 'Garrettsville', 'OH', '44231', '41.3129', '-81.0805');
INSERT INTO `net_city` VALUES ('7013', '23', 'Хобарт', 'Hobart', 'IN', '46342', '41.5179', '-87.2353');
INSERT INTO `net_city` VALUES ('7014', '23', 'Юнионтаун', 'Uniontown', 'OH', '44685', '40.9611', '-81.4326');
INSERT INTO `net_city` VALUES ('7017', '23', 'Равенна', 'Ravenna', 'OH', '44266', '41.1601', '-81.1675');
INSERT INTO `net_city` VALUES ('7019', '23', 'Уилмот', 'Wilmot', 'OH', '44689', '40.6430', '-81.6637');
INSERT INTO `net_city` VALUES ('7022', '23', 'Фредериктаун', 'Fredericktown', 'OH', '43019', '40.4895', '-82.5601');
INSERT INTO `net_city` VALUES ('7026', '23', 'Валли Сити', 'Valley City', 'OH', '44280', '41.2361', '-81.9224');
INSERT INTO `net_city` VALUES ('7027', '23', 'Стритсборо', 'Streetsboro', 'OH', '44241', '41.2350', '-81.3434');
INSERT INTO `net_city` VALUES ('7030', '23', 'Шерродсвилл', 'Sherrodsville', 'OH', '44675', '40.5047', '-81.2502');
INSERT INTO `net_city` VALUES ('7031', '23', 'Бакирус', 'Bucyrus', 'OH', '44820', '40.8192', '-82.9691');
INSERT INTO `net_city` VALUES ('7033', '23', 'Майерстаун', 'Myerstown', 'PA', '17067', '40.3898', '-76.3175');
INSERT INTO `net_city` VALUES ('7034', '23', 'Форт Додж', 'Fort Dodge', 'IA', '50501', '42.4488', '-94.2254');
INSERT INTO `net_city` VALUES ('7035', '23', 'Алтуна', 'Altoona', 'IA', '50009', '41.6472', '-93.4600');
INSERT INTO `net_city` VALUES ('7036', '23', 'Палаус', 'Palouse', 'WA', '99161', '46.8885', '-117.1550');
INSERT INTO `net_city` VALUES ('7038', '23', 'Келлогг', 'Kellogg', 'ID', '83837', '47.5704', '-116.1157');
INSERT INTO `net_city` VALUES ('7039', '28', 'Сейнт-Томас', 'Saint Thomas', '00', '00802', '18.3223', '-64.9637');
INSERT INTO `net_city` VALUES ('7040', '23', 'Маунт-Вернон', 'Mount Vernon', 'OR', '97865', '44.4446', '-119.1634');
INSERT INTO `net_city` VALUES ('7044', '23', 'Мозес Лейк', 'Moses Lake', 'WA', '98837', '47.1901', '-119.3074');
INSERT INTO `net_city` VALUES ('7046', '23', 'Харродсберг', 'Harrodsburg', 'KY', '40330', '37.7909', '-84.8946');
INSERT INTO `net_city` VALUES ('7048', '23', 'Корбин', 'Corbin', 'KY', '40701', '36.9199', '-84.1679');
INSERT INTO `net_city` VALUES ('7049', '23', 'Лоогути', 'Loogootee', 'IN', '47553', '38.6475', '-86.9036');
INSERT INTO `net_city` VALUES ('7052', '23', 'Хосвилл', 'Hawesville', 'KY', '42348', '37.8488', '-86.7785');
INSERT INTO `net_city` VALUES ('7055', '23', 'Кэмпбеллсвилл', 'Campbellsville', 'KY', '42718', '37.3646', '-85.3758');
INSERT INTO `net_city` VALUES ('7056', '23', 'Фердинанд', 'Ferdinand', 'IN', '47532', '38.2079', '-86.8379');
INSERT INTO `net_city` VALUES ('7058', '23', 'Бердсай', 'Birdseye', 'IN', '47513', '38.3078', '-86.7006');
INSERT INTO `net_city` VALUES ('7059', '23', 'Бранчвилл', 'Branchville', 'IN', '47514', '38.1382', '-86.5888');
INSERT INTO `net_city` VALUES ('7060', '23', 'Гринсбург', 'Greensburg', 'KY', '42743', '37.2507', '-85.5177');
INSERT INTO `net_city` VALUES ('7063', '23', 'Рок-Спрингс', 'Rock Springs', 'WI', '53961', '43.4599', '-89.9319');
INSERT INTO `net_city` VALUES ('7064', '23', 'Милфорд', 'Milford', 'OH', '45150', '39.1659', '-84.2295');
INSERT INTO `net_city` VALUES ('7066', '23', 'Хиндман', 'Hindman', 'KY', '41822', '37.3354', '-82.9566');
INSERT INTO `net_city` VALUES ('7067', '23', 'Окана', 'Okeana', 'OH', '45053', '39.3555', '-84.7793');
INSERT INTO `net_city` VALUES ('7070', '23', 'Уолтон', 'Walton', 'KY', '41094', '38.8882', '-84.6417');
INSERT INTO `net_city` VALUES ('7074', '23', 'Боно', 'Bono', 'AR', '72416', '35.9564', '-90.7841');
INSERT INTO `net_city` VALUES ('7075', '23', 'Стивенсон', 'Stevenson', 'AL', '35772', '34.8787', '-85.9078');
INSERT INTO `net_city` VALUES ('7080', '23', 'Пайн Маунтин', 'Pine Mountain', 'GA', '31822', '32.8607', '-84.9051');
INSERT INTO `net_city` VALUES ('7081', '23', 'Чаритон', 'Chariton', 'IA', '50049', '41.0297', '-93.2702');
INSERT INTO `net_city` VALUES ('7083', '23', 'Орланд', 'Orland', 'CA', '95963', '39.7304', '-122.3379');
INSERT INTO `net_city` VALUES ('7085', '23', 'Фрейзер', 'Fraser', 'MI', '48026', '42.5387', '-82.9494');
INSERT INTO `net_city` VALUES ('7088', '23', 'Гранд Блан', 'Grand Blanc', 'MI', '48439', '42.9196', '-83.6496');
INSERT INTO `net_city` VALUES ('7089', '23', 'Армада', 'Armada', 'MI', '48005', '42.8500', '-82.9234');
INSERT INTO `net_city` VALUES ('7094', '23', 'Самнер', 'Sumner', 'WA', '98390', '47.1725', '-122.1845');
INSERT INTO `net_city` VALUES ('7098', '23', 'Гудинг', 'Gooding', 'ID', '83330', '43.0186', '-114.7024');
INSERT INTO `net_city` VALUES ('7099', '23', 'Порт Таунсенд', 'Port Townsend', 'WA', '98368', '48.0354', '-122.8145');
INSERT INTO `net_city` VALUES ('7100', '23', 'Лапвай', 'Lapwai', 'ID', '83540', '46.3238', '-116.7816');
INSERT INTO `net_city` VALUES ('7101', '23', 'Пламмер', 'Plummer', 'ID', '83851', '47.2864', '-116.8876');
INSERT INTO `net_city` VALUES ('7113', '23', 'Санта Роза Бич', 'Santa Rosa Beach', 'FL', '32459', '30.3544', '-86.1594');
INSERT INTO `net_city` VALUES ('7116', '23', 'Болдуинсвилл', 'Baldwinsville', 'NY', '13027', '43.1765', '-76.3640');
INSERT INTO `net_city` VALUES ('7118', '23', 'Овего', 'Owego', 'NY', '13827', '42.1336', '-76.2646');
INSERT INTO `net_city` VALUES ('7121', '23', 'Итон', 'Eaton', 'CO', '80615', '40.5523', '-104.6512');
INSERT INTO `net_city` VALUES ('7125', '23', 'Термонт', 'Thurmont', 'MD', '21788', '39.5928', '-77.4239');
INSERT INTO `net_city` VALUES ('7132', '23', 'Платтсберг', 'Plattsburg', 'MO', '64477', '39.5706', '-94.4596');
INSERT INTO `net_city` VALUES ('7135', '23', 'Мидлтаун', 'Middletown', 'NY', '10941', '41.4871', '-74.3433');
INSERT INTO `net_city` VALUES ('7136', '23', 'Порт Джервис', 'Port Jervis', 'NY', '12771', '41.3729', '-74.6407');
INSERT INTO `net_city` VALUES ('7138', '23', 'Махопак', 'Mahopac', 'NY', '10541', '41.3796', '-73.7537');
INSERT INTO `net_city` VALUES ('7141', '23', 'Милфорд', 'Milford', 'PA', '18337', '41.3402', '-74.8686');
INSERT INTO `net_city` VALUES ('7143', '23', 'Чаппаква', 'Chappaqua', 'NY', '10514', '41.1726', '-73.7712');
INSERT INTO `net_city` VALUES ('7145', '23', 'Спринг Валли', 'Spring Valley', 'NY', '10977', '41.1163', '-74.0460');
INSERT INTO `net_city` VALUES ('7147', '23', 'Хопуэлл Джанкшен', 'Hopewell Junction', 'NY', '12533', '41.5458', '-73.7815');
INSERT INTO `net_city` VALUES ('7149', '23', 'Хантингдон', 'Huntington', 'NY', '11743', '40.8719', '-73.4347');
INSERT INTO `net_city` VALUES ('7150', '23', 'Найек', 'Nyack', 'NY', '10960', '41.0861', '-73.9285');
INSERT INTO `net_city` VALUES ('7152', '23', 'Камдентон', 'Camdenton', 'MO', '65020', '37.9887', '-92.7536');
INSERT INTO `net_city` VALUES ('7158', '23', 'Лоренсевилл', 'Lawrenceville', 'IL', '62439', '38.7399', '-87.6341');
INSERT INTO `net_city` VALUES ('7162', '23', 'Метрополис', 'Metropolis', 'IL', '62960', '37.2300', '-88.7139');
INSERT INTO `net_city` VALUES ('7166', '23', 'Сейнт Энн', 'Saint Ann', 'MO', '63074', '38.7262', '-90.3890');
INSERT INTO `net_city` VALUES ('7181', '23', 'Команче', 'Comanche', 'TX', '76442', '31.8892', '-98.6385');
INSERT INTO `net_city` VALUES ('7184', '23', 'Милсап', 'Millsap', 'TX', '76066', '32.7035', '-97.9889');
INSERT INTO `net_city` VALUES ('7185', '23', 'Кроули', 'Crowley', 'TX', '76036', '32.5838', '-97.4142');
INSERT INTO `net_city` VALUES ('7187', '23', 'Хавр де Грейс', 'Havre de Grace', 'MD', '21078', '39.5564', '-76.1242');
INSERT INTO `net_city` VALUES ('7189', '23', 'Уиллард', 'Willard', 'OH', '44890', '41.0905', '-82.6972');
INSERT INTO `net_city` VALUES ('7191', '23', 'Ривер Гров', 'River Grove', 'IL', '60171', '41.9231', '-87.8396');
INSERT INTO `net_city` VALUES ('7192', '23', 'Рошелл', 'Rochelle', 'IL', '61068', '41.9627', '-89.0511');
INSERT INTO `net_city` VALUES ('7193', '23', 'Шерервилл', 'Schererville', 'IN', '46375', '41.4881', '-87.4424');
INSERT INTO `net_city` VALUES ('7196', '23', 'Уэст Данди', 'West Dundee', 'IL', '60118', '42.1121', '-88.3431');
INSERT INTO `net_city` VALUES ('7197', '23', 'Кольюза', 'Colusa', 'CA', '95932', '39.2739', '-122.0546');
INSERT INTO `net_city` VALUES ('7200', '23', 'Белла-Виста', 'Bella Vista', 'CA', '96008', '40.7016', '-122.0966');
INSERT INTO `net_city` VALUES ('7204', '23', 'Пиккерингтон', 'Pickerington', 'OH', '43147', '39.8980', '-82.7459');
INSERT INTO `net_city` VALUES ('7206', '23', 'Джеветт', 'Jewett', 'TX', '75846', '31.3172', '-96.1713');
INSERT INTO `net_city` VALUES ('7211', '23', 'Бонэм', 'Bonham', 'TX', '75418', '33.5790', '-96.1889');
INSERT INTO `net_city` VALUES ('7213', '23', 'Мэйплвуд', 'Maplewood', 'NJ', '07040', '40.7298', '-74.2662');
INSERT INTO `net_city` VALUES ('7215', '23', 'Бен Уилер', 'Ben Wheeler', 'TX', '75754', '32.4419', '-95.6335');
INSERT INTO `net_city` VALUES ('7218', '23', 'Сидар Сити', 'Cedar City', 'UT', '84720', '37.8116', '-113.2241');
INSERT INTO `net_city` VALUES ('7219', '23', 'Энола', 'Enola', 'PA', '17025', '40.2918', '-77.0022');
INSERT INTO `net_city` VALUES ('7220', '23', 'Пайн Гров Милс', 'Pine Grove Mills', 'PA', '16868', '40.7337', '-77.8856');
INSERT INTO `net_city` VALUES ('7222', '23', 'Пепперелл', 'Pepperell', 'MA', '01463', '42.6655', '-71.5952');
INSERT INTO `net_city` VALUES ('7223', '23', 'Маунтвилл', 'Mountville', 'PA', '17554', '40.0378', '-76.4209');
INSERT INTO `net_city` VALUES ('7225', '23', 'Истпойнт', 'Eastpoint', 'FL', '32328', '29.8613', '-84.9055');
INSERT INTO `net_city` VALUES ('7227', '23', 'Кистон Хайтс', 'Keystone Heights', 'FL', '32656', '29.8228', '-81.9648');
INSERT INTO `net_city` VALUES ('7228', '23', 'Ист Дублин', 'East Dublin', 'GA', '31027', '32.5599', '-82.8184');
INSERT INTO `net_city` VALUES ('7229', '23', 'Пласентия', 'Placentia', 'CA', '92870', '33.8818', '-117.8503');
INSERT INTO `net_city` VALUES ('7230', '23', 'Бивердам', 'Beaverdam', 'VA', '23015', '37.9348', '-77.5591');
INSERT INTO `net_city` VALUES ('7233', '23', 'Розленд', 'Roseland', 'VA', '22967', '37.8120', '-78.9588');
INSERT INTO `net_city` VALUES ('7235', '23', 'Лейк Орион', 'Lake Orion', 'MI', '48359', '42.7251', '-83.2716');
INSERT INTO `net_city` VALUES ('7236', '23', 'Клосон', 'Clawson', 'MI', '48017', '42.5368', '-83.1464');
INSERT INTO `net_city` VALUES ('7237', '23', 'Камминг', 'Cumming', 'GA', '30040', '34.2281', '-84.1780');
INSERT INTO `net_city` VALUES ('7239', '23', 'Берч Ран', 'Birch Run', 'MI', '48415', '43.2712', '-83.8079');
INSERT INTO `net_city` VALUES ('7242', '23', 'Грэйт Нек', 'Great Neck', 'NY', '11021', '40.7852', '-73.7279');
INSERT INTO `net_city` VALUES ('7244', '23', 'Норт Балтимор', 'North Baltimore', 'OH', '45872', '41.1908', '-83.6864');
INSERT INTO `net_city` VALUES ('7246', '23', 'Колледж Парк', 'College Park', 'MD', '20740', '39.0012', '-76.9317');
INSERT INTO `net_city` VALUES ('7247', '23', 'Делаплейн', 'Delaplane', 'VA', '20144', '38.9187', '-77.9362');
INSERT INTO `net_city` VALUES ('7248', '23', 'Гретна', 'Gretna', 'LA', '70053', '29.9121', '-90.0549');
INSERT INTO `net_city` VALUES ('7252', '23', 'Дасон', 'Duson', 'LA', '70529', '30.1815', '-92.1825');
INSERT INTO `net_city` VALUES ('7256', '23', 'Закари', 'Zachary', 'LA', '70791', '30.6379', '-91.1797');
INSERT INTO `net_city` VALUES ('7258', '23', 'Морис', 'Maurice', 'LA', '70555', '30.0742', '-92.1483');
INSERT INTO `net_city` VALUES ('7259', '23', 'Вулрич', 'Woolrich', 'PA', '17779', '41.2016', '-77.3643');
INSERT INTO `net_city` VALUES ('7264', '23', 'Морехед Сити', 'Morehead City', 'NC', '28557', '34.7386', '-76.7677');
INSERT INTO `net_city` VALUES ('7268', '23', 'Аптос', 'Aptos', 'CA', '95003', '37.0082', '-121.8777');
INSERT INTO `net_city` VALUES ('7272', '23', 'Окои', 'Ocoee', 'FL', '34761', '28.5704', '-81.5298');
INSERT INTO `net_city` VALUES ('7278', '23', 'Форт Майерс Бич', 'Fort Myers Beach', 'FL', '33931', '26.4707', '-81.9181');
INSERT INTO `net_city` VALUES ('7284', '27', 'Гуайяма', 'Guayama', '00', '00785', '17.9789', '-66.1102');
INSERT INTO `net_city` VALUES ('7285', '27', 'Кагуас', 'Caguas', '00', '00725', '18.2273', '-66.0580');
INSERT INTO `net_city` VALUES ('7295', '23', 'Прейри дю Сак', 'Prairie du Sac', 'WI', '53578', '43.3149', '-89.8056');
INSERT INTO `net_city` VALUES ('7297', '23', 'Антиго', 'Antigo', 'WI', '54409', '45.1027', '-89.1910');
INSERT INTO `net_city` VALUES ('7299', '23', 'Авалон', 'Avalon', 'WI', '53505', '42.6592', '-88.8307');
INSERT INTO `net_city` VALUES ('7300', '23', 'Элрой', 'Elroy', 'WI', '53929', '43.7528', '-90.2923');
INSERT INTO `net_city` VALUES ('7303', '23', 'Делаван', 'Delavan', 'WI', '53115', '42.6495', '-88.6594');
INSERT INTO `net_city` VALUES ('7304', '23', 'Оналяска', 'Onalaska', 'WI', '54650', '43.9102', '-91.2432');
INSERT INTO `net_city` VALUES ('7310', '23', 'Абботсфорд', 'Abbotsford', 'WI', '54405', '44.9672', '-90.2976');
INSERT INTO `net_city` VALUES ('7314', '23', 'Марафон', 'Marathon', 'WI', '54448', '44.9370', '-89.8268');
INSERT INTO `net_city` VALUES ('7316', '23', 'Клермонт', 'Clermont', 'FL', '34711', '28.5050', '-81.7897');
INSERT INTO `net_city` VALUES ('7319', '23', 'Холлетсвилл', 'Hallettsville', 'TX', '77964', '29.3525', '-96.8281');
INSERT INTO `net_city` VALUES ('7325', '23', 'Бивилл', 'Beeville', 'TX', '78102', '28.4731', '-97.7071');
INSERT INTO `net_city` VALUES ('7331', '23', 'Джос', 'Joes', 'CO', '80822', '39.6994', '-102.6798');
INSERT INTO `net_city` VALUES ('7335', '23', 'Монтелло', 'Montello', 'WI', '53949', '43.7829', '-89.2983');
INSERT INTO `net_city` VALUES ('7340', '23', 'Рошолт', 'Rosholt', 'WI', '54473', '44.6594', '-89.3569');
INSERT INTO `net_city` VALUES ('7343', '23', 'Перу', 'Peru', 'IL', '61354', '41.3832', '-89.1461');
INSERT INTO `net_city` VALUES ('7348', '23', 'Си Герт', 'Sea Girt', 'NJ', '08750', '40.1320', '-74.0461');
INSERT INTO `net_city` VALUES ('7349', '23', 'Хазлет', 'Hazlet', 'NJ', '07730', '40.4242', '-74.1746');
INSERT INTO `net_city` VALUES ('7353', '23', 'Нокона', 'Nocona', 'TX', '76255', '33.8204', '-97.7374');
INSERT INTO `net_city` VALUES ('7355', '23', 'Бедфорд', 'Bedford', 'TX', '76021', '32.8523', '-97.1342');
INSERT INTO `net_city` VALUES ('7356', '23', 'Осейдж Сити', 'Osage City', 'KS', '66523', '38.5988', '-95.8371');
INSERT INTO `net_city` VALUES ('7357', '23', 'Риджуэй', 'Ridgeway', 'VA', '24148', '36.6006', '-79.8545');
INSERT INTO `net_city` VALUES ('7358', '23', 'Лоугап', 'Lowgap', 'NC', '27024', '36.5180', '-80.8348');
INSERT INTO `net_city` VALUES ('7361', '23', 'Питерстаун', 'Peterstown', 'WV', '24963', '37.4316', '-80.7676');
INSERT INTO `net_city` VALUES ('7362', '23', 'Бруквилл', 'Brookville', 'IN', '47012', '39.4047', '-84.9736');
INSERT INTO `net_city` VALUES ('7367', '23', 'Фраквилл', 'Frackville', 'PA', '17931', '40.7852', '-76.2230');
INSERT INTO `net_city` VALUES ('7369', '23', 'Гринкасл', 'Greencastle', 'PA', '17225', '39.7991', '-77.7540');
INSERT INTO `net_city` VALUES ('7371', '23', 'Шиппенсберг', 'Shippensburg', 'PA', '17257', '40.0458', '-77.4807');
INSERT INTO `net_city` VALUES ('7374', '23', 'Набб', 'Nabb', 'IN', '47147', '38.5864', '-85.5318');
INSERT INTO `net_city` VALUES ('7375', '23', 'Хокли', 'Hockley', 'TX', '77447', '30.0551', '-95.8187');
INSERT INTO `net_city` VALUES ('7377', '23', 'Страудсберг', 'Stroudsburg', 'PA', '18360', '40.9588', '-75.3006');
INSERT INTO `net_city` VALUES ('7379', '23', 'Навасота', 'Navasota', 'TX', '77868', '30.3706', '-96.0565');
INSERT INTO `net_city` VALUES ('7380', '23', 'Нью Фридом', 'New Freedom', 'PA', '17349', '39.7697', '-76.6563');
INSERT INTO `net_city` VALUES ('7381', '23', 'Фармерсвилл', 'Farmersville', 'TX', '75442', '33.1756', '-96.3441');
INSERT INTO `net_city` VALUES ('7384', '23', 'Фриленд', 'Freeland', 'MI', '48623', '43.4989', '-84.1560');
INSERT INTO `net_city` VALUES ('7386', '23', 'Элберон', 'Elberon', 'VA', '23846', '37.0719', '-76.8310');
INSERT INTO `net_city` VALUES ('7387', '23', 'Хотчкисс', 'Hotchkiss', 'CO', '81419', '38.9627', '-107.7223');
INSERT INTO `net_city` VALUES ('7388', '23', 'Титон-Вилидж', 'Teton Village', 'WY', '83025', '43.5880', '-110.8280');
INSERT INTO `net_city` VALUES ('7390', '23', 'Брекенридж', 'Breckenridge', 'CO', '80424', '39.4678', '-105.9962');
INSERT INTO `net_city` VALUES ('7391', '23', 'Гранби', 'Granby', 'CO', '80446', '40.1766', '-105.8971');
INSERT INTO `net_city` VALUES ('7392', '23', 'Маунт Олив', 'Mount Olive', 'WV', '25185', '38.0413', '-81.0648');
INSERT INTO `net_city` VALUES ('7393', '23', 'Аппер Блэк Эдди', 'Upper Black Eddy', 'PA', '18972', '40.5301', '-75.1249');
INSERT INTO `net_city` VALUES ('7394', '23', 'Путнам', 'Putnam', 'CT', '06260', '41.9009', '-71.8653');
INSERT INTO `net_city` VALUES ('7395', '23', 'Клеймонт', 'Claymont', 'DE', '19703', '39.8041', '-75.4559');
INSERT INTO `net_city` VALUES ('7399', '23', 'Фоулервилл', 'Fowlerville', 'MI', '48836', '42.6625', '-84.0674');
INSERT INTO `net_city` VALUES ('7400', '23', 'Браселтон', 'Braselton', 'GA', '30517', '34.1366', '-83.7837');
INSERT INTO `net_city` VALUES ('7401', '23', 'Лоудон', 'Loudon', 'TN', '37774', '35.7102', '-84.3743');
INSERT INTO `net_city` VALUES ('7403', '23', 'Олд Сейбрук', 'Old Saybrook', 'CT', '06475', '41.3009', '-72.3876');
INSERT INTO `net_city` VALUES ('7404', '23', 'Мусап', 'Moosup', 'CT', '06354', '41.7046', '-71.8490');
INSERT INTO `net_city` VALUES ('7406', '23', 'Анкасвилл', 'Uncasville', 'CT', '06382', '41.4626', '-72.1309');
INSERT INTO `net_city` VALUES ('7407', '23', 'Уиллимантик', 'Willimantic', 'CT', '06226', '41.7094', '-72.2112');
INSERT INTO `net_city` VALUES ('7410', '23', 'Ладлоу', 'Ludlow', 'MA', '01056', '42.1926', '-72.4598');
INSERT INTO `net_city` VALUES ('7411', '23', 'Мериден', 'Meriden', 'CT', '06450', '41.5372', '-72.7801');
INSERT INTO `net_city` VALUES ('7412', '23', 'Дейвилл', 'Dayville', 'CT', '06241', '41.8531', '-71.8601');
INSERT INTO `net_city` VALUES ('7413', '23', 'Ньюингтон', 'Newington', 'CT', '06111', '41.6856', '-72.7312');
INSERT INTO `net_city` VALUES ('7414', '23', 'Норт Адамс', 'North Adams', 'MA', '01247', '42.6881', '-73.0630');
INSERT INTO `net_city` VALUES ('7425', '23', 'Уиннсборо', 'Winnsboro', 'LA', '71295', '32.1344', '-91.7112');
INSERT INTO `net_city` VALUES ('7427', '23', 'Ламбертон', 'Lumberton', 'TX', '77657', '30.2311', '-94.2066');
INSERT INTO `net_city` VALUES ('7431', '23', 'Хомосасса', 'Homosassa', 'FL', '34446', '28.7501', '-82.5166');
INSERT INTO `net_city` VALUES ('7432', '23', 'Палм Бэй', 'Palm Bay', 'FL', '32905', '28.0381', '-80.6115');
INSERT INTO `net_city` VALUES ('7434', '23', 'Фэрфакс', 'Fairfax', 'IA', '52228', '41.8983', '-91.7938');
INSERT INTO `net_city` VALUES ('7435', '23', 'Салфер', 'Sulphur', 'LA', '70663', '30.2585', '-93.4063');
INSERT INTO `net_city` VALUES ('7438', '23', 'Беттендорф', 'Bettendorf', 'IA', '52722', '41.5738', '-90.4582');
INSERT INTO `net_city` VALUES ('7440', '23', 'Абингдон', 'Abingdon', 'VA', '24210', '36.7620', '-82.0388');
INSERT INTO `net_city` VALUES ('7442', '23', 'Солсбери', 'Salisbury', 'NC', '28147', '35.6872', '-80.5669');
INSERT INTO `net_city` VALUES ('7443', '23', 'Уэйнсвилл', 'Waynesville', 'NC', '28785', '35.6346', '-83.0230');
INSERT INTO `net_city` VALUES ('7444', '23', 'Симпсонвилл', 'Simpsonville', 'SC', '29681', '34.7664', '-82.2202');
INSERT INTO `net_city` VALUES ('7448', '23', 'Коммерс', 'Commerce', 'TX', '75428', '33.2844', '-95.9206');
INSERT INTO `net_city` VALUES ('7449', '23', 'Полсборо', 'Paulsboro', 'NJ', '08066', '39.8353', '-75.1954');
INSERT INTO `net_city` VALUES ('7457', '23', 'Мекилтео', 'Mukilteo', 'WA', '98275', '47.9130', '-122.3042');
INSERT INTO `net_city` VALUES ('7458', '23', 'Канандейгуа', 'Canandaigua', 'NY', '14424', '42.8326', '-77.3096');
INSERT INTO `net_city` VALUES ('7459', '23', 'Оуингсвилл', 'Owingsville', 'KY', '40360', '38.1592', '-83.7736');
INSERT INTO `net_city` VALUES ('7460', '23', 'Кэмп Верде', 'Camp Verde', 'AZ', '86322', '34.4862', '-111.7808');
INSERT INTO `net_city` VALUES ('7462', '23', 'Риджфилд Парк', 'Ridgefield Park', 'NJ', '07660', '40.8536', '-74.0209');
INSERT INTO `net_city` VALUES ('7466', '23', 'Силвердейл', 'Silverdale', 'WA', '98315', '47.7244', '-122.7191');
INSERT INTO `net_city` VALUES ('7467', '23', 'Даррингтон', 'Darrington', 'WA', '98241', '48.1966', '-121.5372');
INSERT INTO `net_city` VALUES ('7471', '23', 'Блэйн', 'Blaine', 'WA', '98230', '48.9301', '-122.7253');
INSERT INTO `net_city` VALUES ('7472', '23', 'Пуиолап', 'Puyallup', 'WA', '98372', '47.2257', '-122.2721');
INSERT INTO `net_city` VALUES ('7473', '23', 'Мейпл Валли', 'Maple Valley', 'WA', '98038', '47.4061', '-121.9953');
INSERT INTO `net_city` VALUES ('7475', '23', 'Милтон-Фриуотер', 'Milton-Freewater', 'OR', '97862', '45.9029', '-118.3401');
INSERT INTO `net_city` VALUES ('7477', '23', 'Сентрал Пойнт', 'Central Point', 'OR', '97502', '42.3914', '-122.9367');
INSERT INTO `net_city` VALUES ('7479', '23', 'Нью Филадельфия', 'New Philadelphia', 'OH', '44663', '40.4410', '-81.4920');
INSERT INTO `net_city` VALUES ('7484', '23', 'Ист Пойнт', 'East Point', 'GA', '30297', '33.6116', '-84.3726');
INSERT INTO `net_city` VALUES ('7486', '23', 'Сегин', 'Seguin', 'TX', '78156', '29.5688', '-97.9647');
INSERT INTO `net_city` VALUES ('7487', '23', 'Бьютт', 'Butte', 'MT', '59701', '46.0092', '-112.4421');
INSERT INTO `net_city` VALUES ('7491', '23', 'Стойстаун', 'Stoystown', 'PA', '15563', '40.0895', '-78.9561');
INSERT INTO `net_city` VALUES ('7492', '23', 'Пойнт Марион', 'Point Marion', 'PA', '15474', '39.7572', '-79.9022');
INSERT INTO `net_city` VALUES ('7494', '23', 'Рослин', 'Roslyn', 'NY', '11576', '40.8082', '-73.6386');
INSERT INTO `net_city` VALUES ('7495', '23', 'Батлер', 'Butler', 'WI', '53007', '43.1078', '-88.0715');
INSERT INTO `net_city` VALUES ('7496', '23', 'Уотерфорд', 'Waterford', 'WI', '53185', '42.7870', '-88.2091');
INSERT INTO `net_city` VALUES ('7497', '23', 'Серри', 'Surry', 'VA', '23883', '37.1166', '-76.7534');
INSERT INTO `net_city` VALUES ('7503', '23', 'Прайнвилл', 'Prineville', 'OR', '97754', '44.1066', '-120.6642');
INSERT INTO `net_city` VALUES ('7504', '23', 'Голд Бич', 'Gold Beach', 'OR', '97444', '42.4517', '-124.3062');
INSERT INTO `net_city` VALUES ('7507', '23', 'Гарден Сити', 'Garden City', 'ID', '83714', '43.6461', '-116.2675');
INSERT INTO `net_city` VALUES ('7508', '23', 'Опп', 'Opp', 'AL', '36467', '31.2936', '-86.2595');
INSERT INTO `net_city` VALUES ('7509', '23', 'Шортер', 'Shorter', 'AL', '36075', '32.3893', '-85.9064');
INSERT INTO `net_city` VALUES ('7511', '23', 'Пулвилл', 'Poolville', 'TX', '76487', '32.9842', '-97.8713');
INSERT INTO `net_city` VALUES ('7515', '23', 'Ремлап', 'Remlap', 'AL', '35133', '33.8308', '-86.5947');
INSERT INTO `net_city` VALUES ('7517', '23', 'Питтстаун', 'Pittstown', 'NJ', '08867', '40.5714', '-74.9725');
INSERT INTO `net_city` VALUES ('7518', '23', 'Толука', 'Toluca', 'IL', '61369', '40.9850', '-89.1521');
INSERT INTO `net_city` VALUES ('7522', '23', 'Кенова', 'Kenova', 'WV', '25530', '38.3427', '-82.5445');
INSERT INTO `net_city` VALUES ('7523', '23', 'Фразисберг', 'Frazeysburg', 'OH', '43822', '40.1747', '-82.1576');
INSERT INTO `net_city` VALUES ('7524', '23', 'Занесвилл', 'Zanesville', 'OH', '43701', '39.9553', '-82.0718');
INSERT INTO `net_city` VALUES ('7527', '23', 'Вансберг', 'Vanceburg', 'KY', '41179', '38.5084', '-83.4106');
INSERT INTO `net_city` VALUES ('7528', '23', 'Луиза', 'Louisa', 'KY', '41230', '38.0954', '-82.7211');
INSERT INTO `net_city` VALUES ('7529', '23', 'Санбери', 'Sunbury', 'OH', '43074', '40.2667', '-82.8477');
INSERT INTO `net_city` VALUES ('7531', '23', 'Барборсвилл', 'Barboursville', 'WV', '25504', '38.3881', '-82.2258');
INSERT INTO `net_city` VALUES ('7534', '23', 'Джерико', 'Jericho', 'NY', '11753', '40.7932', '-73.5424');
INSERT INTO `net_city` VALUES ('7539', '23', 'Плейнвью', 'Plainview', 'NY', '11803', '40.7820', '-73.4739');
INSERT INTO `net_city` VALUES ('7543', '23', 'Пинкни', 'Pinckney', 'MI', '48169', '42.4581', '-83.9468');
INSERT INTO `net_city` VALUES ('7546', '23', 'Хартфорд Сити', 'Hartford City', 'IN', '47348', '40.4725', '-85.3422');
INSERT INTO `net_city` VALUES ('7549', '23', 'Гранбери', 'Granbury', 'TX', '76048', '32.4272', '-97.7982');
INSERT INTO `net_city` VALUES ('7551', '23', 'Канаджохари', 'Canajoharie', 'NY', '13317', '42.8527', '-74.5974');
INSERT INTO `net_city` VALUES ('7556', '23', 'Гудвью', 'Goodview', 'VA', '24095', '37.2114', '-79.7550');
INSERT INTO `net_city` VALUES ('7559', '23', 'Эллори', 'Elloree', 'SC', '29047', '33.5328', '-80.5868');
INSERT INTO `net_city` VALUES ('7560', '23', 'Кейс', 'Cayce', 'SC', '29033', '33.9541', '-81.0601');
INSERT INTO `net_city` VALUES ('7562', '23', 'Риджкрест', 'Ridgecrest', 'CA', '93555', '35.5532', '-117.6765');
INSERT INTO `net_city` VALUES ('7567', '23', 'Ки Бискейн', 'Key Biscayne', 'FL', '33149', '25.6968', '-80.1611');
INSERT INTO `net_city` VALUES ('7569', '23', 'Беллпорт', 'Bellport', 'NY', '11713', '40.7716', '-72.9407');
INSERT INTO `net_city` VALUES ('7570', '23', 'Мартинес', 'Martinez', 'CA', '94553', '37.9876', '-122.1532');
INSERT INTO `net_city` VALUES ('7571', '23', 'Маргаретвилл', 'Margaretville', 'NY', '12455', '42.1334', '-74.6396');
INSERT INTO `net_city` VALUES ('7574', '23', 'Эль Гранада', 'El Granada', 'CA', '94018', '37.5027', '-122.4694');
INSERT INTO `net_city` VALUES ('7577', '23', 'Инид', 'Enid', 'OK', '73701', '36.4486', '-97.7697');
INSERT INTO `net_city` VALUES ('7583', '23', 'Бойн Фолс', 'Boyne Falls', 'MI', '49713', '45.2180', '-84.8554');
INSERT INTO `net_city` VALUES ('7585', '23', 'Копперополис', 'Copperopolis', 'CA', '95228', '37.9454', '-120.6683');
INSERT INTO `net_city` VALUES ('7586', '23', 'Холиок', 'Holyoke', 'MA', '01040', '42.2238', '-72.6409');
INSERT INTO `net_city` VALUES ('7588', '23', 'Уэстклифф', 'Westcliffe', 'CO', '81252', '38.0774', '-105.4599');
INSERT INTO `net_city` VALUES ('7591', '23', 'Шервуд', 'Sherwood', 'AR', '72120', '34.9024', '-92.2302');
INSERT INTO `net_city` VALUES ('7594', '23', 'Очард Парк', 'Orchard Park', 'NY', '14127', '42.7442', '-78.7442');
INSERT INTO `net_city` VALUES ('7599', '23', 'Харриман', 'Harriman', 'TN', '37748', '35.9770', '-84.4625');
INSERT INTO `net_city` VALUES ('7607', '23', 'Гастония', 'Gastonia', 'NC', '28052', '35.2298', '-81.2428');
INSERT INTO `net_city` VALUES ('7608', '23', 'Рокингем', 'Rockingham', 'NC', '28379', '34.9302', '-79.7670');
INSERT INTO `net_city` VALUES ('7617', '23', 'Уолкотт', 'Wolcott', 'CT', '06716', '41.5989', '-72.9776');
INSERT INTO `net_city` VALUES ('7618', '23', 'Корнелиус', 'Cornelius', 'NC', '28031', '35.4699', '-80.8801');
INSERT INTO `net_city` VALUES ('7619', '23', 'Лиман', 'Lyman', 'SC', '29365', '34.9838', '-82.1627');
INSERT INTO `net_city` VALUES ('7623', '23', 'Бернсвилл', 'Burnsville', 'NC', '28714', '35.8807', '-82.3095');
INSERT INTO `net_city` VALUES ('7626', '23', 'Дентон', 'Denton', 'TX', '76209', '33.2324', '-97.1108');
INSERT INTO `net_city` VALUES ('7628', '23', 'Аргайл', 'Argyle', 'TX', '76226', '33.1088', '-97.1665');
INSERT INTO `net_city` VALUES ('7629', '23', 'Данканвилл', 'Duncanville', 'TX', '75137', '32.6323', '-96.9125');
INSERT INTO `net_city` VALUES ('7634', '23', 'Аллентон', 'Allenton', 'WI', '53002', '43.4684', '-88.3714');
INSERT INTO `net_city` VALUES ('7635', '23', 'Солванг', 'Solvang', 'CA', '93463', '34.6145', '-120.1414');
INSERT INTO `net_city` VALUES ('7636', '23', 'Кеньон', 'Kenyon', 'MN', '55946', '44.2816', '-92.9511');
INSERT INTO `net_city` VALUES ('7637', '23', 'Лак', 'Luck', 'WI', '54853', '45.5773', '-92.4375');
INSERT INTO `net_city` VALUES ('7642', '23', 'Ок Парк', 'Oak Park', 'IL', '60301', '41.8889', '-87.7978');
INSERT INTO `net_city` VALUES ('7644', '23', 'Шенандоа', 'Shenandoah', 'PA', '17976', '40.8218', '-76.2035');
INSERT INTO `net_city` VALUES ('7647', '23', 'Саут Холланд', 'South Holland', 'IL', '60473', '41.6003', '-87.5975');
INSERT INTO `net_city` VALUES ('7648', '23', 'Спринг-Гров', 'Spring Grove', 'IL', '60081', '42.4510', '-88.2213');
INSERT INTO `net_city` VALUES ('7651', '23', 'Хауи-ин-Хилс', 'Howey-in-the-Hills', 'FL', '34705', '28.7017', '-81.7204');
INSERT INTO `net_city` VALUES ('7657', '23', 'Уэстпойнт', 'Westpoint', 'IN', '47992', '40.3206', '-87.0519');
INSERT INTO `net_city` VALUES ('7661', '23', 'Марион', 'Marion', 'IN', '46953', '40.5099', '-85.6264');
INSERT INTO `net_city` VALUES ('7665', '23', 'Крофордсвилл', 'Crawfordsville', 'IN', '47933', '40.0407', '-86.9003');
INSERT INTO `net_city` VALUES ('7666', '23', 'Аттика', 'Attica', 'IN', '47918', '40.2775', '-87.2040');
INSERT INTO `net_city` VALUES ('7669', '23', 'Эдинбург', 'Edinburgh', 'IN', '46124', '39.3847', '-85.9023');
INSERT INTO `net_city` VALUES ('7681', '23', 'Лудингтон', 'Ludington', 'MI', '49431', '43.9624', '-86.3979');
INSERT INTO `net_city` VALUES ('7684', '23', 'Фаруэлл', 'Farwell', 'MI', '48622', '43.8213', '-84.8840');
INSERT INTO `net_city` VALUES ('7686', '23', 'Эварт', 'Evart', 'MI', '49631', '43.9776', '-85.2578');
INSERT INTO `net_city` VALUES ('7687', '23', 'Вудлиф', 'Woodleaf', 'NC', '27054', '35.7909', '-80.6023');
INSERT INTO `net_city` VALUES ('7691', '23', 'Данди', 'Dundee', 'MI', '48131', '41.9603', '-83.6735');
INSERT INTO `net_city` VALUES ('7694', '23', 'Портсмут', 'Portsmouth', 'OH', '45662', '38.7915', '-82.9217');
INSERT INTO `net_city` VALUES ('7697', '23', 'Катлеттсберг', 'Catlettsburg', 'KY', '41129', '38.3092', '-82.6460');
INSERT INTO `net_city` VALUES ('7698', '23', 'Нельсонвилл', 'Nelsonville', 'OH', '45764', '39.4616', '-82.2460');
INSERT INTO `net_city` VALUES ('7699', '23', 'Минерал Уэлс', 'Mineral Wells', 'WV', '26150', '39.1491', '-81.5257');
INSERT INTO `net_city` VALUES ('7700', '23', 'Адамстаун', 'Adamstown', 'MD', '21710', '39.2984', '-77.4543');
INSERT INTO `net_city` VALUES ('7706', '23', 'Манчуа', 'Mantua', 'OH', '44255', '41.3308', '-81.2294');
INSERT INTO `net_city` VALUES ('7714', '23', 'Осейдж', 'Osage', 'IA', '50461', '43.2993', '-92.7993');
INSERT INTO `net_city` VALUES ('7720', '23', 'Оукс', 'Oaks', 'PA', '19456', '40.1318', '-75.4596');
INSERT INTO `net_city` VALUES ('7723', '23', 'Дьюрант', 'Durant', 'OK', '74701', '33.9950', '-96.3917');
INSERT INTO `net_city` VALUES ('7726', '23', 'Вудворд', 'Woodward', 'OK', '73801', '36.4545', '-99.4170');
INSERT INTO `net_city` VALUES ('7729', '23', 'Джерсивилл', 'Jerseyville', 'IL', '62052', '39.0971', '-90.3148');
INSERT INTO `net_city` VALUES ('7734', '23', 'Клей Сити', 'Clay City', 'IL', '62824', '38.6846', '-88.3412');
INSERT INTO `net_city` VALUES ('7735', '23', 'Марлин', 'Marlin', 'TX', '76661', '31.3024', '-96.8434');
INSERT INTO `net_city` VALUES ('7745', '23', 'Исли', 'Easley', 'SC', '29640', '34.8861', '-82.5857');
INSERT INTO `net_city` VALUES ('7747', '23', 'Пайнблафф', 'Pinebluff', 'NC', '28373', '35.0947', '-79.4857');
INSERT INTO `net_city` VALUES ('7750', '23', 'Уолтерборо', 'Walterboro', 'SC', '29488', '32.9183', '-80.6879');
INSERT INTO `net_city` VALUES ('7751', '23', 'Блэквилл', 'Blackville', 'SC', '29817', '33.3668', '-81.2581');
INSERT INTO `net_city` VALUES ('7756', '23', 'Арвония', 'Arvonia', 'VA', '23004', '37.6714', '-78.3997');
INSERT INTO `net_city` VALUES ('7757', '23', 'Риджленд', 'Ridgeland', 'SC', '29936', '32.4835', '-81.0069');
INSERT INTO `net_city` VALUES ('7763', '23', 'Лорис', 'Loris', 'SC', '29569', '34.0210', '-78.9098');
INSERT INTO `net_city` VALUES ('7767', '23', 'Ладсон', 'Ladson', 'SC', '29456', '32.9831', '-80.1223');
INSERT INTO `net_city` VALUES ('7771', '23', 'Маунтин Сити', 'Mountain City', 'TN', '37683', '36.4713', '-81.8144');
INSERT INTO `net_city` VALUES ('7778', '23', 'Делафилд', 'Delafield', 'WI', '53018', '43.0460', '-88.3889');
INSERT INTO `net_city` VALUES ('7789', '23', 'Темплтон', 'Templeton', 'CA', '93465', '35.5422', '-120.7505');
INSERT INTO `net_city` VALUES ('7791', '23', 'Нептьюн Бич', 'Neptune Beach', 'FL', '32266', '30.3159', '-81.4145');
INSERT INTO `net_city` VALUES ('7792', '23', 'Колтон', 'Colton', 'CA', '92324', '34.0144', '-117.2772');
INSERT INTO `net_city` VALUES ('7794', '23', 'Катедрал Сити', 'Cathedral City', 'CA', '92234', '33.8205', '-116.4586');
INSERT INTO `net_city` VALUES ('7796', '23', 'Оскалуза', 'Oskaloosa', 'IA', '52577', '41.2812', '-92.6502');
INSERT INTO `net_city` VALUES ('7801', '23', 'Херши', 'Hershey', 'NE', '69143', '41.1675', '-101.0104');
INSERT INTO `net_city` VALUES ('7804', '23', 'Рок Валли', 'Rock Valley', 'IA', '51247', '43.1944', '-96.3529');
INSERT INTO `net_city` VALUES ('7810', '23', 'Пончатаула', 'Ponchatoula', 'LA', '70454', '30.4009', '-90.3936');
INSERT INTO `net_city` VALUES ('7817', '23', 'Джоппа', 'Joppa', 'MD', '21085', '39.4526', '-76.3528');
INSERT INTO `net_city` VALUES ('7818', '23', 'Хампстед', 'Hampstead', 'MD', '21074', '39.6162', '-76.8258');
INSERT INTO `net_city` VALUES ('7821', '23', 'Тахо Сити', 'Tahoe City', 'CA', '96145', '39.1839', '-120.1468');
INSERT INTO `net_city` VALUES ('7822', '23', 'Йерингтон', 'Yerington', 'NV', '89447', '38.8727', '-119.1489');
INSERT INTO `net_city` VALUES ('7823', '23', 'Роклин', 'Rocklin', 'CA', '95765', '38.8185', '-121.2819');
INSERT INTO `net_city` VALUES ('7824', '23', 'Макминнвилл', 'McMinnville', 'OR', '97128', '45.1949', '-123.2466');
INSERT INTO `net_city` VALUES ('7826', '23', 'Канби', 'Canby', 'OR', '97013', '45.2160', '-122.6667');
INSERT INTO `net_city` VALUES ('7827', '23', 'Силвертон', 'Silverton', 'OR', '97381', '44.9544', '-122.7138');
INSERT INTO `net_city` VALUES ('7829', '23', 'Элк Гров', 'Elk Grove', 'CA', '95624', '38.4412', '-121.3064');
INSERT INTO `net_city` VALUES ('7831', '23', 'Мендота', 'Mendota', 'CA', '93640', '36.6712', '-120.4387');
INSERT INTO `net_city` VALUES ('7832', '23', 'Вирджиния Сити', 'Virginia City', 'NV', '89440', '39.3070', '-119.6353');
INSERT INTO `net_city` VALUES ('7833', '23', 'Мантека', 'Manteca', 'CA', '95336', '37.8311', '-121.1872');
INSERT INTO `net_city` VALUES ('7834', '23', 'Линден', 'Linden', 'NJ', '07036', '40.6247', '-74.2494');
INSERT INTO `net_city` VALUES ('7835', '23', 'Галесвилл', 'Galesville', 'WI', '54630', '44.0945', '-91.3427');
INSERT INTO `net_city` VALUES ('7841', '23', 'Портола', 'Portola', 'CA', '96122', '39.7963', '-120.4673');
INSERT INTO `net_city` VALUES ('7843', '23', 'Санта Кларита', 'Santa Clarita', 'CA', '91350', '34.4302', '-118.5193');
INSERT INTO `net_city` VALUES ('7846', '23', 'Пасо Роблс', 'Paso Robles', 'CA', '93446', '35.6189', '-120.7669');
INSERT INTO `net_city` VALUES ('7848', '23', 'Манхэттен Бич', 'Manhattan Beach', 'CA', '90266', '33.8893', '-118.4010');
INSERT INTO `net_city` VALUES ('7849', '23', 'Никса', 'Nixa', 'MO', '65714', '37.0271', '-93.3193');
INSERT INTO `net_city` VALUES ('7850', '23', 'Киллингтон', 'Killington', 'VT', '05751', '43.6543', '-72.7856');
INSERT INTO `net_city` VALUES ('7851', '23', 'Вентнор Сити', 'Ventnor City', 'NJ', '08406', '39.3418', '-74.4817');
INSERT INTO `net_city` VALUES ('7854', '23', 'Франкенмут', 'Frankenmuth', 'MI', '48734', '43.3546', '-83.7414');
INSERT INTO `net_city` VALUES ('7856', '23', 'Прескотт ', 'Prescott', 'AZ', '86301', '34.6248', '-112.4220');
INSERT INTO `net_city` VALUES ('7857', '23', 'Пич Спрингс', 'Peach Springs', 'AZ', '86434', '35.6440', '-113.6189');
INSERT INTO `net_city` VALUES ('7863', '23', 'Роджерс', 'Rogers', 'MN', '55374', '45.1708', '-93.5758');
INSERT INTO `net_city` VALUES ('7865', '23', 'Тоано', 'Toano', 'VA', '23168', '37.4179', '-76.8329');
INSERT INTO `net_city` VALUES ('7866', '23', 'Дептфорд', 'Deptford', 'NJ', '08080', '39.7615', '-75.1245');
INSERT INTO `net_city` VALUES ('7869', '23', 'Ридсвилл', 'Reedsville', 'WV', '26547', '39.5133', '-79.8139');
INSERT INTO `net_city` VALUES ('7870', '23', 'Дитмер', 'Dittmer', 'MO', '63023', '38.2676', '-90.7065');
INSERT INTO `net_city` VALUES ('7872', '23', 'Уайтсберг', 'Whitesburg', 'KY', '41858', '37.1338', '-82.8747');
INSERT INTO `net_city` VALUES ('7873', '23', 'Эдгартаун', 'Edgartown', 'MA', '02539', '41.3843', '-70.5535');
INSERT INTO `net_city` VALUES ('7874', '23', 'Этова', 'Etowah', 'TN', '37331', '35.3321', '-84.5301');
INSERT INTO `net_city` VALUES ('7876', '23', 'Кембридж', 'Cambridge', 'MN', '55008', '45.5650', '-93.2729');
INSERT INTO `net_city` VALUES ('7877', '23', 'Оксон Хилл', 'Oxon Hill', 'MD', '20745', '38.8046', '-76.9947');
INSERT INTO `net_city` VALUES ('7882', '23', 'Маунт Эйри', 'Mount Airy', 'NC', '27030', '36.4617', '-80.6191');
INSERT INTO `net_city` VALUES ('7885', '23', 'Кадис', 'Cadiz', 'OH', '43907', '40.2612', '-81.0199');
INSERT INTO `net_city` VALUES ('7897', '23', 'Одубон', 'Audubon', 'MN', '56511', '46.8547', '-96.0026');
INSERT INTO `net_city` VALUES ('7898', '23', 'Фэрибо', 'Faribault', 'MN', '55021', '44.3278', '-93.2776');
INSERT INTO `net_city` VALUES ('7900', '23', 'Уид', 'Weed', 'CA', '96094', '41.5109', '-122.3648');
INSERT INTO `net_city` VALUES ('7903', '23', 'Манси', 'Muncy', 'PA', '17756', '41.2240', '-76.6180');
INSERT INTO `net_city` VALUES ('7910', '23', 'Форт Кэмпбелл', 'Fort Campbell', 'KY', '42223', '36.6408', '-87.4718');
INSERT INTO `net_city` VALUES ('7912', '23', 'Пайлот Пойнт', 'Pilot Point', 'TX', '76258', '33.3635', '-96.9170');
INSERT INTO `net_city` VALUES ('7913', '23', 'Адайрвилл', 'Adairville', 'KY', '42202', '36.6951', '-86.8594');
INSERT INTO `net_city` VALUES ('7914', '23', 'Ашленд Сити', 'Ashland City', 'TN', '37015', '36.2833', '-87.0121');
INSERT INTO `net_city` VALUES ('7915', '23', 'Томпкинсвилл', 'Tompkinsville', 'KY', '42167', '36.7264', '-85.6923');
INSERT INTO `net_city` VALUES ('7917', '23', 'Шелдон', 'Sheldon', 'VT', '05483', '44.8926', '-72.9538');
INSERT INTO `net_city` VALUES ('7918', '23', 'Данвилл', 'Danville', 'PA', '17821', '41.0415', '-76.6507');
INSERT INTO `net_city` VALUES ('7919', '23', 'Норт Либерти', 'North Liberty', 'IA', '52317', '41.7643', '-91.6326');
INSERT INTO `net_city` VALUES ('7920', '23', 'Бримфилд', 'Brimfield', 'IL', '61517', '40.8167', '-89.8603');
INSERT INTO `net_city` VALUES ('7921', '23', 'Лейквилл', 'Lakeville', 'CT', '06039', '41.9674', '-73.4321');
INSERT INTO `net_city` VALUES ('7929', '23', 'Джемез Спрингс', 'Jemez Springs', 'NM', '87025', '35.8352', '-106.6696');
INSERT INTO `net_city` VALUES ('7933', '23', 'Аламоса', 'Alamosa', 'CO', '81101', '37.4625', '-105.7804');
INSERT INTO `net_city` VALUES ('7936', '23', 'Кле Элум', 'Cle Elum', 'WA', '98922', '47.2073', '-120.9022');
INSERT INTO `net_city` VALUES ('7937', '23', 'Карролтон', 'Carrollton', 'GA', '30117', '33.5756', '-85.1340');
INSERT INTO `net_city` VALUES ('7941', '23', 'Уинтер Гарден', 'Winter Garden', 'FL', '34787', '28.4768', '-81.6319');
INSERT INTO `net_city` VALUES ('7942', '23', 'Кингсленд', 'Kingsland', 'GA', '31548', '30.7985', '-81.7207');
INSERT INTO `net_city` VALUES ('7944', '23', 'Биг Спринг', 'Big Spring', 'TX', '79720', '32.1864', '-101.4510');
INSERT INTO `net_city` VALUES ('7945', '23', 'Лолита', 'Lolita', 'TX', '77971', '28.8373', '-96.5195');
INSERT INTO `net_city` VALUES ('7948', '23', 'Белхейвен', 'Belhaven', 'NC', '27810', '35.6169', '-76.4850');
INSERT INTO `net_city` VALUES ('7951', '23', 'Форест Гров', 'Forest Grove', 'OR', '97116', '45.5559', '-123.1511');
INSERT INTO `net_city` VALUES ('7953', '23', 'Пейнтед Пост', 'Painted Post', 'NY', '14870', '42.1753', '-77.1269');
INSERT INTO `net_city` VALUES ('7955', '23', 'Пайн Медоу', 'Pine Meadow', 'CT', '06061', '41.8765', '-72.9671');
INSERT INTO `net_city` VALUES ('7956', '23', 'Стокбридж', 'Stockbridge', 'MA', '01262', '42.2822', '-73.3262');
INSERT INTO `net_city` VALUES ('7962', '23', 'Коко-Бич', 'Cocoa Beach', 'FL', '32931', '28.3257', '-80.6122');
INSERT INTO `net_city` VALUES ('7970', '23', 'Браунсберг', 'Brownsburg', 'IN', '46112', '39.8725', '-86.3826');
INSERT INTO `net_city` VALUES ('7971', '23', 'Гринсбург', 'Greensburg', 'IN', '47240', '39.3251', '-85.4792');
INSERT INTO `net_city` VALUES ('7972', '23', 'Райнелендер', 'Rhinelander', 'WI', '54501', '45.6799', '-89.3460');
INSERT INTO `net_city` VALUES ('7973', '23', 'Аркола', 'Arcola', 'IL', '61910', '39.6753', '-88.2960');
INSERT INTO `net_city` VALUES ('7974', '23', 'Вудлейк', 'Woodlake', 'CA', '93286', '36.4659', '-119.1022');
INSERT INTO `net_city` VALUES ('7976', '23', 'Карролтон', 'Carrollton', 'OH', '44615', '40.5758', '-81.0646');
INSERT INTO `net_city` VALUES ('7977', '23', 'Ноблсвилл', 'Noblesville', 'IN', '46060', '40.0698', '-85.9817');
INSERT INTO `net_city` VALUES ('7978', '23', 'Рантул', 'Rantoul', 'IL', '61866', '40.3118', '-88.1467');
INSERT INTO `net_city` VALUES ('7984', '23', 'Галт', 'Galt', 'CA', '95632', '38.2722', '-121.2289');
INSERT INTO `net_city` VALUES ('7986', '23', 'Данниган', 'Dunnigan', 'CA', '95937', '38.8831', '-122.0022');
INSERT INTO `net_city` VALUES ('7989', '23', 'Рудхаус', 'Roodhouse', 'IL', '62082', '39.5008', '-90.3322');
INSERT INTO `net_city` VALUES ('7993', '23', 'Крестон', 'Creston', 'CA', '93432', '35.4780', '-120.4891');
INSERT INTO `net_city` VALUES ('7994', '23', 'Сан-Габриэль', 'San Gabriel', 'CA', '91776', '34.0891', '-118.0924');
INSERT INTO `net_city` VALUES ('7996', '23', 'Альгамбра', 'Alhambra', 'CA', '91801', '34.0905', '-118.1344');
INSERT INTO `net_city` VALUES ('8000', '23', 'Сентерпорт', 'Centerport', 'PA', '19516', '40.4862', '-76.0074');
INSERT INTO `net_city` VALUES ('8003', '23', 'Рутерфорд', 'Rutherford', 'CA', '94573', '38.4585', '-122.4225');
INSERT INTO `net_city` VALUES ('8006', '23', 'Гассвилл', 'Gassville', 'AR', '72635', '36.3178', '-92.4825');
INSERT INTO `net_city` VALUES ('8007', '23', 'Ардмор', 'Ardmore', 'OK', '73401', '34.1894', '-97.1603');
INSERT INTO `net_city` VALUES ('8011', '23', 'Вельма', 'Velma', 'OK', '73491', '34.4601', '-97.6739');
INSERT INTO `net_city` VALUES ('8012', '23', 'Эль Рино', 'El Reno', 'OK', '73036', '35.4931', '-97.9812');
INSERT INTO `net_city` VALUES ('8015', '23', 'Гатри', 'Guthrie', 'OK', '73044', '35.8590', '-97.4340');
INSERT INTO `net_city` VALUES ('8016', '23', 'Уотонга', 'Watonga', 'OK', '73772', '35.8912', '-98.4102');
INSERT INTO `net_city` VALUES ('8019', '23', 'Уолтерс', 'Walters', 'OK', '73572', '34.3684', '-98.4004');
INSERT INTO `net_city` VALUES ('8020', '23', 'Форт Стоктон', 'Fort Stockton', 'TX', '79735', '30.6791', '-102.7875');
INSERT INTO `net_city` VALUES ('8023', '23', 'Ньюберг', 'Newberg', 'OR', '97132', '45.3234', '-122.9820');
INSERT INTO `net_city` VALUES ('8030', '23', 'Гарднервилл', 'Gardnerville', 'NV', '89410', '38.7599', '-119.6135');
INSERT INTO `net_city` VALUES ('8031', '23', 'Уайт Стон', 'White Stone', 'VA', '22578', '37.6518', '-76.3594');
INSERT INTO `net_city` VALUES ('8034', '23', 'Латроп', 'Lathrop', 'CA', '95330', '37.8227', '-121.2900');
INSERT INTO `net_city` VALUES ('8037', '23', 'Сканителес', 'Skaneateles', 'NY', '13152', '42.9051', '-76.3563');
INSERT INTO `net_city` VALUES ('8041', '23', 'Санмен', 'Sunman', 'IN', '47041', '39.2371', '-85.0981');
INSERT INTO `net_city` VALUES ('8047', '23', 'Фестус', 'Festus', 'MO', '63028', '38.1177', '-90.3976');
INSERT INTO `net_city` VALUES ('8049', '23', 'Согас', 'Saugus', 'MA', '01906', '42.4675', '-71.0131');
INSERT INTO `net_city` VALUES ('8053', '23', 'Бруклин', 'Brookline', 'MA', '02446', '42.3431', '-71.1230');
INSERT INTO `net_city` VALUES ('8054', '23', 'Рейнхем', 'Raynham', 'MA', '02767', '41.9391', '-71.0586');
INSERT INTO `net_city` VALUES ('8056', '23', 'Баззардс Бэй', 'Buzzards Bay', 'MA', '02542', '41.7040', '-70.5432');
INSERT INTO `net_city` VALUES ('8058', '23', 'Ноблборо', 'Nobleboro', 'ME', '04555', '44.1109', '-69.4820');
INSERT INTO `net_city` VALUES ('8061', '23', 'Киттери', 'Kittery', 'ME', '03904', '43.1153', '-70.7051');
INSERT INTO `net_city` VALUES ('8062', '23', 'Скоухеган', 'Skowhegan', 'ME', '04976', '44.8071', '-69.6740');
INSERT INTO `net_city` VALUES ('8063', '23', 'Мариетта', 'Marietta', 'OH', '45750', '39.4411', '-81.3466');
INSERT INTO `net_city` VALUES ('8081', '23', 'Терривилл', 'Terryville', 'CT', '06786', '41.6642', '-73.0195');
INSERT INTO `net_city` VALUES ('8083', '23', 'Мартинсвилл', 'Martinsville', 'IN', '46151', '39.4520', '-86.4673');
INSERT INTO `net_city` VALUES ('8084', '23', 'Алпайн', 'Alpine', 'TX', '79830', '29.9510', '-103.4682');
INSERT INTO `net_city` VALUES ('8085', '23', 'Франкфорт', 'Frankfort', 'IN', '46041', '40.3187', '-86.4688');
INSERT INTO `net_city` VALUES ('8086', '23', 'Буффало Гэп', 'Buffalo Gap', 'TX', '79508', '32.2702', '-99.8290');
INSERT INTO `net_city` VALUES ('8088', '23', 'Буффало Джанкшен', 'Buffalo Junction', 'VA', '24529', '36.6000', '-78.6116');
INSERT INTO `net_city` VALUES ('8090', '23', 'Баннинг', 'Banning', 'CA', '92220', '33.9227', '-116.8336');
INSERT INTO `net_city` VALUES ('8094', '23', 'Индиан Хед', 'Indian Head', 'MD', '20640', '38.5584', '-77.1433');
INSERT INTO `net_city` VALUES ('8097', '23', 'Стар', 'Star', 'NC', '27356', '35.4355', '-79.7967');
INSERT INTO `net_city` VALUES ('8100', '23', 'Леди Лейк', 'Lady Lake', 'FL', '32159', '28.9235', '-81.9185');
INSERT INTO `net_city` VALUES ('8102', '23', 'Сейнт Клауд', 'Saint Cloud', 'FL', '34772', '28.1669', '-81.2700');
INSERT INTO `net_city` VALUES ('8103', '23', 'Бранфорд', 'Branford', 'FL', '32008', '29.8959', '-82.8992');
INSERT INTO `net_city` VALUES ('8112', '23', 'Дэниелсон', 'Danielson', 'CT', '06239', '41.7890', '-71.8552');
INSERT INTO `net_city` VALUES ('8114', '23', 'Хадли', 'Hadley', 'MA', '01035', '42.3567', '-72.5864');
INSERT INTO `net_city` VALUES ('8115', '23', 'Ленокс', 'Lenox', 'MA', '01240', '42.3665', '-73.2636');
INSERT INTO `net_city` VALUES ('8117', '23', 'Райтстаун', 'Wrightstown', 'NJ', '08562', '40.0688', '-74.5956');
INSERT INTO `net_city` VALUES ('8119', '23', 'Аллен', 'Allen', 'TX', '75013', '33.1122', '-96.6938');
INSERT INTO `net_city` VALUES ('8123', '23', 'Ла Плата', 'La Plata', 'MD', '20646', '38.5163', '-77.0154');
INSERT INTO `net_city` VALUES ('8124', '23', 'Стивенсберг', 'Stevensburg', 'VA', '22741', '38.4519', '-77.8796');
INSERT INTO `net_city` VALUES ('8125', '24', 'Оттава', 'Ottawa', 'ON', 'k2k2w7', '45.4167', '-75.7000');
INSERT INTO `net_city` VALUES ('8126', '23', 'Стивенс Сити', 'Stephens City', 'VA', '22655', '39.0457', '-78.2276');
INSERT INTO `net_city` VALUES ('8130', '23', 'Фолстон', 'Fallston', 'MD', '21047', '39.5338', '-76.4450');
INSERT INTO `net_city` VALUES ('8132', '23', 'Холлидейсберг', 'Hollidaysburg', 'PA', '16648', '40.4368', '-78.3315');
INSERT INTO `net_city` VALUES ('8134', '23', 'Киндерхук', 'Kinderhook', 'NY', '12106', '42.3858', '-73.7149');
INSERT INTO `net_city` VALUES ('8139', '23', 'Алачуа', 'Alachua', 'FL', '32615', '29.8142', '-82.4909');
INSERT INTO `net_city` VALUES ('8141', '23', 'Саут Пасадена', 'South Pasadena', 'CA', '91030', '34.1121', '-118.1564');
INSERT INTO `net_city` VALUES ('8142', '23', 'Мохаве', 'Mojave', 'CA', '93501', '35.0979', '-118.1302');
INSERT INTO `net_city` VALUES ('8143', '23', 'Стивенсон Ранч', 'Stevenson Ranch', 'CA', '91381', '34.3759', '-118.6162');
INSERT INTO `net_city` VALUES ('8144', '23', 'Гудзон', 'Hudson', 'MA', '01749', '42.3897', '-71.5401');
INSERT INTO `net_city` VALUES ('8146', '23', 'Холи', 'Hawley', 'MN', '56549', '46.8498', '-96.3146');
INSERT INTO `net_city` VALUES ('8148', '23', 'Рамона', 'Ramona', 'OK', '74061', '36.5396', '-95.9054');
INSERT INTO `net_city` VALUES ('8149', '23', 'Форест Сити', 'Forrest City', 'AR', '72335', '35.0257', '-90.7807');
INSERT INTO `net_city` VALUES ('8152', '23', 'Хендерсонвилл', 'Hendersonville', 'TN', '37075', '36.3479', '-86.6005');
INSERT INTO `net_city` VALUES ('8153', '23', 'Резерв', 'Reserve', 'LA', '70084', '30.0684', '-90.5804');
INSERT INTO `net_city` VALUES ('8154', '23', 'Спаниш Форт', 'Spanish Fort', 'AL', '36527', '30.7021', '-87.8637');
INSERT INTO `net_city` VALUES ('8158', '23', 'Бро Бридж', 'Breaux Bridge', 'LA', '70517', '30.2853', '-91.7987');
INSERT INTO `net_city` VALUES ('8160', '23', 'Вашингтон', 'Washington', 'OH', '43160', '39.5372', '-83.4343');
INSERT INTO `net_city` VALUES ('8167', '23', 'Серклвилл', 'Circleville', 'OH', '43113', '39.5929', '-82.8912');
INSERT INTO `net_city` VALUES ('8169', '23', 'Хантингтон Парк', 'Huntington Park', 'CA', '90255', '33.9775', '-118.2133');
INSERT INTO `net_city` VALUES ('8171', '23', 'Розмид', 'Rosemead', 'CA', '91770', '34.0616', '-118.0818');
INSERT INTO `net_city` VALUES ('8173', '23', 'Малверн', 'Malvern', 'AR', '72104', '34.3422', '-92.7960');
INSERT INTO `net_city` VALUES ('8179', '23', 'Уитмор Лейк', 'Whitmore Lake', 'MI', '48189', '42.4054', '-83.7943');
INSERT INTO `net_city` VALUES ('8182', '23', 'Арчболд', 'Archbold', 'OH', '43502', '41.5375', '-84.3010');
INSERT INTO `net_city` VALUES ('8190', '23', 'Локуст Гров', 'Locust Grove', 'VA', '22508', '38.3113', '-77.7871');
INSERT INTO `net_city` VALUES ('8192', '23', 'Кингсвилл', 'Kingsville', 'MO', '64061', '38.7817', '-94.0919');
INSERT INTO `net_city` VALUES ('8193', '23', 'Клируотер', 'Clearwater', 'KS', '67026', '37.5050', '-97.5067');
INSERT INTO `net_city` VALUES ('8201', '23', 'Холи', 'Hawley', 'PA', '18428', '41.4165', '-75.1552');
INSERT INTO `net_city` VALUES ('8203', '23', 'Эйкрон', 'Akron', 'NY', '14001', '43.0334', '-78.5068');
INSERT INTO `net_city` VALUES ('8213', '23', 'Галион', 'Galion', 'OH', '44833', '40.7136', '-82.8012');
INSERT INTO `net_city` VALUES ('8216', '23', 'Гири', 'Geary', 'OK', '73040', '35.6559', '-98.3829');
INSERT INTO `net_city` VALUES ('8222', '23', 'Стивенсвилл', 'Stevensville', 'MT', '59870', '46.5081', '-114.1057');
INSERT INTO `net_city` VALUES ('8226', '23', 'Линвуд', 'Lynwood', 'CA', '90262', '33.9251', '-118.2032');
INSERT INTO `net_city` VALUES ('8227', '23', 'Сейнт Джонс', 'Saint Johns', 'MI', '48879', '43.0125', '-84.5722');
INSERT INTO `net_city` VALUES ('8231', '23', 'Монро', 'Monroe', 'OH', '45050', '39.4445', '-84.3678');
INSERT INTO `net_city` VALUES ('8233', '23', 'Молалла', 'Molalla', 'OR', '97038', '45.0730', '-122.5548');
INSERT INTO `net_city` VALUES ('8237', '23', 'Норко', 'Norco', 'CA', '92860', '33.9300', '-117.5642');
INSERT INTO `net_city` VALUES ('8239', '23', 'Экспорт', 'Export', 'PA', '15632', '40.4354', '-79.6192');
INSERT INTO `net_city` VALUES ('8242', '23', 'Ютика', 'Utica', 'PA', '16362', '41.4200', '-79.9781');
INSERT INTO `net_city` VALUES ('8244', '23', 'Маунт-Плезант', 'Mount Pleasant', 'PA', '15666', '40.1490', '-79.5181');
INSERT INTO `net_city` VALUES ('8246', '23', 'Райтсвилл', 'Wrightsville', 'PA', '17368', '39.9865', '-76.5318');
INSERT INTO `net_city` VALUES ('8248', '23', 'Карлайл', 'Carlisle', 'PA', '17013', '40.1808', '-77.2139');
INSERT INTO `net_city` VALUES ('8251', '23', 'Спрингфилд Гарденс', 'Springfield Gardens', 'NY', '11413', '40.6650', '-73.7502');
INSERT INTO `net_city` VALUES ('8265', '23', 'Саусалито', 'Sausalito', 'CA', '94966', '37.8591', '-122.4852');
INSERT INTO `net_city` VALUES ('8271', '23', 'Дир Парк', 'Deer Park', 'NY', '11729', '40.7627', '-73.3227');
INSERT INTO `net_city` VALUES ('8272', '23', 'Джонсборо', 'Jonesboro', 'GA', '30236', '33.5209', '-84.3238');
INSERT INTO `net_city` VALUES ('8273', '23', 'Чеуэла', 'Chewelah', 'WA', '99109', '48.2660', '-117.7635');
INSERT INTO `net_city` VALUES ('8279', '23', 'Хаддонфилд', 'Haddonfield', 'NJ', '08033', '39.8942', '-75.0394');
INSERT INTO `net_city` VALUES ('8282', '23', 'Ист Лансинг', 'East Lansing', 'MI', '48823', '42.7627', '-84.4427');
INSERT INTO `net_city` VALUES ('8295', '23', 'Гленс Фолс', 'Glens Falls', 'NY', '12801', '43.3101', '-73.6432');
INSERT INTO `net_city` VALUES ('8299', '23', 'Мейбрук', 'Maybrook', 'NY', '12543', '41.4882', '-74.2203');
INSERT INTO `net_city` VALUES ('8302', '23', 'Дейд Сити', 'Dade City', 'FL', '33525', '28.3466', '-82.2480');
INSERT INTO `net_city` VALUES ('8308', '23', 'Литл Ферри', 'Little Ferry', 'NJ', '07643', '40.8442', '-74.0416');
INSERT INTO `net_city` VALUES ('8311', '23', 'Ла Хабра', 'La Habra', 'CA', '90631', '33.9414', '-117.9555');
INSERT INTO `net_city` VALUES ('8318', '23', 'Кеосоква', 'Keosauqua', 'IA', '52565', '40.7326', '-91.9644');
INSERT INTO `net_city` VALUES ('8322', '23', 'Уолкотт', 'Walcott', 'IA', '52773', '41.6109', '-90.7632');
INSERT INTO `net_city` VALUES ('8324', '23', 'Коттонвуд', 'Cottonwood', 'AZ', '86326', '34.7582', '-112.0118');
INSERT INTO `net_city` VALUES ('8325', '23', 'Уайт Ривер Джанкшен', 'White River Junction', 'VT', '05001', '43.6543', '-72.3904');
INSERT INTO `net_city` VALUES ('8326', '23', 'Норт-Конуэй', 'North Conway', 'NH', '03860', '44.0354', '-71.1348');
INSERT INTO `net_city` VALUES ('8328', '23', 'Роктон', 'Rockton', 'IL', '61072', '42.4656', '-89.1715');
INSERT INTO `net_city` VALUES ('8337', '23', 'Корайдон', 'Corydon', 'IN', '47112', '38.1841', '-86.1523');
INSERT INTO `net_city` VALUES ('8340', '23', 'Ходженвилл', 'Hodgenville', 'KY', '42748', '37.5652', '-85.7264');
INSERT INTO `net_city` VALUES ('8341', '23', 'Артемус', 'Artemus', 'KY', '40903', '36.7908', '-83.8190');
INSERT INTO `net_city` VALUES ('8343', '23', 'Беверли', 'Beverly', 'KY', '40913', '37.0230', '-83.5593');
INSERT INTO `net_city` VALUES ('8344', '23', 'Санта Йзабел', 'Santa Ysabel', 'CA', '92070', '33.1858', '-116.7317');
INSERT INTO `net_city` VALUES ('8350', '23', 'Голконда', 'Golconda', 'NV', '89414', '40.9361', '-117.3312');
INSERT INTO `net_city` VALUES ('8351', '23', 'Кобальт', 'Cobalt', 'ID', '83229', '44.9681', '-113.8167');
INSERT INTO `net_city` VALUES ('8352', '23', 'Фильмор', 'Fillmore', 'UT', '84631', '39.0186', '-112.2729');
INSERT INTO `net_city` VALUES ('8355', '23', 'Ред Лодж', 'Red Lodge', 'MT', '59068', '45.2331', '-109.4403');
INSERT INTO `net_city` VALUES ('8358', '23', 'Санборн', 'Sanborn', 'NY', '14132', '43.1476', '-78.8754');
INSERT INTO `net_city` VALUES ('8359', '23', 'Кларенс', 'Clarence', 'NY', '14031', '42.9986', '-78.6142');
INSERT INTO `net_city` VALUES ('8360', '23', 'Кларион', 'Clarion', 'PA', '16214', '41.1755', '-79.3791');
INSERT INTO `net_city` VALUES ('8362', '23', 'Бабилон', 'Babylon', 'NY', '11702', '40.6278', '-73.3650');
INSERT INTO `net_city` VALUES ('8364', '23', 'Сигнал Хилл', 'Signal Hill', 'CA', '90755', '33.8008', '-118.1673');
INSERT INTO `net_city` VALUES ('8365', '23', 'Омсвилл', 'Aumsville', 'OR', '97325', '44.8268', '-122.8548');
INSERT INTO `net_city` VALUES ('8366', '23', 'Питтсфорд', 'Pittsford', 'NY', '14534', '43.0511', '-77.5224');
INSERT INTO `net_city` VALUES ('8367', '23', 'Перри', 'Perry', 'NY', '14530', '42.7328', '-78.0197');
INSERT INTO `net_city` VALUES ('8375', '23', 'Орион', 'Orion', 'IL', '61273', '41.3619', '-90.4142');
INSERT INTO `net_city` VALUES ('8377', '23', 'Норт Брукфилд', 'North Brookfield', 'MA', '01535', '42.2691', '-72.0826');
INSERT INTO `net_city` VALUES ('8384', '23', 'Уосика', 'Waseca', 'MN', '56093', '44.0656', '-93.5270');
INSERT INTO `net_city` VALUES ('8385', '23', 'Инвер-Гров-Хайтс', 'Inver Grove Heights', 'MN', '55077', '44.8219', '-93.0578');
INSERT INTO `net_city` VALUES ('8386', '23', 'Стиллуотер', 'Stillwater', 'MN', '55082', '45.0648', '-92.8473');
INSERT INTO `net_city` VALUES ('8387', '23', 'Саут-Сент-Пол', 'South Saint Paul', 'MN', '55075', '44.8839', '-93.0400');
INSERT INTO `net_city` VALUES ('8388', '23', 'Браунсдейл', 'Brownsdale', 'MN', '55918', '43.7421', '-92.8496');
INSERT INTO `net_city` VALUES ('8397', '23', 'Моменс', 'Momence', 'IL', '60954', '41.1166', '-87.6278');
INSERT INTO `net_city` VALUES ('8399', '23', 'Томагавк', 'Tomahawk', 'KY', '41262', '37.8625', '-82.6174');
INSERT INTO `net_city` VALUES ('8401', '23', 'Аннандейл', 'Annandale', 'MN', '55302', '45.2603', '-94.1308');
INSERT INTO `net_city` VALUES ('8402', '23', 'Пенджили', 'Pengilly', 'MN', '55775', '47.2834', '-93.1929');
INSERT INTO `net_city` VALUES ('8404', '23', 'Айола', 'Iola', 'WI', '54990', '44.4619', '-88.9150');
INSERT INTO `net_city` VALUES ('8405', '23', 'Маастон', 'Mauston', 'WI', '53948', '43.7720', '-90.0337');
INSERT INTO `net_city` VALUES ('8407', '23', 'Саламанка', 'Salamanca', 'NY', '14779', '42.0826', '-78.7601');
INSERT INTO `net_city` VALUES ('8408', '23', 'Льюисберг', 'Lewisburg', 'PA', '17837', '40.9812', '-76.9587');
INSERT INTO `net_city` VALUES ('8415', '23', 'Саллигент', 'Sulligent', 'AL', '35586', '33.8396', '-88.1066');
INSERT INTO `net_city` VALUES ('8416', '23', 'Скайатук', 'Skiatook', 'OK', '74070', '36.4218', '-96.0543');
INSERT INTO `net_city` VALUES ('8427', '23', 'Марлетт', 'Marlette', 'MI', '48453', '43.3530', '-83.0142');
INSERT INTO `net_city` VALUES ('8428', '23', 'Алмонт', 'Almont', 'MI', '48003', '42.9358', '-83.0440');
INSERT INTO `net_city` VALUES ('8429', '23', 'Олди', 'Aldie', 'VA', '20105', '38.9636', '-77.6131');
INSERT INTO `net_city` VALUES ('8430', '23', 'Боррего Спрингс', 'Borrego Springs', 'CA', '92004', '33.1799', '-116.2731');
INSERT INTO `net_city` VALUES ('8434', '23', 'Кортленд', 'Cortland', 'NY', '13045', '42.6178', '-76.1926');
INSERT INTO `net_city` VALUES ('8435', '23', 'Бат', 'Bath', 'NY', '14810', '42.3629', '-77.3539');
INSERT INTO `net_city` VALUES ('8436', '23', 'Мидлфилд', 'Middlefield', 'OH', '44062', '41.4558', '-81.0184');
INSERT INTO `net_city` VALUES ('8437', '23', 'Саладо', 'Salado', 'TX', '76571', '30.9287', '-97.5819');
INSERT INTO `net_city` VALUES ('8439', '23', 'Грин', 'Greene', 'NY', '13778', '42.3384', '-75.7544');
INSERT INTO `net_city` VALUES ('8440', '23', 'Содус', 'Sodus', 'NY', '14551', '43.2152', '-77.0415');
INSERT INTO `net_city` VALUES ('8441', '23', 'Джеймсвилл', 'Jamesville', 'NY', '13078', '42.9605', '-76.0589');
INSERT INTO `net_city` VALUES ('8444', '23', 'Мэн', 'Maine', 'NY', '13802', '42.2586', '-76.0548');
INSERT INTO `net_city` VALUES ('8445', '23', 'Мортон Гров', 'Morton Grove', 'IL', '60053', '42.0390', '-87.7938');
INSERT INTO `net_city` VALUES ('8446', '23', 'Феррис', 'Ferris', 'TX', '75125', '32.5427', '-96.6176');
INSERT INTO `net_city` VALUES ('8449', '23', 'Одесса', 'Odessa', 'NY', '14869', '42.3680', '-76.7728');
INSERT INTO `net_city` VALUES ('8452', '23', 'Ремингтон', 'Remington', 'VA', '22734', '38.5390', '-77.8067');
INSERT INTO `net_city` VALUES ('8453', '23', 'Сиерра Виста', 'Sierra Vista', 'AZ', '85635', '31.5918', '-110.1719');
INSERT INTO `net_city` VALUES ('8456', '23', 'Типп Сити', 'Tipp City', 'OH', '45371', '39.9402', '-84.1727');
INSERT INTO `net_city` VALUES ('8458', '23', 'Блафтон', 'Bluffton', 'IN', '46714', '40.7134', '-85.1648');
INSERT INTO `net_city` VALUES ('8460', '23', 'Порт Нечес', 'Port Neches', 'TX', '77651', '29.9801', '-93.9587');
INSERT INTO `net_city` VALUES ('8462', '23', 'Колумбус', 'Columbus', 'TX', '78934', '29.7679', '-96.5874');
INSERT INTO `net_city` VALUES ('8472', '23', 'Хорсшу-Бенд', 'Horseshoe Bend', 'ID', '83629', '43.9270', '-116.1768');
INSERT INTO `net_city` VALUES ('8478', '23', 'Кошоктон', 'Coshocton', 'OH', '43812', '40.2594', '-81.9641');
INSERT INTO `net_city` VALUES ('8479', '23', 'Уэйн', 'Wayne', 'OH', '43466', '41.2982', '-83.5151');
INSERT INTO `net_city` VALUES ('8480', '23', 'Ашвилл', 'Ashville', 'OH', '43103', '39.7220', '-82.9215');
INSERT INTO `net_city` VALUES ('8482', '23', 'Уэверли', 'Waverly', 'WV', '26184', '39.2993', '-81.3483');
INSERT INTO `net_city` VALUES ('8487', '23', 'Девитт', 'Dewitt', 'MI', '48820', '42.8602', '-84.5941');
INSERT INTO `net_city` VALUES ('8496', '23', 'Энглвуд', 'Englewood', 'FL', '34224', '26.9554', '-82.2987');
INSERT INTO `net_city` VALUES ('8498', '23', 'Марина', 'Marina', 'CA', '93933', '36.6799', '-121.7897');
INSERT INTO `net_city` VALUES ('8505', '23', 'Уомелсдорф', 'Womelsdorf', 'PA', '19567', '40.3941', '-76.2067');
INSERT INTO `net_city` VALUES ('8507', '23', 'Саут-Лейк-Тахо', 'South Lake Tahoe', 'CA', '96150', '38.8479', '-120.0139');
INSERT INTO `net_city` VALUES ('8510', '23', 'Вебстер', 'Webster', 'NY', '14580', '43.2186', '-77.4494');
INSERT INTO `net_city` VALUES ('8513', '23', 'Малшу', 'Muleshoe', 'TX', '79347', '34.2007', '-102.7439');
INSERT INTO `net_city` VALUES ('8515', '23', 'Оттертейл', 'Ottertail', 'MN', '56571', '46.4389', '-95.5324');
INSERT INTO `net_city` VALUES ('8516', '23', 'Лутсен', 'Lutsen', 'MN', '55612', '47.7507', '-90.6045');
INSERT INTO `net_city` VALUES ('8517', '23', 'Примхар', 'Primghar', 'IA', '51245', '43.0734', '-95.6047');
INSERT INTO `net_city` VALUES ('8519', '23', 'Бандон', 'Bandon', 'OR', '97411', '43.0596', '-124.3680');
INSERT INTO `net_city` VALUES ('8520', '23', 'Ок Лон', 'Oak Lawn', 'IL', '60453', '41.7091', '-87.7596');
INSERT INTO `net_city` VALUES ('8525', '23', 'Торнтаун', 'Thorntown', 'IN', '46071', '40.1089', '-86.5818');
INSERT INTO `net_city` VALUES ('8528', '23', 'Таскола', 'Tuscola', 'IL', '61953', '39.7942', '-88.2734');
INSERT INTO `net_city` VALUES ('8539', '23', 'Нью-Алм', 'New Ulm', 'MN', '56073', '44.3041', '-94.4356');
INSERT INTO `net_city` VALUES ('8542', '23', 'Манчестер', 'Manchester', 'VT', '05254', '43.1637', '-73.0723');
INSERT INTO `net_city` VALUES ('8549', '23', 'Сельма', 'Selma', 'CA', '93662', '36.5396', '-119.6452');
INSERT INTO `net_city` VALUES ('8556', '23', 'Олд Фордж', 'Old Forge', 'NY', '13420', '43.7188', '-74.9040');
INSERT INTO `net_city` VALUES ('8557', '23', 'Ганнибал', 'Hannibal', 'NY', '13074', '43.3199', '-76.5473');
INSERT INTO `net_city` VALUES ('8558', '23', 'Франкфурт', 'Frankfort', 'NY', '13340', '43.0384', '-75.1078');
INSERT INTO `net_city` VALUES ('8559', '23', 'Орискани', 'Oriskany', 'NY', '13424', '43.1511', '-75.3629');
INSERT INTO `net_city` VALUES ('8561', '23', 'Ютика', 'Utica', 'NY', '13501', '43.0744', '-75.2117');
INSERT INTO `net_city` VALUES ('8564', '23', 'Вестал', 'Vestal', 'NY', '13850', '42.0567', '-76.0272');
INSERT INTO `net_city` VALUES ('8567', '23', 'Гаррисон', 'Garrison', 'NY', '10524', '41.3780', '-73.9315');
INSERT INTO `net_city` VALUES ('8569', '23', 'Довер Плейнс', 'Dover Plains', 'NY', '12522', '41.7152', '-73.5820');
INSERT INTO `net_city` VALUES ('8573', '23', 'Риджли', 'Ridgely', 'MD', '21660', '38.9598', '-75.8904');
INSERT INTO `net_city` VALUES ('8576', '23', 'Палестин', 'Palestine', 'TX', '75803', '31.8664', '-95.6507');
INSERT INTO `net_city` VALUES ('8577', '23', 'Джером', 'Jerome', 'ID', '83338', '42.7595', '-114.3650');
INSERT INTO `net_city` VALUES ('8584', '23', 'Литчфилд', 'Litchfield', 'IL', '62056', '39.1721', '-89.6905');
INSERT INTO `net_city` VALUES ('8586', '23', 'Гибсония', 'Gibsonia', 'PA', '15044', '40.6421', '-79.9445');
INSERT INTO `net_city` VALUES ('8587', '23', 'Манфордвилл', 'Munfordville', 'KY', '42765', '37.3053', '-85.9140');
INSERT INTO `net_city` VALUES ('8588', '23', 'Оуэнсвилл', 'Owensville', 'MO', '65066', '38.3457', '-91.4814');
INSERT INTO `net_city` VALUES ('8590', '23', 'Лейкхёрст', 'Lakehurst', 'NJ', '08733', '40.0239', '-74.3665');
INSERT INTO `net_city` VALUES ('8594', '23', 'Спрингдейл', 'Springdale', 'PA', '15144', '40.5489', '-79.7844');
INSERT INTO `net_city` VALUES ('8600', '23', 'Уоелдер', 'Waelder', 'TX', '78959', '29.7046', '-97.2741');
INSERT INTO `net_city` VALUES ('8601', '23', 'Леонард', 'Leonard', 'TX', '75452', '33.3872', '-96.2665');
INSERT INTO `net_city` VALUES ('8603', '23', 'Теннесси Колони', 'Tennessee Colony', 'TX', '75861', '31.8690', '-95.8978');
INSERT INTO `net_city` VALUES ('8605', '23', 'Роанок', 'Roanoke', 'TX', '76262', '33.0217', '-97.2224');
INSERT INTO `net_city` VALUES ('8606', '23', 'Литл Элм', 'Little Elm', 'TX', '75068', '33.1809', '-96.9177');
INSERT INTO `net_city` VALUES ('8608', '23', 'Гейтсвилл', 'Gatesville', 'TX', '76528', '31.4397', '-97.7853');
INSERT INTO `net_city` VALUES ('8613', '23', 'Шарлотт', 'Charlotte', 'MI', '48813', '42.5689', '-84.8361');
INSERT INTO `net_city` VALUES ('8615', '23', 'Харбор Спрингс', 'Harbor Springs', 'MI', '49740', '45.5442', '-84.9915');
INSERT INTO `net_city` VALUES ('8616', '23', 'Белдинг', 'Belding', 'MI', '48809', '43.0579', '-85.2779');
INSERT INTO `net_city` VALUES ('8626', '23', 'Гранд Бэй', 'Grand Bay', 'AL', '36541', '30.4922', '-88.3313');
INSERT INTO `net_city` VALUES ('8627', '23', 'Осуиго', 'Oswego', 'NY', '13126', '43.4464', '-76.3971');
INSERT INTO `net_city` VALUES ('8631', '27', 'Байямон', 'Bayamon', '00', '00959', '18.3741', '-66.1403');
INSERT INTO `net_city` VALUES ('8639', '23', 'Титусвилл', 'Titusville', 'FL', '32780', '28.5311', '-80.8523');
INSERT INTO `net_city` VALUES ('8641', '23', 'Бушнелл', 'Bushnell', 'FL', '33513', '28.6833', '-82.1646');
INSERT INTO `net_city` VALUES ('8645', '23', 'Дамфрис', 'Dumfries', 'VA', '22026', '38.5830', '-77.3158');
INSERT INTO `net_city` VALUES ('8647', '23', 'Деленд', 'DeLand', 'FL', '32720', '29.0453', '-81.3976');
INSERT INTO `net_city` VALUES ('8648', '23', 'Гровленд', 'Groveland', 'FL', '34736', '28.5412', '-81.8727');
INSERT INTO `net_city` VALUES ('8657', '23', 'Лома Линда', 'Loma Linda', 'CA', '92354', '34.0530', '-117.2489');
INSERT INTO `net_city` VALUES ('8658', '23', 'Миннетонка', 'Minnetonka', 'MN', '55345', '44.9198', '-93.4832');
INSERT INTO `net_city` VALUES ('8664', '23', 'Пенфилд', 'Penfield', 'IL', '61862', '40.3124', '-87.9513');
INSERT INTO `net_city` VALUES ('8667', '23', 'Сомерс Пойнт', 'Somers Point', 'NJ', '08244', '39.3204', '-74.6009');
INSERT INTO `net_city` VALUES ('8668', '23', 'Манахокин', 'Manahawkin', 'NJ', '08050', '39.7042', '-74.2546');
INSERT INTO `net_city` VALUES ('8670', '23', 'Лебек', 'Lebec', 'CA', '93243', '34.8630', '-118.8715');
INSERT INTO `net_city` VALUES ('8671', '23', 'Клинчфилд', 'Clinchfield', 'GA', '31013', '32.4135', '-83.6382');
INSERT INTO `net_city` VALUES ('8674', '23', 'Дейли Сити', 'Daly City', 'CA', '94014', '37.6869', '-122.4389');
INSERT INTO `net_city` VALUES ('8675', '23', 'Лахайна', 'Lahaina', 'HI', '96761', '20.9091', '-156.6216');
INSERT INTO `net_city` VALUES ('8676', '23', 'Кахеку', 'Kahuku', 'HI', '96731', '21.6645', '-157.9800');
INSERT INTO `net_city` VALUES ('8677', '23', 'Принсевилл', 'Princeville', 'HI', '96722', '22.2225', '-159.4801');
INSERT INTO `net_city` VALUES ('8678', '23', 'Ракерсвилл', 'Ruckersville', 'VA', '22968', '38.2550', '-78.3918');
INSERT INTO `net_city` VALUES ('8681', '23', 'Альварадо', 'Alvarado', 'TX', '76009', '32.4300', '-97.1929');
INSERT INTO `net_city` VALUES ('8685', '23', 'Гордон', 'Gordon', 'GA', '31031', '32.8813', '-83.3133');
INSERT INTO `net_city` VALUES ('8687', '23', 'Уильямс', 'Williams', 'AZ', '86046', '35.3713', '-112.2665');
INSERT INTO `net_city` VALUES ('8691', '23', 'Манхейм', 'Manheim', 'PA', '17545', '40.1767', '-76.4297');
INSERT INTO `net_city` VALUES ('8695', '23', 'Кардингтон', 'Cardington', 'OH', '43315', '40.4896', '-82.8591');
INSERT INTO `net_city` VALUES ('8702', '23', 'Брейди', 'Brady', 'NE', '69123', '41.0320', '-100.3804');
INSERT INTO `net_city` VALUES ('8703', '23', 'Бельвю', 'Bellevue', 'NE', '68005', '41.1425', '-95.8951');
INSERT INTO `net_city` VALUES ('8705', '23', 'Хьюго', 'Hugo', 'CO', '80821', '38.9959', '-103.4601');
INSERT INTO `net_city` VALUES ('8706', '23', 'Хей Спрингс', 'Hay Springs', 'NE', '69347', '42.6536', '-102.7050');
INSERT INTO `net_city` VALUES ('8711', '23', 'Саммервилл', 'Summerville', 'SC', '29483', '33.0975', '-80.1753');
INSERT INTO `net_city` VALUES ('8717', '23', 'Сандстон', 'Sandston', 'VA', '23150', '37.5036', '-77.2608');
INSERT INTO `net_city` VALUES ('8719', '23', 'Палатин', 'Palatine', 'IL', '60067', '42.1032', '-88.0699');
INSERT INTO `net_city` VALUES ('8722', '23', 'Бойс', 'Boyce', 'VA', '22620', '39.0838', '-78.0461');
INSERT INTO `net_city` VALUES ('8726', '23', 'Уэйлуку', 'Wailuku', 'HI', '96793', '20.8999', '-156.5389');
INSERT INTO `net_city` VALUES ('8727', '23', 'Доббинс', 'Dobbins', 'CA', '95935', '39.3680', '-121.2067');
INSERT INTO `net_city` VALUES ('8733', '23', 'Тонганокси', 'Tonganoxie', 'KS', '66086', '39.1120', '-95.0794');
INSERT INTO `net_city` VALUES ('8734', '23', 'Бруквилл', 'Brookville', 'OH', '45309', '39.8374', '-84.4079');
INSERT INTO `net_city` VALUES ('8736', '23', 'Спайсленд', 'Spiceland', 'IN', '47385', '39.8347', '-85.4543');
INSERT INTO `net_city` VALUES ('8749', '23', 'Харперсвилл', 'Harpersville', 'AL', '35078', '33.3368', '-86.4548');
INSERT INTO `net_city` VALUES ('8754', '23', 'Америкус', 'Americus', 'GA', '31709', '32.0535', '-84.1223');
INSERT INTO `net_city` VALUES ('8755', '23', 'Мок', 'Mauk', 'GA', '31058', '32.5050', '-84.4398');
INSERT INTO `net_city` VALUES ('8760', '23', 'Оттумва', 'Ottumwa', 'IA', '52501', '41.0387', '-92.3579');
INSERT INTO `net_city` VALUES ('8761', '23', 'Уитмен', 'Whitman', 'MA', '02382', '42.0804', '-70.9393');
INSERT INTO `net_city` VALUES ('8762', '23', 'Форт Скотт', 'Fort Scott', 'KS', '66701', '37.8266', '-94.7925');
INSERT INTO `net_city` VALUES ('8764', '23', 'Линдейл', 'Lindale', 'TX', '75771', '32.5316', '-95.3916');
INSERT INTO `net_city` VALUES ('8765', '23', 'Мескит', 'Mesquite', 'TX', '75150', '32.8195', '-96.6338');
INSERT INTO `net_city` VALUES ('8766', '23', 'Гринвилл', 'Greenville', 'TX', '75404', '33.1384', '-96.1108');
INSERT INTO `net_city` VALUES ('8767', '23', 'Колер', 'Kohler', 'WI', '53044', '43.7394', '-87.7889');
INSERT INTO `net_city` VALUES ('8768', '23', 'Ван Хорн', 'Van Horn', 'TX', '79855', '31.2785', '-104.5365');
INSERT INTO `net_city` VALUES ('8774', '23', 'Порт Клинтон', 'Port Clinton', 'OH', '43452', '41.5227', '-82.8589');
INSERT INTO `net_city` VALUES ('8775', '23', 'Бернардсвилл', 'Bernardsville', 'NJ', '07924', '40.7262', '-74.5949');
INSERT INTO `net_city` VALUES ('8777', '23', 'Жан', 'Jean', 'NV', '89019', '35.7591', '-115.5376');
INSERT INTO `net_city` VALUES ('8778', '23', 'Рутер Глен', 'Ruther Glen', 'VA', '22546', '37.9550', '-77.4372');
INSERT INTO `net_city` VALUES ('8779', '23', 'Натали', 'Nathalie', 'VA', '24577', '36.9340', '-78.9533');
INSERT INTO `net_city` VALUES ('8782', '23', 'Гарднер', 'Gardner', 'MA', '01440', '42.5899', '-71.9887');
INSERT INTO `net_city` VALUES ('8785', '23', 'Уайтинсвилл', 'Whitinsville', 'MA', '01588', '42.1244', '-71.6653');
INSERT INTO `net_city` VALUES ('8787', '23', 'Нортборо', 'Northborough', 'MA', '01532', '42.3218', '-71.6350');
INSERT INTO `net_city` VALUES ('8789', '23', 'Уэбстер', 'Webster', 'MA', '01570', '42.0581', '-71.8466');
INSERT INTO `net_city` VALUES ('8790', '23', 'Олимпик Вэлли', 'Olympic Valley', 'CA', '96146', '39.1924', '-120.2200');
INSERT INTO `net_city` VALUES ('8792', '23', 'Уэст Лонг Бранч', 'West Long Branch', 'NJ', '07764', '40.2884', '-74.0195');
INSERT INTO `net_city` VALUES ('8796', '23', 'Боливия', 'Bolivia', 'NC', '28422', '34.0150', '-78.1685');
INSERT INTO `net_city` VALUES ('8797', '23', 'Лос Фреснос', 'Los Fresnos', 'TX', '78566', '26.1020', '-97.4113');
INSERT INTO `net_city` VALUES ('8800', '23', 'Шарпсберг', 'Sharpsburg', 'MD', '21782', '39.4497', '-77.7745');
INSERT INTO `net_city` VALUES ('8801', '23', 'Ченанго Форкс', 'Chenango Forks', 'NY', '13746', '42.2901', '-75.8507');
INSERT INTO `net_city` VALUES ('8802', '23', 'Хидалго', 'Hidalgo', 'TX', '78557', '26.1105', '-98.2526');
INSERT INTO `net_city` VALUES ('8803', '23', 'Грейпленд', 'Grapeland', 'TX', '75844', '31.5160', '-95.4276');
INSERT INTO `net_city` VALUES ('8807', '23', 'Эспарто', 'Esparto', 'CA', '95627', '38.7873', '-122.1259');
INSERT INTO `net_city` VALUES ('8813', '23', 'Таппаханнок', 'Tappahannock', 'VA', '22560', '37.9083', '-76.9644');
INSERT INTO `net_city` VALUES ('8815', '23', 'Аддисон', 'Addison', 'PA', '15411', '39.7646', '-79.3560');
INSERT INTO `net_city` VALUES ('8817', '23', 'Ижамсвилл', 'Ijamsville', 'MD', '21754', '39.3452', '-77.3118');
INSERT INTO `net_city` VALUES ('8818', '23', 'Аргос', 'Argos', 'IN', '46501', '41.2230', '-86.2500');
INSERT INTO `net_city` VALUES ('8824', '23', 'Де Бари', 'DeBary', 'FL', '32713', '28.8939', '-81.3194');
INSERT INTO `net_city` VALUES ('8826', '23', 'Аннистон', 'Anniston', 'AL', '36207', '33.6965', '-85.6820');
INSERT INTO `net_city` VALUES ('8827', '23', 'Черчвилл', 'Churchville', 'VA', '24421', '38.2684', '-79.1772');
INSERT INTO `net_city` VALUES ('8828', '23', 'Мидуэй', 'Midway', 'UT', '84049', '40.5089', '-111.5251');
INSERT INTO `net_city` VALUES ('8831', '23', 'Брокпорт', 'Brockport', 'NY', '14420', '43.2508', '-77.9246');
INSERT INTO `net_city` VALUES ('8839', '23', 'Каунтз', 'Kountze', 'TX', '77625', '30.3538', '-94.3882');
INSERT INTO `net_city` VALUES ('8840', '23', 'Северн', 'Severn', 'NC', '27877', '36.5151', '-77.1897');
INSERT INTO `net_city` VALUES ('8841', '23', 'Полтни', 'Poultney', 'VT', '05764', '43.4980', '-73.1831');
INSERT INTO `net_city` VALUES ('8846', '23', 'Хеджесвилл', 'Hedgesville', 'WV', '25427', '39.5235', '-78.0704');
INSERT INTO `net_city` VALUES ('8849', '23', 'Роленд', 'Roland', 'OK', '74954', '35.4394', '-94.5272');
INSERT INTO `net_city` VALUES ('8850', '23', 'Сапулпа', 'Sapulpa', 'OK', '74066', '35.9664', '-96.1630');
INSERT INTO `net_city` VALUES ('8853', '23', 'Лион', 'Lyons', 'KS', '67554', '38.3770', '-98.2110');
INSERT INTO `net_city` VALUES ('8855', '23', 'Талква', 'Tahlequah', 'OK', '74464', '35.9582', '-94.9624');
INSERT INTO `net_city` VALUES ('8857', '23', 'Лафлин', 'Laughlin', 'NV', '89029', '35.1023', '-114.7121');
INSERT INTO `net_city` VALUES ('8860', '23', 'Пондерей', 'Ponderay', 'ID', '83852', '48.3055', '-116.5338');
INSERT INTO `net_city` VALUES ('8861', '23', 'Моран', 'Moran', 'KS', '66755', '37.9145', '-95.1660');
INSERT INTO `net_city` VALUES ('8862', '23', 'Гровс', 'Groves', 'TX', '77619', '29.9446', '-93.9175');
INSERT INTO `net_city` VALUES ('8864', '23', 'Джаспер', 'Jasper', 'TX', '75951', '30.9259', '-94.0738');
INSERT INTO `net_city` VALUES ('8865', '23', 'Уоуконда', 'Wauconda', 'IL', '60084', '42.2711', '-88.1390');
INSERT INTO `net_city` VALUES ('8869', '23', 'Королла', 'Corolla', 'NC', '27927', '36.3897', '-75.8347');
INSERT INTO `net_city` VALUES ('8870', '23', 'Элизабеттаун', 'Elizabethtown', 'NC', '28337', '34.6849', '-78.5435');
INSERT INTO `net_city` VALUES ('8871', '23', 'Беулавилл', 'Beulaville', 'NC', '28518', '34.9022', '-77.7451');
INSERT INTO `net_city` VALUES ('8872', '23', 'Окракок', 'Ocracoke', 'NC', '27960', '35.1304', '-75.9164');
INSERT INTO `net_city` VALUES ('8873', '23', 'Абердин', 'Aberdeen', 'NC', '28315', '35.1060', '-79.4507');
INSERT INTO `net_city` VALUES ('8875', '23', 'Бремен', 'Bremen', 'IN', '46506', '41.4631', '-86.1701');
INSERT INTO `net_city` VALUES ('8877', '23', 'Уэверли', 'Waverly', 'VA', '23890', '37.0051', '-77.1182');
INSERT INTO `net_city` VALUES ('8880', '23', 'Саут Хилл', 'South Hill', 'VA', '23970', '36.7531', '-78.1967');
INSERT INTO `net_city` VALUES ('8881', '23', 'Гошен', 'Goshen', 'VA', '24439', '37.9994', '-79.4921');
INSERT INTO `net_city` VALUES ('8882', '23', 'Плейнс', 'The Plains', 'VA', '20198', '38.8834', '-77.7597');
INSERT INTO `net_city` VALUES ('8884', '23', 'Аппервилл', 'Upperville', 'VA', '20184', '39.0054', '-77.8868');
INSERT INTO `net_city` VALUES ('8890', '23', 'Беруик', 'Berwick', 'PA', '18603', '41.0951', '-76.2619');
INSERT INTO `net_city` VALUES ('8894', '23', 'Альфред', 'Alfred', 'NY', '14802', '42.2541', '-77.7907');
INSERT INTO `net_city` VALUES ('8895', '23', 'Бакли', 'Buckley', 'IL', '60918', '40.6034', '-88.0200');
INSERT INTO `net_city` VALUES ('8897', '23', 'Сан Сити', 'Sun City', 'CA', '92585', '33.7415', '-117.1889');
INSERT INTO `net_city` VALUES ('8898', '23', 'Флинтстон', 'Flintstone', 'MD', '21530', '39.6768', '-78.5339');
INSERT INTO `net_city` VALUES ('8901', '23', 'Ред Хук', 'Red Hook', 'NY', '12571', '42.0080', '-73.8175');
INSERT INTO `net_city` VALUES ('8912', '23', 'Уэнхем', 'Wenham', 'MA', '01984', '42.6007', '-70.8719');
INSERT INTO `net_city` VALUES ('8913', '23', 'Мерреллс Инлет', 'Murrells Inlet', 'SC', '29576', '33.5603', '-79.0441');
INSERT INTO `net_city` VALUES ('8916', '23', 'Корнинг', 'Corning', 'NY', '14830', '42.0843', '-77.0278');
INSERT INTO `net_city` VALUES ('8918', '23', 'Ремсен', 'Remsen', 'NY', '13438', '43.3453', '-75.1285');
INSERT INTO `net_city` VALUES ('8919', '23', 'Мерна', 'Merna', 'NE', '68856', '41.4892', '-99.8569');
INSERT INTO `net_city` VALUES ('8923', '23', 'Янгсвилл', 'Youngsville', 'NC', '27596', '35.9948', '-78.4405');
INSERT INTO `net_city` VALUES ('8925', '23', 'Линден', 'Linden', 'VA', '22642', '38.9188', '-78.0399');
INSERT INTO `net_city` VALUES ('8927', '23', 'Лурей', 'Luray', 'VA', '22835', '38.6590', '-78.4515');
INSERT INTO `net_city` VALUES ('8928', '23', 'Данкансвилл', 'Duncansville', 'PA', '16635', '40.4171', '-78.4899');
INSERT INTO `net_city` VALUES ('8931', '23', 'Чатем', 'Chatham', 'VA', '24531', '36.8385', '-79.4334');
INSERT INTO `net_city` VALUES ('8932', '23', 'Шелби Гэп', 'Shelby Gap', 'KY', '41563', '37.2358', '-82.5351');
INSERT INTO `net_city` VALUES ('8933', '23', 'Остинтаун', 'Austintown', 'OH', '44446', '41.1851', '-80.7422');
INSERT INTO `net_city` VALUES ('8939', '23', 'Ганнибал', 'Hannibal', 'OH', '43931', '39.6673', '-80.8720');
INSERT INTO `net_city` VALUES ('8944', '23', 'Темпл Хилс', 'Temple Hills', 'MD', '20748', '38.8179', '-76.9425');
INSERT INTO `net_city` VALUES ('8948', '23', 'Сидар Хилл', 'Cedar Hill', 'TX', '75104', '32.5901', '-96.9676');
INSERT INTO `net_city` VALUES ('8951', '23', 'Форк', 'Fork', 'MD', '21051', '39.4710', '-76.4483');
INSERT INTO `net_city` VALUES ('8960', '23', 'Джонсонвилл', 'Johnsonville', 'SC', '29555', '33.8566', '-79.4610');
INSERT INTO `net_city` VALUES ('8964', '23', 'Оберн', 'Auburn', 'IN', '46706', '41.3346', '-85.0217');
INSERT INTO `net_city` VALUES ('8966', '23', 'Салфер Спрингс', 'Sulphur Springs', 'TX', '75482', '33.1482', '-95.5996');
INSERT INTO `net_city` VALUES ('8967', '23', 'Сойер', 'Sawyer', 'MI', '49125', '41.8926', '-86.5723');
INSERT INTO `net_city` VALUES ('8969', '23', 'Уолкертон', 'Walkerton', 'IN', '46574', '41.4835', '-86.4852');
INSERT INTO `net_city` VALUES ('8975', '23', 'Делано', 'Delano', 'MN', '55328', '45.0367', '-93.8166');
INSERT INTO `net_city` VALUES ('8978', '23', 'Кун-Рапидс', 'Coon Rapids', 'MN', '55316', '45.1803', '-93.4017');
INSERT INTO `net_city` VALUES ('8980', '23', 'Бемиджи', 'Bemidji', 'MN', '56601', '47.5036', '-94.6850');
INSERT INTO `net_city` VALUES ('8981', '23', 'Каррингтон', 'Carrington', 'ND', '58421', '47.4358', '-99.0534');
INSERT INTO `net_city` VALUES ('8982', '23', 'Уэст Фарго', 'West Fargo', 'ND', '58078', '46.8914', '-96.9294');
INSERT INTO `net_city` VALUES ('8984', '23', 'Хилл Сити', 'Hill City', 'MN', '55748', '46.9494', '-93.5774');
INSERT INTO `net_city` VALUES ('8985', '23', 'Морган', 'Morgan', 'MN', '56266', '44.4164', '-94.9117');
INSERT INTO `net_city` VALUES ('8991', '23', 'Уотерфорд', 'Waterford', 'CT', '06385', '41.3595', '-72.1602');
INSERT INTO `net_city` VALUES ('8992', '23', 'Плантсвилл', 'Plantsville', 'CT', '06479', '41.5766', '-72.9007');
INSERT INTO `net_city` VALUES ('8995', '23', 'Паола', 'Paola', 'KS', '66071', '38.5708', '-94.8803');
INSERT INTO `net_city` VALUES ('8996', '23', 'Бейтс Сити', 'Bates City', 'MO', '64011', '38.9568', '-94.0673');
INSERT INTO `net_city` VALUES ('8999', '23', 'Окли', 'Oakley', 'KS', '67748', '39.0465', '-100.8512');
INSERT INTO `net_city` VALUES ('9002', '23', 'Холтон', 'Holton', 'KS', '66436', '39.4745', '-95.6955');
INSERT INTO `net_city` VALUES ('9004', '23', 'Снохомиш', 'Snohomish', 'WA', '98290', '47.9402', '-122.0062');
INSERT INTO `net_city` VALUES ('9005', '23', 'Каупевилл', 'Coupeville', 'WA', '98239', '48.1855', '-122.6680');
INSERT INTO `net_city` VALUES ('9016', '27', 'Тоа Альта', 'Toa Alta', '00', '00953', '18.3610', '-66.2534');
INSERT INTO `net_city` VALUES ('9019', '27', 'Нагуабо', 'Naguabo', '00', '00718', '18.2353', '-65.7445');
INSERT INTO `net_city` VALUES ('9024', '27', 'Понсе', 'Ponce', '00', '00716', '17.9799', '-66.6481');
INSERT INTO `net_city` VALUES ('9028', '23', 'Техачапи', 'Tehachapi', 'CA', '93561', '35.1293', '-118.5110');
INSERT INTO `net_city` VALUES ('9036', '23', 'Пуэбло', 'Pueblo', 'CO', '81004', '38.0934', '-104.6652');
INSERT INTO `net_city` VALUES ('9041', '23', 'Ки-Уэст', 'Key West', 'FL', '33040', '24.5857', '-81.6810');
INSERT INTO `net_city` VALUES ('9048', '23', 'Арройо Гранде', 'Arroyo Grande', 'CA', '93420', '35.1665', '-120.4376');
INSERT INTO `net_city` VALUES ('9053', '23', 'Пакоима', 'Pacoima', 'CA', '91331', '34.2572', '-118.4195');
INSERT INTO `net_city` VALUES ('9054', '23', 'Кокоа', 'Cocoa', 'FL', '32926', '28.3904', '-80.8233');
INSERT INTO `net_city` VALUES ('9058', '23', 'Палм Кост', 'Palm Coast', 'FL', '32137', '29.5706', '-81.2175');
INSERT INTO `net_city` VALUES ('9061', '23', 'Таунсенд', 'Townsend', 'GA', '31331', '31.5112', '-81.4529');
INSERT INTO `net_city` VALUES ('9063', '23', 'Нью Хармони', 'New Harmony', 'UT', '84757', '37.3863', '-113.3245');
INSERT INTO `net_city` VALUES ('9066', '23', 'Чаллис', 'Challis', 'ID', '83226', '44.6520', '-114.1543');
INSERT INTO `net_city` VALUES ('9067', '23', 'Мак-Дермитт', 'Mc Dermitt', 'NV', '89421', '41.9908', '-117.7128');
INSERT INTO `net_city` VALUES ('9069', '23', 'Хамер', 'Hamer', 'ID', '83425', '43.9855', '-112.1811');
INSERT INTO `net_city` VALUES ('9070', '23', 'Охай', 'Ojai', 'CA', '93023', '34.5152', '-119.2896');
INSERT INTO `net_city` VALUES ('9075', '23', 'Паркер', 'Parker', 'CO', '80138', '39.5076', '-104.6773');
INSERT INTO `net_city` VALUES ('9081', '23', 'Кингман', 'Kingman', 'AZ', '86401', '35.2481', '-113.7640');
INSERT INTO `net_city` VALUES ('9087', '23', 'Свифтуотер', 'Swiftwater', 'PA', '18370', '41.0895', '-75.3346');
INSERT INTO `net_city` VALUES ('9088', '23', 'Питтстон', 'Pittston', 'PA', '18643', '41.3656', '-75.8396');
INSERT INTO `net_city` VALUES ('9089', '23', 'Лихайтон', 'Lehighton', 'PA', '18235', '40.7999', '-75.7339');
INSERT INTO `net_city` VALUES ('9090', '23', 'Лейквилл', 'Lakeville', 'PA', '18438', '41.4215', '-75.2557');
INSERT INTO `net_city` VALUES ('9093', '23', 'Хонсдейл', 'Honesdale', 'PA', '18431', '41.6294', '-75.2424');
INSERT INTO `net_city` VALUES ('9101', '23', 'Паулинг', 'Pawling', 'NY', '12564', '41.5810', '-73.5910');
INSERT INTO `net_city` VALUES ('9103', '23', 'Согертис', 'Saugerties', 'NY', '12477', '42.0978', '-73.9967');
INSERT INTO `net_city` VALUES ('9104', '23', 'Айлендия', 'Islandia', 'NY', '11749', '40.8064', '-73.1738');
INSERT INTO `net_city` VALUES ('9108', '23', 'Пелхэм', 'Pelham', 'NY', '10803', '40.9050', '-73.8057');
INSERT INTO `net_city` VALUES ('9111', '23', 'Олмито', 'Olmito', 'TX', '78575', '26.0263', '-97.5403');
INSERT INTO `net_city` VALUES ('9121', '23', 'Монторсвилл', 'Montoursville', 'PA', '17754', '41.2875', '-76.8801');
INSERT INTO `net_city` VALUES ('9122', '23', 'Шрив', 'Shreve', 'OH', '44676', '40.6804', '-82.0295');
INSERT INTO `net_city` VALUES ('9123', '23', 'Ньютон Фоллс', 'Newton Falls', 'OH', '44444', '41.1764', '-80.9685');
INSERT INTO `net_city` VALUES ('9124', '23', 'Ритман', 'Rittman', 'OH', '44270', '40.9595', '-81.7726');
INSERT INTO `net_city` VALUES ('9125', '23', 'Хонакер', 'Honaker', 'VA', '24260', '37.0367', '-81.9947');
INSERT INTO `net_city` VALUES ('9126', '23', 'Мебан', 'Mebane', 'NC', '27302', '36.1399', '-79.2665');
INSERT INTO `net_city` VALUES ('9129', '23', 'Томпсонвилл', 'Thompsonville', 'MI', '49683', '44.5232', '-85.9409');
INSERT INTO `net_city` VALUES ('9132', '23', 'Флоресвилл', 'Floresville', 'TX', '78114', '29.1191', '-98.1733');
INSERT INTO `net_city` VALUES ('9133', '23', 'Форт Давис', 'Fort Davis', 'TX', '79734', '30.7587', '-103.9249');
INSERT INTO `net_city` VALUES ('9138', '23', 'Мерс', 'Mears', 'MI', '49436', '43.6901', '-86.4692');
INSERT INTO `net_city` VALUES ('9140', '23', 'Уиллитс', 'Willits', 'CA', '95490', '39.4971', '-123.3660');
INSERT INTO `net_city` VALUES ('9141', '23', 'Бодега', 'Bodega Bay', 'CA', '94923', '38.3558', '-123.0629');
INSERT INTO `net_city` VALUES ('9143', '23', 'Кловердейл', 'Cloverdale', 'CA', '95425', '38.7827', '-122.9232');
INSERT INTO `net_city` VALUES ('9146', '23', 'Арапахо', 'Arapahoe', 'NE', '68922', '40.3744', '-99.8812');
INSERT INTO `net_city` VALUES ('9147', '23', 'Уэнтзвилл', 'Wentzville', 'MO', '63385', '38.7900', '-90.8549');
INSERT INTO `net_city` VALUES ('9149', '23', 'Сейнт Роберт', 'Saint Robert', 'MO', '65584', '37.8334', '-92.1249');
INSERT INTO `net_city` VALUES ('9150', '23', 'Бейлис', 'Baylis', 'IL', '62314', '39.7802', '-90.8689');
INSERT INTO `net_city` VALUES ('9152', '23', 'Ролла', 'Rolla', 'MO', '65401', '37.9265', '-91.7791');
INSERT INTO `net_city` VALUES ('9154', '23', 'Колвилл', 'Colville', 'WA', '99114', '48.6791', '-117.7527');
INSERT INTO `net_city` VALUES ('9158', '23', 'Хилсборо', 'Hillsboro', 'TX', '76645', '31.9969', '-97.1374');
INSERT INTO `net_city` VALUES ('9162', '23', 'Синтиана', 'Cynthiana', 'KY', '41031', '38.4302', '-84.2904');
INSERT INTO `net_city` VALUES ('9170', '23', 'Гров Сити', 'Grove City', 'PA', '16127', '41.1660', '-80.0615');
INSERT INTO `net_city` VALUES ('9171', '23', 'Льюиспорт', 'Lewisport', 'KY', '42351', '37.8951', '-86.8840');
INSERT INTO `net_city` VALUES ('9173', '23', 'Окленд Сити', 'Oakland City', 'IN', '47660', '38.2967', '-87.3213');
INSERT INTO `net_city` VALUES ('9174', '23', 'Уитли Сити', 'Whitley City', 'KY', '42653', '36.7864', '-84.4720');
INSERT INTO `net_city` VALUES ('9176', '23', 'Адел', 'Adel', 'IA', '50003', '41.6259', '-94.0427');
INSERT INTO `net_city` VALUES ('9178', '23', 'Станфорд', 'Stanford', 'KY', '40484', '37.5159', '-84.6816');
INSERT INTO `net_city` VALUES ('9179', '23', 'Селлерсберг', 'Sellersburg', 'IN', '47172', '38.4004', '-85.7725');
INSERT INTO `net_city` VALUES ('9186', '23', 'Монтвилл', 'Montville', 'NJ', '07045', '40.9117', '-74.3631');
INSERT INTO `net_city` VALUES ('9188', '23', 'Фернли', 'Fernley', 'NV', '89408', '39.6688', '-119.0687');
INSERT INTO `net_city` VALUES ('9189', '23', 'Халтом Сити', 'Haltom City', 'TX', '76117', '32.8034', '-97.2665');
INSERT INTO `net_city` VALUES ('9190', '23', 'Тасли', 'Tasley', 'VA', '23441', '37.7104', '-75.7005');
INSERT INTO `net_city` VALUES ('9194', '23', 'Кинсейл', 'Kinsale', 'VA', '22488', '38.0416', '-76.5852');
INSERT INTO `net_city` VALUES ('9195', '23', 'Калабасас', 'Calabasas', 'CA', '91302', '34.1182', '-118.6739');
INSERT INTO `net_city` VALUES ('9196', '23', 'Кондон', 'Condon', 'OR', '97823', '45.2855', '-120.1577');
INSERT INTO `net_city` VALUES ('9198', '23', 'Линкольн Парк', 'Lincoln Park', 'NJ', '07035', '40.9272', '-74.3039');
INSERT INTO `net_city` VALUES ('9201', '23', 'Парк Ридж', 'Park Ridge', 'NJ', '07656', '41.0348', '-74.0439');
INSERT INTO `net_city` VALUES ('9204', '23', 'Мансфилд', 'Mansfield', 'TX', '76063', '32.5702', '-97.1313');
INSERT INTO `net_city` VALUES ('9206', '23', 'Рок Рапидс', 'Rock Rapids', 'IA', '51246', '43.4080', '-96.1493');
INSERT INTO `net_city` VALUES ('9207', '23', 'Кеота', 'Keota', 'IA', '52248', '41.3567', '-91.9181');
INSERT INTO `net_city` VALUES ('9209', '23', 'Уоткинс', 'Watkins', 'CO', '80137', '39.7250', '-104.5859');
INSERT INTO `net_city` VALUES ('9210', '23', 'Гленвуд Спрингс', 'Glenwood Springs', 'CO', '81601', '39.5846', '-107.3016');
INSERT INTO `net_city` VALUES ('9215', '23', 'Форт Морган', 'Fort Morgan', 'CO', '80701', '40.0598', '-103.8584');
INSERT INTO `net_city` VALUES ('9216', '23', 'Анза', 'Anza', 'CA', '92539', '33.5325', '-116.6815');
INSERT INTO `net_city` VALUES ('9217', '23', 'Хокинс', 'Hawkins', 'TX', '75765', '32.6289', '-95.2482');
INSERT INTO `net_city` VALUES ('9222', '23', 'Уинтерсет', 'Winterset', 'IA', '50273', '41.3516', '-94.0514');
INSERT INTO `net_city` VALUES ('9230', '23', 'Маунт Поконо', 'Mount Pocono', 'PA', '18344', '41.1189', '-75.3389');
INSERT INTO `net_city` VALUES ('9231', '23', 'Уэстлейк', 'Westlake', 'LA', '70669', '30.2413', '-93.2690');
INSERT INTO `net_city` VALUES ('9235', '23', 'Анкени', 'Ankeny', 'IA', '50021', '41.7248', '-93.6017');
INSERT INTO `net_city` VALUES ('9238', '23', 'Лакин', 'Lufkin', 'TX', '75901', '31.2671', '-94.6467');
INSERT INTO `net_city` VALUES ('9239', '23', 'Вудвилл', 'Woodville', 'TX', '75979', '30.7848', '-94.3723');
INSERT INTO `net_city` VALUES ('9240', '23', 'Силсби', 'Silsbee', 'TX', '77656', '30.4611', '-94.1611');
INSERT INTO `net_city` VALUES ('9243', '23', 'Преск Айл', 'Presque Isle', 'ME', '04769', '46.6885', '-67.9911');
INSERT INTO `net_city` VALUES ('9245', '23', 'Парсонсфилд', 'Parsonsfield', 'ME', '04047', '43.7421', '-70.9141');
INSERT INTO `net_city` VALUES ('9246', '23', 'Бриджтон', 'Bridgton', 'ME', '04009', '44.0336', '-70.7570');
INSERT INTO `net_city` VALUES ('9248', '23', 'Биддефорд', 'Biddeford', 'ME', '04005', '43.4961', '-70.4886');
INSERT INTO `net_city` VALUES ('9249', '23', 'Декстер', 'Dexter', 'ME', '04930', '45.0292', '-69.3164');
INSERT INTO `net_city` VALUES ('9250', '23', 'Магнолия', 'Magnolia', 'TX', '77354', '30.2035', '-95.6633');
INSERT INTO `net_city` VALUES ('9251', '23', 'Ок Харбор', 'Oak Harbor', 'WA', '98277', '48.3218', '-122.6305');
INSERT INTO `net_city` VALUES ('9253', '23', 'Мэрисвилл', 'Marysville', 'WA', '98270', '48.0585', '-122.1482');
INSERT INTO `net_city` VALUES ('9256', '23', 'Филоматкс', 'Philomath', 'OR', '97370', '44.5911', '-123.4641');
INSERT INTO `net_city` VALUES ('9261', '23', 'Маунт Плезант', 'Mount Pleasant', 'TX', '75455', '33.2176', '-94.9673');
INSERT INTO `net_city` VALUES ('9263', '23', 'Сеффнер', 'Seffner', 'FL', '33584', '28.0042', '-82.2936');
INSERT INTO `net_city` VALUES ('9268', '23', 'Венис', 'Venice', 'FL', '34292', '27.1019', '-82.3826');
INSERT INTO `net_city` VALUES ('9270', '23', 'Лейнсборо   ', 'Lanesboro', 'MA', '01237', '42.5584', '-73.2197');
INSERT INTO `net_city` VALUES ('9273', '23', 'Ярмут Порт', 'Yarmouth Port', 'MA', '02675', '41.7072', '-70.2299');
INSERT INTO `net_city` VALUES ('9274', '23', 'Сатерлин', 'Sutherlin', 'OR', '97479', '43.4159', '-123.1134');
INSERT INTO `net_city` VALUES ('9279', '23', 'Уэст Гринвич', 'West Greenwich', 'RI', '02817', '41.6298', '-71.6677');
INSERT INTO `net_city` VALUES ('9284', '23', 'Сан Пабло', 'San Pablo', 'CA', '94806', '37.9809', '-122.3332');
INSERT INTO `net_city` VALUES ('9285', '23', 'Эстес Парк', 'Estes Park', 'CO', '80517', '40.3974', '-105.6234');
INSERT INTO `net_city` VALUES ('9290', '23', 'Пайн Гров', 'Pine Grove', 'LA', '70453', '30.6826', '-90.7636');
INSERT INTO `net_city` VALUES ('9292', '23', 'Чесапик Сити', 'Chesapeake City', 'MD', '21915', '39.4979', '-75.8504');
INSERT INTO `net_city` VALUES ('9293', '23', 'Садлерсвилл', 'Sudlersville', 'MD', '21668', '39.1949', '-75.8643');
INSERT INTO `net_city` VALUES ('9296', '23', 'Монро', 'Monroe', 'WA', '98272', '47.8703', '-121.8810');
INSERT INTO `net_city` VALUES ('9298', '23', 'Крейгмонт', 'Craigmont', 'ID', '83523', '46.2306', '-116.4891');
INSERT INTO `net_city` VALUES ('9300', '23', 'Рицвилл', 'Ritzville', 'WA', '99169', '47.0796', '-118.4705');
INSERT INTO `net_city` VALUES ('9304', '23', 'Мойи Спрингс', 'Moyie Springs', 'ID', '83845', '48.7078', '-116.1263');
INSERT INTO `net_city` VALUES ('9305', '23', 'Кетчум', 'Ketchum', 'ID', '83340', '43.7770', '-114.6251');
INSERT INTO `net_city` VALUES ('9306', '23', 'Кендрик', 'Kendrick', 'ID', '83537', '46.6411', '-116.5423');
INSERT INTO `net_city` VALUES ('9308', '23', 'Алгонкин', 'Algonquin', 'IL', '60102', '42.1617', '-88.3285');
INSERT INTO `net_city` VALUES ('9309', '23', 'Буштон', 'Bushton', 'KS', '67427', '38.5072', '-98.3965');
INSERT INTO `net_city` VALUES ('9310', '23', 'Престонсберг', 'Prestonsburg', 'KY', '41653', '37.6576', '-82.7548');
INSERT INTO `net_city` VALUES ('9312', '23', 'Дженкинс', 'Jenkins', 'KY', '41537', '37.2297', '-82.6164');
INSERT INTO `net_city` VALUES ('9313', '23', 'Айвел', 'Ivel', 'KY', '41642', '37.5942', '-82.6521');
INSERT INTO `net_city` VALUES ('9314', '23', 'Локуст Дейл', 'Locust Dale', 'VA', '22948', '38.3797', '-78.1231');
INSERT INTO `net_city` VALUES ('9317', '23', 'Лисси', 'Lissie', 'TX', '77454', '29.5353', '-96.2304');
INSERT INTO `net_city` VALUES ('9321', '23', 'Хопдейл', 'Hopedale', 'OH', '43976', '40.3655', '-80.9116');
INSERT INTO `net_city` VALUES ('9323', '23', 'Доджевилл', 'Dodgeville', 'WI', '53533', '42.9976', '-90.1331');
INSERT INTO `net_city` VALUES ('9326', '23', 'Сауарита', 'Sahuarita', 'AZ', '85629', '31.9102', '-110.8996');
INSERT INTO `net_city` VALUES ('9327', '23', 'Кларкдейл', 'Clarkdale', 'AZ', '86324', '34.7917', '-112.1064');
INSERT INTO `net_city` VALUES ('9328', '23', 'Пайнтоп', 'Pinetop', 'AZ', '85935', '34.0848', '-109.9087');
INSERT INTO `net_city` VALUES ('9329', '23', 'Флагстафф', 'Flagstaff', 'AZ', '86003', '35.1981', '-111.6513');
INSERT INTO `net_city` VALUES ('9333', '23', 'Брод Брук', 'Broad Brook', 'CT', '06016', '41.9068', '-72.5516');
INSERT INTO `net_city` VALUES ('9338', '23', 'Фармвилл', 'Farmville', 'VA', '23901', '37.2981', '-78.4044');
INSERT INTO `net_city` VALUES ('9339', '23', 'Рингголд', 'Ringgold', 'GA', '30736', '34.8914', '-85.1207');
INSERT INTO `net_city` VALUES ('9343', '23', 'Вабаш', 'Wabash', 'IN', '46992', '40.7414', '-85.7936');
INSERT INTO `net_city` VALUES ('9344', '23', 'Наппани', 'Nappanee', 'IN', '46550', '41.4419', '-85.9923');
INSERT INTO `net_city` VALUES ('9352', '23', 'Банкер Хилл', 'Bunker Hill', 'IN', '46914', '40.6360', '-86.0900');
INSERT INTO `net_city` VALUES ('9353', '23', 'Каннон-Фолс', 'Cannon Falls', 'MN', '55009', '44.4795', '-92.8727');
INSERT INTO `net_city` VALUES ('9354', '23', 'Меномони', 'Menomonie', 'WI', '54751', '44.8471', '-92.0009');
INSERT INTO `net_city` VALUES ('9355', '23', 'Лейквилл', 'Lakeville', 'IN', '46536', '41.5126', '-86.2848');
INSERT INTO `net_city` VALUES ('9362', '23', 'Фолс Сити', 'Falls City', 'NE', '68355', '40.1310', '-95.5723');
INSERT INTO `net_city` VALUES ('9365', '23', 'Уэйкаруса', 'Wakarusa', 'KS', '66546', '38.8916', '-95.7419');
INSERT INTO `net_city` VALUES ('9367', '23', 'Тиф-Ривер-Фолс', 'Thief River Falls', 'MN', '56701', '48.1464', '-96.1765');
INSERT INTO `net_city` VALUES ('9370', '23', 'Таунвилл', 'Townville', 'PA', '16360', '41.6765', '-79.8963');
INSERT INTO `net_city` VALUES ('9373', '23', 'Белвью', 'Belvue', 'KS', '66407', '39.2692', '-96.1710');
INSERT INTO `net_city` VALUES ('9375', '23', 'Эббивилл', 'Abbeville', 'AL', '36310', '31.5951', '-85.2108');
INSERT INTO `net_city` VALUES ('9376', '23', 'Муди', 'Moody', 'AL', '35004', '33.6063', '-86.4916');
INSERT INTO `net_city` VALUES ('9377', '23', 'Перкинс', 'Perkins', 'OK', '74059', '35.9145', '-97.0521');
INSERT INTO `net_city` VALUES ('9382', '23', 'Веймар', 'Weimar', 'TX', '78962', '29.6371', '-96.7253');
INSERT INTO `net_city` VALUES ('9385', '23', 'Динвилл', 'Deanville', 'TX', '77852', '30.4322', '-96.7561');
INSERT INTO `net_city` VALUES ('9389', '23', 'Шуленберг', 'Schulenburg', 'TX', '78956', '29.6791', '-96.9357');
INSERT INTO `net_city` VALUES ('9392', '23', 'Сабета', 'Sabetha', 'KS', '66534', '39.8669', '-95.8359');
INSERT INTO `net_city` VALUES ('9393', '23', 'Хэйс', 'Hays', 'KS', '67601', '38.9001', '-99.3470');
INSERT INTO `net_city` VALUES ('9395', '23', 'Клермор', 'Claremore', 'OK', '74017', '36.3555', '-95.6029');
INSERT INTO `net_city` VALUES ('9400', '23', 'Алтус', 'Altus', 'OK', '73521', '34.6182', '-99.2732');
INSERT INTO `net_city` VALUES ('9408', '24', 'Виктория ', 'Victoria (British Columbia)', 'BC', 'v8x3b6', '48.4333', '-123.3500');
INSERT INTO `net_city` VALUES ('9410', '23', 'Бетел Парк', 'Bethel Park', 'PA', '15102', '40.3224', '-80.0355');
INSERT INTO `net_city` VALUES ('9418', '23', 'Сандерсвилл', 'Sandersville', 'GA', '31082', '32.9752', '-82.8575');
INSERT INTO `net_city` VALUES ('9421', '23', 'Калверт', 'Calvert', 'TX', '77837', '31.0014', '-96.6719');
INSERT INTO `net_city` VALUES ('9424', '23', 'Пайнвилл', 'Pineville', 'LA', '71360', '31.2884', '-92.3880');
INSERT INTO `net_city` VALUES ('9435', '23', 'Дублин', 'Dublin', 'GA', '31021', '32.4643', '-82.9495');
INSERT INTO `net_city` VALUES ('9438', '23', 'Фэрберн', 'Fairburn', 'GA', '30213', '33.5879', '-84.6467');
INSERT INTO `net_city` VALUES ('9440', '23', 'Гриффин', 'Griffin', 'GA', '30224', '33.2023', '-84.2306');
INSERT INTO `net_city` VALUES ('9441', '23', 'Мюррей', 'Murray', 'KY', '42071', '36.6355', '-88.2830');
INSERT INTO `net_city` VALUES ('9445', '23', 'Маренго', 'Marengo', 'IN', '47140', '38.3718', '-86.3677');
INSERT INTO `net_city` VALUES ('9449', '23', 'Чандлер', 'Chandler', 'IN', '47610', '38.0447', '-87.4121');
INSERT INTO `net_city` VALUES ('9451', '23', 'Форт-Уолтон-Бич', 'Fort Walton Beach', 'FL', '32548', '30.4218', '-86.6298');
INSERT INTO `net_city` VALUES ('9453', '23', 'Галф Бриз', 'Gulf Breeze', 'FL', '32563', '30.4074', '-86.9785');
INSERT INTO `net_city` VALUES ('9454', '23', 'Язу Сити', 'Yazoo City', 'MS', '39194', '32.8342', '-90.5553');
INSERT INTO `net_city` VALUES ('9460', '23', 'Кейд', 'Cade', 'LA', '70519', '30.0874', '-91.9054');
INSERT INTO `net_city` VALUES ('9462', '23', 'Девилл', 'Deville', 'LA', '71328', '31.3502', '-92.1942');
INSERT INTO `net_city` VALUES ('9466', '23', 'Дженнер', 'Jenner', 'CA', '95450', '38.5172', '-123.2122');
INSERT INTO `net_city` VALUES ('9467', '23', 'Амелия', 'Amelia', 'OH', '45102', '39.0131', '-84.2049');
INSERT INTO `net_city` VALUES ('9470', '23', 'Диболл', 'Diboll', 'TX', '75941', '31.1961', '-94.7447');
INSERT INTO `net_city` VALUES ('9479', '23', 'Паскагула', 'Pascagoula', 'MS', '39581', '30.3561', '-88.4924');
INSERT INTO `net_city` VALUES ('9485', '23', 'Кливс', 'Cleves', 'OH', '45002', '39.2039', '-84.7225');
INSERT INTO `net_city` VALUES ('9491', '23', 'Херлок', 'Hurlock', 'MD', '21643', '38.6402', '-75.8672');
INSERT INTO `net_city` VALUES ('9492', '23', 'Проспект Хайтс', 'Prospect Heights', 'IL', '60070', '42.1058', '-87.8771');
INSERT INTO `net_city` VALUES ('9499', '23', 'Бостон', 'Boston', 'VA', '22713', '38.5443', '-78.1301');
INSERT INTO `net_city` VALUES ('9500', '23', 'Нора', 'Nora', 'VA', '24272', '37.0137', '-82.3405');
INSERT INTO `net_city` VALUES ('9504', '23', 'Селинсгров', 'Selinsgrove', 'PA', '17870', '40.8165', '-76.8812');
INSERT INTO `net_city` VALUES ('9506', '23', 'Клинчко', 'Clinchco', 'VA', '24226', '37.1289', '-82.3281');
INSERT INTO `net_city` VALUES ('9509', '23', 'Кэпей', 'Capay', 'CA', '95607', '38.6904', '-122.1283');
INSERT INTO `net_city` VALUES ('9511', '23', 'Александер Сити', 'Alexander City', 'AL', '35010', '32.9061', '-85.9370');
INSERT INTO `net_city` VALUES ('9513', '23', 'Кенмор', 'Kenmore', 'WA', '98028', '47.7542', '-122.2444');
INSERT INTO `net_city` VALUES ('9514', '23', 'Ист Лайм', 'East Lyme', 'CT', '06333', '41.3829', '-72.2368');
INSERT INTO `net_city` VALUES ('9517', '23', 'Фиш Кэмп', 'Fish Camp', 'CA', '93623', '37.4763', '-119.6616');
INSERT INTO `net_city` VALUES ('9519', '23', 'Лихай Эйкерс', 'Lehigh Acres', 'FL', '33936', '26.6025', '-81.6233');
INSERT INTO `net_city` VALUES ('9520', '23', 'Пинелас Парк', 'Pinellas Park', 'FL', '33781', '27.8386', '-82.7166');
INSERT INTO `net_city` VALUES ('9522', '23', 'Аранзас Пасс', 'Aransas Pass', 'TX', '78336', '27.9709', '-97.1550');
INSERT INTO `net_city` VALUES ('9524', '23', 'Джанкшен Сити', 'Junction City', 'KS', '66441', '38.9661', '-96.7651');
INSERT INTO `net_city` VALUES ('9527', '23', 'Баннелл', 'Bunnell', 'FL', '32110', '29.4254', '-81.3384');
INSERT INTO `net_city` VALUES ('9530', '23', 'Клинтвуд', 'Clintwood', 'VA', '24228', '37.1635', '-82.4397');
INSERT INTO `net_city` VALUES ('9531', '23', 'Морганфилд', 'Morganfield', 'KY', '42437', '37.6623', '-87.9317');
INSERT INTO `net_city` VALUES ('9532', '23', 'Олдсмар', 'Oldsmar', 'FL', '34677', '28.0444', '-82.6795');
INSERT INTO `net_city` VALUES ('9534', '23', 'Нокомис', 'Nokomis', 'FL', '34275', '27.1799', '-82.3894');
INSERT INTO `net_city` VALUES ('9540', '23', 'Лейк Пласид', 'Lake Placid', 'FL', '33852', '27.2419', '-81.3564');
INSERT INTO `net_city` VALUES ('9542', '23', 'Мерритт Айленд', 'Merritt Island', 'FL', '32952', '28.2519', '-80.6607');
INSERT INTO `net_city` VALUES ('9544', '23', 'Харди', 'Hardy', 'VA', '24101', '37.1759', '-79.8013');
INSERT INTO `net_city` VALUES ('9547', '23', 'Обри', 'Aubrey', 'TX', '76227', '33.2637', '-96.9528');
INSERT INTO `net_city` VALUES ('9549', '23', 'Порт Аллен', 'Port Allen', 'LA', '70767', '30.4595', '-91.3428');
INSERT INTO `net_city` VALUES ('9551', '23', 'Мерриета', 'Murrieta', 'CA', '92563', '33.5789', '-117.1412');
INSERT INTO `net_city` VALUES ('9562', '23', 'Хатто', 'Hutto', 'TX', '78634', '30.5543', '-97.5520');
INSERT INTO `net_city` VALUES ('9566', '23', 'Уиндбер', 'Windber', 'PA', '15963', '40.2267', '-78.7794');
INSERT INTO `net_city` VALUES ('9569', '23', 'Сейнт Роуз', 'Saint Rose', 'LA', '70087', '29.9767', '-90.3121');
INSERT INTO `net_city` VALUES ('9570', '23', 'Фоли', 'Foley', 'AL', '36535', '30.3880', '-87.7199');
INSERT INTO `net_city` VALUES ('9571', '23', 'Брассард', 'Broussard', 'LA', '70518', '30.1203', '-91.9279');
INSERT INTO `net_city` VALUES ('9572', '23', 'Эль Кампо', 'El Campo', 'TX', '77437', '29.1886', '-96.2973');
INSERT INTO `net_city` VALUES ('9573', '23', 'Хэмпшир', 'Hampshire', 'IL', '60140', '42.0681', '-88.5095');
INSERT INTO `net_city` VALUES ('9577', '23', 'Мартвилл', 'Martville', 'NY', '13111', '43.2574', '-76.6207');
INSERT INTO `net_city` VALUES ('9578', '23', 'Сейр', 'Sayre', 'PA', '18840', '41.9642', '-76.6160');
INSERT INTO `net_city` VALUES ('9579', '23', 'Лас-Вегас', 'Las Vegas', 'NM', '87701', '35.4988', '-104.9370');
INSERT INTO `net_city` VALUES ('9582', '23', 'Рио-Ранчо', 'Rio Rancho', 'NM', '87124', '35.2467', '-106.7232');
INSERT INTO `net_city` VALUES ('9583', '23', 'Каса Бланка', 'Casa Blanca', 'NM', '87007', '35.0030', '-107.4748');
INSERT INTO `net_city` VALUES ('9584', '23', 'Джемез Пуэбло', 'Jemez Pueblo', 'NM', '87024', '35.6491', '-106.7381');
INSERT INTO `net_city` VALUES ('9585', '23', 'Мескалеро', 'Mescalero', 'NM', '88340', '33.1972', '-105.6777');
INSERT INTO `net_city` VALUES ('9589', '23', 'Уоупака', 'Waupaca', 'WI', '54981', '44.3223', '-89.1207');
INSERT INTO `net_city` VALUES ('9591', '23', 'Кловис', 'Clovis', 'NM', '88101', '34.5028', '-103.2757');
INSERT INTO `net_city` VALUES ('9592', '23', 'Артижа', 'Artesia', 'NM', '88211', '32.8423', '-104.4033');
INSERT INTO `net_city` VALUES ('9593', '23', 'Лос Аламос', 'Los Alamos', 'NM', '87544', '35.8366', '-106.3093');
INSERT INTO `net_city` VALUES ('9594', '23', 'Зуни', 'Zuni', 'NM', '87327', '35.0824', '-108.7577');
INSERT INTO `net_city` VALUES ('9596', '23', 'Кесвик', 'Keswick', 'VA', '22947', '38.0361', '-78.3328');
INSERT INTO `net_city` VALUES ('9597', '23', 'Фишерсвилл', 'Fishersville', 'VA', '22939', '38.1142', '-78.9845');
INSERT INTO `net_city` VALUES ('9600', '23', 'Акстон', 'Axton', 'VA', '24054', '36.6695', '-79.7148');
INSERT INTO `net_city` VALUES ('9602', '23', 'Минерва', 'Minerva', 'OH', '44657', '40.7380', '-81.0970');
INSERT INTO `net_city` VALUES ('9603', '23', 'Томбал', 'Tomball', 'TX', '77375', '30.0872', '-95.5880');
INSERT INTO `net_city` VALUES ('9604', '23', 'Кейп-Мэй Корт Хаус', 'Cape May Court House', 'NJ', '08210', '39.1156', '-74.8180');
INSERT INTO `net_city` VALUES ('9606', '23', 'Буэна', 'Buena', 'NJ', '08310', '39.5228', '-74.8954');
INSERT INTO `net_city` VALUES ('9611', '23', 'Уайт Салфер Спрингс', 'White Sulphur Springs', 'WV', '24986', '37.8748', '-80.1709');
INSERT INTO `net_city` VALUES ('9614', '23', 'Тарпон Спрингс', 'Tarpon Springs', 'FL', '34689', '28.1476', '-82.7641');
INSERT INTO `net_city` VALUES ('9618', '23', 'Лейк-Сити', 'Lake City', 'MN', '55041', '44.4074', '-92.3072');
INSERT INTO `net_city` VALUES ('9626', '23', 'Робертс', 'Roberts', 'IL', '60962', '40.6321', '-88.1782');
INSERT INTO `net_city` VALUES ('9627', '23', 'Содди-Дейзи', 'Soddy-Daisy', 'TN', '37379', '35.3007', '-85.1807');
INSERT INTO `net_city` VALUES ('9642', '23', 'Кирквуд', 'Kirkwood', 'NY', '13795', '42.0613', '-75.7821');
INSERT INTO `net_city` VALUES ('9644', '23', 'Ллано', 'Llano', 'TX', '78643', '30.6386', '-98.6841');
INSERT INTO `net_city` VALUES ('9645', '23', 'Абилин', 'Abilene', 'KS', '67410', '39.0279', '-97.2213');
INSERT INTO `net_city` VALUES ('9646', '23', 'Хортон', 'Horton', 'KS', '66439', '39.6588', '-95.5505');
INSERT INTO `net_city` VALUES ('9649', '23', 'Саутпорт', 'Southport', 'CT', '06890', '41.1435', '-73.2894');
INSERT INTO `net_city` VALUES ('9650', '23', 'Хамден', 'Hamden', 'CT', '06514', '41.3745', '-72.9396');
INSERT INTO `net_city` VALUES ('9651', '23', 'Делмонт', 'Delmont', 'PA', '15626', '40.4139', '-79.5796');
INSERT INTO `net_city` VALUES ('9654', '23', 'Марин Сити', 'Marine City', 'MI', '48039', '42.6914', '-82.5496');
INSERT INTO `net_city` VALUES ('9657', '23', 'Дьюрант', 'Durant', 'IA', '52747', '41.6260', '-90.9177');
INSERT INTO `net_city` VALUES ('9659', '23', 'Хейден', 'Hayden', 'ID', '83835', '47.7887', '-116.7112');
INSERT INTO `net_city` VALUES ('9662', '23', 'Пирстон', 'Pierceton', 'IN', '46562', '41.2184', '-85.7072');
INSERT INTO `net_city` VALUES ('9663', '23', 'Ред Ривер', 'Red River', 'NM', '87558', '36.7081', '-105.4061');
INSERT INTO `net_city` VALUES ('9664', '23', 'Сан Хасинто', 'San Jacinto', 'CA', '92583', '33.7994', '-116.9321');
INSERT INTO `net_city` VALUES ('9665', '23', 'Таскумбия', 'Tuscumbia', 'AL', '35674', '34.6639', '-87.7787');
INSERT INTO `net_city` VALUES ('9670', '23', 'Хомер', 'Homer', 'MI', '49245', '42.1476', '-84.8223');
INSERT INTO `net_city` VALUES ('9672', '23', 'Гленпул', 'Glenpool', 'OK', '74033', '35.9261', '-96.0193');
INSERT INTO `net_city` VALUES ('9674', '23', 'Юли', 'Yulee', 'FL', '32097', '30.6458', '-81.6299');
INSERT INTO `net_city` VALUES ('9675', '23', 'Санкук', 'Suncook', 'NH', '03275', '43.1756', '-71.4104');
INSERT INTO `net_city` VALUES ('9676', '23', 'Макомб', 'Macomb', 'IL', '61455', '40.4120', '-90.6238');
INSERT INTO `net_city` VALUES ('9678', '23', 'Боерн', 'Boerne', 'TX', '78015', '29.7329', '-98.6592');
INSERT INTO `net_city` VALUES ('9679', '23', 'Эмлентон', 'Emlenton', 'PA', '16373', '41.2242', '-79.6352');
INSERT INTO `net_city` VALUES ('9681', '23', 'Уилтон', 'Wilton', 'NH', '03086', '42.8339', '-71.7745');
INSERT INTO `net_city` VALUES ('9684', '23', 'Меса', 'Mesa', 'CO', '81643', '39.1098', '-108.1736');
INSERT INTO `net_city` VALUES ('9685', '23', 'Паония', 'Paonia', 'CO', '81428', '38.9557', '-107.5941');
INSERT INTO `net_city` VALUES ('9687', '23', 'Фэрмонт', 'Fairmont', 'MN', '56031', '43.6365', '-94.4808');
INSERT INTO `net_city` VALUES ('9689', '23', 'Миссури Сити', 'Missouri City', 'TX', '77459', '29.5288', '-95.5252');
INSERT INTO `net_city` VALUES ('9690', '23', 'Кокссеки', 'Coxsackie', 'NY', '12051', '42.3461', '-73.8412');
INSERT INTO `net_city` VALUES ('9692', '23', 'Праттвилл', 'Prattville', 'AL', '36067', '32.5141', '-86.5863');
INSERT INTO `net_city` VALUES ('9694', '23', 'Эдвардс', 'Edwards', 'CA', '93523', '34.9616', '-117.8759');
INSERT INTO `net_city` VALUES ('9699', '23', 'Робстаун', 'Robstown', 'TX', '78380', '27.7604', '-97.7429');
INSERT INTO `net_city` VALUES ('9700', '23', 'Кристиана', 'Christiana', 'TN', '37037', '35.6962', '-86.3599');
INSERT INTO `net_city` VALUES ('9701', '23', 'Бемент', 'Bement', 'IL', '61813', '39.9084', '-88.5656');
INSERT INTO `net_city` VALUES ('9705', '23', 'Марко Айленд', 'Marco Island', 'FL', '34145', '25.9376', '-81.6977');
INSERT INTO `net_city` VALUES ('9708', '23', 'Наварр', 'Navarre', 'FL', '32566', '30.4467', '-86.8750');
INSERT INTO `net_city` VALUES ('9709', '23', 'Сан Хуан Капистрано', 'San Juan Capistrano', 'CA', '92675', '33.5256', '-117.6191');
INSERT INTO `net_city` VALUES ('9722', '23', 'Сент-Джозеф', 'Saint Joseph', 'MN', '56374', '45.6163', '-94.2945');
INSERT INTO `net_city` VALUES ('9723', '23', 'Милбрук', 'Millbrook', 'NY', '12545', '41.7912', '-73.6600');
INSERT INTO `net_city` VALUES ('9725', '23', 'Фриленд', 'Freeland', 'PA', '18224', '41.0219', '-75.8756');
INSERT INTO `net_city` VALUES ('9728', '23', 'Альберта', 'Alberta', 'VA', '23821', '36.8679', '-77.9259');
INSERT INTO `net_city` VALUES ('9730', '23', 'Хикори Флэт', 'Hickory Flat', 'MS', '38633', '34.6410', '-89.1953');
INSERT INTO `net_city` VALUES ('9733', '23', 'Уэст Кокссеки', 'West Coxsackie', 'NY', '12192', '42.3984', '-73.8317');
INSERT INTO `net_city` VALUES ('9736', '23', 'Уиллоу Вуд', 'Willow Wood', 'OH', '45696', '38.5970', '-82.4525');
INSERT INTO `net_city` VALUES ('9737', '23', 'Ридсберг', 'Reedsburg', 'WI', '53959', '43.5309', '-89.9734');
INSERT INTO `net_city` VALUES ('9741', '23', 'Васко', 'Wasco', 'CA', '93280', '35.6454', '-119.4435');
INSERT INTO `net_city` VALUES ('9743', '23', 'Ромео', 'Romeo', 'MI', '48065', '42.8436', '-83.0403');
INSERT INTO `net_city` VALUES ('9745', '23', 'Ламур', 'Lamoure', 'ND', '58458', '46.3601', '-98.2646');
INSERT INTO `net_city` VALUES ('9746', '23', 'Сентревилл', 'Centreville', 'MD', '21617', '39.0543', '-76.0185');
INSERT INTO `net_city` VALUES ('9751', '23', 'Гас Сити', 'Gas City', 'IN', '46933', '40.4894', '-85.5977');
INSERT INTO `net_city` VALUES ('9752', '23', 'Дюпон', 'Dupont', 'IN', '47231', '38.8944', '-85.4977');
INSERT INTO `net_city` VALUES ('9753', '23', 'Брукстон', 'Brookston', 'IN', '47923', '40.6141', '-86.9203');
INSERT INTO `net_city` VALUES ('9755', '23', 'Норт-Миртл-Бич', 'North Myrtle Beach', 'SC', '29582', '33.8322', '-78.6491');
INSERT INTO `net_city` VALUES ('9756', '23', 'Лондейл', 'Lawndale', 'CA', '90260', '33.8872', '-118.3548');
INSERT INTO `net_city` VALUES ('9765', '23', 'Мак-Комб', 'McComb', 'MS', '39648', '31.2032', '-90.3956');
INSERT INTO `net_city` VALUES ('9769', '23', 'Похаска', 'Pawhuska', 'OK', '74056', '36.7643', '-96.3008');
INSERT INTO `net_city` VALUES ('9773', '23', 'Корфу', 'Corfu', 'NY', '14036', '42.9837', '-78.3728');
INSERT INTO `net_city` VALUES ('9774', '23', 'Уэвока', 'Wewoka', 'OK', '74884', '35.2032', '-96.5205');
INSERT INTO `net_city` VALUES ('9778', '23', 'Вест Тисбури', 'West Tisbury', 'MA', '02575', '41.4278', '-70.6346');
INSERT INTO `net_city` VALUES ('9780', '23', 'Лигоньер', 'Ligonier', 'PA', '15658', '40.2482', '-79.1972');
INSERT INTO `net_city` VALUES ('9781', '23', 'Шаста Лейк', 'Shasta Lake', 'CA', '96019', '40.6893', '-122.3768');
INSERT INTO `net_city` VALUES ('9785', '23', 'Аплгейт', 'Applegate', 'CA', '95703', '39.0006', '-120.9970');
INSERT INTO `net_city` VALUES ('9787', '23', 'Галлиполис', 'Gallipolis', 'OH', '45631', '38.8065', '-82.2702');
INSERT INTO `net_city` VALUES ('9788', '23', 'Эйвон', 'Avon', 'IN', '46123', '39.7602', '-86.3942');
INSERT INTO `net_city` VALUES ('9796', '23', 'Ричфилд Спрингс', 'Richfield Springs', 'NY', '13439', '42.8488', '-74.9778');
INSERT INTO `net_city` VALUES ('9803', '23', 'Кобб', 'Cobb', 'CA', '95426', '38.8221', '-122.7231');
INSERT INTO `net_city` VALUES ('9811', '23', 'Акворт', 'Acworth', 'GA', '30101', '34.0264', '-84.6998');
INSERT INTO `net_city` VALUES ('9821', '23', 'Тахо Виста', 'Tahoe Vista', 'CA', '96148', '39.2446', '-120.0517');
INSERT INTO `net_city` VALUES ('9823', '23', 'Бланчард', 'Blanchard', 'OK', '73010', '35.1240', '-97.6707');
INSERT INTO `net_city` VALUES ('9824', '23', 'Блафтон', 'Bluffton', 'OH', '45817', '40.8754', '-83.8809');
INSERT INTO `net_city` VALUES ('9829', '23', 'Хазен', 'Hazen', 'AR', '72064', '34.7940', '-91.5837');
INSERT INTO `net_city` VALUES ('9833', '23', 'Хатчинс', 'Hutchins', 'TX', '75141', '32.6372', '-96.6812');
INSERT INTO `net_city` VALUES ('9835', '23', 'Хопленд', 'Hopland', 'CA', '95449', '38.9384', '-123.1101');
INSERT INTO `net_city` VALUES ('9836', '23', 'Анакортс', 'Anacortes', 'WA', '98221', '48.4648', '-122.6092');
INSERT INTO `net_city` VALUES ('9837', '23', 'Бразил', 'Brazil', 'IN', '47834', '39.5545', '-87.1251');
INSERT INTO `net_city` VALUES ('9842', '23', 'Стивенсвилл', 'Stevensville', 'MI', '49127', '42.0092', '-86.5101');
INSERT INTO `net_city` VALUES ('9846', '23', 'Мэдисонвилл', 'Madisonville', 'TX', '77864', '30.9689', '-95.8912');
INSERT INTO `net_city` VALUES ('9847', '23', 'Тсейл', 'Tsaile', 'AZ', '86556', '36.2740', '-109.2657');
INSERT INTO `net_city` VALUES ('9849', '23', 'Станвуд', 'Stanwood', 'WA', '98292', '48.2124', '-122.2846');
INSERT INTO `net_city` VALUES ('9852', '23', 'Рэдклифф', 'Radcliff', 'KY', '40160', '37.8546', '-85.8961');
INSERT INTO `net_city` VALUES ('9854', '23', 'Фонтейн Хилс', 'Fountain Hills', 'AZ', '85268', '33.6040', '-111.7426');
INSERT INTO `net_city` VALUES ('9860', '23', 'Лакон', 'Lacon', 'IL', '61540', '41.0173', '-89.3619');
INSERT INTO `net_city` VALUES ('9863', '23', 'Сидартаун', 'Cedartown', 'GA', '30125', '34.0147', '-85.2654');
INSERT INTO `net_city` VALUES ('9867', '23', 'Флаглер Бич', 'Flagler Beach', 'FL', '32136', '29.4931', '-81.1350');
INSERT INTO `net_city` VALUES ('9871', '23', 'Хопкинс', 'Hopkins', 'MI', '49328', '42.6180', '-85.7212');
INSERT INTO `net_city` VALUES ('9873', '23', 'Луисвилл', 'Louisville', 'TN', '37777', '35.8134', '-84.0855');
INSERT INTO `net_city` VALUES ('9877', '23', 'Кунклтаун', 'Kunkletown', 'PA', '18058', '40.8457', '-75.4948');
INSERT INTO `net_city` VALUES ('9878', '23', 'Перкаси', 'Perkasie', 'PA', '18944', '40.3979', '-75.2320');
INSERT INTO `net_city` VALUES ('9890', '23', 'Анамоса', 'Anamosa', 'IA', '52205', '42.1386', '-91.2483');
INSERT INTO `net_city` VALUES ('9891', '23', 'Каманч', 'Camanche', 'IA', '52730', '41.7716', '-90.3385');
INSERT INTO `net_city` VALUES ('9894', '23', 'Тискилва', 'Tiskilwa', 'IL', '61368', '41.2450', '-89.5217');
INSERT INTO `net_city` VALUES ('9895', '23', 'Медиаполис', 'Mediapolis', 'IA', '52637', '41.0187', '-91.1314');
INSERT INTO `net_city` VALUES ('9906', '23', 'Бунсборо', 'Boonsboro', 'MD', '21713', '39.5190', '-77.6878');
INSERT INTO `net_city` VALUES ('9910', '23', 'Похатан Пойнт', 'Powhatan Point', 'OH', '43942', '39.8711', '-80.8552');
INSERT INTO `net_city` VALUES ('9911', '23', 'Хомстед', 'Homestead', 'PA', '15120', '40.3948', '-79.9056');
INSERT INTO `net_city` VALUES ('9912', '23', 'Калипатрия', 'Calipatria', 'CA', '92233', '33.1375', '-115.5238');
INSERT INTO `net_city` VALUES ('9915', '23', 'Бонсал', 'Bonsall', 'CA', '92003', '33.2880', '-117.1938');
INSERT INTO `net_city` VALUES ('9916', '23', 'Бриллион', 'Brillion', 'WI', '54110', '44.1683', '-88.1105');
INSERT INTO `net_city` VALUES ('9920', '23', 'Таварс', 'Tavares', 'FL', '32778', '28.7760', '-81.7152');
INSERT INTO `net_city` VALUES ('9927', '23', 'Доусон', 'Dawson', 'PA', '15428', '40.0818', '-79.6859');
INSERT INTO `net_city` VALUES ('9929', '23', 'Хорикон', 'Horicon', 'WI', '53032', '43.4566', '-88.6316');
INSERT INTO `net_city` VALUES ('9930', '23', 'Гленмонт', 'Glenmont', 'OH', '44628', '40.5325', '-82.1487');
INSERT INTO `net_city` VALUES ('9931', '23', 'Бербанк', 'Burbank', 'IL', '60459', '41.7452', '-87.7703');
INSERT INTO `net_city` VALUES ('9932', '23', 'Уилбертон', 'Wilburton', 'OK', '74578', '34.8948', '-95.2836');
INSERT INTO `net_city` VALUES ('9933', '23', 'Гров', 'Grove', 'OK', '74344', '36.5920', '-94.7297');
INSERT INTO `net_city` VALUES ('9935', '23', 'Сисайд', 'Seaside', 'CA', '93955', '36.6249', '-121.8257');
INSERT INTO `net_city` VALUES ('9936', '23', 'Сентр Холл', 'Centre Hall', 'PA', '16828', '40.8214', '-77.6945');
INSERT INTO `net_city` VALUES ('9941', '23', 'Имлей Сити', 'Imlay City', 'MI', '48444', '43.0680', '-83.0379');
INSERT INTO `net_city` VALUES ('9944', '23', 'Окли', 'Oakley', 'CA', '94561', '37.9942', '-121.6887');
INSERT INTO `net_city` VALUES ('9950', '23', 'Аппер Лейк', 'Upper Lake', 'CA', '95485', '39.2661', '-122.9667');
INSERT INTO `net_city` VALUES ('9953', '23', 'Липан', 'Lipan', 'TX', '76462', '32.5226', '-98.0483');
INSERT INTO `net_city` VALUES ('9957', '23', 'Картаж', 'Carthage', 'TX', '75633', '32.1193', '-94.3195');
INSERT INTO `net_city` VALUES ('9958', '23', 'Квитман', 'Quitman', 'TX', '75783', '32.8350', '-95.4230');
INSERT INTO `net_city` VALUES ('9966', '23', 'Накодочес', 'Nacogdoches', 'TX', '75961', '31.5565', '-94.4799');
INSERT INTO `net_city` VALUES ('9971', '23', 'Роксбери', 'Roxbury', 'CT', '06783', '41.5538', '-73.3015');
INSERT INTO `net_city` VALUES ('9974', '23', 'Сан Симеон', 'San Simeon', 'CA', '93452', '35.6950', '-121.2046');
INSERT INTO `net_city` VALUES ('9982', '23', 'Ричлендс', 'Richlands', 'VA', '24641', '37.1092', '-81.8163');
INSERT INTO `net_city` VALUES ('9988', '23', 'Ваксахачи', 'Waxahachie', 'TX', '75165', '32.3694', '-96.7873');
INSERT INTO `net_city` VALUES ('9990', '23', 'Анадарко', 'Anadarko', 'OK', '73005', '35.0583', '-98.2424');
INSERT INTO `net_city` VALUES ('9991', '23', 'Милл Крик', 'Mill Creek', 'OK', '74856', '34.3974', '-96.8268');
INSERT INTO `net_city` VALUES ('9992', '23', 'Слиделл', 'Slidell', 'LA', '70458', '30.2712', '-89.7705');
INSERT INTO `net_city` VALUES ('9993', '23', 'Лемон Ков', 'Lemon Cove', 'CA', '93244', '36.4606', '-118.9808');
INSERT INTO `net_city` VALUES ('9994', '23', 'Дауньевилл', 'Downieville', 'CA', '95936', '39.5813', '-120.7924');
INSERT INTO `net_city` VALUES ('9998', '23', 'Фэрпорт', 'Fairport', 'NY', '14450', '43.1005', '-77.4260');
INSERT INTO `net_city` VALUES ('10002', '23', 'Иксония', 'Ixonia', 'WI', '53036', '43.1533', '-88.6012');
INSERT INTO `net_city` VALUES ('10003', '23', 'Айдиллуайлд', 'Idyllwild', 'CA', '92549', '33.7631', '-116.7364');
INSERT INTO `net_city` VALUES ('10005', '23', 'Стилуэлл', 'Stilwell', 'OK', '74960', '35.8016', '-94.6720');
INSERT INTO `net_city` VALUES ('10006', '23', 'Мак-Алестер', 'McAlester', 'OK', '74501', '34.9665', '-95.8257');
INSERT INTO `net_city` VALUES ('10009', '23', 'Бастиан', 'Bastian', 'VA', '24314', '37.1578', '-81.2167');
INSERT INTO `net_city` VALUES ('10011', '23', 'Кэт Спринг', 'Cat Spring', 'TX', '78933', '29.7892', '-96.3624');
INSERT INTO `net_city` VALUES ('10014', '23', 'Дилсберг', 'Dillsburg', 'PA', '17019', '40.0811', '-77.0314');
INSERT INTO `net_city` VALUES ('10015', '23', 'Колинга', 'Coalinga', 'CA', '93210', '36.1966', '-120.3906');
INSERT INTO `net_city` VALUES ('10016', '23', 'Чоучилла', 'Chowchilla', 'CA', '93610', '37.0771', '-120.2738');
INSERT INTO `net_city` VALUES ('10019', '23', 'Уэлдон', 'Weldon', 'NC', '27890', '36.4139', '-77.5944');
INSERT INTO `net_city` VALUES ('10020', '23', 'Вилл Платт', 'Ville Platte', 'LA', '70586', '30.7409', '-92.3455');
INSERT INTO `net_city` VALUES ('10021', '23', 'Бидуэлл', 'Bidwell', 'OH', '45614', '38.9263', '-82.2680');
INSERT INTO `net_city` VALUES ('10025', '23', 'Гвалала', 'Gualala', 'CA', '95445', '38.8270', '-123.5146');
INSERT INTO `net_city` VALUES ('10028', '23', 'Дир Айл', 'Deer Isle', 'ME', '04627', '44.2237', '-68.6487');
INSERT INTO `net_city` VALUES ('10030', '23', 'Гладуин', 'Gladwin', 'MI', '48624', '44.0747', '-84.4347');
INSERT INTO `net_city` VALUES ('10034', '23', 'Граймс', 'Grimes', 'IA', '50111', '41.6897', '-93.7951');
INSERT INTO `net_city` VALUES ('10040', '23', 'Лебанон', 'Lebanon', 'MO', '65536', '37.6989', '-92.6620');
INSERT INTO `net_city` VALUES ('10044', '23', 'Пиджен Фордж', 'Pigeon Forge', 'TN', '37863', '35.7778', '-83.5733');
INSERT INTO `net_city` VALUES ('10049', '23', 'Сандаски', 'Sandusky', 'MI', '48471', '43.4201', '-82.8577');
INSERT INTO `net_city` VALUES ('10051', '23', 'Уикетт', 'Wickett', 'TX', '79788', '31.5701', '-103.0010');
INSERT INTO `net_city` VALUES ('10053', '23', 'Брнаф', 'Bronaugh', 'MO', '64728', '37.7140', '-94.5063');
INSERT INTO `net_city` VALUES ('10057', '23', 'Мюррейвилл', 'Murrayville', 'IL', '62668', '39.5853', '-90.2416');
INSERT INTO `net_city` VALUES ('10059', '23', 'Кортленд', 'Cortland', 'OH', '44410', '41.3598', '-80.7148');
INSERT INTO `net_city` VALUES ('10060', '23', 'Хаббард', 'Hubbard', 'OH', '44425', '41.1743', '-80.5841');
INSERT INTO `net_city` VALUES ('10064', '23', 'Коттедж Гров', 'Cottage Grove', 'WI', '53527', '43.0709', '-89.1885');
INSERT INTO `net_city` VALUES ('10065', '23', 'Ваутома', 'Wautoma', 'WI', '54982', '44.0654', '-89.2821');
INSERT INTO `net_city` VALUES ('10066', '23', 'Эджертон', 'Edgerton', 'WI', '53534', '42.8575', '-89.1026');
INSERT INTO `net_city` VALUES ('10067', '23', 'Санол', 'Sunol', 'CA', '94586', '37.5610', '-121.8489');
INSERT INTO `net_city` VALUES ('10070', '23', 'Коди', 'Cody', 'WY', '82414', '44.4023', '-109.5347');
INSERT INTO `net_city` VALUES ('10073', '23', 'Роксборо', 'Roxboro', 'NC', '27573', '36.3995', '-78.9760');
INSERT INTO `net_city` VALUES ('10081', '23', 'Седалия', 'Sedalia', 'MO', '65301', '38.7029', '-93.2368');
INSERT INTO `net_city` VALUES ('10082', '23', 'Роквилл', 'Rockville', 'MO', '64780', '38.0581', '-94.0691');
INSERT INTO `net_city` VALUES ('10088', '23', 'Ла Марк', 'La Marque', 'TX', '77568', '29.3732', '-95.0035');
INSERT INTO `net_city` VALUES ('10099', '23', 'Роулинс', 'Rawlins', 'WY', '82301', '42.0442', '-107.4298');
INSERT INTO `net_city` VALUES ('10100', '23', 'Вудсборо', 'Woodsboro', 'MD', '21798', '39.5333', '-77.2970');
INSERT INTO `net_city` VALUES ('10101', '23', 'Чесни', 'Chesnee', 'SC', '29323', '35.1121', '-81.9154');
INSERT INTO `net_city` VALUES ('10102', '23', 'Нелай', 'Neligh', 'NE', '68756', '42.1826', '-97.9813');
INSERT INTO `net_city` VALUES ('10103', '23', 'Гленн', 'Glenn', 'CA', '95943', '39.6039', '-122.0252');
INSERT INTO `net_city` VALUES ('10106', '23', 'Лондон', 'London', 'OH', '43140', '39.8979', '-83.3866');
INSERT INTO `net_city` VALUES ('10108', '23', 'Негауни', 'Negaunee', 'MI', '49866', '46.5172', '-87.6034');
INSERT INTO `net_city` VALUES ('10109', '23', 'Калабаш', 'Calabash', 'NC', '28467', '33.9182', '-78.5999');
INSERT INTO `net_city` VALUES ('10110', '23', 'Арканзас Сити', 'Arkansas City', 'KS', '67005', '37.0931', '-96.9558');
INSERT INTO `net_city` VALUES ('10115', '23', 'Кемпнер', 'Kempner', 'TX', '76539', '31.0979', '-97.9965');
INSERT INTO `net_city` VALUES ('10116', '23', 'Лампасас', 'Lampasas', 'TX', '76550', '31.1703', '-98.2232');
INSERT INTO `net_city` VALUES ('10118', '23', 'Ризель', 'Riesel', 'TX', '76682', '31.4561', '-96.8917');
INSERT INTO `net_city` VALUES ('10119', '23', 'Итаска', 'Itasca', 'TX', '76055', '32.1564', '-97.1509');
INSERT INTO `net_city` VALUES ('10121', '23', 'Чарлвуа', 'Charlevoix', 'MI', '49720', '45.2510', '-85.2807');
INSERT INTO `net_city` VALUES ('10123', '23', 'Итон Рапидс', 'Eaton Rapids', 'MI', '48827', '42.5103', '-84.6637');
INSERT INTO `net_city` VALUES ('10124', '23', 'Нью Хартфорд', 'New Hartford', 'NY', '13413', '43.0582', '-75.2705');
INSERT INTO `net_city` VALUES ('10127', '23', 'Онарга', 'Onarga', 'IL', '60955', '40.7010', '-87.9831');
INSERT INTO `net_city` VALUES ('10128', '23', 'Ок Форест', 'Oak Forest', 'IL', '60452', '41.6033', '-87.7547');
INSERT INTO `net_city` VALUES ('10135', '23', 'Джоакин', 'Joaquin', 'TX', '75954', '31.9281', '-94.0682');
INSERT INTO `net_city` VALUES ('10138', '23', 'Игл', 'Eagle', 'CO', '81631', '39.6101', '-106.7991');
INSERT INTO `net_city` VALUES ('10139', '23', 'Бандьера', 'Bandera', 'TX', '78003', '29.7331', '-99.1294');
INSERT INTO `net_city` VALUES ('10141', '23', 'Дип Ривер', 'Deep River', 'CT', '06417', '41.3680', '-72.4564');
INSERT INTO `net_city` VALUES ('10144', '23', 'Грейвуа Милс', 'Gravois Mills', 'MO', '65037', '38.2419', '-92.8548');
INSERT INTO `net_city` VALUES ('10146', '23', 'Маунд Сити', 'Mound City', 'IL', '62963', '37.0913', '-89.1647');
INSERT INTO `net_city` VALUES ('10148', '23', 'Сандерсон', 'Sanderson', 'FL', '32087', '30.3546', '-82.3298');
INSERT INTO `net_city` VALUES ('10149', '23', 'Рокпорт', 'Rockport', 'TX', '78382', '28.0380', '-97.0937');
INSERT INTO `net_city` VALUES ('10150', '23', 'Порт Гэмбл', 'Port Gamble', 'WA', '98364', '47.8543', '-122.5838');
INSERT INTO `net_city` VALUES ('10152', '23', 'Фортвилл', 'Fortville', 'IN', '46040', '39.9268', '-85.8414');
INSERT INTO `net_city` VALUES ('10156', '23', 'Эдна', 'Edna', 'TX', '77957', '29.0352', '-96.7370');
INSERT INTO `net_city` VALUES ('10157', '23', 'Куеро', 'Cuero', 'TX', '77954', '29.1159', '-97.2712');
INSERT INTO `net_city` VALUES ('10162', '23', 'Локборн', 'Lockbourne', 'OH', '43137', '39.8014', '-82.9895');
INSERT INTO `net_city` VALUES ('10168', '23', 'Джеймул', 'Jamul', 'CA', '91935', '32.6998', '-116.8038');
INSERT INTO `net_city` VALUES ('10169', '23', 'Паума Валли', 'Pauma Valley', 'CA', '92061', '33.3043', '-116.9239');
INSERT INTO `net_city` VALUES ('10174', '23', 'Мемфис', 'Memphis', 'IN', '47143', '38.4854', '-85.7589');
INSERT INTO `net_city` VALUES ('10178', '23', 'Джеветт Сити', 'Jewett City', 'CT', '06351', '41.5811', '-71.9554');
INSERT INTO `net_city` VALUES ('10180', '23', 'Индиана', 'Indiana', 'PA', '15701', '40.6224', '-79.1454');
INSERT INTO `net_city` VALUES ('10181', '23', 'Беверли Хиллс', 'Beverly Hills', 'FL', '34465', '28.9345', '-82.4723');
INSERT INTO `net_city` VALUES ('10187', '23', 'Санти', 'Santee', 'CA', '92071', '32.8561', '-116.9968');
INSERT INTO `net_city` VALUES ('10188', '23', 'Манчестер', 'Manchester Township', 'NJ', '08759', '39.9742', '-74.3451');
INSERT INTO `net_city` VALUES ('10190', '23', 'Ошен Айл Бич', 'Ocean Isle Beach', 'NC', '28469', '33.9259', '-78.4498');
INSERT INTO `net_city` VALUES ('10191', '23', 'Прайор-Лейк', 'Prior Lake', 'MN', '55372', '44.6742', '-93.4103');
INSERT INTO `net_city` VALUES ('10196', '23', 'Пико Ривера', 'Pico Rivera', 'CA', '90660', '33.9864', '-118.0884');
INSERT INTO `net_city` VALUES ('10197', '23', 'Маскаута', 'Mascoutah', 'IL', '62258', '38.4556', '-89.7709');
INSERT INTO `net_city` VALUES ('10200', '23', 'Чагуотер', 'Chugwater', 'WY', '82210', '41.7549', '-104.7785');
INSERT INTO `net_city` VALUES ('10202', '23', 'Кармел Валли', 'Carmel Valley', 'CA', '93924', '36.3917', '-121.6538');
INSERT INTO `net_city` VALUES ('10206', '23', 'Саттон', 'Sutton', 'MA', '01590', '42.1365', '-71.7559');
INSERT INTO `net_city` VALUES ('10210', '23', 'Милилани', 'Mililani', 'HI', '96789', '21.4701', '-157.9637');
INSERT INTO `net_city` VALUES ('10212', '23', 'Соквилл', 'Saukville', 'WI', '53080', '43.4106', '-87.9796');
INSERT INTO `net_city` VALUES ('10215', '23', 'Ройс Сити', 'Royse City', 'TX', '75189', '32.9478', '-96.3139');
INSERT INTO `net_city` VALUES ('10216', '23', 'Три Риверс', 'Three Rivers', 'CA', '93271', '36.4407', '-118.8604');
INSERT INTO `net_city` VALUES ('10218', '23', 'Ниленд', 'Niland', 'CA', '92257', '33.3055', '-115.5573');
INSERT INTO `net_city` VALUES ('10219', '23', 'Колвер', 'Colver', 'PA', '15927', '40.5402', '-78.7835');
INSERT INTO `net_city` VALUES ('10222', '23', 'Холли Хилл', 'Holly Hill', 'SC', '29059', '33.3015', '-80.4288');
INSERT INTO `net_city` VALUES ('10225', '23', 'Лорена', 'Lorena', 'TX', '76655', '31.3968', '-97.1748');
INSERT INTO `net_city` VALUES ('10228', '23', 'Пловер', 'Plover', 'WI', '54467', '44.4229', '-89.5369');
INSERT INTO `net_city` VALUES ('10231', '23', 'Кламат', 'Klamath', 'CA', '95548', '41.5993', '-124.0695');
INSERT INTO `net_city` VALUES ('10233', '23', 'Кутенай', 'Kootenai', 'ID', '83840', '48.3102', '-116.5135');
INSERT INTO `net_city` VALUES ('10235', '23', 'Сиговилл', 'Seagoville', 'TX', '75159', '32.5956', '-96.5584');
INSERT INTO `net_city` VALUES ('10239', '23', 'Вилла Гров', 'Villa Grove', 'IL', '61956', '39.8542', '-88.1507');
INSERT INTO `net_city` VALUES ('10244', '23', 'Ен', 'Ione', 'CA', '95640', '38.3389', '-120.8875');
INSERT INTO `net_city` VALUES ('10249', '23', 'Мандей', 'Munday', 'TX', '76371', '33.4997', '-99.6163');
INSERT INTO `net_city` VALUES ('10250', '23', 'Минерал Уэлс', 'Mineral Wells', 'TX', '76067', '32.7923', '-98.1388');
INSERT INTO `net_city` VALUES ('10254', '23', 'Бонита', 'Bonita', 'CA', '91902', '32.6773', '-117.0123');
INSERT INTO `net_city` VALUES ('10256', '23', 'Марлборо', 'Marlborough', 'CT', '06447', '41.6363', '-72.4568');
INSERT INTO `net_city` VALUES ('10257', '23', 'Уильямстаун', 'Williamstown', 'MA', '01267', '42.6442', '-73.2463');
INSERT INTO `net_city` VALUES ('10260', '23', 'Игл Пасс', 'Eagle Pass', 'TX', '78852', '28.7364', '-100.4521');
INSERT INTO `net_city` VALUES ('10262', '23', 'Карнс Сити', 'Karnes City', 'TX', '78118', '28.9227', '-97.9022');
INSERT INTO `net_city` VALUES ('10265', '23', 'Маркез', 'Marquez', 'TX', '77865', '31.2275', '-96.2108');
INSERT INTO `net_city` VALUES ('10271', '23', 'Кавколин', 'Kawkawlin', 'MI', '48631', '43.6884', '-84.0086');
INSERT INTO `net_city` VALUES ('10277', '23', 'Симонтон', 'Simonton', 'TX', '77476', '29.6778', '-95.9921');
INSERT INTO `net_city` VALUES ('10279', '23', 'Эллингтон', 'Ellington', 'MO', '63638', '37.2292', '-90.9713');
INSERT INTO `net_city` VALUES ('10281', '23', 'Кастро Валли', 'Castro Valley', 'CA', '94546', '37.7090', '-122.0885');
INSERT INTO `net_city` VALUES ('10282', '23', 'Гиббон', 'Gibbon', 'NE', '68840', '40.7742', '-98.8842');
INSERT INTO `net_city` VALUES ('10283', '23', 'Козад', 'Cozad', 'NE', '69130', '40.9387', '-99.9860');
INSERT INTO `net_city` VALUES ('10286', '23', 'Хомвуд', 'Homewood', 'IL', '60430', '41.5583', '-87.6612');
INSERT INTO `net_city` VALUES ('10287', '23', 'Ист Чикаго', 'East Chicago', 'IN', '46312', '41.6463', '-87.4528');
INSERT INTO `net_city` VALUES ('10289', '23', 'Перселл', 'Purcell', 'OK', '73080', '35.0298', '-97.4710');
INSERT INTO `net_city` VALUES ('10293', '23', 'Ювалд', 'Uvalde', 'TX', '78801', '29.3566', '-99.8313');
INSERT INTO `net_city` VALUES ('10295', '23', 'Ривер Фолс', 'River Falls', 'WI', '54022', '44.8371', '-92.5917');
INSERT INTO `net_city` VALUES ('10296', '23', 'Амери', 'Amery', 'WI', '54001', '45.3314', '-92.3695');
INSERT INTO `net_city` VALUES ('10298', '23', 'Уэсли Чапел', 'Wesley Chapel', 'FL', '33544', '28.2722', '-82.3322');
INSERT INTO `net_city` VALUES ('10302', '23', 'Генри', 'Henry', 'VA', '24102', '36.8427', '-79.9971');
INSERT INTO `net_city` VALUES ('10306', '23', 'Мейхилл', 'Mayhill', 'NM', '88339', '32.9633', '-105.3057');
INSERT INTO `net_city` VALUES ('10308', '23', 'Уиндоу-Рок', 'Window Rock', 'AZ', '86515', '35.6806', '-109.0526');
INSERT INTO `net_city` VALUES ('10310', '23', 'Юпора', 'Eupora', 'MS', '39744', '33.5564', '-89.3295');
INSERT INTO `net_city` VALUES ('10315', '23', 'Хибер-Спрингс', 'Heber Springs', 'AR', '72543', '35.4479', '-91.9977');
INSERT INTO `net_city` VALUES ('10318', '23', 'Драско', 'Drasco', 'AR', '72530', '35.6290', '-91.9324');
INSERT INTO `net_city` VALUES ('10319', '23', 'Абердин', 'Aberdeen', 'SD', '57401', '45.4819', '-98.5064');
INSERT INTO `net_city` VALUES ('10320', '23', 'Карлтон', 'Carleton', 'NE', '68326', '40.2870', '-97.6613');
INSERT INTO `net_city` VALUES ('10324', '23', 'Рансом Каньон', 'Ransom Canyon', 'TX', '79366', '33.5151', '-101.6756');
INSERT INTO `net_city` VALUES ('10328', '23', 'Морган Сити', 'Morgan City', 'LA', '70380', '29.6997', '-91.0655');
INSERT INTO `net_city` VALUES ('10329', '23', 'Флоувуд', 'Flowood', 'MS', '39232', '32.3223', '-90.1087');
INSERT INTO `net_city` VALUES ('10332', '23', 'Гент', 'Ghent', 'NY', '12075', '42.3085', '-73.6144');
INSERT INTO `net_city` VALUES ('10333', '23', 'Рок Фолс', 'Rock Falls', 'IL', '61071', '41.7364', '-89.7042');
INSERT INTO `net_city` VALUES ('10334', '23', 'Форт Мэдисон', 'Fort Madison', 'IA', '52627', '40.6662', '-91.3492');
INSERT INTO `net_city` VALUES ('10339', '23', 'Поплар Гров', 'Poplar Grove', 'IL', '61065', '42.3998', '-88.8271');
INSERT INTO `net_city` VALUES ('10340', '23', 'Сентревилл', 'Centreville', 'AL', '35042', '32.9039', '-87.0851');
INSERT INTO `net_city` VALUES ('10341', '23', 'Плезантон', 'Pleasanton', 'KS', '66075', '38.1861', '-94.7057');
INSERT INTO `net_city` VALUES ('10343', '23', 'Саут Хатчинсон', 'South Hutchinson', 'KS', '67505', '38.0282', '-97.9485');
INSERT INTO `net_city` VALUES ('10344', '23', 'Спайви', 'Spivey', 'KS', '67142', '37.4718', '-98.1267');
INSERT INTO `net_city` VALUES ('10349', '23', 'Браш', 'Brush', 'CO', '80723', '40.1677', '-103.5368');
INSERT INTO `net_city` VALUES ('10355', '23', 'Маринетт', 'Marinette', 'WI', '54143', '45.0901', '-87.7101');
INSERT INTO `net_city` VALUES ('10359', '23', 'Бруклин', 'Brooklin', 'ME', '04616', '44.2855', '-68.5727');
INSERT INTO `net_city` VALUES ('10367', '23', 'Уэбб Сити', 'Webb City', 'MO', '64870', '37.1847', '-94.4738');
INSERT INTO `net_city` VALUES ('10371', '23', 'Хазел Парк', 'Hazel Park', 'MI', '48030', '42.4618', '-83.0985');
INSERT INTO `net_city` VALUES ('10372', '23', 'Джинеси', 'Genesee', 'MI', '48437', '43.1125', '-83.6177');
INSERT INTO `net_city` VALUES ('10373', '23', 'Метамора', 'Metamora', 'MI', '48455', '42.9431', '-83.2998');
INSERT INTO `net_city` VALUES ('10376', '23', 'Сидарберг', 'Cedarburg', 'WI', '53012', '43.3208', '-88.0314');
INSERT INTO `net_city` VALUES ('10379', '23', 'Бейрд', 'Baird', 'TX', '79504', '32.2976', '-99.3057');
INSERT INTO `net_city` VALUES ('10380', '23', 'Майерсвилл', 'Myersville', 'MD', '21773', '39.5365', '-77.5563');
INSERT INTO `net_city` VALUES ('10382', '23', 'Уэбстер', 'Webster', 'FL', '33597', '28.5299', '-82.0902');
INSERT INTO `net_city` VALUES ('10383', '23', 'Босуэлл', 'Boswell', 'IN', '47921', '40.4731', '-87.3662');
INSERT INTO `net_city` VALUES ('10385', '23', 'Порт Байрон', 'Port Byron', 'IL', '61275', '41.5939', '-90.3035');
INSERT INTO `net_city` VALUES ('10387', '23', 'Брод Ран', 'Broad Run', 'VA', '20137', '38.8150', '-77.7097');
INSERT INTO `net_city` VALUES ('10388', '23', 'Паудерли', 'Powderly', 'TX', '75473', '33.8090', '-95.4619');
INSERT INTO `net_city` VALUES ('10395', '23', 'Сок Сити', 'Sauk City', 'WI', '53583', '43.2626', '-89.8467');
INSERT INTO `net_city` VALUES ('10396', '23', 'Текопа', 'Tecopa', 'CA', '92389', '35.8519', '-116.2251');
INSERT INTO `net_city` VALUES ('10398', '23', 'Данедин', 'Dunedin', 'FL', '34698', '28.0288', '-82.7689');
INSERT INTO `net_city` VALUES ('10401', '23', 'Фанси Гэп', 'Fancy Gap', 'VA', '24328', '36.6561', '-80.6822');
INSERT INTO `net_city` VALUES ('10402', '23', 'Кеокек', 'Keokuk', 'IA', '52632', '40.4520', '-91.4558');
INSERT INTO `net_city` VALUES ('10408', '23', 'Уилтон', 'Wilton', 'CA', '95693', '38.3926', '-121.2429');
INSERT INTO `net_city` VALUES ('10414', '23', 'Джоердантон', 'Jourdanton', 'TX', '78026', '28.8291', '-98.5506');
INSERT INTO `net_city` VALUES ('10415', '23', 'Йокум', 'Yoakum', 'TX', '77995', '29.1814', '-97.1055');
INSERT INTO `net_city` VALUES ('10416', '23', 'Мерседес', 'Mercedes', 'TX', '78570', '26.1884', '-97.9232');
INSERT INTO `net_city` VALUES ('10417', '23', 'Кояноса', 'Coyanosa', 'TX', '79730', '31.1821', '-103.0965');
INSERT INTO `net_city` VALUES ('10419', '23', 'Ружмонт', 'Rougemont', 'NC', '27572', '36.2535', '-78.8985');
INSERT INTO `net_city` VALUES ('10421', '23', 'Маркванд', 'Marquand', 'MO', '63655', '37.3906', '-90.1973');
INSERT INTO `net_city` VALUES ('10423', '23', 'Бастроп', 'Bastrop', 'TX', '78602', '30.1406', '-97.3275');
INSERT INTO `net_city` VALUES ('10424', '23', 'Альбемарль', 'Albemarle', 'NC', '28001', '35.3400', '-80.2108');
INSERT INTO `net_city` VALUES ('10429', '23', 'Бойла', 'Beulah', 'MI', '49617', '44.6400', '-86.0365');
INSERT INTO `net_city` VALUES ('10430', '23', 'Уэтерфорд', 'Weatherford', 'OK', '73096', '35.5224', '-98.7331');
INSERT INTO `net_city` VALUES ('10434', '23', 'Голден Медоу', 'Golden Meadow', 'LA', '70357', '29.2922', '-90.2020');
INSERT INTO `net_city` VALUES ('10435', '23', 'Милтон', 'Milton', 'FL', '32571', '30.6668', '-87.1850');
INSERT INTO `net_city` VALUES ('10437', '23', 'Мидлберг Хайтс', 'Middleburg Heights', 'OH', '44133', '41.3146', '-81.7449');
INSERT INTO `net_city` VALUES ('10444', '23', 'Верди', 'Verdi', 'NV', '89439', '39.5182', '-119.9888');
INSERT INTO `net_city` VALUES ('10448', '23', 'Лютер', 'Luther', 'OK', '73054', '35.6885', '-97.1962');
INSERT INTO `net_city` VALUES ('10449', '23', 'Спотсильвания', 'Spotsylvania', 'VA', '22553', '38.1972', '-77.6821');
INSERT INTO `net_city` VALUES ('10456', '23', 'Сьюард', 'Seward', 'NE', '68434', '40.9195', '-97.1109');
INSERT INTO `net_city` VALUES ('10457', '23', 'Пуэбло Акома', 'Pueblo Of Acoma', 'NM', '87034', '35.0847', '-107.5985');
INSERT INTO `net_city` VALUES ('10462', '23', 'Гарвард', 'Harvard', 'IL', '60033', '42.4041', '-88.6023');
INSERT INTO `net_city` VALUES ('10463', '23', 'Бельвью', 'Belleview', 'FL', '34420', '29.0563', '-82.0257');
INSERT INTO `net_city` VALUES ('10467', '23', 'Хазел Крест', 'Hazel Crest', 'IL', '60429', '41.5680', '-87.6934');
INSERT INTO `net_city` VALUES ('10471', '23', 'Ричлендс', 'Richlands', 'NC', '28574', '34.8791', '-77.5906');
INSERT INTO `net_city` VALUES ('10474', '23', 'Озарк', 'Ozark', 'AL', '36360', '31.4627', '-85.6267');
INSERT INTO `net_city` VALUES ('10478', '23', 'Колтс Нек', 'Colts Neck', 'NJ', '07722', '40.2909', '-74.1652');
INSERT INTO `net_city` VALUES ('10479', '23', 'Лейкпорт', 'Lakeport', 'CA', '95453', '39.0486', '-122.9390');
INSERT INTO `net_city` VALUES ('10485', '23', 'Беркбернетт', 'Burkburnett', 'TX', '76354', '34.0978', '-98.6163');
INSERT INTO `net_city` VALUES ('10486', '23', 'Юкон', 'Yukon', 'OK', '73099', '35.5331', '-97.7707');
INSERT INTO `net_city` VALUES ('10488', '23', 'Графорд', 'Graford', 'TX', '76449', '32.8944', '-98.3087');
INSERT INTO `net_city` VALUES ('10492', '23', 'Парсонс', 'Parsons', 'KS', '67357', '37.3323', '-95.2612');
INSERT INTO `net_city` VALUES ('10498', '23', 'Сейнт Джордж', 'Saint George', 'UT', '84790', '37.0645', '-113.5746');
INSERT INTO `net_city` VALUES ('10499', '23', 'Анна', 'Anna', 'IL', '62906', '37.4444', '-89.1705');
INSERT INTO `net_city` VALUES ('10500', '23', 'Окдейл', 'Oakdale', 'CA', '95361', '37.8034', '-120.7464');
INSERT INTO `net_city` VALUES ('10504', '23', 'Дарби', 'Darby', 'PA', '19023', '39.9180', '-75.2692');
INSERT INTO `net_city` VALUES ('10509', '23', 'Атаскадеро', 'Atascadero', 'CA', '93422', '35.4573', '-120.7192');
INSERT INTO `net_city` VALUES ('10512', '23', 'Роллинг Прейри', 'Rolling Prairie', 'IN', '46371', '41.6800', '-86.6030');
INSERT INTO `net_city` VALUES ('10513', '23', 'Брайант', 'Bryant', 'AR', '72022', '34.6008', '-92.4911');
INSERT INTO `net_city` VALUES ('10518', '23', 'Григсвилл', 'Griggsville', 'IL', '62340', '39.7288', '-90.7298');
INSERT INTO `net_city` VALUES ('10519', '23', 'Кисер', 'Keyser', 'WV', '26726', '39.4530', '-78.9494');
INSERT INTO `net_city` VALUES ('10525', '23', 'Петтус', 'Pettus', 'TX', '78146', '28.6180', '-97.8022');
INSERT INTO `net_city` VALUES ('10536', '23', 'Ричвейл', 'Richvale', 'CA', '95974', '39.4938', '-121.7447');
INSERT INTO `net_city` VALUES ('10541', '23', 'Вернал', 'Vernal', 'UT', '84078', '40.5512', '-109.5696');
INSERT INTO `net_city` VALUES ('10542', '23', 'Дакуотер', 'Duckwater', 'NV', '89314', '38.9324', '-115.7145');
INSERT INTO `net_city` VALUES ('10543', '23', 'Рио Хондо', 'Rio Hondo', 'TX', '78583', '26.2615', '-97.4872');
INSERT INTO `net_city` VALUES ('10546', '23', 'Гейсмар', 'Geismar', 'LA', '70734', '30.1948', '-91.0084');
INSERT INTO `net_city` VALUES ('10550', '23', 'Фелан', 'Phelan', 'CA', '92371', '34.4277', '-117.4821');
INSERT INTO `net_city` VALUES ('10559', '23', 'Эмпория', 'Emporia', 'VA', '23847', '36.7215', '-77.5320');
INSERT INTO `net_city` VALUES ('10560', '23', 'Спаркс', 'Sparks', 'GA', '31647', '31.2056', '-83.4274');
INSERT INTO `net_city` VALUES ('10561', '23', 'Ренс', 'Wrens', 'GA', '30833', '33.1887', '-82.3552');
INSERT INTO `net_city` VALUES ('10564', '23', 'Айден', 'Ayden', 'NC', '28513', '35.4425', '-77.4045');
INSERT INTO `net_city` VALUES ('10567', '23', 'Вашон', 'Vashon', 'WA', '98070', '47.4206', '-122.4509');
INSERT INTO `net_city` VALUES ('10568', '23', 'Маренго', 'Marengo', 'IL', '60152', '42.2479', '-88.6083');
INSERT INTO `net_city` VALUES ('10573', '23', 'Керман', 'Kerman', 'CA', '93630', '36.7144', '-120.1561');
INSERT INTO `net_city` VALUES ('10576', '23', 'Соледад', 'Soledad', 'CA', '93960', '36.3952', '-121.3047');
INSERT INTO `net_city` VALUES ('10577', '23', 'Файербо', 'Firebaugh', 'CA', '93622', '36.8524', '-120.5467');
INSERT INTO `net_city` VALUES ('10579', '23', 'Лепанто', 'Lepanto', 'AR', '72354', '35.6247', '-90.3071');
INSERT INTO `net_city` VALUES ('10580', '23', 'Полс Валли', 'Pauls Valley', 'OK', '73075', '34.7389', '-97.2337');
INSERT INTO `net_city` VALUES ('10581', '23', 'Левелленд', 'Levelland', 'TX', '79336', '33.6067', '-102.3872');
INSERT INTO `net_city` VALUES ('10584', '23', 'Белмонт', 'Belmont', 'CA', '94002', '37.5081', '-122.3010');
INSERT INTO `net_city` VALUES ('10586', '23', 'Дюма', 'Dumas', 'TX', '79029', '35.8787', '-101.9508');
INSERT INTO `net_city` VALUES ('10587', '23', 'Авондейл', 'Avondale', 'AZ', '85323', '33.4442', '-112.3178');
INSERT INTO `net_city` VALUES ('10588', '23', 'Лорел Форк', 'Laurel Fork', 'VA', '24352', '36.7111', '-80.5381');
INSERT INTO `net_city` VALUES ('10591', '23', 'Диксон', 'Dickson', 'TN', '37055', '36.0643', '-87.4302');
INSERT INTO `net_city` VALUES ('10592', '23', 'Патаскала', 'Pataskala', 'OH', '43062', '40.0097', '-82.6718');
INSERT INTO `net_city` VALUES ('10595', '23', 'Хайнс', 'Hines', 'IL', '60141', '41.8536', '-87.8395');
INSERT INTO `net_city` VALUES ('10597', '23', 'Айронтон', 'Ironton', 'OH', '45638', '38.5650', '-82.6772');
INSERT INTO `net_city` VALUES ('10599', '23', 'Гордон', 'Gordon', 'TX', '76453', '32.5576', '-98.3457');
INSERT INTO `net_city` VALUES ('10600', '23', 'Уиллоус', 'Willows', 'CA', '95988', '39.5041', '-122.2825');
INSERT INTO `net_city` VALUES ('10601', '23', 'Песко', 'Pasco', 'WA', '99301', '46.4182', '-118.9003');
INSERT INTO `net_city` VALUES ('10608', '23', 'Атуотер', 'Atwater', 'CA', '95301', '37.3255', '-120.6367');
INSERT INTO `net_city` VALUES ('10612', '23', 'Кабазон', 'Cabazon', 'CA', '92230', '33.9326', '-116.7720');
INSERT INTO `net_city` VALUES ('10615', '23', 'Калона', 'Kalona', 'IA', '52247', '41.5096', '-91.7258');
INSERT INTO `net_city` VALUES ('10616', '23', 'Атчисон', 'Atchison', 'KS', '66002', '39.5505', '-95.1273');
INSERT INTO `net_city` VALUES ('10619', '23', 'Фипсберг', 'Phippsburg', 'ME', '04562', '43.7900', '-69.8271');
INSERT INTO `net_city` VALUES ('10620', '23', 'Питерборо', 'Peterborough', 'NH', '03458', '42.8665', '-71.9605');
INSERT INTO `net_city` VALUES ('10623', '23', 'Киллингворт', 'Killingworth', 'CT', '06419', '41.3764', '-72.5833');
INSERT INTO `net_city` VALUES ('10630', '23', 'Кларксдейл', 'Clarksdale', 'MS', '38614', '34.1729', '-90.6075');
INSERT INTO `net_city` VALUES ('10634', '23', 'Нешнел Сити', 'National City', 'CA', '91950', '32.6707', '-117.0946');
INSERT INTO `net_city` VALUES ('10637', '23', 'Кема', 'Kemah', 'TX', '77565', '29.5332', '-95.0215');
INSERT INTO `net_city` VALUES ('10639', '23', 'Тарборо', 'Tarboro', 'NC', '27886', '35.9070', '-77.5424');
INSERT INTO `net_city` VALUES ('10643', '23', 'Канаан', 'Canaan', 'NY', '12029', '42.4057', '-73.4301');
INSERT INTO `net_city` VALUES ('10644', '23', 'Тазевелл', 'Tazewell', 'VA', '24651', '37.0595', '-81.5220');
INSERT INTO `net_city` VALUES ('10646', '23', 'Зебулон', 'Zebulon', 'NC', '27597', '35.8080', '-78.3169');
INSERT INTO `net_city` VALUES ('10647', '23', 'Ландисберг', 'Landisburg', 'PA', '17040', '40.3160', '-77.3269');
INSERT INTO `net_city` VALUES ('10650', '23', 'Фэрмонт', 'Fairmont', 'WV', '26554', '39.4841', '-80.0601');
INSERT INTO `net_city` VALUES ('10653', '23', 'Траут Ран', 'Trout Run', 'PA', '17771', '41.4469', '-77.0402');
INSERT INTO `net_city` VALUES ('10655', '23', 'Каслтон', 'Castleton', 'VA', '22716', '38.6366', '-78.1116');
INSERT INTO `net_city` VALUES ('10661', '23', 'Калера', 'Calera', 'AL', '35040', '33.1008', '-86.7083');
INSERT INTO `net_city` VALUES ('10664', '23', 'Ванс', 'Vance', 'AL', '35490', '33.2184', '-87.2287');
INSERT INTO `net_city` VALUES ('10665', '23', 'Пайни Вудс', 'Piney Woods', 'MS', '39148', '32.0626', '-89.9929');
INSERT INTO `net_city` VALUES ('10666', '23', 'Медоу Виста', 'Meadow Vista', 'CA', '95722', '39.0020', '-121.0331');
INSERT INTO `net_city` VALUES ('10669', '23', 'Денвер Сити', 'Denver City', 'TX', '79323', '32.9530', '-102.8815');
INSERT INTO `net_city` VALUES ('10674', '23', 'Хардин', 'Hardin', 'MT', '59034', '45.7553', '-107.7902');
INSERT INTO `net_city` VALUES ('10677', '23', 'Гаварден', 'Hawarden', 'IA', '51023', '43.0333', '-96.4271');
INSERT INTO `net_city` VALUES ('10684', '23', 'Текейт', 'Tecate', 'CA', '91980', '32.5925', '-116.5855');
INSERT INTO `net_city` VALUES ('10685', '23', 'Тонто Бейсин', 'Tonto Basin', 'AZ', '85553', '33.8317', '-111.2946');
INSERT INTO `net_city` VALUES ('10695', '23', 'Девайн', 'Devine', 'TX', '78016', '29.1945', '-98.9480');
INSERT INTO `net_city` VALUES ('10696', '23', 'Рефухио', 'Refugio', 'TX', '78377', '28.3478', '-97.1904');
INSERT INTO `net_city` VALUES ('10699', '23', 'Валайермо', 'Valyermo', 'CA', '93563', '34.3973', '-117.7446');
INSERT INTO `net_city` VALUES ('10703', '23', 'Ньюейго', 'Newaygo', 'MI', '49337', '43.4332', '-85.7110');
INSERT INTO `net_city` VALUES ('10705', '23', 'Мунит', 'Munith', 'MI', '49259', '42.3733', '-84.2585');
INSERT INTO `net_city` VALUES ('10706', '23', 'Дженсен Бич', 'Jensen Beach', 'FL', '34957', '27.2550', '-80.2476');
INSERT INTO `net_city` VALUES ('10710', '23', 'Маренго', 'Marengo', 'IA', '52301', '41.7895', '-92.0896');
INSERT INTO `net_city` VALUES ('10713', '23', 'Инкстер', 'Inkster', 'MI', '48141', '42.2933', '-83.3147');
INSERT INTO `net_city` VALUES ('10714', '23', 'Инман', 'Inman', 'SC', '29349', '35.0484', '-82.0852');
INSERT INTO `net_city` VALUES ('10717', '23', 'Гарнер', 'Garner', 'NC', '27529', '35.6461', '-78.5791');
INSERT INTO `net_city` VALUES ('10718', '23', 'Либерал', 'Liberal', 'KS', '67901', '37.1347', '-100.8862');
INSERT INTO `net_city` VALUES ('10720', '23', 'Лейк-Элмо', 'Lake Elmo', 'MN', '55042', '44.9928', '-92.8988');
INSERT INTO `net_city` VALUES ('10721', '23', 'Стивенсон', 'Stephenson', 'MI', '49887', '45.4459', '-87.4433');
INSERT INTO `net_city` VALUES ('10722', '23', 'Лумис', 'Loomis', 'CA', '95650', '38.8139', '-121.1662');
INSERT INTO `net_city` VALUES ('10726', '23', 'Барнхарт', 'Barnhart', 'MO', '63012', '38.3345', '-90.4462');
INSERT INTO `net_city` VALUES ('10727', '23', 'Уайлдерсвилл', 'Wildersville', 'TN', '38388', '35.7536', '-88.2292');
INSERT INTO `net_city` VALUES ('10735', '23', 'Джеллико', 'Jellico', 'TN', '37762', '36.5203', '-84.1920');
INSERT INTO `net_city` VALUES ('10736', '23', 'Ла Фолетт', 'La Follette', 'TN', '37766', '36.4040', '-84.0721');
INSERT INTO `net_city` VALUES ('10737', '23', 'Ленокс', 'Lenox', 'GA', '31637', '31.2957', '-83.4352');
INSERT INTO `net_city` VALUES ('10738', '23', 'Элбертон', 'Elberton', 'GA', '30635', '34.1302', '-82.8038');
INSERT INTO `net_city` VALUES ('10739', '23', 'Оливер Спрингс', 'Oliver Springs', 'TN', '37840', '36.0522', '-84.3608');
INSERT INTO `net_city` VALUES ('10741', '23', 'Омега', 'Omega', 'GA', '31775', '31.3274', '-83.6051');
INSERT INTO `net_city` VALUES ('10742', '23', 'Эдисто Айленд', 'Edisto Island', 'SC', '29438', '32.5579', '-80.2192');
INSERT INTO `net_city` VALUES ('10746', '23', 'Маршфилд', 'Marshfield', 'MO', '65706', '37.3311', '-92.8818');
INSERT INTO `net_city` VALUES ('10747', '23', 'Мустанг', 'Mustang', 'OK', '73064', '35.3798', '-97.7598');
INSERT INTO `net_city` VALUES ('10751', '23', 'Уиллс Пойнт', 'Wills Point', 'TX', '75169', '32.6993', '-95.9972');
INSERT INTO `net_city` VALUES ('10758', '23', 'Уотсика', 'Watseka', 'IL', '60970', '40.7886', '-87.7481');
INSERT INTO `net_city` VALUES ('10761', '23', 'Коммерс Тауншип', 'Commerce Township', 'MI', '48382', '42.5860', '-83.5006');
INSERT INTO `net_city` VALUES ('10765', '23', 'Мидлвилл', 'Middleville', 'MI', '49333', '42.6862', '-85.4515');
INSERT INTO `net_city` VALUES ('10770', '23', 'Истлейк', 'Eastlake', 'OH', '44095', '41.6502', '-81.4533');
INSERT INTO `net_city` VALUES ('10774', '23', 'Линдсборг', 'Lindsborg', 'KS', '67456', '38.6237', '-97.6876');
INSERT INTO `net_city` VALUES ('10775', '23', 'Бонн Терр', 'Bonne Terre', 'MO', '63628', '37.9450', '-90.5218');
INSERT INTO `net_city` VALUES ('10777', '23', 'Растон', 'Ruston', 'LA', '71270', '32.5151', '-92.6262');
INSERT INTO `net_city` VALUES ('10779', '23', 'Колорадо Сити', 'Colorado City', 'AZ', '86021', '36.9736', '-112.9829');
INSERT INTO `net_city` VALUES ('10780', '23', 'Додсон', 'Dodson', 'LA', '71422', '32.0595', '-92.6445');
INSERT INTO `net_city` VALUES ('10782', '23', 'Дарроу', 'Darrow', 'LA', '70725', '30.1468', '-90.9640');
INSERT INTO `net_city` VALUES ('10788', '23', 'Мишен', 'Mission', 'TX', '78572', '26.1788', '-98.3595');
INSERT INTO `net_city` VALUES ('10791', '23', 'Норманна', 'Normanna', 'TX', '78142', '28.5297', '-97.7822');
INSERT INTO `net_city` VALUES ('10792', '23', 'Перл Ривер', 'Pearl River', 'LA', '70452', '30.4319', '-89.7940');
INSERT INTO `net_city` VALUES ('10801', '23', 'Топанга', 'Topanga', 'CA', '90290', '34.1049', '-118.6089');
INSERT INTO `net_city` VALUES ('10802', '23', 'Уильямсберг', 'Williamsburg', 'KY', '40769', '36.7222', '-84.1660');
INSERT INTO `net_city` VALUES ('10804', '23', 'Небраска Сити', 'Nebraska City', 'NE', '68410', '40.6536', '-95.8784');
INSERT INTO `net_city` VALUES ('10808', '23', 'Уайтривер', 'Whiteriver', 'AZ', '85941', '33.8370', '-109.9643');
INSERT INTO `net_city` VALUES ('10809', '23', 'Ларами', 'Laramie', 'WY', '82070', '41.3386', '-105.8602');
INSERT INTO `net_city` VALUES ('10813', '23', 'Манселона', 'Mancelona', 'MI', '49659', '44.9062', '-85.0293');
INSERT INTO `net_city` VALUES ('10814', '23', 'Белойт', 'Beloit', 'OH', '44609', '40.9083', '-80.9881');
INSERT INTO `net_city` VALUES ('10815', '23', 'Флеминг', 'Fleming', 'OH', '45729', '39.4104', '-81.6077');
INSERT INTO `net_city` VALUES ('10821', '23', 'Эль Серрито', 'El Cerrito', 'CA', '94530', '37.9180', '-122.3032');
INSERT INTO `net_city` VALUES ('10822', '23', 'Ментон', 'Mentone', 'CA', '92359', '34.1044', '-117.0486');
INSERT INTO `net_city` VALUES ('10823', '23', 'Банкер Хилл', 'Bunker Hill', 'IL', '62014', '39.0497', '-89.9513');
INSERT INTO `net_city` VALUES ('10831', '23', 'Брейтуэйт', 'Braithwaite', 'LA', '70040', '29.7065', '-89.9610');
INSERT INTO `net_city` VALUES ('10832', '23', 'Манвел', 'Manvel', 'TX', '77578', '29.4751', '-95.3598');
INSERT INTO `net_city` VALUES ('10835', '23', 'Форни', 'Forney', 'TX', '75126', '32.7380', '-96.4463');
INSERT INTO `net_city` VALUES ('10838', '23', 'Хамшир', 'Hamshire', 'TX', '77622', '29.8647', '-94.2743');
INSERT INTO `net_city` VALUES ('10843', '23', 'Кастровилл', 'Castroville', 'CA', '95012', '36.7619', '-121.7573');
INSERT INTO `net_city` VALUES ('10845', '23', 'Поттер Валли', 'Potter Valley', 'CA', '95469', '39.3776', '-123.0196');
INSERT INTO `net_city` VALUES ('10848', '23', 'Мак-Клауд', 'McCloud', 'CA', '96057', '41.2661', '-122.1076');
INSERT INTO `net_city` VALUES ('10850', '23', 'Келсо', 'Kelso', 'WA', '98626', '46.1491', '-122.8089');
INSERT INTO `net_city` VALUES ('10851', '23', 'Бёрли', 'Burley', 'ID', '83318', '42.3984', '-113.7814');
INSERT INTO `net_city` VALUES ('10854', '23', 'Кейв Джанкшен', 'Cave Junction', 'OR', '97523', '42.1193', '-123.6028');
INSERT INTO `net_city` VALUES ('10859', '23', 'Косциаско', 'Kosciusko', 'MS', '39090', '32.9911', '-89.5168');
INSERT INTO `net_city` VALUES ('10861', '23', 'Эфингем', 'Effingham', 'KS', '66023', '39.5075', '-95.3850');
INSERT INTO `net_city` VALUES ('10862', '23', 'Хайден', 'Higden', 'AR', '72067', '35.5786', '-92.1199');
INSERT INTO `net_city` VALUES ('10865', '23', 'Одубон', 'Audubon', 'NJ', '08106', '39.8913', '-75.0730');
INSERT INTO `net_city` VALUES ('10871', '23', 'Норт Тазуэлл', 'North Tazewell', 'VA', '24630', '37.1784', '-81.4683');
INSERT INTO `net_city` VALUES ('10872', '23', 'Молтон', 'Moulton', 'AL', '35650', '34.4620', '-87.2951');
INSERT INTO `net_city` VALUES ('10873', '23', 'Истабога', 'Eastaboga', 'AL', '36260', '33.6020', '-86.0037');
INSERT INTO `net_city` VALUES ('10874', '23', 'Райзинг Фон', 'Rising Fawn', 'GA', '30738', '34.8021', '-85.4708');
INSERT INTO `net_city` VALUES ('10876', '23', 'Травелерс Рест', 'Travelers Rest', 'SC', '29690', '35.0768', '-82.4361');
INSERT INTO `net_city` VALUES ('10883', '23', 'Найтстаун', 'Knightstown', 'IN', '46148', '39.8154', '-85.5151');
INSERT INTO `net_city` VALUES ('10886', '23', 'Пеотон', 'Peotone', 'IL', '60468', '41.3308', '-87.8018');
INSERT INTO `net_city` VALUES ('10888', '23', 'Плимут', 'Plymouth', 'WI', '53073', '43.7685', '-88.0161');
INSERT INTO `net_city` VALUES ('10889', '23', 'Хортонвилл', 'Hortonville', 'WI', '54944', '44.3162', '-88.6117');
INSERT INTO `net_city` VALUES ('10893', '23', 'Рэймонд', 'Raymond', 'MS', '39154', '32.2180', '-90.4647');
INSERT INTO `net_city` VALUES ('10894', '23', 'Монтесума', 'Montezuma', 'IA', '50171', '41.5914', '-92.5344');
INSERT INTO `net_city` VALUES ('10897', '23', 'Фарнемвилл', 'Farnhamville', 'IA', '50538', '42.2816', '-94.4269');
INSERT INTO `net_city` VALUES ('10901', '23', 'Уайтстаун', 'Whitestown', 'IN', '46075', '40.0196', '-86.3294');
INSERT INTO `net_city` VALUES ('10909', '23', 'Маунт-Вернон', 'Mount Vernon', 'KY', '40456', '37.3446', '-84.3092');
INSERT INTO `net_city` VALUES ('10914', '23', 'Хермоса Бич', 'Hermosa Beach', 'CA', '90254', '33.8649', '-118.3971');
INSERT INTO `net_city` VALUES ('10917', '23', 'Крандалл', 'Crandall', 'TX', '75114', '32.5927', '-96.4314');
INSERT INTO `net_city` VALUES ('10918', '23', 'Гленко', 'Glencoe', 'IL', '60022', '42.1306', '-87.7678');
INSERT INTO `net_city` VALUES ('10919', '23', 'Сан-Андреас', 'San Andreas', 'CA', '95249', '38.2068', '-120.6214');
INSERT INTO `net_city` VALUES ('10922', '23', 'Тобиханна', 'Tobyhanna', 'PA', '18466', '41.1880', '-75.3804');
INSERT INTO `net_city` VALUES ('10924', '23', 'Резеда', 'Reseda', 'CA', '91335', '34.2005', '-118.5404');
INSERT INTO `net_city` VALUES ('10925', '23', 'Солана Бич', 'Solana Beach', 'CA', '92075', '32.9959', '-117.2571');
INSERT INTO `net_city` VALUES ('10928', '23', 'Фулшир', 'Fulshear', 'TX', '77441', '29.7018', '-95.9138');
INSERT INTO `net_city` VALUES ('10930', '23', 'Тайнгсборо', 'Tyngsboro', 'MA', '01879', '42.6590', '-71.4484');
INSERT INTO `net_city` VALUES ('10936', '23', 'Хансевилл', 'Hanceville', 'AL', '35077', '34.0040', '-86.8316');
INSERT INTO `net_city` VALUES ('10938', '23', 'Истанолли', 'Eastanollee', 'GA', '30538', '34.4990', '-83.2700');
INSERT INTO `net_city` VALUES ('10939', '23', 'Кисвилл', 'Keysville', 'GA', '30816', '33.1616', '-82.1593');
INSERT INTO `net_city` VALUES ('10941', '23', 'Камила', 'Camilla', 'GA', '31730', '31.2154', '-84.2685');
INSERT INTO `net_city` VALUES ('10942', '23', 'Флауэри Бранч', 'Flowery Branch', 'GA', '30542', '34.1675', '-83.9120');
INSERT INTO `net_city` VALUES ('10943', '23', 'Малга', 'Mulga', 'AL', '35118', '33.5347', '-87.0583');
INSERT INTO `net_city` VALUES ('10944', '23', 'Фармерсвилл', 'Farmersville', 'CA', '93223', '36.3086', '-119.1939');
INSERT INTO `net_city` VALUES ('10947', '23', 'Табак', 'Tubac', 'AZ', '85646', '31.6126', '-111.0459');
INSERT INTO `net_city` VALUES ('10948', '23', 'Майами', 'Miami', 'AZ', '85539', '33.4096', '-110.9775');
INSERT INTO `net_city` VALUES ('10950', '23', 'Лейксайд Марблхед', 'Lakeside Marblehead', 'OH', '43440', '41.5278', '-82.7810');
INSERT INTO `net_city` VALUES ('10955', '23', 'Гарден Валли', 'Garden Valley', 'CA', '95633', '38.8495', '-120.8392');
INSERT INTO `net_city` VALUES ('10958', '23', 'Бронсон', 'Bronson', 'MI', '49028', '41.8724', '-85.1659');
INSERT INTO `net_city` VALUES ('10959', '23', 'Лиссабон', 'Lisbon', 'OH', '44432', '40.7442', '-80.7546');
INSERT INTO `net_city` VALUES ('10961', '23', 'Мурсвилл', 'Mooresville', 'IN', '46158', '39.5825', '-86.3679');
INSERT INTO `net_city` VALUES ('10962', '23', 'Нью Стантон', 'New Stanton', 'PA', '15672', '40.2387', '-79.6291');
INSERT INTO `net_city` VALUES ('10967', '23', 'Террелл', 'Turrell', 'AR', '72384', '35.3690', '-90.2465');
INSERT INTO `net_city` VALUES ('10969', '23', 'Гилман', 'Gilman', 'IL', '60938', '40.7749', '-87.9946');
INSERT INTO `net_city` VALUES ('10970', '23', 'Хилсвилл', 'Hillsville', 'VA', '24343', '36.7804', '-80.7091');
INSERT INTO `net_city` VALUES ('10973', '23', 'Гровер', 'Grover', 'MO', '63040', '38.5722', '-90.6279');
INSERT INTO `net_city` VALUES ('10974', '23', 'Кабот', 'Cabot', 'AR', '72023', '34.9461', '-92.0858');
INSERT INTO `net_city` VALUES ('10978', '23', 'Опелусас', 'Opelousas', 'LA', '70570', '30.5335', '-92.1163');
INSERT INTO `net_city` VALUES ('10979', '23', 'Кеннер', 'Kenner', 'LA', '70062', '29.9894', '-90.2529');
INSERT INTO `net_city` VALUES ('10983', '23', 'Фэрхоп', 'Fairhope', 'AL', '36532', '30.4798', '-87.8658');
INSERT INTO `net_city` VALUES ('10984', '23', 'Леандер', 'Leander', 'TX', '78641', '30.5423', '-97.9176');
INSERT INTO `net_city` VALUES ('10985', '23', 'Сейнт Мартинвилл', 'Saint Martinville', 'LA', '70582', '30.1745', '-91.7777');
INSERT INTO `net_city` VALUES ('10986', '23', 'Айова', 'Iowa', 'LA', '70647', '30.2435', '-93.0092');
INSERT INTO `net_city` VALUES ('10987', '23', 'Порт Боливар', 'Port Bolivar', 'TX', '77650', '29.4260', '-94.6977');
INSERT INTO `net_city` VALUES ('10989', '23', 'Коттондейл', 'Cottondale', 'AL', '35453', '33.1730', '-87.3874');
INSERT INTO `net_city` VALUES ('10992', '23', 'Маллинс', 'Mullins', 'SC', '29574', '34.1632', '-79.2574');
INSERT INTO `net_city` VALUES ('10993', '23', 'Чилдерсберг', 'Childersburg', 'AL', '35044', '33.2591', '-86.3628');
INSERT INTO `net_city` VALUES ('10994', '23', 'Глен Жан', 'Glen Jean', 'WV', '25846', '37.9265', '-81.1501');
INSERT INTO `net_city` VALUES ('10996', '23', 'Таскджи', 'Tuskegee', 'AL', '36083', '32.3807', '-85.6808');
INSERT INTO `net_city` VALUES ('10997', '23', 'Мейплсвилл', 'Maplesville', 'AL', '36750', '32.7827', '-86.8589');
INSERT INTO `net_city` VALUES ('10999', '23', 'Сельма', 'Selma', 'AL', '36701', '32.5237', '-87.0965');
INSERT INTO `net_city` VALUES ('11002', '23', 'Берриен Спрингс', 'Berrien Springs', 'MI', '49103', '41.9599', '-86.3932');
INSERT INTO `net_city` VALUES ('11003', '23', 'Арджей', 'Arjay', 'KY', '40902', '36.8567', '-83.6328');
INSERT INTO `net_city` VALUES ('11006', '23', 'Тоивола', 'Toivola', 'MI', '49965', '46.9589', '-88.7752');
INSERT INTO `net_city` VALUES ('11008', '23', 'Колома', 'Coloma', 'WI', '54930', '44.0238', '-89.5699');
INSERT INTO `net_city` VALUES ('11015', '23', 'Кейн', 'Kane', 'PA', '16735', '41.6182', '-78.7831');
INSERT INTO `net_city` VALUES ('11018', '23', 'Честерленд', 'Chesterland', 'OH', '44026', '41.5348', '-81.3171');
INSERT INTO `net_city` VALUES ('11022', '23', 'Шафтер', 'Shafter', 'CA', '93263', '35.4961', '-119.3006');
INSERT INTO `net_city` VALUES ('11023', '23', 'Фейетвилл', 'Fayetteville', 'GA', '30214', '33.4811', '-84.4798');
INSERT INTO `net_city` VALUES ('11026', '23', 'Дадевилл', 'Dadeville', 'AL', '36853', '32.7968', '-85.7585');
INSERT INTO `net_city` VALUES ('11028', '23', 'Хупа', 'Hoopa', 'CA', '95546', '41.1143', '-123.6431');
INSERT INTO `net_city` VALUES ('11030', '23', 'Брейнингсвилл', 'Breinigsville', 'PA', '18031', '40.5489', '-75.6658');
INSERT INTO `net_city` VALUES ('11033', '23', 'Ладога', 'Ladoga', 'IN', '47954', '39.9099', '-86.8254');
INSERT INTO `net_city` VALUES ('11035', '23', 'Кио', 'Keaau', 'HI', '96749', '19.5846', '-155.0242');
INSERT INTO `net_city` VALUES ('11036', '23', 'Арката', 'Arcata', 'CA', '95521', '40.8536', '-124.0502');
INSERT INTO `net_city` VALUES ('11038', '23', 'Ирмо', 'Irmo', 'SC', '29063', '34.1422', '-81.2047');
INSERT INTO `net_city` VALUES ('11039', '23', 'Санти', 'Santee', 'SC', '29142', '33.4642', '-80.4486');
INSERT INTO `net_city` VALUES ('11043', '23', 'Семмс', 'Semmes', 'AL', '36575', '30.7564', '-88.2723');
INSERT INTO `net_city` VALUES ('11046', '23', 'Маратон', 'Marathon', 'FL', '33050', '24.7163', '-81.0767');
INSERT INTO `net_city` VALUES ('11049', '23', 'Боулдер', 'Boulder', 'MT', '59632', '46.1766', '-111.9930');
INSERT INTO `net_city` VALUES ('11055', '23', 'Вирден', 'Virden', 'IL', '62690', '39.5011', '-89.7482');
INSERT INTO `net_city` VALUES ('11056', '23', 'Санрайз Бич', 'Sunrise Beach', 'MO', '65079', '38.1480', '-92.7448');
INSERT INTO `net_city` VALUES ('11057', '23', 'Неога', 'Neoga', 'IL', '62447', '39.3103', '-88.4485');
INSERT INTO `net_city` VALUES ('11062', '23', 'Саут-Джордан', 'South Jordan', 'UT', '84095', '40.5598', '-111.9665');
INSERT INTO `net_city` VALUES ('11067', '23', 'Рофф', 'Roff', 'OK', '74865', '34.6221', '-96.8200');
INSERT INTO `net_city` VALUES ('11068', '23', 'Локхарт', 'Lockhart', 'TX', '78644', '29.8973', '-97.6783');
INSERT INTO `net_city` VALUES ('11070', '23', 'Флойдада', 'Floydada', 'TX', '79235', '33.9468', '-101.2555');
INSERT INTO `net_city` VALUES ('11073', '23', 'Хермли', 'Hermleigh', 'TX', '79526', '32.6949', '-100.6943');
INSERT INTO `net_city` VALUES ('11075', '23', 'Гарднер', 'Gardner', 'KS', '66030', '38.8077', '-94.9452');
INSERT INTO `net_city` VALUES ('11076', '23', 'Уэллсвилл', 'Wellsville', 'KS', '66092', '38.7049', '-95.1114');
INSERT INTO `net_city` VALUES ('11081', '23', 'Пулер', 'Pooler', 'GA', '31322', '32.0957', '-81.2531');
INSERT INTO `net_city` VALUES ('11084', '23', 'Крофордсвилл', 'Crawfordville', 'FL', '32327', '30.1755', '-84.3386');
INSERT INTO `net_city` VALUES ('11088', '23', 'Китвилл', 'Keithville', 'LA', '71047', '32.3049', '-93.8978');
INSERT INTO `net_city` VALUES ('11093', '23', 'Орфордвилл', 'Orfordville', 'WI', '53576', '42.6288', '-89.2300');
INSERT INTO `net_city` VALUES ('11103', '23', 'Гринуэлл Спрингс', 'Greenwell Springs', 'LA', '70739', '30.5919', '-90.9913');
INSERT INTO `net_city` VALUES ('11104', '23', 'Квемадо', 'Quemado', 'TX', '78877', '28.9258', '-100.5908');
INSERT INTO `net_city` VALUES ('11105', '23', 'Беллвилл', 'Bellville', 'TX', '77418', '29.9756', '-96.2847');
INSERT INTO `net_city` VALUES ('11107', '23', 'Винтон', 'Vinton', 'LA', '70668', '30.1875', '-93.5964');
INSERT INTO `net_city` VALUES ('11111', '23', 'Этель', 'Ethel', 'LA', '70730', '30.8210', '-91.1121');
INSERT INTO `net_city` VALUES ('11116', '23', 'Торнвилл', 'Thornville', 'OH', '43076', '39.8896', '-82.3735');
INSERT INTO `net_city` VALUES ('11119', '23', 'Кловердейл', 'Cloverdale', 'OH', '45827', '41.0055', '-84.2989');
INSERT INTO `net_city` VALUES ('11128', '23', 'Хейверстро', 'Haverstraw', 'NY', '10927', '41.1901', '-73.9647');
INSERT INTO `net_city` VALUES ('11129', '23', 'Смиттаун', 'Smithtown', 'NY', '11787', '40.8594', '-73.2121');
INSERT INTO `net_city` VALUES ('11139', '23', 'Себуэйнг', 'Sebewaing', 'MI', '48759', '43.7396', '-83.3934');
INSERT INTO `net_city` VALUES ('11144', '23', 'Миноккуа', 'Minocqua', 'WI', '54548', '45.8639', '-89.8223');
INSERT INTO `net_city` VALUES ('11146', '23', 'Гардендейл', 'Gardendale', 'AL', '35071', '33.7061', '-86.8238');
INSERT INTO `net_city` VALUES ('11149', '23', 'Сан Хуан', 'San Juan', 'TX', '78589', '26.1664', '-98.1518');
INSERT INTO `net_city` VALUES ('11150', '23', 'Дибервилл', 'D\'iberville', 'MS', '39540', '30.4438', '-88.9008');
INSERT INTO `net_city` VALUES ('11152', '23', 'Уолнат-Гров', 'Walnut Grove', 'MS', '39189', '32.5956', '-89.4119');
INSERT INTO `net_city` VALUES ('11157', '23', 'Натчиточес', 'Natchitoches', 'LA', '71457', '31.6835', '-93.1197');
INSERT INTO `net_city` VALUES ('11159', '23', 'Трой', 'Troy', 'NY', '12180', '42.7495', '-73.5951');
INSERT INTO `net_city` VALUES ('11161', '23', 'Форт Люптон', 'Fort Lupton', 'CO', '80621', '40.1099', '-104.7863');
INSERT INTO `net_city` VALUES ('11165', '23', 'Ван', 'Van', 'TX', '75790', '32.5271', '-95.6376');
INSERT INTO `net_city` VALUES ('11168', '23', 'Уотсонтаун', 'Watsontown', 'PA', '17777', '41.1071', '-76.8153');
INSERT INTO `net_city` VALUES ('11169', '23', 'Пеквот-Лейкс', 'Pequot Lakes', 'MN', '56472', '46.5430', '-94.3360');
INSERT INTO `net_city` VALUES ('11170', '23', 'Аделанто', 'Adelanto', 'CA', '92301', '34.6647', '-117.5121');
INSERT INTO `net_city` VALUES ('11176', '23', 'Джермин', 'Jermyn', 'PA', '18433', '41.5788', '-75.5783');
INSERT INTO `net_city` VALUES ('11181', '23', 'Диккерсон', 'Dickerson', 'MD', '20842', '39.2043', '-77.4198');
INSERT INTO `net_city` VALUES ('11182', '23', 'Кемптон', 'Kempton', 'PA', '19529', '40.6426', '-75.8606');
INSERT INTO `net_city` VALUES ('11191', '23', 'Лакассин', 'Lacassine', 'LA', '70650', '30.2391', '-92.9090');
INSERT INTO `net_city` VALUES ('11192', '23', 'Пенитас', 'Penitas', 'TX', '78576', '26.2306', '-98.4447');
INSERT INTO `net_city` VALUES ('11195', '23', 'Монмут', 'Monmouth', 'IL', '61462', '40.9263', '-90.6713');
INSERT INTO `net_city` VALUES ('11205', '23', 'Серс', 'Ceres', 'CA', '95307', '37.5566', '-120.9680');
INSERT INTO `net_city` VALUES ('11206', '23', 'Кэпитола', 'Capitola', 'CA', '95010', '36.9760', '-121.9536');
INSERT INTO `net_city` VALUES ('11208', '23', 'Льюисберг', 'Lewisburg', 'TN', '37091', '35.4724', '-86.7524');
INSERT INTO `net_city` VALUES ('11209', '23', 'Ашберн', 'Ashburn', 'GA', '31714', '31.7038', '-83.6753');
INSERT INTO `net_city` VALUES ('11210', '23', 'Лисвилл', 'Leesville', 'SC', '29070', '33.8892', '-81.4341');
INSERT INTO `net_city` VALUES ('11212', '23', 'Ипсуич', 'Ipswich', 'MA', '01938', '42.6825', '-70.8470');
INSERT INTO `net_city` VALUES ('11215', '23', 'Анджелс Кэмп', 'Angels Camp', 'CA', '95222', '38.0468', '-120.6134');
INSERT INTO `net_city` VALUES ('11218', '23', 'Холи', 'Hawley', 'TX', '79525', '32.6347', '-99.8297');
INSERT INTO `net_city` VALUES ('11221', '23', 'Гибстаун', 'Gibbstown', 'NJ', '08027', '39.8192', '-75.2872');
INSERT INTO `net_city` VALUES ('11223', '23', 'Лавленд', 'Loveland', 'OH', '45140', '39.2549', '-84.2391');
INSERT INTO `net_city` VALUES ('11224', '23', 'Бурго', 'Burgaw', 'NC', '28425', '34.5521', '-77.9068');
INSERT INTO `net_city` VALUES ('11225', '23', 'Джаспер', 'Jasper', 'AL', '35503', '33.9370', '-87.3024');
INSERT INTO `net_city` VALUES ('11226', '23', 'Спрус Пайн', 'Spruce Pine', 'NC', '28777', '35.9117', '-82.0671');
INSERT INTO `net_city` VALUES ('11231', '23', 'Найантик', 'Niantic', 'CT', '06357', '41.3277', '-72.2177');
INSERT INTO `net_city` VALUES ('11234', '23', 'Сентревилл', 'Centreville', 'MS', '39631', '31.0965', '-91.0872');
INSERT INTO `net_city` VALUES ('11235', '23', 'Марфа', 'Marfa', 'TX', '79843', '30.1828', '-104.3885');
INSERT INTO `net_city` VALUES ('11237', '23', 'Пирсолл', 'Pearsall', 'TX', '78061', '28.8683', '-99.1074');
INSERT INTO `net_city` VALUES ('11243', '23', 'Лак дю Фламбо', 'Lac du Flambeau', 'WI', '54538', '45.9580', '-89.9082');
INSERT INTO `net_city` VALUES ('11246', '23', 'Уэстовер', 'Westover', 'MD', '21871', '38.1073', '-75.7442');
INSERT INTO `net_city` VALUES ('11248', '23', 'Бордентаун', 'Bordentown', 'NJ', '08505', '40.1005', '-74.7203');
INSERT INTO `net_city` VALUES ('11250', '23', 'Эдгар', 'Edgar', 'FL', '32149', '29.6193', '-81.8979');
INSERT INTO `net_city` VALUES ('11258', '23', 'Эвергрин', 'Evergreen', 'AL', '36401', '31.5043', '-86.9343');
INSERT INTO `net_city` VALUES ('11260', '23', 'Сардис', 'Sardis', 'OH', '43946', '39.6490', '-80.9670');
INSERT INTO `net_city` VALUES ('11264', '23', 'Иука', 'Iuka', 'MS', '38852', '34.8287', '-88.2108');
INSERT INTO `net_city` VALUES ('11265', '23', 'Амори', 'Amory', 'MS', '38821', '33.9454', '-88.4080');
INSERT INTO `net_city` VALUES ('11267', '23', 'Симсборо', 'Simsboro', 'LA', '71275', '32.5042', '-92.8161');
INSERT INTO `net_city` VALUES ('11271', '23', 'Оссипи', 'Ossipee', 'NH', '03864', '43.6927', '-71.1177');
INSERT INTO `net_city` VALUES ('11278', '23', 'Калумет', 'Calumet', 'MI', '49913', '47.2426', '-88.4382');
INSERT INTO `net_city` VALUES ('11279', '23', 'Манистик', 'Manistique', 'MI', '49854', '46.0442', '-86.3025');
INSERT INTO `net_city` VALUES ('11283', '23', 'Броли', 'Brawley', 'CA', '92227', '33.0276', '-115.4511');
INSERT INTO `net_city` VALUES ('11284', '23', 'Калистога', 'Calistoga', 'CA', '94515', '38.6253', '-122.6159');
INSERT INTO `net_city` VALUES ('11286', '23', 'Фильмор', 'Fillmore', 'CA', '93015', '34.4021', '-118.8395');
INSERT INTO `net_city` VALUES ('11288', '23', 'Эмметт', 'Emmett', 'ID', '83617', '43.9865', '-116.5246');
INSERT INTO `net_city` VALUES ('11289', '23', 'Онтарио', 'Ontario', 'OR', '97914', '44.0861', '-117.0188');
INSERT INTO `net_city` VALUES ('11291', '23', 'Скайкомиш', 'Skykomish', 'WA', '98288', '47.6493', '-121.3316');
INSERT INTO `net_city` VALUES ('11292', '23', 'Маршалл', 'Marshall', 'MO', '65340', '39.0866', '-93.1495');
INSERT INTO `net_city` VALUES ('11293', '23', 'Блэкуэлл', 'Blackwell', 'OK', '74631', '36.7875', '-97.3007');
INSERT INTO `net_city` VALUES ('11305', '23', 'Талладега', 'Talladega', 'AL', '35160', '33.3782', '-86.1034');
INSERT INTO `net_city` VALUES ('11309', '23', 'Таллапуза', 'Tallapoosa', 'GA', '30176', '33.7859', '-85.2896');
INSERT INTO `net_city` VALUES ('11310', '23', 'Ньюберри', 'Newberry', 'SC', '29108', '34.2767', '-81.6365');
INSERT INTO `net_city` VALUES ('11313', '23', 'Лайлс', 'Lyles', 'TN', '37098', '35.8669', '-87.3081');
INSERT INTO `net_city` VALUES ('11314', '23', 'Диринг', 'Dearing', 'GA', '30808', '33.3901', '-82.3835');
INSERT INTO `net_city` VALUES ('11315', '23', 'Корнерсвилл', 'Cornersville', 'TN', '37047', '35.3223', '-86.8291');
INSERT INTO `net_city` VALUES ('11319', '23', 'Брент', 'Brent', 'AL', '35034', '32.9088', '-87.2644');
INSERT INTO `net_city` VALUES ('11321', '23', 'Ньюпорт', 'Newport', 'TN', '37821', '35.9496', '-83.1866');
INSERT INTO `net_city` VALUES ('11323', '23', 'Ирика', 'Yreka', 'CA', '96097', '41.7511', '-122.6727');
INSERT INTO `net_city` VALUES ('11324', '23', 'Уэст Уэндовер', 'West Wendover', 'NV', '89883', '40.7391', '-114.0733');
INSERT INTO `net_city` VALUES ('11325', '23', 'Шелли', 'Shelley', 'ID', '83274', '43.3419', '-112.0712');
INSERT INTO `net_city` VALUES ('11328', '23', 'Ломета', 'Lometa', 'TX', '76853', '31.2501', '-98.3808');
INSERT INTO `net_city` VALUES ('11329', '23', 'Рокдейл', 'Rockdale', 'TX', '76567', '30.6448', '-97.0448');
INSERT INTO `net_city` VALUES ('11330', '23', 'Канейдиан', 'Canadian', 'TX', '79014', '35.9468', '-100.2736');
INSERT INTO `net_city` VALUES ('11332', '23', 'Маршолтаун', 'Marshalltown', 'IA', '50158', '42.0542', '-92.9305');
INSERT INTO `net_city` VALUES ('11335', '23', 'Нью Смирна Бич', 'New Smyrna Beach', 'FL', '32168', '28.9970', '-81.0563');
INSERT INTO `net_city` VALUES ('11340', '23', 'Медфилд', 'Medfield', 'MA', '02052', '42.1820', '-71.3100');
INSERT INTO `net_city` VALUES ('11342', '23', 'Ройерсфорд', 'Royersford', 'PA', '19468', '40.2040', '-75.5381');
INSERT INTO `net_city` VALUES ('11343', '23', 'Уайт Сити', 'White City', 'OR', '97503', '42.5650', '-122.9219');
INSERT INTO `net_city` VALUES ('11344', '23', 'Лейк-Хавасу-Сити', 'Lake Havasu City', 'AZ', '86403', '34.4849', '-114.3286');
INSERT INTO `net_city` VALUES ('11349', '23', 'Форт Монтгомери', 'Fort Montgomery', 'NY', '10922', '41.3315', '-73.9868');
INSERT INTO `net_city` VALUES ('11350', '23', 'Маркл', 'Markle', 'IN', '46770', '40.8530', '-85.2987');
INSERT INTO `net_city` VALUES ('11352', '23', 'Лон Ок', 'Lone Oak', 'TX', '75453', '32.9807', '-95.9086');
INSERT INTO `net_city` VALUES ('11355', '23', 'Кастаик', 'Castaic', 'CA', '91384', '34.5102', '-118.6804');
INSERT INTO `net_city` VALUES ('11356', '23', 'Делано', 'Delano', 'CA', '93215', '35.7833', '-119.2361');
INSERT INTO `net_city` VALUES ('11358', '23', 'Монтевалло', 'Montevallo', 'AL', '35115', '33.1071', '-86.9032');
INSERT INTO `net_city` VALUES ('11362', '23', 'Сенатобия', 'Senatobia', 'MS', '38668', '34.6170', '-89.9080');
INSERT INTO `net_city` VALUES ('11366', '24', 'Торонто', 'Toronto', 'ON', 'm5s1c1', '43.6667', '-79.4167');
INSERT INTO `net_city` VALUES ('11376', '24', 'Парксвилл', 'Parksville', 'BC', 'v9p2h5', '49.3000', '-124.3167');
INSERT INTO `net_city` VALUES ('11386', '24', 'Эдмонтон', 'Edmonton', 'AB', 't6h5x2', '53.5500', '-113.5000');
INSERT INTO `net_city` VALUES ('11390', '23', 'Посдем', 'Potsdam', 'NY', '13676', '44.6609', '-74.9258');
INSERT INTO `net_city` VALUES ('11404', '24', 'Ванкувер', 'Vancouver', 'BC', 'v6b5k3', '49.2500', '-123.1333');
INSERT INTO `net_city` VALUES ('11421', '24', 'Саскатун', 'Saskatoon', 'SK', 's7n4l5', '52.1333', '-106.6667');
INSERT INTO `net_city` VALUES ('11428', '23', 'Далгрен', 'Dahlgren', 'VA', '22448', '38.3404', '-77.0327');
INSERT INTO `net_city` VALUES ('11441', '24', 'Лондон', 'London', 'ON', 'n6a5b7', '42.9833', '-81.2500');
INSERT INTO `net_city` VALUES ('11456', '23', 'Сокорро', 'Socorro', 'NM', '87801', '33.8974', '-107.0261');
INSERT INTO `net_city` VALUES ('11462', '24', 'Галифакс', 'Halifax', 'NS', 'b3h4h8', '44.6500', '-63.6000');
INSERT INTO `net_city` VALUES ('11466', '23', 'Прейри Вью', 'Prairie View', 'TX', '77446', '30.0828', '-95.9863');
INSERT INTO `net_city` VALUES ('11477', '23', 'Йорктаун Хайтс', 'Yorktown Heights', 'NY', '10598', '41.2864', '-73.7908');
INSERT INTO `net_city` VALUES ('11480', '23', 'Варшава', 'Warsaw', 'NY', '14569', '42.7401', '-78.1648');
INSERT INTO `net_city` VALUES ('11482', '23', 'Норт Тонаванда', 'North Tonawanda', 'NY', '14120', '43.0708', '-78.8201');
INSERT INTO `net_city` VALUES ('11490', '23', 'Сент-Олбанс', 'Saint Albans', 'NY', '11412', '40.6966', '-73.7604');
INSERT INTO `net_city` VALUES ('11498', '23', 'Стони Брук', 'Stony Brook', 'NY', '11794', '40.9223', '-72.6371');
INSERT INTO `net_city` VALUES ('11506', '23', 'Нотр Дам', 'Notre Dame', 'IN', '46556', '41.7007', '-86.2501');
INSERT INTO `net_city` VALUES ('11513', '24', 'Ватерлоо', 'Waterloo (Ontario)', 'ON', 'n2l3g1', '43.4665', '-80.5023');
INSERT INTO `net_city` VALUES ('11514', '23', 'Копиаг', 'Copiague', 'NY', '11726', '40.6788', '-73.3942');
INSERT INTO `net_city` VALUES ('11526', '23', 'Ороно', 'Orono', 'ME', '04469', '45.0028', '-68.6334');
INSERT INTO `net_city` VALUES ('11527', '24', 'Гамильтон', 'Hamilton', 'ON', 'l8s4m1', '43.2561', '-79.8575');
INSERT INTO `net_city` VALUES ('11529', '24', 'Кингстон ', 'Kingston (Ontario)', 'ON', '', '44.2202', '-76.5849');
INSERT INTO `net_city` VALUES ('11539', '24', 'Виннипег', 'Winnipeg', 'MB', 'r3t2n2', '49.8833', '-97.1667');
INSERT INTO `net_city` VALUES ('11561', '23', 'Нортфилд', 'Northfield', 'MN', '55057', '44.4614', '-93.2007');
INSERT INTO `net_city` VALUES ('11569', '24', 'Гуэлф', 'Guelph', 'ON', 'n1g2w1', '43.5500', '-80.2500');
INSERT INTO `net_city` VALUES ('11571', '23', 'Монтерей', 'Monterey', 'CA', '93943', '36.3543', '-121.1329');
INSERT INTO `net_city` VALUES ('11573', '23', 'Саут Кингстаун', 'South Kingstown', 'RI', '02881', '41.4773', '-71.5208');
INSERT INTO `net_city` VALUES ('11579', '24', 'Вулфвилл', 'Wolfville', 'NS', 'b4p2r6', '45.0467', '-64.3502');
INSERT INTO `net_city` VALUES ('11580', '24', 'Калгари', 'Calgary', 'AB', 't2a7r9', '51.0833', '-114.0833');
INSERT INTO `net_city` VALUES ('11585', '24', 'Варен', 'Varennes', 'QC', 'j3x1s1', '45.6833', '-73.4333');
INSERT INTO `net_city` VALUES ('11587', '24', 'Фредериктон', 'Fredericton', 'NB', 'e3b5a3', '45.9106', '-66.6586');
INSERT INTO `net_city` VALUES ('11593', '23', 'Нортгемптон', 'Northampton', 'MA', '01063', '42.3179', '-72.6402');
INSERT INTO `net_city` VALUES ('11594', '24', 'Атабаска', 'Athabasca', 'AB', 't9s3a3', '54.7167', '-113.2667');
INSERT INTO `net_city` VALUES ('11595', '24', 'Дорваль', 'Dorval', 'QC', 'h9p1j3', '45.4500', '-73.7500');
INSERT INTO `net_city` VALUES ('11617', '23', 'Саутбридж', 'Southbridge', 'MA', '01550', '42.0707', '-72.0440');
INSERT INTO `net_city` VALUES ('11632', '24', 'Монреаль', 'Montreal', 'QC', 'h3a1b9', '45.5000', '-73.5833');
INSERT INTO `net_city` VALUES ('11633', '24', 'Квебек', 'Quebec City', 'QC', 'g1k7p4', '46.8000', '-71.2500');
INSERT INTO `net_city` VALUES ('11638', '24', 'Труа-Ривьер', 'Trois-Rivieres', 'QC', 'g9a5h7', '46.3500', '-72.5500');
INSERT INTO `net_city` VALUES ('11639', '24', 'Шербрук', 'Sherbrooke (Quebec)', 'QC', 'j1k2r1', '45.4000', '-71.9000');
INSERT INTO `net_city` VALUES ('11641', '24', 'Шикутими', 'Chicoutimi', 'QC', 'g7h2b1', '48.4333', '-71.0667');
INSERT INTO `net_city` VALUES ('11642', '24', 'Гатино', 'Gatineau', 'QC', 'j8x3x7', '45.4833', '-75.6500');
INSERT INTO `net_city` VALUES ('11644', '24', 'Римуски', 'Rimouski', 'QC', 'g5l3a1', '48.4333', '-68.5167');
INSERT INTO `net_city` VALUES ('11677', '23', 'Сидар Фолс', 'Cedar Falls', 'IA', '50614', '42.4698', '-92.3095');
INSERT INTO `net_city` VALUES ('11680', '23', 'Клермонт', 'Claremont', 'CA', '91711', '34.1223', '-117.7143');
INSERT INTO `net_city` VALUES ('11695', '24', 'Воган', 'Vaughan', 'ON', 'm3k1y5', '43.7167', '-79.4833');
INSERT INTO `net_city` VALUES ('11699', '23', 'Мосс Ландинг', 'Moss Landing', 'CA', '95039', '36.8468', '-121.7758');
INSERT INTO `net_city` VALUES ('11706', '23', 'Смитсберг', 'Smithsburg', 'MD', '21783', '39.6488', '-77.5619');
INSERT INTO `net_city` VALUES ('11716', '1', 'Брисбен', 'Brisbane', '04', '', '-27.4710', '153.0243');
INSERT INTO `net_city` VALUES ('11717', '59', 'Эбикон', 'Ebikon', '11', '', '47.0794', '8.3404');
INSERT INTO `net_city` VALUES ('11720', '23', 'Халфуэй', 'Halfway', 'OR', '97834', '44.9461', '-117.1082');
INSERT INTO `net_city` VALUES ('11725', '23', 'Нью Палц', 'New Paltz', 'NY', '12561', '41.7583', '-74.0657');
INSERT INTO `net_city` VALUES ('11726', '23', 'Уотервилл', 'Waterville', 'ME', '04901', '44.5616', '-69.5559');
INSERT INTO `net_city` VALUES ('11727', '24', 'Шарлоттаун ', 'Charlottetown (Prince Edward Island)', 'PE', 'c1a4p3', '46.2382', '-63.1395');
INSERT INTO `net_city` VALUES ('11732', '24', 'Бернаби', 'Burnaby', 'BC', 'v5n4n2', '49.2500', '-122.9500');
INSERT INTO `net_city` VALUES ('11733', '24', 'Дьеп', 'Dieppe', 'NB', 'e1a4x5', '46.1000', '-64.7500');
INSERT INTO `net_city` VALUES ('11735', '24', 'Дартмут', 'Dartmouth', 'NS', 'b3a4k7', '44.6667', '-63.5667');
INSERT INTO `net_city` VALUES ('11739', '24', 'Сидней', 'Sydney', 'NS', 'b1p6s9', '46.1500', '-60.1667');
INSERT INTO `net_city` VALUES ('11747', '24', 'Виндзор ', 'Windsor (Ontario)', 'ON', 'n9b3p4', '42.3016', '-83.0307');
INSERT INTO `net_city` VALUES ('11748', '23', 'Брукингс', 'Brookings', 'SD', '57007', '44.3697', '-96.7907');
INSERT INTO `net_city` VALUES ('11751', '23', 'Дженесео', 'Geneseo', 'NY', '14454', '42.7812', '-77.7778');
INSERT INTO `net_city` VALUES ('11764', '23', 'Ривертон', 'Riverton', 'WY', '82501', '42.9200', '-108.0467');
INSERT INTO `net_city` VALUES ('11767', '23', 'Шеридан', 'Sheridan', 'WY', '82801', '44.7777', '-106.8386');
INSERT INTO `net_city` VALUES ('11768', '23', 'Рок-Спрингс', 'Rock Springs', 'WY', '82901', '41.5159', '-108.9942');
INSERT INTO `net_city` VALUES ('11769', '23', 'Кочайти Пуэбло', 'Cochiti Pueblo', 'NM', '87072', '35.6075', '-106.3473');
INSERT INTO `net_city` VALUES ('11778', '24', 'Сент-Джон', 'Saint John', 'NB', 'e2l4l5', '45.2308', '-66.0953');
INSERT INTO `net_city` VALUES ('11781', '23', 'Морхед', 'Moorhead', 'MN', '56560', '46.8464', '-96.7451');
INSERT INTO `net_city` VALUES ('11793', '23', 'Сент-Питер', 'Saint Peter', 'MN', '56082', '44.3341', '-94.0617');
INSERT INTO `net_city` VALUES ('11798', '23', 'Гамбьер', 'Gambier', 'OH', '43022', '40.3364', '-82.3484');
INSERT INTO `net_city` VALUES ('11800', '24', 'Банкрофт', 'Bancroft', 'ON', 'k0l1c0', '45.0500', '-77.8500');
INSERT INTO `net_city` VALUES ('11802', '24', 'Саквилл', 'Sackville', 'NB', 'e0a3c0', '45.9004', '-64.3708');
INSERT INTO `net_city` VALUES ('11817', '23', 'Гринап', 'Greenup', 'KY', '41144', '38.5506', '-82.9032');
INSERT INTO `net_city` VALUES ('11873', '24', 'Уинфилд', 'Winfield', 'BC', 'v4v1s7', '50.0200', '-119.4100');
INSERT INTO `net_city` VALUES ('11874', '24', 'Сидни', 'Sidney', 'BC', 'v8l1w3', '48.6500', '-123.4167');
INSERT INTO `net_city` VALUES ('11876', '24', 'Ред-Дир', 'Red Deer', 'AB', 't4s1a6', '52.2667', '-113.8000');
INSERT INTO `net_city` VALUES ('11878', '24', 'Пис-Ривер', 'Peace River', 'AB', 't8s1s6', '56.2333', '-117.2833');
INSERT INTO `net_city` VALUES ('11882', '24', 'Ллойдминстер', 'Lloydminster (Alberta)', 'AB', 't9v2z4', '53.2700', '-110.0300');
INSERT INTO `net_city` VALUES ('11885', '23', 'Расселл', 'Russell', 'KY', '41169', '38.5241', '-82.6935');
INSERT INTO `net_city` VALUES ('11895', '24', 'Эйрдри', 'Airdrie', 'AB', 't4b2c9', '51.2667', '-114.0167');
INSERT INTO `net_city` VALUES ('11899', '23', 'Глостер Пойнт', 'Gloucester Point', 'VA', '23062', '37.2571', '-76.4936');
INSERT INTO `net_city` VALUES ('11906', '24', 'Шервуд-Парк', 'Sherwood Park', 'AB', 't8a5z2', '53.5167', '-113.3167');
INSERT INTO `net_city` VALUES ('11919', '23', 'Уилмор', 'Wilmore', 'KY', '40390', '37.8448', '-84.6715');
INSERT INTO `net_city` VALUES ('11921', '23', 'Пейнт Лик', 'Paint Lick', 'KY', '40461', '37.5814', '-84.4077');
INSERT INTO `net_city` VALUES ('11922', '23', 'Берксвилл', 'Burkesville', 'KY', '42717', '36.7489', '-85.3660');
INSERT INTO `net_city` VALUES ('11928', '24', 'Салмон Арм', 'Salmon Arm', 'BC', 'v1e1x1', '50.7000', '-119.2833');
INSERT INTO `net_city` VALUES ('11937', '23', 'Лебанон', 'Lebanon', 'KY', '40033', '37.5408', '-85.2510');
INSERT INTO `net_city` VALUES ('11939', '23', 'Сесилия', 'Cecilia', 'KY', '42724', '37.6647', '-86.0607');
INSERT INTO `net_city` VALUES ('11942', '23', 'Бронстон', 'Bronston', 'KY', '42518', '36.9318', '-84.6379');
INSERT INTO `net_city` VALUES ('11949', '24', 'Нанаймо', 'Nanaimo', 'BC', 'v9t6l8', '49.1500', '-123.9167');
INSERT INTO `net_city` VALUES ('11951', '24', 'Дункан', 'Duncan', 'BC', 'v9l2t3', '48.7833', '-123.7000');
INSERT INTO `net_city` VALUES ('12034', '24', 'Ледук', 'LeDuc', 'AB', 't9e7e7', '53.2667', '-113.5333');
INSERT INTO `net_city` VALUES ('12036', '24', 'Ниску', 'Nisku', 'AB', 't9e7m3', '53.3333', '-113.5333');
INSERT INTO `net_city` VALUES ('12037', '24', 'Уэйнрайт', 'Wainwright', 'AB', 't9w1l7', '52.8333', '-110.8667');
INSERT INTO `net_city` VALUES ('12040', '24', 'Гранде Прейри', 'Grande Prairie', 'AB', 't8v7g2', '55.1667', '-118.8000');
INSERT INTO `net_city` VALUES ('12052', '24', 'Нью-Уэстминстер', 'New Westminster', 'BC', 'v3l5b2', '49.2167', '-122.9167');
INSERT INTO `net_city` VALUES ('12053', '24', 'Миссиссога', 'Mississauga', 'ON', 'l4t3e9', '43.6000', '-79.6500');
INSERT INTO `net_city` VALUES ('12057', '23', 'Саут Ярмут', 'South Yarmouth', 'MA', '02664', '41.6713', '-70.1916');
INSERT INTO `net_city` VALUES ('12060', '23', 'Норт Фолмут', 'North Falmouth', 'MA', '02556', '41.6378', '-70.6278');
INSERT INTO `net_city` VALUES ('12061', '23', 'Машпи', 'Mashpee', 'MA', '02649', '41.6162', '-70.4931');
INSERT INTO `net_city` VALUES ('12064', '23', 'Провинстаун', 'Provincetown', 'MA', '02657', '42.0511', '-70.1960');
INSERT INTO `net_city` VALUES ('12066', '23', 'Барнстейбл', 'Barnstable', 'MA', '02630', '41.7001', '-70.3088');
INSERT INTO `net_city` VALUES ('12068', '23', 'Хинсдейл', 'Hinsdale', 'MA', '01235', '42.4319', '-73.0740');
INSERT INTO `net_city` VALUES ('12076', '23', 'Деннис Порт', 'Dennis Port', 'MA', '02639', '41.6686', '-70.1374');
INSERT INTO `net_city` VALUES ('12080', '23', 'Вайнона', 'Winona', 'MN', '55987', '43.9848', '-91.6064');
INSERT INTO `net_city` VALUES ('12081', '23', 'Дагуэй', 'Dugway', 'UT', '84022', '40.3236', '-112.7975');
INSERT INTO `net_city` VALUES ('12085', '23', 'Мидлбери', 'Middlebury', 'VT', '05753', '43.9957', '-73.1596');
INSERT INTO `net_city` VALUES ('12086', '23', 'Каса Гранде', 'Casa Grande', 'AZ', '85222', '32.8345', '-111.7306');
INSERT INTO `net_city` VALUES ('12087', '23', 'Арлингтон', 'Arlington', 'MA', '', '42.4154', '-71.1564');
INSERT INTO `net_city` VALUES ('12094', '22', 'Гентофте ', 'Gentofte', '05', '', '55.7500', '12.5500');
INSERT INTO `net_city` VALUES ('12095', '23', 'Сомертон', 'Somerton', 'AZ', '85350', '32.5376', '-114.7138');
INSERT INTO `net_city` VALUES ('12099', '23', 'Бакай', 'Buckeye', 'AZ', '85326', '33.3703', '-112.5838');
INSERT INTO `net_city` VALUES ('12101', '24', 'Антигониш', 'Antigonish', 'NS', 'b2g2w5', '45.6167', '-61.9667');
INSERT INTO `net_city` VALUES ('12105', '24', 'Лонгёй', 'Longueuil', 'QC', 'j4g1a1', '45.5333', '-73.5167');
INSERT INTO `net_city` VALUES ('12106', '59', 'Веве', 'Vevey', '23', '', '46.4653', '6.8412');
INSERT INTO `net_city` VALUES ('12107', '139', 'Хельсинки ', 'Helsinki', '13', '', '60.1756', '24.9342');
INSERT INTO `net_city` VALUES ('12108', '23', 'Ист Ориндж', 'East Orange', 'NJ', '07019', '40.7673', '-74.2049');
INSERT INTO `net_city` VALUES ('12109', '23', 'Сидман', 'Sidman', 'PA', '15955', '40.3107', '-78.6959');
INSERT INTO `net_city` VALUES ('12112', '23', 'Керхонксон', 'Kerhonkson', 'NY', '12446', '41.7954', '-74.3092');
INSERT INTO `net_city` VALUES ('12116', '23', 'Порт Джефферсон', 'Port Jefferson', 'NY', '11777', '40.9515', '-73.0650');
INSERT INTO `net_city` VALUES ('12124', '23', 'Огденсберг', 'Ogdensburg', 'NY', '13669', '44.6052', '-75.5947');
INSERT INTO `net_city` VALUES ('12127', '23', 'Куперстаун', 'Cooperstown', 'NY', '13326', '42.7128', '-74.9173');
INSERT INTO `net_city` VALUES ('12133', '23', 'Уихокен', 'Weehawken', 'NJ', '07086', '40.7686', '-74.0199');
INSERT INTO `net_city` VALUES ('12134', '23', 'Вайлдвуд', 'Wildwood', 'NJ', '08260', '38.9828', '-74.8295');
INSERT INTO `net_city` VALUES ('12136', '23', 'Ошен Сити', 'Ocean City', 'NJ', '08226', '39.2548', '-74.6029');
INSERT INTO `net_city` VALUES ('12138', '23', 'Раннемид', 'Runnemede', 'NJ', '08078', '39.8508', '-75.0752');
INSERT INTO `net_city` VALUES ('12146', '23', 'Сидарвилл', 'Cedarville', 'NJ', '08311', '39.3282', '-75.2054');
INSERT INTO `net_city` VALUES ('12147', '23', 'Шони-он-Делавэр', 'Shawnee on Delaware', 'PA', '18356', '41.0123', '-75.1107');
INSERT INTO `net_city` VALUES ('12148', '23', 'Ист-Страудсберг', 'East Stroudsburg', 'PA', '18301', '41.0715', '-75.1278');
INSERT INTO `net_city` VALUES ('12154', '23', 'Хаузатоник', 'Housatonic', 'MA', '01236', '42.2649', '-73.3835');
INSERT INTO `net_city` VALUES ('12162', '23', 'Харлисвилл', 'Harleysville', 'PA', '19438', '40.2701', '-75.4040');
INSERT INTO `net_city` VALUES ('12165', '23', 'Ист Гринвилл', 'East Greenville', 'PA', '18041', '40.4180', '-75.5157');
INSERT INTO `net_city` VALUES ('12177', '23', 'Иствилл', 'Eastville', 'VA', '23347', '37.3526', '-75.9458');
INSERT INTO `net_city` VALUES ('12180', '23', 'Кейп Чарльз', 'Cape Charles', 'VA', '23310', '37.2542', '-75.9602');
INSERT INTO `net_city` VALUES ('12181', '23', 'Мелфа', 'Melfa', 'VA', '23410', '37.6219', '-75.7290');
INSERT INTO `net_city` VALUES ('12183', '23', 'Грасонвилл', 'Grasonville', 'MD', '21638', '38.9366', '-76.2081');
INSERT INTO `net_city` VALUES ('12190', '23', 'Элкинс', 'Elkins', 'WV', '26241', '38.9143', '-79.8407');
INSERT INTO `net_city` VALUES ('12194', '23', 'Ромни', 'Romney', 'WV', '26757', '39.2954', '-78.7311');
INSERT INTO `net_city` VALUES ('12197', '23', 'Колумбия Фолс', 'Columbia Falls', 'MT', '59912', '48.5448', '-114.3473');
INSERT INTO `net_city` VALUES ('12198', '23', 'Бейсден', 'Baisden', 'WV', '25608', '37.5657', '-81.8985');
INSERT INTO `net_city` VALUES ('12222', '23', 'Ист Моричес', 'East Moriches', 'NY', '11940', '40.8079', '-72.7577');
INSERT INTO `net_city` VALUES ('12223', '23', 'Эксмор', 'Exmore', 'VA', '23350', '37.5142', '-75.8780');
INSERT INTO `net_city` VALUES ('12226', '23', 'Карл Плейс', 'Carle Place', 'NY', '11514', '40.7505', '-73.6116');
INSERT INTO `net_city` VALUES ('12238', '23', 'Хоноай Фолс', 'Honeoye Falls', 'NY', '14472', '42.9680', '-77.5976');
INSERT INTO `net_city` VALUES ('12244', '23', 'Кэпитол Хайтс', 'Capitol Heights', 'MD', '20743', '38.8912', '-76.8953');
INSERT INTO `net_city` VALUES ('12246', '23', 'Маклин', 'McLean', 'VA', '', '38.9343', '-77.1775');
INSERT INTO `net_city` VALUES ('12263', '23', 'Эссингтон', 'Essington', 'PA', '19029', '39.8684', '-75.2223');
INSERT INTO `net_city` VALUES ('12273', '23', 'Квакертаун', 'Quakertown', 'PA', '18951', '40.4639', '-75.3263');
INSERT INTO `net_city` VALUES ('12274', '23', 'Левитаун', 'Levittown', 'PA', '19057', '40.1442', '-74.8483');
INSERT INTO `net_city` VALUES ('12275', '23', 'Сметпорт', 'Smethport', 'PA', '16749', '41.7663', '-78.4566');
INSERT INTO `net_city` VALUES ('12286', '23', 'Коннеллсвилл', 'Connellsville', 'PA', '15425', '40.0306', '-79.5390');
INSERT INTO `net_city` VALUES ('12290', '12', 'Лион', 'Lyon', 'B9', '', '45.7485', '4.8467');
INSERT INTO `net_city` VALUES ('12291', '21', 'Манчестер', 'Manchester', 'I2', '', '53.5000', '-2.2167');
INSERT INTO `net_city` VALUES ('12292', '23', 'Дель Мар', 'Del Mar', 'CA', '92014', '32.9672', '-117.2586');
INSERT INTO `net_city` VALUES ('12293', '23', 'Перл Ривер', 'Pearl River', 'NY', '10965', '41.0605', '-74.0166');
INSERT INTO `net_city` VALUES ('12306', '23', 'Тайдиаут', 'Tidioute', 'PA', '16351', '41.6874', '-79.3157');
INSERT INTO `net_city` VALUES ('12322', '23', 'Уэллсли', 'Wellesley', 'MA', '02482', '42.2935', '-71.2960');
INSERT INTO `net_city` VALUES ('12323', '23', 'Эдмстон', 'Edmeston', 'NY', '13335', '42.6988', '-75.2546');
INSERT INTO `net_city` VALUES ('12345', '24', 'Брендон', 'Brandon', 'MB', 'r7a6a9', '49.8333', '-99.9500');
INSERT INTO `net_city` VALUES ('12355', '24', 'Маркем', 'Markham', 'ON', 'l3r1c9', '43.8770', '-79.2578');
INSERT INTO `net_city` VALUES ('12362', '24', 'Китченер', 'Kitchener', 'ON', 'n2g4m4', '43.4470', '-80.4725');
INSERT INTO `net_city` VALUES ('12366', '24', 'Садбери', 'Sudbury', 'ON', 'p3a5w1', '46.5000', '-80.9667');
INSERT INTO `net_city` VALUES ('12367', '24', 'Реджайна', 'Regina', 'SK', 's4p3y2', '50.4500', '-104.6167');
INSERT INTO `net_city` VALUES ('12369', '24', 'Вудсток', 'Woodstock (New Brunswick)', 'NB', 'e7m5c3', '46.1103', '-67.5843');
INSERT INTO `net_city` VALUES ('12370', '24', 'Барри', 'Barrie', 'ON', 'l4m6k9', '44.3833', '-79.7000');
INSERT INTO `net_city` VALUES ('12371', '24', 'Ориллия', 'Orillia', 'ON', 'l3v6h1', '44.6000', '-79.4167');
INSERT INTO `net_city` VALUES ('12381', '24', 'Аллистон', 'Alliston', 'ON', 'l9r1v5', '44.1500', '-79.8667');
INSERT INTO `net_city` VALUES ('12382', '24', 'Эдмундстон', 'Edmundston', 'NB', 'e3v2s8', '47.3623', '-68.3279');
INSERT INTO `net_city` VALUES ('12404', '24', 'Валь-д&#39;Ор', 'Val D\'or', 'QC', 'j9p1p8', '48.1167', '-77.7667');
INSERT INTO `net_city` VALUES ('12406', '24', 'Кокитлам', 'Coquitlam', 'BC', 'v3b7n2', '49.2667', '-122.7833');
INSERT INTO `net_city` VALUES ('12422', '24', 'Питерборо', 'Peterborough', 'ON', 'k9j7b1', '44.3000', '-78.3333');
INSERT INTO `net_city` VALUES ('12441', '24', 'Брамптон', 'Brampton', 'ON', 'l6y4r2', '43.6885', '-79.7616');
INSERT INTO `net_city` VALUES ('12445', '24', 'Оквилл', 'Oakville', 'ON', 'l6j5e3', '43.4476', '-79.6686');
INSERT INTO `net_city` VALUES ('12464', '24', 'Корнуолл', 'Cornwall (Ontario)', 'ON', 'k6h5v3', '45.0167', '-74.7333');
INSERT INTO `net_city` VALUES ('12486', '24', 'Коллингвуд', 'Collingwood', 'ON', 'l9y3z1', '44.5000', '-80.2167');
INSERT INTO `net_city` VALUES ('12489', '24', 'Оуэн Саунд', 'Owen Sound', 'ON', 'n4k3e3', '44.5667', '-80.8500');
INSERT INTO `net_city` VALUES ('12515', '24', 'Летбридж', 'Lethbridge', 'AB', 't1k3m4', '49.7000', '-112.8333');
INSERT INTO `net_city` VALUES ('12517', '24', 'Форт Мак-Мюррей', 'Fort McMurray', 'AB', 't9h3l1', '56.7333', '-111.3833');
INSERT INTO `net_city` VALUES ('12536', '24', 'Мак-Грегор', 'Mcgregor', 'ON', 'n0r1j0', '42.1500', '-82.9667');
INSERT INTO `net_city` VALUES ('12538', '24', 'Порт Карлинг', 'Port Carling', 'ON', 'p0c1a0', '45.0167', '-79.6167');
INSERT INTO `net_city` VALUES ('12547', '24', 'Мидленд', 'Midland', 'ON', 'l4r1k9', '44.7500', '-79.9000');
INSERT INTO `net_city` VALUES ('12591', '23', 'Рипон', 'Ripon', 'WI', '54971', '43.8771', '-88.8457');
INSERT INTO `net_city` VALUES ('12598', '23', 'Уэлс', 'Wells', 'ME', '04090', '43.3199', '-70.6318');
INSERT INTO `net_city` VALUES ('12625', '23', 'Уилберфорс', 'Wilberforce', 'OH', '45384', '39.7162', '-83.8777');
INSERT INTO `net_city` VALUES ('12626', '23', 'Маунт-Вернон', 'Mount Vernon', 'IA', '52314', '41.9370', '-91.4481');
INSERT INTO `net_city` VALUES ('12635', '23', 'Лимерик', 'Limerick', 'PA', '19442', '40.1307', '-75.5721');
INSERT INTO `net_city` VALUES ('12636', '23', 'Миллерсвилл', 'Millersville', 'MD', '21108', '39.0840', '-76.6157');
INSERT INTO `net_city` VALUES ('12640', '23', 'Шумейкерсвилл', 'Shoemakersville', 'PA', '19555', '40.4881', '-75.9554');
INSERT INTO `net_city` VALUES ('12646', '23', 'Фрейзер', 'Frazer', 'PA', '19353', '40.0537', '-75.6599');
INSERT INTO `net_city` VALUES ('12649', '23', 'Куцтаун', 'Kutztown', 'PA', '19530', '40.5378', '-75.7812');
INSERT INTO `net_city` VALUES ('12651', '23', 'Дагсборо', 'Dagsboro', 'DE', '19939', '38.5528', '-75.2440');
INSERT INTO `net_city` VALUES ('12652', '23', 'Уолнатпорт', 'Walnutport', 'PA', '18088', '40.7630', '-75.5440');
INSERT INTO `net_city` VALUES ('12666', '23', 'Манвилл', 'Manville', 'NJ', '08835', '40.5422', '-74.5770');
INSERT INTO `net_city` VALUES ('12675', '23', 'Порт Норрис', 'Port Norris', 'NJ', '08349', '39.2614', '-75.0686');
INSERT INTO `net_city` VALUES ('12686', '23', 'Смирна', 'Smyrna', 'DE', '19977', '39.2955', '-75.5698');
INSERT INTO `net_city` VALUES ('12689', '23', 'Орвигсберг', 'Orwigsburg', 'PA', '17961', '40.6415', '-76.0623');
INSERT INTO `net_city` VALUES ('12692', '23', 'Дугласвилл', 'Douglassville', 'PA', '19518', '40.2933', '-75.7441');
INSERT INTO `net_city` VALUES ('12696', '23', 'Авондейл', 'Avondale', 'PA', '19311', '39.8292', '-75.7830');
INSERT INTO `net_city` VALUES ('12697', '23', 'Кулпсвилл', 'Kulpsville', 'PA', '19443', '40.2429', '-75.3366');
INSERT INTO `net_city` VALUES ('12699', '23', 'Шилох', 'Shiloh', 'NJ', '08353', '39.4594', '-75.2968');
INSERT INTO `net_city` VALUES ('12705', '23', 'Юнионвилл', 'Unionville', 'PA', '19375', '40.9415', '-79.9620');
INSERT INTO `net_city` VALUES ('12709', '23', 'Ламбертвилл', 'Lambertville', 'NJ', '08530', '40.3706', '-74.8949');
INSERT INTO `net_city` VALUES ('12711', '23', 'Таунсенд', 'Townsend', 'DE', '19734', '39.3813', '-75.6402');
INSERT INTO `net_city` VALUES ('12713', '23', 'Макунги', 'Macungie', 'PA', '18062', '40.5025', '-75.5868');
INSERT INTO `net_city` VALUES ('12717', '23', 'Бич Хейвен', 'Beach Haven', 'NJ', '08008', '39.6247', '-74.2042');
INSERT INTO `net_city` VALUES ('12726', '23', 'Скоттдейл', 'Scottdale', 'PA', '15683', '40.1082', '-79.6117');
INSERT INTO `net_city` VALUES ('12730', '23', 'Уильямстаун', 'Williamstown', 'NJ', '08094', '39.6397', '-74.9738');
INSERT INTO `net_city` VALUES ('12735', '23', 'Элмер', 'Elmer', 'NJ', '08318', '39.5455', '-75.1959');
INSERT INTO `net_city` VALUES ('12742', '23', 'Валли Гров', 'Valley Grove', 'WV', '26060', '40.1019', '-80.5590');
INSERT INTO `net_city` VALUES ('12748', '23', 'Фредерика', 'Frederica', 'DE', '19946', '39.0250', '-75.4611');
INSERT INTO `net_city` VALUES ('12752', '23', 'Лафайетт Хилл', 'Lafayette Hill', 'PA', '19444', '40.0918', '-75.2562');
INSERT INTO `net_city` VALUES ('12769', '23', 'Кларксберг', 'Clarksburg', 'NJ', '08510', '40.1884', '-74.4424');
INSERT INTO `net_city` VALUES ('12774', '23', 'Эндрас', 'Andreas', 'PA', '18211', '40.7447', '-75.8181');
INSERT INTO `net_city` VALUES ('12775', '23', 'Бердсборо', 'Birdsboro', 'PA', '19508', '40.2484', '-75.8446');
INSERT INTO `net_city` VALUES ('12776', '23', 'Нескхонинг', 'Nesquehoning', 'PA', '18240', '40.8794', '-75.8118');
INSERT INTO `net_city` VALUES ('12786', '23', 'Вайомиссинг', 'Wyomissing', 'PA', '19533', '40.4201', '-75.9958');
INSERT INTO `net_city` VALUES ('12789', '23', 'Гленмур', 'Glenmoore', 'PA', '19343', '40.1002', '-75.7562');
INSERT INTO `net_city` VALUES ('12793', '23', 'Шартлсвилл', 'Shartlesville', 'PA', '19554', '40.5129', '-76.1044');
INSERT INTO `net_city` VALUES ('12796', '23', 'Пеннсвилл', 'Pennsville', 'NJ', '08070', '39.6280', '-75.5153');
INSERT INTO `net_city` VALUES ('12797', '23', 'Винсентаун', 'Vincentown', 'NJ', '08088', '39.8566', '-74.6704');
INSERT INTO `net_city` VALUES ('12798', '23', 'Шуйлкилл Хейвен', 'Schuylkill Haven', 'PA', '17972', '40.6035', '-76.2189');
INSERT INTO `net_city` VALUES ('12805', '23', 'Крим Ридж', 'Cream Ridge', 'NJ', '08514', '40.1345', '-74.4920');
INSERT INTO `net_city` VALUES ('12810', '23', 'Самнитаун', 'Sumneytown', 'PA', '18084', '40.3290', '-75.4510');
INSERT INTO `net_city` VALUES ('12811', '23', 'Харбесон', 'Harbeson', 'DE', '19951', '38.6755', '-75.2151');
INSERT INTO `net_city` VALUES ('12812', '23', 'Брукхейвен', 'Brookhaven', 'PA', '19015', '39.8686', '-75.3958');
INSERT INTO `net_city` VALUES ('12813', '23', 'Бель Вернон', 'Belle Vernon', 'PA', '15012', '40.1647', '-79.8240');
INSERT INTO `net_city` VALUES ('12822', '23', 'Порт Орчард', 'Port Orchard', 'WA', '98366', '47.5459', '-122.5889');
INSERT INTO `net_city` VALUES ('12826', '23', 'Форт Полк', 'Fort Polk', 'LA', '71459', '31.1073', '-93.1808');
INSERT INTO `net_city` VALUES ('12827', '23', 'Джуно', 'Juneau', 'AK', '99811', '58.3019', '-134.4197');
INSERT INTO `net_city` VALUES ('12832', '22', 'Копенгаген', 'Copenhagen', '06', '', '55.6667', '12.5833');
INSERT INTO `net_city` VALUES ('12838', '23', 'Бриджуотер', 'Bridgewater', 'VA', '22812', '38.3622', '-79.0337');
INSERT INTO `net_city` VALUES ('12842', '23', 'Фишертаун', 'Fishertown', 'PA', '15539', '40.1290', '-78.5940');
INSERT INTO `net_city` VALUES ('12844', '23', 'Кэрнбрук', 'Cairnbrook', 'PA', '15924', '40.0996', '-78.7789');
INSERT INTO `net_city` VALUES ('12845', '23', 'Джером', 'Jerome', 'PA', '15937', '40.2090', '-78.9836');
INSERT INTO `net_city` VALUES ('12846', '23', 'Карролтаун', 'Carrolltown', 'PA', '15722', '40.5936', '-78.7205');
INSERT INTO `net_city` VALUES ('12852', '23', 'Форт Драм', 'Fort Drum', 'NY', '13602', '44.0325', '-75.7545');
INSERT INTO `net_city` VALUES ('12854', '23', 'Уэйнсберг', 'Waynesburg', 'PA', '15370', '39.8916', '-80.1780');
INSERT INTO `net_city` VALUES ('12858', '23', 'Капао', 'Kapaau', 'HI', '96755', '20.2017', '-155.7833');
INSERT INTO `net_city` VALUES ('12862', '23', 'Эдинборо', 'Edinboro', 'PA', '16444', '42.1827', '-80.0649');
INSERT INTO `net_city` VALUES ('12863', '23', 'Сторм Лейк', 'Storm Lake', 'IA', '50588', '42.6765', '-95.1615');
INSERT INTO `net_city` VALUES ('12894', '23', 'Ваграм', 'Wagram', 'NC', '28396', '34.9232', '-79.4047');
INSERT INTO `net_city` VALUES ('12898', '23', 'Уэйдсборо', 'Wadesboro', 'NC', '28170', '35.0073', '-80.0860');
INSERT INTO `net_city` VALUES ('12901', '23', 'Блэк Маунтин', 'Black Mountain', 'NC', '28711', '35.6050', '-82.3132');
INSERT INTO `net_city` VALUES ('12903', '23', 'Сильва', 'Sylva', 'NC', '28779', '35.3619', '-83.2078');
INSERT INTO `net_city` VALUES ('12904', '23', 'Мансон', 'Manson', 'NC', '27553', '36.4675', '-78.3050');
INSERT INTO `net_city` VALUES ('12908', '23', 'Кенансвилл', 'Kenansville', 'NC', '28349', '34.9729', '-77.9234');
INSERT INTO `net_city` VALUES ('12909', '23', 'Лиллингтон', 'Lillington', 'NC', '27546', '35.3874', '-78.8686');
INSERT INTO `net_city` VALUES ('12916', '23', 'Спиндейл', 'Spindale', 'NC', '28160', '35.3586', '-81.9238');
INSERT INTO `net_city` VALUES ('12922', '23', 'Эверетс', 'Everetts', 'NC', '27825', '35.8349', '-77.1736');
INSERT INTO `net_city` VALUES ('12923', '23', 'Уэнтворт', 'Wentworth', 'NC', '27375', '36.4001', '-79.7745');
INSERT INTO `net_city` VALUES ('12924', '23', 'Янсивилл', 'Yanceyville', 'NC', '27379', '36.3823', '-79.3213');
INSERT INTO `net_city` VALUES ('12944', '23', 'Ядкинвилл', 'Yadkinville', 'NC', '27055', '36.1242', '-80.6351');
INSERT INTO `net_city` VALUES ('13155', '23', 'Херши ', 'Hershey', 'PA', '17033', '40.2667', '-76.6381');
INSERT INTO `net_city` VALUES ('13157', '23', 'Кирксвилл', 'Kirksville', 'MO', '63501', '40.1812', '-92.6204');
INSERT INTO `net_city` VALUES ('13159', '139', 'Вантаа', 'Vantaa', '13', '', '60.3000', '24.8500');
INSERT INTO `net_city` VALUES ('13162', '23', 'Дуарти', 'Duarte', 'CA', '91010', '34.1378', '-117.9474');
INSERT INTO `net_city` VALUES ('13177', '23', 'Гвинн Ок', 'Gwynn Oak', 'MD', '21207', '39.3264', '-76.7141');
INSERT INTO `net_city` VALUES ('13181', '23', 'Кендалл Парк', 'Kendall Park', 'NJ', '08824', '40.4242', '-74.5523');
INSERT INTO `net_city` VALUES ('13188', '23', 'Ист Хамптон', 'East Hampton', 'NY', '11937', '40.9919', '-72.1989');
INSERT INTO `net_city` VALUES ('13189', '23', 'Калифорния', 'California', 'PA', '15419', '40.0540', '-79.8934');
INSERT INTO `net_city` VALUES ('13191', '23', 'Рингвуд', 'Ringwood', 'NJ', '07456', '41.1119', '-74.2797');
INSERT INTO `net_city` VALUES ('13197', '23', 'Лидс', 'Leeds', 'AL', '35094', '33.5147', '-86.5532');
INSERT INTO `net_city` VALUES ('13201', '23', 'Лонг-Айленд Сити', 'Long Island City', 'NY', '11120', '40.6514', '-73.8708');
INSERT INTO `net_city` VALUES ('13202', '23', 'Тенафлай', 'Tenafly', 'NJ', '07670', '40.9192', '-73.9588');
INSERT INTO `net_city` VALUES ('13206', '23', 'Миледжвилл', 'Milledgeville', 'GA', '31061', '33.0247', '-83.2296');
INSERT INTO `net_city` VALUES ('13212', '23', 'Спринг Лейк', 'Spring Lake', 'NJ', '07762', '40.1534', '-74.0376');
INSERT INTO `net_city` VALUES ('13216', '23', 'Токкоа Фолс', 'Toccoa Falls', 'GA', '30598', '34.5937', '-83.3582');
INSERT INTO `net_city` VALUES ('13227', '23', 'Бруквилл', 'Brookville', 'PA', '15825', '41.1804', '-79.0597');
INSERT INTO `net_city` VALUES ('13231', '23', 'Грейвс Милл', 'Graves Mill', 'VA', '22721', '38.4226', '-78.3675');
INSERT INTO `net_city` VALUES ('13232', '23', 'Ноксвилл', 'Nokesville', 'VA', '20181', '38.6934', '-77.5664');
INSERT INTO `net_city` VALUES ('13235', '23', 'Алеппо', 'Aleppo', 'PA', '15310', '39.7848', '-80.4884');
INSERT INTO `net_city` VALUES ('13236', '23', 'Монессен', 'Monessen', 'PA', '15062', '40.1485', '-79.8814');
INSERT INTO `net_city` VALUES ('13238', '23', 'Бивер Фолс', 'Beaver Falls', 'PA', '15010', '40.7731', '-80.3959');
INSERT INTO `net_city` VALUES ('13239', '23', 'Уитленд', 'Wheatland', 'PA', '16161', '41.2009', '-80.4978');
INSERT INTO `net_city` VALUES ('13241', '23', 'Клаймер', 'Clymer', 'PA', '15728', '40.6770', '-78.9184');
INSERT INTO `net_city` VALUES ('13243', '23', 'Смиттон', 'Smithton', 'PA', '15479', '40.1472', '-79.7048');
INSERT INTO `net_city` VALUES ('13249', '23', 'Болл Граунд', 'Ball Ground', 'GA', '30107', '34.3410', '-84.3490');
INSERT INTO `net_city` VALUES ('13256', '23', 'Кохассет', 'Cohasset', 'MA', '02025', '42.2328', '-70.8176');
INSERT INTO `net_city` VALUES ('13257', '23', 'Котут', 'Cotuit', 'MA', '02635', '41.6218', '-70.4413');
INSERT INTO `net_city` VALUES ('13258', '23', 'Норфолк', 'Norfolk', 'MA', '02056', '42.1162', '-71.3306');
INSERT INTO `net_city` VALUES ('13269', '23', 'Франклинвилл', 'Franklinville', 'NJ', '08322', '39.6193', '-75.0318');
INSERT INTO `net_city` VALUES ('13273', '23', 'Саттон', 'Sutton', 'WV', '26601', '38.6508', '-80.6639');
INSERT INTO `net_city` VALUES ('13276', '23', 'Риджуэй', 'Ridgway', 'PA', '15853', '41.3897', '-78.7865');
INSERT INTO `net_city` VALUES ('13277', '23', 'Блэкли', 'Blakely', 'GA', '39823', '31.3314', '-84.9419');
INSERT INTO `net_city` VALUES ('13279', '23', 'Юнадилла', 'Unadilla', 'GA', '31091', '32.2280', '-83.7361');
INSERT INTO `net_city` VALUES ('13283', '23', 'Сильвания', 'Sylvania', 'GA', '30467', '32.7385', '-81.6142');
INSERT INTO `net_city` VALUES ('13291', '23', 'Томастон', 'Thomaston', 'GA', '30286', '32.8685', '-84.3246');
INSERT INTO `net_city` VALUES ('13298', '23', 'Фолкнер', 'Faulkner', 'MD', '20632', '38.4261', '-76.9593');
INSERT INTO `net_city` VALUES ('13321', '23', 'Текамсе', 'Tecumseh', 'MI', '49286', '42.0115', '-83.9169');
INSERT INTO `net_city` VALUES ('13330', '23', 'Баннер Элк', 'Banner Elk', 'NC', '28604', '36.1452', '-81.8380');
INSERT INTO `net_city` VALUES ('13331', '23', 'Каллоухе', 'Cullowhee', 'NC', '28723', '35.2521', '-83.1871');
INSERT INTO `net_city` VALUES ('13333', '23', 'Элон', 'Elon', 'NC', '27244', '36.1656', '-79.5205');
INSERT INTO `net_city` VALUES ('13335', '23', 'Маунт Олив', 'Mount Olive', 'NC', '28365', '35.1638', '-78.0702');
INSERT INTO `net_city` VALUES ('13339', '23', 'Дэвидсон', 'Davidson', 'NC', '28036', '35.4838', '-80.7943');
INSERT INTO `net_city` VALUES ('13346', '125', 'Хортен', 'Horten', '20', '', '59.4136', '10.4669');
INSERT INTO `net_city` VALUES ('13350', '56', 'Лёвен', 'Leuven', '12', '', '50.8833', '4.7000');
INSERT INTO `net_city` VALUES ('13358', '24', 'Уитби', 'Whitby', 'ON', 'l1n3w9', '43.8719', '-78.9378');
INSERT INTO `net_city` VALUES ('13365', '24', 'Ошава', 'Oshawa', 'ON', 'l1j6z7', '43.9000', '-78.8667');
INSERT INTO `net_city` VALUES ('13366', '24', 'Орора', 'Aurora', 'ON', 'l4g6k6', '44.0000', '-79.4667');
INSERT INTO `net_city` VALUES ('13383', '23', 'Шелберн Фолс', 'Shelburne Falls', 'MA', '01370', '42.6011', '-72.7327');
INSERT INTO `net_city` VALUES ('13389', '23', 'Мелроз', 'Melrose', 'MA', '02176', '42.4574', '-71.0540');
INSERT INTO `net_city` VALUES ('13401', '23', 'Уэст Уорик', 'West Warwick', 'RI', '02893', '41.6970', '-71.5254');
INSERT INTO `net_city` VALUES ('13410', '23', 'Гоффстаун', 'Goffstown', 'NH', '03045', '43.0203', '-71.5721');
INSERT INTO `net_city` VALUES ('13411', '23', 'Горем', 'Gorham', 'ME', '04038', '43.7224', '-70.4622');
INSERT INTO `net_city` VALUES ('13413', '23', 'Виндхам', 'Windham', 'NH', '03087', '42.8054', '-71.3013');
INSERT INTO `net_city` VALUES ('13415', '23', 'Ист Хампстед', 'East Hampstead', 'NH', '03826', '42.8910', '-71.1220');
INSERT INTO `net_city` VALUES ('13422', '23', 'Форт Юстис', 'Fort Eustis', 'VA', '23604', '37.1254', '-76.5892');
INSERT INTO `net_city` VALUES ('13435', '23', 'Коттедж Гров', 'Cottage Grove', 'MN', '55016', '44.8205', '-92.9256');
INSERT INTO `net_city` VALUES ('13439', '23', 'Уотербери', 'Waterbury', 'VT', '05676', '44.3107', '-72.8247');
INSERT INTO `net_city` VALUES ('13444', '23', 'Кос Коб', 'Cos Cob', 'CT', '06807', '41.0621', '-73.5895');
INSERT INTO `net_city` VALUES ('13446', '23', 'Таунсенд', 'Townsend', 'MA', '01469', '42.6594', '-71.7005');
INSERT INTO `net_city` VALUES ('13455', '23', 'Сибрук', 'Seabrook', 'NH', '03874', '42.8839', '-70.8717');
INSERT INTO `net_city` VALUES ('13461', '23', 'Маршфилд', 'Marshfield', 'MA', '02050', '42.1112', '-70.7127');
INSERT INTO `net_city` VALUES ('13462', '23', 'Плейстоу', 'Plaistow', 'NH', '03865', '42.8430', '-71.0950');
INSERT INTO `net_city` VALUES ('13475', '23', 'Маунт Хорб', 'Mount Horeb', 'WI', '53572', '42.9613', '-89.7301');
INSERT INTO `net_city` VALUES ('13476', '23', 'Литл Шут', 'Little Chute', 'WI', '54140', '44.2865', '-88.3158');
INSERT INTO `net_city` VALUES ('13477', '23', 'Грейслейк', 'Grayslake', 'IL', '60030', '42.3316', '-88.0545');
INSERT INTO `net_city` VALUES ('13478', '23', 'Элкхарт Лейк', 'Elkhart Lake', 'WI', '53020', '43.8597', '-88.0043');
INSERT INTO `net_city` VALUES ('13485', '23', 'Йеллоу Спрингс', 'Yellow Springs', 'OH', '45387', '39.7949', '-83.8873');
INSERT INTO `net_city` VALUES ('13498', '45', 'Джакарта', 'Jakarta', '06', '', '-6.1744', '106.8294');
INSERT INTO `net_city` VALUES ('13500', '23', 'Тооел', 'Tooele', 'UT', '84074', '40.5757', '-112.3346');
INSERT INTO `net_city` VALUES ('13507', '23', 'Плимут', 'Plymouth', 'NH', '03264', '43.7173', '-71.7163');
INSERT INTO `net_city` VALUES ('13547', '21', 'Лондон', 'London', 'H9', '', '51.5142', '-0.0931');
INSERT INTO `net_city` VALUES ('13549', '23', 'Чадрон', 'Chadron', 'NE', '69337', '42.8277', '-103.1392');
INSERT INTO `net_city` VALUES ('13554', '23', 'Сан-Мигел', 'San Miguel', 'CA', '93451', '35.8951', '-120.6017');
INSERT INTO `net_city` VALUES ('13560', '23', 'Спаниш Форк', 'Spanish Fork', 'UT', '84660', '40.0278', '-111.5547');
INSERT INTO `net_city` VALUES ('13586', '23', 'Гэмбрилс', 'Gambrills', 'MD', '21054', '39.0529', '-76.6811');
INSERT INTO `net_city` VALUES ('13598', '23', 'Монтросс', 'Montross', 'VA', '22520', '38.1122', '-76.8471');
INSERT INTO `net_city` VALUES ('13599', '23', 'Фалконер', 'Falconer', 'NY', '14733', '42.1495', '-79.1897');
INSERT INTO `net_city` VALUES ('13604', '23', 'Фрусберг', 'Frewsburg', 'NY', '14738', '42.0464', '-79.0530');
INSERT INTO `net_city` VALUES ('13606', '23', 'Хит', 'Heath', 'OH', '43056', '40.0064', '-82.3502');
INSERT INTO `net_city` VALUES ('13609', '23', 'Мардела Спрингс', 'Mardela Springs', 'MD', '21837', '38.4647', '-75.7729');
INSERT INTO `net_city` VALUES ('13612', '23', 'Вортон', 'Worton', 'MD', '21678', '39.3048', '-76.0912');
INSERT INTO `net_city` VALUES ('13613', '23', 'Силвер-Бэй', 'Silver Bay', 'NY', '12874', '43.6919', '-73.5500');
INSERT INTO `net_city` VALUES ('13617', '23', 'Колберт', 'Colbert', 'GA', '30628', '34.0245', '-83.2246');
INSERT INTO `net_city` VALUES ('13622', '23', 'Киттаннинг', 'Kittanning', 'PA', '16201', '40.8076', '-79.4220');
INSERT INTO `net_city` VALUES ('13624', '23', 'Полктон', 'Polkton', 'NC', '28135', '35.0611', '-80.2045');
INSERT INTO `net_city` VALUES ('13630', '23', 'Фордис', 'Fordyce', 'AR', '71742', '33.8195', '-92.4715');
INSERT INTO `net_city` VALUES ('13631', '23', 'Интерлейшен', 'Interlachen', 'FL', '32148', '29.6217', '-81.8608');
INSERT INTO `net_city` VALUES ('13634', '23', 'Де-Куин', 'De Queen', 'AR', '71832', '34.0356', '-94.3339');
INSERT INTO `net_city` VALUES ('13635', '23', 'Кроссетт', 'Crossett', 'AR', '71635', '33.1560', '-92.0018');
INSERT INTO `net_city` VALUES ('13650', '23', 'Хай-Спрингс', 'High Springs', 'FL', '32643', '29.8323', '-82.5854');
INSERT INTO `net_city` VALUES ('13654', '23', 'Карнесвилл', 'Carnesville', 'GA', '30521', '34.3527', '-83.2983');
INSERT INTO `net_city` VALUES ('13657', '23', 'Катберт', 'Cuthbert', 'GA', '39840', '31.7756', '-84.7545');
INSERT INTO `net_city` VALUES ('13668', '23', 'Чаутоква', 'Chautauqua', 'NY', '14722', '42.2098', '-79.4667');
INSERT INTO `net_city` VALUES ('13669', '23', 'Кентон', 'Kenton', 'OH', '43326', '40.6391', '-83.5981');
INSERT INTO `net_city` VALUES ('13671', '23', 'Манлиус', 'Manlius', 'NY', '13104', '42.9624', '-75.9603');
INSERT INTO `net_city` VALUES ('13673', '23', 'Кармайклс', 'Carmichaels', 'PA', '15320', '39.8720', '-79.9982');
INSERT INTO `net_city` VALUES ('13678', '23', 'Ваксхо', 'Waxhaw', 'NC', '28173', '34.9273', '-80.7278');
INSERT INTO `net_city` VALUES ('13685', '23', 'Анауак', 'Anahuac', 'TX', '77514', '29.6824', '-94.6512');
INSERT INTO `net_city` VALUES ('13688', '23', 'Плезант Хоп', 'Pleasant Hope', 'MO', '65725', '37.4197', '-93.2650');
INSERT INTO `net_city` VALUES ('13689', '23', 'Уоллисвилл', 'Wallisville', 'TX', '77597', '29.8313', '-94.7081');
INSERT INTO `net_city` VALUES ('13692', '23', 'Доналсонвилл', 'Donalsonville', 'GA', '39845', '30.9591', '-84.8898');
INSERT INTO `net_city` VALUES ('13694', '23', 'Лейкленд', 'Lakeland', 'GA', '31635', '31.1200', '-83.0462');
INSERT INTO `net_city` VALUES ('13696', '23', 'Маунт-Вернон', 'Mount Vernon', 'GA', '30445', '32.1825', '-82.6023');
INSERT INTO `net_city` VALUES ('13697', '23', 'Оцилла', 'Ocilla', 'GA', '31774', '31.5678', '-83.2719');
INSERT INTO `net_city` VALUES ('13698', '23', 'Кларксвилл', 'Clarkesville', 'GA', '30523', '34.7251', '-83.5108');
INSERT INTO `net_city` VALUES ('13704', '23', 'Лудоуиси', 'Ludowici', 'GA', '31316', '31.7224', '-81.7368');
INSERT INTO `net_city` VALUES ('13706', '23', 'Доеран', 'Doerun', 'GA', '31744', '31.3226', '-83.8578');
INSERT INTO `net_city` VALUES ('13711', '23', 'Шекливилл', 'Sheakleyville', 'PA', '16151', '41.4428', '-80.2078');
INSERT INTO `net_city` VALUES ('13712', '23', 'Личберг', 'Leechburg', 'PA', '15656', '40.6253', '-79.6377');
INSERT INTO `net_city` VALUES ('13714', '23', 'Дэниелсвилл', 'Danielsville', 'GA', '30633', '34.1650', '-83.2355');
INSERT INTO `net_city` VALUES ('13718', '23', 'Тобакковилл', 'Tobaccoville', 'NC', '27050', '36.2393', '-80.3968');
INSERT INTO `net_city` VALUES ('13720', '23', 'Оливия', 'Olivia', 'NC', '28368', '35.3596', '-79.1098');
INSERT INTO `net_city` VALUES ('13724', '23', 'Уайт Спрингс', 'White Springs', 'FL', '32096', '30.4327', '-82.6471');
INSERT INTO `net_city` VALUES ('13727', '23', 'Уолдо', 'Waldo', 'FL', '32694', '29.7862', '-82.1614');
INSERT INTO `net_city` VALUES ('13738', '23', 'Саммервилл', 'Summerville', 'GA', '30747', '34.5028', '-85.3013');
INSERT INTO `net_city` VALUES ('13739', '23', 'Сесил', 'Cecil', 'GA', '31627', '31.0455', '-83.3921');
INSERT INTO `net_city` VALUES ('13740', '23', 'Гленнвилл', 'Glennville', 'GA', '30427', '31.9323', '-81.9659');
INSERT INTO `net_city` VALUES ('13741', '23', 'Хаайра', 'Hahira', 'GA', '31632', '30.9966', '-83.3605');
INSERT INTO `net_city` VALUES ('13742', '23', 'Шелман', 'Shellman', 'GA', '39886', '31.7364', '-84.6007');
INSERT INTO `net_city` VALUES ('13743', '23', 'Эллавилл', 'Ellaville', 'GA', '31806', '32.2933', '-84.3059');
INSERT INTO `net_city` VALUES ('13745', '23', 'Дьюарт', 'Dewart', 'PA', '17730', '41.1093', '-76.8766');
INSERT INTO `net_city` VALUES ('13746', '23', 'Терботвилл', 'Turbotville', 'PA', '17772', '41.1171', '-76.7222');
INSERT INTO `net_city` VALUES ('13747', '23', 'Мейсонтаун', 'Masontown', 'PA', '15461', '39.8417', '-79.8958');
INSERT INTO `net_city` VALUES ('13750', '23', 'Корнелия', 'Cornelia', 'GA', '30531', '34.4968', '-83.5849');
INSERT INTO `net_city` VALUES ('13751', '23', 'Лейкмонт', 'Lakemont', 'GA', '30552', '34.7802', '-83.4455');
INSERT INTO `net_city` VALUES ('13752', '23', 'Сидарвилл', 'Cedarville', 'OH', '45314', '39.7444', '-83.7669');
INSERT INTO `net_city` VALUES ('13755', '23', 'Гуз Крик', 'Goose Creek', 'SC', '29445', '32.9878', '-80.0057');
INSERT INTO `net_city` VALUES ('13756', '23', 'Уэствилл', 'Westville', 'IN', '46391', '41.5525', '-86.9056');
INSERT INTO `net_city` VALUES ('13768', '23', 'Пирр', 'Pierre', 'SD', '57501', '44.5422', '-100.2754');
INSERT INTO `net_city` VALUES ('13777', '23', 'Терпин', 'Turpin', 'OK', '73950', '36.8350', '-100.8735');
INSERT INTO `net_city` VALUES ('13779', '23', 'Виннвуд', 'Wynnewood', 'OK', '73098', '34.6421', '-97.1689');
INSERT INTO `net_city` VALUES ('13780', '23', 'Форган', 'Forgan', 'OK', '73938', '36.9202', '-100.6001');
INSERT INTO `net_city` VALUES ('13783', '23', 'Валлиант', 'Valliant', 'OK', '74764', '34.0778', '-95.0747');
INSERT INTO `net_city` VALUES ('13784', '23', 'Панама', 'Panama', 'OK', '74951', '35.1673', '-94.6724');
INSERT INTO `net_city` VALUES ('13785', '23', 'Копан', 'Copan', 'OK', '74022', '36.9195', '-95.9753');
INSERT INTO `net_city` VALUES ('13786', '23', 'Хевенер', 'Heavener', 'OK', '74937', '34.8182', '-94.6097');
INSERT INTO `net_city` VALUES ('13787', '23', 'Калера', 'Calera', 'OK', '74730', '33.9022', '-96.4143');
INSERT INTO `net_city` VALUES ('13788', '23', 'Соллисо', 'Sallisaw', 'OK', '74955', '35.4935', '-94.7746');
INSERT INTO `net_city` VALUES ('13789', '23', 'Хартшорн', 'Hartshorne', 'OK', '74547', '34.8167', '-95.6006');
INSERT INTO `net_city` VALUES ('13790', '23', 'Порум', 'Porum', 'OK', '74455', '35.3562', '-95.2651');
INSERT INTO `net_city` VALUES ('13791', '23', 'Пото', 'Poteau', 'OK', '74953', '35.0262', '-94.5225');
INSERT INTO `net_city` VALUES ('13797', '23', 'Кифер', 'Kiefer', 'OK', '74041', '35.9448', '-96.0653');
INSERT INTO `net_city` VALUES ('13802', '23', 'Сперри', 'Sperry', 'OK', '74073', '36.2984', '-96.0027');
INSERT INTO `net_city` VALUES ('13803', '23', 'Беннингтон', 'Bennington', 'OK', '74723', '33.9980', '-96.0099');
INSERT INTO `net_city` VALUES ('13805', '23', 'Паден', 'Paden', 'OK', '74860', '35.5149', '-96.5508');
INSERT INTO `net_city` VALUES ('13806', '23', 'Мангам', 'Mangum', 'OK', '73554', '34.8494', '-99.5403');
INSERT INTO `net_city` VALUES ('13807', '23', 'Октаха', 'Oktaha', 'OK', '74450', '35.6033', '-95.4764');
INSERT INTO `net_city` VALUES ('13808', '23', 'Инола', 'Inola', 'OK', '74036', '36.1602', '-95.5027');
INSERT INTO `net_city` VALUES ('13809', '23', 'Талиайна', 'Talihina', 'OK', '74571', '34.7559', '-95.0918');
INSERT INTO `net_city` VALUES ('13811', '23', 'Шидлер', 'Shidler', 'OK', '74652', '36.8399', '-96.6202');
INSERT INTO `net_city` VALUES ('13812', '23', 'Холденвилл', 'Holdenville', 'OK', '74848', '35.0967', '-96.3540');
INSERT INTO `net_city` VALUES ('13815', '23', 'Уайтфилд', 'Whitefield', 'OK', '74472', '35.2551', '-95.2733');
INSERT INTO `net_city` VALUES ('13822', '23', 'Тишоминго', 'Tishomingo', 'OK', '73460', '34.2998', '-96.6708');
INSERT INTO `net_city` VALUES ('13823', '23', 'Айдабел', 'Idabel', 'OK', '74745', '33.8584', '-94.8045');
INSERT INTO `net_city` VALUES ('13824', '23', 'Уэбберс Фолс', 'Webbers Falls', 'OK', '74470', '35.4828', '-95.1673');
INSERT INTO `net_city` VALUES ('13830', '23', 'Спиро', 'Spiro', 'OK', '74959', '35.2683', '-94.5562');
INSERT INTO `net_city` VALUES ('13831', '23', 'Стиглер', 'Stigler', 'OK', '74462', '35.2935', '-95.1519');
INSERT INTO `net_city` VALUES ('13832', '23', 'Кушинг', 'Cushing', 'OK', '74023', '35.9592', '-96.7554');
INSERT INTO `net_city` VALUES ('13834', '23', 'Эрик', 'Erick', 'OK', '73645', '35.2262', '-99.8504');
INSERT INTO `net_city` VALUES ('13835', '23', 'Команчи', 'Comanche', 'OK', '73529', '34.3691', '-97.9380');
INSERT INTO `net_city` VALUES ('13839', '23', 'Антлерс', 'Antlers', 'OK', '74523', '34.2075', '-95.6283');
INSERT INTO `net_city` VALUES ('13840', '23', 'Краудер', 'Crowder', 'OK', '74430', '35.1240', '-95.6700');
INSERT INTO `net_city` VALUES ('13841', '23', 'Салина', 'Salina', 'OK', '74365', '36.2916', '-95.0323');
INSERT INTO `net_city` VALUES ('13842', '23', 'Гор', 'Gore', 'OK', '74435', '35.5733', '-95.1009');
INSERT INTO `net_city` VALUES ('13843', '23', 'Сейр', 'Sayre', 'OK', '73662', '35.3128', '-99.6750');
INSERT INTO `net_city` VALUES ('13844', '23', 'Ходжен', 'Hodgen', 'OK', '74939', '34.7339', '-94.6658');
INSERT INTO `net_city` VALUES ('13847', '23', 'Кинта', 'Kinta', 'OK', '74552', '35.1234', '-95.2342');
INSERT INTO `net_city` VALUES ('13848', '23', 'Мак-Кертейн', 'Mccurtain', 'OK', '74944', '35.1273', '-95.0059');
INSERT INTO `net_city` VALUES ('13849', '23', 'Кеота', 'Keota', 'OK', '74941', '35.2629', '-94.8792');
INSERT INTO `net_city` VALUES ('13850', '23', 'Панола', 'Panola', 'OK', '74559', '34.9287', '-95.2133');
INSERT INTO `net_city` VALUES ('13851', '23', 'Маунтин-Вью', 'Mountain View', 'OK', '73062', '35.0443', '-98.7347');
INSERT INTO `net_city` VALUES ('13852', '23', 'Колберт', 'Colbert', 'OK', '74733', '33.8308', '-96.4775');
INSERT INTO `net_city` VALUES ('13853', '23', 'Рейдон', 'Reydon', 'OK', '73660', '35.6426', '-99.9011');
INSERT INTO `net_city` VALUES ('13855', '23', 'Уорнер', 'Warner', 'OK', '74469', '35.5010', '-95.3228');
INSERT INTO `net_city` VALUES ('13856', '23', 'Биксби', 'Bixby', 'OK', '74008', '35.9221', '-95.8776');
INSERT INTO `net_city` VALUES ('13858', '23', 'Тафт', 'Taft', 'OK', '74463', '35.7584', '-95.5534');
INSERT INTO `net_city` VALUES ('13859', '23', 'Коуета', 'Coweta', 'OK', '74429', '35.9115', '-95.6152');
INSERT INTO `net_city` VALUES ('13861', '23', 'Маклауд', 'Mcloud', 'OK', '74851', '35.4127', '-97.0712');
INSERT INTO `net_city` VALUES ('13862', '23', 'Парк Хилл', 'Park Hill', 'OK', '74451', '35.7547', '-94.9842');
INSERT INTO `net_city` VALUES ('13864', '23', 'Бойсе Сити', 'Boise City', 'OK', '73933', '36.7506', '-102.5981');
INSERT INTO `net_city` VALUES ('13865', '23', 'Виан', 'Vian', 'OK', '74962', '35.5377', '-94.9540');
INSERT INTO `net_city` VALUES ('13869', '23', 'Лефлор', 'Leflore', 'OK', '74942', '34.8987', '-94.9802');
INSERT INTO `net_city` VALUES ('13870', '23', 'Дастин', 'Dustin', 'OK', '74839', '35.2439', '-96.0649');
INSERT INTO `net_city` VALUES ('13872', '23', 'Хаммон', 'Hammon', 'OK', '73650', '35.6335', '-99.3922');
INSERT INTO `net_city` VALUES ('13873', '23', 'Улога', 'Oologah', 'OK', '74053', '36.4345', '-95.7358');
INSERT INTO `net_city` VALUES ('13876', '23', 'Бокчито', 'Bokchito', 'OK', '74726', '33.9469', '-96.1749');
INSERT INTO `net_city` VALUES ('13877', '23', 'Уилсон', 'Wilson', 'OK', '73463', '34.1190', '-97.4273');
INSERT INTO `net_city` VALUES ('13878', '23', 'Койл', 'Coyle', 'OK', '73027', '35.9695', '-97.2676');
INSERT INTO `net_city` VALUES ('13880', '23', 'Аллен', 'Allen', 'OK', '74825', '34.8021', '-96.4039');
INSERT INTO `net_city` VALUES ('13881', '23', 'Уэлитка', 'Weleetka', 'OK', '74880', '35.4067', '-96.1141');
INSERT INTO `net_city` VALUES ('13883', '23', 'Нашоба', 'Nashoba', 'OK', '74558', '34.4904', '-95.1480');
INSERT INTO `net_city` VALUES ('13887', '23', 'Сопер', 'Soper', 'OK', '74759', '34.0187', '-95.7151');
INSERT INTO `net_city` VALUES ('13888', '23', 'Уистер', 'Wister', 'OK', '74966', '35.0044', '-94.8091');
INSERT INTO `net_city` VALUES ('13890', '23', 'Стонуолл', 'Stonewall', 'OK', '74871', '34.6028', '-96.5448');
INSERT INTO `net_city` VALUES ('13891', '23', 'Ашер', 'Asher', 'OK', '74826', '35.0141', '-96.9101');
INSERT INTO `net_city` VALUES ('13892', '23', 'Мойерс', 'Moyers', 'OK', '74557', '34.4020', '-95.6731');
INSERT INTO `net_city` VALUES ('13893', '23', 'Балко', 'Balko', 'OK', '73931', '36.6209', '-100.7748');
INSERT INTO `net_city` VALUES ('13894', '23', 'Босуэлл', 'Boswell', 'OK', '74727', '34.0261', '-95.8604');
INSERT INTO `net_city` VALUES ('13895', '23', 'Кларита', 'Clarita', 'OK', '74535', '34.4829', '-96.4333');
INSERT INTO `net_city` VALUES ('13896', '23', 'Конава', 'Konawa', 'OK', '74849', '34.9706', '-96.7282');
INSERT INTO `net_city` VALUES ('13897', '23', 'Чекота', 'Checotah', 'OK', '74426', '35.4364', '-95.4865');
INSERT INTO `net_city` VALUES ('13898', '23', 'Ноуота', 'Nowata', 'OK', '74048', '36.6969', '-95.6791');
INSERT INTO `net_city` VALUES ('13901', '23', 'Колкорд', 'Colcord', 'OK', '74338', '36.2588', '-94.7527');
INSERT INTO `net_city` VALUES ('13904', '23', 'Каунтилайн', 'Countyline', 'OK', '73425', '34.4487', '-97.5628');
INSERT INTO `net_city` VALUES ('13906', '23', 'Юфола', 'Eufaula', 'OK', '74432', '35.3072', '-95.7216');
INSERT INTO `net_city` VALUES ('13908', '23', 'Чокто', 'Choctaw', 'OK', '73020', '35.4568', '-97.2652');
INSERT INTO `net_city` VALUES ('13909', '23', 'Мод', 'Maud', 'OK', '74854', '35.1306', '-96.7853');
INSERT INTO `net_city` VALUES ('13910', '23', 'Марленд', 'Marland', 'OK', '74644', '36.5459', '-97.0948');
INSERT INTO `net_city` VALUES ('13911', '23', 'Келливилл', 'Kellyville', 'OK', '74039', '35.8967', '-96.2198');
INSERT INTO `net_city` VALUES ('13912', '23', 'Лангстон', 'Langston', 'OK', '73050', '35.9275', '-97.2656');
INSERT INTO `net_city` VALUES ('13913', '23', 'Дженкс', 'Jenks', 'OK', '74037', '36.0027', '-95.9775');
INSERT INTO `net_city` VALUES ('13914', '23', 'Вапанака', 'Wapanucka', 'OK', '73461', '34.3464', '-96.4304');
INSERT INTO `net_city` VALUES ('13917', '23', 'Покассет', 'Pocasset', 'OK', '73079', '35.2181', '-98.0191');
INSERT INTO `net_city` VALUES ('13919', '23', 'Алекс', 'Alex', 'OK', '73002', '34.9413', '-97.7366');
INSERT INTO `net_city` VALUES ('13920', '23', 'Боулегс', 'Bowlegs', 'OK', '74830', '35.1469', '-96.6639');
INSERT INTO `net_city` VALUES ('13922', '23', 'Бокош', 'Bokoshe', 'OK', '74930', '35.1870', '-94.8005');
INSERT INTO `net_city` VALUES ('13923', '23', 'Боли', 'Boley', 'OK', '74829', '35.5121', '-96.4679');
INSERT INTO `net_city` VALUES ('13924', '23', 'Форт Гибсон', 'Fort Gibson', 'OK', '74434', '35.8006', '-95.1910');
INSERT INTO `net_city` VALUES ('13929', '23', 'Саванна', 'Savanna', 'OK', '74565', '34.8290', '-95.8439');
INSERT INTO `net_city` VALUES ('13930', '23', 'Кейес', 'Keyes', 'OK', '73947', '36.8133', '-102.2387');
INSERT INTO `net_city` VALUES ('13931', '23', 'Малдроу', 'Muldrow', 'OK', '74948', '35.4821', '-94.5690');
INSERT INTO `net_city` VALUES ('13935', '23', 'Винита', 'Vinita', 'OK', '74301', '36.6873', '-95.2618');
INSERT INTO `net_city` VALUES ('13940', '23', 'Мадилл', 'Madill', 'OK', '73446', '34.0784', '-96.7598');
INSERT INTO `net_city` VALUES ('13944', '23', 'Грант', 'Grant', 'OK', '74738', '33.9137', '-95.4592');
INSERT INTO `net_city` VALUES ('13945', '23', 'Барнсдолл', 'Barnsdall', 'OK', '74002', '36.5549', '-96.1481');
INSERT INTO `net_city` VALUES ('13947', '23', 'Драмрайт', 'Drumright', 'OK', '74030', '35.9737', '-96.5544');
INSERT INTO `net_city` VALUES ('13948', '23', 'Уэтумка', 'Wetumka', 'OK', '74883', '35.2145', '-96.2473');
INSERT INTO `net_city` VALUES ('13949', '23', 'Страуд', 'Stroud', 'OK', '74079', '35.7397', '-96.6718');
INSERT INTO `net_city` VALUES ('13950', '23', 'Пегс', 'Peggs', 'OK', '74452', '36.1154', '-95.0849');
INSERT INTO `net_city` VALUES ('13952', '23', 'Элмор Сити', 'Elmore City', 'OK', '73433', '34.6263', '-97.4138');
INSERT INTO `net_city` VALUES ('13954', '23', 'Хендрикс', 'Hendrix', 'OK', '74741', '33.7736', '-96.2582');
INSERT INTO `net_city` VALUES ('13955', '23', 'Хардести', 'Hardesty', 'OK', '73944', '36.6087', '-101.1219');
INSERT INTO `net_city` VALUES ('13956', '23', 'Генриетта', 'Henryetta', 'OK', '74437', '35.4345', '-95.8932');
INSERT INTO `net_city` VALUES ('13957', '23', 'Фредерик', 'Frederick', 'OK', '73542', '34.4425', '-98.9498');
INSERT INTO `net_city` VALUES ('13958', '23', 'Милберн', 'Milburn', 'OK', '73450', '34.2959', '-96.5243');
INSERT INTO `net_city` VALUES ('13970', '23', 'Саратога', 'Saratoga', 'CA', '95070', '37.2539', '-122.0638');
INSERT INTO `net_city` VALUES ('13974', '23', 'Сан Ансельмо', 'San Anselmo', 'CA', '94960', '37.9922', '-122.5814');
INSERT INTO `net_city` VALUES ('13995', '21', 'Лутон', 'Luton', 'I1', '', '51.8833', '-0.4167');
INSERT INTO `net_city` VALUES ('13999', '21', 'Кидлингтон', 'Kidlington', 'K2', '', '51.8167', '-1.2833');
INSERT INTO `net_city` VALUES ('14005', '23', 'Крестлайн', 'Crestline', 'CA', '92325', '34.2557', '-117.3040');
INSERT INTO `net_city` VALUES ('14009', '23', 'Инглсайд', 'Ingleside', 'IL', '60041', '42.3677', '-88.1497');
INSERT INTO `net_city` VALUES ('14014', '23', 'Крет', 'Crete', 'IL', '60417', '41.4271', '-87.5981');
INSERT INTO `net_city` VALUES ('14025', '34', 'Рамат-Ган', 'Ramat Gan', '05', '', '32.0806', '34.8142');
INSERT INTO `net_city` VALUES ('14026', '23', 'Рок-Крик', 'Rock Creek', 'OH', '44084', '41.6695', '-80.9065');
INSERT INTO `net_city` VALUES ('14033', '23', 'Уинни', 'Winnie', 'TX', '77665', '29.8152', '-94.4010');
INSERT INTO `net_city` VALUES ('14035', '23', 'Бирден', 'Bearden', 'AR', '71720', '33.7940', '-92.6389');
INSERT INTO `net_city` VALUES ('14040', '23', 'Прентисс', 'Prentiss', 'MS', '39474', '31.6145', '-89.8271');
INSERT INTO `net_city` VALUES ('14042', '23', 'Малберри', 'Mulberry', 'AR', '72947', '35.5886', '-94.0275');
INSERT INTO `net_city` VALUES ('14047', '23', 'Диркс', 'Dierks', 'AR', '71833', '34.1333', '-94.0325');
INSERT INTO `net_city` VALUES ('14051', '23', 'Локсберг', 'Lockesburg', 'AR', '71846', '33.9530', '-94.1045');
INSERT INTO `net_city` VALUES ('14054', '23', 'Хоштон', 'Hoschton', 'GA', '30548', '34.0977', '-83.7762');
INSERT INTO `net_city` VALUES ('14055', '23', 'Бетлехем', 'Bethlehem', 'GA', '30620', '33.9297', '-83.7447');
INSERT INTO `net_city` VALUES ('14058', '23', 'Пангберн', 'Pangburn', 'AR', '72121', '35.4475', '-91.7976');
INSERT INTO `net_city` VALUES ('14059', '23', 'Праттсвилл', 'Prattsville', 'AR', '72129', '34.3306', '-92.5444');
INSERT INTO `net_city` VALUES ('14063', '23', 'Каннаполис', 'Kannapolis', 'NC', '28081', '35.4973', '-80.6755');
INSERT INTO `net_city` VALUES ('14064', '23', 'Маунт Перри', 'Mount Perry', 'OH', '43760', '39.8758', '-82.1801');
INSERT INTO `net_city` VALUES ('14069', '23', 'Маунт-Плезант', 'Mount Pleasant', 'NC', '28124', '35.3874', '-80.4067');
INSERT INTO `net_city` VALUES ('14075', '23', 'Окборо', 'Oakboro', 'NC', '28129', '35.2361', '-80.3098');
INSERT INTO `net_city` VALUES ('14084', '59', 'Лозанна', 'Lausanne', '23', '', '46.5333', '6.6667');
INSERT INTO `net_city` VALUES ('14085', '23', 'Бат', 'Bath', 'ME', '04530', '43.9030', '-69.8506');
INSERT INTO `net_city` VALUES ('14091', '23', 'Хайсвилл', 'Haysville', 'KS', '67060', '37.5433', '-97.3657');
INSERT INTO `net_city` VALUES ('14109', '23', 'Флорал Парк', 'Floral Park', 'NY', '11001', '40.7251', '-73.7070');
INSERT INTO `net_city` VALUES ('14114', '23', 'Гринпорт', 'Greenport', 'NY', '11944', '41.1021', '-72.3742');
INSERT INTO `net_city` VALUES ('14116', '23', 'Болдуин Плейс', 'Baldwin Place', 'NY', '10505', '41.3422', '-73.7449');
INSERT INTO `net_city` VALUES ('14121', '23', 'Рузвельт', 'Roosevelt', 'NY', '11575', '40.6784', '-73.5851');
INSERT INTO `net_city` VALUES ('14124', '23', 'Фармингвилл', 'Farmingville', 'NY', '11738', '40.8408', '-73.0395');
INSERT INTO `net_city` VALUES ('14125', '23', 'Локуст Валли', 'Locust Valley', 'NY', '11560', '40.8740', '-73.5927');
INSERT INTO `net_city` VALUES ('14140', '23', 'Массапеква Парк', 'Massapequa Park', 'NY', '11762', '40.6789', '-73.4474');
INSERT INTO `net_city` VALUES ('14141', '29', 'Франкфурт', 'Frankfurt am Main', '05', '', '50.1167', '8.6833');
INSERT INTO `net_city` VALUES ('14143', '23', 'Манорвилл', 'Manorville', 'NY', '11949', '40.8674', '-72.7943');
INSERT INTO `net_city` VALUES ('14147', '23', 'Сентерич', 'Centereach', 'NY', '11720', '40.8732', '-73.0812');
INSERT INTO `net_city` VALUES ('14151', '23', 'Ардсли', 'Ardsley', 'NY', '10502', '41.0101', '-73.8413');
INSERT INTO `net_city` VALUES ('14153', '23', 'Кинсберг', 'Keansburg', 'NJ', '07734', '40.4426', '-74.1326');
INSERT INTO `net_city` VALUES ('14166', '24', 'Монктон', 'Moncton', 'NB', 'e1c8l3', '46.0833', '-64.7667');
INSERT INTO `net_city` VALUES ('14169', '156', 'Барригада', 'Barrigada', '00', '96913', '13.4443', '144.7863');
INSERT INTO `net_city` VALUES ('14172', '23', 'Арвада', 'Arvada', 'CO', '80002', '39.7941', '-105.1019');
INSERT INTO `net_city` VALUES ('14173', '23', 'Верона', 'Verona', 'NY', '13478', '43.1499', '-75.5848');
INSERT INTO `net_city` VALUES ('14176', '23', 'Байнбридж', 'Bainbridge', 'GA', '39818', '30.9038', '-84.5755');
INSERT INTO `net_city` VALUES ('14181', '23', 'Дуглас', 'Douglas', 'WY', '82633', '43.0600', '-105.2960');
INSERT INTO `net_city` VALUES ('14183', '23', 'Уиллкокс', 'Willcox', 'AZ', '85644', '32.2529', '-109.8320');
INSERT INTO `net_city` VALUES ('14184', '23', 'Эндикотт', 'Endicott', 'NY', '13760', '42.1460', '-76.0909');
INSERT INTO `net_city` VALUES ('14185', '23', 'Кокран', 'Cochran', 'GA', '31014', '32.4333', '-83.3410');
INSERT INTO `net_city` VALUES ('14188', '23', 'Свайнсборо', 'Swainsboro', 'GA', '30401', '32.6074', '-82.3580');
INSERT INTO `net_city` VALUES ('14198', '23', 'Бич Гров', 'Beech Grove', 'IN', '46107', '39.7139', '-86.0886');
INSERT INTO `net_city` VALUES ('14199', '23', 'Дос Палос', 'Dos Palos', 'CA', '93620', '37.0713', '-120.6385');
INSERT INTO `net_city` VALUES ('14245', '23', 'Блитвуд', 'Blythewood', 'SC', '29016', '34.2038', '-80.9955');
INSERT INTO `net_city` VALUES ('14264', '24', 'Суррей', 'Surrey', 'BC', 'v3r7k1', '49.1364', '-122.8213');
INSERT INTO `net_city` VALUES ('14266', '56', 'Брюссель', 'Brussels', '11', '', '50.8333', '4.3333');
INSERT INTO `net_city` VALUES ('14269', '23', 'Комбс', 'Combs', 'KY', '41729', '37.2694', '-83.2075');
INSERT INTO `net_city` VALUES ('14277', '23', 'Бакханнон', 'Buckhannon', 'WV', '26201', '38.9822', '-80.2008');
INSERT INTO `net_city` VALUES ('14290', '23', 'Хайнсберг', 'Hinesburg', 'VT', '05461', '44.3175', '-73.0909');
INSERT INTO `net_city` VALUES ('14307', '56', 'Шарлеруа', 'Charleroi', '03', '', '50.4167', '4.4333');
INSERT INTO `net_city` VALUES ('14309', '23', 'Кларендон Хилс', 'Clarendon Hills', 'IL', '60514', '41.7959', '-87.9590');
INSERT INTO `net_city` VALUES ('14310', '23', 'Ридж', 'Ridge', 'NY', '11961', '40.8992', '-72.8832');
INSERT INTO `net_city` VALUES ('14312', '23', 'Байнбридж Айленд', 'Bainbridge Island', 'WA', '98110', '47.6476', '-122.5364');
INSERT INTO `net_city` VALUES ('14313', '23', 'Паломар Маунтин', 'Palomar Mountain', 'CA', '92060', '33.3228', '-116.8786');
INSERT INTO `net_city` VALUES ('14325', '23', 'Уэнатчи', 'Wenatchee', 'WA', '98801', '47.3707', '-120.3593');
INSERT INTO `net_city` VALUES ('14326', '23', 'Биатрис', 'Beatrice', 'NE', '68310', '40.2553', '-96.7089');
INSERT INTO `net_city` VALUES ('14328', '23', 'Бэй Сити', 'Bay City', 'TX', '77414', '28.9394', '-95.7893');
INSERT INTO `net_city` VALUES ('14331', '23', 'Уэст Франкфорт', 'West Frankfort', 'IL', '62896', '37.8879', '-88.9033');
INSERT INTO `net_city` VALUES ('14333', '23', 'Окарч', 'Okarche', 'OK', '73762', '35.7039', '-98.0028');
INSERT INTO `net_city` VALUES ('14343', '23', 'Уэйнсборо', 'Waynesboro', 'VA', '22980', '38.1103', '-78.9073');
INSERT INTO `net_city` VALUES ('14350', '23', 'Хилл Сити', 'Hill City', 'SD', '57745', '43.9984', '-103.7074');
INSERT INTO `net_city` VALUES ('14355', '15', 'Стокгольм', 'Stockholm', '26', '', '59.3333', '18.0500');
INSERT INTO `net_city` VALUES ('14356', '15', 'Норрчёпинг', 'Norrkoping', '16', '', '58.6000', '16.1833');
INSERT INTO `net_city` VALUES ('14359', '35', 'Мадрид', 'Madrid', '29', '', '40.4086', '-3.6922');
INSERT INTO `net_city` VALUES ('14374', '24', 'Бленвиль', 'Blainville', 'QC', 'j7c5e2', '45.6730', '-73.8800');
INSERT INTO `net_city` VALUES ('14393', '23', 'Смиттон', 'Smithton', 'IL', '62285', '38.3859', '-90.0104');
INSERT INTO `net_city` VALUES ('14400', '24', 'Келоуна', 'Kelowna', 'BC', 'v1v1v7', '49.9000', '-119.4833');
INSERT INTO `net_city` VALUES ('14405', '12', 'Монпелье', 'Montpellier', 'A9', '', '43.6109', '3.8772');
INSERT INTO `net_city` VALUES ('14409', '1', 'Мельбурн', 'Melbourne', '07', '', '-37.8139', '144.9634');
INSERT INTO `net_city` VALUES ('14410', '21', 'Шеффилд', 'Sheffield', 'L9', '', '53.3667', '-1.5000');
INSERT INTO `net_city` VALUES ('14413', '21', 'Дарлингтон', 'Darlington', 'D1', '', '54.5333', '-1.5667');
INSERT INTO `net_city` VALUES ('14414', '59', 'Бад-Цурцах', 'Bad Zurzach', '01', '', '47.5892', '8.2896');
INSERT INTO `net_city` VALUES ('14418', '59', 'Аарау', 'Aarau', '01', '', '47.3896', '8.0524');
INSERT INTO `net_city` VALUES ('14419', '15', 'Эслёв', 'Eslöv', '27', '', '55.8333', '13.3333');
INSERT INTO `net_city` VALUES ('14420', '1', 'Джелонг', 'Geelong', '07', '', '-38.1535', '144.3581');
INSERT INTO `net_city` VALUES ('14421', '59', 'Крисье', 'Crissier', '23', '', '46.5517', '6.5713');
INSERT INTO `net_city` VALUES ('14423', '35', 'Сабадель', 'Sabadell', '56', '', '41.5433', '2.1094');
INSERT INTO `net_city` VALUES ('14424', '59', 'Фрибур', 'Fribourg', '06', '', '46.7957', '7.1547');
INSERT INTO `net_city` VALUES ('14425', '59', 'Гларус', 'Glarus', '08', '', '47.0406', '9.0680');
INSERT INTO `net_city` VALUES ('14426', '59', 'Вайнфельден', 'Weinfelden', '19', '', '47.5662', '9.1075');
INSERT INTO `net_city` VALUES ('14427', '33', 'Девентер', 'Deventer', '15', '', '52.2500', '6.2000');
INSERT INTO `net_city` VALUES ('14431', '4', 'Шанхай', 'Shanghai', '23', '', '31.0456', '121.3997');
INSERT INTO `net_city` VALUES ('14434', '23', 'Крессона', 'Cressona', 'PA', '17929', '40.6319', '-76.1947');
INSERT INTO `net_city` VALUES ('14435', '33', 'Амстердам', 'Amsterdam', '07', '', '52.3500', '4.9167');
INSERT INTO `net_city` VALUES ('14436', '35', 'Бадалона', 'Badalona', '56', '', '41.4471', '2.2448');
INSERT INTO `net_city` VALUES ('14438', '125', 'Берум', 'Baerum', '01', '', '59.9000', '10.6000');
INSERT INTO `net_city` VALUES ('14439', '21', 'Дерби', 'Derby', 'D2', '', '52.9333', '-1.5000');
INSERT INTO `net_city` VALUES ('14440', '1', 'Квинсферри', 'Queensferry', '07', '', '-38.4167', '145.5000');
INSERT INTO `net_city` VALUES ('14441', '21', 'Бристоль', 'Bristol', 'B7', '', '51.4500', '-2.5833');
INSERT INTO `net_city` VALUES ('14442', '23', 'Райтвуд', 'Wrightwood', 'CA', '92397', '34.3663', '-117.6121');
INSERT INTO `net_city` VALUES ('14445', '23', 'Ранчо Палос Вердес', 'Rancho Palos Verdes', 'CA', '90275', '33.7584', '-118.3163');
INSERT INTO `net_city` VALUES ('14454', '24', 'Бросар', 'Brossard', 'QC', 'j4x1c2', '45.4500', '-73.4833');
INSERT INTO `net_city` VALUES ('14460', '23', 'Кастер', 'Custer', 'WA', '98240', '48.9420', '-122.6253');
INSERT INTO `net_city` VALUES ('14468', '24', 'Делта', 'Delta (British Columbia)', 'BC', 'v3m6e7', '49.0192', '-123.0867');
INSERT INTO `net_city` VALUES ('14476', '24', 'Сарния', 'Sarnia', 'ON', 'n7t7k4', '42.9667', '-82.4000');
INSERT INTO `net_city` VALUES ('14477', '24', 'Дон Милс', 'Don Mills', 'ON', 'm3c1v6', '43.7333', '-79.3333');
INSERT INTO `net_city` VALUES ('14492', '24', 'Мейпл Ридж', 'Maple Ridge', 'BC', 'v2x8n6', '49.2500', '-122.5000');
INSERT INTO `net_city` VALUES ('14500', '24', 'Норт-Бей', 'North Bay', 'ON', 'p1b8k9', '46.3000', '-79.4500');
INSERT INTO `net_city` VALUES ('14509', '24', 'Вермилен', 'Vermilion', 'AB', 't1k1l6', '53.3500', '-110.8500');
INSERT INTO `net_city` VALUES ('14511', '24', 'Медисин-Хат', 'Medicine Hat', 'AB', 't1a3y6', '50.0333', '-110.6833');
INSERT INTO `net_city` VALUES ('14528', '24', 'Камлупс', 'Kamloops', 'BC', 'v2c5n3', '50.6667', '-120.3333');
INSERT INTO `net_city` VALUES ('14541', '23', 'Слиппери Рок', 'Slippery Rock', 'PA', '16057', '41.0456', '-80.0696');
INSERT INTO `net_city` VALUES ('14554', '23', 'Суит Брайр', 'Sweet Briar', 'VA', '24595', '37.5627', '-79.0824');
INSERT INTO `net_city` VALUES ('14557', '23', 'Харвинтон', 'Harwinton', 'CT', '06791', '41.7525', '-73.0604');
INSERT INTO `net_city` VALUES ('14558', '23', 'Леонард', 'Leonard', 'OK', '74043', '35.9204', '-95.7994');
INSERT INTO `net_city` VALUES ('14570', '24', 'Лавал', 'Laval', 'QC', 'h7s2a4', '45.6167', '-73.7500');
INSERT INTO `net_city` VALUES ('14582', '23', 'Нью Мартинсвилл', 'New Martinsville', 'WV', '26155', '39.6232', '-80.7596');
INSERT INTO `net_city` VALUES ('14595', '23', 'Бофорт', 'Beaufort', 'NC', '28516', '34.8481', '-76.6115');
INSERT INTO `net_city` VALUES ('14598', '23', 'Элизабет Сити', 'Elizabeth City', 'NC', '27909', '36.3170', '-76.2754');
INSERT INTO `net_city` VALUES ('14601', '59', 'Цюрих', 'Zurich', '25', '', '47.3667', '8.5500');
INSERT INTO `net_city` VALUES ('14603', '26', 'Бермуда', 'Bermuda', '03', '', '32.2942', '-64.7839');
INSERT INTO `net_city` VALUES ('14607', '23', 'Лейси', 'Lacey', 'WA', '98509', '47.0343', '-122.8232');
INSERT INTO `net_city` VALUES ('14614', '5', 'Токио', 'Tokyo', '40', '', '35.6850', '139.7514');
INSERT INTO `net_city` VALUES ('14615', '29', 'Карлсруэ', 'Karlsruhe', '01', '', '49.0047', '8.3858');
INSERT INTO `net_city` VALUES ('14616', '59', 'Лугано', 'Lugano', '20', '', '46.0062', '8.9511');
INSERT INTO `net_city` VALUES ('14617', '29', 'Кёльн', 'Cologne', '07', '', '50.9333', '6.9500');
INSERT INTO `net_city` VALUES ('14634', '24', 'Халтон Хилс', 'Halton Hills', 'ON', 'l7g4x4', '43.6526', '-79.9281');
INSERT INTO `net_city` VALUES ('14645', '23', 'Клинтон', 'Clinton', 'SC', '29325', '34.4620', '-81.8197');
INSERT INTO `net_city` VALUES ('14646', '23', 'Аламогордо', 'Alamogordo', 'NM', '88310', '32.8426', '-105.9891');
INSERT INTO `net_city` VALUES ('14648', '23', 'Мориарти', 'Moriarty', 'NM', '87035', '34.9555', '-105.9957');
INSERT INTO `net_city` VALUES ('14649', '23', 'Эстансия', 'Estancia', 'NM', '87016', '34.7485', '-106.0882');
INSERT INTO `net_city` VALUES ('14650', '23', 'Вон', 'Vaughn', 'NM', '88353', '34.6065', '-105.1023');
INSERT INTO `net_city` VALUES ('14651', '23', 'Алгодонс', 'Algodones', 'NM', '87001', '35.3540', '-106.3799');
INSERT INTO `net_city` VALUES ('14654', '23', 'Херлонг', 'Herlong', 'CA', '96113', '40.2018', '-120.1969');
INSERT INTO `net_city` VALUES ('14656', '23', 'Маунт Лагуна', 'Mount Laguna', 'CA', '91948', '32.8723', '-116.4184');
INSERT INTO `net_city` VALUES ('14675', '23', 'Огаллала', 'Ogallala', 'NE', '69153', '41.0987', '-101.6619');
INSERT INTO `net_city` VALUES ('14676', '24', 'Окотокс', 'Okotoks', 'AB', 't0c1t0', '50.7167', '-113.9667');
INSERT INTO `net_city` VALUES ('14678', '23', 'Пекос', 'Pecos', 'TX', '79772', '31.3086', '-103.5892');
INSERT INTO `net_city` VALUES ('14681', '24', 'Викториавилл', 'Victoriaville', 'QC', '', '46.0631', '-71.9588');
INSERT INTO `net_city` VALUES ('14685', '24', 'Темискаминг Шорс', 'Temiskaming Shores', 'ON', 'p0j1p0', '47.5000', '-79.6667');
INSERT INTO `net_city` VALUES ('14686', '23', 'Баффало', 'Buffalo', 'MN', '55313', '45.1845', '-93.8397');
INSERT INTO `net_city` VALUES ('14689', '23', 'Вакония', 'Waconia', 'MN', '55387', '44.8547', '-93.7854');
INSERT INTO `net_city` VALUES ('14692', '24', 'Пентиктон', 'Penticton', 'BC', '', '49.5000', '-119.5833');
INSERT INTO `net_city` VALUES ('14694', '23', 'Хиббинг', 'Hibbing', 'MN', '55746', '47.4080', '-92.9669');
INSERT INTO `net_city` VALUES ('14700', '23', 'Альберт-Ли', 'Albert Lea', 'MN', '56007', '43.6583', '-93.3759');
INSERT INTO `net_city` VALUES ('14702', '24', 'Смитерс', 'Smithers', 'BC', '', '54.7667', '-127.1667');
INSERT INTO `net_city` VALUES ('14703', '24', 'Селкирк', 'Selkirk', 'MB', '', '50.1500', '-96.8833');
INSERT INTO `net_city` VALUES ('14704', '23', 'Салида', 'Salida', 'CO', '81201', '38.5619', '-106.1153');
INSERT INTO `net_city` VALUES ('14706', '24', 'Олдс', 'Olds', 'AB', '', '51.7833', '-114.1000');
INSERT INTO `net_city` VALUES ('14707', '24', 'Чилливак', 'Chilliwack', 'BC', '', '49.1667', '-121.9500');
INSERT INTO `net_city` VALUES ('14708', '24', 'Элора', 'Elora', 'ON', '', '43.6844', '-80.4301');
INSERT INTO `net_city` VALUES ('14710', '23', 'Гленшо', 'Glenshaw', 'PA', '15116', '40.5447', '-79.9288');
INSERT INTO `net_city` VALUES ('14715', '23', 'Таос', 'Taos', 'NM', '87571', '36.4146', '-105.5222');
INSERT INTO `net_city` VALUES ('14726', '23', 'Джиллетт', 'Gillette', 'WY', '82716', '44.5562', '-105.6665');
INSERT INTO `net_city` VALUES ('14731', '24', 'Рокленд', 'Rockland', 'ON', 'k4k1k2', '45.5459', '-75.2836');
INSERT INTO `net_city` VALUES ('14742', '23', 'Мортаун', 'Moretown', 'VT', '05660', '44.2466', '-72.7727');
INSERT INTO `net_city` VALUES ('14756', '24', 'Лоренстаун', 'Lawrencetown', 'NS', '', '44.6333', '-63.3500');
INSERT INTO `net_city` VALUES ('14763', '24', 'Аджакс', 'Ajax', 'ON', 'l1s6z6', '43.8540', '-79.0202');
INSERT INTO `net_city` VALUES ('14788', '24', 'Принс-Джордж', 'Prince George', 'BC', 'v2n1p8', '53.9167', '-122.7667');
INSERT INTO `net_city` VALUES ('14795', '24', 'Порт Муди', 'Port Moody', 'BC', 'v3h1s1', '49.2833', '-122.8500');
INSERT INTO `net_city` VALUES ('14798', '24', 'Леви ', 'Levis', 'QC', 'g6v6z9', '46.8000', '-71.1667');
INSERT INTO `net_city` VALUES ('14799', '24', 'Мон-Жоли', 'Mont-Joli', 'QC', 'g5h3z4', '48.5833', '-68.1833');
INSERT INTO `net_city` VALUES ('14803', '24', 'Тандер-Бей', 'Thunder Bay', 'ON', 'p7c4w1', '48.4000', '-89.2333');
INSERT INTO `net_city` VALUES ('14805', '24', 'Уэлленд', 'Welland', 'ON', 'l3c7l3', '42.9833', '-79.2500');
INSERT INTO `net_city` VALUES ('14807', '24', 'Тимминс', 'Timmins', 'ON', 'p4n8r6', '48.4667', '-81.3333');
INSERT INTO `net_city` VALUES ('14821', '23', 'Декора', 'Decorah', 'IA', '52101', '43.3312', '-91.7510');
INSERT INTO `net_city` VALUES ('14822', '24', 'Лэнгли', 'Langley', 'BC', 'v6a4p8', '49.1000', '-122.6500');
INSERT INTO `net_city` VALUES ('14836', '23', 'Пабло', 'Pablo', 'MT', '59855', '47.6002', '-114.1190');
INSERT INTO `net_city` VALUES ('14838', '23', 'Еттерс', 'Etters', 'PA', '17319', '40.1574', '-76.7978');
INSERT INTO `net_city` VALUES ('14839', '24', 'Норт-Ванкувер', 'North Vancouver', 'BC', 'v7j3s4', '49.3167', '-123.0667');
INSERT INTO `net_city` VALUES ('14852', '23', 'Порталес', 'Portales', 'NM', '88130', '34.0697', '-103.3306');
INSERT INTO `net_city` VALUES ('14867', '23', 'Майерсдейл', 'Meyersdale', 'PA', '15552', '39.7997', '-78.9928');
INSERT INTO `net_city` VALUES ('14872', '175', 'Каракас', 'Caracas', '25', '', '10.5000', '-66.9167');
INSERT INTO `net_city` VALUES ('14887', '24', 'Бернсайд', 'Burnside', 'NL', '', '48.7000', '-53.8000');
INSERT INTO `net_city` VALUES ('14910', '24', 'Вернон', 'Vernon', 'BC', '', '50.2667', '-119.2667');
INSERT INTO `net_city` VALUES ('14912', '23', 'Варни', 'Varney', 'WV', '25696', '37.6693', '-82.1221');
INSERT INTO `net_city` VALUES ('14922', '23', 'Уопетон', 'Wahpeton', 'ND', '58075', '46.2900', '-96.7258');
INSERT INTO `net_city` VALUES ('14927', '23', 'Бревард', 'Brevard', 'NC', '28712', '35.1698', '-82.7897');
INSERT INTO `net_city` VALUES ('14934', '24', 'Роки Маунтин Хаус', 'Rocky Mountain House', 'AB', '', '52.3667', '-114.9167');
INSERT INTO `net_city` VALUES ('14935', '23', 'Кеннбанкпорт', 'Kennebunkport', 'ME', '04046', '43.4183', '-70.4984');
INSERT INTO `net_city` VALUES ('14937', '24', 'Хьюстон', 'Houston', 'BC', '', '54.4000', '-126.6500');
INSERT INTO `net_city` VALUES ('14938', '23', 'Аппоматтокс', 'Appomattox', 'VA', '24522', '37.3543', '-78.7583');
INSERT INTO `net_city` VALUES ('14942', '23', 'Льюисберг', 'Lewisburg', 'WV', '24901', '37.8511', '-80.4466');
INSERT INTO `net_city` VALUES ('14944', '23', 'Стейплс', 'Staples', 'MN', '56479', '46.3851', '-94.8082');
INSERT INTO `net_city` VALUES ('14945', '23', 'Ричленд Сентер', 'Richland Center', 'WI', '53581', '43.3775', '-90.4250');
INSERT INTO `net_city` VALUES ('14969', '23', 'Чино Хилс', 'Chino Hills', 'CA', '91709', '33.9473', '-117.7289');
INSERT INTO `net_city` VALUES ('14971', '23', 'Энфилд', 'Enfield', 'NH', '03748', '43.6154', '-72.1142');
INSERT INTO `net_city` VALUES ('14975', '23', 'Годфри', 'Godfrey', 'IL', '62035', '38.9609', '-90.2571');
INSERT INTO `net_city` VALUES ('14976', '23', 'Принсевилл', 'Princeville', 'IL', '61559', '40.9199', '-89.7802');
INSERT INTO `net_city` VALUES ('14990', '23', 'Вермиллион', 'Vermillion', 'SD', '57069', '42.8369', '-96.9833');
INSERT INTO `net_city` VALUES ('14992', '13', 'Милан', 'Milan', '09', '', '45.4667', '9.2000');
INSERT INTO `net_city` VALUES ('14998', '21', 'Слау', 'Slough', 'M1', '', '51.5000', '-0.5833');
INSERT INTO `net_city` VALUES ('15000', '33', 'Берген-оп-Зом', 'Bergen op Zoom', '06', '', '51.4945', '4.2835');
INSERT INTO `net_city` VALUES ('15003', '23', 'Эммитсберг', 'Emmitsburg', 'MD', '21727', '39.6752', '-77.3360');
INSERT INTO `net_city` VALUES ('15014', '1', 'Канберра', 'Canberra', '01', '', '-35.2760', '149.1344');
INSERT INTO `net_city` VALUES ('15015', '23', 'Эстилл Спрингс', 'Estill Springs', 'TN', '37330', '35.2712', '-86.1521');
INSERT INTO `net_city` VALUES ('15016', '23', 'Индиалантик', 'Indialantic', 'FL', '32903', '28.1075', '-80.5803');
INSERT INTO `net_city` VALUES ('15018', '23', 'Драйден', 'Dryden', 'NY', '13053', '42.4777', '-76.2700');
INSERT INTO `net_city` VALUES ('15022', '23', 'Херкимер', 'Herkimer', 'NY', '13350', '43.0762', '-75.0061');
INSERT INTO `net_city` VALUES ('15039', '1', 'Сидней', 'Sydney', '02', '', '-33.8615', '151.2055');
INSERT INTO `net_city` VALUES ('15044', '24', 'Порт Хоксбери', 'Port Hawkesbury', 'NS', 'b0e2v0', '45.6262', '-61.3171');
INSERT INTO `net_city` VALUES ('15048', '23', 'Пикаюн', 'Picayune', 'MS', '39466', '30.5354', '-89.4600');
INSERT INTO `net_city` VALUES ('15056', '23', 'Хейли', 'Hailey', 'ID', '83333', '43.5770', '-114.2140');
INSERT INTO `net_city` VALUES ('15078', '23', 'Клемсон', 'Clemson', 'SC', '29634', '34.8474', '-82.7101');
INSERT INTO `net_city` VALUES ('15081', '23', 'Бар Харбор', 'Bar Harbor', 'ME', '04609', '44.3761', '-68.2757');
INSERT INTO `net_city` VALUES ('15093', '56', 'Звевегем', 'Zwevegem', '09', '', '50.8000', '3.3333');
INSERT INTO `net_city` VALUES ('15094', '139', 'Эспоо', 'Espoo', '13', '', '60.2167', '24.6667');
INSERT INTO `net_city` VALUES ('15104', '127', 'Вена', 'Vienna', '09', '', '48.2000', '16.3667');
INSERT INTO `net_city` VALUES ('15105', '24', 'Ричмонд-Хилл', 'Richmond Hill', 'ON', 'l4b2n3', '43.8777', '-79.4359');
INSERT INTO `net_city` VALUES ('15128', '23', 'Эванс', 'Evans', 'GA', '30809', '33.5578', '-82.1648');
INSERT INTO `net_city` VALUES ('15130', '23', 'Линкольнтон', 'Lincolnton', 'GA', '30817', '33.7855', '-82.4198');
INSERT INTO `net_city` VALUES ('15151', '24', 'Берлингтон', 'Burlington', 'ON', 'l7l6b8', '43.3274', '-79.7989');
INSERT INTO `net_city` VALUES ('15183', '23', 'Ковентри', 'Coventry', 'RI', '02816', '41.6933', '-71.6395');
INSERT INTO `net_city` VALUES ('15185', '23', 'Вудсток', 'Woodstock', 'VA', '22664', '38.8910', '-78.5341');
INSERT INTO `net_city` VALUES ('15204', '23', 'Уэстли', 'Westley', 'CA', '95387', '37.5494', '-121.1991');
INSERT INTO `net_city` VALUES ('15217', '23', 'Леверетт', 'Leverett', 'MA', '01054', '42.4745', '-72.4874');
INSERT INTO `net_city` VALUES ('15222', '23', 'Вандергрифт', 'Vandergrift', 'PA', '15690', '40.6543', '-79.4829');
INSERT INTO `net_city` VALUES ('15224', '139', 'Лохья', 'Lohja', '13', '', '60.2500', '24.0833');
INSERT INTO `net_city` VALUES ('15233', '23', 'Шалимар', 'Shalimar', 'FL', '32579', '30.4692', '-86.5791');
INSERT INTO `net_city` VALUES ('15235', '23', 'Келсивилл', 'Kelseyville', 'CA', '95451', '38.9199', '-122.7954');
INSERT INTO `net_city` VALUES ('15241', '157', 'Кингстон', 'Kingston', '08', '', '18.0000', '-76.8000');
INSERT INTO `net_city` VALUES ('15242', '37', 'Кингстаун', 'Kingstown', '04', '', '13.1333', '-61.2167');
INSERT INTO `net_city` VALUES ('15243', '176', 'Сент-Питер', 'Saint Peter', '07', '', '13.3000', '-59.5833');
INSERT INTO `net_city` VALUES ('15244', '191', 'Амман', 'Amman', '11', '', '31.9500', '35.9333');
INSERT INTO `net_city` VALUES ('15245', '38', 'Сантьяго', 'Santiago', '12', '', '-33.4500', '-70.6667');
INSERT INTO `net_city` VALUES ('15254', '24', 'Пуант-Клер', 'Pointe Claire', 'QC', 'h9r1b1', '45.4333', '-73.7500');
INSERT INTO `net_city` VALUES ('15255', '23', 'Хартвилл', 'Hartville', 'OH', '44632', '40.9586', '-81.3090');
INSERT INTO `net_city` VALUES ('15256', '215', 'Аддис-Абеба', 'Addis Ababa', '10', '', '9.0333', '38.7000');
INSERT INTO `net_city` VALUES ('15258', '170', 'Санто-Доминго', 'Santo Domingo', '05', '', '18.4667', '-69.9000');
INSERT INTO `net_city` VALUES ('15259', '25', 'Мехико', 'Mexico City', '09', '', '19.4342', '-99.1386');
INSERT INTO `net_city` VALUES ('15261', '175', 'Валенсия', 'Valencia', '07', '', '10.1806', '-68.0039');
INSERT INTO `net_city` VALUES ('15262', '161', 'Лима ', 'Lima', '15', '', '-12.0500', '-77.0500');
INSERT INTO `net_city` VALUES ('15265', '27', 'Сидра', 'Cidra', '00', '00739', '18.1819', '-66.1731');
INSERT INTO `net_city` VALUES ('15266', '27', 'Сейба', 'Ceiba', '00', '00735', '18.2477', '-65.6783');
INSERT INTO `net_city` VALUES ('15267', '27', 'Атильо', 'Hatillo', '00', '00659', '18.4070', '-66.8018');
INSERT INTO `net_city` VALUES ('15268', '176', 'Бриджтаун', 'Bridgetown', '08', '', '13.1000', '-59.6167');
INSERT INTO `net_city` VALUES ('15269', '157', 'Монтего-Бэй', 'Montego Bay', '12', '', '18.4667', '-77.9167');
INSERT INTO `net_city` VALUES ('15270', '23', 'Ламони', 'Lamoni', 'IA', '50140', '40.6701', '-93.9337');
INSERT INTO `net_city` VALUES ('15276', '23', 'Прескотт Валли', 'Prescott Valley', 'AZ', '86314', '34.6649', '-112.2940');
INSERT INTO `net_city` VALUES ('15290', '23', 'Петоски', 'Petoskey', 'MI', '49770', '45.3449', '-84.9150');
INSERT INTO `net_city` VALUES ('15291', '23', 'Пелстон', 'Pellston', 'MI', '49769', '45.5740', '-84.8265');
INSERT INTO `net_city` VALUES ('15293', '23', 'Алпена', 'Alpena', 'MI', '49707', '45.0657', '-83.4551');
INSERT INTO `net_city` VALUES ('15296', '23', 'Спринг Арбор', 'Spring Arbor', 'MI', '49283', '42.1975', '-84.5648');
INSERT INTO `net_city` VALUES ('15301', '23', 'Эсканаба', 'Escanaba', 'MI', '49829', '45.7566', '-87.1571');
INSERT INTO `net_city` VALUES ('15302', '23', 'Солт-Сейнт-Мари', 'Sault Sainte Marie', 'MI', '49783', '46.4091', '-84.3537');
INSERT INTO `net_city` VALUES ('15303', '23', 'Каро', 'Caro', 'MI', '48723', '43.4990', '-83.3851');
INSERT INTO `net_city` VALUES ('15309', '23', 'Лонг-Прери', 'Long Prairie', 'MN', '56347', '45.9531', '-94.8689');
INSERT INTO `net_city` VALUES ('15312', '23', 'Рокпорт', 'Rockport', 'MA', '01966', '42.6593', '-70.5991');
INSERT INTO `net_city` VALUES ('15316', '23', 'Манти', 'Manti', 'UT', '84642', '39.2502', '-111.5195');
INSERT INTO `net_city` VALUES ('15319', '23', 'Ле Марс', 'Le Mars', 'IA', '51031', '42.7809', '-96.2132');
INSERT INTO `net_city` VALUES ('15339', '23', 'Александрия', 'Alexandria', 'MN', '56308', '45.8934', '-95.3971');
INSERT INTO `net_city` VALUES ('15342', '23', 'Эллсворт', 'Ellsworth', 'ME', '04605', '44.6513', '-68.4507');
INSERT INTO `net_city` VALUES ('15344', '23', 'Нортумберленд', 'Northumberland', 'PA', '17857', '40.9258', '-76.7568');
INSERT INTO `net_city` VALUES ('15367', '24', 'Уайтхорс', 'Whitehorse', 'YT', 'y1a4y4', '60.7167', '-135.0500');
INSERT INTO `net_city` VALUES ('15373', '23', 'Бивертаун', 'Beavertown', 'PA', '17813', '40.7809', '-77.2342');
INSERT INTO `net_city` VALUES ('15377', '23', 'Опелика', 'Opelika', 'AL', '36802', '32.6454', '-85.3783');
INSERT INTO `net_city` VALUES ('15379', '23', 'Беллер', 'Bellaire', 'MI', '49615', '44.9597', '-85.1954');
INSERT INTO `net_city` VALUES ('15388', '33', 'Марсен', 'Maarssen', '09', '', '52.1435', '5.0448');
INSERT INTO `net_city` VALUES ('15389', '12', 'Париж', 'Paris', 'A8', '', '48.8667', '2.3333');
INSERT INTO `net_city` VALUES ('15395', '23', 'Рамона', 'Ramona', 'CA', '92065', '33.0706', '-116.8372');
INSERT INTO `net_city` VALUES ('15400', '33', 'Харен', 'Haren', '04', '', '53.1767', '6.6304');
INSERT INTO `net_city` VALUES ('15410', '23', 'Траутман', 'Troutman', 'NC', '28166', '35.6822', '-80.8663');
INSERT INTO `net_city` VALUES ('15411', '23', 'Райтсвилл Бич', 'Wrightsville Beach', 'NC', '28480', '34.2170', '-77.7896');
INSERT INTO `net_city` VALUES ('15416', '23', 'Кэмпобелло', 'Campobello', 'SC', '29322', '35.1142', '-82.1287');
INSERT INTO `net_city` VALUES ('15418', '23', 'Касл Хейн', 'Castle Hayne', 'NC', '28429', '34.3369', '-77.8992');
INSERT INTO `net_city` VALUES ('15423', '23', 'Молдин', 'Mauldin', 'SC', '29662', '34.7776', '-82.3051');
INSERT INTO `net_city` VALUES ('15426', '23', 'Рафорд', 'Raeford', 'NC', '28376', '34.9874', '-79.2320');
INSERT INTO `net_city` VALUES ('15432', '23', 'Лукаут Маунтин', 'Lookout Mountain', 'GA', '30750', '34.9386', '-85.3936');
INSERT INTO `net_city` VALUES ('15439', '23', 'Джон Дей', 'John Day', 'OR', '97845', '44.3675', '-118.8084');
INSERT INTO `net_city` VALUES ('15441', '23', 'Миллис', 'Millis', 'MA', '02054', '42.1663', '-71.3612');
INSERT INTO `net_city` VALUES ('15444', '23', 'Теллерайд', 'Telluride', 'CO', '81435', '37.9963', '-107.8805');
INSERT INTO `net_city` VALUES ('15450', '23', 'Розо', 'Roseau', 'MN', '56751', '48.7699', '-95.7904');
INSERT INTO `net_city` VALUES ('15455', '23', 'Стон Ридж', 'Stone Ridge', 'NY', '12484', '41.8709', '-74.1662');
INSERT INTO `net_city` VALUES ('15458', '23', 'Крослейк', 'Crosslake', 'MN', '56442', '46.6608', '-94.1036');
INSERT INTO `net_city` VALUES ('15459', '23', 'Уиндом', 'Windom', 'MN', '56101', '43.8766', '-95.1277');
INSERT INTO `net_city` VALUES ('15460', '23', 'Бланко', 'Blanco', 'TX', '78606', '30.0889', '-98.4780');
INSERT INTO `net_city` VALUES ('15461', '23', 'Латта', 'Latta', 'SC', '29565', '34.3600', '-79.4888');
INSERT INTO `net_city` VALUES ('15464', '23', 'Постон', 'Poston', 'AZ', '85371', '33.9906', '-114.3963');
INSERT INTO `net_city` VALUES ('15474', '23', 'Франклинтон', 'Franklinton', 'NC', '27525', '36.1146', '-78.4688');
INSERT INTO `net_city` VALUES ('15484', '24', 'Лакомб', 'Lacombe', 'AB', 't4l2e5', '52.4667', '-113.7333');
INSERT INTO `net_city` VALUES ('15485', '24', 'Йеллоунайф', 'Yellowknife', 'NT', 'x1a2p5', '62.4500', '-114.3500');
INSERT INTO `net_city` VALUES ('15503', '24', 'Хинтон', 'Hinton', 'AB', 't7v1x6', '53.4000', '-117.5833');
INSERT INTO `net_city` VALUES ('15506', '24', 'Камроуз', 'Camrose', 'AB', 't4v2r3', '53.0167', '-112.8167');
INSERT INTO `net_city` VALUES ('15510', '24', 'Уайткорт', 'Whitecourt', 'AB', 't7s1p9', '54.1333', '-115.6833');
INSERT INTO `net_city` VALUES ('15527', '24', 'Банф', 'Banff', 'AB', 't1l1h5', '51.1667', '-115.5667');
INSERT INTO `net_city` VALUES ('15529', '24', 'Форт-Саскачеван', 'Fort Saskatchewan', 'AB', 't8l2p2', '53.7167', '-113.2000');
INSERT INTO `net_city` VALUES ('15537', '24', 'Крэнбрук', 'Cranbrook', 'BC', 'v1c5l7', '49.5167', '-115.7667');
INSERT INTO `net_city` VALUES ('15542', '24', 'Квеснел', 'Quesnel', 'BC', 'v2j3j5', '52.9833', '-122.4833');
INSERT INTO `net_city` VALUES ('15548', '24', 'Питт Медоус', 'Pitt Meadows', 'BC', 'v3y1j9', '49.2333', '-122.6833');
INSERT INTO `net_city` VALUES ('15570', '24', 'Абботсфорд', 'Abbotsford', 'BC', 'v2s7m8', '49.0500', '-122.3000');
INSERT INTO `net_city` VALUES ('15582', '24', 'Уинклер', 'Winkler', 'MB', '', '49.1833', '-97.9333');
INSERT INTO `net_city` VALUES ('15585', '24', 'Зе-Пас', 'The Pas', 'MB', 'r9a1m7', '53.8167', '-101.2333');
INSERT INTO `net_city` VALUES ('15620', '24', 'Шедьяк', 'Shediac', 'NB', 'e0a3g0', '46.2212', '-64.5438');
INSERT INTO `net_city` VALUES ('15625', '24', 'Батерст', 'Bathurst', 'NB', 'e2a1m9', '47.5584', '-65.6565');
INSERT INTO `net_city` VALUES ('15628', '24', 'Ротесэй', 'Rothesay', 'NB', 'e2e5a2', '45.3465', '-66.0002');
INSERT INTO `net_city` VALUES ('15655', '24', 'Мирамичи', 'Miramichi', 'NB', 'e1v1a5', '47.0354', '-65.1757');
INSERT INTO `net_city` VALUES ('15663', '24', 'Мемрамкук', 'Memramcook', 'NB', 'e0a2c0', '46.0000', '-64.5500');
INSERT INTO `net_city` VALUES ('15664', '24', 'Сассекс', 'Sussex', 'NB', 'e0e1p0', '45.6680', '-65.5218');
INSERT INTO `net_city` VALUES ('15667', '24', 'Оромокто', 'Oromocto', 'NB', 'e2v2h2', '45.7953', '-66.4783');
INSERT INTO `net_city` VALUES ('15692', '24', 'Вудсток', 'Woodstock (Ontario)', 'ON', 'n4s7y3', '43.1319', '-80.7583');
INSERT INTO `net_city` VALUES ('15708', '24', 'Корнуолл', 'Cornwall (Prince Edward Island)', 'PE', 'c0a1h0', '46.2400', '-63.2100');
INSERT INTO `net_city` VALUES ('15712', '24', 'Саммерсайд', 'Summerside', 'PE', 'c1n2y7', '46.3988', '-63.7915');
INSERT INTO `net_city` VALUES ('15755', '24', 'Принс-Альберт', 'Prince Albert', 'SK', '', '53.2000', '-105.7500');
INSERT INTO `net_city` VALUES ('15761', '24', 'Мелвилл', 'Melville', 'SK', 's0a2p0', '50.9333', '-102.8000');
INSERT INTO `net_city` VALUES ('15763', '24', 'Колонсей', 'Colonsay', 'SK', 's0k0z0', '51.9667', '-105.8667');
INSERT INTO `net_city` VALUES ('15782', '23', 'Вискассет', 'Wiscasset', 'ME', '04578', '44.0100', '-69.6871');
INSERT INTO `net_city` VALUES ('15784', '23', 'Кассон', 'Kasson', 'MN', '55944', '43.9824', '-92.7285');
INSERT INTO `net_city` VALUES ('15787', '23', 'Эвергрин', 'Evergreen', 'CO', '80439', '39.6545', '-105.4486');
INSERT INTO `net_city` VALUES ('15788', '23', 'Уодина', 'Wadena', 'MN', '56482', '46.4851', '-95.1448');
INSERT INTO `net_city` VALUES ('15802', '24', 'Гандер', 'Gander', 'NL', 'a1v1h6', '48.9500', '-54.5500');
INSERT INTO `net_city` VALUES ('15804', '23', 'Уэйт-Парк', 'Waite Park', 'MN', '56387', '45.5304', '-94.2328');
INSERT INTO `net_city` VALUES ('15805', '23', 'Ред-Уинг', 'Red Wing', 'MN', '55066', '44.5232', '-92.5378');
INSERT INTO `net_city` VALUES ('15808', '23', 'Магнолия', 'Magnolia', 'MN', '56158', '43.6233', '-96.0732');
INSERT INTO `net_city` VALUES ('15811', '23', 'Шорвью', 'Shoreview', 'MN', '55014', '45.1674', '-93.1223');
INSERT INTO `net_city` VALUES ('15814', '23', 'Клокей', 'Cloquet', 'MN', '55720', '46.7440', '-92.5739');
INSERT INTO `net_city` VALUES ('15817', '23', 'Брейнерд', 'Brainerd', 'MN', '56401', '46.3067', '-94.1008');
INSERT INTO `net_city` VALUES ('15827', '23', 'Беллвью', 'Bellvue', 'CO', '80512', '40.6946', '-105.6579');
INSERT INTO `net_city` VALUES ('15831', '23', 'Дерри', 'Derry', 'NH', '03038', '42.8915', '-71.2787');
INSERT INTO `net_city` VALUES ('15838', '29', 'Вислох ', 'Wiesloch', '01', '', '49.2978', '8.7014');
INSERT INTO `net_city` VALUES ('15841', '23', 'Лейтон', 'Layton', 'UT', '84041', '41.0713', '-111.9874');
INSERT INTO `net_city` VALUES ('15842', '23', 'Спирфиш', 'Spearfish', 'SD', '57799', '44.4958', '-103.8703');
INSERT INTO `net_city` VALUES ('15847', '23', 'Сиу Сентер', 'Sioux Center', 'IA', '51250', '43.0706', '-96.2344');
INSERT INTO `net_city` VALUES ('15861', '29', 'Глоттерталь', 'Glottertal', '01', '', '48.0000', '7.8500');
INSERT INTO `net_city` VALUES ('15862', '59', 'Женева', 'Geneva', '07', '', '46.1956', '6.1481');
INSERT INTO `net_city` VALUES ('15863', '29', 'Рюссельсхайм', 'Russelsheim', '05', '', '49.9925', '8.4350');
INSERT INTO `net_city` VALUES ('15864', '21', 'Геррардз-Кросс', 'Gerrards Cross', 'F9', '', '51.5500', '-0.4833');
INSERT INTO `net_city` VALUES ('15865', '42', 'Сингапур', 'Singapore', '00', '', '1.2931', '103.8558');
INSERT INTO `net_city` VALUES ('15877', '21', 'Бейзингсток', 'Basingstoke', 'F2', '', '51.2667', '-1.0833');
INSERT INTO `net_city` VALUES ('15878', '13', 'Рим', 'Rome', '07', '', '41.9000', '12.4833');
INSERT INTO `net_city` VALUES ('15885', '23', 'Геттисберг', 'Gettysburg', 'OH', '45328', '40.1114', '-84.4952');
INSERT INTO `net_city` VALUES ('15891', '23', 'Блэрстаун', 'Blairstown', 'NJ', '07825', '40.9691', '-74.9619');
INSERT INTO `net_city` VALUES ('15898', '23', 'Полсон', 'Polson', 'MT', '59860', '47.7209', '-114.2191');
INSERT INTO `net_city` VALUES ('15900', '23', 'Буэна Виста', 'Buena Vista', 'CO', '81211', '38.8750', '-106.2531');
INSERT INTO `net_city` VALUES ('15907', '23', 'Отсиго', 'Otsego', 'MI', '49078', '42.4387', '-85.7371');
INSERT INTO `net_city` VALUES ('15908', '23', 'Порт Байрон', 'Port Byron', 'NY', '13140', '43.0165', '-76.6535');
INSERT INTO `net_city` VALUES ('15922', '23', 'Маунт Гилеад', 'Mount Gilead', 'OH', '43338', '40.5561', '-82.7593');
INSERT INTO `net_city` VALUES ('15925', '23', 'Артижа', 'Artesia', 'CA', '90701', '33.8669', '-118.0803');
INSERT INTO `net_city` VALUES ('15928', '23', 'Талелейк', 'Tulelake', 'CA', '96134', '41.8085', '-121.4604');
INSERT INTO `net_city` VALUES ('15931', '23', 'Джэксонвилл', 'Jacksonville', 'AL', '36265', '33.8558', '-85.7758');
INSERT INTO `net_city` VALUES ('15942', '23', 'Тилламук', 'Tillamook', 'OR', '97141', '45.4662', '-123.7100');
INSERT INTO `net_city` VALUES ('15955', '23', 'Клантон', 'Clanton', 'AL', '35045', '32.8258', '-86.6761');
INSERT INTO `net_city` VALUES ('15958', '23', 'Ашленд', 'Ashland', 'OR', '97520', '42.1563', '-122.5298');
INSERT INTO `net_city` VALUES ('15964', '23', 'Оринджевилл', 'Orangeville', 'UT', '84537', '39.2272', '-111.0535');
INSERT INTO `net_city` VALUES ('15976', '23', 'Наррагансетт', 'Narragansett', 'RI', '02882', '41.4041', '-71.4774');
INSERT INTO `net_city` VALUES ('15978', '23', 'Спринг-Гров', 'Spring Grove', 'PA', '17362', '39.8494', '-76.8662');
INSERT INTO `net_city` VALUES ('15987', '23', 'Хайес', 'Hayes', 'VA', '23072', '37.3044', '-76.4771');
INSERT INTO `net_city` VALUES ('15988', '23', 'Саегертаун', 'Saegertown', 'PA', '16433', '41.7412', '-80.1329');
INSERT INTO `net_city` VALUES ('15992', '23', 'Сейнт Хеленс', 'Saint Helens', 'OR', '97051', '45.8871', '-122.9283');
INSERT INTO `net_city` VALUES ('15996', '23', 'Флинт Хилл', 'Flint Hill', 'VA', '22627', '38.7686', '-78.0781');
INSERT INTO `net_city` VALUES ('15998', '23', 'Скотсблафф', 'Scottsbluff', 'NE', '69361', '41.9923', '-103.6328');
INSERT INTO `net_city` VALUES ('16001', '23', 'Бен Ломонд', 'Ben Lomond', 'CA', '95005', '37.1085', '-122.0890');
INSERT INTO `net_city` VALUES ('16004', '29', 'Неттеталь ', 'Nettetal', '07', '', '51.3167', '6.2833');
INSERT INTO `net_city` VALUES ('16006', '23', 'Монкер', 'Moncure', 'NC', '27559', '35.6529', '-79.1366');
INSERT INTO `net_city` VALUES ('16013', '23', 'Хаслетт', 'Haslett', 'MI', '48840', '42.7730', '-84.3745');
INSERT INTO `net_city` VALUES ('16014', '23', 'По По', 'Paw Paw', 'MI', '49079', '42.2223', '-85.9043');
INSERT INTO `net_city` VALUES ('16015', '23', 'Блайт', 'Blythe', 'GA', '30805', '33.3114', '-82.2478');
INSERT INTO `net_city` VALUES ('16017', '23', 'Ричфилд', 'Richfield', 'UT', '84701', '38.7533', '-112.1056');
INSERT INTO `net_city` VALUES ('16018', '23', 'Сидни', 'Sidney', 'NE', '69162', '41.1480', '-103.0633');
INSERT INTO `net_city` VALUES ('16023', '23', 'Силверторн', 'Silverthorne', 'CO', '80498', '39.7648', '-106.1799');
INSERT INTO `net_city` VALUES ('16025', '23', 'Батлемент Меса', 'Battlement Mesa', 'CO', '81636', '39.4414', '-108.0251');
INSERT INTO `net_city` VALUES ('16026', '23', 'Де Бек', 'De Beque', 'CO', '81630', '39.4722', '-108.4880');
INSERT INTO `net_city` VALUES ('16027', '23', 'Канон Сити', 'Canon City', 'CO', '81212', '38.4779', '-105.4556');
INSERT INTO `net_city` VALUES ('16030', '23', 'Нивот', 'Niwot', 'CO', '80544', '40.1039', '-105.1708');
INSERT INTO `net_city` VALUES ('16031', '23', 'Кеммерер', 'Kemmerer', 'WY', '83101', '41.9499', '-110.4601');
INSERT INTO `net_city` VALUES ('16032', '23', 'Сноумасс Виллидж', 'Snowmass Village', 'CO', '81615', '39.1939', '-106.9447');
INSERT INTO `net_city` VALUES ('16041', '23', 'Триадельфия', 'Triadelphia', 'WV', '26059', '40.0726', '-80.5590');
INSERT INTO `net_city` VALUES ('16042', '23', 'Пембертон', 'Pemberton', 'NJ', '08068', '39.9576', '-74.6645');
INSERT INTO `net_city` VALUES ('16048', '23', 'Микер', 'Meeker', 'CO', '81641', '40.0731', '-107.7770');
INSERT INTO `net_city` VALUES ('16051', '23', 'Норт Кингсвилл', 'North Kingsville', 'OH', '44068', '41.9059', '-80.6904');
INSERT INTO `net_city` VALUES ('16063', '24', 'Пиккеринг', 'Pickering', 'ON', 'l1v6k7', '43.8667', '-79.0333');
INSERT INTO `net_city` VALUES ('16067', '24', 'Кембридж', 'Cambridge (Ontario)', 'ON', 'n1r7h6', '43.3833', '-80.3167');
INSERT INTO `net_city` VALUES ('16073', '24', 'Досон-Крик', 'Dawson Creek', 'BC', '', '55.7667', '-120.2333');
INSERT INTO `net_city` VALUES ('16080', '24', 'Норидж', 'Norwich', 'ON', 'n0j1p0', '42.9833', '-80.6000');
INSERT INTO `net_city` VALUES ('16091', '23', 'Голдендейл', 'Goldendale', 'WA', '98620', '45.8436', '-120.7685');
INSERT INTO `net_city` VALUES ('16092', '23', 'Стивенсон', 'Stevenson', 'WA', '98648', '45.7064', '-121.7235');
INSERT INTO `net_city` VALUES ('16093', '23', 'Фрайдей Харбор', 'Friday Harbor', 'WA', '98250', '48.5372', '-123.0679');
INSERT INTO `net_city` VALUES ('16094', '23', 'Колфакс', 'Colfax', 'WA', '99111', '46.8582', '-117.4444');
INSERT INTO `net_city` VALUES ('16096', '23', 'Катламет', 'Cathlamet', 'WA', '98612', '46.2296', '-123.3136');
INSERT INTO `net_city` VALUES ('16102', '23', 'Кью Гарденс', 'Kew Gardens', 'NY', '11415', '40.7087', '-73.8268');
INSERT INTO `net_city` VALUES ('16103', '23', 'Браунс Милс', 'Browns Mills', 'NJ', '08015', '39.9456', '-74.5558');
INSERT INTO `net_city` VALUES ('16105', '23', 'Джевелл', 'Jewell', 'GA', '31045', '33.2923', '-82.7796');
INSERT INTO `net_city` VALUES ('16110', '176', 'Крайст-Черч', 'Christ Church', '03', '', '13.1000', '-59.5667');
INSERT INTO `net_city` VALUES ('16112', '23', 'Хесстон', 'Hesston', 'KS', '67062', '38.1511', '-97.4454');
INSERT INTO `net_city` VALUES ('16113', '23', 'Макферсон', 'McPherson', 'KS', '67460', '38.3769', '-97.7037');
INSERT INTO `net_city` VALUES ('16115', '23', 'Уотена', 'Wathena', 'KS', '66090', '39.7844', '-94.9605');
INSERT INTO `net_city` VALUES ('16116', '23', 'Болдуин Сити', 'Baldwin City', 'KS', '66006', '38.8043', '-95.2371');
INSERT INTO `net_city` VALUES ('16117', '23', 'Эскридж', 'Eskridge', 'KS', '66423', '38.8735', '-96.0903');
INSERT INTO `net_city` VALUES ('16118', '23', 'Колби', 'Colby', 'KS', '67701', '39.3942', '-101.0187');
INSERT INTO `net_city` VALUES ('16119', '24', 'Принс-Руперт', 'Prince Rupert', 'BC', '', '54.3167', '-130.3333');
INSERT INTO `net_city` VALUES ('16124', '24', 'Стони-Плейн', 'Stony Plain', 'AB', 't0e2g0', '53.5333', '-114.0000');
INSERT INTO `net_city` VALUES ('16133', '24', 'Роберваль', 'Roberval', 'QC', 'g8h1z3', '48.5167', '-72.2167');
INSERT INTO `net_city` VALUES ('16139', '24', 'Оринджевилл', 'Orangeville', 'ON', '', '43.9164', '-80.0967');
INSERT INTO `net_city` VALUES ('16140', '24', 'Драммондвилл', 'Drummondville', 'QC', '', '45.8833', '-72.4833');
INSERT INTO `net_city` VALUES ('16141', '24', 'Грейвенхерст', 'Gravenhurst', 'ON', '', '44.9167', '-79.3667');
INSERT INTO `net_city` VALUES ('16142', '24', 'Жольет', 'Joliette', 'QC', '', '46.0340', '-73.4410');
INSERT INTO `net_city` VALUES ('16143', '24', 'Корнер-Брук', 'Corner Brook', 'NL', '', '48.9500', '-57.9333');
INSERT INTO `net_city` VALUES ('16154', '23', 'Уинд Гэп', 'Wind Gap', 'PA', '18091', '40.8242', '-75.3260');
INSERT INTO `net_city` VALUES ('16155', '24', 'Брантфорд', 'Brantford', 'ON', '', '43.1438', '-80.2600');
INSERT INTO `net_city` VALUES ('16157', '23', 'Стони Ридж', 'Stony Ridge', 'OH', '43463', '41.5103', '-83.5071');
INSERT INTO `net_city` VALUES ('16158', '23', 'Форт Фэрфилд', 'Fort Fairfield', 'ME', '04742', '46.7793', '-67.8573');
INSERT INTO `net_city` VALUES ('16160', '24', 'Шавиниган', 'Shawinigan', 'QC', '', '46.5558', '-72.7437');
INSERT INTO `net_city` VALUES ('16161', '24', 'Пемброк', 'Pembroke', 'ON', '', '45.8167', '-77.1167');
INSERT INTO `net_city` VALUES ('16164', '23', 'Нью Уотерфорд', 'New Waterford', 'OH', '44445', '40.8441', '-80.6218');
INSERT INTO `net_city` VALUES ('16165', '23', 'Ансон', 'Anson', 'TX', '79501', '32.7494', '-99.8959');
INSERT INTO `net_city` VALUES ('16169', '23', 'Уильямсон', 'Williamson', 'WV', '25661', '37.7159', '-82.2369');
INSERT INTO `net_city` VALUES ('16171', '23', 'Каукауна', 'Kaukauna', 'WI', '54130', '44.3483', '-88.2567');
INSERT INTO `net_city` VALUES ('16174', '24', 'Слейв-Лейк', 'Slave Lake', 'AB', '', '55.2833', '-114.7833');
INSERT INTO `net_city` VALUES ('16176', '24', 'Драйтон-Валли', 'Drayton Valley', 'AB', '', '53.2167', '-114.9833');
INSERT INTO `net_city` VALUES ('16181', '23', 'Маллика Хилл', 'Mullica Hill', 'NJ', '08062', '39.7146', '-75.2179');
INSERT INTO `net_city` VALUES ('16185', '23', 'Хановер Парк', 'Hanover Park', 'IL', '60133', '41.9763', '-88.1441');
INSERT INTO `net_city` VALUES ('16191', '23', 'Астория', 'Astoria', 'OR', '97103', '46.1247', '-123.6765');
INSERT INTO `net_city` VALUES ('16192', '23', 'Мадрас', 'Madras', 'OR', '97741', '44.6067', '-121.0560');
INSERT INTO `net_city` VALUES ('16196', '23', 'Брахам', 'Braham', 'MN', '55006', '45.7386', '-93.2158');
INSERT INTO `net_city` VALUES ('16199', '21', 'Рединг', 'Reading', 'K7', '', '51.4333', '-1.0000');
INSERT INTO `net_city` VALUES ('16201', '23', 'Форт Бентон', 'Fort Benton', 'MT', '59442', '47.9866', '-110.8012');
INSERT INTO `net_city` VALUES ('16202', '23', 'Пинконнинг', 'Pinconning', 'MI', '48650', '43.8477', '-84.0225');
INSERT INTO `net_city` VALUES ('16210', '24', 'Хай Ривер', 'High River', 'AB', '', '50.5833', '-113.8667');
INSERT INTO `net_city` VALUES ('16215', '23', 'Алгома', 'Algoma', 'WI', '54201', '44.6069', '-87.5174');
INSERT INTO `net_city` VALUES ('16223', '24', 'Нипава', 'Neepawa', 'MB', '', '50.2333', '-99.4500');
INSERT INTO `net_city` VALUES ('16224', '24', 'Трейл', 'Trail', 'BC', '', '49.1000', '-117.7167');
INSERT INTO `net_city` VALUES ('16225', '24', 'Листауэл', 'Listowel', 'ON', '', '43.7351', '-80.9533');
INSERT INTO `net_city` VALUES ('16226', '23', 'Сако', 'Saco', 'ME', '04072', '43.5416', '-70.4687');
INSERT INTO `net_city` VALUES ('16230', '23', 'Боттино', 'Bottineau', 'ND', '58318', '48.8522', '-100.4018');
INSERT INTO `net_city` VALUES ('16234', '24', 'Смит', 'Smith', 'AB', '', '55.1667', '-114.0333');
INSERT INTO `net_city` VALUES ('16235', '23', 'Санборн', 'Sanborn', 'MN', '56083', '44.2246', '-95.1242');
INSERT INTO `net_city` VALUES ('16241', '23', 'Лемур', 'Lemoore', 'CA', '93245', '36.2939', '-119.8286');
INSERT INTO `net_city` VALUES ('16242', '23', 'Маунт-Плезант', 'Mount Pleasant', 'IA', '52641', '41.0207', '-91.5839');
INSERT INTO `net_city` VALUES ('16244', '23', 'Голдтуэйт', 'Goldthwaite', 'TX', '76844', '31.4520', '-98.5593');
INSERT INTO `net_city` VALUES ('16246', '23', 'Ред Бад', 'Red Bud', 'IL', '62278', '38.2140', '-90.0135');
INSERT INTO `net_city` VALUES ('16247', '24', 'Каслгар', 'Castlegar', 'BC', '', '49.3167', '-117.6667');
INSERT INTO `net_city` VALUES ('16248', '24', 'Ревелсток', 'Revelstoke', 'BC', '', '51.0000', '-118.1833');
INSERT INTO `net_city` VALUES ('16249', '23', 'Чифленд', 'Chiefland', 'FL', '32626', '29.4420', '-82.8770');
INSERT INTO `net_city` VALUES ('16253', '24', 'Кэмпбелл Ривер', 'Campbell River', 'BC', 'v9w2h5', '50.0167', '-125.2500');
INSERT INTO `net_city` VALUES ('16258', '23', 'Ноксвилл', 'Knoxville', 'IA', '50138', '41.2908', '-93.1405');
INSERT INTO `net_city` VALUES ('16263', '23', 'Уайтингем', 'Whitingham', 'VT', '05361', '42.7835', '-72.8679');
INSERT INTO `net_city` VALUES ('16274', '23', 'Перритон', 'Perryton', 'TX', '79070', '36.2786', '-100.7714');
INSERT INTO `net_city` VALUES ('16276', '23', 'Палатка', 'Palatka', 'FL', '32178', '29.6486', '-81.6376');
INSERT INTO `net_city` VALUES ('16277', '23', 'Порт Шарлотт', 'Port Charlotte', 'FL', '33948', '26.9772', '-82.1554');
INSERT INTO `net_city` VALUES ('16278', '23', 'Бунвилл', 'Booneville', 'MS', '38829', '34.6299', '-88.5711');
INSERT INTO `net_city` VALUES ('16281', '23', 'Трут-ор-Консекуэнсес', 'Truth Or Consequences', 'NM', '87901', '33.1288', '-107.0276');
INSERT INTO `net_city` VALUES ('16282', '23', 'Хатч', 'Hatch', 'NM', '87937', '32.5004', '-107.1604');
INSERT INTO `net_city` VALUES ('16283', '23', 'Гэллап', 'Gallup', 'NM', '87301', '35.4999', '-108.8509');
INSERT INTO `net_city` VALUES ('16284', '23', 'Таба Сити', 'Tuba City', 'AZ', '86045', '36.0928', '-111.1312');
INSERT INTO `net_city` VALUES ('16285', '23', 'Грин Ривер', 'Green River', 'WY', '82935', '41.6370', '-109.6515');
INSERT INTO `net_city` VALUES ('16286', '23', 'Ласк', 'Lusk', 'WY', '82225', '43.0563', '-104.3628');
INSERT INTO `net_city` VALUES ('16289', '23', 'Пайндейл', 'Pinedale', 'WY', '82941', '42.8416', '-109.8638');
INSERT INTO `net_city` VALUES ('16290', '23', 'Баффало', 'Buffalo', 'WY', '82834', '44.2195', '-106.6002');
INSERT INTO `net_city` VALUES ('16291', '23', 'Сандэнс', 'Sundance', 'WY', '82729', '44.3827', '-104.4165');
INSERT INTO `net_city` VALUES ('16292', '23', 'Лион', 'Lyons', 'CO', '80540', '40.2379', '-105.4264');
INSERT INTO `net_city` VALUES ('16293', '23', 'Айдахо Спрингс', 'Idaho Springs', 'CO', '80452', '39.7156', '-105.5804');
INSERT INTO `net_city` VALUES ('16294', '23', 'Тэтчер', 'Thatcher', 'AZ', '85552', '32.8251', '-109.7881');
INSERT INTO `net_city` VALUES ('16295', '23', 'Дуглас', 'Douglas', 'AZ', '85607', '31.5452', '-109.4677');
INSERT INTO `net_city` VALUES ('16296', '23', 'Пайетт', 'Payette', 'ID', '83661', '44.0630', '-116.7038');
INSERT INTO `net_city` VALUES ('16300', '23', 'Бригам Сити', 'Brigham City', 'UT', '84302', '41.5178', '-112.0408');
INSERT INTO `net_city` VALUES ('16301', '23', 'Маунт-Плезант', 'Mount Pleasant', 'UT', '84647', '39.5512', '-111.3938');
INSERT INTO `net_city` VALUES ('16317', '23', 'Нотак', 'Naugatuck', 'CT', '06770', '41.4878', '-73.0627');
INSERT INTO `net_city` VALUES ('16324', '23', 'Холли', 'Holly', 'MI', '48442', '42.7853', '-83.5864');
INSERT INTO `net_city` VALUES ('16327', '23', 'Суитзер', 'Sweetser', 'IN', '46987', '40.5720', '-85.7691');
INSERT INTO `net_city` VALUES ('16329', '23', 'Ла Джунта', 'La Junta', 'CO', '81050', '37.8463', '-103.5836');
INSERT INTO `net_city` VALUES ('16333', '23', 'Сейнт Круа Фолс', 'Saint Croix Falls', 'WI', '54024', '45.5044', '-92.6208');
INSERT INTO `net_city` VALUES ('16336', '163', 'Богота', 'Bogota', '33', '', '4.6492', '-74.0628');
INSERT INTO `net_city` VALUES ('16341', '23', 'Пенн Валли', 'Penn Valley', 'CA', '95946', '39.1866', '-121.2011');
INSERT INTO `net_city` VALUES ('16342', '23', 'Сан Карлос', 'San Carlos', 'AZ', '85550', '33.4158', '-110.1113');
INSERT INTO `net_city` VALUES ('16344', '166', 'Сана', 'Sana', '04', '', '15.4000', '47.7667');
INSERT INTO `net_city` VALUES ('16352', '23', 'Грейвилл', 'Grayville', 'IL', '62844', '38.2699', '-88.0086');
INSERT INTO `net_city` VALUES ('16357', '23', 'Абботстаун', 'Abbottstown', 'PA', '17301', '39.8951', '-76.9767');
INSERT INTO `net_city` VALUES ('16360', '23', 'Маунт Пуласки', 'Mount Pulaski', 'IL', '62548', '39.9718', '-89.2931');
INSERT INTO `net_city` VALUES ('16371', '23', 'Зумброта', 'Zumbrota', 'MN', '55992', '44.3010', '-92.6589');
INSERT INTO `net_city` VALUES ('16372', '23', 'Гастон', 'Gaston', 'SC', '29053', '33.8224', '-81.0734');
INSERT INTO `net_city` VALUES ('16373', '23', 'Принсес Энн', 'Princess Anne', 'MD', '21853', '38.1947', '-75.7057');
INSERT INTO `net_city` VALUES ('16399', '23', 'Сан Мартин', 'San Martin', 'CA', '95046', '37.1027', '-121.6001');
INSERT INTO `net_city` VALUES ('16404', '23', 'Гудзонвилл', 'Hudsonville', 'MI', '49426', '42.8555', '-85.8828');
INSERT INTO `net_city` VALUES ('16406', '23', 'Махомет', 'Mahomet', 'IL', '61853', '40.2149', '-88.4046');
INSERT INTO `net_city` VALUES ('16417', '23', 'Уэйк Форест', 'Wake Forest', 'NC', '27588', '35.9799', '-78.5097');
INSERT INTO `net_city` VALUES ('16419', '23', 'Белмонт', 'Belmont', 'NC', '28012', '35.2178', '-81.0394');
INSERT INTO `net_city` VALUES ('16420', '23', 'Марс Хилл', 'Mars Hill', 'NC', '28754', '35.8813', '-82.5134');
INSERT INTO `net_city` VALUES ('16423', '23', 'Элм Сити', 'Elm City', 'NC', '27822', '35.7992', '-77.8450');
INSERT INTO `net_city` VALUES ('16429', '165', 'Виллемстад', 'Willemstad', '00', '', '12.1000', '-68.9167');
INSERT INTO `net_city` VALUES ('16441', '24', 'Ньюмаркет', 'Newmarket', 'ON', 'l3y8j3', '44.0580', '-79.4526');
INSERT INTO `net_city` VALUES ('16468', '23', 'Малинта', 'Malinta', 'OH', '43535', '41.3053', '-84.0037');
INSERT INTO `net_city` VALUES ('16474', '23', 'Виктор', 'Victor', 'CO', '80860', '38.7100', '-105.1400');
INSERT INTO `net_city` VALUES ('16475', '24', 'Чатем', 'Chatham', 'ON', 'n7m5j5', '42.4076', '-82.1911');
INSERT INTO `net_city` VALUES ('16477', '23', 'Вахайава', 'Wahiawa', 'HI', '96786', '21.5488', '-158.0298');
INSERT INTO `net_city` VALUES ('16481', '23', 'Леки', 'Leckie', 'WV', '24856', '37.3482', '-81.4195');
INSERT INTO `net_city` VALUES ('16482', '23', 'Блэк Ривер Фолс', 'Black River Falls', 'WI', '54615', '44.2761', '-90.7962');
INSERT INTO `net_city` VALUES ('16487', '23', 'Давенпорт', 'Davenport', 'FL', '33837', '28.1911', '-81.6068');
INSERT INTO `net_city` VALUES ('16489', '23', 'Маннинг', 'Manning', 'IA', '51455', '41.8845', '-95.0634');
INSERT INTO `net_city` VALUES ('16491', '23', 'Порт Аллегани', 'Port Allegany', 'PA', '16743', '41.7889', '-78.2586');
INSERT INTO `net_city` VALUES ('16495', '23', 'Уэверли', 'Waverly', 'NE', '68462', '40.9581', '-96.5295');
INSERT INTO `net_city` VALUES ('16496', '4', 'Шэньчжэнь', 'Shenzhen', '30', '', '22.5333', '114.1333');
INSERT INTO `net_city` VALUES ('16498', '23', 'Брашир', 'Brashear', 'TX', '75420', '33.0503', '-95.7237');
INSERT INTO `net_city` VALUES ('16505', '23', 'Голливуд', 'Hollywood', 'MD', '20636', '38.3448', '-76.5806');
INSERT INTO `net_city` VALUES ('16509', '23', 'Уайкиап', 'Wikieup', 'AZ', '85360', '34.7034', '-113.6113');
INSERT INTO `net_city` VALUES ('16511', '23', 'Гори', 'Gowrie', 'IA', '50543', '42.2818', '-94.2908');
INSERT INTO `net_city` VALUES ('16512', '23', 'Уэлман', 'Wellman', 'IA', '52356', '41.4820', '-91.8523');
INSERT INTO `net_city` VALUES ('16516', '127', 'Грац', 'Graz', '06', '', '47.0667', '15.4500');
INSERT INTO `net_city` VALUES ('16517', '29', 'Берлин', 'Berlin', '16', '', '52.5167', '13.4000');
INSERT INTO `net_city` VALUES ('16518', '59', 'Базель', 'Basel', '04', '', '47.5584', '7.5733');
INSERT INTO `net_city` VALUES ('16521', '12', 'Сеста', 'Cestas', '97', '', '44.7434', '-0.6791');
INSERT INTO `net_city` VALUES ('16522', '29', 'Исманинг', 'Ismaning', '02', '', '48.2333', '11.6333');
INSERT INTO `net_city` VALUES ('16523', '21', 'Уотфорд', 'Watford', 'F8', '', '51.6667', '-0.4000');
INSERT INTO `net_city` VALUES ('16524', '145', 'Эхтернах', 'Echternach', '02', '', '49.8056', '6.4222');
INSERT INTO `net_city` VALUES ('16525', '29', 'Куксхафен', 'Cuxhaven', '06', '', '53.8833', '8.7000');
INSERT INTO `net_city` VALUES ('16526', '29', 'Эшборн', 'Eschborn', '05', '', '50.1333', '8.5500');
INSERT INTO `net_city` VALUES ('16527', '12', 'Исси-ле-Мулино', 'Issy-les-Moulineaux', 'A8', '', '48.8210', '2.2772');
INSERT INTO `net_city` VALUES ('16529', '29', 'Донцдорф ', 'Donzdorf', '01', '', '48.6833', '9.8167');
INSERT INTO `net_city` VALUES ('16531', '23', 'Прескотт ', 'Prescott', 'AR', '71857', '33.7922', '-93.3217');
INSERT INTO `net_city` VALUES ('16534', '23', 'Кулидж', 'Coolidge', 'AZ', '85228', '32.9769', '-111.5040');
INSERT INTO `net_city` VALUES ('16535', '23', 'Кайента', 'Kayenta', 'AZ', '86033', '36.6486', '-110.1876');
INSERT INTO `net_city` VALUES ('16537', '23', 'Франктаун', 'Franktown', 'CO', '80116', '39.3023', '-104.6994');
INSERT INTO `net_city` VALUES ('16543', '23', 'Зефирхилс', 'Zephyrhills', 'FL', '33542', '28.2337', '-82.1790');
INSERT INTO `net_city` VALUES ('16547', '125', 'Осло', 'Oslo', '12', '', '59.9167', '10.7500');
INSERT INTO `net_city` VALUES ('16564', '23', 'Эдвардс', 'Edwards', 'CO', '81632', '39.6450', '-106.5942');
INSERT INTO `net_city` VALUES ('16566', '23', 'Пайнклифф', 'Pinecliffe', 'CO', '80471', '39.9474', '-105.4593');
INSERT INTO `net_city` VALUES ('16567', '23', 'Ла Мотт', 'La Motte', 'IA', '52054', '42.2955', '-90.6182');
INSERT INTO `net_city` VALUES ('16570', '23', 'Эверли', 'Everly', 'IA', '51338', '43.2080', '-95.3089');
INSERT INTO `net_city` VALUES ('16571', '23', 'Труро', 'Truro', 'IA', '50257', '41.1870', '-93.8488');
INSERT INTO `net_city` VALUES ('16572', '23', 'Грисволд', 'Griswold', 'IA', '51535', '41.2452', '-95.1204');
INSERT INTO `net_city` VALUES ('16573', '23', 'Канаха', 'Kanawha', 'IA', '50447', '42.9219', '-93.8029');
INSERT INTO `net_city` VALUES ('16575', '23', 'Лихай', 'Lehigh', 'IA', '50557', '42.3632', '-94.0150');
INSERT INTO `net_city` VALUES ('16576', '23', 'Уолнат', 'Walnut', 'IA', '51577', '41.4620', '-95.2088');
INSERT INTO `net_city` VALUES ('16579', '23', 'Гуттенберг', 'Guttenberg', 'IA', '52052', '42.7329', '-91.1443');
INSERT INTO `net_city` VALUES ('16580', '23', 'Харлан', 'Harlan', 'IA', '51537', '41.6479', '-95.2867');
INSERT INTO `net_city` VALUES ('16582', '23', 'Монона', 'Monona', 'IA', '52159', '43.0880', '-91.3270');
INSERT INTO `net_city` VALUES ('16583', '23', 'Уилтон', 'Wilton', 'IA', '52778', '41.6106', '-91.0070');
INSERT INTO `net_city` VALUES ('16586', '23', 'Кларенс', 'Clarence', 'IA', '52216', '41.8830', '-91.0538');
INSERT INTO `net_city` VALUES ('16587', '23', 'Хейвлок', 'Havelock', 'IA', '50546', '42.8497', '-94.6936');
INSERT INTO `net_city` VALUES ('16588', '23', 'Шеллсберг', 'Shellsburg', 'IA', '52332', '42.0980', '-91.9025');
INSERT INTO `net_city` VALUES ('16589', '23', 'Форест Ноллс', 'Forest Knolls', 'CA', '94933', '38.0100', '-122.6897');
INSERT INTO `net_city` VALUES ('16590', '23', 'Вейл', 'Vail', 'AZ', '85641', '31.9582', '-110.6930');
INSERT INTO `net_city` VALUES ('16597', '23', 'Россвилл', 'Rossville', 'GA', '30741', '34.9364', '-85.3101');
INSERT INTO `net_city` VALUES ('16599', '23', 'Рингстед', 'Ringsted', 'IA', '50578', '43.3008', '-94.5511');
INSERT INTO `net_city` VALUES ('16600', '23', 'Пало', 'Palo', 'IA', '52324', '42.0801', '-91.8041');
INSERT INTO `net_city` VALUES ('16605', '23', 'Мовилл', 'Moville', 'IA', '51039', '42.4484', '-96.0467');
INSERT INTO `net_city` VALUES ('16610', '23', 'Элдридж', 'Eldridge', 'IA', '52748', '41.6729', '-90.5541');
INSERT INTO `net_city` VALUES ('16611', '23', 'Менло', 'Menlo', 'IA', '50164', '41.5023', '-94.4495');
INSERT INTO `net_city` VALUES ('16614', '23', 'Ремсен', 'Remsen', 'IA', '51050', '42.8008', '-95.9577');
INSERT INTO `net_city` VALUES ('16615', '23', 'Фэрбанк', 'Fairbank', 'IA', '50629', '42.6454', '-92.0915');
INSERT INTO `net_city` VALUES ('16616', '23', 'Элкадер', 'Elkader', 'IA', '52043', '42.8417', '-91.4140');
INSERT INTO `net_city` VALUES ('16618', '23', 'Бернард', 'Bernard', 'IA', '52032', '42.2791', '-90.8418');
INSERT INTO `net_city` VALUES ('16619', '23', 'Риджуэй', 'Ridgway', 'CO', '81432', '38.1199', '-107.7650');
INSERT INTO `net_city` VALUES ('16620', '23', 'Уитленд', 'Wheatland', 'IA', '52777', '41.8588', '-90.8591');
INSERT INTO `net_city` VALUES ('16621', '23', 'Уолл Лейк', 'Wall Lake', 'IA', '51466', '42.2612', '-95.0934');
INSERT INTO `net_city` VALUES ('16623', '23', 'Оран', 'Oran', 'IA', '50664', '42.7014', '-92.0746');
INSERT INTO `net_city` VALUES ('16636', '23', 'Эппинг', 'Epping', 'NH', '03042', '43.0507', '-71.0809');
INSERT INTO `net_city` VALUES ('16654', '23', 'Голдстон', 'Goldston', 'NC', '27252', '35.5672', '-79.3621');
INSERT INTO `net_city` VALUES ('16656', '24', 'Стеллартон', 'Stellarton', 'NS', 'b0k1s0', '45.5667', '-62.6500');
INSERT INTO `net_city` VALUES ('16660', '23', 'Файерстон', 'Firestone', 'CO', '80520', '40.1125', '-104.9366');
INSERT INTO `net_city` VALUES ('16664', '23', 'Наполеонвилл', 'Napoleonville', 'LA', '70390', '29.8853', '-91.0180');
INSERT INTO `net_city` VALUES ('16674', '23', 'Марана', 'Marana', 'AZ', '85653', '32.4580', '-111.2974');
INSERT INTO `net_city` VALUES ('16680', '23', 'Хампстед', 'Hampstead', 'NH', '03841', '42.8830', '-71.1731');
INSERT INTO `net_city` VALUES ('16720', '23', 'Гладстон', 'Gladstone', 'OR', '97027', '45.3884', '-122.5945');
INSERT INTO `net_city` VALUES ('16733', '23', 'Уолкерсвилл', 'Walkersville', 'MD', '21793', '39.4939', '-77.3403');
INSERT INTO `net_city` VALUES ('16736', '23', 'Либби', 'Libby', 'MT', '59923', '48.3259', '-115.3596');
INSERT INTO `net_city` VALUES ('16748', '23', 'Лейк Стивенс', 'Lake Stevens', 'WA', '98258', '48.0431', '-122.0590');
INSERT INTO `net_city` VALUES ('16750', '23', 'Траутдейл', 'Troutdale', 'OR', '97060', '45.5288', '-122.3590');
INSERT INTO `net_city` VALUES ('16762', '23', 'Уиллис', 'Willis', 'MI', '48191', '42.1154', '-83.5693');
INSERT INTO `net_city` VALUES ('16793', '23', 'Монтроз', 'Montrose', 'CA', '91020', '34.2121', '-118.2302');
INSERT INTO `net_city` VALUES ('16795', '23', 'Паудер Спрингс', 'Powder Springs', 'GA', '30127', '33.8821', '-84.7062');
INSERT INTO `net_city` VALUES ('16831', '24', 'Сквамиш', 'Squamish', 'BC', 'v5g4m1', '49.7000', '-123.1500');
INSERT INTO `net_city` VALUES ('16843', '23', 'Маккино Сити', 'Mackinaw City', 'MI', '49701', '45.7554', '-84.6961');
INSERT INTO `net_city` VALUES ('16848', '24', 'Чесли', 'Chesley', 'ON', 'n0g1l0', '44.3000', '-81.1000');
INSERT INTO `net_city` VALUES ('16849', '23', 'Маакпорт', 'Mauckport', 'IN', '47142', '38.0756', '-86.2046');
INSERT INTO `net_city` VALUES ('16857', '23', 'Борон', 'Boron', 'CA', '93516', '34.9624', '-117.6698');
INSERT INTO `net_city` VALUES ('16861', '23', 'Пласитас', 'Placitas', 'NM', '87043', '35.2913', '-106.4469');
INSERT INTO `net_city` VALUES ('16877', '21', 'Стокпорт', 'Stockport', 'N2', '', '53.4000', '-2.1500');
INSERT INTO `net_city` VALUES ('16889', '24', 'Хай Левел', 'High Level', 'AB', 't0h1z0', '58.5167', '-117.1333');
INSERT INTO `net_city` VALUES ('16905', '23', 'Грон', 'Grawn', 'MI', '49637', '44.6273', '-85.6659');
INSERT INTO `net_city` VALUES ('16906', '23', 'Клинт', 'Clint', 'TX', '79836', '31.5642', '-106.1954');
INSERT INTO `net_city` VALUES ('16910', '23', 'Хиллсборо', 'Hillsborough', 'NH', '03244', '43.1196', '-71.9317');
INSERT INTO `net_city` VALUES ('16911', '23', 'Хуксетт', 'Hooksett', 'NH', '03106', '43.0649', '-71.4112');
INSERT INTO `net_city` VALUES ('16917', '23', 'Ганнисон', 'Gunnison', 'CO', '81230', '38.4378', '-107.0601');
INSERT INTO `net_city` VALUES ('16926', '24', 'Боннивилл', 'Bonnyville', 'AB', '', '54.2678', '-110.7508');
INSERT INTO `net_city` VALUES ('16930', '24', 'Порт-Харди ', 'Port Hardy', 'BC', 'v0n2p0', '50.7167', '-127.5000');
INSERT INTO `net_city` VALUES ('16932', '24', 'Баррхед', 'Barrhead', 'AB', 't7n1a4', '54.1167', '-114.4000');
INSERT INTO `net_city` VALUES ('16935', '24', 'Драмеллер', 'Drumheller', 'AB', 't0j0y0', '51.4667', '-112.7000');
INSERT INTO `net_city` VALUES ('16937', '24', 'Херст', 'Hearst', 'ON', 'p0l1n0', '49.7000', '-83.6667');
INSERT INTO `net_city` VALUES ('16939', '23', 'Ратон', 'Raton', 'NM', '87740', '36.6873', '-104.2485');
INSERT INTO `net_city` VALUES ('16940', '23', 'Амелия Корт Хаус', 'Amelia Court House', 'VA', '23002', '37.3479', '-77.9724');
INSERT INTO `net_city` VALUES ('16942', '23', 'Тарентум', 'Tarentum', 'PA', '15084', '40.6172', '-79.8058');
INSERT INTO `net_city` VALUES ('16943', '24', 'Линдсей', 'Lindsay', 'ON', 'k9v6b8', '44.3500', '-78.7333');
INSERT INTO `net_city` VALUES ('16946', '23', 'Лэнгдон', 'Langdon', 'ND', '58249', '48.8155', '-98.2891');
INSERT INTO `net_city` VALUES ('16950', '24', 'Уэстлок', 'Westlock', 'AB', 't0g2l0', '54.1500', '-113.8667');
INSERT INTO `net_city` VALUES ('16954', '23', 'Детройт-Лейкс', 'Detroit Lakes', 'MN', '56501', '46.8241', '-95.8481');
INSERT INTO `net_city` VALUES ('16955', '24', 'Фергюс', 'Fergus', 'ON', 'n1m3h2', '43.7070', '-80.3777');
INSERT INTO `net_city` VALUES ('16957', '23', 'Хазлхерст', 'Hazlehurst', 'GA', '31539', '31.8217', '-82.6268');
INSERT INTO `net_city` VALUES ('16959', '23', 'Уиннер', 'Winner', 'SD', '57580', '43.3560', '-100.0037');
INSERT INTO `net_city` VALUES ('16963', '24', 'Бельвилл', 'Belleville', 'ON', '', '44.1667', '-77.3833');
INSERT INTO `net_city` VALUES ('16965', '24', 'Эдсон', 'Edson', 'AB', 't1e1r8', '53.5833', '-116.4167');
INSERT INTO `net_city` VALUES ('16967', '24', 'Тетфор Мин', 'Thetford Mines', 'QC', '', '46.0901', '-71.3089');
INSERT INTO `net_city` VALUES ('16971', '24', 'Тракади', 'Tracadie', 'NS', '', '45.6167', '-61.6500');
INSERT INTO `net_city` VALUES ('16975', '24', 'Тербон', 'Terrebonne', 'QC', '', '45.6833', '-73.6333');
INSERT INTO `net_city` VALUES ('16983', '24', 'Аксбридж', 'Uxbridge', 'ON', 'l9p1r2', '44.1000', '-79.1167');
INSERT INTO `net_city` VALUES ('16993', '23', 'Холстад', 'Halstad', 'MN', '56548', '47.3723', '-96.7475');
INSERT INTO `net_city` VALUES ('16999', '24', 'Тилсонберг', 'Tillsonburg', 'ON', 'n3r5l8', '42.8667', '-80.7333');
INSERT INTO `net_city` VALUES ('17001', '23', 'Блу-Эрт', 'Blue Earth', 'MN', '56013', '43.6229', '-94.1012');
INSERT INTO `net_city` VALUES ('17003', '23', 'Лейк Милс', 'Lake Mills', 'IA', '50450', '43.4065', '-93.5156');
INSERT INTO `net_city` VALUES ('17006', '23', 'Уолкерсвилл', 'Walkersville', 'WV', '26447', '38.9346', '-80.4427');
INSERT INTO `net_city` VALUES ('17010', '23', 'Бакфилд', 'Buckfield', 'ME', '04220', '44.2997', '-70.3698');
INSERT INTO `net_city` VALUES ('17013', '23', 'Белчертаун', 'Belchertown', 'MA', '01007', '42.2723', '-72.4020');
INSERT INTO `net_city` VALUES ('17017', '23', 'Калмар', 'Calmar', 'IA', '52132', '43.1883', '-91.8616');
INSERT INTO `net_city` VALUES ('17051', '34', 'Нагария', 'Nahariya', '03', '', '33.0059', '35.0941');
INSERT INTO `net_city` VALUES ('17052', '34', 'Хайфа', 'Haifa', '04', '', '32.8156', '34.9892');
INSERT INTO `net_city` VALUES ('17053', '34', 'Иерусалим', 'Jerusalem', '06', '', '31.7800', '35.2300');
INSERT INTO `net_city` VALUES ('17054', '34', 'Тель-Авив', 'Tel Aviv', '05', '', '32.0667', '34.7667');
INSERT INTO `net_city` VALUES ('17055', '34', 'Нацерет Иллит', 'Nazareth Illit', '03', '', '32.7082', '35.3247');
INSERT INTO `net_city` VALUES ('17059', '34', 'Герцлия', 'Herzliya', '05', '', '32.1658', '34.8367');
INSERT INTO `net_city` VALUES ('17060', '34', 'Реховот', 'Rehovot', '02', '', '31.8969', '34.8186');
INSERT INTO `net_city` VALUES ('17067', '24', 'Мейгог', 'Magog', 'QC', 'j1x5p8', '45.2667', '-72.1500');
INSERT INTO `net_city` VALUES ('17072', '23', 'Порт Ричи', 'Port Richey', 'FL', '34668', '28.3031', '-82.7048');
INSERT INTO `net_city` VALUES ('17073', '24', 'Сент-Эсташ ', 'Saint Eustache', 'QC', 'j7r1x9', '45.5667', '-73.9000');
INSERT INTO `net_city` VALUES ('17076', '24', 'Дели', 'Delhi', 'ON', 'n4b2n2', '42.8551', '-80.4918');
INSERT INTO `net_city` VALUES ('17079', '24', 'Бобкейджен', 'Bobcaygeon', 'ON', 'k0m1a0', '44.5333', '-78.5500');
INSERT INTO `net_city` VALUES ('17087', '23', 'Каллауэй', 'Callaway', 'VA', '24067', '37.0532', '-80.0963');
INSERT INTO `net_city` VALUES ('17090', '24', 'Лейкфилд', 'Lakefield', 'ON', 'k0l2h0', '44.4333', '-78.2667');
INSERT INTO `net_city` VALUES ('17101', '24', 'Уингем', 'Wingham', 'ON', 'n0g2w0', '43.8875', '-81.3111');
INSERT INTO `net_city` VALUES ('17131', '23', 'Вансеборо', 'Vanceboro', 'NC', '28586', '35.3099', '-77.1821');
INSERT INTO `net_city` VALUES ('17136', '23', 'Блу Аш', 'Blue Ash', 'OH', '45147', '39.2126', '-84.2994');
INSERT INTO `net_city` VALUES ('17137', '23', 'Диксон Сити', 'Dickson City', 'PA', '18519', '41.4636', '-75.6291');
INSERT INTO `net_city` VALUES ('17138', '23', 'Нантикок', 'Nanticoke', 'PA', '18634', '41.1838', '-76.0341');
INSERT INTO `net_city` VALUES ('17142', '23', 'Даллес', 'The Dalles', 'OR', '97058', '45.5447', '-121.1543');
INSERT INTO `net_city` VALUES ('17160', '23', 'Валрико', 'Valrico', 'FL', '33594', '27.9158', '-82.2290');
INSERT INTO `net_city` VALUES ('17178', '23', 'Луц', 'Lutz', 'FL', '33549', '28.1360', '-82.4476');
INSERT INTO `net_city` VALUES ('17198', '23', 'Фортсон', 'Fortson', 'GA', '31808', '32.6337', '-85.0055');
INSERT INTO `net_city` VALUES ('17212', '23', 'Темпл Террас', 'Temple Terrace', 'FL', '33592', '28.0985', '-82.2734');
INSERT INTO `net_city` VALUES ('17218', '23', 'Грин Валли', 'Green Valley', 'AZ', '85614', '31.8466', '-111.0605');
INSERT INTO `net_city` VALUES ('17224', '23', 'Сан Сити Сентер', 'Sun City Center', 'FL', '33573', '27.7313', '-82.3620');
INSERT INTO `net_city` VALUES ('17242', '23', 'Рамер', 'Ramer', 'AL', '36069', '32.1018', '-86.1399');
INSERT INTO `net_city` VALUES ('17243', '23', 'Атлантик Бич', 'Atlantic Beach', 'FL', '32233', '30.3607', '-81.4262');
INSERT INTO `net_city` VALUES ('17250', '23', 'Онслоу', 'Onslow', 'IA', '52321', '42.1407', '-90.9763');
INSERT INTO `net_city` VALUES ('17255', '24', 'Милтон', 'Milton (Ontario)', 'ON', 'l9t5a6', '43.5136', '-79.8840');
INSERT INTO `net_city` VALUES ('17256', '23', 'Пейтон', 'Peyton', 'CO', '80831', '39.0024', '-104.5271');
INSERT INTO `net_city` VALUES ('17258', '23', 'Элк Хорн', 'Elk Horn', 'IA', '51531', '41.5827', '-95.0833');
INSERT INTO `net_city` VALUES ('17260', '23', 'Алта', 'Alta', 'IA', '51002', '42.7060', '-95.3188');
INSERT INTO `net_city` VALUES ('17268', '23', 'Минберн', 'Minburn', 'IA', '50167', '41.7420', '-94.0075');
INSERT INTO `net_city` VALUES ('17272', '24', 'Порт Хоп', 'Port Hope', 'ON', 'l1a3v6', '43.9500', '-78.3000');
INSERT INTO `net_city` VALUES ('17273', '24', 'Гранби', 'Granby', 'QC', 'j2h1e8', '45.4054', '-72.7286');
INSERT INTO `net_city` VALUES ('17285', '23', 'Чатем', 'Chatham', 'MA', '02633', '41.6872', '-69.9794');
INSERT INTO `net_city` VALUES ('17286', '23', 'Хефлин', 'Heflin', 'AL', '36264', '33.5809', '-85.5437');
INSERT INTO `net_city` VALUES ('17296', '23', 'Акме', 'Acme', 'WA', '98220', '48.7030', '-122.1920');
INSERT INTO `net_city` VALUES ('17310', '24', 'Броквилл', 'Brockville', 'ON', 'k6v3p6', '44.5833', '-75.6833');
INSERT INTO `net_city` VALUES ('17316', '24', 'Стратфорд ', 'Stratford (Ontario)', 'ON', 'n5a2n3', '43.3667', '-80.9833');
INSERT INTO `net_city` VALUES ('17317', '24', 'Форт Эри', 'Fort Erie', 'ON', 'l2a1n2', '42.9000', '-78.9333');
INSERT INTO `net_city` VALUES ('17350', '24', 'Трентон', 'Trenton (Ontario)', 'ON', 'k8v6s3', '44.1000', '-77.5833');
INSERT INTO `net_city` VALUES ('17352', '24', 'Стратрой', 'Strathroy', 'ON', 'n7g3e3', '42.9500', '-81.6167');
INSERT INTO `net_city` VALUES ('17396', '23', 'Блэрстаун', 'Blairstown', 'IA', '52209', '41.9056', '-92.0991');
INSERT INTO `net_city` VALUES ('17428', '24', 'Напани', 'Napanee', 'ON', 'k7r1z5', '44.2500', '-76.9500');
INSERT INTO `net_city` VALUES ('17430', '23', 'Ван Хорн', 'Van Horne', 'IA', '52346', '42.0073', '-92.0768');
INSERT INTO `net_city` VALUES ('17441', '23', 'Данкертон', 'Dunkerton', 'IA', '50626', '42.5771', '-92.1776');
INSERT INTO `net_city` VALUES ('17449', '24', 'Хоксбери', 'Hawkesbury', 'ON', 'k6a1k5', '45.6098', '-74.6101');
INSERT INTO `net_city` VALUES ('17457', '24', 'Текамсе', 'Tecumseh', 'ON', 'n0r1k0', '42.3167', '-82.9000');
INSERT INTO `net_city` VALUES ('17496', '24', 'Форт Франсес', 'Fort Frances', 'ON', 'p9a3m6', '48.6116', '-93.4011');
INSERT INTO `net_city` VALUES ('17554', '24', 'Бушервиль', 'Boucherville', 'QC', 'j4b5h1', '45.6000', '-73.4500');
INSERT INTO `net_city` VALUES ('17564', '23', 'Кэтлин', 'Kathleen', 'FL', '33849', '28.2344', '-82.0495');
INSERT INTO `net_city` VALUES ('17578', '24', 'Ривьер-дю-Лу', 'Riviere Du Loup', 'QC', 'g5r5x9', '47.8333', '-69.5333');
INSERT INTO `net_city` VALUES ('17602', '24', 'Сент-Юбер', 'Saint-Hubert', 'QC', 'j3y8y5', '47.8184', '-69.1505');
INSERT INTO `net_city` VALUES ('17622', '24', 'Сен-Марк-Сюр-Ришелье', 'Saint Marc sur Richelieu', 'QC', 'j3g4c9', '45.5667', '-73.2000');
INSERT INTO `net_city` VALUES ('17624', '24', 'Маниваки', 'Maniwaki', 'QC', 'j9e3a9', '46.3667', '-75.9667');
INSERT INTO `net_city` VALUES ('17642', '23', 'Холидей ', 'Holiday', 'FL', '34690', '28.1913', '-82.7227');
INSERT INTO `net_city` VALUES ('17651', '24', 'Ла Мальбе', 'La Malbaie', 'QC', 'g5a1n2', '47.6500', '-70.1667');
INSERT INTO `net_city` VALUES ('17653', '23', 'Гейтуэй', 'Gateway', 'CO', '81522', '38.6247', '-109.0016');
INSERT INTO `net_city` VALUES ('17663', '23', 'Крейг', 'Craig', 'CO', '81625', '40.6762', '-107.8126');
INSERT INTO `net_city` VALUES ('17664', '23', 'Карбондейл', 'Carbondale', 'CO', '81623', '39.1813', '-107.2261');
INSERT INTO `net_city` VALUES ('17675', '24', 'Мон-Трамблан', 'Mont Tremblant', 'QC', 'j8e2z9', '46.1984', '-74.6292');
INSERT INTO `net_city` VALUES ('17676', '24', 'Ковансвиль', 'Cowansville', 'QC', 'j2k3l9', '45.2098', '-72.7415');
INSERT INTO `net_city` VALUES ('17678', '24', 'Коборг', 'Cobourg', 'ON', 'k9a5p5', '43.9638', '-78.1702');
INSERT INTO `net_city` VALUES ('17687', '24', 'Сент-Агат-Де-Мон', 'Sainte-Agathe-des-Monts', 'QC', 'j8c1l3', '46.0333', '-74.2833');
INSERT INTO `net_city` VALUES ('17732', '24', 'Перт', 'Perth', 'ON', 'k7h3e3', '44.8983', '-76.2449');
INSERT INTO `net_city` VALUES ('17765', '24', 'Брайтон', 'Brighton', 'ON', 'k0k1h0', '44.0421', '-77.7382');
INSERT INTO `net_city` VALUES ('17784', '24', 'Дип Ривер', 'Deep River', 'ON', 'k0j1p0', '46.1667', '-77.5667');
INSERT INTO `net_city` VALUES ('17785', '24', 'Альмонте', 'Almonte', 'ON', 'k0a1a0', '45.2289', '-76.1974');
INSERT INTO `net_city` VALUES ('17786', '24', 'Арнприор', 'Arnprior', 'ON', 'k7s3h2', '45.4363', '-76.3625');
INSERT INTO `net_city` VALUES ('17795', '24', 'Жонкьер', 'Jonquiere', 'QC', 'g7s2a9', '48.4167', '-71.2500');
INSERT INTO `net_city` VALUES ('17802', '24', 'Делсон', 'Delson', 'QC', 'j0l1g0', '45.3667', '-73.5500');
INSERT INTO `net_city` VALUES ('17809', '24', 'Сен-Жером', 'Saint Jerome', 'QC', 'j7y4b6', '45.7667', '-74.0000');
INSERT INTO `net_city` VALUES ('17816', '24', 'Ла-Бе', 'La Baie', 'QC', 'g7b2n8', '48.3333', '-70.8667');
INSERT INTO `net_city` VALUES ('17874', '24', 'Пойнт Эдуард', 'Point Edward', 'ON', 'n7v4j5', '43.0000', '-82.4000');
INSERT INTO `net_city` VALUES ('17885', '24', 'Ингерсолл', 'Ingersoll', 'ON', 'n5c3k5', '43.0400', '-80.8816');
INSERT INTO `net_city` VALUES ('17953', '24', 'Торолд', 'Thorold', 'ON', 'l2v4y6', '43.1167', '-79.2000');
INSERT INTO `net_city` VALUES ('17993', '24', 'Порт Колборн', 'Port Colborne', 'ON', 'l3k5v7', '42.8833', '-79.2333');
INSERT INTO `net_city` VALUES ('18017', '24', 'Хоп', 'Hope', 'ON', 'l1a1a6', '49.3833', '-121.4333');
INSERT INTO `net_city` VALUES ('18026', '24', 'Парри Саунд', 'Parry Sound', 'ON', 'p2a1z1', '45.3333', '-80.0333');
INSERT INTO `net_city` VALUES ('18072', '24', 'Ренфрю', 'Renfrew', 'ON', 'k7v2y6', '45.4741', '-76.6915');
INSERT INTO `net_city` VALUES ('18112', '24', 'Беркс Фолс', 'Burks Falls', 'ON', 't0a1c0', '45.6167', '-79.4167');
INSERT INTO `net_city` VALUES ('18116', '24', 'Уоллесберг', 'Wallaceburg', 'ON', 'n8a4l8', '42.5984', '-82.3916');
INSERT INTO `net_city` VALUES ('18118', '24', 'Артур', 'Arthur', 'ON', 'n0g1a0', '43.8333', '-80.5333');
INSERT INTO `net_city` VALUES ('18144', '24', 'Кэмпбеллфорд', 'Campbellford', 'ON', 'k0l1l0', '44.3000', '-77.8000');
INSERT INTO `net_city` VALUES ('18145', '24', 'Кинг-Сити', 'King City', 'ON', 'l7b1h7', '43.9333', '-79.5333');
INSERT INTO `net_city` VALUES ('18187', '24', 'Мефорд', 'Meaford', 'ON', 'n4l1r2', '44.6000', '-80.5833');
INSERT INTO `net_city` VALUES ('18374', '24', 'Матан', 'Matane', 'QC', 'g4w3m9', '48.8500', '-67.5167');
INSERT INTO `net_city` VALUES ('18401', '24', 'Карп', 'Carp', 'ON', 'k0a1l0', '45.3500', '-76.0333');
INSERT INTO `net_city` VALUES ('18420', '24', 'Лимингтон', 'Leamington', 'ON', 'n8h2l2', '42.0511', '-82.6013');
INSERT INTO `net_city` VALUES ('18434', '24', 'Симко', 'Simcoe', 'ON', 'n3y4m3', '42.8376', '-80.3073');
INSERT INTO `net_city` VALUES ('18440', '23', 'Ахоски', 'Ahoskie', 'NC', '27910', '36.2868', '-77.0180');
INSERT INTO `net_city` VALUES ('18456', '23', 'Уилльямстон', 'Williamston', 'NC', '27892', '35.8120', '-77.0488');
INSERT INTO `net_city` VALUES ('18468', '23', 'Добсон', 'Dobson', 'NC', '27017', '36.3786', '-80.6300');
INSERT INTO `net_city` VALUES ('18545', '24', 'Коатикук', 'Coaticook', 'QC', 'j1a1n2', '45.1333', '-71.8000');
INSERT INTO `net_city` VALUES ('18550', '24', 'Сен-Венсан-де-Поль', 'Saint-vincent-de-paul', 'QC', 'h7e1a1', '45.6167', '-73.6500');
INSERT INTO `net_city` VALUES ('18632', '24', 'Петролия', 'Petrolia', 'ON', 'n0n1r0', '42.8833', '-82.1500');
INSERT INTO `net_city` VALUES ('18638', '23', 'Станхоп', 'Stanhope', 'NJ', '07874', '40.9190', '-74.7026');
INSERT INTO `net_city` VALUES ('18646', '23', 'Олалла', 'Olalla', 'WA', '98359', '47.4329', '-122.5782');
INSERT INTO `net_city` VALUES ('18647', '23', 'Эмигрант', 'Emigrant', 'MT', '59027', '45.2874', '-110.8689');
INSERT INTO `net_city` VALUES ('18651', '23', 'Фоли Бич', 'Folly Beach', 'SC', '29439', '32.6552', '-79.9404');
INSERT INTO `net_city` VALUES ('18654', '23', 'Сан Валли', 'Sun Valley', 'ID', '83353', '43.6971', '-114.3517');
INSERT INTO `net_city` VALUES ('18656', '23', 'Редвуд-Фолс', 'Redwood Falls', 'MN', '56283', '44.5391', '-95.1504');
INSERT INTO `net_city` VALUES ('18733', '24', 'Инувик', 'Inuvik', 'NT', 'x0e0t0', '68.3500', '-133.7000');
INSERT INTO `net_city` VALUES ('18738', '23', 'Чикамога', 'Chickamauga', 'GA', '30707', '34.7735', '-85.3462');
INSERT INTO `net_city` VALUES ('18739', '23', 'Дансвилл', 'Dansville', 'NY', '14437', '42.5832', '-77.7275');
INSERT INTO `net_city` VALUES ('18743', '23', 'Топпениш', 'Toppenish', 'WA', '98948', '46.2848', '-120.2588');
INSERT INTO `net_city` VALUES ('18746', '23', 'Хогансвилл', 'Hogansville', 'GA', '30230', '33.1846', '-84.9076');
INSERT INTO `net_city` VALUES ('18750', '23', 'Фредериксберг', 'Fredericksburg', 'TX', '78624', '30.2481', '-98.9060');
INSERT INTO `net_city` VALUES ('18755', '23', 'Уилмот', 'Wilmot', 'WI', '53192', '42.5128', '-88.1820');
INSERT INTO `net_city` VALUES ('18761', '23', 'Перрисвилл', 'Perrysville', 'OH', '44864', '40.6624', '-82.3261');
INSERT INTO `net_city` VALUES ('18764', '23', 'Мокси', 'Moxee', 'WA', '98936', '46.5260', '-120.2010');
INSERT INTO `net_city` VALUES ('18765', '23', 'Фискдейл', 'Fiskdale', 'MA', '01518', '42.1065', '-72.1131');
INSERT INTO `net_city` VALUES ('18766', '23', 'Клэтскани', 'Clatskanie', 'OR', '97016', '46.0611', '-123.2749');
INSERT INTO `net_city` VALUES ('18771', '23', 'Шокан', 'Shokan', 'NY', '12481', '41.9770', '-74.2183');
INSERT INTO `net_city` VALUES ('18772', '23', 'Лох Шелдрейк', 'Loch Sheldrake', 'NY', '12759', '41.7699', '-74.6588');
INSERT INTO `net_city` VALUES ('18773', '23', 'Батавия', 'Batavia', 'NY', '14020', '42.9898', '-78.2221');
INSERT INTO `net_city` VALUES ('18774', '23', 'Джонстаун', 'Johnstown', 'NY', '12095', '43.0639', '-74.5044');
INSERT INTO `net_city` VALUES ('18777', '23', 'Маундридж', 'Moundridge', 'KS', '67107', '38.1866', '-97.5280');
INSERT INTO `net_city` VALUES ('18782', '23', 'Майетта', 'Mayetta', 'KS', '66509', '39.3192', '-95.7588');
INSERT INTO `net_city` VALUES ('18785', '23', 'Коттондейл', 'Cottondale', 'FL', '32431', '30.7928', '-85.3975');
INSERT INTO `net_city` VALUES ('18787', '23', 'Фриско', 'Frisco', 'CO', '80443', '39.5744', '-106.0975');
INSERT INTO `net_city` VALUES ('18793', '23', 'Мюнстер', 'Muenster', 'TX', '76252', '33.6912', '-97.3699');
INSERT INTO `net_city` VALUES ('18795', '23', 'Джонсонвилл', 'Johnsonville', 'NY', '12094', '42.8922', '-73.4952');
INSERT INTO `net_city` VALUES ('18797', '23', 'Пайнленд', 'Pineland', 'SC', '29934', '32.6160', '-81.0972');
INSERT INTO `net_city` VALUES ('18800', '23', 'Пасифика', 'Pacifica', 'CA', '94044', '37.6010', '-122.4545');
INSERT INTO `net_city` VALUES ('18804', '23', 'Форт Оглторп', 'Fort Oglethorpe', 'GA', '30742', '34.9398', '-85.2544');
INSERT INTO `net_city` VALUES ('18807', '23', 'Боксфорд', 'Boxford', 'MA', '01921', '42.6789', '-71.0292');
INSERT INTO `net_city` VALUES ('18813', '23', 'Черо', 'Cheraw', 'SC', '29520', '34.6701', '-79.9142');
INSERT INTO `net_city` VALUES ('18814', '23', 'Кингстри', 'Kingstree', 'SC', '29556', '33.6572', '-79.7767');
INSERT INTO `net_city` VALUES ('18837', '23', 'Кортес', 'Cortez', 'CO', '81321', '37.3363', '-108.7271');
INSERT INTO `net_city` VALUES ('18842', '23', 'Хакстун', 'Haxtun', 'CO', '80731', '40.6229', '-102.6127');
INSERT INTO `net_city` VALUES ('18863', '23', 'Грантсборо', 'Grantsboro', 'NC', '28529', '35.0825', '-76.8702');
INSERT INTO `net_city` VALUES ('18864', '23', 'Мантео', 'Manteo', 'NC', '27954', '35.8971', '-75.6826');
INSERT INTO `net_city` VALUES ('18872', '23', 'Окхерст', 'Oakhurst', 'CA', '93644', '37.4033', '-119.6138');
INSERT INTO `net_city` VALUES ('18873', '23', 'Колстрип', 'Colstrip', 'MT', '59323', '45.8842', '-106.6236');
INSERT INTO `net_city` VALUES ('18881', '21', 'Давентри', 'Daventry', 'J1', '', '52.2500', '-1.1667');
INSERT INTO `net_city` VALUES ('18882', '125', 'Шедсму', 'Skedsmo', '01', '', '59.9500', '11.0833');
INSERT INTO `net_city` VALUES ('18892', '24', 'Порт Меллон', 'Port Mellon', 'BC', 'v0n2s0', '49.5167', '-123.4833');
INSERT INTO `net_city` VALUES ('18923', '23', 'Стилвилл', 'Steelville', 'MO', '65565', '37.8591', '-91.0031');
INSERT INTO `net_city` VALUES ('18973', '23', 'Кенли', 'Kenly', 'NC', '27542', '35.6099', '-78.1506');
INSERT INTO `net_city` VALUES ('18974', '23', 'Айл оф Палмс', 'Isle of Palms', 'SC', '29451', '32.8014', '-79.7639');
INSERT INTO `net_city` VALUES ('18978', '23', 'Хикссон', 'Hixson', 'TN', '37343', '35.1705', '-85.2095');
INSERT INTO `net_city` VALUES ('18985', '23', 'Зелиенопл', 'Zelienople', 'PA', '16063', '40.7731', '-80.1137');
INSERT INTO `net_city` VALUES ('19000', '23', 'Уолленд', 'Walland', 'TN', '37886', '35.7460', '-83.8050');
INSERT INTO `net_city` VALUES ('19002', '23', 'Гатлинберг', 'Gatlinburg', 'TN', '37738', '35.6731', '-83.4570');
INSERT INTO `net_city` VALUES ('19004', '23', 'Санибел', 'Sanibel', 'FL', '33957', '26.4577', '-82.0981');
INSERT INTO `net_city` VALUES ('19005', '23', 'Похатан', 'Powhatan', 'VA', '23139', '37.5533', '-77.9345');
INSERT INTO `net_city` VALUES ('19028', '23', 'Хайнс Сити', 'Haines City', 'FL', '33844', '28.0573', '-81.5687');
INSERT INTO `net_city` VALUES ('19040', '23', 'Фонтейн', 'Fountain', 'NC', '27829', '35.6942', '-77.6294');
INSERT INTO `net_city` VALUES ('19041', '23', 'Китти-Хоук', 'Kitty Hawk', 'NC', '27949', '36.1361', '-75.7371');
INSERT INTO `net_city` VALUES ('19044', '23', 'Кридмур', 'Creedmoor', 'NC', '27522', '36.1052', '-78.6868');
INSERT INTO `net_city` VALUES ('19059', '23', 'Джарреттсвилл', 'Jarrettsville', 'MD', '21084', '39.6094', '-76.4574');
INSERT INTO `net_city` VALUES ('19066', '23', 'Саут Питтсбург', 'South Pittsburg', 'TN', '37380', '35.1050', '-85.7721');
INSERT INTO `net_city` VALUES ('19075', '23', 'Лаплас', 'LaPlace', 'LA', '70068', '30.0556', '-90.4780');
INSERT INTO `net_city` VALUES ('19096', '23', 'Биг Стон Гэп', 'Big Stone Gap', 'VA', '24219', '36.8399', '-82.7610');
INSERT INTO `net_city` VALUES ('19100', '23', 'Дональдсон', 'Donaldson', 'IN', '46513', '41.3612', '-86.4442');
INSERT INTO `net_city` VALUES ('19146', '24', 'Ниагара-он-те-Лейк', 'Niagara-on-the-Lake', 'ON', 'l0s1j0', '43.2500', '-79.0667');
INSERT INTO `net_city` VALUES ('19157', '24', 'Кассельман', 'Casselman', 'ON', 'k0a1m0', '45.3159', '-75.0866');
INSERT INTO `net_city` VALUES ('19160', '23', 'Перхем', 'Perham', 'MN', '56573', '46.6084', '-95.5390');
INSERT INTO `net_city` VALUES ('19173', '23', 'Брайсон Сити', 'Bryson City', 'NC', '28713', '35.3749', '-83.4598');
INSERT INTO `net_city` VALUES ('19175', '23', 'Нагс Хед', 'Nags Head', 'NC', '27959', '35.8850', '-75.5911');
INSERT INTO `net_city` VALUES ('19177', '23', 'Эрвин', 'Erwin', 'NC', '28339', '35.2997', '-78.7167');
INSERT INTO `net_city` VALUES ('19197', '23', 'Уинтон', 'Winton', 'NC', '27986', '36.3960', '-76.9342');
INSERT INTO `net_city` VALUES ('19212', '23', 'Банн', 'Bunn', 'NC', '27508', '35.9578', '-78.2472');
INSERT INTO `net_city` VALUES ('19213', '23', 'Кресуэлл', 'Creswell', 'NC', '27928', '35.8328', '-76.4152');
INSERT INTO `net_city` VALUES ('19214', '23', 'Бейборо', 'Bayboro', 'NC', '28515', '35.1474', '-76.7501');
INSERT INTO `net_city` VALUES ('19281', '24', 'Бимсвилл', 'Beamsville', 'ON', 'l0r2c0', '43.1710', '-79.4767');
INSERT INTO `net_city` VALUES ('19293', '160', 'Прогресо', 'Progreso', '01', '', '-0.9000', '-89.5500');
INSERT INTO `net_city` VALUES ('19294', '172', 'Гватемала', 'Guatemala City', '07', '', '14.6211', '-90.5269');
INSERT INTO `net_city` VALUES ('19297', '174', 'Сан-Сальвадор', 'San Salvador', '10', '', '13.7086', '-89.2031');
INSERT INTO `net_city` VALUES ('19298', '172', 'Реформа', 'Reforma', '22', '', '14.9500', '-89.7000');
INSERT INTO `net_city` VALUES ('19299', '167', 'Остров Гвана', 'Guana Island', '00', '', '18.4167', '-64.6167');
INSERT INTO `net_city` VALUES ('19300', '40', 'Буэнос-Айрес', 'Buenos Aires', '07', '', '-34.5875', '-58.6725');
INSERT INTO `net_city` VALUES ('19301', '164', 'Тегусигальпа', 'Tegucigalpa', '08', '', '14.1000', '-87.2167');
INSERT INTO `net_city` VALUES ('19302', '164', 'Сан-Педро-Сула', 'San Pedro Sula', '06', '', '15.5000', '-88.0333');
INSERT INTO `net_city` VALUES ('19303', '173', 'Сан-Хосе', 'San Jose', '08', '', '9.9333', '-84.0833');
INSERT INTO `net_city` VALUES ('19304', '58', 'Сан-Паулу', 'Sao Paulo', '27', '', '-23.4733', '-46.6658');
INSERT INTO `net_city` VALUES ('19305', '169', 'Манагуа', 'Managua', '10', '', '12.1508', '-86.2683');
INSERT INTO `net_city` VALUES ('19309', '176', 'Хэйстингс', 'Hastings', '01', '', '13.0667', '-59.5833');
INSERT INTO `net_city` VALUES ('19312', '176', 'Сент-Джеймс', 'Saint James', '04', '', '13.2000', '-59.6333');
INSERT INTO `net_city` VALUES ('19319', '58', 'Рио-де-Жанейро', 'Rio de Janeiro', '21', '', '-22.9000', '-43.2333');
INSERT INTO `net_city` VALUES ('19320', '175', 'Матурин', 'Maturin', '16', '', '9.7500', '-63.1767');
INSERT INTO `net_city` VALUES ('19321', '175', 'Майкетия', 'Maiquetia', '26', '', '10.6000', '-66.9500');
INSERT INTO `net_city` VALUES ('19322', '175', 'Пунто Фихо', 'Punto Fijo', '11', '', '11.6997', '-70.1992');
INSERT INTO `net_city` VALUES ('19323', '175', 'Пампатар', 'Pampatar', '17', '', '11.0000', '-63.8000');
INSERT INTO `net_city` VALUES ('19324', '175', 'Пуэрто-Ордас', 'Puerto Ordaz', '06', '', '8.2981', '-62.7186');
INSERT INTO `net_city` VALUES ('19325', '175', 'Пуэрто-ла-Крус', 'Puerto la Cruz', '01', '', '5.1667', '-66.5333');
INSERT INTO `net_city` VALUES ('19326', '175', 'Ла-Гуайра', 'La Guaira', '26', '', '10.6000', '-66.9333');
INSERT INTO `net_city` VALUES ('19327', '175', 'Баркисимето', 'Barquisimeto', '13', '', '10.0739', '-69.3228');
INSERT INTO `net_city` VALUES ('19328', '175', 'Коро', 'Coro', '11', '', '11.4092', '-69.6672');
INSERT INTO `net_city` VALUES ('19329', '175', 'Маракайбо', 'Maracaibo', '23', '', '10.6317', '-71.6406');
INSERT INTO `net_city` VALUES ('19330', '175', 'Валера', 'Valera', '21', '', '9.3178', '-70.6036');
INSERT INTO `net_city` VALUES ('19332', '23', 'Орей', 'Ouray', 'CO', '81427', '37.9897', '-107.7345');
INSERT INTO `net_city` VALUES ('19333', '23', 'Танкханнок', 'Tunkhannock', 'PA', '18657', '41.4917', '-75.9849');
INSERT INTO `net_city` VALUES ('19335', '23', 'Холли Спрингс', 'Holly Springs', 'NC', '27540', '35.6022', '-78.8786');
INSERT INTO `net_city` VALUES ('19384', '24', 'Колборн', 'Colborne', 'ON', 'k0k1s0', '44.0167', '-77.8833');
INSERT INTO `net_city` VALUES ('19441', '24', 'Вава', 'Wawa', 'ON', 'p0s1k0', '47.9947', '-84.7700');
INSERT INTO `net_city` VALUES ('19452', '24', 'Чапло', 'Chapleau', 'ON', 'p0m1k0', '47.8333', '-83.4000');
INSERT INTO `net_city` VALUES ('19460', '24', 'Мирабель', 'Mirabel', 'QC', 'j7n1g9', '45.6526', '-74.0915');
INSERT INTO `net_city` VALUES ('19468', '24', 'Маривиль', 'Marieville', 'QC', 'j3m1e5', '45.4333', '-73.1667');
INSERT INTO `net_city` VALUES ('19471', '185', 'Бастер', 'Basseterre', '03', '', '17.3000', '-62.7167');
INSERT INTO `net_city` VALUES ('19500', '23', 'Орган', 'Organ', 'NM', '88052', '32.4256', '-106.5967');
INSERT INTO `net_city` VALUES ('19504', '23', 'Хавиленд', 'Haviland', 'KS', '67059', '37.6713', '-99.0959');
INSERT INTO `net_city` VALUES ('19588', '24', 'Боуменвилл', 'Bowmanville', 'ON', 'l1c3k5', '43.9125', '-78.6871');
INSERT INTO `net_city` VALUES ('19621', '24', 'Брейсбридж', 'Bracebridge', 'ON', 'p1l1s1', '45.0333', '-79.3000');
INSERT INTO `net_city` VALUES ('19628', '23', 'Маунтин-Айрон', 'Mountain Iron', 'MN', '55768', '47.5119', '-92.6829');
INSERT INTO `net_city` VALUES ('19629', '23', 'Ист-Гранд-Форкс', 'East Grand Forks', 'MN', '56721', '47.9591', '-96.9183');
INSERT INTO `net_city` VALUES ('19631', '23', 'Хамел', 'Hamel', 'MN', '55340', '45.0786', '-93.5788');
INSERT INTO `net_city` VALUES ('19635', '23', 'Меквон', 'Mequon', 'WI', '53097', '43.2361', '-88.0336');
INSERT INTO `net_city` VALUES ('19636', '23', 'Уайтфиш', 'Whitefish', 'MT', '59937', '48.4416', '-114.5354');
INSERT INTO `net_city` VALUES ('19639', '23', 'Монтагю', 'Montague', 'MI', '49437', '43.4547', '-86.3453');
INSERT INTO `net_city` VALUES ('19642', '23', 'Валли', 'Valley', 'NE', '68064', '41.3384', '-96.3794');
INSERT INTO `net_city` VALUES ('19645', '24', 'Дауфин', 'Dauphin', 'MB', 'r7n2v5', '51.1500', '-100.0500');
INSERT INTO `net_city` VALUES ('19647', '23', 'Бул', 'Buhl', 'MN', '55713', '47.4935', '-92.7780');
INSERT INTO `net_city` VALUES ('19648', '23', 'Парк-Рапидс', 'Park Rapids', 'MN', '56470', '46.9967', '-95.0898');
INSERT INTO `net_city` VALUES ('19657', '24', 'Йорктон', 'Yorkton', 'SK', 's3n1j6', '51.2167', '-102.4667');
INSERT INTO `net_city` VALUES ('19666', '24', 'Томпсон', 'Thompson', 'MB', 'r8n0a3', '55.7500', '-97.8667');
INSERT INTO `net_city` VALUES ('19667', '24', 'Портедж Ла Прейри', 'Portage la Prairie', 'MB', 'r1n0n9', '49.9667', '-98.3000');
INSERT INTO `net_city` VALUES ('19679', '23', 'Фосстон', 'Fosston', 'MN', '56542', '47.5626', '-95.7462');
INSERT INTO `net_city` VALUES ('19681', '23', 'Ричберг', 'Richburg', 'SC', '29729', '34.6881', '-81.0180');
INSERT INTO `net_city` VALUES ('19688', '23', 'Нью Плимут', 'New Plymouth', 'ID', '83655', '43.9478', '-116.8061');
INSERT INTO `net_city` VALUES ('19689', '24', 'Нельсон', 'Nelson', 'BC', 'v1l4e8', '49.4833', '-117.2833');
INSERT INTO `net_city` VALUES ('19700', '15', 'Мальмё', 'Malmo', '27', '', '55.6000', '13.0000');
INSERT INTO `net_city` VALUES ('19704', '23', 'Лоап Сити', 'Loup City', 'NE', '68853', '41.2787', '-99.0028');
INSERT INTO `net_city` VALUES ('19705', '23', 'Мета', 'Meta', 'MO', '65058', '38.2571', '-92.1178');
INSERT INTO `net_city` VALUES ('19709', '116', 'Рейкьявик', 'Reykjavik', '10', '', '64.1360', '-21.9203');
INSERT INTO `net_city` VALUES ('19712', '23', 'Далхарт', 'Dalhart', 'TX', '79022', '36.1173', '-102.6024');
INSERT INTO `net_city` VALUES ('19714', '23', 'Худ Ривер', 'Hood River', 'OR', '97031', '45.6119', '-121.5866');
INSERT INTO `net_city` VALUES ('19715', '23', 'Бейкер', 'Baker', 'LA', '70704', '30.5882', '-91.1682');
INSERT INTO `net_city` VALUES ('19718', '23', 'Форт Мохаве', 'Fort Mohave', 'AZ', '86426', '35.0072', '-114.5637');
INSERT INTO `net_city` VALUES ('19720', '23', 'Стейтон', 'Stayton', 'OR', '97383', '44.8155', '-122.7292');
INSERT INTO `net_city` VALUES ('19722', '23', 'Биг-Лейк', 'Big Lake', 'MN', '55309', '45.3954', '-93.7593');
INSERT INTO `net_city` VALUES ('19731', '23', 'Кейлуа-Кона', 'Kailua Kona', 'HI', '96745', '19.6406', '-155.9956');
INSERT INTO `net_city` VALUES ('19734', '23', 'Бун Гров', 'Boone Grove', 'IN', '46302', '41.3548', '-87.1295');
INSERT INTO `net_city` VALUES ('19738', '23', 'Вулфборо', 'Wolfeboro', 'NH', '03894', '43.6104', '-71.1649');
INSERT INTO `net_city` VALUES ('19739', '23', 'Ист Тавас', 'East Tawas', 'MI', '48730', '44.3461', '-83.4787');
INSERT INTO `net_city` VALUES ('19765', '23', 'Каддо Милс', 'Caddo Mills', 'TX', '75135', '33.0678', '-96.2081');
INSERT INTO `net_city` VALUES ('19774', '23', 'Гайтон', 'Guyton', 'GA', '31312', '32.3382', '-81.3983');
INSERT INTO `net_city` VALUES ('19775', '23', 'Фэрдейл', 'Fairdale', 'KY', '40118', '38.0970', '-85.7491');
INSERT INTO `net_city` VALUES ('19778', '23', 'Кэмуела', 'Kamuela', 'HI', '96743', '20.0017', '-155.5327');
INSERT INTO `net_city` VALUES ('19781', '23', 'Скотрун', 'Scotrun', 'PA', '18355', '41.0811', '-75.3406');
INSERT INTO `net_city` VALUES ('19782', '23', 'Вейо', 'Veyo', 'UT', '84782', '37.4262', '-113.7234');
INSERT INTO `net_city` VALUES ('19785', '23', 'Гилкрест', 'Gilcrest', 'CO', '80623', '40.2819', '-104.7777');
INSERT INTO `net_city` VALUES ('19790', '23', 'Гранд Лейк', 'Grand Lake', 'CO', '80447', '40.2810', '-105.7929');
INSERT INTO `net_city` VALUES ('19793', '23', 'Монумент', 'Monument', 'CO', '80132', '39.0747', '-104.8104');
INSERT INTO `net_city` VALUES ('19794', '23', 'Игнасио', 'Ignacio', 'CO', '81137', '37.1075', '-107.6681');
INSERT INTO `net_city` VALUES ('19797', '23', 'Элберт', 'Elbert', 'CO', '80106', '39.1222', '-104.5748');
INSERT INTO `net_city` VALUES ('19802', '23', 'Лас-Лунас', 'Los Lunas', 'NM', '87031', '34.7744', '-106.7274');
INSERT INTO `net_city` VALUES ('19803', '23', 'Орандж-Бич', 'Orange Beach', 'AL', '36561', '30.2802', '-87.5918');
INSERT INTO `net_city` VALUES ('19808', '23', 'Форт Холл', 'Fort Hall', 'ID', '83203', '43.0489', '-112.5353');
INSERT INTO `net_city` VALUES ('19809', '23', 'Сода Спрингс', 'Soda Springs', 'ID', '83276', '42.7531', '-111.5328');
INSERT INTO `net_city` VALUES ('19816', '23', 'Саммердейл', 'Summerdale', 'PA', '17093', '40.0326', '-75.0891');
INSERT INTO `net_city` VALUES ('19817', '23', 'Мак-Кинливилл', 'McKinleyville', 'CA', '95519', '40.9474', '-124.0272');
INSERT INTO `net_city` VALUES ('19880', '23', 'Брукдейл', 'Brookdale', 'CA', '95007', '37.1063', '-122.1061');
INSERT INTO `net_city` VALUES ('19883', '33', 'Роттердам', 'Rotterdam', '11', '', '51.9167', '4.5000');
INSERT INTO `net_city` VALUES ('19884', '29', 'Гиссен ', 'Giessen', '05', '', '50.5833', '8.6500');
INSERT INTO `net_city` VALUES ('19887', '29', 'Драйайх ', 'Dreieich', '05', '', '50.0000', '8.7000');
INSERT INTO `net_city` VALUES ('19888', '13', 'Лайнате', 'Lainate', '09', '', '45.5667', '9.0333');
INSERT INTO `net_city` VALUES ('19889', '13', 'Верона', 'Verona', '20', '', '45.4500', '11.0000');
INSERT INTO `net_city` VALUES ('19909', '23', 'Игл', 'Eagle', 'WI', '53119', '42.8873', '-88.4953');
INSERT INTO `net_city` VALUES ('19912', '23', 'Хайку', 'Haiku', 'HI', '96708', '20.8588', '-156.1405');
INSERT INTO `net_city` VALUES ('19916', '23', 'Пасифик Гров', 'Pacific Grove', 'CA', '93950', '36.6175', '-121.9213');
INSERT INTO `net_city` VALUES ('19921', '23', 'Каудерспорт', 'Coudersport', 'PA', '16915', '41.7992', '-77.9343');
INSERT INTO `net_city` VALUES ('19929', '23', 'Страсберг', 'Strasburg', 'VA', '22657', '39.0102', '-78.3440');
INSERT INTO `net_city` VALUES ('19931', '23', 'Сент-Олбанс', 'Saint Albans', 'VT', '05478', '44.8091', '-73.0922');
INSERT INTO `net_city` VALUES ('19934', '29', 'Вальдорф', 'Walldorf', '01', '', '49.3064', '8.6453');
INSERT INTO `net_city` VALUES ('19938', '23', 'Квин-Сити', 'Queen City', 'TX', '75572', '33.2217', '-94.1328');
INSERT INTO `net_city` VALUES ('19941', '24', 'Мишен', 'Mission', 'BC', 'v2v1e4', '49.1333', '-122.3000');
INSERT INTO `net_city` VALUES ('19951', '23', 'Хансон', 'Hanson', 'MA', '02341', '42.0560', '-70.8731');
INSERT INTO `net_city` VALUES ('19960', '23', 'Сансет Бич', 'Sunset Beach', 'CA', '90742', '33.7199', '-118.0743');
INSERT INTO `net_city` VALUES ('19971', '23', 'Форест-Лейк', 'Forest Lake', 'MN', '55025', '45.2673', '-93.0196');
INSERT INTO `net_city` VALUES ('19972', '23', 'Лонг Лейк', 'Long Lake', 'MN', '55356', '44.9891', '-93.5932');
INSERT INTO `net_city` VALUES ('19986', '23', 'Делтона', 'Deltona', 'FL', '32725', '28.8841', '-81.2348');
INSERT INTO `net_city` VALUES ('19989', '23', 'Сисеро', 'Cicero', 'NY', '13039', '43.1669', '-76.0558');
INSERT INTO `net_city` VALUES ('19990', '23', 'Суонвилл', 'Swanville', 'MN', '56382', '45.9187', '-94.6142');
INSERT INTO `net_city` VALUES ('19998', '24', 'Вандерхуф', 'Vanderhoof', 'BC', 'v0j3a0', '54.0167', '-124.0167');
INSERT INTO `net_city` VALUES ('20001', '24', 'Оливер', 'Oliver', 'BC', 'v0h1t0', '49.1833', '-119.5500');
INSERT INTO `net_city` VALUES ('20056', '24', 'Бамфилд', 'Bamfield', 'BC', 'v0r1b0', '48.8333', '-125.1500');
INSERT INTO `net_city` VALUES ('20067', '6', 'Бангалор', 'Bangalore', '19', '', '12.9833', '77.5833');
INSERT INTO `net_city` VALUES ('20095', '23', 'Гранд-Рапидс', 'Grand Rapids', 'MN', '55744', '47.2432', '-93.5119');
INSERT INTO `net_city` VALUES ('20096', '24', 'Морден', 'Morden', 'MB', 'r6m1e1', '49.1833', '-98.1000');
INSERT INTO `net_city` VALUES ('20100', '175', 'Порламар', 'Porlamar', '17', '', '10.9500', '-63.8500');
INSERT INTO `net_city` VALUES ('20102', '23', 'Дассел', 'Dassel', 'MN', '55325', '45.0931', '-94.3280');
INSERT INTO `net_city` VALUES ('20103', '23', 'Хорнелл', 'Hornell', 'NY', '14843', '42.3056', '-77.6315');
INSERT INTO `net_city` VALUES ('20104', '33', 'Утрехт', 'Utrecht', '09', '', '52.0938', '5.1191');
INSERT INTO `net_city` VALUES ('20116', '24', 'Савона', 'Savona', 'BC', 'v0k2j0', '50.7500', '-120.8500');
INSERT INTO `net_city` VALUES ('20124', '35', 'Вальядолид', 'Valladolid', '55', '', '41.6552', '-4.7237');
INSERT INTO `net_city` VALUES ('20127', '23', 'Палмертон', 'Palmerton', 'PA', '18071', '40.8366', '-75.5883');
INSERT INTO `net_city` VALUES ('20151', '24', 'Хантсвилл', 'Huntsville', 'ON', 'p1h2j4', '45.3333', '-79.2167');
INSERT INTO `net_city` VALUES ('20168', '146', 'Олд-Роуд', 'Old Road', '05', '', '17.0167', '-61.8333');
INSERT INTO `net_city` VALUES ('20169', '41', 'Розо', 'Roseau', '04', '', '15.3000', '-61.4000');
INSERT INTO `net_city` VALUES ('20170', '194', 'Кастри', 'Castries', '03', '', '14.0000', '-61.0000');
INSERT INTO `net_city` VALUES ('20171', '203', 'Ангилья', 'Anguilla', '00', '', '18.2000', '-63.0667');
INSERT INTO `net_city` VALUES ('20172', '146', 'Джолли Харбор', 'Jolly Harbour', '04', '', '17.1333', '-61.8167');
INSERT INTO `net_city` VALUES ('20182', '24', 'Сент-Иасент', 'Saint Hyacinthe', 'QC', 'j2s8a5', '45.6333', '-72.9333');
INSERT INTO `net_city` VALUES ('20273', '23', 'Чалметт', 'Chalmette', 'LA', '70043', '29.9566', '-89.9642');
INSERT INTO `net_city` VALUES ('20274', '23', 'Франклин', 'Franklin', 'LA', '70538', '29.7521', '-91.4813');
INSERT INTO `net_city` VALUES ('20278', '23', 'Латчер', 'Lutcher', 'LA', '70071', '30.0496', '-90.7029');
INSERT INTO `net_city` VALUES ('20283', '24', 'Террас', 'Terrace', 'BC', 'v8g4v2', '54.5000', '-128.5833');
INSERT INTO `net_city` VALUES ('20284', '23', 'Уиннфилд', 'Winnfield', 'LA', '71483', '31.8835', '-92.6600');
INSERT INTO `net_city` VALUES ('20285', '23', 'ДеРиддер', 'DeRidder', 'LA', '70634', '30.8277', '-93.2494');
INSERT INTO `net_city` VALUES ('20294', '24', 'Мансон', 'Munson', 'AB', 't0j2c0', '51.5667', '-112.7500');
INSERT INTO `net_city` VALUES ('20340', '24', 'Три Хилс', 'Three Hills', 'AB', 't0m2n0', '51.7000', '-113.2667');
INSERT INTO `net_city` VALUES ('20346', '24', 'Понока', 'Ponoka', 'AB', 't4j1p6', '52.6833', '-113.5667');
INSERT INTO `net_city` VALUES ('20347', '24', 'Бомонт', 'Beaumont', 'AB', 't4x1j2', '53.3700', '-113.4100');
INSERT INTO `net_city` VALUES ('20372', '23', 'Иммакулата', 'Immaculata', 'PA', '19345', '30.7249', '-91.9710');
INSERT INTO `net_city` VALUES ('20375', '23', 'Уоллова', 'Wallowa', 'OR', '97885', '45.5658', '-117.5043');
INSERT INTO `net_city` VALUES ('20384', '23', 'Ла Квинта', 'La Quinta', 'NC', '27925', '35.8335', '-76.1961');
INSERT INTO `net_city` VALUES ('20385', '23', 'Хо Ривер', 'Haw River', 'NC', '27258', '36.0539', '-79.3494');
INSERT INTO `net_city` VALUES ('20387', '23', 'Уолнат Ков', 'Walnut Cove', 'NC', '27052', '36.3178', '-80.1813');
INSERT INTO `net_city` VALUES ('20388', '23', 'Керритак', 'Currituck', 'NC', '27929', '36.4249', '-75.9707');
INSERT INTO `net_city` VALUES ('20389', '23', 'Мойок', 'Moyock', 'NC', '27958', '36.4726', '-76.1579');
INSERT INTO `net_city` VALUES ('20390', '23', 'Поплар Бранч', 'Poplar Branch', 'NC', '27965', '36.2508', '-75.9137');
INSERT INTO `net_city` VALUES ('20391', '23', 'Мейпл', 'Maple', 'NC', '27956', '36.4195', '-76.0303');
INSERT INTO `net_city` VALUES ('20392', '23', 'Роббинсвилл', 'Robbinsville', 'NC', '28771', '35.3414', '-83.8139');
INSERT INTO `net_city` VALUES ('20394', '23', 'Суонквотер', 'Swanquarter', 'NC', '27885', '35.4143', '-76.2658');
INSERT INTO `net_city` VALUES ('20397', '23', 'Крестед Бьютт', 'Crested Butte', 'CO', '81225', '38.8697', '-106.9878');
INSERT INTO `net_city` VALUES ('20401', '23', 'Роленд', 'Rowland', 'NC', '28383', '34.5609', '-79.2721');
INSERT INTO `net_city` VALUES ('20402', '23', 'Игл Спрингс', 'Eagle Springs', 'NC', '27242', '35.3314', '-79.6282');
INSERT INTO `net_city` VALUES ('20403', '23', 'Маннс Харбор', 'Manns Harbor', 'NC', '27953', '35.8290', '-75.7715');
INSERT INTO `net_city` VALUES ('20408', '23', 'Ошен Гров', 'Ocean Grove', 'NJ', '07756', '40.2122', '-74.0076');
INSERT INTO `net_city` VALUES ('20412', '23', 'Брейси', 'Bracey', 'VA', '23919', '36.5879', '-78.1446');
INSERT INTO `net_city` VALUES ('20415', '23', 'Игл Бьютт', 'Eagle Butte', 'SD', '57625', '44.9338', '-100.9795');
INSERT INTO `net_city` VALUES ('20420', '23', 'Суонтон', 'Swanton', 'OH', '43558', '41.5867', '-83.8694');
INSERT INTO `net_city` VALUES ('20440', '23', 'Ашбернем', 'Ashburnham', 'MA', '01430', '42.6541', '-71.9220');
INSERT INTO `net_city` VALUES ('20449', '40', 'Кордоба', 'Cordoba', '05', '', '-31.4000', '-64.1833');
INSERT INTO `net_city` VALUES ('20452', '23', 'Юстис', 'Eustis', 'FL', '32726', '28.8743', '-81.6860');
INSERT INTO `net_city` VALUES ('20453', '23', 'Уиндермир', 'Windermere', 'FL', '34786', '28.4807', '-81.5518');
INSERT INTO `net_city` VALUES ('20455', '23', 'Кристал Ривер', 'Crystal River', 'FL', '34429', '28.8708', '-82.5856');
INSERT INTO `net_city` VALUES ('20457', '23', 'Пеннингтон Гэп', 'Pennington Gap', 'VA', '24277', '36.7549', '-83.0268');
INSERT INTO `net_city` VALUES ('20471', '23', 'Хатчинсон', 'Hutchinson', 'MN', '55350', '44.8994', '-94.4101');
INSERT INTO `net_city` VALUES ('20474', '23', 'Бартонсвилл', 'Bartonsville', 'PA', '18321', '41.0175', '-75.2869');
INSERT INTO `net_city` VALUES ('20475', '23', 'Мейплтон', 'Mapleton', 'MN', '56065', '43.9458', '-93.9230');
INSERT INTO `net_city` VALUES ('20476', '23', 'Бодетт', 'Baudette', 'MN', '56623', '48.6102', '-94.5517');
INSERT INTO `net_city` VALUES ('20491', '23', 'Нью Кейни', 'New Caney', 'TX', '77357', '30.1873', '-95.1469');
INSERT INTO `net_city` VALUES ('20499', '23', 'Ту Харборс', 'Two Harbors', 'MN', '55616', '47.1891', '-91.6050');
INSERT INTO `net_city` VALUES ('20500', '23', 'Игл', 'Eagle', 'ID', '83616', '43.7922', '-116.3878');
INSERT INTO `net_city` VALUES ('20509', '23', 'Мора', 'Mora', 'MN', '55051', '45.9270', '-93.3504');
INSERT INTO `net_city` VALUES ('20512', '23', 'Буффало', 'Buffalo', 'SD', '57720', '45.5792', '-103.5997');
INSERT INTO `net_city` VALUES ('20514', '23', 'Барневельд', 'Barneveld', 'WI', '53507', '43.0057', '-89.8986');
INSERT INTO `net_city` VALUES ('20523', '23', 'Андерхилл', 'Underhill', 'VT', '05489', '44.5471', '-72.8877');
INSERT INTO `net_city` VALUES ('20524', '23', 'Юнион Сити', 'Union City', 'TN', '38261', '36.4146', '-89.1396');
INSERT INTO `net_city` VALUES ('20539', '24', 'Кинкардин', 'Kincardine', 'ON', 'n2z2y9', '44.1742', '-81.6362');
INSERT INTO `net_city` VALUES ('20577', '24', 'Драйден', 'Dryden', 'ON', 'p8n2z7', '49.7833', '-92.8333');
INSERT INTO `net_city` VALUES ('20615', '24', 'Эганвилл', 'Eganville', 'ON', 'k0j1t0', '45.5333', '-77.1000');
INSERT INTO `net_city` VALUES ('20619', '23', 'Кимберли', 'Kimberly', 'ID', '83341', '42.4257', '-114.3827');
INSERT INTO `net_city` VALUES ('20621', '23', 'Термополис', 'Thermopolis', 'WY', '82443', '43.7698', '-108.4541');
INSERT INTO `net_city` VALUES ('20622', '23', 'Шошони', 'Shoshoni', 'WY', '82649', '43.2505', '-108.0859');
INSERT INTO `net_city` VALUES ('20623', '23', 'Диамондвилл', 'Diamondville', 'WY', '83116', '41.7794', '-110.5385');
INSERT INTO `net_city` VALUES ('20624', '23', 'Пейдж', 'Page', 'AZ', '86040', '36.6867', '-111.4159');
INSERT INTO `net_city` VALUES ('20626', '35', 'Барселона', 'Barcelona', '56', '', '41.3984', '2.1741');
INSERT INTO `net_city` VALUES ('20627', '29', 'Гёттинген', 'Gottingen', '06', '', '51.5333', '9.9333');
INSERT INTO `net_city` VALUES ('20628', '33', 'Лейден', 'Leiden', '11', '', '52.1763', '4.5282');
INSERT INTO `net_city` VALUES ('20629', '21', 'Уокингем', 'Wokingham', 'Q2', '', '51.4167', '-0.8333');
INSERT INTO `net_city` VALUES ('20630', '5', 'Осака', 'Osaka', '32', '', '34.6864', '135.5200');
INSERT INTO `net_city` VALUES ('20631', '21', 'Милтон-Кинс', 'Milton Keynes', 'I6', '', '52.0333', '-0.7000');
INSERT INTO `net_city` VALUES ('20632', '55', 'Дублин', 'Dublin', '07', '', '53.3331', '-6.2489');
INSERT INTO `net_city` VALUES ('20633', '33', 'Хелмонд', 'Helmond', '06', '', '51.4814', '5.7001');
INSERT INTO `net_city` VALUES ('20635', '139', 'Райсио', 'Raisio', '15', '', '60.4833', '22.1833');
INSERT INTO `net_city` VALUES ('20638', '29', 'Мюнхен', 'Munich', '02', '', '48.1500', '11.5833');
INSERT INTO `net_city` VALUES ('20647', '23', 'Мани', 'Many', 'LA', '71449', '31.5636', '-93.5041');
INSERT INTO `net_city` VALUES ('20648', '23', 'Молтонборо', 'Moultonborough', 'NH', '03254', '43.7326', '-71.3642');
INSERT INTO `net_city` VALUES ('20655', '24', 'Китимат', 'Kitimat', 'BC', 'v8c2h2', '54.0000', '-128.7000');
INSERT INTO `net_city` VALUES ('20668', '24', 'Кортеней', 'Courtenay', 'BC', 'v9n2r6', '49.6833', '-125.0000');
INSERT INTO `net_city` VALUES ('20691', '24', 'Вклуэлет', 'Ucluelet', 'BC', 'v0r3a0', '48.9333', '-125.5167');
INSERT INTO `net_city` VALUES ('20696', '24', 'Солт Спринг Айленд', 'Salt Spring Island', 'BC', 'v8k1n2', '48.8525', '-123.5022');
INSERT INTO `net_city` VALUES ('20757', '23', 'Коранна', 'Corunna', 'MI', '48817', '43.0211', '-84.0336');
INSERT INTO `net_city` VALUES ('20767', '2', 'Кучинг', 'Kuching', '11', '', '1.5500', '110.3333');
INSERT INTO `net_city` VALUES ('20771', '24', 'Уильямс Лейк', 'Williams Lake', 'BC', 'v2g2a5', '52.1167', '-122.1500');
INSERT INTO `net_city` VALUES ('20784', '24', 'Тофино', 'Tofino', 'BC', 'v0r2z0', '49.1333', '-125.9000');
INSERT INTO `net_city` VALUES ('20790', '23', 'Фэрплей', 'Fairplay', 'CO', '80440', '39.2289', '-105.9809');
INSERT INTO `net_city` VALUES ('20824', '24', 'Лиллоет', 'Lillooet', 'BC', 'v0k1v0', '50.6833', '-121.9333');
INSERT INTO `net_city` VALUES ('20828', '198', 'Джорджтаун', 'Georgetown', '12', '', '6.8000', '-58.1667');
INSERT INTO `net_city` VALUES ('20831', '23', 'Нью-Прейг', 'New Prague', 'MN', '56071', '44.5411', '-93.5902');
INSERT INTO `net_city` VALUES ('20832', '23', 'Брутен', 'Brooten', 'MN', '56316', '45.4846', '-95.1332');
INSERT INTO `net_city` VALUES ('20837', '33', 'Виллемстад', 'Willemstad', '06', '', '51.6930', '4.4392');
INSERT INTO `net_city` VALUES ('20838', '23', 'Ноленсвилл', 'Nolensville', 'TN', '37135', '35.9344', '-86.6781');
INSERT INTO `net_city` VALUES ('20841', '23', 'Хемингфорд', 'Hemingford', 'NE', '69348', '42.3062', '-103.3386');
INSERT INTO `net_city` VALUES ('20842', '23', 'Гранби', 'Granby', 'MO', '64844', '36.9082', '-94.2259');
INSERT INTO `net_city` VALUES ('20844', '23', 'Джонсборо', 'Jonesborough', 'TN', '37659', '36.3022', '-82.4825');
INSERT INTO `net_city` VALUES ('20847', '23', 'Эванстон', 'Evanston', 'WY', '82930', '41.2355', '-110.8313');
INSERT INTO `net_city` VALUES ('20850', '23', 'Уинчендон', 'Winchendon', 'MA', '01475', '42.6610', '-72.0489');
INSERT INTO `net_city` VALUES ('20852', '23', 'Толар', 'Tolar', 'TX', '76476', '32.3825', '-97.9209');
INSERT INTO `net_city` VALUES ('20853', '23', 'Рансон', 'Ranson', 'WV', '25438', '39.3132', '-77.8813');
INSERT INTO `net_city` VALUES ('20859', '23', 'Лонг Валли', 'Long Valley', 'NJ', '07853', '40.7843', '-74.8060');
INSERT INTO `net_city` VALUES ('20863', '23', 'Халивилл', 'Haleyville', 'AL', '35565', '34.2371', '-87.5876');
INSERT INTO `net_city` VALUES ('20866', '23', 'Джеринг', 'Gering', 'NE', '69341', '41.7101', '-103.6648');
INSERT INTO `net_city` VALUES ('20870', '23', 'Данканнон', 'Duncannon', 'PA', '17020', '40.4080', '-77.0322');
INSERT INTO `net_city` VALUES ('20871', '23', 'Маунт Холли Спрингс', 'Mount Holly Springs', 'PA', '17065', '40.0893', '-77.2056');
INSERT INTO `net_city` VALUES ('20878', '23', 'Хинкли', 'Hinckley', 'MN', '55037', '46.0026', '-92.8310');
INSERT INTO `net_city` VALUES ('20881', '23', 'Окичоби', 'Okeechobee', 'FL', '34974', '27.1519', '-81.0611');
INSERT INTO `net_city` VALUES ('20884', '23', 'Колд Спринг', 'Cold Spring', 'MN', '56320', '45.4732', '-94.4124');
INSERT INTO `net_city` VALUES ('20896', '23', 'Парашут', 'Parachute', 'CO', '81635', '39.4782', '-108.0331');
INSERT INTO `net_city` VALUES ('20905', '48', 'Данидин', 'Dunedin', '00', '', '-45.8667', '170.5000');
INSERT INTO `net_city` VALUES ('20907', '23', 'Хоултон', 'Houlton', 'ME', '04730', '46.1154', '-67.9170');
INSERT INTO `net_city` VALUES ('20908', '25', 'Тихуана', 'Tijuana', '02', '', '32.5333', '-117.0167');
INSERT INTO `net_city` VALUES ('20910', '23', 'Девилс Лейк', 'Devils Lake', 'ND', '58301', '48.1436', '-98.8872');
INSERT INTO `net_city` VALUES ('20912', '23', 'Шоу Лоу', 'Show Low', 'AZ', '85901', '34.2338', '-110.0772');
INSERT INTO `net_city` VALUES ('20924', '23', 'Каюга', 'Cayuga', 'IN', '47928', '39.9121', '-87.4437');
INSERT INTO `net_city` VALUES ('20932', '155', 'Порт-о-Пренс', 'Port-au-prince', '11', '', '18.5392', '-72.3350');
INSERT INTO `net_city` VALUES ('20934', '24', 'Ирокез', 'Iroquois', 'ON', 'k0e1k0', '44.8500', '-75.3167');
INSERT INTO `net_city` VALUES ('20942', '23', 'Фергус-Фолс', 'Fergus Falls', 'MN', '56537', '46.2697', '-96.0874');
INSERT INTO `net_city` VALUES ('20944', '20', 'Омск', 'Omsk', '54', '', '55.0000', '73.4000');
INSERT INTO `net_city` VALUES ('20945', '23', 'Деннисон', 'Dennison', 'MN', '55018', '44.4399', '-92.9909');
INSERT INTO `net_city` VALUES ('20949', '23', 'Саутуик', 'Southwick', 'MA', '01077', '42.0499', '-72.7722');
INSERT INTO `net_city` VALUES ('20950', '109', 'Анкара', 'Ankara', '68', '', '39.9117', '32.8403');
INSERT INTO `net_city` VALUES ('20953', '23', 'Уорик', 'Warwick', 'NY', '10990', '41.2639', '-74.3634');
INSERT INTO `net_city` VALUES ('20954', '23', 'Колден', 'Colden', 'NY', '14033', '42.6547', '-78.6798');
INSERT INTO `net_city` VALUES ('20969', '23', 'Кларинда', 'Clarinda', 'IA', '51632', '40.7516', '-95.0539');
INSERT INTO `net_city` VALUES ('20983', '23', 'Гилдерленд', 'Guilderland', 'NY', '12084', '42.7051', '-73.8994');
INSERT INTO `net_city` VALUES ('20996', '23', 'Кранфилс Гэп', 'Cranfills Gap', 'TX', '76637', '31.7558', '-97.8238');
INSERT INTO `net_city` VALUES ('21008', '24', 'Эйлмер', 'Aylmer', 'QC', 'j9h2m7', '45.4000', '-75.8500');
INSERT INTO `net_city` VALUES ('21009', '24', 'Карлтон Плейс', 'Carleton Place', 'ON', 'k7c2v2', '45.1418', '-76.1409');
INSERT INTO `net_city` VALUES ('21012', '24', 'Уайт Рок', 'White Rock', 'BC', 'v4b1y6', '49.0333', '-122.8167');
INSERT INTO `net_city` VALUES ('21033', '23', 'Диллон', 'Dillon', 'CO', '80435', '39.5972', '-105.9247');
INSERT INTO `net_city` VALUES ('21040', '23', 'Дефьюниак Спрингс', 'DeFuniak Springs', 'FL', '32433', '30.8536', '-86.2137');
INSERT INTO `net_city` VALUES ('21044', '23', 'Мэри Эстер', 'Mary Esther', 'FL', '32569', '30.4087', '-86.7569');
INSERT INTO `net_city` VALUES ('21081', '24', 'Табер', 'Taber', 'AB', 't1g2b3', '49.7833', '-112.1500');
INSERT INTO `net_city` VALUES ('21092', '23', 'Рай', 'Rye', 'NH', '03870', '43.0143', '-70.7634');
INSERT INTO `net_city` VALUES ('21145', '24', 'Сешелт', 'Sechelt', 'BC', 'v0n3a0', '49.4667', '-123.7667');
INSERT INTO `net_city` VALUES ('21152', '24', 'Репантиньи', 'Repentigny', 'QC', 'j6a8b4', '45.7333', '-73.4500');
INSERT INTO `net_city` VALUES ('21172', '23', 'Арапахо', 'Arapahoe', 'WY', '82510', '42.9837', '-108.6269');
INSERT INTO `net_city` VALUES ('21176', '23', 'Джиддингс', 'Giddings', 'TX', '78942', '30.1794', '-96.9072');
INSERT INTO `net_city` VALUES ('21189', '12', 'Тулуза', 'Toulouse', 'B3', '', '43.5995', '1.4332');
INSERT INTO `net_city` VALUES ('21198', '23', 'Неседа', 'Necedah', 'WI', '54646', '44.0798', '-90.0879');
INSERT INTO `net_city` VALUES ('21207', '23', 'Ламбертон', 'Lamberton', 'MN', '56152', '44.2247', '-95.2694');
INSERT INTO `net_city` VALUES ('21212', '23', 'Гейлорд', 'Gaylord', 'MN', '55334', '44.5425', '-94.2119');
INSERT INTO `net_city` VALUES ('21216', '23', 'Ледисмит', 'Ladysmith', 'WI', '54848', '45.5254', '-91.0503');
INSERT INTO `net_city` VALUES ('21221', '29', 'Штутгарт', 'Stuttgart', '01', '', '48.7667', '9.1833');
INSERT INTO `net_city` VALUES ('21222', '56', 'Завентем', 'Zaventem', '02', '', '50.8833', '4.4667');
INSERT INTO `net_city` VALUES ('21223', '18', 'Афины', 'Athens', '35', '', '37.9833', '23.7333');
INSERT INTO `net_city` VALUES ('21224', '56', 'Эдегем', 'Edegem', '01', '', '51.1500', '4.4500');
INSERT INTO `net_city` VALUES ('21225', '56', 'Эссен', 'Essen', '01', '', '51.4667', '4.4667');
INSERT INTO `net_city` VALUES ('21227', '21', 'Уиннерш', 'Winnersh', 'Q2', '', '51.4167', '-0.8667');
INSERT INTO `net_city` VALUES ('21228', '21', 'Ашфорд', 'Ashford', 'G5', '', '51.1333', '0.8833');
INSERT INTO `net_city` VALUES ('21229', '29', 'Виллих ', 'Willich', '07', '', '51.2667', '6.5500');
INSERT INTO `net_city` VALUES ('21230', '23', 'Аджер', 'Adger', 'AL', '35006', '33.4326', '-87.2308');
INSERT INTO `net_city` VALUES ('21231', '29', 'Дюссельдорф', 'Dusseldorf', '07', '', '51.2167', '6.7667');
INSERT INTO `net_city` VALUES ('21232', '29', 'Эссен', 'Essen', '07', '', '51.4500', '7.0167');
INSERT INTO `net_city` VALUES ('21234', '29', 'Галле', 'Halle', '14', '', '51.5000', '12.0000');
INSERT INTO `net_city` VALUES ('21235', '114', 'Прага', 'Prague', '52', '', '50.0833', '14.4667');
INSERT INTO `net_city` VALUES ('21237', '21', 'Багшот', 'Bagshot', 'N7', '', '51.3667', '-0.6833');
INSERT INTO `net_city` VALUES ('21238', '12', 'Пюто', 'Puteaux', 'A8', '', '48.8789', '2.2393');
INSERT INTO `net_city` VALUES ('21239', '145', 'Дюделанж', 'Dudelange', '03', '', '49.4806', '6.0875');
INSERT INTO `net_city` VALUES ('21241', '21', 'Сток-он-Трент', 'Stoke on Trent', 'N4', '', '53.0000', '-2.1833');
INSERT INTO `net_city` VALUES ('21242', '125', 'Берген', 'Bergen', '07', '', '60.3911', '5.3247');
INSERT INTO `net_city` VALUES ('21243', '29', 'Хан ', 'Haan', '07', '', '51.2000', '7.0000');
INSERT INTO `net_city` VALUES ('21244', '59', 'Беве', 'Bevaix', '12', '', '46.9324', '6.8161');
INSERT INTO `net_city` VALUES ('21245', '29', 'Нойфарн', 'Neufahrn', '02', '', '48.3167', '11.6667');
INSERT INTO `net_city` VALUES ('21247', '15', 'Дандерюд', 'Danderyd', '26', '', '59.4167', '18.0167');
INSERT INTO `net_city` VALUES ('21248', '7', 'Тайбэй', 'Taipei', '03', '', '25.0392', '121.5250');
INSERT INTO `net_city` VALUES ('21250', '5', 'Иокогама', 'Yokohama', '19', '', '35.4478', '139.6425');
INSERT INTO `net_city` VALUES ('21251', '21', 'Стерлинг', 'Stirling', 'W6', '', '56.1167', '-3.9500');
INSERT INTO `net_city` VALUES ('21252', '13', 'Ананьи', 'Anagni', '07', '', '41.7333', '13.1500');
INSERT INTO `net_city` VALUES ('21258', '23', 'Сомонок', 'Somonauk', 'IL', '60552', '41.6676', '-88.7075');
INSERT INTO `net_city` VALUES ('21272', '24', 'Норт-Батлфорд', 'North Battleford', 'SK', 's9a2y2', '52.7667', '-108.2833');
INSERT INTO `net_city` VALUES ('21281', '24', 'Лампман', 'Lampman', 'SK', 's0c1n0', '49.3833', '-102.7500');
INSERT INTO `net_city` VALUES ('21283', '24', 'Мелфорт', 'Melfort', 'SK', 's0e1a0', '52.8667', '-104.6000');
INSERT INTO `net_city` VALUES ('21296', '24', 'Мус-Джо', 'Moose Jaw', 'SK', 's6h4p8', '50.4000', '-105.5500');
INSERT INTO `net_city` VALUES ('21299', '24', 'Гумбольдт', 'Humboldt', 'SK', 's0k2a0', '52.2000', '-105.1167');
INSERT INTO `net_city` VALUES ('21308', '24', 'Свифт Керрент', 'Swift Current', 'SK', 's9h3x4', '50.2833', '-107.7667');
INSERT INTO `net_city` VALUES ('21319', '23', 'Мейвилл', 'Mayville', 'NY', '14757', '42.2401', '-79.5131');
INSERT INTO `net_city` VALUES ('21343', '23', 'Мариоттсвилл', 'Marriottsville', 'MD', '21104', '39.3456', '-76.9050');
INSERT INTO `net_city` VALUES ('21404', '22', 'Альбертслунн', 'Albertslund', '05', '', '55.6500', '12.3500');
INSERT INTO `net_city` VALUES ('21497', '21', 'Глазго', 'Glasgow', 'V2', '', '55.8333', '-4.2500');
INSERT INTO `net_city` VALUES ('21500', '23', 'Мартиндейл', 'Martindale', 'TX', '78655', '29.8003', '-97.8408');
INSERT INTO `net_city` VALUES ('21502', '23', 'Лэнгли', 'Langley', 'WA', '98260', '48.0435', '-122.4447');
INSERT INTO `net_city` VALUES ('21505', '23', 'Де Леон', 'De Leon', 'TX', '76444', '32.1310', '-98.5836');
INSERT INTO `net_city` VALUES ('21507', '23', 'Гросбек', 'Groesbeck', 'TX', '76642', '31.5116', '-96.5223');
INSERT INTO `net_city` VALUES ('21508', '21', 'Кембридж', 'Cambridge', 'C3', '', '52.2000', '0.1167');
INSERT INTO `net_city` VALUES ('21513', '23', 'Ленора', 'Lenora', 'KS', '67645', '39.5818', '-99.9090');
INSERT INTO `net_city` VALUES ('21514', '23', 'Джошуа', 'Joshua', 'TX', '76058', '32.4705', '-97.3557');
INSERT INTO `net_city` VALUES ('21515', '23', 'Этна', 'Etna', 'CA', '96027', '41.4158', '-123.0274');
INSERT INTO `net_city` VALUES ('21517', '23', 'Спайсер', 'Spicer', 'MN', '56288', '45.2384', '-94.9659');
INSERT INTO `net_city` VALUES ('21521', '23', 'Пейсон', 'Payson', 'UT', '84651', '40.0142', '-111.7389');
INSERT INTO `net_city` VALUES ('21525', '23', 'Лонг Ки', 'Long Key', 'FL', '33001', '24.8235', '-80.8110');
INSERT INTO `net_city` VALUES ('21526', '23', 'Эль-Дорадо', 'El Dorado', 'KS', '67042', '37.8467', '-96.8055');
INSERT INTO `net_city` VALUES ('21535', '23', 'Бридж-Сити', 'Bridge City', 'TX', '77611', '30.0160', '-93.8134');
INSERT INTO `net_city` VALUES ('21537', '123', 'Бухарест', 'Bucharest', '38', '', '44.4333', '26.1000');
INSERT INTO `net_city` VALUES ('21544', '23', 'Гавайиан Гарденс', 'Hawaiian Gardens', 'CA', '90716', '33.8307', '-118.0731');
INSERT INTO `net_city` VALUES ('21547', '203', 'Валли', 'The Valley', '00', '', '18.2167', '-63.0500');
INSERT INTO `net_city` VALUES ('21551', '23', 'Ганнисон', 'Gunnison', 'UT', '84634', '39.2291', '-111.7504');
INSERT INTO `net_city` VALUES ('21553', '14', 'Шарджа', 'Sharjah', '06', '', '25.3573', '55.4033');
INSERT INTO `net_city` VALUES ('21556', '23', 'Лидс', 'Lead', 'SD', '57754', '44.2859', '-103.8905');
INSERT INTO `net_city` VALUES ('21563', '23', 'Болсберг', 'Boalsburg', 'PA', '16827', '40.7748', '-77.7747');
INSERT INTO `net_city` VALUES ('21564', '187', 'Монтевидео', 'Montevideo', '10', '', '-34.8581', '-56.1708');
INSERT INTO `net_city` VALUES ('21568', '1', 'Тувумба ', 'Toowoomba', '04', '', '-27.5606', '151.9539');
INSERT INTO `net_city` VALUES ('21574', '24', 'Дандас', 'Dundas', 'ON', 'l9h5e1', '43.2698', '-79.9550');
INSERT INTO `net_city` VALUES ('21579', '23', 'Хенникер', 'Henniker', 'NH', '03242', '43.1710', '-71.8229');
INSERT INTO `net_city` VALUES ('21583', '23', 'Лаи', 'Laie', 'HI', '96762', '21.6266', '-157.9423');
INSERT INTO `net_city` VALUES ('21586', '23', 'Ортонвилл', 'Ortonville', 'MI', '48462', '42.8514', '-83.4376');
INSERT INTO `net_city` VALUES ('21592', '23', 'Порт Хаенем', 'Port Hueneme', 'CA', '93041', '34.1124', '-119.1107');
INSERT INTO `net_city` VALUES ('21594', '23', 'Леджвуд', 'Ledgewood', 'NJ', '07852', '40.8765', '-74.6505');
INSERT INTO `net_city` VALUES ('21595', '23', 'Олбертис', 'Alburtis', 'PA', '18011', '40.4543', '-75.6600');
INSERT INTO `net_city` VALUES ('21601', '23', 'Уэнделл', 'Wendell', 'NC', '27591', '35.7877', '-78.3905');
INSERT INTO `net_city` VALUES ('21602', '23', 'Бойдтон', 'Boydton', 'VA', '23917', '36.6648', '-78.3715');
INSERT INTO `net_city` VALUES ('21606', '23', 'Копперас Ков', 'Copperas Cove', 'TX', '76522', '31.2002', '-97.9921');
INSERT INTO `net_city` VALUES ('21608', '23', 'Макавао', 'Makawao', 'HI', '96768', '20.8451', '-156.3087');
INSERT INTO `net_city` VALUES ('21707', '21', 'Ист-Гринстед', 'East Grinstead', 'P6', '', '51.1167', '-0.0167');
INSERT INTO `net_city` VALUES ('21772', '24', 'Шелберн', 'Shelburne', 'ON', 'l0n1s4', '44.0810', '-80.2041');
INSERT INTO `net_city` VALUES ('21795', '24', 'Нью Глазго', 'New Glasgow (Nova Scotia)', 'NS', 'b2h3p9', '45.5833', '-62.6333');
INSERT INTO `net_city` VALUES ('21877', '23', 'Джошуа Три', 'Joshua Tree', 'CA', '92252', '34.1578', '-116.2732');
INSERT INTO `net_city` VALUES ('21890', '23', 'Тринидад', 'Trinidad', 'CO', '81082', '37.2242', '-104.3727');
INSERT INTO `net_city` VALUES ('21893', '23', 'Мариетта', 'Marietta', 'PA', '17547', '40.0773', '-76.5943');
INSERT INTO `net_city` VALUES ('21895', '23', 'Доррис', 'Dorris', 'CA', '96023', '41.8928', '-121.7445');
INSERT INTO `net_city` VALUES ('21901', '23', 'Зелвуд', 'Zellwood', 'FL', '32798', '28.7126', '-81.5834');
INSERT INTO `net_city` VALUES ('21905', '23', 'Уимаума', 'Wimauma', 'FL', '33598', '27.7146', '-82.2322');
INSERT INTO `net_city` VALUES ('21910', '25', 'Энсенада', 'Ensenada', '02', '', '31.8667', '-116.6167');
INSERT INTO `net_city` VALUES ('21911', '23', 'Бинген', 'Bingen', 'WA', '98605', '45.7755', '-121.6610');
INSERT INTO `net_city` VALUES ('21912', '23', 'Грандвью', 'Grandview', 'WA', '98930', '46.2642', '-119.9051');
INSERT INTO `net_city` VALUES ('21914', '23', 'Писмо Бич', 'Pismo Beach', 'CA', '93449', '35.1546', '-120.6595');
INSERT INTO `net_city` VALUES ('21916', '23', 'Атлантик', 'Atlantic', 'IA', '50022', '41.4110', '-95.0122');
INSERT INTO `net_city` VALUES ('21917', '23', 'Некуза', 'Nekoosa', 'WI', '54457', '44.2309', '-89.7862');
INSERT INTO `net_city` VALUES ('21931', '23', 'Бартелсо', 'Bartelso', 'IL', '62218', '38.5201', '-89.4797');
INSERT INTO `net_city` VALUES ('21941', '23', 'Роквейл', 'Rockvale', 'TN', '37153', '35.7581', '-86.5505');
INSERT INTO `net_city` VALUES ('21942', '23', 'Спотсвуд', 'Spotswood', 'NJ', '08884', '40.3940', '-74.3899');
INSERT INTO `net_city` VALUES ('21946', '23', 'Уиггинс', 'Wiggins', 'CO', '80654', '40.1438', '-104.0840');
INSERT INTO `net_city` VALUES ('21953', '23', 'Блэк Хок', 'Black Hawk', 'CO', '80422', '39.8257', '-105.5297');
INSERT INTO `net_city` VALUES ('21954', '23', 'Уолсенберг', 'Walsenburg', 'CO', '81089', '37.6432', '-104.6241');
INSERT INTO `net_city` VALUES ('21955', '23', 'Джулсберг', 'Julesburg', 'CO', '80737', '40.8756', '-102.2158');
INSERT INTO `net_city` VALUES ('21956', '23', 'Кано', 'Kaneohe', 'HI', '96744', '21.4539', '-157.8299');
INSERT INTO `net_city` VALUES ('21962', '23', 'Фелтон', 'Felton', 'CA', '95018', '37.0829', '-122.0533');
INSERT INTO `net_city` VALUES ('21966', '23', 'Пеббл Бич', 'Pebble Beach', 'CA', '93953', '36.5815', '-121.9464');
INSERT INTO `net_city` VALUES ('21967', '23', 'Истсаунд', 'Eastsound', 'WA', '98245', '48.6576', '-122.8119');
INSERT INTO `net_city` VALUES ('21970', '23', 'Давенпорт', 'Davenport', 'CA', '95017', '37.0949', '-122.2398');
INSERT INTO `net_city` VALUES ('21971', '23', 'Кармел', 'Carmel By the Sea', 'CA', '93921', '36.5552', '-121.9233');
INSERT INTO `net_city` VALUES ('21973', '118', 'Будапешт', 'Budapest', '05', '', '47.5000', '19.0833');
INSERT INTO `net_city` VALUES ('21974', '21', 'Суиндон', 'Swindon', 'N9', '', '51.5167', '-1.7833');
INSERT INTO `net_city` VALUES ('22047', '24', 'Уэйберн', 'Weyburn', 'SK', 's4h0h8', '49.6667', '-103.8500');
INSERT INTO `net_city` VALUES ('22058', '23', 'Фокс Лейк', 'Fox Lake', 'IL', '60020', '42.3959', '-88.1749');
INSERT INTO `net_city` VALUES ('22059', '23', 'Форрестон', 'Forreston', 'IL', '61030', '42.1098', '-89.5855');
INSERT INTO `net_city` VALUES ('22064', '23', 'Лонгвью', 'Longview', 'WA', '98632', '46.1933', '-123.0548');
INSERT INTO `net_city` VALUES ('22065', '23', 'Дженесео', 'Geneseo', 'IL', '61254', '41.4638', '-90.1512');
INSERT INTO `net_city` VALUES ('22069', '23', 'Халлок', 'Hallock', 'MN', '56728', '48.7681', '-96.9517');
INSERT INTO `net_city` VALUES ('22071', '24', 'Крестон', 'Creston', 'BC', 'v0b1g0', '49.1000', '-116.5167');
INSERT INTO `net_city` VALUES ('22083', '23', 'Ренвилл', 'Renville', 'MN', '56284', '44.7706', '-95.2087');
INSERT INTO `net_city` VALUES ('22084', '23', 'Ронан', 'Ronan', 'MT', '59864', '47.5325', '-114.1388');
INSERT INTO `net_city` VALUES ('22091', '24', 'Кап-Окс-Мёль', 'Cap-aux-Meules', 'QC', 'g4t1c2', '47.3833', '-61.8667');
INSERT INTO `net_city` VALUES ('22093', '23', 'Блафс', 'Bluffs', 'IL', '62621', '39.7210', '-90.5389');
INSERT INTO `net_city` VALUES ('22096', '23', 'Челан', 'Chelan', 'WA', '98816', '47.8988', '-119.9986');
INSERT INTO `net_city` VALUES ('22110', '24', 'Стейнбах', 'Steinbach', 'MB', 'r0a2a0', '49.5167', '-96.6833');
INSERT INTO `net_city` VALUES ('22148', '23', 'Элленвилл', 'Ellenville', 'NY', '12428', '41.7489', '-74.4467');
INSERT INTO `net_city` VALUES ('22168', '24', 'Тадуссак', 'Tadoussac', 'QC', 'g0t2a0', '48.1500', '-69.7167');
INSERT INTO `net_city` VALUES ('22338', '24', 'Риджтаун', 'Ridgetown', 'ON', 'n0p2c0', '42.4415', '-81.8834');
INSERT INTO `net_city` VALUES ('22349', '24', 'Чатсворт', 'Chatsworth', 'ON', 'n0h1g0', '44.4500', '-80.8833');
INSERT INTO `net_city` VALUES ('22392', '23', 'Кейп Винсент', 'Cape Vincent', 'NY', '13618', '44.1039', '-76.2641');
INSERT INTO `net_city` VALUES ('22394', '23', 'Рейнджели', 'Rangely', 'CO', '81648', '39.9363', '-108.6889');
INSERT INTO `net_city` VALUES ('22399', '23', 'Уитленд', 'Wheatland', 'WY', '82201', '41.9826', '-105.1153');
INSERT INTO `net_city` VALUES ('22474', '24', 'Атикокан', 'Atikokan', 'ON', '', '48.7500', '-91.6167');
INSERT INTO `net_city` VALUES ('22480', '24', 'Смитс Фолс', 'Smiths Falls', 'ON', 'k7a1m4', '44.9000', '-76.0167');
INSERT INTO `net_city` VALUES ('22481', '24', 'Су-Лукаут', 'Sioux Lookout', 'ON', '', '50.1000', '-91.9167');
INSERT INTO `net_city` VALUES ('22486', '24', 'Маратон', 'Marathon', 'ON', 'p0t2e0', '48.7500', '-86.3667');
INSERT INTO `net_city` VALUES ('22491', '176', 'Сент-Филип', 'Saint Philip', '10', '', '13.1333', '-59.4333');
INSERT INTO `net_city` VALUES ('22496', '23', 'Клифтон Хилл', 'Clifton Hill', 'MO', '65244', '39.4890', '-92.6791');
INSERT INTO `net_city` VALUES ('22499', '19', 'Эр-Рияд', 'Riyadh', '10', '', '24.6537', '46.7152');
INSERT INTO `net_city` VALUES ('22505', '19', 'Эль-Джубайль', 'Jubail', '06', '', '27.0112', '49.6583');
INSERT INTO `net_city` VALUES ('22510', '23', 'Дэймон', 'Damon', 'TX', '77430', '29.2709', '-95.6725');
INSERT INTO `net_city` VALUES ('22511', '5', 'Минато', 'Minato', '27', '', '34.6333', '129.3333');
INSERT INTO `net_city` VALUES ('22514', '137', 'Бейрут', 'Beirut', '04', '', '33.8719', '35.5097');
INSERT INTO `net_city` VALUES ('22518', '23', 'Уоллула', 'Wallula', 'WA', '99363', '46.0854', '-118.9053');
INSERT INTO `net_city` VALUES ('22519', '19', 'Джидда', 'Jeddah', '14', '', '21.5169', '39.2192');
INSERT INTO `net_city` VALUES ('22520', '122', 'Маскат', 'Muscat', '06', '', '23.6133', '58.5933');
INSERT INTO `net_city` VALUES ('22521', '23', 'Оклаваха', 'Ocklawaha', 'FL', '32179', '29.0928', '-81.9066');
INSERT INTO `net_city` VALUES ('22522', '14', 'Дубай', 'Dubai', '03', '', '25.2582', '55.3047');
INSERT INTO `net_city` VALUES ('22524', '19', 'Таиф', 'Taif', '14', '', '21.2703', '40.4158');
INSERT INTO `net_city` VALUES ('22528', '44', 'Манила', 'Manila', 'D9', '', '14.6042', '120.9822');
INSERT INTO `net_city` VALUES ('22536', '21', 'Брайтон и Хоув', 'Brighton', 'E2', '', '50.8333', '-0.1500');
INSERT INTO `net_city` VALUES ('22537', '9', 'Бангкок', 'Bangkok', '40', '', '13.7540', '100.5014');
INSERT INTO `net_city` VALUES ('22540', '12', 'Ломм', 'Lomme', 'B4', '', '50.6436', '2.9871');
INSERT INTO `net_city` VALUES ('22541', '23', 'Паттерсон', 'Patterson', 'NY', '12563', '41.4872', '-73.5902');
INSERT INTO `net_city` VALUES ('22543', '48', 'Гамильтон', 'Hamilton', '00', '', '-37.7833', '175.2833');
INSERT INTO `net_city` VALUES ('22544', '20', 'Владивосток', 'Vladivostok', '59', '', '43.1211', '131.9226');
INSERT INTO `net_city` VALUES ('22547', '21', 'Бат', 'Bath', 'A4', '', '51.3794', '-2.3656');
INSERT INTO `net_city` VALUES ('22548', '21', 'Шрусбери', 'Shrewsbury', 'L6', '', '52.7167', '-2.7333');
INSERT INTO `net_city` VALUES ('22549', '1', 'Перт', 'Perth', '08', '', '-31.9522', '115.8614');
INSERT INTO `net_city` VALUES ('22551', '23', 'Систер Бэй', 'Sister Bay', 'WI', '54234', '45.1895', '-87.1002');
INSERT INTO `net_city` VALUES ('22552', '33', 'Делфгау', 'Delfgauw', '11', '', '52.0131', '4.4100');
INSERT INTO `net_city` VALUES ('22554', '23', 'Саффорд', 'Safford', 'AZ', '85546', '32.7038', '-109.6558');
INSERT INTO `net_city` VALUES ('22557', '21', 'Абердин', 'Aberdeen', 'T5', '', '57.1333', '-2.1000');
INSERT INTO `net_city` VALUES ('22560', '21', 'Брентфорд', 'Brentford', '17', '', '51.5000', '-0.3167');
INSERT INTO `net_city` VALUES ('22561', '23', 'Маунт Шаста', 'Mount Shasta', 'CA', '96067', '41.3181', '-122.3202');
INSERT INTO `net_city` VALUES ('22565', '23', 'Меттер', 'Metter', 'GA', '30439', '32.4143', '-82.0904');
INSERT INTO `net_city` VALUES ('22568', '23', 'Уитакерс', 'Whitakers', 'NC', '27891', '36.0865', '-77.7412');
INSERT INTO `net_city` VALUES ('22571', '23', 'Таунсенд', 'Townsend', 'TN', '37882', '35.6235', '-83.7952');
INSERT INTO `net_city` VALUES ('22576', '23', 'Кокрантон', 'Cochranton', 'PA', '16314', '41.5130', '-80.0662');
INSERT INTO `net_city` VALUES ('22577', '23', 'Боскобел', 'Boscobel', 'WI', '53805', '43.1102', '-90.6741');
INSERT INTO `net_city` VALUES ('22581', '21', 'Кингстон Багпуайз', 'Kingston Bagpuize', 'K2', '', '51.6000', '-1.4167');
INSERT INTO `net_city` VALUES ('22587', '23', 'Мейплтон', 'Mapleton', 'IA', '51034', '42.1681', '-95.7688');
INSERT INTO `net_city` VALUES ('22589', '23', 'Айда Гров', 'Ida Grove', 'IA', '51445', '42.3340', '-95.4682');
INSERT INTO `net_city` VALUES ('22590', '23', 'Чартер Ок', 'Charter Oak', 'IA', '51439', '42.0904', '-95.5760');
INSERT INTO `net_city` VALUES ('22591', '23', 'Коррекшенвилл', 'Correctionville', 'IA', '51016', '42.4588', '-95.8223');
INSERT INTO `net_city` VALUES ('22593', '23', 'Онава', 'Onawa', 'IA', '51040', '42.0284', '-96.1303');
INSERT INTO `net_city` VALUES ('22595', '23', 'Виктор', 'Victor', 'IA', '52347', '41.7034', '-92.2943');
INSERT INTO `net_city` VALUES ('22597', '23', 'Латимер', 'Latimer', 'IA', '50452', '42.7918', '-93.3898');
INSERT INTO `net_city` VALUES ('22599', '23', 'Маквокета', 'Maquoketa', 'IA', '52060', '42.0986', '-90.6777');
INSERT INTO `net_city` VALUES ('22606', '23', 'Хазлхерст', 'Hazlehurst', 'MS', '39083', '31.8636', '-90.4224');
INSERT INTO `net_city` VALUES ('22612', '23', 'Рокуэй Парк', 'Rockaway Park', 'NY', '11694', '40.5749', '-73.8446');
INSERT INTO `net_city` VALUES ('22621', '23', 'Феннвилл', 'Fennville', 'MI', '49408', '42.5675', '-86.1116');
INSERT INTO `net_city` VALUES ('22624', '23', 'Саранак', 'Saranac', 'MI', '48881', '42.9084', '-85.2032');
INSERT INTO `net_city` VALUES ('22632', '23', 'Лейквью', 'Lakeview', 'MI', '48850', '43.4384', '-85.2574');
INSERT INTO `net_city` VALUES ('22633', '23', 'Эдмор', 'Edmore', 'MI', '48829', '43.4101', '-85.0297');
INSERT INTO `net_city` VALUES ('22642', '23', 'Элбридж', 'Elbridge', 'NY', '13060', '43.0313', '-76.4211');
INSERT INTO `net_city` VALUES ('22671', '24', 'Росспорт', 'Rossport', 'ON', 'p0t2r0', '48.8333', '-87.5167');
INSERT INTO `net_city` VALUES ('22687', '24', 'Эстерхази', 'Esterhazy', 'SK', 's0a0x0', '50.6500', '-102.0833');
INSERT INTO `net_city` VALUES ('22708', '160', 'Кито', 'Quito', '18', '', '-0.2167', '-78.5000');
INSERT INTO `net_city` VALUES ('22722', '24', 'Сет-Иль', 'Sept Iles', 'QC', 'g4r4m4', '50.2000', '-66.3833');
INSERT INTO `net_city` VALUES ('22725', '24', 'Николе', 'Nicolet', 'QC', 'j3t1s3', '46.2297', '-72.6135');
INSERT INTO `net_city` VALUES ('22760', '24', 'Кап-Ша', 'Cap-Chat', 'QC', 'g0j1e0', '49.0833', '-66.6833');
INSERT INTO `net_city` VALUES ('22768', '24', 'Бэ-Комо', 'Baie Comeau', 'QC', 'g5c2b2', '49.2167', '-68.1500');
INSERT INTO `net_city` VALUES ('22776', '24', 'Гран-Мер', 'Grand Mere', 'QC', 'g5y3g1', '46.6167', '-72.6667');
INSERT INTO `net_city` VALUES ('22805', '23', 'Ликенс', 'Lykens', 'PA', '17048', '40.6050', '-76.7048');
INSERT INTO `net_city` VALUES ('22808', '23', 'Уэлсборо', 'Wellsboro', 'PA', '16901', '41.7499', '-77.3334');
INSERT INTO `net_city` VALUES ('22813', '199', 'Парамарибо', 'Paramaribo', '16', '', '5.8333', '-55.1667');
INSERT INTO `net_city` VALUES ('22814', '25', 'Монтеррей', 'Monterrey', '19', '', '25.6667', '-100.3167');
INSERT INTO `net_city` VALUES ('22816', '23', 'Дакор', 'Ducor', 'CA', '93218', '35.8916', '-119.0473');
INSERT INTO `net_city` VALUES ('22822', '23', 'Мидлпорт', 'Middleport', 'NY', '14105', '43.1894', '-78.4871');
INSERT INTO `net_city` VALUES ('22825', '23', 'Барага', 'Baraga', 'MI', '49908', '46.8168', '-88.5703');
INSERT INTO `net_city` VALUES ('22826', '23', 'Каньонвилл', 'Canyonville', 'OR', '97417', '42.9447', '-123.2252');
INSERT INTO `net_city` VALUES ('22828', '23', 'Кловердейл', 'Cloverdale', 'IN', '46120', '39.5075', '-86.7657');
INSERT INTO `net_city` VALUES ('22831', '23', 'Брасстаун', 'Brasstown', 'NC', '28902', '35.0284', '-83.9520');
INSERT INTO `net_city` VALUES ('22833', '35', 'Валенсия', 'Valencia', '60', '', '39.4667', '-0.3667');
INSERT INTO `net_city` VALUES ('22834', '23', 'Элкин', 'Elkin', 'NC', '28621', '36.3177', '-80.7772');
INSERT INTO `net_city` VALUES ('22835', '23', 'Хектор', 'Hector', 'MN', '55342', '44.7534', '-94.7364');
INSERT INTO `net_city` VALUES ('22839', '56', 'Тилт', 'Tielt', '09', '', '51.0000', '3.3167');
INSERT INTO `net_city` VALUES ('22840', '23', 'Роринг Спринг', 'Roaring Spring', 'PA', '16673', '40.2981', '-78.3926');
INSERT INTO `net_city` VALUES ('22846', '23', 'Индиантаун', 'Indiantown', 'FL', '34956', '27.0972', '-80.5329');
INSERT INTO `net_city` VALUES ('22847', '23', 'Кльюистон', 'Clewiston', 'FL', '33440', '26.5378', '-81.0113');
INSERT INTO `net_city` VALUES ('22849', '23', 'Уошула', 'Wauchula', 'FL', '33873', '27.5063', '-81.7793');
INSERT INTO `net_city` VALUES ('22858', '23', 'Чаплин', 'Chaplin', 'CT', '06235', '41.7895', '-72.1283');
INSERT INTO `net_city` VALUES ('22859', '23', 'Уиллингтон', 'Willington', 'CT', '06279', '41.8967', '-72.2642');
INSERT INTO `net_city` VALUES ('22861', '23', 'Уоереган', 'Wauregan', 'CT', '06387', '41.7443', '-71.9092');
INSERT INTO `net_city` VALUES ('22862', '23', 'Волантаун', 'Voluntown', 'CT', '06384', '41.5758', '-71.8361');
INSERT INTO `net_city` VALUES ('22874', '21', 'Коулфорд', 'Coleford', 'E6', '', '51.8000', '-2.6000');
INSERT INTO `net_city` VALUES ('22875', '29', 'Линдау', 'Lindau', '02', '', '47.5500', '9.6833');
INSERT INTO `net_city` VALUES ('22878', '21', 'Мейденхед', 'Maidenhead', 'P9', '', '51.5167', '-0.7000');
INSERT INTO `net_city` VALUES ('22879', '21', 'Рикмансуорт', 'Rickmansworth', 'F8', '', '51.6333', '-0.4667');
INSERT INTO `net_city` VALUES ('22881', '15', 'Мьёльбю', 'Mjölby', '16', '', '58.3167', '15.1333');
INSERT INTO `net_city` VALUES ('22882', '12', 'Лилль', 'Lille', 'B4', '', '50.6330', '3.0586');
INSERT INTO `net_city` VALUES ('22883', '3', 'Сеул', 'Seoul', '11', '', '37.5985', '126.9783');
INSERT INTO `net_city` VALUES ('22884', '29', 'Гамбург', 'Hamburg', '04', '', '53.5500', '10.0000');
INSERT INTO `net_city` VALUES ('22887', '25', 'Колония', 'Colonia', '27', '', '17.8500', '-93.8667');
INSERT INTO `net_city` VALUES ('22889', '21', 'Саутгемптон', 'Southampton', 'M4', '', '50.9000', '-1.4000');
INSERT INTO `net_city` VALUES ('22892', '22', 'Хёе-Тоструп', 'Hoje-Taastrup', '05', '', '55.6500', '12.3167');
INSERT INTO `net_city` VALUES ('22893', '23', 'Марн', 'Marne', 'MI', '49435', '43.0271', '-85.8338');
INSERT INTO `net_city` VALUES ('22911', '21', 'Данди', 'Dundee', 'U3', '', '56.5000', '-2.9667');
INSERT INTO `net_city` VALUES ('22916', '23', 'Мокламн Хилл', 'Mokelumne Hill', 'CA', '95245', '38.2991', '-120.5842');
INSERT INTO `net_city` VALUES ('22926', '23', 'Вулвертон', 'Wolverton', 'MN', '56594', '46.5436', '-96.6605');
INSERT INTO `net_city` VALUES ('22927', '23', 'Мидл-Ривер', 'Middle River', 'MN', '56737', '48.4147', '-96.0291');
INSERT INTO `net_city` VALUES ('22929', '23', 'Шугар Сити', 'Sugar City', 'ID', '83448', '43.8512', '-111.6902');
INSERT INTO `net_city` VALUES ('22930', '23', 'Гринбуш', 'Greenbush', 'MN', '56726', '48.7330', '-96.1995');
INSERT INTO `net_city` VALUES ('22935', '23', 'Даймондхед', 'Diamondhead', 'MS', '39525', '30.3826', '-89.3730');
INSERT INTO `net_city` VALUES ('22939', '96', 'Конакри', 'Conakry', '04', '', '9.5092', '-13.7122');
INSERT INTO `net_city` VALUES ('22940', '23', 'Пало', 'Pala', 'CA', '92059', '33.3800', '-117.0714');
INSERT INTO `net_city` VALUES ('22943', '13', 'Катания', 'Catania', '15', '', '37.5000', '15.1000');
INSERT INTO `net_city` VALUES ('22945', '23', 'Шеперд', 'Shepherd', 'MT', '59079', '46.0571', '-108.3820');
INSERT INTO `net_city` VALUES ('22951', '54', 'Читтагонг', 'Chittagong', '85', '', '22.3636', '91.8033');
INSERT INTO `net_city` VALUES ('22960', '6', 'Хайдарабад', 'Hyderabad', '02', '', '17.3753', '78.4744');
INSERT INTO `net_city` VALUES ('22962', '6', 'Пуне', 'Pune', '16', '', '18.5333', '73.8667');
INSERT INTO `net_city` VALUES ('22963', '21', 'Лидс', 'Leeds', 'H3', '', '53.8000', '-1.5833');
INSERT INTO `net_city` VALUES ('22964', '23', 'Ганадо', 'Ganado', 'TX', '77962', '28.9861', '-96.4729');
INSERT INTO `net_city` VALUES ('22965', '23', 'Гэлакс', 'Galax', 'VA', '24333', '36.6694', '-80.9395');
INSERT INTO `net_city` VALUES ('22967', '23', 'Робесония', 'Robesonia', 'PA', '19551', '40.3578', '-76.1296');
INSERT INTO `net_city` VALUES ('22970', '23', 'Бродвей', 'Broadway', 'VA', '22815', '38.6469', '-78.8530');
INSERT INTO `net_city` VALUES ('22971', '6', 'Джайпур', 'Jaipur', '24', '', '26.9167', '75.8167');
INSERT INTO `net_city` VALUES ('22973', '23', 'Маннинг', 'Manning', 'SC', '29102', '33.6174', '-80.2107');
INSERT INTO `net_city` VALUES ('22974', '23', 'Торнтон', 'Thornton', 'PA', '19373', '39.9087', '-75.5361');
INSERT INTO `net_city` VALUES ('22975', '58', 'Сальто', 'Salto', '27', '', '-23.2000', '-47.2833');
INSERT INTO `net_city` VALUES ('22977', '46', 'Лахор', 'Lahore', '04', '', '31.5497', '74.3436');
INSERT INTO `net_city` VALUES ('22981', '24', 'Капасказинг', 'Kapuskasing', 'ON', 'p5n2y2', '49.4167', '-82.4333');
INSERT INTO `net_city` VALUES ('22983', '24', 'Сен-Жан-Сюр-Ришелье', 'Saint Jean Sur Richelieu', 'QC', 'j2x4j3', '45.3126', '-73.2351');
INSERT INTO `net_city` VALUES ('22990', '23', 'Рекс', 'Rex', 'NC', '28378', '34.8571', '-79.0492');
INSERT INTO `net_city` VALUES ('23007', '24', 'Порт Элберни', 'Port Alberni', 'BC', 'v9y3y4', '49.2333', '-124.8000');
INSERT INTO `net_city` VALUES ('23027', '21', 'Маркет Дрейтон', 'Market Drayton', 'L6', '', '52.9000', '-2.4667');
INSERT INTO `net_city` VALUES ('23033', '54', 'Дакка', 'Dhaka', '81', '', '23.7231', '90.4086');
INSERT INTO `net_city` VALUES ('23037', '1', 'Меррилендс', 'Merrylands', '02', '', '-33.8333', '150.9833');
INSERT INTO `net_city` VALUES ('23038', '23', 'Брюэртон', 'Brewerton', 'NY', '13029', '43.2108', '-76.1363');
INSERT INTO `net_city` VALUES ('23043', '117', 'Пафос', 'Paphos', '06', '', '34.7667', '32.4167');
INSERT INTO `net_city` VALUES ('23047', '45', 'Тимур', 'Timur', '16', '', '-8.1833', '131.0833');
INSERT INTO `net_city` VALUES ('23054', '23', 'Маундсвилл', 'Moundsville', 'WV', '26041', '39.8904', '-80.7021');
INSERT INTO `net_city` VALUES ('23059', '23', 'Клиффсайд-Парк', 'Cliffside Park', 'NJ', '07010', '40.8203', '-73.9871');
INSERT INTO `net_city` VALUES ('23060', '23', 'Харливилл', 'Harleyville', 'SC', '29448', '33.2424', '-80.4388');
INSERT INTO `net_city` VALUES ('23067', '23', 'Ронкс', 'Ronks', 'PA', '17572', '40.0079', '-76.1411');
INSERT INTO `net_city` VALUES ('23080', '23', 'Конклин', 'Conklin', 'MI', '49403', '43.1300', '-85.8481');
INSERT INTO `net_city` VALUES ('23082', '23', 'Вердженес', 'Vergennes', 'VT', '05491', '44.1209', '-73.3354');
INSERT INTO `net_city` VALUES ('23090', '23', 'Толенд', 'Tolland', 'CT', '06084', '41.8833', '-72.3611');
INSERT INTO `net_city` VALUES ('23101', '24', 'Эшкрофт', 'Ashcroft', 'BC', 'v0k1a0', '50.7167', '-121.2667');
INSERT INTO `net_city` VALUES ('23116', '24', 'Саммерленд', 'Summerland', 'BC', 'v0h1z0', '49.6000', '-119.6667');
INSERT INTO `net_city` VALUES ('23164', '23', 'Роулетт', 'Rowlett', 'TX', '75088', '32.8916', '-96.5684');
INSERT INTO `net_city` VALUES ('23167', '23', 'Уэст', 'West', 'TX', '76691', '31.7828', '-97.1016');
INSERT INTO `net_city` VALUES ('23170', '23', 'Сидар Крест', 'Cedar Crest', 'NM', '87008', '35.1483', '-106.3906');
INSERT INTO `net_city` VALUES ('23171', '23', 'Бьюкенен', 'Buchanan', 'VA', '24066', '37.5183', '-79.6681');
INSERT INTO `net_city` VALUES ('23187', '24', 'Монтбело', 'Montebello', 'QC', 'l0v1l0', '45.6558', '-74.9425');
INSERT INTO `net_city` VALUES ('23206', '23', 'Ист Уэнатчи', 'East Wenatchee', 'WA', '98802', '47.4940', '-120.1955');
INSERT INTO `net_city` VALUES ('23229', '24', 'Кокран', 'Cochrane (Ontario)', 'ON', 'p0l1c0', '49.0667', '-81.0167');
INSERT INTO `net_city` VALUES ('23270', '24', 'Нипигон', 'Nipigon', 'ON', 'p0t2j0', '49.0167', '-88.2500');
INSERT INTO `net_city` VALUES ('23271', '23', 'Провиденс', 'Providence', 'UT', '84332', '41.6929', '-111.8147');
INSERT INTO `net_city` VALUES ('23277', '23', 'Норт Бранч', 'North Branch', 'MN', '55056', '45.4967', '-92.9365');
INSERT INTO `net_city` VALUES ('23284', '23', 'Аманда', 'Amanda', 'OH', '43102', '39.6436', '-82.7613');
INSERT INTO `net_city` VALUES ('23292', '23', 'Уолкер', 'Walker', 'MN', '56484', '47.1149', '-94.4856');
INSERT INTO `net_city` VALUES ('23294', '23', 'Пейнесвилл', 'Paynesville', 'MN', '56362', '45.3981', '-94.7010');
INSERT INTO `net_city` VALUES ('23305', '23', 'Россфорд', 'Rossford', 'OH', '43460', '41.6018', '-83.5604');
INSERT INTO `net_city` VALUES ('23315', '23', 'Уайт-Ривер', 'White River', 'SD', '57579', '43.6203', '-100.7244');
INSERT INTO `net_city` VALUES ('23320', '23', 'Эносберг Фолс', 'Enosburg Falls', 'VT', '05450', '44.8981', '-72.7933');
INSERT INTO `net_city` VALUES ('23321', '23', 'Богарт', 'Bogart', 'GA', '30622', '33.9094', '-83.5154');
INSERT INTO `net_city` VALUES ('23323', '36', 'Нассау', 'Nassau', '23', '', '25.0833', '-77.3500');
INSERT INTO `net_city` VALUES ('23328', '23', 'Спринг Парк', 'Spring Park', 'MN', '55384', '44.9373', '-93.6221');
INSERT INTO `net_city` VALUES ('23330', '23', 'Онеймия', 'Onamia', 'MN', '56359', '46.0614', '-93.6734');
INSERT INTO `net_city` VALUES ('23332', '23', 'Верндейл', 'Verndale', 'MN', '56481', '46.4414', '-94.9678');
INSERT INTO `net_city` VALUES ('23339', '23', 'Эмили', 'Emily', 'MN', '56447', '46.7311', '-93.9055');
INSERT INTO `net_city` VALUES ('23348', '23', 'Джонс Милс', 'Jones Mills', 'PA', '15646', '40.0910', '-79.3120');
INSERT INTO `net_city` VALUES ('23354', '23', 'Валли Парк', 'Valley Park', 'MO', '63088', '38.5577', '-90.4986');
INSERT INTO `net_city` VALUES ('23355', '23', 'Саммерсвилл', 'Summersville', 'WV', '26651', '38.3330', '-80.8881');
INSERT INTO `net_city` VALUES ('23357', '23', 'Монтевидео', 'Montevideo', 'MN', '56265', '45.0062', '-95.7366');
INSERT INTO `net_city` VALUES ('23363', '23', 'Бакингем', 'Buckingham', 'VA', '23921', '37.6010', '-78.6127');
INSERT INTO `net_city` VALUES ('23369', '23', 'Уэйзер', 'Weiser', 'ID', '83672', '44.4729', '-116.9169');
INSERT INTO `net_city` VALUES ('23497', '23', 'Россберг', 'Rossburg', 'OH', '45362', '40.2885', '-84.6370');
INSERT INTO `net_city` VALUES ('23499', '23', 'Холтс Саммит', 'Holts Summit', 'MO', '65043', '38.6296', '-92.1027');
INSERT INTO `net_city` VALUES ('23500', '23', 'Нью Парис', 'New Paris', 'IN', '46553', '41.4787', '-85.8474');
INSERT INTO `net_city` VALUES ('23502', '23', 'Дилсборо', 'Dillsboro', 'IN', '47018', '38.9879', '-85.0682');
INSERT INTO `net_city` VALUES ('23520', '23', 'Олеан', 'Olean', 'NY', '14760', '42.1033', '-78.4042');
INSERT INTO `net_city` VALUES ('23537', '23', 'Марреро', 'Marrero', 'LA', '70072', '29.8256', '-90.1211');
INSERT INTO `net_city` VALUES ('23541', '20', 'Москва', 'Moscow', '48', '', '55.7522', '37.6156');
INSERT INTO `net_city` VALUES ('23543', '21', 'Телфорд', 'Telford', 'O2', '', '52.6333', '-2.5000');
INSERT INTO `net_city` VALUES ('23562', '35', 'Марбелья', 'Marbella', '51', '', '36.5105', '-4.8857');
INSERT INTO `net_city` VALUES ('23563', '23', 'Шипио', 'Scipio', 'IN', '47273', '39.0720', '-85.7292');
INSERT INTO `net_city` VALUES ('23564', '23', 'Крокетт', 'Crockett', 'TX', '75835', '31.2836', '-95.4827');
INSERT INTO `net_city` VALUES ('23568', '23', 'Тикондерога', 'Ticonderoga', 'NY', '12883', '43.8549', '-73.5090');
INSERT INTO `net_city` VALUES ('23570', '23', 'Лайнвилл', 'Lineville', 'AL', '36266', '33.3400', '-85.7631');
INSERT INTO `net_city` VALUES ('23573', '23', 'Де-Мойн', 'Des Moines', 'NM', '88418', '36.7361', '-103.5926');
INSERT INTO `net_city` VALUES ('23575', '23', 'Магнолия', 'Magnolia', 'MS', '39652', '31.1054', '-90.4671');
INSERT INTO `net_city` VALUES ('23582', '23', 'Хартсел', 'Hartselle', 'AL', '35640', '34.4436', '-86.9369');
INSERT INTO `net_city` VALUES ('23583', '23', 'Тони', 'Toney', 'AL', '35773', '34.8976', '-86.7154');
INSERT INTO `net_city` VALUES ('23587', '139', 'Тампере ', 'Tampere', '15', '', '61.5000', '23.7500');
INSERT INTO `net_city` VALUES ('23588', '23', 'Вайнмонт', 'Vinemont', 'AL', '35179', '34.2742', '-86.9456');
INSERT INTO `net_city` VALUES ('23593', '24', 'Бакингем', 'Buckingham', 'QC', 'j8l2w2', '45.5889', '-75.4164');
INSERT INTO `net_city` VALUES ('23627', '59', 'Штайнхаузен', 'Steinhausen', '24', '', '47.1951', '8.4858');
INSERT INTO `net_city` VALUES ('23629', '163', 'Сан Франсиско', 'San Francisco', '22', '', '1.1787', '-76.8785');
INSERT INTO `net_city` VALUES ('23630', '29', 'Фрайзинг ', 'Freising', '02', '', '48.4000', '11.7333');
INSERT INTO `net_city` VALUES ('23632', '23', 'Кинсберг', 'Keenesburg', 'CO', '80643', '40.1313', '-104.4499');
INSERT INTO `net_city` VALUES ('23634', '34', 'Нетания', 'Netanya', '02', '', '32.3329', '34.8599');
INSERT INTO `net_city` VALUES ('23638', '190', 'Доха', 'Doha', '01', '', '25.2867', '51.5333');
INSERT INTO `net_city` VALUES ('23640', '23', 'Чикаго Парк', 'Chicago Park', 'CA', '95712', '39.1623', '-120.9567');
INSERT INTO `net_city` VALUES ('23651', '23', 'Орик', 'Orick', 'CA', '95555', '41.3590', '-124.0483');
INSERT INTO `net_city` VALUES ('23654', '23', 'Клементс', 'Clements', 'CA', '95227', '38.1908', '-121.0883');
INSERT INTO `net_city` VALUES ('23656', '23', 'Мерфис', 'Murphys', 'CA', '95247', '38.1498', '-120.4546');
INSERT INTO `net_city` VALUES ('23658', '24', 'Салаберри-де-Валлифилд', 'Salaberry-de-Valleyfield', 'QC', 'j6t6l4', '45.2666', '-74.1372');
INSERT INTO `net_city` VALUES ('23660', '23', 'Ок Вью', 'Oak View', 'CA', '93022', '34.4022', '-119.3031');
INSERT INTO `net_city` VALUES ('23665', '1', 'Бонди', 'Bondi', '02', '', '-33.8917', '151.2667');
INSERT INTO `net_city` VALUES ('23714', '24', 'Кардинал', 'Cardinal', 'ON', 'k0e1e0', '44.7930', '-75.3794');
INSERT INTO `net_city` VALUES ('23722', '24', 'Мэттава', 'Mattawa', 'ON', 'p0h1v0', '46.3167', '-78.7000');
INSERT INTO `net_city` VALUES ('23730', '24', 'Халибертон', 'Haliburton', 'ON', 'k0m1s0', '45.0333', '-78.5167');
INSERT INTO `net_city` VALUES ('23742', '23', 'Шофилд', 'Schofield', 'WI', '54476', '44.8876', '-89.5200');
INSERT INTO `net_city` VALUES ('23746', '23', 'Митчелл', 'Mitchell', 'SD', '57301', '43.7183', '-98.0262');
INSERT INTO `net_city` VALUES ('23750', '24', 'Кортрайт', 'Courtright', 'ON', 'n0n1h0', '42.8167', '-82.4667');
INSERT INTO `net_city` VALUES ('23754', '23', 'Ван Верт', 'Van Wert', 'OH', '45891', '40.8769', '-84.5869');
INSERT INTO `net_city` VALUES ('23766', '12', 'Палезо', 'Palaiseau', 'A8', '', '48.7167', '2.2491');
INSERT INTO `net_city` VALUES ('23767', '12', 'Бордо', 'Bordeaux', '97', '', '44.8404', '-0.5805');
INSERT INTO `net_city` VALUES ('23769', '5', 'Нака', 'Naka', '14', '', '36.0500', '140.1667');
INSERT INTO `net_city` VALUES ('23770', '21', 'Абингдон ', 'Abingdon', 'K2', '', '51.6667', '-1.2833');
INSERT INTO `net_city` VALUES ('23771', '33', 'Амерсфорт', 'Amersfoort', '09', '', '52.1560', '5.3895');
INSERT INTO `net_city` VALUES ('23773', '56', 'Херенталс', 'Herentals', '01', '', '51.1833', '4.8333');
INSERT INTO `net_city` VALUES ('23775', '59', 'Цолликофен', 'Zollikofen', '05', '', '46.9957', '7.4590');
INSERT INTO `net_city` VALUES ('23776', '21', 'Ранкорн', 'Runcorn', 'C5', '', '53.3333', '-2.7500');
INSERT INTO `net_city` VALUES ('23777', '56', 'Веттерен', 'Wetteren', '08', '', '51.0000', '3.8833');
INSERT INTO `net_city` VALUES ('23778', '12', 'Малакофф', 'Malakoff', 'A8', '', '48.8200', '2.3000');
INSERT INTO `net_city` VALUES ('23786', '21', 'Бирмингем', 'Birmingham', 'A7', '', '52.4667', '-1.9167');
INSERT INTO `net_city` VALUES ('23787', '58', 'Порту-Алегри', 'Porto Alegre', '23', '', '-30.0333', '-51.2000');
INSERT INTO `net_city` VALUES ('23789', '21', 'Берфорд', 'Burford', 'K2', '', '51.8000', '-1.6333');
INSERT INTO `net_city` VALUES ('23790', '127', 'Нидервальдкирхен ', 'Niederwaldkirchen', '04', '', '48.4500', '14.0833');
INSERT INTO `net_city` VALUES ('23791', '15', 'Соллентуна', 'Sollentuna', '26', '', '59.4667', '17.9000');
INSERT INTO `net_city` VALUES ('23793', '58', 'Белу-Оризонти', 'Belo Horizonte', '15', '', '-19.9167', '-43.9333');
INSERT INTO `net_city` VALUES ('23796', '4', 'Чанша', 'Changshu', '03', '', '28.0833', '115.5167');
INSERT INTO `net_city` VALUES ('23797', '2', 'Куала-Лумпур', 'Kuala Lumpur', '14', '', '3.1667', '101.7000');
INSERT INTO `net_city` VALUES ('23800', '45', 'Матарам', 'Mataram', '17', '', '-8.5833', '116.1167');
INSERT INTO `net_city` VALUES ('23801', '2', 'Шах-Алам', 'Shah Alam', '12', '', '3.0833', '101.5333');
INSERT INTO `net_city` VALUES ('23802', '22', 'Брённбю', 'Brondby', '06', '', '55.6833', '12.5000');
INSERT INTO `net_city` VALUES ('23804', '29', 'Бюрштадт ', 'Burstadt', '05', '', '49.6436', '8.4600');
INSERT INTO `net_city` VALUES ('23805', '13', 'Комо', 'Como', '09', '', '45.7833', '9.0833');
INSERT INTO `net_city` VALUES ('23807', '35', 'Кастельбисбаль', 'Castellbisbal', '56', '', '41.4748', '1.9799');
INSERT INTO `net_city` VALUES ('23808', '29', 'Билефельд', 'Bielefeld', '07', '', '52.0333', '8.5333');
INSERT INTO `net_city` VALUES ('23809', '56', 'Дихем', 'Diegem', '02', '', '50.9000', '4.4333');
INSERT INTO `net_city` VALUES ('23811', '33', 'Весп', 'Weesp', '07', '', '52.3077', '5.0397');
INSERT INTO `net_city` VALUES ('23812', '12', 'Вильнёв д&#39;Аск', 'Villeneuve d\'Ascq', 'B4', '', '50.6710', '3.2292');
INSERT INTO `net_city` VALUES ('23813', '59', 'Шлирен ', 'Schlieren', '25', '', '47.3965', '8.4486');
INSERT INTO `net_city` VALUES ('23814', '21', 'Ньюбери', 'Newbury', 'P4', '', '51.4000', '-1.3167');
INSERT INTO `net_city` VALUES ('23816', '21', 'Реддич', 'Redditch', 'Q4', '', '52.3000', '-1.9333');
INSERT INTO `net_city` VALUES ('23817', '13', 'Сесто-Сан-Джованни', 'Sesto San Giovanni', '09', '', '45.5333', '9.2333');
INSERT INTO `net_city` VALUES ('23856', '23', 'Уэстби', 'Westby', 'WI', '54667', '43.6628', '-90.8505');
INSERT INTO `net_city` VALUES ('23857', '23', 'Джонсон Крик', 'Johnson Creek', 'WI', '53038', '43.0658', '-88.7536');
INSERT INTO `net_city` VALUES ('23867', '21', 'Бишопс-Стортфорд', 'Bishop\'s Stortford', 'N7', '', '51.8667', '0.1667');
INSERT INTO `net_city` VALUES ('24006', '23', 'Олт', 'Ault', 'CO', '80610', '40.7114', '-104.5626');
INSERT INTO `net_city` VALUES ('24013', '23', 'Скхари', 'Schoharie', 'NY', '12157', '42.6574', '-74.2928');
INSERT INTO `net_city` VALUES ('24017', '23', 'Лоренс', 'Laurens', 'IA', '50554', '42.8434', '-94.8360');
INSERT INTO `net_city` VALUES ('24025', '25', 'Керетаро', 'Queretaro', '22', '', '20.6000', '-100.3833');
INSERT INTO `net_city` VALUES ('24030', '23', 'Альфред', 'Alfred', 'ME', '04002', '43.4958', '-70.6841');
INSERT INTO `net_city` VALUES ('24031', '23', 'Твин Лейкс', 'Twin Lakes', 'WI', '53181', '42.5220', '-88.2426');
INSERT INTO `net_city` VALUES ('24038', '23', 'Шипрок', 'Shiprock', 'NM', '87420', '36.7632', '-108.8181');
INSERT INTO `net_city` VALUES ('24041', '23', 'Кимс Каньон', 'Keams Canyon', 'AZ', '86034', '35.7642', '-110.2523');
INSERT INTO `net_city` VALUES ('24042', '23', 'Апач Джанкшен', 'Apache Junction', 'AZ', '85217', '33.4151', '-111.5496');
INSERT INTO `net_city` VALUES ('24044', '23', 'Майер', 'Mayer', 'AZ', '86333', '34.3417', '-112.0367');
INSERT INTO `net_city` VALUES ('24045', '23', 'Глоуб', 'Globe', 'AZ', '85501', '33.6295', '-110.7071');
INSERT INTO `net_city` VALUES ('24048', '23', 'Сейнт Франсисвилл', 'Saint Francisville', 'LA', '70775', '30.8281', '-91.4486');
INSERT INTO `net_city` VALUES ('24051', '23', 'Богальюза', 'Bogalusa', 'LA', '70427', '30.7554', '-89.9131');
INSERT INTO `net_city` VALUES ('24054', '23', 'Минден', 'Minden', 'LA', '71055', '32.7081', '-93.2779');
INSERT INTO `net_city` VALUES ('24056', '23', 'Арчбалд', 'Archbald', 'PA', '18403', '41.4979', '-75.5476');
INSERT INTO `net_city` VALUES ('24060', '23', 'Улисзес', 'Ulysses', 'KS', '67880', '37.6528', '-101.3160');
INSERT INTO `net_city` VALUES ('24061', '24', 'Нипавин', 'Nipawin', 'SK', 's0e1e0', '53.3667', '-104.0167');
INSERT INTO `net_city` VALUES ('24063', '23', 'Салмон', 'Salmon', 'ID', '83467', '45.0052', '-113.8658');
INSERT INTO `net_city` VALUES ('24065', '23', 'Белен', 'Belen', 'NM', '87002', '34.5967', '-106.6720');
INSERT INTO `net_city` VALUES ('24066', '23', 'Мус-Лейк', 'Moose Lake', 'MN', '55767', '46.4401', '-92.7551');
INSERT INTO `net_city` VALUES ('24075', '23', 'Вермилен', 'Vermilion', 'OH', '44089', '41.3882', '-82.3754');
INSERT INTO `net_city` VALUES ('24084', '23', 'Платтсмут', 'Plattsmouth', 'NE', '68048', '40.9682', '-95.9400');
INSERT INTO `net_city` VALUES ('24086', '23', 'Фэрбери', 'Fairbury', 'NE', '68352', '40.1610', '-97.1899');
INSERT INTO `net_city` VALUES ('24090', '25', 'Мерида', 'Merida', '31', '', '20.9667', '-89.6167');
INSERT INTO `net_city` VALUES ('24119', '23', 'Уэтерли', 'Weatherly', 'PA', '18255', '40.9354', '-75.8406');
INSERT INTO `net_city` VALUES ('24130', '23', 'Ист Эрл', 'East Earl', 'PA', '17519', '40.1385', '-76.0241');
INSERT INTO `net_city` VALUES ('24135', '23', 'Крейгвилл', 'Craigville', 'IN', '46731', '40.8010', '-85.1042');
INSERT INTO `net_city` VALUES ('24137', '23', 'Овандо', 'Ovando', 'MT', '59854', '47.0776', '-113.0495');
INSERT INTO `net_city` VALUES ('24141', '23', 'Стивенвилл', 'Stephenville', 'TX', '76401', '32.2888', '-98.1948');
INSERT INTO `net_city` VALUES ('24143', '23', 'Бегс', 'Beggs', 'OK', '74421', '35.7530', '-96.0422');
INSERT INTO `net_city` VALUES ('24148', '23', 'Бродалбин', 'Broadalbin', 'NY', '12025', '43.0938', '-74.1159');
INSERT INTO `net_city` VALUES ('24150', '23', 'Помфрет ', 'Pomfret', 'CT', '06258', '41.8976', '-71.9626');
INSERT INTO `net_city` VALUES ('24151', '23', 'Эллингтон', 'Ellington', 'CT', '06029', '41.9072', '-72.4728');
INSERT INTO `net_city` VALUES ('24159', '23', 'Роу', 'Rowe', 'MA', '01367', '42.6862', '-72.9249');
INSERT INTO `net_city` VALUES ('24173', '23', 'Стаатсберг', 'Staatsburg', 'NY', '12580', '41.8551', '-73.8652');
INSERT INTO `net_city` VALUES ('24186', '23', 'Дэниелсвилл', 'Danielsville', 'PA', '18038', '40.7957', '-75.4826');
INSERT INTO `net_city` VALUES ('24191', '23', 'Делавэр Уотер Гэп', 'Delaware Water Gap', 'PA', '18327', '40.9736', '-75.1383');
INSERT INTO `net_city` VALUES ('24204', '23', 'Нассавадокс', 'Nassawadox', 'VA', '23413', '37.4482', '-75.8207');
INSERT INTO `net_city` VALUES ('24230', '23', 'Ченоа', 'Chenoa', 'IL', '61726', '40.7355', '-88.6986');
INSERT INTO `net_city` VALUES ('24245', '23', 'Харвич Порт', 'Harwich Port', 'MA', '02646', '41.6713', '-70.0688');
INSERT INTO `net_city` VALUES ('24255', '23', 'Кардифф-бай-Си', 'Cardiff by the Sea', 'CA', '92007', '33.0179', '-117.2767');
INSERT INTO `net_city` VALUES ('24265', '23', 'Эль Портал', 'El Portal', 'CA', '95318', '37.6594', '-119.8079');
INSERT INTO `net_city` VALUES ('24271', '23', 'Саблетт', 'Sublette', 'KS', '67877', '37.5332', '-100.8348');
INSERT INTO `net_city` VALUES ('24272', '23', 'Лейкин', 'Lakin', 'KS', '67860', '38.0002', '-101.3158');
INSERT INTO `net_city` VALUES ('24277', '23', 'Кенеди', 'Kenedy', 'TX', '78119', '28.7427', '-97.8807');
INSERT INTO `net_city` VALUES ('24279', '23', 'Кушинг', 'Cushing', 'TX', '75760', '31.7988', '-94.8617');
INSERT INTO `net_city` VALUES ('24281', '23', 'Бридпорт', 'Bridport', 'VT', '05734', '43.9801', '-73.3296');
INSERT INTO `net_city` VALUES ('24293', '23', 'Бересфорд', 'Beresford', 'SD', '57004', '43.0693', '-96.7959');
INSERT INTO `net_city` VALUES ('24296', '23', 'Крествуд', 'Crestwood', 'KY', '40014', '38.3439', '-85.4299');
INSERT INTO `net_city` VALUES ('24298', '2', 'Пенанг', 'Penang', '09', '', '5.4112', '100.3354');
INSERT INTO `net_city` VALUES ('24299', '23', 'Гранд-Айл', 'Grand Isle', 'LA', '70358', '29.2331', '-89.9962');
INSERT INTO `net_city` VALUES ('24301', '23', 'Миллер Плейс', 'Miller Place', 'NY', '11764', '40.9357', '-72.9809');
INSERT INTO `net_city` VALUES ('24303', '25', 'Веракрус', 'Veracruz', '30', '', '19.2000', '-96.1333');
INSERT INTO `net_city` VALUES ('24308', '23', 'Спанауэй', 'Spanaway', 'WA', '98387', '47.0597', '-122.3623');
INSERT INTO `net_city` VALUES ('24310', '21', 'Честерфилд', 'Chesterfield', 'D3', '', '53.2500', '-1.4167');
INSERT INTO `net_city` VALUES ('24311', '44', 'Калукан', 'Caloocan City', '53', '', '14.5836', '121.0336');
INSERT INTO `net_city` VALUES ('24317', '23', 'Виллиска', 'Villisca', 'IA', '50864', '40.9990', '-94.9774');
INSERT INTO `net_city` VALUES ('24320', '23', 'Элма', 'Elma', 'NY', '14059', '42.8306', '-78.6262');
INSERT INTO `net_city` VALUES ('24326', '23', 'Стерджис', 'Sturgis', 'SD', '57785', '44.4192', '-103.2643');
INSERT INTO `net_city` VALUES ('24328', '4', 'Пекин', 'Beijing', '22', '', '39.9289', '116.3883');
INSERT INTO `net_city` VALUES ('24333', '23', 'Мартел', 'Martelle', 'IA', '52305', '42.0236', '-91.3436');
INSERT INTO `net_city` VALUES ('24334', '23', 'Хаксли', 'Huxley', 'IA', '50124', '41.8854', '-93.6055');
INSERT INTO `net_city` VALUES ('24335', '23', 'Оливия', 'Olivia', 'MN', '56277', '44.7606', '-94.9860');
INSERT INTO `net_city` VALUES ('24336', '24', 'Киркленд Лейк', 'Kirkland Lake', 'ON', 'p2n3p4', '48.1500', '-80.0333');
INSERT INTO `net_city` VALUES ('24346', '24', 'Саутгемптон', 'Southampton', 'ON', 'n0h2l0', '44.5000', '-81.3667');
INSERT INTO `net_city` VALUES ('24360', '24', 'Мерриквилл', 'Merrickville', 'ON', 'k0g1n0', '44.9167', '-75.8333');
INSERT INTO `net_city` VALUES ('24380', '23', 'Абрамс', 'Abrams', 'WI', '54101', '44.7995', '-88.0729');
INSERT INTO `net_city` VALUES ('24381', '23', 'Ниагара', 'Niagara', 'WI', '54151', '45.7258', '-87.9926');
INSERT INTO `net_city` VALUES ('24382', '23', 'Виттенберг', 'Wittenberg', 'WI', '54499', '44.7901', '-89.1670');
INSERT INTO `net_city` VALUES ('24401', '23', 'Манава', 'Manawa', 'WI', '54949', '44.4891', '-88.8868');
INSERT INTO `net_city` VALUES ('24402', '23', 'Оконто Фолс', 'Oconto Falls', 'WI', '54154', '44.8640', '-88.1890');
INSERT INTO `net_city` VALUES ('24413', '23', 'Рамфорд', 'Rumford', 'RI', '02916', '41.8442', '-71.3532');
INSERT INTO `net_city` VALUES ('24424', '24', 'Джимли', 'Gimli', 'MB', 'r0c1b0', '50.6333', '-97.0000');
INSERT INTO `net_city` VALUES ('24429', '24', 'Стони Маунтин', 'Stony Mountain', 'MB', 'r0c3a0', '50.0667', '-97.2167');
INSERT INTO `net_city` VALUES ('24460', '119', 'Братислава', 'Bratislava', '02', '', '48.1500', '17.1167');
INSERT INTO `net_city` VALUES ('24472', '24', 'Гримсби', 'Grimsby', 'ON', 'l3m1r6', '43.1964', '-79.5624');
INSERT INTO `net_city` VALUES ('24514', '24', 'Сент-Мари', 'Sainte-marie', 'QC', 'g6e1b2', '46.4417', '-71.0188');
INSERT INTO `net_city` VALUES ('24565', '24', 'Уолкертон', 'Walkerton', 'ON', 'n0g2v0', '44.1333', '-81.1500');
INSERT INTO `net_city` VALUES ('24575', '24', 'Клермон', 'Clermont', 'QC', 'g4a1b8', '47.6962', '-70.2275');
INSERT INTO `net_city` VALUES ('24599', '24', 'Хазелтон', 'Hazelton', 'BC', 'v0j1y0', '55.2500', '-127.6667');
INSERT INTO `net_city` VALUES ('24609', '24', 'Мон-Сент-Илер', 'Mont-saint-hilaire', 'QC', 'j3h6c4', '45.5333', '-73.1667');
INSERT INTO `net_city` VALUES ('24659', '24', 'Гибсонс', 'Gibsons', 'BC', 'v0n1v7', '49.4000', '-123.5000');
INSERT INTO `net_city` VALUES ('24695', '24', 'Хейвлок', 'Havelock', 'ON', 'k0l1z0', '44.4333', '-77.8833');
INSERT INTO `net_city` VALUES ('24719', '24', 'Пиктон', 'Picton', 'ON', 'k0k2t0', '44.0065', '-77.1464');
INSERT INTO `net_city` VALUES ('24726', '23', 'Мидлбрук', 'Middlebrook', 'VA', '24459', '38.0424', '-79.2803');
INSERT INTO `net_city` VALUES ('24728', '24', 'Коттам', 'Cottam', 'ON', 'n0r1b0', '42.1333', '-82.7500');
INSERT INTO `net_city` VALUES ('24730', '24', 'Ташеро', 'Taschereau', 'QC', '', '48.6667', '-78.7000');
INSERT INTO `net_city` VALUES ('24741', '24', 'Пефферло', 'Pefferlaw', 'ON', 'l0e1n0', '44.3167', '-79.2000');
INSERT INTO `net_city` VALUES ('24756', '34', 'Беэр Яаков ', 'Be\'er Ya\'akov', '02', '', '31.9061', '34.8731');
INSERT INTO `net_city` VALUES ('24758', '58', 'Ресифи', 'Recife', '30', '', '-8.0500', '-34.9000');
INSERT INTO `net_city` VALUES ('24766', '109', 'Стамбул', 'Istanbul', '34', '', '41.0186', '28.9647');
INSERT INTO `net_city` VALUES ('24768', '29', 'Дортмунд', 'Dortmund', '07', '', '51.5167', '7.4500');
INSERT INTO `net_city` VALUES ('24769', '131', 'Сенгкуронг', 'Sengkurong', '00', '', '4.8833', '114.8333');
INSERT INTO `net_city` VALUES ('24776', '30', 'Тегеран', 'Tehran', '26', '', '35.7261', '51.3304');
INSERT INTO `net_city` VALUES ('24777', '46', 'Исламабад', 'Islamabad', '08', '', '33.6900', '73.0551');
INSERT INTO `net_city` VALUES ('24792', '163', 'Картахена-де-Индиас', 'Cartagena de Indias', '05', '', '10.3997', '-75.5144');
INSERT INTO `net_city` VALUES ('24797', '132', 'Коломбо', 'Colombo', '36', '', '6.9319', '79.8478');
INSERT INTO `net_city` VALUES ('24798', '27', 'Фахардо', 'Fajardo', '00', '00738', '18.3278', '-65.6837');
INSERT INTO `net_city` VALUES ('24799', '163', 'Перейра', 'Pereira', '24', '', '4.8133', '-75.6961');
INSERT INTO `net_city` VALUES ('24801', '175', 'Маракай', 'Maracay', '04', '', '10.2469', '-67.5958');
INSERT INTO `net_city` VALUES ('24803', '163', 'Нейва', 'Neiva', '16', '', '2.9273', '-75.2819');
INSERT INTO `net_city` VALUES ('24804', '38', 'Винья-дель-Мар', 'Vina del Mar', '01', '', '-33.0081', '-71.5197');
INSERT INTO `net_city` VALUES ('24807', '25', 'Пьедрас Неграс ', 'Piedras Negras', '07', '', '28.7000', '-100.5167');
INSERT INTO `net_city` VALUES ('24808', '197', 'Ораньестад', 'Oranjestad', '00', '', '12.5167', '-70.0333');
INSERT INTO `net_city` VALUES ('24809', '25', 'Канкун', 'Cancún', '23', '', '21.1667', '-86.8333');
INSERT INTO `net_city` VALUES ('24811', '113', 'Минск', 'Minsk', '04', '', '53.9000', '27.5667');
INSERT INTO `net_city` VALUES ('24815', '23', 'Тайби-Айленд', 'Tybee Island', 'GA', '31328', '32.0280', '-80.9361');
INSERT INTO `net_city` VALUES ('24820', '24', 'Клэр', 'Clair', 'SK', '', '52.0167', '-104.0667');
INSERT INTO `net_city` VALUES ('24829', '23', 'Монмут', 'Monmouth', 'OR', '97361', '44.7841', '-123.3377');
INSERT INTO `net_city` VALUES ('24834', '23', 'Коули', 'Cowley', 'WY', '82420', '44.8833', '-108.4696');
INSERT INTO `net_city` VALUES ('24838', '23', 'Ландер', 'Lander', 'WY', '82520', '42.6501', '-108.4242');
INSERT INTO `net_city` VALUES ('24839', '23', 'Дюбуа', 'Dubois', 'WY', '82513', '43.4930', '-109.6436');
INSERT INTO `net_city` VALUES ('24840', '23', 'Келли', 'Kelly', 'WY', '83011', '43.5987', '-110.5555');
INSERT INTO `net_city` VALUES ('24848', '4', 'Мяньян', 'Mianyang', '32', '', '31.4593', '104.7542');
INSERT INTO `net_city` VALUES ('24851', '23', 'Лейк-Гамильтон', 'Lake Hamilton', 'FL', '33851', '28.0445', '-81.6278');
INSERT INTO `net_city` VALUES ('24852', '6', 'Гургаон', 'Gurgaon', '10', '', '28.4667', '77.0333');
INSERT INTO `net_city` VALUES ('24858', '23', 'Саут Пойнт', 'South Point', 'OH', '45680', '38.4558', '-82.5407');
INSERT INTO `net_city` VALUES ('24859', '23', 'Тиллери', 'Tillery', 'NC', '27887', '36.2518', '-77.4855');
INSERT INTO `net_city` VALUES ('24860', '23', 'Хойт', 'Hoyt', 'OK', '74440', '35.2832', '-95.3202');
INSERT INTO `net_city` VALUES ('24865', '23', 'Сарвер', 'Sarver', 'PA', '16055', '40.7219', '-79.7469');
INSERT INTO `net_city` VALUES ('24872', '23', 'Мони', 'Monee', 'IL', '60449', '41.4123', '-87.7964');
INSERT INTO `net_city` VALUES ('24874', '23', 'Титонка', 'Titonka', 'IA', '50480', '43.2558', '-94.0503');
INSERT INTO `net_city` VALUES ('24878', '23', 'Джордж', 'George', 'IA', '51237', '43.3381', '-96.0188');
INSERT INTO `net_city` VALUES ('24879', '23', 'Вулсток', 'Woolstock', 'IA', '50599', '42.5797', '-93.8140');
INSERT INTO `net_city` VALUES ('24882', '23', 'Дайсарт', 'Dysart', 'IA', '52224', '42.1623', '-92.3167');
INSERT INTO `net_city` VALUES ('24884', '25', 'Чиуауа', 'Chihuahua', '06', '', '28.6333', '-106.0833');
INSERT INTO `net_city` VALUES ('24886', '25', 'Гвадалахара', 'Guadalajara', '14', '', '20.6667', '-103.3333');
INSERT INTO `net_city` VALUES ('24888', '13', 'Латина', 'Latina', '07', '', '41.4667', '12.8667');
INSERT INTO `net_city` VALUES ('24889', '56', 'Пюрс', 'Puurs', '01', '', '51.0833', '4.2833');
INSERT INTO `net_city` VALUES ('24890', '15', 'Эскильстуна', 'Eskilstuna', '18', '', '59.3667', '16.5000');
INSERT INTO `net_city` VALUES ('24891', '127', 'Ансфельден', 'Ansfelden', '04', '', '48.2000', '14.2833');
INSERT INTO `net_city` VALUES ('24892', '12', 'Сержи', 'Cergy', 'A8', '', '49.0364', '2.0761');
INSERT INTO `net_city` VALUES ('24893', '29', 'Людвигсбург', 'Ludwigsburg', '01', '', '48.9000', '9.1833');
INSERT INTO `net_city` VALUES ('24894', '21', 'Барнстейпл', 'Barnstaple', 'D4', '', '51.0833', '-4.0500');
INSERT INTO `net_city` VALUES ('24895', '21', 'Нортидж', 'Northwich', 'C5', '', '53.2667', '-2.5');
INSERT INTO `net_city` VALUES ('24899', '33', 'Влардинген', 'Vlaardingen', '11', '', '51.9210', '4.3219');
INSERT INTO `net_city` VALUES ('24901', '21', 'Эйлсбери', 'Aylesbury', 'B9', '', '51.8167', '-0.8000');
INSERT INTO `net_city` VALUES ('24902', '12', 'Дуэ', 'Douai', 'B4', '', '50.3724', '3.0890');
INSERT INTO `net_city` VALUES ('24903', '15', 'Шеллефтео', 'Skelleftea', '23', '', '64.7667', '20.9500');
INSERT INTO `net_city` VALUES ('24904', '12', 'Шарент', 'Charenton-le-Pont', 'A8', '', '48.8221', '2.4122');
INSERT INTO `net_city` VALUES ('24906', '56', 'Вёрне', 'Veurne', '09', '', '51.0667', '2.6667');
INSERT INTO `net_city` VALUES ('24910', '45', 'Тангеранг', 'Tangerang', '30', '', '-6.1781', '106.6300');
INSERT INTO `net_city` VALUES ('24911', '3', 'Ульсан', 'Ulsan', '21', '', '35.5372', '129.3167');
INSERT INTO `net_city` VALUES ('24912', '5', 'Кавагоэ', 'Kawagoe', '34', '', '35.9086', '139.4853');
INSERT INTO `net_city` VALUES ('24914', '9', 'Нонтхабури', 'Nonthaburi', '38', '', '13.8622', '100.5134');
INSERT INTO `net_city` VALUES ('24915', '21', 'Кеннфорд', 'Kennford', 'D4', '', '50.7000', '-3.4833');
INSERT INTO `net_city` VALUES ('24916', '29', 'Арнсторф', 'Arnstorf', '02', '', '48.5667', '12.8167');
INSERT INTO `net_city` VALUES ('24917', '5', 'Кобе', 'Kobe', '13', '', '34.6913', '135.1830');
INSERT INTO `net_city` VALUES ('24918', '5', 'Хадано', 'Hadano', '19', '', '35.3711', '139.2236');
INSERT INTO `net_city` VALUES ('24919', '21', 'Хайес', 'Hayes', '17', '', '51.3667', '0.0167');
INSERT INTO `net_city` VALUES ('24921', '21', 'Линкольн ', 'Lincoln', 'H7', '', '53.2333', '-0.5333');
INSERT INTO `net_city` VALUES ('24926', '21', 'Фейрхам', 'Fareham', 'F2', '', '50.8500', '-1.1833');
INSERT INTO `net_city` VALUES ('24927', '58', 'Таубате', 'Taubaté', '27', '', '-23.0333', '-45.5500');
INSERT INTO `net_city` VALUES ('24928', '15', 'Хёганес', 'Höganäs', '27', '', '56.2000', '12.5500');
INSERT INTO `net_city` VALUES ('24932', '58', 'Лондрина', 'Londrina', '18', '', '-23.3000', '-51.1500');
INSERT INTO `net_city` VALUES ('24933', '58', 'Серра', 'Serra', '08', '', '-20.1167', '-40.3000');
INSERT INTO `net_city` VALUES ('24934', '13', 'Рапалло', 'Rapallo', '08', '', '44.3500', '9.2333');
INSERT INTO `net_city` VALUES ('24936', '23', 'Хинесвилл', 'Hinesville', 'GA', '31313', '31.8581', '-81.5854');
INSERT INTO `net_city` VALUES ('24939', '23', 'Вагенер', 'Wagener', 'SC', '29164', '33.6485', '-81.4285');
INSERT INTO `net_city` VALUES ('24951', '23', 'Авенал', 'Avenal', 'CA', '93204', '35.9244', '-120.1084');
INSERT INTO `net_city` VALUES ('24953', '23', 'Линдсей', 'Lindsay', 'CA', '93247', '36.2077', '-119.0883');
INSERT INTO `net_city` VALUES ('24955', '23', 'Уокена', 'Waukena', 'CA', '93282', '36.1386', '-119.5096');
INSERT INTO `net_city` VALUES ('24958', '23', 'Стратмор', 'Strathmore', 'CA', '93267', '36.1491', '-119.0921');
INSERT INTO `net_city` VALUES ('24959', '23', 'Алпо', 'Alpaugh', 'CA', '93201', '35.8877', '-119.4873');
INSERT INTO `net_city` VALUES ('24960', '23', 'Пиксли', 'Pixley', 'CA', '93256', '35.9541', '-119.3133');
INSERT INTO `net_city` VALUES ('24961', '23', 'Оберри', 'Auberry', 'CA', '93602', '37.0038', '-119.1516');
INSERT INTO `net_city` VALUES ('24967', '23', 'Латон', 'Laton', 'CA', '93242', '36.4369', '-119.6923');
INSERT INTO `net_city` VALUES ('24968', '23', 'Глиндон', 'Glyndon', 'MN', '56547', '46.8910', '-96.5610');
INSERT INTO `net_city` VALUES ('24971', '23', 'Мадилия', 'Madelia', 'MN', '56062', '44.0527', '-94.4212');
INSERT INTO `net_city` VALUES ('24972', '23', 'Пейсон', 'Payson', 'AZ', '85541', '34.1954', '-111.1726');
INSERT INTO `net_city` VALUES ('24976', '23', 'Секим', 'Sequim', 'WA', '98382', '48.0656', '-123.0613');
INSERT INTO `net_city` VALUES ('24978', '23', 'Истленд', 'Eastland', 'TX', '76448', '32.4100', '-98.7840');
INSERT INTO `net_city` VALUES ('24982', '24', 'Ламби', 'Lumby', 'BC', 'v0e2g0', '50.2500', '-118.9667');
INSERT INTO `net_city` VALUES ('24984', '24', 'Голден', 'Golden', 'BC', 'v0a1v0', '51.3000', '-116.9667');
INSERT INTO `net_city` VALUES ('24989', '24', 'Энвермер', 'Invermere', 'BC', 'v0a1k0', '50.5000', '-116.0333');
INSERT INTO `net_city` VALUES ('24990', '24', 'Ферни', 'Fernie', 'BC', 'v0b1m1', '49.5000', '-115.0667');
INSERT INTO `net_city` VALUES ('24999', '24', 'Треерн', 'Treherne', 'MB', 'r0g2v0', '49.6333', '-98.7000');
INSERT INTO `net_city` VALUES ('25004', '24', 'Маккензи', 'Mackenzie', 'BC', 'v0j2c0', '55.3300', '-123.0900');
INSERT INTO `net_city` VALUES ('25036', '23', 'Шавано', 'Shawano', 'WI', '54166', '44.7677', '-88.7169');
INSERT INTO `net_city` VALUES ('25038', '23', 'Саур Лейк', 'Sour Lake', 'TX', '77659', '30.1782', '-94.4222');
INSERT INTO `net_city` VALUES ('25050', '23', 'Брансон Уэст', 'Branson West', 'MO', '65737', '36.7027', '-93.3612');
INSERT INTO `net_city` VALUES ('25052', '23', 'Себика', 'Sebeka', 'MN', '56477', '46.6085', '-95.0523');
INSERT INTO `net_city` VALUES ('25054', '23', 'Пламмер', 'Plummer', 'MN', '56748', '47.9194', '-96.0170');
INSERT INTO `net_city` VALUES ('25057', '23', 'Уайлдвуд', 'Wildwood', 'FL', '34785', '28.8405', '-82.0504');
INSERT INTO `net_city` VALUES ('25071', '23', 'Танунак', 'Tununak', 'AK', '99681', '60.6088', '-165.1392');
INSERT INTO `net_city` VALUES ('25072', '27', 'Коросаль', 'Corozal', '00', '00783', '18.3044', '-66.3305');
INSERT INTO `net_city` VALUES ('25073', '23', 'Хаутздейл', 'Houtzdale', 'PA', '16651', '40.8423', '-78.3731');
INSERT INTO `net_city` VALUES ('25074', '24', 'Брукс', 'Brooks', 'AB', 't1r1c7', '50.5667', '-111.9000');
INSERT INTO `net_city` VALUES ('25077', '23', 'Массена', 'Massena', 'NY', '13662', '44.9503', '-74.9404');
INSERT INTO `net_city` VALUES ('25079', '23', 'Пеконик', 'Peconic', 'NY', '11958', '41.0376', '-72.4655');
INSERT INTO `net_city` VALUES ('25081', '23', 'Гарнетт', 'Garnett', 'KS', '66032', '38.2723', '-95.2866');
INSERT INTO `net_city` VALUES ('25085', '23', 'Бойлстон', 'Boylston', 'MA', '01505', '42.3539', '-71.7173');
INSERT INTO `net_city` VALUES ('25089', '23', 'Ньюманстаун', 'Newmanstown', 'PA', '17073', '40.3009', '-76.2581');
INSERT INTO `net_city` VALUES ('25090', '23', 'Поттер', 'Potter', 'WI', '54160', '44.1206', '-88.0993');
INSERT INTO `net_city` VALUES ('25092', '23', 'Платт Сити', 'Platte City', 'MO', '64079', '39.3818', '-94.7825');
INSERT INTO `net_city` VALUES ('25093', '23', 'Саблетт', 'Sublette', 'IL', '61367', '41.6287', '-89.2746');
INSERT INTO `net_city` VALUES ('25095', '23', 'Элдон', 'Eldon', 'MO', '65026', '38.3129', '-92.5530');
INSERT INTO `net_city` VALUES ('25097', '23', 'Бернт Хилс', 'Burnt Hills', 'NY', '12027', '42.9214', '-73.9096');
INSERT INTO `net_city` VALUES ('25102', '23', 'Или', 'Ely', 'MN', '55731', '47.9445', '-91.7717');
INSERT INTO `net_city` VALUES ('25105', '23', 'Покомок Сити', 'Pocomoke City', 'MD', '21851', '38.0694', '-75.5412');
INSERT INTO `net_city` VALUES ('25108', '23', 'Суитуотер', 'Sweetwater', 'TX', '79556', '32.4669', '-100.4257');
INSERT INTO `net_city` VALUES ('25112', '23', 'Таусанд Палмс', 'Thousand Palms', 'CA', '92276', '33.8093', '-116.3623');
INSERT INTO `net_city` VALUES ('25115', '23', 'Боуменсвилл', 'Bowmansville', 'NY', '14026', '42.9413', '-78.6899');
INSERT INTO `net_city` VALUES ('25117', '23', 'Овоссо', 'Owosso', 'MI', '48867', '42.9965', '-84.1874');
INSERT INTO `net_city` VALUES ('25126', '23', 'Вироква', 'Viroqua', 'WI', '54665', '43.5290', '-90.9161');
INSERT INTO `net_city` VALUES ('25127', '24', 'Кенора', 'Kenora', 'ON', 'p9n3x3', '49.7667', '-94.4667');
INSERT INTO `net_city` VALUES ('25135', '23', 'Гвинда', 'Guinda', 'CA', '95637', '38.8071', '-122.1882');
INSERT INTO `net_city` VALUES ('25137', '23', 'Сентр', 'Centre', 'AL', '35960', '34.1187', '-85.5927');
INSERT INTO `net_city` VALUES ('25138', '23', 'Квартцзит', 'Quartzsite', 'AZ', '85359', '33.6639', '-114.2300');
INSERT INTO `net_city` VALUES ('25143', '23', 'Конкрет', 'Concrete', 'WA', '98237', '48.5614', '-121.7705');
INSERT INTO `net_city` VALUES ('25144', '23', 'Феннимор', 'Fennimore', 'WI', '53809', '42.9940', '-90.6309');
INSERT INTO `net_city` VALUES ('25146', '23', 'Уоунейки', 'Waunakee', 'WI', '53597', '43.1855', '-89.4735');
INSERT INTO `net_city` VALUES ('25160', '4', 'Чанчунь', 'Changchun', '05', '', '43.8800', '125.3228');
INSERT INTO `net_city` VALUES ('25163', '58', 'Уберландия', 'Uberlândia', '15', '', '-18.9167', '-48.3000');
INSERT INTO `net_city` VALUES ('25175', '23', 'Фрипорт', 'Freeport', 'ME', '04032', '43.8635', '-70.0976');
INSERT INTO `net_city` VALUES ('25182', '23', 'Сандиа Парк', 'Sandia Park', 'NM', '87047', '35.2329', '-106.2828');
INSERT INTO `net_city` VALUES ('25187', '23', 'Седро-Вулли', 'Sedro Woolley', 'WA', '98284', '48.5991', '-122.1379');
INSERT INTO `net_city` VALUES ('25198', '23', 'Маскода', 'Muscoda', 'WI', '53573', '43.1200', '-90.4414');
INSERT INTO `net_city` VALUES ('25204', '23', 'Байерз', 'Byers', 'CO', '80103', '39.7830', '-104.1154');
INSERT INTO `net_city` VALUES ('25216', '23', 'Маунт Эфрейм', 'Mount Ephraim', 'NJ', '08059', '39.8865', '-75.0941');
INSERT INTO `net_city` VALUES ('25218', '23', 'Сансет', 'Sunset', 'LA', '70584', '30.3882', '-92.0935');
INSERT INTO `net_city` VALUES ('25223', '23', 'Хойзингтон', 'Hoisington', 'KS', '67544', '38.5729', '-98.7474');
INSERT INTO `net_city` VALUES ('25224', '23', 'Аддисон', 'Addison', 'MI', '49220', '41.9943', '-84.3386');
INSERT INTO `net_city` VALUES ('25229', '23', 'Карлтон', 'Carleton', 'MI', '48117', '42.0412', '-83.4209');
INSERT INTO `net_city` VALUES ('25240', '23', 'Грамерси', 'Gramercy', 'LA', '70052', '30.0613', '-90.6936');
INSERT INTO `net_city` VALUES ('25241', '23', 'Бриттон', 'Britton', 'MI', '49229', '42.0013', '-83.8439');
INSERT INTO `net_city` VALUES ('25248', '23', 'Моренси', 'Morenci', 'MI', '49256', '41.7606', '-84.2282');
INSERT INTO `net_city` VALUES ('25249', '23', 'Онстед', 'Onsted', 'MI', '49265', '42.0076', '-84.1661');
INSERT INTO `net_city` VALUES ('25254', '23', 'Довер', 'Dover', 'VT', '05363', '42.8752', '-72.8486');
INSERT INTO `net_city` VALUES ('25258', '23', 'Белфилд', 'Belfield', 'ND', '58622', '46.9246', '-103.2622');
INSERT INTO `net_city` VALUES ('25259', '23', 'Бисби', 'Bisbee', 'AZ', '85603', '31.4453', '-109.8731');
INSERT INTO `net_city` VALUES ('25261', '23', 'Лейк Монтесума', 'Lake Montezuma', 'AZ', '86342', '34.6322', '-111.7779');
INSERT INTO `net_city` VALUES ('25264', '23', 'Сакатон', 'Sacaton', 'AZ', '85247', '33.1000', '-111.7903');
INSERT INTO `net_city` VALUES ('25272', '23', 'Университи Плейс', 'University Place', 'WA', '98467', '47.2012', '-122.5419');
INSERT INTO `net_city` VALUES ('25276', '21', 'Дронфилд', 'Dronfield', 'D3', '', '53.3000', '-1.4667');
INSERT INTO `net_city` VALUES ('25283', '23', 'Линвуд', 'Linwood', 'KS', '66052', '39.0126', '-95.0294');
INSERT INTO `net_city` VALUES ('25284', '23', 'Пагуат', 'Paguate', 'NM', '87040', '35.1386', '-107.3789');
INSERT INTO `net_city` VALUES ('25286', '23', 'Навахо Дэм', 'Navajo Dam', 'NM', '87419', '36.8660', '-107.4652');
INSERT INTO `net_city` VALUES ('25288', '23', 'Байяр', 'Bayard', 'NM', '88023', '32.7790', '-108.0722');
INSERT INTO `net_city` VALUES ('25289', '23', 'Тукумкари', 'Tucumcari', 'NM', '88401', '35.0965', '-103.7766');
INSERT INTO `net_city` VALUES ('25291', '23', 'Сиссетон', 'Sisseton', 'SD', '57262', '45.6710', '-97.0715');
INSERT INTO `net_city` VALUES ('25292', '23', 'Бокс Элдер', 'Box Elder', 'SD', '57719', '44.2160', '-102.9797');
INSERT INTO `net_city` VALUES ('25295', '23', 'Фландро', 'Flandreau', 'SD', '57028', '44.0361', '-96.6209');
INSERT INTO `net_city` VALUES ('25296', '23', 'Леммон', 'Lemmon', 'SD', '57638', '45.8752', '-102.2065');
INSERT INTO `net_city` VALUES ('25297', '23', 'Лопез Айленд', 'Lopez Island', 'WA', '98261', '48.4955', '-122.8729');
INSERT INTO `net_city` VALUES ('25299', '23', 'Эфрата', 'Ephrata', 'WA', '98823', '47.2724', '-119.5900');
INSERT INTO `net_city` VALUES ('25301', '23', 'Барнум', 'Barnum', 'MN', '55707', '46.5412', '-92.6262');
INSERT INTO `net_city` VALUES ('25304', '23', 'Тримонт', 'Trimont', 'MN', '56176', '43.7829', '-94.7233');
INSERT INTO `net_city` VALUES ('25306', '23', 'Мейвилл', 'Mayville', 'ND', '58257', '47.4907', '-97.2731');
INSERT INTO `net_city` VALUES ('25307', '23', 'Хайлендвилл', 'Highlandville', 'MO', '65669', '36.9159', '-93.3051');
INSERT INTO `net_city` VALUES ('25309', '23', 'Рейнир', 'Rainier', 'OR', '97048', '46.0419', '-122.9883');
INSERT INTO `net_city` VALUES ('25317', '24', 'Сиденхам', 'Sydenham', 'ON', 'k0h2t0', '44.4074', '-76.5970');
INSERT INTO `net_city` VALUES ('25320', '23', 'Редфилд', 'Redfield', 'SD', '57469', '44.8807', '-98.5739');
INSERT INTO `net_city` VALUES ('25337', '23', 'Эль Дорадо Спрингс', 'El Dorado Springs', 'MO', '64744', '37.8463', '-93.9951');
INSERT INTO `net_city` VALUES ('25348', '23', 'Макон', 'Macon', 'MO', '63552', '39.7524', '-92.4566');
INSERT INTO `net_city` VALUES ('25353', '130', 'Белла Виста', 'Bella Vista', '07', '', '7.7500', '-80.2333');
INSERT INTO `net_city` VALUES ('25362', '23', 'Уорли', 'Worley', 'ID', '83876', '47.4469', '-116.8976');
INSERT INTO `net_city` VALUES ('25368', '121', 'София', 'Sofia', '42', '', '42.6833', '23.3167');
INSERT INTO `net_city` VALUES ('25369', '17', 'Лиссабон', 'Lisbon', '14', '', '38.7167', '-9.1333');
INSERT INTO `net_city` VALUES ('25370', '15', 'Хельсингборг', 'Helsingborg', '27', '', '56.0500', '12.7000');
INSERT INTO `net_city` VALUES ('25371', '12', 'Амьен', 'Amiens', 'B6', '', '49.9000', '2.3000');
INSERT INTO `net_city` VALUES ('25372', '55', 'Корк', 'Cork', '04', '', '51.8986', '-8.4958');
INSERT INTO `net_city` VALUES ('25373', '60', 'Моссел Бей', 'Mossel Bay', '11', '', '-34.1831', '22.1460');
INSERT INTO `net_city` VALUES ('25377', '29', 'Фюрт', 'Furth', '02', '', '49.4667', '10.9667');
INSERT INTO `net_city` VALUES ('25378', '56', 'Антверпен', 'Antwerp', '01', '', '51.2167', '4.4167');
INSERT INTO `net_city` VALUES ('25380', '12', 'Ле Бурже', 'Le Bourget', 'A8', '', '48.9341', '2.4358');
INSERT INTO `net_city` VALUES ('25381', '13', 'Асколи-Пичено', 'Ascoli Piceno', '10', '', '42.8500', '13.5667');
INSERT INTO `net_city` VALUES ('25382', '18', 'Пиргос', 'Piraeus', '35', '', '37.9614', '23.6389');
INSERT INTO `net_city` VALUES ('25383', '35', 'Руби', 'Rubi', '56', '', '41.4923', '2.0330');
INSERT INTO `net_city` VALUES ('25385', '145', 'Башараж', 'Bascharage', '03', '', '49.5675', '5.9103');
INSERT INTO `net_city` VALUES ('25386', '170', 'Пуэрто Плата', 'Puerto Plata', '18', '', '19.8000', '-70.6833');
INSERT INTO `net_city` VALUES ('25388', '29', 'Зост ', 'Soest', '07', '', '51.5833', '8.1167');
INSERT INTO `net_city` VALUES ('25391', '12', 'Кроль', 'Crolles', 'B9', '', '45.2820', '5.8782');
INSERT INTO `net_city` VALUES ('25392', '12', 'Нёйи-сюр-Сен', 'Neuilly-sur-Seine', 'A8', '', '48.8833', '2.2667');
INSERT INTO `net_city` VALUES ('25398', '23', 'Глориета', 'Glorieta', 'NM', '87535', '35.7538', '-105.7483');
INSERT INTO `net_city` VALUES ('25399', '21', 'Кроли', 'Crawley', 'P6', '', '51.1167', '-0.1833');
INSERT INTO `net_city` VALUES ('25404', '23', 'Гровленд', 'Groveland', 'MA', '01834', '42.7505', '-71.0093');
INSERT INTO `net_city` VALUES ('25406', '46', 'Карачи', 'Karachi', '05', '', '24.9056', '67.0822');
INSERT INTO `net_city` VALUES ('25411', '12', 'Вальбон', 'Valbonne', 'B8', '', '43.6413', '7.0057');
INSERT INTO `net_city` VALUES ('25419', '13', 'Новара', 'Novara', '12', '', '45.4667', '8.6333');
INSERT INTO `net_city` VALUES ('25422', '56', 'Ватерлоо', 'Waterloo', '02', '', '50.7167', '4.3833');
INSERT INTO `net_city` VALUES ('25428', '33', 'Зандам', 'Zaandam', '07', '', '52.4393', '4.8106');
INSERT INTO `net_city` VALUES ('25429', '23', 'Проссер', 'Prosser', 'WA', '99350', '46.1287', '-119.6798');
INSERT INTO `net_city` VALUES ('25460', '23', 'Сноквалми Пасс', 'Snoqualmie Pass', 'WA', '98068', '47.3923', '-121.4001');
INSERT INTO `net_city` VALUES ('25463', '23', 'Маунтин Гров', 'Mountain Grove', 'MO', '65711', '37.2186', '-92.2704');
INSERT INTO `net_city` VALUES ('25467', '33', 'Тилбург', 'Tilburg', '06', '', '51.5769', '5.1063');
INSERT INTO `net_city` VALUES ('25474', '23', 'Тивертон', 'Tiverton', 'RI', '02878', '41.6092', '-71.1744');
INSERT INTO `net_city` VALUES ('25475', '23', 'Уэлс', 'Wells', 'NV', '89835', '41.3543', '-114.8075');
INSERT INTO `net_city` VALUES ('25478', '23', 'Гилсум', 'Gilsum', 'NH', '03448', '43.0387', '-72.2806');
INSERT INTO `net_city` VALUES ('25483', '23', 'Сафети Харбор', 'Safety Harbor', 'FL', '34695', '28.0145', '-82.6923');
INSERT INTO `net_city` VALUES ('25490', '23', 'Слейтон', 'Slayton', 'MN', '56172', '44.0267', '-95.7637');
INSERT INTO `net_city` VALUES ('25545', '27', 'Аресибо', 'Arecibo', '00', '00612', '18.3994', '-66.7113');
INSERT INTO `net_city` VALUES ('25546', '27', 'Майягуэс', 'Mayaguez', '00', '00680', '18.2115', '-67.1026');
INSERT INTO `net_city` VALUES ('25549', '23', 'Беллоус Фолс', 'Bellows Falls', 'VT', '05101', '43.1731', '-72.4957');
INSERT INTO `net_city` VALUES ('25554', '23', 'Адамс', 'Adams', 'MA', '01220', '42.6271', '-73.1187');
INSERT INTO `net_city` VALUES ('25560', '23', 'Путни', 'Putney', 'VT', '05346', '43.0203', '-72.5261');
INSERT INTO `net_city` VALUES ('25562', '23', 'Страффорд', 'Strafford', 'VT', '05072', '43.8776', '-72.3665');
INSERT INTO `net_city` VALUES ('25567', '23', 'Шафтсбери', 'Shaftsbury', 'VT', '05262', '42.9934', '-73.1349');
INSERT INTO `net_city` VALUES ('25568', '23', 'Линдонвилл', 'Lyndonville', 'VT', '05851', '44.5326', '-72.0470');
INSERT INTO `net_city` VALUES ('25569', '23', 'Квичи', 'Quechee', 'VT', '05059', '43.6462', '-72.4184');
INSERT INTO `net_city` VALUES ('25571', '23', 'Олстед', 'Alstead', 'NH', '03602', '43.1351', '-72.3392');
INSERT INTO `net_city` VALUES ('25573', '23', 'Солсбери', 'Salisbury', 'VT', '05769', '43.9144', '-73.1137');
INSERT INTO `net_city` VALUES ('25574', '23', 'Норт Уолпол', 'North Walpole', 'NH', '03609', '43.1418', '-72.4353');
INSERT INTO `net_city` VALUES ('25575', '23', 'Кале', 'Calais', 'VT', '05648', '44.3772', '-72.4994');
INSERT INTO `net_city` VALUES ('25576', '23', 'Дорсет', 'Dorset', 'VT', '05251', '43.2603', '-73.0986');
INSERT INTO `net_city` VALUES ('25577', '23', 'Гранд Маунд', 'Grand Mound', 'IA', '52751', '41.8431', '-90.6790');
INSERT INTO `net_city` VALUES ('25578', '23', 'Саут Ройалтон', 'South Royalton', 'VT', '05068', '43.7577', '-72.5255');
INSERT INTO `net_city` VALUES ('25579', '23', 'Норт Беннингтон', 'North Bennington', 'VT', '05257', '42.9699', '-73.2617');
INSERT INTO `net_city` VALUES ('25581', '23', 'Норт Помфрет', 'North Pomfret', 'VT', '05053', '43.7263', '-72.4855');
INSERT INTO `net_city` VALUES ('25586', '23', 'Саут Барр', 'South Barre', 'VT', '05670', '44.1770', '-72.5057');
INSERT INTO `net_city` VALUES ('25587', '23', 'Ист Мидлбери', 'East Middlebury', 'VT', '05740', '43.9734', '-73.1062');
INSERT INTO `net_city` VALUES ('25646', '23', 'Чарлтон', 'Charlton', 'MA', '01507', '42.1318', '-71.9731');
INSERT INTO `net_city` VALUES ('25647', '23', 'Виндхам', 'Windham', 'ME', '04062', '43.7940', '-70.3979');
INSERT INTO `net_city` VALUES ('25649', '23', 'Атлантик Бич', 'Atlantic Beach', 'NC', '28512', '34.7000', '-76.7741');
INSERT INTO `net_city` VALUES ('25679', '24', 'Саре-Кёр', 'Sacre-Coeur', 'QC', 'g0t1y0', '48.4333', '-68.5833');
INSERT INTO `net_city` VALUES ('25740', '23', 'Хансвилл', 'Hansville', 'WA', '98340', '47.9121', '-122.5704');
INSERT INTO `net_city` VALUES ('25776', '23', 'Уиллоу Спрингс', 'Willow Springs', 'MO', '65793', '37.0031', '-91.9659');
INSERT INTO `net_city` VALUES ('25777', '23', 'Калифорния Сити', 'California City', 'CA', '93505', '35.1509', '-117.9215');
INSERT INTO `net_city` VALUES ('25779', '23', 'Хаттерас', 'Hatteras', 'NC', '27943', '35.2193', '-75.6902');
INSERT INTO `net_city` VALUES ('25781', '23', 'Пойнт Харбор', 'Point Harbor', 'NC', '27964', '36.0871', '-75.8041');
INSERT INTO `net_city` VALUES ('25783', '23', 'Дилвин', 'Dillwyn', 'VA', '23936', '37.5419', '-78.5029');
INSERT INTO `net_city` VALUES ('25799', '23', 'Проктор', 'Proctor', 'VT', '05765', '43.6516', '-73.0348');
INSERT INTO `net_city` VALUES ('25815', '23', 'Корделл', 'Cordell', 'OK', '73632', '35.2472', '-98.8882');
INSERT INTO `net_city` VALUES ('25826', '23', 'Сейнт Мэттьюс', 'Saint Matthews', 'SC', '29135', '33.6784', '-80.7804');
INSERT INTO `net_city` VALUES ('25827', '23', 'Рейнсвилл', 'Rainsville', 'AL', '35986', '34.5029', '-85.8358');
INSERT INTO `net_city` VALUES ('25829', '23', 'Фоллентимбер', 'Fallentimber', 'PA', '16639', '40.6848', '-78.4447');
INSERT INTO `net_city` VALUES ('25833', '6', 'Нью-Дели', 'New Delhi', '07', '', '28.6000', '77.2000');
INSERT INTO `net_city` VALUES ('25842', '23', 'Эванс Сити', 'Evans City', 'PA', '16033', '40.7957', '-80.0397');
INSERT INTO `net_city` VALUES ('25845', '23', 'Уикенберг', 'Wickenburg', 'AZ', '85390', '33.9022', '-112.9014');
INSERT INTO `net_city` VALUES ('25854', '24', 'Колд Лейк', 'Cold Lake', 'AB', 't9m1p1', '54.4650', '-110.1831');
INSERT INTO `net_city` VALUES ('25882', '24', 'Уэтаскивин', 'Wetaskiwin', 'AB', 't9a2g4', '52.9667', '-113.3833');
INSERT INTO `net_city` VALUES ('25892', '24', 'Хай Прейри', 'High Prairie', 'AB', 't0g1e0', '55.4333', '-116.4833');
INSERT INTO `net_city` VALUES ('25934', '24', 'Дидсбери', 'Didsbury', 'AB', 't0m0w0', '51.6667', '-114.1333');
INSERT INTO `net_city` VALUES ('25939', '23', 'Фаунтинвилл', 'Fountainville', 'PA', '18923', '40.3523', '-75.1709');
INSERT INTO `net_city` VALUES ('25940', '23', 'Дуглас', 'Douglas', 'MA', '01516', '42.0544', '-71.7548');
INSERT INTO `net_city` VALUES ('25968', '23', 'Лос Оливос', 'Los Olivos', 'CA', '93441', '34.7107', '-120.0115');
INSERT INTO `net_city` VALUES ('25969', '20', 'Смоленск', 'Smolensk', '69', '', '54.7818', '32.0401');
INSERT INTO `net_city` VALUES ('25976', '139', 'Турку ', 'Turku', '15', '', '60.4500', '22.2833');
INSERT INTO `net_city` VALUES ('25977', '21', 'Бракнелл', 'Bracknell', 'B3', '', '51.4167', '-0.7500');
INSERT INTO `net_city` VALUES ('25983', '109', 'Мерсин', 'Mersin', '32', '', '36.7328', '34.6442');
INSERT INTO `net_city` VALUES ('25986', '35', 'Боадилья-дель-Монте', 'Boadilla del Monte', '29', '', '40.4028', '-3.8756');
INSERT INTO `net_city` VALUES ('25988', '20', 'Саратов', 'Saratov', '67', '', '51.5406', '46.0086');
INSERT INTO `net_city` VALUES ('25990', '153', 'Баку', 'Baku', '09', '', '40.3953', '49.8822');
INSERT INTO `net_city` VALUES ('25991', '21', 'Мидлсбро', 'Middlesbrough', 'I5', '', '54.5728', '-1.1628');
INSERT INTO `net_city` VALUES ('25994', '40', 'Росарио', 'Rosario', '21', '', '-32.9468', '-60.6393');
INSERT INTO `net_city` VALUES ('25995', '36', 'Фрипорт', 'Freeport', '25', '', '26.5333', '-78.7000');
INSERT INTO `net_city` VALUES ('25996', '58', 'Куритиба', 'Curitiba', '18', '', '-25.4167', '-49.2500');
INSERT INTO `net_city` VALUES ('25997', '35', 'Пальма', 'Palma', '07', '', '39.5743', '2.6552');
INSERT INTO `net_city` VALUES ('26002', '12', 'Этамп ', 'Etampes', 'A3', '', '48.4330', '2.1758');
INSERT INTO `net_city` VALUES ('26013', '23', 'Эмметт', 'Emmett', 'MI', '48022', '43.0286', '-82.8106');
INSERT INTO `net_city` VALUES ('26027', '127', 'Баден', 'Baden bei Wien', '03', '', '48.0167', '16.2333');
INSERT INTO `net_city` VALUES ('26031', '23', 'Мазомани', 'Mazomanie', 'WI', '53560', '43.1976', '-89.7438');
INSERT INTO `net_city` VALUES ('26033', '35', 'Виго', 'Vigo', '58', '', '42.2328', '-8.7226');
INSERT INTO `net_city` VALUES ('26036', '21', 'Абергел', 'Abergele', 'X8', '', '53.2833', '-3.5833');
INSERT INTO `net_city` VALUES ('26043', '24', 'Суон Ривер', 'Swan River', 'MB', 'r0l1z0', '52.1000', '-101.2667');
INSERT INTO `net_city` VALUES ('26132', '24', 'Комокс', 'Comox', 'BC', 'v9n3x4', '49.6833', '-124.9333');
INSERT INTO `net_city` VALUES ('26163', '58', 'Кампинас', 'Campinas', '27', '', '-22.9000', '-47.0833');
INSERT INTO `net_city` VALUES ('26169', '24', 'Тессалон', 'Thessalon', 'ON', 'p0p1y0', '46.2500', '-83.5500');
INSERT INTO `net_city` VALUES ('26217', '13', 'Кунео', 'Cuneo', '12', '', '44.3833', '7.5333');
INSERT INTO `net_city` VALUES ('26225', '24', 'Кабано', 'Cabano', 'QC', 'g0l1e0', '47.6801', '-68.8826');
INSERT INTO `net_city` VALUES ('26309', '24', 'Сен-Лоран', 'Saint-laurent', 'MB', 'h4s1a8', '50.4167', '-97.9500');
INSERT INTO `net_city` VALUES ('26381', '23', 'Бритт', 'Britt', 'IA', '50423', '43.1324', '-93.8129');
INSERT INTO `net_city` VALUES ('26382', '23', 'Аллертон', 'Allerton', 'IA', '50008', '40.6671', '-93.3842');
INSERT INTO `net_city` VALUES ('26384', '23', 'Глидден', 'Glidden', 'IA', '51443', '42.0801', '-94.7044');
INSERT INTO `net_city` VALUES ('26418', '23', 'Бурбон', 'Bourbon', 'MO', '65441', '38.0963', '-91.1710');
INSERT INTO `net_city` VALUES ('26423', '24', 'Листер', 'Lyster', 'QC', 'g0s1v0', '46.3667', '-71.6167');
INSERT INTO `net_city` VALUES ('26425', '24', 'Уитчерч-Стоаффвилл', 'Whitchurch-stouffville', 'ON', 'l0h1g0', '43.9667', '-79.2500');
INSERT INTO `net_city` VALUES ('26427', '23', 'Игл Бридж', 'Eagle Bridge', 'NY', '12057', '42.9681', '-73.3524');
INSERT INTO `net_city` VALUES ('26428', '23', 'Ла Порт Сити', 'La Porte City', 'IA', '50651', '42.3050', '-92.2062');
INSERT INTO `net_city` VALUES ('26429', '23', 'Уэверли', 'Waverly', 'TN', '37185', '36.0298', '-87.8195');
INSERT INTO `net_city` VALUES ('26432', '23', 'Ломайра', 'Lomira', 'WI', '53048', '43.5865', '-88.4512');
INSERT INTO `net_city` VALUES ('26433', '23', 'Три Лейкс', 'Three Lakes', 'WI', '54562', '45.8136', '-89.0924');
INSERT INTO `net_city` VALUES ('26435', '23', 'Хеленвилл', 'Helenville', 'WI', '53137', '43.0033', '-88.6571');
INSERT INTO `net_city` VALUES ('26436', '23', 'Роско', 'Roscoe', 'IL', '61073', '42.4257', '-88.9878');
INSERT INTO `net_city` VALUES ('26437', '23', 'Броко', 'Brokaw', 'WI', '54417', '45.0272', '-89.6532');
INSERT INTO `net_city` VALUES ('26441', '23', 'Уиннебаго', 'Winnebago', 'IL', '61088', '42.2752', '-89.2711');
INSERT INTO `net_city` VALUES ('26448', '23', 'Глидден', 'Glidden', 'WI', '54527', '46.1215', '-90.6761');
INSERT INTO `net_city` VALUES ('26451', '23', 'Фентон', 'Fenton', 'IA', '50539', '43.2503', '-94.4327');
INSERT INTO `net_city` VALUES ('26464', '23', 'Камано Айленд', 'Camano Island', 'WA', '98282', '48.1625', '-122.4954');
INSERT INTO `net_city` VALUES ('26470', '23', 'Хелотс', 'Helotes', 'TX', '78023', '29.6322', '-98.7606');
INSERT INTO `net_city` VALUES ('26474', '109', 'Кютахья ', 'Kütahya', '43', '', '39.4242', '29.9833');
INSERT INTO `net_city` VALUES ('26482', '23', 'Бландинг', 'Blanding', 'UT', '84511', '37.5521', '-109.4821');
INSERT INTO `net_city` VALUES ('26486', '24', 'Киндерсли', 'Kindersley', 'SK', 's0l1s0', '51.4667', '-109.1333');
INSERT INTO `net_city` VALUES ('26488', '23', 'Террил', 'Terril', 'IA', '51364', '43.2918', '-94.9645');
INSERT INTO `net_city` VALUES ('26495', '23', 'Лонгбот Ки', 'Longboat Key', 'FL', '34228', '27.3853', '-82.6368');
INSERT INTO `net_city` VALUES ('26496', '23', 'Бомонт', 'Beaumont', 'CA', '92223', '33.9494', '-116.9775');
INSERT INTO `net_city` VALUES ('26508', '24', 'Беканкур', 'Becancour', 'QC', 'g0x1b0', '46.3443', '-72.4326');
INSERT INTO `net_city` VALUES ('26544', '24', 'Маркдейл', 'Markdale', 'ON', 'n0c1h0', '44.3167', '-80.6500');
INSERT INTO `net_city` VALUES ('26585', '23', 'Луненберг', 'Lunenburg', 'VT', '05906', '44.4701', '-71.7010');
INSERT INTO `net_city` VALUES ('26586', '23', 'Хорс Бранч', 'Horse Branch', 'KY', '42349', '37.4266', '-86.6730');
INSERT INTO `net_city` VALUES ('26587', '23', 'Прейриберг', 'Prairieburg', 'IA', '52219', '42.2383', '-91.4224');
INSERT INTO `net_city` VALUES ('26588', '23', 'Чуалар', 'Chualar', 'CA', '93925', '36.5725', '-121.4448');
INSERT INTO `net_city` VALUES ('26590', '23', 'Аллисон', 'Allison', 'IA', '50602', '42.7449', '-92.8318');
INSERT INTO `net_city` VALUES ('26594', '23', 'Бакстер', 'Baxter', 'IA', '50028', '41.8176', '-93.1529');
INSERT INTO `net_city` VALUES ('26596', '23', 'Бойден', 'Boyden', 'IA', '51234', '43.1893', '-96.0143');
INSERT INTO `net_city` VALUES ('26605', '33', 'Зволле', 'Zwolle', '15', '', '52.5058', '6.0858');
INSERT INTO `net_city` VALUES ('26606', '23', 'Галлоуэй', 'Galloway', 'NJ', '08241', '39.5281', '-74.4822');
INSERT INTO `net_city` VALUES ('26648', '48', 'Крайстчёрч', 'Christchurch', '00', '', '-43.5333', '172.6333');
INSERT INTO `net_city` VALUES ('26653', '24', 'Херон Бэй', 'Heron Bay', 'ON', 'p0t1r0', '48.6500', '-86.2833');
INSERT INTO `net_city` VALUES ('26655', '23', 'Кларкстон', 'Clarkston', 'WA', '99403', '46.3690', '-117.2288');
INSERT INTO `net_city` VALUES ('26656', '23', 'Цилла', 'Zillah', 'WA', '98953', '46.4121', '-120.2340');
INSERT INTO `net_city` VALUES ('26667', '23', 'Аптон', 'Upton', 'MA', '01568', '42.1761', '-71.6000');
INSERT INTO `net_city` VALUES ('26669', '23', 'Рейнир', 'Rainier', 'WA', '98576', '46.8753', '-122.6689');
INSERT INTO `net_city` VALUES ('26694', '23', 'Уиллоу Хилл', 'Willow Hill', 'PA', '17271', '40.0993', '-77.8179');
INSERT INTO `net_city` VALUES ('26695', '23', 'Биглервилл', 'Biglerville', 'PA', '17307', '39.9492', '-77.3250');
INSERT INTO `net_city` VALUES ('26698', '23', 'Йорк Хейвен', 'York Haven', 'PA', '17370', '40.1219', '-76.7809');
INSERT INTO `net_city` VALUES ('26706', '23', 'Чама', 'Chama', 'NM', '87520', '36.8680', '-106.6119');
INSERT INTO `net_city` VALUES ('26786', '23', 'Боулдер Сити', 'Boulder City', 'NV', '89005', '35.9168', '-114.8013');
INSERT INTO `net_city` VALUES ('26791', '23', 'Уэст Суонзей', 'West Swanzey', 'NH', '03469', '42.8734', '-72.3151');
INSERT INTO `net_city` VALUES ('26792', '23', 'Стандиш', 'Standish', 'ME', '04084', '43.7667', '-70.5559');
INSERT INTO `net_city` VALUES ('26793', '23', 'Марлоу', 'Marlow', 'NH', '03456', '43.1265', '-72.2145');
INSERT INTO `net_city` VALUES ('26800', '23', 'Уэймут', 'Weymouth', 'MA', '02188', '42.2068', '-70.9552');
INSERT INTO `net_city` VALUES ('26803', '23', 'Саут Парис', 'South Paris', 'ME', '04281', '44.2438', '-70.4905');
INSERT INTO `net_city` VALUES ('26804', '23', 'Форт Эдуард', 'Fort Edward', 'NY', '12828', '43.2516', '-73.5351');
INSERT INTO `net_city` VALUES ('26805', '23', 'Манор', 'Manor', 'TX', '78653', '30.3419', '-97.5328');
INSERT INTO `net_city` VALUES ('26808', '23', 'Хаддэм', 'Haddam', 'CT', '06438', '41.4602', '-72.5006');
INSERT INTO `net_city` VALUES ('26809', '24', 'Саттон', 'Sutton', 'QC', 'j0e2k0', '45.1102', '-72.6166');
INSERT INTO `net_city` VALUES ('26811', '24', 'Карлайл', 'Carlyle', 'SK', 's0c0r0', '49.6333', '-102.2667');
INSERT INTO `net_city` VALUES ('26814', '23', 'Уэст Бойлстон', 'West Boylston', 'MA', '01583', '42.3638', '-71.7749');
INSERT INTO `net_city` VALUES ('26823', '23', 'Ист Брукфилд', 'East Brookfield', 'MA', '01515', '42.2073', '-72.0488');
INSERT INTO `net_city` VALUES ('26824', '23', 'Норт Хамптон', 'North Hampton', 'NH', '03862', '42.9797', '-70.8287');
INSERT INTO `net_city` VALUES ('26826', '23', 'Эруэй Хайтс', 'Airway Heights', 'WA', '99001', '47.6446', '-117.5933');
INSERT INTO `net_city` VALUES ('26833', '23', 'Роули', 'Rowley', 'MA', '01969', '42.7177', '-70.8957');
INSERT INTO `net_city` VALUES ('26838', '23', 'Омар', 'Omar', 'WV', '25638', '37.7283', '-82.0400');
INSERT INTO `net_city` VALUES ('26839', '23', 'Прейри дю Чиен', 'Prairie du Chien', 'WI', '53821', '43.0600', '-91.0568');
INSERT INTO `net_city` VALUES ('26864', '33', 'Холтен', 'Holten', '15', '', '52.2834', '6.4252');
INSERT INTO `net_city` VALUES ('26870', '23', 'Карролтон', 'Carrollton', 'MO', '64633', '39.3777', '-93.4775');
INSERT INTO `net_city` VALUES ('26873', '23', 'Эфленд', 'Efland', 'NC', '27243', '36.0664', '-79.1969');
INSERT INTO `net_city` VALUES ('26877', '23', 'Ньюленд', 'Newland', 'NC', '28657', '36.0277', '-81.8827');
INSERT INTO `net_city` VALUES ('26885', '23', 'Галена Парк', 'Galena Park', 'TX', '77547', '29.7334', '-95.2339');
INSERT INTO `net_city` VALUES ('26892', '23', 'Адкинс', 'Adkins', 'TX', '78101', '29.3412', '-98.2343');
INSERT INTO `net_city` VALUES ('26897', '23', 'Литл', 'Lytle', 'TX', '78052', '29.2012', '-98.7712');
INSERT INTO `net_city` VALUES ('26899', '23', 'Джастин', 'Justin', 'TX', '76247', '33.0945', '-97.3118');
INSERT INTO `net_city` VALUES ('26910', '24', 'Гор Бэй', 'Gore Bay', 'ON', 'p0p1h0', '45.9167', '-82.4667');
INSERT INTO `net_city` VALUES ('26920', '23', 'Айдахо Сити', 'Idaho City', 'ID', '83631', '43.8990', '-115.7684');
INSERT INTO `net_city` VALUES ('26924', '23', 'Мартасвилл', 'Marthasville', 'MO', '63357', '38.6468', '-91.1265');
INSERT INTO `net_city` VALUES ('26925', '48', 'Веллингтон', 'Wellington', '00', '', '-41.3000', '174.7833');
INSERT INTO `net_city` VALUES ('26931', '23', 'Начес', 'Naches', 'WA', '98937', '46.7863', '-120.8798');
INSERT INTO `net_city` VALUES ('26946', '24', 'Дандерн', 'Dundurn', 'SK', 's0k0y0', '51.8000', '-106.5000');
INSERT INTO `net_city` VALUES ('26947', '24', 'Аллан', 'Allan', 'SK', 's0k0c0', '51.9000', '-106.0667');
INSERT INTO `net_city` VALUES ('26951', '24', 'Уорман', 'Warman', 'SK', 's0k4s0', '52.3167', '-106.5667');
INSERT INTO `net_city` VALUES ('26953', '24', 'Медоу Лейк', 'Meadow Lake', 'SK', 's9x1e6', '54.1297', '-108.4347');
INSERT INTO `net_city` VALUES ('26958', '24', 'Ханли', 'Hanley', 'SK', 's0g2e0', '51.6167', '-106.4333');
INSERT INTO `net_city` VALUES ('26963', '24', 'Розтаун', 'Rosetown', 'SK', 's0l2v0', '51.5500', '-107.9833');
INSERT INTO `net_city` VALUES ('26992', '24', 'Эстон', 'Eston', 'SK', 's0l1a0', '51.1500', '-108.7500');
INSERT INTO `net_city` VALUES ('27000', '24', 'Уилки', 'Wilkie', 'SK', 's0k4w0', '52.4167', '-108.7000');
INSERT INTO `net_city` VALUES ('27005', '24', 'Кабри', 'Cabri', 'SK', 's0n0j0', '50.6167', '-108.4500');
INSERT INTO `net_city` VALUES ('27008', '24', 'Сомбра', 'Sombra', 'ON', 'n0n1h0', '42.7119', '-82.4723');
INSERT INTO `net_city` VALUES ('27038', '24', 'Вирден', 'Virden', 'MB', 'r0m2c0', '49.8500', '-100.9333');
INSERT INTO `net_city` VALUES ('27039', '24', 'Ассинибоия', 'Assiniboia', 'SK', 's0h0b0', '49.6167', '-105.9833');
INSERT INTO `net_city` VALUES ('27040', '24', 'Уайтвуд', 'Whitewood', 'SK', 's0g5c0', '50.3333', '-102.2500');
INSERT INTO `net_city` VALUES ('27044', '23', 'Пинсон', 'Pinson', 'AL', '35126', '33.7289', '-86.6485');
INSERT INTO `net_city` VALUES ('27045', '1', 'Парраматта', 'Parramatta', '02', '', '-33.8167', '151.0000');
INSERT INTO `net_city` VALUES ('27111', '23', 'Вабено', 'Wabeno', 'WI', '54566', '45.4217', '-88.6272');
INSERT INTO `net_city` VALUES ('27115', '23', 'Маунт-Вернон', 'Mount Vernon', 'MO', '65712', '37.1056', '-93.7876');
INSERT INTO `net_city` VALUES ('27120', '24', 'Лабелл', 'Labelle', 'QC', 'j0t1h0', '46.2833', '-74.7333');
INSERT INTO `net_city` VALUES ('27122', '23', 'Бардстаун', 'Bardstown', 'KY', '40004', '37.7905', '-85.4848');
INSERT INTO `net_city` VALUES ('27135', '23', 'Гейтсвилл', 'Gatesville', 'NC', '27938', '36.3818', '-76.7116');
INSERT INTO `net_city` VALUES ('27142', '2', 'Петалинг Джая', 'Petaling Jaya', '14', '', '3.0833', '101.6500');
INSERT INTO `net_city` VALUES ('27145', '23', 'Херманн', 'Hermann', 'MO', '65041', '38.5782', '-91.5047');
INSERT INTO `net_city` VALUES ('27146', '23', 'Берч Три', 'Birch Tree', 'MO', '65438', '36.9404', '-91.5012');
INSERT INTO `net_city` VALUES ('27150', '12', 'Вийёрбанн', 'Villeurbanne', 'B9', '', '45.7655', '4.8755');
INSERT INTO `net_city` VALUES ('27152', '29', 'Любек ', 'Lubeck', '10', '', '53.8667', '10.7000');
INSERT INTO `net_city` VALUES ('27153', '21', 'Ширнесс', 'Sheerness', 'G5', '', '51.4333', '0.7667');
INSERT INTO `net_city` VALUES ('27164', '33', 'Зутермер ', 'Zoetermeer', '11', '', '52.0278', '4.5123');
INSERT INTO `net_city` VALUES ('27167', '29', 'Ратинген', 'Ratingen', '07', '', '51.3000', '6.8500');
INSERT INTO `net_city` VALUES ('27168', '15', 'Нючёпинг', 'Nykoping', '18', '', '58.7500', '17.0000');
INSERT INTO `net_city` VALUES ('27169', '125', 'Аскер', 'Asker', '01', '', '59.8333', '10.4333');
INSERT INTO `net_city` VALUES ('27170', '33', 'Бладел', 'Bladel', '06', '', '51.3692', '5.2189');
INSERT INTO `net_city` VALUES ('27172', '5', 'Вакаяма', 'Wakayama', '43', '', '34.2261', '135.1675');
INSERT INTO `net_city` VALUES ('27174', '12', 'Страсбург ', 'Strasbourg', 'C1', '', '48.6004', '7.7874');
INSERT INTO `net_city` VALUES ('27176', '48', 'Окленд', 'Auckland', '00', '', '-36.8667', '174.7667');
INSERT INTO `net_city` VALUES ('27177', '22', 'Вайле', 'Vejle', '13', '', '55.7000', '9.5333');
INSERT INTO `net_city` VALUES ('27178', '58', 'Контажен', 'Contagem', '15', '', '-19.9167', '-44.1000');
INSERT INTO `net_city` VALUES ('27179', '12', 'Нантер', 'Nanterre', 'A8', '', '48.8914', '2.2003');
INSERT INTO `net_city` VALUES ('27182', '33', 'Амстелвен', 'Amstelveen', '07', '', '52.3107', '4.8768');
INSERT INTO `net_city` VALUES ('27183', '23', 'Хоп Халл', 'Hope Hull', 'AL', '36043', '32.1854', '-86.3665');
INSERT INTO `net_city` VALUES ('27184', '21', 'Уоркинг', 'Woking', 'N7', '', '51.3167', '-0.5333');
INSERT INTO `net_city` VALUES ('27187', '56', 'Локерен', 'Lokeren', '08', '', '51.1000', '3.9833');
INSERT INTO `net_city` VALUES ('27189', '55', 'Донегол', 'Donegal', '06', '', '54.6500', '-8.1167');
INSERT INTO `net_city` VALUES ('27190', '58', 'Манаус', 'Manaus', '04', '', '-3.1133', '-60.0253');
INSERT INTO `net_city` VALUES ('27191', '29', 'Бад-Зоден', 'Bad Soden', '05', '', '50.1333', '8.5000');
INSERT INTO `net_city` VALUES ('27194', '59', 'Лойфельфинген', 'Laufelfingen', '01', '', '47.4000', '7.8500');
INSERT INTO `net_city` VALUES ('27195', '33', 'Апелдорн', 'Apeldoorn', '03', '', '52.2167', '5.9667');
INSERT INTO `net_city` VALUES ('27197', '23', 'Уинтер Парк', 'Winter Park', 'CO', '80482', '39.8916', '-105.7631');
INSERT INTO `net_city` VALUES ('27204', '23', 'Форестхилл', 'Foresthill', 'CA', '95631', '39.0361', '-120.8291');
INSERT INTO `net_city` VALUES ('27206', '23', 'Тахома', 'Tahoma', 'CA', '96142', '39.0252', '-120.1421');
INSERT INTO `net_city` VALUES ('27230', '23', 'Саттер Крик', 'Sutter Creek', 'CA', '95685', '38.4297', '-120.7551');
INSERT INTO `net_city` VALUES ('27234', '23', 'Санленд', 'Sunland', 'CA', '91040', '34.2686', '-118.3295');
INSERT INTO `net_city` VALUES ('27235', '23', 'Клайо', 'Clyo', 'GA', '31303', '32.5022', '-81.3147');
INSERT INTO `net_city` VALUES ('27236', '23', 'Ошено', 'Oceano', 'CA', '93445', '35.0688', '-120.6092');
INSERT INTO `net_city` VALUES ('27245', '23', 'Хафман', 'Huffman', 'TX', '77336', '30.0698', '-95.1105');
INSERT INTO `net_city` VALUES ('27246', '23', 'Дель Валле', 'Del Valle', 'TX', '78617', '30.1518', '-97.5904');
INSERT INTO `net_city` VALUES ('27249', '21', 'Ноттингем', 'Nottingham', 'J8', '', '52.9667', '-1.1667');
INSERT INTO `net_city` VALUES ('27269', '23', 'Лонг Бич', 'Long Beach', 'WA', '98631', '46.3952', '-124.0377');
INSERT INTO `net_city` VALUES ('27273', '35', 'Фуэнлабрада', 'Fuenlabrada', '29', '', '40.2842', '-3.7941');
INSERT INTO `net_city` VALUES ('27282', '24', 'Порт Перри', 'Port Perry', 'ON', 'l9l1b3', '44.1000', '-78.9333');
INSERT INTO `net_city` VALUES ('27291', '21', 'Алдершот', 'Aldershot', 'F2', '', '51.2500', '-0.7667');
INSERT INTO `net_city` VALUES ('27296', '24', 'Сандридж', 'Sundridge', 'ON', 'p0a1z0', '45.7667', '-79.4000');
INSERT INTO `net_city` VALUES ('27304', '24', 'Тивертон', 'Tiverton', 'ON', 'n0g2t0', '44.2700', '-81.5400');
INSERT INTO `net_city` VALUES ('27316', '23', 'Уайкомб', 'Wycombe', 'PA', '18980', '40.2823', '-75.0188');
INSERT INTO `net_city` VALUES ('27317', '23', 'Лотиан', 'Lothian', 'MD', '20711', '38.8011', '-76.6469');
INSERT INTO `net_city` VALUES ('27319', '23', 'Анджел Файер', 'Angel Fire', 'NM', '87710', '36.3931', '-105.2850');
INSERT INTO `net_city` VALUES ('27321', '23', 'Севилл', 'Seville', 'OH', '44273', '41.0250', '-81.8863');
INSERT INTO `net_city` VALUES ('27330', '23', 'Эверсон', 'Everson', 'WA', '98247', '48.9001', '-122.3057');
INSERT INTO `net_city` VALUES ('27331', '23', 'Аткинсон', 'Atkinson', 'NH', '03811', '42.8371', '-71.1599');
INSERT INTO `net_city` VALUES ('27340', '23', 'Лоло', 'Lolo', 'MT', '59847', '46.7326', '-114.3599');
INSERT INTO `net_city` VALUES ('27341', '23', 'Лагуна', 'Laguna', 'NM', '87026', '35.0876', '-107.2431');
INSERT INTO `net_city` VALUES ('27342', '23', 'Корралес', 'Corrales', 'NM', '87048', '35.2393', '-106.6255');
INSERT INTO `net_city` VALUES ('27344', '23', 'Истфорд', 'Eastford', 'CT', '06242', '41.9018', '-72.1007');
INSERT INTO `net_city` VALUES ('27347', '23', 'Литчфилд Парк', 'Litchfield Park', 'AZ', '85340', '33.5178', '-112.3667');
INSERT INTO `net_city` VALUES ('27349', '23', 'Гошен', 'Goshen', 'CT', '06756', '41.8489', '-73.2358');
INSERT INTO `net_city` VALUES ('27350', '23', 'Гранби', 'Granby', 'CT', '06035', '41.9597', '-72.7961');
INSERT INTO `net_city` VALUES ('27362', '23', 'Скотленд', 'Scotland', 'CT', '06264', '41.6938', '-72.0971');
INSERT INTO `net_city` VALUES ('27366', '23', 'Чемберлен', 'Chamberlain', 'SD', '57325', '43.7887', '-99.3140');
INSERT INTO `net_city` VALUES ('27368', '23', 'Монте Виста', 'Monte Vista', 'CO', '81144', '37.5602', '-106.1392');
INSERT INTO `net_city` VALUES ('27374', '23', 'Пенроуз', 'Penrose', 'CO', '81240', '38.4960', '-105.0535');
INSERT INTO `net_city` VALUES ('27385', '23', 'Берналильо', 'Bernalillo', 'NM', '87004', '35.3488', '-106.5586');
INSERT INTO `net_city` VALUES ('27388', '23', 'Уорм Спрингс', 'Warm Springs', 'OR', '97761', '44.8237', '-121.3155');
INSERT INTO `net_city` VALUES ('27389', '23', 'Уоррентон', 'Warrenton', 'OR', '97146', '46.1221', '-123.9098');
INSERT INTO `net_city` VALUES ('27393', '23', 'Басолт', 'Basalt', 'CO', '81621', '39.3584', '-107.0539');
INSERT INTO `net_city` VALUES ('27429', '24', 'Лакноу', 'Lucknow', 'ON', 'n0g2h0', '43.9600', '-81.5125');
INSERT INTO `net_city` VALUES ('27437', '23', 'Эль Прадо', 'El Prado', 'NM', '87529', '36.4635', '-105.6128');
INSERT INTO `net_city` VALUES ('27439', '23', 'Кэннон Бич', 'Cannon Beach', 'OR', '97110', '45.8918', '-123.9615');
INSERT INTO `net_city` VALUES ('27442', '23', 'Форкс', 'Forks', 'WA', '98331', '47.7948', '-124.2643');
INSERT INTO `net_city` VALUES ('27447', '23', 'Уинлок', 'Winlock', 'WA', '98596', '46.4895', '-122.8781');
INSERT INTO `net_city` VALUES ('27459', '23', 'Клонтарф', 'Clontarf', 'MN', '56226', '45.3981', '-95.6754');
INSERT INTO `net_city` VALUES ('27468', '24', 'Макгрегор', 'Macgregor', 'MB', 'r0h0r0', '49.9667', '-98.7667');
INSERT INTO `net_city` VALUES ('27490', '23', 'Тони', 'Tony', 'WI', '54563', '45.4570', '-90.9718');
INSERT INTO `net_city` VALUES ('27492', '23', 'Меллен', 'Mellen', 'WI', '54546', '46.2536', '-90.7280');
INSERT INTO `net_city` VALUES ('27493', '23', 'Холмен', 'Holmen', 'WI', '54636', '44.0069', '-91.2272');
INSERT INTO `net_city` VALUES ('27494', '23', 'Парк Фолс', 'Park Falls', 'WI', '54552', '45.9242', '-90.3265');
INSERT INTO `net_city` VALUES ('27502', '23', 'Касивилл', 'Caseyville', 'IL', '62232', '38.6303', '-90.0121');
INSERT INTO `net_city` VALUES ('27504', '23', 'Элсберри', 'Elsberry', 'MO', '63343', '39.1614', '-90.8388');
INSERT INTO `net_city` VALUES ('27505', '23', 'Эдвардс', 'Edwards', 'MO', '65326', '38.1658', '-93.1716');
INSERT INTO `net_city` VALUES ('27510', '23', 'Хатчешубби', 'Hatchechubbee', 'AL', '36858', '32.3011', '-85.3180');
INSERT INTO `net_city` VALUES ('27517', '23', 'Маунт Гамильтон', 'Mount Hamilton', 'CA', '95140', '37.3679', '-121.6741');
INSERT INTO `net_city` VALUES ('27519', '34', 'Тверия', 'Tiberias', '03', '', '32.7922', '35.5312');
INSERT INTO `net_city` VALUES ('27520', '34', 'Ашдод', 'Ashdod', '01', '', '31.7361', '34.6559');
INSERT INTO `net_city` VALUES ('27533', '23', 'Террелл', 'Terrell', 'TX', '75160', '32.7516', '-96.2857');
INSERT INTO `net_city` VALUES ('27536', '23', 'Селеста', 'Celeste', 'TX', '75423', '33.2941', '-96.1939');
INSERT INTO `net_city` VALUES ('27542', '23', 'Том Бин', 'Tom Bean', 'TX', '75489', '33.5201', '-96.4839');
INSERT INTO `net_city` VALUES ('27544', '23', 'Потсборо', 'Pottsboro', 'TX', '75076', '33.8157', '-96.7156');
INSERT INTO `net_city` VALUES ('27546', '23', 'Додд Сити', 'Dodd City', 'TX', '75438', '33.6045', '-96.0633');
INSERT INTO `net_city` VALUES ('27547', '23', 'Кэмпбелл', 'Campbell', 'TX', '75422', '33.1279', '-95.9342');
INSERT INTO `net_city` VALUES ('27549', '23', 'Мейперл', 'Maypearl', 'TX', '76064', '32.3130', '-97.0224');
INSERT INTO `net_city` VALUES ('27551', '23', 'Мабанк', 'Mabank', 'TX', '75147', '32.4472', '-96.0746');
INSERT INTO `net_city` VALUES ('27552', '23', 'Уайтрайт', 'Whitewright', 'TX', '75491', '33.4865', '-96.3923');
INSERT INTO `net_city` VALUES ('27554', '23', 'Вулф Сити', 'Wolfe City', 'TX', '75496', '33.3523', '-96.0539');
INSERT INTO `net_city` VALUES ('27561', '23', 'Мелисса', 'Melissa', 'TX', '75454', '33.2747', '-96.5532');
INSERT INTO `net_city` VALUES ('27563', '1', 'Паддингтон', 'Paddington', '08', '', '-30.4833', '121.3333');
INSERT INTO `net_city` VALUES ('27566', '23', 'Комфорт', 'Comfort', 'TX', '78013', '29.9771', '-98.8798');
INSERT INTO `net_city` VALUES ('27610', '24', 'Мадок', 'Madoc', 'ON', 'l0m1s0', '44.5167', '-77.4833');
INSERT INTO `net_city` VALUES ('27668', '24', 'Атле', 'Hatley', 'QC', 'j0b3h0', '45.2833', '-71.8833');
INSERT INTO `net_city` VALUES ('27731', '24', 'Милхейвен', 'Millhaven', 'ON', 'k7m6j1', '44.2000', '-76.7500');
INSERT INTO `net_city` VALUES ('27811', '121', 'Варна', 'Varna', '61', '', '43.2167', '27.9167');
INSERT INTO `net_city` VALUES ('27812', '128', 'Тирана', 'Tirana', '50', '', '41.3275', '19.8189');
INSERT INTO `net_city` VALUES ('27813', '141', 'Сараево', 'Sarajevo', '01', '', '43.8500', '18.3833');
INSERT INTO `net_city` VALUES ('27814', '123', 'Яссы', 'Iasi', '23', '', '47.1667', '27.6000');
INSERT INTO `net_city` VALUES ('27831', '23', 'Веста', 'Vesta', 'MN', '56292', '44.4923', '-95.4526');
INSERT INTO `net_city` VALUES ('27832', '23', 'Милтаун', 'Milltown', 'MT', '59851', '46.8713', '-113.8818');
INSERT INTO `net_city` VALUES ('27837', '23', 'Тайер', 'Thayer', 'MO', '65791', '36.5800', '-91.3875');
INSERT INTO `net_city` VALUES ('27838', '23', 'Хартвилл', 'Hartville', 'MO', '65667', '37.3226', '-92.5270');
INSERT INTO `net_city` VALUES ('27839', '23', 'Саркокси', 'Sarcoxie', 'MO', '64862', '37.1388', '-94.0701');
INSERT INTO `net_city` VALUES ('27841', '24', 'Эстеван', 'Estevan', 'SK', 's4a2a5', '49.1500', '-103.0000');
INSERT INTO `net_city` VALUES ('27852', '23', 'Селигман', 'Seligman', 'AZ', '86337', '35.1360', '-112.9904');
INSERT INTO `net_city` VALUES ('27855', '23', 'Грин', 'Green', 'OH', '44232', '40.9459', '-81.4832');
INSERT INTO `net_city` VALUES ('27856', '23', 'Эстеро', 'Estero', 'FL', '33928', '26.3997', '-81.7011');
INSERT INTO `net_city` VALUES ('27859', '23', 'Аш Форк', 'Ash Fork', 'AZ', '86320', '35.1307', '-112.5227');
INSERT INTO `net_city` VALUES ('27870', '23', 'Сартелл', 'Sartell', 'MN', '56377', '45.6393', '-94.2237');
INSERT INTO `net_city` VALUES ('27874', '23', 'Кахока', 'Kahoka', 'MO', '63445', '40.4067', '-91.7345');
INSERT INTO `net_city` VALUES ('27880', '24', 'Годерич', 'Goderich', 'ON', 'n7a3x8', '43.7420', '-81.7115');
INSERT INTO `net_city` VALUES ('27898', '23', 'Полк Сити', 'Polk City', 'IA', '50226', '41.7874', '-93.7171');
INSERT INTO `net_city` VALUES ('27907', '23', 'Лестер', 'Leicester', 'NC', '28748', '35.6513', '-82.7659');
INSERT INTO `net_city` VALUES ('27910', '23', 'Кламат Ривер', 'Klamath River', 'CA', '96050', '41.8326', '-122.9205');
INSERT INTO `net_city` VALUES ('27921', '23', 'Касселтон', 'Casselton', 'ND', '58012', '46.9412', '-97.1774');
INSERT INTO `net_city` VALUES ('27922', '23', 'Минто', 'Minto', 'ND', '58261', '48.2233', '-97.3135');
INSERT INTO `net_city` VALUES ('27980', '24', 'Маклин', 'Macklin', 'SK', 's0l2c0', '52.3333', '-109.9500');
INSERT INTO `net_city` VALUES ('27995', '23', 'Пайн', 'Pine', 'AZ', '85544', '34.3249', '-111.5487');
INSERT INTO `net_city` VALUES ('28002', '23', 'Грей Маунтин', 'Gray Mountain', 'AZ', '86016', '35.7469', '-111.4749');
INSERT INTO `net_city` VALUES ('28011', '23', 'Одубон', 'Audubon', 'IA', '50025', '41.7396', '-94.8994');
INSERT INTO `net_city` VALUES ('28012', '23', 'Суонсборо', 'Swansboro', 'NC', '28584', '34.7380', '-77.0803');
INSERT INTO `net_city` VALUES ('28016', '23', 'Хинсдейл', 'Hinsdale', 'NH', '03451', '42.7924', '-72.5022');
INSERT INTO `net_city` VALUES ('28017', '23', 'Уотервилл Валли', 'Waterville Valley', 'NH', '03215', '43.9501', '-71.4995');
INSERT INTO `net_city` VALUES ('28026', '23', 'Инвернесс', 'Inverness', 'FL', '34450', '28.8213', '-82.2613');
INSERT INTO `net_city` VALUES ('28033', '23', 'Хартли', 'Hartley', 'IA', '51346', '43.1913', '-95.4568');
INSERT INTO `net_city` VALUES ('28035', '23', 'Хартингтон', 'Hartington', 'NE', '68739', '42.6342', '-97.2408');
INSERT INTO `net_city` VALUES ('28042', '23', 'Фористелл', 'Foristell', 'MO', '63348', '38.7732', '-90.9348');
INSERT INTO `net_city` VALUES ('28043', '23', 'Хай Хилл', 'High Hill', 'MO', '63350', '38.8970', '-91.3623');
INSERT INTO `net_city` VALUES ('28053', '23', 'Хебер', 'Heber City', 'UT', '84032', '40.4363', '-111.1946');
INSERT INTO `net_city` VALUES ('28055', '23', 'Санапи', 'Sunapee', 'NH', '03782', '43.3948', '-72.0926');
INSERT INTO `net_city` VALUES ('28089', '24', 'Лак Ла Бич', 'Lac La Biche', 'AB', 't0a2c0', '54.7719', '-111.9647');
INSERT INTO `net_city` VALUES ('28152', '23', 'Дель Норт', 'Del Norte', 'CO', '81132', '37.7091', '-106.4282');
INSERT INTO `net_city` VALUES ('28154', '23', 'Гиллетт', 'Gillett', 'WI', '54124', '44.9134', '-88.3577');
INSERT INTO `net_city` VALUES ('28158', '23', 'Колмен', 'Coleman', 'WI', '54112', '45.0415', '-88.0431');
INSERT INTO `net_city` VALUES ('28314', '23', 'Сантакин', 'Santaquin', 'UT', '84655', '39.9976', '-111.8142');
INSERT INTO `net_city` VALUES ('28318', '24', 'Бертьервиль', 'Berthierville', 'QC', 'j0k1a0', '46.0830', '-73.1800');
INSERT INTO `net_city` VALUES ('28327', '24', 'Сен-Зотик', 'Saint-Zotique', 'QC', 'j0p1z0', '45.2455', '-74.2481');
INSERT INTO `net_city` VALUES ('28374', '23', 'Найтдейл', 'Knightdale', 'NC', '27545', '35.7912', '-78.4811');
INSERT INTO `net_city` VALUES ('28375', '23', 'Биско', 'Biscoe', 'NC', '27209', '35.3446', '-79.7592');
INSERT INTO `net_city` VALUES ('28376', '23', 'Кейв Крик', 'Cave Creek', 'AZ', '85331', '33.8045', '-111.9317');
INSERT INTO `net_city` VALUES ('28377', '23', 'Уорренсвилл', 'Warrensville', 'NC', '28693', '36.4623', '-81.5547');
INSERT INTO `net_city` VALUES ('28386', '23', 'Мори', 'Maury', 'NC', '28554', '35.4821', '-77.5861');
INSERT INTO `net_city` VALUES ('28388', '23', 'Росман', 'Rosman', 'NC', '28772', '35.1316', '-82.8488');
INSERT INTO `net_city` VALUES ('28398', '23', 'Бакстон', 'Buxton', 'NC', '27920', '35.2677', '-75.5424');
INSERT INTO `net_city` VALUES ('28400', '24', 'Лоу', 'Low', 'QC', 'j0x2c0', '45.8108', '-75.9493');
INSERT INTO `net_city` VALUES ('28403', '23', 'Ванчес', 'Wanchese', 'NC', '27981', '35.8568', '-75.6387');
INSERT INTO `net_city` VALUES ('28404', '23', 'Фасги Форест', 'Pisgah Forest', 'NC', '28768', '35.2754', '-82.6909');
INSERT INTO `net_city` VALUES ('28407', '23', 'Коннеллис Спрингс', 'Connellys Springs', 'NC', '28612', '35.6711', '-81.5106');
INSERT INTO `net_city` VALUES ('28408', '23', 'Блоуинг Рок', 'Blowing Rock', 'NC', '28605', '36.1368', '-81.7168');
INSERT INTO `net_city` VALUES ('28415', '23', 'Клайд', 'Clyde', 'NC', '28721', '35.6497', '-82.9789');
INSERT INTO `net_city` VALUES ('28417', '23', 'Хармон', 'Harmon', 'IL', '61042', '41.6963', '-89.5404');
INSERT INTO `net_city` VALUES ('28421', '23', 'Дельфос', 'Delphos', 'OH', '45833', '40.8415', '-84.3596');
INSERT INTO `net_city` VALUES ('28430', '23', 'Конто', 'Conetoe', 'NC', '27819', '35.8157', '-77.4558');
INSERT INTO `net_city` VALUES ('28435', '23', 'Фриберг', 'Freeburg', 'MO', '65035', '38.3747', '-91.9447');
INSERT INTO `net_city` VALUES ('28437', '25', 'Нуэво Ларедо', 'Nuevo Laredo', '28', '', '27.5000', '-99.5167');
INSERT INTO `net_city` VALUES ('28439', '23', 'Посивилл', 'Poseyville', 'IN', '47633', '38.1817', '-87.7730');
INSERT INTO `net_city` VALUES ('28440', '23', 'Пайн Ривер', 'Pine River', 'MN', '56474', '46.7242', '-94.4076');
INSERT INTO `net_city` VALUES ('28648', '23', 'Ленуар Сити', 'Lenoir City', 'TN', '37771', '35.8288', '-84.3177');
INSERT INTO `net_city` VALUES ('28651', '23', 'Ньютон Гров', 'Newton Grove', 'NC', '28366', '35.2434', '-78.3630');
INSERT INTO `net_city` VALUES ('28663', '23', 'Ист Киллингли', 'East Killingly', 'CT', '06243', '41.8449', '-71.8189');
INSERT INTO `net_city` VALUES ('28665', '23', 'Риндж', 'Rindge', 'NH', '03461', '42.7528', '-72.0101');
INSERT INTO `net_city` VALUES ('28669', '23', 'Рехобот', 'Rehoboth', 'MA', '02769', '41.8428', '-71.2455');
INSERT INTO `net_city` VALUES ('28673', '23', 'Норт Сайчуат', 'North Scituate', 'MA', '02060', '42.2190', '-70.7856');
INSERT INTO `net_city` VALUES ('28680', '23', 'Халл', 'Hull', 'MA', '02045', '42.2846', '-70.8741');
INSERT INTO `net_city` VALUES ('28684', '23', 'Ист Темплтон', 'East Templeton', 'MA', '01438', '42.5631', '-72.0370');
INSERT INTO `net_city` VALUES ('28721', '24', 'Уитни', 'Whitney', 'ON', 'k0j2m0', '45.5000', '-78.2333');
INSERT INTO `net_city` VALUES ('28724', '24', 'Валь-Давид', 'Val David', 'QC', 'j8c2z8', '46.0333', '-74.2833');
INSERT INTO `net_city` VALUES ('28727', '24', 'Прескотт', 'Prescott', 'ON', 'k0e1t0', '44.7215', '-75.5161');
INSERT INTO `net_city` VALUES ('28861', '24', 'Ливели', 'Lively', 'ON', 'p0m2m0', '46.4333', '-81.1500');
INSERT INTO `net_city` VALUES ('28914', '24', 'Ла Тюк', 'La Tuque', 'QC', 'g9x3p8', '47.4465', '-72.7838');
INSERT INTO `net_city` VALUES ('28951', '23', 'Дечерд', 'Decherd', 'TN', '37324', '35.2499', '-85.9867');
INSERT INTO `net_city` VALUES ('28953', '23', 'Кингстон Спрингс', 'Kingston Springs', 'TN', '37082', '36.1272', '-87.1106');
INSERT INTO `net_city` VALUES ('28956', '23', 'Роквуд', 'Rockwood', 'TN', '37854', '35.8895', '-84.7310');
INSERT INTO `net_city` VALUES ('28961', '23', 'Тулароса', 'Tularosa', 'NM', '88352', '33.1797', '-106.0917');
INSERT INTO `net_city` VALUES ('28963', '23', 'Кроунпойнт', 'Crownpoint', 'NM', '87313', '35.7754', '-108.0346');
INSERT INTO `net_city` VALUES ('28971', '23', 'Брентон', 'Brenton', 'WV', '24818', '37.5880', '-81.6592');
INSERT INTO `net_city` VALUES ('28972', '23', 'Ричвуд', 'Richwood', 'WV', '26261', '38.2058', '-80.5468');
INSERT INTO `net_city` VALUES ('28976', '23', 'Литтл Торч Ки', 'Little Torch Key', 'FL', '33043', '24.6881', '-81.3649');
INSERT INTO `net_city` VALUES ('28980', '23', 'Гленнс Ферри', 'Glenns Ferry', 'ID', '83623', '43.0954', '-115.3768');
INSERT INTO `net_city` VALUES ('28981', '23', 'Хазелтон', 'Hazelton', 'ID', '83335', '42.5866', '-114.0760');
INSERT INTO `net_city` VALUES ('28982', '23', 'Куна', 'Kuna', 'ID', '83634', '43.4375', '-116.3232');
INSERT INTO `net_city` VALUES ('28985', '23', 'Эндерлин', 'Enderlin', 'ND', '58027', '46.6374', '-97.5960');
INSERT INTO `net_city` VALUES ('28986', '23', 'Мак-Колл', 'McCall', 'ID', '83638', '44.8842', '-115.7791');
INSERT INTO `net_city` VALUES ('28987', '23', 'Мидлтон', 'Middleton', 'ID', '83644', '43.7439', '-116.5828');
INSERT INTO `net_city` VALUES ('28988', '23', 'Боннерс Ферри', 'Bonners Ferry', 'ID', '83805', '48.7581', '-116.5110');
INSERT INTO `net_city` VALUES ('28993', '23', 'Хоутон Лейк', 'Houghton Lake', 'MI', '48629', '44.2915', '-84.7340');
INSERT INTO `net_city` VALUES ('28994', '23', 'Онауэй', 'Onaway', 'MI', '49765', '45.3785', '-84.2573');
INSERT INTO `net_city` VALUES ('29000', '23', 'Локуст Гров', 'Locust Grove', 'GA', '30248', '33.3448', '-84.1155');
INSERT INTO `net_city` VALUES ('29011', '21', 'Уиган', 'Wigan', 'P7', '', '53.5333', '-2.6167');
INSERT INTO `net_city` VALUES ('29012', '23', 'Драгун', 'Dragoon', 'AZ', '85609', '32.0281', '-110.0387');
INSERT INTO `net_city` VALUES ('29013', '21', 'Ричмонд ', 'Richmond', 'N7', '', '54.4000', '-1.7333');
INSERT INTO `net_city` VALUES ('29023', '23', 'Холдредж', 'Holdrege', 'NE', '68949', '40.4452', '-99.3649');
INSERT INTO `net_city` VALUES ('29025', '23', 'Дейви', 'Davey', 'NE', '68336', '40.9397', '-96.6721');
INSERT INTO `net_city` VALUES ('29058', '1', 'Пеннант Хилс', 'Pennant Hills', '02', '', '-33.7333', '151.0667');
INSERT INTO `net_city` VALUES ('29060', '23', 'Спалдинг', 'Spalding', 'MI', '49886', '45.6941', '-87.4877');
INSERT INTO `net_city` VALUES ('29065', '21', 'Поттерс-Бар', 'Potters Bar', 'F8', '', '51.6833', '-0.1667');
INSERT INTO `net_city` VALUES ('29068', '23', 'Ла Веркин', 'La Verkin', 'UT', '84745', '37.2724', '-113.1960');
INSERT INTO `net_city` VALUES ('29070', '23', 'Пирблоссом', 'Pearblossom', 'CA', '93553', '34.4876', '-117.8796');
INSERT INTO `net_city` VALUES ('29071', '157', 'Негрил', 'Negril', '16', '', '18.2667', '-78.3500');
INSERT INTO `net_city` VALUES ('29072', '157', 'Очо-Риос', 'Ocho Rios', '09', '', '18.4167', '-77.1167');
INSERT INTO `net_city` VALUES ('29075', '23', 'Скулкрафт', 'Schoolcraft', 'MI', '49087', '42.1331', '-85.6851');
INSERT INTO `net_city` VALUES ('29080', '23', 'Эмералд Айл', 'Emerald Isle', 'NC', '28594', '34.6637', '-77.0431');
INSERT INTO `net_city` VALUES ('29082', '23', 'Линдон', 'Lyndon', 'KS', '66451', '38.5870', '-95.6562');
INSERT INTO `net_city` VALUES ('29083', '23', 'Наанта', 'Nahunta', 'GA', '31553', '31.1584', '-81.9710');
INSERT INTO `net_city` VALUES ('29086', '23', 'Кенбридж', 'Kenbridge', 'VA', '23944', '36.9072', '-78.1528');
INSERT INTO `net_city` VALUES ('29088', '23', 'Катскилл', 'Catskill', 'NY', '12414', '42.2041', '-73.9432');
INSERT INTO `net_city` VALUES ('29091', '23', 'Эль Пасо', 'El Paso', 'IL', '61738', '40.7467', '-89.0254');
INSERT INTO `net_city` VALUES ('29092', '117', 'Никосия', 'Nicosia', '04', '', '35.1667', '33.3667');
INSERT INTO `net_city` VALUES ('29095', '23', 'Ханна', 'Hanna', 'OK', '74845', '35.2602', '-95.8675');
INSERT INTO `net_city` VALUES ('29099', '23', 'Прю', 'Prue', 'OK', '74060', '36.2868', '-96.2720');
INSERT INTO `net_city` VALUES ('29100', '23', 'Фэрленд', 'Fairland', 'OK', '74343', '36.7425', '-94.8317');
INSERT INTO `net_city` VALUES ('29101', '23', 'Квапо', 'Quapaw', 'OK', '74363', '36.9460', '-94.6820');
INSERT INTO `net_city` VALUES ('29108', '21', 'Сандбэч', 'Sandbach', 'C5', '', '53.1333', '-2.3667');
INSERT INTO `net_city` VALUES ('29109', '23', 'Элверта', 'Elverta', 'CA', '95626', '38.7378', '-121.4689');
INSERT INTO `net_city` VALUES ('29115', '21', 'Борнмут', 'Bournemouth', 'B2', '', '50.7167', '-1.8833');
INSERT INTO `net_city` VALUES ('29120', '23', 'Брайтвуд', 'Brightwood', 'VA', '22715', '38.4123', '-78.1710');
INSERT INTO `net_city` VALUES ('29128', '23', 'Овертон', 'Overton', 'NV', '89040', '36.3957', '-114.3784');
INSERT INTO `net_city` VALUES ('29129', '225', 'Таити', 'Tahiti', '00', '', '-17.5333', '-149.5667');
INSERT INTO `net_city` VALUES ('29131', '23', 'Хамптон Фолс', 'Hampton Falls', 'NH', '03844', '42.9319', '-70.8751');
INSERT INTO `net_city` VALUES ('29132', '23', 'Юкон', 'Yukon', 'PA', '15698', '40.2153', '-79.6854');
INSERT INTO `net_city` VALUES ('29135', '23', 'Блу Маундс', 'Blue Mounds', 'WI', '53517', '43.0339', '-89.8449');
INSERT INTO `net_city` VALUES ('29136', '23', 'Ребак', 'Rebuck', 'PA', '17867', '40.7128', '-76.6971');
INSERT INTO `net_city` VALUES ('29139', '23', 'Гринап', 'Greenup', 'IL', '62428', '39.2640', '-88.1195');
INSERT INTO `net_city` VALUES ('29145', '15', 'Сольна', 'Solna', '26', '', '59.3667', '18.0167');
INSERT INTO `net_city` VALUES ('29149', '23', 'Уилкокс', 'Wilcox', 'NE', '68982', '40.2898', '-99.2034');
INSERT INTO `net_city` VALUES ('29152', '23', 'Хант', 'Hunt', 'TX', '78024', '30.0296', '-99.4832');
INSERT INTO `net_city` VALUES ('29154', '23', 'Куорривилл', 'Quarryville', 'PA', '17566', '39.8631', '-76.1525');
INSERT INTO `net_city` VALUES ('29160', '23', 'Блэкдак', 'Blackduck', 'MN', '56630', '47.7274', '-94.5010');
INSERT INTO `net_city` VALUES ('29161', '23', 'Керуэнсвилл', 'Curwensville', 'PA', '16833', '40.9347', '-78.5867');
INSERT INTO `net_city` VALUES ('29162', '23', 'Корнвилл', 'Cornville', 'AZ', '86325', '34.7331', '-111.9114');
INSERT INTO `net_city` VALUES ('29171', '23', 'Нью Оберн', 'New Auburn', 'MN', '55366', '44.6736', '-94.2239');
INSERT INTO `net_city` VALUES ('29172', '23', 'Депозит', 'Deposit', 'NY', '13754', '42.0932', '-75.4374');
INSERT INTO `net_city` VALUES ('29175', '157', 'Дискавери Бэй', 'Discovery Bay', '09', '', '18.4667', '-77.4000');
INSERT INTO `net_city` VALUES ('29176', '157', 'Мандевилл', 'Mandeville', '04', '', '18.0333', '-77.5000');
INSERT INTO `net_city` VALUES ('29180', '23', 'Нью Оберн', 'New Auburn', 'WI', '54757', '45.2372', '-91.5006');
INSERT INTO `net_city` VALUES ('29184', '23', 'Хокси', 'Hoxie', 'AR', '72433', '36.0111', '-91.0293');
INSERT INTO `net_city` VALUES ('29185', '23', 'Монон', 'Monon', 'IN', '47959', '40.8595', '-86.9162');
INSERT INTO `net_city` VALUES ('29186', '23', 'Сейнт Джо', 'Saint Joe', 'IN', '46785', '41.3198', '-84.8885');
INSERT INTO `net_city` VALUES ('29187', '23', 'Моэб', 'Moab', 'UT', '84532', '38.4506', '-109.6027');
INSERT INTO `net_city` VALUES ('29188', '23', 'Кимбал', 'Kimball', 'SD', '57355', '43.7965', '-98.9735');
INSERT INTO `net_city` VALUES ('29189', '23', 'Вагнер', 'Wagner', 'SD', '57380', '43.0401', '-98.2874');
INSERT INTO `net_city` VALUES ('29191', '23', 'Проспект Хилл', 'Prospect Hill', 'NC', '27314', '36.2899', '-79.1881');
INSERT INTO `net_city` VALUES ('29193', '23', 'Кэрфри', 'Carefree', 'AZ', '85377', '33.8223', '-111.9182');
INSERT INTO `net_city` VALUES ('29197', '23', 'Сандерс', 'Sanders', 'AZ', '86512', '35.2164', '-109.3337');
INSERT INTO `net_city` VALUES ('29199', '23', 'Лон Вулф', 'Lone Wolf', 'OK', '73655', '34.9663', '-99.2691');
INSERT INTO `net_city` VALUES ('29202', '23', 'Грейсмонт', 'Gracemont', 'OK', '73042', '35.2413', '-98.2470');
INSERT INTO `net_city` VALUES ('29205', '23', 'Дьюар', 'Dewar', 'OK', '74431', '35.4582', '-95.9414');
INSERT INTO `net_city` VALUES ('29207', '23', 'Ноб Ностер', 'Knob Noster', 'MO', '65336', '38.7662', '-93.5655');
INSERT INTO `net_city` VALUES ('29210', '23', 'Спирвилл', 'Spearville', 'KS', '67876', '37.8593', '-99.7255');
INSERT INTO `net_city` VALUES ('29217', '23', 'Греймонт', 'Graymont', 'IL', '61743', '40.8797', '-88.7774');
INSERT INTO `net_city` VALUES ('29218', '23', 'Браунсборо', 'Brownsboro', 'TX', '75756', '32.2999', '-95.5998');
INSERT INTO `net_city` VALUES ('29222', '23', 'Мейсонвилл', 'Masonville', 'CO', '80541', '40.4875', '-105.2108');
INSERT INTO `net_city` VALUES ('29228', '23', 'Ланаи Сити', 'Lanai City', 'HI', '96763', '20.8209', '-156.9474');
INSERT INTO `net_city` VALUES ('29231', '23', 'Прейри Сити', 'Prairie City', 'OR', '97869', '44.3895', '-118.6410');
INSERT INTO `net_city` VALUES ('29232', '23', 'Мидлсборо', 'Middlesboro', 'KY', '40965', '36.6442', '-83.6555');
INSERT INTO `net_city` VALUES ('29237', '23', 'Кэмп Пойнт', 'Camp Point', 'IL', '62320', '40.0196', '-91.0794');
INSERT INTO `net_city` VALUES ('29240', '23', 'Дженкинс', 'Jenkins', 'MN', '56456', '46.6395', '-94.3348');
INSERT INTO `net_city` VALUES ('29241', '23', 'Порт Ройал', 'Port Royal', 'SC', '29935', '32.3855', '-80.6988');
INSERT INTO `net_city` VALUES ('29242', '23', 'Литлфилд', 'Littlefield', 'TX', '79339', '33.8943', '-102.3413');
INSERT INTO `net_city` VALUES ('29243', '23', 'Стоддард', 'Stoddard', 'NH', '03464', '43.0754', '-72.1143');
INSERT INTO `net_city` VALUES ('29245', '23', 'Джаффри', 'Jaffrey', 'NH', '03452', '42.8450', '-72.0595');
INSERT INTO `net_city` VALUES ('29246', '23', 'Уэстморленд', 'Westmoreland', 'NH', '03467', '42.9735', '-72.4466');
INSERT INTO `net_city` VALUES ('29248', '23', 'Хаймор', 'Highmore', 'SD', '57345', '44.5452', '-99.4877');
INSERT INTO `net_city` VALUES ('29251', '23', 'Гарретсон', 'Garretson', 'SD', '57030', '43.7473', '-96.5722');
INSERT INTO `net_city` VALUES ('29256', '29', 'Боппард ', 'Boppard', '08', '', '50.2333', '7.6000');
INSERT INTO `net_city` VALUES ('29257', '23', 'Лонок', 'Lonoke', 'AR', '72086', '34.7885', '-91.9277');
INSERT INTO `net_city` VALUES ('29258', '23', 'Фелпс', 'Phelps', 'NY', '14532', '42.9575', '-77.0117');
INSERT INTO `net_city` VALUES ('29261', '23', 'Ван Алстйн', 'Van Alstyne', 'TX', '75495', '33.4366', '-96.5553');
INSERT INTO `net_city` VALUES ('29274', '23', 'Грей Корт', 'Gray Court', 'SC', '29645', '34.5788', '-82.1141');
INSERT INTO `net_city` VALUES ('29276', '23', 'Альворд', 'Alvord', 'TX', '76225', '33.3537', '-97.6778');
INSERT INTO `net_city` VALUES ('29278', '23', 'Джеррардстаун', 'Gerrardstown', 'WV', '25420', '39.3970', '-78.1035');
INSERT INTO `net_city` VALUES ('29280', '23', 'Фаулер', 'Fowler', 'KS', '67844', '37.3727', '-100.2072');
INSERT INTO `net_city` VALUES ('29281', '23', 'Аппер Сандаски', 'Upper Sandusky', 'OH', '43351', '40.8260', '-83.3137');
INSERT INTO `net_city` VALUES ('29282', '23', 'Варшава', 'Warsaw', 'OH', '43844', '40.3216', '-82.0464');
INSERT INTO `net_city` VALUES ('29289', '29', 'Грефельфинг', 'Grafelfing', '02', '', '48.1000', '11.4500');
INSERT INTO `net_city` VALUES ('29290', '23', 'Кимбал', 'Kimball', 'NE', '69145', '41.2772', '-103.6872');
INSERT INTO `net_city` VALUES ('29293', '23', 'Олэт', 'Olathe', 'CO', '81425', '38.4926', '-108.0915');
INSERT INTO `net_city` VALUES ('29298', '23', 'Ловингстон', 'Lovingston', 'VA', '22949', '37.7919', '-78.8603');
INSERT INTO `net_city` VALUES ('29302', '23', 'Эйва', 'Ava', 'MO', '65608', '36.9003', '-92.6347');
INSERT INTO `net_city` VALUES ('29322', '24', 'Валемаунт', 'Valemount', 'BC', 'v0e2z0', '52.8333', '-119.2500');
INSERT INTO `net_city` VALUES ('29373', '24', 'Гранд-Форкс', 'Grand Forks', 'BC', 'v0h1h2', '49.0500', '-118.4667');
INSERT INTO `net_city` VALUES ('29374', '23', 'Бульвар', 'Boulevard', 'CA', '91905', '32.6798', '-116.3140');
INSERT INTO `net_city` VALUES ('29378', '23', 'Труманн', 'Trumann', 'AR', '72472', '35.5745', '-90.5215');
INSERT INTO `net_city` VALUES ('29383', '23', 'Бордман', 'Boardman', 'OR', '97818', '45.7788', '-119.5290');
INSERT INTO `net_city` VALUES ('29386', '13', 'Фоджа', 'Foggia', '13', '', '41.4500', '15.5667');
INSERT INTO `net_city` VALUES ('29400', '23', 'Руидозо', 'Ruidoso', 'NM', '88345', '33.3539', '-105.6328');
INSERT INTO `net_city` VALUES ('29402', '24', 'Макбрайд', 'McBride', 'BC', 'v0j3e0', '53.3000', '-120.1667');
INSERT INTO `net_city` VALUES ('29403', '23', 'Андерсонвилл', 'Andersonville', 'TN', '37705', '36.2281', '-84.0039');
INSERT INTO `net_city` VALUES ('29404', '113', 'Брест', 'Brest', '01', '', '52.0975', '23.6878');
INSERT INTO `net_city` VALUES ('29411', '23', 'Мазон', 'Mazon', 'IL', '60444', '41.2379', '-88.4073');
INSERT INTO `net_city` VALUES ('29412', '23', 'Райт', 'Wright', 'WY', '82732', '43.7071', '-105.5628');
INSERT INTO `net_city` VALUES ('29415', '23', 'Сьюард', 'Seward', 'IL', '61077', '42.2389', '-89.3579');
INSERT INTO `net_city` VALUES ('29416', '23', 'Эрин', 'Erin', 'TN', '37061', '36.2871', '-87.6913');
INSERT INTO `net_city` VALUES ('29417', '23', 'Уорнер Спрингс', 'Warner Springs', 'CA', '92086', '33.2827', '-116.6030');
INSERT INTO `net_city` VALUES ('29424', '23', 'Харлан', 'Harlan', 'KY', '40831', '36.7696', '-83.3478');
INSERT INTO `net_city` VALUES ('29426', '23', 'Кликитат', 'Klickitat', 'WA', '98628', '45.8462', '-121.0416');
INSERT INTO `net_city` VALUES ('29429', '23', 'Гиллетт', 'Gillett', 'TX', '78116', '29.1125', '-97.7749');
INSERT INTO `net_city` VALUES ('29430', '23', 'Дейл', 'Dale', 'TX', '78616', '29.9260', '-97.5644');
INSERT INTO `net_city` VALUES ('29431', '23', 'Буда', 'Buda', 'TX', '78610', '30.0787', '-97.8341');
INSERT INTO `net_city` VALUES ('29437', '23', 'Фолс Сити', 'Falls City', 'TX', '78113', '28.9395', '-98.1336');
INSERT INTO `net_city` VALUES ('29441', '23', 'Лон Джек', 'Lone Jack', 'MO', '64070', '38.8976', '-94.1492');
INSERT INTO `net_city` VALUES ('29443', '23', 'Карутерсвилл', 'Caruthersville', 'MO', '63830', '36.1140', '-89.6895');
INSERT INTO `net_city` VALUES ('29452', '23', 'Сентер', 'Center', 'TX', '75935', '31.7530', '-94.1940');
INSERT INTO `net_city` VALUES ('29459', '23', 'Лэнгли', 'Langley', 'OK', '74350', '36.4640', '-95.0477');
INSERT INTO `net_city` VALUES ('29463', '23', 'Четек', 'Chetek', 'WI', '54728', '45.2839', '-91.7103');
INSERT INTO `net_city` VALUES ('29469', '23', 'Саут Хьюстон', 'South Houston', 'TX', '77587', '29.6608', '-95.2286');
INSERT INTO `net_city` VALUES ('29470', '23', 'Рокспрингс', 'Rocksprings', 'TX', '78880', '30.0063', '-100.2212');
INSERT INTO `net_city` VALUES ('29471', '23', 'Клирвью Сити', 'Clearview City', 'KS', '66019', '38.9458', '-95.0030');
INSERT INTO `net_city` VALUES ('29473', '23', 'Пайлот Маунтин', 'Pilot Mountain', 'NC', '27041', '36.4151', '-80.4773');
INSERT INTO `net_city` VALUES ('29478', '23', 'Котулла', 'Cotulla', 'TX', '78014', '28.3566', '-99.1436');
INSERT INTO `net_city` VALUES ('29479', '23', 'Карризо Спрингс', 'Carrizo Springs', 'TX', '78834', '28.4955', '-99.8026');
INSERT INTO `net_city` VALUES ('29489', '23', 'Элберта', 'Elberta', 'AL', '36530', '30.4078', '-87.5553');
INSERT INTO `net_city` VALUES ('29490', '23', 'Галф Шорс', 'Gulf Shores', 'AL', '36547', '30.2460', '-87.7008');
INSERT INTO `net_city` VALUES ('29491', '23', 'Саммердейл', 'Summerdale', 'AL', '36580', '30.4759', '-87.6957');
INSERT INTO `net_city` VALUES ('29493', '23', 'Рисборо', 'Riceboro', 'GA', '31323', '31.6807', '-81.4307');
INSERT INTO `net_city` VALUES ('29495', '23', 'Уиллардс', 'Willards', 'MD', '21874', '38.3841', '-75.3569');
INSERT INTO `net_city` VALUES ('29498', '21', 'Дурем', 'Durham', 'D8', '', '54.7667', '-1.5667');
INSERT INTO `net_city` VALUES ('29500', '23', 'Уэст Юнион', 'West Union', 'OH', '45693', '38.8256', '-83.5288');
INSERT INTO `net_city` VALUES ('29503', '23', 'Моуристаун', 'Mowrystown', 'OH', '45155', '39.0384', '-83.7485');
INSERT INTO `net_city` VALUES ('29506', '23', 'Сардиния', 'Sardinia', 'OH', '45171', '39.0102', '-83.8054');
INSERT INTO `net_city` VALUES ('29514', '23', 'Минфорд', 'Minford', 'OH', '45653', '38.8892', '-82.8447');
INSERT INTO `net_city` VALUES ('29515', '23', 'Ок Хилл', 'Oak Hill', 'OH', '45656', '38.8655', '-82.5844');
INSERT INTO `net_city` VALUES ('29517', '23', 'Лукасвилл', 'Lucasville', 'OH', '45648', '38.9105', '-82.9444');
INSERT INTO `net_city` VALUES ('29519', '23', 'Уилерсберг', 'Wheelersburg', 'OH', '45694', '38.7599', '-82.7836');
INSERT INTO `net_city` VALUES ('29520', '23', 'Маунт Ораб', 'Mount Orab', 'OH', '45154', '39.0565', '-83.9216');
INSERT INTO `net_city` VALUES ('29534', '23', 'Сирен', 'Siren', 'WI', '54872', '45.7683', '-92.3855');
INSERT INTO `net_city` VALUES ('29539', '23', 'Вахоо', 'Wahoo', 'NE', '68066', '41.1836', '-96.6195');
INSERT INTO `net_city` VALUES ('29541', '23', 'Уолкертаун', 'Walkertown', 'NC', '27051', '36.1871', '-80.1658');
INSERT INTO `net_city` VALUES ('29542', '23', 'Фокс Ривер Гров', 'Fox River Grove', 'IL', '60021', '42.1947', '-88.2199');
INSERT INTO `net_city` VALUES ('29543', '23', 'Холли', 'Holley', 'NY', '14470', '43.2166', '-78.0584');
INSERT INTO `net_city` VALUES ('29549', '23', 'Лоувилл', 'Lowville', 'NY', '13367', '43.7914', '-75.5878');
INSERT INTO `net_city` VALUES ('29559', '23', 'Сателлит Бич', 'Satellite Beach', 'FL', '32937', '28.1737', '-80.5997');
INSERT INTO `net_city` VALUES ('29561', '23', 'Биг Бэар Лейк', 'Big Bear Lake', 'CA', '92315', '34.2395', '-116.8685');
INSERT INTO `net_city` VALUES ('29569', '23', 'Кордел', 'Cordele', 'GA', '31015', '31.9251', '-83.7800');
INSERT INTO `net_city` VALUES ('29571', '23', 'Джонстаун', 'Jonestown', 'PA', '17038', '40.4657', '-76.5489');
INSERT INTO `net_city` VALUES ('29573', '23', 'Нокс Сити', 'Knox City', 'TX', '79529', '33.4536', '-99.8468');
INSERT INTO `net_city` VALUES ('29576', '23', 'Стюартсвилл', 'Stewartsville', 'NJ', '08886', '40.6950', '-75.0983');
INSERT INTO `net_city` VALUES ('29578', '23', 'Поттерсвилл', 'Pottersville', 'NJ', '07979', '40.7137', '-74.7218');
INSERT INTO `net_city` VALUES ('29579', '23', 'Бетани Бич', 'Bethany Beach', 'DE', '19930', '38.5562', '-75.0692');
INSERT INTO `net_city` VALUES ('29583', '23', 'Уэверли', 'Waverly', 'GA', '31565', '31.0652', '-81.6297');
INSERT INTO `net_city` VALUES ('29589', '23', 'Йорквилл', 'Yorkville', 'IL', '60560', '41.5996', '-88.4322');
INSERT INTO `net_city` VALUES ('29591', '23', 'Холсвилл', 'Hallsville', 'TX', '75650', '32.5155', '-94.5626');
INSERT INTO `net_city` VALUES ('29594', '21', 'Уотерлувилл', 'Waterlooville', 'F2', '', '50.8667', '-1.0167');
INSERT INTO `net_city` VALUES ('29596', '23', 'Рандлман', 'Randleman', 'NC', '27317', '35.8285', '-79.7984');
INSERT INTO `net_city` VALUES ('29599', '23', 'Хесперия', 'Hesperia', 'CA', '92345', '34.3661', '-117.3205');
INSERT INTO `net_city` VALUES ('29602', '23', 'Бампас', 'Bumpass', 'VA', '23024', '37.9392', '-77.7899');
INSERT INTO `net_city` VALUES ('29607', '23', 'Джанкшен', 'Junction', 'TX', '76849', '30.4995', '-99.7923');
INSERT INTO `net_city` VALUES ('29609', '23', 'Гучленд', 'Goochland', 'VA', '23063', '37.7268', '-77.9860');
INSERT INTO `net_city` VALUES ('29613', '23', 'Кетлман Сити', 'Kettleman City', 'CA', '93239', '35.9930', '-119.9990');
INSERT INTO `net_city` VALUES ('29618', '163', 'Барранкилья', 'Barranquilla', '04', '', '10.9639', '-74.7964');
INSERT INTO `net_city` VALUES ('29623', '35', 'Таррагона', 'Tarragona', '56', '', '41.1167', '1.2500');
INSERT INTO `net_city` VALUES ('29624', '140', 'Таллин', 'Tallinn', '01', '', '59.4339', '24.7281');
INSERT INTO `net_city` VALUES ('29630', '23', 'Маниту Спрингс', 'Manitou Springs', 'CO', '80829', '38.8406', '-104.9795');
INSERT INTO `net_city` VALUES ('29632', '23', 'Скоттвилл', 'Scottville', 'MI', '49454', '43.9334', '-86.2641');
INSERT INTO `net_city` VALUES ('29636', '23', 'Каслтон', 'Castleton', 'VT', '05735', '43.6603', '-73.1664');
INSERT INTO `net_city` VALUES ('29641', '23', 'Милри', 'Millry', 'AL', '36558', '31.6175', '-88.2944');
INSERT INTO `net_city` VALUES ('29649', '23', 'Станардсвилл', 'Stanardsville', 'VA', '22973', '38.3425', '-78.4840');
INSERT INTO `net_city` VALUES ('29655', '23', 'Оксвасс', 'Auxvasse', 'MO', '65231', '39.0143', '-91.8939');
INSERT INTO `net_city` VALUES ('29657', '213', 'Вадуц', 'Vaduz', '11', '', '47.1333', '9.5167');
INSERT INTO `net_city` VALUES ('29658', '23', 'Трс Пинос', 'Tres Pinos', 'CA', '95075', '36.7617', '-121.2748');
INSERT INTO `net_city` VALUES ('29660', '239', 'Абиджан', 'Abidjan', '82', '', '5.3097', '-4.0127');
INSERT INTO `net_city` VALUES ('29662', '23', 'Грин', 'Greene', 'ME', '04236', '44.1921', '-70.1442');
INSERT INTO `net_city` VALUES ('29663', '23', 'Френч Лик', 'French Lick', 'IN', '47432', '38.4890', '-86.6456');
INSERT INTO `net_city` VALUES ('29666', '23', 'Норт Ньютон', 'North Newton', 'KS', '67117', '38.0737', '-97.3460');
INSERT INTO `net_city` VALUES ('29669', '23', 'Сентертон', 'Centerton', 'AR', '72719', '36.3692', '-94.3053');
INSERT INTO `net_city` VALUES ('29672', '23', 'Сентервилл', 'Centerville', 'TN', '37033', '35.7484', '-87.5313');
INSERT INTO `net_city` VALUES ('29678', '23', 'Хеброн', 'Hebron', 'NH', '03241', '43.7217', '-71.7974');
INSERT INTO `net_city` VALUES ('29679', '23', 'Коттеджвилл', 'Cottageville', 'SC', '29435', '32.9580', '-80.4689');
INSERT INTO `net_city` VALUES ('29681', '23', 'Уэтампка', 'Wetumpka', 'AL', '36092', '32.6308', '-86.1686');
INSERT INTO `net_city` VALUES ('29682', '23', 'Хайвуд', 'Highwood', 'IL', '60040', '42.2035', '-87.8132');
INSERT INTO `net_city` VALUES ('29698', '23', 'Шарпсвилл', 'Sharpsville', 'PA', '16150', '41.2988', '-80.4888');
INSERT INTO `net_city` VALUES ('29703', '23', 'Камби', 'Cumby', 'TX', '75433', '33.1164', '-95.8073');
INSERT INTO `net_city` VALUES ('29707', '23', 'Канистео', 'Canisteo', 'NY', '14823', '42.2423', '-77.5814');
INSERT INTO `net_city` VALUES ('29709', '23', 'Мельбурн Бич', 'Melbourne Beach', 'FL', '32951', '27.9668', '-80.5096');
INSERT INTO `net_city` VALUES ('29710', '23', 'Кейп Элизабет', 'Cape Elizabeth', 'ME', '04107', '43.5932', '-70.2382');
INSERT INTO `net_city` VALUES ('29711', '23', 'Миневилл', 'Mineville', 'NY', '12956', '44.0888', '-73.4995');
INSERT INTO `net_city` VALUES ('29713', '23', 'Пол Смитс', 'Paul Smiths', 'NY', '12970', '44.4509', '-74.3075');
INSERT INTO `net_city` VALUES ('29714', '23', 'Порт Мюррей', 'Port Murray', 'NJ', '07865', '40.7917', '-74.9020');
INSERT INTO `net_city` VALUES ('29718', '23', 'Грейтаун', 'Graytown', 'OH', '43432', '41.5696', '-83.2418');
INSERT INTO `net_city` VALUES ('29723', '23', 'Карми', 'Carmi', 'IL', '62821', '38.0864', '-88.1173');
INSERT INTO `net_city` VALUES ('29727', '9', 'Пхукет', 'Phuket', '62', '', '7.8333', '98.3833');
INSERT INTO `net_city` VALUES ('29728', '21', 'Лланелли', 'Llanelli', 'X7', '', '51.6761', '-4.1567');
INSERT INTO `net_city` VALUES ('29736', '23', 'Уорфилд', 'Warfield', 'VA', '23889', '36.8984', '-77.7514');
INSERT INTO `net_city` VALUES ('29737', '23', 'Милсберг', 'Milesburg', 'PA', '16853', '40.9417', '-77.7850');
INSERT INTO `net_city` VALUES ('29738', '23', 'Луизиана', 'Louisiana', 'MO', '63353', '39.4425', '-91.1028');
INSERT INTO `net_city` VALUES ('29746', '23', 'Бландфорд', 'Blandford', 'MA', '01008', '42.1820', '-72.9530');
INSERT INTO `net_city` VALUES ('29752', '23', 'Буллард', 'Bullard', 'TX', '75757', '32.1097', '-95.3386');
INSERT INTO `net_city` VALUES ('29764', '23', 'Байесвилл', 'Byesville', 'OH', '43723', '39.9609', '-81.5365');
INSERT INTO `net_city` VALUES ('29767', '23', 'Уинслоу', 'Winslow', 'IL', '61089', '42.4644', '-89.8263');
INSERT INTO `net_city` VALUES ('29772', '23', 'Локни', 'Lockney', 'TX', '79241', '34.1537', '-101.1464');
INSERT INTO `net_city` VALUES ('29775', '23', 'Хинтон', 'Hinton', 'WV', '25951', '37.6862', '-80.8367');
INSERT INTO `net_city` VALUES ('29776', '23', 'Робертс', 'Roberts', 'MT', '59070', '45.3489', '-109.1654');
INSERT INTO `net_city` VALUES ('29779', '23', 'Лос Осос', 'Los Osos', 'CA', '93402', '35.2904', '-120.8101');
INSERT INTO `net_city` VALUES ('29780', '23', 'Колониал Бич', 'Colonial Beach', 'VA', '22443', '38.1818', '-76.9847');
INSERT INTO `net_city` VALUES ('29783', '23', 'Маккленни', 'Macclenny', 'FL', '32063', '30.2558', '-82.1300');
INSERT INTO `net_city` VALUES ('29786', '23', 'Лароз', 'Larose', 'LA', '70373', '29.5724', '-90.3817');
INSERT INTO `net_city` VALUES ('29788', '23', 'Пирпон', 'Pierpont', 'OH', '44082', '41.7664', '-80.5709');
INSERT INTO `net_city` VALUES ('29789', '23', 'Кейзер', 'Keizer', 'OR', '97307', '44.9901', '-123.0262');
INSERT INTO `net_city` VALUES ('29790', '112', 'Одесса', 'Odessa', '17', '', '46.4639', '30.7386');
INSERT INTO `net_city` VALUES ('29791', '23', 'Филлипс', 'Phillips', 'WI', '54555', '45.6983', '-90.3900');
INSERT INTO `net_city` VALUES ('29797', '23', 'Мак-Кенна', 'Mckenna', 'WA', '98558', '46.9348', '-122.5565');
INSERT INTO `net_city` VALUES ('29799', '23', 'Буллхед Сити', 'Bullhead City', 'AZ', '86442', '35.0900', '-114.5736');
INSERT INTO `net_city` VALUES ('29806', '23', 'Морган', 'Morgan', 'VT', '05853', '44.8822', '-71.9625');
INSERT INTO `net_city` VALUES ('29807', '23', 'Стейси', 'Stacy', 'MN', '55079', '45.4067', '-93.0302');
INSERT INTO `net_city` VALUES ('29813', '21', 'Олдем', 'Oldham', 'K1', '', '53.5500', '-2.1167');
INSERT INTO `net_city` VALUES ('29814', '23', 'Раск', 'Rusk', 'TX', '75785', '31.7553', '-95.1640');
INSERT INTO `net_city` VALUES ('29817', '23', 'Норт Лима', 'North Lima', 'OH', '44452', '40.9512', '-80.6529');
INSERT INTO `net_city` VALUES ('29825', '23', 'Бронте', 'Bronte', 'TX', '76933', '31.8833', '-100.2842');
INSERT INTO `net_city` VALUES ('29827', '23', 'Линвилл', 'Linville', 'VA', '22834', '38.5587', '-78.8613');
INSERT INTO `net_city` VALUES ('29828', '24', 'Сен-Мишель-Де-Сен', 'Saint-Michel-des-Saints', 'QC', 'j0k3b0', '46.6821', '-73.9188');
INSERT INTO `net_city` VALUES ('29831', '23', 'Милтаун', 'Milltown', 'WI', '54858', '45.5111', '-92.4582');
INSERT INTO `net_city` VALUES ('29835', '23', 'Анаконда', 'Anaconda', 'MT', '59711', '46.1241', '-112.9701');
INSERT INTO `net_city` VALUES ('29836', '23', 'Уинтерс', 'Winters', 'TX', '79567', '31.9856', '-99.9558');
INSERT INTO `net_city` VALUES ('29837', '23', 'Тахока', 'Tahoka', 'TX', '79373', '33.1762', '-101.8181');
INSERT INTO `net_city` VALUES ('29838', '23', 'Батл-Лейк', 'Battle Lake', 'MN', '56515', '46.2843', '-95.7266');
INSERT INTO `net_city` VALUES ('29841', '23', 'Белгрейд', 'Belgrade', 'MT', '59714', '45.9666', '-111.1124');
INSERT INTO `net_city` VALUES ('29842', '23', 'Белград', 'Belgrade', 'ME', '04917', '44.4876', '-69.8380');
INSERT INTO `net_city` VALUES ('29843', '23', 'Сан Бенито', 'San Benito', 'TX', '78586', '26.0989', '-97.6432');
INSERT INTO `net_city` VALUES ('29847', '23', 'Превитт', 'Prewitt', 'NM', '87045', '35.4362', '-107.9930');
INSERT INTO `net_city` VALUES ('29848', '23', 'Уэлчес', 'Welches', 'OR', '97067', '45.3027', '-121.9511');
INSERT INTO `net_city` VALUES ('29849', '21', 'Таучестер', 'Towcester', 'J1', '', '52.1333', '-0.9833');
INSERT INTO `net_city` VALUES ('29855', '23', 'Рафин', 'Raphine', 'VA', '24472', '37.9426', '-79.2035');
INSERT INTO `net_city` VALUES ('29856', '23', 'Мондамин', 'Mondamin', 'IA', '51557', '41.7398', '-95.9900');
INSERT INTO `net_city` VALUES ('29858', '23', 'Уинберн', 'Winburne', 'PA', '16879', '40.9681', '-78.1575');
INSERT INTO `net_city` VALUES ('29862', '23', 'Эванс Милс', 'Evans Mills', 'NY', '13637', '44.0945', '-75.8179');
INSERT INTO `net_city` VALUES ('29863', '23', 'Перидот', 'Peridot', 'AZ', '85542', '33.2147', '-110.5340');
INSERT INTO `net_city` VALUES ('29865', '23', 'Пенс Спрингс', 'Pence Springs', 'WV', '24962', '37.6626', '-80.7179');
INSERT INTO `net_city` VALUES ('29866', '1', 'Оберн', 'Auburn', '07', '', '-37.8167', '145.0500');
INSERT INTO `net_city` VALUES ('29869', '23', 'Линден', 'Lynden', 'WA', '98264', '48.9566', '-122.4325');
INSERT INTO `net_city` VALUES ('29874', '23', 'Хайленд Фолс', 'Highland Falls', 'NY', '10928', '41.3546', '-74.0017');
INSERT INTO `net_city` VALUES ('29875', '23', 'Саутпорт', 'Southport', 'ME', '04576', '43.8187', '-69.6696');
INSERT INTO `net_city` VALUES ('29877', '23', 'Старлайт', 'Starlight', 'PA', '18461', '41.9391', '-75.3324');
INSERT INTO `net_city` VALUES ('29879', '23', 'Маунт Сторм', 'Mount Storm', 'WV', '26739', '39.2338', '-79.2453');
INSERT INTO `net_city` VALUES ('29882', '23', 'Амит', 'Amite', 'LA', '70422', '30.7308', '-90.6098');
INSERT INTO `net_city` VALUES ('29883', '23', 'Ламар', 'Lamar', 'CO', '81052', '37.8778', '-102.6234');
INSERT INTO `net_city` VALUES ('29889', '23', 'Джекайлл Айленд', 'Jekyll Island', 'GA', '31527', '31.0671', '-81.4206');
INSERT INTO `net_city` VALUES ('29901', '1', 'Аделаида', 'Adelaide', '05', '', '-34.9287', '138.5986');
INSERT INTO `net_city` VALUES ('29904', '21', 'Хемел-Хемпстед', 'Hemel Hempstead', 'F8', '', '51.7500', '-0.4667');
INSERT INTO `net_city` VALUES ('29905', '21', 'Бекклс', 'Beccles', 'N5', '', '52.4667', '1.5667');
INSERT INTO `net_city` VALUES ('29908', '23', 'Грин Понд', 'Green Pond', 'SC', '29446', '32.6545', '-80.6002');
INSERT INTO `net_city` VALUES ('29910', '23', 'Лутрелл', 'Luttrell', 'TN', '37779', '36.2143', '-83.7670');
INSERT INTO `net_city` VALUES ('29918', '23', 'Виктор', 'Victor', 'MT', '59875', '46.3926', '-114.2617');
INSERT INTO `net_city` VALUES ('29919', '23', 'Макстон', 'Maxton', 'NC', '28364', '34.7121', '-79.3394');
INSERT INTO `net_city` VALUES ('29923', '23', 'Маршвилл', 'Marshville', 'NC', '28103', '35.0051', '-80.3544');
INSERT INTO `net_city` VALUES ('29924', '24', 'Шелберн', 'Shelburne (Nova Scotia)', 'NS', 'b0t1w0', '43.7534', '-65.2461');
INSERT INTO `net_city` VALUES ('29931', '23', 'Пинкнивилл', 'Pinckneyville', 'IL', '62274', '38.0834', '-89.3988');
INSERT INTO `net_city` VALUES ('29935', '163', 'Букараманга', 'Bucaramanga', '26', '', '7.1254', '-73.1198');
INSERT INTO `net_city` VALUES ('29936', '23', 'Делтон', 'Delton', 'MI', '49046', '42.5186', '-85.3842');
INSERT INTO `net_city` VALUES ('29939', '23', 'Олдтаун', 'Oldtown', 'MD', '21555', '39.5925', '-78.5901');
INSERT INTO `net_city` VALUES ('29946', '23', 'Эйвон Парк', 'Avon Park', 'FL', '33825', '27.6387', '-81.4048');
INSERT INTO `net_city` VALUES ('29953', '23', 'Таунсенд', 'Townsend', 'MT', '59644', '46.4848', '-111.3486');
INSERT INTO `net_city` VALUES ('29955', '23', 'Бессемер', 'Bessemer', 'PA', '16112', '40.9579', '-80.4940');
INSERT INTO `net_city` VALUES ('29961', '23', 'Криц', 'Critz', 'VA', '24082', '36.6203', '-80.1286');
INSERT INTO `net_city` VALUES ('29962', '23', 'Милбридж', 'Milbridge', 'ME', '04658', '44.5685', '-67.8656');
INSERT INTO `net_city` VALUES ('29963', '23', 'Валдез', 'Valdez', 'AK', '99686', '61.4065', '-145.6670');
INSERT INTO `net_city` VALUES ('29964', '23', 'Миклтон', 'Mickleton', 'NJ', '08056', '39.7883', '-75.2500');
INSERT INTO `net_city` VALUES ('29965', '23', 'Тайнер', 'Tyner', 'NC', '27980', '36.2474', '-76.6186');
INSERT INTO `net_city` VALUES ('29971', '23', 'Ле Рой', 'Le Roy', 'NY', '14482', '42.9603', '-77.9779');
INSERT INTO `net_city` VALUES ('29972', '162', 'Джорджтаун', 'George Town', '00', '', '19.3000', '-81.3833');
INSERT INTO `net_city` VALUES ('29973', '23', 'Силвер Спрингс', 'Silver Springs', 'NV', '89429', '39.3749', '-119.2653');
INSERT INTO `net_city` VALUES ('29977', '146', 'Дикенсон Бей', 'Dickenson Bay', '03', '', '17.1167', '-61.8000');
INSERT INTO `net_city` VALUES ('29978', '23', 'Брукшир', 'Brookshire', 'TX', '77423', '29.8210', '-95.9317');
INSERT INTO `net_city` VALUES ('29981', '6', 'Тривандрум', 'Trivandrum', '13', '', '8.5069', '76.9569');
INSERT INTO `net_city` VALUES ('29989', '23', 'Де Графф', 'De Graff', 'OH', '43318', '40.3080', '-83.9143');
INSERT INTO `net_city` VALUES ('29995', '23', 'Мендон', 'Mendon', 'MA', '01756', '42.1030', '-71.5439');
INSERT INTO `net_city` VALUES ('29996', '23', 'Глен Эллен', 'Glen Ellen', 'CA', '95442', '38.3813', '-122.5197');
INSERT INTO `net_city` VALUES ('30000', '23', 'Баннокберн', 'Bannockburn', 'IL', '60037', '42.2111', '-87.8090');
INSERT INTO `net_city` VALUES ('30001', '23', 'Комсток Парк', 'Comstock Park', 'MI', '49321', '43.0818', '-85.6814');
INSERT INTO `net_city` VALUES ('30014', '21', 'Стаффорд', 'Stafford', 'M9', '', '52.8000', '-2.1000');
INSERT INTO `net_city` VALUES ('30021', '23', 'Остинберг', 'Austinburg', 'OH', '44010', '41.7564', '-80.8566');
INSERT INTO `net_city` VALUES ('30022', '23', 'Феникс Сити', 'Phenix City', 'AL', '36869', '32.4065', '-85.0425');
INSERT INTO `net_city` VALUES ('30023', '23', 'Таммс', 'Tamms', 'IL', '62988', '37.2424', '-89.2963');
INSERT INTO `net_city` VALUES ('30031', '23', 'Вапаконета', 'Wapakoneta', 'OH', '45895', '40.5767', '-84.1399');
INSERT INTO `net_city` VALUES ('30033', '130', 'Панама', 'Panama City', '08', '', '8.9667', '-79.5333');
INSERT INTO `net_city` VALUES ('30035', '23', 'Ливиттсберг', 'Leavittsburg', 'OH', '44430', '41.2375', '-80.9066');
INSERT INTO `net_city` VALUES ('30037', '23', 'Лаудонвилл', 'Loudonville', 'OH', '44842', '40.6550', '-82.2338');
INSERT INTO `net_city` VALUES ('30038', '23', 'Калвертон', 'Calverton', 'VA', '20138', '38.6321', '-77.6706');
INSERT INTO `net_city` VALUES ('30044', '23', 'Долорес', 'Dolores', 'CO', '81323', '37.6363', '-108.3015');
INSERT INTO `net_city` VALUES ('30045', '23', 'Хот Салфер Спрингс', 'Hot Sulphur Springs', 'CO', '80451', '40.0730', '-106.1028');
INSERT INTO `net_city` VALUES ('30047', '23', 'Бакс', 'Bucks', 'AL', '36512', '31.0105', '-88.0242');
INSERT INTO `net_city` VALUES ('30048', '23', 'Коллбран', 'Collbran', 'CO', '81624', '39.2048', '-107.8500');
INSERT INTO `net_city` VALUES ('30050', '23', 'Кандлер', 'Candler', 'NC', '28715', '35.5119', '-82.7037');
INSERT INTO `net_city` VALUES ('30051', '23', 'Маунтинвилл', 'Mountainville', 'NY', '10953', '41.4009', '-74.0785');
INSERT INTO `net_city` VALUES ('30057', '155', 'Круа-де-Буке', 'Croix Des Bouquets', '11', '', '18.5767', '-72.2269');
INSERT INTO `net_city` VALUES ('30060', '23', 'Лемон Гров', 'Lemon Grove', 'CA', '91945', '32.7313', '-117.0391');
INSERT INTO `net_city` VALUES ('30072', '23', 'Куксвилл', 'Cooksville', 'MD', '21723', '39.3232', '-77.0040');
INSERT INTO `net_city` VALUES ('30079', '23', 'Кротон Фолс', 'Croton Falls', 'NY', '10519', '41.3473', '-73.6610');
INSERT INTO `net_city` VALUES ('30094', '23', 'Сентер-Сити', 'Center City', 'MN', '55012', '45.4402', '-92.7870');
INSERT INTO `net_city` VALUES ('30111', '23', 'Денем Спрингс', 'Denham Springs', 'LA', '70726', '30.4298', '-90.8999');
INSERT INTO `net_city` VALUES ('30113', '23', 'Гретна', 'Gretna', 'NE', '68028', '41.1028', '-96.2429');
INSERT INTO `net_city` VALUES ('30117', '23', 'Уэйтсберг', 'Waitsburg', 'WA', '99361', '46.2277', '-118.1524');
INSERT INTO `net_city` VALUES ('30168', '24', 'Эллиот Лейк', 'Elliot Lake', 'ON', 'p5a3n9', '46.3833', '-82.6500');
INSERT INTO `net_city` VALUES ('30195', '23', 'Пемброк-Пайнс', 'Pembroke Pines', 'FL', '33082', '26.0032', '-80.2239');
INSERT INTO `net_city` VALUES ('30211', '23', 'Слейтерсвилл', 'Slatersville', 'RI', '02876', '41.9984', '-71.5763');
INSERT INTO `net_city` VALUES ('30213', '23', 'Тайрингем', 'Tyringham', 'MA', '01264', '42.2459', '-73.2037');
INSERT INTO `net_city` VALUES ('30221', '15', 'Орса', 'Orsa', '10', '', '61.1167', '14.6167');
INSERT INTO `net_city` VALUES ('30230', '30', 'Исфахан', 'Isfahan', '28', '', '32.6572', '51.6776');
INSERT INTO `net_city` VALUES ('30239', '15', 'Гётеборг', 'Gothenburg', '28', '', '57.7167', '11.9667');
INSERT INTO `net_city` VALUES ('30241', '23', 'Нью Касл', 'New Castle', 'NH', '03854', '43.0646', '-70.7226');
INSERT INTO `net_city` VALUES ('30248', '23', 'Лейк Даллас', 'Lake Dallas', 'TX', '75065', '33.1161', '-97.0118');
INSERT INTO `net_city` VALUES ('30254', '23', 'Мейпл Сити', 'Maple City', 'MI', '49664', '44.8719', '-85.8916');
INSERT INTO `net_city` VALUES ('30255', '23', 'Ултюа', 'Ooltewah', 'TN', '37363', '35.1371', '-85.0368');
INSERT INTO `net_city` VALUES ('30269', '123', 'Бая-Маре', 'Baia Mare', '25', '', '47.6667', '23.5833');
INSERT INTO `net_city` VALUES ('30272', '23', 'Экинанк', 'Equinunk', 'PA', '18417', '41.8075', '-75.1934');
INSERT INTO `net_city` VALUES ('30276', '142', 'Кувейт', 'Kuwait City', '02', '', '29.3328', '48.0286');
INSERT INTO `net_city` VALUES ('30278', '23', 'Рокмарт', 'Rockmart', 'GA', '30153', '33.9762', '-85.0527');
INSERT INTO `net_city` VALUES ('30285', '121', 'Бургас', 'Burgas', '39', '', '42.5000', '27.4667');
INSERT INTO `net_city` VALUES ('30287', '21', 'Дуглас', 'Douglas', 'W5', '', '55.5500', '-3.8500');
INSERT INTO `net_city` VALUES ('30289', '23', 'Эллендейл', 'Ellendale', 'ND', '58436', '46.1098', '-98.6107');
INSERT INTO `net_city` VALUES ('30294', '46', 'Мултан', 'Multan', '04', '', '30.1956', '71.4753');
INSERT INTO `net_city` VALUES ('30296', '160', 'Гуаякиль', 'Guayaquil', '10', '', '-2.1667', '-79.9000');
INSERT INTO `net_city` VALUES ('30298', '23', 'Манзанита', 'Manzanita', 'OR', '97130', '45.7701', '-123.9635');
INSERT INTO `net_city` VALUES ('30299', '23', 'Раскин', 'Ruskin', 'FL', '33570', '27.7101', '-82.4314');
INSERT INTO `net_city` VALUES ('30300', '23', 'Уэбстер', 'Webster', 'WI', '54893', '45.8622', '-92.2978');
INSERT INTO `net_city` VALUES ('30301', '21', 'Лангхолм', 'Langholm', 'U2', '', '55.1500', '-3.0000');
INSERT INTO `net_city` VALUES ('30305', '1', 'Редбанк', 'Redbank', '07', '', '-36.9333', '143.3167');
INSERT INTO `net_city` VALUES ('30308', '23', 'Дайерсвилл', 'Dyersville', 'IA', '52040', '42.5054', '-91.1361');
INSERT INTO `net_city` VALUES ('30311', '23', 'Ла Пайн', 'La Pine', 'OR', '97739', '43.6900', '-121.1467');
INSERT INTO `net_city` VALUES ('30313', '123', 'Сату-Маре', 'Satu Mare', '32', '', '47.8000', '22.8833');
INSERT INTO `net_city` VALUES ('30314', '23', 'Тилсон', 'Tillson', 'NY', '12486', '41.8344', '-74.0662');
INSERT INTO `net_city` VALUES ('30315', '111', 'Рига', 'Riga', '25', '', '56.9500', '24.1000');
INSERT INTO `net_city` VALUES ('30317', '13', 'Козенца', 'Cosenza', '03', '', '39.3000', '16.2500');
INSERT INTO `net_city` VALUES ('30319', '23', 'Ла Пуш', 'La Push', 'WA', '98350', '47.9087', '-124.6366');
INSERT INTO `net_city` VALUES ('30324', '23', 'Хартвуд', 'Hartwood', 'VA', '22471', '38.4023', '-77.5653');
INSERT INTO `net_city` VALUES ('30332', '23', 'Бруквилл', 'Brookeville', 'MD', '20833', '39.2176', '-77.0533');
INSERT INTO `net_city` VALUES ('30339', '23', 'Уотсон', 'Watson', 'LA', '70786', '30.5757', '-90.9532');
INSERT INTO `net_city` VALUES ('30349', '130', 'Колон', 'Colon', '04', '', '9.3592', '-79.9014');
INSERT INTO `net_city` VALUES ('30355', '23', 'Бедиас', 'Bedias', 'TX', '77831', '30.7257', '-95.9111');
INSERT INTO `net_city` VALUES ('30357', '23', 'Клат', 'Clute', 'TX', '77531', '29.0655', '-95.3828');
INSERT INTO `net_city` VALUES ('30362', '23', 'Портленд', 'Portland', 'TX', '78374', '27.8923', '-97.3187');
INSERT INTO `net_city` VALUES ('30363', '23', 'Си Айл Сити', 'Sea Isle City', 'NJ', '08243', '39.1516', '-74.6932');
INSERT INTO `net_city` VALUES ('30364', '23', 'Форт Джонс', 'Fort Jones', 'CA', '96032', '41.5949', '-122.9661');
INSERT INTO `net_city` VALUES ('30365', '23', 'Алгонак', 'Algonac', 'MI', '48001', '42.6376', '-82.5823');
INSERT INTO `net_city` VALUES ('30366', '23', 'Джеддо', 'Jeddo', 'MI', '48032', '43.1357', '-82.5855');
INSERT INTO `net_city` VALUES ('30368', '23', 'Атталла', 'Attalla', 'AL', '35954', '34.0905', '-86.0442');
INSERT INTO `net_city` VALUES ('30377', '23', 'Луверн', 'Luverne', 'AL', '36049', '31.7443', '-86.2952');
INSERT INTO `net_city` VALUES ('30386', '23', 'Бигфорк', 'Bigfork', 'MT', '59911', '47.8874', '-113.8725');
INSERT INTO `net_city` VALUES ('30394', '23', 'Сейнт Мэрис', 'Saint Marys', 'OH', '45885', '40.5722', '-84.3813');
INSERT INTO `net_city` VALUES ('30397', '23', 'Баском', 'Bascom', 'OH', '44809', '41.1328', '-83.2852');
INSERT INTO `net_city` VALUES ('30404', '23', 'Лития', 'Lithia', 'FL', '33547', '27.7866', '-82.1440');
INSERT INTO `net_city` VALUES ('30405', '23', 'Селбивилл', 'Selbyville', 'DE', '19975', '38.4782', '-75.1981');
INSERT INTO `net_city` VALUES ('30406', '23', 'Монтчанин', 'Montchanin', 'DE', '19710', '39.7898', '-75.5891');
INSERT INTO `net_city` VALUES ('30467', '33', 'Валкенсвард', 'Valkenswaard', '06', '', '51.3527', '5.4561');
INSERT INTO `net_city` VALUES ('30469', '44', 'Лас-Пинас', 'Las Pinas', '53', '', '14.4506', '120.9828');
INSERT INTO `net_city` VALUES ('30475', '23', 'Декуинси', 'Dequincy', 'LA', '70633', '30.4172', '-93.3907');
INSERT INTO `net_city` VALUES ('30477', '23', 'Саттонс Бэй', 'Suttons Bay', 'MI', '49682', '44.9776', '-85.6089');
INSERT INTO `net_city` VALUES ('30480', '23', 'Дарданелл', 'Dardanelle', 'AR', '72834', '35.1702', '-93.1912');
INSERT INTO `net_city` VALUES ('30495', '23', 'Калида', 'Kalida', 'OH', '45853', '40.9828', '-84.1994');
INSERT INTO `net_city` VALUES ('30497', '23', 'Феррон', 'Ferron', 'UT', '84523', '39.1031', '-111.1674');
INSERT INTO `net_city` VALUES ('30498', '23', 'Уэндовер', 'Wendover', 'UT', '84083', '40.8494', '-114.0239');
INSERT INTO `net_city` VALUES ('30501', '23', 'Траер', 'Traer', 'IA', '50675', '42.2065', '-92.4961');
INSERT INTO `net_city` VALUES ('30506', '23', 'Нова', 'Nova', 'OH', '44859', '41.0168', '-82.3228');
INSERT INTO `net_city` VALUES ('30525', '23', 'Беллеэр Бич', 'Belleair Beach', 'FL', '33786', '27.9237', '-82.8424');
INSERT INTO `net_city` VALUES ('30526', '23', 'Ландисвилл', 'Landisville', 'NJ', '08326', '39.5336', '-74.9331');
INSERT INTO `net_city` VALUES ('30547', '23', 'Ист Хелена', 'East Helena', 'MT', '59635', '46.5366', '-111.7695');
INSERT INTO `net_city` VALUES ('30548', '21', 'Аттоксетер', 'Uttoxeter', 'M9', '', '52.9000', '-1.8500');
INSERT INTO `net_city` VALUES ('30551', '21', 'Хонитон', 'Honiton', 'D4', '', '50.8000', '-3.1833');
INSERT INTO `net_city` VALUES ('30567', '23', 'Слейт Хилл', 'Slate Hill', 'NY', '10973', '41.3853', '-74.4738');
INSERT INTO `net_city` VALUES ('30569', '23', 'Китс Хилл', 'Kitts Hill', 'OH', '45645', '38.5731', '-82.5419');
INSERT INTO `net_city` VALUES ('30571', '23', 'Хинтон', 'Hinton', 'IA', '51024', '42.6198', '-96.2810');
INSERT INTO `net_city` VALUES ('30576', '23', 'Одеболт', 'Odebolt', 'IA', '51458', '42.3137', '-95.2262');
INSERT INTO `net_city` VALUES ('30582', '23', 'Рутвен', 'Ruthven', 'IA', '51358', '43.1260', '-94.9046');
INSERT INTO `net_city` VALUES ('30583', '23', 'Олин', 'Olin', 'IA', '52320', '42.0003', '-91.1491');
INSERT INTO `net_city` VALUES ('30592', '125', 'Мосс', 'Moss', '13', '', '59.4367', '10.6692');
INSERT INTO `net_city` VALUES ('30593', '12', 'Роберт', 'Robert', 'B1', '', '45.4299', '2.0471');
INSERT INTO `net_city` VALUES ('30599', '23', 'Серджантсвилл', 'Sergeantsville', 'NJ', '08557', '40.4459', '-74.9435');
INSERT INTO `net_city` VALUES ('30602', '23', 'Динвидди', 'Dinwiddie', 'VA', '23841', '37.0429', '-77.5580');
INSERT INTO `net_city` VALUES ('30603', '48', 'Нью-Плимут', 'New Plymouth', '00', '', '-39.0667', '174.0833');
INSERT INTO `net_city` VALUES ('30606', '1', 'Апуи', 'Upwey', '07', '', '-37.9000', '145.3333');
INSERT INTO `net_city` VALUES ('30607', '23', 'Пайн Буш', 'Pine Bush', 'NY', '12566', '41.6182', '-74.3361');
INSERT INTO `net_city` VALUES ('30608', '112', 'Херсон', 'Kherson', '08', '', '46.6558', '32.6178');
INSERT INTO `net_city` VALUES ('30611', '23', 'Осеола Милс', 'Osceola Mills', 'PA', '16666', '40.8594', '-78.3129');
INSERT INTO `net_city` VALUES ('30617', '23', 'Окдейл', 'Oakdale', 'LA', '71463', '30.8109', '-92.6156');
INSERT INTO `net_city` VALUES ('30618', '35', 'Малага', 'Malaga', '51', '', '36.7267', '-4.4348');
INSERT INTO `net_city` VALUES ('30619', '6', 'Ченнай', 'Chennai', '25', '', '13.0833', '80.2833');
INSERT INTO `net_city` VALUES ('30622', '23', 'Брантли', 'Brantley', 'AL', '36009', '31.5762', '-86.3202');
INSERT INTO `net_city` VALUES ('30754', '24', 'Эр', 'Ayr', 'ON', 'n0b1e0', '43.2833', '-80.4500');
INSERT INTO `net_city` VALUES ('30818', '29', 'Бохум', 'Bochum', '07', '', '51.4833', '7.2167');
INSERT INTO `net_city` VALUES ('30819', '181', 'Гибралтар', 'Gibraltar', '00', '', '36.1333', '-5.3500');
INSERT INTO `net_city` VALUES ('30822', '1', 'Митчелл', 'Mitchell', '04', '', '-26.4849', '147.9742');
INSERT INTO `net_city` VALUES ('30823', '17', 'Майа', 'Maia', '17', '', '41.2357', '-8.6199');
INSERT INTO `net_city` VALUES ('30825', '23', 'Годдард', 'Goddard', 'KS', '67052', '37.6565', '-97.5798');
INSERT INTO `net_city` VALUES ('30826', '129', 'Крань ', 'Kranj', '04', '', '46.2411', '14.3617');
INSERT INTO `net_city` VALUES ('30827', '29', 'Вадгассен ', 'Wadgassen', '09', '', '49.2667', '6.7833');
INSERT INTO `net_city` VALUES ('30830', '29', 'Шнефердинген ', 'Schneverdingen', '06', '', '53.1167', '9.8000');
INSERT INTO `net_city` VALUES ('30832', '12', 'Флер', 'Flers', '99', '', '48.7372', '-0.5747');
INSERT INTO `net_city` VALUES ('30834', '23', 'Портхилл', 'Porthill', 'ID', '83853', '48.9592', '-116.6232');
INSERT INTO `net_city` VALUES ('30836', '2', 'Куала-Тренгану', 'Kuala Terengganu', '13', '', '5.3302', '103.1408');
INSERT INTO `net_city` VALUES ('30838', '1', 'Кэрнс', 'Cairns', '04', '', '-16.9230', '145.7663');
INSERT INTO `net_city` VALUES ('30840', '23', 'Ном', 'Nome', 'TX', '77629', '30.0358', '-94.4244');
INSERT INTO `net_city` VALUES ('30841', '23', 'Форествилл', 'Forestville', 'CA', '95436', '38.4813', '-122.9061');
INSERT INTO `net_city` VALUES ('30844', '45', 'Джамби', 'Jambi', '05', '', '-1.6000', '103.6167');
INSERT INTO `net_city` VALUES ('30846', '182', 'Асунсьон', 'Asuncion', '06', '', '-25.2939', '-57.6111');
INSERT INTO `net_city` VALUES ('30847', '12', 'Людр', 'Ludres', 'B2', '', '48.6218', '6.1618');
INSERT INTO `net_city` VALUES ('30848', '22', 'Орхус', 'Aarhus', '01', '', '56.1500', '10.2167');
INSERT INTO `net_city` VALUES ('30858', '23', 'Ванак', 'Wanaque', 'NJ', '07465', '41.0404', '-74.3010');
INSERT INTO `net_city` VALUES ('30862', '23', 'Амауолк', 'Amawalk', 'NY', '10501', '41.2924', '-73.7623');
INSERT INTO `net_city` VALUES ('30908', '24', 'Эйлмер', 'Aylmer', 'ON', 'n5h1z9', '42.7742', '-80.9746');
INSERT INTO `net_city` VALUES ('31033', '23', 'Кэтлин', 'Kathleen', 'GA', '31047', '32.4614', '-83.6014');
INSERT INTO `net_city` VALUES ('31122', '23', 'Уэйд', 'Wade', 'NC', '28395', '35.1242', '-78.7475');
INSERT INTO `net_city` VALUES ('31128', '23', 'Полдинг', 'Paulding', 'OH', '45879', '41.1310', '-84.5568');
INSERT INTO `net_city` VALUES ('31132', '23', 'Пик', 'Peak', 'SC', '29122', '34.2407', '-81.3234');
INSERT INTO `net_city` VALUES ('31133', '23', 'Барнуэлл', 'Barnwell', 'SC', '29812', '33.2342', '-81.4731');
INSERT INTO `net_city` VALUES ('31146', '23', 'Шоборо', 'Shawboro', 'NC', '27973', '36.3994', '-76.0927');
INSERT INTO `net_city` VALUES ('31149', '23', 'Браунсборо', 'Brownsboro', 'AL', '35741', '34.7206', '-86.4724');
INSERT INTO `net_city` VALUES ('31150', '23', 'Бринсон', 'Brinson', 'GA', '39825', '30.9494', '-84.7107');
INSERT INTO `net_city` VALUES ('31174', '23', 'Картер Лейк', 'Carter Lake', 'IA', '51510', '41.2869', '-95.9169');
INSERT INTO `net_city` VALUES ('31175', '23', 'Флориссант', 'Florissant', 'CO', '80816', '38.8522', '-105.3181');
INSERT INTO `net_city` VALUES ('31205', '15', 'Сёдерхамн', 'Soderhamn', '03', '', '61.3000', '17.0500');
INSERT INTO `net_city` VALUES ('31211', '23', 'Плейнвилл', 'Plainville', 'KS', '67663', '39.2270', '-99.3379');
INSERT INTO `net_city` VALUES ('31218', '23', 'Файет Сити', 'Fayette City', 'PA', '15438', '40.0776', '-79.8290');
INSERT INTO `net_city` VALUES ('31219', '23', 'Уоусеон', 'Wauseon', 'OH', '43567', '41.5824', '-84.1435');
INSERT INTO `net_city` VALUES ('31221', '23', 'Конкорд', 'Concord', 'MI', '49237', '42.1752', '-84.6418');
INSERT INTO `net_city` VALUES ('31223', '23', 'Тоника', 'Tonica', 'IL', '61370', '41.2147', '-89.0474');
INSERT INTO `net_city` VALUES ('31225', '23', 'Каслтон-он-Гудзон', 'Castleton On Hudson', 'NY', '12033', '42.5325', '-73.7042');
INSERT INTO `net_city` VALUES ('31226', '23', 'Финишия', 'Phoenicia', 'NY', '12464', '42.0340', '-74.3524');
INSERT INTO `net_city` VALUES ('31228', '23', 'Индиан Рокс Бич', 'Indian Rocks Beach', 'FL', '33785', '27.8736', '-82.8500');
INSERT INTO `net_city` VALUES ('31234', '23', 'Бримсон', 'Brimson', 'MN', '55602', '47.3506', '-91.9001');
INSERT INTO `net_city` VALUES ('31238', '23', 'Пало Седро', 'Palo Cedro', 'CA', '96073', '40.5661', '-122.2019');
INSERT INTO `net_city` VALUES ('31240', '23', 'Роуз Сити', 'Rose City', 'MI', '48654', '44.4719', '-84.1297');
INSERT INTO `net_city` VALUES ('31243', '23', 'Пагоса Спрингс', 'Pagosa Springs', 'CO', '81147', '37.3442', '-107.0802');
INSERT INTO `net_city` VALUES ('31244', '23', 'Берта', 'Bertha', 'MN', '56437', '46.2488', '-95.0531');
INSERT INTO `net_city` VALUES ('31246', '23', 'Паркерс-Прери', 'Parkers Prairie', 'MN', '56361', '46.1713', '-95.3385');
INSERT INTO `net_city` VALUES ('31247', '23', 'Мак-Грегор', 'Mcgregor', 'MN', '55760', '46.6282', '-93.2608');
INSERT INTO `net_city` VALUES ('31249', '23', 'Милака', 'Milaca', 'MN', '56353', '45.7856', '-93.6209');
INSERT INTO `net_city` VALUES ('31250', '23', 'Балатон', 'Balaton', 'MN', '56115', '44.2071', '-95.9019');
INSERT INTO `net_city` VALUES ('31251', '23', 'Мотли', 'Motley', 'MN', '56466', '46.4444', '-94.6486');
INSERT INTO `net_city` VALUES ('31256', '23', 'Баттерфилд', 'Butterfield', 'MN', '56120', '43.9712', '-94.7793');
INSERT INTO `net_city` VALUES ('31259', '23', 'Уиннебаго', 'Winnebago', 'MN', '56098', '43.7570', '-94.1925');
INSERT INTO `net_city` VALUES ('31261', '23', 'Гиббон', 'Gibbon', 'MN', '55335', '44.5251', '-94.5354');
INSERT INTO `net_city` VALUES ('31265', '23', 'Шерберн', 'Sherburn', 'MN', '56171', '43.6692', '-94.7495');
INSERT INTO `net_city` VALUES ('31267', '23', 'Уотервилл', 'Waterville', 'MN', '56096', '44.2367', '-93.6034');
INSERT INTO `net_city` VALUES ('31269', '23', 'Олден', 'Alden', 'MN', '56009', '43.6467', '-93.5451');
INSERT INTO `net_city` VALUES ('31273', '23', 'Окли', 'Oklee', 'MN', '56742', '47.9340', '-95.8279');
INSERT INTO `net_city` VALUES ('31274', '23', 'Альберта', 'Alberta', 'MN', '56207', '45.4920', '-96.0618');
INSERT INTO `net_city` VALUES ('31278', '23', 'Клирбрук', 'Clearbrook', 'MN', '56634', '47.6959', '-95.4063');
INSERT INTO `net_city` VALUES ('31281', '23', 'Холивилл', 'Hawleyville', 'CT', '06440', '41.4276', '-73.3551');
INSERT INTO `net_city` VALUES ('31293', '23', 'Сисайд', 'Seaside', 'OR', '97138', '45.9282', '-123.7093');
INSERT INTO `net_city` VALUES ('31297', '23', 'Коттедж Гров', 'Cottage Grove', 'OR', '97424', '43.7163', '-123.0374');
INSERT INTO `net_city` VALUES ('31317', '23', 'Прейри Сити', 'Prairie City', 'IA', '50228', '41.5815', '-93.2370');
INSERT INTO `net_city` VALUES ('31330', '23', 'Нако', 'Naco', 'AZ', '85620', '31.3354', '-109.9481');
INSERT INTO `net_city` VALUES ('31331', '23', 'Бондьюрант', 'Bondurant', 'WY', '82922', '43.1226', '-110.3816');
INSERT INTO `net_city` VALUES ('31334', '23', 'Космос', 'Cosmos', 'MN', '56228', '44.9498', '-94.6711');
INSERT INTO `net_city` VALUES ('31338', '23', 'Найн Майл Фолс', 'Nine Mile Falls', 'WA', '99026', '47.8084', '-117.6226');
INSERT INTO `net_city` VALUES ('31343', '23', 'Джексонвилл', 'Jacksonville', 'OR', '97530', '42.1882', '-123.0465');
INSERT INTO `net_city` VALUES ('31347', '23', 'Уильямс', 'Williams', 'OR', '97544', '42.1487', '-123.3258');
INSERT INTO `net_city` VALUES ('31348', '23', 'Уинстон', 'Winston', 'OR', '97496', '43.0512', '-123.5043');
INSERT INTO `net_city` VALUES ('31354', '23', 'Уэллсвилл', 'Wellsville', 'UT', '84339', '41.6231', '-111.9313');
INSERT INTO `net_city` VALUES ('31356', '23', 'Коринн', 'Corinne', 'UT', '84307', '41.4635', '-112.4721');
INSERT INTO `net_city` VALUES ('31357', '23', 'Села', 'Selah', 'WA', '98942', '46.7682', '-120.6872');
INSERT INTO `net_city` VALUES ('31362', '23', 'Ювальда', 'Uvalda', 'GA', '30473', '32.0151', '-82.4835');
INSERT INTO `net_city` VALUES ('31366', '23', 'Риджуэй', 'Ridgeway', 'SC', '29130', '34.3249', '-80.8812');
INSERT INTO `net_city` VALUES ('31372', '23', 'Дуриея', 'Duryea', 'PA', '18642', '41.3540', '-75.7728');
INSERT INTO `net_city` VALUES ('31377', '23', 'Бингер', 'Binger', 'OK', '73009', '35.2690', '-98.3763');
INSERT INTO `net_city` VALUES ('31384', '23', 'Уабаша', 'Wabasha', 'MN', '55981', '44.3438', '-92.0607');
INSERT INTO `net_city` VALUES ('31387', '23', 'Фортуна', 'Fortuna', 'CA', '95540', '40.5788', '-124.1500');
INSERT INTO `net_city` VALUES ('31390', '23', 'Флэтония', 'Flatonia', 'TX', '78941', '29.7689', '-97.1403');
INSERT INTO `net_city` VALUES ('31392', '23', 'Ашдаун', 'Ashdown', 'AR', '71822', '33.6703', '-94.1151');
INSERT INTO `net_city` VALUES ('31407', '23', 'Уэнделл', 'Wendell', 'ID', '83355', '42.7471', '-114.7325');
INSERT INTO `net_city` VALUES ('31409', '23', 'Хомдейл', 'Homedale', 'ID', '83628', '43.5909', '-116.9492');
INSERT INTO `net_city` VALUES ('31410', '23', 'Уэипп', 'Weippe', 'ID', '83553', '46.3830', '-115.8976');
INSERT INTO `net_city` VALUES ('31411', '23', 'Нордман', 'Nordman', 'ID', '83848', '48.6709', '-116.8875');
INSERT INTO `net_city` VALUES ('31414', '23', 'Лаклид', 'Laclede', 'ID', '83841', '48.1702', '-116.7560');
INSERT INTO `net_city` VALUES ('31418', '137', 'Триполи ', 'Tripoli', '03', '', '34.4333', '35.8500');
INSERT INTO `net_city` VALUES ('31420', '21', 'Ромси', 'Romsey', 'F2', '', '50.9833', '-1.5000');
INSERT INTO `net_city` VALUES ('31421', '23', 'Галлиано', 'Galliano', 'LA', '70354', '29.4388', '-90.2915');
INSERT INTO `net_city` VALUES ('31422', '5', 'Фукуока', 'Fukuoka', '07', '', '33.6064', '130.4181');
INSERT INTO `net_city` VALUES ('31429', '23', 'Маркхам', 'Markham', 'IL', '60428', '41.5936', '-87.6948');
INSERT INTO `net_city` VALUES ('31431', '23', 'Глендайв', 'Glendive', 'MT', '59330', '47.1294', '-104.8734');
INSERT INTO `net_city` VALUES ('31435', '23', 'Дир Ривер', 'Deer River', 'MN', '56636', '47.3851', '-93.8770');
INSERT INTO `net_city` VALUES ('31441', '23', 'Авон-бай-зе-Си', 'Avon-by-the-Sea', 'NJ', '07717', '40.1925', '-74.0160');
INSERT INTO `net_city` VALUES ('31442', '23', 'Келлиер', 'Kelliher', 'MN', '56650', '47.9895', '-94.5796');
INSERT INTO `net_city` VALUES ('31443', '23', 'Нортом', 'Northome', 'MN', '56661', '47.8242', '-94.1691');
INSERT INTO `net_city` VALUES ('31445', '23', 'Меридианвилл', 'Meridianville', 'AL', '35759', '34.8660', '-86.5536');
INSERT INTO `net_city` VALUES ('31450', '30', 'Шираз', 'Shiraz', '07', '', '29.6036', '52.5388');
INSERT INTO `net_city` VALUES ('31470', '23', 'Аддисон', 'Addison', 'AL', '35540', '34.2285', '-87.1775');
INSERT INTO `net_city` VALUES ('31472', '23', 'Вреденбург', 'Vredenburgh', 'AL', '36481', '31.7543', '-87.3773');
INSERT INTO `net_city` VALUES ('31484', '23', 'Стерретт', 'Sterrett', 'AL', '35147', '33.4183', '-86.5378');
INSERT INTO `net_city` VALUES ('31502', '23', 'Маунт Кармел', 'Mount Carmel', 'TN', '37645', '36.5630', '-82.6638');
INSERT INTO `net_city` VALUES ('31511', '23', 'Ханна', 'Hanna', 'WY', '82327', '42.0325', '-106.6627');
INSERT INTO `net_city` VALUES ('31512', '23', 'Ранчестер', 'Ranchester', 'WY', '82839', '44.9103', '-107.1417');
INSERT INTO `net_city` VALUES ('31518', '1', 'Сифорд', 'Seaford', '07', '', '-38.1000', '145.1333');
INSERT INTO `net_city` VALUES ('31519', '21', 'Ковентри', 'Coventry', 'C7', '', '52.4167', '-1.5500');
INSERT INTO `net_city` VALUES ('31520', '35', 'Сан-Агустин', 'San Agustin', '59', '', '43.1316', '-2.5634');
INSERT INTO `net_city` VALUES ('31521', '117', 'Лимасол', 'Limassol', '05', '', '34.6750', '33.0333');
INSERT INTO `net_city` VALUES ('31522', '49', 'Пномпень ', 'Phnom Penh', '11', '', '11.5500', '104.9167');
INSERT INTO `net_city` VALUES ('31527', '56', 'Льеж', 'Liege', '04', '', '50.6333', '5.5667');
INSERT INTO `net_city` VALUES ('31536', '23', 'Нью Берлинвилл', 'New Berlinville', 'PA', '19545', '40.3454', '-75.6330');
INSERT INTO `net_city` VALUES ('31541', '9', 'Паттайя', 'Pattaya', '46', '', '12.9333', '100.8833');
INSERT INTO `net_city` VALUES ('31543', '23', 'Жанеретт', 'Jeanerette', 'LA', '70544', '29.9083', '-91.6802');
INSERT INTO `net_city` VALUES ('31544', '13', 'Таранто', 'Taranto', '13', '', '40.4761', '17.2297');
INSERT INTO `net_city` VALUES ('31546', '14', 'Абу-Даби', 'Abu Dhabi', '01', '', '24.4667', '54.3667');
INSERT INTO `net_city` VALUES ('31547', '40', 'Пуэрто Мадрин', 'Puerto Madryn', '04', '', '-42.7692', '-65.0385');
INSERT INTO `net_city` VALUES ('31548', '21', 'Алтринчем', 'Altrincham', 'C5', '', '53.3833', '-2.3500');
INSERT INTO `net_city` VALUES ('31551', '23', 'Роджерсон', 'Rogerson', 'ID', '83302', '42.1122', '-114.9508');
INSERT INTO `net_city` VALUES ('31552', '29', 'Бонн', 'Bonn', '07', '', '50.7333', '7.1000');
INSERT INTO `net_city` VALUES ('31555', '23', 'Харрикейн', 'Hurricane', 'WV', '25526', '38.4043', '-81.9702');
INSERT INTO `net_city` VALUES ('31556', '23', 'Чапманвилл', 'Chapmanville', 'WV', '25508', '37.9411', '-82.0660');
INSERT INTO `net_city` VALUES ('31568', '23', 'Филиппи', 'Philippi', 'WV', '26416', '39.1790', '-80.0792');
INSERT INTO `net_city` VALUES ('31577', '23', 'Данбар', 'Dunbar', 'WV', '25064', '38.3760', '-81.7477');
INSERT INTO `net_city` VALUES ('31579', '33', 'Маастрихт', 'Maastricht', '05', '', '50.8500', '5.6833');
INSERT INTO `net_city` VALUES ('31581', '23', 'Саут Лондондерри', 'South Londonderry', 'VT', '05155', '43.0799', '-72.9140');
INSERT INTO `net_city` VALUES ('31590', '23', 'Уэверли', 'Waverly', 'AL', '36879', '32.7336', '-85.5368');
INSERT INTO `net_city` VALUES ('31591', '23', 'Уитмайр', 'Whitmire', 'SC', '29178', '34.5020', '-81.6040');
INSERT INTO `net_city` VALUES ('31593', '23', 'Спайсвуд', 'Spicewood', 'TX', '78669', '30.4444', '-98.1347');
INSERT INTO `net_city` VALUES ('31596', '23', 'Ривервью', 'Riverview', 'MI', '48193', '42.1742', '-83.1794');
INSERT INTO `net_city` VALUES ('31598', '151', 'Манама', 'Manama', '02', '', '26.2361', '50.5831');
INSERT INTO `net_city` VALUES ('31601', '23', 'Айленд Понд', 'Island Pond', 'VT', '05846', '44.8303', '-71.8189');
INSERT INTO `net_city` VALUES ('31605', '23', 'Ридсборо', 'Readsboro', 'VT', '05350', '42.7992', '-72.9717');
INSERT INTO `net_city` VALUES ('31607', '23', 'Ист Монтпилиер', 'East Montpelier', 'VT', '05651', '44.2816', '-72.4966');
INSERT INTO `net_city` VALUES ('31613', '23', 'Моравия', 'Moravia', 'NY', '13118', '42.7484', '-76.4060');
INSERT INTO `net_city` VALUES ('31614', '23', 'Боствик', 'Bostwick', 'FL', '32007', '29.7741', '-81.6370');
INSERT INTO `net_city` VALUES ('31617', '23', 'Квилин', 'Quilcene', 'WA', '98376', '47.8254', '-122.8453');
INSERT INTO `net_city` VALUES ('31624', '23', 'Джонсонберг', 'Johnsonburg', 'NJ', '07846', '40.9645', '-74.8785');
INSERT INTO `net_city` VALUES ('31625', '23', 'Карнс Сити', 'Karns City', 'PA', '16041', '41.0063', '-79.6646');
INSERT INTO `net_city` VALUES ('31761', '21', 'Теддингтон', 'Teddington', '17', '', '51.4167', '-0.3333');
INSERT INTO `net_city` VALUES ('31793', '29', 'Мангейм', 'Mannheim', '01', '', '49.4883', '8.4647');
INSERT INTO `net_city` VALUES ('31808', '23', 'Шейди Сайд', 'Shady Side', 'MD', '20764', '38.8288', '-76.5114');
INSERT INTO `net_city` VALUES ('31811', '23', 'Риз', 'Reese', 'MI', '48757', '43.4868', '-83.6773');
INSERT INTO `net_city` VALUES ('31812', '23', 'Мейвилл', 'Mayville', 'MI', '48744', '43.3378', '-83.3727');
INSERT INTO `net_city` VALUES ('31814', '23', 'Байхалия', 'Byhalia', 'MS', '38611', '34.8260', '-89.6795');
INSERT INTO `net_city` VALUES ('31816', '23', 'Скаппуз', 'Scappoose', 'OR', '97056', '45.8002', '-122.9735');
INSERT INTO `net_city` VALUES ('31819', '23', 'Сатсоп', 'Satsop', 'WA', '98583', '47.0031', '-123.4835');
INSERT INTO `net_city` VALUES ('31822', '33', 'Вассенар', 'Wassenaar', '11', '', '52.1108', '4.3560');
INSERT INTO `net_city` VALUES ('31826', '21', 'Нортгемптон', 'Northampton', 'J1', '', '52.2500', '-0.8833');
INSERT INTO `net_city` VALUES ('31837', '23', 'Старк', 'Starke', 'FL', '32091', '29.9254', '-82.0791');
INSERT INTO `net_city` VALUES ('31848', '23', 'Сайчуат', 'Scituate', 'MA', '02066', '42.2081', '-70.7750');
INSERT INTO `net_city` VALUES ('31850', '23', 'Бартлетт', 'Bartlett', 'NH', '03812', '44.1176', '-71.1743');
INSERT INTO `net_city` VALUES ('31857', '23', 'Норт Бонневилл', 'North Bonneville', 'WA', '98639', '45.6373', '-121.9712');
INSERT INTO `net_city` VALUES ('31859', '23', 'Линкольн Сити', 'Lincoln City', 'OR', '97367', '44.9435', '-123.9487');
INSERT INTO `net_city` VALUES ('31864', '23', 'Коннелл', 'Connell', 'WA', '99326', '46.6686', '-118.9033');
INSERT INTO `net_city` VALUES ('31873', '23', 'Саутолд', 'Southold', 'NY', '11971', '41.0639', '-72.4290');
INSERT INTO `net_city` VALUES ('31879', '23', 'Пакстон', 'Paxton', 'MA', '01612', '42.3154', '-71.9293');
INSERT INTO `net_city` VALUES ('31880', '23', 'Стербридж', 'Sturbridge', 'MA', '01566', '42.1017', '-72.0798');
INSERT INTO `net_city` VALUES ('31882', '23', 'Уэстпарк', 'Westport', 'MA', '02790', '41.6077', '-71.0676');
INSERT INTO `net_city` VALUES ('31883', '23', 'Пикетт', 'Pickett', 'WI', '54964', '43.9171', '-88.7257');
INSERT INTO `net_city` VALUES ('31884', '23', 'Маунт Худ Паркдейл', 'Mount Hood Parkdale', 'OR', '97041', '45.4325', '-121.6330');
INSERT INTO `net_city` VALUES ('31885', '23', 'Уайт Салмон', 'White Salmon', 'WA', '98672', '45.8223', '-121.4637');
INSERT INTO `net_city` VALUES ('31968', '23', 'Ренц', 'Rentz', 'GA', '31075', '32.3458', '-82.9638');
INSERT INTO `net_city` VALUES ('31970', '23', 'Дариен', 'Darien', 'GA', '31305', '31.4116', '-81.4167');
INSERT INTO `net_city` VALUES ('31972', '23', 'Стюартстаун', 'Stewartstown', 'PA', '17363', '39.7724', '-76.5845');
INSERT INTO `net_city` VALUES ('31974', '23', 'Норт Бриджтон', 'North Bridgton', 'ME', '04057', '44.0987', '-70.6987');
INSERT INTO `net_city` VALUES ('31975', '23', 'Кастин', 'Castine', 'ME', '04420', '44.4130', '-68.7980');
INSERT INTO `net_city` VALUES ('31981', '23', 'Лон Пайн', 'Lone Pine', 'CA', '93545', '36.5647', '-118.1873');
INSERT INTO `net_city` VALUES ('32074', '13', 'Вимеркате', 'Vimercate', '09', '', '45.6167', '9.3667');
INSERT INTO `net_city` VALUES ('32076', '13', 'Карпи ', 'Carpi', '05', '', '44.7833', '10.8833');
INSERT INTO `net_city` VALUES ('32077', '13', 'Бари', 'Bari', '13', '', '41.1333', '16.8500');
INSERT INTO `net_city` VALUES ('32080', '13', 'Модена', 'Modena', '05', '', '44.6667', '10.9167');
INSERT INTO `net_city` VALUES ('32081', '13', 'Сора', 'Sora', '07', '', '41.7167', '13.6167');
INSERT INTO `net_city` VALUES ('32082', '13', 'Эсте', 'Este', '20', '', '45.2333', '11.6500');
INSERT INTO `net_city` VALUES ('32083', '13', 'Фолиньо', 'Foligno', '18', '', '42.9500', '12.7000');
INSERT INTO `net_city` VALUES ('32084', '23', 'Дестрхен', 'Destrehan', 'LA', '70047', '29.9671', '-90.3606');
INSERT INTO `net_city` VALUES ('32094', '23', 'Поллок Пайнс', 'Pollock Pines', 'CA', '95726', '38.7427', '-120.5744');
INSERT INTO `net_city` VALUES ('32104', '23', 'Гибсонтон', 'Gibsonton', 'FL', '33534', '27.7967', '-82.3797');
INSERT INTO `net_city` VALUES ('32105', '23', 'Кромвель', 'Cromwell', 'OK', '74837', '35.3441', '-96.4590');
INSERT INTO `net_city` VALUES ('32108', '23', 'Уонетт', 'Wanette', 'OK', '74878', '35.0193', '-97.0443');
INSERT INTO `net_city` VALUES ('32109', '23', 'Локуст Гров', 'Locust Grove', 'OK', '74352', '36.1214', '-95.1688');
INSERT INTO `net_city` VALUES ('32110', '23', 'Оилтон', 'Oilton', 'OK', '74052', '36.0845', '-96.5836');
INSERT INTO `net_city` VALUES ('32112', '127', 'Вайц', 'Weiz', '06', '', '47.2167', '15.6167');
INSERT INTO `net_city` VALUES ('32114', '23', 'Каско', 'Casco', 'MI', '48064', '42.7674', '-82.6728');
INSERT INTO `net_city` VALUES ('32117', '23', 'Ла-Хонда', 'La Honda', 'CA', '94020', '37.2885', '-122.2402');
INSERT INTO `net_city` VALUES ('32134', '23', 'Дуайт', 'Dwight', 'IL', '60420', '41.0946', '-88.4200');
INSERT INTO `net_city` VALUES ('32139', '23', 'Ларнед', 'Larned', 'KS', '67550', '38.1752', '-99.1569');
INSERT INTO `net_city` VALUES ('32145', '23', 'Харджил', 'Hargill', 'TX', '78549', '26.4682', '-98.0393');
INSERT INTO `net_city` VALUES ('32154', '110', 'Прушкув', 'Pruszkow', '67', '', '52.1667', '20.8333');
INSERT INTO `net_city` VALUES ('32155', '23', 'Виндхам', 'Windham', 'CT', '06280', '41.7008', '-72.1389');
INSERT INTO `net_city` VALUES ('32162', '23', 'Нидвилл', 'Needville', 'TX', '77461', '29.3905', '-95.7479');
INSERT INTO `net_city` VALUES ('32167', '46', 'Равалпинди', 'Rawalpindi', '04', '', '33.6007', '73.0679');
INSERT INTO `net_city` VALUES ('32172', '23', 'Раунд Маунтин', 'Round Mountain', 'TX', '78663', '30.4104', '-98.2836');
INSERT INTO `net_city` VALUES ('32173', '23', 'Манчака', 'Manchaca', 'TX', '78652', '30.1329', '-97.8556');
INSERT INTO `net_city` VALUES ('32304', '23', 'Коррелл', 'Correll', 'MN', '56227', '45.2944', '-96.1671');
INSERT INTO `net_city` VALUES ('32306', '15', 'Лидчёпинг ', 'Lidköping', '28', '', '58.5000', '13.1667');
INSERT INTO `net_city` VALUES ('32308', '23', 'Вудбери', 'Woodbury', 'MN', '55055', '44.8728', '-92.9955');
INSERT INTO `net_city` VALUES ('32310', '18', 'Ларисса', 'Larissa', '21', '', '39.6372', '22.4203');
INSERT INTO `net_city` VALUES ('32316', '20', 'Калининград', 'Kaliningrad', '23', '', '54.7065', '20.5110');
INSERT INTO `net_city` VALUES ('32318', '13', 'Неаполь', 'Naples', '04', '', '40.8333', '14.2500');
INSERT INTO `net_city` VALUES ('32319', '144', 'Каунас', 'Kaunas', '57', '', '54.9000', '23.9000');
INSERT INTO `net_city` VALUES ('32320', '21', 'Сандерленд', 'Sunderland', 'N6', '', '54.9119', '-1.3833');
INSERT INTO `net_city` VALUES ('32324', '23', 'Хоб Саунд', 'Hobe Sound', 'FL', '33455', '27.0545', '-80.1436');
INSERT INTO `net_city` VALUES ('32325', '35', 'Мариана', 'Mariana', '54', '', '40.1672', '-2.1460');
INSERT INTO `net_city` VALUES ('32326', '21', 'Донкастер', 'Doncaster', 'D5', '', '53.5333', '-1.1167');
INSERT INTO `net_city` VALUES ('32327', '23', 'Клир Брук', 'Clear Brook', 'VA', '22624', '39.2715', '-78.0843');
INSERT INTO `net_city` VALUES ('32329', '23', 'Спрингпорт', 'Springport', 'MI', '49284', '42.3925', '-84.6989');
INSERT INTO `net_city` VALUES ('32332', '23', 'Грантсберг', 'Grantsburg', 'WI', '54840', '45.7564', '-92.6903');
INSERT INTO `net_city` VALUES ('32334', '40', 'Санта-Фе', 'Santa Fe', '21', '', '-31.6295', '-60.7010');
INSERT INTO `net_city` VALUES ('32338', '23', 'Пласида', 'Placida', 'FL', '33946', '26.8574', '-82.3116');
INSERT INTO `net_city` VALUES ('32345', '21', 'Холиуэлл', 'Holywell', 'Y1', '', '53.2833', '-3.2500');
INSERT INTO `net_city` VALUES ('32346', '23', 'Бендж', 'Benge', 'WA', '99105', '46.8881', '-118.1507');
INSERT INTO `net_city` VALUES ('32350', '21', 'Мьюир оф Орд', 'Muir of Ord', 'V3', '', '57.5167', '-4.4500');
INSERT INTO `net_city` VALUES ('32351', '15', 'Умео', 'Umea', '23', '', '63.8333', '20.2500');
INSERT INTO `net_city` VALUES ('32352', '12', 'Аньер-сюр-Сен', 'Asnieres-sur-Seine', 'A8', '', '48.8939', '2.2886');
INSERT INTO `net_city` VALUES ('32353', '21', 'Эпсом', 'Epsom', 'N7', '', '51.3167', '-0.2667');
INSERT INTO `net_city` VALUES ('32354', '13', 'Триест', 'Trieste', '06', '', '45.6486', '13.7800');
INSERT INTO `net_city` VALUES ('32358', '29', 'Дитценбах', 'Dietzenbach', '05', '', '50.0167', '8.7833');
INSERT INTO `net_city` VALUES ('32359', '59', 'Баден', 'Baden', '01', '', '47.4780', '8.3028');
INSERT INTO `net_city` VALUES ('32361', '21', 'Дройтуич Спа', 'Droitwich Spa', 'Q4', '', '52.2667', '-2.1500');
INSERT INTO `net_city` VALUES ('32362', '12', 'Брон', 'Bron', 'B9', '', '45.7402', '4.9224');
INSERT INTO `net_city` VALUES ('32363', '15', 'Уппсала', 'Uppsala', '21', '', '59.8500', '17.6333');
INSERT INTO `net_city` VALUES ('32365', '110', 'Варшава', 'Warsaw', '67', '', '52.2500', '21.0000');
INSERT INTO `net_city` VALUES ('32366', '35', 'Хатива', 'Xativa', '60', '', '38.9852', '-0.5570');
INSERT INTO `net_city` VALUES ('32367', '33', 'Барневелд', 'Barneveld', '03', '', '52.1416', '5.5845');
INSERT INTO `net_city` VALUES ('32368', '21', 'Севеноукс', 'Sevenoaks', 'G5', '', '51.2667', '0.2000');
INSERT INTO `net_city` VALUES ('32371', '21', 'Белфаст', 'Belfast', 'R3', '', '54.5833', '-5.9333');
INSERT INTO `net_city` VALUES ('32373', '29', 'Бремен', 'Bremen', '03', '', '53.0833', '8.8000');
INSERT INTO `net_city` VALUES ('32376', '44', 'Кавите', 'Cavite', 'B6', '', '14.4778', '120.8932');
INSERT INTO `net_city` VALUES ('32378', '44', 'Кордова', 'Cordova (Cebu)', 'B7', '', '10.3000', '123.8833');
INSERT INTO `net_city` VALUES ('32380', '29', 'Шлезвиг', 'Schleswig', '10', '', '54.5167', '9.5500');
INSERT INTO `net_city` VALUES ('32382', '21', 'Бракли', 'Brackley', 'V3', '', '57.5500', '-4.0167');
INSERT INTO `net_city` VALUES ('32383', '21', 'Эдинбург', 'Edinburgh', 'U8', '', '55.9500', '-3.2000');
INSERT INTO `net_city` VALUES ('32385', '56', 'Лувэн-Ла-Нёв', 'Louvain-la-Neuve', '12', '', '50.8833', '4.7000');
INSERT INTO `net_city` VALUES ('32387', '23', 'Брадентон Бич', 'Bradenton Beach', 'FL', '34217', '27.4857', '-82.7044');
INSERT INTO `net_city` VALUES ('32393', '23', 'Гомер Сити', 'Homer City', 'PA', '15748', '40.5251', '-79.1096');
INSERT INTO `net_city` VALUES ('32395', '23', 'Бригантин', 'Brigantine', 'NJ', '08203', '39.4079', '-74.3665');
INSERT INTO `net_city` VALUES ('32397', '23', 'Эстелл Манор', 'Estell Manor', 'NJ', '08319', '39.3612', '-74.8082');
INSERT INTO `net_city` VALUES ('32402', '23', 'Шуйлер', 'Schuyler', 'VA', '22969', '37.8076', '-78.6842');
INSERT INTO `net_city` VALUES ('32407', '23', 'Веллинг', 'Welling', 'OK', '74471', '35.8212', '-94.8783');
INSERT INTO `net_city` VALUES ('32469', '23', 'Алгона', 'Algona', 'IA', '50511', '43.0676', '-94.2232');
INSERT INTO `net_city` VALUES ('32473', '21', 'Маркет-Рейзен', 'Market Rasen', 'H7', '', '53.3833', '-0.3333');
INSERT INTO `net_city` VALUES ('32474', '14', 'Рас-эль-Хайма', 'Ras Al Khaimah', '05', '', '25.7895', '55.9432');
INSERT INTO `net_city` VALUES ('32475', '21', 'Грэнтем', 'Grantham', 'H7', '', '52.9000', '-0.6333');
INSERT INTO `net_city` VALUES ('32476', '21', 'Бери', 'Bury', 'C1', '', '53.6000', '-2.3000');
INSERT INTO `net_city` VALUES ('32480', '23', 'Джефферсонтаун', 'Jeffersontown', 'KY', '40056', '38.3029', '-85.4901');
INSERT INTO `net_city` VALUES ('32489', '23', 'Белград', 'Belgrade', 'MN', '56312', '45.4742', '-94.9677');
INSERT INTO `net_city` VALUES ('32490', '56', 'Алст', 'Aalst', '08', '', '50.9333', '4.0333');
INSERT INTO `net_city` VALUES ('32493', '23', 'Оспри', 'Osprey', 'FL', '34229', '27.1896', '-82.4802');
INSERT INTO `net_city` VALUES ('32497', '20', 'Санкт-Петербург', 'St Petersburg', '66', '', '59.8944', '30.2642');
INSERT INTO `net_city` VALUES ('32500', '23', 'Сакстон', 'Saxton', 'PA', '16678', '40.2296', '-78.2883');
INSERT INTO `net_city` VALUES ('32501', '23', 'Де Леон Спрингс', 'De Leon Springs', 'FL', '32130', '29.1813', '-81.3326');
INSERT INTO `net_city` VALUES ('32509', '23', 'Ошен Спрингс', 'Ocean Springs', 'MS', '39564', '30.4007', '-88.7587');
INSERT INTO `net_city` VALUES ('32510', '23', 'Ширли', 'Shirley', 'IN', '47384', '39.9232', '-85.5486');
INSERT INTO `net_city` VALUES ('32513', '23', 'Вамего', 'Wamego', 'KS', '66547', '39.2591', '-96.3007');
INSERT INTO `net_city` VALUES ('32515', '23', 'Лейк Джуналаска', 'Lake Junaluska', 'NC', '28745', '35.5252', '-82.9711');
INSERT INTO `net_city` VALUES ('32519', '23', 'Карролтон', 'Carrollton', 'MS', '38917', '33.5078', '-89.9643');
INSERT INTO `net_city` VALUES ('32520', '23', 'Сасанвилл', 'Susanville', 'CA', '96130', '40.5730', '-120.6182');
INSERT INTO `net_city` VALUES ('32714', '202', 'Загреб', 'Zagreb', '21', '', '45.8000', '16.0000');
INSERT INTO `net_city` VALUES ('32715', '21', 'Престон', 'Preston', 'H2', '', '53.7667', '-2.7167');
INSERT INTO `net_city` VALUES ('32718', '33', 'Харлем', 'Haarlem', '07', '', '52.3667', '4.6500');
INSERT INTO `net_city` VALUES ('32720', '29', 'Нойбиберг ', 'Neubiberg', '02', '', '48.0833', '11.6833');
INSERT INTO `net_city` VALUES ('32723', '6', 'Тхане', 'Thane', '16', '', '19.2000', '72.9667');
INSERT INTO `net_city` VALUES ('32725', '21', 'Оксфорд', 'Oxford', 'K2', '', '51.7500', '-1.2500');
INSERT INTO `net_city` VALUES ('32727', '23', 'Уодделл', 'Waddell', 'AZ', '85355', '33.5590', '-112.4320');
INSERT INTO `net_city` VALUES ('32732', '23', 'Бушкилл', 'Bushkill', 'PA', '18324', '41.1458', '-74.9923');
INSERT INTO `net_city` VALUES ('32747', '24', 'Хиксон', 'Hixon', 'BC', 'v0k1s0', '53.4000', '-122.5667');
INSERT INTO `net_city` VALUES ('32872', '24', 'Квин Шарлотт', 'Queen Charlotte', 'BC', 'v0t1s0', '53.2563', '-132.0757');
INSERT INTO `net_city` VALUES ('32915', '23', 'Эстервилл', 'Estherville', 'IA', '51334', '43.3779', '-94.7973');
INSERT INTO `net_city` VALUES ('32921', '78', 'Триполи ', 'Tripoli', '61', '', '32.8925', '13.1800');
INSERT INTO `net_city` VALUES ('32922', '168', 'Дамаск', 'Damascus', '13', '', '33.5000', '36.3000');
INSERT INTO `net_city` VALUES ('32957', '126', 'Ереван', 'Yerevan', '11', '', '40.1811', '44.5136');
INSERT INTO `net_city` VALUES ('32959', '39', 'Нумеа', 'Noumea', '00', '', '-22.2667', '166.4500');
INSERT INTO `net_city` VALUES ('32964', '23', 'Валли Вью', 'Valley View', 'PA', '17983', '40.6439', '-76.5408');
INSERT INTO `net_city` VALUES ('32971', '64', 'Ндола', 'Ndola', '02', '', '-12.9667', '28.6333');
INSERT INTO `net_city` VALUES ('32975', '23', 'Косби', 'Cosby', 'TN', '37722', '35.8124', '-83.2194');
INSERT INTO `net_city` VALUES ('32979', '45', 'Семаранг', 'Semarang', '07', '', '-6.9932', '110.4203');
INSERT INTO `net_city` VALUES ('32982', '56', 'Борглон', 'Borgloon', '05', '', '50.8000', '5.3333');
INSERT INTO `net_city` VALUES ('32984', '24', 'Хаббардс', 'Hubbards', 'NS', 'b0j1t0', '44.6333', '-64.0500');
INSERT INTO `net_city` VALUES ('32986', '29', 'Пфорцхайм', 'Pforzheim', '01', '', '48.8833', '8.7000');
INSERT INTO `net_city` VALUES ('32991', '21', 'Малпас', 'Malpas', 'C5', '', '53.0167', '-2.7667');
INSERT INTO `net_city` VALUES ('32992', '6', 'Индор', 'Indore', '35', '', '22.7167', '75.8333');
INSERT INTO `net_city` VALUES ('32993', '22', 'Виборг', 'Viborg', '15', '', '56.4333', '9.4000');
INSERT INTO `net_city` VALUES ('32998', '21', 'Пул', 'Poole', 'K5', '', '50.7167', '-2.0000');
INSERT INTO `net_city` VALUES ('32999', '12', 'Андрезьё-Бутеон', 'Andrezieux-Boutheon', 'B9', '', '45.6007', '4.3620');
INSERT INTO `net_city` VALUES ('33000', '21', 'Кендал', 'Kendal', 'C9', '', '54.3167', '-2.7500');
INSERT INTO `net_city` VALUES ('33003', '18', 'Салоники', 'Thessaloniki', '13', '', '40.6403', '22.9439');
INSERT INTO `net_city` VALUES ('33004', '202', 'Сплит', 'Split', '15', '', '43.5139', '16.4558');
INSERT INTO `net_city` VALUES ('33007', '12', 'Мец', 'Metz', 'B2', '', '49.1155', '6.1759');
INSERT INTO `net_city` VALUES ('33013', '12', 'Безансон', 'Besancon', 'A6', '', '47.2488', '6.0182');
INSERT INTO `net_city` VALUES ('33014', '13', 'Масса', 'Massa', '16', '', '44.0167', '10.1500');
INSERT INTO `net_city` VALUES ('33015', '29', 'Монхайм', 'Monheim', '07', '', '51.0833', '6.8833');
INSERT INTO `net_city` VALUES ('33016', '109', 'Эскишехир', 'Eskisehir', '26', '', '39.7767', '30.5206');
INSERT INTO `net_city` VALUES ('33020', '50', 'Макао', 'Macau', '01', '', '22.2000', '113.5500');
INSERT INTO `net_city` VALUES ('33021', '33', 'Нарден', 'Naarden', '07', '', '52.2922', '5.1496');
INSERT INTO `net_city` VALUES ('33022', '139', 'Лаппеэнранта', 'Lappeenranta', '13', '', '61.0667', '28.1833');
INSERT INTO `net_city` VALUES ('33023', '21', 'Кройдон', 'Croydon', 'C8', '', '51.3833', '-0.1000');
INSERT INTO `net_city` VALUES ('33026', '55', 'Уотерфорд', 'Waterford', '27', '', '52.2583', '-7.1119');
INSERT INTO `net_city` VALUES ('33030', '21', 'Стейнес', 'Staines', '17', '', '51.4333', '-0.5167');
INSERT INTO `net_city` VALUES ('33031', '35', 'Хавеа', 'Jávea', '54', '', '38.7878', '0.1619');
INSERT INTO `net_city` VALUES ('33032', '23', 'Каньон Лейк', 'Canyon Lake', 'TX', '78133', '29.9105', '-98.1723');
INSERT INTO `net_city` VALUES ('33040', '23', 'Фицвиллиам', 'Fitzwilliam', 'NH', '03447', '42.7635', '-72.1485');
INSERT INTO `net_city` VALUES ('33041', '23', 'Ист Фритаун', 'East Freetown', 'MA', '02717', '41.7444', '-70.9803');
INSERT INTO `net_city` VALUES ('33045', '23', 'Уотфорд Сити', 'Watford City', 'ND', '58854', '47.8342', '-103.2017');
INSERT INTO `net_city` VALUES ('33060', '23', 'Камас', 'Kamas', 'UT', '84036', '40.6272', '-111.1589');
INSERT INTO `net_city` VALUES ('33061', '23', 'Иглвилл', 'Eagleville', 'TN', '37060', '35.7375', '-86.6326');
INSERT INTO `net_city` VALUES ('33062', '23', 'Хот-Спрингс-Вилидж', 'Hot Springs Village', 'AR', '71909', '34.6438', '-92.9788');
INSERT INTO `net_city` VALUES ('33069', '21', 'Бартон', 'Bourton', 'N9', '', '51.5667', '-1.6667');
INSERT INTO `net_city` VALUES ('33092', '23', 'Леннон', 'Lennon', 'MI', '48449', '43.0025', '-83.9427');
INSERT INTO `net_city` VALUES ('33146', '23', 'Торсби', 'Thorsby', 'AL', '35171', '32.8922', '-86.7471');
INSERT INTO `net_city` VALUES ('33150', '23', 'Эндрю', 'Andrew', 'IA', '52030', '42.1533', '-90.5922');
INSERT INTO `net_city` VALUES ('33151', '23', 'Хосперс', 'Hospers', 'IA', '51238', '43.0693', '-95.8997');
INSERT INTO `net_city` VALUES ('33153', '23', 'Зеринг', 'Zearing', 'IA', '50278', '42.1507', '-93.2991');
INSERT INTO `net_city` VALUES ('33154', '23', 'Лон Рок', 'Lone Rock', 'IA', '50559', '43.2198', '-94.3250');
INSERT INTO `net_city` VALUES ('33158', '21', 'Кранфилд', 'Cranfield', 'H2', '', '52.0667', '-0.6000');
INSERT INTO `net_city` VALUES ('33159', '23', 'Гринвуд Лейк', 'Greenwood Lake', 'NY', '10925', '41.2101', '-74.2950');
INSERT INTO `net_city` VALUES ('33170', '23', 'Донифен', 'Doniphan', 'MO', '63935', '36.6591', '-91.0066');
INSERT INTO `net_city` VALUES ('33178', '23', 'Казадеро', 'Cazadero', 'CA', '95421', '38.5665', '-123.2001');
INSERT INTO `net_city` VALUES ('33179', '23', 'Лабелл', 'LaBelle', 'FL', '33935', '26.8451', '-81.4438');
INSERT INTO `net_city` VALUES ('33185', '23', 'Герневилл', 'Guerneville', 'CA', '95446', '38.5268', '-123.0147');
INSERT INTO `net_city` VALUES ('33194', '23', 'Раунд Маунтин', 'Round Mountain', 'NV', '89045', '38.7942', '-117.1173');
INSERT INTO `net_city` VALUES ('33206', '23', 'Понсфорд', 'Ponsford', 'MN', '56575', '47.0469', '-95.4775');
INSERT INTO `net_city` VALUES ('33207', '146', 'Мамора Бей', 'Mamora Bay', '07', '', '17.0833', '-61.7667');
INSERT INTO `net_city` VALUES ('33208', '23', 'Саратога', 'Saratoga', 'WY', '82331', '41.4841', '-106.6529');
INSERT INTO `net_city` VALUES ('33211', '23', 'Уодли', 'Wadley', 'AL', '36276', '33.1412', '-85.5273');
INSERT INTO `net_city` VALUES ('33214', '23', 'Литл Саамико', 'Little Suamico', 'WI', '54141', '44.7442', '-87.9878');
INSERT INTO `net_city` VALUES ('33217', '23', 'Барнет', 'Barnet', 'VT', '05821', '44.3182', '-72.1085');
INSERT INTO `net_city` VALUES ('33218', '23', 'Саут Белойт', 'South Beloit', 'IL', '61080', '42.4732', '-88.9707');
INSERT INTO `net_city` VALUES ('33250', '24', 'Гананок', 'Gananoque', 'ON', 'k7g1n7', '44.3333', '-76.1667');
INSERT INTO `net_city` VALUES ('33295', '24', 'Петавава', 'Petawawa', 'ON', 'k8h2x3', '45.9000', '-77.2833');
INSERT INTO `net_city` VALUES ('33306', '24', 'Альфред', 'Alfred', 'ON', 'k0b1a0', '45.5616', '-74.8787');
INSERT INTO `net_city` VALUES ('33324', '38', 'Вальпараисо', 'Valparaiso', '01', '', '-33.0478', '-71.6011');
INSERT INTO `net_city` VALUES ('33326', '34', 'Кесария', 'Caesarea', '04', '', '32.4921', '34.8922');
INSERT INTO `net_city` VALUES ('33328', '34', 'Веред-ха-Галиль', 'Vered Hagalil', '03', '', '32.9805', '35.5424');
INSERT INTO `net_city` VALUES ('33330', '12', 'Мериньяк', 'Merignac', '97', '', '44.8325', '-0.6338');
INSERT INTO `net_city` VALUES ('33343', '35', 'Лас-Пальмас', 'Las Palmas', '53', '', '28.0997', '-15.4134');
INSERT INTO `net_city` VALUES ('33349', '23', 'Планкинтон', 'Plankinton', 'SD', '57368', '43.7467', '-98.4999');
INSERT INTO `net_city` VALUES ('33352', '24', 'Уэбстер', 'Webster', 'AB', '', '55.4333', '-118.7000');
INSERT INTO `net_city` VALUES ('33371', '23', 'Монтесано', 'Montesano', 'WA', '98563', '47.1791', '-123.6061');
INSERT INTO `net_city` VALUES ('33372', '23', 'Итонтон', 'Eatonton', 'GA', '31024', '33.3188', '-83.3449');
INSERT INTO `net_city` VALUES ('33382', '1', 'Розбери', 'Rosebery', '07', '', '-35.8167', '142.4167');
INSERT INTO `net_city` VALUES ('33383', '4', 'Сучжоу', 'Suzhou', '04', '', '31.3041', '120.5954');
INSERT INTO `net_city` VALUES ('33387', '25', 'Магдалена', 'Magdalena', '14', '', '20.9167', '-103.9500');
INSERT INTO `net_city` VALUES ('33389', '45', 'Богор', 'Bogor', '06', '', '-6.5897', '106.7914');
INSERT INTO `net_city` VALUES ('33391', '3', 'Ансан', 'Ansan', '13', '', '37.3236', '126.8219');
INSERT INTO `net_city` VALUES ('33393', '44', 'Пасай-Сити', 'Pasay City', 'E9', '', '14.5518', '120.9943');
INSERT INTO `net_city` VALUES ('33394', '15', 'Мёррум', 'Mörrum', '02', '', '56.1833', '14.7500');
INSERT INTO `net_city` VALUES ('33396', '139', 'Хейнола', 'Heinola', '13', '', '61.2167', '26.0333');
INSERT INTO `net_city` VALUES ('33398', '21', 'Блэкберн', 'Blackburn', 'A8', '', '53.7500', '-2.4833');
INSERT INTO `net_city` VALUES ('33401', '29', 'Мербуш', 'Meerbusch', '07', '', '51.2833', '6.6667');
INSERT INTO `net_city` VALUES ('33402', '35', 'Бермео', 'Bermeo', '59', '', '43.4204', '-2.7242');
INSERT INTO `net_city` VALUES ('33403', '12', 'Лонь', 'Lognes', 'A8', '', '48.8354', '2.6300');
INSERT INTO `net_city` VALUES ('33407', '29', 'Росдорф', 'Rossdorf (Hesse)', '05', '', '49.8597', '8.7617');
INSERT INTO `net_city` VALUES ('33408', '55', 'Уэксфорд', 'Wexford', '30', '', '52.3342', '-6.4575');
INSERT INTO `net_city` VALUES ('33409', '15', 'Мёльндаль', 'Molndal', '28', '', '57.6500', '12.0167');
INSERT INTO `net_city` VALUES ('33410', '29', 'Гох ', 'Goch', '07', '', '51.6667', '6.1667');
INSERT INTO `net_city` VALUES ('33411', '23', 'Амения', 'Amenia', 'NY', '12501', '41.8506', '-73.5783');
INSERT INTO `net_city` VALUES ('33426', '23', 'Онли', 'Onley', 'VA', '23418', '37.6619', '-75.6883');
INSERT INTO `net_city` VALUES ('33428', '23', 'Карсон', 'Carson', 'VA', '23830', '37.0192', '-77.3871');
INSERT INTO `net_city` VALUES ('33430', '23', 'Порт Хейвуд', 'Port Haywood', 'VA', '23138', '37.3704', '-76.2966');
INSERT INTO `net_city` VALUES ('33433', '12', 'Аваре', 'Avaray', 'A3', '', '47.7225', '1.5644');
INSERT INTO `net_city` VALUES ('33435', '23', 'Хайдс', 'Hydes', 'MD', '21082', '39.4774', '-76.4635');
INSERT INTO `net_city` VALUES ('33438', '23', 'Джемисон', 'Jemison', 'AL', '35085', '32.9789', '-86.7424');
INSERT INTO `net_city` VALUES ('33442', '23', 'Мишикот', 'Mishicot', 'WI', '54228', '44.2714', '-87.6595');
INSERT INTO `net_city` VALUES ('33443', '35', 'Пуэртольяно', 'Puertollano', '54', '', '38.6889', '-4.1083');
INSERT INTO `net_city` VALUES ('33446', '21', 'Ливерпуль', 'Liverpool', 'H8', '', '53.4167', '-3.0000');
INSERT INTO `net_city` VALUES ('33447', '140', 'Тарту', 'Tartu', '18', '', '58.3661', '26.7361');
INSERT INTO `net_city` VALUES ('33448', '23', 'Имбоден', 'Imboden', 'AR', '72434', '36.2265', '-91.1750');
INSERT INTO `net_city` VALUES ('33449', '23', 'Сторден', 'Storden', 'MN', '56174', '44.0182', '-95.3106');
INSERT INTO `net_city` VALUES ('33450', '23', 'Илвако', 'Ilwaco', 'WA', '98624', '46.3194', '-123.9942');
INSERT INTO `net_city` VALUES ('33463', '58', 'Бразилиа', 'Brasilia', '07', '', '-15.7833', '-47.9167');
INSERT INTO `net_city` VALUES ('33465', '163', 'Кали', 'Cali', '29', '', '3.4372', '-76.5225');
INSERT INTO `net_city` VALUES ('33468', '109', 'Текирдаг', 'Tekirdag', '59', '', '40.9780', '27.5085');
INSERT INTO `net_city` VALUES ('33469', '52', 'Мале', 'Male', '40', '', '4.1667', '73.5000');
INSERT INTO `net_city` VALUES ('33471', '138', 'Чореску', 'Ciorescu', '48', '', '47.1294', '28.8856');
INSERT INTO `net_city` VALUES ('33478', '13', 'Ронкаделле', 'Roncadelle', '20', '', '45.7578', '12.4103');
INSERT INTO `net_city` VALUES ('33479', '21', 'Биркенхед', 'Birkenhead', 'C5', '', '53.4000', '-3.0333');
INSERT INTO `net_city` VALUES ('33480', '1', 'Хоршам', 'Horsham', '07', '', '-36.7113', '142.1998');
INSERT INTO `net_city` VALUES ('33482', '21', 'Босуэлл', 'Bothwell', 'V8', '', '55.8000', '-4.0667');
INSERT INTO `net_city` VALUES ('33483', '23', 'Дир Трейл', 'Deer Trail', 'CO', '80105', '39.6474', '-104.0039');
INSERT INTO `net_city` VALUES ('33485', '24', 'Сен-Жан', 'Saint-jean', 'QC', 'j3b2b2', '48.8667', '-67.1000');
INSERT INTO `net_city` VALUES ('33486', '30', 'Кередж', 'Karaj', '26', '', '35.8355', '51.0103');
INSERT INTO `net_city` VALUES ('33487', '139', 'Ювяскюля', 'Jyvaskyla', '15', '', '62.2333', '25.7333');
INSERT INTO `net_city` VALUES ('33488', '173', 'Эредия', 'Heredia', '04', '', '10.0024', '-84.1165');
INSERT INTO `net_city` VALUES ('33489', '4', 'Чэнду', 'Chengdu', '32', '', '30.6667', '104.0667');
INSERT INTO `net_city` VALUES ('33492', '25', 'Сальтильо', 'Saltillo', '07', '', '25.4167', '-101.0000');
INSERT INTO `net_city` VALUES ('33493', '58', 'Пату-Бранку', 'Pato Branco', '18', '', '-26.2167', '-52.6667');
INSERT INTO `net_city` VALUES ('33494', '4', 'Циндао', 'Qingdao', '25', '', '36.0986', '120.3719');
INSERT INTO `net_city` VALUES ('33496', '23', 'Хузик', 'Hoosick', 'NY', '12089', '42.8626', '-73.3282');
INSERT INTO `net_city` VALUES ('33500', '23', 'Артур', 'Arthur', 'IL', '61911', '39.6926', '-88.4547');
INSERT INTO `net_city` VALUES ('33502', '23', 'Лавлок', 'Lovelock', 'NV', '89419', '40.3248', '-118.2092');
INSERT INTO `net_city` VALUES ('33503', '23', 'Толхаус', 'Tollhouse', 'CA', '93667', '36.9659', '-119.3057');
INSERT INTO `net_city` VALUES ('33506', '23', 'Или', 'Ely', 'NV', '89301', '39.4205', '-115.0080');
INSERT INTO `net_city` VALUES ('33509', '23', 'Траут Крик', 'Trout Creek', 'MT', '59874', '47.7695', '-115.6305');
INSERT INTO `net_city` VALUES ('33521', '24', 'Ньюгейт', 'Newgate', 'BC', '', '49.0000', '-115.1667');
INSERT INTO `net_city` VALUES ('33523', '24', 'Нотр-Дам', 'Notre Dame', 'NB', '', '46.3000', '-64.7167');
INSERT INTO `net_city` VALUES ('33527', '24', 'Маккензи', 'Mackenzie', 'ON', '', '48.5500', '-88.9667');
INSERT INTO `net_city` VALUES ('33531', '21', 'Редхилл', 'Redhill', 'J4', '', '51.3658', '-2.7203');
INSERT INTO `net_city` VALUES ('33533', '23', 'Суишер', 'Swisher', 'IA', '52338', '41.8309', '-91.6986');
INSERT INTO `net_city` VALUES ('33566', '23', 'Линдеборо', 'Lyndeborough', 'NH', '03082', '42.9050', '-71.7815');
INSERT INTO `net_city` VALUES ('33567', '24', 'Иглулик', 'Igloolik', 'NT', 'x0a0l0', '69.4000', '-81.8000');
INSERT INTO `net_city` VALUES ('33569', '24', 'Икалуит', 'Iqaluit', 'NT', 'x0a0h0', '63.7333', '-68.5000');
INSERT INTO `net_city` VALUES ('33576', '24', 'Корал-Харбор', 'Coral Harbour', 'NT', 'x0c0c0', '64.1333', '-83.1667');
INSERT INTO `net_city` VALUES ('33577', '24', 'Холл Бич', 'Hall Beach', 'NT', 'x0a0k0', '68.7667', '-81.2000');
INSERT INTO `net_city` VALUES ('33578', '24', 'Честерфилд Инлет', 'Chesterfield Inlet', 'NT', 'x0c0b0', '63.3333', '-90.7000');
INSERT INTO `net_city` VALUES ('33582', '24', 'Саникилуак', 'Sanikiluaq', 'NT', 'x0a0w0', '56.5333', '-79.2333');
INSERT INTO `net_city` VALUES ('33593', '24', 'Форт-Смит', 'Fort Smith', 'NT', 'x0e0p0', '60.0000', '-111.8833');
INSERT INTO `net_city` VALUES ('33596', '24', 'Форт Лиард', 'Fort Liard', 'NT', 'x0g0a0', '60.2333', '-123.4833');
INSERT INTO `net_city` VALUES ('33616', '24', 'Арвиат', 'Arviat', 'NT', 'x0c0e0', '61.1167', '-94.0500');
INSERT INTO `net_city` VALUES ('33617', '24', 'Бейкер-Лейк', 'Baker Lake', 'NT', 'x0c0a0', '64.3167', '-96.0167');
INSERT INTO `net_city` VALUES ('33623', '24', 'Пангниртунг', 'Pangnirtung', 'NT', 'x0a0r0', '66.1333', '-65.7500');
INSERT INTO `net_city` VALUES ('33628', '24', 'Клайд Ривер', 'Clyde River', 'NT', 'x0a0e0', '70.4500', '-68.5667');
INSERT INTO `net_city` VALUES ('33636', '23', 'Голиад', 'Goliad', 'TX', '77963', '28.6431', '-97.4437');
INSERT INTO `net_city` VALUES ('33637', '125', 'Хьёме', 'Tjøme', '20', '', '59.1167', '10.4000');
INSERT INTO `net_city` VALUES ('33638', '59', 'Люцерн', 'Lucerne', '11', '', '47.0833', '8.2667');
INSERT INTO `net_city` VALUES ('33639', '13', 'Арезе', 'Arese', '09', '', '45.5333', '9.0833');
INSERT INTO `net_city` VALUES ('33641', '21', 'Пенрит', 'Penrith', 'C9', '', '54.6500', '-2.7333');
INSERT INTO `net_city` VALUES ('33644', '12', 'Нанси', 'Nancy', 'B2', '', '48.6921', '6.1878');
INSERT INTO `net_city` VALUES ('33647', '1', 'Камс Уорф', 'Cams Wharf', '07', '', '-33.1124', '151.5616');
INSERT INTO `net_city` VALUES ('33648', '29', 'Хаген', 'Hagen', '07', '', '51.3500', '7.4667');
INSERT INTO `net_city` VALUES ('33649', '23', 'Саут Уилмингтон', 'South Wilmington', 'IL', '60474', '41.1728', '-88.2767');
INSERT INTO `net_city` VALUES ('33651', '17', 'Порту', 'Porto', '17', '', '41.1496', '-8.6110');
INSERT INTO `net_city` VALUES ('33652', '23', 'Градивилл', 'Gradyville', 'KY', '42742', '37.0912', '-85.4650');
INSERT INTO `net_city` VALUES ('33654', '29', 'Фирзен ', 'Viersen', '07', '', '51.2500', '6.3833');
INSERT INTO `net_city` VALUES ('33657', '23', 'Калхэн', 'Calhan', 'CO', '80808', '39.0003', '-104.2844');
INSERT INTO `net_city` VALUES ('33661', '12', 'Ла Курон', 'La Couronne', 'B7', '', '45.6167', '0.1000');
INSERT INTO `net_city` VALUES ('33663', '21', 'Бедфорд', 'Bedford', 'A5', '', '52.1333', '-0.45');
INSERT INTO `net_city` VALUES ('33678', '23', 'Дингманс Ферри', 'Dingmans Ferry', 'PA', '18328', '41.2171', '-75.0086');
INSERT INTO `net_city` VALUES ('33680', '23', 'Колорадо Сити', 'Colorado City', 'TX', '79512', '32.3308', '-100.9240');
INSERT INTO `net_city` VALUES ('33690', '21', 'Лисбурн', 'Lisburn', 'S5', '', '54.5167', '-6.0667');
INSERT INTO `net_city` VALUES ('33695', '23', 'Касота', 'Kasota', 'MN', '56050', '44.2702', '-93.9532');
INSERT INTO `net_city` VALUES ('33696', '23', 'Скандия', 'Scandia', 'MN', '55073', '45.2617', '-92.8274');
INSERT INTO `net_city` VALUES ('33701', '23', 'Колберт', 'Colbert', 'WA', '99005', '47.8463', '-117.3592');
INSERT INTO `net_city` VALUES ('33702', '23', 'Бард', 'Bard', 'CA', '92222', '32.7892', '-114.5561');
INSERT INTO `net_city` VALUES ('33713', '23', 'Пратт', 'Pratt', 'KS', '67124', '37.6312', '-98.7678');
INSERT INTO `net_city` VALUES ('33715', '160', 'Амбато', 'Ambato', '19', '', '-1.2500', '-78.6167');
INSERT INTO `net_city` VALUES ('33718', '23', 'Хичкок', 'Hitchcock', 'TX', '77563', '29.2897', '-95.0207');
INSERT INTO `net_city` VALUES ('33720', '23', 'Банкер Хилл', 'Bunker Hill', 'WV', '25413', '39.3076', '-78.0535');
INSERT INTO `net_city` VALUES ('33727', '23', 'Сонора', 'Sonora', 'TX', '76950', '30.4264', '-100.5385');
INSERT INTO `net_city` VALUES ('33728', '23', 'Линдхерст', 'Lyndhurst', 'VA', '22952', '37.9650', '-78.9627');
INSERT INTO `net_city` VALUES ('33729', '23', 'Сэтвилль', 'Saltville', 'VA', '24370', '36.9141', '-81.7788');
INSERT INTO `net_city` VALUES ('33731', '23', 'Константин', 'Constantine', 'MI', '49042', '41.8525', '-85.7234');
INSERT INTO `net_city` VALUES ('33732', '23', 'Берр Ок', 'Burr Oak', 'MI', '49030', '41.8397', '-85.3447');
INSERT INTO `net_city` VALUES ('33739', '57', 'Кайо', 'Cayo', '02', '', '17.0750', '-89.1392');
INSERT INTO `net_city` VALUES ('33740', '23', 'Сентревилл', 'Centreville', 'MI', '49032', '41.9065', '-85.5448');
INSERT INTO `net_city` VALUES ('33742', '34', 'Эйлат', 'Eilat', '01', '', '29.5580', '34.9482');
INSERT INTO `net_city` VALUES ('33746', '23', 'Слэб Форк', 'Slab Fork', 'WV', '25920', '37.7054', '-81.3535');
INSERT INTO `net_city` VALUES ('33751', '21', 'Эксетер', 'Exeter', 'D4', '', '50.7000', '-3.5333');
INSERT INTO `net_city` VALUES ('33753', '1', 'Балларат', 'Ballarat', '07', '', '-37.5627', '143.8626');
INSERT INTO `net_city` VALUES ('33757', '23', 'Ричфорд', 'Richford', 'VT', '05476', '44.9577', '-72.6566');
INSERT INTO `net_city` VALUES ('33775', '24', 'Моринвилл', 'Morinville', 'AB', 't8r1h4', '53.8000', '-113.6500');
INSERT INTO `net_city` VALUES ('33786', '23', 'Пойнт-оф-Рокс', 'Point Of Rocks', 'MD', '21777', '39.2758', '-77.5325');
INSERT INTO `net_city` VALUES ('33788', '23', 'Кэмпбеллспорт', 'Campbellsport', 'WI', '53010', '43.6129', '-88.2905');
INSERT INTO `net_city` VALUES ('33790', '23', 'Клинтонвилл', 'Clintonville', 'WI', '54929', '44.6382', '-88.7364');
INSERT INTO `net_city` VALUES ('33791', '23', 'Вудстаун', 'Woodstown', 'NJ', '08098', '39.6357', '-75.3265');
INSERT INTO `net_city` VALUES ('33792', '23', 'Сангерфилд', 'Sangerfield', 'NY', '13455', '42.9140', '-75.3791');
INSERT INTO `net_city` VALUES ('33805', '23', 'Холмдел', 'Holmdel', 'NJ', '', '40.3451', '-74.1840');
INSERT INTO `net_city` VALUES ('33806', '62', 'Кано', 'Kano', '29', '', '11.9944', '8.5138');
INSERT INTO `net_city` VALUES ('33853', '23', 'Мимбрс', 'Mimbres', 'NM', '88049', '32.9967', '-108.0940');
INSERT INTO `net_city` VALUES ('33870', '23', 'Сенекавилл', 'Senecaville', 'OH', '43780', '39.9197', '-81.4396');
INSERT INTO `net_city` VALUES ('33871', '23', 'Амбой', 'Amboy', 'MN', '56010', '43.9028', '-94.1787');
INSERT INTO `net_city` VALUES ('33872', '23', 'Дригс', 'Driggs', 'ID', '83422', '43.7485', '-111.0393');
INSERT INTO `net_city` VALUES ('33874', '1', 'Террамерра', 'Turramurra', '02', '', '-33.7333', '151.1333');
INSERT INTO `net_city` VALUES ('33875', '21', 'Плимут', 'Plymouth', 'K4', '', '50.3964', '-4.1386');
INSERT INTO `net_city` VALUES ('33883', '23', 'Кресент', 'Crescent', 'OR', '97733', '43.4289', '-121.6827');
INSERT INTO `net_city` VALUES ('33898', '119', 'Нове-Место-над-Вагом', 'Nové Mesto Nad Váhom', '06', '', '48.7500', '17.8333');
INSERT INTO `net_city` VALUES ('33902', '33', 'Эгмонд-ан-Зе', 'Egmond Aan Zee', '07', '', '52.6188', '4.6250');
INSERT INTO `net_city` VALUES ('33906', '23', 'Бейливилл', 'Baileyville', 'ME', '04694', '45.1285', '-67.4510');
INSERT INTO `net_city` VALUES ('33911', '22', 'Хедехусене ', 'Hedehusene', '05', '', '55.6500', '12.2000');
INSERT INTO `net_city` VALUES ('33912', '20', 'Ростов', 'Rostov', '88', '', '57.1914', '39.4139');
INSERT INTO `net_city` VALUES ('33913', '21', 'Блэквуд', 'Blackwood', 'X4', '', '51.6678', '-3.2075');
INSERT INTO `net_city` VALUES ('33915', '185', 'Чарлстаун', 'Charlestown', '07', '', '17.1333', '-62.6167');
INSERT INTO `net_city` VALUES ('33916', '21', 'Халл', 'Hull', 'G6', '', '53.7167', '-0.3333');
INSERT INTO `net_city` VALUES ('33917', '110', 'Познань', 'Poznan', '86', '', '52.4167', '16.9667');
INSERT INTO `net_city` VALUES ('33918', '23', 'Холуалоа', 'Holualoa', 'HI', '96725', '19.6256', '-155.9194');
INSERT INTO `net_city` VALUES ('33930', '21', 'Ньюарк-он-Трент', 'Newark-on-Trent', 'J9', '', '53.0667', '-0.8167');
INSERT INTO `net_city` VALUES ('33933', '23', 'Томпсон Фолс', 'Thompson Falls', 'MT', '59873', '47.5625', '-115.4420');
INSERT INTO `net_city` VALUES ('33935', '23', 'Потомак', 'Potomac', 'MT', '59823', '46.9591', '-113.5771');
INSERT INTO `net_city` VALUES ('33937', '23', 'Чатфилд', 'Chatfield', 'TX', '75105', '32.2512', '-96.3596');
INSERT INTO `net_city` VALUES ('33939', '23', 'Кленденин', 'Clendenin', 'WV', '25045', '38.4101', '-81.3259');
INSERT INTO `net_city` VALUES ('33941', '23', 'Ротсей', 'Rothsay', 'MN', '56579', '46.4861', '-96.3379');
INSERT INTO `net_city` VALUES ('34032', '55', 'Уиклоу', 'Wicklow', '31', '', '52.9750', '-6.0494');
INSERT INTO `net_city` VALUES ('34037', '21', 'Йорк', 'York', 'Q5', '', '53.9667', '-1.0833');
INSERT INTO `net_city` VALUES ('34045', '23', 'Гриливилл', 'Greeleyville', 'SC', '29056', '33.6178', '-79.9903');
INSERT INTO `net_city` VALUES ('34046', '23', 'Лейк-Сити', 'Lake City', 'SC', '29560', '33.8329', '-79.7555');
INSERT INTO `net_city` VALUES ('34047', '23', 'Бишопвилл', 'Bishopville', 'SC', '29010', '34.2078', '-80.2819');
INSERT INTO `net_city` VALUES ('34050', '23', 'Клир Спринг', 'Clear Spring', 'MD', '21722', '39.6542', '-77.9034');
INSERT INTO `net_city` VALUES ('34053', '21', 'Ньютон Эббот', 'Newton Abbot', 'D4', '', '50.5333', '-3.6000');
INSERT INTO `net_city` VALUES ('34056', '18', 'Комотини', 'Komotiní', '02', '', '41.1228', '25.3964');
INSERT INTO `net_city` VALUES ('34058', '21', 'Уоррингтон', 'Warrington', 'P2', '', '53.3833', '-2.6000');
INSERT INTO `net_city` VALUES ('34062', '33', 'Эммелорд', 'Emmeloord', '16', '', '52.7100', '5.7512');
INSERT INTO `net_city` VALUES ('34078', '23', 'Ист Кале', 'East Calais', 'VT', '05650', '44.4198', '-72.4362');
INSERT INTO `net_city` VALUES ('34081', '98', 'Маэ', 'Mahe', '08', '', '-4.6167', '55.4500');
INSERT INTO `net_city` VALUES ('34086', '23', 'Холстед', 'Hallstead', 'PA', '18822', '41.9391', '-75.7852');
INSERT INTO `net_city` VALUES ('34090', '23', 'Паркер', 'Parker', 'AZ', '85344', '33.9902', '-114.2391');
INSERT INTO `net_city` VALUES ('34093', '23', 'Пайпстон', 'Pipestone', 'MN', '56164', '44.0376', '-96.3186');
INSERT INTO `net_city` VALUES ('34100', '23', 'Боумен', 'Bowman', 'SC', '29018', '33.3493', '-80.6640');
INSERT INTO `net_city` VALUES ('34113', '23', 'Фордленд', 'Fordland', 'MO', '65652', '37.1379', '-92.9420');
INSERT INTO `net_city` VALUES ('34140', '23', 'Фрайберг', 'Fryburg', 'PA', '16326', '41.3627', '-79.4375');
INSERT INTO `net_city` VALUES ('34142', '23', 'Клифвуд', 'Cliffwood', 'NJ', '07721', '40.4362', '-74.2341');
INSERT INTO `net_city` VALUES ('34146', '23', 'Чилтон', 'Chilton', 'WI', '53014', '44.0205', '-88.1535');
INSERT INTO `net_city` VALUES ('34215', '177', 'Порт-оф-Спейн', 'Port of Spain', '05', '', '10.6500', '-61.5167');
INSERT INTO `net_city` VALUES ('34220', '23', 'Честер', 'Chester', 'CA', '96020', '40.2732', '-121.2454');
INSERT INTO `net_city` VALUES ('34224', '23', 'Магнолия', 'Magnolia', 'DE', '19962', '39.0783', '-75.4610');
INSERT INTO `net_city` VALUES ('34225', '23', 'Боннер Спрингс', 'Bonner Springs', 'KS', '66012', '39.0499', '-94.9179');
INSERT INTO `net_city` VALUES ('34228', '23', 'Ирвин', 'Irwin', 'OH', '43029', '40.0994', '-83.4502');
INSERT INTO `net_city` VALUES ('34237', '23', 'Шарлотт Холл', 'Charlotte Hall', 'MD', '20622', '38.4501', '-76.8451');
INSERT INTO `net_city` VALUES ('34244', '23', 'Сесилтон', 'Cecilton', 'MD', '21913', '39.4045', '-75.8678');
INSERT INTO `net_city` VALUES ('34253', '23', 'Кобб', 'Cobb', 'WI', '53526', '42.9713', '-90.3517');
INSERT INTO `net_city` VALUES ('34260', '23', 'Шепердстаун', 'Shepherdstown', 'WV', '25443', '39.4406', '-77.8137');
INSERT INTO `net_city` VALUES ('34264', '222', 'Бисау', 'Bissau', '11', '', '11.8500', '-15.5833');
INSERT INTO `net_city` VALUES ('34265', '35', 'Сьюдад-Реаль', 'Ciudad Real', '54', '', '38.9863', '-3.9291');
INSERT INTO `net_city` VALUES ('34268', '23', 'Сатанта', 'Satanta', 'KS', '67870', '37.5041', '-101.0162');
INSERT INTO `net_city` VALUES ('34269', '29', 'Франкенталь ', 'Frankenthal', '08', '', '49.5372', '8.3550');
INSERT INTO `net_city` VALUES ('34273', '23', 'Лаваллетт', 'Lavallette', 'NJ', '08735', '39.9810', '-74.0720');
INSERT INTO `net_city` VALUES ('34277', '23', 'Ист Эллиджей', 'East Ellijay', 'GA', '30539', '34.6585', '-84.4932');
INSERT INTO `net_city` VALUES ('34283', '23', 'Рокбридж', 'Rockbridge', 'OH', '43149', '39.5278', '-82.5920');
INSERT INTO `net_city` VALUES ('34284', '12', 'Ницца', 'Nice', 'B8', '', '43.7136', '7.2595');
INSERT INTO `net_city` VALUES ('34291', '175', 'Миранда', 'Miranda', '07', '', '10.1539', '-68.3925');
INSERT INTO `net_city` VALUES ('34292', '12', 'Версаль', 'Versailles', 'A8', '', '48.8036', '2.1342');
INSERT INTO `net_city` VALUES ('34293', '21', 'Рочестер', 'Rochester', 'I3', '', '51.3833', '0.5167');
INSERT INTO `net_city` VALUES ('34294', '21', 'Колитон', 'Colyton', 'D4', '', '50.7500', '-3.0833');
INSERT INTO `net_city` VALUES ('34298', '23', 'Алстер', 'Alcester', 'SD', '57001', '42.9742', '-96.6319');
INSERT INTO `net_city` VALUES ('34300', '23', 'Мендосино', 'Mendocino', 'CA', '95460', '39.3099', '-123.7346');
INSERT INTO `net_city` VALUES ('34301', '23', 'Маннфорд', 'Mannford', 'OK', '74044', '36.0969', '-96.3963');
INSERT INTO `net_city` VALUES ('34320', '5', 'Нагоя', 'Nagoya', '01', '', '35.1802', '136.9067');
INSERT INTO `net_city` VALUES ('34328', '23', 'Эпворт', 'Epworth', 'IA', '52045', '42.4524', '-90.9398');
INSERT INTO `net_city` VALUES ('34330', '23', 'Элберн', 'Elburn', 'IL', '60119', '41.8660', '-88.4828');
INSERT INTO `net_city` VALUES ('34332', '23', 'Уэйконда', 'Wakonda', 'SD', '57073', '43.0115', '-97.0492');
INSERT INTO `net_city` VALUES ('34334', '23', 'Гейвилл', 'Gayville', 'SD', '57031', '42.8753', '-97.1900');
INSERT INTO `net_city` VALUES ('34335', '23', 'Сентервилл', 'Centerville', 'SD', '57014', '43.0839', '-96.9634');
INSERT INTO `net_city` VALUES ('34337', '23', 'Луверн', 'Luverne', 'MN', '56156', '43.6751', '-96.2530');
INSERT INTO `net_city` VALUES ('34340', '23', 'Херли', 'Hurley', 'SD', '57036', '43.2718', '-97.1317');
INSERT INTO `net_city` VALUES ('34341', '23', 'Уортинг', 'Worthing', 'SD', '57077', '43.3157', '-96.7569');
INSERT INTO `net_city` VALUES ('34378', '23', 'Элк Пойнт', 'Elk Point', 'SD', '57025', '42.7322', '-96.6840');
INSERT INTO `net_city` VALUES ('34380', '23', 'Выборг', 'Viborg', 'SD', '57070', '43.1847', '-97.1902');
INSERT INTO `net_city` VALUES ('34381', '23', 'Тиндалл', 'Tyndall', 'SD', '57066', '42.9884', '-97.8527');
INSERT INTO `net_city` VALUES ('34388', '23', 'Афтон', 'Afton', 'MN', '55001', '44.9014', '-92.8150');
INSERT INTO `net_city` VALUES ('34398', '23', 'Ситак', 'SeaTac', 'WA', '98062', '47.4693', '-122.3621');
INSERT INTO `net_city` VALUES ('34401', '23', 'Трейси', 'Tracy', 'MN', '56175', '44.2527', '-95.6746');
INSERT INTO `net_city` VALUES ('34410', '23', 'Майлс Сити', 'Miles City', 'MT', '59301', '46.2222', '-105.6050');
INSERT INTO `net_city` VALUES ('34417', '23', 'Стейлакум', 'Steilacoom', 'WA', '98388', '47.2117', '-122.6846');
INSERT INTO `net_city` VALUES ('34418', '23', 'Сидар', 'Cedar', 'MN', '55011', '45.3407', '-93.2442');
INSERT INTO `net_city` VALUES ('34421', '23', 'Николс', 'Nicholls', 'GA', '31554', '31.5179', '-82.6113');
INSERT INTO `net_city` VALUES ('34428', '23', 'Далцелл', 'Dalzell', 'SC', '29040', '34.0659', '-80.4237');
INSERT INTO `net_city` VALUES ('34429', '23', 'Виналхейвен', 'Vinalhaven', 'ME', '04863', '44.0815', '-68.8445');
INSERT INTO `net_city` VALUES ('34431', '24', 'Робертс Крик', 'Roberts Creek', 'BC', 'v0n2w2', '49.4167', '-123.6167');
INSERT INTO `net_city` VALUES ('34433', '23', 'Мэттава', 'Mattawa', 'WA', '99349', '46.7294', '-119.7313');
INSERT INTO `net_city` VALUES ('34448', '23', 'Палисейд', 'Palisade', 'CO', '81526', '39.0860', '-108.3596');
INSERT INTO `net_city` VALUES ('34449', '23', 'Три Форкс', 'Three Forks', 'MT', '59752', '45.9177', '-111.4299');
INSERT INTO `net_city` VALUES ('34456', '23', 'Дюбуа', 'Dubois', 'ID', '83423', '44.2209', '-112.3696');
INSERT INTO `net_city` VALUES ('34462', '35', 'Бильбао', 'Bilbao', '59', '', '43.2609', '-2.9388');
INSERT INTO `net_city` VALUES ('34475', '23', 'Спрингвейл', 'Springvale', 'ME', '04083', '43.4589', '-70.8215');
INSERT INTO `net_city` VALUES ('34489', '23', 'Форсайт', 'Forsyth', 'GA', '31029', '33.0325', '-83.8957');
INSERT INTO `net_city` VALUES ('34500', '23', 'Гошен', 'Goshen', 'KY', '40026', '38.4309', '-85.5239');
INSERT INTO `net_city` VALUES ('34504', '24', 'Бигар', 'Biggar', 'SK', 's0k0m0', '52.0500', '-107.9833');
INSERT INTO `net_city` VALUES ('34507', '24', 'Буффало Нарроус', 'Buffalo Narrows', 'SK', 's0m0j0', '55.8542', '-108.4842');
INSERT INTO `net_city` VALUES ('34515', '23', 'Ловингтон', 'Lovington', 'IL', '61937', '39.7366', '-88.6676');
INSERT INTO `net_city` VALUES ('34520', '23', 'Вудхейвен', 'Woodhaven', 'NY', '11421', '40.6931', '-73.8575');
INSERT INTO `net_city` VALUES ('34531', '23', 'Афтон', 'Afton', 'WY', '83110', '42.7007', '-110.8560');
INSERT INTO `net_city` VALUES ('34532', '23', 'Тетония', 'Tetonia', 'ID', '83452', '43.8509', '-111.1136');
INSERT INTO `net_city` VALUES ('34533', '23', 'Алпайн', 'Alpine', 'WY', '83128', '43.1220', '-111.0151');
INSERT INTO `net_city` VALUES ('34540', '23', 'Рамсер', 'Ramseur', 'NC', '27316', '35.6874', '-79.6162');
INSERT INTO `net_city` VALUES ('34553', '24', 'Лансдаун', 'Lansdowne', 'ON', 'k0e1g0', '44.4067', '-76.0157');
INSERT INTO `net_city` VALUES ('34590', '23', 'Сагл', 'Sagle', 'ID', '83860', '48.1848', '-116.5597');
INSERT INTO `net_city` VALUES ('34619', '23', 'Юто', 'Eutaw', 'AL', '35462', '32.9275', '-87.9685');
INSERT INTO `net_city` VALUES ('34625', '23', 'Хазел Грин', 'Hazel Green', 'AL', '35750', '34.9341', '-86.5803');
INSERT INTO `net_city` VALUES ('34628', '23', 'Маунт Рейнир', 'Mount Rainier', 'MD', '20712', '38.9428', '-76.9672');
INSERT INTO `net_city` VALUES ('34642', '23', 'Уайсокс', 'Wysox', 'PA', '18854', '41.7955', '-76.3576');
INSERT INTO `net_city` VALUES ('34645', '23', 'Сассекс', 'Sussex', 'NJ', '07461', '41.2487', '-74.6097');
INSERT INTO `net_city` VALUES ('34647', '23', 'Уоупан', 'Waupun', 'WI', '53963', '43.6329', '-88.7565');
INSERT INTO `net_city` VALUES ('34650', '23', 'Биттивилл', 'Beattyville', 'KY', '41311', '37.5775', '-83.7140');
INSERT INTO `net_city` VALUES ('34656', '23', 'Эджфилд', 'Edgefield', 'SC', '29824', '33.8166', '-82.0082');
INSERT INTO `net_city` VALUES ('34657', '23', 'Крандалл', 'Crandall', 'GA', '30711', '34.9264', '-84.7478');
INSERT INTO `net_city` VALUES ('34659', '23', 'Боливар', 'Bolivar', 'TN', '38008', '35.2431', '-88.9955');
INSERT INTO `net_city` VALUES ('34684', '23', 'Сейнт Джордж', 'Saint George', 'SC', '29477', '33.1759', '-80.5758');
INSERT INTO `net_city` VALUES ('34725', '23', 'Нерстранд', 'Nerstrand', 'MN', '55053', '44.3523', '-93.0470');
INSERT INTO `net_city` VALUES ('34731', '23', 'Хастонвилл', 'Hustonville', 'KY', '40437', '37.4512', '-84.8559');
INSERT INTO `net_city` VALUES ('34734', '21', 'Рамси', 'Ramsey', 'C3', '', '52.4500', '-0.1167');
INSERT INTO `net_city` VALUES ('34744', '23', 'Баклифф', 'Bacliff', 'TX', '77518', '29.4982', '-94.9894');
INSERT INTO `net_city` VALUES ('34747', '23', 'Линкольн', 'Lincoln', 'NH', '03251', '44.0797', '-71.6326');
INSERT INTO `net_city` VALUES ('34748', '23', 'Монсон', 'Monson', 'MA', '01057', '42.0953', '-72.3245');
INSERT INTO `net_city` VALUES ('34754', '23', 'Санта Клаус', 'Santa Claus', 'IN', '47579', '38.1169', '-86.9115');
INSERT INTO `net_city` VALUES ('34757', '23', 'Ламонт', 'Lamont', 'WA', '99017', '47.1637', '-117.8489');
INSERT INTO `net_city` VALUES ('34758', '23', 'Адди', 'Addy', 'WA', '99101', '48.3297', '-117.9116');
INSERT INTO `net_city` VALUES ('34760', '23', 'Уишрам', 'Wishram', 'WA', '98673', '45.6574', '-120.9667');
INSERT INTO `net_city` VALUES ('34763', '23', 'Старбак', 'Starbuck', 'WA', '99359', '46.5196', '-118.1288');
INSERT INTO `net_city` VALUES ('34767', '23', 'Шо Айленд', 'Shaw Island', 'WA', '98286', '48.5843', '-122.9291');
INSERT INTO `net_city` VALUES ('34768', '23', 'Палисейдс', 'Palisades', 'WA', '98845', '47.3879', '-119.9618');
INSERT INTO `net_city` VALUES ('34769', '23', 'Степто', 'Steptoe', 'WA', '99174', '47.0060', '-117.3560');
INSERT INTO `net_city` VALUES ('34770', '23', 'Келлер', 'Keller', 'WA', '99140', '48.1044', '-118.7116');
INSERT INTO `net_city` VALUES ('34772', '23', 'Сентервилл', 'Centerville', 'WA', '98613', '45.7427', '-120.9378');
INSERT INTO `net_city` VALUES ('34774', '23', 'Аманда Парк', 'Amanda Park', 'WA', '98526', '47.4727', '-123.9219');
INSERT INTO `net_city` VALUES ('34775', '23', 'Линд', 'Lind', 'WA', '99341', '46.9062', '-118.6801');
INSERT INTO `net_city` VALUES ('34776', '23', 'Оканоган', 'Okanogan', 'WA', '98840', '48.2205', '-119.4552');
INSERT INTO `net_city` VALUES ('34780', '23', 'Ошен Шорс', 'Ocean Shores', 'WA', '98569', '46.9720', '-124.1432');
INSERT INTO `net_city` VALUES ('34782', '23', 'Самас', 'Sumas', 'WA', '98295', '48.9499', '-122.2338');
INSERT INTO `net_city` VALUES ('34783', '6', 'Чандигарх', 'Chandigarh', '05', '', '30.7343', '76.7933');
INSERT INTO `net_city` VALUES ('34794', '24', 'Ледисмит', 'Ladysmith', 'BC', 'v0r2e0', '48.9908', '-123.8174');
INSERT INTO `net_city` VALUES ('34826', '23', 'Моричес', 'Moriches', 'NY', '11955', '40.8048', '-72.8253');
INSERT INTO `net_city` VALUES ('34827', '23', 'Топшем', 'Topsham', 'ME', '04086', '43.9602', '-69.9654');
INSERT INTO `net_city` VALUES ('34828', '23', 'Лейк Джордж', 'Lake George', 'NY', '12845', '43.4200', '-73.7108');
INSERT INTO `net_city` VALUES ('34832', '23', 'Уилтон', 'Wilton', 'ME', '04294', '44.6273', '-70.2567');
INSERT INTO `net_city` VALUES ('34833', '23', 'Гленвилл', 'Glenville', 'WV', '26351', '38.9292', '-80.8689');
INSERT INTO `net_city` VALUES ('34837', '23', 'Линвуд', 'Linwood', 'MA', '01525', '42.0973', '-71.6448');
INSERT INTO `net_city` VALUES ('34838', '29', 'Ахен', 'Aachen', '07', '', '50.7708', '6.1053');
INSERT INTO `net_city` VALUES ('34839', '98', 'Виктория', 'Victoria', '08', '', '-4.6167', '55.4500');
INSERT INTO `net_city` VALUES ('34845', '23', 'Авилла', 'Avilla', 'IN', '46710', '41.3523', '-85.2510');
INSERT INTO `net_city` VALUES ('34849', '23', 'Дэвис Джанкшен', 'Davis Junction', 'IL', '61020', '42.1114', '-89.0930');
INSERT INTO `net_city` VALUES ('34855', '23', 'Факторивилл', 'Factoryville', 'PA', '18419', '41.5601', '-75.8046');
INSERT INTO `net_city` VALUES ('34859', '23', 'Брайант', 'Bryant', 'FL', '33439', '26.8521', '-80.6202');
INSERT INTO `net_city` VALUES ('34861', '24', 'Грисволд', 'Griswold', 'MB', 'r0m0s0', '49.7667', '-100.4667');
INSERT INTO `net_city` VALUES ('34865', '23', 'Уолкертон', 'Walkerton', 'VA', '23177', '37.7361', '-77.0092');
INSERT INTO `net_city` VALUES ('34867', '23', 'Хакберри', 'Hackberry', 'LA', '70645', '29.9647', '-93.4296');
INSERT INTO `net_city` VALUES ('34868', '13', 'Кастелло-Тезино', 'Castello Tesino', '20', '', '46.0667', '11.6333');
INSERT INTO `net_city` VALUES ('34875', '23', 'Канатильо', 'Canutillo', 'TX', '79835', '31.9325', '-106.5938');
INSERT INTO `net_city` VALUES ('34881', '23', 'Риджвилл Корнерс', 'Ridgeville Corners', 'OH', '43555', '41.4378', '-84.2575');
INSERT INTO `net_city` VALUES ('34885', '23', 'Прейри Ли', 'Prairie Lea', 'TX', '78661', '29.7325', '-97.7536');
INSERT INTO `net_city` VALUES ('34900', '23', 'Боудойнхем', 'Bowdoinham', 'ME', '04008', '44.0387', '-69.8684');
INSERT INTO `net_city` VALUES ('34905', '23', 'Халлоуэлл', 'Hallowell', 'ME', '04347', '44.2882', '-69.8169');
INSERT INTO `net_city` VALUES ('34911', '23', 'Кандия', 'Candia', 'NH', '03034', '43.0591', '-71.3114');
INSERT INTO `net_city` VALUES ('34912', '23', 'Шютсбери', 'Shutesbury', 'MA', '01072', '42.4635', '-72.4243');
INSERT INTO `net_city` VALUES ('34913', '23', 'Бернардстон', 'Bernardston', 'MA', '01337', '42.6906', '-72.5832');
INSERT INTO `net_city` VALUES ('34917', '23', 'Колрейн', 'Colrain', 'MA', '01340', '42.6828', '-72.7389');
INSERT INTO `net_city` VALUES ('34920', '23', 'Олд-Орчард-Бич', 'Old Orchard Beach', 'ME', '04064', '43.5273', '-70.3894');
INSERT INTO `net_city` VALUES ('34921', '23', 'Вассалборо', 'Vassalboro', 'ME', '04989', '44.4291', '-69.6471');
INSERT INTO `net_city` VALUES ('34925', '23', 'Гошен', 'Goshen', 'MA', '01032', '42.4549', '-72.8086');
INSERT INTO `net_city` VALUES ('34926', '23', 'Уэстфорд', 'Westford', 'VT', '05494', '44.6007', '-73.0158');
INSERT INTO `net_city` VALUES ('34928', '23', 'Бондсвилл', 'Bondsville', 'MA', '01009', '42.2040', '-72.3433');
INSERT INTO `net_city` VALUES ('34930', '23', 'Сирспорт', 'Searsport', 'ME', '04974', '44.4967', '-68.9222');
INSERT INTO `net_city` VALUES ('34935', '23', 'Миллерс Фолс', 'Millers Falls', 'MA', '01349', '42.5751', '-72.4512');
INSERT INTO `net_city` VALUES ('34936', '23', 'Саут Помфрет', 'South Pomfret', 'VT', '05067', '43.6947', '-72.5461');
INSERT INTO `net_city` VALUES ('34941', '23', 'Споффорд', 'Spofford', 'NH', '03462', '42.8970', '-72.4155');
INSERT INTO `net_city` VALUES ('34944', '23', 'Уильямстаун', 'Williamstown', 'VT', '05679', '44.1068', '-72.5397');
INSERT INTO `net_city` VALUES ('34945', '23', 'Саут Эгремонт', 'South Egremont', 'MA', '01258', '42.1022', '-73.4641');
INSERT INTO `net_city` VALUES ('34947', '23', 'Каммингтон', 'Cummington', 'MA', '01026', '42.4703', '-72.9174');
INSERT INTO `net_city` VALUES ('34951', '23', 'Тернерс Фолс', 'Turners Falls', 'MA', '01376', '42.6376', '-72.5096');
INSERT INTO `net_city` VALUES ('34958', '23', 'Гилфорд', 'Gilford', 'NH', '03249', '43.5389', '-71.3864');
INSERT INTO `net_city` VALUES ('34960', '23', 'Маунт-Вернон', 'Mount Vernon', 'ME', '04352', '44.4709', '-69.9644');
INSERT INTO `net_city` VALUES ('34963', '23', 'Хайгейт Спрингс', 'Highgate Springs', 'VT', '05460', '44.9795', '-73.1054');
INSERT INTO `net_city` VALUES ('34970', '23', 'Харрисвилл', 'Harrisville', 'NH', '03450', '42.9442', '-72.0781');
INSERT INTO `net_city` VALUES ('34972', '23', 'Интервейл', 'Intervale', 'NH', '03845', '44.1018', '-71.1277');
INSERT INTO `net_city` VALUES ('34977', '23', 'Майкка Сити', 'Myakka City', 'FL', '34251', '27.3726', '-82.2049');
INSERT INTO `net_city` VALUES ('34983', '23', 'Фармерсберг', 'Farmersburg', 'IN', '47850', '39.2447', '-87.4246');
INSERT INTO `net_city` VALUES ('34984', '23', 'Хеннепин', 'Hennepin', 'IL', '61327', '41.2139', '-89.3040');
INSERT INTO `net_city` VALUES ('34985', '23', 'Одон', 'Odon', 'IN', '47562', '38.8304', '-86.9985');
INSERT INTO `net_city` VALUES ('34986', '23', 'Тревор', 'Trevor', 'WI', '53179', '42.5187', '-88.1309');
INSERT INTO `net_city` VALUES ('35010', '25', 'Оахака', 'Oaxaca', '20', '', '17.0500', '-96.7167');
INSERT INTO `net_city` VALUES ('35018', '25', 'Пуэбла', 'Puebla', '21', '', '19.0500', '-98.2000');
INSERT INTO `net_city` VALUES ('35022', '25', 'Дуранго', 'Durango', '10', '', '24.0333', '-104.6667');
INSERT INTO `net_city` VALUES ('35023', '25', 'Сонора', 'Sonora', '27', '', '17.8417', '-91.4875');
INSERT INTO `net_city` VALUES ('35025', '25', 'Кампече', 'Campeche', '04', '', '19.8500', '-90.5333');
INSERT INTO `net_city` VALUES ('35026', '25', 'Идальго', 'Hidalgo', '16', '', '19.6833', '-100.5667');
INSERT INTO `net_city` VALUES ('35032', '25', 'Тласкала', 'Tlaxcala', '29', '', '19.3139', '-98.2417');
INSERT INTO `net_city` VALUES ('35033', '25', 'Сан-Луис-Потоси', 'San Luis Potosi', '24', '', '22.1500', '-100.9833');
INSERT INTO `net_city` VALUES ('35035', '25', 'Колима', 'Colima', '08', '', '19.2333', '-103.7167');
INSERT INTO `net_city` VALUES ('35038', '25', 'Леон ', 'Leon (Guanajuato)', '11', '', '21.1167', '-101.6667');
INSERT INTO `net_city` VALUES ('35042', '25', 'Мина', 'Mina', '19', '', '26.0167', '-100.5333');
INSERT INTO `net_city` VALUES ('35044', '25', 'Монклова', 'Monclova', '07', '', '26.9000', '-101.4167');
INSERT INTO `net_city` VALUES ('35046', '25', 'Маскота', 'Mascota', '14', '', '20.5167', '-104.7833');
INSERT INTO `net_city` VALUES ('35047', '25', 'Агуаскальентес', 'Aguascalientes', '01', '', '21.8833', '-102.3000');
INSERT INTO `net_city` VALUES ('35048', '25', 'Сакатекас', 'Zacatecas', '32', '', '22.7833', '-102.5833');
INSERT INTO `net_city` VALUES ('35063', '25', 'Табаско', 'Tabasco', '32', '', '21.8667', '-102.9167');
INSERT INTO `net_city` VALUES ('35084', '23', 'Флинтон', 'Flinton', 'PA', '16640', '40.7010', '-78.5470');
INSERT INTO `net_city` VALUES ('35113', '23', 'Мекоста', 'Mecosta', 'MI', '49332', '43.6205', '-85.2544');
INSERT INTO `net_city` VALUES ('35137', '23', 'Пекулиар', 'Peculiar', 'MO', '64078', '38.7031', '-94.4737');
INSERT INTO `net_city` VALUES ('35150', '23', 'Банкрофт', 'Bancroft', 'IA', '50517', '43.3135', '-94.2469');
INSERT INTO `net_city` VALUES ('35244', '24', 'Кесвик', 'Keswick', 'ON', 'l4p3m3', '44.2500', '-79.4667');
INSERT INTO `net_city` VALUES ('35303', '23', 'Кристал Бэй', 'Crystal Bay', 'NV', '89402', '39.2260', '-120.0041');
INSERT INTO `net_city` VALUES ('35315', '24', 'Шрайбер', 'Schreiber', 'ON', 'p0t2s0', '48.8000', '-87.2667');
INSERT INTO `net_city` VALUES ('35322', '24', 'Нейкина', 'Nakina', 'ON', 'p0t2h0', '50.1833', '-86.7000');
INSERT INTO `net_city` VALUES ('35323', '23', 'Минко', 'Minco', 'OK', '73059', '35.3069', '-98.0597');
INSERT INTO `net_city` VALUES ('35333', '23', 'Холстед', 'Halstead', 'KS', '67056', '38.0247', '-97.5187');
INSERT INTO `net_city` VALUES ('35340', '23', 'Робертсвилл', 'Robertsville', 'MO', '63072', '38.3701', '-90.8181');
INSERT INTO `net_city` VALUES ('35344', '23', 'Бергер', 'Berger', 'MO', '63014', '38.6411', '-91.3069');
INSERT INTO `net_city` VALUES ('35345', '23', 'Пивли', 'Pevely', 'MO', '63070', '38.2891', '-90.4244');
INSERT INTO `net_city` VALUES ('35347', '23', 'Каммингс', 'Cummings', 'KS', '66016', '39.4819', '-95.2306');
INSERT INTO `net_city` VALUES ('35348', '23', 'Херингтон', 'Herington', 'KS', '67449', '38.6819', '-96.8881');
INSERT INTO `net_city` VALUES ('35349', '23', 'Фултондейл', 'Fultondale', 'AL', '35068', '33.5948', '-86.8308');
INSERT INTO `net_city` VALUES ('35351', '23', 'Хардинсберг', 'Hardinsburg', 'KY', '40143', '37.7798', '-86.4972');
INSERT INTO `net_city` VALUES ('35355', '23', 'Лорелтон', 'Laurelton', 'PA', '17835', '40.8827', '-77.2074');
INSERT INTO `net_city` VALUES ('35377', '24', 'Ланиган', 'Lanigan', 'SK', 's0k2m0', '51.8500', '-105.0333');
INSERT INTO `net_city` VALUES ('35384', '23', 'Маккаммон', 'Mccammon', 'ID', '83250', '42.6801', '-112.2006');
INSERT INTO `net_city` VALUES ('35392', '23', 'Чуджиак', 'Chugiak', 'AK', '99567', '61.4137', '-149.1711');
INSERT INTO `net_city` VALUES ('35393', '23', 'Норт Пемброк', 'North Pembroke', 'MA', '02358', '42.0932', '-70.7925');
INSERT INTO `net_city` VALUES ('35397', '21', 'Глочестер', 'Gloucester', 'E6', '', '51.8333', '-2.2500');
INSERT INTO `net_city` VALUES ('35401', '23', 'Уайт', 'White', 'GA', '30184', '34.2528', '-84.7127');
INSERT INTO `net_city` VALUES ('35404', '1', 'Малгрейв', 'Mulgrave', '07', '', '-37.9167', '145.2000');
INSERT INTO `net_city` VALUES ('35432', '33', 'Берг-ен-Терблейт', 'Berg en Terblijt', '05', '', '50.9400', '5.7965');
INSERT INTO `net_city` VALUES ('35434', '23', 'Диллард', 'Dillard', 'GA', '30537', '34.9577', '-83.3713');
INSERT INTO `net_city` VALUES ('35437', '21', 'Фэйрфорд', 'Fairford', 'E6', '', '51.7000', '-1.7833');
INSERT INTO `net_city` VALUES ('35441', '23', 'Пайн Хилл', 'Pine Hill', 'NY', '12465', '42.1440', '-74.4808');
INSERT INTO `net_city` VALUES ('35442', '15', 'Скондал', 'Sköndal', '26', '', '59.2500', '18.1167');
INSERT INTO `net_city` VALUES ('35455', '23', 'Холландейл', 'Hollandale', 'MS', '38748', '33.1390', '-90.9232');
INSERT INTO `net_city` VALUES ('35459', '23', 'Кале', 'Calais', 'ME', '04619', '45.1317', '-67.2209');
INSERT INTO `net_city` VALUES ('35460', '23', 'Бранденберг', 'Brandenburg', 'KY', '40108', '37.9697', '-86.1519');
INSERT INTO `net_city` VALUES ('35463', '23', 'Флойд', 'Floyd', 'VA', '24091', '36.9017', '-80.3288');
INSERT INTO `net_city` VALUES ('35464', '23', 'Даунсвилл', 'Downsville', 'WI', '54735', '44.7747', '-91.9321');
INSERT INTO `net_city` VALUES ('35466', '23', 'Раш Валли', 'Rush Valley', 'UT', '84069', '40.3494', '-112.4892');
INSERT INTO `net_city` VALUES ('35474', '24', 'Торнбери', 'Thornbury', 'ON', 'n0h2p0', '44.5500', '-80.4500');
INSERT INTO `net_city` VALUES ('35549', '23', 'Мидлпорт', 'Middleport', 'PA', '17953', '40.7295', '-76.0855');
INSERT INTO `net_city` VALUES ('35550', '23', 'Нескопек', 'Nescopeck', 'PA', '18635', '41.0251', '-76.1840');
INSERT INTO `net_city` VALUES ('35551', '23', 'Серкл', 'Circle', 'MT', '59215', '47.5675', '-105.7759');
INSERT INTO `net_city` VALUES ('35557', '23', 'Сереско', 'Ceresco', 'NE', '68017', '41.0527', '-96.6476');
INSERT INTO `net_city` VALUES ('35558', '141', 'Баня-Лука', 'Banja Luka', '02', '', '44.7784', '17.1939');
INSERT INTO `net_city` VALUES ('35570', '23', 'Камберленд Форесайд', 'Cumberland Foreside', 'ME', '04110', '43.7607', '-70.1964');
INSERT INTO `net_city` VALUES ('35573', '144', 'Вильнюс', 'Vilnius', '65', '', '54.6833', '25.3167');
INSERT INTO `net_city` VALUES ('35577', '23', 'Беннетт', 'Bennett', 'CO', '80102', '39.7462', '-104.4604');
INSERT INTO `net_city` VALUES ('35582', '23', 'Браунтон', 'Brownton', 'MN', '55312', '44.7139', '-94.3406');
INSERT INTO `net_city` VALUES ('35584', '23', 'Норт Чатем', 'North Chatham', 'NY', '12132', '42.4720', '-73.6318');
INSERT INTO `net_city` VALUES ('35585', '23', 'Паунд Ридж', 'Pound Ridge', 'NY', '10576', '41.2070', '-73.5682');
INSERT INTO `net_city` VALUES ('35587', '23', 'Оскода', 'Oscoda', 'MI', '48750', '44.4532', '-83.5409');
INSERT INTO `net_city` VALUES ('35594', '23', 'Линтон', 'Linton', 'ND', '58552', '46.1861', '-100.0251');
INSERT INTO `net_city` VALUES ('35596', '23', 'Велва', 'Velva', 'ND', '58790', '48.0217', '-100.9605');
INSERT INTO `net_city` VALUES ('35600', '23', 'Хаббардстон', 'Hubbardston', 'MA', '01452', '42.4839', '-72.0097');
INSERT INTO `net_city` VALUES ('35601', '110', 'Гданьск', 'Gdansk', '82', '', '54.3608', '18.6583');
INSERT INTO `net_city` VALUES ('35602', '91', 'Киншаса', 'Kinshasa', '06', '', '-4.3000', '15.3000');
INSERT INTO `net_city` VALUES ('35603', '19', 'Эль-Хубар', 'Al Khobar', '06', '', '26.2794', '50.2083');
INSERT INTO `net_city` VALUES ('35606', '23', 'Силт', 'Silt', 'CO', '81652', '39.4560', '-107.6644');
INSERT INTO `net_city` VALUES ('35619', '23', 'Голконда', 'Golconda', 'IL', '62938', '37.3613', '-88.5421');
INSERT INTO `net_city` VALUES ('35622', '23', 'Шонитаун', 'Shawneetown', 'IL', '62984', '37.6911', '-88.1441');
INSERT INTO `net_city` VALUES ('35623', '23', 'Карнак', 'Karnak', 'IL', '62956', '37.2749', '-88.9464');
INSERT INTO `net_city` VALUES ('35624', '23', 'Энфилд', 'Enfield', 'IL', '62835', '38.1005', '-88.3158');
INSERT INTO `net_city` VALUES ('35625', '23', 'Норрис Сити', 'Norris City', 'IL', '62869', '37.9661', '-88.2816');
INSERT INTO `net_city` VALUES ('35626', '23', 'Нью Черч', 'New Church', 'VA', '23415', '37.9627', '-75.5373');
INSERT INTO `net_city` VALUES ('35635', '23', 'Истпорт', 'Eastport', 'NY', '11941', '40.8254', '-72.7242');
INSERT INTO `net_city` VALUES ('35645', '24', 'Сен-Ромюальд', 'Saint-Romuald', 'QC', 'g6w5m6', '46.7500', '-71.2333');
INSERT INTO `net_city` VALUES ('35648', '24', 'Роблин', 'Roblin', 'ON', 'l8l4z7', '44.3833', '-77.0167');
INSERT INTO `net_city` VALUES ('35681', '23', 'Блэйн', 'Blaine', 'OH', '43909', '40.0678', '-80.8173');
INSERT INTO `net_city` VALUES ('35685', '23', 'Боксем', 'Boxholm', 'IA', '50040', '42.1735', '-94.1062');
INSERT INTO `net_city` VALUES ('35686', '23', 'Фергусон', 'Ferguson', 'IA', '50078', '41.9369', '-92.8658');
INSERT INTO `net_city` VALUES ('35692', '23', 'Тулли', 'Tully', 'NY', '13159', '42.8062', '-76.1299');
INSERT INTO `net_city` VALUES ('35695', '23', 'Алта', 'Altha', 'FL', '32421', '30.5148', '-85.1605');
INSERT INTO `net_city` VALUES ('35702', '23', 'Линн Хейвен', 'Lynn Haven', 'FL', '32444', '30.2332', '-85.6423');
INSERT INTO `net_city` VALUES ('35704', '23', 'Келлитон', 'Kellyton', 'AL', '35089', '32.9258', '-86.1068');
INSERT INTO `net_city` VALUES ('35706', '23', 'Ходжес', 'Hodges', 'AL', '35571', '34.3624', '-87.9508');
INSERT INTO `net_city` VALUES ('35713', '23', 'Тама', 'Tama', 'IA', '52339', '41.9243', '-92.5738');
INSERT INTO `net_city` VALUES ('35718', '23', 'Хартвик', 'Hartwick', 'IA', '52232', '41.8048', '-92.3280');
INSERT INTO `net_city` VALUES ('35719', '23', 'Хилс', 'Hills', 'IA', '52235', '41.5542', '-91.5349');
INSERT INTO `net_city` VALUES ('35721', '23', 'Скотсвилл', 'Scottsville', 'NY', '14546', '43.0318', '-77.7769');
INSERT INTO `net_city` VALUES ('35722', '23', 'Кукстаун', 'Cookstown', 'NJ', '08511', '40.0491', '-74.5570');
INSERT INTO `net_city` VALUES ('35724', '23', 'Кросуэлл', 'Croswell', 'MI', '48422', '43.2640', '-82.6589');
INSERT INTO `net_city` VALUES ('35725', '1', 'Гордон', 'Gordon', '07', '', '-37.5823', '144.1093');
INSERT INTO `net_city` VALUES ('35728', '23', 'Колвилл', 'Coalville', 'UT', '84017', '40.8868', '-111.3148');
INSERT INTO `net_city` VALUES ('35729', '23', 'Хенефер', 'Henefer', 'UT', '84033', '40.9736', '-111.5156');
INSERT INTO `net_city` VALUES ('35817', '23', 'Дирвуд', 'Deerwood', 'MN', '56444', '46.4289', '-93.8831');
INSERT INTO `net_city` VALUES ('35829', '23', 'Фолкстон', 'Folkston', 'GA', '31537', '30.8589', '-81.9720');
INSERT INTO `net_city` VALUES ('35831', '23', 'Кентленд', 'Kentland', 'IN', '47951', '40.7991', '-87.4305');
INSERT INTO `net_city` VALUES ('35873', '33', 'Энсхеде', 'Enschede', '15', '', '52.2195', '6.8912');
INSERT INTO `net_city` VALUES ('35874', '23', 'Миллерспорт', 'Millersport', 'OH', '43046', '39.8911', '-82.5487');
INSERT INTO `net_city` VALUES ('35876', '23', 'Бакай Лейк', 'Buckeye Lake', 'OH', '43008', '39.9344', '-82.4751');
INSERT INTO `net_city` VALUES ('35884', '23', 'Индиан-Уэллс', 'Indian Wells', 'CA', '92210', '33.7002', '-116.3364');
INSERT INTO `net_city` VALUES ('35893', '23', 'Каннелтон', 'Cannelton', 'WV', '25036', '38.1943', '-81.2959');
INSERT INTO `net_city` VALUES ('35897', '23', 'Комфорт', 'Comfort', 'WV', '25049', '38.1220', '-81.5708');
INSERT INTO `net_city` VALUES ('35901', '23', 'Элквью', 'Elkview', 'WV', '25071', '38.4943', '-81.4668');
INSERT INTO `net_city` VALUES ('35905', '23', 'Дауэс', 'Dawes', 'WV', '25054', '38.1429', '-81.4521');
INSERT INTO `net_city` VALUES ('35909', '23', 'Скарбро', 'Scarbro', 'WV', '25917', '37.9573', '-81.2273');
INSERT INTO `net_city` VALUES ('35911', '23', 'Кингвуд', 'Kingwood', 'WV', '26537', '39.4841', '-79.7307');
INSERT INTO `net_city` VALUES ('35922', '23', 'Мердок', 'Murdock', 'NE', '68407', '40.9141', '-96.2648');
INSERT INTO `net_city` VALUES ('35924', '23', 'Лавалетт', 'Lavalette', 'WV', '25535', '38.3050', '-82.4274');
INSERT INTO `net_city` VALUES ('35932', '23', 'Уоллес', 'Wallace', 'ID', '83873', '47.6148', '-115.9143');
INSERT INTO `net_city` VALUES ('35939', '23', 'Кенвуд', 'Kenwood', 'CA', '95452', '38.4267', '-122.5403');
INSERT INTO `net_city` VALUES ('35941', '23', 'Коло', 'Colo', 'IA', '50056', '42.0212', '-93.3002');
INSERT INTO `net_city` VALUES ('35944', '23', 'Монротон', 'Monroeton', 'PA', '18832', '41.6771', '-76.5731');
INSERT INTO `net_city` VALUES ('35946', '23', 'Саскуэханна', 'Susquehanna', 'PA', '18847', '41.8762', '-75.6050');
INSERT INTO `net_city` VALUES ('35948', '23', 'Димок', 'Dimock', 'PA', '18816', '41.7465', '-75.8983');
INSERT INTO `net_city` VALUES ('35997', '23', 'Кондон', 'Condon', 'MT', '59826', '47.4360', '-113.7088');
INSERT INTO `net_city` VALUES ('36003', '23', 'Йеллоустон Нешнел Парк', 'Yellowstone National Park', 'WY', '82190', '44.5678', '-110.4412');
INSERT INTO `net_city` VALUES ('36024', '23', 'Фриберг', 'Freeburg', 'IL', '62243', '38.4153', '-89.9064');
INSERT INTO `net_city` VALUES ('36040', '23', 'Лесли', 'Leslie', 'GA', '31764', '31.9854', '-84.0860');
INSERT INTO `net_city` VALUES ('36132', '23', 'Мак-Кенни', 'Mckenney', 'VA', '', '36.9868', '-77.7231');
INSERT INTO `net_city` VALUES ('36138', '23', 'Провиденс Фордж', 'Providence Forge', 'VA', '23140', '37.4348', '-77.0559');
INSERT INTO `net_city` VALUES ('36140', '60', 'Ричардс-Бэй', 'Richards Bay', '02', '', '-28.7754', '32.0540');
INSERT INTO `net_city` VALUES ('36143', '60', 'Альбертон', 'Alberton', '06', '', '-26.2652', '28.1406');
INSERT INTO `net_city` VALUES ('36150', '23', 'Аллин', 'Allyn', 'WA', '98524', '47.3759', '-122.8419');
INSERT INTO `net_city` VALUES ('36159', '29', 'Вупперталь', 'Wuppertal', '07', '', '51.2667', '7.1833');
INSERT INTO `net_city` VALUES ('36166', '23', 'Озона', 'Ozona', 'FL', '34660', '28.0695', '-82.7757');
INSERT INTO `net_city` VALUES ('36171', '23', 'Поквосон', 'Poquoson', 'VA', '23662', '37.1355', '-76.3526');
INSERT INTO `net_city` VALUES ('36185', '163', 'Медельин', 'Medellin', '02', '', '6.2518', '-75.5636');
INSERT INTO `net_city` VALUES ('36187', '21', 'Ипсуич', 'Ipswich', 'N5', '', '52.0833', '1.1667');
INSERT INTO `net_city` VALUES ('36188', '21', 'Саутенд-он-Си', 'Southend On Sea', 'M5', '', '51.5333', '0.7000');
INSERT INTO `net_city` VALUES ('36194', '23', 'Бигерс', 'Biggers', 'AR', '72413', '36.2996', '-90.8309');
INSERT INTO `net_city` VALUES ('36196', '23', 'Четопа', 'Chetopa', 'KS', '67336', '37.0822', '-95.0036');
INSERT INTO `net_city` VALUES ('36200', '23', 'Бернс', 'Burns', 'TN', '37029', '36.0450', '-87.2624');
INSERT INTO `net_city` VALUES ('36203', '23', 'Сан-Огастин', 'San Augustine', 'TX', '75972', '31.4942', '-94.1240');
INSERT INTO `net_city` VALUES ('36215', '23', 'Роби', 'Roby', 'TX', '79543', '32.7124', '-100.3954');
INSERT INTO `net_city` VALUES ('36217', '23', 'Лесли', 'Leslie', 'AR', '72645', '35.8060', '-92.5784');
INSERT INTO `net_city` VALUES ('36218', '23', 'Гаен', 'Guion', 'AR', '72540', '35.9302', '-91.9109');
INSERT INTO `net_city` VALUES ('36219', '23', 'Сейнт Пол', 'Saint Paul', 'KS', '66771', '37.4784', '-95.1584');
INSERT INTO `net_city` VALUES ('36226', '23', 'Кеннетт', 'Kennett', 'MO', '63857', '36.2357', '-90.0421');
INSERT INTO `net_city` VALUES ('36231', '23', 'Саммерленд', 'Summerland', 'CA', '93067', '34.4181', '-119.5903');
INSERT INTO `net_city` VALUES ('36233', '23', 'Лидия', 'Lydia', 'SC', '29079', '34.2890', '-80.1123');
INSERT INTO `net_city` VALUES ('36242', '35', 'Михас', 'Mijas', '51', '', '36.5953', '-4.6399');
INSERT INTO `net_city` VALUES ('36245', '13', 'Монца', 'Monza', '09', '', '45.5833', '9.2667');
INSERT INTO `net_city` VALUES ('36250', '23', 'Таверньер', 'Tavernier', 'FL', '33070', '25.0042', '-80.5267');
INSERT INTO `net_city` VALUES ('36251', '33', 'Бюссюм', 'Bussum', '07', '', '52.2655', '5.1794');
INSERT INTO `net_city` VALUES ('36253', '21', 'Мелроуз', 'Melrose', 'T9', '', '55.5833', '-2.7167');
INSERT INTO `net_city` VALUES ('36264', '23', 'Рок-Ривер', 'Rock River', 'WY', '82083', '41.7554', '-105.9561');
INSERT INTO `net_city` VALUES ('36265', '23', 'Гранд-Марей', 'Grand Marais', 'MN', '55604', '47.9718', '-90.0459');
INSERT INTO `net_city` VALUES ('36267', '24', 'Тависток', 'Tavistock', 'ON', 'n0b2r0', '43.3192', '-80.8384');
INSERT INTO `net_city` VALUES ('36280', '23', 'Гассауэй', 'Gassaway', 'WV', '26624', '38.7257', '-80.8036');
INSERT INTO `net_city` VALUES ('36282', '23', 'Далзура', 'Dulzura', 'CA', '91917', '32.6283', '-116.6751');
INSERT INTO `net_city` VALUES ('36283', '23', 'Интернешнл-Фоллс', 'International Falls', 'MN', '56649', '48.5078', '-93.3737');
INSERT INTO `net_city` VALUES ('36285', '38', 'Вальдивия', 'Valdivia', '09', '', '-39.8000', '-73.2333');
INSERT INTO `net_city` VALUES ('36290', '23', 'Леланд', 'Leland', 'IL', '60531', '41.6090', '-88.7698');
INSERT INTO `net_city` VALUES ('36297', '23', 'Мершон', 'Mershon', 'GA', '31551', '31.4899', '-82.2601');
INSERT INTO `net_city` VALUES ('36305', '23', 'Хейнвилл', 'Hayneville', 'AL', '36040', '32.1899', '-86.6796');
INSERT INTO `net_city` VALUES ('36321', '23', 'Холмс', 'Holmes', 'NY', '12531', '41.5315', '-73.6674');
INSERT INTO `net_city` VALUES ('36324', '23', 'Шеррард', 'Sherrard', 'IL', '61281', '41.3036', '-90.5201');
INSERT INTO `net_city` VALUES ('36325', '23', 'Холмсвилл', 'Holmesville', 'OH', '44633', '40.6242', '-81.9390');
INSERT INTO `net_city` VALUES ('36326', '23', 'Берклер', 'Berclair', 'TX', '78107', '28.5308', '-97.5911');
INSERT INTO `net_city` VALUES ('36374', '24', 'Амхерст', 'Amherst', 'NS', 'b4h4s7', '45.8300', '-64.2100');
INSERT INTO `net_city` VALUES ('36582', '23', 'Текамсе', 'Tecumseh', 'KS', '66542', '39.0052', '-95.5572');
INSERT INTO `net_city` VALUES ('36584', '23', 'Дайтон', 'Dighton', 'KS', '67839', '38.5243', '-100.4664');
INSERT INTO `net_city` VALUES ('36585', '23', 'Рексфорд', 'Rexford', 'KS', '67753', '39.4728', '-100.7308');
INSERT INTO `net_city` VALUES ('36591', '23', 'Уинслоу', 'Winslow', 'AR', '72959', '35.7722', '-94.0807');
INSERT INTO `net_city` VALUES ('36602', '23', 'Морро Бэй', 'Morro Bay', 'CA', '93442', '35.3848', '-120.7845');
INSERT INTO `net_city` VALUES ('36607', '24', 'Фенелон Фолс', 'Fenelon Falls', 'ON', 'k0m1n0', '44.5333', '-78.7500');
INSERT INTO `net_city` VALUES ('36610', '23', 'Берчвуд', 'Birchwood', 'WI', '54817', '45.6759', '-91.5341');
INSERT INTO `net_city` VALUES ('36613', '23', 'Диллер', 'Diller', 'NE', '68342', '40.0958', '-96.9447');
INSERT INTO `net_city` VALUES ('36614', '36', 'Эльютера', 'Eleuthera', '27', '', '25.1667', '-76.1667');
INSERT INTO `net_city` VALUES ('36615', '36', 'Марш Харбор', 'Marsh Harbour', '31', '', '26.5500', '-77.0500');
INSERT INTO `net_city` VALUES ('36625', '23', 'Литлрок', 'Littlerock', 'CA', '93543', '34.4805', '-117.9238');
INSERT INTO `net_city` VALUES ('36626', '23', 'Далластаун', 'Dallastown', 'PA', '17313', '39.8844', '-76.6541');
INSERT INTO `net_city` VALUES ('36630', '23', 'Ишпеминг', 'Ishpeming', 'MI', '49849', '46.4553', '-87.6934');
INSERT INTO `net_city` VALUES ('36631', '23', 'Ла Коннер', 'La Conner', 'WA', '98257', '48.4146', '-122.5363');
INSERT INTO `net_city` VALUES ('36638', '23', 'Аллегани', 'Allegany', 'NY', '14706', '42.1518', '-78.5319');
INSERT INTO `net_city` VALUES ('36644', '23', 'Порт Лайонс', 'Port Lions', 'AK', '99550', '57.8675', '-152.8822');
INSERT INTO `net_city` VALUES ('36645', '23', 'Уилльямс', 'Williams', 'CA', '95987', '39.1163', '-122.2708');
INSERT INTO `net_city` VALUES ('36648', '23', 'Стерджис', 'Sturgis', 'KY', '42459', '37.5617', '-88.0167');
INSERT INTO `net_city` VALUES ('36649', '23', 'Клирлейк Окс', 'Clearlake Oaks', 'CA', '95423', '39.0549', '-122.5543');
INSERT INTO `net_city` VALUES ('36652', '23', 'Ист Сметпорт', 'East Smethport', 'PA', '16730', '41.8087', '-78.4195');
INSERT INTO `net_city` VALUES ('36667', '23', 'Олден', 'Alden', 'MI', '49612', '44.8721', '-85.2190');
INSERT INTO `net_city` VALUES ('36689', '23', 'Оттервилл', 'Otterville', 'MO', '65348', '38.7202', '-92.9784');
INSERT INTO `net_city` VALUES ('36691', '23', 'Биг Бэар Сити', 'Big Bear City', 'CA', '92314', '34.2436', '-116.7724');
INSERT INTO `net_city` VALUES ('36698', '23', 'Каролина Бич', 'Carolina Beach', 'NC', '28428', '34.0376', '-77.8991');
INSERT INTO `net_city` VALUES ('36699', '23', 'Холли Ридж', 'Holly Ridge', 'NC', '28445', '34.5481', '-77.5464');
INSERT INTO `net_city` VALUES ('36708', '24', 'Даннвилл', 'Dunnville', 'ON', 'n1a2p7', '42.9053', '-79.6167');
INSERT INTO `net_city` VALUES ('36722', '23', 'Талога', 'Taloga', 'OK', '73667', '35.9858', '-99.0166');
INSERT INTO `net_city` VALUES ('36725', '23', 'Клаудкрофт', 'Cloudcroft', 'NM', '88317', '32.8193', '-105.7562');
INSERT INTO `net_city` VALUES ('36730', '23', 'Стокдейл', 'Stockdale', 'PA', '15483', '40.0835', '-79.8507');
INSERT INTO `net_city` VALUES ('36753', '23', 'Гринбанк', 'Greenbank', 'WA', '98253', '48.0962', '-122.5754');
INSERT INTO `net_city` VALUES ('36765', '23', 'Глейдуотер', 'Gladewater', 'TX', '75647', '32.5215', '-94.9665');
INSERT INTO `net_city` VALUES ('36768', '25', 'Куаутитлан-Искальи', 'Cuautitlan Izcalli', '15', '', '19.6469', '-99.2467');
INSERT INTO `net_city` VALUES ('36774', '35', 'Альпедрете', 'Alpedrete', '29', '', '40.6606', '-4.0253');
INSERT INTO `net_city` VALUES ('36775', '12', 'Гуссенвиль', 'Goussainville', 'A8', '', '49.0137', '2.4659');
INSERT INTO `net_city` VALUES ('36777', '29', 'Потсдам', 'Potsdam', '11', '', '52.4000', '13.0667');
INSERT INTO `net_city` VALUES ('36779', '35', 'Манреса', 'Manresa', '56', '', '41.7263', '1.8258');
INSERT INTO `net_city` VALUES ('36781', '123', 'Сибиу', 'Sibiu', '33', '', '45.8000', '24.1500');
INSERT INTO `net_city` VALUES ('36782', '29', 'Хайдельберг', 'Heidelberg', '01', '', '49.4167', '8.7000');
INSERT INTO `net_city` VALUES ('36783', '17', 'Амадора', 'Amadora', '14', '', '38.7597', '-9.2397');
INSERT INTO `net_city` VALUES ('36784', '19', 'Дахран ', 'Dhahran', '06', '', '26.3032', '50.1353');
INSERT INTO `net_city` VALUES ('36785', '4', 'Чунцин', 'Chongqing', '33', '', '29.5628', '106.5528');
INSERT INTO `net_city` VALUES ('36786', '21', 'Норидж', 'Norwich', 'I9', '', '52.6333', '1.3000');
INSERT INTO `net_city` VALUES ('36787', '23', 'Уортаун', 'Waretown', 'NJ', '08758', '39.7978', '-74.2559');
INSERT INTO `net_city` VALUES ('36791', '1', 'Колли', 'Collie', '08', '', '-33.3621', '116.1562');
INSERT INTO `net_city` VALUES ('36792', '33', 'Ассен', 'Assen', '01', '', '52.9947', '6.5632');
INSERT INTO `net_city` VALUES ('36795', '97', 'Монровия', 'Monrovia', '14', '', '6.3106', '-10.8047');
INSERT INTO `net_city` VALUES ('36796', '6', 'Нагар', 'Nagar', '24', '', '27.4333', '77.1000');
INSERT INTO `net_city` VALUES ('36799', '23', 'Траянгл', 'Triangle', 'VA', '22172', '38.5817', '-77.4325');
INSERT INTO `net_city` VALUES ('36801', '9', 'Чиангмай', 'Chiang Mai', '02', '', '18.7904', '98.9847');
INSERT INTO `net_city` VALUES ('36802', '21', 'Альнвик', 'Alnwick', 'J6', '', '55.4000', '-1.7000');
INSERT INTO `net_city` VALUES ('36803', '23', 'Хартуэлл', 'Hartwell', 'GA', '30643', '34.3224', '-82.8864');
INSERT INTO `net_city` VALUES ('36804', '23', 'Файф Лейк', 'Fife Lake', 'MI', '49633', '44.5643', '-85.1681');
INSERT INTO `net_city` VALUES ('36806', '23', 'Лавон', 'Lavon', 'TX', '75166', '33.0184', '-96.4402');
INSERT INTO `net_city` VALUES ('36808', '35', 'Колунга', 'Colunga', '34', '', '43.4851', '-5.2700');
INSERT INTO `net_city` VALUES ('36810', '23', 'Афтон', 'Afton', 'NY', '13730', '42.2546', '-75.5550');
INSERT INTO `net_city` VALUES ('36811', '23', 'Истман', 'Eastman', 'GA', '31023', '32.1759', '-83.2001');
INSERT INTO `net_city` VALUES ('36814', '23', 'Карсонвилл', 'Carsonville', 'MI', '48419', '43.4337', '-82.6555');
INSERT INTO `net_city` VALUES ('36818', '21', 'Лестер', 'Leicester', 'H4', '', '52.6333', '-1.1333');
INSERT INTO `net_city` VALUES ('36819', '23', 'Вевей', 'Vevay', 'IN', '47043', '38.7960', '-85.0863');
INSERT INTO `net_city` VALUES ('36822', '187', 'Пунта-дель-Эсте', 'Punta Del Este', '09', '', '-34.9667', '-54.9500');
INSERT INTO `net_city` VALUES ('36831', '29', 'Бюль', 'Buhl (Baden)', '01', '', '48.7000', '8.0667');
INSERT INTO `net_city` VALUES ('36832', '23', 'Алегзандрия Бэй', 'Alexandria Bay', 'NY', '13607', '44.3326', '-75.8850');
INSERT INTO `net_city` VALUES ('36834', '45', 'Паданг', 'Padang', '24', '', '-0.9532', '100.3677');
INSERT INTO `net_city` VALUES ('36837', '20', 'Ильичево', 'Il\'ichevo', '66', '', '60.1997', '29.7018');
INSERT INTO `net_city` VALUES ('36839', '35', 'Мостолес', 'Mostoles', '29', '', '40.3209', '-3.8628');
INSERT INTO `net_city` VALUES ('36841', '23', 'Уэверли', 'Waverly', 'NY', '14892', '42.0596', '-76.5279');
INSERT INTO `net_city` VALUES ('36842', '23', 'Эвлет', 'Eveleth', 'MN', '55734', '47.3241', '-92.4646');
INSERT INTO `net_city` VALUES ('36844', '23', 'Рипон', 'Ripon', 'CA', '95366', '37.7576', '-121.1290');
INSERT INTO `net_city` VALUES ('36846', '23', 'Элой', 'Eloy', 'AZ', '85231', '32.6762', '-111.5594');
INSERT INTO `net_city` VALUES ('36848', '23', 'Стил', 'Steele', 'MO', '63877', '36.0873', '-89.8691');
INSERT INTO `net_city` VALUES ('36858', '23', 'Кэптива', 'Captiva', 'FL', '33924', '26.5167', '-82.1919');
INSERT INTO `net_city` VALUES ('36862', '23', 'Спрингервилл', 'Springerville', 'AZ', '85938', '34.0486', '-109.2019');
INSERT INTO `net_city` VALUES ('36875', '23', 'Кистон', 'Keystone', 'SD', '57751', '43.8923', '-103.3900');
INSERT INTO `net_city` VALUES ('36881', '23', 'Томбстон', 'Tombstone', 'AZ', '85638', '31.7186', '-110.0404');
INSERT INTO `net_city` VALUES ('36885', '23', 'Орртанна', 'Orrtanna', 'PA', '17353', '39.8914', '-77.3918');
INSERT INTO `net_city` VALUES ('36889', '23', 'Драй Ридж', 'Dry Ridge', 'KY', '41035', '38.6867', '-84.6463');
INSERT INTO `net_city` VALUES ('36893', '23', 'Перриневилл', 'Perrineville', 'NJ', '08535', '40.2288', '-74.4551');
INSERT INTO `net_city` VALUES ('36896', '23', 'Чемунг', 'Chemung', 'NY', '14825', '42.0525', '-76.6140');
INSERT INTO `net_city` VALUES ('36900', '23', 'Эджком', 'Edgecomb', 'ME', '04556', '43.9746', '-69.6235');
INSERT INTO `net_city` VALUES ('36903', '23', 'Дэниелс', 'Daniels', 'WV', '25832', '37.7294', '-81.1063');
INSERT INTO `net_city` VALUES ('36908', '23', 'Джефферсонвилл', 'Jeffersonville', 'OH', '43128', '39.6557', '-83.5665');
INSERT INTO `net_city` VALUES ('36911', '23', 'Чебиг Айленд', 'Chebeague Island', 'ME', '04017', '43.7330', '-70.1180');
INSERT INTO `net_city` VALUES ('36912', '23', 'Гранби', 'Granby', 'MA', '01033', '42.2623', '-72.5028');
INSERT INTO `net_city` VALUES ('36913', '23', 'Уолворт', 'Walworth', 'NY', '14568', '43.1433', '-77.2879');
INSERT INTO `net_city` VALUES ('36917', '23', 'Авока', 'Avoca', 'WI', '53506', '43.1451', '-90.2889');
INSERT INTO `net_city` VALUES ('36923', '23', 'Суонтон', 'Swanton', 'VT', '05488', '44.9066', '-73.1434');
INSERT INTO `net_city` VALUES ('36926', '23', 'Миллертон', 'Millerton', 'NY', '12546', '41.9758', '-73.5441');
INSERT INTO `net_city` VALUES ('36933', '53', 'Кабул', 'Kabul', '13', '', '34.5167', '69.1833');
INSERT INTO `net_city` VALUES ('36938', '1', 'Бейсуотер', 'Bayswater', '07', '', '-37.8500', '145.2667');
INSERT INTO `net_city` VALUES ('36939', '23', 'Хорсшу Бэй', 'Horseshoe Bay', 'TX', '78657', '30.5266', '-98.4204');
INSERT INTO `net_city` VALUES ('36953', '23', 'Крил Спрингс', 'Creal Springs', 'IL', '62922', '37.6100', '-88.8184');
INSERT INTO `net_city` VALUES ('36958', '23', 'Мельба', 'Melba', 'ID', '83641', '43.3674', '-116.5540');
INSERT INTO `net_city` VALUES ('36963', '23', 'Серриллос', 'Cerrillos', 'NM', '87010', '35.4004', '-106.1111');
INSERT INTO `net_city` VALUES ('36964', '23', 'Пейн', 'Payne', 'OH', '45880', '41.0628', '-84.7170');
INSERT INTO `net_city` VALUES ('36969', '23', 'Бернамвуд', 'Birnamwood', 'WI', '54414', '44.9501', '-89.1645');
INSERT INTO `net_city` VALUES ('36979', '23', 'Поттерсвилл', 'Pottersville', 'NY', '12860', '43.7462', '-73.8331');
INSERT INTO `net_city` VALUES ('36986', '23', 'Кохос', 'Cohoes', 'NY', '12047', '42.7828', '-73.7328');
INSERT INTO `net_city` VALUES ('36989', '23', 'Колевилл', 'Coleville', 'CA', '96107', '38.4752', '-119.4836');
INSERT INTO `net_city` VALUES ('36999', '23', 'Бранчвилл', 'Branchville', 'SC', '29432', '33.2326', '-80.8224');
INSERT INTO `net_city` VALUES ('37002', '23', 'Спунер', 'Spooner', 'WI', '54801', '45.8830', '-91.8991');
INSERT INTO `net_city` VALUES ('37008', '23', 'Айлета', 'Isleta', 'NM', '87022', '34.9073', '-106.6892');
INSERT INTO `net_city` VALUES ('37013', '23', 'Мароа', 'Maroa', 'IL', '61756', '40.0270', '-88.9921');
INSERT INTO `net_city` VALUES ('37018', '23', 'Спринг Лейк', 'Spring Lake', 'NC', '28390', '35.2268', '-78.9562');
INSERT INTO `net_city` VALUES ('37019', '23', 'Саммитвилл', 'Summitville', 'OH', '43962', '40.6781', '-80.8862');
INSERT INTO `net_city` VALUES ('37022', '23', 'Форт Калхун', 'Fort Calhoun', 'NE', '68023', '41.4550', '-96.0230');
INSERT INTO `net_city` VALUES ('37027', '23', 'Линкольндейл', 'Lincolndale', 'NY', '10540', '41.3229', '-73.7182');
INSERT INTO `net_city` VALUES ('37034', '23', 'Уэллпинит', 'Wellpinit', 'WA', '99040', '47.8986', '-117.9924');
INSERT INTO `net_city` VALUES ('37037', '23', 'Гнаденхаттен', 'Gnadenhutten', 'OH', '44629', '40.3383', '-81.4564');
INSERT INTO `net_city` VALUES ('37046', '5', 'Кавасаки', 'Kawasaki', '19', '', '35.5206', '139.7172');
INSERT INTO `net_city` VALUES ('37049', '23', 'Уэстморленд', 'Westmoreland', 'NY', '13490', '43.1147', '-75.4380');
INSERT INTO `net_city` VALUES ('37052', '23', 'Ашиппан', 'Ashippun', 'WI', '53003', '43.2120', '-88.5162');
INSERT INTO `net_city` VALUES ('37054', '23', 'Чипли', 'Chipley', 'FL', '32428', '30.6344', '-85.5948');
INSERT INTO `net_city` VALUES ('37057', '23', 'Лейтонвилл', 'Laytonville', 'CA', '95454', '39.8060', '-123.5076');
INSERT INTO `net_city` VALUES ('37059', '23', 'Огаста', 'Augusta', 'SC', '29180', '34.3439', '-81.0914');
INSERT INTO `net_city` VALUES ('37060', '23', 'Гибсон-Сити', 'Gibson City', 'IL', '60936', '40.4717', '-88.3753');
INSERT INTO `net_city` VALUES ('37065', '23', 'Соноита', 'Sonoita', 'AZ', '85637', '31.7596', '-110.6638');
INSERT INTO `net_city` VALUES ('37068', '23', 'Сейнт Полс', 'Saint Pauls', 'NC', '28384', '34.7909', '-78.9522');
INSERT INTO `net_city` VALUES ('37069', '33', 'Боксмер', 'Boxmeer', '06', '', '51.6440', '5.9608');
INSERT INTO `net_city` VALUES ('37070', '23', 'Бекер', 'Becker', 'MN', '55308', '45.4255', '-93.8111');
INSERT INTO `net_city` VALUES ('37075', '23', 'Фоксберг', 'Foxburg', 'PA', '16036', '41.1410', '-79.6664');
INSERT INTO `net_city` VALUES ('37076', '23', 'Бентливилл', 'Bentleyville', 'PA', '15314', '40.1462', '-80.0220');
INSERT INTO `net_city` VALUES ('37079', '23', 'Донгола', 'Dongola', 'IL', '62926', '37.3676', '-89.1514');
INSERT INTO `net_city` VALUES ('37081', '23', 'Онага', 'Onaga', 'KS', '66521', '39.4641', '-96.2207');
INSERT INTO `net_city` VALUES ('37082', '23', 'Сейнт Мэрис', 'Saint Marys', 'KS', '66536', '39.2124', '-96.0820');
INSERT INTO `net_city` VALUES ('37083', '23', 'Сиссна Парк', 'Cissna Park', 'IL', '60924', '40.5583', '-87.8827');
INSERT INTO `net_city` VALUES ('37085', '23', 'Ламар', 'Lamar', 'MO', '64759', '37.5237', '-94.2764');
INSERT INTO `net_city` VALUES ('37086', '27', 'Рио Гранде', 'Rio Grande', '00', '00745', '18.3475', '-65.8127');
INSERT INTO `net_city` VALUES ('37088', '23', 'Нанда', 'Nunda', 'NY', '14517', '42.5969', '-77.8718');
INSERT INTO `net_city` VALUES ('37093', '23', 'Поствилл', 'Postville', 'IA', '52162', '43.0869', '-91.5491');
INSERT INTO `net_city` VALUES ('37095', '23', 'Сан Хуан Пуэбло', 'San Juan Pueblo', 'NM', '87566', '36.0974', '-106.0705');
INSERT INTO `net_city` VALUES ('37099', '23', 'Лордсберг', 'Lordsburg', 'NM', '88045', '32.3444', '-108.7926');
INSERT INTO `net_city` VALUES ('37100', '23', 'Никсон', 'Nixon', 'NV', '89424', '39.8661', '-119.4443');
INSERT INTO `net_city` VALUES ('37108', '23', 'Алчерас', 'Alturas', 'CA', '96101', '41.4384', '-120.5340');
INSERT INTO `net_city` VALUES ('37109', '23', 'Джеймсвилл', 'Jamesville', 'NC', '27846', '35.7728', '-76.8976');
INSERT INTO `net_city` VALUES ('37111', '23', 'Альмо', 'Almo', 'KY', '42020', '36.6942', '-88.2881');
INSERT INTO `net_city` VALUES ('37112', '23', 'Суит Спрингс', 'Sweet Springs', 'MO', '65351', '38.9794', '-93.3724');
INSERT INTO `net_city` VALUES ('37115', '23', 'Рогген', 'Roggen', 'CO', '80652', '40.1313', '-104.2678');
INSERT INTO `net_city` VALUES ('37119', '23', 'Алум Банк', 'Alum Bank', 'PA', '15521', '40.2048', '-78.6298');
INSERT INTO `net_city` VALUES ('37121', '23', 'Фифилд', 'Fifield', 'WI', '54524', '45.8383', '-90.3709');
INSERT INTO `net_city` VALUES ('37124', '23', 'Гарднерс', 'Gardners', 'PA', '17324', '40.0383', '-77.2517');
INSERT INTO `net_city` VALUES ('37129', '23', 'Аллен', 'Allen', 'KS', '66833', '38.6520', '-96.1659');
INSERT INTO `net_city` VALUES ('37131', '29', 'Вайль-на-Рейне', 'Weil am Rhein', '01', '', '47.5937', '7.6298');
INSERT INTO `net_city` VALUES ('37134', '23', 'Адайрсвилл', 'Adairsville', 'GA', '30103', '34.3692', '-84.9293');
INSERT INTO `net_city` VALUES ('37135', '23', 'Алленсвилл', 'Allensville', 'PA', '17002', '40.5413', '-77.7951');
INSERT INTO `net_city` VALUES ('37141', '23', 'Гиллеспи', 'Gillespie', 'IL', '62033', '39.1407', '-89.8400');
INSERT INTO `net_city` VALUES ('37144', '23', 'Шульсберг', 'Shullsburg', 'WI', '53586', '42.5839', '-90.2307');
INSERT INTO `net_city` VALUES ('37151', '23', 'Ньюфилд', 'Newfield', 'NY', '14867', '42.3385', '-76.6103');
INSERT INTO `net_city` VALUES ('37152', '23', 'Аплтон Сити', 'Appleton City', 'MO', '64724', '38.1340', '-94.0157');
INSERT INTO `net_city` VALUES ('37153', '23', 'Олив Хилл', 'Olive Hill', 'KY', '41164', '38.3051', '-83.1681');
INSERT INTO `net_city` VALUES ('37154', '23', 'Марингуин', 'Maringouin', 'LA', '70757', '30.4220', '-91.5099');
INSERT INTO `net_city` VALUES ('37155', '23', 'Бриннон', 'Brinnon', 'WA', '98320', '47.6977', '-122.9939');
INSERT INTO `net_city` VALUES ('37164', '23', 'Аллоез', 'Allouez', 'MI', '49805', '47.3646', '-88.3515');
INSERT INTO `net_city` VALUES ('37168', '23', 'Кин', 'Keene', 'CA', '93531', '35.2379', '-118.6278');
INSERT INTO `net_city` VALUES ('37179', '23', 'Браунстаун', 'Brownstown', 'IN', '47220', '38.8361', '-86.0092');
INSERT INTO `net_city` VALUES ('37183', '23', 'Кинг Сити', 'King City', 'CA', '93930', '36.2085', '-120.9449');
INSERT INTO `net_city` VALUES ('37190', '23', 'Арнолд', 'Arnold', 'CA', '95223', '38.3574', '-120.2003');
INSERT INTO `net_city` VALUES ('37195', '23', 'Дескансо', 'Descanso', 'CA', '91916', '32.9079', '-116.6244');
INSERT INTO `net_city` VALUES ('37200', '23', 'Шандон', 'Shandon', 'CA', '93461', '35.6314', '-120.2660');
INSERT INTO `net_city` VALUES ('37201', '23', 'Санта Маргарита', 'Santa Margarita', 'CA', '93453', '35.3112', '-120.2730');
INSERT INTO `net_city` VALUES ('37205', '23', 'Норден', 'Norden', 'CA', '95724', '39.3180', '-120.3560');
INSERT INTO `net_city` VALUES ('37209', '23', 'Пайн Валли', 'Pine Valley', 'CA', '91962', '32.7857', '-116.4874');
INSERT INTO `net_city` VALUES ('37210', '23', 'Уэнтворт', 'Wentworth', 'SD', '57075', '43.9934', '-96.9740');
INSERT INTO `net_city` VALUES ('37222', '23', 'Топика', 'Topeka', 'IN', '46571', '41.5718', '-85.5361');
INSERT INTO `net_city` VALUES ('37235', '23', 'Сидар Валли', 'Cedar Valley', 'UT', '84013', '40.3336', '-112.1132');
INSERT INTO `net_city` VALUES ('37237', '23', 'Кресент', 'Crescent', 'IA', '51526', '41.3946', '-95.8971');
INSERT INTO `net_city` VALUES ('37249', '23', 'Бруно', 'Bruneau', 'ID', '83604', '42.5791', '-115.8514');
INSERT INTO `net_city` VALUES ('37250', '23', 'Уэрленд', 'Worland', 'WY', '82401', '44.0205', '-108.2314');
INSERT INTO `net_city` VALUES ('37257', '23', 'Дален', 'Dahlen', 'ND', '58224', '48.1658', '-97.9575');
INSERT INTO `net_city` VALUES ('37267', '23', 'Пангитч', 'Panguitch', 'UT', '84759', '37.8694', '-112.3460');
INSERT INTO `net_city` VALUES ('37271', '23', 'Станфилд', 'Stanfield', 'AZ', '85272', '32.8032', '-112.0064');
INSERT INTO `net_city` VALUES ('37288', '23', 'Тендой', 'Tendoy', 'ID', '83468', '44.9609', '-113.6414');
INSERT INTO `net_city` VALUES ('37295', '23', 'Лусерн', 'Lucerne', 'CO', '80646', '40.4819', '-104.6997');
INSERT INTO `net_city` VALUES ('37299', '23', 'Омак', 'Omak', 'WA', '98841', '48.3647', '-119.2704');
INSERT INTO `net_city` VALUES ('37300', '23', 'Отелло', 'Othello', 'WA', '99344', '46.8027', '-119.1557');
INSERT INTO `net_city` VALUES ('37304', '23', 'Вега', 'Vega', 'TX', '79092', '35.2503', '-102.4174');
INSERT INTO `net_city` VALUES ('37313', '23', 'Таоламн', 'Tuolumne', 'CA', '95379', '37.9521', '-120.2019');
INSERT INTO `net_city` VALUES ('37316', '23', 'Альда', 'Alda', 'NE', '68810', '40.8575', '-98.4595');
INSERT INTO `net_city` VALUES ('37317', '23', 'Миссури Валли', 'Missouri Valley', 'IA', '51555', '41.5824', '-95.9205');
INSERT INTO `net_city` VALUES ('37323', '23', 'Белфэр', 'Belfair', 'WA', '98528', '47.4341', '-122.9259');
INSERT INTO `net_city` VALUES ('37325', '164', 'Ла-Сейба', 'La Ceiba', '01', '', '15.7833', '-86.8000');
INSERT INTO `net_city` VALUES ('37326', '23', 'Арапахо', 'Arapahoe', 'CO', '80802', '38.8310', '-102.1995');
INSERT INTO `net_city` VALUES ('37327', '23', 'Манкос', 'Mancos', 'CO', '81328', '37.3789', '-108.2815');
INSERT INTO `net_city` VALUES ('37328', '23', 'Ист Норидж', 'East Norwich', 'NY', '11732', '40.8419', '-73.5364');
INSERT INTO `net_city` VALUES ('37335', '23', 'Арма', 'Armagh', 'PA', '15920', '40.4681', '-79.0451');
INSERT INTO `net_city` VALUES ('37338', '23', 'Дабах', 'Dubach', 'LA', '71235', '32.6975', '-92.6707');
INSERT INTO `net_city` VALUES ('37342', '23', 'Чино Валли', 'Chino Valley', 'AZ', '86323', '34.7706', '-112.4564');
INSERT INTO `net_city` VALUES ('37343', '23', 'Беллмонт', 'Bellemont', 'AZ', '86015', '35.2381', '-111.8335');
INSERT INTO `net_city` VALUES ('37347', '23', 'Алта', 'Alta', 'CA', '95701', '39.2176', '-120.7924');
INSERT INTO `net_city` VALUES ('37349', '23', 'Мамерс', 'Mamers', 'NC', '27552', '35.4168', '-78.9334');
INSERT INTO `net_city` VALUES ('37361', '23', 'Палатин Бридж', 'Palatine Bridge', 'NY', '13428', '42.9206', '-74.5453');
INSERT INTO `net_city` VALUES ('37362', '23', 'Плезант Валли', 'Pleasant Valley', 'NY', '12569', '41.7293', '-73.7927');
INSERT INTO `net_city` VALUES ('37365', '23', 'Ямхилл', 'Yamhill', 'OR', '97148', '45.3660', '-123.2479');
INSERT INTO `net_city` VALUES ('37368', '23', 'Хеленвуд', 'Helenwood', 'TN', '37755', '36.4133', '-84.4937');
INSERT INTO `net_city` VALUES ('37384', '23', 'Холмс Милл', 'Holmes Mill', 'KY', '40843', '36.8891', '-82.9664');
INSERT INTO `net_city` VALUES ('37473', '25', 'Сапопан', 'Zapopan', '14', '', '20.7167', '-103.4000');
INSERT INTO `net_city` VALUES ('37474', '25', 'Тлалнепантла', 'Tlalnepantla', '15', '', '19.5269', '-99.2217');
INSERT INTO `net_city` VALUES ('37476', '58', 'Глория', 'Glória', '11', '', '-22.3500', '-54.2167');
INSERT INTO `net_city` VALUES ('37484', '23', 'Мансфилд Сентер', 'Mansfield Center', 'CT', '06250', '41.7816', '-72.1810');
INSERT INTO `net_city` VALUES ('37487', '23', 'Годли', 'Godley', 'TX', '76044', '32.4331', '-97.5390');
INSERT INTO `net_city` VALUES ('37496', '23', 'Амлин', 'Amlin', 'OH', '43002', '40.0537', '-83.2180');
INSERT INTO `net_city` VALUES ('37498', '23', 'Рандл', 'Randle', 'WA', '98377', '46.4797', '-121.8220');
INSERT INTO `net_city` VALUES ('37500', '23', 'Тексхома', 'Texhoma', 'OK', '73949', '36.5668', '-101.9513');
INSERT INTO `net_city` VALUES ('37502', '23', 'Уоткинс', 'Watkins', 'IA', '52354', '41.9127', '-91.9887');
INSERT INTO `net_city` VALUES ('37505', '23', 'Ок Блафс', 'Oak Bluffs', 'MA', '02557', '41.4543', '-70.5620');
INSERT INTO `net_city` VALUES ('37506', '23', 'Оровилл', 'Oroville', 'WA', '98844', '48.8791', '-119.2245');
INSERT INTO `net_city` VALUES ('37514', '23', 'Норт Хейвенхилл', 'North Haverhill', 'NH', '03774', '44.0862', '-71.9862');
INSERT INTO `net_city` VALUES ('37516', '23', 'Кларивилл', 'Claryville', 'NY', '12725', '41.9586', '-74.5331');
INSERT INTO `net_city` VALUES ('37518', '23', 'Арверн', 'Arverne', 'NY', '11692', '40.5950', '-73.7876');
INSERT INTO `net_city` VALUES ('37519', '23', 'Уинтерс', 'Winters', 'CA', '95694', '38.5602', '-121.9961');
INSERT INTO `net_city` VALUES ('37523', '23', 'Читтенанго', 'Chittenango', 'NY', '13037', '43.0581', '-75.8674');
INSERT INTO `net_city` VALUES ('37528', '23', 'Дачесн', 'Duchesne', 'UT', '84021', '40.1033', '-110.4972');
INSERT INTO `net_city` VALUES ('37533', '23', 'Канаб', 'Kanab', 'UT', '84741', '37.2718', '-112.2365');
INSERT INTO `net_city` VALUES ('37534', '23', 'Аккомак', 'Accomac', 'VA', '23301', '37.7022', '-75.6592');
INSERT INTO `net_city` VALUES ('37541', '23', 'Даймондейл', 'Dimondale', 'MI', '48821', '42.6406', '-84.6542');
INSERT INTO `net_city` VALUES ('37544', '23', 'Сеноия', 'Senoia', 'GA', '30276', '33.2677', '-84.5999');
INSERT INTO `net_city` VALUES ('37556', '23', 'Абита Спрингс', 'Abita Springs', 'LA', '70420', '30.4904', '-89.9549');
INSERT INTO `net_city` VALUES ('37559', '23', 'Гаутьер', 'Gautier', 'MS', '39553', '30.4224', '-88.6527');
INSERT INTO `net_city` VALUES ('37562', '23', 'Уэбстер', 'Webster', 'SD', '57274', '45.2972', '-97.6034');
INSERT INTO `net_city` VALUES ('37565', '165', 'Кралендейк', 'Kralendijk', '00', '', '12.1500', '-68.2667');
INSERT INTO `net_city` VALUES ('37581', '23', 'Хамер', 'Hamer', 'SC', '29547', '34.4879', '-79.3234');
INSERT INTO `net_city` VALUES ('37586', '23', 'Мурсберг', 'Mooresburg', 'TN', '37811', '36.3577', '-83.1940');
INSERT INTO `net_city` VALUES ('37592', '23', 'Амагансетт', 'Amagansett', 'NY', '11930', '40.9737', '-72.1437');
INSERT INTO `net_city` VALUES ('37593', '23', 'Манила', 'Manila', 'UT', '84046', '40.9488', '-109.7957');
INSERT INTO `net_city` VALUES ('37596', '23', 'Мулино', 'Mulino', 'OR', '97042', '45.2081', '-122.5407');
INSERT INTO `net_city` VALUES ('37599', '23', 'Кимболтон', 'Kimbolton', 'OH', '43749', '40.1475', '-81.5870');
INSERT INTO `net_city` VALUES ('37602', '23', 'Бибер', 'Bieber', 'CA', '96009', '41.1213', '-121.1441');
INSERT INTO `net_city` VALUES ('37603', '44', 'Макати', 'Makati City', '53', '', '14.5094', '120.9931');
INSERT INTO `net_city` VALUES ('37608', '23', 'Джун Лейк', 'June Lake', 'CA', '93529', '37.7758', '-119.0671');
INSERT INTO `net_city` VALUES ('37610', '23', 'Даллс', 'Dulles', 'VA', '20101', '39.0021', '-77.4421');
INSERT INTO `net_city` VALUES ('37614', '23', 'Батл Маунтин', 'Battle Mountain', 'NV', '89820', '40.4709', '-117.0363');
INSERT INTO `net_city` VALUES ('37619', '23', 'Лимон', 'Limon', 'CO', '80828', '39.2673', '-103.6851');
INSERT INTO `net_city` VALUES ('37623', '23', 'Йодер', 'Yoder', 'IN', '46798', '40.9428', '-85.2320');
INSERT INTO `net_city` VALUES ('37634', '4', 'Нанкин', 'Nanjing', '04', '', '32.0617', '118.7778');
INSERT INTO `net_city` VALUES ('37637', '23', 'Гвинн', 'Gwinn', 'MI', '49841', '46.2880', '-87.5165');
INSERT INTO `net_city` VALUES ('37638', '23', 'Норт Риджвилл', 'North Ridgeville', 'OH', '44039', '41.3853', '-82.0195');
INSERT INTO `net_city` VALUES ('37654', '23', 'Уэймея', 'Waimea', 'HI', '96796', '22.0609', '-159.7131');
INSERT INTO `net_city` VALUES ('37655', '23', 'Секвойя Нешнел Парк', 'Sequoia National Park', 'CA', '93262', '36.5377', '-118.7274');
INSERT INTO `net_city` VALUES ('37656', '23', 'Рокхаус', 'Rockhouse', 'KY', '41561', '37.8695', '-83.1225');
INSERT INTO `net_city` VALUES ('37663', '23', 'Камак', 'Camak', 'GA', '30807', '33.4535', '-82.6460');
INSERT INTO `net_city` VALUES ('37664', '23', 'Аддисон', 'Addison', 'NY', '14801', '42.1024', '-77.2983');
INSERT INTO `net_city` VALUES ('37673', '23', 'Ред Бойлинг Спрингс', 'Red Boiling Springs', 'TN', '37150', '36.5171', '-85.8149');
INSERT INTO `net_city` VALUES ('37678', '23', 'Игл', 'Eagle', 'NE', '68347', '40.8057', '-96.4251');
INSERT INTO `net_city` VALUES ('37681', '23', 'Хампстед', 'Hampstead', 'NC', '28443', '34.4568', '-77.6691');
INSERT INTO `net_city` VALUES ('37683', '23', 'Апалачайн', 'Apalachin', 'NY', '13732', '42.0503', '-76.1751');
INSERT INTO `net_city` VALUES ('37684', '23', 'Колмснейл', 'Colmesneil', 'TX', '75938', '30.9322', '-94.3499');
INSERT INTO `net_city` VALUES ('37685', '23', 'Браунфилд', 'Brownfield', 'TX', '79316', '33.1643', '-102.3270');
INSERT INTO `net_city` VALUES ('37686', '23', 'Авингер', 'Avinger', 'TX', '75630', '32.8756', '-94.5285');
INSERT INTO `net_city` VALUES ('37687', '23', 'Перривилл', 'Perryville', 'AR', '72126', '34.9324', '-92.9264');
INSERT INTO `net_city` VALUES ('37688', '23', 'Кристал-Сити', 'Crystal City', 'TX', '78839', '28.7317', '-99.7894');
INSERT INTO `net_city` VALUES ('37689', '23', 'Маунт-Вернон', 'Mount Vernon', 'TX', '75457', '33.1853', '-95.2163');
INSERT INTO `net_city` VALUES ('37692', '23', 'Ланевилл', 'Laneville', 'TX', '75667', '31.9738', '-94.8458');
INSERT INTO `net_city` VALUES ('37693', '23', 'Саути Накоочи', 'Sautee Nacoochee', 'GA', '30571', '34.7127', '-83.7068');
INSERT INTO `net_city` VALUES ('37698', '23', 'Лиссабон', 'Lisbon', 'IA', '52253', '41.8942', '-91.3489');
INSERT INTO `net_city` VALUES ('37699', '23', 'Паласиос', 'Palacios', 'TX', '77465', '28.7575', '-96.2523');
INSERT INTO `net_city` VALUES ('37703', '23', 'Тьюлия', 'Tulia', 'TX', '79088', '34.5730', '-101.7349');
INSERT INTO `net_city` VALUES ('37704', '23', 'Лейк Лур', 'Lake Lure', 'NC', '28746', '35.4625', '-82.1803');
INSERT INTO `net_city` VALUES ('37710', '23', 'Сатсума', 'Satsuma', 'FL', '32189', '29.5408', '-81.6552');
INSERT INTO `net_city` VALUES ('37712', '23', 'Агуанга', 'Aguanga', 'CA', '92536', '33.5040', '-116.8193');
INSERT INTO `net_city` VALUES ('37715', '23', 'Блафф Дейл', 'Bluff Dale', 'TX', '76433', '32.2966', '-98.0182');
INSERT INTO `net_city` VALUES ('37716', '23', 'Мекка', 'Mecca', 'CA', '92254', '33.5524', '-115.9741');
INSERT INTO `net_city` VALUES ('37720', '23', 'Альба', 'Alba', 'TX', '75410', '32.7948', '-95.6360');
INSERT INTO `net_city` VALUES ('37721', '23', 'Лоудон', 'Loudon', 'NH', '03307', '43.3229', '-71.4415');
INSERT INTO `net_city` VALUES ('37722', '23', 'Ист Макиас', 'East Machias', 'ME', '04630', '44.7791', '-67.4273');
INSERT INTO `net_city` VALUES ('37726', '23', 'Эмори', 'Emory', 'TX', '75440', '32.8391', '-95.7591');
INSERT INTO `net_city` VALUES ('37728', '23', 'Рикролл', 'Rickreall', 'OR', '97371', '44.9900', '-123.2037');
INSERT INTO `net_city` VALUES ('37730', '23', 'Сентервью', 'Centerview', 'MO', '64019', '38.7790', '-93.8657');
INSERT INTO `net_city` VALUES ('37731', '23', 'Спрингдейл', 'Springdale', 'UT', '84767', '37.1889', '-112.9985');
INSERT INTO `net_city` VALUES ('37732', '23', 'Гила Бенд', 'Gila Bend', 'AZ', '85337', '32.9929', '-112.9084');
INSERT INTO `net_city` VALUES ('37736', '23', 'Коммодор', 'Commodore', 'PA', '15729', '40.7049', '-78.9248');
INSERT INTO `net_city` VALUES ('37737', '13', 'Савиньоне ', 'Savignone', '08', '', '44.5167', '9.0500');
INSERT INTO `net_city` VALUES ('37739', '23', 'Килкенни', 'Kilkenny', 'MN', '56052', '44.3123', '-93.5637');
INSERT INTO `net_city` VALUES ('37740', '23', 'Гленс Форк', 'Glens Fork', 'KY', '42741', '36.9894', '-85.2575');
INSERT INTO `net_city` VALUES ('37741', '23', 'Ганнибал', 'Hannibal', 'WI', '54439', '45.2525', '-90.7890');
INSERT INTO `net_city` VALUES ('37749', '13', 'Искья', 'Ischia', '04', '', '40.7333', '13.9500');
INSERT INTO `net_city` VALUES ('37755', '23', 'Оруэлл', 'Orwell', 'VT', '05760', '43.8008', '-73.2984');
INSERT INTO `net_city` VALUES ('37756', '22', 'Ведбек', 'Vedbaek', '05', '', '55.8167', '12.5500');
INSERT INTO `net_city` VALUES ('37757', '23', 'Метлейкатла', 'Metlakatla', 'AK', '99926', '55.1443', '-131.4984');
INSERT INTO `net_city` VALUES ('37759', '23', 'Лонгс', 'Longs', 'SC', '29568', '33.8944', '-78.7503');
INSERT INTO `net_city` VALUES ('37766', '12', 'Булонь-Бийанкур', 'Boulogne-Billancourt', 'A8', '', '48.8357', '2.2473');
INSERT INTO `net_city` VALUES ('37767', '35', 'Кадис', 'Cadiz', '51', '', '36.5158', '-6.2797');
INSERT INTO `net_city` VALUES ('37768', '21', 'Уэлшпул', 'Welshpool', 'Y8', '', '52.6667', '-3.1333');
INSERT INTO `net_city` VALUES ('37772', '23', 'Кэмп Дуглас', 'Camp Douglas', 'WI', '54618', '43.9583', '-90.2984');
INSERT INTO `net_city` VALUES ('37802', '23', 'Хопвуд', 'Hopwood', 'PA', '15445', '39.8699', '-79.6490');
INSERT INTO `net_city` VALUES ('37805', '23', 'Комсток', 'Comstock', 'MI', '49041', '42.2867', '-85.5133');
INSERT INTO `net_city` VALUES ('37806', '13', 'Дзола-Предоза', 'Zola Predosa', '05', '', '44.4833', '11.2000');
INSERT INTO `net_city` VALUES ('37810', '23', 'Уэстгемптон', 'Westhampton', 'NY', '11977', '40.8302', '-72.6873');
INSERT INTO `net_city` VALUES ('37815', '38', 'Пуэрто-Монт', 'Puerto Montt', '09', '', '-41.4698', '-72.9447');
INSERT INTO `net_city` VALUES ('37822', '1', 'Армидейл', 'Armidale', '02', '', '-30.5083', '151.6712');
INSERT INTO `net_city` VALUES ('37826', '1', 'Солсбери', 'Salisbury', '07', '', '-36.3500', '141.7667');
INSERT INTO `net_city` VALUES ('37866', '109', 'Конья', 'Konya', '71', '', '37.8714', '32.4846');
INSERT INTO `net_city` VALUES ('37935', '23', 'Эддингтон', 'Eddington', 'ME', '04428', '44.8066', '-68.5728');
INSERT INTO `net_city` VALUES ('37964', '23', 'Миннеола', 'Minneola', 'KS', '67865', '37.3872', '-99.9408');
INSERT INTO `net_city` VALUES ('37971', '23', 'Вилла Ридж', 'Villa Ridge', 'MO', '63089', '38.4561', '-90.8920');
INSERT INTO `net_city` VALUES ('37973', '23', 'Бардуэлл', 'Bardwell', 'TX', '75101', '32.2690', '-96.6961');
INSERT INTO `net_city` VALUES ('37975', '23', 'Элмендорф', 'Elmendorf', 'TX', '78112', '29.2054', '-98.3553');
INSERT INTO `net_city` VALUES ('37979', '21', 'Сайренсестер', 'Cirencester', 'E6', '', '51.7333', '-1.9833');
INSERT INTO `net_city` VALUES ('37981', '23', 'Дуглас', 'Douglass', 'KS', '67039', '37.5220', '-96.9987');
INSERT INTO `net_city` VALUES ('37983', '23', 'Планада', 'Planada', 'CA', '95365', '37.2908', '-120.3185');
INSERT INTO `net_city` VALUES ('37990', '114', 'Брно', 'Brno', '78', '', '49.2000', '16.6333');
INSERT INTO `net_city` VALUES ('37992', '1', 'Аспендейл', 'Aspendale', '07', '', '-38.0333', '145.1000');
INSERT INTO `net_city` VALUES ('37995', '192', 'Паго-Паго', 'Pago Pago', '00', '', '-14.2393', '-170.7221');
INSERT INTO `net_city` VALUES ('38000', '23', 'Марипоса', 'Mariposa', 'CA', '95338', '37.4986', '-120.0092');
INSERT INTO `net_city` VALUES ('38001', '23', 'Форт Бидуэлл', 'Fort Bidwell', 'CA', '96112', '41.8815', '-120.1150');
INSERT INTO `net_city` VALUES ('38015', '23', 'Лукаут', 'Lookout', 'WV', '25868', '38.0654', '-80.9725');
INSERT INTO `net_city` VALUES ('38021', '130', 'Токумен', 'Tocumen', '08', '', '9.0833', '-79.3833');
INSERT INTO `net_city` VALUES ('38023', '21', 'Крю', 'Crewe', 'C5', '', '53.1', '-2.4333');
INSERT INTO `net_city` VALUES ('38031', '23', 'Гудфилд', 'Goodfield', 'IL', '61742', '40.6256', '-89.2869');
INSERT INTO `net_city` VALUES ('38032', '23', 'Фэрфакс', 'Fairfax', 'VT', '05454', '44.7079', '-73.0225');
INSERT INTO `net_city` VALUES ('38069', '23', 'Брул', 'Brule', 'NE', '69127', '41.1008', '-101.9300');
INSERT INTO `net_city` VALUES ('38081', '163', 'Боливар', 'Bolívar', '09', '', '1.9708', '-76.9694');
INSERT INTO `net_city` VALUES ('38098', '13', 'Кремона', 'Cremona', '05', '', '45.1167', '10.0333');
INSERT INTO `net_city` VALUES ('38106', '23', 'Вайн Гров', 'Vine Grove', 'KY', '40175', '37.8300', '-86.0934');
INSERT INTO `net_city` VALUES ('38131', '12', 'Кретей', 'Creteil', 'A8', '', '48.7927', '2.4657');
INSERT INTO `net_city` VALUES ('38133', '33', 'Ден-Хелдер', 'Den Helder', '07', '', '52.9561', '4.7594');
INSERT INTO `net_city` VALUES ('38134', '33', 'Алмере', 'Almere', '16', '', '52.3881', '5.2354');
INSERT INTO `net_city` VALUES ('38140', '18', 'Кавала', 'Kavala', '14', '', '40.9397', '24.4019');
INSERT INTO `net_city` VALUES ('38145', '23', 'Глен Роуз', 'Glen Rose', 'TX', '76043', '32.1990', '-97.7934');
INSERT INTO `net_city` VALUES ('38147', '12', 'Тур', 'Tours', 'A3', '', '47.3948', '0.7040');
INSERT INTO `net_city` VALUES ('38148', '13', 'Фоллоника', 'Follonica', '16', '', '42.9167', '10.7500');
INSERT INTO `net_city` VALUES ('38150', '23', 'Гаспорт', 'Gasport', 'NY', '14067', '43.2493', '-78.5728');
INSERT INTO `net_city` VALUES ('38151', '13', 'Оспедалетто-Лодиджано', 'Ospedaletto Lodigiano', '09', '', '45.2333', '9.6000');
INSERT INTO `net_city` VALUES ('38156', '23', 'Мозьер', 'Mozier', 'IL', '62070', '39.2918', '-90.7359');
INSERT INTO `net_city` VALUES ('38161', '23', 'Кэш', 'Cache', 'OK', '73527', '34.6190', '-98.6479');
INSERT INTO `net_city` VALUES ('38169', '24', 'Ирокез Фолс', 'Iroquois Falls', 'ON', 'p0k1e0', '48.7667', '-80.6667');
INSERT INTO `net_city` VALUES ('38173', '23', 'Станвуд', 'Stanwood', 'MI', '49346', '43.5918', '-85.3981');
INSERT INTO `net_city` VALUES ('38209', '25', 'Гуанахуато', 'Guanajuato', '11', '', '21.0167', '-101.2500');
INSERT INTO `net_city` VALUES ('38216', '23', 'Джорджиана', 'Georgiana', 'AL', '36033', '31.6773', '-86.7763');
INSERT INTO `net_city` VALUES ('38221', '23', 'Сомерс', 'Somers', 'MT', '59932', '48.0764', '-114.1273');
INSERT INTO `net_city` VALUES ('38224', '23', 'Дусман', 'Dousman', 'WI', '53118', '42.9758', '-88.4868');
INSERT INTO `net_city` VALUES ('38225', '23', 'Элтопиа', 'Eltopia', 'WA', '99330', '46.5004', '-119.0536');
INSERT INTO `net_city` VALUES ('38226', '23', 'Канджилон', 'Canjilon', 'NM', '87515', '36.4795', '-106.4378');
INSERT INTO `net_city` VALUES ('38238', '23', 'Дашор', 'Dushore', 'PA', '18614', '41.4671', '-76.2194');
INSERT INTO `net_city` VALUES ('38243', '23', 'Парагон', 'Paragon', 'IN', '46166', '39.4202', '-86.5838');
INSERT INTO `net_city` VALUES ('38247', '23', 'Фоллинг Уотерс', 'Falling Waters', 'WV', '25419', '39.5749', '-77.8873');
INSERT INTO `net_city` VALUES ('38252', '1', 'Гладстон', 'Gladstone', '04', '', '-23.8476', '151.2563');
INSERT INTO `net_city` VALUES ('38254', '23', 'Кантролл', 'Cantrall', 'IL', '62625', '39.9064', '-89.6980');
INSERT INTO `net_city` VALUES ('38261', '23', 'Озарк', 'Ozark', 'IL', '62972', '37.5339', '-88.7843');
INSERT INTO `net_city` VALUES ('38263', '23', 'Эддивилл', 'Eddyville', 'IL', '62928', '37.4803', '-88.5687');
INSERT INTO `net_city` VALUES ('38265', '23', 'Элизабеттаун', 'Elizabethtown', 'IL', '62931', '37.5428', '-88.2815');
INSERT INTO `net_city` VALUES ('38266', '23', 'Розиклер', 'Rosiclare', 'IL', '62982', '37.4331', '-88.3565');
INSERT INTO `net_city` VALUES ('38269', '23', 'Херрин', 'Herrin', 'IL', '62948', '37.8180', '-89.0278');
INSERT INTO `net_city` VALUES ('38272', '23', 'Кобден', 'Cobden', 'IL', '62920', '37.5384', '-89.2219');
INSERT INTO `net_city` VALUES ('38277', '23', 'Уитленд', 'Wheatland', 'CA', '95692', '39.0470', '-121.3976');
INSERT INTO `net_city` VALUES ('38278', '23', 'Сода Спрингс', 'Soda Springs', 'CA', '95728', '39.2799', '-120.4152');
INSERT INTO `net_city` VALUES ('38293', '23', 'Калахео', 'Kalaheo', 'HI', '96741', '21.9673', '-159.5228');
INSERT INTO `net_city` VALUES ('38294', '23', 'Фидлтаун', 'Fiddletown', 'CA', '95629', '38.5222', '-120.7033');
INSERT INTO `net_city` VALUES ('38298', '23', 'Мосс Бич', 'Moss Beach', 'CA', '94038', '37.5149', '-122.5033');
INSERT INTO `net_city` VALUES ('38300', '23', 'Медоу Валли', 'Meadow Valley', 'CA', '95956', '39.9269', '-121.0533');
INSERT INTO `net_city` VALUES ('38301', '23', 'Холтвилл', 'Holtville', 'CA', '92250', '32.8345', '-115.1961');
INSERT INTO `net_city` VALUES ('38304', '23', 'Гринсборо Бенд', 'Greensboro Bend', 'VT', '05842', '44.5880', '-72.2462');
INSERT INTO `net_city` VALUES ('38308', '23', 'Бернетт', 'Burnett', 'WI', '53922', '43.5172', '-88.7137');
INSERT INTO `net_city` VALUES ('38311', '23', 'Салида', 'Salida', 'CA', '95368', '37.7187', '-121.0899');
INSERT INTO `net_city` VALUES ('38318', '23', 'Ольстер Парк', 'Ulster Park', 'NY', '12487', '41.8618', '-73.9984');
INSERT INTO `net_city` VALUES ('38327', '24', 'Сен-Никола', 'St. Nicolas', 'QC', 'g1y2h4', '46.7500', '-71.3500');
INSERT INTO `net_city` VALUES ('38374', '12', 'Руан', 'Rouen', 'A7', '', '49.4333', '1.0833');
INSERT INTO `net_city` VALUES ('38377', '21', 'Росс-он-Уай', 'Ross-on-Wye', 'E6', '', '51.9167', '-2.5667');
INSERT INTO `net_city` VALUES ('38383', '1', 'Ньюстед', 'Newstead', '07', '', '-37.1060', '144.0647');
INSERT INTO `net_city` VALUES ('38409', '23', 'Флеминг', 'Fleming', 'CO', '80728', '40.6307', '-102.9076');
INSERT INTO `net_city` VALUES ('38410', '23', 'Ньюалла', 'Newalla', 'OK', '74857', '35.3482', '-97.1996');
INSERT INTO `net_city` VALUES ('38412', '23', 'Гарднер', 'Gardner', 'IL', '60424', '41.1847', '-88.3107');
INSERT INTO `net_city` VALUES ('38415', '23', 'Пеоста', 'Peosta', 'IA', '52068', '42.4245', '-90.8083');
INSERT INTO `net_city` VALUES ('38416', '23', 'Маунт Леммон', 'Mount Lemmon', 'AZ', '85619', '32.3874', '-110.7568');
INSERT INTO `net_city` VALUES ('38423', '12', 'Люттербах', 'Lutterbach', 'C1', '', '47.7584', '7.2770');
INSERT INTO `net_city` VALUES ('38426', '23', 'Хартли', 'Hartley', 'TX', '79044', '35.8682', '-102.3650');
INSERT INTO `net_city` VALUES ('38551', '23', 'Уайт Пост', 'White Post', 'VA', '22663', '39.0535', '-78.1192');
INSERT INTO `net_city` VALUES ('38552', '23', 'Хинтон', 'Hinton', 'VA', '22831', '38.6230', '-79.0667');
INSERT INTO `net_city` VALUES ('38557', '23', 'Адамс', 'Adams', 'ND', '58210', '48.4124', '-98.1338');
INSERT INTO `net_city` VALUES ('38561', '23', 'Стидхэм', 'Stidham', 'OK', '74461', '35.3821', '-95.6868');
INSERT INTO `net_city` VALUES ('38567', '23', 'Топсфилд', 'Topsfield', 'ME', '04490', '45.4351', '-67.7849');
INSERT INTO `net_city` VALUES ('38579', '23', 'Хантингтон Милс', 'Huntington Mills', 'PA', '18622', '41.1998', '-76.2520');
INSERT INTO `net_city` VALUES ('38582', '23', 'Анита', 'Anita', 'PA', '15711', '41.0105', '-78.9587');
INSERT INTO `net_city` VALUES ('38601', '23', 'Патриот', 'Patriot', 'OH', '45658', '38.7654', '-82.4114');
INSERT INTO `net_city` VALUES ('38602', '23', 'Глен Хейвен', 'Glen Haven', 'CO', '80532', '40.4539', '-105.4492');
INSERT INTO `net_city` VALUES ('38613', '23', 'Бенхам', 'Benham', 'KY', '40807', '36.9634', '-82.9500');
INSERT INTO `net_city` VALUES ('38617', '23', 'Агат', 'Agate', 'CO', '80101', '39.4025', '-104.0437');
INSERT INTO `net_city` VALUES ('38637', '23', 'Плейнвью', 'Plainview', 'TX', '79072', '34.0946', '-101.6830');
INSERT INTO `net_city` VALUES ('38639', '23', 'Хардин', 'Hardin', 'TX', '77561', '30.1701', '-94.7096');
INSERT INTO `net_city` VALUES ('38641', '23', 'Гудленд', 'Goodland', 'KS', '67735', '39.3509', '-101.7498');
INSERT INTO `net_city` VALUES ('38646', '23', 'Паоли', 'Paoli', 'OK', '73074', '34.8437', '-97.2738');
INSERT INTO `net_city` VALUES ('38652', '23', 'Шамрок', 'Shamrock', 'TX', '79079', '35.1980', '-100.2837');
INSERT INTO `net_city` VALUES ('38655', '23', 'Чатейньер', 'Chataignier', 'LA', '70524', '30.5685', '-92.3221');
INSERT INTO `net_city` VALUES ('38657', '23', 'Донна', 'Donna', 'TX', '78537', '26.1629', '-98.0560');
INSERT INTO `net_city` VALUES ('38661', '23', 'Кентс Хилл', 'Kents Hill', 'ME', '04349', '44.4354', '-70.0731');
INSERT INTO `net_city` VALUES ('38686', '23', 'Скотс', 'Scotts', 'MI', '49088', '42.1869', '-85.4274');
INSERT INTO `net_city` VALUES ('38688', '40', 'Мендоса', 'Mendoza', '13', '', '-32.8908', '-68.8272');
INSERT INTO `net_city` VALUES ('38690', '23', 'Капаа', 'Kapaa', 'HI', '96746', '22.0837', '-159.3553');
INSERT INTO `net_city` VALUES ('38691', '23', 'Колоа', 'Koloa', 'HI', '96756', '21.9081', '-159.4762');
INSERT INTO `net_city` VALUES ('38693', '23', 'Пахоа', 'Pahoa', 'HI', '96778', '19.4601', '-155.0246');
INSERT INTO `net_city` VALUES ('38694', '161', 'Арекипа', 'Arequipa', '04', '', '-16.3989', '-71.5350');
INSERT INTO `net_city` VALUES ('38712', '23', 'Меро', 'Meraux', 'LA', '70075', '29.9313', '-89.9228');
INSERT INTO `net_city` VALUES ('38713', '23', 'Оринджфилд', 'Orangefield', 'TX', '77639', '30.0749', '-93.8557');
INSERT INTO `net_city` VALUES ('38714', '23', 'Брундидж', 'Brundidge', 'AL', '36010', '31.6706', '-85.8347');
INSERT INTO `net_city` VALUES ('38716', '23', 'Барнард', 'Barnard', 'VT', '05031', '43.7287', '-72.6190');
INSERT INTO `net_city` VALUES ('38724', '23', 'Макиас', 'Machias', 'ME', '04654', '44.7986', '-67.5424');
INSERT INTO `net_city` VALUES ('38727', '23', 'Норт Спрингфилд', 'North Springfield', 'VT', '05150', '43.3356', '-72.5242');
INSERT INTO `net_city` VALUES ('38731', '5', 'Касива', 'Kashiwa', '04', '', '35.8544', '139.9689');
INSERT INTO `net_city` VALUES ('38732', '40', 'Рио Себальос', 'Rio Ceballos', '05', '', '-31.1667', '-64.3333');
INSERT INTO `net_city` VALUES ('38753', '23', 'Чатогей', 'Chateaugay', 'NY', '12920', '44.8656', '-74.0691');
INSERT INTO `net_city` VALUES ('38755', '23', 'Эрскин', 'Erskine', 'MN', '56535', '47.6771', '-96.0658');
INSERT INTO `net_city` VALUES ('38760', '23', 'Флористон', 'Floriston', 'CA', '96111', '39.3946', '-120.0213');
INSERT INTO `net_city` VALUES ('38762', '23', 'Суэйзи', 'Swayzee', 'IN', '46986', '40.5051', '-85.8157');
INSERT INTO `net_city` VALUES ('38763', '23', 'Нью Лисбон', 'New Lisbon', 'IN', '47366', '39.8634', '-85.2630');
INSERT INTO `net_city` VALUES ('38765', '23', 'Менифи', 'Menifee', 'CA', '92584', '33.6518', '-117.1823');
INSERT INTO `net_city` VALUES ('38771', '23', 'Джонспорт', 'Jonesport', 'ME', '04649', '44.5794', '-67.6002');
INSERT INTO `net_city` VALUES ('38781', '23', 'Уэбстер Спрингс', 'Webster Springs', 'WV', '26288', '38.4936', '-80.3694');
INSERT INTO `net_city` VALUES ('38783', '23', 'Каункакай', 'Kaunakakai', 'HI', '96748', '21.1090', '-156.9093');
INSERT INTO `net_city` VALUES ('38785', '23', 'Джефф', 'Jeff', 'KY', '41751', '37.2357', '-83.1167');
INSERT INTO `net_city` VALUES ('38808', '27', 'Адхунтас', 'Adjuntas', '00', '00601', '18.1812', '-66.7499');
INSERT INTO `net_city` VALUES ('38819', '23', 'Кимбал', 'Kimball', 'MN', '55353', '45.3272', '-94.3127');
INSERT INTO `net_city` VALUES ('38824', '23', 'Кристал', 'Crystal', 'MI', '48818', '43.2745', '-84.8999');
INSERT INTO `net_city` VALUES ('38829', '23', 'Шаттак', 'Shattuck', 'OK', '73858', '36.1393', '-99.8856');
INSERT INTO `net_city` VALUES ('38830', '23', 'Сейлинг', 'Seiling', 'OK', '73663', '36.0959', '-98.9026');
INSERT INTO `net_city` VALUES ('38832', '23', 'Грандфилд', 'Grandfield', 'OK', '73546', '34.2368', '-98.7752');
INSERT INTO `net_city` VALUES ('38834', '23', 'Гарбер', 'Garber', 'OK', '73738', '36.4654', '-97.5684');
INSERT INTO `net_city` VALUES ('38838', '23', 'Омега', 'Omega', 'OK', '73764', '35.8335', '-98.1982');
INSERT INTO `net_city` VALUES ('38839', '23', 'Маниту', 'Manitou', 'OK', '73555', '34.5221', '-98.9484');
INSERT INTO `net_city` VALUES ('38840', '23', 'Окин', 'Okeene', 'OK', '73763', '36.1154', '-98.3320');
INSERT INTO `net_city` VALUES ('38844', '23', 'Арнетт', 'Arnett', 'OK', '73832', '36.0518', '-99.6563');
INSERT INTO `net_city` VALUES ('38845', '23', 'Кресент', 'Crescent', 'OK', '73028', '35.9681', '-97.6426');
INSERT INTO `net_city` VALUES ('38846', '23', 'Ламонт', 'Lamont', 'OK', '74643', '36.7046', '-97.6065');
INSERT INTO `net_city` VALUES ('38848', '23', 'Алайн', 'Aline', 'OK', '73716', '36.4777', '-98.5327');
INSERT INTO `net_city` VALUES ('38849', '23', 'Холлис', 'Hollis', 'OK', '73550', '34.6860', '-99.8602');
INSERT INTO `net_city` VALUES ('38850', '23', 'Мурленд', 'Mooreland', 'OK', '73852', '36.4650', '-99.1300');
INSERT INTO `net_city` VALUES ('38854', '23', 'Томас', 'Thomas', 'OK', '73669', '35.7256', '-98.7281');
INSERT INTO `net_city` VALUES ('38856', '23', 'Уокомис', 'Waukomis', 'OK', '73773', '36.2487', '-97.8845');
INSERT INTO `net_city` VALUES ('38857', '23', 'Лахома', 'Lahoma', 'OK', '73754', '36.3834', '-98.0870');
INSERT INTO `net_city` VALUES ('38859', '23', 'Драммонд', 'Drummond', 'OK', '73735', '36.2632', '-98.0329');
INSERT INTO `net_city` VALUES ('38863', '23', 'Блэрстаун', 'Blairstown', 'MO', '64726', '38.5312', '-93.8946');
INSERT INTO `net_city` VALUES ('38866', '24', 'Пембертон', 'Pemberton', 'BC', 'v0n2l0', '50.3167', '-122.8167');
INSERT INTO `net_city` VALUES ('38875', '23', 'Варшава', 'Warsaw', 'KY', '41095', '38.7944', '-84.7797');
INSERT INTO `net_city` VALUES ('38890', '23', 'Кейни', 'Caney', 'KS', '67333', '37.0562', '-95.8737');
INSERT INTO `net_city` VALUES ('38915', '125', 'Фредрикстад', 'Fredrikstad', '13', '', '59.2167', '10.9500');
INSERT INTO `net_city` VALUES ('38918', '125', 'Халден ', 'Halden', '13', '', '59.1500', '11.3833');
INSERT INTO `net_city` VALUES ('38920', '23', 'Джонсон', 'Johnson', 'VT', '05656', '44.6475', '-72.6901');
INSERT INTO `net_city` VALUES ('38924', '23', 'Ист Хардвик', 'East Hardwick', 'VT', '05836', '44.5273', '-72.2383');
INSERT INTO `net_city` VALUES ('38925', '23', 'Аскутни', 'Ascutney', 'VT', '05030', '43.4070', '-72.4070');
INSERT INTO `net_city` VALUES ('38926', '55', 'Сордс', 'Swords', '07', '', '53.4597', '-6.2181');
INSERT INTO `net_city` VALUES ('38945', '23', 'Делл Рапидс', 'Dell Rapids', 'SD', '57022', '43.8701', '-96.7404');
INSERT INTO `net_city` VALUES ('38946', '23', 'Коуич', 'Cowiche', 'WA', '98923', '46.6655', '-120.7941');
INSERT INTO `net_city` VALUES ('38948', '23', 'Пауэлл Бьютт', 'Powell Butte', 'OR', '97753', '44.2378', '-121.0140');
INSERT INTO `net_city` VALUES ('38950', '23', 'Саутингтон', 'Southington', 'OH', '44470', '41.2982', '-80.9544');
INSERT INTO `net_city` VALUES ('38951', '40', 'Мар-дель-Плата', 'Mar Del Plata', '01', '', '-38.0023', '-57.5575');
INSERT INTO `net_city` VALUES ('38952', '29', 'Эрдинг', 'Erding', '02', '', '48.3000', '11.9333');
INSERT INTO `net_city` VALUES ('38955', '5', 'Окинава', 'Okinawa', '47', '', '26.3358', '127.8014');
INSERT INTO `net_city` VALUES ('38984', '21', 'Лоустофт', 'Lowestoft', 'N5', '', '52.4833', '1.7500');
INSERT INTO `net_city` VALUES ('38988', '29', 'Дайдесхайм ', 'Deidesheim', '08', '', '49.4092', '8.1878');
INSERT INTO `net_city` VALUES ('38991', '6', 'Джаландхар', 'Jalandhar', '23', '', '31.3256', '75.5792');
INSERT INTO `net_city` VALUES ('38995', '1', 'Ньюкасл', 'Newcastle', '02', '', '-32.9278', '151.7845');
INSERT INTO `net_city` VALUES ('39000', '13', 'Боргоманеро', 'Borgomanero', '09', '', '45.7000', '8.4667');
INSERT INTO `net_city` VALUES ('39002', '23', 'Уоиана', 'Waianae', 'HI', '96792', '21.4570', '-158.1730');
INSERT INTO `net_city` VALUES ('39006', '21', 'Хоршем', 'Horsham', 'P6', '', '51.0500', '-0.3333');
INSERT INTO `net_city` VALUES ('39008', '13', 'Болонья', 'Bologna', '05', '', '44.4833', '11.3333');
INSERT INTO `net_city` VALUES ('39009', '23', 'Уэймарт', 'Waymart', 'PA', '18472', '41.5722', '-75.3917');
INSERT INTO `net_city` VALUES ('39010', '21', 'Ньюпорт ', 'Newport', 'Y6', '', '51.5833', '-2.9833');
INSERT INTO `net_city` VALUES ('39011', '20', 'Челябинск', 'Chelyabinsk', '13', '', '55.1540', '61.4291');
INSERT INTO `net_city` VALUES ('39071', '23', 'Фишервилл', 'Fisherville', 'KY', '40023', '38.1674', '-85.4407');
INSERT INTO `net_city` VALUES ('39096', '23', 'Шинглхаус', 'Shinglehouse', 'PA', '16748', '41.9280', '-78.1342');
INSERT INTO `net_city` VALUES ('39097', '23', 'Клирлейк Парк', 'Clearlake Park', 'CA', '95424', '38.9666', '-122.6511');
INSERT INTO `net_city` VALUES ('39100', '23', 'Габс', 'Gabbs', 'NV', '89409', '38.8053', '-117.6868');
INSERT INTO `net_city` VALUES ('39106', '23', 'Федералсберг', 'Federalsburg', 'MD', '21632', '38.7287', '-75.7925');
INSERT INTO `net_city` VALUES ('39112', '127', 'Вельс', 'Wels', '04', '', '48.1667', '14.0333');
INSERT INTO `net_city` VALUES ('39118', '5', 'Ниигата', 'Niigata', '29', '', '37.9022', '139.0236');
INSERT INTO `net_city` VALUES ('39119', '151', 'Мухаррак', 'Muharraq', '03', '', '26.2572', '50.6119');
INSERT INTO `net_city` VALUES ('39120', '56', 'Монс', 'Mons', '03', '', '50.4500', '3.9333');
INSERT INTO `net_city` VALUES ('39126', '1', 'Наррабеен', 'Narrabeen', '02', '', '-33.7083', '151.3000');
INSERT INTO `net_city` VALUES ('39128', '23', 'Лиссабон', 'Lisbon', 'ME', '04250', '44.0271', '-70.1175');
INSERT INTO `net_city` VALUES ('39129', '1', 'Скорсби', 'Scoresby', '07', '', '-37.9000', '145.2333');
INSERT INTO `net_city` VALUES ('39132', '21', 'Сафрон-Уолден', 'Saffron Walden', 'E4', '', '52.0167', '0.2500');
INSERT INTO `net_city` VALUES ('39133', '23', 'Гасберг', 'Gasburg', 'VA', '23857', '36.5942', '-77.8659');
INSERT INTO `net_city` VALUES ('39136', '22', 'Брюруп', 'Bryrup', '01', '', '56.0167', '9.5167');
INSERT INTO `net_city` VALUES ('39137', '6', 'Нагпур', 'Nagpur', '16', '', '21.1500', '79.1000');
INSERT INTO `net_city` VALUES ('39139', '23', 'Ланесвилл', 'Lanesville', 'IN', '47136', '38.2318', '-85.9609');
INSERT INTO `net_city` VALUES ('39140', '21', 'Честер', 'Chester', 'C5', '', '53.2000', '-2.9167');
INSERT INTO `net_city` VALUES ('39141', '21', 'Бостон', 'Boston', 'H7', '', '52.9833', '-0.0167');
INSERT INTO `net_city` VALUES ('39167', '24', 'Корнуоллис', 'Cornwallis', 'NS', '', '44.6090', '-65.6467');
INSERT INTO `net_city` VALUES ('39231', '23', 'Маршолс Крик', 'Marshalls Creek', 'PA', '18335', '41.0431', '-75.1274');
INSERT INTO `net_city` VALUES ('39268', '23', 'Бернт Прейри', 'Burnt Prairie', 'IL', '62820', '38.2457', '-88.2198');
INSERT INTO `net_city` VALUES ('39270', '23', 'Аргусвилл', 'Argusville', 'ND', '58005', '47.0637', '-96.9729');
INSERT INTO `net_city` VALUES ('39320', '23', 'Ханалей', 'Hanalei', 'HI', '96714', '22.2017', '-159.5031');
INSERT INTO `net_city` VALUES ('39353', '23', 'Онтарио', 'Ontario', 'CA', '91798', '34.8400', '-115.9671');
INSERT INTO `net_city` VALUES ('39358', '13', 'Лукка', 'Lucca', '16', '', '43.8333', '10.4833');
INSERT INTO `net_city` VALUES ('39360', '33', 'Эймёйден', 'Ijmuiden', '07', '', '52.4547', '4.6032');
INSERT INTO `net_city` VALUES ('39361', '23', 'Мак-Мчен', 'Mcmechen', 'WV', '26040', '39.9857', '-80.7312');
INSERT INTO `net_city` VALUES ('39364', '23', 'Пеннсборо', 'Pennsboro', 'WV', '26415', '39.2953', '-80.9339');
INSERT INTO `net_city` VALUES ('39368', '23', 'Саутсайд', 'Southside', 'WV', '25187', '38.7326', '-82.0219');
INSERT INTO `net_city` VALUES ('39373', '23', 'Фэрлея', 'Fairlea', 'WV', '24902', '37.7807', '-80.4570');
INSERT INTO `net_city` VALUES ('39375', '23', 'Виктор', 'Victor', 'CA', '95253', '38.1380', '-121.2061');
INSERT INTO `net_city` VALUES ('39380', '23', 'Мобридж', 'Mobridge', 'SD', '57601', '45.2899', '-100.5344');
INSERT INTO `net_city` VALUES ('39381', '23', 'Фолктон', 'Faulkton', 'SD', '57438', '45.0711', '-99.1547');
INSERT INTO `net_city` VALUES ('39400', '23', 'Уотерборо', 'Waterboro', 'ME', '04087', '43.5657', '-70.7504');
INSERT INTO `net_city` VALUES ('39427', '23', 'Розалия', 'Rosalia', 'KS', '67132', '37.8330', '-96.5933');
INSERT INTO `net_city` VALUES ('39432', '1', 'Уилерс Хилл', 'Wheelers Hill', '07', '', '-37.9000', '145.1833');
INSERT INTO `net_city` VALUES ('39434', '21', 'Доркинг', 'Dorking', 'N7', '', '51.2167', '-0.3333');
INSERT INTO `net_city` VALUES ('39438', '23', 'Кэмбриа', 'Cambria', 'CA', '93428', '35.5954', '-121.0184');
INSERT INTO `net_city` VALUES ('39470', '23', 'Спарроу Буш', 'Sparrow Bush', 'NY', '12780', '41.4438', '-74.7284');
INSERT INTO `net_city` VALUES ('39471', '23', 'Бирсвилл', 'Bearsville', 'NY', '12409', '42.0699', '-74.1722');
INSERT INTO `net_city` VALUES ('39472', '23', 'Хонокаа', 'Honokaa', 'HI', '96727', '20.0394', '-155.4264');
INSERT INTO `net_city` VALUES ('39474', '23', 'Хана', 'Hana', 'HI', '96713', '20.7615', '-156.1103');
INSERT INTO `net_city` VALUES ('39477', '40', 'Сан-Хуан', 'San Juan', '18', '', '-31.5375', '-68.5364');
INSERT INTO `net_city` VALUES ('39478', '40', 'Парана', 'Parana', '08', '', '-31.7333', '-60.5333');
INSERT INTO `net_city` VALUES ('39479', '38', 'Талька', 'Talca', '11', '', '-35.4333', '-71.6667');
INSERT INTO `net_city` VALUES ('39481', '40', 'Корриентес', 'Corrientes', '06', '', '-27.4806', '-58.8341');
INSERT INTO `net_city` VALUES ('39482', '40', 'Формоса', 'Formosa', '09', '', '-26.1775', '-58.1781');
INSERT INTO `net_city` VALUES ('39483', '40', 'Сан-Луис', 'San Luis', '19', '', '-33.2950', '-66.3356');
INSERT INTO `net_city` VALUES ('39484', '40', 'Сальта', 'Salta', '17', '', '-24.7859', '-65.4117');
INSERT INTO `net_city` VALUES ('39485', '40', 'Вьедма', 'Viedma', '16', '', '-40.8135', '-62.9967');
INSERT INTO `net_city` VALUES ('39486', '163', 'Юмбо', 'Yumbo', '29', '', '3.5823', '-76.4915');
INSERT INTO `net_city` VALUES ('39487', '163', 'Итаги', 'Itagüí', '02', '', '6.1719', '-75.6114');
INSERT INTO `net_city` VALUES ('39488', '163', 'Буга', 'Buga', '29', '', '3.9009', '-76.2978');
INSERT INTO `net_city` VALUES ('39489', '163', 'Хирардот', 'Girardot', '33', '', '4.2987', '-74.8047');
INSERT INTO `net_city` VALUES ('39490', '160', 'Куэнка', 'Cuenca', '02', '', '-2.8833', '-78.9833');
INSERT INTO `net_city` VALUES ('39491', '175', 'Лара', 'Lara', '03', '', '7.2667', '-68.4000');
INSERT INTO `net_city` VALUES ('39492', '23', 'Нортфорд', 'Northford', 'CT', '06472', '41.3806', '-72.7700');
INSERT INTO `net_city` VALUES ('39495', '1', 'Гилфорд', 'Guilford', '06', '', '-41.4167', '145.7000');
INSERT INTO `net_city` VALUES ('39496', '6', 'Секундерабад', 'Secunderabad', '02', '', '17.4500', '78.5000');
INSERT INTO `net_city` VALUES ('39497', '1', 'Пенгин', 'Penguin', '06', '', '-41.1144', '146.0706');
INSERT INTO `net_city` VALUES ('39502', '23', 'Гарнервилл', 'Garnerville', 'NY', '10923', '41.2051', '-74.0013');
INSERT INTO `net_city` VALUES ('39504', '21', 'Уэстон-сьюпер-Мэр', 'Weston-super-Mare', 'J4', '', '51.3458', '-2.9678');
INSERT INTO `net_city` VALUES ('39506', '13', 'Кастельфранко-Эмилия', 'Castelfranco Emilia', '05', '', '44.6167', '11.0500');
INSERT INTO `net_city` VALUES ('39509', '25', 'Оливос', 'Olivos', '16', '', '18.8458', '-102.1500');
INSERT INTO `net_city` VALUES ('39511', '38', 'Альгарробо', 'Algarrobo', '07', '', '-30.1500', '-71.0000');
INSERT INTO `net_city` VALUES ('39518', '24', 'Энглхарт', 'Englehart', 'ON', 'p0j1h0', '47.8167', '-79.8667');
INSERT INTO `net_city` VALUES ('39537', '23', 'Хоноай', 'Honeoye', 'NY', '14471', '42.7485', '-77.4908');
INSERT INTO `net_city` VALUES ('39538', '23', 'Спенсерпорт', 'Spencerport', 'NY', '14559', '43.1667', '-77.8252');
INSERT INTO `net_city` VALUES ('39587', '23', 'Франклинвилл', 'Franklinville', 'NY', '14737', '42.3360', '-78.4367');
INSERT INTO `net_city` VALUES ('39601', '23', 'Уэст Стокбридж', 'West Stockbridge', 'MA', '01266', '42.2886', '-73.3749');
INSERT INTO `net_city` VALUES ('39602', '23', 'Гровленд', 'Groveland', 'NY', '14462', '42.6885', '-77.7696');
INSERT INTO `net_city` VALUES ('39659', '46', 'Сваби', 'Swabi', '03', '', '34.1199', '72.4699');
INSERT INTO `net_city` VALUES ('39660', '179', 'Маджуро', 'Majuro', '00', '', '7.3648', '170.8551');
INSERT INTO `net_city` VALUES ('39667', '23', 'Милл Холл', 'Mill Hall', 'PA', '17751', '41.1440', '-77.5231');
INSERT INTO `net_city` VALUES ('39671', '23', 'Монетт', 'Monette', 'AR', '72447', '35.8988', '-90.3593');
INSERT INTO `net_city` VALUES ('39672', '23', 'Уидман', 'Wideman', 'AR', '72585', '36.1850', '-92.0204');
INSERT INTO `net_city` VALUES ('39675', '23', 'Кила', 'Kila', 'MT', '59920', '48.0681', '-114.5034');
INSERT INTO `net_city` VALUES ('39679', '23', 'Рио', 'Rio', 'WI', '53960', '43.3950', '-89.2449');
INSERT INTO `net_city` VALUES ('39686', '23', 'Ирригон', 'Irrigon', 'OR', '97844', '45.8616', '-119.5490');
INSERT INTO `net_city` VALUES ('39696', '23', 'Сайо', 'Scio', 'OR', '97374', '44.6864', '-122.7666');
INSERT INTO `net_city` VALUES ('39709', '23', 'Гринфилд Парк', 'Greenfield Park', 'NY', '12435', '41.7296', '-74.5267');
INSERT INTO `net_city` VALUES ('39714', '23', 'Мид', 'Meade', 'KS', '67864', '37.2380', '-100.3076');
INSERT INTO `net_city` VALUES ('39716', '23', 'Столлингс', 'Stollings', 'WV', '25646', '37.8376', '-81.9646');
INSERT INTO `net_city` VALUES ('39722', '23', 'Элил', 'Eleele', 'HI', '96705', '21.9108', '-159.5828');
INSERT INTO `net_city` VALUES ('39724', '184', 'Апиа', 'Apia', '00', '', '-13.8333', '-171.7333');
INSERT INTO `net_city` VALUES ('39730', '55', 'Листоуэл', 'Listowel', '11', '', '52.4464', '-9.4850');
INSERT INTO `net_city` VALUES ('39737', '24', 'Гарсон', 'Garson', 'ON', 'p3l1e7', '46.5667', '-80.8667');
INSERT INTO `net_city` VALUES ('39745', '109', 'Бодрум', 'Bodrum', '48', '', '37.0383', '27.4292');
INSERT INTO `net_city` VALUES ('39774', '23', 'Томастон', 'Thomaston', 'CT', '06787', '41.6576', '-73.0965');
INSERT INTO `net_city` VALUES ('39780', '23', 'Блумингберг', 'Bloomingburg', 'NY', '12721', '41.5611', '-74.4440');
INSERT INTO `net_city` VALUES ('39782', '23', 'Конвой', 'Convoy', 'OH', '45832', '40.9096', '-84.7164');
INSERT INTO `net_city` VALUES ('39787', '24', 'Кокран', 'Cochrane (Alberta)', 'AB', 't4c2k8', '51.2000', '-114.4500');
INSERT INTO `net_city` VALUES ('39789', '29', 'Линдлар ', 'Lindlar', '07', '', '51.0167', '7.3833');
INSERT INTO `net_city` VALUES ('39822', '23', 'Аламо', 'Alamo', 'TX', '78516', '26.1451', '-98.1197');
INSERT INTO `net_city` VALUES ('39846', '23', 'Кула', 'Kula', 'HI', '96790', '20.7020', '-156.2581');
INSERT INTO `net_city` VALUES ('39856', '23', 'Санберст', 'Sunburst', 'MT', '59482', '48.8693', '-111.8984');
INSERT INTO `net_city` VALUES ('39857', '23', 'Боск', 'Bosque', 'NM', '87006', '34.5025', '-106.8323');
INSERT INTO `net_city` VALUES ('39879', '23', 'Хадли', 'Hadley', 'NY', '12835', '43.3127', '-73.9926');
INSERT INTO `net_city` VALUES ('39887', '23', 'Валентайн', 'Valentine', 'NE', '69201', '42.6082', '-100.7196');
INSERT INTO `net_city` VALUES ('39889', '23', 'Эрлхэм', 'Earlham', 'IA', '50072', '41.4730', '-94.1089');
INSERT INTO `net_city` VALUES ('39890', '23', 'Финлейсон', 'Finlayson', 'MN', '55735', '46.2306', '-93.0460');
INSERT INTO `net_city` VALUES ('39907', '21', 'Тьюксбери', 'Tewkesbury', 'E6', '', '52.0000', '-2.1500');
INSERT INTO `net_city` VALUES ('39908', '12', 'Сен-Мор', 'Saint-Maur', 'A3', '', '46.5805', '2.2990');
INSERT INTO `net_city` VALUES ('39909', '139', 'Холлола', 'Hollola', '13', '', '61.0500', '25.4333');
INSERT INTO `net_city` VALUES ('39912', '58', 'Калдас-Новас', 'Caldas Novas', '29', '', '-17.7500', '-48.6333');
INSERT INTO `net_city` VALUES ('39917', '120', 'Белград', 'Belgrade', '02', '', '44.8186', '20.4681');
INSERT INTO `net_city` VALUES ('39919', '109', 'Ыспарта', 'Isparta', '33', '', '37.7644', '30.5522');
INSERT INTO `net_city` VALUES ('39920', '7', 'Тайнань', 'Tainan', '04', '', '22.9933', '120.2036');
INSERT INTO `net_city` VALUES ('39921', '20', 'Воронеж', 'Voronezh', '86', '', '51.6720', '39.1843');
INSERT INTO `net_city` VALUES ('39923', '35', 'Сарагоса', 'Zaragoza', '52', '', '41.6453', '-0.8849');
INSERT INTO `net_city` VALUES ('39924', '29', 'Штайнфурт ', 'Steinfurt', '07', '', '52.1500', '7.3500');
INSERT INTO `net_city` VALUES ('39926', '22', 'Фредерикссунн', 'Frederikssund', '03', '', '55.8333', '12.0667');
INSERT INTO `net_city` VALUES ('39928', '19', 'Даммам', 'Dammam', '06', '', '26.4344', '50.1033');
INSERT INTO `net_city` VALUES ('39929', '1', 'Матхаура', 'Mathoura', '02', '', '-35.8140', '144.9003');
INSERT INTO `net_city` VALUES ('39930', '20', 'Пенза', 'Penza', '57', '', '53.2007', '45.0046');
INSERT INTO `net_city` VALUES ('39931', '35', 'Саламанка', 'Salamanca', '55', '', '40.9681', '-5.6620');
INSERT INTO `net_city` VALUES ('39933', '58', 'Шапеко', 'Chapecó', '26', '', '-27.0833', '-52.9833');
INSERT INTO `net_city` VALUES ('39934', '21', 'Винчестер', 'Winchester', 'F2', '', '51.0167', '-1.3167');
INSERT INTO `net_city` VALUES ('39935', '21', 'Брирли Хилл', 'Brierley Hill', 'M9', '', '52.4833', '-2.1167');
INSERT INTO `net_city` VALUES ('39936', '125', 'Ставангер', 'Stavanger', '14', '', '58.9667', '5.7500');
INSERT INTO `net_city` VALUES ('39937', '21', 'Керколди', 'Kirkcaldy', 'V1', '', '56.1167', '-3.1667');
INSERT INTO `net_city` VALUES ('39939', '29', 'Лаймен', 'Leimen', '01', '', '49.3511', '8.6894');
INSERT INTO `net_city` VALUES ('39944', '15', 'Йёнчёпинг', 'Jonkoping', '08', '', '57.7833', '14.1833');
INSERT INTO `net_city` VALUES ('39952', '35', 'Сан-Жуст-Десверн', 'Sant Just Desvern', '56', '', '41.3833', '2.0833');
INSERT INTO `net_city` VALUES ('39957', '23', 'Лена', 'Lena', 'IL', '61048', '42.3859', '-89.8283');
INSERT INTO `net_city` VALUES ('39960', '23', 'Мур Хейвен', 'Moore Haven', 'FL', '33471', '26.9335', '-81.1778');
INSERT INTO `net_city` VALUES ('39966', '28', 'Сейнт-Джон', 'Saint John', '00', '00830', '18.3282', '-64.7407');
INSERT INTO `net_city` VALUES ('39969', '23', 'Крипл Крик', 'Cripple Creek', 'CO', '80813', '38.7655', '-105.1133');
INSERT INTO `net_city` VALUES ('39970', '23', 'Бойкинс', 'Boykins', 'VA', '23827', '36.6157', '-77.2102');
INSERT INTO `net_city` VALUES ('39972', '23', 'Элмор', 'Elmore', 'OH', '43416', '41.4841', '-83.2702');
INSERT INTO `net_city` VALUES ('39974', '23', 'Гилбертсвилл', 'Gilbertsville', 'PA', '19525', '40.3133', '-75.5858');
INSERT INTO `net_city` VALUES ('39977', '27', 'Барранкитас', 'Barranquitas', '00', '00794', '18.2009', '-66.3073');
INSERT INTO `net_city` VALUES ('39980', '23', 'Тамуотер', 'Tumwater', 'WA', '98511', '47.0073', '-122.9093');
INSERT INTO `net_city` VALUES ('39984', '23', 'Нис', 'Nice', 'CA', '95464', '39.1208', '-122.8413');
INSERT INTO `net_city` VALUES ('39987', '23', 'Ридсвилл', 'Reedsville', 'PA', '17084', '40.6724', '-77.6223');
INSERT INTO `net_city` VALUES ('39991', '23', 'Айнсворт', 'Ainsworth', 'NE', '69210', '42.4365', '-99.9152');
INSERT INTO `net_city` VALUES ('39992', '23', 'Чейз Сити', 'Chase City', 'VA', '23924', '36.8217', '-78.4399');
INSERT INTO `net_city` VALUES ('39993', '22', 'Баллеруп', 'Ballerup', '05', '', '55.7333', '12.3667');
INSERT INTO `net_city` VALUES ('39994', '23', 'Окободжи', 'Okoboji', 'IA', '51355', '43.3900', '-95.1290');
INSERT INTO `net_city` VALUES ('39996', '23', 'Чарм', 'Charm', 'OH', '44617', '40.5067', '-81.7849');
INSERT INTO `net_city` VALUES ('39997', '23', 'Бурбон', 'Bourbon', 'IN', '46504', '41.2964', '-86.1133');
INSERT INTO `net_city` VALUES ('39998', '23', 'Дьюи', 'Dewey', 'AZ', '86327', '34.5678', '-112.1239');
INSERT INTO `net_city` VALUES ('40001', '23', 'Тексико', 'Texico', 'NM', '88135', '34.5618', '-103.0802');
INSERT INTO `net_city` VALUES ('40002', '23', 'Сессер', 'Sesser', 'IL', '62884', '38.0782', '-89.0482');
INSERT INTO `net_city` VALUES ('40009', '23', 'Коуэн', 'Cowen', 'WV', '26206', '38.4203', '-80.5418');
INSERT INTO `net_city` VALUES ('40011', '23', 'Лагуна Парк', 'Laguna Park', 'TX', '76644', '31.8974', '-97.6410');
INSERT INTO `net_city` VALUES ('40015', '23', 'Истовер', 'Eastover', 'SC', '29044', '33.9399', '-80.7415');
INSERT INTO `net_city` VALUES ('40016', '23', 'Осгуд', 'Osgood', 'IN', '47037', '39.1695', '-85.3105');
INSERT INTO `net_city` VALUES ('40022', '23', 'Бирдстаун', 'Beardstown', 'IL', '62618', '39.9889', '-90.4045');
INSERT INTO `net_city` VALUES ('40024', '23', 'Крабтри', 'Crabtree', 'PA', '15624', '40.3594', '-79.4722');
INSERT INTO `net_city` VALUES ('40026', '23', 'Порт Ладлоу', 'Port Ludlow', 'WA', '98365', '47.8981', '-122.6999');
INSERT INTO `net_city` VALUES ('40031', '23', 'Саттон', 'Sutton', 'VT', '05867', '44.6701', '-72.0487');
INSERT INTO `net_city` VALUES ('40032', '23', 'Конгресс', 'Congress', 'AZ', '85332', '34.2163', '-112.9755');
INSERT INTO `net_city` VALUES ('40034', '23', 'Ривер Ранч', 'River Ranch', 'FL', '33867', '27.8845', '-81.4796');
INSERT INTO `net_city` VALUES ('40035', '23', 'Уэллсвилл', 'Wellsville', 'OH', '43968', '40.6418', '-80.6891');
INSERT INTO `net_city` VALUES ('40037', '23', 'Айова Парк', 'Iowa Park', 'TX', '76367', '33.9856', '-98.6966');
INSERT INTO `net_city` VALUES ('40042', '23', 'Даггетт', 'Daggett', 'CA', '92327', '34.8658', '-116.8115');
INSERT INTO `net_city` VALUES ('40045', '23', 'Кевил', 'Kevil', 'KY', '42053', '37.0812', '-88.9091');
INSERT INTO `net_city` VALUES ('40049', '23', 'Саут Уитли', 'South Whitley', 'IN', '46787', '41.0712', '-85.6265');
INSERT INTO `net_city` VALUES ('40051', '23', 'Титон', 'Tieton', 'WA', '98947', '46.7104', '-120.7606');
INSERT INTO `net_city` VALUES ('40052', '23', 'Лемонт Фернас', 'Lemont Furnace', 'PA', '15456', '39.9273', '-79.6567');
INSERT INTO `net_city` VALUES ('40053', '23', 'Готенберг', 'Gothenburg', 'NE', '69138', '41.0603', '-100.1769');
INSERT INTO `net_city` VALUES ('40054', '23', 'Раннинг Спрингс', 'Running Springs', 'CA', '92382', '34.1839', '-117.0835');
INSERT INTO `net_city` VALUES ('40061', '23', 'Арроусмит', 'Arrowsmith', 'IL', '61722', '40.4205', '-88.6416');
INSERT INTO `net_city` VALUES ('40063', '23', 'Магалия', 'Magalia', 'CA', '95954', '39.8496', '-121.6061');
INSERT INTO `net_city` VALUES ('40066', '23', 'Фромберг', 'Fromberg', 'MT', '59029', '45.3991', '-108.7958');
INSERT INTO `net_city` VALUES ('40069', '23', 'Эллентон', 'Ellenton', 'FL', '34222', '27.5361', '-82.4978');
INSERT INTO `net_city` VALUES ('40071', '23', 'Раднор', 'Radnor', 'OH', '43066', '40.3887', '-83.1652');
INSERT INTO `net_city` VALUES ('40077', '23', 'Рок', 'The Rock', 'GA', '30285', '32.9881', '-84.2461');
INSERT INTO `net_city` VALUES ('40083', '23', 'Колерейн', 'Coleraine', 'MN', '55722', '47.2888', '-93.4277');
INSERT INTO `net_city` VALUES ('40088', '23', 'Таос Ски Валли', 'Taos Ski Valley', 'NM', '87525', '36.5960', '-105.4545');
INSERT INTO `net_city` VALUES ('40092', '23', 'Чамберс', 'Chambers', 'NE', '68725', '42.1427', '-98.7972');
INSERT INTO `net_city` VALUES ('40096', '23', 'Ливенворт', 'Leavenworth', 'WA', '98826', '47.8139', '-120.8604');
INSERT INTO `net_city` VALUES ('40097', '23', 'Гоблс', 'Gobles', 'MI', '49055', '42.3697', '-85.8555');
INSERT INTO `net_city` VALUES ('40101', '23', 'Уоткинс Глен', 'Watkins Glen', 'NY', '14891', '42.3698', '-76.9566');
INSERT INTO `net_city` VALUES ('40102', '23', 'Лидвилл', 'Leadville', 'CO', '80461', '39.2185', '-106.3609');
INSERT INTO `net_city` VALUES ('40106', '23', 'Бродбент', 'Broadbent', 'OR', '97414', '42.9687', '-124.1739');
INSERT INTO `net_city` VALUES ('40109', '23', 'Грандин', 'Grandin', 'ND', '58038', '47.2743', '-96.8935');
INSERT INTO `net_city` VALUES ('40111', '23', 'Пейдж', 'Paige', 'TX', '78659', '30.2052', '-97.1194');
INSERT INTO `net_city` VALUES ('40114', '23', 'Сошьер', 'Saucier', 'MS', '39574', '30.6055', '-89.1075');
INSERT INTO `net_city` VALUES ('40115', '13', 'Палермо', 'Palermo', '15', '', '38.1167', '13.3667');
INSERT INTO `net_city` VALUES ('40116', '23', 'Чизем', 'Chisholm', 'MN', '55719', '47.5491', '-92.8609');
INSERT INTO `net_city` VALUES ('40117', '123', 'Клуж-Напока', 'Cluj-Napoca', '13', '', '46.7667', '23.6000');
INSERT INTO `net_city` VALUES ('40119', '23', 'Ранчос де Таос', 'Ranchos De Taos', 'NM', '87557', '36.3743', '-105.6126');
INSERT INTO `net_city` VALUES ('40126', '23', 'Лесли', 'Leslie', 'MI', '49251', '42.4729', '-84.4011');
INSERT INTO `net_city` VALUES ('40128', '23', 'Кернвилл', 'Kernville', 'CA', '93238', '35.8397', '-118.4522');
INSERT INTO `net_city` VALUES ('40129', '23', 'Кроган', 'Croghan', 'NY', '13327', '43.9491', '-75.2967');
INSERT INTO `net_city` VALUES ('40130', '23', 'Адайр', 'Adair', 'IA', '50002', '41.5101', '-94.6555');
INSERT INTO `net_city` VALUES ('40135', '23', 'Табор Сити', 'Tabor City', 'NC', '28463', '34.0933', '-78.8027');
INSERT INTO `net_city` VALUES ('40138', '23', 'Порт Исабел', 'Port Isabel', 'TX', '78578', '26.0968', '-97.3168');
INSERT INTO `net_city` VALUES ('40140', '23', 'Рома', 'Roma', 'TX', '78584', '26.5779', '-98.9936');
INSERT INTO `net_city` VALUES ('40145', '23', 'Томас', 'Thomas', 'WV', '26292', '39.1636', '-79.5099');
INSERT INTO `net_city` VALUES ('40147', '23', 'Стокдейл', 'Stockdale', 'TX', '78160', '29.2355', '-97.9264');
INSERT INTO `net_city` VALUES ('40149', '23', 'Гошен', 'Goshen', 'OH', '45122', '39.2225', '-84.1182');
INSERT INTO `net_city` VALUES ('40152', '23', 'Непонсет', 'Neponset', 'IL', '61345', '41.2723', '-89.7901');
INSERT INTO `net_city` VALUES ('40153', '23', 'Бабсон Парк', 'Babson Park', 'FL', '33827', '27.8134', '-81.4770');
INSERT INTO `net_city` VALUES ('40156', '23', 'Кардуэлл', 'Cardwell', 'MT', '59721', '45.7869', '-111.9858');
INSERT INTO `net_city` VALUES ('40158', '23', 'Сентерберг', 'Centerburg', 'OH', '43011', '40.3160', '-82.6858');
INSERT INTO `net_city` VALUES ('40163', '23', 'Эрп', 'Earp', 'CA', '92242', '34.1575', '-114.3369');
INSERT INTO `net_city` VALUES ('40166', '23', 'Лабади', 'Labadie', 'MO', '63055', '38.5464', '-90.8446');
INSERT INTO `net_city` VALUES ('40170', '23', 'Ютан', 'Yutan', 'NE', '68073', '41.2567', '-96.3955');
INSERT INTO `net_city` VALUES ('40172', '23', 'Стонборо', 'Stoneboro', 'PA', '16153', '41.3288', '-80.0887');
INSERT INTO `net_city` VALUES ('40174', '23', 'Сентервилл', 'Centerville', 'IA', '52544', '40.7074', '-92.9213');
INSERT INTO `net_city` VALUES ('40177', '23', 'Бунс Милл', 'Boones Mill', 'VA', '24065', '37.1112', '-79.9586');
INSERT INTO `net_city` VALUES ('40179', '15', 'Сандвикен', 'Sandviken', '03', '', '60.6167', '16.7667');
INSERT INTO `net_city` VALUES ('40185', '23', 'Браштон', 'Brushton', 'NY', '12916', '44.8452', '-74.5173');
INSERT INTO `net_city` VALUES ('40193', '23', 'Тайер', 'Thayer', 'IL', '62689', '39.5381', '-89.7631');
INSERT INTO `net_city` VALUES ('40199', '173', 'Моравия', 'Moravia', '02', '', '9.8264', '-83.4406');
INSERT INTO `net_city` VALUES ('40204', '21', 'Файли', 'Filey', 'Q5', '', '54.2100', '-0.2892');
INSERT INTO `net_city` VALUES ('40205', '21', 'Сандхерст', 'Sandhurst', '03', '', '51.0167', '0.5667');
INSERT INTO `net_city` VALUES ('40216', '23', 'Роки', 'Rocky', 'OK', '73661', '35.1749', '-99.0170');
INSERT INTO `net_city` VALUES ('40224', '23', 'Дейзетта', 'Daisetta', 'TX', '77533', '30.1101', '-94.6601');
INSERT INTO `net_city` VALUES ('40225', '23', 'Ванзант', 'Vansant', 'VA', '24656', '37.1942', '-82.1322');
INSERT INTO `net_city` VALUES ('40227', '23', 'Форт Ричардсон', 'Fort Richardson', 'AK', '99505', '61.3152', '-149.6515');
INSERT INTO `net_city` VALUES ('40228', '23', 'Делкамбр', 'Delcambre', 'LA', '70528', '29.9037', '-91.9735');
INSERT INTO `net_city` VALUES ('40232', '56', 'Вилворде', 'Vilvoorde', '02', '', '50.9333', '4.4333');
INSERT INTO `net_city` VALUES ('40237', '23', 'Даконо', 'Dacono', 'CO', '80514', '40.0805', '-104.9332');
INSERT INTO `net_city` VALUES ('40239', '23', 'Саванна', 'Savanna', 'IL', '61074', '42.1028', '-90.1075');
INSERT INTO `net_city` VALUES ('40240', '59', 'Тессерете', 'Tesserete', '20', '', '46.0681', '8.9658');
INSERT INTO `net_city` VALUES ('40244', '23', 'Милрой', 'Milroy', 'IN', '46156', '39.4888', '-85.5036');
INSERT INTO `net_city` VALUES ('40262', '23', 'Хорник', 'Hornick', 'IA', '51026', '42.2557', '-96.0603');
INSERT INTO `net_city` VALUES ('40264', '23', 'Лакона', 'Lacona', 'NY', '13083', '43.6461', '-75.9805');
INSERT INTO `net_city` VALUES ('40267', '23', 'Седжвик', 'Sedgwick', 'KS', '67135', '37.9118', '-97.4457');
INSERT INTO `net_city` VALUES ('40293', '21', 'Уэйкфилд', 'Wakefield', 'O7', '', '53.7000', '-1.4833');
INSERT INTO `net_city` VALUES ('40295', '23', 'Хардивилл', 'Hardeeville', 'SC', '29927', '32.2870', '-81.0587');
INSERT INTO `net_city` VALUES ('40296', '23', 'Лонг Понд', 'Long Pond', 'PA', '18334', '41.0605', '-75.4616');
INSERT INTO `net_city` VALUES ('40297', '23', 'Раф энд Риди', 'Rough And Ready', 'CA', '95975', '39.2258', '-121.1546');
INSERT INTO `net_city` VALUES ('40299', '29', 'Изенбург', 'Isenburg', '01', '', '48.4167', '8.6833');
INSERT INTO `net_city` VALUES ('40305', '23', 'Коппер Сентер', 'Copper Center', 'AK', '99573', '61.6842', '-145.1484');
INSERT INTO `net_city` VALUES ('40311', '23', 'Теконша', 'Tekonsha', 'MI', '49092', '42.1136', '-84.9825');
INSERT INTO `net_city` VALUES ('40312', '23', 'Элк Маунд', 'Elk Mound', 'WI', '54739', '44.8507', '-91.7022');
INSERT INTO `net_city` VALUES ('40313', '23', 'Ред-Лейк-Фолс', 'Red Lake Falls', 'MN', '56750', '47.8908', '-96.2759');
INSERT INTO `net_city` VALUES ('40314', '23', 'Страсберг', 'Strasburg', 'OH', '44680', '40.5988', '-81.5394');
INSERT INTO `net_city` VALUES ('40315', '23', 'Шипшевана', 'Shipshewana', 'IN', '46565', '41.6777', '-85.5712');
INSERT INTO `net_city` VALUES ('40316', '23', 'Стьюартвилл', 'Stewartville', 'MN', '55976', '43.8565', '-92.5037');
INSERT INTO `net_city` VALUES ('40318', '23', 'Ньюберн', 'Newbern', 'TN', '38059', '36.1106', '-89.2738');
INSERT INTO `net_city` VALUES ('40321', '23', 'Чинук', 'Chinook', 'MT', '59523', '48.4761', '-109.2166');
INSERT INTO `net_city` VALUES ('40322', '23', 'Баллингер', 'Ballinger', 'TX', '76821', '31.7400', '-99.9604');
INSERT INTO `net_city` VALUES ('40326', '23', 'Рок Хилл', 'Rock Hill', 'NY', '12775', '41.6121', '-74.5802');
INSERT INTO `net_city` VALUES ('40327', '23', 'Памплико', 'Pamplico', 'SC', '29583', '33.9720', '-79.5753');
INSERT INTO `net_city` VALUES ('40328', '23', 'Фармер Сити', 'Farmer City', 'IL', '61842', '40.2412', '-88.6719');
INSERT INTO `net_city` VALUES ('40335', '23', 'Фрайона', 'Friona', 'TX', '79035', '34.7351', '-102.7842');
INSERT INTO `net_city` VALUES ('40336', '23', 'Рочестер Милс', 'Rochester Mills', 'PA', '15771', '40.8334', '-78.9968');
INSERT INTO `net_city` VALUES ('40337', '23', 'Симан', 'Seaman', 'OH', '45679', '38.9681', '-83.5601');
INSERT INTO `net_city` VALUES ('40343', '23', 'Холландейл', 'Hollandale', 'WI', '53544', '42.8749', '-89.9315');
INSERT INTO `net_city` VALUES ('40347', '23', 'Сидарвилл', 'Cedarville', 'CA', '96104', '41.4839', '-120.1413');
INSERT INTO `net_city` VALUES ('40348', '23', 'Талала', 'Talala', 'OK', '74080', '36.5158', '-95.7241');
INSERT INTO `net_city` VALUES ('40358', '23', 'Хаддлстон', 'Huddleston', 'VA', '24104', '37.1526', '-79.4836');
INSERT INTO `net_city` VALUES ('40360', '23', 'Пинон', 'Pinon', 'AZ', '86510', '36.2078', '-110.2385');
INSERT INTO `net_city` VALUES ('40361', '23', 'Кончо', 'Concho', 'OK', '73022', '35.5252', '-97.9923');
INSERT INTO `net_city` VALUES ('40364', '23', 'Кисвилл', 'Keysville', 'VA', '23947', '37.0403', '-78.4393');
INSERT INTO `net_city` VALUES ('40369', '23', 'Уэллсвилл', 'Wellsville', 'MO', '63384', '39.0984', '-91.5573');
INSERT INTO `net_city` VALUES ('40370', '23', 'Уинтроп Харбор', 'Winthrop Harbor', 'IL', '60096', '42.4784', '-87.8307');
INSERT INTO `net_city` VALUES ('40372', '23', 'Куксон', 'Cookson', 'OK', '74427', '35.6979', '-94.8925');
INSERT INTO `net_city` VALUES ('40374', '23', 'Семора', 'Semora', 'NC', '27343', '36.4950', '-79.0928');
INSERT INTO `net_city` VALUES ('40375', '23', 'Перривилл', 'Perryville', 'MD', '21903', '39.5725', '-76.0431');
INSERT INTO `net_city` VALUES ('40376', '23', 'Мак-Кинли Парк', 'Denali National Park', 'AK', '99755', '63.6445', '-148.8126');
INSERT INTO `net_city` VALUES ('40378', '23', 'Оланча', 'Olancha', 'CA', '93549', '36.2819', '-118.0065');
INSERT INTO `net_city` VALUES ('40383', '23', 'Хаджерман', 'Hagerman', 'ID', '83332', '42.8141', '-114.9181');
INSERT INTO `net_city` VALUES ('40384', '23', 'Сентервилл', 'Centerville', 'TX', '75833', '31.2626', '-95.8465');
INSERT INTO `net_city` VALUES ('40388', '23', 'Амбой', 'Amboy', 'IL', '61310', '41.7075', '-89.3524');
INSERT INTO `net_city` VALUES ('40389', '23', 'Канзас', 'Kansas', 'IL', '61933', '39.5461', '-87.9392');
INSERT INTO `net_city` VALUES ('40390', '23', 'Барнстон', 'Barneston', 'NE', '68309', '40.0510', '-96.5720');
INSERT INTO `net_city` VALUES ('40392', '23', 'Оттербейн', 'Otterbein', 'IN', '47970', '40.4741', '-87.1404');
INSERT INTO `net_city` VALUES ('40393', '23', 'Гленфорд', 'Glenford', 'OH', '43739', '39.9213', '-82.2935');
INSERT INTO `net_city` VALUES ('40396', '23', 'Хитсвилл', 'Heathsville', 'VA', '22473', '37.8799', '-76.3927');
INSERT INTO `net_city` VALUES ('40398', '23', 'Чинкотиг Айленд', 'Chincoteague Island', 'VA', '23336', '37.9430', '-75.3215');
INSERT INTO `net_city` VALUES ('40399', '23', 'Коллинс', 'Collins', 'MS', '39428', '31.6541', '-89.5780');
INSERT INTO `net_city` VALUES ('40400', '23', 'Милфей', 'Milfay', 'OK', '74046', '35.7551', '-96.5658');
INSERT INTO `net_city` VALUES ('40402', '23', 'Кортленд', 'Cortland', 'IL', '60112', '41.9255', '-88.6958');
INSERT INTO `net_city` VALUES ('40403', '23', 'Хамптонвилл', 'Hamptonville', 'NC', '27020', '36.1207', '-80.8508');
INSERT INTO `net_city` VALUES ('40409', '23', 'Гленрок', 'Glenrock', 'WY', '82637', '42.6517', '-105.8739');
INSERT INTO `net_city` VALUES ('40420', '23', 'Терлингуа', 'Terlingua', 'TX', '79852', '29.4518', '-103.5845');
INSERT INTO `net_city` VALUES ('40422', '23', 'Неола', 'Neola', 'UT', '84053', '40.4102', '-109.9943');
INSERT INTO `net_city` VALUES ('40423', '23', 'Банки', 'Bunkie', 'LA', '71322', '30.8764', '-92.1308');
INSERT INTO `net_city` VALUES ('40424', '23', 'Санбери', 'Sunbury', 'NC', '27979', '36.4544', '-76.5884');
INSERT INTO `net_city` VALUES ('40426', '23', 'Линдонвилл', 'Lyndonville', 'NY', '14098', '43.3236', '-78.3731');
INSERT INTO `net_city` VALUES ('40430', '226', 'Гавана', 'Havana', '02', '', '23.1319', '-82.3642');
INSERT INTO `net_city` VALUES ('40435', '23', 'Сейнер', 'Sayner', 'WI', '54560', '46.0031', '-89.5377');
INSERT INTO `net_city` VALUES ('40438', '23', 'Блэк Лик', 'Black Lick', 'PA', '15716', '40.4736', '-79.1929');
INSERT INTO `net_city` VALUES ('40442', '23', 'Сентер Харбор', 'Center Harbor', 'NH', '03226', '43.7284', '-71.4778');
INSERT INTO `net_city` VALUES ('40443', '23', 'Лейк-Сити', 'Lake City', 'MI', '49651', '44.3819', '-85.1367');
INSERT INTO `net_city` VALUES ('40445', '23', 'Ист Спарта', 'East Sparta', 'OH', '44626', '40.6834', '-81.3845');
INSERT INTO `net_city` VALUES ('40449', '29', 'Бергнойштадт', 'Bergneustadt', '07', '', '51.0333', '7.6500');
INSERT INTO `net_city` VALUES ('40451', '23', 'Тоомсуба', 'Toomsuba', 'MS', '39364', '32.4130', '-88.5196');
INSERT INTO `net_city` VALUES ('40454', '23', 'Лейкмонт', 'Lakemont', 'NY', '14857', '42.5162', '-76.9280');
INSERT INTO `net_city` VALUES ('40455', '23', 'Макино-Сити', 'Mackinac Island', 'MI', '49757', '45.8658', '-84.6271');
INSERT INTO `net_city` VALUES ('40457', '23', 'Колледж Корнер', 'College Corner', 'OH', '45003', '39.6106', '-84.7894');
INSERT INTO `net_city` VALUES ('40459', '23', 'Эвингтон', 'Evington', 'VA', '24550', '37.2329', '-79.2788');
INSERT INTO `net_city` VALUES ('40460', '23', 'Баю ла Батр', 'Bayou La Batre', 'AL', '36509', '30.4061', '-88.2518');
INSERT INTO `net_city` VALUES ('40464', '58', 'Пирасикаба', 'Piracicaba', '27', '', '-22.7167', '-47.6333');
INSERT INTO `net_city` VALUES ('40466', '23', 'Клакстон', 'Claxton', 'GA', '30417', '32.1615', '-81.8736');
INSERT INTO `net_city` VALUES ('40468', '23', 'Бремонд', 'Bremond', 'TX', '76629', '31.1525', '-96.6553');
INSERT INTO `net_city` VALUES ('40470', '23', 'Ортинг', 'Orting', 'WA', '98360', '47.0375', '-122.1081');
INSERT INTO `net_city` VALUES ('40471', '23', 'Норт Пол', 'North Pole', 'AK', '99705', '64.7783', '-147.3371');
INSERT INTO `net_city` VALUES ('40476', '23', 'Бонфилд', 'Bonfield', 'IL', '60913', '41.1390', '-88.0606');
INSERT INTO `net_city` VALUES ('40481', '23', 'Ньюсомс', 'Newsoms', 'VA', '23874', '36.6114', '-77.0939');
INSERT INTO `net_city` VALUES ('40483', '23', 'Багс', 'Baggs', 'WY', '82321', '41.0934', '-107.7098');
INSERT INTO `net_city` VALUES ('40484', '23', 'Хамел', 'Hamel', 'IL', '62046', '38.8889', '-89.8454');
INSERT INTO `net_city` VALUES ('40486', '23', 'Уайтфас', 'Whiteface', 'TX', '79379', '33.5980', '-102.6280');
INSERT INTO `net_city` VALUES ('40488', '23', 'Маунт Оберн', 'Mount Auburn', 'IA', '52313', '42.2539', '-92.0933');
INSERT INTO `net_city` VALUES ('40491', '23', 'Варшава', 'Warsaw', 'VA', '22572', '38.0002', '-76.7717');
INSERT INTO `net_city` VALUES ('40494', '23', 'Гвиннер', 'Gwinner', 'ND', '58040', '46.2143', '-97.6947');
INSERT INTO `net_city` VALUES ('40495', '23', 'Чула', 'Chula', 'GA', '31733', '31.6078', '-83.4564');
INSERT INTO `net_city` VALUES ('40501', '23', 'Эльза', 'Elsa', 'TX', '78543', '26.2934', '-97.9931');
INSERT INTO `net_city` VALUES ('40503', '23', 'Пойнт-оф-Рокс', 'Point Of Rocks', 'WY', '82942', '41.6778', '-108.7886');
INSERT INTO `net_city` VALUES ('40506', '23', 'Оро Гранде', 'Oro Grande', 'CA', '92368', '34.6535', '-117.2925');
INSERT INTO `net_city` VALUES ('40507', '23', 'Арройо Секо', 'Arroyo Seco', 'NM', '87514', '36.5287', '-105.5455');
INSERT INTO `net_city` VALUES ('40508', '23', 'Лахаска', 'Lahaska', 'PA', '18931', '40.3465', '-75.0316');
INSERT INTO `net_city` VALUES ('40509', '23', 'Порт О&#39;коннор', 'Port O\'Connor', 'TX', '77982', '28.4514', '-96.4335');
INSERT INTO `net_city` VALUES ('40516', '23', 'Тафтон', 'Tafton', 'PA', '18464', '41.4148', '-75.1886');
INSERT INTO `net_city` VALUES ('40517', '23', 'Тейлор Ридж', 'Taylor Ridge', 'IL', '61284', '41.3924', '-90.7501');
INSERT INTO `net_city` VALUES ('40518', '23', 'Бернвилл', 'Bernville', 'PA', '19506', '40.4675', '-76.1274');
INSERT INTO `net_city` VALUES ('40519', '23', 'Монктон', 'Monkton', 'MD', '21111', '39.5744', '-76.5928');
INSERT INTO `net_city` VALUES ('40520', '23', 'Черрифилд', 'Cherryfield', 'ME', '04622', '44.7111', '-67.9723');
INSERT INTO `net_city` VALUES ('40534', '23', 'Берчлиф', 'Birchleaf', 'VA', '24220', '37.1676', '-82.2593');
INSERT INTO `net_city` VALUES ('40535', '23', 'Кидисвилл', 'Keedysville', 'MD', '21756', '39.4505', '-77.7008');
INSERT INTO `net_city` VALUES ('40543', '23', 'Бакспорт', 'Bucksport', 'ME', '04416', '44.6444', '-68.7402');
INSERT INTO `net_city` VALUES ('40544', '23', 'Лами', 'Lamy', 'NM', '87540', '35.4520', '-105.9446');
INSERT INTO `net_city` VALUES ('40545', '23', 'Алленвуд', 'Allenwood', 'PA', '17810', '41.1177', '-77.0423');
INSERT INTO `net_city` VALUES ('40549', '23', 'Джонсон', 'Johnson', 'AR', '72741', '36.1329', '-94.1655');
INSERT INTO `net_city` VALUES ('40554', '23', 'Нидлс', 'Needles', 'CA', '92363', '34.7858', '-114.5993');
INSERT INTO `net_city` VALUES ('40556', '23', 'Баклин', 'Bucklin', 'MO', '64631', '39.8171', '-92.8788');
INSERT INTO `net_city` VALUES ('40563', '23', 'Прейривилл', 'Prairieville', 'LA', '70769', '30.2974', '-90.8657');
INSERT INTO `net_city` VALUES ('40564', '23', 'Гаставус', 'Gustavus', 'AK', '99826', '58.4222', '-135.7812');
INSERT INTO `net_city` VALUES ('40565', '23', 'Бивер-Крик', 'Beaver Creek', 'CO', '81645', '39.5864', '-106.4309');
INSERT INTO `net_city` VALUES ('40566', '23', 'Крестон', 'Crestone', 'CO', '81131', '37.9964', '-105.6997');
INSERT INTO `net_city` VALUES ('40581', '24', 'Сент-Адель', 'Sainte Adele', 'QC', 'j8b3g6', '45.9500', '-74.1500');
INSERT INTO `net_city` VALUES ('40589', '21', 'Валли', 'Valley', 'X1', '', '53.2833', '-4.5667');
INSERT INTO `net_city` VALUES ('40610', '23', 'Элдред', 'Eldred', 'PA', '16731', '41.9391', '-78.3778');
INSERT INTO `net_city` VALUES ('40620', '23', 'Брасевилл', 'Braceville', 'IL', '60407', '41.2160', '-88.2677');
INSERT INTO `net_city` VALUES ('40622', '23', 'Элмвуд', 'Elmwood', 'IL', '61529', '40.7815', '-89.9226');
INSERT INTO `net_city` VALUES ('40638', '23', 'Меномини', 'Menominee', 'MI', '49858', '45.2342', '-87.5643');
INSERT INTO `net_city` VALUES ('40641', '23', 'Сабин Пасс', 'Sabine Pass', 'TX', '77655', '29.6675', '-94.0718');
INSERT INTO `net_city` VALUES ('40646', '23', 'Хауула', 'Hauula', 'HI', '96717', '21.5666', '-157.8909');
INSERT INTO `net_city` VALUES ('40647', '152', 'Ташкент', 'Tashkent', '13', '', '41.3167', '69.2500');
INSERT INTO `net_city` VALUES ('40649', '123', 'Тимишоара', 'Timisoara', '36', '', '45.7494', '21.2272');
INSERT INTO `net_city` VALUES ('40650', '23', 'Саунд Бич', 'Sound Beach', 'NY', '11789', '40.9559', '-72.9713');
INSERT INTO `net_city` VALUES ('40651', '112', 'Симферополь', 'Simferopol', '11', '', '44.9572', '34.1108');
INSERT INTO `net_city` VALUES ('40652', '1', 'Ярра Джанкшен', 'Yarra Junction', '07', '', '-37.7819', '145.6143');
INSERT INTO `net_city` VALUES ('40655', '1', 'Гров', 'Grove', '06', '', '-42.9833', '147.1000');
INSERT INTO `net_city` VALUES ('40666', '23', 'Россер', 'Rosser', 'TX', '75157', '32.4626', '-96.4533');
INSERT INTO `net_city` VALUES ('40670', '23', 'Уэствилл', 'Westville', 'OK', '74965', '36.0022', '-94.6457');
INSERT INTO `net_city` VALUES ('40671', '23', 'Арапахо', 'Arapaho', 'OK', '73620', '35.6314', '-99.0312');
INSERT INTO `net_city` VALUES ('40675', '35', 'Ловиос', 'Lobios', '58', '', '41.8831', '-8.1472');
INSERT INTO `net_city` VALUES ('40676', '23', 'Берртон', 'Burrton', 'KS', '67020', '37.9989', '-97.6716');
INSERT INTO `net_city` VALUES ('40678', '23', 'Фарли', 'Farley', 'MO', '64028', '39.2822', '-94.8314');
INSERT INTO `net_city` VALUES ('40679', '23', 'Тимпсон', 'Timpson', 'TX', '75975', '31.8895', '-94.4362');
INSERT INTO `net_city` VALUES ('40680', '23', 'Сирил', 'Cyril', 'OK', '73029', '34.9127', '-98.2073');
INSERT INTO `net_city` VALUES ('40681', '23', 'Сейнт Женевьев', 'Sainte Genevieve', 'MO', '63670', '37.8813', '-90.1442');
INSERT INTO `net_city` VALUES ('40684', '23', 'Джудит Гэп', 'Judith Gap', 'MT', '59453', '46.6352', '-109.6884');
INSERT INTO `net_city` VALUES ('40691', '23', 'Рейган', 'Reagan', 'TX', '76680', '31.1871', '-96.8101');
INSERT INTO `net_city` VALUES ('40693', '23', 'Литл Хокинг', 'Little Hocking', 'OH', '45742', '39.2799', '-81.7303');
INSERT INTO `net_city` VALUES ('40694', '1', 'Данденонг', 'Dandenong', '07', '', '-37.9833', '145.2000');
INSERT INTO `net_city` VALUES ('40696', '23', 'Гордон', 'Gordon', 'NE', '69343', '42.6355', '-102.0972');
INSERT INTO `net_city` VALUES ('40697', '1', 'Мансфилд', 'Mansfield', '07', '', '-37.0520', '146.0885');
INSERT INTO `net_city` VALUES ('40700', '48', 'Торнтон', 'Thornton', '00', '', '-37.9167', '176.8667');
INSERT INTO `net_city` VALUES ('40711', '23', 'Мейсонтаун', 'Masontown', 'WV', '26542', '39.5818', '-79.7907');
INSERT INTO `net_city` VALUES ('40717', '23', 'Пармели', 'Parmelee', 'SD', '57566', '43.3055', '-101.0353');
INSERT INTO `net_city` VALUES ('40724', '23', 'Лейквилл', 'Lakeville', 'MI', '48366', '42.8033', '-83.1841');
INSERT INTO `net_city` VALUES ('40729', '23', 'Стивенсон', 'Stephenson', 'WV', '25928', '37.5598', '-81.3304');
INSERT INTO `net_city` VALUES ('40748', '23', 'Элизабетвилл', 'Elizabethville', 'PA', '17023', '40.5831', '-76.8075');
INSERT INTO `net_city` VALUES ('40749', '23', 'Суортсвуд', 'Swartswood', 'NJ', '07877', '41.0870', '-74.8271');
INSERT INTO `net_city` VALUES ('40750', '23', 'Глен Аллин', 'Glen Ullin', 'ND', '58631', '46.8974', '-101.8245');
INSERT INTO `net_city` VALUES ('40751', '23', 'Эллендейл', 'Ellendale', 'DE', '19941', '38.7917', '-75.4137');
INSERT INTO `net_city` VALUES ('40757', '23', 'Кромпонд', 'Crompond', 'NY', '10517', '41.2951', '-73.8654');
INSERT INTO `net_city` VALUES ('40774', '23', 'Хайнс', 'Haines', 'AK', '99827', '59.1609', '-135.8681');
INSERT INTO `net_city` VALUES ('40775', '23', 'Фэрфакс', 'Fairfax', 'SC', '29827', '32.9626', '-81.2108');
INSERT INTO `net_city` VALUES ('40776', '23', 'Мона', 'Mona', 'UT', '84645', '39.8599', '-111.8491');
INSERT INTO `net_city` VALUES ('40782', '23', 'Поконо Саммит', 'Pocono Summit', 'PA', '18346', '41.1363', '-75.4230');
INSERT INTO `net_city` VALUES ('40783', '23', 'Буэллтон', 'Buellton', 'CA', '93427', '34.6119', '-120.2269');
INSERT INTO `net_city` VALUES ('40785', '23', 'Порт Депозит', 'Port Deposit', 'MD', '21904', '39.6274', '-76.0726');
INSERT INTO `net_city` VALUES ('40792', '23', 'Буш', 'Bush', 'LA', '70431', '30.6015', '-89.9627');
INSERT INTO `net_city` VALUES ('40925', '24', 'Плесивиль', 'Plessisville', 'QC', 'g6l2l9', '46.2263', '-71.7766');
INSERT INTO `net_city` VALUES ('40940', '23', 'Понтоток', 'Pontotoc', 'MS', '38863', '34.2275', '-89.0352');
INSERT INTO `net_city` VALUES ('40998', '23', 'Хилтоп', 'Hilltop', 'WV', '25855', '37.9429', '-81.1509');
INSERT INTO `net_city` VALUES ('40999', '23', 'Белингтон', 'Belington', 'WV', '26250', '39.0492', '-79.9561');
INSERT INTO `net_city` VALUES ('41001', '23', 'Гаривилл', 'Garyville', 'LA', '70051', '30.0687', '-90.6090');
INSERT INTO `net_city` VALUES ('41003', '23', 'Бирам', 'Byram', 'MS', '39272', '32.1861', '-90.2540');
INSERT INTO `net_city` VALUES ('41005', '23', 'Милстадт', 'Millstadt', 'IL', '62260', '38.4650', '-90.0978');
INSERT INTO `net_city` VALUES ('41008', '23', 'Лейк Озарк', 'Lake Ozark', 'MO', '65049', '38.1795', '-92.6042');
INSERT INTO `net_city` VALUES ('41010', '55', 'Дромоленд', 'Dromoland', '03', '', '52.8156', '-8.9667');
INSERT INTO `net_city` VALUES ('41011', '18', 'Хиос', 'Chíos', '50', '', '38.3678', '26.1358');
INSERT INTO `net_city` VALUES ('41012', '23', 'Форт Ховард', 'Fort Howard', 'MD', '21052', '39.2073', '-76.4450');
INSERT INTO `net_city` VALUES ('41014', '23', 'Сергойнсвилл', 'Surgoinsville', 'TN', '37873', '36.5232', '-82.8539');
INSERT INTO `net_city` VALUES ('41016', '23', 'Мабен', 'Maben', 'MS', '39750', '33.5925', '-89.0538');
INSERT INTO `net_city` VALUES ('41025', '23', 'Скоби', 'Scobey', 'MT', '59263', '48.7814', '-105.6003');
INSERT INTO `net_city` VALUES ('41026', '23', 'Уисдом', 'Wisdom', 'MT', '59761', '45.5425', '-113.5418');
INSERT INTO `net_city` VALUES ('41027', '23', 'Сигрейвс', 'Seagraves', 'TX', '79359', '32.9399', '-102.4961');
INSERT INTO `net_city` VALUES ('41034', '23', 'Орфорд', 'Orford', 'NH', '03777', '43.8985', '-72.0680');
INSERT INTO `net_city` VALUES ('41036', '23', 'Херси', 'Hersey', 'MI', '49639', '43.8597', '-85.4098');
INSERT INTO `net_city` VALUES ('41037', '23', 'Сидар', 'Cedar', 'MI', '49621', '44.8646', '-85.7677');
INSERT INTO `net_city` VALUES ('41045', '23', 'Дрифтвуд', 'Driftwood', 'TX', '78619', '30.1058', '-98.0326');
INSERT INTO `net_city` VALUES ('41049', '23', 'Талмансвилл', 'Tallmansville', 'WV', '26237', '38.8413', '-80.1579');
INSERT INTO `net_city` VALUES ('41057', '23', 'Гранит', 'Granite', 'CO', '81228', '39.0935', '-106.3007');
INSERT INTO `net_city` VALUES ('41058', '23', 'Лас Анимас', 'Las Animas', 'CO', '81054', '37.7901', '-103.1396');
INSERT INTO `net_city` VALUES ('41060', '23', 'Олден', 'Alden', 'NY', '14004', '42.9038', '-78.5008');
INSERT INTO `net_city` VALUES ('41061', '23', 'Парктон', 'Parkton', 'MD', '21120', '39.6476', '-76.6793');
INSERT INTO `net_city` VALUES ('41066', '23', 'Пирмонт', 'Piermont', 'NH', '03779', '43.9724', '-72.0373');
INSERT INTO `net_city` VALUES ('41068', '23', 'Пенобскот', 'Penobscot', 'ME', '04476', '44.4523', '-68.6865');
INSERT INTO `net_city` VALUES ('41081', '23', 'Бардуэлл', 'Bardwell', 'KY', '42023', '36.8669', '-88.9882');
INSERT INTO `net_city` VALUES ('41084', '23', 'Уэллтон', 'Wellton', 'AZ', '85356', '32.7001', '-114.1754');
INSERT INTO `net_city` VALUES ('41085', '23', 'Ковело', 'Covelo', 'CA', '95428', '39.8227', '-123.1606');
INSERT INTO `net_city` VALUES ('41086', '23', 'Гиампом', 'Hyampom', 'CA', '96046', '40.6036', '-123.4089');
INSERT INTO `net_city` VALUES ('41087', '23', 'Уитингтон', 'Whittington', 'IL', '62897', '38.0838', '-88.9092');
INSERT INTO `net_city` VALUES ('41092', '23', 'Сандисфилд', 'Sandisfield', 'MA', '01255', '42.1119', '-73.1200');
INSERT INTO `net_city` VALUES ('41094', '23', 'Калимеса', 'Calimesa', 'CA', '92320', '33.9795', '-117.0527');
INSERT INTO `net_city` VALUES ('41103', '23', 'Сигнал Маунтин', 'Signal Mountain', 'TN', '37377', '35.2044', '-85.3255');
INSERT INTO `net_city` VALUES ('41106', '23', 'Килн', 'Kiln', 'MS', '39556', '30.4481', '-89.4437');
INSERT INTO `net_city` VALUES ('41111', '23', 'Ванклив', 'Vancleave', 'MS', '39565', '30.5736', '-88.7441');
INSERT INTO `net_city` VALUES ('41114', '23', 'Уиггинс', 'Wiggins', 'MS', '39577', '30.9364', '-89.0663');
INSERT INTO `net_city` VALUES ('41116', '23', 'Силвестер', 'Sylvester', 'GA', '31791', '31.5409', '-83.8749');
INSERT INTO `net_city` VALUES ('41118', '23', 'Зебулон', 'Zebulon', 'GA', '30295', '33.0939', '-84.3197');
INSERT INTO `net_city` VALUES ('41119', '23', 'Колкитт', 'Colquitt', 'GA', '39837', '31.1532', '-84.6795');
INSERT INTO `net_city` VALUES ('41128', '23', 'Порт Остин', 'Port Austin', 'MI', '48467', '44.0042', '-82.9822');
INSERT INTO `net_city` VALUES ('41129', '23', 'Эмпайр', 'Empire', 'MI', '49630', '44.8219', '-85.9870');
INSERT INTO `net_city` VALUES ('41131', '23', 'Холли Понд', 'Holly Pond', 'AL', '35083', '34.1877', '-86.6027');
INSERT INTO `net_city` VALUES ('41134', '23', 'Кропуэлл', 'Cropwell', 'AL', '35054', '33.5129', '-86.3398');
INSERT INTO `net_city` VALUES ('41135', '23', 'Беллами', 'Bellamy', 'AL', '36901', '32.4490', '-88.1336');
INSERT INTO `net_city` VALUES ('41143', '23', 'Петал', 'Petal', 'MS', '39465', '31.3249', '-89.1770');
INSERT INTO `net_city` VALUES ('41144', '24', 'Апсли', 'Apsley', 'ON', 'k0l1a0', '44.7500', '-78.0833');
INSERT INTO `net_city` VALUES ('41146', '23', 'Бакленд', 'Buckland', 'OH', '45819', '40.6247', '-84.2599');
INSERT INTO `net_city` VALUES ('41147', '24', 'Кин', 'Keene', 'ON', 'k0l2g0', '44.2395', '-78.1612');
INSERT INTO `net_city` VALUES ('41148', '23', 'Эдвардс', 'Edwards', 'MS', '39066', '32.3044', '-90.6023');
INSERT INTO `net_city` VALUES ('41150', '23', 'Мурвилл', 'Mooreville', 'MS', '38857', '34.2804', '-88.5895');
INSERT INTO `net_city` VALUES ('41152', '23', 'Эллисвилл', 'Ellisville', 'MS', '39437', '31.5601', '-89.2322');
INSERT INTO `net_city` VALUES ('41160', '23', 'Туника', 'Tunica', 'MS', '38676', '34.6738', '-90.3885');
INSERT INTO `net_city` VALUES ('41167', '23', 'Энори', 'Enoree', 'SC', '29335', '34.6636', '-81.8991');
INSERT INTO `net_city` VALUES ('41173', '23', 'Солли', 'Salley', 'SC', '29137', '33.6094', '-81.2845');
INSERT INTO `net_city` VALUES ('41174', '23', 'Роусвилл', 'Rowesville', 'SC', '29133', '33.3686', '-80.7163');
INSERT INTO `net_city` VALUES ('41188', '23', 'Милнер', 'Milner', 'GA', '30257', '33.1356', '-84.1739');
INSERT INTO `net_city` VALUES ('41192', '23', 'Денвер', 'Denver', 'PA', '17517', '40.2402', '-76.1305');
INSERT INTO `net_city` VALUES ('41193', '202', 'Риека', 'Rijeka', '12', '', '45.3431', '14.4092');
INSERT INTO `net_city` VALUES ('41199', '23', 'Мейнардвилл', 'Maynardville', 'TN', '37807', '36.2590', '-83.8065');
INSERT INTO `net_city` VALUES ('41205', '55', 'Лаут', 'Louth', '19', '', '53.9486', '-6.5414');
INSERT INTO `net_city` VALUES ('41206', '23', 'Грир', 'Greer', 'SC', '29652', '34.9387', '-82.2271');
INSERT INTO `net_city` VALUES ('41209', '23', 'Мейлин', 'Maylene', 'AL', '35114', '33.2257', '-86.8652');
INSERT INTO `net_city` VALUES ('41225', '23', 'Чанчула', 'Chunchula', 'AL', '36521', '30.9582', '-88.1780');
INSERT INTO `net_city` VALUES ('41230', '23', 'Стейнхатчи', 'Steinhatchee', 'FL', '32359', '29.7211', '-83.4660');
INSERT INTO `net_city` VALUES ('41267', '23', 'Пердидо', 'Perdido', 'AL', '36562', '31.0326', '-87.6662');
INSERT INTO `net_city` VALUES ('41269', '23', 'Шайенн Уэлс', 'Cheyenne Wells', 'CO', '80810', '38.8295', '-102.4519');
INSERT INTO `net_city` VALUES ('41274', '23', 'Холли', 'Holly', 'CO', '81047', '38.1498', '-102.2672');
INSERT INTO `net_city` VALUES ('41276', '23', 'Марлинтон', 'Marlinton', 'WV', '24954', '38.1700', '-80.0146');
INSERT INTO `net_city` VALUES ('41288', '23', 'Болд-Ноб', 'Bald Knob', 'AR', '72010', '35.3124', '-91.5091');
INSERT INTO `net_city` VALUES ('41291', '23', 'Лост Крик', 'Lost Creek', 'WV', '26385', '39.1584', '-80.3794');
INSERT INTO `net_city` VALUES ('41300', '23', 'Липер', 'Leeper', 'PA', '16233', '41.3613', '-79.2800');
INSERT INTO `net_city` VALUES ('41304', '23', 'Роки Форд', 'Rocky Ford', 'CO', '81067', '37.9689', '-103.7494');
INSERT INTO `net_city` VALUES ('41307', '23', 'Шефферстаун', 'Schaefferstown', 'PA', '17088', '40.2984', '-76.2944');
INSERT INTO `net_city` VALUES ('41308', '23', 'Ист Чатем', 'East Chatham', 'NY', '12060', '42.4184', '-73.4941');
INSERT INTO `net_city` VALUES ('41309', '23', 'Копейк', 'Copake', 'NY', '12516', '42.1029', '-73.5563');
INSERT INTO `net_city` VALUES ('41398', '15', 'Сундбюберг', 'Sundbyberg', '26', '', '59.3667', '17.9667');
INSERT INTO `net_city` VALUES ('41400', '12', 'Шийи-Мазарен', 'Chilly-Mazarin', 'A8', '', '48.7149', '2.3164');
INSERT INTO `net_city` VALUES ('41401', '125', 'Тронхейм', 'Trondheim', '16', '', '63.4167', '10.4167');
INSERT INTO `net_city` VALUES ('41402', '1', 'Бродмедоус', 'Broadmeadows', '07', '', '-37.6667', '144.9000');
INSERT INTO `net_city` VALUES ('41404', '58', 'Жундиаи', 'Jundiai', '27', '', '-23.1833', '-46.8667');
INSERT INTO `net_city` VALUES ('41405', '129', 'Любляна ', 'Ljubljana', '04', '', '46.0553', '14.5144');
INSERT INTO `net_city` VALUES ('41406', '21', 'Челтнем', 'Cheltenham', 'E6', '', '51.9000', '-2.0833');
INSERT INTO `net_city` VALUES ('41407', '35', 'Моральсарсаль', 'Moralzarzal', '29', '', '40.6785', '-3.9707');
INSERT INTO `net_city` VALUES ('41409', '18', 'Паллини', 'Pallíni', '35', '', '38.0000', '23.8833');
INSERT INTO `net_city` VALUES ('41410', '58', 'Флорианополис', 'Florianopolis', '26', '', '-27.5833', '-48.5667');
INSERT INTO `net_city` VALUES ('41413', '20', 'Волгоград', 'Volgograd', '84', '', '48.7194', '44.5018');
INSERT INTO `net_city` VALUES ('41414', '29', 'Найла', 'Naila', '02', '', '50.3167', '11.7000');
INSERT INTO `net_city` VALUES ('41415', '21', 'Хаддерсфилд', 'Huddersfield', 'G8', '', '53.6500', '-1.7833');
INSERT INTO `net_city` VALUES ('41416', '23', 'Седан', 'Sedan', 'KS', '67361', '37.1500', '-96.2041');
INSERT INTO `net_city` VALUES ('41417', '35', 'Вильярреаль', 'Villarreal', '60', '', '39.9875', '-0.0392');
INSERT INTO `net_city` VALUES ('41418', '35', 'Гранада', 'Granada', '51', '', '37.1784', '-3.5992');
INSERT INTO `net_city` VALUES ('41419', '35', 'Пособланко', 'Pozoblanco', '51', '', '38.3791', '-4.8483');
INSERT INTO `net_city` VALUES ('41420', '23', 'Буд', 'Bude', 'MS', '39630', '31.4649', '-90.8234');
INSERT INTO `net_city` VALUES ('41421', '29', 'Ингельфинген ', 'Ingelfingen', '01', '', '49.3006', '9.6550');
INSERT INTO `net_city` VALUES ('41424', '29', 'Гера', 'Gera', '15', '', '50.8667', '12.0833');
INSERT INTO `net_city` VALUES ('41425', '110', 'Жешув ', 'Rzeszow', '80', '', '50.0372', '22.0049');
INSERT INTO `net_city` VALUES ('41426', '17', 'Конштансия', 'Constancia', '18', '', '39.4667', '-8.3333');
INSERT INTO `net_city` VALUES ('41429', '35', 'Алькой', 'Alcoy', '60', '', '38.7054', '-0.4743');
INSERT INTO `net_city` VALUES ('41431', '35', 'Овьедо', 'Oviedo', '34', '', '43.3632', '-5.8531');
INSERT INTO `net_city` VALUES ('41432', '23', 'Бока Гранде', 'Boca Grande', 'FL', '33921', '26.7641', '-82.2643');
INSERT INTO `net_city` VALUES ('41440', '23', 'Херрейд', 'Herreid', 'SD', '57632', '45.8332', '-100.1123');
INSERT INTO `net_city` VALUES ('41443', '109', 'Измир', 'Izmir', '35', '', '38.4127', '27.1384');
INSERT INTO `net_city` VALUES ('41444', '29', 'Везель ', 'Wesel', '07', '', '51.6667', '6.6167');
INSERT INTO `net_city` VALUES ('41466', '23', 'Ричгров', 'Richgrove', 'CA', '93261', '35.7966', '-119.1079');
INSERT INTO `net_city` VALUES ('41469', '23', 'Сент-Олбанс', 'Saint Albans', 'MO', '63073', '38.5792', '-90.7751');
INSERT INTO `net_city` VALUES ('41471', '23', 'Нью Баден', 'New Baden', 'IL', '62265', '38.4920', '-89.6736');
INSERT INTO `net_city` VALUES ('41472', '23', 'Понтун Бич', 'Pontoon Beach', 'IL', '62087', '38.8228', '-90.0600');
INSERT INTO `net_city` VALUES ('41475', '23', 'Каско', 'Casco', 'ME', '04015', '43.9742', '-70.5161');
INSERT INTO `net_city` VALUES ('41545', '23', 'Стормвилл', 'Stormville', 'NY', '12582', '41.5497', '-73.7263');
INSERT INTO `net_city` VALUES ('41547', '23', 'Лейк-Вилидж', 'Lake Village', 'AR', '71653', '33.3510', '-91.2811');
INSERT INTO `net_city` VALUES ('41552', '23', 'Айнор', 'Aynor', 'SC', '29511', '33.9771', '-79.1293');
INSERT INTO `net_city` VALUES ('41562', '23', 'Ла Прайор', 'La Pryor', 'TX', '78872', '28.9742', '-99.8634');
INSERT INTO `net_city` VALUES ('41563', '23', 'Потит', 'Poteet', 'TX', '78065', '29.0680', '-98.6498');
INSERT INTO `net_city` VALUES ('41631', '23', 'Хикори Корнерс', 'Hickory Corners', 'MI', '49060', '42.4235', '-85.3992');
INSERT INTO `net_city` VALUES ('41638', '23', 'Остров Пайн', 'Pine Island', 'MN', '55963', '44.1829', '-92.6682');
INSERT INTO `net_city` VALUES ('41691', '23', 'Конестога', 'Conestoga', 'PA', '17516', '39.9261', '-76.3384');
INSERT INTO `net_city` VALUES ('41694', '23', 'Паркин', 'Parkin', 'AR', '72373', '35.2943', '-90.5974');
INSERT INTO `net_city` VALUES ('41695', '23', 'Берритон', 'Berryton', 'KS', '66409', '38.9277', '-95.5424');
INSERT INTO `net_city` VALUES ('41699', '23', 'Дамарискотта', 'Damariscotta', 'ME', '04543', '44.0357', '-69.4928');
INSERT INTO `net_city` VALUES ('41704', '23', 'Уатли', 'Whately', 'MA', '01093', '42.4398', '-72.6348');
INSERT INTO `net_city` VALUES ('41707', '23', 'Сангервилл', 'Sangerville', 'ME', '04479', '45.1263', '-69.3065');
INSERT INTO `net_city` VALUES ('41708', '23', 'Уиллоу Спринг', 'Willow Spring', 'NC', '27592', '35.5617', '-78.6586');
INSERT INTO `net_city` VALUES ('41715', '23', 'Кэри', 'Carey', 'ID', '83320', '43.2934', '-113.6470');
INSERT INTO `net_city` VALUES ('41725', '23', 'Эсопус', 'Esopus', 'NY', '12429', '41.8279', '-73.9651');
INSERT INTO `net_city` VALUES ('41726', '23', 'Сидаредж', 'Cedaredge', 'CO', '81413', '38.9580', '-107.9684');
INSERT INTO `net_city` VALUES ('41747', '24', 'Шовилл', 'Shawville', 'QC', 'j0x2y0', '45.6049', '-76.4912');
INSERT INTO `net_city` VALUES ('41753', '24', 'Калабоги', 'Calabogie', 'ON', 'k0j1h0', '45.3000', '-76.7167');
INSERT INTO `net_city` VALUES ('41772', '23', 'Кеннедивилл', 'Kennedyville', 'MD', '21645', '39.3144', '-75.9559');
INSERT INTO `net_city` VALUES ('41774', '23', 'Урбанна', 'Urbanna', 'VA', '23175', '37.6367', '-76.5821');
INSERT INTO `net_city` VALUES ('41780', '23', 'Чинук', 'Chinook', 'WA', '98614', '46.2729', '-123.9454');
INSERT INTO `net_city` VALUES ('41798', '23', 'Артур', 'Arthur', 'ND', '58006', '47.1009', '-97.2077');
INSERT INTO `net_city` VALUES ('41809', '182', 'Энкарнасьон', 'Encarnación', '11', '', '-27.3306', '-55.8667');
INSERT INTO `net_city` VALUES ('41811', '23', 'Санборн', 'Sanborn', 'IA', '51248', '43.2078', '-95.6445');
INSERT INTO `net_city` VALUES ('41812', '80', 'Кигали', 'Kigali', '09', '', '-1.9536', '30.0606');
INSERT INTO `net_city` VALUES ('41813', '23', 'Харреллс', 'Harrells', 'NC', '28444', '34.6820', '-78.3134');
INSERT INTO `net_city` VALUES ('41815', '6', 'Сурат', 'Surat', '09', '', '20.9667', '72.9000');
INSERT INTO `net_city` VALUES ('41816', '23', 'Бладенборо', 'Bladenboro', 'NC', '28320', '34.5714', '-78.7566');
INSERT INTO `net_city` VALUES ('41818', '23', 'Бэрдстаун', 'Byrdstown', 'TN', '38549', '36.5350', '-85.0894');
INSERT INTO `net_city` VALUES ('41825', '1', 'Рингвуд Норт', 'Ringwood North', '07', '', '-37.8000', '145.2333');
INSERT INTO `net_city` VALUES ('41847', '25', 'Окосинго', 'Ocosingo', '05', '', '16.9056', '-92.0389');
INSERT INTO `net_city` VALUES ('41857', '23', 'Абикиу', 'Abiquiu', 'NM', '87510', '36.2467', '-106.3767');
INSERT INTO `net_city` VALUES ('41858', '23', 'Декервилл', 'Deckerville', 'MI', '48427', '43.5205', '-82.7241');
INSERT INTO `net_city` VALUES ('41864', '23', 'Генривилл', 'Henryville', 'PA', '18332', '41.1074', '-75.2372');
INSERT INTO `net_city` VALUES ('41866', '23', 'Пойнтел', 'Poyntelle', 'PA', '18454', '41.8206', '-75.4199');
INSERT INTO `net_city` VALUES ('41872', '23', 'Херндон', 'Herndon', 'KY', '42236', '36.7164', '-87.5947');
INSERT INTO `net_city` VALUES ('41876', '23', 'Детройт', 'Detroit', 'OR', '97342', '44.7358', '-122.1039');
INSERT INTO `net_city` VALUES ('41887', '172', 'Сан-Хосе', 'San José', '06', '', '13.9256', '-90.8244');
INSERT INTO `net_city` VALUES ('41888', '25', 'Альенде', 'Allende', '19', '', '25.2833', '-100.0167');
INSERT INTO `net_city` VALUES ('41889', '172', 'Пуэрто Барриос', 'Puerto Barrios', '09', '', '15.7167', '-88.6000');
INSERT INTO `net_city` VALUES ('41892', '25', 'Морелия', 'Morelia', '16', '', '19.7000', '-101.1167');
INSERT INTO `net_city` VALUES ('41894', '23', 'Фэрлон', 'Fairlawn', 'OH', '44334', '41.1278', '-81.6098');
INSERT INTO `net_city` VALUES ('41901', '23', 'Хагер Сити', 'Hager City', 'WI', '54014', '44.6609', '-92.5884');
INSERT INTO `net_city` VALUES ('41919', '23', 'Бейлейтон', 'Baileyton', 'AL', '35019', '34.3074', '-86.6358');
INSERT INTO `net_city` VALUES ('41921', '23', 'Самсон', 'Samson', 'AL', '36477', '31.1155', '-86.0462');
INSERT INTO `net_city` VALUES ('41922', '23', 'Станфилд', 'Stanfield', 'NC', '28163', '35.2147', '-80.4329');
INSERT INTO `net_city` VALUES ('41923', '23', 'Риджвилл', 'Ridgeville', 'SC', '29472', '33.0573', '-80.3190');
INSERT INTO `net_city` VALUES ('41926', '23', 'Элмор', 'Elmore', 'AL', '36025', '32.5465', '-86.3307');
INSERT INTO `net_city` VALUES ('41927', '23', 'Ист Палатка', 'East Palatka', 'FL', '32131', '29.6895', '-81.5778');
INSERT INTO `net_city` VALUES ('41929', '23', 'Сил', 'Seale', 'AL', '36875', '32.3084', '-85.1640');
INSERT INTO `net_city` VALUES ('41931', '23', 'Уэйерхаьюзер', 'Weyerhaeuser', 'WI', '54895', '45.4248', '-91.4289');
INSERT INTO `net_city` VALUES ('41933', '23', 'София', 'Sophia', 'NC', '27350', '35.7987', '-79.8932');
INSERT INTO `net_city` VALUES ('41936', '23', 'Уэстовер', 'Westover', 'AL', '35185', '33.3496', '-86.5358');
INSERT INTO `net_city` VALUES ('41937', '23', 'Ланетт', 'Lanett', 'AL', '36863', '32.8952', '-85.2656');
INSERT INTO `net_city` VALUES ('41987', '25', 'Кордоба', 'Cordoba (Veracruz)', '30', '', '18.8833', '-96.9333');
INSERT INTO `net_city` VALUES ('41988', '6', 'Улхаснагар', 'Ulhasnagar', '16', '', '19.2167', '73.1500');
INSERT INTO `net_city` VALUES ('41997', '5', 'Чиба', 'Chiba', '04', '', '35.6047', '140.1233');
INSERT INTO `net_city` VALUES ('42090', '127', 'Альтхофен', 'Althofen', '06', '', '47.1500', '14.2333');
INSERT INTO `net_city` VALUES ('42120', '173', 'Эскасу', 'Escazú', '08', '', '9.9189', '-84.1399');
INSERT INTO `net_city` VALUES ('42121', '201', 'Порт-Вила', 'Port Vila', '08', '', '-17.7333', '168.3167');
INSERT INTO `net_city` VALUES ('42123', '15', 'Векшё', 'Vaxjo', '12', '', '56.8833', '14.8167');
INSERT INTO `net_city` VALUES ('42132', '23', 'Дональд', 'Donald', 'OR', '97020', '45.2223', '-122.8393');
INSERT INTO `net_city` VALUES ('42134', '23', 'Мейпл Фолс', 'Maple Falls', 'WA', '98266', '48.9554', '-122.0789');
INSERT INTO `net_city` VALUES ('42136', '1', 'Мур', 'Moore', '04', '', '-26.9000', '152.3000');
INSERT INTO `net_city` VALUES ('42138', '21', 'Хитчин', 'Hitchin', 'F8', '', '51.9500', '-0.2667');
INSERT INTO `net_city` VALUES ('42143', '127', 'Зальцбург', 'Salzburg', '05', '', '47.8000', '13.0333');
INSERT INTO `net_city` VALUES ('42144', '1', 'Глен Уэверли', 'Glen Waverley', '07', '', '-37.8833', '145.1667');
INSERT INTO `net_city` VALUES ('42145', '23', 'Оли', 'Oley', 'PA', '19547', '40.3779', '-75.7746');
INSERT INTO `net_city` VALUES ('42147', '23', 'Топтон', 'Topton', 'PA', '19562', '40.5042', '-75.7008');
INSERT INTO `net_city` VALUES ('42148', '1', 'Ипсуич', 'Ipswich', '04', '', '-27.6167', '152.7667');
INSERT INTO `net_city` VALUES ('42152', '15', 'Сёдертелье', 'Sodertalje', '26', '', '59.2000', '17.6167');
INSERT INTO `net_city` VALUES ('42153', '21', 'Нанитон', 'Nuneaton', 'P3', '', '52.5167', '-1.4667');
INSERT INTO `net_city` VALUES ('42161', '35', 'Бургос', 'Burgos', '55', '', '42.3502', '-3.6753');
INSERT INTO `net_city` VALUES ('42163', '23', 'Сопертон', 'Soperton', 'GA', '30457', '32.4055', '-82.5401');
INSERT INTO `net_city` VALUES ('42165', '21', 'Дартфорд', 'Dartford', 'G5', '', '51.4500', '0.2167');
INSERT INTO `net_city` VALUES ('42166', '29', 'Регенсбург', 'Regensburg', '02', '', '49.0150', '12.0956');
INSERT INTO `net_city` VALUES ('42168', '23', 'Лорелвилл', 'Laurelville', 'OH', '43135', '39.4504', '-82.6927');
INSERT INTO `net_city` VALUES ('42169', '23', 'Стивенс', 'Stevens', 'PA', '17578', '40.2223', '-76.1222');
INSERT INTO `net_city` VALUES ('42171', '23', 'Лайзтон', 'Lizton', 'IN', '46149', '39.8786', '-86.5704');
INSERT INTO `net_city` VALUES ('42174', '23', 'Кавендиш', 'Cavendish', 'VT', '05142', '43.4006', '-72.5852');
INSERT INTO `net_city` VALUES ('42176', '23', 'Грантон', 'Granton', 'WI', '54436', '44.5531', '-90.4168');
INSERT INTO `net_city` VALUES ('42177', '23', 'Чили', 'Chili', 'WI', '54420', '44.6037', '-90.3362');
INSERT INTO `net_city` VALUES ('42182', '23', 'О Грес', 'Au Gres', 'MI', '48703', '44.0614', '-83.6615');
INSERT INTO `net_city` VALUES ('42326', '23', 'Тенаха', 'Tenaha', 'TX', '75974', '31.9597', '-94.2500');
INSERT INTO `net_city` VALUES ('42332', '21', 'Болтон', 'Bolton', 'B1', '', '53.5833', '-2.4333');
INSERT INTO `net_city` VALUES ('42336', '35', 'Леон', 'Leon', '55', '', '42.6000', '-5.5703');
INSERT INTO `net_city` VALUES ('42337', '109', 'Газиантеп', 'Gaziantep', '83', '', '37.0594', '37.3825');
INSERT INTO `net_city` VALUES ('42341', '1', 'Голд-Кост', 'Gold Coast', '04', '', '-28.0003', '153.4309');
INSERT INTO `net_city` VALUES ('42342', '29', 'Аурах', 'Aurach', '02', '', '49.3000', '10.4000');
INSERT INTO `net_city` VALUES ('42344', '125', 'Мандал', 'Mandal', '19', '', '58.0333', '7.4500');
INSERT INTO `net_city` VALUES ('42347', '33', 'Пюттен', 'Putten', '03', '', '52.2609', '5.6131');
INSERT INTO `net_city` VALUES ('42348', '1', 'Бетания', 'Bethania', '04', '', '-27.6833', '153.1667');
INSERT INTO `net_city` VALUES ('42356', '23', 'Браунс Валли', 'Browns Valley', 'MN', '56219', '45.6000', '-96.8095');
INSERT INTO `net_city` VALUES ('42371', '23', 'Шеннок', 'Shannock', 'RI', '02875', '41.4558', '-71.6388');
INSERT INTO `net_city` VALUES ('42374', '110', 'Горлице', 'Gorlice', '46', '', '49.6667', '21.1667');
INSERT INTO `net_city` VALUES ('42381', '23', 'Квинтон', 'Quinton', 'NJ', '08072', '39.5459', '-75.4124');
INSERT INTO `net_city` VALUES ('42382', '123', 'Крайова', 'Craiova', '17', '', '44.3167', '23.8000');
INSERT INTO `net_city` VALUES ('42398', '23', 'Сидар Ки', 'Cedar Key', 'FL', '32625', '29.2303', '-82.9625');
INSERT INTO `net_city` VALUES ('42401', '23', 'Миллертон', 'Millerton', 'PA', '16936', '41.9303', '-76.9631');
INSERT INTO `net_city` VALUES ('42410', '23', 'Байби', 'Bybee', 'TN', '37713', '36.1050', '-83.1237');
INSERT INTO `net_city` VALUES ('42417', '23', 'Уайт Блафф', 'White Bluff', 'TN', '37187', '36.1462', '-87.2039');
INSERT INTO `net_city` VALUES ('42422', '23', 'Джерси', 'Jersey', 'GA', '30018', '33.7157', '-83.7988');
INSERT INTO `net_city` VALUES ('42423', '23', 'Уэствего', 'Westwego', 'LA', '70094', '29.9180', '-90.2033');
INSERT INTO `net_city` VALUES ('42430', '23', 'Берни', 'Bernie', 'MO', '63822', '36.6573', '-89.9891');
INSERT INTO `net_city` VALUES ('42431', '21', 'Ситон', 'Seaton', 'D4', '', '50.7000', '-3.0667');
INSERT INTO `net_city` VALUES ('42440', '85', 'Браззавиль', 'Brazzaville', '12', '', '-4.2592', '15.2847');
INSERT INTO `net_city` VALUES ('42443', '23', 'Медоус Оф Дэн', 'Meadows Of Dan', 'VA', '24120', '36.7276', '-80.4185');
INSERT INTO `net_city` VALUES ('42506', '23', 'Харкер Хайтс', 'Harker Heights', 'TX', '76548', '31.0536', '-97.6421');
INSERT INTO `net_city` VALUES ('42515', '23', 'Бессемер Сити', 'Bessemer City', 'NC', '28016', '35.3214', '-81.2973');
INSERT INTO `net_city` VALUES ('42518', '23', 'Конрад', 'Conrad', 'IA', '50621', '42.2459', '-92.9235');
INSERT INTO `net_city` VALUES ('42519', '23', 'Гудхью', 'Goodhue', 'MN', '55027', '44.4156', '-92.6180');
INSERT INTO `net_city` VALUES ('42520', '23', 'Фелтон', 'Felton', 'GA', '30140', '33.8823', '-85.2349');
INSERT INTO `net_city` VALUES ('42526', '23', 'Кашмир', 'Cashmere', 'WA', '98815', '47.5587', '-120.4889');
INSERT INTO `net_city` VALUES ('42559', '23', 'Гринбуш', 'Greenbush', 'ME', '04418', '45.0838', '-68.4655');
INSERT INTO `net_city` VALUES ('42567', '23', 'Тоомсборо', 'Toomsboro', 'GA', '31090', '32.8136', '-83.0527');
INSERT INTO `net_city` VALUES ('42569', '23', 'Форсайт', 'Forsyth', 'MO', '65653', '36.7857', '-93.1249');
INSERT INTO `net_city` VALUES ('42572', '23', 'Херндон', 'Herndon', 'PA', '17830', '40.6793', '-76.7874');
INSERT INTO `net_city` VALUES ('42594', '23', 'Шривер', 'Schriever', 'LA', '70395', '29.6908', '-90.8753');
INSERT INTO `net_city` VALUES ('42609', '23', 'Бруно', 'Bruno', 'MN', '55712', '46.2730', '-92.5107');
INSERT INTO `net_city` VALUES ('42653', '58', 'Марилия', 'Marília', '27', '', '-22.2167', '-49.9333');
INSERT INTO `net_city` VALUES ('42660', '23', 'Стилман Валли', 'Stillman Valley', 'IL', '61084', '42.1210', '-89.1882');
INSERT INTO `net_city` VALUES ('42663', '23', 'Барбервилл', 'Barberville', 'FL', '32105', '29.1872', '-81.4209');
INSERT INTO `net_city` VALUES ('42676', '23', 'Сквайрс', 'Squires', 'MO', '65755', '36.7917', '-92.6556');
INSERT INTO `net_city` VALUES ('42677', '21', 'Тентерден', 'Tenterden', 'G5', '', '51.0500', '0.7000');
INSERT INTO `net_city` VALUES ('42680', '13', 'Соаве', 'Soave', '20', '', '45.4167', '11.2500');
INSERT INTO `net_city` VALUES ('42683', '59', 'Маггия', 'Maggia', '20', '', '46.2465', '8.7081');
INSERT INTO `net_city` VALUES ('42684', '118', 'Пула', 'Pula', '23', '', '47.0000', '17.6500');
INSERT INTO `net_city` VALUES ('42687', '25', 'Косумель', 'Cozumel', '23', '', '20.5083', '-86.9458');
INSERT INTO `net_city` VALUES ('42689', '15', 'Тебю', 'Taby', '26', '', '59.5000', '18.0500');
INSERT INTO `net_city` VALUES ('42691', '21', 'Макклсфилд', 'Macclesfield', 'C5', '', '53.2500', '-2.1167');
INSERT INTO `net_city` VALUES ('42693', '23', 'Касл Рок', 'Castle Rock', 'WA', '98611', '46.2936', '-122.9576');
INSERT INTO `net_city` VALUES ('42704', '109', 'Самсун', 'Samsun', '55', '', '41.2867', '36.3300');
INSERT INTO `net_city` VALUES ('42720', '23', 'Гровтон', 'Groveton', 'TX', '75845', '31.0901', '-95.0795');
INSERT INTO `net_city` VALUES ('42721', '23', 'Кросбитон', 'Crosbyton', 'TX', '79322', '33.6450', '-101.1836');
INSERT INTO `net_city` VALUES ('42726', '23', 'Фэрфакс', 'Fairfax', 'OK', '74637', '36.5708', '-96.7161');
INSERT INTO `net_city` VALUES ('42728', '23', 'Латексо', 'Latexo', 'TX', '75849', '31.3952', '-95.4741');
INSERT INTO `net_city` VALUES ('42729', '23', 'Шенеста', 'Tionesta', 'PA', '16353', '41.4842', '-79.3825');
INSERT INTO `net_city` VALUES ('42730', '23', 'Страттанвилл', 'Strattanville', 'PA', '16258', '41.2369', '-79.2128');
INSERT INTO `net_city` VALUES ('42735', '23', 'Антонио', 'Antonito', 'CO', '81120', '37.1107', '-105.9964');
INSERT INTO `net_city` VALUES ('42736', '23', 'Саутворт', 'Southworth', 'WA', '98386', '47.5120', '-122.5018');
INSERT INTO `net_city` VALUES ('42738', '23', 'Уимблдон', 'Wimbledon', 'ND', '58492', '47.1608', '-98.4466');
INSERT INTO `net_city` VALUES ('42741', '23', 'Ринер', 'Riner', 'VA', '24149', '37.0274', '-80.4431');
INSERT INTO `net_city` VALUES ('42792', '23', 'Уитленд', 'Wheatland', 'ND', '58079', '46.8544', '-97.3360');
INSERT INTO `net_city` VALUES ('42793', '23', 'Адамс', 'Adams', 'WI', '53910', '43.8890', '-89.8355');
INSERT INTO `net_city` VALUES ('42819', '23', 'Николс', 'Nichols', 'SC', '29581', '34.2091', '-79.1085');
INSERT INTO `net_city` VALUES ('42823', '23', 'Баррон', 'Barron', 'WI', '54812', '45.4086', '-91.8838');
INSERT INTO `net_city` VALUES ('42824', '23', 'Говермент Кэмп', 'Government Camp', 'OR', '97028', '45.2784', '-121.7126');
INSERT INTO `net_city` VALUES ('42860', '23', 'Хастисфорд', 'Hustisford', 'WI', '53034', '43.3372', '-88.6086');
INSERT INTO `net_city` VALUES ('42869', '5', 'Футю', 'Fuchu', '40', '', '35.6667', '139.4833');
INSERT INTO `net_city` VALUES ('42884', '23', 'Чесанинг', 'Chesaning', 'MI', '48616', '43.1820', '-84.1315');
INSERT INTO `net_city` VALUES ('42885', '23', 'Бирдсли', 'Beardsley', 'MN', '56211', '45.6013', '-96.7000');
INSERT INTO `net_city` VALUES ('42898', '173', 'Десампарадос', 'Desamparados', '08', '', '9.8968', '-84.0629');
INSERT INTO `net_city` VALUES ('42926', '23', 'Фредерик', 'Frederic', 'WI', '54837', '45.6772', '-92.3830');
INSERT INTO `net_city` VALUES ('42949', '23', 'Остин', 'Osteen', 'FL', '32764', '28.8558', '-81.0603');
INSERT INTO `net_city` VALUES ('42952', '23', 'Крабтри', 'Crabtree', 'OR', '97335', '44.6351', '-122.8982');
INSERT INTO `net_city` VALUES ('42957', '23', 'Родни', 'Rodney', 'IA', '51051', '42.2017', '-95.9647');
INSERT INTO `net_city` VALUES ('42961', '23', 'Эрлвилл', 'Earlville', 'NY', '13332', '42.7597', '-75.5688');
INSERT INTO `net_city` VALUES ('42970', '23', 'Де Арк', 'Des Arc', 'AR', '72040', '34.9424', '-91.5924');
INSERT INTO `net_city` VALUES ('42977', '23', 'Бойд', 'Boyd', 'WI', '54726', '44.9312', '-91.0162');
INSERT INTO `net_city` VALUES ('42978', '1', 'Терроул', 'Thirroul', '02', '', '-34.3167', '150.9167');
INSERT INTO `net_city` VALUES ('42980', '23', 'Маунт-Вернон', 'Mount Vernon', 'AL', '36560', '31.0750', '-88.0564');
INSERT INTO `net_city` VALUES ('42988', '45', 'Сурабая', 'Surabaya', '08', '', '-7.2492', '112.7508');
INSERT INTO `net_city` VALUES ('42991', '23', 'Эдвардс', 'Edwards', 'NY', '13635', '44.3041', '-75.2691');
INSERT INTO `net_city` VALUES ('42995', '23', 'Дав Крик', 'Dove Creek', 'CO', '81324', '37.7062', '-109.0199');
INSERT INTO `net_city` VALUES ('43002', '21', 'Хаслмир', 'Haslemere', 'N7', '', '51.0833', '-0.7000');
INSERT INTO `net_city` VALUES ('43007', '23', 'Санфилд', 'Sunfield', 'MI', '48890', '42.7685', '-84.9697');
INSERT INTO `net_city` VALUES ('43008', '23', 'Гиллетт', 'Gillett', 'AR', '72055', '34.1030', '-91.3558');
INSERT INTO `net_city` VALUES ('43011', '23', 'Лонгвилл', 'Longville', 'LA', '70652', '30.5827', '-93.2515');
INSERT INTO `net_city` VALUES ('43018', '161', 'Ла-Либертад', 'La Libertad', '01', '', '-5.4447', '-78.4886');
INSERT INTO `net_city` VALUES ('43024', '21', 'Саттон', 'Sutton', 'N8', '', '51.3500', '-0.2000');
INSERT INTO `net_city` VALUES ('43063', '23', 'Дональдсон', 'Donaldson', 'MN', '56720', '48.5796', '-96.8350');
INSERT INTO `net_city` VALUES ('43066', '45', 'Блитар', 'Blitar', '08', '', '-8.0983', '112.1681');
INSERT INTO `net_city` VALUES ('43069', '23', 'Милвилл', 'Millville', 'PA', '17846', '41.1492', '-76.5096');
INSERT INTO `net_city` VALUES ('43074', '138', 'Кишинёв', 'Chisinau', '48', '', '47.0056', '28.8575');
INSERT INTO `net_city` VALUES ('43076', '23', 'Смитс Гров', 'Smiths Grove', 'KY', '42171', '37.0372', '-86.1472');
INSERT INTO `net_city` VALUES ('43077', '23', 'Браунс Валли', 'Browns Valley', 'CA', '95918', '39.3320', '-121.3389');
INSERT INTO `net_city` VALUES ('43078', '23', 'Эвартс', 'Evarts', 'KY', '40828', '36.8766', '-83.1409');
INSERT INTO `net_city` VALUES ('43082', '1', 'Кофс-Харбор', 'Coffs Harbour', '02', '', '-30.2963', '153.1135');
INSERT INTO `net_city` VALUES ('43083', '35', 'Реус', 'Reus', '56', '', '41.1559', '1.1074');
INSERT INTO `net_city` VALUES ('43101', '23', 'Финли', 'Finley', 'CA', '95435', '39.0043', '-122.8756');
INSERT INTO `net_city` VALUES ('43105', '23', 'Фосетт', 'Faucett', 'MO', '64448', '39.6047', '-94.8098');
INSERT INTO `net_city` VALUES ('43106', '23', 'Биглер', 'Bigler', 'PA', '16825', '40.9848', '-78.3064');
INSERT INTO `net_city` VALUES ('43116', '23', 'Ньюфаундленд', 'Newfoundland', 'NJ', '07435', '41.0341', '-74.4174');
INSERT INTO `net_city` VALUES ('43118', '23', 'Сейнт Джермейн', 'Saint Germain', 'WI', '54558', '45.9228', '-89.4808');
INSERT INTO `net_city` VALUES ('43120', '23', 'Харт', 'Hart', 'MI', '49420', '43.7279', '-86.2840');
INSERT INTO `net_city` VALUES ('43122', '23', 'Паскоаг', 'Pascoag', 'RI', '02859', '41.9701', '-71.7217');
INSERT INTO `net_city` VALUES ('43129', '23', 'Квеста', 'Questa', 'NM', '87556', '36.7808', '-105.5239');
INSERT INTO `net_city` VALUES ('43137', '23', 'Симаррон', 'Cimarron', 'NM', '87714', '36.6281', '-104.9948');
INSERT INTO `net_city` VALUES ('43140', '23', 'Эбен Джанкшен', 'Eben Junction', 'MI', '49825', '46.3757', '-86.9727');
INSERT INTO `net_city` VALUES ('43165', '23', 'Барвик', 'Barwick', 'GA', '31720', '30.8902', '-83.7407');
INSERT INTO `net_city` VALUES ('43168', '23', 'Минерал Спрингс', 'Mineral Springs', 'NC', '28108', '34.9163', '-80.6404');
INSERT INTO `net_city` VALUES ('43170', '23', 'Патагония', 'Patagonia', 'AZ', '85624', '31.5323', '-110.7113');
INSERT INTO `net_city` VALUES ('43175', '23', 'Альбин', 'Albin', 'WY', '82050', '41.4478', '-104.2664');
INSERT INTO `net_city` VALUES ('43189', '23', 'Кристал Фоллс', 'Crystal Falls', 'MI', '49920', '46.1346', '-88.3601');
INSERT INTO `net_city` VALUES ('43196', '23', 'Топава', 'Topawa', 'AZ', '85639', '31.8140', '-111.8257');
INSERT INTO `net_city` VALUES ('43199', '23', 'Линдсей', 'Lindsay', 'NE', '68644', '41.7355', '-97.6678');
INSERT INTO `net_city` VALUES ('43200', '23', 'Мейплтон', 'Mapleton', 'UT', '84664', '40.1118', '-111.4859');
INSERT INTO `net_city` VALUES ('43202', '23', 'Табиона', 'Tabiona', 'UT', '84072', '40.3845', '-110.6497');
INSERT INTO `net_city` VALUES ('43204', '23', 'Дорена', 'Dorena', 'OR', '97434', '43.7004', '-122.8964');
INSERT INTO `net_city` VALUES ('43209', '23', 'Ханивилл', 'Honeyville', 'UT', '84314', '41.6450', '-112.0988');
INSERT INTO `net_city` VALUES ('43210', '187', 'Мальдонадо', 'Maldonado', '09', '', '-34.9000', '-54.9500');
INSERT INTO `net_city` VALUES ('43225', '123', 'Констанца', 'Constanta', '14', '', '44.1833', '28.6500');
INSERT INTO `net_city` VALUES ('43256', '23', 'Ребекка', 'Rebecca', 'GA', '31783', '31.7413', '-83.4825');
INSERT INTO `net_city` VALUES ('43258', '23', 'Кларктон', 'Clarkton', 'MO', '63837', '36.4503', '-89.9849');
INSERT INTO `net_city` VALUES ('43335', '24', 'Бэ-Сен-Поль', 'Baie-Saint Paul', 'QC', 'g3z2w9', '47.4333', '-70.5000');
INSERT INTO `net_city` VALUES ('43530', '24', 'Сен-Тома', 'Saint Thomas', 'ON', 'n5p4m6', '42.7790', '-81.1908');
INSERT INTO `net_city` VALUES ('43531', '24', 'Смитвилл', 'Smithville', 'ON', 'l0r2a0', '43.1021', '-79.5456');
INSERT INTO `net_city` VALUES ('43790', '24', 'Сент-Анн-де-Бопре', 'Sainte Anne de Beaupre', 'QC', 'g0a3c0', '47.0328', '-70.9309');
INSERT INTO `net_city` VALUES ('43796', '24', 'Раудон', 'Rawdon', 'QC', 'j0k1s0', '46.0464', '-73.7085');
INSERT INTO `net_city` VALUES ('43926', '24', 'Риго', 'Rigaud', 'QC', 'j0p1t0', '45.4812', '-74.3076');
INSERT INTO `net_city` VALUES ('43995', '24', 'Порт Кредит', 'Port Credit', 'ON', 'l5h4k3', '43.5500', '-79.5833');
INSERT INTO `net_city` VALUES ('44015', '24', 'Нотр-Дам-дю-Лак', 'Notre-dame-du-lac', 'QC', 'g0l1x0', '47.6101', '-68.7950');
INSERT INTO `net_city` VALUES ('44131', '23', 'Райс', 'Rice', 'MN', '56367', '45.7501', '-94.1401');
INSERT INTO `net_city` VALUES ('44161', '24', 'Сент-Бернар-де-Лаколь', 'Saint-Bernard-de-Lacolle', 'QC', 'j0j1j0', '45.0837', '-73.3720');
INSERT INTO `net_city` VALUES ('44409', '24', 'Стайнер', 'Stayner', 'ON', 'l0m1s0', '44.4167', '-80.0833');
INSERT INTO `net_city` VALUES ('44427', '24', 'Гленко', 'Glencoe', 'ON', 'n0l1m0', '42.7500', '-81.7000');
INSERT INTO `net_city` VALUES ('44525', '24', 'Буашатель', 'Boischatel', 'QC', 'g0a1h0', '46.9000', '-71.1333');
INSERT INTO `net_city` VALUES ('44680', '23', 'Сейнт Эдуард', 'Saint Edward', 'NE', '68660', '41.5830', '-97.8789');
INSERT INTO `net_city` VALUES ('44681', '23', 'Хамфри', 'Humphrey', 'NE', '68642', '41.6924', '-97.5134');
INSERT INTO `net_city` VALUES ('44684', '23', 'Фрутвейл', 'Fruitvale', 'ID', '', '44.8152', '-116.4401');
INSERT INTO `net_city` VALUES ('44686', '23', 'Полина', 'Paulina', 'LA', '70763', '30.0600', '-90.7332');
INSERT INTO `net_city` VALUES ('44696', '23', 'Пойнт Клир', 'Point Clear', 'AL', '36564', '30.4741', '-87.9192');
INSERT INTO `net_city` VALUES ('44699', '23', 'Вулффорт', 'Wolfforth', 'TX', '79382', '33.4621', '-102.0215');
INSERT INTO `net_city` VALUES ('44706', '23', 'Ист-Хаддэм', 'East Haddam', 'CT', '06423', '41.4777', '-72.3910');
INSERT INTO `net_city` VALUES ('44709', '23', 'Мак-Коннелл', 'Mc Connell', 'IL', '61050', '42.4375', '-89.7339');
INSERT INTO `net_city` VALUES ('44734', '119', 'Лозорно', 'Lozorno', '02', '', '48.3333', '17.0500');
INSERT INTO `net_city` VALUES ('44735', '23', 'Саут Графтон', 'South Grafton', 'MA', '01560', '42.1744', '-71.6811');
INSERT INTO `net_city` VALUES ('44747', '23', 'Хузик Фолс', 'Hoosick Falls', 'NY', '12090', '42.8828', '-73.3700');
INSERT INTO `net_city` VALUES ('44766', '23', 'Такервилл', 'Thackerville', 'OK', '73459', '33.7813', '-97.1263');
INSERT INTO `net_city` VALUES ('44767', '23', 'Креммлинг', 'Kremmling', 'CO', '80459', '40.1850', '-106.4220');
INSERT INTO `net_city` VALUES ('44768', '23', 'Бродвей', 'Broadway', 'NJ', '08808', '40.7320', '-75.0516');
INSERT INTO `net_city` VALUES ('44779', '21', 'Грейвсенд', 'Gravesend', 'G5', '', '51.4333', '0.3667');
INSERT INTO `net_city` VALUES ('44780', '1', 'Калундра', 'Caloundra', '04', '', '-26.7971', '153.1377');
INSERT INTO `net_city` VALUES ('44786', '58', 'Атибая', 'Atibaia', '27', '', '-23.1242', '-46.5622');
INSERT INTO `net_city` VALUES ('44788', '21', 'Вейбридж', 'Weybridge', 'N7', '', '51.3667', '-0.4667');
INSERT INTO `net_city` VALUES ('44789', '29', 'Эрбах', 'Erbach', '05', '', '49.6561', '8.9964');
INSERT INTO `net_city` VALUES ('44790', '110', 'Рыбник', 'Rybnik', '35', '', '50.1167', '18.5333');
INSERT INTO `net_city` VALUES ('44791', '58', 'Паулу-Афонсу', 'Paulo Afonso', '05', '', '-9.3500', '-38.2333');
INSERT INTO `net_city` VALUES ('44792', '23', 'Бутбей', 'Boothbay', 'ME', '04537', '43.9034', '-69.6203');
INSERT INTO `net_city` VALUES ('44794', '23', 'Хеббронвилл', 'Hebbronville', 'TX', '78361', '27.0715', '-98.8097');
INSERT INTO `net_city` VALUES ('44834', '23', 'Стонингтон', 'Stonington', 'CT', '06378', '41.3804', '-71.9151');
INSERT INTO `net_city` VALUES ('44835', '35', 'Аликанте', 'Alicante', '60', '', '38.3462', '-0.4877');
INSERT INTO `net_city` VALUES ('44839', '23', 'Вудсфилд', 'Woodsfield', 'OH', '43793', '39.7453', '-81.1054');
INSERT INTO `net_city` VALUES ('44874', '23', 'Аркдейл', 'Arkdale', 'WI', '54613', '44.0618', '-89.8986');
INSERT INTO `net_city` VALUES ('44877', '23', 'Лайнум', 'Lignum', 'VA', '22726', '38.4031', '-77.8247');
INSERT INTO `net_city` VALUES ('44878', '23', 'Моррис', 'Morris', 'CT', '06763', '41.6901', '-73.2118');
INSERT INTO `net_city` VALUES ('44879', '23', 'Слатингтон', 'Slatington', 'PA', '18080', '40.7366', '-75.6217');
INSERT INTO `net_city` VALUES ('44897', '23', 'Порт Барр', 'Port Barre', 'LA', '70577', '30.5580', '-91.9266');
INSERT INTO `net_city` VALUES ('44898', '23', 'Пима', 'Pima', 'AZ', '85543', '33.0017', '-109.8825');
INSERT INTO `net_city` VALUES ('44907', '23', 'Уордсворт', 'Wadsworth', 'IL', '60083', '42.4370', '-87.9443');
INSERT INTO `net_city` VALUES ('44909', '23', 'Этна', 'Etna', 'OH', '43018', '39.9573', '-82.6818');
INSERT INTO `net_city` VALUES ('44910', '23', 'Афтон', 'Afton', 'MI', '49705', '45.3606', '-84.4745');
INSERT INTO `net_city` VALUES ('44916', '23', 'Сасаква', 'Sasakwa', 'OK', '74867', '34.9713', '-96.5264');
INSERT INTO `net_city` VALUES ('44917', '23', 'Катоисса', 'Catawissa', 'MO', '63015', '38.3858', '-90.7421');
INSERT INTO `net_city` VALUES ('44935', '23', 'Дорчестер', 'Dorchester', 'WI', '54425', '45.0100', '-90.3068');
INSERT INTO `net_city` VALUES ('44940', '23', 'Уэстморленд', 'Westmoreland', 'TN', '37186', '36.5739', '-86.2512');
INSERT INTO `net_city` VALUES ('44941', '23', 'Хикори Гров', 'Hickory Grove', 'SC', '29717', '34.9413', '-81.4351');
INSERT INTO `net_city` VALUES ('44952', '23', 'Мак-Кук', 'McCook', 'NE', '', '40.2019', '-100.6257');
INSERT INTO `net_city` VALUES ('44958', '23', 'Брейдвуд', 'Braidwood', 'IL', '60408', '41.2476', '-88.2169');
INSERT INTO `net_city` VALUES ('44963', '23', 'Чадборн', 'Chadbourn', 'NC', '28431', '34.3113', '-78.8626');
INSERT INTO `net_city` VALUES ('44965', '23', 'Уричсвилл', 'Uhrichsville', 'OH', '44683', '40.3536', '-81.3087');
INSERT INTO `net_city` VALUES ('44966', '23', 'Порт Санилак', 'Port Sanilac', 'MI', '48469', '43.4450', '-82.5557');
INSERT INTO `net_city` VALUES ('44970', '23', 'Даггетт', 'Daggett', 'MI', '49821', '45.5323', '-87.6049');
INSERT INTO `net_city` VALUES ('44971', '23', 'Слейтон', 'Slaton', 'TX', '79364', '33.4629', '-101.6733');
INSERT INTO `net_city` VALUES ('44972', '23', 'Уилмот', 'Wilmot', 'NH', '03287', '43.4487', '-71.9244');
INSERT INTO `net_city` VALUES ('44979', '23', 'Сейнт Игнас', 'Saint Ignace', 'MI', '49781', '45.9976', '-84.7107');
INSERT INTO `net_city` VALUES ('45061', '23', 'Элса', 'Elsah', 'IL', '62028', '38.9678', '-90.3406');
INSERT INTO `net_city` VALUES ('45148', '23', 'Оттер Рок', 'Otter Rock', 'OR', '97369', '44.7468', '-124.0593');
INSERT INTO `net_city` VALUES ('45160', '23', 'Самитон', 'Sumiton', 'AL', '35148', '33.7548', '-87.0468');
INSERT INTO `net_city` VALUES ('45383', '23', 'Ошен Парк', 'Ocean Park', 'WA', '98640', '46.5466', '-124.0465');
INSERT INTO `net_city` VALUES ('45604', '23', 'Нокс Сити', 'Knox City', 'MO', '63446', '40.1186', '-92.0319');
INSERT INTO `net_city` VALUES ('45606', '23', 'Менло', 'Menlo', 'WA', '98561', '46.6215', '-123.6471');
INSERT INTO `net_city` VALUES ('45608', '23', 'Дарден', 'Darden', 'TN', '38328', '35.6734', '-88.2163');
INSERT INTO `net_city` VALUES ('45610', '23', 'Стаутсвилл', 'Stoutsville', 'OH', '43154', '39.6117', '-82.8271');
INSERT INTO `net_city` VALUES ('45611', '23', 'Гастин', 'Gustine', 'CA', '95322', '37.1423', '-121.0470');
INSERT INTO `net_city` VALUES ('45613', '23', 'Шелл Лейк', 'Shell Lake', 'WI', '54871', '45.7272', '-92.0257');
INSERT INTO `net_city` VALUES ('45614', '23', 'Венден', 'Wenden', 'AZ', '85357', '33.8225', '-113.5416');
INSERT INTO `net_city` VALUES ('45615', '23', 'Стилсвилл', 'Stilesville', 'IN', '46180', '39.6005', '-86.6198');
INSERT INTO `net_city` VALUES ('45616', '23', 'Уодесвилл', 'Wadesville', 'IN', '47638', '38.0707', '-87.7863');
INSERT INTO `net_city` VALUES ('45617', '23', 'Бланчардвилл', 'Blanchardville', 'WI', '53516', '42.7947', '-89.8629');
INSERT INTO `net_city` VALUES ('45619', '23', 'Нью-Росс', 'New Ross', 'IN', '47968', '39.9579', '-86.7497');
INSERT INTO `net_city` VALUES ('45621', '23', 'Декатурвилл', 'Decaturville', 'TN', '38329', '35.5400', '-88.1096');
INSERT INTO `net_city` VALUES ('45622', '23', 'Тейт', 'Tate', 'GA', '30177', '34.4149', '-84.3679');
INSERT INTO `net_city` VALUES ('45633', '23', 'Питтсвилл', 'Pittsville', 'WI', '54466', '44.3953', '-90.3023');
INSERT INTO `net_city` VALUES ('45636', '23', 'Раш Спрингс', 'Rush Springs', 'OK', '73082', '34.7852', '-97.8787');
INSERT INTO `net_city` VALUES ('45637', '23', 'Биверкрик', 'Beavercreek', 'OR', '97004', '45.2506', '-122.4605');
INSERT INTO `net_city` VALUES ('45639', '23', 'Роллинсвилл', 'Rollinsville', 'CO', '80474', '39.9172', '-105.5011');
INSERT INTO `net_city` VALUES ('45640', '23', 'Юстас', 'Eustace', 'TX', '75124', '32.3257', '-95.9842');
INSERT INTO `net_city` VALUES ('45641', '45', 'Маланг', 'Malang', '08', '', '-7.9797', '112.6304');
INSERT INTO `net_city` VALUES ('45644', '23', 'Уоерика', 'Waurika', 'OK', '73573', '34.1803', '-97.9288');
INSERT INTO `net_city` VALUES ('45647', '45', 'Джембер', 'Jember', '08', '', '-8.1705', '113.7020');
INSERT INTO `net_city` VALUES ('45650', '45', 'Джокьякарта', 'Yogyakarta', '10', '', '-7.7828', '110.3608');
INSERT INTO `net_city` VALUES ('45724', '24', 'Стерджен Фолс', 'Sturgeon Falls', 'ON', 'p2b1p2', '46.3667', '-79.9333');
INSERT INTO `net_city` VALUES ('45762', '23', 'Афтон', 'Afton', 'WI', '53501', '42.6039', '-89.0712');
INSERT INTO `net_city` VALUES ('45777', '24', 'Сент-Мартин', 'Sainte-martine', 'QC', 'j0s1v0', '45.2472', '-73.7986');
INSERT INTO `net_city` VALUES ('45807', '24', 'Сен-Паскаль', 'Saint-Pascal', 'QC', 'g0l3y0', '47.5298', '-69.8078');
INSERT INTO `net_city` VALUES ('45862', '23', 'Мудус', 'Moodus', 'CT', '06469', '41.5068', '-72.4430');
INSERT INTO `net_city` VALUES ('45876', '23', 'Колбрук', 'Colebrook', 'CT', '06021', '42.0273', '-73.1004');
INSERT INTO `net_city` VALUES ('45877', '23', 'Сомерс', 'Somers', 'CT', '06071', '41.9908', '-72.4517');
INSERT INTO `net_city` VALUES ('45885', '23', 'Сейнт Стивен', 'Saint Stephen', 'SC', '29479', '33.3570', '-79.8687');
INSERT INTO `net_city` VALUES ('45888', '23', 'Коуэн', 'Cowan', 'TN', '37318', '35.1831', '-85.9685');
INSERT INTO `net_city` VALUES ('45894', '117', 'Паралимни ', 'Paralimni', '01', '', '35.0375', '33.9833');
INSERT INTO `net_city` VALUES ('45896', '6', 'Газиабад', 'Ghaziabad', '36', '', '28.6667', '77.4333');
INSERT INTO `net_city` VALUES ('45899', '6', 'Калькутта', 'Kolkata', '28', '', '22.5697', '88.3697');
INSERT INTO `net_city` VALUES ('45900', '12', 'Кийан', 'Quillan', 'A9', '', '42.8758', '2.1818');
INSERT INTO `net_city` VALUES ('45913', '20', 'Ульяновск', 'Ulyanovsk', '81', '', '54.3282', '48.3866');
INSERT INTO `net_city` VALUES ('45919', '23', 'Барнстед', 'Barnstead', 'NH', '03218', '43.3426', '-71.2819');
INSERT INTO `net_city` VALUES ('45920', '59', 'Кьяссо', 'Chiasso', '20', '', '45.8349', '9.0205');
INSERT INTO `net_city` VALUES ('45921', '23', 'Поллоксвилл', 'Pollocksville', 'NC', '28573', '34.9750', '-77.2329');
INSERT INTO `net_city` VALUES ('45935', '23', 'Вейдман', 'Weidman', 'MI', '48893', '43.6831', '-84.9722');
INSERT INTO `net_city` VALUES ('45936', '1', 'Саутпорт', 'Southport', '04', '', '-27.9667', '153.4000');
INSERT INTO `net_city` VALUES ('45942', '21', 'Уолсолл', 'Walsall', 'O8', '', '52.6000', '-2.0000');
INSERT INTO `net_city` VALUES ('45945', '21', 'Солтэш', 'Saltash', 'C6', '', '50.4081', '-4.2153');
INSERT INTO `net_city` VALUES ('45949', '23', 'Коллинвуд', 'Collinwood', 'TN', '38450', '35.1784', '-87.7838');
INSERT INTO `net_city` VALUES ('45950', '23', 'Скотс Хилл', 'Scotts Hill', 'TN', '38374', '35.5046', '-88.1898');
INSERT INTO `net_city` VALUES ('45951', '23', 'Макатава', 'Macatawa', 'MI', '49434', '42.7697', '-86.2061');
INSERT INTO `net_city` VALUES ('45953', '23', 'Богстаун', 'Boggstown', 'IN', '46110', '39.5741', '-85.9139');
INSERT INTO `net_city` VALUES ('45956', '23', 'Индиан Ривер', 'Indian River', 'MI', '49749', '45.4176', '-84.5809');
INSERT INTO `net_city` VALUES ('45964', '23', 'Лобелвилл', 'Lobelville', 'TN', '37097', '35.7559', '-87.8449');
INSERT INTO `net_city` VALUES ('45966', '23', 'Амбой', 'Amboy', 'WA', '98601', '45.9314', '-122.4487');
INSERT INTO `net_city` VALUES ('45967', '23', 'Пеннок', 'Pennock', 'MN', '56279', '45.2215', '-95.1649');
INSERT INTO `net_city` VALUES ('45970', '23', 'Стаутленд', 'Stoutland', 'MO', '65567', '37.8669', '-92.5573');
INSERT INTO `net_city` VALUES ('45971', '23', 'Гровер Хилл', 'Grover Hill', 'OH', '45849', '41.0132', '-84.4671');
INSERT INTO `net_city` VALUES ('45972', '23', 'Этна', 'Etna', 'ME', '04434', '44.7853', '-69.1349');
INSERT INTO `net_city` VALUES ('45973', '23', 'Дерма', 'Derma', 'MS', '38839', '33.8557', '-89.2845');
INSERT INTO `net_city` VALUES ('45978', '23', 'Беннингтон', 'Bennington', 'NH', '03442', '43.0172', '-71.9106');
INSERT INTO `net_city` VALUES ('45983', '23', 'Рочдейл', 'Roachdale', 'IN', '46172', '39.8284', '-86.8235');
INSERT INTO `net_city` VALUES ('45984', '23', 'Валдерс', 'Valders', 'WI', '54245', '44.0290', '-87.9115');
INSERT INTO `net_city` VALUES ('45986', '23', 'Скандинавия', 'Scandinavia', 'WI', '54977', '44.4549', '-89.1716');
INSERT INTO `net_city` VALUES ('45987', '23', 'Антрим', 'Antrim', 'NH', '03440', '43.0597', '-71.9817');
INSERT INTO `net_city` VALUES ('45989', '23', 'Минерал Блафф', 'Mineral Bluff', 'GA', '30559', '34.9375', '-84.2505');
INSERT INTO `net_city` VALUES ('45991', '23', 'Барнардсвилл', 'Barnardsville', 'NC', '28709', '35.7531', '-82.4143');
INSERT INTO `net_city` VALUES ('45997', '23', 'Пештиго', 'Peshtigo', 'WI', '54157', '45.0534', '-87.8010');
INSERT INTO `net_city` VALUES ('46005', '43', 'Катманду', 'Kathmandu', '00', '', '27.7167', '85.3167');
INSERT INTO `net_city` VALUES ('46006', '43', 'Бхактапур', 'Bhaktapur', '00', '', '27.6667', '85.4167');
INSERT INTO `net_city` VALUES ('46010', '23', 'Рисевилл', 'Riceville', 'TN', '37370', '35.3511', '-84.6968');
INSERT INTO `net_city` VALUES ('46011', '23', 'Калхун Сити', 'Calhoun City', 'MS', '38916', '33.8239', '-89.3474');
INSERT INTO `net_city` VALUES ('46012', '23', 'Верден', 'Verden', 'OK', '73092', '35.1234', '-98.0878');
INSERT INTO `net_city` VALUES ('46016', '23', 'Норт Саттон', 'North Sutton', 'NH', '03260', '43.3640', '-71.9395');
INSERT INTO `net_city` VALUES ('46017', '23', 'Моссирок', 'Mossyrock', 'WA', '98564', '46.4887', '-122.4422');
INSERT INTO `net_city` VALUES ('46019', '1', 'Эдитвейл', 'Edithvale', '07', '', '-38.0333', '145.1167');
INSERT INTO `net_city` VALUES ('46020', '110', 'Устронь', 'Ustron', '25', '', '49.7167', '18.8000');
INSERT INTO `net_city` VALUES ('46021', '21', 'Гастингс', 'Hastings', 'E2', '', '50.8500', '0.6000');
INSERT INTO `net_city` VALUES ('46023', '21', 'Кемберли', 'Camberley', 'N7', '', '51.3500', '-0.7333');
INSERT INTO `net_city` VALUES ('46025', '110', 'Бельско-Бяла', 'Bielsko-Biala', '25', '', '49.8224', '19.0469');
INSERT INTO `net_city` VALUES ('46027', '110', 'Клодзко ', 'Klodzko', '66', '', '50.4333', '16.6500');
INSERT INTO `net_city` VALUES ('46030', '56', 'Остенде', 'Oostende', '09', '', '50.7667', '3.4667');
INSERT INTO `net_city` VALUES ('46031', '23', 'Элм Крик', 'Elm Creek', 'NE', '68836', '40.7627', '-99.3602');
INSERT INTO `net_city` VALUES ('46035', '17', 'Алмада', 'Almada', '19', '', '38.6790', '-9.1569');
INSERT INTO `net_city` VALUES ('46039', '21', 'Виндзор', 'Windsor', '03', '', '51.4833', '-0.6000');
INSERT INTO `net_city` VALUES ('46041', '127', 'Линц', 'Linz', '04', '', '48.3000', '14.3000');
INSERT INTO `net_city` VALUES ('46042', '1', 'Модбери', 'Modbury', '05', '', '-34.8333', '138.6833');
INSERT INTO `net_city` VALUES ('46043', '21', 'Уоллингтон', 'Wallington', 'N7', '', '51.3500', '-0.1500');
INSERT INTO `net_city` VALUES ('46045', '23', 'Гретна', 'Gretna', 'FL', '32332', '30.6207', '-84.6642');
INSERT INTO `net_city` VALUES ('46054', '23', 'Этель', 'Ethel', 'WA', '98542', '46.5106', '-122.6835');
INSERT INTO `net_city` VALUES ('46055', '23', 'Рисон', 'Rison', 'AR', '71665', '33.8841', '-92.1578');
INSERT INTO `net_city` VALUES ('46056', '23', 'Гонсалес', 'Gonzalez', 'FL', '32560', '30.5816', '-87.2914');
INSERT INTO `net_city` VALUES ('46057', '23', 'Шенорок', 'Shenorock', 'NY', '10587', '41.3318', '-73.7382');
INSERT INTO `net_city` VALUES ('46058', '23', 'Даунс', 'Downs', 'IL', '61736', '40.3996', '-88.8212');
INSERT INTO `net_city` VALUES ('46061', '23', 'Синбар', 'Cinebar', 'WA', '98533', '46.5910', '-122.5149');
INSERT INTO `net_city` VALUES ('46065', '23', 'Тревортон', 'Trevorton', 'PA', '17881', '40.7861', '-76.6729');
INSERT INTO `net_city` VALUES ('46066', '23', 'Миллер Сити', 'Miller City', 'OH', '45864', '41.1028', '-84.1313');
INSERT INTO `net_city` VALUES ('46070', '23', 'Джулиаетта', 'Juliaetta', 'ID', '83535', '46.5561', '-116.7465');
INSERT INTO `net_city` VALUES ('46071', '23', 'Кингфилд', 'Kingfield', 'ME', '04947', '45.0293', '-70.2579');
INSERT INTO `net_city` VALUES ('46072', '23', 'Солон', 'Solon', 'ME', '04979', '44.9435', '-69.8071');
INSERT INTO `net_city` VALUES ('46073', '23', 'Сент-Олбанс', 'Saint Albans', 'ME', '04971', '44.9330', '-69.3904');
INSERT INTO `net_city` VALUES ('46075', '23', 'Ванлю', 'Vanlue', 'OH', '45890', '40.9838', '-83.4948');
INSERT INTO `net_city` VALUES ('46080', '23', 'Ликсвилл', 'Leakesville', 'MS', '39451', '31.1535', '-88.6858');
INSERT INTO `net_city` VALUES ('46084', '23', 'Блдсо', 'Bledsoe', 'KY', '40810', '36.9289', '-83.3095');
INSERT INTO `net_city` VALUES ('46089', '23', 'Оуэн', 'Owen', 'WI', '54460', '44.9586', '-90.5539');
INSERT INTO `net_city` VALUES ('46092', '23', 'Санберг', 'Sunburg', 'MN', '56289', '45.3257', '-95.1088');
INSERT INTO `net_city` VALUES ('46094', '23', 'Кингсленд', 'Kingsland', 'AR', '71652', '33.9195', '-92.3170');
INSERT INTO `net_city` VALUES ('46097', '23', 'Арпин', 'Arpin', 'WI', '54410', '44.5470', '-90.0326');
INSERT INTO `net_city` VALUES ('46098', '21', 'Хартуэлл', 'Hartwell', 'J1', '', '52.1333', '-0.8500');
INSERT INTO `net_city` VALUES ('46099', '23', 'Ошелата', 'Ochelata', 'OK', '74051', '36.6249', '-95.9607');
INSERT INTO `net_city` VALUES ('46111', '23', 'Уайтс Сити', 'Whites City', 'NM', '88268', '32.1757', '-104.3766');
INSERT INTO `net_city` VALUES ('46112', '23', 'Мертенс', 'Mertens', 'TX', '76666', '32.0509', '-96.8876');
INSERT INTO `net_city` VALUES ('46114', '23', 'Энсино', 'Encino', 'NM', '88321', '34.6510', '-105.6090');
INSERT INTO `net_city` VALUES ('46117', '58', 'Понта-Гроса', 'Ponta Grossa', '18', '', '-25.0833', '-50.1500');
INSERT INTO `net_city` VALUES ('46122', '23', 'Айворитон', 'Ivoryton', 'CT', '06442', '41.3447', '-72.4446');
INSERT INTO `net_city` VALUES ('46130', '24', 'Милвертон', 'Milverton', 'ON', 'n0k1m0', '43.5670', '-80.9207');
INSERT INTO `net_city` VALUES ('46137', '1', 'Бандаберг', 'Bundaberg', '04', '', '-24.8662', '152.3479');
INSERT INTO `net_city` VALUES ('46138', '13', 'Варезе', 'Varese', '09', '', '45.8000', '8.8333');
INSERT INTO `net_city` VALUES ('46145', '23', 'Татл', 'Tuttle', 'OK', '73089', '35.2612', '-97.7947');
INSERT INTO `net_city` VALUES ('46148', '23', 'Атаскоса', 'Atascosa', 'TX', '78002', '29.2813', '-98.7356');
INSERT INTO `net_city` VALUES ('46156', '23', 'Моррис', 'Morrice', 'MI', '48857', '42.8497', '-84.1454');
INSERT INTO `net_city` VALUES ('46158', '23', 'Дикивилл', 'Dickeyville', 'WI', '53808', '42.6272', '-90.5921');
INSERT INTO `net_city` VALUES ('46175', '24', 'Нануз-Бэй', 'Nanoose Bay', 'BC', 'v8m4s9', '49.2500', '-124.1833');
INSERT INTO `net_city` VALUES ('46279', '23', 'Грувер', 'Gruver', 'TX', '79040', '36.2905', '-101.5351');
INSERT INTO `net_city` VALUES ('46286', '23', 'Ханкамер', 'Hankamer', 'TX', '77560', '29.8616', '-94.5939');
INSERT INTO `net_city` VALUES ('46291', '23', 'Кимберли', 'Kimberly', 'WI', '54136', '44.2680', '-88.3376');
INSERT INTO `net_city` VALUES ('46294', '23', 'Хинтон', 'Hinton', 'OK', '73047', '35.4356', '-98.3178');
INSERT INTO `net_city` VALUES ('46297', '23', 'Феррисберг', 'Ferrysburg', 'MI', '49409', '43.0845', '-86.2203');
INSERT INTO `net_city` VALUES ('46299', '23', 'Браунтаун', 'Browntown', 'WI', '53522', '42.5632', '-89.7912');
INSERT INTO `net_city` VALUES ('46300', '23', 'Мердок', 'Murdock', 'MN', '56271', '45.2462', '-95.4148');
INSERT INTO `net_city` VALUES ('46333', '23', 'Одана', 'Odanah', 'WI', '54861', '46.6083', '-90.6968');
INSERT INTO `net_city` VALUES ('46334', '23', 'Ромни', 'Romney', 'IN', '47981', '40.2486', '-86.9207');
INSERT INTO `net_city` VALUES ('46335', '23', 'Скандия', 'Scandia', 'KS', '66966', '39.7771', '-97.7531');
INSERT INTO `net_city` VALUES ('46336', '23', 'Хокси', 'Hoxie', 'KS', '67740', '39.3569', '-100.3863');
INSERT INTO `net_city` VALUES ('46338', '23', 'Стетсон', 'Stetson', 'ME', '04488', '44.8770', '-69.1113');
INSERT INTO `net_city` VALUES ('46339', '23', 'Низс', 'Neeses', 'SC', '29107', '33.5203', '-81.1129');
INSERT INTO `net_city` VALUES ('46353', '23', 'Рашмор', 'Rushmore', 'MN', '56168', '43.6304', '-95.7943');
INSERT INTO `net_city` VALUES ('46356', '23', 'Галиен', 'Galien', 'MI', '49113', '41.8115', '-86.4916');
INSERT INTO `net_city` VALUES ('46357', '23', 'Рейвилл', 'Rayville', 'MO', '64084', '39.3840', '-94.0636');
INSERT INTO `net_city` VALUES ('46359', '23', 'Эдинберг', 'Edinburg', 'IL', '62531', '39.6614', '-89.3566');
INSERT INTO `net_city` VALUES ('46364', '23', 'Ист Орлинс', 'East Orleans', 'MA', '02643', '41.7851', '-69.9703');
INSERT INTO `net_city` VALUES ('46365', '23', 'Берни', 'Burney', 'CA', '96013', '40.9426', '-121.7461');
INSERT INTO `net_city` VALUES ('46367', '23', 'Бургун', 'Burgoon', 'OH', '43407', '41.2788', '-83.2451');
INSERT INTO `net_city` VALUES ('46368', '23', 'Синтиана', 'Cynthiana', 'IN', '47612', '38.2067', '-87.7002');
INSERT INTO `net_city` VALUES ('46372', '23', 'Пентуотер', 'Pentwater', 'MI', '49449', '43.7922', '-86.3664');
INSERT INTO `net_city` VALUES ('46373', '23', 'Перкинсвилл', 'Perkinsville', 'VT', '05151', '43.3907', '-72.4742');
INSERT INTO `net_city` VALUES ('46378', '56', 'Де-Хан', 'De Haan', '09', '', '51.2667', '3.0333');
INSERT INTO `net_city` VALUES ('46379', '59', 'Гольдау', 'Goldau', '17', '', '47.0489', '8.5495');
INSERT INTO `net_city` VALUES ('46382', '18', 'Трикала', 'Trikala', '22', '', '39.5553', '21.7675');
INSERT INTO `net_city` VALUES ('46385', '23', 'Рири', 'Ririe', 'ID', '83443', '43.4995', '-111.5892');
INSERT INTO `net_city` VALUES ('46393', '25', 'Тлакепаке', 'Tlaquepaque', '14', '', '20.6500', '-103.3167');
INSERT INTO `net_city` VALUES ('46394', '23', 'Твин Окс', 'Twin Oaks', 'OK', '74368', '36.2031', '-94.8420');
INSERT INTO `net_city` VALUES ('46399', '23', 'Ром', 'Rhome', 'TX', '76078', '33.1013', '-97.4771');
INSERT INTO `net_city` VALUES ('46400', '59', 'Кур', 'Chur', '09', '', '46.8568', '9.5269');
INSERT INTO `net_city` VALUES ('46407', '23', 'Дана', 'Dana', 'IN', '47847', '39.8373', '-87.4711');
INSERT INTO `net_city` VALUES ('46412', '13', 'Варзо', 'Varzo', '09', '', '46.2000', '8.2500');
INSERT INTO `net_city` VALUES ('46413', '2', 'Пучонг', 'Puchong', '12', '', '3.0167', '101.6167');
INSERT INTO `net_city` VALUES ('46414', '12', 'Обань', 'Aubagne', 'B8', '', '43.2910', '5.5868');
INSERT INTO `net_city` VALUES ('46418', '11', 'Ханой', 'Hanoi', '44', '', '21.0333', '105.8500');
INSERT INTO `net_city` VALUES ('46426', '23', 'Варшава', 'Warsaw', 'MO', '65355', '38.1763', '-93.3194');
INSERT INTO `net_city` VALUES ('46427', '23', 'Аспермонт', 'Aspermont', 'TX', '79502', '33.2093', '-100.2669');
INSERT INTO `net_city` VALUES ('46428', '23', 'Уитни', 'Whitney', 'TX', '76692', '31.9522', '-97.3459');
INSERT INTO `net_city` VALUES ('46432', '23', 'Асотин', 'Asotin', 'WA', '99402', '46.1759', '-117.1687');
INSERT INTO `net_city` VALUES ('46434', '23', 'Саммерсвилл', 'Summersville', 'MO', '65571', '37.1918', '-91.5927');
INSERT INTO `net_city` VALUES ('46446', '23', 'Монтморенси', 'Montmorenci', 'IN', '47962', '40.4742', '-87.0295');
INSERT INTO `net_city` VALUES ('46450', '23', 'Бримли', 'Brimley', 'MI', '49715', '46.3849', '-84.6997');
INSERT INTO `net_city` VALUES ('46451', '23', 'Бедфорд Парк', 'Bedford Park', 'IL', '60499', '41.7628', '-87.8001');
INSERT INTO `net_city` VALUES ('46467', '23', 'Карнелиан Бэй', 'Carnelian Bay', 'CA', '96140', '39.2273', '-120.0886');
INSERT INTO `net_city` VALUES ('46469', '23', 'Браунстаун', 'Brownstown', 'IL', '62418', '39.0201', '-88.9686');
INSERT INTO `net_city` VALUES ('46477', '23', 'Фонтейн Сити', 'Fountain City', 'WI', '54629', '44.1602', '-91.6819');
INSERT INTO `net_city` VALUES ('46480', '23', 'Уорренс', 'Warrens', 'WI', '54666', '44.1645', '-90.4263');
INSERT INTO `net_city` VALUES ('46482', '23', 'Льюис', 'Lewis', 'CO', '81327', '37.5496', '-108.6366');
INSERT INTO `net_city` VALUES ('46483', '23', 'Джонсберг', 'Jonesburg', 'MO', '63351', '38.8627', '-91.3236');
INSERT INTO `net_city` VALUES ('46484', '23', 'Ведоуи', 'Wedowee', 'AL', '36278', '33.3424', '-85.5103');
INSERT INTO `net_city` VALUES ('46486', '23', 'Холсвилл', 'Hallsville', 'MO', '65255', '39.0892', '-92.2381');
INSERT INTO `net_city` VALUES ('46489', '23', 'Рокуэй Бич', 'Rockaway Beach', 'MO', '65740', '36.7144', '-93.1617');
INSERT INTO `net_city` VALUES ('46513', '23', 'Пирс Сити', 'Pierce City', 'MO', '65723', '36.9592', '-93.9986');
INSERT INTO `net_city` VALUES ('46515', '23', 'Харристаун', 'Harristown', 'IL', '62537', '39.8539', '-89.0840');
INSERT INTO `net_city` VALUES ('46520', '24', 'Нантон', 'Nanton', 'AB', 't0l1r0', '50.3500', '-113.7667');
INSERT INTO `net_city` VALUES ('46521', '24', 'Ханна', 'Hanna', 'AB', 't0j1p0', '51.6333', '-111.9167');
INSERT INTO `net_city` VALUES ('46526', '24', 'Элк Пойнт', 'Elk Point', 'AB', 't0a1a0', '53.9000', '-110.9000');
INSERT INTO `net_city` VALUES ('46529', '23', 'Ридждейл', 'Ridgedale', 'MO', '65739', '36.5230', '-93.2649');
INSERT INTO `net_city` VALUES ('46531', '23', 'Глен Флора', 'Glen Flora', 'WI', '54526', '45.5099', '-90.8437');
INSERT INTO `net_city` VALUES ('46543', '142', 'Ардия', 'Ardiyah', '02', '', '29.3436', '47.9461');
INSERT INTO `net_city` VALUES ('46546', '24', 'Вермиллион', 'Vermillion', 'AB', 't9x1l4', '49.8500', '-93.3833');
INSERT INTO `net_city` VALUES ('46558', '23', 'Франсстаун', 'Francestown', 'NH', '03043', '42.9917', '-71.8076');
INSERT INTO `net_city` VALUES ('46564', '23', 'Медоулендс', 'Meadowlands', 'MN', '55765', '47.1285', '-92.8542');
INSERT INTO `net_city` VALUES ('46565', '23', 'Баклин', 'Bucklin', 'KS', '67834', '37.5551', '-99.6301');
INSERT INTO `net_city` VALUES ('46593', '23', 'Шинглтаун', 'Shingletown', 'CA', '96088', '40.5035', '-121.8089');
INSERT INTO `net_city` VALUES ('46643', '23', 'Окдейл', 'Oakdale', 'WI', '54649', '43.9597', '-90.3818');
INSERT INTO `net_city` VALUES ('46651', '45', 'Салатига', 'Salatiga', '07', '', '-7.3214', '110.5078');
INSERT INTO `net_city` VALUES ('46652', '54', 'Кхулна', 'Khulna', '82', '', '22.8000', '89.5500');
INSERT INTO `net_city` VALUES ('46654', '45', 'Пеканбару', 'Pekanbaru', '19', '', '0.5333', '101.4500');
INSERT INTO `net_city` VALUES ('46666', '18', 'Линдос', 'Líndos', '47', '', '36.0906', '28.0844');
INSERT INTO `net_city` VALUES ('46668', '23', 'Вассар', 'Vassar', 'MI', '48768', '43.3655', '-83.5658');
INSERT INTO `net_city` VALUES ('46670', '23', 'Фэруотер', 'Fairwater', 'WI', '53931', '43.7423', '-88.8681');
INSERT INTO `net_city` VALUES ('46671', '23', 'Рейнбек', 'Reinbeck', 'IA', '50669', '42.3471', '-92.6411');
INSERT INTO `net_city` VALUES ('46685', '23', 'Пот', 'Poth', 'TX', '78147', '29.0531', '-98.0558');
INSERT INTO `net_city` VALUES ('46686', '23', 'Ниппа', 'Knippa', 'TX', '78870', '29.3334', '-99.6228');
INSERT INTO `net_city` VALUES ('46688', '23', 'Утопиа', 'Utopia', 'TX', '78884', '29.6162', '-99.5295');
INSERT INTO `net_city` VALUES ('46691', '24', 'Лез Эскумэн', 'Les Escoumins', 'QC', 'g0t1k0', '48.3500', '-69.4167');
INSERT INTO `net_city` VALUES ('46707', '23', 'Шеррилл', 'Sherrill', 'AR', '72152', '34.3485', '-91.9767');
INSERT INTO `net_city` VALUES ('46719', '23', 'Хангерфорд', 'Hungerford', 'TX', '77448', '29.4023', '-96.0905');
INSERT INTO `net_city` VALUES ('46720', '23', 'Перри Пойнт', 'Perry Point', 'MD', '21902', '39.5543', '-76.0719');
INSERT INTO `net_city` VALUES ('46722', '23', 'Шуйлер', 'Schuyler', 'NE', '68661', '41.5070', '-97.0793');
INSERT INTO `net_city` VALUES ('46727', '23', 'Кирвин', 'Kirvin', 'TX', '75848', '31.7665', '-96.3303');
INSERT INTO `net_city` VALUES ('46734', '23', 'Бесси', 'Bessie', 'OK', '73622', '35.4000', '-98.9873');
INSERT INTO `net_city` VALUES ('46735', '23', 'Кловердейл', 'Cloverdale', 'MI', '49035', '42.5527', '-85.3852');
INSERT INTO `net_city` VALUES ('46737', '23', 'Фредерик', 'Frederic', 'MI', '49733', '44.7947', '-84.6855');
INSERT INTO `net_city` VALUES ('46739', '23', 'Ла Джойя', 'La Joya', 'TX', '78560', '26.2389', '-98.4861');
INSERT INTO `net_city` VALUES ('46740', '23', 'Каддо', 'Caddo', 'OK', '74729', '34.1534', '-96.2163');
INSERT INTO `net_city` VALUES ('46746', '23', 'Мохок', 'Mohawk', 'MI', '49950', '47.3472', '-88.1151');
INSERT INTO `net_city` VALUES ('46747', '23', 'Гленмора', 'Glenmora', 'LA', '71433', '31.0296', '-92.6434');
INSERT INTO `net_city` VALUES ('46754', '23', 'Нью Лексингтон', 'New Lexington', 'OH', '43764', '39.7102', '-82.1939');
INSERT INTO `net_city` VALUES ('46755', '23', 'Вермонтвилл', 'Vermontville', 'MI', '49096', '42.6410', '-85.0052');
INSERT INTO `net_city` VALUES ('46757', '23', 'Кинсли', 'Kinsley', 'KS', '67547', '37.9108', '-99.4831');
INSERT INTO `net_city` VALUES ('46759', '23', 'Мингус', 'Mingus', 'TX', '76463', '32.4583', '-98.4044');
INSERT INTO `net_city` VALUES ('46763', '23', 'Абли', 'Ubly', 'MI', '48475', '43.6689', '-82.9676');
INSERT INTO `net_city` VALUES ('46766', '23', 'Широ', 'Shiro', 'TX', '77876', '30.6133', '-95.8883');
INSERT INTO `net_city` VALUES ('46775', '23', 'Чилликот', 'Chillicothe', 'TX', '79225', '34.2371', '-99.4992');
INSERT INTO `net_city` VALUES ('46778', '23', 'Саут Вудсток', 'South Woodstock', 'CT', '06267', '41.9390', '-71.9595');
INSERT INTO `net_city` VALUES ('46809', '24', 'Уиартон', 'Wiarton', 'ON', 'n0h2t0', '44.7333', '-81.1333');
INSERT INTO `net_city` VALUES ('47091', '24', 'Сен-Жозеф-де-Камураска', 'Saint-joseph-de-kamouraska', 'QC', 'g0l3p0', '47.6167', '-69.6333');
INSERT INTO `net_city` VALUES ('47139', '24', 'Делиль', 'Delisle', 'QC', 'g0w1l0', '48.6333', '-71.7000');
INSERT INTO `net_city` VALUES ('47158', '23', 'Грандвью', 'Grandview', 'TX', '76050', '32.2749', '-97.1534');
INSERT INTO `net_city` VALUES ('47159', '23', 'Хелен', 'Helen', 'GA', '30545', '34.7368', '-83.7521');
INSERT INTO `net_city` VALUES ('47161', '23', 'Ирвинвилл', 'Irwinville', 'GA', '31760', '31.6482', '-83.3827');
INSERT INTO `net_city` VALUES ('47167', '23', 'Аткинсон', 'Atkinson', 'NE', '68713', '42.5579', '-98.9937');
INSERT INTO `net_city` VALUES ('47174', '23', 'Туэнтинин Палмс', 'Twentynine Palms', 'CA', '92277', '34.2438', '-115.8598');
INSERT INTO `net_city` VALUES ('47175', '23', 'Сотак', 'Saugatuck', 'MI', '49453', '42.6656', '-86.1742');
INSERT INTO `net_city` VALUES ('47178', '23', 'Девол', 'Devol', 'OK', '73531', '34.1907', '-98.5314');
INSERT INTO `net_city` VALUES ('47181', '23', 'Уоюкон', 'Waukon', 'IA', '52172', '43.2680', '-91.4777');
INSERT INTO `net_city` VALUES ('47182', '23', 'Уэллборн', 'Wellborn', 'FL', '32094', '30.1955', '-82.8279');
INSERT INTO `net_city` VALUES ('47186', '23', 'Мосли', 'Moseley', 'VA', '23120', '37.3995', '-77.7820');
INSERT INTO `net_city` VALUES ('47195', '23', 'Финливилл', 'Finleyville', 'PA', '15332', '40.2378', '-79.9842');
INSERT INTO `net_city` VALUES ('47198', '23', 'Эдгар', 'Edgar', 'WI', '54426', '44.9002', '-90.0192');
INSERT INTO `net_city` VALUES ('47201', '23', 'Оглторп', 'Oglethorpe', 'GA', '31068', '32.3410', '-84.1204');
INSERT INTO `net_city` VALUES ('47203', '23', 'Чикора', 'Chicora', 'PA', '16025', '40.9405', '-79.7517');
INSERT INTO `net_city` VALUES ('47204', '23', 'Миллен', 'Millen', 'GA', '30442', '32.7920', '-81.9934');
INSERT INTO `net_city` VALUES ('47209', '23', 'Маннсвилл', 'Mannsville', 'OK', '73447', '34.2597', '-96.8705');
INSERT INTO `net_city` VALUES ('47214', '23', 'Хилвью', 'Hillview', 'KY', '40129', '38.0698', '-85.6855');
INSERT INTO `net_city` VALUES ('47215', '23', 'Хелендейл', 'Helendale', 'CA', '92342', '34.7480', '-117.3504');
INSERT INTO `net_city` VALUES ('47217', '23', 'Силвердейл', 'Silverdale', 'PA', '18962', '40.3476', '-75.2710');
INSERT INTO `net_city` VALUES ('47218', '23', 'Иньокерн', 'Inyokern', 'CA', '93527', '35.8846', '-118.1522');
INSERT INTO `net_city` VALUES ('47223', '12', 'Антиб', 'Antibes', 'B8', '', '43.5624', '7.1278');
INSERT INTO `net_city` VALUES ('47230', '21', 'Чорли', 'Chorley', 'H2', '', '53.6500', '-2.6167');
INSERT INTO `net_city` VALUES ('47231', '23', 'Симсония', 'Symsonia', 'KY', '42082', '36.9194', '-88.5003');
INSERT INTO `net_city` VALUES ('47234', '21', 'Ливингстон', 'Livingston', 'W9', '', '55.8833', '-3.5333');
INSERT INTO `net_city` VALUES ('47237', '23', 'Тенино', 'Tenino', 'WA', '98589', '46.8427', '-122.8501');
INSERT INTO `net_city` VALUES ('47240', '24', 'Канмор', 'Canmore', 'AB', 't1w3h5', '51.1000', '-115.3500');
INSERT INTO `net_city` VALUES ('47241', '23', 'Гленелг', 'Glenelg', 'MD', '21737', '39.2484', '-77.0340');
INSERT INTO `net_city` VALUES ('47242', '1', 'Байрон-Бей', 'Byron Bay', '02', '', '-28.6420', '153.6119');
INSERT INTO `net_city` VALUES ('47245', '23', 'Малдун', 'Muldoon', 'TX', '78949', '29.8316', '-97.0802');
INSERT INTO `net_city` VALUES ('47246', '23', 'Ист Хартленд', 'East Hartland', 'CT', '06027', '42.0044', '-72.9104');
INSERT INTO `net_city` VALUES ('47249', '23', 'Велард', 'Velarde', 'NM', '87582', '36.1589', '-105.9747');
INSERT INTO `net_city` VALUES ('47253', '21', 'Солсбери', 'Salisbury', 'P8', '', '51.0667', '-1.7833');
INSERT INTO `net_city` VALUES ('47254', '23', 'Парксли', 'Parksley', 'VA', '23421', '37.7717', '-75.6335');
INSERT INTO `net_city` VALUES ('47258', '12', 'Эннри', 'Ennery', 'B2', '', '49.2262', '6.2180');
INSERT INTO `net_city` VALUES ('47263', '23', 'Бреттон Вудс', 'Bretton Woods', 'NH', '03575', '44.2581', '-71.4412');
INSERT INTO `net_city` VALUES ('47265', '7', 'Гаосюн', 'Kaohsiung', '04', '', '22.6333', '120.3500');
INSERT INTO `net_city` VALUES ('47267', '1', 'Банкрофт', 'Bancroft', '04', '', '-24.7833', '151.2333');
INSERT INTO `net_city` VALUES ('47269', '13', 'Фарнезе', 'Farnese', '07', '', '42.5500', '11.7167');
INSERT INTO `net_city` VALUES ('47289', '21', 'Кардифф', 'Cardiff', 'X5', '', '51.5000', '-3.2000');
INSERT INTO `net_city` VALUES ('47290', '23', 'Кеймар', 'Keymar', 'MD', '21757', '39.5993', '-77.2494');
INSERT INTO `net_city` VALUES ('47294', '23', 'Баксли', 'Baxley', 'GA', '31515', '31.7782', '-82.3485');
INSERT INTO `net_city` VALUES ('47295', '23', 'Паия', 'Paia', 'HI', '96779', '20.9088', '-156.3702');
INSERT INTO `net_city` VALUES ('47298', '23', 'Хумстон', 'Humeston', 'IA', '50123', '40.8316', '-93.5040');
INSERT INTO `net_city` VALUES ('47305', '24', 'Кардстон', 'Cardston', 'AB', 't0k0k0', '49.2000', '-113.3167');
INSERT INTO `net_city` VALUES ('47306', '23', 'Мосс Пойнт', 'Moss Point', 'MS', '39562', '30.5309', '-88.4999');
INSERT INTO `net_city` VALUES ('47312', '23', 'Юнион Дейл', 'Union Dale', 'PA', '18470', '41.7442', '-75.5328');
INSERT INTO `net_city` VALUES ('47313', '1', 'Миттагонг', 'Mittagong', '02', '', '-34.4500', '150.4457');
INSERT INTO `net_city` VALUES ('47316', '21', 'Уорик', 'Warwick', 'P3', '', '52.2833', '-1.5833');
INSERT INTO `net_city` VALUES ('47317', '24', 'Ярмут', 'Yarmouth', 'NS', 'b5a4b2', '43.8333', '-66.1167');
INSERT INTO `net_city` VALUES ('47325', '23', 'Марбери', 'Marbury', 'AL', '36051', '32.6625', '-86.4670');
INSERT INTO `net_city` VALUES ('47328', '23', 'Боудон', 'Bowdon', 'GA', '30108', '33.5281', '-85.2600');
INSERT INTO `net_city` VALUES ('47330', '25', 'Анауак', 'Anáhuac', '19', '', '27.2333', '-100.1500');
INSERT INTO `net_city` VALUES ('47339', '21', 'Брамптон', 'Brampton', 'C9', '', '54.9500', '-2.7333');
INSERT INTO `net_city` VALUES ('47341', '23', 'Ист Кларидон', 'East Claridon', 'OH', '44033', '41.5326', '-81.1157');
INSERT INTO `net_city` VALUES ('47343', '1', 'Порт Дуглас', 'Port Douglas', '04', '', '-16.4838', '145.4673');
INSERT INTO `net_city` VALUES ('47346', '23', 'Литл-Америка', 'Little America', 'WY', '82929', '41.5436', '-109.8590');
INSERT INTO `net_city` VALUES ('47352', '23', 'Байвабик', 'Biwabik', 'MN', '55708', '47.5330', '-92.3402');
INSERT INTO `net_city` VALUES ('47385', '23', 'Джал', 'Jal', 'NM', '88252', '32.1717', '-103.3563');
INSERT INTO `net_city` VALUES ('47401', '23', 'Уэйвленд', 'Waveland', 'MS', '39576', '30.2852', '-89.3783');
INSERT INTO `net_city` VALUES ('47422', '23', 'Мюррейвилл', 'Murrayville', 'GA', '30564', '34.4770', '-83.8622');
INSERT INTO `net_city` VALUES ('47432', '23', 'Миканопи', 'Micanopy', 'FL', '32667', '29.5200', '-82.3005');
INSERT INTO `net_city` VALUES ('47451', '23', 'Фрутхерст', 'Fruithurst', 'AL', '36262', '33.7899', '-85.4722');
INSERT INTO `net_city` VALUES ('47479', '29', 'Кайзерслаутерн', 'Kaiserslautern', '08', '', '49.4500', '7.7500');
INSERT INTO `net_city` VALUES ('47493', '23', 'Брандамор', 'Brandamore', 'PA', '19316', '40.0537', '-75.8199');
INSERT INTO `net_city` VALUES ('47537', '23', 'Тринидад', 'Trinidad', 'TX', '75163', '32.1601', '-96.0907');
INSERT INTO `net_city` VALUES ('47560', '23', 'Шортсвилл', 'Shortsville', 'NY', '14548', '42.9729', '-77.2489');
INSERT INTO `net_city` VALUES ('47561', '23', 'Пайни Пойнт', 'Piney Point', 'MD', '20674', '38.1194', '-76.4820');
INSERT INTO `net_city` VALUES ('47571', '23', 'Валхалла', 'Walhalla', 'SC', '29691', '34.7845', '-83.0878');
INSERT INTO `net_city` VALUES ('47574', '23', 'Фолс Виллидж', 'Falls Village', 'CT', '06031', '41.9470', '-73.3182');
INSERT INTO `net_city` VALUES ('47576', '23', 'Санрей', 'Sunray', 'TX', '79086', '36.0706', '-101.7530');
INSERT INTO `net_city` VALUES ('47577', '23', 'Трокмортон', 'Throckmorton', 'TX', '76483', '33.1777', '-99.2124');
INSERT INTO `net_city` VALUES ('47581', '23', 'Валли Милс', 'Valley Mills', 'TX', '76689', '31.6648', '-97.5274');
INSERT INTO `net_city` VALUES ('47597', '23', 'Норт Эгремонт', 'North Egremont', 'MA', '01252', '42.1968', '-73.4379');
INSERT INTO `net_city` VALUES ('47601', '21', 'Рипон', 'Ripon', 'Q5', '', '54.1167', '-1.5167');
INSERT INTO `net_city` VALUES ('47604', '24', 'Пауэлл Ривер', 'Powell River', 'BC', 'v8a4z2', '49.8833', '-124.5500');
INSERT INTO `net_city` VALUES ('47607', '23', 'Кельн', 'Cologne', 'NJ', '08213', '39.5048', '-74.6132');
INSERT INTO `net_city` VALUES ('47620', '23', 'Дженсен', 'Jensen', 'UT', '84035', '40.4718', '-109.2667');
INSERT INTO `net_city` VALUES ('47621', '23', 'Уайтрокс', 'Whiterocks', 'UT', '84085', '40.5527', '-109.9010');
INSERT INTO `net_city` VALUES ('47627', '23', 'Льюистон Вудвилл', 'Lewiston Woodville', 'NC', '27849', '36.0667', '-77.2230');
INSERT INTO `net_city` VALUES ('47633', '23', 'Холладей', 'Holladay', 'TN', '38341', '35.8675', '-88.0777');
INSERT INTO `net_city` VALUES ('47636', '25', 'Уискилукан', 'Huixquilucan', '15', '', '19.3603', '-99.3514');
INSERT INTO `net_city` VALUES ('47639', '23', 'Янгсвилл', 'Youngsville', 'LA', '70592', '30.0771', '-92.0137');
INSERT INTO `net_city` VALUES ('47642', '23', 'Кимберли', 'Kimberly', 'AL', '35091', '33.7715', '-86.8084');
INSERT INTO `net_city` VALUES ('47649', '23', 'Хефзиба', 'Hephzibah', 'GA', '30815', '33.2810', '-82.0743');
INSERT INTO `net_city` VALUES ('47651', '21', 'Данстейбл', 'Dunstable', 'A5', '', '51.8833', '-0.5167');
INSERT INTO `net_city` VALUES ('47657', '23', 'Опал', 'Opal', 'WY', '83124', '41.7405', '-110.1939');
INSERT INTO `net_city` VALUES ('47659', '25', 'Эрмосильо ', 'Hermosillo', '26', '', '29.0667', '-110.9667');
INSERT INTO `net_city` VALUES ('47660', '25', 'Сан-Хосе-дель-Кабо', 'San Jose del Cabo', '03', '', '23.0500', '-109.6833');
INSERT INTO `net_city` VALUES ('47664', '21', 'Хавант', 'Havant', 'F2', '', '50.8500', '-0.9833');
INSERT INTO `net_city` VALUES ('47665', '5', 'Нисиномия ', 'Nishinomiya', '13', '', '34.7167', '135.3333');
INSERT INTO `net_city` VALUES ('47667', '4', 'Гуанчжоу', 'Guangzhou', '30', '', '23.1167', '113.2500');
INSERT INTO `net_city` VALUES ('47668', '1', 'Туид Хедс', 'Tweed Heads', '02', '', '-28.1756', '153.5420');
INSERT INTO `net_city` VALUES ('47669', '1', 'Нора', 'Nowra', '02', '', '-34.8842', '150.6004');
INSERT INTO `net_city` VALUES ('47670', '21', 'Фарнем', 'Farnham', 'N7', '', '51.2000', '-0.8000');
INSERT INTO `net_city` VALUES ('47675', '23', 'Пелзер', 'Pelzer', 'SC', '29669', '34.6342', '-82.4211');
INSERT INTO `net_city` VALUES ('47677', '23', 'Уэбстер Сити', 'Webster City', 'IA', '50595', '42.4415', '-93.8258');
INSERT INTO `net_city` VALUES ('47680', '23', 'Кингс Бич', 'Kings Beach', 'CA', '96143', '39.2423', '-120.0426');
INSERT INTO `net_city` VALUES ('47685', '48', 'Коллингвуд', 'Collingwood', '00', '', '-40.6667', '172.6833');
INSERT INTO `net_city` VALUES ('47689', '23', 'Бризи Пойнт', 'Breezy Point', 'NY', '11697', '40.5620', '-73.9011');
INSERT INTO `net_city` VALUES ('47698', '23', 'Бонли', 'Bonlee', 'NC', '27213', '35.6460', '-79.4145');
INSERT INTO `net_city` VALUES ('47702', '23', 'Джэксонс Гэп', 'Jacksons Gap', 'AL', '36861', '32.8840', '-85.8264');
INSERT INTO `net_city` VALUES ('47706', '23', 'Барто', 'Barto', 'PA', '19504', '40.4030', '-75.5975');
INSERT INTO `net_city` VALUES ('47723', '24', 'Инглсайд', 'Ingleside', 'ON', 'k0c1m0', '45.0000', '-75.0000');
INSERT INTO `net_city` VALUES ('47744', '23', 'Мимс', 'Mims', 'FL', '32754', '28.7010', '-80.9319');
INSERT INTO `net_city` VALUES ('47748', '35', 'Паленсия', 'Palencia', '55', '', '42.0096', '-4.5241');
INSERT INTO `net_city` VALUES ('47749', '23', 'Понсе Де Леон', 'Ponce De Leon', 'FL', '32455', '30.6461', '-85.9916');
INSERT INTO `net_city` VALUES ('47800', '23', 'Родни', 'Rodney', 'MI', '49342', '43.6960', '-85.3281');
INSERT INTO `net_city` VALUES ('47814', '23', 'Маунт Тремпер', 'Mount Tremper', 'NY', '12457', '42.0517', '-74.2324');
INSERT INTO `net_city` VALUES ('47831', '23', 'Вашингтон Депо', 'Washington Depot', 'CT', '06794', '41.6475', '-73.3213');
INSERT INTO `net_city` VALUES ('47836', '31', 'Кочабамба', 'Cochabamba', '02', '', '-17.3833', '-66.1500');
INSERT INTO `net_city` VALUES ('47837', '23', 'Стелла', 'Stella', 'NC', '28582', '34.7574', '-77.1685');
INSERT INTO `net_city` VALUES ('47839', '25', 'Рейноса', 'Reynosa', '28', '', '26.0833', '-98.2833');
INSERT INTO `net_city` VALUES ('47843', '23', 'Ренсселаервилл', 'Rensselaerville', 'NY', '12147', '42.5016', '-74.1616');
INSERT INTO `net_city` VALUES ('47861', '1', 'Пайн Хилл', 'Pine Hill', '04', '', '-23.6500', '146.9667');
INSERT INTO `net_city` VALUES ('47863', '23', 'Лион', 'Lyons', 'NY', '14489', '43.0802', '-76.9767');
INSERT INTO `net_city` VALUES ('47866', '13', 'Латизана', 'Latisana', '06', '', '45.7792', '13.0000');
INSERT INTO `net_city` VALUES ('47892', '1', 'Баркли', 'Barkly', '07', '', '-36.9333', '143.2000');
INSERT INTO `net_city` VALUES ('47893', '25', 'Провиденсия', 'Providencia', '26', '', '28.7167', '-111.5833');
INSERT INTO `net_city` VALUES ('47894', '25', 'Вердес', 'Verdes', '24', '', '22.7833', '-100.7667');
INSERT INTO `net_city` VALUES ('47897', '1', 'Престон', 'Preston', '07', '', '-37.7500', '145.0167');
INSERT INTO `net_city` VALUES ('47903', '23', 'Солбери', 'Solebury', 'PA', '18963', '40.3807', '-75.0082');
INSERT INTO `net_city` VALUES ('47905', '23', 'Порт Юэн', 'Port Ewen', 'NY', '12466', '41.8764', '-73.9644');
INSERT INTO `net_city` VALUES ('47906', '23', 'Сандан', 'Sandown', 'NH', '03873', '42.9314', '-71.1851');
INSERT INTO `net_city` VALUES ('47908', '23', 'Лагуна Вудс', 'Laguna Woods', 'CA', '92637', '33.6103', '-117.7253');
INSERT INTO `net_city` VALUES ('47931', '21', 'Сохолл', 'Saughall', 'C5', '', '53.2167', '-2.95');
INSERT INTO `net_city` VALUES ('47932', '23', 'Ройалстон', 'Royalston', 'MA', '01368', '42.6685', '-72.1970');
INSERT INTO `net_city` VALUES ('47937', '21', 'Ньюкасл-апон-Тайн', 'Newcastle', 'I7', '', '54.9881', '-1.6194');
INSERT INTO `net_city` VALUES ('47938', '60', 'Гудвуд', 'Goodwood', '11', '', '-33.9049', '18.5488');
INSERT INTO `net_city` VALUES ('47942', '59', 'Ньон ', 'Nyon', '07', '', '46.3888', '6.2393');
INSERT INTO `net_city` VALUES ('47943', '21', 'Богемвуд', 'Borehamwood', 'F8', '', '51.6500', '-0.2667');
INSERT INTO `net_city` VALUES ('47948', '23', 'Джеймспорт', 'Jamesport', 'NY', '11947', '40.9495', '-72.5815');
INSERT INTO `net_city` VALUES ('47951', '23', 'Уилер', 'Wheeler', 'OR', '97147', '45.6890', '-123.8807');
INSERT INTO `net_city` VALUES ('47953', '23', 'Томалс', 'Tomales', 'CA', '94971', '38.2402', '-122.9067');
INSERT INTO `net_city` VALUES ('47955', '23', 'Уэверли Холл', 'Waverly Hall', 'GA', '31831', '32.6785', '-84.7018');
INSERT INTO `net_city` VALUES ('47956', '23', 'Роксбери', 'Roxbury', 'NY', '12474', '42.3089', '-74.5797');
INSERT INTO `net_city` VALUES ('47973', '123', 'Хунедоара', 'Hunedoara', '21', '', '45.7500', '22.9000');
INSERT INTO `net_city` VALUES ('47974', '58', 'Жуан-Песоа', 'Joao Pessoa', '17', '', '-7.1167', '-34.8667');
INSERT INTO `net_city` VALUES ('47976', '45', 'Бандунг', 'Bandung', '30', '', '-6.9039', '107.6186');
INSERT INTO `net_city` VALUES ('47979', '25', 'Акапулько', 'Acapulco', '12', '', '16.8500', '-99.9167');
INSERT INTO `net_city` VALUES ('47988', '23', 'Чилдресс', 'Childress', 'TX', '79201', '34.3673', '-100.3565');
INSERT INTO `net_city` VALUES ('47996', '23', 'Лампкин', 'Lumpkin', 'GA', '31815', '32.0356', '-84.8549');
INSERT INTO `net_city` VALUES ('47998', '23', 'Эль Рито', 'El Rito', 'NM', '87530', '36.4049', '-106.1888');
INSERT INTO `net_city` VALUES ('48000', '23', 'Шелокта', 'Shelocta', 'PA', '15774', '40.6582', '-79.3335');
INSERT INTO `net_city` VALUES ('48001', '48', 'Уэйтакер', 'Waitakere', '00', '', '-36.8500', '174.5500');
INSERT INTO `net_city` VALUES ('48002', '21', 'Тонбридж', 'Tonbridge', 'G5', '', '51.1833', '0.2833');
INSERT INTO `net_city` VALUES ('48004', '23', 'Капитан', 'Capitan', 'NM', '88316', '33.7826', '-105.2905');
INSERT INTO `net_city` VALUES ('48005', '23', 'Равия', 'Ravia', 'OK', '73455', '34.2403', '-96.7819');
INSERT INTO `net_city` VALUES ('48008', '23', 'Альмо', 'Almo', 'ID', '83312', '42.1002', '-113.6336');
INSERT INTO `net_city` VALUES ('48018', '23', 'Флаглер', 'Flagler', 'CO', '80815', '39.3825', '-103.1291');
INSERT INTO `net_city` VALUES ('48026', '23', 'Террал', 'Terral', 'OK', '73569', '33.9537', '-97.7674');
INSERT INTO `net_city` VALUES ('48057', '23', 'Садлер', 'Sadler', 'TX', '76264', '33.7415', '-96.8340');
INSERT INTO `net_city` VALUES ('48063', '23', 'Кросс Сити', 'Cross City', 'FL', '32628', '29.6245', '-83.1432');
INSERT INTO `net_city` VALUES ('48066', '23', 'Тчула', 'Tchula', 'MS', '39169', '33.1473', '-90.2857');
INSERT INTO `net_city` VALUES ('48068', '23', 'Клермон', 'Clermont', 'GA', '30527', '34.4787', '-83.7754');
INSERT INTO `net_city` VALUES ('48073', '23', 'Саттон', 'Sutton', 'NE', '68979', '40.5898', '-97.8526');
INSERT INTO `net_city` VALUES ('48074', '23', 'Адамс', 'Adams', 'NE', '68301', '40.4868', '-96.5272');
INSERT INTO `net_city` VALUES ('48077', '58', 'Петрополис', 'Petropolis', '21', '', '-22.5108', '-43.1844');
INSERT INTO `net_city` VALUES ('48078', '25', 'Саламанка', 'Salamanca', '11', '', '20.5667', '-101.2000');
INSERT INTO `net_city` VALUES ('48079', '25', 'Толука', 'Toluca', '15', '', '19.2883', '-99.6672');
INSERT INTO `net_city` VALUES ('48080', '25', 'Тустла-Гутьеррес', 'Tuxtla Gutierrez', '05', '', '16.7500', '-93.1167');
INSERT INTO `net_city` VALUES ('48081', '25', 'Вильяэрмоса', 'Villahermosa', '27', '', '17.9833', '-92.9167');
INSERT INTO `net_city` VALUES ('48082', '25', 'Халапа', 'Jalapa', '20', '', '16.5000', '-95.4667');
INSERT INTO `net_city` VALUES ('48084', '25', 'Куэрнавака ', 'Cuernavaca', '17', '', '18.9167', '-99.2500');
INSERT INTO `net_city` VALUES ('48085', '25', 'Торреон', 'Torreon', '07', '', '25.5500', '-103.4333');
INSERT INTO `net_city` VALUES ('48086', '25', 'Матаморос', 'Matamoros', '28', '', '25.8833', '-97.5000');
INSERT INTO `net_city` VALUES ('48087', '25', 'Ла-Пас', 'La Paz', '03', '', '24.1667', '-110.3000');
INSERT INTO `net_city` VALUES ('48088', '25', 'Селая', 'Celaya', '11', '', '20.5167', '-100.8167');
INSERT INTO `net_city` VALUES ('48089', '25', 'Масатлан', 'Mazatlan', '25', '', '23.2167', '-106.4167');
INSERT INTO `net_city` VALUES ('48090', '25', 'Кульякан', 'Culiacan', '25', '', '24.7994', '-107.3897');
INSERT INTO `net_city` VALUES ('48091', '25', 'Мехикали', 'Mexicali', '02', '', '32.6519', '-115.4683');
INSERT INTO `net_city` VALUES ('48093', '25', 'Хьютепек', 'Jiutepec', '17', '', '18.8667', '-99.1833');
INSERT INTO `net_city` VALUES ('48094', '25', 'Тампико', 'Tampico', '28', '', '22.3000', '-97.8500');
INSERT INTO `net_city` VALUES ('48095', '25', 'Тополобампо', 'Topolobampo', '25', '', '25.6000', '-109.0500');
INSERT INTO `net_city` VALUES ('48096', '25', 'Туспан', 'Tuxpan', '14', '', '19.5500', '-103.4000');
INSERT INTO `net_city` VALUES ('48099', '25', 'Пуэрто-Вальярта', 'Puerto Vallarta', '14', '', '20.6167', '-105.2500');
INSERT INTO `net_city` VALUES ('48100', '25', 'Потоси', 'Potosi', '19', '', '24.8500', '-100.3167');
INSERT INTO `net_city` VALUES ('48101', '25', 'Тепик', 'Tepic', '18', '', '21.5000', '-104.9000');
INSERT INTO `net_city` VALUES ('48103', '25', 'Сантьяго', 'Santiago', '19', '', '25.4167', '-100.1500');
INSERT INTO `net_city` VALUES ('48104', '25', 'Аподака', 'Apodaca', '19', '', '25.7667', '-100.2000');
INSERT INTO `net_city` VALUES ('48107', '25', 'Рамос Ариспе ', 'Ramos Arizpe', '07', '', '25.5500', '-100.9667');
INSERT INTO `net_city` VALUES ('48108', '25', 'Чапала', 'Chapala', '14', '', '20.3000', '-103.2000');
INSERT INTO `net_city` VALUES ('48109', '25', 'Тепатитлан', 'Tepatitlan', '14', '', '20.8167', '-102.7333');
INSERT INTO `net_city` VALUES ('48111', '25', 'Орисаба', 'Orizaba', '30', '', '18.8500', '-97.1000');
INSERT INTO `net_city` VALUES ('48112', '25', 'Пачука', 'Pachuca', '13', '', '20.1167', '-98.7333');
INSERT INTO `net_city` VALUES ('48113', '25', 'Ирапуато', 'Irapuato', '11', '', '20.6833', '-101.3500');
INSERT INTO `net_city` VALUES ('48115', '25', 'Хокотепек', 'Jocotepec', '14', '', '20.3000', '-103.4333');
INSERT INTO `net_city` VALUES ('48117', '25', 'Самора', 'Zamora', '16', '', '19.9833', '-102.2667');
INSERT INTO `net_city` VALUES ('48120', '25', 'Бока-дель-Рио', 'Boca Del Rio', '30', '', '19.1000', '-96.1000');
INSERT INTO `net_city` VALUES ('48121', '25', 'Теуакан ', 'Tehuacán', '21', '', '18.4500', '-97.3833');
INSERT INTO `net_city` VALUES ('48122', '25', 'Метепек', 'Metepec', '15', '', '19.2536', '-99.6078');
INSERT INTO `net_city` VALUES ('48126', '25', 'Санта-Катарина', 'Santa Catarina', '19', '', '25.6833', '-100.4667');
INSERT INTO `net_city` VALUES ('48127', '25', 'Лердо', 'Lerdo', '10', '', '25.5333', '-103.5333');
INSERT INTO `net_city` VALUES ('48129', '25', 'Уруапан', 'Uruapan', '16', '', '19.4167', '-102.0667');
INSERT INTO `net_city` VALUES ('48131', '25', 'Пуэнте-де-Истла', 'Puente De Ixtla', '17', '', '18.6167', '-99.3000');
INSERT INTO `net_city` VALUES ('48138', '25', 'Тультитлан', 'Tultitlan', '15', '', '19.6472', '-99.1708');
INSERT INTO `net_city` VALUES ('48145', '25', 'Монтеморелос', 'Montemorelos', '19', '', '25.2000', '-99.8167');
INSERT INTO `net_city` VALUES ('48148', '58', 'Сан-Жозе-дус-Кампус', 'São José Dos Campos', '27', '', '-23.1833', '-45.8833');
INSERT INTO `net_city` VALUES ('48149', '58', 'Кампина-Гранди', 'Campina Grande', '17', '', '-7.2167', '-35.8833');
INSERT INTO `net_city` VALUES ('48150', '38', 'Консепсьон', 'Concepcion', '06', '', '-36.8333', '-73.0500');
INSERT INTO `net_city` VALUES ('48151', '40', 'Сан-Хавьер', 'Ciudad Universitaria', '24', '', '-26.7833', '-65.3500');
INSERT INTO `net_city` VALUES ('48154', '40', 'Кильмес', 'Quilmes', '01', '', '-34.7242', '-58.2526');
INSERT INTO `net_city` VALUES ('48157', '226', 'Гавана', 'Habana', '07', '', '22.2514', '-78.9131');
INSERT INTO `net_city` VALUES ('48158', '40', 'Ла-Плата', 'La Plata', '01', '', '-34.9215', '-57.9545');
INSERT INTO `net_city` VALUES ('48161', '40', 'Санта-Роса', 'Santa Rosa', '11', '', '-36.6167', '-64.2833');
INSERT INTO `net_city` VALUES ('48162', '40', 'Вилья Хесель', 'Villa Gesell', '01', '', '-37.2695', '-56.9845');
INSERT INTO `net_city` VALUES ('48163', '130', 'Пуэбло Нуэво', 'Pueblo Nuevo', '02', '', '8.5667', '-82.4167');
INSERT INTO `net_city` VALUES ('48165', '163', 'Манисалес', 'Manizales', '07', '', '5.0689', '-75.5174');
INSERT INTO `net_city` VALUES ('48166', '175', 'Мерида', 'Mérida', '14', '', '8.5983', '-71.1450');
INSERT INTO `net_city` VALUES ('48167', '175', 'Кумана', 'Cumaná', '19', '', '10.4667', '-64.1667');
INSERT INTO `net_city` VALUES ('48168', '38', 'Ринконада', 'Rinconada', '07', '', '-30.0000', '-71.3333');
INSERT INTO `net_city` VALUES ('48169', '163', 'Вильявисенсьо', 'Villavicencio', '19', '', '4.1420', '-73.6266');
INSERT INTO `net_city` VALUES ('48170', '40', 'Трес Арройос', 'Tres Arroyos', '01', '', '-38.3739', '-60.2798');
INSERT INTO `net_city` VALUES ('48172', '40', 'Дель Висо', 'Del Viso', '01', '', '-34.4501', '-58.7878');
INSERT INTO `net_city` VALUES ('48174', '163', 'Попаян', 'Popayan', '12', '', '8.6703', '-76.2092');
INSERT INTO `net_city` VALUES ('48175', '38', 'Темуко', 'Temuco', '04', '', '-38.7333', '-72.6000');
INSERT INTO `net_city` VALUES ('48176', '38', 'Лос-Андес', 'Los Andes', '01', '', '-32.8333', '-70.6167');
INSERT INTO `net_city` VALUES ('48178', '40', 'Рафаэла', 'Rafaela', '21', '', '-31.2503', '-61.4867');
INSERT INTO `net_city` VALUES ('48180', '25', 'Тескоко', 'Texcoco', '15', '', '19.5167', '-98.8833');
INSERT INTO `net_city` VALUES ('48183', '58', 'Белен', 'Belem', '16', '', '-1.4500', '-48.4833');
INSERT INTO `net_city` VALUES ('48186', '58', 'Нитерой', 'Niteroi', '21', '', '-22.9021', '-43.1303');
INSERT INTO `net_city` VALUES ('48187', '58', 'Салвадор', 'Salvador', '05', '', '-12.9833', '-38.5167');
INSERT INTO `net_city` VALUES ('48188', '160', 'Портовьехо', 'Portoviejo', '14', '', '-1.0500', '-80.4500');
INSERT INTO `net_city` VALUES ('48189', '160', 'Лоха', 'Loja', '12', '', '-4.0000', '-79.2167');
INSERT INTO `net_city` VALUES ('48190', '160', 'Санголки', 'Sangolquí', '18', '', '-0.3167', '-78.4500');
INSERT INTO `net_city` VALUES ('48191', '58', 'Витория', 'Vitoria', '08', '', '-20.3167', '-40.3500');
INSERT INTO `net_city` VALUES ('48192', '160', 'Манта', 'Manta', '14', '', '-0.9500', '-80.7333');
INSERT INTO `net_city` VALUES ('48197', '173', 'Картаго', 'Cartago', '02', '', '9.8533', '-83.9023');
INSERT INTO `net_city` VALUES ('48198', '173', 'Алахуэла', 'Alajuela', '01', '', '10.0162', '-84.2116');
INSERT INTO `net_city` VALUES ('48201', '38', 'Эль Сальвадор', 'El Salvador', '05', '', '-26.2500', '-69.6167');
INSERT INTO `net_city` VALUES ('48203', '161', 'Кальяо', 'Callao', '07', '', '-12.0667', '-77.1500');
INSERT INTO `net_city` VALUES ('48206', '40', 'Ломас де Самора', 'Lomas De Zamora', '01', '', '-34.7609', '-58.4063');
INSERT INTO `net_city` VALUES ('48212', '40', 'Некочеа', 'Necochea', '01', '', '-38.5473', '-58.7368');
INSERT INTO `net_city` VALUES ('48214', '58', 'Франсиску-Белтран', 'Francisco Beltrão', '18', '', '-26.0833', '-53.0667');
INSERT INTO `net_city` VALUES ('48215', '58', 'Кастро', 'Castro', '18', '', '-24.7833', '-50.0000');
INSERT INTO `net_city` VALUES ('48217', '58', 'Маринга', 'Maringa', '18', '', '-23.4167', '-51.9167');
INSERT INTO `net_city` VALUES ('48219', '58', 'Фос-ду-Игуасу', 'Foz do Iguacu', '18', '', '-25.5500', '-54.5833');
INSERT INTO `net_city` VALUES ('48220', '58', 'Бруски', 'Brusque', '26', '', '-27.1000', '-48.9333');
INSERT INTO `net_city` VALUES ('48221', '58', 'Блуменау', 'Blumenau', '26', '', '-26.9222', '-49.0615');
INSERT INTO `net_city` VALUES ('48222', '40', 'Ривадавия', 'Rivadavia', '13', '', '-33.1905', '-68.4608');
INSERT INTO `net_city` VALUES ('48224', '58', 'Валиньюс', 'Valinhos', '27', '', '-22.9500', '-47.0167');
INSERT INTO `net_city` VALUES ('48225', '58', 'Итажаи', 'Itajaí', '26', '', '-26.8833', '-48.6500');
INSERT INTO `net_city` VALUES ('48226', '58', 'Жуис-ди-Фора', 'Juiz De Fora', '15', '', '-21.7517', '-43.3528');
INSERT INTO `net_city` VALUES ('48227', '58', 'Рондонополис', 'Rondonópolis', '14', '', '-16.4667', '-54.6333');
INSERT INTO `net_city` VALUES ('48228', '58', 'Куяба', 'Cuiabá', '14', '', '-15.5833', '-56.0833');
INSERT INTO `net_city` VALUES ('48229', '58', 'Паулиста', 'Paulista', '30', '', '-7.9500', '-34.8833');
INSERT INTO `net_city` VALUES ('48230', '58', 'Санта-Крус-ду-Сул', 'Santa Cruz Do Sul', '23', '', '-29.7167', '-52.4333');
INSERT INTO `net_city` VALUES ('48232', '58', 'Гояния', 'Goiânia', '29', '', '-16.6667', '-49.2667');
INSERT INTO `net_city` VALUES ('48233', '58', 'Масейо', 'Maceió', '02', '', '-9.6667', '-35.7167');
INSERT INTO `net_city` VALUES ('48235', '58', 'Порту-Велью', 'Porto Velho', '24', '', '-8.7667', '-63.9000');
INSERT INTO `net_city` VALUES ('48236', '58', 'Риу-Бранку', 'Rio Branco', '01', '', '-9.9667', '-67.8000');
INSERT INTO `net_city` VALUES ('48238', '58', 'Арикемис', 'Ariquemes', '24', '', '-9.9333', '-63.0667');
INSERT INTO `net_city` VALUES ('48240', '58', 'Нову-Амбургу', 'Novo Hamburgo', '23', '', '-29.6833', '-51.1333');
INSERT INTO `net_city` VALUES ('48242', '58', 'Кашиас-ду-Сул', 'Caxias do Sul', '23', '', '-29.1689', '-51.1785');
INSERT INTO `net_city` VALUES ('48250', '58', 'Торрис', 'Tôrres', '23', '', '-29.3500', '-49.7333');
INSERT INTO `net_city` VALUES ('48253', '58', 'Жарагуа-ду-Сул', 'Jaragua do Sul', '26', '', '-26.4833', '-49.0667');
INSERT INTO `net_city` VALUES ('48255', '58', 'Каскавел', 'Cascavel', '18', '', '-24.9500', '-53.4667');
INSERT INTO `net_city` VALUES ('48256', '58', 'Пиньяйс', 'Pinhais', '15', '', '-19.7167', '-43.8333');
INSERT INTO `net_city` VALUES ('48258', '58', 'Кампу-Гранди', 'Campo Grande', '11', '', '-20.4500', '-54.6167');
INSERT INTO `net_city` VALUES ('48261', '161', 'Инка', 'Inca', '10', '', '-9.3667', '-74.9667');
INSERT INTO `net_city` VALUES ('48262', '161', 'Лорето', 'Loreto', '18', '', '-17.5167', '-71.2333');
INSERT INTO `net_city` VALUES ('48265', '161', 'Чимботе', 'Chimbote', '02', '', '-9.0833', '-78.6000');
INSERT INTO `net_city` VALUES ('48267', '161', 'Уарас', 'Huaraz', '02', '', '-9.5333', '-77.5333');
INSERT INTO `net_city` VALUES ('48268', '161', 'Трухильо', 'Trujillo', '13', '', '-8.1167', '-79.0333');
INSERT INTO `net_city` VALUES ('48269', '161', 'Кахамарка', 'Cajamarca', '06', '', '-7.1667', '-78.5167');
INSERT INTO `net_city` VALUES ('48270', '161', 'Пьюра', 'Piura', '20', '', '-5.2000', '-80.6333');
INSERT INTO `net_city` VALUES ('48271', '161', 'Пуно', 'Puno', '21', '', '-15.8333', '-70.0333');
INSERT INTO `net_city` VALUES ('48272', '161', 'Такна', 'Tacna', '23', '', '-18.0056', '-70.2483');
INSERT INTO `net_city` VALUES ('48273', '161', 'Пукальпа', 'Pucallpa', '25', '', '-8.3825', '-74.5381');
INSERT INTO `net_city` VALUES ('48274', '161', 'Прогресо', 'Progreso', '21', '', '-13.6000', '-70.4333');
INSERT INTO `net_city` VALUES ('48276', '161', 'Паско', 'Pasco', '09', '', '-12.8667', '-74.7833');
INSERT INTO `net_city` VALUES ('48278', '57', 'Панама', 'Panama', '02', '', '17.3500', '-88.6833');
INSERT INTO `net_city` VALUES ('48279', '161', 'Икитос', 'Iquitos', '16', '', '-3.7481', '-73.2472');
INSERT INTO `net_city` VALUES ('48284', '40', 'Сантьяго-дель-Эстеро', 'Santiago Del Estero', '22', '', '-27.7951', '-64.2615');
INSERT INTO `net_city` VALUES ('48285', '40', 'Асуль ', 'Azul', '01', '', '-36.7770', '-59.8585');
INSERT INTO `net_city` VALUES ('48286', '40', 'Трелью', 'Trelew', '04', '', '-43.2501', '-65.3133');
INSERT INTO `net_city` VALUES ('48287', '40', 'Рио-Гальегос', 'Rio Gallegos', '20', '', '-51.6333', '-69.2167');
INSERT INTO `net_city` VALUES ('48290', '40', 'Манфреди', 'Manfredi', '05', '', '-31.8443', '-63.7472');
INSERT INTO `net_city` VALUES ('48291', '40', 'Оливерос', 'Oliveros', '21', '', '-32.5756', '-60.8524');
INSERT INTO `net_city` VALUES ('48292', '40', 'Реконкиста', 'Reconquista', '21', '', '-29.1500', '-59.6500');
INSERT INTO `net_city` VALUES ('48297', '40', 'Балькарсе', 'Balcarce', '01', '', '-37.8462', '-58.2552');
INSERT INTO `net_city` VALUES ('48298', '40', 'Консепсьон', 'Concepción', '22', '', '-27.9333', '-63.6333');
INSERT INTO `net_city` VALUES ('48301', '40', 'Иларио', 'Hilario', '18', '', '-31.4817', '-69.4077');
INSERT INTO `net_city` VALUES ('48308', '170', 'Ла Романа', 'La Romana', '12', '', '18.4167', '-68.9667');
INSERT INTO `net_city` VALUES ('48309', '57', 'Ледивиль', 'Ladyville', '01', '', '17.5500', '-88.1167');
INSERT INTO `net_city` VALUES ('48311', '38', 'Калама', 'Calama', '03', '', '-22.4667', '-68.9333');
INSERT INTO `net_city` VALUES ('48314', '40', 'Неукен', 'Neuquen', '15', '', '-38.9500', '-68.0667');
INSERT INTO `net_city` VALUES ('48317', '40', 'Чакабуко', 'Chacabuco', '01', '', '-34.6417', '-60.4739');
INSERT INTO `net_city` VALUES ('48319', '40', 'Гуалегуайчу', 'Gualeguaychu', '08', '', '-33.0103', '-58.5142');
INSERT INTO `net_city` VALUES ('48321', '163', 'Энвигадо', 'Envigado', '02', '', '6.1706', '-75.5853');
INSERT INTO `net_city` VALUES ('48322', '31', 'Крус', 'Cruz', '07', '', '-20.9667', '-65.5667');
INSERT INTO `net_city` VALUES ('48323', '38', 'Антофагаста', 'Antofagasta', '03', '', '-23.6500', '-70.4000');
INSERT INTO `net_city` VALUES ('48324', '25', 'Аламос', 'Álamos', '26', '', '27.0167', '-108.9333');
INSERT INTO `net_city` VALUES ('48329', '58', 'Камасари', 'Camacari', '05', '', '-12.4833', '-38.2167');
INSERT INTO `net_city` VALUES ('48330', '58', 'Фейра-ди-Сантана', 'Feira De Santana', '05', '', '-12.2500', '-38.9500');
INSERT INTO `net_city` VALUES ('48333', '58', 'Ору-Прету', 'Ouro Prêto', '15', '', '-20.3833', '-43.5000');
INSERT INTO `net_city` VALUES ('48335', '58', 'Говернадор-Валадарис', 'Governador Valadares', '15', '', '-18.8500', '-41.9333');
INSERT INTO `net_city` VALUES ('48337', '25', 'Реформа', 'Reforma', '04', '', '18.1000', '-91.0167');
INSERT INTO `net_city` VALUES ('48340', '31', 'Тариха', 'Tarija', '09', '', '-21.5167', '-64.7500');
INSERT INTO `net_city` VALUES ('48342', '174', 'Санта-Текла', 'Santa Tecla', '05', '', '13.6769', '-89.2797');
INSERT INTO `net_city` VALUES ('48343', '174', 'Комалапа', 'Comalapa', '03', '', '14.1333', '-88.9500');
INSERT INTO `net_city` VALUES ('48344', '164', 'Йоро', 'Yoro', '18', '', '15.1333', '-87.1333');
INSERT INTO `net_city` VALUES ('48349', '58', 'Президенти-Пруденти', 'Presidente Prudente', '27', '', '-22.1167', '-51.3667');
INSERT INTO `net_city` VALUES ('48350', '58', 'Лорена', 'Lorena', '27', '', '-22.7333', '-45.1333');
INSERT INTO `net_city` VALUES ('48351', '58', 'Жакареи', 'Jacarei', '27', '', '-23.3167', '-45.9667');
INSERT INTO `net_city` VALUES ('48353', '58', 'Сан-Карлус', 'Sao Carlos', '27', '', '-22.0167', '-47.9000');
INSERT INTO `net_city` VALUES ('48355', '58', 'Гуарульюс', 'Guarulhos', '27', '', '-23.4507', '-46.5262');
INSERT INTO `net_city` VALUES ('48356', '58', 'Натал', 'Natal', '22', '', '-5.7833', '-35.2167');
INSERT INTO `net_city` VALUES ('48357', '58', 'Терезина', 'Teresina', '20', '', '-5.0833', '-42.8167');
INSERT INTO `net_city` VALUES ('48358', '58', 'Медианейра', 'Medianeira', '18', '', '-25.2833', '-54.0833');
INSERT INTO `net_city` VALUES ('48361', '58', 'Тимбо', 'Timbó', '26', '', '-26.8333', '-49.3000');
INSERT INTO `net_city` VALUES ('48364', '58', 'Рондон', 'Rondon', '18', '', '-23.3833', '-52.8000');
INSERT INTO `net_city` VALUES ('48367', '58', 'Парнаиба', 'Parnaiba', '20', '', '-2.9092', '-41.7747');
INSERT INTO `net_city` VALUES ('48368', '58', 'Сианорти', 'Cianorte', '18', '', '-23.6167', '-52.6167');
INSERT INTO `net_city` VALUES ('48370', '58', 'Сан-Жозе-дус-Пиньяйс', 'Sao Jose dos Pinhais', '18', '', '-25.5167', '-49.2167');
INSERT INTO `net_city` VALUES ('48371', '58', 'Апукарана', 'Apucarana', '18', '', '-23.5500', '-51.4833');
INSERT INTO `net_city` VALUES ('48372', '58', 'Бела-Виста', 'Bela Vista', '11', '', '-22.1000', '-56.5167');
INSERT INTO `net_city` VALUES ('48375', '58', 'Паса-Куатру', 'Passa Quatro', '15', '', '-22.3833', '-44.9667');
INSERT INTO `net_city` VALUES ('48376', '58', 'Араруама', 'Araruama', '21', '', '-22.8833', '-42.3333');
INSERT INTO `net_city` VALUES ('48377', '58', 'Риу-дас-Острас', 'Rio Das Ostras', '21', '', '-22.5333', '-41.9500');
INSERT INTO `net_city` VALUES ('48378', '58', 'Нова-Фрибургу', 'Nova Friburgo', '21', '', '-22.2667', '-42.5333');
INSERT INTO `net_city` VALUES ('48379', '38', 'Эль-Сальто', 'El Salto', '07', '', '-29.4833', '-70.6000');
INSERT INTO `net_city` VALUES ('48383', '58', 'Пасу-Фунду', 'Passo Fundo', '23', '', '-28.2667', '-52.4000');
INSERT INTO `net_city` VALUES ('48386', '58', 'Веганополис', 'Veranópolis', '23', '', '-28.9500', '-51.5500');
INSERT INTO `net_city` VALUES ('48389', '58', 'Граватаи', 'Gravataí', '23', '', '-29.9426', '-50.9933');
INSERT INTO `net_city` VALUES ('48392', '58', 'Бенту-Гонсалвис', 'Bento Goncalves', '23', '', '-29.1667', '-51.5167');
INSERT INTO `net_city` VALUES ('48396', '58', 'Можи-дас-Крузис', 'Mogi das Cruzes', '27', '', '-23.5167', '-46.1833');
INSERT INTO `net_city` VALUES ('48397', '58', 'Нова', 'Nova', '11', '', '-21.8667', '-56.5333');
INSERT INTO `net_city` VALUES ('48398', '58', 'Бауру', 'Bauru', '27', '', '-22.3167', '-49.0667');
INSERT INTO `net_city` VALUES ('48399', '58', 'Сантус', 'Santos', '27', '', '-23.9500', '-46.3333');
INSERT INTO `net_city` VALUES ('48401', '58', 'Жуанвиль', 'Joinville', '26', '', '-26.3000', '-48.8333');
INSERT INTO `net_city` VALUES ('48410', '58', 'Сумаре', 'Sumaré', '27', '', '-22.8000', '-47.2833');
INSERT INTO `net_city` VALUES ('48411', '58', 'Лимейра', 'Limeira', '27', '', '-22.5617', '-47.4028');
INSERT INTO `net_city` VALUES ('48413', '58', 'Сорокаба', 'Sorocaba', '27', '', '-23.4833', '-47.4500');
INSERT INTO `net_city` VALUES ('48416', '58', 'Озаску', 'Osasco', '27', '', '-23.5667', '-46.7833');
INSERT INTO `net_city` VALUES ('48417', '58', 'Жагуариуна', 'Jaguariuna', '27', '', '-22.6833', '-46.9833');
INSERT INTO `net_city` VALUES ('48421', '58', 'Санту-Андре', 'Santo Andre', '27', '', '-23.6667', '-46.5167');
INSERT INTO `net_city` VALUES ('48422', '58', 'Диадема', 'Diadema', '27', '', '-23.7000', '-46.6167');
INSERT INTO `net_city` VALUES ('48423', '58', 'Сан-Висенти', 'Sao Vicente', '27', '', '-23.9667', '-46.3833');
INSERT INTO `net_city` VALUES ('48424', '58', 'Индаятуба', 'Indaiatuba', '27', '', '-23.0833', '-47.2333');
INSERT INTO `net_city` VALUES ('48428', '58', 'Итараре', 'Itararé', '27', '', '-24.1167', '-49.3333');
INSERT INTO `net_city` VALUES ('48429', '58', 'Крузейру', 'Cruzeiro', '27', '', '-22.5667', '-44.9667');
INSERT INTO `net_city` VALUES ('48430', '58', 'Баруэри', 'Barueri', '27', '', '-23.5167', '-46.8833');
INSERT INTO `net_city` VALUES ('48433', '58', 'Сан-Педру-да-Алдея', 'São Pedro Da Aldeia', '21', '', '-22.8500', '-42.1000');
INSERT INTO `net_city` VALUES ('48435', '58', 'Позу-Алегри', 'Pouso Alegre', '15', '', '-22.2167', '-45.9333');
INSERT INTO `net_city` VALUES ('48438', '58', 'Сакуарема', 'Saquarema', '21', '', '-22.9333', '-42.5000');
INSERT INTO `net_city` VALUES ('48441', '58', 'Дуки-ди-Кашиас', 'Duque de Caxias', '21', '', '-22.7903', '-43.3250');
INSERT INTO `net_city` VALUES ('48443', '58', 'Васорас', 'Vassouras', '21', '', '-22.4061', '-43.6642');
INSERT INTO `net_city` VALUES ('48444', '38', 'Икике', 'Iquique', '13', '', '-20.2208', '-70.1431');
INSERT INTO `net_city` VALUES ('48446', '58', 'Санта-Исабель', 'Santa Isabel', '27', '', '-23.3158', '-46.2241');
INSERT INTO `net_city` VALUES ('48447', '58', 'Лоанда', 'Loanda', '18', '', '-22.9000', '-53.1667');
INSERT INTO `net_city` VALUES ('48449', '58', 'Кабу-Фриу', 'Cabo Frio', '21', '', '-22.8833', '-42.0167');
INSERT INTO `net_city` VALUES ('48452', '58', 'Дескалваду', 'Descalvado', '27', '', '-21.9000', '-47.6167');
INSERT INTO `net_city` VALUES ('48453', '58', 'Рибейран-Прету', 'Ribeirao Preto', '27', '', '-21.1667', '-47.8000');
INSERT INTO `net_city` VALUES ('48459', '58', 'Риу-Прету', 'Rio Preto', '27', '', '-20.8000', '-49.3833');
INSERT INTO `net_city` VALUES ('48461', '58', 'Американа', 'Americana', '27', '', '-22.7403', '-47.3344');
INSERT INTO `net_city` VALUES ('48462', '58', 'Аваре', 'Avaré', '27', '', '-23.0833', '