<?php
require_once './config.php';
require_once './core/PhpImap/__autoload.php';
require_once './options.php';
require_once './functions.php';
session_start();
error_reporting(E_ALL);
$action = filter_input(INPUT_GET, 'action', FILTER_SANITIZE_STRING);
if ( $action == "delete" ) {
    if($option['ssl'] == "yes") {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/ssl}INBOX', $config['user'], $config['pass'], __DIR__);
    } else {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/novalidate-cert}INBOX', $config['user'], $config['pass'], __DIR__);
    }
    $mailID = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
    $mailID = preg_replace('/[^0-9.]+/', '', $mailID);
    $attachmentsDir = "attachments/".$_SESSION['address']."/".$mailID;
    if (!file_exists($attachmentsDir)) {
        mkdir($attachmentsDir, 0777, true);
        file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    $mailbox->setAttachmentsDir($attachmentsDir);
    $mail = $mailbox->getMail($mailID);
    $mailAddress = $mail->toString;
    if((strpos($mailAddress, $_SESSION['address']) !== false)) {
        if($mailbox->deleteMail($mailID)) {
            echo "true";
        } else {
            echo "false";
        }
    } else if (isset($_GET["email"]) && isset($_GET["apikey"])) {
        if(($config["api"] == "yes" && $mailAddress == $_GET["email"] && $config["apikey"] == $_GET["apikey"])) {
            if($mailbox->deleteMail($mailID)) {
                echo "true";
            } else {
                echo "false";
            }
        }
    } else {
        echo "UnAuthorized";
    }
} else if ( $action == "getUser" ) {
    echo $_SESSION['address'];
} else if ( $action == "download" ) {
    if($option['ssl'] == "yes") {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/ssl}INBOX', $config['user'], $config['pass'], __DIR__);
    } else {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/novalidate-cert}INBOX', $config['user'], $config['pass'], __DIR__);
    }
    $mailID = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
    $mailID = preg_replace('/[^0-9.]+/', '', $mailID);
    $attachmentsDir = "attachments/".$_SESSION['address']."/".$mailID;
    if (!file_exists($attachmentsDir)) {
        mkdir($attachmentsDir, 0777, true);
        file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    $mailbox->setAttachmentsDir($attachmentsDir);
    $mail = $mailbox->getMail($mailID);
    $mailAddress = $mail->toString;
    if((strpos($mailAddress, $_SESSION['address']) !== false)) {
        $filename = "downloads/".$_SESSION['address']."_".$mailID."_mail.eml";
        $mailbox->saveMail($mailID, $filename);
        $path = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        $path = dirname($path);
        if($config["api"] == "yes" && $mailAddress == $_GET["email"]) {
            header('location: '.$path."/".$filename);
            exit();
        }
        echo $path."/".$filename;
    } else if (isset($_GET["email"]) && isset($_GET["apikey"])) {
        if(($config["api"] == "yes" && $mailAddress == $_GET["email"] && $config["apikey"] == $_GET["apikey"])) {
            $filename = "downloads/".$_SESSION['address']."_".$mailID."_mail.eml";
            $mailbox->saveMail($mailID, $filename);
            $path = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            $path = dirname($path);
            if($config["api"] == "yes" && $mailAddress == $_GET["email"]) {
                header('location: '.$path."/".$filename);
                exit();
            }
            echo $path."/".$filename;
        }
    } else {
        echo "UnAuthorized";
    }
} else if ( $action == "refreshRate" ) {
    echo $option['refreshRate'];
} else if ( $action == "encode" ) {
    echo $option['encode'];
} else if ( $action == "pushNotifications" ) {
    if(isset($option['pushNotifications'])) {
        echo $option['pushNotifications'];
    } else {
        echo "no";
    }
} else if ( $action == "changeLang" ) {
    $_SESSION['lang'] = filter_input(INPUT_GET, 'lang', FILTER_SANITIZE_STRING);
} else if ( $action == "getCount" ) {
    if($option['ssl'] == "yes") {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/ssl}INBOX', $config['user'], $config['pass'], __DIR__);
    } else {
        $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/novalidate-cert}INBOX', $config['user'], $config['pass'], __DIR__);
    }
    if(isset($_SESSION["address"])) {
        $address = $_SESSION["address"];
        $toList = "TO ".$address;
        $ccList = "CC ".$address;
        $bccList = "BCC ".$address;
        $mailIdsTo = $mailbox->searchMailbox($toList);
        $mailIdsCc = $mailbox->searchMailbox($ccList);
        $mailIdsBcc = $mailbox->searchMailbox($bccList);
        $mailsIds = array_unique(array_merge($mailIdsTo,$mailIdsCc,$mailIdsBcc));
        if($mailsIds) {
            echo count($mailsIds);
        } else {
            echo "0";
        }
    } else {
        echo "0";   
    }
} else if ( $action == "saveEMails" ) {
    if(setcookie('tmail-emails', serialize($_SESSION["emails"]), time() + (86400 * 7), "/")) {
        echo "1";
    } else {
        echo "0";
    }
} else if ( $action == "clearEMails" ) {
    $_SESSION["emails"] = array();
    if(setcookie('tmail-emails', serialize($_SESSION["emails"]), time() + (86400 * 7), "/")) {
        echo "1";
    } else {
        echo "0";
    }
} else if ( $action == "deleteOldAttachments" ) {
    $folders = glob("attachments/*");
    $now = time();
    foreach ($folders as $folder) {
        if (is_dir($folder)) {
            if ($now - filemtime($folder) >= 60 * 60 * 24 * $option["deleteDays"]) {
                rrmdir($folder);
            }
        }
    }
} else if ( $action == "getDomains" ) {
    if($config["api"] == "yes" && $config["apikey"] == $_GET["apikey"]) {
        echo json_encode($config["domains"]);
    }
}

