<?php
require_once './config.php';
require_once './core/PhpImap/__autoload.php';
require_once './functions.php';
require_once './options.php';
date_default_timezone_set($option['timezone']);
if (isset($_SESSION['lang'])) {
    if ($_SESSION['lang'] != "") {
        require_once './lang/' . $_SESSION['lang'] . '.php';
    } else {
        require_once './lang/en.php';
    }
} else {
    require_once './lang/en.php';
}
session_start();
error_reporting(E_ALL);
$unseen = filter_input(INPUT_GET, 'unseen', FILTER_SANITIZE_STRING);
$count = 0;
if ($option['ssl'] == "yes") {
    $mailbox = new PhpImap\Mailbox('{' . $config['host'] . '/imap/ssl}INBOX', $config['user'], $config['pass'], __DIR__);
} else {
    $mailbox = new PhpImap\Mailbox('{' . $config['host'] . '/imap/novalidate-cert}INBOX', $config['user'], $config['pass'], __DIR__);
}
$address = "";
if (!isset($_SESSION["address"])) {
    if($config['api'] == "yes") {
        if(isset($_GET['email'])) {
            $address = $_GET['email'];
        } else {
            die("DIE");
        }
    } else {
        die("DIE");
    }
} else {
    $address = $_SESSION["address"];
}

$ids = $mailbox->searchMailbox('BEFORE ' . date('d-M-Y', strtotime($option['deleteDays'] . " days ago")));
foreach ($ids as $id) {
    $mailbox->deleteMail($id);
}
$mailbox->expungeDeletedMails();
$files = glob('downloads/*');
foreach ($files as $file) {
    if (is_file($file))
        unlink($file);
}
$toList = "TO " . $address;
$ccList = "CC " . $address;
$bccList = "BCC " . $address;
$mailIdsTo = $mailbox->searchMailbox($toList);
$mailIdsCc = $mailbox->searchMailbox($ccList);
$mailIdsBcc = $mailbox->searchMailbox($bccList);
$mailsIds = array_reverse(array_unique(array_merge($mailIdsTo, $mailIdsCc, $mailIdsBcc)));
if ($unseen == 1) {
    $unseenIds = $mailbox->searchMailbox("UNSEEN");
    $mailsIds = array_intersect($mailsIds, $unseenIds);
}
if($config['api'] == "yes" && isset($_GET['email'])) {
    if($config["apikey"] != $_GET["apikey"]) {
        exit("Access Denied");
    }
    $allmails = array();
    foreach ($mailsIds as $mailID) {
        $attachmentsDir = "attachments/".$address."/".$mailID;
        if (!file_exists($attachmentsDir)) {
            mkdir($attachmentsDir, 0777, true);
            file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        $mailbox->setAttachmentsDir($attachmentsDir);
        $mail = $mailbox->getMail($mailID);
        $mail->tmail_attachments = array();
        $path = dirname("http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
        $mail->tmail_delete_url = $path."/actions.php?action=delete&id=".$mailID."&email=".$address;
        $mail->tmail_download_url = $path."/actions.php?action=download&id=".$mailID."&email=".$address;
        if (is_dir($attachmentsDir)){
            if ($dh = opendir($attachmentsDir)){
                while (($file = readdir($dh)) !== false){
                    if ($file == '.' || $file == '..') {
                        continue;
                    }
                    $filePath = $attachmentsDir."/".$file;
                    $file = str_replace(".","",$file);
                    $path = $path."/".$filePath;
                    array_push($mail->tmail_attachments, array($file, $path));
                }
                closedir($dh);
            }
        }
        array_push($allmails, $mail);
    }
    exit(json_encode($allmails));
}
foreach ($mailsIds as $mailID) {
    $attachmentsDir = "attachments/".$address."/".$mailID;
    if (!file_exists($attachmentsDir)) {
        mkdir($attachmentsDir, 0777, true);
        file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    $mailbox->setAttachmentsDir($attachmentsDir);
    $mail = $mailbox->getMail($mailID);
    $mailTime = DateTime::createFromFormat("Y-m-d H:i:s", $mail->date);
    $timestamp = $mailTime->getTimestamp();
    $yesterdayTime = new DateTime('yesterday');
    $yesterdayTimeStamp = $yesterdayTime->getTimestamp();
    if (date('Ymd') == date('Ymd', $timestamp)) {
        $displayDateTime = $lang['today'];
    } else if (date('Ymd') == date('Ymd', $yesterdayTimeStamp)) {
        $displayDateTime = $lang['yesterday'];
    } else {
        $displayDateTime = date('d M y', $timestamp);
    }
    ?>
    <li class="tmail-email-list-li" id="tmail-email-list-<?php echo $mailID; ?>" onclick="showTMailBody(<?php echo $mailID; ?>)">
        <div class="clearfix">
            <div class="name">
                <?php
                if ($mail->fromName) {
                    echo $mail->fromName;
                } else {
                    echo $mail->fromAddress;
                }
                ?>
            </div>
            <div class="date"><?php echo $displayDateTime; ?></div>
        </div>
        <div class="subject"><?php echo $mail->subject; ?></div>
        <div class="body"><?php echo $mail->textPlain; ?></div>
    </li>
    <-----TMAILCHOPPER----->
    <div class="tmail-email-content-li" id="tmail-email-body-content-<?php echo $mailID; ?>">
        <center class="tmail-ads"><?php echo $option['ads']; ?></center>
        <div class="tmail-email-title"><?php echo $mail->subject ?></div>
        <div class="tmail-email-description clearfix">
            <div class="tmail-email-sender float-left"><?php if ($mail->fromName) {
                echo $mail->fromName . " - ";
            } echo $mail->fromAddress; ?></div>
            <div class="tmail-email-time float-right"><?php echo $mail->date; ?></div>
        </div>
        <div class="tmail-body-delete-download-icons clearfix">
            <div class="tmail-body-download-icon float-left" onclick="downloadMail('<?php echo $mailID; ?>')"><i class="fa fa-download" aria-hidden="true"></i></div>
            <div class="tmail-body-delete-icon float-left" onclick="deleteMail('<?php echo $mailID; ?>')"><i class="fa fa-trash" aria-hidden="true"></i></div>
        </div>
        <div class="tmail-email-body-content">
            <?php if ($mail->textHtml == "") { ?>
                <p><?php echo $mail->textPlain; ?></p>
            <?php } else { ?>
                <p><?php echo $mail->textHtml; ?></p>
            <?php } ?>
        </div>
            <?php 
            $attachmentCheck = true;
            if (is_dir($attachmentsDir)){
                if ($dh = opendir($attachmentsDir)){
                    while (($file = readdir($dh)) !== false){
                        if ($file == '.' || $file == '..') {
                            continue;
                        }
                        if($attachmentCheck) {
                            echo "<div class=\"tmail-email-attachments\">";
                            $attachmentCheck = false;
                        }
                        $filePath = $attachmentsDir."/".$file;
                        $file = str_replace(".","",$file);
                        ?>
                        <a href="<?php echo $filePath ?>" download><i class="fa fa-arrow-down" aria-hidden="true"></i> <?php echo $file; ?></a>
                        <?
                    }
                    if(!$attachmentCheck) {
                        echo "</div>";
                    }
                    closedir($dh);
                }
            }
            ?>
        <br><br>
    </div>
    <-----TMAILNEXTMAIL----->
    <?php
    $count++;
}
?>