<?php

//########################################
// holiday functions
// 0 = sunday
// 1 = monday
// 2 = tuesday
// 3 = wednesday
// 4 = thursday
// 5 = friday
// 6 = saturday
//########################################

function holiday_name($y, $m, $d)
{
	if ($m == 1 && $d == 1)	// jan 1
	return "New Year's Day";
	
	if ($m == 1 && match_day($y, $m, $d, 1, 3))	// 3rd mon in jan
	return "Martin Luther King Day";
	
	if ($m == 2 && $d == 14) // feb 14
	return "Valentine's Day";
	
	if ($m == 2 && match_day($y, $m, $d, 1, 3)) // 3rd mon in feb
	return "President's Day";
	
	if ($m == 3 && $d == 17) // mar 17
	return "St. Patrick's Day";	
	
	if ($m == 4 && $d == 1) // apr 1
	return "April's Fools Day";
	
	if ($m == 5 && $d == 5) // may 5
	return "Cinco De Mayo";
	
	if ($m == 5 && match_day($y, $m, $d, 0, 2)) // 2nd sun in may
	return "Mother's Day";
	
	if ($m == 5 && match_day($y, $m, $d, 1)) // last mon in may
	return "Memorial Day";
	
	if ($m == 6 && $d == 14) // jun 14
	return "Flag Day";
	
	if ($m == 6 && match_day($y, $m, $d, 0, 3)) // 3rd sun jun
	return "Father's Day";
	
	if ($m == 7 && $d == 4) // jul 4
	return "Independence Day";
	
	if ($m == 9 && match_day($y, $m, $d, 1, 1))	// 1st mon in sep
	return "Labor Day";
	
	if ($m == 10 && match_day($y, $m, $d, 1, 2)) // 2nd mon in oct
	return "Columbus Day";
	
	if ($m == 10 && $d == 31) // oct 31
	return "Halloween";
	
	if ($m == 11 && $d == 11) // nov 11
	return "Veteran's Day";
	
	if ($m == 11 && match_day($y, $m, $d, 4, 4)) // 4th thu in nov
	return "Thanksgiving";
	
	if ($m == 11 && match_day($y, $m, $d, 5, 4)) // 4th fri in nov
	return "Black Friday";
	
	if ($m == 11 && match_day($y, $m, $d, 1)) // last mon in nov
	return "Cyber Monday";
	
	if ($m == 12 && $d == 25) // dec 25
	return "Christmas Day";
	
	//##########
	// easter
	//##########
	
	if ($y == 2015 && $m == 4 && $d == 5) // easter
	return "Easter";	
	
	if ($y == 2016 && $m == 3 && $d == 27) // easter
	return "Easter"; 	
	
	if ($y == 2017 && $m == 4 && $d == 16) // easter
	return "Easter"; 
	
	if ($y == 2018 && $m == 4 && $d == 1) // easter
	return "Easter";
	
	if ($y == 2019 && $m == 4 && $d == 21) // easter
	return "Easter";
	
	if ($y == 2020 && $m == 4 && $d == 12) // easter
	return "Easter";
	
	if ($y == 2021 && $m == 4 && $d == 4) // easter
	return "Easter";				

	// return empty if no match for holiday
	return; 
}

function match_day($year, $month, $day, $day_of_week, $week='')
{
	if (!$week || ($week == ''))
	{
		$lastday = date('t', mktime(0, 0, 0, $month, 1, $year));
		$temp = (date('w', mktime(0, 0, 0, $month, $lastday, $year)) - $day_of_week) % 7;
	}
	else
	{
		$temp = ($day_of_week - date('w', mktime(0, 0, 0, $month, 1, $year))) % 7;
	}

	if ($temp < 0)
	{
		$temp += 7;
	}

	if (!$week || ($week == ''))
	{
		$target_day = $lastday - $temp;
	}
	else
	{
		$target_day = (7 * $week) - 6 + $temp;
	}

	return ($day == $target_day);
}