<?php

namespace Andy\BirthdayCalendar\Pub\Controller;

use XF\Pub\Controller\AbstractController;

class BirthdayCalendar extends AbstractController
{
    public function actionIndex()
    {
		//########################################
		// show the birthday calendar
		//########################################
		
		// get visitor
		$visitor = \XF::visitor();				
		
		// check for user group permission
		if (!$visitor->hasPermission('birthdayCalendar', 'view'))
		{
			return $this->noPermission();
		}
		
		// get options
		$options = \XF::options();	
		
		// get options from Admin CP -> Options -> Birthday calendar -> Last activity days
		$lastActivityDays = $options->birthdayCalendarLastActivityDays;
		
		// get options from Admin CP -> Options -> Birthday calendar -> Show holidays
		$showHolidays = $options->birthdayCalendarShowHolidays;
		
		// get options from Admin CP -> Options -> Birthday calendar -> Sunday first day of the week
		$sundayFirstDay = $options->birthdayCalendarSundayFirstDay;
		
		// get options from Admin CP -> Options -> Birthday calendar -> Holiday path
		$holidayPath = $options->birthdayCalendarHolidayPath;
		
		// get holiday.php
		if ($showHolidays)
		{
			if ($holidayPath != '')
			{
				if (!file_exists($holidayPath))
				{
					return $this->error('Birthday calendar holiday path set incorrectly.');
				}
				
				require_once($holidayPath);
			}
			else
			{
				require_once('Holiday.php');
			}
		}
		
		// get year
		$year = $this->filter('year', 'str');
		
		// get yearNarrow
		if ($year == '')
		{
			$year = $this->filter('yearNarrow', 'str');
		}
		
		// get month
		$month = $this->filter('month', 'str');
		
		// get monthNarrow
		if ($month == '')
		{
			$month = $this->filter('monthNarrow', 'str');
		}
		
		// get timezone
		$timezone = $visitor['timezone'];
		
		// set timezone
		date_default_timezone_set($timezone);
		
		// if not numeric set current year
		if (!is_numeric($year))
		{
			$year = date("Y", time());
		}
		
		// if not numeric set current month
		if (!is_numeric($month))
		{
			$month = date("m", time());
		}
	
		// get dataline
		$dateline = time() - (86400 * $lastActivityDays); 

		// get db
		$db = \XF::db();
		
		// run query	
		$members = $db->fetchAll("
		SELECT xf_user.user_id,
		xf_user.username,
		xf_user_profile.dob_day,
		xf_user_profile.dob_month
		FROM xf_user
		INNER JOIN xf_user_profile ON xf_user_profile.user_id = xf_user.user_id
		INNER JOIN xf_user_option ON xf_user_option.user_id = xf_user.user_id
		WHERE xf_user_profile.dob_month = ?
		AND xf_user.last_activity > ?
		AND xf_user.user_state = ?
		AND xf_user.is_banned = ?
		AND xf_user_option.show_dob_date = ?
		ORDER BY xf_user.username ASC
		", array($month, $dateline, 'valid', 0, 1));

		//########################################
		// start calendar
		//########################################	
		
 		// set variables
		$days_in_month = date('t',mktime(0,0,0,$month,1,$year));
		$days_in_this_week = 1;
		$day_counter = 0;
		$today = date('j', time());
		$current_month = date('m', time());
		$current_year = date('Y', time());
		$blankDays = array();
		$holidays = array();
		
		// sunday first day of week
		if ($sundayFirstDay == 1)
		{
			// the number of blank days at start of month
			$running_day = date('w',mktime(0,0,0,$month,1,$year));
		
			// used in template to determine <tr>
			$blankDaysStart = $running_day;
		}
		
		// monday first day of week
		if ($sundayFirstDay == 0)
		{
			// the number of blank days at start of month
			$running_day = date('w',mktime(0,0,0,$month,0,$year));
			
			// used in template to determine <tr>
			$blankDaysStart = $running_day;
		}
		
		// get blank days until the first day of the month
		for ($i=0; $i<$running_day; $i++)
		{
			$days_in_this_week++;
			
			$blankDays[] = array(
				'blankDays' => ''
			);
		}

		// keep going with days
		for ($list_day = 1; $list_day <= $days_in_month; $list_day++)
		{
			
			$dayOfWeek = date("l", mktime(0, 0, 0, $month, $list_day, $year));

			if ($dayOfWeek == 'Sunday')
			{
				$dayOfWeek = \XF::phrase('day_sunday');
			}

			if ($dayOfWeek == 'Monday')
			{
				$dayOfWeek = \XF::phrase('day_monday');
			}

			if ($dayOfWeek == 'Tuesday')
			{
				$dayOfWeek = \XF::phrase('day_tuesday');
			}

			if ($dayOfWeek == 'Wednesday')
			{
				$dayOfWeek = \XF::phrase('day_wednesday');
			}

			if ($dayOfWeek == 'Thursday')
			{
				$dayOfWeek = \XF::phrase('day_thursday');
			}

			if ($dayOfWeek == 'Friday')
			{
				$dayOfWeek = \XF::phrase('day_friday');
			}

			if ($dayOfWeek == 'Saturday')
			{
				$dayOfWeek = \XF::phrase('day_saturday');
			}

			if ($list_day < 10)
			{
				$list_day_padded = '0' . $list_day;
				
				$listDays[] = array(
					'calendarDay' => $list_day,
					'calendarDate' => $year . $month . $list_day_padded,
					'dayOfWeek' => $dayOfWeek
				);
			}

			if ($list_day >= 10)
			{	
				$listDays[] = array(
					'calendarDay' => $list_day,
					'calendarDate' => $year . $month . $list_day,
					'dayOfWeek' => $dayOfWeek
				);
			}
			
			//########################################
			// get holiday
			
			// declare variables
			$holiday = '';	
			$calendarLine = '';		
			
			// if showHolidays
			if ($showHolidays)
			{		
				// run holiday_name function()
				$holiday = holiday_name($year, $month, $list_day);

				if (!empty($holiday))
				{
					$calendarLine = 1;
					
					if ($list_day < 10)
					{
						$list_day_padded = '0' . $list_day;	
						
						$holidays[] = array(
							'holidayDate' => $year . $month . $list_day_padded,
							'holidayTitle' => $holiday
						);
					}

					if ($list_day >= 10)
					{
						$holidays[] = array(
							'holidayDate' => $year . $month . $list_day,
							'holidayTitle' => $holiday
						);
					}
				}
			}
			
			//########################################
			// increment variables

			if ($running_day == 6) 
			{
				$running_day = -1;
				$days_in_this_week = 0;
			}
			
			$days_in_this_week++; 
			$running_day++; 
			$day_counter++;	
		}

		//########################################
		// start date selector
		//########################################
		
		//	declare variables
		$lastYear = date("Y") - 1;
		$currentYear = date("Y");
		$nextYear = date("Y") + 1;
		$selectedLastYear = '';
		$selectedCurrentYear = '';
		$selectedNextYear = '';
		
		// declare selected year
		if ($year == $lastYear)
		{
			$selectedLastYear = 'selected="selected"';
		}
		
		if ($year == $currentYear)
		{
			$selectedCurrentYear = 'selected="selected"';
		}

		if ($year == $nextYear)
		{
			$selectedNextYear = 'selected="selected"';
		}
		
		//########################################
		// declare selected variables
		//########################################

		$selected01 = '';
		$selected02 = '';
		$selected03 = '';
		$selected04 = '';
		$selected05 = '';
		$selected06 = '';
		$selected07 = '';
		$selected08 = '';
		$selected09 = '';
		$selected10 = '';
		$selected11 = '';
		$selected12 = '';
		
		// declare selected month
		if ($month == '01')
		{
			$selected01 = 'selected="selected"';
		}
		
		if ($month == '02')
		{
			$selected02 = 'selected="selected"';
		}
		
		if ($month == '03')
		{
			$selected03 = 'selected="selected"';
		}	
		
		if ($month == '04')
		{
			$selected04 = 'selected="selected"';
		}
		
		if ($month == '05')
		{
			$selected05 = 'selected="selected"';
		}
		
		if ($month == '06')
		{
			$selected06 = 'selected="selected"';
		}
		
		if ($month == '07')
		{
			$selected07 = 'selected="selected"';
		}	
		
		if ($month == '08')
		{
			$selected08 = 'selected="selected"';
		}
		
		if ($month == '09')
		{
			$selected09 = 'selected="selected"';
		}
		
		if ($month == '10')
		{
			$selected10 = 'selected="selected"';
		}
		
		if ($month == '11')
		{
			$selected11 = 'selected="selected"';
		}	
		
		if ($month == '12')
		{
			$selected12 = 'selected="selected"';
		}

		// prepare viewParams
		$viewParams = [
			'lastYear' => $lastYear,
			'currentYear' => $currentYear,
			'nextYear' => $nextYear,
			'selectedLastYear' => $selectedLastYear,
			'selectedCurrentYear' => $selectedCurrentYear,
			'selectedNextYear' => $selectedNextYear,
			'selected01' => $selected01,
			'selected02' => $selected02,
			'selected03' => $selected03,
			'selected04' => $selected04,
			'selected05' => $selected05,
			'selected06' => $selected06,
			'selected07' => $selected07,
			'selected08' => $selected08,
			'selected09' => $selected09,
			'selected10' => $selected10,
			'selected11' => $selected11,
			'selected12' => $selected12,
			'blankDays' => $blankDays,
			'blankDaysStart' => $blankDaysStart,
			'current_year' => $current_year,
			'current_month' => $current_month,
			'year' => $year,
			'month' => $month,
			'today' => $today,
			'holidays' => $holidays,
			'listDays' => $listDays,
			'members' => $members
		];
	
		// send to template	
		return $this->view('Andy\Calendar:ViewCalendar', 'andy_birthday_calendar', $viewParams);
	}
}