<?php

namespace Andy\BumpLimit\XF\Service\Thread; 

use XF\Entity\Post;

class Replier extends XFCP_Replier
{
	protected function _validate()
	{
		//########################################
		// quick editor
		//########################################
		
		// get errors
		$errors = parent::_validate();
		
		// get visitor
		$visitor = \XF::visitor();
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', 'bypass'))
		{
			return $errors;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '12hours'))
		{
			$hours = 12;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '24hours'))
		{
			$hours = 24;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '48hours'))
		{
			$hours = 48;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '72hours'))
		{
			$hours = 72;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '96hours'))
		{
			$hours = 96;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '120hours'))
		{
			$hours = 120;
		}
		
		// get permission
		if ($visitor->hasPermission('bumpLimit', '144hours'))
		{
			$hours = 144;
		}
		
		// get options
		$options = \XF::options();
		
		// get options from Admin CP -> Options -> Bump limit -> Include Forums
		$includeForums = $options->bumpLimitIncludeForums;
		
		// log error if empty
		if (empty($includeForums))
		{
			\XF::app()->error()->logError("Bump limit error. The options page Include forums cannot be blank.");
			return;
		}
		
		// log error if None is selected
		if ($includeForums[0] == 0)
		{
			\XF::app()->error()->logError("Bump limit error. The options page Include forums cannot have (None) as one of the selected forums.");
			return;
		}
		
		// return 0 hours
		if ($hours == 0)
		{
			return $errors;
		}
		
		// get userId
		$userId = $visitor['user_id'];
		
		// get post
		$post = $this->post;

		// get thread
		$thread = $post->Thread;
		
		// get data from _post
		$threadId = $thread->thread_id;
		
		// create whereclause
		$whereclause = 'AND (xf_thread.node_id = ' . implode(' OR xf_thread.node_id = ', $includeForums);
		$whereclause = $whereclause . ')';
		
		// get db
		$db = \XF::db();
		
		// run query
		$thread = $db->fetchRow("
		SELECT xf_thread.user_id, 
		xf_thread.last_post_date,
		xf_thread.last_post_user_id
		FROM xf_thread
		INNER JOIN xf_node ON xf_node.node_id = xf_thread.node_id
		WHERE xf_thread.thread_id = ?
		$whereclause
		", $threadId);
		
		//########################################
		// check if bumping
		//########################################

		if ($userId == $thread['user_id'] AND $thread['user_id'] != '')
		{
			$timestamp = time() - ($hours * 3600);

			if ($thread['last_post_date'] > $timestamp AND $thread['last_post_user_id'] == $userId)
			{	
				// get errors
				$errors[] = $hours . ' ' . \XF::phrase('bumplimit_hours_must_pass_before_bumping_is_allowed');

				// return errors
				return $errors;
			}
		}
		
		// return errors
		return $errors;	
	}
}