/**
 * Revealer - Adds a stylish hover pop-up with five animation effects for internal WordPress website links.
 *
 * @encoding UTF-8
 * @version 1.0.1
 * @copyright Copyright (C) 2019 merkulove ( https://1.envato.market/cc-merkulove ). All rights reserved.
 * @license Envato License https://1.envato.market/KYbje
 * @author merkulove
 * @url https://revealer.merkulov.design/
**/

(function(){"use strict";var e,t,n,i,a,r=function(e,t){return function(){return e.apply(t,arguments)}},s={}.hasOwnProperty,o=function(e,t){for(var n in t)s.call(t,n)&&(e[n]=t[n]);function i(){this.constructor=e}i.prototype=t.prototype;e.prototype=new i;e.__super__=t.prototype;return e};i=(function(){function e(){this.options_index=0;this.parsed=[]}e.prototype.add_node=function(e){if(e.nodeName.toUpperCase()==="OPTGROUP"){return this.add_group(e)}else{return this.add_option(e)}};e.prototype.add_group=function(e){var t,n,i,a,r,s;t=this.parsed.length;this.parsed.push({array_index:t,group:!0,label:this.escapeExpression(e.label),title:e.title?e.title:void 0,children:0,disabled:e.disabled,classes:e.className});r=e.childNodes;s=[];for(i=0, a=r.length;i<a;i++)n=r[i],s.push(this.add_option(n,t,e.disabled));return s};e.prototype.add_option=function(e,t,n){if(e.nodeName.toUpperCase()==="OPTION"){e.text!==""?(t!=null&&(this.parsed[t].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:e.value,text:e.text,html:e.innerHTML,title:e.title?e.title:void 0,selected:e.selected,disabled:n===!0?n:e.disabled,group_array_index:t,group_label:t!=null?this.parsed[t].label:null,classes:e.className,style:e.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0});return this.options_index+=1}};e.prototype.escapeExpression=function(e){var t,n;if(e==null||e===!1){return""}if(!/[\&\<\>\"\'\`]/.test(e)){return e}t={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};n=/&(?!\w+;)|[\<\>\"\'\`]/g;return e.replace(n,function(e){return t[e]||"&amp;"})};return e})();i.select_to_array=function(e){var t,n,a,r,s;n=new i;s=e.childNodes;for(a=0, r=s.length;a<r;a++)t=s[a],n.add_node(t);return n.parsed};t=(function(){function e(t,n){this.form_field=t;this.options=n!=null?n:{};this.label_click_handler=r(this.label_click_handler,this);if(!e.browser_is_supported()){return}this.is_multiple=this.form_field.multiple;this.set_default_text();this.set_default_values();this.setup();this.set_up_html();this.register_observers();this.on_ready()}e.prototype.set_default_values=function(){var e=this;this.click_test_action=function(t){return e.test_active_click(t)};this.activate_action=function(t){return e.activate_field(t)};this.active_field=!1;this.mouse_on_container=!1;this.results_showing=!1;this.result_highlighted=null;this.is_rtl=this.options.rtl||/\bchosen-rtl\b/.test(this.form_field.className);this.allow_single_deselect=this.options.allow_single_deselect!=null&&this.form_field.options[0]!=null&&this.form_field.options[0].text===""?this.options.allow_single_deselect:!1;this.disable_search_threshold=this.options.disable_search_threshold||0;this.disable_search=this.options.disable_search||!1;this.enable_split_word_search=this.options.enable_split_word_search!=null?this.options.enable_split_word_search:!0;this.group_search=this.options.group_search!=null?this.options.group_search:!0;this.search_contains=this.options.search_contains||!1;this.single_backstroke_delete=this.options.single_backstroke_delete!=null?this.options.single_backstroke_delete:!0;this.max_selected_options=this.options.max_selected_options||1/0;this.inherit_select_classes=this.options.inherit_select_classes||!1;this.display_selected_options=this.options.display_selected_options!=null?this.options.display_selected_options:!0;this.display_disabled_options=this.options.display_disabled_options!=null?this.options.display_disabled_options:!0;this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1;this.max_shown_results=this.options.max_shown_results||Number.POSITIVE_INFINITY;this.case_sensitive_search=this.options.case_sensitive_search||!1;return this.hide_results_on_select=this.options.hide_results_on_select!=null?this.options.hide_results_on_select:!0};e.prototype.set_default_text=function(){this.form_field.getAttribute("data-placeholder")?(this.default_text=this.form_field.getAttribute("data-placeholder")):this.is_multiple?(this.default_text=this.options.placeholder_text_multiple||this.options.placeholder_text||e.default_multiple_text):(this.default_text=this.options.placeholder_text_single||this.options.placeholder_text||e.default_single_text);this.default_text=this.escape_html(this.default_text);return this.results_none_found=this.form_field.getAttribute("data-no_results_text")||this.options.no_results_text||e.default_no_result_text};e.prototype.choice_label=function(e){if(this.include_group_label_in_selected&&e.group_label!=null){return"<b class='group-name'>"+e.group_label+"</b>"+e.html}else{return e.html}};e.prototype.mouse_enter=function(){return this.mouse_on_container=!0};e.prototype.mouse_leave=function(){return this.mouse_on_container=!1};e.prototype.input_focus=function(e){var t=this;if(this.is_multiple){if(!this.active_field){return setTimeout((function(){return t.container_mousedown()}),50)}}else{if(!this.active_field){return this.activate_field()}}};e.prototype.input_blur=function(e){var t=this;if(!this.mouse_on_container){this.active_field=!1;return setTimeout((function(){return t.blur_test()}),100)}};e.prototype.label_click_handler=function(e){if(this.is_multiple){return this.container_mousedown(e)}else{return this.activate_field()}};e.prototype.results_option_build=function(e){var t,n,i,a,r,s,o;t='';a=0;o=this.results_data;for(r=0, s=o.length;r<s;r++){n=o[r];i='';n.group?(i=this.result_add_group(n)):(i=this.result_add_option(n));i!==''&&(a++,t+=i);(e!=null?e.first:void 0)&&(n.selected&&this.is_multiple?this.choice_build(n):n.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(n)));if(a>=this.max_shown_results){break}}return t};e.prototype.result_add_option=function(e){var t,n;if(!e.search_match){return''}if(!this.include_option_in_results(e)){return''}t=[];!e.disabled&&!(e.selected&&this.is_multiple)&&t.push("active-result");e.disabled&&!(e.selected&&this.is_multiple)&&t.push("disabled-result");e.selected&&t.push("result-selected");e.group_array_index!=null&&t.push("group-option");e.classes!==""&&t.push(e.classes);n=document.createElement("li");n.className=t.join(" ");n.style.cssText=e.style;n.setAttribute("data-option-array-index",e.array_index);n.innerHTML=e.search_text;e.title&&(n.title=e.title);return this.outerHTML(n)};e.prototype.result_add_group=function(e){var t,n;if(!(e.search_match||e.group_match)){return''}if(!(e.active_options>0)){return''}t=[];t.push("group-result");e.classes&&t.push(e.classes);n=document.createElement("li");n.className=t.join(" ");n.innerHTML=e.search_text;e.title&&(n.title=e.title);return this.outerHTML(n)};e.prototype.results_update_field=function(){this.set_default_text();this.is_multiple||this.results_reset_cleanup();this.result_clear_highlight();this.results_build();if(this.results_showing){return this.winnow_results()}};e.prototype.reset_single_select_options=function(){var e,t,n,i,a;i=this.results_data;a=[];for(t=0, n=i.length;t<n;t++)e=i[t],e.selected?a.push(e.selected=!1):a.push(void 0);return a};e.prototype.results_toggle=function(){if(this.results_showing){return this.results_hide()}else{return this.results_show()}};e.prototype.results_search=function(e){if(this.results_showing){return this.winnow_results()}else{return this.results_show()}};e.prototype.winnow_results=function(){var e,t,n,i,a,r,s,o,d,_,u,l;this.no_results_clear();a=0;s=this.get_search_text();e=s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");i=this.get_search_regex(e);t=this.get_highlight_regex(e);l=this.results_data;for(_=0, u=l.length;_<u;_++)n=l[_],n.search_match=!1,r=null,this.include_option_in_results(n)&&(n.group&&(n.group_match=!1,n.active_options=0),n.group_array_index!=null&&this.results_data[n.group_array_index]&&(r=this.results_data[n.group_array_index],r.active_options===0&&r.search_match&&(a+=1),r.active_options+=1),n.search_text=n.group?n.label:n.html,(n.group&&!this.group_search)||(n.search_match=this.search_string_match(n.search_text,i),n.search_match&&!n.group&&(a+=1),n.search_match?(s.length&&(o=n.search_text.search(t),d=n.search_text.substr(0,o+s.length)+'</em>'+n.search_text.substr(o+s.length),n.search_text=d.substr(0,o)+'<em>'+d.substr(o)),r!=null&&(r.group_match=!0)):n.group_array_index!=null&&this.results_data[n.group_array_index].search_match&&(n.search_match=!0)));this.result_clear_highlight();if(a<1&&s.length){this.update_results_content("");return this.no_results(s)}else{this.update_results_content(this.results_option_build());return this.winnow_results_set_highlight()}};e.prototype.get_search_regex=function(e){var t,n;t=this.search_contains?"":"^";n=this.case_sensitive_search?"":"i";return new RegExp(t+e,n)};e.prototype.get_highlight_regex=function(e){var t,n;t=this.search_contains?"":"\\b";n=this.case_sensitive_search?"":"i";return new RegExp(t+e,n)};e.prototype.search_string_match=function(e,t){var n,i,a,r;if(t.test(e)){return!0}else if(this.enable_split_word_search&&(e.indexOf(" ")>=0||e.indexOf("[")===0)){i=e.replace(/\[|\]/g,"").split(" ");if(i.length){for(a=0, r=i.length;a<r;a++){n=i[a];if(t.test(n)){return!0}}}}};e.prototype.choices_count=function(){var e,t,n,i;if(this.selected_option_count!=null){return this.selected_option_count}this.selected_option_count=0;i=this.form_field.options;for(t=0, n=i.length;t<n;t++)e=i[t],e.selected&&(this.selected_option_count+=1);return this.selected_option_count};e.prototype.choices_click=function(e){e.preventDefault();this.activate_field();if(!(this.results_showing||this.is_disabled)){return this.results_show()}};e.prototype.keydown_checker=function(e){var t,n;t=(n=e.which)!=null?n:e.keyCode;this.search_field_scale();t!==8&&this.pending_backstroke&&this.clear_backstroke();switch(t){case 8:this.backstroke_length=this.get_search_field_value().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(e);this.mouse_on_container=!1;break;case 13:this.results_showing&&e.preventDefault();break;case 27:this.results_showing&&e.preventDefault();break;case 32:this.disable_search&&e.preventDefault();break;case 38:e.preventDefault();this.keyup_arrow();break;case 40:e.preventDefault();this.keydown_arrow();break}};e.prototype.keyup_checker=function(e){var t,n;t=(n=e.which)!=null?n:e.keyCode;this.search_field_scale();switch(t){case 8:this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0?this.keydown_backstroke():this.pending_backstroke||(this.result_clear_highlight(),this.results_search());break;case 13:e.preventDefault();this.results_showing&&this.result_select(e);break;case 27:this.results_showing&&this.results_hide();break;case 9:;case 16:;case 17:;case 18:;case 38:;case 40:;case 91:break;default:this.results_search();break}};e.prototype.clipboard_event_checker=function(e){var t=this;if(this.is_disabled){return}return setTimeout((function(){return t.results_search()}),50)};e.prototype.container_width=function(){if(this.options.width!=null){return this.options.width}else{return""+this.form_field.offsetWidth+"px"}};e.prototype.include_option_in_results=function(e){if(this.is_multiple&&(!this.display_selected_options&&e.selected)){return!1}if(!this.display_disabled_options&&e.disabled){return!1}if(e.empty){return!1}return!0};e.prototype.search_results_touchstart=function(e){this.touch_started=!0;return this.search_results_mouseover(e)};e.prototype.search_results_touchmove=function(e){this.touch_started=!1;return this.search_results_mouseout(e)};e.prototype.search_results_touchend=function(e){if(this.touch_started){return this.search_results_mouseup(e)}};e.prototype.outerHTML=function(e){var t;if(e.outerHTML){return e.outerHTML}t=document.createElement("div");t.appendChild(e);return t.innerHTML};e.prototype.get_single_html=function(){return"<a class=\"chosen-single chosen-default\">\n  <span>"+this.default_text+"</span>\n  <div><b></b></div>\n</a>\n<div class=\"chosen-drop\">\n  <div class=\"chosen-search\">\n    <input class=\"chosen-search-input\" type=\"text\" autocomplete=\"off\" />\n  </div>\n  <ul class=\"chosen-results\"></ul>\n</div>"};e.prototype.get_multi_html=function(){return"<ul class=\"chosen-choices\">\n  <li class=\"search-field\">\n    <input class=\"chosen-search-input\" type=\"text\" autocomplete=\"off\" value=\""+this.default_text+"\" />\n  </li>\n</ul>\n<div class=\"chosen-drop\">\n  <ul class=\"chosen-results\"></ul>\n</div>"};e.prototype.get_no_results_html=function(e){return"<li class=\"no-results\">\n  "+this.results_none_found+" <span>"+e+"</span>\n</li>"};e.browser_is_supported=function(){if("Microsoft Internet Explorer"===window.navigator.appName){return document.documentMode>=8}if(/iP(od|hone)/i.test(window.navigator.userAgent)||/IEMobile/i.test(window.navigator.userAgent)||/Windows Phone/i.test(window.navigator.userAgent)||/BlackBerry/i.test(window.navigator.userAgent)||/BB10/i.test(window.navigator.userAgent)||/Android.*Mobile/i.test(window.navigator.userAgent)){return!1}return!0};e.default_multiple_text="Select Some Options";e.default_single_text="Select an Option";e.default_no_result_text="No results match";return e})();e=jQuery;e.fn.extend({chosen:function(i){if(!t.browser_is_supported()){return this}return this.each(function(t){var a,r;a=e(this);r=a.data('chosen');if(i==='destroy'){r instanceof n&&r.destroy();return}(r instanceof n)||a.data('chosen',new n(this,i))})}});n=(function(t){o(n,t);function n(){a=n.__super__.constructor.apply(this,arguments);return a}n.prototype.setup=function(){this.form_field_jq=e(this.form_field);return this.current_selectedIndex=this.form_field.selectedIndex};n.prototype.set_up_html=function(){var t,n;t=["chosen-container"];t.push("chosen-container-"+(this.is_multiple?"multi":"single"));this.inherit_select_classes&&this.form_field.className&&t.push(this.form_field.className);this.is_rtl&&t.push("chosen-rtl");n={'class':t.join(' '),'title':this.form_field.title};this.form_field.id.length&&(n.id=this.form_field.id.replace(/[^\w]/g,'_')+"_chosen");this.container=e("<div />",n);this.container.width(this.container_width());this.is_multiple?this.container.html(this.get_multi_html()):this.container.html(this.get_single_html());this.form_field_jq.hide().after(this.container);this.dropdown=this.container.find('div.chosen-drop').first();this.search_field=this.container.find('input').first();this.search_results=this.container.find('ul.chosen-results').first();this.search_field_scale();this.search_no_results=this.container.find('li.no-results').first();this.is_multiple?(this.search_choices=this.container.find('ul.chosen-choices').first(),this.search_container=this.container.find('li.search-field').first()):(this.search_container=this.container.find('div.chosen-search').first(),this.selected_item=this.container.find('.chosen-single').first());this.results_build();this.set_tab_index();return this.set_label_behavior()};n.prototype.on_ready=function(){return this.form_field_jq.trigger("chosen:ready",{chosen:this})};n.prototype.register_observers=function(){var e=this;this.container.bind('touchstart.chosen',function(t){e.container_mousedown(t)});this.container.bind('touchend.chosen',function(t){e.container_mouseup(t)});this.container.bind('mousedown.chosen',function(t){e.container_mousedown(t)});this.container.bind('mouseup.chosen',function(t){e.container_mouseup(t)});this.container.bind('mouseenter.chosen',function(t){e.mouse_enter(t)});this.container.bind('mouseleave.chosen',function(t){e.mouse_leave(t)});this.search_results.bind('mouseup.chosen',function(t){e.search_results_mouseup(t)});this.search_results.bind('mouseover.chosen',function(t){e.search_results_mouseover(t)});this.search_results.bind('mouseout.chosen',function(t){e.search_results_mouseout(t)});this.search_results.bind('mousewheel.chosen DOMMouseScroll.chosen',function(t){e.search_results_mousewheel(t)});this.search_results.bind('touchstart.chosen',function(t){e.search_results_touchstart(t)});this.search_results.bind('touchmove.chosen',function(t){e.search_results_touchmove(t)});this.search_results.bind('touchend.chosen',function(t){e.search_results_touchend(t)});this.form_field_jq.bind("chosen:updated.chosen",function(t){e.results_update_field(t)});this.form_field_jq.bind("chosen:activate.chosen",function(t){e.activate_field(t)});this.form_field_jq.bind("chosen:open.chosen",function(t){e.container_mousedown(t)});this.form_field_jq.bind("chosen:close.chosen",function(t){e.close_field(t)});this.search_field.bind('blur.chosen',function(t){e.input_blur(t)});this.search_field.bind('keyup.chosen',function(t){e.keyup_checker(t)});this.search_field.bind('keydown.chosen',function(t){e.keydown_checker(t)});this.search_field.bind('focus.chosen',function(t){e.input_focus(t)});this.search_field.bind('cut.chosen',function(t){e.clipboard_event_checker(t)});this.search_field.bind('paste.chosen',function(t){e.clipboard_event_checker(t)});if(this.is_multiple){return this.search_choices.bind('click.chosen',function(t){e.choices_click(t)})}else{return this.container.bind('click.chosen',function(e){e.preventDefault()})}};n.prototype.destroy=function(){e(this.container[0].ownerDocument).unbind('click.chosen',this.click_test_action);this.form_field_label.length>0&&this.form_field_label.unbind('click.chosen');this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex);this.container.remove();this.form_field_jq.removeData('chosen');return this.form_field_jq.show()};n.prototype.search_field_disabled=function(){this.is_disabled=this.form_field.disabled||this.form_field_jq.parents('fieldset').is(':disabled');this.container.toggleClass('chosen-disabled',this.is_disabled);this.search_field[0].disabled=this.is_disabled;this.is_multiple||this.selected_item.unbind('focus.chosen',this.activate_field);if(this.is_disabled){return this.close_field()}else if(!this.is_multiple){return this.selected_item.bind('focus.chosen',this.activate_field)}};n.prototype.container_mousedown=function(t){var n;if(this.is_disabled){return}t&&((n=t.type)==='mousedown'||n==='touchstart')&&!this.results_showing&&t.preventDefault();if(!(t!=null&&(e(t.target)).hasClass("search-choice-close"))){this.active_field?!this.is_multiple&&t&&(e(t.target)[0]===this.selected_item[0]||e(t.target).parents("a.chosen-single").length)&&(t.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(""),e(this.container[0].ownerDocument).bind('click.chosen',this.click_test_action),this.results_show());return this.activate_field()}};n.prototype.container_mouseup=function(e){if(e.target.nodeName==="ABBR"&&!this.is_disabled){return this.results_reset(e)}};n.prototype.search_results_mousewheel=function(e){var t;e.originalEvent&&(t=e.originalEvent.deltaY||-e.originalEvent.wheelDelta||e.originalEvent.detail);if(t!=null){e.preventDefault();e.type==='DOMMouseScroll'&&(t*=40);return this.search_results.scrollTop(t+this.search_results.scrollTop())}};n.prototype.blur_test=function(e){if(!this.active_field&&this.container.hasClass("chosen-container-active")){return this.close_field()}};n.prototype.close_field=function(){e(this.container[0].ownerDocument).unbind("click.chosen",this.click_test_action);this.active_field=!1;this.results_hide();this.container.removeClass("chosen-container-active");this.clear_backstroke();this.show_search_field_default();this.search_field_scale();return this.search_field.blur()};n.prototype.activate_field=function(){if(this.is_disabled){return}this.container.addClass("chosen-container-active");this.active_field=!0;this.search_field.val(this.search_field.val());return this.search_field.focus()};n.prototype.test_active_click=function(t){var n;n=e(t.target).closest('.chosen-container');if(n.length&&this.container[0]===n[0]){return this.active_field=!0}else{return this.close_field()}};n.prototype.results_build=function(){this.parsing=!0;this.selected_option_count=null;this.results_data=i.select_to_array(this.form_field);this.is_multiple?this.search_choices.find("li.search-choice").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass("chosen-container-single-nosearch")):(this.search_field[0].readOnly=!1,this.container.removeClass("chosen-container-single-nosearch")));this.update_results_content(this.results_option_build({first:!0}));this.search_field_disabled();this.show_search_field_default();this.search_field_scale();return this.parsing=!1};n.prototype.result_do_highlight=function(e){var t,n,i,a,r;if(e.length){this.result_clear_highlight();this.result_highlight=e;this.result_highlight.addClass("highlighted");i=parseInt(this.search_results.css("maxHeight"),10);r=this.search_results.scrollTop();a=i+r;n=this.result_highlight.position().top+this.search_results.scrollTop();t=n+this.result_highlight.outerHeight();if(t>=a){return this.search_results.scrollTop(t-i>0?t-i:0)}else if(n<r){return this.search_results.scrollTop(n)}}};n.prototype.result_clear_highlight=function(){this.result_highlight&&this.result_highlight.removeClass("highlighted");return this.result_highlight=null};n.prototype.results_show=function(){if(this.is_multiple&&this.max_selected_options<=this.choices_count()){this.form_field_jq.trigger("chosen:maxselected",{chosen:this});return!1}this.container.addClass("chosen-with-drop");this.results_showing=!0;this.search_field.focus();this.search_field.val(this.get_search_field_value());this.winnow_results();return this.form_field_jq.trigger("chosen:showing_dropdown",{chosen:this})};n.prototype.update_results_content=function(e){return this.search_results.html(e)};n.prototype.results_hide=function(){this.results_showing&&(this.result_clear_highlight(),this.container.removeClass("chosen-with-drop"),this.form_field_jq.trigger("chosen:hiding_dropdown",{chosen:this}));return this.results_showing=!1};n.prototype.set_tab_index=function(e){var t;if(this.form_field.tabIndex){t=this.form_field.tabIndex;this.form_field.tabIndex=-1;return this.search_field[0].tabIndex=t}};n.prototype.set_label_behavior=function(){this.form_field_label=this.form_field_jq.parents("label");!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=e("label[for='"+this.form_field.id+"']"));if(this.form_field_label.length>0){return this.form_field_label.bind('click.chosen',this.label_click_handler)}};n.prototype.show_search_field_default=function(){if(this.is_multiple&&this.choices_count()<1&&!this.active_field){this.search_field.val(this.default_text);return this.search_field.addClass("default")}else{this.search_field.val("");return this.search_field.removeClass("default")}};n.prototype.search_results_mouseup=function(t){var n;n=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first();if(n.length){this.result_highlight=n;this.result_select(t);return this.search_field.focus()}};n.prototype.search_results_mouseover=function(t){var n;n=e(t.target).hasClass("active-result")?e(t.target):e(t.target).parents(".active-result").first();if(n){return this.result_do_highlight(n)}};n.prototype.search_results_mouseout=function(t){if(e(t.target).hasClass("active-result")){return this.result_clear_highlight()}};n.prototype.choice_build=function(t){var n,i,a=this;n=e('<li />',{"class":"search-choice"}).html("<span>"+(this.choice_label(t))+"</span>");t.disabled?n.addClass('search-choice-disabled'):(i=e('<a />',{"class":'search-choice-close','data-option-array-index':t.array_index}),i.bind('click.chosen',function(e){return a.choice_destroy_link_click(e)}),n.append(i));return this.search_container.before(n)};n.prototype.choice_destroy_link_click=function(t){t.preventDefault();t.stopPropagation();if(!this.is_disabled){return this.choice_destroy(e(t.target))}};n.prototype.choice_destroy=function(e){if(this.result_deselect(e[0].getAttribute("data-option-array-index"))){this.active_field?this.search_field.focus():this.show_search_field_default();this.is_multiple&&this.choices_count()>0&&this.get_search_field_value().length<1&&this.results_hide();e.parents('li').first().remove();return this.search_field_scale()}};n.prototype.results_reset=function(){this.reset_single_select_options();this.form_field.options[0].selected=!0;this.single_set_selected_text();this.show_search_field_default();this.results_reset_cleanup();this.trigger_form_field_change();if(this.active_field){return this.results_hide()}};n.prototype.results_reset_cleanup=function(){this.current_selectedIndex=this.form_field.selectedIndex;return this.selected_item.find("abbr").remove()};n.prototype.result_select=function(e){var t,n;if(this.result_highlight){t=this.result_highlight;this.result_clear_highlight();if(this.is_multiple&&this.max_selected_options<=this.choices_count()){this.form_field_jq.trigger("chosen:maxselected",{chosen:this});return!1}this.is_multiple?t.removeClass("active-result"):this.reset_single_select_options();t.addClass("result-selected");n=this.results_data[t[0].getAttribute("data-option-array-index")];n.selected=!0;this.form_field.options[n.options_index].selected=!0;this.selected_option_count=null;this.is_multiple?this.choice_build(n):this.single_set_selected_text(this.choice_label(n));(this.is_multiple&&(!this.hide_results_on_select||(e.metaKey||e.ctrlKey)))||(this.results_hide(),this.show_search_field_default());(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.trigger_form_field_change({selected:this.form_field.options[n.options_index].value});this.current_selectedIndex=this.form_field.selectedIndex;e.preventDefault();return this.search_field_scale()}};n.prototype.single_set_selected_text=function(e){e==null&&(e=this.default_text);e===this.default_text?this.selected_item.addClass("chosen-default"):(this.single_deselect_control_build(),this.selected_item.removeClass("chosen-default"));return this.selected_item.find("span").html(e)};n.prototype.result_deselect=function(e){var t;t=this.results_data[e];if(!this.form_field.options[t.options_index].disabled){t.selected=!1;this.form_field.options[t.options_index].selected=!1;this.selected_option_count=null;this.result_clear_highlight();this.results_showing&&this.winnow_results();this.trigger_form_field_change({deselected:this.form_field.options[t.options_index].value});this.search_field_scale();return!0}else{return!1}};n.prototype.single_deselect_control_build=function(){if(!this.allow_single_deselect){return}this.selected_item.find("abbr").length||this.selected_item.find("span").first().after("<abbr class=\"search-choice-close\"></abbr>");return this.selected_item.addClass("chosen-single-with-deselect")};n.prototype.get_search_field_value=function(){return this.search_field.val()};n.prototype.get_search_text=function(){return this.escape_html(e.trim(this.get_search_field_value()))};n.prototype.escape_html=function(t){return e('<div/>').text(t).html()};n.prototype.winnow_results_set_highlight=function(){var e,t;t=!this.is_multiple?this.search_results.find(".result-selected.active-result"):[];e=t.length?t.first():this.search_results.find(".active-result").first();if(e!=null){return this.result_do_highlight(e)}};n.prototype.no_results=function(e){var t;t=this.get_no_results_html(e);this.search_results.append(t);return this.form_field_jq.trigger("chosen:no_results",{chosen:this})};n.prototype.no_results_clear=function(){return this.search_results.find(".no-results").remove()};n.prototype.keydown_arrow=function(){var e;if(this.results_showing&&this.result_highlight){e=this.result_highlight.nextAll("li.active-result").first();if(e){return this.result_do_highlight(e)}}else{return this.results_show()}};n.prototype.keyup_arrow=function(){var e;if(!this.results_showing&&!this.is_multiple){return this.results_show()}else if(this.result_highlight){e=this.result_highlight.prevAll("li.active-result");if(e.length){return this.result_do_highlight(e.first())}else{this.choices_count()>0&&this.results_hide();return this.result_clear_highlight()}}};n.prototype.keydown_backstroke=function(){var e;if(this.pending_backstroke){this.choice_destroy(this.pending_backstroke.find("a").first());return this.clear_backstroke()}else{e=this.search_container.siblings("li.search-choice").last();if(e.length&&!e.hasClass("search-choice-disabled")){this.pending_backstroke=e;if(this.single_backstroke_delete){return this.keydown_backstroke()}else{return this.pending_backstroke.addClass("search-choice-focus")}}}};n.prototype.clear_backstroke=function(){this.pending_backstroke&&this.pending_backstroke.removeClass("search-choice-focus");return this.pending_backstroke=null};n.prototype.search_field_scale=function(){var t,n,i,a,r,s,o,d;if(!this.is_multiple){return}a={position:'absolute',left:'-1000px',top:'-1000px',display:'none',whiteSpace:'pre'};r=['fontSize','fontStyle','fontWeight','fontFamily','lineHeight','textTransform','letterSpacing'];for(o=0, d=r.length;o<d;o++)i=r[o],a[i]=this.search_field.css(i);n=e('<div />').css(a);n.text(this.get_search_field_value());e('body').append(n);s=n.width()+25;n.remove();t=this.container.outerWidth();s=Math.min(t-10,s);return this.search_field.width(s)};n.prototype.trigger_form_field_change=function(e){this.form_field_jq.trigger("input",e);return this.form_field_jq.trigger("change",e)};return n})(t)}).call(this),!function(e){"use strict";var t;if(!window.jQuery){throw new Error('UIkit 2.x requires jQuery')}else t=e(window.jQuery);typeof define=='function'&&define.amd&&define('uikit',function(){t.load=function(e,n,i,a){var r=e.split(','),s=[],o,d=(a.config&&a.config.uikit&&a.config.uikit.base?a.config.uikit.base:'').replace(/\/+$/g,'');if(!d){throw new Error('Please define base path to UIkit in the requirejs config.')}for(o=0;o<r.length;o+=1){var _=r[o].replace(/\./g,'/');s.push(d+'/components/'+_)}n(s,function(){i(t)})};return t})}(function(e){"use strict";if(window.UIkit2MD){return window.UIkit2MD}var t={},n=window.UIkit||void 0;t.version='2.27.3';t.noConflict=function(){n&&(window.UIkit=n,e.UIkit=n,e.fn.uk=n.fn);return t};window.UIkit2MD=t;n||(window.UIkit=t);t.$=e;t.$doc=t.$(document);t.$win=t.$(window);t.$html=t.$('html');t.support={};t.support.transition=(function(){var e=(function(){var e=document.body||document.documentElement,t={WebkitTransition:'webkitTransitionEnd',MozTransition:'transitionend',OTransition:'oTransitionEnd otransitionend',transition:'transitionend'},n;for(n in t){if(e.style[n]!==void 0)return t[n]}}());return e&&{end:e}})();t.support.animation=(function(){var e=(function(){var e=document.body||document.documentElement,t={WebkitAnimation:'webkitAnimationEnd',MozAnimation:'animationend',OAnimation:'oAnimationEnd oanimationend',animation:'animationend'},n;for(n in t){if(e.style[n]!==void 0)return t[n]}}());return e&&{end:e}})();!function(){Date.now=Date.now||function(){return new Date.getTime()};var e=['webkit','moz'];for(var t=0;t<e.length&&!window.requestAnimationFrame;++t){var n=e[t];window.requestAnimationFrame=window[n+'RequestAnimationFrame'];window.cancelAnimationFrame=window[n+'CancelAnimationFrame']||window[n+'CancelRequestAnimationFrame']}if(/iP(ad|hone|od).*OS 6/.test(window.navigator.userAgent)||!window.requestAnimationFrame||!window.cancelAnimationFrame){var i=0;window.requestAnimationFrame=function(e){var t=Date.now(),n=Math.max(i+16,t);return setTimeout(function(){e(i=n)},n-t)};window.cancelAnimationFrame=clearTimeout}}();t.support.touch='ontouchstart' in document||window.DocumentTouch&&document instanceof window.DocumentTouch||window.navigator.msPointerEnabled&&window.navigator.msMaxTouchPoints>0||window.navigator.pointerEnabled&&window.navigator.maxTouchPoints>0||!1;t.support.mutationobserver=window.MutationObserver||window.WebKitMutationObserver||null;t.Utils={};t.Utils.isFullscreen=function(){return document.webkitFullscreenElement||document.mozFullScreenElement||document.msFullscreenElement||document.fullscreenElement||!1};t.Utils.str2json=function(e,t){try{if(t){return JSON.parse(e.replace(/([\$\w]+)\s*:/g,function(e,t){return'"'+t+'":'}).replace(/'([^']+)'/g,function(e,t){return'"'+t+'"'}))}else{return new Function('','var json = '+e+'; return JSON.parse(JSON.stringify(json));')()}}catch(e){return!1}};t.Utils.debounce=function(e,t,n){var i;return function(){var a=this,r=arguments,s=function(){i=null;n||e.apply(a,r)},o=n&&!i;clearTimeout(i);i=setTimeout(s,t);o&&e.apply(a,r)}};t.Utils.throttle=function(e,t){var n=!1;return function(){n||(e.call(),n=!0,setTimeout(function(){n=!1},t))}};t.Utils.removeCssRules=function(e){var t,n,i,a,r,s,o,d,_,u;if(!e)return;setTimeout(function(){try{u=document.styleSheets;for(a=0, o=u.length;a<o;a++){i=u[a];n=[];i.cssRules=i.cssRules;for(t=r=0, d=i.cssRules.length;r<d;t=++r)i.cssRules[t].type===CSSRule.STYLE_RULE&&e.test(i.cssRules[t].selectorText)&&n.unshift(t);for(s=0, _=n.length;s<_;s++)i.deleteRule(n[s])}}catch(e){}},0)};t.Utils.isInView=function(n,i){var a=e(n);if(!a.is(':visible')){return!1}var r=t.$win.scrollLeft(),s=t.$win.scrollTop(),o=a.offset(),d=o.left,_=o.top;i=e.extend({topoffset:0,leftoffset:0},i);if(_+a.height()>=s&&_-i.topoffset<=s+t.$win.height()&&d+a.width()>=r&&d-i.leftoffset<=r+t.$win.width()){return!0}else{return!1}};t.Utils.checkDisplay=function(n,i){var a=t.$('[data-mdp-margin], [data-mdp-grid-match], [data-mdp-grid-margin], [data-mdp-check-display]',n||document);n&&!a.length&&(a=e(n));a.trigger('display.uk.check');i&&(typeof i!='string'&&(i='[class*="mdp-animation-"]'),a.find(i).each(function(){var e=t.$(this),n=e.attr('class'),i=n.match(/mdp-animation-(.+)/);e.removeClass(i[0]).width();e.addClass(i[0])}));return a};t.Utils.options=function(n){if(e.type(n)!='string')return n;n.indexOf(':')!=-1&&n.trim().substr(-1)!='}'&&(n='{'+n+'}');var i=n?n.indexOf("{"):-1,a={};if(i!=-1){try{a=t.Utils.str2json(n.substr(i))}catch(e){}}return a};t.Utils.animate=function(n,i){var a=e.Deferred();n=t.$(n);n.css('display','none').addClass(i).one(t.support.animation.end,function(){n.removeClass(i);a.resolve()});n.css('display','');return a.promise()};t.Utils.uid=function(e){return(e||'id')+(new Date.getTime())+"RAND"+(Math.ceil(Math.random()*1e5))};t.Utils.template=function(e,t){var n=e.replace(/\n/g,'\\n').replace(/\{\{\{\s*(.+?)\s*\}\}\}/g,"{{!$1}}").split(/(\{\{\s*(.+?)\s*\}\})/g),i=0,a,r,s,o,d=[],_=0;while(i<n.length){a=n[i];if(a.match(/\{\{\s*(.+?)\s*\}\}/)){i+=1;a=n[i];r=a[0];s=a.substring(a.match(/^(\^|\#|\!|\~|\:)/)?1:0);switch(r){case '~':d.push('for(var $i=0;$i<'+s+'.length;$i++) { var $item = '+s+'[$i];');_++;break;case ':':d.push('for(var $key in '+s+') { var $val = '+s+'[$key];');_++;break;case '#':d.push('if('+s+') {');_++;break;case '^':d.push('if(!'+s+') {');_++;break;case '/':d.push('}');_--;break;case '!':d.push('__ret.push('+s+');');break;default:d.push('__ret.push(escape('+s+'));');break}}else d.push("__ret.push('"+a.replace(/\'/g,"\\'")+"');");i+=1}o=new Function('$data',['var __ret = [];','try {','with($data){',!_?d.join(''):'__ret = ["Not all blocks are closed correctly."]','};','}catch(e){__ret = [e.message];}','return __ret.join("").replace(/\\n\\n/g, "\\n");',"function escape(html) { return String(html).replace(/&/g, '&amp;').replace(/\"/g, '&quot;').replace(/</g, '&lt;').replace(/>/g, '&gt;');}"].join("\n"));return t?o(t):o};t.Utils.focus=function(t,n){t=e(t);if(!t.length){return t}var i=t.find('[autofocus]:first'),a;if(i.length){return i.focus()}i=t.find(':input'+(n&&','+n||'')).first();if(i.length){return i.focus()}t.attr('tabindex')||(a=1e3,t.attr('tabindex',a));t[0].focus();a&&t.attr('tabindex','');return t};t.Utils.events={};t.Utils.events.click=t.support.touch?'tap':'click';t.fn=function(n,i){var a=arguments,r=n.match(/^([a-z\-]+)(?:\.([a-z]+))?/i),s=r[1],o=r[2];if(!t[s]){e.error('UIkit component ['+s+'] does not exist.');return this}return this.each(function(){var n=e(this),r=n.data(s);r||n.data(s,(r=t[s](this,o?void 0:i)));o&&r[o].apply(r,Array.prototype.slice.call(a,1))})};e.UIkit=t;e.fn.uk=t.fn;t.langdirection=t.$html.attr("dir")=="rtl"?"right":"left";t.components={};t.component=function(n,i,a){if(t.components[n]&&!a){return t.components[n]}var r=function(i,a){var s=this;this.UIkit=t;this.element=i?t.$(i):null;this.options=e.extend(!0,{},this.defaults,a);this.plugins={};this.element&&this.element.data(n,this);this.init();(this.options.plugins.length?this.options.plugins:Object.keys(r.plugins)).forEach(function(e){r.plugins[e].init&&(r.plugins[e].init(s),s.plugins[e]=!0)});this.trigger('init.uk.component',[n,this]);return this};r.plugins={};e.extend(!0,r.prototype,{defaults:{plugins:[]},boot:function(){},init:function(){},on:function(e,n,i){return t.$(this.element||this).on(e,n,i)},one:function(e,n,i){return t.$(this.element||this).one(e,n,i)},off:function(e){return t.$(this.element||this).off(e)},trigger:function(e,n){return t.$(this.element||this).trigger(e,n)},find:function(e){return t.$(this.element?this.element:[]).find(e)},proxy:function(e,t){var n=this;t.split(' ').forEach(function(t){n[t]||(n[t]=function(){return e[t].apply(e,arguments)})})},mixin:function(e,t){var n=this;t.split(' ').forEach(function(t){n[t]||(n[t]=e[t].bind(n))})},option:function(){if(arguments.length==1){return this.options[arguments[0]]||void 0}else arguments.length==2&&(this.options[arguments[0]]=arguments[1])}},i);this.components[n]=r;this[n]=function(){var i,a;if(arguments.length){switch(arguments.length){case 1:typeof arguments[0]==='string'||arguments[0].nodeType||arguments[0] instanceof jQuery?(i=e(arguments[0])):(a=arguments[0]);break;case 2:i=e(arguments[0]);a=arguments[1];break}}if(i&&i.data(n)){return i.data(n)}return new t.components[n](i,a)};t.domready&&t.component.boot(n);return r};t.plugin=function(e,t,n){this.components[e].plugins[t]=n};t.component.boot=function(e){t.components[e].prototype&&t.components[e].prototype.boot&&!t.components[e].booted&&(t.components[e].prototype.boot.apply(t,[]),t.components[e].booted=!0)};t.component.bootComponents=function(){for(var e in t.components)t.component.boot(e)};t.domObservers=[];t.domready=!1;t.ready=function(e){t.domObservers.push(e);t.domready&&e(document)};t.on=function(e,n,i){e&&e.indexOf('ready.uk.dom')>-1&&t.domready&&n.apply(t.$doc);return t.$doc.on(e,n,i)};t.one=function(e,n,i){if(e&&e.indexOf('ready.uk.dom')>-1&&t.domready){n.apply(t.$doc);return t.$doc}return t.$doc.one(e,n,i)};t.trigger=function(e,n){return t.$doc.trigger(e,n)};t.domObserve=function(e,n){if(!t.support.mutationobserver)return;n=n||function(){};t.$(e).each(function(){var e=this,i=t.$(e);if(i.data('observer')){return}try{var a=new t.support.mutationobserver(t.Utils.debounce(function(t){n.apply(e,[i]);i.trigger('changed.uk.dom')},50),{childList:!0,subtree:!0});a.observe(e,{childList:!0,subtree:!0});i.data('observer',a)}catch(e){}})};t.init=function(e){e=e||document;t.domObservers.forEach(function(t){t(e)})};t.on('domready.uk.dom',function(){t.init();t.domready&&t.Utils.checkDisplay()});document.addEventListener('DOMContentLoaded',function(){var n=function(){t.$body=t.$('body');t.trigger('beforeready.uk.dom');t.component.bootComponents();var n=requestAnimationFrame((function(){var e={dir:{x:0,y:0},x:window.pageXOffset,y:window.pageYOffset},i=function(){var a=window.pageXOffset,r=window.pageYOffset;(e.x!=a||e.y!=r)&&(a!=e.x?(e.dir.x=a>e.x?1:-1):(e.dir.x=0),r!=e.y?(e.dir.y=r>e.y?1:-1):(e.dir.y=0),e.x=a,e.y=r,t.$doc.trigger('scrolling.uk.document',[{dir:{x:e.dir.x,y:e.dir.y},x:a,y:r}]));cancelAnimationFrame(n);n=requestAnimationFrame(i)};t.support.touch&&t.$html.on('touchmove touchend MSPointerMove MSPointerUp pointermove pointerup',i);(e.x||e.y)&&i();return i})());t.trigger('domready.uk.dom');t.support.touch&&(navigator.userAgent.match(/(iPad|iPhone|iPod)/g)&&t.$win.on('load orientationchange resize',t.Utils.debounce((function(){var t=function(){e('.mdp-height-viewport').css('height',window.innerHeight);return t};return t()})(),100)));t.trigger('afterready.uk.dom');t.domready=!0;if(t.support.mutationobserver){var i=t.Utils.debounce(function(){requestAnimationFrame(function(){t.init(document.body)})},10);(new t.support.mutationobserver(function(e){var t=!1;e.every(function(e){if(e.type!='childList')return!0;for(var n=0,i;n<e.addedNodes.length;++n){i=e.addedNodes[n];if(i.outerHTML&&i.outerHTML.indexOf('data-mdp-')!==-1){return(t=!0)&&!1}}return!0});t&&i()})).observe(document.body,{childList:!0,subtree:!0})}};(document.readyState=='complete'||document.readyState=='interactive')&&setTimeout(n);return n}());t.$html.addClass(t.support.touch?'mdp-touch':'mdp-notouch');if(t.support.touch){var i=!1,a,r='mdp-hover',s='.mdp-overlay, .mdp-overlay-hover, .mdp-overlay-toggle, .mdp-animation-hover, .mdp-has-hover';t.$html.on('mouseenter touchstart MSPointerDown pointerdown',s,function(){i&&e('.'+r).removeClass(r);i=e(this).addClass(r)}).on('mouseleave touchend MSPointerUp pointerup',function(t){a=e(t.target).parents(s);i&&i.not(a).removeClass(r)})}return t}),!function(e){if(e.fn.swipeLeft){return}var t={},n,i,a,r,s=750,o,d='ontouchstart' in window,_=window.PointerEvent,u=d||window.DocumentTouch&&document instanceof DocumentTouch||navigator.msPointerEnabled&&navigator.msMaxTouchPoints>0||navigator.pointerEnabled&&navigator.maxTouchPoints>0;function l(e,t,n,i){return Math.abs(e-t)>=Math.abs(n-i)?(e-t>0?'Left':'Right'):(n-i>0?'Up':'Down')}function m(){r=null;t.last&&(t.el!==void 0&&t.el.trigger('longTap'),t={})}function p(){r&&clearTimeout(r);r=null}function c(){n&&clearTimeout(n);i&&clearTimeout(i);a&&clearTimeout(a);r&&clearTimeout(r);n=i=a=r=null;t={}}function f(e){return e.pointerType==e.MSPOINTER_TYPE_TOUCH&&e.isPrimary}e(function(){var h,M,Y=0,g=0,b;'MSGesture' in window&&(o=new MSGesture,o.target=document.body);e(document).on('MSGestureEnd gestureend',function(e){var n=e.originalEvent.velocityX>1?'Right':e.originalEvent.velocityX<-1?'Left':e.originalEvent.velocityY>1?'Down':e.originalEvent.velocityY<-1?'Up':null;n&&t.el!==void 0&&(t.el.trigger('swipe'),t.el.trigger('swipe'+n))}).on('touchstart MSPointerDown pointerdown',function(i){if(i.type=='MSPointerDown'&&!f(i.originalEvent))return;b=i.type=='MSPointerDown'||i.type=='pointerdown'?i:i.originalEvent.touches[0];h=Date.now();M=h-(t.last||h);t.el=e('tagName' in b.target?b.target:b.target.parentNode);n&&clearTimeout(n);t.x1=b.pageX;t.y1=b.pageY;M>0&&M<=250&&(t.isDoubleTap=!0);t.last=h;r=setTimeout(m,s);i.originalEvent&&i.originalEvent.pointerId&&o&&(i.type=='MSPointerDown'||i.type=='pointerdown'||i.type=='touchstart')&&o.addPointer(i.originalEvent.pointerId)}).on('touchmove MSPointerMove pointermove',function(e){if(e.type=='MSPointerMove'&&!f(e.originalEvent))return;b=e.type=='MSPointerMove'||e.type=='pointermove'?e:e.originalEvent.touches[0];p();t.x2=b.pageX;t.y2=b.pageY;Y+=Math.abs(t.x1-t.x2);g+=Math.abs(t.y1-t.y2)}).on('touchend MSPointerUp pointerup',function(r){if(r.type=='MSPointerUp'&&!f(r.originalEvent))return;p();t.x2&&Math.abs(t.x1-t.x2)>30||t.y2&&Math.abs(t.y1-t.y2)>30?(a=setTimeout(function(){t.el!==void 0&&(t.el.trigger('swipe'),t.el.trigger('swipe'+(l(t.x1,t.x2,t.y1,t.y2))));t={}},0)):'last' in t&&(isNaN(Y)||Y<30&&g<30?(i=setTimeout(function(){var i=e.Event('tap');i.cancelTouch=c;t.el!==void 0&&t.el.trigger(i);t.isDoubleTap?(t.el!==void 0&&t.el.trigger('doubleTap'),t={}):(n=setTimeout(function(){n=null;t.el!==void 0&&t.el.trigger('singleTap');t={}},250))},0)):(t={}),Y=g=0)}).on('touchcancel MSPointerCancel pointercancel',function(e){(e.type=='touchcancel'&&d&&u||!d&&e.type=='pointercancel'&&_)&&c()});e(window).on('scroll',c)});['swipe','swipeLeft','swipeRight','swipeUp','swipeDown','doubleTap','tap','singleTap','longTap'].forEach(function(t){e.fn[t]=function(n){return e(this).on(t,n)}})}(jQuery),!function(e){"use strict";var t=[];e.component('stackMargin',{defaults:{cls:'mdp-margin-small-top',rowfirst:!1,observe:!1},boot:function(){e.ready(function(t){e.$('[data-mdp-margin]',t).each(function(){var t=e.$(this);t.data('stackMargin')||e.stackMargin(t,e.Utils.options(t.attr('data-mdp-margin')))})})},init:function(){var n=this;e.$win.on('resize orientationchange',(function(){var t=function(){n.process()};e.$(function(){t();e.$win.on('load',t)});return e.Utils.debounce(t,20)})());this.on('display.uk.check',function(e){this.element.is(':visible')&&this.process()}.bind(this));this.options.observe&&e.domObserve(this.element,function(e){n.element.is(':visible')&&n.process()});t.push(this)},process:function(){this;var t=this.element.children();e.Utils.stackMargin(t,this.options);if(!this.options.rowfirst||!t.length){return this}var n={},i=!1;t.removeClass(this.options.rowfirst).each(function(t,a){a=e.$(this);this.style.display!='none'&&(t=a.offset().left,((n[t]=n[t]||[])&&n[t]).push(this),i=i===!1?t:Math.min(i,t))});e.$(n[i]).addClass(this.options.rowfirst);return this}});!function(){var t=[],n=function(e){if(!e.is(':visible'))return;var t=e.parent().width(),n=e.data('width'),i=t/n,a=Math.floor(i*e.data('height'));e.css({height:t<n?a:e.data('height')})};e.component('responsiveElement',{defaults:{},boot:function(){e.ready(function(t){e.$('iframe.mdp-responsive-width, [data-mdp-responsive]',t).each(function(){var t=e.$(this),n;t.data('responsiveElement')||(n=e.responsiveElement(t,{}))})})},init:function(){var e=this.element;e.attr('width')&&e.attr('height')&&(e.data({width:e.attr('width'),height:e.attr('height')}).on('display.uk.check',function(){n(e)}),n(e),t.push(e))}});e.$win.on('resize load',e.Utils.debounce(function(){t.forEach(function(e){n(e)})},15))}();e.Utils.stackMargin=function(t,n){n=e.$.extend({cls:'mdp-margin-small-top'},n);t=e.$(t).removeClass(n.cls);var i=!1;t.each(function(t,n,a,r){r=e.$(this);r.css('display')!='none'&&(t=r.offset(),n=r.outerHeight(),a=t.top+n,r.data({ukMarginPos:a,ukMarginTop:t.top}),(i===!1||t.top<i.top)&&(i={top:t.top,left:t.left,pos:a}))}).each(function(t){t=e.$(this);t.css('display')!='none'&&t.data('ukMarginTop')>i.top&&t.data('ukMarginPos')>i.pos&&t.addClass(n.cls)})};e.Utils.matchHeights=function(t,n){t=e.$(t).css('min-height','');n=e.$.extend({row:!0},n);var i=function(t){if(t.length<2)return;var n=0;t.each(function(){n=Math.max(n,e.$(this).outerHeight())}).each(function(){var t=e.$(this),i=n-(t.css('box-sizing')=='border-box'?0:t.outerHeight()-t.height());t.css('min-height',i+'px')})};n.row?(t.first().width(),setTimeout(function(){var n=!1,a=[];t.each(function(){var t=e.$(this),r=t.offset().top;r!=n&&a.length&&(i(e.$(a)),a=[],r=t.offset().top);a.push(t);n=r});a.length&&i(e.$(a))},0)):i(t)};!function(t){e.Utils.inlineSvg=function(n,i){e.$(n||'img[src$=".svg"]',i||document).each(function(){var n=e.$(this),i=n.attr('src');if(!t[i]){var a=e.$.Deferred();e.$.get(i,{nc:Math.random()},function(t){a.resolve(e.$(t).find('svg'))});t[i]=a.promise()}t[i].then(function(t){var i=e.$(t).clone();n.attr('id')&&i.attr('id',n.attr('id'));n.attr('class')&&i.attr('class',n.attr('class'));n.attr('style')&&i.attr('style',n.attr('style'));n.attr('width')&&(i.attr('width',n.attr('width')),n.attr('height')||i.removeAttr('height'));n.attr('height')&&(i.attr('height',n.attr('height')),n.attr('width')||i.removeAttr('width'));n.replaceWith(i)})})};e.ready(function(t){e.Utils.inlineSvg('[data-mdp-svg]',t)})}({});e.Utils.getCssVar=function(e){var t,n=document.documentElement,i=n.appendChild(document.createElement('div'));i.classList.add('var-'+e);try{t=JSON.parse(t=getComputedStyle(i,':before').content.replace(/^["'](.*)["']$/,'$1'))}catch(e){t=void 0};n.removeChild(i);return t}}(UIkit2MD),!function(e){"use strict";e.component('smoothScroll',{boot:function(){e.$html.on('click.smooth-scroll.uikit','[data-mdp-smooth-scroll]',function(t){var n=e.$(this);if(!n.data('smoothScroll')){e.smoothScroll(n,e.Utils.options(n.attr('data-mdp-smooth-scroll')));n.trigger('click')}return!1})},init:function(){var n=this;this.on('click',function(i){i.preventDefault();t(e.$(this.hash).length?e.$(this.hash):e.$('body'),n.options)})}});function t(t,n){n=e.$.extend({duration:1e3,transition:'easeOutExpo',offset:0,complete:function(){}},n);var i=t.offset().top-n.offset,a=e.$doc.height(),r=window.innerHeight;i+r>a&&(i=a-r);e.$('html,body').stop().animate({scrollTop:i},n.duration,n.transition).promise().done(n.complete)}e.Utils.scrollToElement=t;e.$.easing.easeOutExpo||(e.$.easing.easeOutExpo=function(e,t,n,i,a){return t==a?n+i:i*(-Math.pow(2,-10*t/a)+1)+n})}(UIkit2MD),!function(e){"use strict";var t=e.$win,n=e.$doc,i=[],a=function(){for(var e=0;e<i.length;e++)window.requestAnimationFrame.apply(window,[i[e].check])};e.component('scrollspy',{defaults:{target:!1,cls:'mdp-scrollspy-inview',initcls:'mdp-scrollspy-init-inview',topoffset:0,leftoffset:0,repeat:!1,delay:0},boot:function(){n.on('scrolling.uk.document',a);t.on('load resize orientationchange',e.Utils.debounce(a,50));e.ready(function(t){e.$('[data-mdp-scrollspy]',t).each(function(){var t=e.$(this);if(!t.data('scrollspy'))e.scrollspy(t,e.Utils.options(t.attr('data-mdp-scrollspy')))})})},init:function(){var t=this,n,a=this.options.cls.split(/,/),r=function(){var i=t.options.target?t.element.find(t.options.target):t.element,r=i.length===1?1:0,s=0;i.each(function(i){var o=e.$(this),d=o.data('inviewstate'),_=e.Utils.isInView(o,t.options),u=o.attr('data-mdp-scrollspy-cls')||a[s].trim();_&&!d&&!o.data('scrollspy-idle')&&(n||(o.addClass(t.options.initcls),t.offset=o.offset(),n=!0,o.trigger('init.uk.scrollspy')),o.data('scrollspy-idle',setTimeout(function(){o.addClass('mdp-scrollspy-inview').toggleClass(u).width();o.trigger('inview.uk.scrollspy');o.data('scrollspy-idle',!1);o.data('inviewstate',!0)},t.options.delay*r)),r++);!_&&d&&t.options.repeat&&(o.data('scrollspy-idle')&&(clearTimeout(o.data('scrollspy-idle')),o.data('scrollspy-idle',!1)),o.removeClass('mdp-scrollspy-inview').toggleClass(u),o.data('inviewstate',!1),o.trigger('outview.uk.scrollspy'));s=a[s+1]?s+1:0})};r();this.check=r;i.push(this)}});var r=[],s=function(){for(var e=0;e<r.length;e++)window.requestAnimationFrame.apply(window,[r[e].check])};e.component('scrollspynav',{defaults:{cls:'mdp-active',closest:!1,topoffset:0,leftoffset:0,smoothscroll:!1},boot:function(){n.on('scrolling.uk.document',s);t.on('resize orientationchange',e.Utils.debounce(s,50));e.ready(function(t){e.$('[data-mdp-scrollspy-nav]',t).each(function(){var t=e.$(this);if(!t.data('scrollspynav'))e.scrollspynav(t,e.Utils.options(t.attr('data-mdp-scrollspy-nav')))})})},init:function(){var n=[],i=this.find("a[href^='#']").each(function(){this.getAttribute('href').trim()!=='#'&&n.push(this.getAttribute('href'))}),a=e.$(n.join(",")),s=this.options.cls,o=this.options.closest||this.options.closest,d=this,_,u=function(){_=[];for(var n=0;n<a.length;n++)e.Utils.isInView(a.eq(n),d.options)&&_.push(a.eq(n));if(_.length){var r,u=t.scrollTop(),l=(function(){for(var e=0;e<_.length;e++){if(_[e].offset().top-d.options.topoffset>=u){return _[e]}}})();if(!l)return;d.options.closest?(i.blur().closest(o).removeClass(s),r=i.filter("a[href='#"+l.attr('id')+"']").closest(o).addClass(s)):(r=i.removeClass(s).filter("a[href='#"+l.attr("id")+"']").addClass(s));d.element.trigger('inview.uk.scrollspynav',[l,r])}};this.options.smoothscroll&&e.smoothScroll&&i.each(function(){e.smoothScroll(this,d.options.smoothscroll)});u();this.element.data('scrollspynav',this);this.check=u;r.push(this)}})}(UIkit2MD),!function(e){"use strict";var t=[];e.component('toggle',{defaults:{target:!1,cls:'mdp-hidden',animation:!1,duration:200},boot:function(){e.ready(function(n){e.$('[data-mdp-toggle]',n).each(function(){var t=e.$(this);if(!t.data('toggle'))e.toggle(t,e.Utils.options(t.attr('data-mdp-toggle')))});setTimeout(function(){t.forEach(function(e){e.getToggles()})},0)})},init:function(){var e=this;this.aria=this.options.cls.indexOf('mdp-hidden')!==-1;this.on('click',function(t){e.element.is('a[href="#"]')&&t.preventDefault();e.toggle()});t.push(this)},toggle:function(){this.getToggles();if(!this.totoggle.length)return;if(this.options.animation&&e.support.animation){var t=this,n=this.options.animation.split(',');n.length==1&&(n[1]=n[0]);n[0]=n[0].trim();n[1]=n[1].trim();this.totoggle.css('animation-duration',this.options.duration+'ms');this.totoggle.each(function(){var i=e.$(this);i.hasClass(t.options.cls)?(i.toggleClass(t.options.cls),e.Utils.animate(i,n[0]).then(function(){i.css('animation-duration','');e.Utils.checkDisplay(i)})):e.Utils.animate(this,n[1]+' mdp-animation-reverse').then(function(){i.toggleClass(t.options.cls).css('animation-duration','');e.Utils.checkDisplay(i)})})}else this.totoggle.toggleClass(this.options.cls),e.Utils.checkDisplay(this.totoggle);this.updateAria()},getToggles:function(){this.totoggle=this.options.target?e.$(this.options.target):[];this.updateAria()},updateAria:function(){this.aria&&this.totoggle.length&&this.totoggle.not('[aria-hidden]').each(function(){e.$(this).attr('aria-hidden',e.$(this).hasClass('mdp-hidden'))})}})}(UIkit2MD),!function(e){"use strict";e.component('alert',{defaults:{fade:!0,duration:200,trigger:'.mdp-alert-close'},boot:function(){e.$html.on('click.alert.uikit','[data-mdp-alert]',function(t){var n=e.$(this);if(!n.data('alert')){var i=e.alert(n,e.Utils.options(n.attr('data-mdp-alert')));e.$(t.target).is(i.options.trigger)&&(t.preventDefault(),i.close())}})},init:function(){var e=this;this.on('click',this.options.trigger,function(t){t.preventDefault();e.close()})},close:function(){var e=this.trigger('close.uk.alert'),t=function(){this.trigger('closed.uk.alert').remove()}.bind(this);this.options.fade?e.css('overflow','hidden').css("max-height",e.height()).animate({height:0,opacity:0,paddingTop:0,paddingBottom:0,marginTop:0,marginBottom:0},this.options.duration,t):t()}})}(UIkit2MD),!function(e){"use strict";e.component('buttonRadio',{defaults:{activeClass:'mdp-active',target:'.mdp-button'},boot:function(){e.$html.on('click.buttonradio.uikit','[data-mdp-button-radio]',function(t){var n=e.$(this);if(!n.data('buttonRadio')){var i=e.buttonRadio(n,e.Utils.options(n.attr('data-mdp-button-radio'))),a=e.$(t.target);a.is(i.options.target)&&a.trigger('click')}})},init:function(){var t=this;this.find(t.options.target).attr('aria-checked','false').filter('.'+t.options.activeClass).attr('aria-checked','true');this.on('click',this.options.target,function(n){var i=e.$(this);i.is('a[href="#"]')&&n.preventDefault();t.find(t.options.target).not(i).removeClass(t.options.activeClass).blur();i.addClass(t.options.activeClass);t.find(t.options.target).not(i).attr('aria-checked','false');i.attr('aria-checked','true');t.trigger('change.uk.button',[i])})},getSelected:function(){return this.find('.'+this.options.activeClass)}});e.component('buttonCheckbox',{defaults:{activeClass:'mdp-active',target:'.mdp-button'},boot:function(){e.$html.on('click.buttoncheckbox.uikit','[data-mdp-button-checkbox]',function(t){var n=e.$(this);if(!n.data('buttonCheckbox')){var i=e.buttonCheckbox(n,e.Utils.options(n.attr('data-mdp-button-checkbox'))),a=e.$(t.target);a.is(i.options.target)&&a.trigger('click')}})},init:function(){var t=this;this.find(t.options.target).attr('aria-checked','false').filter('.'+t.options.activeClass).attr('aria-checked','true');this.on('click',this.options.target,function(n){var i=e.$(this);i.is('a[href="#"]')&&n.preventDefault();i.toggleClass(t.options.activeClass).blur();i.attr('aria-checked',i.hasClass(t.options.activeClass));t.trigger('change.uk.button',[i])})},getSelected:function(){return this.find('.'+this.options.activeClass)}});e.component('button',{defaults:{},boot:function(){e.$html.on('click.button.uikit','[data-mdp-button]',function(t){var n=e.$(this);if(!n.data('button')){e.button(n,e.Utils.options(n.attr('data-mdp-button')));n.trigger('click')}})},init:function(){var e=this;this.element.attr('aria-pressed',this.element.hasClass("mdp-active"));this.on('click',function(t){e.element.is('a[href="#"]')&&t.preventDefault();e.toggle();e.trigger('change.uk.button',[e.element.blur().hasClass('mdp-active')])})},toggle:function(){this.element.toggleClass('mdp-active');this.element.attr('aria-pressed',this.element.hasClass('mdp-active'))}})}(UIkit2MD),!function(e){"use strict";var t=!1,n,i={x:{'bottom-left':'bottom-right','bottom-right':'bottom-left','bottom-center':'bottom-center','top-left':'top-right','top-right':'top-left','top-center':'top-center','left-top':'right-top','left-bottom':'right-bottom','left-center':'right-center','right-top':'left-top','right-bottom':'left-bottom','right-center':'left-center'},y:{'bottom-left':'top-left','bottom-right':'top-right','bottom-center':'top-center','top-left':'bottom-left','top-right':'bottom-right','top-center':'bottom-center','left-top':'left-bottom','left-bottom':'left-top','left-center':'left-center','right-top':'right-bottom','right-bottom':'right-top','right-center':'right-center'},xy:{'bottom-left':'top-right','bottom-right':'top-left','bottom-center':'top-center','top-left':'bottom-right','top-right':'bottom-left','top-center':'bottom-center','left-top':'right-bottom','left-bottom':'right-top','left-center':'right-center','right-top':'left-bottom','right-bottom':'left-top','right-center':'left-center'}};e.component('dropdown',{defaults:{mode:'hover',pos:'bottom-left',offset:0,remaintime:800,justify:!1,boundary:e.$win,delay:0,dropdownSelector:'.mdp-dropdown,.mdp-dropdown-blank',hoverDelayIdle:250,preventflip:!1},remainIdle:!1,boot:function(){var t=e.support.touch?'click':'mouseenter';e.$html.on(t+'.dropdown.uikit focus pointerdown','[data-mdp-dropdown]',function(n){var i=e.$(this);if(!i.data('dropdown')){var a=e.dropdown(i,e.Utils.options(i.attr('data-mdp-dropdown')));(n.type=='click'||n.type=='mouseenter'&&a.options.mode=='hover')&&a.element.trigger(t);a.dropdown.length&&n.preventDefault()}})},init:function(){var i=this;this.dropdown=this.find(this.options.dropdownSelector);this.offsetParent=this.dropdown.parents().filter(function(){return e.$.inArray(e.$(this).css('position'),['relative','fixed','absolute'])!==-1}).slice(0,1);this.offsetParent.length||(this.offsetParent=this.element);this.centered=this.dropdown.hasClass('mdp-dropdown-center');this.justified=this.options.justify?e.$(this.options.justify):!1;this.boundary=e.$(this.options.boundary);this.boundary.length||(this.boundary=e.$win);this.dropdown.hasClass('mdp-dropdown-up')&&(this.options.pos='top-left');this.dropdown.hasClass('mdp-dropdown-flip')&&(this.options.pos=this.options.pos.replace('left','right'));this.dropdown.hasClass('mdp-dropdown-center')&&(this.options.pos=this.options.pos.replace(/(left|right)/,'center'));this.element.attr('aria-haspopup','true');this.element.attr('aria-expanded',this.element.hasClass('mdp-open'));this.dropdown.attr('aria-hidden','true');this.options.mode=='click'||e.support.touch?this.on('click.uk.dropdown',function(t){var n=e.$(t.target);n.parents(i.options.dropdownSelector).length||((n.is("a[href='#']")||n.parent().is("a[href='#']")||i.dropdown.length&&!i.dropdown.is(':visible'))&&t.preventDefault(),n.blur());i.element.hasClass('mdp-open')?((!i.dropdown.find(t.target).length||n.is('.mdp-dropdown-close')||n.parents('.mdp-dropdown-close').length)&&i.hide()):i.show()}):this.on('mouseenter',function(e){i.trigger('pointerenter.uk.dropdown',[i]);i.remainIdle&&clearTimeout(i.remainIdle);n&&clearTimeout(n);if(t&&t==i){return}t&&t!=i?(n=setTimeout(function(){n=setTimeout(i.show.bind(i),i.options.delay)},i.options.hoverDelayIdle)):(n=setTimeout(i.show.bind(i),i.options.delay))}).on('mouseleave',function(){n&&clearTimeout(n);i.remainIdle=setTimeout(function(){t&&t==i&&i.hide()},i.options.remaintime);i.trigger('pointerleave.uk.dropdown',[i])}).on('click',function(n){var a=e.$(n.target);i.remainIdle&&clearTimeout(i.remainIdle);if(t&&t==i){(!i.dropdown.find(n.target).length||a.is('.mdp-dropdown-close')||a.parents('.mdp-dropdown-close').length)&&i.hide();return}(a.is("a[href='#']")||a.parent().is("a[href='#']"))&&n.preventDefault();i.show()})},show:function(){e.$html.off('click.outer.dropdown');t&&t!=this&&t.hide(!0);n&&clearTimeout(n);this.trigger('beforeshow.uk.dropdown',[this]);this.checkDimensions();this.element.addClass('mdp-open');this.element.attr('aria-expanded','true');this.dropdown.attr('aria-hidden','false');this.trigger('show.uk.dropdown',[this]);e.Utils.checkDisplay(this.dropdown,!0);e.Utils.focus(this.dropdown);t=this;this.registerOuterClick()},hide:function(e){this.trigger('beforehide.uk.dropdown',[this,e]);this.element.removeClass('mdp-open');this.remainIdle&&clearTimeout(this.remainIdle);this.remainIdle=!1;this.element.attr('aria-expanded','false');this.dropdown.attr('aria-hidden','true');this.trigger('hide.uk.dropdown',[this,e]);t==this&&(t=!1)},registerOuterClick:function(){var i=this;e.$html.off('click.outer.dropdown');setTimeout(function(){e.$html.on('click.outer.dropdown',function(a){n&&clearTimeout(n);e.$(a.target);t==i&&!i.element.find(a.target).length&&(i.hide(!0),e.$html.off('click.outer.dropdown'))})},10)},checkDimensions:function(){if(!this.dropdown.length)return;this.dropdown.removeClass('mdp-dropdown-top mdp-dropdown-bottom mdp-dropdown-left mdp-dropdown-right mdp-dropdown-stack mdp-dropdown-autoflip').css({topLeft:'',left:'',marginLeft:'',marginRight:''});this.justified&&this.justified.length&&this.dropdown.css('min-width','');this;var t=e.$.extend({},this.offsetParent.offset(),{width:this.offsetParent[0].offsetWidth,height:this.offsetParent[0].offsetHeight}),n=this.options.offset,r=this.dropdown;r.show().offset()||{left:0,top:0};var s=r.outerWidth(),o=r.outerHeight(),d=this.boundary.width();this.boundary[0]!==window&&this.boundary.offset()?this.boundary.offset():{top:0,left:0};var _=this.options.pos,u={'bottom-left':{top:0+t.height+n,left:0},'bottom-right':{top:0+t.height+n,left:0+t.width-s},'bottom-center':{top:0+t.height+n,left:0+t.width/2-s/2},'top-left':{top:0-o-n,left:0},'top-right':{top:0-o-n,left:0+t.width-s},'top-center':{top:0-o-n,left:0+t.width/2-s/2},'left-top':{top:0,left:0-s-n},'left-bottom':{top:0+t.height-o,left:0-s-n},'left-center':{top:0+t.height/2-o/2,left:0-s-n},'right-top':{top:0,left:0+t.width+n},'right-bottom':{top:0+t.height-o,left:0+t.width+n},'right-center':{top:0+t.height/2-o/2,left:0+t.width+n}},l={},m;m=_.split('-');l=u[_]?u[_]:u['bottom-left'];if(this.justified&&this.justified.length)a(r.css({left:0}),this.justified,d);else{if(this.options.preventflip!==!0){var p;switch(this.checkBoundary(t.left+l.left,t.top+l.top,s,o,d)){case "x":this.options.preventflip!=='x'&&(p=i.x[_]||'right-top');break;case "y":this.options.preventflip!=='y'&&(p=i.y[_]||'top-left');break;case "xy":this.options.preventflip||(p=i.xy[_]||'right-bottom');break}p&&(m=p.split('-'),l=u[p]?u[p]:u['bottom-left'],r.addClass('mdp-dropdown-autoflip'),this.checkBoundary(t.left+l.left,t.top+l.top,s,o,d)&&(m=_.split('-'),l=u[_]?u[_]:u['bottom-left']))}}s>d&&(r.addClass('mdp-dropdown-stack'),this.trigger('stack.uk.dropdown',[this]));r.css(l).css('display','').addClass('mdp-dropdown-'+m[0])},checkBoundary:function(t,n,i,a,r){var s="";(t<0||t-e.$win.scrollLeft()+i>r)&&(s+="x");(n-e.$win.scrollTop()<0||n-e.$win.scrollTop()+a>window.innerHeight)&&(s+="y");return s}});e.component('dropdownOverlay',{defaults:{justify:!1,cls:'',duration:200},boot:function(){e.ready(function(t){e.$('[data-mdp-dropdown-overlay]',t).each(function(){var t=e.$(this);t.data('dropdownOverlay')||e.dropdownOverlay(t,e.Utils.options(t.attr('data-mdp-dropdown-overlay')))})})},init:function(){var n=this;this.justified=this.options.justify?e.$(this.options.justify):!1;this.overlay=this.element.find('mdp-dropdown-overlay');this.overlay.length||(this.overlay=e.$('<div class="mdp-dropdown-overlay"></div>').appendTo(this.element));this.overlay.addClass(this.options.cls);this.on({'beforeshow.uk.dropdown':function(e,t){n.dropdown=t;n.justified&&n.justified.length&&a(n.overlay.css({display:'block',marginLeft:'',marginRight:''}),n.justified,n.justified.outerWidth())},'show.uk.dropdown':function(t,i){var a=n.dropdown.dropdown.outerHeight(!0);n.dropdown.element.removeClass('mdp-open');n.overlay.stop().css('display','block').animate({height:a},n.options.duration,function(){n.dropdown.dropdown.css('visibility','');n.dropdown.element.addClass('mdp-open');e.Utils.checkDisplay(n.dropdown.dropdown,!0)});n.pointerleave=!1},'hide.uk.dropdown':function(){n.overlay.stop().animate({height:0},n.options.duration)},'pointerenter.uk.dropdown':function(e,t){clearTimeout(n.remainIdle)},'pointerleave.uk.dropdown':function(e,t){n.pointerleave=!0}});this.overlay.on({'mouseenter':function(){n.remainIdle&&(clearTimeout(n.dropdown.remainIdle),clearTimeout(n.remainIdle))},'mouseleave':function(){n.pointerleave&&t&&(n.remainIdle=setTimeout(function(){t&&t.hide()},t.options.remaintime))}})}});function a(t,n,i,a){t=e.$(t);n=e.$(n);i=i||window.innerWidth;a=a||t.offset();if(n.length){var r=n.outerWidth();t.css('min-width',r);if(e.langdirection=='right'){var s=i-(n.offset().left+r),o=i-(t.offset().left+t.outerWidth());t.css('margin-right',s-o)}else t.css('margin-left',n.offset().left-a.left)}}}(UIkit2MD),!function(e){"use strict";var t=[];e.component('gridMatchHeight',{defaults:{target:!1,row:!0,ignorestacked:!1,observe:!1},boot:function(){e.ready(function(t){e.$('[data-mdp-grid-match]',t).each(function(){var t=e.$(this),n;t.data('gridMatchHeight')||(n=e.gridMatchHeight(t,e.Utils.options(t.attr('data-mdp-grid-match'))))})})},init:function(){var n=this;this.columns=this.element.children();this.elements=this.options.target?this.find(this.options.target):this.columns;if(!this.columns.length)return;e.$win.on('load resize orientationchange',(function(){var t=function(){n.element.is(':visible')&&n.match()};e.$(function(){t()});return e.Utils.debounce(t,50)})());this.options.observe&&e.domObserve(this.element,function(e){n.element.is(':visible')&&n.match()});this.on('display.uk.check',function(e){this.element.is(':visible')&&this.match()}.bind(this));t.push(this)},match:function(){var t=this.columns.filter(':visible:first');if(!t.length)return;var n=Math.ceil(100*parseFloat(t.css('width'))/parseFloat(t.parent().css('width')))>=100;n&&!this.options.ignorestacked?this.revert():e.Utils.matchHeights(this.elements,this.options);return this},revert:function(){this.elements.css('min-height','');return this}});e.component('gridMargin',{defaults:{cls:'mdp-grid-margin',rowfirst:'mdp-row-first'},boot:function(){e.ready(function(t){e.$('[data-mdp-grid-margin]',t).each(function(){var t=e.$(this),n;t.data('gridMargin')||(n=e.gridMargin(t,e.Utils.options(t.attr('data-mdp-grid-margin'))))})})},init:function(){e.stackMargin(this.element,this.options)}})}(UIkit2MD),!function(e){"use strict";var t=!1,n=0,i=e.$html,a;e.$win.on('resize orientationchange',e.Utils.debounce(function(){e.$('.mdp-modal.mdp-open').each(function(){return e.$(this).data('modal')&&e.$(this).data('modal').resize()})},150));e.component('modal',{defaults:{keyboard:!0,bgclose:!0,minScrollHeight:150,center:!1,modal:!0},scrollable:!1,transition:!1,hasTransitioned:!0,init:function(){a||(a=e.$('body'));if(!this.element.length)return;var t=this;this.paddingdir='padding-'+(e.langdirection=='left'?'right':'left');this.dialog=this.find('.mdp-modal-dialog');this.active=!1;this.element.attr('aria-hidden',this.element.hasClass('mdp-open'));this.on('click','.mdp-modal-close',function(e){e.preventDefault();t.hide()}).on('click',function(n){var i=e.$(n.target);i[0]==t.element[0]&&t.options.bgclose&&t.hide()});e.domObserve(this.element,function(e){t.resize()})},toggle:function(){return this[this.isActive()?'hide':'show']()},show:function(){if(!this.element.length)return;var a=this;if(this.isActive())return;this.options.modal&&t&&t.hide(!0);this.element.removeClass('mdp-open').show();this.resize(!0);this.options.modal&&(t=this);this.active=!0;n++;e.support.transition?(this.hasTransitioned=!1,this.element.one(e.support.transition.end,function(){a.hasTransitioned=!0;e.Utils.focus(a.dialog,'a[href]')}).addClass('mdp-open')):(this.element.addClass('mdp-open'),e.Utils.focus(this.dialog,'a[href]'));i.addClass('mdp-modal-page').height();this.element.attr('aria-hidden','false');this.element.trigger('show.uk.modal');e.Utils.checkDisplay(this.dialog,!0);return this},hide:function(t){if(!t&&e.support.transition&&this.hasTransitioned){var n=this;this.one(e.support.transition.end,function(){n._hide()}).removeClass('mdp-open')}else this._hide();return this},resize:function(e){if(!this.isActive()&&!e)return;var t=a.width();this.scrollbarwidth=window.innerWidth-t;a.css(this.paddingdir,this.scrollbarwidth);this.element.css('overflow-y',this.scrollbarwidth?'scroll':'auto');if(!this.updateScrollable()&&this.options.center){var n=this.dialog.outerHeight(),i=parseInt(this.dialog.css('margin-top'),10)+parseInt(this.dialog.css('margin-bottom'),10);n+i<window.innerHeight?this.dialog.css({top:window.innerHeight/2-n/2-i}):this.dialog.css({top:''})}},updateScrollable:function(){var e=this.dialog.find('.mdp-overflow-container:visible:first');if(e.length){e.css('height',0);var t=Math.abs(parseInt(this.dialog.css('margin-top'),10)),n=this.dialog.outerHeight(),i=window.innerHeight,a=i-2*(t<20?20:t)-n;e.css({maxHeight:a<this.options.minScrollHeight?'':a,height:''});return!0}return!1},_hide:function(){this.active=!1;n>0?n--:(n=0);this.element.hide().removeClass('mdp-open');this.element.attr('aria-hidden','true');n||(i.removeClass('mdp-modal-page'),a.css(this.paddingdir,""));t===this&&(t=!1);this.trigger('hide.uk.modal')},isActive:function(){return this.element.hasClass('mdp-open')}});e.component('modalTrigger',{boot:function(){e.$html.on('click.modal.uikit','[data-mdp-modal]',function(t){var n=e.$(this);n.is('a')&&t.preventDefault();if(!n.data('modalTrigger')){var i=e.modalTrigger(n,e.Utils.options(n.attr('data-mdp-modal')));i.show()}});e.$html.on('keydown.modal.uikit',function(e){t&&e.keyCode===27&&t.options.keyboard&&(e.preventDefault(),t.hide())})},init:function(){var t=this;this.options=e.$.extend({target:t.element.is('a')?t.element.attr('href'):!1},this.options);this.modal=e.modal(this.options.target,this.options);this.on("click",function(e){e.preventDefault();t.show()});this.proxy(this.modal,'show hide isActive')}});e.modal.dialog=function(t,n){var i=e.modal(e.$(e.modal.dialog.template).appendTo('body'),n);i.on('hide.uk.modal',function(){i.persist&&(i.persist.appendTo(i.persist.data('modalPersistParent')),i.persist=!1);i.element.remove()});r(t,i);return i};e.modal.dialog.template='<div class="mdp-modal"><div class="mdp-modal-dialog" style="min-height:0;"></div></div>';e.modal.alert=function(t,n){n=e.$.extend(!0,{bgclose:!1,keyboard:!1,modal:!1,labels:e.modal.labels},n);var i=e.modal.dialog((['<div class="mdp-margin mdp-modal-content">'+String(t)+'</div>','<div class="mdp-modal-footer mdp-text-right"><button class="mdp-button mdp-button-primary mdp-modal-close">'+n.labels.Ok+'</button></div>']).join(""),n);i.on('show.uk.modal',function(){setTimeout(function(){i.element.find('button:first').focus()},50)});return i.show()};e.modal.confirm=function(t,n,i){var a=arguments.length>1&&arguments[arguments.length-1]?arguments[arguments.length-1]:{};n=e.$.isFunction(n)?n:function(){};i=e.$.isFunction(i)?i:function(){};a=e.$.extend(!0,{bgclose:!1,keyboard:!1,modal:!1,labels:e.modal.labels},e.$.isFunction(a)?{}:a);var r=e.modal.dialog((['<div class="mdp-margin mdp-modal-content">'+String(t)+'</div>','<div class="mdp-modal-footer mdp-text-right"><button class="mdp-button js-modal-confirm-cancel">'+a.labels.Cancel+'</button> <button class="mdp-button mdp-button-primary js-modal-confirm">'+a.labels.Ok+'</button></div>']).join(""),a);r.element.find(".js-modal-confirm, .js-modal-confirm-cancel").on("click",function(){e.$(this).is('.js-modal-confirm')?n():i();r.hide()});r.on('show.uk.modal',function(){setTimeout(function(){r.element.find('.js-modal-confirm').focus()},50)});return r.show()};e.modal.prompt=function(t,n,i,a){i=e.$.isFunction(i)?i:function(e){};a=e.$.extend(!0,{bgclose:!1,keyboard:!1,modal:!1,labels:e.modal.labels},a);var r=e.modal.dialog(([t?'<div class="mdp-modal-content mdp-form">'+String(t)+'</div>':'','<div class="mdp-margin-small-top mdp-modal-content mdp-form"><p><input type="text" class="mdp-width-1-1"></p></div>','<div class="mdp-modal-footer mdp-text-right"><button class="mdp-button mdp-modal-close">'+a.labels.Cancel+'</button> <button class="mdp-button mdp-button-primary js-modal-ok">'+a.labels.Ok+'</button></div>']).join(""),a),s=r.element.find("input[type='text']").val(n||'').on('keyup',function(e){e.keyCode==13&&r.element.find('.js-modal-ok').trigger('click')});r.element.find('.js-modal-ok').on('click',function(){i(s.val())!==!1&&r.hide()});return r.show()};e.modal.blockUI=function(t,n){var i=e.modal.dialog((['<div class="mdp-margin mdp-modal-content">'+String(t||'<div class="mdp-text-center">...</div>')+'</div>']).join(""),e.$.extend({bgclose:!1,keyboard:!1,modal:!1},n));i.content=i.element.find('.mdp-modal-content:first');return i.show()};e.modal.labels={Ok:'Ok',Cancel:'Cancel'};function r(t,n){if(!n)return;typeof t==='object'?(t=t instanceof jQuery?t:e.$(t),t.parent().length&&(n.persist=t,n.persist.data('modalPersistParent',t.parent()))):typeof t==='string'||typeof t==='number'?(t=e.$('<div></div>').html(t)):(t=e.$('<div></div>').html('UIkit2MD.modal Error: Unsupported data type: '+typeof t));t.appendTo(n.element.find('.mdp-modal-dialog'));return n}}(UIkit2MD),!function(e){"use strict";e.component('nav',{defaults:{toggle:'>li.mdp-parent > a[href="#"]',lists:'>li.mdp-parent > ul',multiple:!1},boot:function(){e.ready(function(t){e.$('[data-mdp-nav]',t).each(function(){var t=e.$(this);if(!t.data('nav'))e.nav(t,e.Utils.options(t.attr('data-mdp-nav')))})})},init:function(){var t=this;this.on('click.uk.nav',this.options.toggle,function(n){n.preventDefault();var i=e.$(this);t.open(i.parent()[0]==t.element[0]?i:i.parent("li"))});this.update();e.domObserve(this.element,function(e){t.element.find(t.options.lists).not('[role]').length&&t.update()})},update:function(){var t=this;this.find(this.options.lists).each(function(){var n=e.$(this).attr('role','menu'),i=n.closest('li'),a=i.hasClass("mdp-active");i.data('list-container')||(n.wrap('<div style="overflow:hidden;height:0;position:relative;"></div>'),i.data('list-container',n.parent()[a?'removeClass':'addClass']('mdp-hidden')));i.attr('aria-expanded',i.hasClass("mdp-open"));a&&t.open(i,!0)})},open:function(n,i){var a=this,r=this.element,s=e.$(n),o=s.data('list-container');this.options.multiple||r.children('.mdp-open').not(n).each(function(){var t=e.$(this);t.data('list-container')&&t.data('list-container').stop().animate({height:0},function(){e.$(this).parent().removeClass('mdp-open').end().addClass('mdp-hidden')})});s.toggleClass('mdp-open');s.attr('aria-expanded',s.hasClass('mdp-open'));o&&(s.hasClass('mdp-open')&&o.removeClass('mdp-hidden'),i?(o.stop().height(s.hasClass('mdp-open')?'auto':0),s.hasClass('mdp-open')||o.addClass('mdp-hidden'),this.trigger('display.uk.check')):o.stop().animate({height:s.hasClass('mdp-open')?t(o.find('ul:first')):0},function(){s.hasClass('mdp-open')?o.css('height',''):o.addClass('mdp-hidden');a.trigger('display.uk.check')}))}});function t(t){var n=e.$(t),i='auto';if(n.is(':visible'))i=n.outerHeight();else{var a={position:n.css('position'),visibility:n.css('visibility'),display:n.css('display')};i=n.css({position:'absolute',visibility:'hidden',display:'block'}).outerHeight();n.css(a)}return i}}(UIkit2MD),!function(e){"use strict";var t={x:window.scrollX,y:window.scrollY};e.$win;e.$doc;var n=e.$html,i={show:function(i,a){i=e.$(i);if(!i.length)return;a=e.$.extend({mode:'push'},a);var r=e.$('body'),s=i.find('.mdp-offcanvas-bar:first'),o=e.langdirection=='right',d=s.hasClass('mdp-offcanvas-bar-flip')?-1:1,_=d*(o?-1:1),u=window.innerWidth-r.width();t={x:window.pageXOffset,y:window.pageYOffset};s.attr('mode',a.mode);i.addClass('mdp-active');r.css({width:window.innerWidth-u,height:window.innerHeight}).addClass('mdp-offcanvas-page');(a.mode=='push'||a.mode=='reveal')&&r.css((o?'margin-right':'margin-left'),(o?-1:1)*(s.outerWidth()*_));a.mode=='reveal'&&s.css('clip','rect(0, '+s.outerWidth()+'px, 100vh, 0)');n.css('margin-top',t.y*-1).width();s.addClass('mdp-offcanvas-bar-show');this._initElement(i);s.trigger('show.uk.offcanvas',[i,s]);i.attr('aria-hidden','false')},hide:function(i){var a=e.$('body'),r=e.$('.mdp-offcanvas.mdp-active'),s=e.langdirection=='right',o=r.find('.mdp-offcanvas-bar:first'),d=function(){a.removeClass('mdp-offcanvas-page').css({width:'',height:'',marginLeft:'',marginRight:''});r.removeClass('mdp-active');o.removeClass('mdp-offcanvas-bar-show');n.css('margin-top','');window.scrollTo(t.x,t.y);o.trigger('hide.uk.offcanvas',[r,o]);r.attr('aria-hidden','true')};if(!r.length)return;o.attr('mode')=='none'&&(i=!0);e.support.transition&&!i?(a.one(e.support.transition.end,function(){d()}).css((s?'margin-right':'margin-left'),''),o.attr('mode')=='reveal'&&o.css('clip',''),setTimeout(function(){o.removeClass('mdp-offcanvas-bar-show')},0)):d()},_initElement:function(t){if(t.data('OffcanvasInit'))return;t.on('click.uk.offcanvas swipeRight.uk.offcanvas swipeLeft.uk.offcanvas',function(t){var n=e.$(t.target);if(!t.type.match(/swipe/)){if(!n.hasClass('mdp-offcanvas-close')){if(n.hasClass('mdp-offcanvas-bar'))return;if(n.parents('.mdp-offcanvas-bar:first').length)return}}t.stopImmediatePropagation();i.hide()});t.on('click','a[href*="#"]',function(t){var n=e.$(this),a=n.attr('href');if(a=='#'){return}e.$doc.one('hide.uk.offcanvas',function(){var t;try{t=e.$(n[0].hash)}catch(e){t=''};t.length||(t=e.$('[name="'+n[0].hash.replace('#','')+'"]'));t.length&&e.Utils.scrollToElement?e.Utils.scrollToElement(t,e.Utils.options(n.attr('data-mdp-smooth-scroll')||'{}')):(window.location.href=a)});i.hide()});t.data('OffcanvasInit',!0)}};e.component('offcanvasTrigger',{boot:function(){n.on('click.offcanvas.uikit','[data-mdp-offcanvas]',function(t){t.preventDefault();var n=e.$(this);if(!n.data('offcanvasTrigger')){e.offcanvasTrigger(n,e.Utils.options(n.attr('data-mdp-offcanvas')));n.trigger("click")}});n.on('keydown.uk.offcanvas',function(e){e.keyCode===27&&i.hide()})},init:function(){var t=this;this.options=e.$.extend({target:t.element.is('a')?t.element.attr('href'):!1,mode:'push'},this.options);this.on('click',function(e){e.preventDefault();i.show(t.options.target,t.options)})}});e.offcanvas=i}(UIkit2MD),!function(e){"use strict";var t;e.component('switcher',{defaults:{connect:!1,toggle:'>*',active:0,animation:!1,duration:200,swiping:!0},animating:!1,boot:function(){e.ready(function(t){e.$('[data-mdp-switcher]',t).each(function(){var t=e.$(this);if(!t.data('switcher'))e.switcher(t,e.Utils.options(t.attr('data-mdp-switcher')))})})},init:function(){var t=this;this.on('click.uk.switcher',this.options.toggle,function(e){e.preventDefault();t.show(this)});if(!this.options.connect){return}this.connect=e.$(this.options.connect);if(!this.connect.length){return}this.connect.on('click.uk.switcher','[data-mdp-switcher-item]',function(n){n.preventDefault();var i=e.$(this).attr('data-mdp-switcher-item');if(t.index==i)return;switch(i){case 'next':;case 'previous':t.show(t.index+(i=='next'?1:-1));break;default:t.show(parseInt(i,10))}});this.options.swiping&&this.connect.on('swipeRight swipeLeft',function(e){e.preventDefault();window.getSelection().toString()||t.show(t.index+(e.type=='swipeLeft'?1:-1))});this.update()},update:function(){this.connect.children().removeClass('mdp-active').attr('aria-hidden','true');var e=this.find(this.options.toggle),t=e.filter('.mdp-active');if(t.length)this.show(t,!1);else{if(this.options.active===!1)return;t=e.eq(this.options.active);this.show(t.length?t:e.eq(0),!1)}e.not(t).attr('aria-expanded','false');t.attr('aria-expanded','true')},show:function(i,a){if(this.animating){return}var r=this.find(this.options.toggle);isNaN(i)?(i=e.$(i)):(i=i<0?r.length-1:i,i=r.eq(r[i]?i:0));var s=this,o=e.$(i),d=t[this.options.animation]||function(e,i){if(!s.options.animation){return t.none.apply(s)}var a=s.options.animation.split(',');a.length==1&&(a[1]=a[0]);a[0]=a[0].trim();a[1]=a[1].trim();return n.apply(s,[a,e,i])};(a===!1||!e.support.animation)&&(d=t.none);if(o.hasClass("mdp-disabled"))return;r.attr('aria-expanded','false');o.attr('aria-expanded','true');r.filter(".mdp-active").removeClass("mdp-active");o.addClass("mdp-active");this.options.connect&&this.connect.length&&(this.index=this.find(this.options.toggle).index(o),this.index==-1&&(this.index=0),this.connect.each(function(){var t=e.$(this),n=e.$(t.children()),i=e.$(n.filter('.mdp-active')),a=e.$(n.eq(s.index));s.animating=!0;d.apply(s,[i,a]).then(function(){i.removeClass("mdp-active");a.addClass("mdp-active");i.attr('aria-hidden','true');a.attr('aria-hidden','false');e.Utils.checkDisplay(a,!0);s.animating=!1})}));this.trigger("show.uk.switcher",[o])}});t={'none':function(){var t=e.$.Deferred();t.resolve();return t.promise()},'fade':function(e,t){return n.apply(this,['mdp-animation-fade',e,t])},'slide-bottom':function(e,t){return n.apply(this,['mdp-animation-slide-bottom',e,t])},'slide-top':function(e,t){return n.apply(this,['mdp-animation-slide-top',e,t])},'slide-vertical':function(e,t,i){var a=['mdp-animation-slide-top','mdp-animation-slide-bottom'];e&&e.index()>t.index()&&a.reverse();return n.apply(this,[a,e,t])},'slide-left':function(e,t){return n.apply(this,['mdp-animation-slide-left',e,t])},'slide-right':function(e,t){return n.apply(this,['mdp-animation-slide-right',e,t])},'slide-horizontal':function(e,t,i){var a=['mdp-animation-slide-right','mdp-animation-slide-left'];e&&e.index()>t.index()&&a.reverse();return n.apply(this,[a,e,t])},'scale':function(e,t){return n.apply(this,['mdp-animation-scale-up',e,t])}};e.switcher.animations=t;function n(t,n,i){var a=e.$.Deferred(),r=t,s=t,o;if(i[0]===n[0]){a.resolve();return a.promise()}typeof t=='object'&&(r=t[0],s=t[1]||t[0]);e.$body.css('overflow-x','hidden');o=function(){n&&n.hide().removeClass('mdp-active '+s+' mdp-animation-reverse');i.addClass(r).one(e.support.animation.end,function(){setTimeout(function(){i.removeClass(''+r+'').css({opacity:'',display:''})},0);a.resolve();e.$body.css('overflow-x','');n&&n.css({opacity:'',display:''})}.bind(this)).show()};i.css('animation-duration',this.options.duration+'ms');n&&n.length?(n.css('animation-duration',this.options.duration+'ms'),n.css('display','none').addClass(s+' mdp-animation-reverse').one(e.support.animation.end,function(){o()}.bind(this)).css('display','')):(i.addClass('mdp-active'),o());return a.promise()}}(UIkit2MD),!function(e){"use strict";e.component('tab',{defaults:{target:'>li:not(.mdp-tab-responsive, .mdp-disabled)',connect:!1,active:0,animation:!1,duration:200,swiping:!0},boot:function(){e.ready(function(t){e.$('[data-mdp-tab]',t).each(function(){var t=e.$(this);if(!t.data('tab'))e.tab(t,e.Utils.options(t.attr('data-mdp-tab')))})})},init:function(){var t=this;this.current=!1;this.on('click.uk.tab',this.options.target,function(n){n.preventDefault();if(t.switcher&&t.switcher.animating){return}var i=t.find(t.options.target).not(this);i.removeClass('mdp-active').blur();t.trigger('change.uk.tab',[e.$(this).addClass('mdp-active'),t.current]);t.current=e.$(this);t.options.connect||(i.attr('aria-expanded','false'),e.$(this).attr('aria-expanded','true'))});this.options.connect&&(this.connect=e.$(this.options.connect));this.responsivetab=e.$('<li class="mdp-tab-responsive mdp-active"><a></a></li>').append('<div class="mdp-dropdown mdp-dropdown-small"><ul class="mdp-nav mdp-nav-dropdown"></ul><div>');this.responsivetab.dropdown=this.responsivetab.find('.mdp-dropdown');this.responsivetab.lst=this.responsivetab.dropdown.find('ul');this.responsivetab.caption=this.responsivetab.find('a:first');this.element.hasClass('mdp-tab-bottom')&&this.responsivetab.dropdown.addClass('mdp-dropdown-up');this.responsivetab.lst.on('click.uk.tab','a',function(n){n.preventDefault();n.stopPropagation();var i=e.$(this);t.element.children('li:not(.mdp-tab-responsive)').eq(i.data('index')).trigger('click')});this.on('show.uk.switcher change.uk.tab',function(e,n){t.responsivetab.caption.html(n.text())});this.element.append(this.responsivetab);this.options.connect&&(this.switcher=e.switcher(this.element,{toggle:'>li:not(.mdp-tab-responsive)',connect:this.options.connect,active:this.options.active,animation:this.options.animation,duration:this.options.duration,swiping:this.options.swiping}));e.dropdown(this.responsivetab,{mode:'click',preventflip:'y'});t.trigger('change.uk.tab',[this.element.find(this.options.target).not('.mdp-tab-responsive').filter('.mdp-active')]);this.check();e.$win.on('resize orientationchange',e.Utils.debounce(function(){t.element.is(':visible')&&t.check()},100));this.on('display.uk.check',function(){t.element.is(':visible')&&t.check()})},check:function(){var t=this.element.children('li:not(.mdp-tab-responsive)').removeClass('mdp-hidden');if(!t.length){this.responsivetab.addClass('mdp-hidden');return}var n=t.eq(0).offset().top+Math.ceil(t.eq(0).height()/2),i=!1,a,r,s;this.responsivetab.lst.empty();t.each(function(){e.$(this).offset().top>n&&(i=!0)});if(i){for(var o=0;o<t.length;o++)a=e.$(t.eq(o)),r=a.find('a'),a.css('float')!='none'&&!a.attr('mdp-dropdown')&&(a.hasClass('mdp-disabled')||(s=e.$(a[0].outerHTML),s.find('a').data('index',o),this.responsivetab.lst.append(s)),a.addClass('mdp-hidden'))}this.responsivetab[this.responsivetab.lst.children('li').length?'removeClass':'addClass']('mdp-hidden')}})}(UIkit2MD),!function(e){"use strict";e.component('cover',{defaults:{automute:!0},boot:function(){e.ready(function(t){e.$('[data-mdp-cover]',t).each(function(){var t=e.$(this);if(!t.data('cover'))e.cover(t,e.Utils.options(t.attr('data-mdp-cover')))})})},init:function(){this.parent=this.element.parent();e.$win.on('load resize orientationchange',e.Utils.debounce(function(){this.check()}.bind(this),100));this.on('display.uk.check',function(e){this.element.is(':visible')&&this.check()}.bind(this));this.check();if(this.element.is('iframe')&&this.options.automute){var t=this.element.attr('src');this.element.attr('src','').on('load',function(){this.contentWindow.postMessage('{ "event": "command", "func": "mute", "method":"setVolume", "value":0}','*')}).attr('src',[t,t.indexOf('?')>-1?'&':'?','enablejsapi=1&api=1'].join(''))}},check:function(){this.element.css({width:'',height:''});this.dimension={w:this.element.width(),h:this.element.height()};this.element.attr('width')&&!isNaN(this.element.attr('width'))&&(this.dimension.w=this.element.attr('width'));this.element.attr('height')&&!isNaN(this.element.attr('height'))&&(this.dimension.h=this.element.attr('height'));this.ratio=this.dimension.w/this.dimension.h;var e=this.parent.width(),t=this.parent.height(),n,i;e/this.ratio<t?(n=Math.ceil(t*this.ratio),i=t):(n=e,i=Math.ceil(e/this.ratio));this.element.css({width:n,height:i})}})}(UIkit2MD),!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){"use strict";function e(){return Xi.apply(null,arguments)}function t(e){Xi=e}function n(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function i(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function a(e,t){var n,i=[];for(n=0;n<e.length;++n)i.push(t(e[n],n));return i}function r(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function s(e,t){for(var n in t)r(t,n)&&(e[n]=t[n]);return r(t,"toString")&&(e.toString=t.toString),r(t,"valueOf")&&(e.valueOf=t.valueOf),e}function o(e,t,n,i){return Oe(e,t,n,i,!0).utc()}function d(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1}}function _(e){return null==e._pf&&(e._pf=d()),e._pf}function u(e){if(null==e._isValid){var t=_(e);e._isValid=!(isNaN(e._d.getTime())||!(t.overflow<0)||t.empty||t.invalidMonth||t.invalidWeekday||t.nullInput||t.invalidFormat||t.userInvalidated),e._strict&&(e._isValid=e._isValid&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour)}return e._isValid}function l(e){var t=o(NaN);return null!=e?s(_(t),e):_(t).userInvalidated=!0,t}function m(e){return void 0===e}function p(e,t){var n,i,a;if(m(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),m(t._i)||(e._i=t._i),m(t._f)||(e._f=t._f),m(t._l)||(e._l=t._l),m(t._strict)||(e._strict=t._strict),m(t._tzm)||(e._tzm=t._tzm),m(t._isUTC)||(e._isUTC=t._isUTC),m(t._offset)||(e._offset=t._offset),m(t._pf)||(e._pf=_(t)),m(t._locale)||(e._locale=t._locale),Bi.length>0)for(n in Bi)i=Bi[n],a=t[i],m(a)||(e[i]=a);return e}function c(t){p(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),Ki===!1&&(Ki=!0,e.updateOffset(this),Ki=!1)}function f(e){return e instanceof c||null!=e&&null!=e._isAMomentObject}function h(e){return 0>e?Math.ceil(e):Math.floor(e)}function M(e){var t=+e,n=0;return 0!==t&&isFinite(t)&&(n=h(t)),n}function Y(e,t,n){var i,a=Math.min(e.length,t.length),r=Math.abs(e.length-t.length),s=0;for(i=0;a>i;i++)(n&&e[i]!==t[i]||!n&&M(e[i])!==M(t[i]))&&s++;return s+r}function g(t){e.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function b(e,t){var n=!0;return s(function(){return n&&(g(e+"\nArguments: "+Array.prototype.slice.call(arguments).join(", ")+"\n"+(new Error).stack),n=!1),t.apply(this,arguments)},t)}function k(e,t){Qi[e]||(g(t),Qi[e]=!0)}function v(e){return e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function D(e){return"[object Object]"===Object.prototype.toString.call(e)}function T(e){var t,n;for(n in e)t=e[n],v(t)?this[n]=t:this["_"+n]=t;this._config=e,this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+"\\d{1,2}")}function L(e,t){var n,i=s({},e);for(n in t)r(t,n)&&(D(e[n])&&D(t[n])?(i[n]={},s(i[n],e[n]),s(i[n],t[n])):null!=t[n]?i[n]=t[n]:delete i[n]);return i}function y(e){null!=e&&this.set(e)}function H(e){return e?e.toLowerCase().replace("_","-"):e}function w(e){for(var t,n,i,a,r=0;r<e.length;){for(a=H(e[r]).split("-"),t=a.length,n=H(e[r+1]),n=n?n.split("-"):null;t>0;){if(i=j(a.slice(0,t).join("-")))return i;if(n&&n.length>=t&&Y(a,n,!0)>=t-1)break;t--}r++}return null}function j(e){var t=null;if(!ea[e]&&"undefined"!=typeof module&&module&&module.exports)try{t=Zi._abbr,require("./locale/"+e),x(t)}catch(e){};return ea[e]}function x(e,t){var n;return e&&(n=m(t)?A(e):S(e,t),n&&(Zi=n)),Zi._abbr}function S(e,t){return null!==t?(t.abbr=e,null!=ea[e]?(k("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale"),t=L(ea[e]._config,t)):null!=t.parentLocale&&(null!=ea[t.parentLocale]?t=L(ea[t.parentLocale]._config,t):k("parentLocaleUndefined","specified parentLocale is not defined yet")),ea[e]=new y(t),x(e),ea[e]):(delete ea[e],null)}function C(e,t){if(null!=t){var n;null!=ea[e]&&(t=L(ea[e]._config,t)),n=new y(t),n.parentLocale=ea[e],ea[e]=n,x(e)}else null!=ea[e]&&(null!=ea[e].parentLocale?ea[e]=ea[e].parentLocale:null!=ea[e]&&delete ea[e]);return ea[e]}function A(e){var t;if(e&&e._locale&&e._locale._abbr&&(e=e._locale._abbr),!e)return Zi;if(!n(e)){if(t=j(e))return t;e=[e]}return w(e)}function O(){return Object.keys(ea)}function z(e,t){var n=e.toLowerCase();ta[n]=ta[n+"s"]=ta[t]=e}function P(e){return"string"==typeof e?ta[e]||ta[e.toLowerCase()]:void 0}function $(e){var t,n,i={};for(n in e)r(e,n)&&(t=P(n),t&&(i[t]=e[n]));return i}function J(t,n){return function(i){return null!=i?(I(this,t,i),e.updateOffset(this,n),this):F(this,t)}}function F(e,t){return e.isValid()?e._d["get"+(e._isUTC?"UTC":"")+t]():NaN}function I(e,t,n){e.isValid()&&e._d["set"+(e._isUTC?"UTC":"")+t](n)}function W(e,t){var n;if("object"==typeof e)for(n in e)this.set(n,e[n]);else if(e=P(e),v(this[e]))return this[e](t);return this}function U(e,t,n){var i=""+Math.abs(e),a=t-i.length,r=e>=0;return(r?n?"+":"":"-")+Math.pow(10,Math.max(0,a)).toString().substr(1)+i}function E(e,t,n,i){var a=i;"string"==typeof i&&(a=function(){return this[i]()}),e&&(ra[e]=a),t&&(ra[t[0]]=function(){return U(a.apply(this,arguments),t[1],t[2])}),n&&(ra[n]=function(){return this.localeData().ordinal(a.apply(this,arguments),e)})}function V(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function q(e){var t,n,i=e.match(na);for(t=0,n=i.length;n>t;t++)ra[i[t]]?i[t]=ra[i[t]]:i[t]=V(i[t]);return function(a){var r="";for(t=0;n>t;t++)r+=i[t] instanceof Function?i[t].call(a,e):i[t];return r}}function N(e,t){return e.isValid()?(t=G(t,e.localeData()),aa[t]=aa[t]||q(t),aa[t](e)):e.localeData().invalidDate()}function G(e,t){function n(e){return t.longDateFormat(e)||e}var i=5;for(ia.lastIndex=0;i>=0&&ia.test(e);)e=e.replace(ia,n),ia.lastIndex=0,i-=1;return e}function R(e,t,n){Da[e]=v(t)?t:function(e,i){return e&&n?n:t}}function X(e,t){return r(Da,e)?Da[e](t._strict,t._locale):new RegExp(B(e))}function B(e){return K(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(e,t,n,i,a){return t||n||i||a}))}function K(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function Q(e,t){var n,i=t;for("string"==typeof e&&(e=[e]),"number"==typeof t&&(i=function(e,n){n[t]=M(e)}),n=0;n<e.length;n++)Ta[e[n]]=i}function Z(e,t){Q(e,function(e,n,i,a){i._w=i._w||{},t(e,i._w,i,a)})}function ee(e,t,n){null!=t&&r(Ta,e)&&Ta[e](t,n._a,n,e)}function te(e,t){return new Date(Date.UTC(e,t+1,0)).getUTCDate()}function ne(e,t){return n(this._months)?this._months[e.month()]:this._months[Oa.test(t)?"format":"standalone"][e.month()]}function ie(e,t){return n(this._monthsShort)?this._monthsShort[e.month()]:this._monthsShort[Oa.test(t)?"format":"standalone"][e.month()]}function ae(e,t,n){var i,a,r;for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),i=0;12>i;i++){if(a=o([2e3,i]),n&&!this._longMonthsParse[i]&&(this._longMonthsParse[i]=new RegExp("^"+this.months(a,"").replace(".","")+"$","i"),this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(a,"").replace(".","")+"$","i")),n||this._monthsParse[i]||(r="^"+this.months(a,"")+"|^"+this.monthsShort(a,""),this._monthsParse[i]=new RegExp(r.replace(".",""),"i")),n&&"MMMM"===t&&this._longMonthsParse[i].test(e))return i;if(n&&"MMM"===t&&this._shortMonthsParse[i].test(e))return i;if(!n&&this._monthsParse[i].test(e))return i}}function re(e,t){var n;if(!e.isValid())return e;if("string"==typeof t)if(/^\d+$/.test(t))t=M(t);else if(t=e.localeData().monthsParse(t),"number"!=typeof t)return e;return n=Math.min(e.date(),te(e.year(),t)),e._d["set"+(e._isUTC?"UTC":"")+"Month"](t,n),e}function se(t){return null!=t?(re(this,t),e.updateOffset(this,!0),this):F(this,"Month")}function oe(){return te(this.year(),this.month())}function de(e){return this._monthsParseExact?(r(this,"_monthsRegex")||ue.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex}function _e(e){return this._monthsParseExact?(r(this,"_monthsRegex")||ue.call(this),e?this._monthsStrictRegex:this._monthsRegex):this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex}function ue(){function e(e,t){return t.length-e.length}var t,n,i=[],a=[],r=[];for(t=0;12>t;t++)n=o([2e3,t]),i.push(this.monthsShort(n,"")),a.push(this.months(n,"")),r.push(this.months(n,"")),r.push(this.monthsShort(n,""));for(i.sort(e),a.sort(e),r.sort(e),t=0;12>t;t++)i[t]=K(i[t]),a[t]=K(a[t]),r[t]=K(r[t]);this._monthsRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+a.join("|")+")$","i"),this._monthsShortStrictRegex=new RegExp("^("+i.join("|")+")$","i")}function le(e){var t,n=e._a;return n&&-2===_(e).overflow&&(t=n[ya]<0||n[ya]>11?ya:n[Ha]<1||n[Ha]>te(n[La],n[ya])?Ha:n[wa]<0||n[wa]>24||24===n[wa]&&(0!==n[ja]||0!==n[xa]||0!==n[Sa])?wa:n[ja]<0||n[ja]>59?ja:n[xa]<0||n[xa]>59?xa:n[Sa]<0||n[Sa]>999?Sa:-1,_(e)._overflowDayOfYear&&(La>t||t>Ha)&&(t=Ha),_(e)._overflowWeeks&&-1===t&&(t=Ca),_(e)._overflowWeekday&&-1===t&&(t=Aa),_(e).overflow=t),e}function me(e){var t,n,i,a,r,s,o=e._i,d=Fa.exec(o)||Ia.exec(o);if(d){for(_(e).iso=!0,t=0,n=Ua.length;n>t;t++)if(Ua[t][1].exec(d[1])){a=Ua[t][0],i=Ua[t][2]!==!1;break};if(null==a)return void(e._isValid=!1);if(d[3]){for(t=0,n=Ea.length;n>t;t++)if(Ea[t][1].exec(d[3])){r=(d[2]||" ")+Ea[t][0];break};if(null==r)return void(e._isValid=!1)}if(!i&&null!=r)return void(e._isValid=!1);if(d[4]){if(!Wa.exec(d[4]))return void(e._isValid=!1);s="Z"}e._f=a+(r||"")+(s||""),He(e)}else e._isValid=!1}function pe(t){var n=Va.exec(t._i);return null!==n?void(t._d=new Date(+n[1])):(me(t),void(t._isValid===!1&&(delete t._isValid,e.createFromInputFallback(t))))}function ce(e,t,n,i,a,r,s){var o=new Date(e,t,n,i,a,r,s);return 100>e&&e>=0&&isFinite(o.getFullYear())&&o.setFullYear(e),o}function fe(e){var t=new Date(Date.UTC.apply(null,arguments));return 100>e&&e>=0&&isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e),t}function he(e){return Me(e)?366:365}function Me(e){return e%4===0&&e%100!==0||e%400===0}function Ye(){return Me(this.year())}function ge(e,t,n){var i=7+t-n,a=(7+fe(e,0,i).getUTCDay()-t)%7;return-a+i-1}function be(e,t,n,i,a){var r,s,o=(7+n-i)%7,d=ge(e,i,a),_=1+7*(t-1)+o+d;return 0>=_?(r=e-1,s=he(r)+_):_>he(e)?(r=e+1,s=_-he(e)):(r=e,s=_),{year:r,dayOfYear:s}}function ke(e,t,n){var i,a,r=ge(e.year(),t,n),s=Math.floor((e.dayOfYear()-r-1)/7)+1;return 1>s?(a=e.year()-1,i=s+ve(a,t,n)):s>ve(e.year(),t,n)?(i=s-ve(e.year(),t,n),a=e.year()+1):(a=e.year(),i=s),{week:i,year:a}}function ve(e,t,n){var i=ge(e,t,n),a=ge(e+1,t,n);return(he(e)-i+a)/7}function De(e,t,n){return null!=e?e:null!=t?t:n}function Te(t){var n=new Date(e.now());return t._useUTC?[n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate()]:[n.getFullYear(),n.getMonth(),n.getDate()]}function Le(e){var t,n,i,a,r=[];if(!e._d){for(i=Te(e),e._w&&null==e._a[Ha]&&null==e._a[ya]&&ye(e),e._dayOfYear&&(a=De(e._a[La],i[La]),e._dayOfYear>he(a)&&(_(e)._overflowDayOfYear=!0),n=fe(a,0,e._dayOfYear),e._a[ya]=n.getUTCMonth(),e._a[Ha]=n.getUTCDate()),t=0;3>t&&null==e._a[t];++t)e._a[t]=r[t]=i[t];for(;7>t;t++)e._a[t]=r[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[wa]&&0===e._a[ja]&&0===e._a[xa]&&0===e._a[Sa]&&(e._nextDay=!0,e._a[wa]=0),e._d=(e._useUTC?fe:ce).apply(null,r),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[wa]=24)}}function ye(e){var t,n,i,a,r,s,o,d;t=e._w,null!=t.GG||null!=t.W||null!=t.E?(r=1,s=4,n=De(t.GG,e._a[La],ke(ze(),1,4).year),i=De(t.W,1),a=De(t.E,1),(1>a||a>7)&&(d=!0)):(r=e._locale._week.dow,s=e._locale._week.doy,n=De(t.gg,e._a[La],ke(ze(),r,s).year),i=De(t.w,1),null!=t.d?(a=t.d,(0>a||a>6)&&(d=!0)):null!=t.e?(a=t.e+r,(t.e<0||t.e>6)&&(d=!0)):a=r),1>i||i>ve(n,r,s)?_(e)._overflowWeeks=!0:null!=d?_(e)._overflowWeekday=!0:(o=be(n,i,a,r,s),e._a[La]=o.year,e._dayOfYear=o.dayOfYear)}function He(t){if(t._f===e.ISO_8601)return void me(t);t._a=[],_(t).empty=!0;var n,i,a,r,s,o=""+t._i,d=o.length,u=0;for(a=G(t._f,t._locale).match(na)||[],n=0;n<a.length;n++)r=a[n],i=(o.match(X(r,t))||[])[0],i&&(s=o.substr(0,o.indexOf(i)),s.length>0&&_(t).unusedInput.push(s),o=o.slice(o.indexOf(i)+i.length),u+=i.length),ra[r]?(i?_(t).empty=!1:_(t).unusedTokens.push(r),ee(r,i,t)):t._strict&&!i&&_(t).unusedTokens.push(r);_(t).charsLeftOver=d-u,o.length>0&&_(t).unusedInput.push(o),_(t).bigHour===!0&&t._a[wa]<=12&&t._a[wa]>0&&(_(t).bigHour=void 0),t._a[wa]=we(t._locale,t._a[wa],t._meridiem),Le(t),le(t)}function we(e,t,n){var i;return null==n?t:null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?(i=e.isPM(n),i&&12>t&&(t+=12),i||12!==t||(t=0),t):t}function je(e){var t,n,i,a,r;if(0===e._f.length)return _(e).invalidFormat=!0,void(e._d=new Date(NaN));for(a=0;a<e._f.length;a++)r=0,t=p({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[a],He(t),u(t)&&(r+=_(t).charsLeftOver,r+=10*_(t).unusedTokens.length,_(t).score=r,(null==i||i>r)&&(i=r,n=t));s(e,n||t)}function xe(e){if(!e._d){var t=$(e._i);e._a=a([t.year,t.month,t.day||t.date,t.hour,t.minute,t.second,t.millisecond],function(e){return e&&parseInt(e,10)}),Le(e)}}function Se(e){var t=new c(le(Ce(e)));return t._nextDay&&(t.add(1,"d"),t._nextDay=void 0),t}function Ce(e){var t=e._i,a=e._f;return e._locale=e._locale||A(e._l),null===t||void 0===a&&""===t?l({nullInput:!0}):("string"==typeof t&&(e._i=t=e._locale.preparse(t)),f(t)?new c(le(t)):(n(a)?je(e):a?He(e):i(t)?e._d=t:Ae(e),u(e)||(e._d=null),e))}function Ae(t){var r=t._i;void 0===r?t._d=new Date(e.now()):i(r)?t._d=new Date(+r):"string"==typeof r?pe(t):n(r)?(t._a=a(r.slice(0),function(e){return parseInt(e,10)}),Le(t)):"object"==typeof r?xe(t):"number"==typeof r?t._d=new Date(r):e.createFromInputFallback(t)}function Oe(e,t,n,i,a){var r={};return"boolean"==typeof n&&(i=n,n=void 0),r._isAMomentObject=!0,r._useUTC=r._isUTC=a,r._l=n,r._i=e,r._f=t,r._strict=i,Se(r)}function ze(e,t,n,i){return Oe(e,t,n,i,!1)}function Pe(e,t){var i,a;if(1===t.length&&n(t[0])&&(t=t[0]),!t.length)return ze();for(i=t[0],a=1;a<t.length;++a)(!t[a].isValid()||t[a][e](i))&&(i=t[a]);return i}function $e(){var e=[].slice.call(arguments,0);return Pe("isBefore",e)}function Je(){var e=[].slice.call(arguments,0);return Pe("isAfter",e)}function Fe(e){var t=$(e),n=t.year||0,i=t.quarter||0,a=t.month||0,r=t.week||0,s=t.day||0,o=t.hour||0,d=t.minute||0,_=t.second||0,u=t.millisecond||0;this._milliseconds=+u+1e3*_+6e4*d+3.6e6*o,this._days=+s+7*r,this._months=+a+3*i+12*n,this._data={},this._locale=A(),this._bubble()}function Ie(e){return e instanceof Fe}function We(e,t){E(e,0,0,function(){var e=this.utcOffset(),n="+";return 0>e&&(e=-e,n="-"),n+U(~~(e/60),2)+t+U(~~e%60,2)})}function Ue(e,t){var n=(t||"").match(e)||[],i=n[n.length-1]||[],a=(i+"").match(Xa)||["-",0,0],r=+(60*a[1])+M(a[2]);return"+"===a[0]?r:-r}function Ee(t,n){var a,r;return n._isUTC?(a=n.clone(),r=(f(t)||i(t)?+t:+ze(t))-+a,a._d.setTime(+a._d+r),e.updateOffset(a,!1),a):ze(t).local()}function Ve(e){return 15*-Math.round(e._d.getTimezoneOffset()/15)}function qe(t,n){var i,a=this._offset||0;return this.isValid()?null!=t?("string"==typeof t?t=Ue(ba,t):Math.abs(t)<16&&(t*=60),!this._isUTC&&n&&(i=Ve(this)),this._offset=t,this._isUTC=!0,null!=i&&this.add(i,"m"),a!==t&&(!n||this._changeInProgress?dt(this,nt(t-a,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,e.updateOffset(this,!0),this._changeInProgress=null)),this):this._isUTC?a:Ve(this):null!=t?this:NaN}function Ne(e,t){return null!=e?("string"!=typeof e&&(e=-e),this.utcOffset(e,t),this):-this.utcOffset()}function Ge(e){return this.utcOffset(0,e)}function Re(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(Ve(this),"m")),this}function Xe(){return this._tzm?this.utcOffset(this._tzm):"string"==typeof this._i&&this.utcOffset(Ue(ga,this._i)),this}function Be(e){return this.isValid()?(e=e?ze(e).utcOffset():0,(this.utcOffset()-e)%60===0):!1}function Ke(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Qe(){if(!m(this._isDSTShifted))return this._isDSTShifted;var e={};if(p(e,this),e=Ce(e),e._a){var t=e._isUTC?o(e._a):ze(e._a);this._isDSTShifted=this.isValid()&&Y(e._a,t.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Ze(){return this.isValid()?!this._isUTC:!1}function et(){return this.isValid()?this._isUTC:!1}function tt(){return this.isValid()?this._isUTC&&0===this._offset:!1}function nt(e,t){var n,i,a,s=e,o=null;return Ie(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:"number"==typeof e?(s={},t?s[t]=e:s.milliseconds=e):(o=Ba.exec(e))?(n="-"===o[1]?-1:1,s={y:0,d:M(o[Ha])*n,h:M(o[wa])*n,m:M(o[ja])*n,s:M(o[xa])*n,ms:M(o[Sa])*n}):(o=Ka.exec(e))?(n="-"===o[1]?-1:1,s={y:it(o[2],n),M:it(o[3],n),w:it(o[4],n),d:it(o[5],n),h:it(o[6],n),m:it(o[7],n),s:it(o[8],n)}):null==s?s={}:"object"==typeof s&&("from" in s||"to" in s)&&(a=rt(ze(s.from),ze(s.to)),s={},s.ms=a.milliseconds,s.M=a.months),i=new Fe(s),Ie(e)&&r(e,"_locale")&&(i._locale=e._locale),i}function it(e,t){var n=e&&parseFloat(e.replace(",","."));return(isNaN(n)?0:n)*t}function at(e,t){var n={milliseconds:0,months:0};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,"M").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,"M"),n}function rt(e,t){var n;return e.isValid()&&t.isValid()?(t=Ee(t,e),e.isBefore(t)?n=at(e,t):(n=at(t,e),n.milliseconds=-n.milliseconds,n.months=-n.months),n):{milliseconds:0,months:0}}function st(e){return 0>e?-1*Math.round(-1*e):Math.round(e)}function ot(e,t){return function(n,i){var a,r;return null===i||isNaN(+i)||(k(t,"moment()."+t+"(period, number) is deprecated. Please use moment()."+t+"(number, period)."),r=n,n=i,i=r),n="string"==typeof n?+n:n,a=nt(n,i),dt(this,a,e),this}}function dt(t,n,i,a){var r=n._milliseconds,s=st(n._days),o=st(n._months);t.isValid()&&(a=null==a?!0:a,r&&t._d.setTime(+t._d+r*i),s&&I(t,"Date",F(t,"Date")+s*i),o&&re(t,F(t,"Month")+o*i),a&&e.updateOffset(t,s||o))}function _t(e,t){var n=e||ze(),i=Ee(n,this).startOf("day"),a=this.diff(i,"days",!0),r=-6>a?"sameElse":-1>a?"lastWeek":0>a?"lastDay":1>a?"sameDay":2>a?"nextDay":7>a?"nextWeek":"sameElse",s=t&&(v(t[r])?t[r]():t[r]);return this.format(s||this.localeData().calendar(r,this,ze(n)))}function ut(){return new c(this)}function lt(e,t){var n=f(e)?e:ze(e);return this.isValid()&&n.isValid()?(t=P(m(t)?"millisecond":t),"millisecond"===t?+this>+n:+n<+this.clone().startOf(t)):!1}function mt(e,t){var n=f(e)?e:ze(e);return this.isValid()&&n.isValid()?(t=P(m(t)?"millisecond":t),"millisecond"===t?+n>+this:+this.clone().endOf(t)<+n):!1}function pt(e,t,n){return this.isAfter(e,n)&&this.isBefore(t,n)}function ct(e,t){var n,i=f(e)?e:ze(e);return this.isValid()&&i.isValid()?(t=P(t||"millisecond"),"millisecond"===t?+this===+i:(n=+i,+this.clone().startOf(t)<=n&&n<=+this.clone().endOf(t))):!1}function ft(e,t){return this.isSame(e,t)||this.isAfter(e,t)}function ht(e,t){return this.isSame(e,t)||this.isBefore(e,t)}function Mt(e,t,n){var i,a,r,s;return this.isValid()?(i=Ee(e,this),i.isValid()?(a=6e4*(i.utcOffset()-this.utcOffset()),t=P(t),"year"===t||"month"===t||"quarter"===t?(s=Yt(this,i),"quarter"===t?s/=3:"year"===t&&(s/=12)):(r=this-i,s="second"===t?r/1e3:"minute"===t?r/6e4:"hour"===t?r/3.6e6:"day"===t?(r-a)/8.64e7:"week"===t?(r-a)/6.048e8:r),n?s:h(s)):NaN):NaN}function Yt(e,t){var n,i,a=12*(t.year()-e.year())+(t.month()-e.month()),r=e.clone().add(a,"months");return 0>t-r?(n=e.clone().add(a-1,"months"),i=(t-r)/(r-n)):(n=e.clone().add(a+1,"months"),i=(t-r)/(n-r)),-(a+i)}function gt(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function bt(){var e=this.clone().utc();return 0<e.year()&&e.year()<=9999?v(Date.prototype.toISOString)?this.toDate().toISOString():N(e,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):N(e,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function kt(t){var n=N(this,t||e.defaultFormat);return this.localeData().postformat(n)}function vt(e,t){return this.isValid()&&(f(e)&&e.isValid()||ze(e).isValid())?nt({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function Dt(e){return this.from(ze(),e)}function Tt(e,t){return this.isValid()&&(f(e)&&e.isValid()||ze(e).isValid())?nt({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()}function Lt(e){return this.to(ze(),e)}function yt(e){var t;return void 0===e?this._locale._abbr:(t=A(e),null!=t&&(this._locale=t),this)}function Ht(){return this._locale}function wt(e){switch(e=P(e)){case"year":this.month(0);case"quarter":;case"month":this.date(1);case"week":;case"isoWeek":;case"day":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return"week"===e&&this.weekday(0),"isoWeek"===e&&this.isoWeekday(1),"quarter"===e&&this.month(3*Math.floor(this.month()/3)),this}function jt(e){return e=P(e),void 0===e||"millisecond"===e?this:this.startOf(e).add(1,"isoWeek"===e?"week":e).subtract(1,"ms")}function xt(){return+this._d-6e4*(this._offset||0)}function St(){return Math.floor(+this/1e3)}function Ct(){return this._offset?new Date(+this):this._d}function At(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]}function Ot(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}}function zt(){return this.isValid()?this.toISOString():null}function Pt(){return u(this)}function $t(){return s({},_(this))}function Jt(){return _(this).overflow}function Ft(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function It(e,t){E(0,[e,e.length],0,t)}function Wt(e){return qt.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function Ut(e){return qt.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)}function Et(){return ve(this.year(),1,4)}function Vt(){var e=this.localeData()._week;return ve(this.year(),e.dow,e.doy)}function qt(e,t,n,i,a){var r;return null==e?ke(this,i,a).year:(r=ve(e,i,a),t>r&&(t=r),Nt.call(this,e,t,n,i,a))}function Nt(e,t,n,i,a){var r=be(e,t,n,i,a),s=fe(r.year,0,r.dayOfYear);return this.year(s.getUTCFullYear()),this.month(s.getUTCMonth()),this.date(s.getUTCDate()),this}function Gt(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)}function Rt(e){return ke(e,this._week.dow,this._week.doy).week}function Xt(){return this._week.dow}function Bt(){return this._week.doy}function Kt(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")}function Qt(e){var t=ke(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")}function Zt(e,t){return"string"!=typeof e?e:isNaN(e)?(e=t.weekdaysParse(e),"number"==typeof e?e:null):parseInt(e,10)}function en(e,t){return n(this._weekdays)?this._weekdays[e.day()]:this._weekdays[this._weekdays.isFormat.test(t)?"format":"standalone"][e.day()]}function tn(e){return this._weekdaysShort[e.day()]}function nn(e){return this._weekdaysMin[e.day()]}function an(e,t,n){var i,a,r;for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),i=0;7>i;i++){if(a=ze([2e3,1]).day(i),n&&!this._fullWeekdaysParse[i]&&(this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(a,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(a,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(a,"").replace(".",".?")+"$","i")),this._weekdaysParse[i]||(r="^"+this.weekdays(a,"")+"|^"+this.weekdaysShort(a,"")+"|^"+this.weekdaysMin(a,""),this._weekdaysParse[i]=new RegExp(r.replace(".",""),"i")),n&&"dddd"===t&&this._fullWeekdaysParse[i].test(e))return i;if(n&&"ddd"===t&&this._shortWeekdaysParse[i].test(e))return i;if(n&&"dd"===t&&this._minWeekdaysParse[i].test(e))return i;if(!n&&this._weekdaysParse[i].test(e))return i}}function rn(e){if(!this.isValid())return null!=e?this:NaN;var t=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(e=Zt(e,this.localeData()),this.add(e-t,"d")):t}function sn(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,"d")}function on(e){return this.isValid()?null==e?this.day()||7:this.day(this.day()%7?e:e-7):null!=e?this:NaN}function dn(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/8.64e7)+1;return null==e?t:this.add(e-t,"d")}function _n(){return this.hours()%12||12}function un(e,t){E(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function ln(e,t){return t._meridiemParse}function mn(e){return"p"===(e+"").toLowerCase().charAt(0)}function pn(e,t,n){return e>11?n?"pm":"PM":n?"am":"AM"}function cn(e,t){t[Sa]=M(1e3*("0."+e))}function fn(){return this._isUTC?"UTC":""}function hn(){return this._isUTC?"Coordinated Universal Time":""}function Mn(e){return ze(1e3*e)}function Yn(){return ze.apply(null,arguments).parseZone()}function gn(e,t,n){var i=this._calendar[e];return v(i)?i.call(t,n):i}function bn(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.replace(/MMMM|MM|DD|dddd/g,function(e){return e.slice(1)}),this._longDateFormat[e])}function kn(){return this._invalidDate}function vn(e){return this._ordinal.replace("%d",e)}function Dn(e){return e}function Tn(e,t,n,i){var a=this._relativeTime[n];return v(a)?a(e,t,n,i):a.replace(/%d/i,e)}function Ln(e,t){var n=this._relativeTime[e>0?"future":"past"];return v(n)?n(t):n.replace(/%s/i,t)}function yn(e,t,n,i){var a=A(),r=o().set(i,t);return a[n](r,e)}function Hn(e,t,n,i,a){if("number"==typeof e&&(t=e,e=void 0),e=e||"",null!=t)return yn(e,t,n,a);var r,s=[];for(r=0;i>r;r++)s[r]=yn(e,r,n,a);return s}function wn(e,t){return Hn(e,t,"months",12,"month")}function jn(e,t){return Hn(e,t,"monthsShort",12,"month")}function xn(e,t){return Hn(e,t,"weekdays",7,"day")}function Sn(e,t){return Hn(e,t,"weekdaysShort",7,"day")}function Cn(e,t){return Hn(e,t,"weekdaysMin",7,"day")}function An(){var e=this._data;return this._milliseconds=kr(this._milliseconds),this._days=kr(this._days),this._months=kr(this._months),e.milliseconds=kr(e.milliseconds),e.seconds=kr(e.seconds),e.minutes=kr(e.minutes),e.hours=kr(e.hours),e.months=kr(e.months),e.years=kr(e.years),this}function On(e,t,n,i){var a=nt(t,n);return e._milliseconds+=i*a._milliseconds,e._days+=i*a._days,e._months+=i*a._months,e._bubble()}function zn(e,t){return On(this,e,t,1)}function Pn(e,t){return On(this,e,t,-1)}function $n(e){return 0>e?Math.floor(e):Math.ceil(e)}function Jn(){var e,t,n,i,a,r=this._milliseconds,s=this._days,o=this._months,d=this._data;return r>=0&&s>=0&&o>=0||0>=r&&0>=s&&0>=o||(r+=8.64e7*$n(In(o)+s),s=0,o=0),d.milliseconds=r%1e3,e=h(r/1e3),d.seconds=e%60,t=h(e/60),d.minutes=t%60,n=h(t/60),d.hours=n%24,s+=h(n/24),a=h(Fn(s)),o+=a,s-=$n(In(a)),i=h(o/12),o%=12,d.days=s,d.months=o,d.years=i,this}function Fn(e){return 4800*e/146097}function In(e){return 146097*e/4800}function Wn(e){var t,n,i=this._milliseconds;if(e=P(e),"month"===e||"year"===e)return t=this._days+i/8.64e7,n=this._months+Fn(t),"month"===e?n:n/12;switch(t=this._days+Math.round(In(this._months)),e){case"week":return t/7+i/6.048e8;case"day":return t+i/8.64e7;case"hour":return 24*t+i/3.6e6;case"minute":return 1440*t+i/6e4;case"second":return 86400*t+i/1e3;case"millisecond":return Math.floor(8.64e7*t)+i;default:throw new Error("Unknown unit "+e)}}function Un(){return this._milliseconds+8.64e7*this._days+this._months%12*2.592e9+3.1536e10*M(this._months/12)}function En(e){return function(){return this.as(e)}}function Vn(e){return e=P(e),this[e+"s"]()}function qn(e){return function(){return this._data[e]}}function Nn(){return h(this.days()/7)}function Gn(e,t,n,i,a){return a.relativeTime(t||1,!!n,e,i)}function Rn(e,t,n){var i=nt(e).abs(),a=$r(i.as("s")),r=$r(i.as("m")),s=$r(i.as("h")),o=$r(i.as("d")),d=$r(i.as("M")),_=$r(i.as("y")),u=a<Jr.s&&["s",a]||1>=r&&["m"]||r<Jr.m&&["mm",r]||1>=s&&["h"]||s<Jr.h&&["hh",s]||1>=o&&["d"]||o<Jr.d&&["dd",o]||1>=d&&["M"]||d<Jr.M&&["MM",d]||1>=_&&["y"]||["yy",_];return u[2]=t,u[3]=+e>0,u[4]=n,Gn.apply(null,u)}function Xn(e,t){return void 0===Jr[e]?!1:void 0===t?Jr[e]:(Jr[e]=t,!0)}function Bn(e){var t=this.localeData(),n=Rn(this,!e,t);return e&&(n=t.pastFuture(+this,n)),t.postformat(n)}function Kn(){var e,t,n,i=Fr(this._milliseconds)/1e3,a=Fr(this._days),r=Fr(this._months);e=h(i/60),t=h(e/60),i%=60,e%=60,n=h(r/12),r%=12;var s=n,o=r,d=a,_=t,u=e,l=i,m=this.asSeconds();return m?(0>m?"-":"")+"P"+(s?s+"Y":"")+(o?o+"M":"")+(d?d+"D":"")+(_||u||l?"T":"")+(_?_+"H":"")+(u?u+"M":"")+(l?l+"S":""):"P0D"}function Qn(e,t){var n=e.split("_");return t%10===1&&t%100!==11?n[0]:t%10>=2&&4>=t%10&&(10>t%100||t%100>=20)?n[1]:n[2]}function Zn(e,t,n){var i={mm:t?"хвіліна_хвіліны_хвілін":"хвіліну_хвіліны_хвілін",hh:t?"гадзіна_гадзіны_гадзін":"гадзіну_гадзіны_гадзін",dd:"дзень_дні_дзён",MM:"месяц_месяцы_месяцаў",yy:"год_гады_гадоў"};return"m"===n?t?"хвіліна":"хвіліну":"h"===n?t?"гадзіна":"гадзіну":e+" "+Qn(i[n],+e)}function ei(e,t,n){var i={mm:"munutenn",MM:"miz",dd:"devezh"};return e+" "+ii(i[n],e)}function ti(e){switch(ni(e)){case 1:;case 3:;case 4:;case 5:;case 9:return e+" bloaz";default:return e+" vloaz"}}function ni(e){return e>9?ni(e%10):e}function ii(e,t){return 2===t?ai(e):e}function ai(e){var t={m:"v",b:"v",d:"z"};return void 0===t[e.charAt(0)]?e:t[e.charAt(0)]+e.substring(1)}function ri(e,t,n){var i=e+" ";switch(n){case"m":return t?"jedna minuta":"jedne minute";case"mm":return i+=1===e?"minuta":2===e||3===e||4===e?"minute":"minuta";case"h":return t?"jedan sat":"jednog sata";case"hh":return i+=1===e?"sat":2===e||3===e||4===e?"sata":"sati";case"dd":return i+=1===e?"dan":"dana";case"MM":return i+=1===e?"mjesec":2===e||3===e||4===e?"mjeseca":"mjeseci";case"yy":return i+=1===e?"godina":2===e||3===e||4===e?"godine":"godina"}}function si(e){return e>1&&5>e&&1!==~~(e/10)}function oi(e,t,n,i){var a=e+" ";switch(n){case"s":return t||i?"pár sekund":"pár sekundami";case"m":return t?"minuta":i?"minutu":"minutou";case"mm":return t||i?a+(si(e)?"minuty":"minut"):a+"minutami";case"h":return t?"hodina":i?"hodinu":"hodinou";case"hh":return t||i?a+(si(e)?"hodiny":"hodin"):a+"hodinami";case"d":return t||i?"den":"dnem";case"dd":return t||i?a+(si(e)?"dny":"dní"):a+"dny";case"M":return t||i?"měsíc":"měsícem";case"MM":return t||i?a+(si(e)?"měsíce":"měsíců"):a+"měsíci";case"y":return t||i?"rok":"rokem";case"yy":return t||i?a+(si(e)?"roky":"let"):a+"lety"}}function di(e,t,n,i){var a={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[e+" Tage",e+" Tagen"],M:["ein Monat","einem Monat"],MM:[e+" Monate",e+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[e+" Jahre",e+" Jahren"]};return t?a[n][0]:a[n][1]}function _i(e,t,n,i){var a={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[e+" Tage",e+" Tagen"],M:["ein Monat","einem Monat"],MM:[e+" Monate",e+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[e+" Jahre",e+" Jahren"]};return t?a[n][0]:a[n][1]}function ui(e,t,n,i){var a={s:["mõne sekundi","mõni sekund","paar sekundit"],m:["ühe minuti","üks minut"],mm:[e+" minuti",e+" minutit"],h:["ühe tunni","tund aega","üks tund"],hh:[e+" tunni",e+" tundi"],d:["ühe päeva","üks päev"],M:["kuu aja","kuu aega","üks kuu"],MM:[e+" kuu",e+" kuud"],y:["ühe aasta","aasta","üks aasta"],yy:[e+" aasta",e+" aastat"]};return t?a[n][2]?a[n][2]:a[n][1]:i?a[n][0]:a[n][1]}function li(e,t,n,i){var a="";switch(n){case"s":return i?"muutaman sekunnin":"muutama sekunti";case"m":return i?"minuutin":"minuutti";case"mm":a=i?"minuutin":"minuuttia";break;case"h":return i?"tunnin":"tunti";case"hh":a=i?"tunnin":"tuntia";break;case"d":return i?"päivän":"päivä";case"dd":a=i?"päivän":"päivää";break;case"M":return i?"kuukauden":"kuukausi";case"MM":a=i?"kuukauden":"kuukautta";break;case"y":return i?"vuoden":"vuosi";case"yy":a=i?"vuoden":"vuotta"}return a=mi(e,i)+" "+a}function mi(e,t){return 10>e?t?us[e]:_s[e]:e}function pi(e,t,n){var i=e+" ";switch(n){case"m":return t?"jedna minuta":"jedne minute";case"mm":return i+=1===e?"minuta":2===e||3===e||4===e?"minute":"minuta";case"h":return t?"jedan sat":"jednog sata";case"hh":return i+=1===e?"sat":2===e||3===e||4===e?"sata":"sati";case"dd":return i+=1===e?"dan":"dana";case"MM":return i+=1===e?"mjesec":2===e||3===e||4===e?"mjeseca":"mjeseci";case"yy":return i+=1===e?"godina":2===e||3===e||4===e?"godine":"godina"}}function ci(e,t,n,i){var a=e;switch(n){case"s":return i||t?"néhány másodperc":"néhány másodperce";case"m":return"egy"+(i||t?" perc":" perce");case"mm":return a+(i||t?" perc":" perce");case"h":return"egy"+(i||t?" óra":" órája");case"hh":return a+(i||t?" óra":" órája");case"d":return"egy"+(i||t?" nap":" napja");case"dd":return a+(i||t?" nap":" napja");case"M":return"egy"+(i||t?" hónap":" hónapja");case"MM":return a+(i||t?" hónap":" hónapja");case"y":return"egy"+(i||t?" év":" éve");case"yy":return a+(i||t?" év":" éve")}return""}function fi(e){return(e?"":"[múlt] ")+"["+bs[this.day()]+"] LT[-kor]"}function hi(e){return e%100===11?!0:e%10===1?!1:!0}function Mi(e,t,n,i){var a=e+" ";switch(n){case"s":return t||i?"nokkrar sekúndur":"nokkrum sekúndum";case"m":return t?"mínúta":"mínútu";case"mm":return hi(e)?a+(t||i?"mínútur":"mínútum"):t?a+"mínúta":a+"mínútu";case"hh":return hi(e)?a+(t||i?"klukkustundir":"klukkustundum"):a+"klukkustund";case"d":return t?"dagur":i?"dag":"degi";case"dd":return hi(e)?t?a+"dagar":a+(i?"daga":"dögum"):t?a+"dagur":a+(i?"dag":"degi");case"M":return t?"mánuður":i?"mánuð":"mánuði";case"MM":return hi(e)?t?a+"mánuðir":a+(i?"mánuði":"mánuðum"):t?a+"mánuður":a+(i?"mánuð":"mánuði");case"y":return t||i?"ár":"ári";case"yy":return hi(e)?a+(t||i?"ár":"árum"):a+(t||i?"ár":"ári")}}function Yi(e,t,n,i){var a={m:["eng Minutt","enger Minutt"],h:["eng Stonn","enger Stonn"],d:["een Dag","engem Dag"],M:["ee Mount","engem Mount"],y:["ee Joer","engem Joer"]};return t?a[n][0]:a[n][1]}function gi(e){var t=e.substr(0,e.indexOf(" "));return ki(t)?"a "+e:"an "+e}function bi(e){var t=e.substr(0,e.indexOf(" "));return ki(t)?"viru "+e:"virun "+e}function ki(e){if(e=parseInt(e,10),isNaN(e))return!1;if(0>e)return!0;if(10>e)return e>=4&&7>=e?!0:!1;if(100>e){var t=e%10,n=e/10;return ki(0===t?n:t)}if(1e4>e){for(;e>=10;)e/=10;return ki(e)}return e/=1e3,ki(e)}function vi(e,t,n,i){return t?"kelios sekundės":i?"kelių sekundžių":"kelias sekundes"}function Di(e,t,n,i){return t?Li(n)[0]:i?Li(n)[1]:Li(n)[2]}function Ti(e){return e%10===0||e>10&&20>e}function Li(e){return vs[e].split("_")}function yi(e,t,n,i){var a=e+" ";return 1===e?a+Di(e,t,n[0],i):t?a+(Ti(e)?Li(n)[1]:Li(n)[0]):i?a+Li(n)[1]:a+(Ti(e)?Li(n)[1]:Li(n)[2])}function Hi(e,t,n){return n?t%10===1&&11!==t?e[2]:e[3]:t%10===1&&11!==t?e[0]:e[1]}function wi(e,t,n){return e+" "+Hi(Ds[n],e,t)}function ji(e,t,n){return Hi(Ds[n],e,t)}function xi(e,t){return t?"dažas sekundes":"dažām sekundēm"}function Si(e,t,n,i){var a="";if(t)switch(n){case"s":a="काही सेकंद";break;case"m":a="एक मिनिट";break;case"mm":a="%d मिनिटे";break;case"h":a="एक तास";break;case"hh":a="%d तास";break;case"d":a="एक दिवस";break;case"dd":a="%d दिवस";break;case"M":a="एक महिना";break;case"MM":a="%d महिने";break;case"y":a="एक वर्ष";break;case"yy":a="%d वर्षे"}else switch(n){case"s":a="काही सेकंदां";break;case"m":a="एका मिनिटा";break;case"mm":a="%d मिनिटां";break;case"h":a="एका तासा";break;case"hh":a="%d तासां";break;case"d":a="एका दिवसा";break;case"dd":a="%d दिवसां";break;case"M":a="एका महिन्या";break;case"MM":a="%d महिन्यां";break;case"y":a="एका वर्षा";break;case"yy":a="%d वर्षां"};return a.replace(/%d/i,e)}function Ci(e){return 5>e%10&&e%10>1&&~~(e/10)%10!==1}function Ai(e,t,n){var i=e+" ";switch(n){case"m":return t?"minuta":"minutę";case"mm":return i+(Ci(e)?"minuty":"minut");case"h":return t?"godzina":"godzinę";case"hh":return i+(Ci(e)?"godziny":"godzin");case"MM":return i+(Ci(e)?"miesiące":"miesięcy");case"yy":return i+(Ci(e)?"lata":"lat")}}function Oi(e,t,n){var i={mm:"minute",hh:"ore",dd:"zile",MM:"luni",yy:"ani"},a=" ";return(e%100>=20||e>=100&&e%100===0)&&(a=" de "),e+a+i[n]}function zi(e,t){var n=e.split("_");return t%10===1&&t%100!==11?n[0]:t%10>=2&&4>=t%10&&(10>t%100||t%100>=20)?n[1]:n[2]}function Pi(e,t,n){var i={mm:t?"минута_минуты_минут":"минуту_минуты_минут",hh:"час_часа_часов",dd:"день_дня_дней",MM:"месяц_месяца_месяцев",yy:"год_года_лет"};return"m"===n?t?"минута":"минуту":e+" "+zi(i[n],+e)}function $i(e){return e>1&&5>e}function Ji(e,t,n,i){var a=e+" ";switch(n){case"s":return t||i?"pár sekúnd":"pár sekundami";case"m":return t?"minúta":i?"minútu":"minútou";case"mm":return t||i?a+($i(e)?"minúty":"minút"):a+"minútami";case"h":return t?"hodina":i?"hodinu":"hodinou";case"hh":return t||i?a+($i(e)?"hodiny":"hodín"):a+"hodinami";case"d":return t||i?"deň":"dňom";case"dd":return t||i?a+($i(e)?"dni":"dní"):a+"dňami";case"M":return t||i?"mesiac":"mesiacom";case"MM":return t||i?a+($i(e)?"mesiace":"mesiacov"):a+"mesiacmi";case"y":return t||i?"rok":"rokom";case"yy":return t||i?a+($i(e)?"roky":"rokov"):a+"rokmi"}}function Fi(e,t,n,i){var a=e+" ";switch(n){case"s":return t||i?"nekaj sekund":"nekaj sekundami";case"m":return t?"ena minuta":"eno minuto";case"mm":return a+=1===e?t?"minuta":"minuto":2===e?t||i?"minuti":"minutama":5>e?t||i?"minute":"minutami":t||i?"minut":"minutami";case"h":return t?"ena ura":"eno uro";case"hh":return a+=1===e?t?"ura":"uro":2===e?t||i?"uri":"urama":5>e?t||i?"ure":"urami":t||i?"ur":"urami";case"d":return t||i?"en dan":"enim dnem";case"dd":return a+=1===e?t||i?"dan":"dnem":2===e?t||i?"dni":"dnevoma":t||i?"dni":"dnevi";case"M":return t||i?"en mesec":"enim mesecem";case"MM":return a+=1===e?t||i?"mesec":"mesecem":2===e?t||i?"meseca":"mesecema":5>e?t||i?"mesece":"meseci":t||i?"mesecev":"meseci";case"y":return t||i?"eno leto":"enim letom";case"yy":return a+=1===e?t||i?"leto":"letom":2===e?t||i?"leti":"letoma":5>e?t||i?"leta":"leti":t||i?"let":"leti"}}function Ii(e){var t=e;return t=-1!==e.indexOf("jaj")?t.slice(0,-3)+"leS":-1!==e.indexOf("jar")?t.slice(0,-3)+"waQ":-1!==e.indexOf("DIS")?t.slice(0,-3)+"nem":t+" pIq"}function Wi(e){var t=e;return t=-1!==e.indexOf("jaj")?t.slice(0,-3)+"Hu’":-1!==e.indexOf("jar")?t.slice(0,-3)+"wen":-1!==e.indexOf("DIS")?t.slice(0,-3)+"ben":t+" ret"}function Ui(e,t,n,i){var a=Ei(e);switch(n){case"mm":return a+" tup";case"hh":return a+" rep";case"dd":return a+" jaj";case"MM":return a+" jar";case"yy":return a+" DIS"}}function Ei(e){var t=Math.floor(e%1e3/100),n=Math.floor(e%100/10),i=e%10,a="";return t>0&&(a+=Vs[t]+"vatlh"),n>0&&(a+=(""!==a?" ":"")+Vs[n]+"maH"),i>0&&(a+=(""!==a?" ":"")+Vs[i]),""===a?"pagh":a}function Vi(e,t,n,i){var a={s:["viensas secunds","'iensas secunds"],m:["'n míut","'iens míut"],mm:[e+" míuts",""+e+" míuts"],h:["'n þora","'iensa þora"],hh:[e+" þoras",""+e+" þoras"],d:["'n ziua","'iensa ziua"],dd:[e+" ziuas",""+e+" ziuas"],M:["'n mes","'iens mes"],MM:[e+" mesen",""+e+" mesen"],y:["'n ar","'iens ar"],yy:[e+" ars",""+e+" ars"]};return i?a[n][0]:t?a[n][0]:a[n][1]}function qi(e,t){var n=e.split("_");return t%10===1&&t%100!==11?n[0]:t%10>=2&&4>=t%10&&(10>t%100||t%100>=20)?n[1]:n[2]}function Ni(e,t,n){var i={mm:t?"хвилина_хвилини_хвилин":"хвилину_хвилини_хвилин",hh:t?"година_години_годин":"годину_години_годин",dd:"день_дні_днів",MM:"місяць_місяці_місяців",yy:"рік_роки_років"};return"m"===n?t?"хвилина":"хвилину":"h"===n?t?"година":"годину":e+" "+qi(i[n],+e)}function Gi(e,t){var n={nominative:"неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),accusative:"неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),genitive:"неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")},i=/(\[[ВвУу]\]) ?dddd/.test(t)?"accusative":/\[?(?:минулої|наступної)? ?\] ?dddd/.test(t)?"genitive":"nominative";return n[i][e.day()]}function Ri(e){return function(){return e+"о"+(11===this.hours()?"б":"")+"] LT"}}var Xi,Bi=e.momentProperties=[],Ki=!1,Qi={};e.suppressDeprecationWarnings=!1;var Zi,ea={},ta={},na=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ia=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,aa={},ra={},sa=/\d/,oa=/\d\d/,da=/\d{3}/,_a=/\d{4}/,ua=/[+-]?\d{6}/,la=/\d\d?/,ma=/\d\d\d\d?/,pa=/\d\d\d\d\d\d?/,ca=/\d{1,3}/,fa=/\d{1,4}/,ha=/[+-]?\d{1,6}/,Ma=/\d+/,Ya=/[+-]?\d+/,ga=/Z|[+-]\d\d:?\d\d/gi,ba=/Z|[+-]\d\d(?::?\d\d)?/gi,ka=/[+-]?\d+(\.\d{1,3})?/,va=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,Da={},Ta={},La=0,ya=1,Ha=2,wa=3,ja=4,xa=5,Sa=6,Ca=7,Aa=8;E("M",["MM",2],"Mo",function(){return this.month()+1}),E("MMM",0,0,function(e){return this.localeData().monthsShort(this,e)}),E("MMMM",0,0,function(e){return this.localeData().months(this,e)}),z("month","M"),R("M",la),R("MM",la,oa),R("MMM",function(e,t){return t.monthsShortRegex(e)}),R("MMMM",function(e,t){return t.monthsRegex(e)}),Q(["M","MM"],function(e,t){t[ya]=M(e)-1}),Q(["MMM","MMMM"],function(e,t,n,i){var a=n._locale.monthsParse(e,i,n._strict);null!=a?t[ya]=a:_(n).invalidMonth=e});var Oa=/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/,za="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),Pa="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),$a=va,Ja=va,Fa=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,Ia=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,Wa=/Z|[+-]\d\d(?::?\d\d)?/,Ua=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Ea=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Va=/^\/?Date\((\-?\d+)/i;e.createFromInputFallback=b("moment construction falls back to js Date. This is discouraged and will be removed in upcoming major release. Please refer to https://github.com/moment/moment/issues/1407 for more info.",function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))}),E("Y",0,0,function(){var e=this.year();return 9999>=e?""+e:"+"+e}),E(0,["YY",2],0,function(){return this.year()%100}),E(0,["YYYY",4],0,"year"),E(0,["YYYYY",5],0,"year"),E(0,["YYYYYY",6,!0],0,"year"),z("year","y"),R("Y",Ya),R("YY",la,oa),R("YYYY",fa,_a),R("YYYYY",ha,ua),R("YYYYYY",ha,ua),Q(["YYYYY","YYYYYY"],La),Q("YYYY",function(t,n){n[La]=2===t.length?e.parseTwoDigitYear(t):M(t)}),Q("YY",function(t,n){n[La]=e.parseTwoDigitYear(t)}),Q("Y",function(e,t){t[La]=parseInt(e,10)}),e.parseTwoDigitYear=function(e){return M(e)+(M(e)>68?1900:2e3)};var qa=J("FullYear",!1);e.ISO_8601=function(){};var Na=b("moment().min is deprecated, use moment.max instead. https://github.com/moment/moment/issues/1548",function(){var e=ze.apply(null,arguments);return this.isValid()&&e.isValid()?this>e?this:e:l()}),Ga=b("moment().max is deprecated, use moment.min instead. https://github.com/moment/moment/issues/1548",function(){var e=ze.apply(null,arguments);return this.isValid()&&e.isValid()?e>this?this:e:l()}),Ra=function(){return Date.now?Date.now():+new Date};We("Z",":"),We("ZZ",""),R("Z",ba),R("ZZ",ba),Q(["Z","ZZ"],function(e,t,n){n._useUTC=!0,n._tzm=Ue(ba,e)});var Xa=/([\+\-]|\d\d)/gi;e.updateOffset=function(){};var Ba=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?\d*)?$/,Ka=/^(-)?P(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)W)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?$/;nt.fn=Fe.prototype;var Qa=ot(1,"add"),Za=ot(-1,"subtract");e.defaultFormat="YYYY-MM-DDTHH:mm:ssZ";var er=b("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(e){return void 0===e?this.localeData():this.locale(e)});E(0,["gg",2],0,function(){return this.weekYear()%100}),E(0,["GG",2],0,function(){return this.isoWeekYear()%100}),It("gggg","weekYear"),It("ggggg","weekYear"),It("GGGG","isoWeekYear"),It("GGGGG","isoWeekYear"),z("weekYear","gg"),z("isoWeekYear","GG"),R("G",Ya),R("g",Ya),R("GG",la,oa),R("gg",la,oa),R("GGGG",fa,_a),R("gggg",fa,_a),R("GGGGG",ha,ua),R("ggggg",ha,ua),Z(["gggg","ggggg","GGGG","GGGGG"],function(e,t,n,i){t[i.substr(0,2)]=M(e)}),Z(["gg","GG"],function(t,n,i,a){n[a]=e.parseTwoDigitYear(t)}),E("Q",0,"Qo","quarter"),z("quarter","Q"),R("Q",sa),Q("Q",function(e,t){t[ya]=3*(M(e)-1)}),E("w",["ww",2],"wo","week"),E("W",["WW",2],"Wo","isoWeek"),z("week","w"),z("isoWeek","W"),R("w",la),R("ww",la,oa),R("W",la),R("WW",la,oa),Z(["w","ww","W","WW"],function(e,t,n,i){t[i.substr(0,1)]=M(e)});var tr={dow:0,doy:6};E("D",["DD",2],"Do","date"),z("date","D"),R("D",la),R("DD",la,oa),R("Do",function(e,t){return e?t._ordinalParse:t._ordinalParseLenient}),Q(["D","DD"],Ha),Q("Do",function(e,t){t[Ha]=M(e.match(la)[0],10)});var nr=J("Date",!0);E("d",0,"do","day"),E("dd",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),E("ddd",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),E("dddd",0,0,function(e){return this.localeData().weekdays(this,e)}),E("e",0,0,"weekday"),E("E",0,0,"isoWeekday"),z("day","d"),z("weekday","e"),z("isoWeekday","E"),R("d",la),R("e",la),R("E",la),R("dd",va),R("ddd",va),R("dddd",va),Z(["dd","ddd","dddd"],function(e,t,n,i){var a=n._locale.weekdaysParse(e,i,n._strict);null!=a?t.d=a:_(n).invalidWeekday=e}),Z(["d","e","E"],function(e,t,n,i){t[i]=M(e)});var ir="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),ar="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),rr="Su_Mo_Tu_We_Th_Fr_Sa".split("_");E("DDD",["DDDD",3],"DDDo","dayOfYear"),z("dayOfYear","DDD"),R("DDD",ca),R("DDDD",da),Q(["DDD","DDDD"],function(e,t,n){n._dayOfYear=M(e)}),E("H",["HH",2],0,"hour"),E("h",["hh",2],0,_n),E("hmm",0,0,function(){return""+_n.apply(this)+U(this.minutes(),2)}),E("hmmss",0,0,function(){return""+_n.apply(this)+U(this.minutes(),2)+U(this.seconds(),2)}),E("Hmm",0,0,function(){return""+this.hours()+U(this.minutes(),2)}),E("Hmmss",0,0,function(){return""+this.hours()+U(this.minutes(),2)+U(this.seconds(),2)}),un("a",!0),un("A",!1),z("hour","h"),R("a",ln),R("A",ln),R("H",la),R("h",la),R("HH",la,oa),R("hh",la,oa),R("hmm",ma),R("hmmss",pa),R("Hmm",ma),R("Hmmss",pa),Q(["H","HH"],wa),Q(["a","A"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),Q(["h","hh"],function(e,t,n){t[wa]=M(e),_(n).bigHour=!0}),Q("hmm",function(e,t,n){var i=e.length-2;t[wa]=M(e.substr(0,i)),t[ja]=M(e.substr(i)),_(n).bigHour=!0}),Q("hmmss",function(e,t,n){var i=e.length-4,a=e.length-2;t[wa]=M(e.substr(0,i)),t[ja]=M(e.substr(i,2)),t[xa]=M(e.substr(a)),_(n).bigHour=!0}),Q("Hmm",function(e,t,n){var i=e.length-2;t[wa]=M(e.substr(0,i)),t[ja]=M(e.substr(i))}),Q("Hmmss",function(e,t,n){var i=e.length-4,a=e.length-2;t[wa]=M(e.substr(0,i)),t[ja]=M(e.substr(i,2)),t[xa]=M(e.substr(a))});var sr=/[ap]\.?m?\.?/i,or=J("Hours",!0);E("m",["mm",2],0,"minute"),z("minute","m"),R("m",la),R("mm",la,oa),Q(["m","mm"],ja);var dr=J("Minutes",!1);E("s",["ss",2],0,"second"),z("second","s"),R("s",la),R("ss",la,oa),Q(["s","ss"],xa);var _r=J("Seconds",!1);E("S",0,0,function(){return~~(this.millisecond()/100)}),E(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),E(0,["SSS",3],0,"millisecond"),E(0,["SSSS",4],0,function(){return 10*this.millisecond()}),E(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),E(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),E(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),E(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),E(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),z("millisecond","ms"),R("S",ca,sa),R("SS",ca,oa),R("SSS",ca,da);var ur;for(ur="SSSS";ur.length<=9;ur+="S")R(ur,Ma);for(ur="S";ur.length<=9;ur+="S")Q(ur,cn);var lr=J("Milliseconds",!1);E("z",0,0,"zoneAbbr"),E("zz",0,0,"zoneName");var mr=c.prototype;mr.add=Qa,mr.calendar=_t,mr.clone=ut,mr.diff=Mt,mr.endOf=jt,mr.format=kt,mr.from=vt,mr.fromNow=Dt,mr.to=Tt,mr.toNow=Lt,mr.get=W,mr.invalidAt=Jt,mr.isAfter=lt,mr.isBefore=mt,mr.isBetween=pt,mr.isSame=ct,mr.isSameOrAfter=ft,mr.isSameOrBefore=ht,mr.isValid=Pt,mr.lang=er,mr.locale=yt,mr.localeData=Ht,mr.max=Ga,mr.min=Na,mr.parsingFlags=$t,mr.set=W,mr.startOf=wt,mr.subtract=Za,mr.toArray=At,mr.toObject=Ot,mr.toDate=Ct,mr.toISOString=bt,mr.toJSON=zt,mr.toString=gt,mr.unix=St,mr.valueOf=xt,mr.creationData=Ft,mr.year=qa,mr.isLeapYear=Ye,mr.weekYear=Wt,mr.isoWeekYear=Ut,mr.quarter=mr.quarters=Gt,mr.month=se,mr.daysInMonth=oe,mr.week=mr.weeks=Kt,mr.isoWeek=mr.isoWeeks=Qt,mr.weeksInYear=Vt,mr.isoWeeksInYear=Et,mr.date=nr,mr.day=mr.days=rn,mr.weekday=sn,mr.isoWeekday=on,mr.dayOfYear=dn,mr.hour=mr.hours=or,mr.minute=mr.minutes=dr,mr.second=mr.seconds=_r,mr.millisecond=mr.milliseconds=lr,mr.utcOffset=qe,mr.utc=Ge,mr.local=Re,mr.parseZone=Xe,mr.hasAlignedHourOffset=Be,mr.isDST=Ke,mr.isDSTShifted=Qe,mr.isLocal=Ze,mr.isUtcOffset=et,mr.isUtc=tt,mr.isUTC=tt,mr.zoneAbbr=fn,mr.zoneName=hn,mr.dates=b("dates accessor is deprecated. Use date instead.",nr),mr.months=b("months accessor is deprecated. Use month instead",se),mr.years=b("years accessor is deprecated. Use year instead",qa),mr.zone=b("moment().zone is deprecated, use moment().utcOffset instead. https://github.com/moment/moment/issues/1779",Ne);var pr=mr,cr={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},fr={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},hr="Invalid date",Mr="%d",Yr=/\d{1,2}/,gr={future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},br=y.prototype;br._calendar=cr,br.calendar=gn,br._longDateFormat=fr,br.longDateFormat=bn,br._invalidDate=hr,br.invalidDate=kn,br._ordinal=Mr,br.ordinal=vn,br._ordinalParse=Yr,br.preparse=Dn,br.postformat=Dn,br._relativeTime=gr,br.relativeTime=Tn,br.pastFuture=Ln,br.set=T,br.months=ne,br._months=za,br.monthsShort=ie,br._monthsShort=Pa,br.monthsParse=ae,br._monthsRegex=Ja,br.monthsRegex=_e,br._monthsShortRegex=$a,br.monthsShortRegex=de,br.week=Rt,br._week=tr,br.firstDayOfYear=Bt,br.firstDayOfWeek=Xt,br.weekdays=en,br._weekdays=ir,br.weekdaysMin=nn,br._weekdaysMin=rr,br.weekdaysShort=tn,br._weekdaysShort=ar,br.weekdaysParse=an,br.isPM=mn,br._meridiemParse=sr,br.meridiem=pn,x("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10,n=1===M(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n}}),e.lang=b("moment.lang is deprecated. Use moment.locale instead.",x),e.langData=b("moment.langData is deprecated. Use moment.localeData instead.",A);var kr=Math.abs,vr=En("ms"),Dr=En("s"),Tr=En("m"),Lr=En("h"),yr=En("d"),Hr=En("w"),wr=En("M"),jr=En("y"),xr=qn("milliseconds"),Sr=qn("seconds"),Cr=qn("minutes"),Ar=qn("hours"),Or=qn("days"),zr=qn("months"),Pr=qn("years"),$r=Math.round,Jr={s:45,m:45,h:22,d:26,M:11},Fr=Math.abs,Ir=Fe.prototype;Ir.abs=An,Ir.add=zn,Ir.subtract=Pn,Ir.as=Wn,Ir.asMilliseconds=vr,Ir.asSeconds=Dr,Ir.asMinutes=Tr,Ir.asHours=Lr,Ir.asDays=yr,Ir.asWeeks=Hr,Ir.asMonths=wr,Ir.asYears=jr,Ir.valueOf=Un,Ir._bubble=Jn,Ir.get=Vn,Ir.milliseconds=xr,Ir.seconds=Sr,Ir.minutes=Cr,Ir.hours=Ar,Ir.days=Or,Ir.weeks=Nn,Ir.months=zr,Ir.years=Pr,Ir.humanize=Bn,Ir.toISOString=Kn,Ir.toString=Kn,Ir.toJSON=Kn,Ir.locale=yt,Ir.localeData=Ht,Ir.toIsoString=b("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",Kn),Ir.lang=er,E("X",0,0,"unix"),E("x",0,0,"valueOf"),R("x",Ya),R("X",ka),Q("X",function(e,t,n){n._d=new Date(1e3*parseFloat(e,10))}),Q("x",function(e,t,n){n._d=new Date(M(e))}),e.version="2.12.0",t(ze),e.fn=pr,e.min=$e,e.max=Je,e.now=Ra,e.utc=o,e.unix=Mn,e.months=wn,e.isDate=i,e.locale=x,e.invalid=l,e.duration=nt,e.isMoment=f,e.weekdays=xn,e.parseZone=Yn,e.localeData=A,e.isDuration=Ie,e.monthsShort=jn,e.weekdaysMin=Cn,e.defineLocale=S,e.updateLocale=C,e.locales=O,e.weekdaysShort=Sn,e.normalizeUnits=P,e.relativeTimeThreshold=Xn,e.prototype=pr;var Wr=e,Ur=(Wr.defineLocale("af",{months:"Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des".split("_"),weekdays:"Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag".split("_"),weekdaysShort:"Son_Maa_Din_Woe_Don_Vry_Sat".split("_"),weekdaysMin:"So_Ma_Di_Wo_Do_Vr_Sa".split("_"),meridiemParse:/vm|nm/i,isPM:function(e){return /^nm$/i.test(e)},meridiem:function(e,t,n){return 12>e?n?"vm":"VM":n?"nm":"NM"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Vandag om] LT",nextDay:"[Môre om] LT",nextWeek:"dddd [om] LT",lastDay:"[Gister om] LT",lastWeek:"[Laas] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oor %s",past:"%s gelede",s:"'n paar sekondes",m:"'n minuut",mm:"%d minute",h:"'n uur",hh:"%d ure",d:"'n dag",dd:"%d dae",M:"'n maand",MM:"%d maande",y:"'n jaar",yy:"%d jaar"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}}),Wr.defineLocale("ar-ma",{months:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),monthsShort:"يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر".split("_"),weekdays:"الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},week:{dow:6,doy:12}}),{1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"}),Er={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"},Vr=(Wr.defineLocale("ar-sa",{months:"يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),monthsShort:"يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return 12>e?"ص":"م"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},preparse:function(e){return e.replace(/[١٢٣٤٥٦٧٨٩٠]/g,function(e){return Er[e]}).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,function(e){return Ur[e]}).replace(/,/g,"،")},week:{dow:6,doy:12}}),Wr.defineLocale("ar-tn",{months:"جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),monthsShort:"جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر".split("_"),weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[اليوم على الساعة] LT",nextDay:"[غدا على الساعة] LT",nextWeek:"dddd [على الساعة] LT",lastDay:"[أمس على الساعة] LT",lastWeek:"dddd [على الساعة] LT",sameElse:"L"},relativeTime:{future:"في %s",past:"منذ %s",s:"ثوان",m:"دقيقة",mm:"%d دقائق",h:"ساعة",hh:"%d ساعات",d:"يوم",dd:"%d أيام",M:"شهر",MM:"%d أشهر",y:"سنة",yy:"%d سنوات"},week:{dow:1,doy:4}}),{1:"١",2:"٢",3:"٣",4:"٤",5:"٥",6:"٦",7:"٧",8:"٨",9:"٩",0:"٠"}),qr={"١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","٠":"0"},Nr=function(e){return 0===e?0:1===e?1:2===e?2:e%100>=3&&10>=e%100?3:e%100>=11?4:5},Gr={s:["أقل من ثانية","ثانية واحدة",["ثانيتان","ثانيتين"],"%d ثوان","%d ثانية","%d ثانية"],m:["أقل من دقيقة","دقيقة واحدة",["دقيقتان","دقيقتين"],"%d دقائق","%d دقيقة","%d دقيقة"],h:["أقل من ساعة","ساعة واحدة",["ساعتان","ساعتين"],"%d ساعات","%d ساعة","%d ساعة"],d:["أقل من يوم","يوم واحد",["يومان","يومين"],"%d أيام","%d يومًا","%d يوم"],M:["أقل من شهر","شهر واحد",["شهران","شهرين"],"%d أشهر","%d شهرا","%d شهر"],y:["أقل من عام","عام واحد",["عامان","عامين"],"%d أعوام","%d عامًا","%d عام"]},Rr=function(e){return function(t,n,i,a){var r=Nr(t),s=Gr[e][Nr(t)];return 2===r&&(s=s[n?0:1]),s.replace(/%d/i,t)}},Xr=["كانون الثاني يناير","شباط فبراير","آذار مارس","نيسان أبريل","أيار مايو","حزيران يونيو","تموز يوليو","آب أغسطس","أيلول سبتمبر","تشرين الأول أكتوبر","تشرين الثاني نوفمبر","كانون الأول ديسمبر"],Br=(Wr.defineLocale("ar",{months:Xr,monthsShort:Xr,weekdays:"الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت".split("_"),weekdaysShort:"أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت".split("_"),weekdaysMin:"ح_ن_ث_ر_خ_ج_س".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/‏M/‏YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/ص|م/,isPM:function(e){return"م"===e},meridiem:function(e,t,n){return 12>e?"ص":"م"},calendar:{sameDay:"[اليوم عند الساعة] LT",nextDay:"[غدًا عند الساعة] LT",nextWeek:"dddd [عند الساعة] LT",lastDay:"[أمس عند الساعة] LT",lastWeek:"dddd [عند الساعة] LT",sameElse:"L"},relativeTime:{future:"بعد %s",past:"منذ %s",s:Rr("s"),m:Rr("m"),mm:Rr("m"),h:Rr("h"),hh:Rr("h"),d:Rr("d"),dd:Rr("d"),M:Rr("M"),MM:Rr("M"),y:Rr("y"),yy:Rr("y")},preparse:function(e){return e.replace(/\u200f/g,"").replace(/[١٢٣٤٥٦٧٨٩٠]/g,function(e){return qr[e]}).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,function(e){return Vr[e]}).replace(/,/g,"،")},week:{dow:6,doy:12}}),{1:"-inci",5:"-inci",8:"-inci",70:"-inci",80:"-inci",2:"-nci",7:"-nci",20:"-nci",50:"-nci",3:"-üncü",4:"-üncü",100:"-üncü",6:"-ncı",9:"-uncu",10:"-uncu",30:"-uncu",60:"-ıncı",90:"-ıncı"}),Kr=(Wr.defineLocale("az",{months:"yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr".split("_"),monthsShort:"yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek".split("_"),weekdays:"Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə".split("_"),weekdaysShort:"Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən".split("_"),weekdaysMin:"Bz_BE_ÇA_Çə_CA_Cü_Şə".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugün saat] LT",nextDay:"[sabah saat] LT",nextWeek:"[gələn həftə] dddd [saat] LT",lastDay:"[dünən] LT",lastWeek:"[keçən həftə] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s əvvəl",s:"birneçə saniyyə",m:"bir dəqiqə",mm:"%d dəqiqə",h:"bir saat",hh:"%d saat",d:"bir gün",dd:"%d gün",M:"bir ay",MM:"%d ay",y:"bir il",yy:"%d il"},meridiemParse:/gecə|səhər|gündüz|axşam/,isPM:function(e){return /^(gündüz|axşam)$/.test(e)},meridiem:function(e,t,n){return 4>e?"gecə":12>e?"səhər":17>e?"gündüz":"axşam"},ordinalParse:/\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,ordinal:function(e){if(0===e)return e+"-ıncı";var t=e%10,n=e%100-t,i=e>=100?100:null;return e+(Br[t]||Br[n]||Br[i])},week:{dow:1,doy:7}}),Wr.defineLocale("be",{months:{format:"студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня".split("_"),standalone:"студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань".split("_")},monthsShort:"студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж".split("_"),weekdays:{format:"нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу".split("_"),standalone:"нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота".split("_"),isFormat:/\[ ?[Вв] ?(?:мінулую|наступную)? ?\] ?dddd/},weekdaysShort:"нд_пн_ат_ср_чц_пт_сб".split("_"),weekdaysMin:"нд_пн_ат_ср_чц_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., HH:mm",LLLL:"dddd, D MMMM YYYY г., HH:mm"},calendar:{sameDay:"[Сёння ў] LT",nextDay:"[Заўтра ў] LT",lastDay:"[Учора ў] LT",nextWeek:function(){return"[У] dddd [ў] LT"},lastWeek:function(){switch(this.day()){case 0:;case 3:;case 5:;case 6:return"[У мінулую] dddd [ў] LT";case 1:;case 2:;case 4:return"[У мінулы] dddd [ў] LT"}},sameElse:"L"},relativeTime:{future:"праз %s",past:"%s таму",s:"некалькі секунд",m:Zn,mm:Zn,h:Zn,hh:Zn,d:"дзень",dd:Zn,M:"месяц",MM:Zn,y:"год",yy:Zn},meridiemParse:/ночы|раніцы|дня|вечара/,isPM:function(e){return /^(дня|вечара)$/.test(e)},meridiem:function(e,t,n){return 4>e?"ночы":12>e?"раніцы":17>e?"дня":"вечара"},ordinalParse:/\d{1,2}-(і|ы|га)/,ordinal:function(e,t){switch(t){case"M":;case"d":;case"DDD":;case"w":;case"W":return e%10!==2&&e%10!==3||e%100===12||e%100===13?e+"-ы":e+"-і";case"D":return e+"-га";default:return e}},week:{dow:1,doy:7}}),Wr.defineLocale("bg",{months:"януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември".split("_"),monthsShort:"янр_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек".split("_"),weekdays:"неделя_понеделник_вторник_сряда_четвъртък_петък_събота".split("_"),weekdaysShort:"нед_пон_вто_сря_чет_пет_съб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Днес в] LT",nextDay:"[Утре в] LT",nextWeek:"dddd [в] LT",lastDay:"[Вчера в] LT",lastWeek:function(){switch(this.day()){case 0:;case 3:;case 6:return"[В изминалата] dddd [в] LT";case 1:;case 2:;case 4:;case 5:return"[В изминалия] dddd [в] LT"}},sameElse:"L"},relativeTime:{future:"след %s",past:"преди %s",s:"няколко секунди",m:"минута",mm:"%d минути",h:"час",hh:"%d часа",d:"ден",dd:"%d дни",M:"месец",MM:"%d месеца",y:"година",yy:"%d години"},ordinalParse:/\d{1,2}-(ев|ен|ти|ви|ри|ми)/,ordinal:function(e){var t=e%10,n=e%100;return 0===e?e+"-ев":0===n?e+"-ен":n>10&&20>n?e+"-ти":1===t?e+"-ви":2===t?e+"-ри":7===t||8===t?e+"-ми":e+"-ти"},week:{dow:1,doy:7}}),{1:"১",2:"২",3:"৩",4:"৪",5:"৫",6:"৬",7:"৭",8:"৮",9:"৯",0:"০"}),Qr={"১":"1","২":"2","৩":"3","৪":"4","৫":"5","৬":"6","৭":"7","৮":"8","৯":"9","০":"0"},Zr=(Wr.defineLocale("bn",{months:"জানুয়ারী_ফেবুয়ারী_মার্চ_এপ্রিল_মে_জুন_জুলাই_অগাস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর".split("_"),monthsShort:"জানু_ফেব_মার্চ_এপর_মে_জুন_জুল_অগ_সেপ্ট_অক্টো_নভ_ডিসেম্".split("_"),weekdays:"রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পত্তিবার_শুক্রবার_শনিবার".split("_"),weekdaysShort:"রবি_সোম_মঙ্গল_বুধ_বৃহস্পত্তি_শুক্র_শনি".split("_"),weekdaysMin:"রব_সম_মঙ্গ_বু_ব্রিহ_শু_শনি".split("_"),longDateFormat:{LT:"A h:mm সময়",LTS:"A h:mm:ss সময়",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm সময়",LLLL:"dddd, D MMMM YYYY, A h:mm সময়"},calendar:{sameDay:"[আজ] LT",nextDay:"[আগামীকাল] LT",nextWeek:"dddd, LT",lastDay:"[গতকাল] LT",lastWeek:"[গত] dddd, LT",sameElse:"L"},relativeTime:{future:"%s পরে",past:"%s আগে",s:"কয়েক সেকেন্ড",m:"এক মিনিট",mm:"%d মিনিট",h:"এক ঘন্টা",hh:"%d ঘন্টা",d:"এক দিন",dd:"%d দিন",M:"এক মাস",MM:"%d মাস",y:"এক বছর",yy:"%d বছর"},preparse:function(e){return e.replace(/[১২৩৪৫৬৭৮৯০]/g,function(e){return Qr[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Kr[e]})},meridiemParse:/রাত|সকাল|দুপুর|বিকাল|রাত/,meridiemHour:function(e,t){return 12===e&&(e=0),"রাত"===t&&e>=4||"দুপুর"===t&&5>e||"বিকাল"===t?e+12:e},meridiem:function(e,t,n){return 4>e?"রাত":10>e?"সকাল":17>e?"দুপুর":20>e?"বিকাল":"রাত"},week:{dow:0,doy:6}}),{1:"༡",2:"༢",3:"༣",4:"༤",5:"༥",6:"༦",7:"༧",8:"༨",9:"༩",0:"༠"}),es={"༡":"1","༢":"2","༣":"3","༤":"4","༥":"5","༦":"6","༧":"7","༨":"8","༩":"9","༠":"0"},ts=(Wr.defineLocale("bo",{months:"ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),monthsShort:"ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ".split("_"),weekdays:"གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་".split("_"),weekdaysShort:"ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),weekdaysMin:"ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[དི་རིང] LT",nextDay:"[སང་ཉིན] LT",nextWeek:"[བདུན་ཕྲག་རྗེས་མ], LT",lastDay:"[ཁ་སང] LT",lastWeek:"[བདུན་ཕྲག་མཐའ་མ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s ལ་",past:"%s སྔན་ལ",s:"ལམ་སང",m:"སྐར་མ་གཅིག",mm:"%d སྐར་མ",h:"ཆུ་ཚོད་གཅིག",hh:"%d ཆུ་ཚོད",d:"ཉིན་གཅིག",dd:"%d ཉིན་",M:"ཟླ་བ་གཅིག",MM:"%d ཟླ་བ",y:"ལོ་གཅིག",yy:"%d ལོ"},preparse:function(e){return e.replace(/[༡༢༣༤༥༦༧༨༩༠]/g,function(e){return es[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Zr[e]})},meridiemParse:/མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,meridiemHour:function(e,t){return 12===e&&(e=0),"མཚན་མོ"===t&&e>=4||"ཉིན་གུང"===t&&5>e||"དགོང་དག"===t?e+12:e},meridiem:function(e,t,n){return 4>e?"མཚན་མོ":10>e?"ཞོགས་ཀས":17>e?"ཉིན་གུང":20>e?"དགོང་དག":"མཚན་མོ"},week:{dow:0,doy:6}}),Wr.defineLocale("br",{months:"Genver_C'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu".split("_"),monthsShort:"Gen_C'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker".split("_"),weekdays:"Sul_Lun_Meurzh_Merc'her_Yaou_Gwener_Sadorn".split("_"),weekdaysShort:"Sul_Lun_Meu_Mer_Yao_Gwe_Sad".split("_"),weekdaysMin:"Su_Lu_Me_Mer_Ya_Gw_Sa".split("_"),longDateFormat:{LT:"h[e]mm A",LTS:"h[e]mm:ss A",L:"DD/MM/YYYY",LL:"D [a viz] MMMM YYYY",LLL:"D [a viz] MMMM YYYY h[e]mm A",LLLL:"dddd, D [a viz] MMMM YYYY h[e]mm A"},calendar:{sameDay:"[Hiziv da] LT",nextDay:"[Warc'hoazh da] LT",nextWeek:"dddd [da] LT",lastDay:"[Dec'h da] LT",lastWeek:"dddd [paset da] LT",sameElse:"L"},relativeTime:{future:"a-benn %s",past:"%s 'zo",s:"un nebeud segondennoù",m:"ur vunutenn",mm:ei,h:"un eur",hh:"%d eur",d:"un devezh",dd:ei,M:"ur miz",MM:ei,y:"ur bloaz",yy:ti},ordinalParse:/\d{1,2}(añ|vet)/,ordinal:function(e){var t=1===e?"añ":"vet";return e+t},week:{dow:1,doy:4}}),Wr.defineLocale("bs",{months:"januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.".split("_"),weekdays:"nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:;case 2:;case 4:;case 5:return"[u] dddd [u] LT"}},lastDay:"[jučer u] LT",lastWeek:function(){switch(this.day()){case 0:;case 3:return"[prošlu] dddd [u] LT";case 6:return"[prošle] [subote] [u] LT";case 1:;case 2:;case 4:;case 5:return"[prošli] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",m:ri,mm:ri,h:ri,hh:ri,d:"dan",dd:ri,M:"mjesec",MM:ri,y:"godinu",yy:ri},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),Wr.defineLocale("ca",{months:"gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre".split("_"),monthsShort:"gen._febr._mar._abr._mai._jun._jul._ag._set._oct._nov._des.".split("_"),weekdays:"diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte".split("_"),weekdaysShort:"dg._dl._dt._dc._dj._dv._ds.".split("_"),weekdaysMin:"Dg_Dl_Dt_Dc_Dj_Dv_Ds".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd D MMMM YYYY H:mm"},calendar:{sameDay:function(){return"[avui a "+(1!==this.hours()?"les":"la")+"] LT"},nextDay:function(){return"[demà a "+(1!==this.hours()?"les":"la")+"] LT"},nextWeek:function(){return"dddd [a "+(1!==this.hours()?"les":"la")+"] LT"},lastDay:function(){return"[ahir a "+(1!==this.hours()?"les":"la")+"] LT"},lastWeek:function(){return"[el] dddd [passat a "+(1!==this.hours()?"les":"la")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"fa %s",s:"uns segons",m:"un minut",mm:"%d minuts",h:"una hora",hh:"%d hores",d:"un dia",dd:"%d dies",M:"un mes",MM:"%d mesos",y:"un any",yy:"%d anys"},ordinalParse:/\d{1,2}(r|n|t|è|a)/,ordinal:function(e,t){var n=1===e?"r":2===e?"n":3===e?"r":4===e?"t":"è";return("w"===t||"W"===t)&&(n="a"),e+n},week:{dow:1,doy:4}}),"leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec".split("_")),ns="led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro".split("_"),is=(Wr.defineLocale("cs",{months:ts,monthsShort:ns,monthsParse:function(e,t){var n,i=[];for(n=0;12>n;n++)i[n]=new RegExp("^"+e[n]+"$|^"+t[n]+"$","i");return i}(ts,ns),shortMonthsParse:function(e){var t,n=[];for(t=0;12>t;t++)n[t]=new RegExp("^"+e[t]+"$","i");return n}(ns),longMonthsParse:function(e){var t,n=[];for(t=0;12>t;t++)n[t]=new RegExp("^"+e[t]+"$","i");return n}(ts),weekdays:"neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota".split("_"),weekdaysShort:"ne_po_út_st_čt_pá_so".split("_"),weekdaysMin:"ne_po_út_st_čt_pá_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm"},calendar:{sameDay:"[dnes v] LT",nextDay:"[zítra v] LT",nextWeek:function(){switch(this.day()){case 0:return"[v neděli v] LT";case 1:;case 2:return"[v] dddd [v] LT";case 3:return"[ve středu v] LT";case 4:return"[ve čtvrtek v] LT";case 5:return"[v pátek v] LT";case 6:return"[v sobotu v] LT"}},lastDay:"[včera v] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulou neděli v] LT";case 1:;case 2:return"[minulé] dddd [v] LT";case 3:return"[minulou středu v] LT";case 4:;case 5:return"[minulý] dddd [v] LT";case 6:return"[minulou sobotu v] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"před %s",s:oi,m:oi,mm:oi,h:oi,hh:oi,d:oi,dd:oi,M:oi,MM:oi,y:oi,yy:oi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("cv",{months:"кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав".split("_"),monthsShort:"кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш".split("_"),weekdays:"вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун".split("_"),weekdaysShort:"выр_тун_ытл_юн_кӗҫ_эрн_шӑм".split("_"),weekdaysMin:"вр_тн_ыт_юн_кҫ_эр_шм".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]",LLL:"YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm",LLLL:"dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm"},calendar:{sameDay:"[Паян] LT [сехетре]",nextDay:"[Ыран] LT [сехетре]",lastDay:"[Ӗнер] LT [сехетре]",nextWeek:"[Ҫитес] dddd LT [сехетре]",lastWeek:"[Иртнӗ] dddd LT [сехетре]",sameElse:"L"},relativeTime:{future:function(e){var t=/сехет$/i.exec(e)?"рен":/ҫул$/i.exec(e)?"тан":"ран";return e+t},past:"%s каялла",s:"пӗр-ик ҫеккунт",m:"пӗр минут",mm:"%d минут",h:"пӗр сехет",hh:"%d сехет",d:"пӗр кун",dd:"%d кун",M:"пӗр уйӑх",MM:"%d уйӑх",y:"пӗр ҫул",yy:"%d ҫул"},ordinalParse:/\d{1,2}-мӗш/,ordinal:"%d-мӗш",week:{dow:1,doy:7}}),Wr.defineLocale("cy",{months:"Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr".split("_"),monthsShort:"Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag".split("_"),weekdays:"Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn".split("_"),weekdaysShort:"Sul_Llun_Maw_Mer_Iau_Gwe_Sad".split("_"),weekdaysMin:"Su_Ll_Ma_Me_Ia_Gw_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Heddiw am] LT",nextDay:"[Yfory am] LT",nextWeek:"dddd [am] LT",lastDay:"[Ddoe am] LT",lastWeek:"dddd [diwethaf am] LT",sameElse:"L"},relativeTime:{future:"mewn %s",past:"%s yn ôl",s:"ychydig eiliadau",m:"munud",mm:"%d munud",h:"awr",hh:"%d awr",d:"diwrnod",dd:"%d diwrnod",M:"mis",MM:"%d mis",y:"blwyddyn",yy:"%d flynedd"},ordinalParse:/\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,ordinal:function(e){var t=e,n="",i=["","af","il","ydd","ydd","ed","ed","ed","fed","fed","fed","eg","fed","eg","eg","fed","eg","eg","fed","eg","fed"];return t>20?n=40===t||50===t||60===t||80===t||100===t?"fed":"ain":t>0&&(n=i[t]),e+n},week:{dow:1,doy:4}}),Wr.defineLocale("da",{months:"januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),weekdaysShort:"søn_man_tir_ons_tor_fre_lør".split("_"),weekdaysMin:"sø_ma_ti_on_to_fr_lø".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd [d.] D. MMMM YYYY HH:mm"},calendar:{sameDay:"[I dag kl.] LT",nextDay:"[I morgen kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[I går kl.] LT",lastWeek:"[sidste] dddd [kl] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"%s siden",s:"få sekunder",m:"et minut",mm:"%d minutter",h:"en time",hh:"%d timer",d:"en dag",dd:"%d dage",M:"en måned",MM:"%d måneder",y:"et år",yy:"%d år"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("de-at",{months:"Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",m:di,mm:"%d Minuten",h:di,hh:"%d Stunden",d:di,dd:di,M:di,MM:di,y:di,yy:di},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("de",{months:"Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",m:_i,mm:"%d Minuten",h:_i,hh:"%d Stunden",d:_i,dd:_i,M:_i,MM:_i,y:_i,yy:_i},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),["ޖެނުއަރީ","ފެބްރުއަރީ","މާރިޗު","އޭޕްރީލު","މޭ","ޖޫން","ޖުލައި","އޯގަސްޓު","ސެޕްޓެމްބަރު","އޮކްޓޯބަރު","ނޮވެމްބަރު","ޑިސެމްބަރު"]),as=["އާދިއްތަ","ހޯމަ","އަންގާރަ","ބުދަ","ބުރާސްފަތި","ހުކުރު","ހޮނިހިރު"],rs=(Wr.defineLocale("dv",{months:is,monthsShort:is,weekdays:as,weekdaysShort:as,weekdaysMin:"އާދި_ހޯމަ_އަން_ބުދަ_ބުރާ_ހުކު_ހޮނި".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"D/M/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},meridiemParse:/މކ|މފ/,isPM:function(e){return"މފ"===e},meridiem:function(e,t,n){return 12>e?"މކ":"މފ"},calendar:{sameDay:"[މިއަދު] LT",nextDay:"[މާދަމާ] LT",nextWeek:"dddd LT",lastDay:"[އިއްޔެ] LT",lastWeek:"[ފާއިތުވި] dddd LT",sameElse:"L"},relativeTime:{future:"ތެރޭގައި %s",past:"ކުރިން %s",s:"ސިކުންތުކޮޅެއް",m:"މިނިޓެއް",mm:"މިނިޓު %d",h:"ގަޑިއިރެއް",hh:"ގަޑިއިރު %d",d:"ދުވަހެއް",dd:"ދުވަސް %d",M:"މަހެއް",MM:"މަސް %d",y:"އަހަރެއް",yy:"އަހަރު %d"},preparse:function(e){return e.replace(/،/g,",")},postformat:function(e){return e.replace(/,/g,"،")},week:{dow:7,doy:12}}),Wr.defineLocale("el",{monthsNominativeEl:"Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος".split("_"),monthsGenitiveEl:"Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου".split("_"),months:function(e,t){return /D/.test(t.substring(0,t.indexOf("MMMM")))?this._monthsGenitiveEl[e.month()]:this._monthsNominativeEl[e.month()]},monthsShort:"Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ".split("_"),weekdays:"Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο".split("_"),weekdaysShort:"Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ".split("_"),weekdaysMin:"Κυ_Δε_Τρ_Τε_Πε_Πα_Σα".split("_"),meridiem:function(e,t,n){return e>11?n?"μμ":"ΜΜ":n?"πμ":"ΠΜ"},isPM:function(e){return"μ"===(e+"").toLowerCase()[0]},meridiemParse:/[ΠΜ]\.?Μ?\.?/i,longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendarEl:{sameDay:"[Σήμερα {}] LT",nextDay:"[Αύριο {}] LT",nextWeek:"dddd [{}] LT",lastDay:"[Χθες {}] LT",lastWeek:function(){switch(this.day()){case 6:return"[το προηγούμενο] dddd [{}] LT";default:return"[την προηγούμενη] dddd [{}] LT"}},sameElse:"L"},calendar:function(e,t){var n=this._calendarEl[e],i=t&&t.hours();return v(n)&&(n=n.apply(t)),n.replace("{}",i%12===1?"στη":"στις")},relativeTime:{future:"σε %s",past:"%s πριν",s:"λίγα δευτερόλεπτα",m:"ένα λεπτό",mm:"%d λεπτά",h:"μία ώρα",hh:"%d ώρες",d:"μία μέρα",dd:"%d μέρες",M:"ένας μήνας",MM:"%d μήνες",y:"ένας χρόνος",yy:"%d χρόνια"},ordinalParse:/\d{1,2}η/,ordinal:"%dη",week:{dow:1,doy:4}}),Wr.defineLocale("en-au",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n},week:{dow:1,doy:4}}),Wr.defineLocale("en-ca",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"YYYY-MM-DD",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n}}),Wr.defineLocale("en-gb",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n},week:{dow:1,doy:4}}),Wr.defineLocale("en-ie",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n},week:{dow:1,doy:4}}),Wr.defineLocale("en-nz",{months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},ordinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"th":1===t?"st":2===t?"nd":3===t?"rd":"th";return e+n},week:{dow:1,doy:4}}),Wr.defineLocale("eo",{months:"januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aŭg_sep_okt_nov_dec".split("_"),weekdays:"Dimanĉo_Lundo_Mardo_Merkredo_Ĵaŭdo_Vendredo_Sabato".split("_"),weekdaysShort:"Dim_Lun_Mard_Merk_Ĵaŭ_Ven_Sab".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Ĵa_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D[-an de] MMMM, YYYY",LLL:"D[-an de] MMMM, YYYY HH:mm",LLLL:"dddd, [la] D[-an de] MMMM, YYYY HH:mm"},meridiemParse:/[ap]\.t\.m/i,isPM:function(e){return"p"===e.charAt(0).toLowerCase()},meridiem:function(e,t,n){return e>11?n?"p.t.m.":"P.T.M.":n?"a.t.m.":"A.T.M."},calendar:{sameDay:"[Hodiaŭ je] LT",nextDay:"[Morgaŭ je] LT",nextWeek:"dddd [je] LT",lastDay:"[Hieraŭ je] LT",lastWeek:"[pasinta] dddd [je] LT",sameElse:"L"},relativeTime:{future:"je %s",past:"antaŭ %s",s:"sekundoj",m:"minuto",mm:"%d minutoj",h:"horo",hh:"%d horoj",d:"tago",dd:"%d tagoj",M:"monato",MM:"%d monatoj",y:"jaro",yy:"%d jaroj"},ordinalParse:/\d{1,2}a/,ordinal:"%da",week:{dow:1,doy:7}}),"ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_")),ss="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),os=(Wr.defineLocale("es",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(e,t){return /-MMM-/.test(t)?ss[e.month()]:rs[e.month()]},weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},ordinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}}),Wr.defineLocale("et",{months:"jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember".split("_"),monthsShort:"jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets".split("_"),weekdays:"pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev".split("_"),weekdaysShort:"P_E_T_K_N_R_L".split("_"),weekdaysMin:"P_E_T_K_N_R_L".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[Täna,] LT",nextDay:"[Homme,] LT",nextWeek:"[Järgmine] dddd LT",lastDay:"[Eile,] LT",lastWeek:"[Eelmine] dddd LT",sameElse:"L"},relativeTime:{future:"%s pärast",past:"%s tagasi",s:ui,m:ui,mm:ui,h:ui,hh:ui,d:ui,dd:"%d päeva",M:ui,MM:ui,y:ui,yy:ui},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("eu",{months:"urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua".split("_"),monthsShort:"urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.".split("_"),weekdays:"igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata".split("_"),weekdaysShort:"ig._al._ar._az._og._ol._lr.".split("_"),weekdaysMin:"ig_al_ar_az_og_ol_lr".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY[ko] MMMM[ren] D[a]",LLL:"YYYY[ko] MMMM[ren] D[a] HH:mm",LLLL:"dddd, YYYY[ko] MMMM[ren] D[a] HH:mm",l:"YYYY-M-D",ll:"YYYY[ko] MMM D[a]",lll:"YYYY[ko] MMM D[a] HH:mm",llll:"ddd, YYYY[ko] MMM D[a] HH:mm"},calendar:{sameDay:"[gaur] LT[etan]",nextDay:"[bihar] LT[etan]",nextWeek:"dddd LT[etan]",lastDay:"[atzo] LT[etan]",lastWeek:"[aurreko] dddd LT[etan]",sameElse:"L"},relativeTime:{future:"%s barru",past:"duela %s",s:"segundo batzuk",m:"minutu bat",mm:"%d minutu",h:"ordu bat",hh:"%d ordu",d:"egun bat",dd:"%d egun",M:"hilabete bat",MM:"%d hilabete",y:"urte bat",yy:"%d urte"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),{1:"۱",2:"۲",3:"۳",4:"۴",5:"۵",6:"۶",7:"۷",8:"۸",9:"۹",0:"۰"}),ds={"۱":"1","۲":"2","۳":"3","۴":"4","۵":"5","۶":"6","۷":"7","۸":"8","۹":"9","۰":"0"},_s=(Wr.defineLocale("fa",{months:"ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),monthsShort:"ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر".split("_"),weekdays:"یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),weekdaysShort:"یک‌شنبه_دوشنبه_سه‌شنبه_چهارشنبه_پنج‌شنبه_جمعه_شنبه".split("_"),weekdaysMin:"ی_د_س_چ_پ_ج_ش".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},meridiemParse:/قبل از ظهر|بعد از ظهر/,isPM:function(e){return /بعد از ظهر/.test(e)},meridiem:function(e,t,n){return 12>e?"قبل از ظهر":"بعد از ظهر"},calendar:{sameDay:"[امروز ساعت] LT",nextDay:"[فردا ساعت] LT",nextWeek:"dddd [ساعت] LT",lastDay:"[دیروز ساعت] LT",lastWeek:"dddd [پیش] [ساعت] LT",sameElse:"L"},relativeTime:{future:"در %s",past:"%s پیش",s:"چندین ثانیه",m:"یک دقیقه",mm:"%d دقیقه",h:"یک ساعت",hh:"%d ساعت",d:"یک روز",dd:"%d روز",M:"یک ماه",MM:"%d ماه",y:"یک سال",yy:"%d سال"},preparse:function(e){return e.replace(/[۰-۹]/g,function(e){return ds[e]}).replace(/،/g,",")},postformat:function(e){return e.replace(/\d/g,function(e){return os[e]}).replace(/,/g,"،")},ordinalParse:/\d{1,2}م/,ordinal:"%dم",week:{dow:6,doy:12}}),"nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän".split(" ")),us=["nolla","yhden","kahden","kolmen","neljän","viiden","kuuden",_s[7],_s[8],_s[9]],ls=(Wr.defineLocale("fi",{months:"tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu".split("_"),monthsShort:"tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu".split("_"),weekdays:"sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai".split("_"),weekdaysShort:"su_ma_ti_ke_to_pe_la".split("_"),weekdaysMin:"su_ma_ti_ke_to_pe_la".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"Do MMMM[ta] YYYY",LLL:"Do MMMM[ta] YYYY, [klo] HH.mm",LLLL:"dddd, Do MMMM[ta] YYYY, [klo] HH.mm",l:"D.M.YYYY",ll:"Do MMM YYYY",lll:"Do MMM YYYY, [klo] HH.mm",llll:"ddd, Do MMM YYYY, [klo] HH.mm"},calendar:{sameDay:"[tänään] [klo] LT",nextDay:"[huomenna] [klo] LT",nextWeek:"dddd [klo] LT",lastDay:"[eilen] [klo] LT",lastWeek:"[viime] dddd[na] [klo] LT",sameElse:"L"},relativeTime:{future:"%s päästä",past:"%s sitten",s:li,m:li,mm:li,h:li,hh:li,d:li,dd:li,M:li,MM:li,y:li,yy:li},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("fo",{months:"januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),weekdays:"sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur".split("_"),weekdaysShort:"sun_mán_týs_mik_hós_frí_ley".split("_"),weekdaysMin:"su_má_tý_mi_hó_fr_le".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D. MMMM, YYYY HH:mm"},calendar:{sameDay:"[Í dag kl.] LT",nextDay:"[Í morgin kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[Í gjár kl.] LT",lastWeek:"[síðstu] dddd [kl] LT",sameElse:"L"},relativeTime:{future:"um %s",past:"%s síðani",s:"fá sekund",m:"ein minutt",mm:"%d minuttir",h:"ein tími",hh:"%d tímar",d:"ein dagur",dd:"%d dagar",M:"ein mánaði",MM:"%d mánaðir",y:"eitt ár",yy:"%d ár"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("fr-ca",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|e)/,ordinal:function(e){return e+(1===e?"er":"e")}}),Wr.defineLocale("fr-ch",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|e)/,ordinal:function(e){return e+(1===e?"er":"e")},week:{dow:1,doy:4}}),Wr.defineLocale("fr",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"Di_Lu_Ma_Me_Je_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd'hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},ordinalParse:/\d{1,2}(er|)/,ordinal:function(e){return e+(1===e?"er":"")},week:{dow:1,doy:4}}),"jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.".split("_")),ms="jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),ps=(Wr.defineLocale("fy",{months:"jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber".split("_"),monthsShort:function(e,t){return /-MMM-/.test(t)?ms[e.month()]:ls[e.month()]},weekdays:"snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon".split("_"),weekdaysShort:"si._mo._ti._wo._to._fr._so.".split("_"),weekdaysMin:"Si_Mo_Ti_Wo_To_Fr_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[hjoed om] LT",nextDay:"[moarn om] LT",nextWeek:"dddd [om] LT",lastDay:"[juster om] LT",lastWeek:"[ôfrûne] dddd [om] LT",sameElse:"L"},relativeTime:{future:"oer %s",past:"%s lyn",s:"in pear sekonden",m:"ien minút",mm:"%d minuten",h:"ien oere",hh:"%d oeren",d:"ien dei",dd:"%d dagen",M:"ien moanne",MM:"%d moannen",y:"ien jier",yy:"%d jierren"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}}),["Am Faoilleach","An Gearran","Am Màrt","An Giblean","An Cèitean","An t-Ògmhios","An t-Iuchar","An Lùnastal","An t-Sultain","An Dàmhair","An t-Samhain","An Dùbhlachd"]),cs=["Faoi","Gear","Màrt","Gibl","Cèit","Ògmh","Iuch","Lùn","Sult","Dàmh","Samh","Dùbh"],fs=["Didòmhnaich","Diluain","Dimàirt","Diciadain","Diardaoin","Dihaoine","Disathairne"],hs=["Did","Dil","Dim","Dic","Dia","Dih","Dis"],Ms=["Dò","Lu","Mà","Ci","Ar","Ha","Sa"],Ys=(Wr.defineLocale("gd",{months:ps,monthsShort:cs,monthsParseExact:!0,weekdays:fs,weekdaysShort:hs,weekdaysMin:Ms,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[An-diugh aig] LT",nextDay:"[A-màireach aig] LT",nextWeek:"dddd [aig] LT",lastDay:"[An-dè aig] LT",lastWeek:"dddd [seo chaidh] [aig] LT",sameElse:"L"},relativeTime:{future:"ann an %s",past:"bho chionn %s",s:"beagan diogan",m:"mionaid",mm:"%d mionaidean",h:"uair",hh:"%d uairean",d:"latha",dd:"%d latha",M:"mìos",MM:"%d mìosan",y:"bliadhna",yy:"%d bliadhna"},ordinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(e){var t=1===e?"d":e%10===2?"na":"mh";return e+t},week:{dow:1,doy:4}}),Wr.defineLocale("gl",{months:"Xaneiro_Febreiro_Marzo_Abril_Maio_Xuño_Xullo_Agosto_Setembro_Outubro_Novembro_Decembro".split("_"),monthsShort:"Xan._Feb._Mar._Abr._Mai._Xuñ._Xul._Ago._Set._Out._Nov._Dec.".split("_"),weekdays:"Domingo_Luns_Martes_Mércores_Xoves_Venres_Sábado".split("_"),weekdaysShort:"Dom._Lun._Mar._Mér._Xov._Ven._Sáb.".split("_"),weekdaysMin:"Do_Lu_Ma_Mé_Xo_Ve_Sá".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd D MMMM YYYY H:mm"},calendar:{sameDay:function(){return"[hoxe "+(1!==this.hours()?"ás":"á")+"] LT"},nextDay:function(){return"[mañá "+(1!==this.hours()?"ás":"á")+"] LT"},nextWeek:function(){return"dddd ["+(1!==this.hours()?"ás":"a")+"] LT"},lastDay:function(){return"[onte "+(1!==this.hours()?"á":"a")+"] LT"},lastWeek:function(){return"[o] dddd [pasado "+(1!==this.hours()?"ás":"a")+"] LT"},sameElse:"L"},relativeTime:{future:function(e){return"uns segundos"===e?"nuns segundos":"en "+e},past:"hai %s",s:"uns segundos",m:"un minuto",mm:"%d minutos",h:"unha hora",hh:"%d horas",d:"un día",dd:"%d días",M:"un mes",MM:"%d meses",y:"un ano",yy:"%d anos"},ordinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:7}}),Wr.defineLocale("he",{months:"ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר".split("_"),monthsShort:"ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳".split("_"),weekdays:"ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת".split("_"),weekdaysShort:"א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳".split("_"),weekdaysMin:"א_ב_ג_ד_ה_ו_ש".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [ב]MMMM YYYY",LLL:"D [ב]MMMM YYYY HH:mm",LLLL:"dddd, D [ב]MMMM YYYY HH:mm",l:"D/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[היום ב־]LT",nextDay:"[מחר ב־]LT",nextWeek:"dddd [בשעה] LT",lastDay:"[אתמול ב־]LT",lastWeek:"[ביום] dddd [האחרון בשעה] LT",sameElse:"L"},relativeTime:{future:"בעוד %s",past:"לפני %s",s:"מספר שניות",m:"דקה",mm:"%d דקות",h:"שעה",hh:function(e){return 2===e?"שעתיים":e+" שעות"},d:"יום",dd:function(e){return 2===e?"יומיים":e+" ימים"},M:"חודש",MM:function(e){return 2===e?"חודשיים":e+" חודשים"},y:"שנה",yy:function(e){return 2===e?"שנתיים":e%10===0&&10!==e?e+" שנה":e+" שנים"}},meridiemParse:/אחה"צ|לפנה"צ|אחרי הצהריים|לפני הצהריים|לפנות בוקר|בבוקר|בערב/i,isPM:function(e){return /^(אחה"צ|אחרי הצהריים|בערב)$/.test(e)},meridiem:function(e,t,n){return 5>e?"לפנות בוקר":10>e?"בבוקר":12>e?n?'לפנה"צ':"לפני הצהריים":18>e?n?'אחה"צ':"אחרי הצהריים":"בערב"}}),{1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"}),gs={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"},bs=(Wr.defineLocale("hi",{months:"जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर".split("_"),monthsShort:"जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.".split("_"),weekdays:"रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),weekdaysShort:"रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि".split("_"),weekdaysMin:"र_सो_मं_बु_गु_शु_श".split("_"),longDateFormat:{LT:"A h:mm बजे",LTS:"A h:mm:ss बजे",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm बजे",LLLL:"dddd, D MMMM YYYY, A h:mm बजे"},calendar:{sameDay:"[आज] LT",nextDay:"[कल] LT",nextWeek:"dddd, LT",lastDay:"[कल] LT",lastWeek:"[पिछले] dddd, LT",sameElse:"L"},relativeTime:{future:"%s में",past:"%s पहले",s:"कुछ ही क्षण",m:"एक मिनट",mm:"%d मिनट",h:"एक घंटा",hh:"%d घंटे",d:"एक दिन",dd:"%d दिन",M:"एक महीने",MM:"%d महीने",y:"एक वर्ष",yy:"%d वर्ष"},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,function(e){return gs[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Ys[e]})},meridiemParse:/रात|सुबह|दोपहर|शाम/,meridiemHour:function(e,t){return 12===e&&(e=0),"रात"===t?4>e?e:e+12:"सुबह"===t?e:"दोपहर"===t?e>=10?e:e+12:"शाम"===t?e+12:void 0},meridiem:function(e,t,n){return 4>e?"रात":10>e?"सुबह":17>e?"दोपहर":20>e?"शाम":"रात"},week:{dow:0,doy:6}}),Wr.defineLocale("hr",{months:{format:"siječnja_veljače_ožujka_travnja_svibnja_lipnja_srpnja_kolovoza_rujna_listopada_studenoga_prosinca".split("_"),standalone:"siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac".split("_")},monthsShort:"sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.".split("_"),weekdays:"nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota".split("_"),weekdaysShort:"ned._pon._uto._sri._čet._pet._sub.".split("_"),weekdaysMin:"ne_po_ut_sr_če_pe_su".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:;case 2:;case 4:;case 5:return"[u] dddd [u] LT"}},lastDay:"[jučer u] LT",lastWeek:function(){switch(this.day()){case 0:;case 3:return"[prošlu] dddd [u] LT";case 6:return"[prošle] [subote] [u] LT";case 1:;case 2:;case 4:;case 5:return"[prošli] dddd [u] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"par sekundi",m:pi,mm:pi,h:pi,hh:pi,d:"dan",dd:pi,M:"mjesec",MM:pi,y:"godinu",yy:pi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),"vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton".split(" ")),ks=(Wr.defineLocale("hu",{months:"január_február_március_április_május_június_július_augusztus_szeptember_október_november_december".split("_"),monthsShort:"jan_feb_márc_ápr_máj_jún_júl_aug_szept_okt_nov_dec".split("_"),weekdays:"vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat".split("_"),weekdaysShort:"vas_hét_kedd_sze_csüt_pén_szo".split("_"),weekdaysMin:"v_h_k_sze_cs_p_szo".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"YYYY.MM.DD.",LL:"YYYY. MMMM D.",LLL:"YYYY. MMMM D. H:mm",LLLL:"YYYY. MMMM D., dddd H:mm"},meridiemParse:/de|du/i,isPM:function(e){return"u"===e.charAt(1).toLowerCase()},meridiem:function(e,t,n){return 12>e?n===!0?"de":"DE":n===!0?"du":"DU"},calendar:{sameDay:"[ma] LT[-kor]",nextDay:"[holnap] LT[-kor]",nextWeek:function(){return fi.call(this,!0)},lastDay:"[tegnap] LT[-kor]",lastWeek:function(){return fi.call(this,!1)},sameElse:"L"},relativeTime:{future:"%s múlva",past:"%s",s:ci,m:ci,mm:ci,h:ci,hh:ci,d:ci,dd:ci,M:ci,MM:ci,y:ci,yy:ci},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),Wr.defineLocale("hy-am",{months:{format:"հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի".split("_"),standalone:"հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր".split("_")},monthsShort:"հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ".split("_"),weekdays:"կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ".split("_"),weekdaysShort:"կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),weekdaysMin:"կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY թ.",LLL:"D MMMM YYYY թ., HH:mm",LLLL:"dddd, D MMMM YYYY թ., HH:mm"},calendar:{sameDay:"[այսօր] LT",nextDay:"[վաղը] LT",lastDay:"[երեկ] LT",nextWeek:function(){return"dddd [օրը ժամը] LT"},lastWeek:function(){return"[անցած] dddd [օրը ժամը] LT"},sameElse:"L"},relativeTime:{future:"%s հետո",past:"%s առաջ",s:"մի քանի վայրկյան",m:"րոպե",mm:"%d րոպե",h:"ժամ",hh:"%d ժամ",d:"օր",dd:"%d օր",M:"ամիս",MM:"%d ամիս",y:"տարի",yy:"%d տարի"},meridiemParse:/գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,isPM:function(e){return /^(ցերեկվա|երեկոյան)$/.test(e)},meridiem:function(e){return 4>e?"գիշերվա":12>e?"առավոտվա":17>e?"ցերեկվա":"երեկոյան"},ordinalParse:/\d{1,2}|\d{1,2}-(ին|րդ)/,ordinal:function(e,t){switch(t){case"DDD":;case"w":;case"W":;case"DDDo":return 1===e?e+"-ին":e+"-րդ";default:return e}},week:{dow:1,doy:7}}),Wr.defineLocale("id",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des".split("_"),weekdays:"Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu".split("_"),weekdaysShort:"Min_Sen_Sel_Rab_Kam_Jum_Sab".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|siang|sore|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"siang"===t?e>=11?e:e+12:"sore"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return 11>e?"pagi":15>e?"siang":19>e?"sore":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Besok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kemarin pukul] LT",lastWeek:"dddd [lalu pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lalu",s:"beberapa detik",m:"semenit",mm:"%d menit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,doy:7}}),Wr.defineLocale("is",{months:"janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember".split("_"),monthsShort:"jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des".split("_"),weekdays:"sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur".split("_"),weekdaysShort:"sun_mán_þri_mið_fim_fös_lau".split("_"),weekdaysMin:"Su_Má_Þr_Mi_Fi_Fö_La".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd, D. MMMM YYYY [kl.] H:mm"},calendar:{sameDay:"[í dag kl.] LT",nextDay:"[á morgun kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[í gær kl.] LT",lastWeek:"[síðasta] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"eftir %s",past:"fyrir %s síðan",s:Mi,m:Mi,mm:Mi,h:"klukkustund",hh:Mi,d:Mi,dd:Mi,M:Mi,MM:Mi,y:Mi,yy:Mi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("it",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"Domenica_Lunedì_Martedì_Mercoledì_Giovedì_Venerdì_Sabato".split("_"),weekdaysShort:"Dom_Lun_Mar_Mer_Gio_Ven_Sab".split("_"),weekdaysMin:"Do_Lu_Ma_Me_Gi_Ve_Sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Oggi alle] LT",nextDay:"[Domani alle] LT",nextWeek:"dddd [alle] LT",lastDay:"[Ieri alle] LT",lastWeek:function(){switch(this.day()){case 0:return"[la scorsa] dddd [alle] LT";default:return"[lo scorso] dddd [alle] LT"}},sameElse:"L"},relativeTime:{future:function(e){return(/^[0-9].+$/.test(e)?"tra":"in")+" "+e},past:"%s fa",s:"alcuni secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},ordinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}}),Wr.defineLocale("ja",{months:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),weekdaysShort:"日_月_火_水_木_金_土".split("_"),weekdaysMin:"日_月_火_水_木_金_土".split("_"),longDateFormat:{LT:"Ah時m分",LTS:"Ah時m分s秒",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日Ah時m分",LLLL:"YYYY年M月D日Ah時m分 dddd"},meridiemParse:/午前|午後/i,isPM:function(e){return"午後"===e},meridiem:function(e,t,n){return 12>e?"午前":"午後"},calendar:{sameDay:"[今日] LT",nextDay:"[明日] LT",nextWeek:"[来週]dddd LT",lastDay:"[昨日] LT",lastWeek:"[前週]dddd LT",sameElse:"L"},ordinalParse:/\d{1,2}日/,ordinal:function(e,t){switch(t){case"d":;case"D":;case"DDD":return e+"日";default:return e}},relativeTime:{future:"%s後",past:"%s前",s:"数秒",m:"1分",mm:"%d分",h:"1時間",hh:"%d時間",d:"1日",dd:"%d日",M:"1ヶ月",MM:"%dヶ月",y:"1年",yy:"%d年"}}),Wr.defineLocale("jv",{months:"Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember".split("_"),monthsShort:"Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des".split("_"),weekdays:"Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu".split("_"),weekdaysShort:"Min_Sen_Sel_Reb_Kem_Jem_Sep".split("_"),weekdaysMin:"Mg_Sn_Sl_Rb_Km_Jm_Sp".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/enjing|siyang|sonten|ndalu/,meridiemHour:function(e,t){return 12===e&&(e=0),"enjing"===t?e:"siyang"===t?e>=11?e:e+12:"sonten"===t||"ndalu"===t?e+12:void 0},meridiem:function(e,t,n){return 11>e?"enjing":15>e?"siyang":19>e?"sonten":"ndalu"},calendar:{sameDay:"[Dinten puniko pukul] LT",nextDay:"[Mbenjang pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kala wingi pukul] LT",lastWeek:"dddd [kepengker pukul] LT",sameElse:"L"},relativeTime:{future:"wonten ing %s",past:"%s ingkang kepengker",s:"sawetawis detik",m:"setunggal menit",mm:"%d menit",h:"setunggal jam",hh:"%d jam",d:"sedinten",dd:"%d dinten",M:"sewulan",MM:"%d wulan",y:"setaun",yy:"%d taun"},week:{dow:1,doy:7}}),Wr.defineLocale("ka",{months:{standalone:"იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი".split("_"),format:"იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს".split("_")},monthsShort:"იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ".split("_"),weekdays:{standalone:"კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი".split("_"),format:"კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს".split("_"),isFormat:/(წინა|შემდეგ)/},weekdaysShort:"კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ".split("_"),weekdaysMin:"კვ_ორ_სა_ოთ_ხუ_პა_შა".split("_"),longDateFormat:{LT:"h:mm A",LTS:"h:mm:ss A",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY h:mm A",LLLL:"dddd, D MMMM YYYY h:mm A"},calendar:{sameDay:"[დღეს] LT[-ზე]",nextDay:"[ხვალ] LT[-ზე]",lastDay:"[გუშინ] LT[-ზე]",nextWeek:"[შემდეგ] dddd LT[-ზე]",lastWeek:"[წინა] dddd LT-ზე",sameElse:"L"},relativeTime:{future:function(e){return /(წამი|წუთი|საათი|წელი)/.test(e)?e.replace(/ი$/,"ში"):e+"ში"},past:function(e){return /(წამი|წუთი|საათი|დღე|თვე)/.test(e)?e.replace(/(ი|ე)$/,"ის წინ"):/წელი/.test(e)?e.replace(/წელი$/,"წლის წინ"):void 0},s:"რამდენიმე წამი",m:"წუთი",mm:"%d წუთი",h:"საათი",hh:"%d საათი",d:"დღე",dd:"%d დღე",M:"თვე",MM:"%d თვე",y:"წელი",yy:"%d წელი"},ordinalParse:/0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,ordinal:function(e){return 0===e?e:1===e?e+"-ლი":20>e||100>=e&&e%20===0||e%100===0?"მე-"+e:e+"-ე"},week:{dow:1,doy:7}}),{0:"-ші",1:"-ші",2:"-ші",3:"-ші",4:"-ші",5:"-ші",6:"-шы",7:"-ші",8:"-ші",9:"-шы",10:"-шы",20:"-шы",30:"-шы",40:"-шы",50:"-ші",60:"-шы",70:"-ші",80:"-ші",90:"-шы",100:"-ші"}),vs=(Wr.defineLocale("kk",{months:"Қаңтар_Ақпан_Наурыз_Сәуір_Мамыр_Маусым_Шілде_Тамыз_Қыркүйек_Қазан_Қараша_Желтоқсан".split("_"),monthsShort:"Қаң_Ақп_Нау_Сәу_Мам_Мау_Шіл_Там_Қыр_Қаз_Қар_Жел".split("_"),weekdays:"Жексенбі_Дүйсенбі_Сейсенбі_Сәрсенбі_Бейсенбі_Жұма_Сенбі".split("_"),weekdaysShort:"Жек_Дүй_Сей_Сәр_Бей_Жұм_Сен".split("_"),weekdaysMin:"Жк_Дй_Сй_Ср_Бй_Жм_Сн".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Бүгін сағат] LT",nextDay:"[Ертең сағат] LT",nextWeek:"dddd [сағат] LT",lastDay:"[Кеше сағат] LT",lastWeek:"[Өткен аптаның] dddd [сағат] LT",sameElse:"L"},relativeTime:{future:"%s ішінде",past:"%s бұрын",s:"бірнеше секунд",m:"бір минут",mm:"%d минут",h:"бір сағат",hh:"%d сағат",d:"бір күн",dd:"%d күн",M:"бір ай",MM:"%d ай",y:"бір жыл",yy:"%d жыл"},ordinalParse:/\d{1,2}-(ші|шы)/,ordinal:function(e){var t=e%10,n=e>=100?100:null;return e+(ks[e]||ks[t]||ks[n])},week:{dow:1,doy:7}}),Wr.defineLocale("km",{months:"មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),monthsShort:"មករា_កុម្ភៈ_មិនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ".split("_"),weekdays:"អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),weekdaysShort:"អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),weekdaysMin:"អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[ថ្ងៃនេះ ម៉ោង] LT",nextDay:"[ស្អែក ម៉ោង] LT",nextWeek:"dddd [ម៉ោង] LT",lastDay:"[ម្សិលមិញ ម៉ោង] LT",lastWeek:"dddd [សប្តាហ៍មុន] [ម៉ោង] LT",sameElse:"L"},relativeTime:{future:"%sទៀត",past:"%sមុន",s:"ប៉ុន្មានវិនាទី",m:"មួយនាទី",mm:"%d នាទី",h:"មួយម៉ោង",hh:"%d ម៉ោង",d:"មួយថ្ងៃ",dd:"%d ថ្ងៃ",M:"មួយខែ",MM:"%d ខែ",y:"មួយឆ្នាំ",yy:"%d ឆ្នាំ"},week:{dow:1,doy:4}}),Wr.defineLocale("ko",{months:"1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),monthsShort:"1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월".split("_"),weekdays:"일요일_월요일_화요일_수요일_목요일_금요일_토요일".split("_"),weekdaysShort:"일_월_화_수_목_금_토".split("_"),weekdaysMin:"일_월_화_수_목_금_토".split("_"),longDateFormat:{LT:"A h시 m분",LTS:"A h시 m분 s초",L:"YYYY.MM.DD",LL:"YYYY년 MMMM D일",LLL:"YYYY년 MMMM D일 A h시 m분",LLLL:"YYYY년 MMMM D일 dddd A h시 m분"},calendar:{sameDay:"오늘 LT",nextDay:"내일 LT",nextWeek:"dddd LT",lastDay:"어제 LT",lastWeek:"지난주 dddd LT",sameElse:"L"},relativeTime:{future:"%s 후",past:"%s 전",s:"몇초",ss:"%d초",m:"일분",mm:"%d분",h:"한시간",hh:"%d시간",d:"하루",dd:"%d일",M:"한달",MM:"%d달",y:"일년",yy:"%d년"},ordinalParse:/\d{1,2}일/,ordinal:"%d일",meridiemParse:/오전|오후/,isPM:function(e){return"오후"===e},meridiem:function(e,t,n){return 12>e?"오전":"오후"}}),Wr.defineLocale("lb",{months:"Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.".split("_"),weekdays:"Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg".split("_"),weekdaysShort:"So._Mé._Dë._Më._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mé_Dë_Më_Do_Fr_Sa".split("_"),longDateFormat:{LT:"H:mm [Auer]",LTS:"H:mm:ss [Auer]",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm [Auer]",LLLL:"dddd, D. MMMM YYYY H:mm [Auer]"},calendar:{sameDay:"[Haut um] LT",sameElse:"L",nextDay:"[Muer um] LT",nextWeek:"dddd [um] LT",lastDay:"[Gëschter um] LT",lastWeek:function(){switch(this.day()){case 2:;case 4:return"[Leschten] dddd [um] LT";default:return"[Leschte] dddd [um] LT"}}},relativeTime:{future:gi,past:bi,s:"e puer Sekonnen",m:Yi,mm:"%d Minutten",h:Yi,hh:"%d Stonnen",d:Yi,dd:"%d Deeg",M:Yi,MM:"%d Méint",y:Yi,yy:"%d Joer"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("lo",{months:"ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ".split("_"),monthsShort:"ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ".split("_"),weekdays:"ອາທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ".split("_"),weekdaysShort:"ທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ".split("_"),weekdaysMin:"ທ_ຈ_ອຄ_ພ_ພຫ_ສກ_ສ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"ວັນdddd D MMMM YYYY HH:mm"},meridiemParse:/ຕອນເຊົ້າ|ຕອນແລງ/,isPM:function(e){return"ຕອນແລງ"===e},meridiem:function(e,t,n){return 12>e?"ຕອນເຊົ້າ":"ຕອນແລງ"},calendar:{sameDay:"[ມື້ນີ້ເວລາ] LT",nextDay:"[ມື້ອື່ນເວລາ] LT",nextWeek:"[ວັນ]dddd[ໜ້າເວລາ] LT",lastDay:"[ມື້ວານນີ້ເວລາ] LT",lastWeek:"[ວັນ]dddd[ແລ້ວນີ້ເວລາ] LT",sameElse:"L"},relativeTime:{future:"ອີກ %s",past:"%sຜ່ານມາ",s:"ບໍ່ເທົ່າໃດວິນາທີ",m:"1 ນາທີ",mm:"%d ນາທີ",h:"1 ຊົ່ວໂມງ",hh:"%d ຊົ່ວໂມງ",d:"1 ມື້",dd:"%d ມື້",M:"1 ເດືອນ",MM:"%d ເດືອນ",y:"1 ປີ",yy:"%d ປີ"},ordinalParse:/(ທີ່)\d{1,2}/,ordinal:function(e){return"ທີ່"+e}}),{m:"minutė_minutės_minutę",mm:"minutės_minučių_minutes",h:"valanda_valandos_valandą",hh:"valandos_valandų_valandas",d:"diena_dienos_dieną",dd:"dienos_dienų_dienas",M:"mėnuo_mėnesio_mėnesį",MM:"mėnesiai_mėnesių_mėnesius",y:"metai_metų_metus",yy:"metai_metų_metus"}),Ds=(Wr.defineLocale("lt",{months:{format:"sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio".split("_"),standalone:"sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis".split("_")},monthsShort:"sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd".split("_"),weekdays:{format:"sekmadienį_pirmadienį_antradienį_trečiadienį_ketvirtadienį_penktadienį_šeštadienį".split("_"),standalone:"sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis".split("_"),isFormat:/dddd HH:mm/},weekdaysShort:"Sek_Pir_Ant_Tre_Ket_Pen_Šeš".split("_"),weekdaysMin:"S_P_A_T_K_Pn_Š".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"YYYY [m.] MMMM D [d.]",LLL:"YYYY [m.] MMMM D [d.], HH:mm [val.]",LLLL:"YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]",l:"YYYY-MM-DD",ll:"YYYY [m.] MMMM D [d.]",lll:"YYYY [m.] MMMM D [d.], HH:mm [val.]",llll:"YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]"},calendar:{sameDay:"[Šiandien] LT",nextDay:"[Rytoj] LT",nextWeek:"dddd LT",lastDay:"[Vakar] LT",lastWeek:"[Praėjusį] dddd LT",sameElse:"L"},relativeTime:{future:"po %s",past:"prieš %s",s:vi,m:Di,mm:yi,h:Di,hh:yi,d:Di,dd:yi,M:Di,MM:yi,y:Di,yy:yi},ordinalParse:/\d{1,2}-oji/,ordinal:function(e){return e+"-oji"},week:{dow:1,doy:4}}),{m:"minūtes_minūtēm_minūte_minūtes".split("_"),mm:"minūtes_minūtēm_minūte_minūtes".split("_"),h:"stundas_stundām_stunda_stundas".split("_"),hh:"stundas_stundām_stunda_stundas".split("_"),d:"dienas_dienām_diena_dienas".split("_"),dd:"dienas_dienām_diena_dienas".split("_"),M:"mēneša_mēnešiem_mēnesis_mēneši".split("_"),MM:"mēneša_mēnešiem_mēnesis_mēneši".split("_"),y:"gada_gadiem_gads_gadi".split("_"),yy:"gada_gadiem_gads_gadi".split("_")}),Ts=(Wr.defineLocale("lv",{months:"janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris".split("_"),monthsShort:"jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec".split("_"),weekdays:"svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena".split("_"),weekdaysShort:"Sv_P_O_T_C_Pk_S".split("_"),weekdaysMin:"Sv_P_O_T_C_Pk_S".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY.",LL:"YYYY. [gada] D. MMMM",LLL:"YYYY. [gada] D. MMMM, HH:mm",LLLL:"YYYY. [gada] D. MMMM, dddd, HH:mm"},calendar:{sameDay:"[Šodien pulksten] LT",nextDay:"[Rīt pulksten] LT",nextWeek:"dddd [pulksten] LT",lastDay:"[Vakar pulksten] LT",lastWeek:"[Pagājušā] dddd [pulksten] LT",sameElse:"L"},relativeTime:{future:"pēc %s",past:"pirms %s",s:xi,m:ji,mm:wi,h:ji,hh:wi,d:ji,dd:wi,M:ji,MM:wi,y:ji,yy:wi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),{words:{m:["jedan minut","jednog minuta"],mm:["minut","minuta","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],dd:["dan","dana","dana"],MM:["mjesec","mjeseca","mjeseci"],yy:["godina","godine","godina"]},correctGrammaticalCase:function(e,t){return 1===e?t[0]:e>=2&&4>=e?t[1]:t[2]},translate:function(e,t,n){var i=Ts.words[n];return 1===n.length?t?i[0]:i[1]:e+" "+Ts.correctGrammaticalCase(e,i)}}),Ls=(Wr.defineLocale("me",{months:["januar","februar","mart","april","maj","jun","jul","avgust","septembar","oktobar","novembar","decembar"],monthsShort:["jan.","feb.","mar.","apr.","maj","jun","jul","avg.","sep.","okt.","nov.","dec."],weekdays:["nedjelja","ponedjeljak","utorak","srijeda","četvrtak","petak","subota"],weekdaysShort:["ned.","pon.","uto.","sri.","čet.","pet.","sub."],weekdaysMin:["ne","po","ut","sr","če","pe","su"],longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sjutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedjelju] [u] LT";case 3:return"[u] [srijedu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:;case 2:;case 4:;case 5:return"[u] dddd [u] LT"}},lastDay:"[juče u] LT",lastWeek:function(){var e=["[prošle] [nedjelje] [u] LT","[prošlog] [ponedjeljka] [u] LT","[prošlog] [utorka] [u] LT","[prošle] [srijede] [u] LT","[prošlog] [četvrtka] [u] LT","[prošlog] [petka] [u] LT","[prošle] [subote] [u] LT"];return e[this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"prije %s",s:"nekoliko sekundi",m:Ts.translate,mm:Ts.translate,h:Ts.translate,hh:Ts.translate,d:"dan",dd:Ts.translate,M:"mjesec",MM:Ts.translate,y:"godinu",yy:Ts.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),Wr.defineLocale("mk",{months:"јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември".split("_"),monthsShort:"јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек".split("_"),weekdays:"недела_понеделник_вторник_среда_четврток_петок_сабота".split("_"),weekdaysShort:"нед_пон_вто_сре_чет_пет_саб".split("_"),weekdaysMin:"нe_пo_вт_ср_че_пе_сa".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"D.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[Денес во] LT",nextDay:"[Утре во] LT",nextWeek:"[Во] dddd [во] LT",lastDay:"[Вчера во] LT",lastWeek:function(){switch(this.day()){case 0:;case 3:;case 6:return"[Изминатата] dddd [во] LT";case 1:;case 2:;case 4:;case 5:return"[Изминатиот] dddd [во] LT"}},sameElse:"L"},relativeTime:{future:"после %s",past:"пред %s",s:"неколку секунди",m:"минута",mm:"%d минути",h:"час",hh:"%d часа",d:"ден",dd:"%d дена",M:"месец",MM:"%d месеци",y:"година",yy:"%d години"},ordinalParse:/\d{1,2}-(ев|ен|ти|ви|ри|ми)/,ordinal:function(e){var t=e%10,n=e%100;return 0===e?e+"-ев":0===n?e+"-ен":n>10&&20>n?e+"-ти":1===t?e+"-ви":2===t?e+"-ри":7===t||8===t?e+"-ми":e+"-ти"},week:{dow:1,doy:7}}),Wr.defineLocale("ml",{months:"ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ".split("_"),monthsShort:"ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.".split("_"),weekdays:"ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച".split("_"),weekdaysShort:"ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി".split("_"),weekdaysMin:"ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ".split("_"),longDateFormat:{LT:"A h:mm -നു",LTS:"A h:mm:ss -നു",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm -നു",LLLL:"dddd, D MMMM YYYY, A h:mm -നു"},calendar:{sameDay:"[ഇന്ന്] LT",nextDay:"[നാളെ] LT",nextWeek:"dddd, LT",lastDay:"[ഇന്നലെ] LT",lastWeek:"[കഴിഞ്ഞ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s കഴിഞ്ഞ്",past:"%s മുൻപ്",s:"അൽപ നിമിഷങ്ങൾ",m:"ഒരു മിനിറ്റ്",mm:"%d മിനിറ്റ്",h:"ഒരു മണിക്കൂർ",hh:"%d മണിക്കൂർ",d:"ഒരു ദിവസം",dd:"%d ദിവസം",M:"ഒരു മാസം",MM:"%d മാസം",y:"ഒരു വർഷം",yy:"%d വർഷം"},meridiemParse:/രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,meridiemHour:function(e,t){return 12===e&&(e=0),"രാത്രി"===t&&e>=4||"ഉച്ച കഴിഞ്ഞ്"===t||"വൈകുന്നേരം"===t?e+12:e},meridiem:function(e,t,n){return 4>e?"രാത്രി":12>e?"രാവിലെ":17>e?"ഉച്ച കഴിഞ്ഞ്":20>e?"വൈകുന്നേരം":"രാത്രി"}}),{1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"}),ys={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"},Hs=(Wr.defineLocale("mr",{months:"जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर".split("_"),monthsShort:"जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.".split("_"),weekdays:"रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार".split("_"),weekdaysShort:"रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि".split("_"),weekdaysMin:"र_सो_मं_बु_गु_शु_श".split("_"),longDateFormat:{LT:"A h:mm वाजता",LTS:"A h:mm:ss वाजता",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm वाजता",LLLL:"dddd, D MMMM YYYY, A h:mm वाजता"},calendar:{sameDay:"[आज] LT",nextDay:"[उद्या] LT",nextWeek:"dddd, LT",lastDay:"[काल] LT",lastWeek:"[मागील] dddd, LT",sameElse:"L"},relativeTime:{future:"%sमध्ये",past:"%sपूर्वी",s:Si,m:Si,mm:Si,h:Si,hh:Si,d:Si,dd:Si,M:Si,MM:Si,y:Si,yy:Si},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,function(e){return ys[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Ls[e]})},meridiemParse:/रात्री|सकाळी|दुपारी|सायंकाळी/,meridiemHour:function(e,t){return 12===e&&(e=0),"रात्री"===t?4>e?e:e+12:"सकाळी"===t?e:"दुपारी"===t?e>=10?e:e+12:"सायंकाळी"===t?e+12:void 0},meridiem:function(e,t,n){return 4>e?"रात्री":10>e?"सकाळी":17>e?"दुपारी":20>e?"सायंकाळी":"रात्री"},week:{dow:0,doy:6}}),Wr.defineLocale("ms-my",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"tengahari"===t?e>=11?e:e+12:"petang"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return 11>e?"pagi":15>e?"tengahari":19>e?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,doy:7}}),Wr.defineLocale("ms",{months:"Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis".split("_"),weekdays:"Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu".split("_"),weekdaysShort:"Ahd_Isn_Sel_Rab_Kha_Jum_Sab".split("_"),weekdaysMin:"Ah_Is_Sl_Rb_Km_Jm_Sb".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY [pukul] HH.mm",LLLL:"dddd, D MMMM YYYY [pukul] HH.mm"},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(e,t){return 12===e&&(e=0),"pagi"===t?e:"tengahari"===t?e>=11?e:e+12:"petang"===t||"malam"===t?e+12:void 0},meridiem:function(e,t,n){return 11>e?"pagi":15>e?"tengahari":19>e?"petang":"malam"},calendar:{sameDay:"[Hari ini pukul] LT",nextDay:"[Esok pukul] LT",nextWeek:"dddd [pukul] LT",lastDay:"[Kelmarin pukul] LT",lastWeek:"dddd [lepas pukul] LT",sameElse:"L"},relativeTime:{future:"dalam %s",past:"%s yang lepas",s:"beberapa saat",m:"seminit",mm:"%d minit",h:"sejam",hh:"%d jam",d:"sehari",dd:"%d hari",M:"sebulan",MM:"%d bulan",y:"setahun",yy:"%d tahun"},week:{dow:1,doy:7}}),{1:"၁",2:"၂",3:"၃",4:"၄",5:"၅",6:"၆",7:"၇",8:"၈",9:"၉",0:"၀"}),ws={"၁":"1","၂":"2","၃":"3","၄":"4","၅":"5","၆":"6","၇":"7","၈":"8","၉":"9","၀":"0"},js=(Wr.defineLocale("my",{months:"ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ".split("_"),monthsShort:"ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ".split("_"),weekdays:"တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ".split("_"),weekdaysShort:"နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),weekdaysMin:"နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[ယနေ.] LT [မှာ]",nextDay:"[မနက်ဖြန်] LT [မှာ]",nextWeek:"dddd LT [မှာ]",lastDay:"[မနေ.က] LT [မှာ]",lastWeek:"[ပြီးခဲ့သော] dddd LT [မှာ]",sameElse:"L"},relativeTime:{future:"လာမည့် %s မှာ",past:"လွန်ခဲ့သော %s က",s:"စက္ကန်.အနည်းငယ်",m:"တစ်မိနစ်",mm:"%d မိနစ်",h:"တစ်နာရီ",hh:"%d နာရီ",d:"တစ်ရက်",dd:"%d ရက်",M:"တစ်လ",MM:"%d လ",y:"တစ်နှစ်",yy:"%d နှစ်"},preparse:function(e){return e.replace(/[၁၂၃၄၅၆၇၈၉၀]/g,function(e){return ws[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Hs[e]})},week:{dow:1,doy:4}}),Wr.defineLocale("nb",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan._feb._mars_april_mai_juni_juli_aug._sep._okt._nov._des.".split("_"),weekdays:"søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag".split("_"),weekdaysShort:"sø._ma._ti._on._to._fr._lø.".split("_"),weekdaysMin:"sø_ma_ti_on_to_fr_lø".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] HH:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[i dag kl.] LT",nextDay:"[i morgen kl.] LT",nextWeek:"dddd [kl.] LT",lastDay:"[i går kl.] LT",lastWeek:"[forrige] dddd [kl.] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"for %s siden",s:"noen sekunder",m:"ett minutt",mm:"%d minutter",h:"en time",hh:"%d timer",d:"en dag",dd:"%d dager",M:"en måned",MM:"%d måneder",y:"ett år",yy:"%d år"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),{1:"१",2:"२",3:"३",4:"४",5:"५",6:"६",7:"७",8:"८",9:"९",0:"०"}),xs={"१":"1","२":"2","३":"3","४":"4","५":"5","६":"6","७":"7","८":"8","९":"9","०":"0"},Ss=(Wr.defineLocale("ne",{months:"जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर".split("_"),monthsShort:"जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.".split("_"),weekdays:"आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार".split("_"),weekdaysShort:"आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.".split("_"),weekdaysMin:"आ._सो._मं._बु._बि._शु._श.".split("_"),longDateFormat:{LT:"Aको h:mm बजे",LTS:"Aको h:mm:ss बजे",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, Aको h:mm बजे",LLLL:"dddd, D MMMM YYYY, Aको h:mm बजे"},preparse:function(e){return e.replace(/[१२३४५६७८९०]/g,function(e){return xs[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return js[e]})},meridiemParse:/राति|बिहान|दिउँसो|साँझ/,meridiemHour:function(e,t){return 12===e&&(e=0),"राति"===t?4>e?e:e+12:"बिहान"===t?e:"दिउँसो"===t?e>=10?e:e+12:"साँझ"===t?e+12:void 0},meridiem:function(e,t,n){return 3>e?"राति":12>e?"बिहान":16>e?"दिउँसो":20>e?"साँझ":"राति"},calendar:{sameDay:"[आज] LT",nextDay:"[भोलि] LT",nextWeek:"[आउँदो] dddd[,] LT",lastDay:"[हिजो] LT",lastWeek:"[गएको] dddd[,] LT",sameElse:"L"},relativeTime:{future:"%sमा",past:"%s अगाडि",s:"केही क्षण",m:"एक मिनेट",mm:"%d मिनेट",h:"एक घण्टा",hh:"%d घण्टा",d:"एक दिन",dd:"%d दिन",M:"एक महिना",MM:"%d महिना",y:"एक बर्ष",yy:"%d बर्ष"},week:{dow:0,doy:6}}),"jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_")),Cs="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),As=(Wr.defineLocale("nl",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(e,t){return /-MMM-/.test(t)?Cs[e.month()]:Ss[e.month()]},weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"Zo_Ma_Di_Wo_Do_Vr_Za".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",m:"één minuut",mm:"%d minuten",h:"één uur",hh:"%d uur",d:"één dag",dd:"%d dagen",M:"één maand",MM:"%d maanden",y:"één jaar",yy:"%d jaar"},ordinalParse:/\d{1,2}(ste|de)/,ordinal:function(e){return e+(1===e||8===e||e>=20?"ste":"de")},week:{dow:1,doy:4}}),Wr.defineLocale("nn",{months:"januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember".split("_"),monthsShort:"jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des".split("_"),weekdays:"sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag".split("_"),weekdaysShort:"sun_mån_tys_ons_tor_fre_lau".split("_"),weekdaysMin:"su_må_ty_on_to_fr_lø".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY [kl.] H:mm",LLLL:"dddd D. MMMM YYYY [kl.] HH:mm"},calendar:{sameDay:"[I dag klokka] LT",nextDay:"[I morgon klokka] LT",nextWeek:"dddd [klokka] LT",lastDay:"[I går klokka] LT",lastWeek:"[Føregåande] dddd [klokka] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"for %s sidan",s:"nokre sekund",m:"eit minutt",mm:"%d minutt",h:"ein time",hh:"%d timar",d:"ein dag",dd:"%d dagar",M:"ein månad",MM:"%d månader",y:"eit år",yy:"%d år"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),{1:"੧",2:"੨",3:"੩",4:"੪",5:"੫",6:"੬",7:"੭",8:"੮",9:"੯",0:"੦"}),Os={"੧":"1","੨":"2","੩":"3","੪":"4","੫":"5","੬":"6","੭":"7","੮":"8","੯":"9","੦":"0"},zs=(Wr.defineLocale("pa-in",{months:"ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ".split("_"),monthsShort:"ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ".split("_"),weekdays:"ਐਤਵਾਰ_ਸੋਮਵਾਰ_ਮੰਗਲਵਾਰ_ਬੁਧਵਾਰ_ਵੀਰਵਾਰ_ਸ਼ੁੱਕਰਵਾਰ_ਸ਼ਨੀਚਰਵਾਰ".split("_"),weekdaysShort:"ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ".split("_"),weekdaysMin:"ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ".split("_"),longDateFormat:{LT:"A h:mm ਵਜੇ",LTS:"A h:mm:ss ਵਜੇ",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm ਵਜੇ",LLLL:"dddd, D MMMM YYYY, A h:mm ਵਜੇ"},calendar:{sameDay:"[ਅਜ] LT",nextDay:"[ਕਲ] LT",nextWeek:"dddd, LT",lastDay:"[ਕਲ] LT",lastWeek:"[ਪਿਛਲੇ] dddd, LT",sameElse:"L"},relativeTime:{future:"%s ਵਿੱਚ",past:"%s ਪਿਛਲੇ",s:"ਕੁਝ ਸਕਿੰਟ",m:"ਇਕ ਮਿੰਟ",mm:"%d ਮਿੰਟ",h:"ਇੱਕ ਘੰਟਾ",hh:"%d ਘੰਟੇ",d:"ਇੱਕ ਦਿਨ",dd:"%d ਦਿਨ",M:"ਇੱਕ ਮਹੀਨਾ",MM:"%d ਮਹੀਨੇ",y:"ਇੱਕ ਸਾਲ",yy:"%d ਸਾਲ"},preparse:function(e){return e.replace(/[੧੨੩੪੫੬੭੮੯੦]/g,function(e){return Os[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return As[e]})},meridiemParse:/ਰਾਤ|ਸਵੇਰ|ਦੁਪਹਿਰ|ਸ਼ਾਮ/,meridiemHour:function(e,t){return 12===e&&(e=0),"ਰਾਤ"===t?4>e?e:e+12:"ਸਵੇਰ"===t?e:"ਦੁਪਹਿਰ"===t?e>=10?e:e+12:"ਸ਼ਾਮ"===t?e+12:void 0},meridiem:function(e,t,n){return 4>e?"ਰਾਤ":10>e?"ਸਵੇਰ":17>e?"ਦੁਪਹਿਰ":20>e?"ਸ਼ਾਮ":"ਰਾਤ"},week:{dow:0,doy:6}}),"styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_")),Ps="stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_"),$s=(Wr.defineLocale("pl",{months:function(e,t){return""===t?"("+Ps[e.month()]+"|"+zs[e.month()]+")":/D MMMM/.test(t)?Ps[e.month()]:zs[e.month()]},monthsShort:"sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),weekdays:"niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),weekdaysShort:"nie_pon_wt_śr_czw_pt_sb".split("_"),weekdaysMin:"Nd_Pn_Wt_Śr_Cz_Pt_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Dziś o] LT",nextDay:"[Jutro o] LT",nextWeek:"[W] dddd [o] LT",lastDay:"[Wczoraj o] LT",lastWeek:function(){switch(this.day()){case 0:return"[W zeszłą niedzielę o] LT";case 3:return"[W zeszłą środę o] LT";case 6:return"[W zeszłą sobotę o] LT";default:return"[W zeszły] dddd [o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"%s temu",s:"kilka sekund",m:Ai,mm:Ai,h:Ai,hh:Ai,d:"1 dzień",dd:"%d dni",M:"miesiąc",MM:Ai,y:"rok",yy:Ai},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("pt-br",{months:"Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),monthsShort:"Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),weekdays:"Domingo_Segunda-feira_Terça-feira_Quarta-feira_Quinta-feira_Sexta-feira_Sábado".split("_"),weekdaysShort:"Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),weekdaysMin:"Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY [às] HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY [às] HH:mm"},calendar:{sameDay:"[Hoje às] LT",nextDay:"[Amanhã às] LT",nextWeek:"dddd [às] LT",lastDay:"[Ontem às] LT",lastWeek:function(){return 0===this.day()||6===this.day()?"[Último] dddd [às] LT":"[Última] dddd [às] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"%s atrás",s:"poucos segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",M:"um mês",MM:"%d meses",y:"um ano",yy:"%d anos"},ordinalParse:/\d{1,2}º/,ordinal:"%dº"}),Wr.defineLocale("pt",{months:"Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro".split("_"),monthsShort:"Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez".split("_"),weekdays:"Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado".split("_"),weekdaysShort:"Dom_Seg_Ter_Qua_Qui_Sex_Sáb".split("_"),weekdaysMin:"Dom_2ª_3ª_4ª_5ª_6ª_Sáb".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY HH:mm",LLLL:"dddd, D [de] MMMM [de] YYYY HH:mm"},calendar:{sameDay:"[Hoje às] LT",nextDay:"[Amanhã às] LT",nextWeek:"dddd [às] LT",lastDay:"[Ontem às] LT",lastWeek:function(){return 0===this.day()||6===this.day()?"[Último] dddd [às] LT":"[Última] dddd [às] LT"},sameElse:"L"},relativeTime:{future:"em %s",past:"há %s",s:"segundos",m:"um minuto",mm:"%d minutos",h:"uma hora",hh:"%d horas",d:"um dia",dd:"%d dias",M:"um mês",MM:"%d meses",y:"um ano",yy:"%d anos"},ordinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}}),Wr.defineLocale("ro",{months:"ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie".split("_"),monthsShort:"ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.".split("_"),weekdays:"duminică_luni_marți_miercuri_joi_vineri_sâmbătă".split("_"),weekdaysShort:"Dum_Lun_Mar_Mie_Joi_Vin_Sâm".split("_"),weekdaysMin:"Du_Lu_Ma_Mi_Jo_Vi_Sâ".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY H:mm",LLLL:"dddd, D MMMM YYYY H:mm"},calendar:{sameDay:"[azi la] LT",nextDay:"[mâine la] LT",nextWeek:"dddd [la] LT",lastDay:"[ieri la] LT",lastWeek:"[fosta] dddd [la] LT",sameElse:"L"},relativeTime:{future:"peste %s",past:"%s în urmă",s:"câteva secunde",m:"un minut",mm:Oi,h:"o oră",hh:Oi,d:"o zi",dd:Oi,M:"o lună",MM:Oi,y:"un an",yy:Oi},week:{dow:1,doy:7}}),[/^янв/i,/^фев/i,/^мар/i,/^апр/i,/^ма[й|я]/i,/^июн/i,/^июл/i,/^авг/i,/^сен/i,/^окт/i,/^ноя/i,/^дек/i]),Js=(Wr.defineLocale("ru",{months:{format:"января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_"),standalone:"январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_")},monthsShort:{format:"янв_фев_мар_апр_мая_июня_июля_авг_сен_окт_ноя_дек".split("_"),standalone:"янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек".split("_")},weekdays:{standalone:"воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),format:"воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_"),isFormat:/\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/},weekdaysShort:"вс_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"вс_пн_вт_ср_чт_пт_сб".split("_"),monthsParse:$s,longMonthsParse:$s,shortMonthsParse:$s,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., HH:mm",LLLL:"dddd, D MMMM YYYY г., HH:mm"},calendar:{sameDay:"[Сегодня в] LT",nextDay:"[Завтра в] LT",lastDay:"[Вчера в] LT",nextWeek:function(e){if(e.week()===this.week())return 2===this.day()?"[Во] dddd [в] LT":"[В] dddd [в] LT";switch(this.day()){case 0:return"[В следующее] dddd [в] LT";case 1:;case 2:;case 4:return"[В следующий] dddd [в] LT";case 3:;case 5:;case 6:return"[В следующую] dddd [в] LT"}},lastWeek:function(e){if(e.week()===this.week())return 2===this.day()?"[Во] dddd [в] LT":"[В] dddd [в] LT";switch(this.day()){case 0:return"[В прошлое] dddd [в] LT";case 1:;case 2:;case 4:return"[В прошлый] dddd [в] LT";case 3:;case 5:;case 6:return"[В прошлую] dddd [в] LT"}},sameElse:"L"},relativeTime:{future:"через %s",past:"%s назад",s:"несколько секунд",m:Pi,mm:Pi,h:"час",hh:Pi,d:"день",dd:Pi,M:"месяц",MM:Pi,y:"год",yy:Pi},meridiemParse:/ночи|утра|дня|вечера/i,isPM:function(e){return /^(дня|вечера)$/.test(e)},meridiem:function(e,t,n){return 4>e?"ночи":12>e?"утра":17>e?"дня":"вечера"},ordinalParse:/\d{1,2}-(й|го|я)/,ordinal:function(e,t){switch(t){case"M":;case"d":;case"DDD":return e+"-й";case"D":return e+"-го";case"w":;case"W":return e+"-я";default:return e}},week:{dow:1,doy:7}}),Wr.defineLocale("se",{months:"ođđajagemánnu_guovvamánnu_njukčamánnu_cuoŋománnu_miessemánnu_geassemánnu_suoidnemánnu_borgemánnu_čakčamánnu_golggotmánnu_skábmamánnu_juovlamánnu".split("_"),monthsShort:"ođđj_guov_njuk_cuo_mies_geas_suoi_borg_čakč_golg_skáb_juov".split("_"),weekdays:"sotnabeaivi_vuossárga_maŋŋebárga_gaskavahkku_duorastat_bearjadat_lávvardat".split("_"),weekdaysShort:"sotn_vuos_maŋ_gask_duor_bear_láv".split("_"),weekdaysMin:"s_v_m_g_d_b_L".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"MMMM D. [b.] YYYY",LLL:"MMMM D. [b.] YYYY [ti.] HH:mm",LLLL:"dddd, MMMM D. [b.] YYYY [ti.] HH:mm"},calendar:{sameDay:"[otne ti] LT",nextDay:"[ihttin ti] LT",nextWeek:"dddd [ti] LT",lastDay:"[ikte ti] LT",lastWeek:"[ovddit] dddd [ti] LT",sameElse:"L"},relativeTime:{future:"%s geažes",past:"maŋit %s",s:"moadde sekunddat",m:"okta minuhta",mm:"%d minuhtat",h:"okta diimmu",hh:"%d diimmut",d:"okta beaivi",dd:"%d beaivvit",M:"okta mánnu",MM:"%d mánut",y:"okta jahki",yy:"%d jagit"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("si",{months:"ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්".split("_"),monthsShort:"ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ".split("_"),weekdays:"ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා".split("_"),weekdaysShort:"ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන".split("_"),weekdaysMin:"ඉ_ස_අ_බ_බ්‍ර_සි_සෙ".split("_"),longDateFormat:{LT:"a h:mm",LTS:"a h:mm:ss",L:"YYYY/MM/DD",LL:"YYYY MMMM D",LLL:"YYYY MMMM D, a h:mm",LLLL:"YYYY MMMM D [වැනි] dddd, a h:mm:ss"},calendar:{sameDay:"[අද] LT[ට]",nextDay:"[හෙට] LT[ට]",nextWeek:"dddd LT[ට]",lastDay:"[ඊයේ] LT[ට]",lastWeek:"[පසුගිය] dddd LT[ට]",sameElse:"L"},relativeTime:{future:"%sකින්",past:"%sකට පෙර",s:"තත්පර කිහිපය",m:"මිනිත්තුව",mm:"මිනිත්තු %d",h:"පැය",hh:"පැය %d",d:"දිනය",dd:"දින %d",M:"මාසය",MM:"මාස %d",y:"වසර",yy:"වසර %d"},ordinalParse:/\d{1,2} වැනි/,ordinal:function(e){return e+" වැනි"},meridiemParse:/පෙර වරු|පස් වරු|පෙ.ව|ප.ව./,isPM:function(e){return"ප.ව."===e||"පස් වරු"===e},meridiem:function(e,t,n){return e>11?n?"ප.ව.":"පස් වරු":n?"පෙ.ව.":"පෙර වරු"}}),"január_február_marec_apríl_máj_jún_júl_august_september_október_november_december".split("_")),Fs="jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec".split("_"),Is=(Wr.defineLocale("sk",{months:Js,monthsShort:Fs,weekdays:"nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota".split("_"),weekdaysShort:"ne_po_ut_st_št_pi_so".split("_"),weekdaysMin:"ne_po_ut_st_št_pi_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd D. MMMM YYYY H:mm"},calendar:{sameDay:"[dnes o] LT",nextDay:"[zajtra o] LT",nextWeek:function(){switch(this.day()){case 0:return"[v nedeľu o] LT";case 1:;case 2:return"[v] dddd [o] LT";case 3:return"[v stredu o] LT";case 4:return"[vo štvrtok o] LT";case 5:return"[v piatok o] LT";case 6:return"[v sobotu o] LT"}},lastDay:"[včera o] LT",lastWeek:function(){switch(this.day()){case 0:return"[minulú nedeľu o] LT";case 1:;case 2:return"[minulý] dddd [o] LT";case 3:return"[minulú stredu o] LT";case 4:;case 5:return"[minulý] dddd [o] LT";case 6:return"[minulú sobotu o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"pred %s",s:Ji,m:Ji,mm:Ji,h:Ji,hh:Ji,d:Ji,dd:Ji,M:Ji,MM:Ji,y:Ji,yy:Ji},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("sl",{months:"januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december".split("_"),monthsShort:"jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.".split("_"),weekdays:"nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota".split("_"),weekdaysShort:"ned._pon._tor._sre._čet._pet._sob.".split("_"),weekdaysMin:"ne_po_to_sr_če_pe_so".split("_"),longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danes ob] LT",nextDay:"[jutri ob] LT",nextWeek:function(){switch(this.day()){case 0:return"[v] [nedeljo] [ob] LT";case 3:return"[v] [sredo] [ob] LT";case 6:return"[v] [soboto] [ob] LT";case 1:;case 2:;case 4:;case 5:return"[v] dddd [ob] LT"}},lastDay:"[včeraj ob] LT",lastWeek:function(){switch(this.day()){case 0:return"[prejšnjo] [nedeljo] [ob] LT";case 3:return"[prejšnjo] [sredo] [ob] LT";case 6:return"[prejšnjo] [soboto] [ob] LT";case 1:;case 2:;case 4:;case 5:return"[prejšnji] dddd [ob] LT"}},sameElse:"L"},relativeTime:{future:"čez %s",past:"pred %s",s:Fi,m:Fi,mm:Fi,h:Fi,hh:Fi,d:Fi,dd:Fi,M:Fi,MM:Fi,y:Fi,yy:Fi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),Wr.defineLocale("sq",{months:"Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor".split("_"),monthsShort:"Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj".split("_"),weekdays:"E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë".split("_"),weekdaysShort:"Die_Hën_Mar_Mër_Enj_Pre_Sht".split("_"),weekdaysMin:"D_H_Ma_Më_E_P_Sh".split("_"),meridiemParse:/PD|MD/,isPM:function(e){return"M"===e.charAt(0)},meridiem:function(e,t,n){return 12>e?"PD":"MD"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Sot në] LT",nextDay:"[Nesër në] LT",nextWeek:"dddd [në] LT",lastDay:"[Dje në] LT",lastWeek:"dddd [e kaluar në] LT",sameElse:"L"},relativeTime:{future:"në %s",past:"%s më parë",s:"disa sekonda",m:"një minutë",mm:"%d minuta",h:"një orë",hh:"%d orë",d:"një ditë",dd:"%d ditë",M:"një muaj",MM:"%d muaj",y:"një vit",yy:"%d vite"},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),{words:{m:["један минут","једне минуте"],mm:["минут","минуте","минута"],h:["један сат","једног сата"],hh:["сат","сата","сати"],dd:["дан","дана","дана"],MM:["месец","месеца","месеци"],yy:["година","године","година"]},correctGrammaticalCase:function(e,t){return 1===e?t[0]:e>=2&&4>=e?t[1]:t[2]},translate:function(e,t,n){var i=Is.words[n];return 1===n.length?t?i[0]:i[1]:e+" "+Is.correctGrammaticalCase(e,i)}}),Ws=(Wr.defineLocale("sr-cyrl",{months:["јануар","фебруар","март","април","мај","јун","јул","август","септембар","октобар","новембар","децембар"],monthsShort:["јан.","феб.","мар.","апр.","мај","јун","јул","авг.","сеп.","окт.","нов.","дец."],weekdays:["недеља","понедељак","уторак","среда","четвртак","петак","субота"],weekdaysShort:["нед.","пон.","уто.","сре.","чет.","пет.","суб."],weekdaysMin:["не","по","ут","ср","че","пе","су"],longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[данас у] LT",nextDay:"[сутра у] LT",nextWeek:function(){switch(this.day()){case 0:return"[у] [недељу] [у] LT";case 3:return"[у] [среду] [у] LT";case 6:return"[у] [суботу] [у] LT";case 1:;case 2:;case 4:;case 5:return"[у] dddd [у] LT"}},lastDay:"[јуче у] LT",lastWeek:function(){var e=["[прошле] [недеље] [у] LT","[прошлог] [понедељка] [у] LT","[прошлог] [уторка] [у] LT","[прошле] [среде] [у] LT","[прошлог] [четвртка] [у] LT","[прошлог] [петка] [у] LT","[прошле] [суботе] [у] LT"];return e[this.day()]},sameElse:"L"},relativeTime:{future:"за %s",past:"пре %s",s:"неколико секунди",m:Is.translate,mm:Is.translate,h:Is.translate,hh:Is.translate,d:"дан",dd:Is.translate,M:"месец",MM:Is.translate,y:"годину",yy:Is.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),{words:{m:["jedan minut","jedne minute"],mm:["minut","minute","minuta"],h:["jedan sat","jednog sata"],hh:["sat","sata","sati"],dd:["dan","dana","dana"],MM:["mesec","meseca","meseci"],yy:["godina","godine","godina"]},correctGrammaticalCase:function(e,t){return 1===e?t[0]:e>=2&&4>=e?t[1]:t[2]},translate:function(e,t,n){var i=Ws.words[n];return 1===n.length?t?i[0]:i[1]:e+" "+Ws.correctGrammaticalCase(e,i)}}),Us=(Wr.defineLocale("sr",{months:["januar","februar","mart","april","maj","jun","jul","avgust","septembar","oktobar","novembar","decembar"],monthsShort:["jan.","feb.","mar.","apr.","maj","jun","jul","avg.","sep.","okt.","nov.","dec."],weekdays:["nedelja","ponedeljak","utorak","sreda","četvrtak","petak","subota"],weekdaysShort:["ned.","pon.","uto.","sre.","čet.","pet.","sub."],weekdaysMin:["ne","po","ut","sr","če","pe","su"],longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD. MM. YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY H:mm",LLLL:"dddd, D. MMMM YYYY H:mm"},calendar:{sameDay:"[danas u] LT",nextDay:"[sutra u] LT",nextWeek:function(){switch(this.day()){case 0:return"[u] [nedelju] [u] LT";case 3:return"[u] [sredu] [u] LT";case 6:return"[u] [subotu] [u] LT";case 1:;case 2:;case 4:;case 5:return"[u] dddd [u] LT"}},lastDay:"[juče u] LT",lastWeek:function(){var e=["[prošle] [nedelje] [u] LT","[prošlog] [ponedeljka] [u] LT","[prošlog] [utorka] [u] LT","[prošle] [srede] [u] LT","[prošlog] [četvrtka] [u] LT","[prošlog] [petka] [u] LT","[prošle] [subote] [u] LT"];return e[this.day()]},sameElse:"L"},relativeTime:{future:"za %s",past:"pre %s",s:"nekoliko sekundi",m:Ws.translate,mm:Ws.translate,h:Ws.translate,hh:Ws.translate,d:"dan",dd:Ws.translate,M:"mesec",MM:Ws.translate,y:"godinu",yy:Ws.translate},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:7}}),Wr.defineLocale("sv",{months:"januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december".split("_"),monthsShort:"jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec".split("_"),weekdays:"söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag".split("_"),weekdaysShort:"sön_mån_tis_ons_tor_fre_lör".split("_"),weekdaysMin:"sö_må_ti_on_to_fr_lö".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY-MM-DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Idag] LT",nextDay:"[Imorgon] LT",lastDay:"[Igår] LT",nextWeek:"[På] dddd LT",lastWeek:"[I] dddd[s] LT",sameElse:"L"},relativeTime:{future:"om %s",past:"för %s sedan",s:"några sekunder",m:"en minut",mm:"%d minuter",h:"en timme",hh:"%d timmar",d:"en dag",dd:"%d dagar",M:"en månad",MM:"%d månader",y:"ett år",yy:"%d år"},ordinalParse:/\d{1,2}(e|a)/,ordinal:function(e){var t=e%10,n=1===~~(e%100/10)?"e":1===t?"a":2===t?"a":"e";return e+n},week:{dow:1,doy:4}}),Wr.defineLocale("sw",{months:"Januari_Februari_Machi_Aprili_Mei_Juni_Julai_Agosti_Septemba_Oktoba_Novemba_Desemba".split("_"),monthsShort:"Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ago_Sep_Okt_Nov_Des".split("_"),weekdays:"Jumapili_Jumatatu_Jumanne_Jumatano_Alhamisi_Ijumaa_Jumamosi".split("_"),weekdaysShort:"Jpl_Jtat_Jnne_Jtan_Alh_Ijm_Jmos".split("_"),weekdaysMin:"J2_J3_J4_J5_Al_Ij_J1".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[leo saa] LT",nextDay:"[kesho saa] LT",nextWeek:"[wiki ijayo] dddd [saat] LT",lastDay:"[jana] LT",lastWeek:"[wiki iliyopita] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s baadaye",past:"tokea %s",s:"hivi punde",m:"dakika moja",mm:"dakika %d",h:"saa limoja",hh:"masaa %d",d:"siku moja",dd:"masiku %d",M:"mwezi mmoja",MM:"miezi %d",y:"mwaka mmoja",yy:"miaka %d"},week:{dow:1,doy:7}}),{1:"௧",2:"௨",3:"௩",4:"௪",5:"௫",6:"௬",7:"௭",8:"௮",9:"௯",0:"௦"}),Es={"௧":"1","௨":"2","௩":"3","௪":"4","௫":"5","௬":"6","௭":"7","௮":"8","௯":"9","௦":"0"},Vs=(Wr.defineLocale("ta",{months:"ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),monthsShort:"ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்".split("_"),weekdays:"ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை".split("_"),weekdaysShort:"ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி".split("_"),weekdaysMin:"ஞா_தி_செ_பு_வி_வெ_ச".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, HH:mm",LLLL:"dddd, D MMMM YYYY, HH:mm"},calendar:{sameDay:"[இன்று] LT",nextDay:"[நாளை] LT",nextWeek:"dddd, LT",lastDay:"[நேற்று] LT",lastWeek:"[கடந்த வாரம்] dddd, LT",sameElse:"L"},relativeTime:{future:"%s இல்",past:"%s முன்",s:"ஒரு சில விநாடிகள்",m:"ஒரு நிமிடம்",mm:"%d நிமிடங்கள்",h:"ஒரு மணி நேரம்",hh:"%d மணி நேரம்",d:"ஒரு நாள்",dd:"%d நாட்கள்",M:"ஒரு மாதம்",MM:"%d மாதங்கள்",y:"ஒரு வருடம்",yy:"%d ஆண்டுகள்"},ordinalParse:/\d{1,2}வது/,ordinal:function(e){return e+"வது"},preparse:function(e){return e.replace(/[௧௨௩௪௫௬௭௮௯௦]/g,function(e){return Es[e]})},postformat:function(e){return e.replace(/\d/g,function(e){return Us[e]})},meridiemParse:/யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,meridiem:function(e,t,n){return 2>e?" யாமம்":6>e?" வைகறை":10>e?" காலை":14>e?" நண்பகல்":18>e?" எற்பாடு":22>e?" மாலை":" யாமம்"},meridiemHour:function(e,t){return 12===e&&(e=0),"யாமம்"===t?2>e?e:e+12:"வைகறை"===t||"காலை"===t?e:"நண்பகல்"===t&&e>=10?e:e+12},week:{dow:0,doy:6}}),Wr.defineLocale("te",{months:"జనవరి_ఫిబ్రవరి_మార్చి_ఏప్రిల్_మే_జూన్_జూలై_ఆగస్టు_సెప్టెంబర్_అక్టోబర్_నవంబర్_డిసెంబర్".split("_"),monthsShort:"జన._ఫిబ్ర._మార్చి_ఏప్రి._మే_జూన్_జూలై_ఆగ._సెప్._అక్టో._నవ._డిసె.".split("_"),weekdays:"ఆదివారం_సోమవారం_మంగళవారం_బుధవారం_గురువారం_శుక్రవారం_శనివారం".split("_"),weekdaysShort:"ఆది_సోమ_మంగళ_బుధ_గురు_శుక్ర_శని".split("_"),weekdaysMin:"ఆ_సో_మం_బు_గు_శు_శ".split("_"),longDateFormat:{LT:"A h:mm",LTS:"A h:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY, A h:mm",LLLL:"dddd, D MMMM YYYY, A h:mm"},calendar:{sameDay:"[నేడు] LT",nextDay:"[రేపు] LT",nextWeek:"dddd, LT",lastDay:"[నిన్న] LT",lastWeek:"[గత] dddd, LT",sameElse:"L"},relativeTime:{future:"%s లో",past:"%s క్రితం",s:"కొన్ని క్షణాలు",m:"ఒక నిమిషం",mm:"%d నిమిషాలు",h:"ఒక గంట",hh:"%d గంటలు",d:"ఒక రోజు",dd:"%d రోజులు",M:"ఒక నెల",MM:"%d నెలలు",y:"ఒక సంవత్సరం",yy:"%d సంవత్సరాలు"},ordinalParse:/\d{1,2}వ/,ordinal:"%dవ",meridiemParse:/రాత్రి|ఉదయం|మధ్యాహ్నం|సాయంత్రం/,meridiemHour:function(e,t){return 12===e&&(e=0),"రాత్రి"===t?4>e?e:e+12:"ఉదయం"===t?e:"మధ్యాహ్నం"===t?e>=10?e:e+12:"సాయంత్రం"===t?e+12:void 0},meridiem:function(e,t,n){return 4>e?"రాత్రి":10>e?"ఉదయం":17>e?"మధ్యాహ్నం":20>e?"సాయంత్రం":"రాత్రి"},week:{dow:0,doy:6}}),Wr.defineLocale("th",{months:"มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม".split("_"),monthsShort:"มกรา_กุมภา_มีนา_เมษา_พฤษภา_มิถุนา_กรกฎา_สิงหา_กันยา_ตุลา_พฤศจิกา_ธันวา".split("_"),weekdays:"อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์".split("_"),weekdaysShort:"อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์".split("_"),weekdaysMin:"อา._จ._อ._พ._พฤ._ศ._ส.".split("_"),longDateFormat:{LT:"H นาฬิกา m นาที",LTS:"H นาฬิกา m นาที s วินาที",L:"YYYY/MM/DD",LL:"D MMMM YYYY",LLL:"D MMMM YYYY เวลา H นาฬิกา m นาที",LLLL:"วันddddที่ D MMMM YYYY เวลา H นาฬิกา m นาที"},meridiemParse:/ก่อนเที่ยง|หลังเที่ยง/,isPM:function(e){return"หลังเที่ยง"===e},meridiem:function(e,t,n){return 12>e?"ก่อนเที่ยง":"หลังเที่ยง"},calendar:{sameDay:"[วันนี้ เวลา] LT",nextDay:"[พรุ่งนี้ เวลา] LT",nextWeek:"dddd[หน้า เวลา] LT",lastDay:"[เมื่อวานนี้ เวลา] LT",lastWeek:"[วัน]dddd[ที่แล้ว เวลา] LT",sameElse:"L"},relativeTime:{future:"อีก %s",past:"%sที่แล้ว",s:"ไม่กี่วินาที",m:"1 นาที",mm:"%d นาที",h:"1 ชั่วโมง",hh:"%d ชั่วโมง",d:"1 วัน",dd:"%d วัน",M:"1 เดือน",MM:"%d เดือน",y:"1 ปี",yy:"%d ปี"}}),Wr.defineLocale("tl-ph",{months:"Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre".split("_"),monthsShort:"Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis".split("_"),weekdays:"Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado".split("_"),weekdaysShort:"Lin_Lun_Mar_Miy_Huw_Biy_Sab".split("_"),weekdaysMin:"Li_Lu_Ma_Mi_Hu_Bi_Sab".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"MM/D/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY HH:mm",LLLL:"dddd, MMMM DD, YYYY HH:mm"},calendar:{sameDay:"[Ngayon sa] LT",nextDay:"[Bukas sa] LT",nextWeek:"dddd [sa] LT",lastDay:"[Kahapon sa] LT",lastWeek:"dddd [huling linggo] LT",sameElse:"L"},relativeTime:{future:"sa loob ng %s",past:"%s ang nakalipas",s:"ilang segundo",m:"isang minuto",mm:"%d minuto",h:"isang oras",hh:"%d oras",d:"isang araw",dd:"%d araw",M:"isang buwan",MM:"%d buwan",y:"isang taon",yy:"%d taon"},ordinalParse:/\d{1,2}/,ordinal:function(e){return e},week:{dow:1,doy:4}}),"pagh_wa’_cha’_wej_loS_vagh_jav_Soch_chorgh_Hut".split("_")),qs=(Wr.defineLocale("tlh",{months:"tera’ jar wa’_tera’ jar cha’_tera’ jar wej_tera’ jar loS_tera’ jar vagh_tera’ jar jav_tera’ jar Soch_tera’ jar chorgh_tera’ jar Hut_tera’ jar wa’maH_tera’ jar wa’maH wa’_tera’ jar wa’maH cha’".split("_"),monthsShort:"jar wa’_jar cha’_jar wej_jar loS_jar vagh_jar jav_jar Soch_jar chorgh_jar Hut_jar wa’maH_jar wa’maH wa’_jar wa’maH cha’".split("_"),weekdays:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysShort:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),weekdaysMin:"lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[DaHjaj] LT",nextDay:"[wa’leS] LT",nextWeek:"LLL",lastDay:"[wa’Hu’] LT",lastWeek:"LLL",sameElse:"L"},relativeTime:{future:Ii,past:Wi,s:"puS lup",m:"wa’ tup",mm:Ui,h:"wa’ rep",hh:Ui,d:"wa’ jaj",dd:Ui,M:"wa’ jar",MM:Ui,y:"wa’ DIS",yy:Ui},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),{1:"'inci",5:"'inci",8:"'inci",70:"'inci",80:"'inci",2:"'nci",7:"'nci",20:"'nci",50:"'nci",3:"'üncü",4:"'üncü",100:"'üncü",6:"'ncı",9:"'uncu",10:"'uncu",30:"'uncu",60:"'ıncı",90:"'ıncı"}),Ns=(Wr.defineLocale("tr",{months:"Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık".split("_"),monthsShort:"Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara".split("_"),weekdays:"Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi".split("_"),weekdaysShort:"Paz_Pts_Sal_Çar_Per_Cum_Cts".split("_"),weekdaysMin:"Pz_Pt_Sa_Ça_Pe_Cu_Ct".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[bugün saat] LT",nextDay:"[yarın saat] LT",nextWeek:"[haftaya] dddd [saat] LT",lastDay:"[dün] LT",lastWeek:"[geçen hafta] dddd [saat] LT",sameElse:"L"},relativeTime:{future:"%s sonra",past:"%s önce",s:"birkaç saniye",m:"bir dakika",mm:"%d dakika",h:"bir saat",hh:"%d saat",d:"bir gün",dd:"%d gün",M:"bir ay",MM:"%d ay",y:"bir yıl",yy:"%d yıl"},ordinalParse:/\d{1,2}'(inci|nci|üncü|ncı|uncu|ıncı)/,ordinal:function(e){if(0===e)return e+"'ıncı";var t=e%10,n=e%100-t,i=e>=100?100:null;return e+(qs[t]||qs[n]||qs[i])},week:{dow:1,doy:7}}),Wr.defineLocale("tzl",{months:"Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar".split("_"),monthsShort:"Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec".split("_"),weekdays:"Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi".split("_"),weekdaysShort:"Súl_Lún_Mai_Már_Xhú_Vié_Sát".split("_"),weekdaysMin:"Sú_Lú_Ma_Má_Xh_Vi_Sá".split("_"),longDateFormat:{LT:"HH.mm",LTS:"HH.mm.ss",L:"DD.MM.YYYY",LL:"D. MMMM [dallas] YYYY",LLL:"D. MMMM [dallas] YYYY HH.mm",LLLL:"dddd, [li] D. MMMM [dallas] YYYY HH.mm"},meridiemParse:/d\'o|d\'a/i,isPM:function(e){return"d'o"===e.toLowerCase()},meridiem:function(e,t,n){return e>11?n?"d'o":"D'O":n?"d'a":"D'A"},calendar:{sameDay:"[oxhi à] LT",nextDay:"[demà à] LT",nextWeek:"dddd [à] LT",lastDay:"[ieiri à] LT",lastWeek:"[sür el] dddd [lasteu à] LT",sameElse:"L"},relativeTime:{future:"osprei %s",past:"ja%s",s:Vi,m:Vi,mm:Vi,h:Vi,hh:Vi,d:Vi,dd:Vi,M:Vi,MM:Vi,y:Vi,yy:Vi},ordinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}}),Wr.defineLocale("tzm-latn",{months:"innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),monthsShort:"innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir".split("_"),weekdays:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),weekdaysShort:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),weekdaysMin:"asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[asdkh g] LT",nextDay:"[aska g] LT",nextWeek:"dddd [g] LT",lastDay:"[assant g] LT",lastWeek:"dddd [g] LT",sameElse:"L"},relativeTime:{future:"dadkh s yan %s",past:"yan %s",s:"imik",m:"minuḍ",mm:"%d minuḍ",h:"saɛa",hh:"%d tassaɛin",d:"ass",dd:"%d ossan",M:"ayowr",MM:"%d iyyirn",y:"asgas",yy:"%d isgasn"},week:{dow:6,doy:12}}),Wr.defineLocale("tzm",{months:"ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),monthsShort:"ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ".split("_"),weekdays:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),weekdaysShort:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),weekdaysMin:"ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[ⴰⵙⴷⵅ ⴴ] LT",nextDay:"[ⴰⵙⴽⴰ ⴴ] LT",nextWeek:"dddd [ⴴ] LT",lastDay:"[ⴰⵚⴰⵏⵜ ⴴ] LT",lastWeek:"dddd [ⴴ] LT",sameElse:"L"},relativeTime:{future:"ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s",past:"ⵢⴰⵏ %s",s:"ⵉⵎⵉⴽ",m:"ⵎⵉⵏⵓⴺ",mm:"%d ⵎⵉⵏⵓⴺ",h:"ⵙⴰⵄⴰ",hh:"%d ⵜⴰⵙⵙⴰⵄⵉⵏ",d:"ⴰⵙⵙ",dd:"%d oⵙⵙⴰⵏ",M:"ⴰⵢoⵓⵔ",MM:"%d ⵉⵢⵢⵉⵔⵏ",y:"ⴰⵙⴳⴰⵙ",yy:"%d ⵉⵙⴳⴰⵙⵏ"},week:{dow:6,doy:12}}),Wr.defineLocale("uk",{months:{format:"січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_"),standalone:"січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_")},monthsShort:"січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),weekdays:Gi,weekdaysShort:"нд_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY р.",LLL:"D MMMM YYYY р., HH:mm",LLLL:"dddd, D MMMM YYYY р., HH:mm"},calendar:{sameDay:Ri("[Сьогодні "),nextDay:Ri("[Завтра "),lastDay:Ri("[Вчора "),nextWeek:Ri("[У] dddd ["),lastWeek:function(){switch(this.day()){case 0:;case 3:;case 5:;case 6:return Ri("[Минулої] dddd [").call(this);case 1:;case 2:;case 4:return Ri("[Минулого] dddd [").call(this)}},sameElse:"L"},relativeTime:{future:"за %s",past:"%s тому",s:"декілька секунд",m:Ni,mm:Ni,h:"годину",hh:Ni,d:"день",dd:Ni,M:"місяць",MM:Ni,y:"рік",yy:Ni},meridiemParse:/ночі|ранку|дня|вечора/,isPM:function(e){return /^(дня|вечора)$/.test(e)},meridiem:function(e,t,n){return 4>e?"ночі":12>e?"ранку":17>e?"дня":"вечора"},ordinalParse:/\d{1,2}-(й|го)/,ordinal:function(e,t){switch(t){case"M":;case"d":;case"DDD":;case"w":;case"W":return e+"-й";case"D":return e+"-го";default:return e}},week:{dow:1,doy:7}}),Wr.defineLocale("uz",{months:"январ_феврал_март_апрел_май_июн_июл_август_сентябр_октябр_ноябр_декабр".split("_"),monthsShort:"янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),weekdays:"Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба".split("_"),weekdaysShort:"Якш_Душ_Сеш_Чор_Пай_Жум_Шан".split("_"),weekdaysMin:"Як_Ду_Се_Чо_Па_Жу_Ша".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"D MMMM YYYY, dddd HH:mm"},calendar:{sameDay:"[Бугун соат] LT [да]",nextDay:"[Эртага] LT [да]",nextWeek:"dddd [куни соат] LT [да]",lastDay:"[Кеча соат] LT [да]",lastWeek:"[Утган] dddd [куни соат] LT [да]",sameElse:"L"},relativeTime:{future:"Якин %s ичида",past:"Бир неча %s олдин",s:"фурсат",m:"бир дакика",mm:"%d дакика",h:"бир соат",hh:"%d соат",d:"бир кун",dd:"%d кун",M:"бир ой",MM:"%d ой",y:"бир йил",yy:"%d йил"},week:{dow:1,doy:7}}),Wr.defineLocale("vi",{months:"tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12".split("_"),monthsShort:"Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12".split("_"),weekdays:"chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy".split("_"),weekdaysShort:"CN_T2_T3_T4_T5_T6_T7".split("_"),weekdaysMin:"CN_T2_T3_T4_T5_T6_T7".split("_"),meridiemParse:/sa|ch/i,isPM:function(e){return /^ch$/i.test(e)},meridiem:function(e,t,n){return 12>e?n?"sa":"SA":n?"ch":"CH"},longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM [năm] YYYY",LLL:"D MMMM [năm] YYYY HH:mm",LLLL:"dddd, D MMMM [năm] YYYY HH:mm",l:"DD/M/YYYY",ll:"D MMM YYYY",lll:"D MMM YYYY HH:mm",llll:"ddd, D MMM YYYY HH:mm"},calendar:{sameDay:"[Hôm nay lúc] LT",nextDay:"[Ngày mai lúc] LT",nextWeek:"dddd [tuần tới lúc] LT",lastDay:"[Hôm qua lúc] LT",lastWeek:"dddd [tuần rồi lúc] LT",sameElse:"L"},relativeTime:{future:"%s tới",past:"%s trước",s:"vài giây",m:"một phút",mm:"%d phút",h:"một giờ",hh:"%d giờ",d:"một ngày",dd:"%d ngày",M:"một tháng",MM:"%d tháng",y:"một năm",yy:"%d năm"},ordinalParse:/\d{1,2}/,ordinal:function(e){return e},week:{dow:1,doy:4}}),Wr.defineLocale("zh-cn",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"周日_周一_周二_周三_周四_周五_周六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"Ah点mm分",LTS:"Ah点m分s秒",L:"YYYY-MM-DD",LL:"YYYY年MMMD日",LLL:"YYYY年MMMD日Ah点mm分",LLLL:"YYYY年MMMD日ddddAh点mm分",l:"YYYY-MM-DD",ll:"YYYY年MMMD日",lll:"YYYY年MMMD日Ah点mm分",llll:"YYYY年MMMD日ddddAh点mm分"},meridiemParse:/凌晨|早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"凌晨"===t||"早上"===t||"上午"===t?e:"下午"===t||"晚上"===t?e+12:e>=11?e:e+12},meridiem:function(e,t,n){var i=100*e+t;return 600>i?"凌晨":900>i?"早上":1130>i?"上午":1230>i?"中午":1800>i?"下午":"晚上"},calendar:{sameDay:function(){return 0===this.minutes()?"[今天]Ah[点整]":"[今天]LT"},nextDay:function(){return 0===this.minutes()?"[明天]Ah[点整]":"[明天]LT"},lastDay:function(){return 0===this.minutes()?"[昨天]Ah[点整]":"[昨天]LT"},nextWeek:function(){var e,t;return e=Wr().startOf("week"),t=this.unix()-e.unix()>=604800?"[下]":"[本]",0===this.minutes()?t+"dddAh点整":t+"dddAh点mm"},lastWeek:function(){var e,t;return e=Wr().startOf("week"),t=this.unix()<e.unix()?"[上]":"[本]",0===this.minutes()?t+"dddAh点整":t+"dddAh点mm"},sameElse:"LL"},ordinalParse:/\d{1,2}(日|月|周)/,ordinal:function(e,t){switch(t){case"d":;case"D":;case"DDD":return e+"日";case"M":return e+"月";case"w":;case"W":return e+"周";default:return e}},relativeTime:{future:"%s内",past:"%s前",s:"几秒",m:"1 分钟",mm:"%d 分钟",h:"1 小时",hh:"%d 小时",d:"1 天",dd:"%d 天",M:"1 个月",MM:"%d 个月",y:"1 年",yy:"%d 年"},week:{dow:1,doy:4}}),Wr.defineLocale("zh-tw",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"星期日_星期一_星期二_星期三_星期四_星期五_星期六".split("_"),weekdaysShort:"週日_週一_週二_週三_週四_週五_週六".split("_"),weekdaysMin:"日_一_二_三_四_五_六".split("_"),longDateFormat:{LT:"Ah點mm分",LTS:"Ah點m分s秒",L:"YYYY年MMMD日",LL:"YYYY年MMMD日",LLL:"YYYY年MMMD日Ah點mm分",LLLL:"YYYY年MMMD日ddddAh點mm分",l:"YYYY年MMMD日",ll:"YYYY年MMMD日",lll:"YYYY年MMMD日Ah點mm分",llll:"YYYY年MMMD日ddddAh點mm分"},meridiemParse:/早上|上午|中午|下午|晚上/,meridiemHour:function(e,t){return 12===e&&(e=0),"早上"===t||"上午"===t?e:"中午"===t?e>=11?e:e+12:"下午"===t||"晚上"===t?e+12:void 0},meridiem:function(e,t,n){var i=100*e+t;return 900>i?"早上":1130>i?"上午":1230>i?"中午":1800>i?"下午":"晚上"},calendar:{sameDay:"[今天]LT",nextDay:"[明天]LT",nextWeek:"[下]ddddLT",lastDay:"[昨天]LT",lastWeek:"[上]ddddLT",sameElse:"L"},ordinalParse:/\d{1,2}(日|月|週)/,ordinal:function(e,t){switch(t){case"d":;case"D":;case"DDD":return e+"日";case"M":return e+"月";case"w":;case"W":return e+"週";default:return e}},relativeTime:{future:"%s內",past:"%s前",s:"幾秒",m:"一分鐘",mm:"%d分鐘",h:"一小時",hh:"%d小時",d:"一天",dd:"%d天",M:"一個月",MM:"%d個月",y:"一年",yy:"%d年"}}),Wr);return Ns.locale("en"),Ns}),!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof exports?module.exports=e:e(jQuery)}(function(e){function t(t){var s=t||window.event,o=d.call(arguments,1),_=0,l=0,m=0,p=0,c=0,f=0;if(t=e.event.fix(s),t.type="mousewheel","detail" in s&&(m=-1*s.detail),"wheelDelta" in s&&(m=s.wheelDelta),"wheelDeltaY" in s&&(m=s.wheelDeltaY),"wheelDeltaX" in s&&(l=-1*s.wheelDeltaX),"axis" in s&&s.axis===s.HORIZONTAL_AXIS&&(l=-1*m,m=0),_=0===m?l:m,"deltaY" in s&&(m=-1*s.deltaY,_=m),"deltaX" in s&&(l=s.deltaX,0===m&&(_=-1*l)),0!==m||0!==l){if(1===s.deltaMode){var h=e.data(this,"mousewheel-line-height");_*=h,m*=h,l*=h}else if(2===s.deltaMode){var M=e.data(this,"mousewheel-page-height");_*=M,m*=M,l*=M}if(p=Math.max(Math.abs(m),Math.abs(l)),(!r||r>p)&&(r=p,i(s,p)&&(r/=40)),i(s,p)&&(_/=40,l/=40,m/=40),_=Math[_>=1?"floor":"ceil"](_/r),l=Math[l>=1?"floor":"ceil"](l/r),m=Math[m>=1?"floor":"ceil"](m/r),u.settings.normalizeOffset&&this.getBoundingClientRect){var Y=this.getBoundingClientRect();c=t.clientX-Y.left,f=t.clientY-Y.top}return t.deltaX=l,t.deltaY=m,t.deltaFactor=r,t.offsetX=c,t.offsetY=f,t.deltaMode=0,o.unshift(t,_,l,m),a&&clearTimeout(a),a=setTimeout(n,200),(e.event.dispatch||e.event.handle).apply(this,o)}}function n(){r=null}function i(e,t){return u.settings.adjustOldDeltas&&"mousewheel"===e.type&&t%120===0}var a,r,s=["wheel","mousewheel","DOMMouseScroll","MozMousePixelScroll"],o="onwheel" in document||document.documentMode>=9?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"],d=Array.prototype.slice;if(e.event.fixHooks)for(var _=s.length;_;)e.event.fixHooks[s[--_]]=e.event.mouseHooks;var u=e.event.special.mousewheel={version:"3.1.12",setup:function(){if(this.addEventListener)for(var n=o.length;n;)this.addEventListener(o[--n],t,!1);else this.onmousewheel=t;e.data(this,"mousewheel-line-height",u.getLineHeight(this)),e.data(this,"mousewheel-page-height",u.getPageHeight(this))},teardown:function(){if(this.removeEventListener)for(var n=o.length;n;)this.removeEventListener(o[--n],t,!1);else this.onmousewheel=null;e.removeData(this,"mousewheel-line-height"),e.removeData(this,"mousewheel-page-height")},getLineHeight:function(t){var n=e(t),i=n["offsetParent" in e.fn?"offsetParent":"parent"]();return i.length||(i=e("body")),parseInt(i.css("fontSize"),10)||parseInt(n.css("fontSize"),10)||16},getPageHeight:function(t){return e(t).height()},settings:{adjustOldDeltas:!0,normalizeOffset:!0}};e.fn.extend({mousewheel:function(e){return e?this.bind("mousewheel",e):this.trigger("mousewheel")},unmousewheel:function(e){return this.unbind("mousewheel",e)}})}),function(e,t,n){"use strict";function i(n){var i=new Date,a=0,r=this;return r.onChange=[],r.validate=function(){n.minTime&&(n.minTime instanceof Date||(n.minTime=r.parse(n.minTime)),r.isValid(n.minTime)?(n.minTime=r.cloneTime(n.minTime),i<n.minTime&&(i=r.cloneTime(n.minTime))):n.minTime=!1),n.maxTime&&(n.maxTime instanceof Date||(n.maxTime=r.parse(n.maxTime)),r.isValid(n.maxTime)?(n.maxTime=r.cloneTime(n.maxTime),i>n.maxTime&&(i=r.cloneTime(n.maxTime))):n.maxTime=!1)},r.cloneTime=function(e){var t=new Date;return t.setHours(e.getHours()),t.setMinutes(e.getMinutes()),t.setSeconds(e.getSeconds()),t},r.isValid=function(e){return"[object Date]"!==Object.prototype.toString.call(e)?!1:!isNaN(e.getTime())},r.hours12Format=function(){var e=i.getHours();return 0===e?12:e>0&&13>e?e:e>12&&23>=e?e-12:void 0},r.to12Format=function(e){return 12!==e||a?a&&12>e?e+12:e:0},r.change=function(t){var n;if(r.onChange.length)for(n=0;n<r.onChange.length;n+=1)e.isFunction(r.onChange[n])&&r.onChange[n].call(r,r.get(),i,t)},r.index=function(e,t){var s,o=i.getTime();if(void 0!==t&&null!==t){switch(t=parseInt(t,10),e){case 1:i.setMinutes(t);break;case 2:i.setSeconds(t);break;case 3:s=i.getHours(),a=t,12>s&&t?i.setHours(s+12):s>=12&&!t&&i.setHours(s-12);break;default:i.setHours(n.twelveHoursFormat?r.to12Format(t):t)}a=r.index(3),r.validate(),o!==i.getTime()&&r.change()}switch(e){case 1:return i.getMinutes();case 2:return i.getSeconds();case 3:return a=i.getHours()>=12?1:0;default:return n.twelveHoursFormat?r.hours12Format():i.getHours()}},r.parse=function(e){return void 0!==t.moment?moment(e,n.inputFormat).toDate():Date.parse(e)},r.set=function(e,t){var n=i.getTime(),a=r.isValid(e)?r.cloneTime(e):r.parse(e);r.isValid(a)&&(i=a,n!==i.getTime()&&(r.validate(),r.change(t)))},r.get=function(){return void 0!==t.moment?moment(i).format(n.inputFormat):String(i)},r.getTime=function(){return i.getTime()},r}function a(t,i,a){var r=this;r.box=a||n.body,r.options=i,r.startinput=e(t),r.uniqueid=s,s+=1,r.init()}function r(i,a){var r=this;r.uniqueid=s,s+=1,r.options=a,r.startinput=e(i),r.picker=e('<div class="periodpicker_timepicker_dialog"></div>'),r.startinput.TimePicker(a,r.picker),r.options.inline?(r.picker.addClass("periodpicker_timepicker_inline"),r.startinput.after(r.picker).hide(),r.startinput.TimePicker("regenerate")):(e(n.body).append(r.picker),r.startinput.on("focus.xdsoft"+r.uniqueid,function(){r.show()}),e(t).on("mousedown.xdsoft"+r.uniqueid,function(){r.hide()}))}var s=1;a.prototype.getRealOffset=function(e){var t=this.getIndex(e);return-1!==this.indexes[e].indexOf(t)?this.indexes[e].indexOf(t)*this.itemHeight():0},a.prototype.getIndex=function(e){return Math.floor(this.currentime.index(e)/this.options.steps[e])*this.options.steps[e]},a.prototype.height=function(){return this.timepicker?parseInt(this.timepicker.get(0).offsetHeight,10):0},a.prototype.itemHeight=function(){return this.items[0][0]?parseInt(this.items[0][0].get(0).offsetHeight,10):22},a.prototype.highlight=function(){var e,t;for(void 0===this.last&&(this.last=[]),e=0;e<this.boxes.length;e+=1)t=this.getIndex(e),void 0!==this.items[e][this.indexes[e].indexOf(t)]&&this.items[e][this.indexes[e].indexOf(t)].addClass("active"),void 0!==this.last[e]&&this.last[e]!==this.indexes[e].indexOf(t)&&void 0!==this.items[e][this.last[e]]&&this.items[e][this.last[e]].removeClass("active"),this.last[e]=this.indexes[e].indexOf(t)},a.prototype.setTime=function(e){var t,n;if(void 0!==e&&e&&e.length)for(n=this.boxes.length-1;n>=0;n-=1)this.currentime.index(n,e[n]);for(n=0;n<this.boxes.length;n+=1)void 0!==this.boxes[n]&&(t=-this.getRealOffset(n)+Math.ceil(this.height()-this.itemHeight())/2,this.boxes[n].css("margin-top",t+"px"));this.highlight()},a.prototype.xy=function(e){var t,n={x:0,y:0};return"touchstart"===e.type||"touchmove"===e.type||"touchend"===e.type||"touchcancel"===e.type?(t=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0],n.x=t.clientX,n.y=t.clientY):("mousedown"===e.type||"mouseup"===e.type||"mousemove"===e.type||"mouseover"===e.type||"mouseout"===e.type||"mouseenter"===e.type||"mouseleave"===e.type)&&(n.x=e.clientX,n.y=e.clientY),n},a.prototype.init=function(){var n,a,r,s=this;s.timepicker=e('<div class="periodpicker_timepicker xdsoft_noselect"><div class="periodpicker_timepicker_sliders">'+(s.options.hours?'<div data-index="0" class="periodpicker_hourspicker_box"><div class="periodpicker_hourspicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.minutes?'<div data-index="1" class="periodpicker_minutespicker_box"><div class="periodpicker_minutespicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.seconds?'<div data-index="2" class="periodpicker_secondspicker_box"><div class="periodpicker_secondspicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.ampm?'<div data-index="3" class="periodpicker_ampmpicker_box"><div class="periodpicker_ampmpicker"><div data-value="0" class="periodpicker_0 periodpicker_item">AM</div><div data-value="1" class="periodpicker_1 periodpicker_item">PM</div></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+'</div><div class="periodpicker_timepicker_center"></div></div>'),s.currentime=new i(s.options),s.startinput.length&&s.startinput.val()?s.currentime.set(s.startinput.val()):(s.startinput.val(s.options.defaultTime),s.currentime.set(s.options.defaultTime)),s.options.onChange&&s.currentime.onChange.push(s.options.onChange),s.options.saveOnChange&&s.currentime.onChange.push(function(e,t,n){var i=s.startinput.val();s.startinput.val(e),e===i||n||s.startinput.trigger("change")}),s.boxes={},r=0,s.timepicker.find(".periodpicker_timepicker_sliders>div>div").each(function(){r=Math.max(r,parseInt(e(this).parent().data("index"),10)),s.boxes[parseInt(e(this).parent().data("index"),10)]=e(this)}),s.boxes.length=r+1,s.timepicker.find(".periodpicker_timepicker_sliders>div").addClass("periodpicker_col"+s.timepicker.find(".periodpicker_timepicker_sliders>div>div").length),s.timer2=0,s.timepicker.on("mousewheel",function(e){s.options.mouseWheel&&(e.preventDefault(),e.stopPropagation())}),s.timepicker.find(".periodpicker_timepicker_sliders>div").on("mousewheel",function(t){if(s.options.mouseWheel){var n=e(this),i=[null,null,null,null],a=parseInt(e(this).data("index"),10);n.addClass("draggable"),3>a?i[a]=s.currentime.index(a)+-t.deltaY*(s.options.inverseMouseWheel?-1:1)*s.options.steps[a]:i[a]=s.currentime.index(a)-1,s.setTime(i),clearTimeout(s.timer2),s.timer2=setTimeout(function(){n.removeClass("draggable")},300),t.preventDefault(),t.stopPropagation()}}),s.timepicker.find(".periodpicker_timepicker_sliders").on("click",".periodpicker_item",function(){if(s.options.clickAndSelect){var t=parseInt(e(this).data("value"),10),n=[null,null,null,null],i=parseInt(e(this).parent().parent().data("index"),10);s.iwasdragged||isNaN(t)||(n[i]=t,s.setTime(n))}}),s.timer=0,s.timepicker.find(".periodpicker_timepicker_sliders>div input.periodpicker_key_hooker").on("keydown",function(t){if(s.options.listenKeyPress){var n=[null,null,null,null],i=e(this),a=parseInt(i.parent().data("index"),10),r=!1;switch(t.keyCode){case 38:n[a]=s.currentime.index(a)-s.options.steps[a],s.setTime(n),r=!0;break;case 39:e(this).parent().next().length&&e(this).parent().next().find("input.periodpicker_key_hooker").eq(0).focus(),r=!0;break;case 37:e(this).parent().prev().length&&e(this).parent().prev().find("input.periodpicker_key_hooker").eq(0).focus(),r=!0;break;case 40:n[a]=s.currentime.index(a)+s.options.steps[a],s.setTime(n),r=!0;break;default:/[0-9amp]/i.test(String.fromCharCode(t.keyCode))&&(i.val(i.val()+String.fromCharCode(t.keyCode)),r=!0),clearTimeout(s.timer),s.timer=setTimeout(function(){var e=i.val();i.val(""),3===a&&e.length&&(e="p"===e.toLowerCase().substr(0,1)?1:0),e=parseInt(e,10),isNaN(e)||(n[a]=e,s.setTime(n))},300)}r&&(t.preventDefault(),t.stopImmediatePropagation())}}),s.timepicker.find(".periodpicker_timepicker_sliders>div").on("mousedown.xdsoft touchstart.xdsoft",function(t){s.options.dragAndDrop&&(s.drag=!0,n=[s.xy(t).x,s.xy(t).y],n[4]=parseInt(e(this).data("index"),10),n[3]=s.boxes[n[4]],n[2]=parseInt(n[3].css("margin-top"),10),n[3].find("div").removeClass("active"),n[3].parent().addClass("draggable"),s.iwasdragged=!1,t.preventDefault(),t.stopImmediatePropagation()),e(this).find("input.periodpicker_key_hooker").focus()}),s.iwasdragged=!1,e(t).on("mouseup.xdsoft"+s.uniqueid+" touchend.xdsoft"+s.uniqueid,function(e){s.options.dragAndDrop&&s.drag&&(s.drag=!1,s.setTime(),n[3].parent().removeClass("draggable"),e.stopImmediatePropagation())}).on("mousemove.xdsoft"+s.uniqueid+" touchmove.xdsoft"+s.uniqueid,function(e){if(s.drag&&s.options.dragAndDrop){a=[s.xy(e).x-n[0],s.xy(e).y-n[1]],n[3].css({marginTop:n[2]+a[1]}),a[1]>10&&(s.iwasdragged=!0);var t=-Math.round((-(s.height()-s.itemHeight())/2+n[2]+a[1])/s.itemHeight());0>t&&(t=0),t>=s.items[n[4]].length&&(t=s.items[n[4]].length-1),t=parseInt(s.items[n[4]][t].data("value"),10),s.currentime.index(n[4],t),s.highlight(),e.preventDefault()}}),e(s.box).append(s.timepicker),s.generateTimepicker(),s.setTime()},a.prototype.destroy=function(){var n=this;e(t).off("mouseup.xdsoft"+n.uniqueid+" touchend.xdsoft"+n.uniqueid).off("mousemove.xdsoft"+n.uniqueid+" touchmove.xdsoft"+n.uniqueid),n.timepicker.remove(),delete n.timepicker,delete n.boxes,delete n.currentime},a.prototype.generateTimepicker=function(){var t,n,i=this;for(i.items=[[],[],[],[]],i.indexes=[[],[],[],[0,1]],t=0;2>=t;t+=1)if(void 0!==i.options.parts[t]&&void 0!==i.boxes[t]){if(!i.options.twelveHoursFormat||t>0)for(n=i.options.parts[t][0][0];n<=i.options.parts[t][0][1];n+=i.options.steps[t])i.items[t].push(e('<div data-value="'+n+'" class="periodpicker_'+n+' periodpicker_item">'+(10>n?"0":"")+n+"</div>")),i.indexes[t].push(n);else for(i.items[t].push(e('<div data-value="12" class="periodpicker_12 periodpicker_item">12</div>')),i.indexes[t].push(12),n=1;11>=n;n+=i.options.steps[t])i.items[t].push(e('<div data-value="'+n+'" class="periodpicker_'+n+' periodpicker_item">'+(10>n?"0":"")+n+"</div>")),i.indexes[t].push(n);i.boxes[t].html(i.items[t])};i.boxes[3]&&i.boxes[3].length&&i.boxes[t].find("div").each(function(){i.items[3].push(e(this))})},e.fn.TimePicker=function(t,n,i){var r,s=this;return this.each(function(){var o,d=e(this),_=d.data("timepicker");if(_||"string"!=typeof t)if(_)switch(t){case"stopDrag":_.drag=!1,_.timepicker.find(".draggable").removeClass("draggable"),_.setTime();break;case"regenerate":_.setTime();break;case"destroy":_.destroy();break;case"save":d.val(_.currentime.get());break;case"setValue":_.currentime.set(n,i),_.setTime();break;case"setMin":;case"setMax":r=_.currentime.getTime(),_.options["setMin"===t?"minTime":"maxTime"]=n,_.currentime.validate(),_.setTime(),r!==_.currentime.getTime()&&_.currentime.change();break;case"getValue":s=_.currentime.get()}else o=e.extend(!0,{},e.fn.TimePicker.defaultOptions,t),_=new a(this,o,n),d.data("timepicker",_)}),s},e.fn.timepicker=e.fn.TimePicker,e.fn.TimePicker.defaultOptions={clickAndSelect:!0,dragAndDrop:!0,mouseWheel:!0,inverseMouseWheel:!1,listenKeyPress:!0,saveOnChange:!0,onChange:function(){return!0},twelveHoursFormat:!0,inputFormat:"HH:mm:ss",defaultTime:"00:00:00",minTime:!1,maxTime:!1,hours:!0,minutes:!0,seconds:!1,ampm:!0,parts:[[[0,23]],[[0,59]],[[0,59]],[[0,1]]],steps:[1,1,1,1]},r.prototype.destroy=function(){this.startinput.TimePicker("destroy"),this.picker.remove()},r.prototype.hide=function(){if(this.picker.hasClass("visible")){var t=!0;this.options.onHide&&e.isFunction(this.options.onHide)&&(t=!(this.options.onHide.call(this,this.startinput)===!1)),t&&this.picker.removeClass("visible")}},r.prototype.show=function(){if(!this.picker.hasClass("visible")){var n,i,a=this.startinput.offset();n=a.top+this.startinput.outerHeight()-1,i=a.left,n+this.picker.outerHeight()>e(t).height()+e(t).scrollTop()&&(n=a.top-this.picker.outerHeight()-1),0>n&&(n=0),i+this.picker.outerWidth()>e(t).width()&&(i=e(t).width()-this.picker.outerWidth()),this.picker.css({left:i,top:n}),this.picker.addClass("visible"),this.startinput.TimePicker("regenerate")}},e.fn.TimePickerAlone=function(t,n,i){var a=this;return this.each(function(){var a,s=e(this),o=s.data("timepickeralone");if(o)switch(t){case"destroy":o.destroy();break;default:return o.startinput.TimePicker(t,n,i)}else a=e.extend(!0,{},e.fn.TimePicker.defaultOptions,e.fn.TimePickerAlone.defaultOptions,t),o=new r(this,a),s.data("timepickeralone",o)}),a},e.fn.timepickeralone=e.fn.TimePickerAlone,e.fn.TimePickerAlone.defaultOptions={inline:!1,onHide:function(){return!0}}}(jQuery,window,document),function(e,t,n){"use strict";function i(t,n,a){var r,s=a||new Date;return s.isTW=!0,s.weekdays=function(e){var t,n,i=moment.weekdaysShort();for(t=i.splice(1),t[6]=i[0],i=t,t=i.splice(e-1),n=0;e-1>n;n+=1)t.push(i[n]);return t},s.clone=function(e,t,n,a,r,o){var d=new i(!1,!1,new Date(s.getTime()));return a&&d.setHours(a),r&&d.setMinutes(r),o&&d.setSeconds(o),e&&d.setFullYear(e),t&&d.setMonth(t),n&&d.setDate(n),d},s.inRange=function(e,t){return moment(e).isBetween(t[0],t[1],"day")||moment(e).isSame(t[0],"day")||moment(e).isSame(t[1],"day")},s.isValid=function(){return"[object Date]"!==Object.prototype.toString.call(s)?!1:!isNaN(s.getTime())},s.parseStr=function(t,n){var a;return a="string"==typeof t?moment(t,n):"date"===e.type(t)?new i(0,0,new Date(t.getTime())):t,a&&a.isValid()?s=a.isTW?a:new i(0,0,a.toDate()):null},s.isEqualDate=function(e,t){return e&&e.isValid()&&t&&t.isValid()?e.getDate()===t.getDate()&&e.getMonth()===t.getMonth()&&e.getMonth()===t.getMonth():!1},s.format=function(e){return r=moment(s).format(e),new RegExp("^[0-9]+$").test(r)?parseInt(r,10):r},s.countDaysInMonth=function(){return new Date(s.getFullYear(),s.getMonth()+1,0).getDate()},t&&n&&s.parseStr(t,n),s}function a(t,n){var a,r=this,o=[];r.options=n,r.picker=e('<div unselectable="on" class="period_picker_box xdsoft_noselect" style=""><div class="period_picker_resizer"></div><div class="period_picker_head"><span class="period_picker_head_title"></span><span class="period_picker_max_min" title="'+this.i18n("Open fullscreen")+'"></span><span class="period_picker_close" title="'+this.i18n("Close")+'"></span></div><div class="period_picker_years"><div class="period_picker_years_inner"><div class="period_picker_years_selector"><div class="period_picker_years_selector_container" style="width: 5960px; left: 0px;"></div></div></div></div><div class="period_picker_work"><a href="" class="xdsoft_navigate xdsoft_navigate_prev"></a><div class="period_picker_timepicker_box"><input data-index="0" class="timepicker" type="hidden"></div><div class="period_picker_days"><table><tbody></tbody></table></div><div class="period_picker_timepicker_box"><input  data-index="1"  class="timepicker" type="hidden"></div><a href="" class="xdsoft_navigate xdsoft_navigate_next"></a></div><div class="period_picker_submit_shadow"></div><div class="period_picker_submit_dates"><span class="period_picker_from_time_block period_picker_time"><span class="input_box"><input data-index="0"  class="input_control period_picker_from_time"></span></span><span class="period_picker_from_block period_picker_date"><span class="input_box"><input class="input_control period_picker_from" maxlength="10"></span></span><span class="period_picker_date_separator">&#8212;</span><span class="period_picker_to_block period_picker_date"><span class="input_box"><input class="input_control period_picker_to" maxlength="10"></span></span><span class="period_picker_to_time_block period_picker_time"><span class="input_box"><input data-index="1" class="input_control period_picker_to_time"></span></span><button class="period_picker_show period_picker_ok" role="button" type="button"><span class="button_text">'+this.i18n("OK")+'</span></button><button class="period_picker_show period_picker_today" role="button" type="button"><span class="button_text">'+this.i18n("Today")+'</span></button><button class="period_picker_show period_picker_clear" role="button" type="button"><span class="button_text">'+this.i18n("Clear")+"</span></button></div></div>"),r.pickerdays=r.picker.find(".period_picker_days"),r.calendarbox=r.pickerdays.find("> table > tbody"),r.yearsline=r.picker.find(".period_picker_years_selector_container"),r.yearslineparent=r.picker.find(".period_picker_years_selector"),r.timepicker=r.picker.find(".period_picker_timepicker_box"),r.button=e('<div class="period_picker_input" type="button"><span class="period_button_text"><span class="period_button_content_wrapper"><span class="period_button_content"><span class="icon_calendar"></span><span class="period_button_content_body">'+this.i18n(n.norange?"Choose date":"Choose period")+'</span><span class="icon_clear"></span></span></span></span></div>'),r.startinput=e(n.start?n.start:t),r.endinput=e(n.end),r.startinput.attr("autocomplete","off"),r.endinput.attr("autocomplete","off"),r.periodtime=[[]],r.period=[],r.director=0,a=new i,o[0]=r.startinput.val(),o[1]=r.endinput.val(),r.addRange([a.parseStr(o[0],n.timepicker?n.formatDateTime:n.formatDate)||a.parseStr(o[0],n.formatDate),a.parseStr(o[1],n.timepicker?n.formatDateTime:n.formatDate)||a.parseStr(o[1],n.formatDate)]),r.onAfterShow=[],r.onAfterHide=[],r.onAfterRegenerate=[],r.uniqueid=s,r.currentTimepickerIndex=0,r.timepickerSetLimits=!1,r.timer1=0,r.timer2=0,r.timer3=0,s+=1,r.applyOptions(),r.init(),n.timepicker&&void 0!==e.fn.TimePicker&&r.addRangeTime(a.parseStr(o[0],n.formatDateTime)||a.parseStr(o[0],n.formatDate),a.parseStr(o[1],n.formatDateTime)||a.parseStr(o[1],n.formatDate))}var r,s=0,o=function(e,t){(t||void 0===t)&&e.is(":hidden")?e.each(function(){this.style.display=""}):t||e.hide()};a.prototype.applyOptions=function(){var t,n=this.options,a=this;a.picker.toggleClass("period_picker_maximize",n.fullsize),o(a.picker.find(".period_picker_resizer"),n.resizeButton),o(a.picker.find(".period_picker_head_title").html(a.i18n(n.norange?"Select date":"Select period")),n.title),o(a.picker.find(".period_picker_max_min"),n.fullsizeButton),o(a.picker.find(".period_picker_close"),n.closeButton&&!n.inline),o(a.picker.find(".period_picker_years"),n.yearsLine),o(a.picker.find(".xdsoft_navigate"),n.navigate),o(a.picker.find(".period_picker_timepicker_box").eq(0),n.timepicker&&void 0!==e.fn.TimePicker),o(a.picker.find(".period_picker_timepicker_box").eq(1),n.timepicker&&void 0!==e.fn.TimePicker&&!n.norange),a.picker.find(".period_picker_date,.period_picker_date_separator").css("visibility",n.showDatepickerInputs?"":"hidden"),o(a.picker.find(".period_picker_from_time_block"),n.timepicker&&void 0!==e.fn.TimePicker),a.picker.find(".period_picker_from_time_block").css("visibility",n.showTimepickerInputs?"":"hidden"),o(a.picker.find(".period_picker_to_time_block"),n.timepicker&&void 0!==e.fn.TimePicker&&!a.options.norange),a.picker.find(".period_picker_to_time_block").css("visibility",n.showTimepickerInputs?"":"hidden"),o(a.picker.find(".period_picker_ok"),n.okButton&&!n.inline),o(a.picker.find(".period_picker_today"),n.todayButton),o(a.picker.find(".period_picker_clear"),n.clearButton),o(a.button.find(".period_button_content .icon_clear"),n.clearButtonInButton),n.tabIndex!==!1&&a.button.attr("tabindex",n.tabIndex),!n.withoutBottomPanel&&(n.todayButton||n.clearButton||n.okButton&&!n.inline||n.showDatepickerInputs||n.showTimepickerInputs&&n.timepicker&&void 0!==e.fn.TimePicker)||(a.picker.addClass("without_bottom_panel"),n.withoutBottomPanel=!0,n.someYOffset=0),n.yearsLine||a.picker.addClass("without_yearsline"),n.title||n.fullsizeButton||n.closeButton&&!n.inline||a.picker.addClass("without_header"),n.timepicker&&void 0!==e.fn.TimePicker&&a.picker.addClass("with_first_timepicker"),n.timepicker&&void 0!==e.fn.TimePicker&&!n.norange&&a.picker.addClass("with_second_timepicker"),n.animation&&a.picker.addClass("animation"),n.norange&&a.picker.addClass("xdsoft_norange"),n.inline&&a.picker.addClass("xdsoft_inline"),t=function(t){var i,r=!1;if(void 0!==n[t]&&e.isFunction(n[t])){for(i=0;i<a[t].length;i+=1)if(n[t]===a[t][i]){r=!0;break};r||a[t].push(n[t])}},t("onAfterShow"),t("onAfterHide"),t("onAfterRegenerate"),a.maxdate=n.maxDate?new i(n.maxDate,n.formatDate):!1,a.mindate=n.minDate?new i(n.minDate,n.formatDate):!1,a.monthcount=n.cells[0]*n.cells[1],a.picker.css({width:n.cells[1]*n.monthWidthInPixels+(n.timepicker&&e.fn.TimePicker?87*(n.norange?1:2):0)+50,height:n.cells[0]*n.monthHeightInPixels+n.someYOffset})},a.prototype.returnPeriod=function(){this.picker.find("input.period_picker_from").val(void 0!==this.period?this.period:""),this.picker.find("input.period_picker_to").val(void 0!==this.period[1]?this.period[1]:this.picker.find("input.period_picker_from").val())},a.prototype.moveTimeToDate=function(){this.options.timepicker&&this.periodtime.length&&this.periodtime[0].length&&(null!==this.period[0]&&this.period[0].format&&this.periodtime[0][0].format&&(this.period[0].setSeconds(this.periodtime[0][0].getSeconds()),this.period[0].setMinutes(this.periodtime[0][0].getMinutes()),this.period[0].setHours(this.periodtime[0][0].getHours())),null!==this.periodtime[0][1]&&null!==this.period[1]&&this.period[1].format&&this.periodtime[0][1].format&&(this.period[1].setSeconds(this.periodtime[0][1].getSeconds()),this.period[1].setMinutes(this.periodtime[0][1].getMinutes()),this.period[1].setHours(this.periodtime[0][1].getHours())))},a.prototype.syncTimesInputs=function(){if(this.options.timepicker&&void 0!==e.fn.TimePicker){var t=new i,n=this.timepicker.find("input.timepicker"),a=this.picker.find(".period_picker_submit_dates .period_picker_time input");this.periodtime[0][0]&&(e.fn.TimePicker&&n.eq(0).TimePicker("setValue",this.periodtime[0][0],!0),a.eq(0).is(":focus")||a.eq(0).val(this.periodtime[0][0].format(this.options.timepickerOptions.inputFormat))),!this.options.norange&&this.periodtime[0][1]&&(e.fn.TimePicker&&n.eq(1).TimePicker("setValue",this.periodtime[0][1],!0),a.eq(1).is(":focus")||a.eq(1).val(this.periodtime[0][1].format(this.options.timepickerOptions.inputFormat))),!this.options.norange&&this.options.useTimepickerLimits&&t.isEqualDate(this.period[0],this.period[1])&&(0===this.currentTimepickerIndex?n.eq(1).TimePicker("setMin",n.eq(0).val()).TimePicker("setMin",!1):n.eq(0).TimePicker("setMax",n.eq(1).val()).TimePicker("setMax",!1))}},a.prototype.getInputsValue=function(){var e,t=[];return this.syncTimesInputs(),this.startinput.length&&this.period&&this.period.length&&(this.moveTimeToDate(),e=this.options.timepicker?this.options.formatDateTime:this.options.formatDate,this.period[0]&&this.period[0].format&&t.push(this.period[0].format(e)),this.period[1]&&this.period[1].format&&t.push(this.period[1].format(e))),t},a.prototype.setInputsValue=function(){var e=this.getInputsValue();e.length?(e[0]&&this.startinput.val()!==e[0]&&this.startinput.val(e[0]),e[1]&&this.endinput.val()!==e[1]&&this.endinput.val(e[1])):(this.startinput.val(""),this.endinput.val("")),this.oldStringRange!==e.join("-")&&(this.oldStringRange=e.join("-"),this.startinput.trigger("change"),this.endinput.trigger("change"))},a.prototype.getLabel=function(){var e,t=[];return this.period.length&&(this.moveTimeToDate(),e=this.options.timepicker?[this.options.formatDecoreDateTimeWithYear||this.options.formatDecoreDateTime||this.options.formatDateTime,this.options.formatDecoreDateTimeWithoutMonth||this.options.formatDecoreDateTime||this.options.formatDateTime,this.options.formatDecoreDateTime||this.options.formatDateTime,this.options.formatDateTime]:[this.options.formatDecoreDateWithYear||this.options.formatDecoreDate||this.options.formatDate,this.options.formatDecoreDateWithoutMonth||this.options.formatDecoreDate||this.options.formatDate,this.options.formatDecoreDate||this.options.formatDate,this.options.formatDate],void 0!==this.period[1]&&this.period[1]&&void 0!==this.period[1].format&&this.period[1].format&&this.period[0].format(e[3])!==this.period[1].format(e[3])?(t.push(this.period[0].format(this.period[0].format("YYYY")!==this.period[1].format("YYYY")?e[0]:this.period[0].format("M")!==this.period[1].format("M")?e[2]:e[1])),t.push(this.period[1].format(e[0]))):t.push(this.period[0].format(e[0]))),t},a.prototype.setLabel=function(){var e=this.getLabel();e.length?(1===e.length?this.button.find(".period_button_content_body").html(e[0]):this.button.find(".period_button_content_body").html("<span>"+e[0]+'</span><span class="period_button_dash">&#8212;</span><span>'+e[1]+"</span>"),this.options.clearButtonInButton&&o(this.button.find(".period_button_content .icon_clear"),!0)):(this.button.find(".period_button_content_body").html(this.i18n(this.options.norange?"Choose date":"Choose period")),o(this.button.find(".period_button_content .icon_clear"),!1))},a.prototype.highlightPeriod=function(){var t=this,n=new i;moment.locale(t.options.lang),t.picker.is(":hidden")||(t.picker.find(".period_picker_cell.period_picker_selected").removeClass("period_picker_selected"),t.period.length?(t.picker.find(".period_picker_cell").each(function(){var i=n.parseStr(e(this).data("date"),t.options.formatDate);n.inRange(i,t.period)&&e(this).addClass("period_picker_selected")}),t.picker.find(".period_picker_years_period").css({width:Math.floor(t.options.yearSizeInPixels/365*Math.abs(moment(t.period[1]).diff(t.period[0],"day")))+"px",left:Math.floor(t.options.yearSizeInPixels/365*-moment([t.options.yearsPeriod[0],1,1]).diff(t.period[0],"day"))}),t.picker.find("input.period_picker_from:not(:focus)").val(void 0!==t.period[0]&&t.period[0]?t.period[0].format(t.options.formatDate):""),t.picker.find("input.period_picker_to:not(:focus)").val(void 0!==t.period[1]&&t.period[1]?t.period[1].format(t.options.formatDate):t.picker.find("input.period_picker_from").val()),t.picker.find("input.period_picker_from:not(:focus),input.period_picker_to:not(:focus)").trigger("change")):t.picker.find("input.period_picker_from:not(:focus),input.period_picker_to:not(:focus)").val("")),t.setLabel(),t.setInputsValue()},a.prototype.addRangeTime=function(e,t){var n=new i;this.periodtime[0][0]=n.parseStr(e,this.options.timepickerOptions.inputFormat),this.options.norange?this.periodtime[0][1]=this.periodtime[0][0]:(this.periodtime[0][1]=n.parseStr(t,this.options.timepickerOptions.inputFormat),null===this.periodtime[0][0]&&this.periodtime[0][1]&&(this.periodtime[0][0]=this.periodtime[0][1])),null===this.periodtime[0][0]&&(this.periodtime[0]=[]),this.setLabel(),this.setInputsValue()},a.prototype.addRange=function(t){this.oldStringRange=this.getInputsValue().join("-"),this.currentTimepickerIndex=0;var n,a=new i;if(this.options.norange&&(this.director=0),e.isArray(t))this.period=[a.parseStr(t[0],this.options.formatDate),a.parseStr(t[1],this.options.formatDate)],null===this.period[0]&&(this.period=[]),this.director=0;else{if(void 0===this.period&&(this.period=[]),this.period[this.options.norange?0:this.director]=a.parseStr(t,this.options.formatDate),null===this.period[this.director])return this.period=[],void this.highlightPeriod();this.director||(this.period[1]=this.period[this.director].clone()),this.period[0]>this.period[1]&&(n=this.period[0],this.period[0]=this.period[1],this.period[1]=n),this.director=this.director?0:1}this.options.norange&&this.period[0]&&this.period[1]&&this.period[1]!==this.period[0]&&(this.period[1]=this.period[0].clone()),this.highlightPeriod(),this.options.hideAfterSelect&&this.period[0]&&this.period[1]&&this.period[0]!==this.period[1]&&this.hide(),this.month=this.period.length?this.period[0].getMonth()+1:this.options.startMonth,this.year=this.period.length?this.period[0].getFullYear():this.options.startYear},a.prototype.recalcDraggerPosition=function(){var e=this;clearTimeout(this.timer2),this.timer2=setTimeout(function(){var t=Math.abs(parseInt(e.yearsline.css("left"),10)),n=e.picker.find(".period_picker_years_dragger"),i=parseInt(n.css("left"),10);t>i?e.yearsline.css("left",-i+"px"):i+n.width()>t+e.yearslineparent.width()&&e.yearsline.css("left",-(i+n.width()-e.yearslineparent.width())+"px")},100)},a.prototype.calcDate=function(e,t,n,i){e.setFullYear(t),e.setMonth(n),e.setDate(i)},a.prototype.getRealDateTime=function(){var e=new Date;return this.calcDate(e,this.year,this.month-1,1),[e.getMonth(),e.getFullYear()]},a.prototype.regenerate=function(t){if(this.picker.is(":visible")){var n,i=this,a=parseInt(i.pickerdays.width(),10),r=parseInt(i.picker[0].offsetHeight,10);for(moment.locale(i.options.lang),void 0===t?this.options.cells=[Math.floor((r-i.options.someYOffset)/i.options.monthHeightInPixels)||1,Math.floor(a/i.options.monthWidthInPixels)||1]:(this.options.cells=t,i.picker.css({width:this.options.cells[1]*i.options.monthWidthInPixels+(i.options.timepicker&&e.fn.TimePicker?87*(i.options.norange?1:2):0)+50,height:this.options.cells[0]*i.options.monthHeightInPixels+i.options.someYOffset})),this.options.cells[0]<0&&(this.options.cells[0]=1),i.monthcount=this.options.cells[0]*this.options.cells[1],i.generateCalendars(i.month,i.year),i.generateYearsLine(),i.recalcDraggerPosition(),i.highlightPeriod(),n=0;n<this.onAfterRegenerate.length;n+=1)this.onAfterRegenerate[n].call(this)}},a.prototype.init=function(){var a,s,o,d,_,u,l,m,p,c,f,h,M=this;M.button.on("click keydown",function(e){if("keydown"===e.type)switch(e.which){case 9:return void(M.options.inline||M.hide());case 38:;case 13:break;default:return};return M.button.is("[disabled]")?(e.preventDefault(),!1):void M.toggle()}),M.options.inline||M.startinput.after(M.button),a=M.startinput.offset(),M.picker.find(".period_picker_submit_dates input").on("focus",function(){e(this).parent().parent().addClass("input_focused_yes")}).on("blur",function(){e(this).parent().parent().removeClass("input_focused_yes")}),M.picker.find(".period_picker_submit_dates .period_picker_date input").on("keydown",function(){var t=this;clearTimeout(M.timer3),M.timer3=setTimeout(function(){if(e(t).val()){var n=moment(e(t).val(),M.options.formatDate);if(!n.isValid())return void e(t).parent().parent().addClass("period_picker_error");M.addRange([M.picker.find(".period_picker_submit_dates .period_picker_date input").eq(0).val(),M.picker.find(".period_picker_submit_dates .period_picker_date input").eq(1).val()])}e(t).parent().parent().removeClass("period_picker_error")},200)}),M.options.timepicker&&e.fn.TimePicker&&(h=function(){var t,n=this,a=new i;if(M.currentTimepickerIndex=parseInt(e(this).data("index"),10),e(n).val()){if(t=moment(e(n).val(),M.options.timepickerOptions.inputFormat),!t.isValid())return void e(n).parent().parent().addClass("period_picker_error");if(this.period&&this.period.length&&a.isEqualDate(this.period[0],this.period[1])&&moment(f.eq(0).val(),M.options.timepickerOptions.inputFormat).getDate().getTime()>moment(f.eq(1).val(),M.options.timepickerOptions.inputFormat).getDate().getTime())return void e(n).parent().parent().addClass("period_picker_error");M.addRangeTime(M.picker.find(".period_picker_submit_dates .period_picker_time input").eq(0).val(),M.picker.find(".period_picker_submit_dates .period_picker_time input").eq(1).val())}e(n).parent().parent().removeClass("period_picker_error")},f=M.picker.find(".period_picker_submit_dates .period_picker_time input").on("keydown change",function(e){"keydown"===e.type?(clearTimeout(M.timer3),M.timer3=setTimeout(h.bind(this),300)):h.call(this)})),M.picker.find(".period_picker_max_min").on("click",function(){M.picker.toggleClass("period_picker_maximize"),M.regenerate()}),M.options.fullsizeOnDblClick&&M.picker.find(".period_picker_head").on("dblclick",function(){M.picker.toggleClass("period_picker_maximize"),M.regenerate()}),M.picker.find(".period_picker_close").on("click",function(){M.hide()}),M.options.mousewheel&&(M.picker.on("mousewheel",function(e){return M.month+=(M.options.reverseMouseWheel?-1:1)*e.deltaY,M.regenerate(),!1}),M.options.mousewheelYearsLine&&M.picker.find(".period_picker_years_selector").on("mousewheel",function(e){return M.year+=(M.options.reverseMouseWheel?-1:1)*e.deltaY,M.month=1,M.regenerate(),e.preventDefault(),e.stopPropagation(),!1})),M.options.navigate&&M.picker.find(".xdsoft_navigate").on("click",function(){return M.month+=e(this).hasClass("xdsoft_navigate_prev")?-1:1,M.regenerate(),!1}),M.picker.on("click",".period_picker_show.period_picker_today",function(){if(!M.options.onTodayButtonClick||!e.isFunction(M.options.onTodayButtonClick)||M.options.onTodayButtonClick.call(M)!==!1){var t=new Date;M.year=t.getFullYear(),M.month=t.getMonth()+1,M.regenerate()}}),M.picker.on("click",".period_picker_show.period_picker_ok",function(){M.options.onOkButtonClick&&e.isFunction(M.options.onOkButtonClick)&&M.options.onOkButtonClick.call(M)===!1||M.hide()}),M.options.clearButtonInButton&&M.button.find(".icon_clear").on("mousedown",function(e){return M.clear(),e.preventDefault(),e.stopPropagation(),!1}),M.options.clearButton&&M.picker.on("click",".period_picker_show.period_picker_clear",function(){M.clear()}),M.picker.on("click",".period_picker_years_selector .period_picker_year",function(){M.year=parseInt(e(this).text(),10),M.month=-Math.floor(M.monthcount/2)+1,M.regenerate()}),M.picker.on("mousedown",".period_picker_days td td,.period_picker_month",function(){if(e(this).hasClass("period_picker_month"))M.addRange([e(this).data("datestart"),e(this).data("dateend")]);else if(!e(this).hasClass("period_picker_gray_period")&&!e(this).hasClass("period_picker_empty"))if(e(this).hasClass("period_picker_selector_week")){var t=parseInt(e(this).parent().data("week"),10),n=M.picker.find("tr[data-week="+t+"] > td.period_picker_cell:not(.period_picker_gray_period)"),i=n.eq(-1),a=n.eq(0);i.length&&M.addRange([a.data("date"),i.data("date")])}else 1!==M.picker.find(".period_picker_selected").length?(M.picker.find(".period_picker_selected").removeClass("period_picker_selected"),e(this).addClass("period_picker_selected")):e(this).addClass("period_picker_selected"),M.addRange(e(this).data("date"))}),M.picker.on("mousedown",".period_picker_years_selector_container",function(t){p=e(this),c=!0,s=[t.clientX,t.clientY,parseInt(p.css("left")||0,10)],t.preventDefault()}),M.picker.on("mousedown",".period_picker_years_dragger",function(t){u=e(this),_=!0,s=[t.clientX,t.clientY,parseInt(u.css("left"),10)],t.stopPropagation(),t.preventDefault()}),M.options.draggable&&M.picker.on("mousedown",".period_picker_head",function(e){m=!0,s=[e.clientX,e.clientY,parseInt(M.picker.css("left"),10),parseInt(M.picker.css("top"),10)],e.preventDefault()}),M.picker.on("mouseup",function(t){d=!1,_=!1,m=!1,c=!1,M.options.timepicker&&e.fn.TimePicker&&M.timepicker.find("input.timepicker").TimePicker("stopDrag"),t.stopPropagation()}),M.picker.find(".period_picker_resizer").on("mousedown",function(e){d=!0,s=[e.clientX,e.clientY,parseInt(M.picker.css("width"),10),parseInt(M.picker.css("height"),10)],e.preventDefault()}),M.picker.css({left:M.options.inline?"auto":a.left,top:M.options.inline?"auto":a.top+M.button.height(),width:this.options.cells[1]*M.options.monthWidthInPixels+(M.options.timepicker&&e.fn.TimePicker?87*(M.options.norange?1:2):0)+50,height:this.options.cells[0]*M.options.monthHeightInPixels+M.options.someYOffset}),M.options.noHideSourceInputs||M.options.likeXDSoftDateTimePicker?(M.startinput.add(M.endinput).on("keydown.xdsoftpp mousedown.xdsoftpp",function(){clearTimeout(r),r=setTimeout(function(){var e,t=M.getInputsValue(),n=M.options.timepicker?M.options.formatDateTime:M.options.formatDate;(void 0!==t[0]&&t[0]!==M.startinput.val()||void 0!==t[1]&&M.endinput.length&&t[1]!==M.endinput.val())&&(e=new i,M.addRange([e.parseStr(M.startinput.val(),n),e.parseStr(M.endinput.val(),n)]),M.period[0]&&(M.year=M.period[0].getFullYear(),M.month=M.period[0].getMonth()+1,M.regenerate()))},300)}),M.options.likeXDSoftDateTimePicker&&(M.button.remove(),M.startinput.add(M.endinput).on("open.xdsoftpp focusin.xdsoftpp mousedown.xdsoftpp touchstart.xdsoftpp",function(){var t=this;e(t).is(":disabled")||M.picker.hasClass("visible")||(clearTimeout(r),r=setTimeout(function(){M.show(t)},100))}),M.options.hideOnBlur&&M.startinput.add(M.endinput).on("blur.xdsoftpp",function(){setTimeout(function(){M.picker.find("*:focus").length||M.hide()},200)}))):(M.startinput.hide(),M.endinput.hide()),M.options.inline?(M.startinput.after(M.picker),M.show()):e(n.body).append(M.picker),e(t).on("resize.xdsoftpp"+M.uniqueid,function(){M.regenerate()}).on("keydown.xdsoftpp"+M.uniqueid,function(e){if(M.picker.hasClass("visible"))switch(e.which){case 40:;case 27:M.options.inline||M.hide();break;case 37:;case 39:M.picker.find(".xdsoft_navigate").eq(37===e.which?0:1).trigger("click")}}).on("mouseup.xdsoftpp"+M.uniqueid,function(e){d||_||m||c?(d=!1,_=!1,m=!1,c=!1):M.options.inline||(M.hide(),M.options.likeXDSoftDateTimePicker&&(M.startinput.is(e.target)||M.endinput.is(e.target))&&M.show(e.target))}).on("mousemove.xdsoftpp"+M.uniqueid,function(e){m&&!M.options.inline&&(o=[e.clientX-s[0],e.clientY-s[1]],M.picker.hasClass("xdsoft_i_moved")||M.picker.addClass("xdsoft_i_moved"),M.picker.css({left:s[2]+o[0],top:s[3]+o[1]})),d&&(o=[e.clientX-s[0],e.clientY-s[1]],M.picker.css({width:s[2]+o[0],height:s[3]+o[1]}),M.regenerate()),_&&(o=[e.clientX-s[0],e.clientY-s[1]],l=s[2]+o[0],u.css("left",l),M.calcMonthOffsetFromPeriodDragger(l),M.generateCalendars(M.month,M.year),M.recalcDraggerPosition()),c&&(o=[e.clientX-s[0],e.clientY-s[1]],l=s[2]+o[0],p.css("left",l))}),M.generateTimePicker()},a.prototype.generateTimePicker=function(){var t=this;t.options.timepicker&&void 0!==e.fn.TimePicker&&t.timepicker.each(function(){var n=e(this).find("input.timepicker"),i=parseInt(n.data("index")||0,10);n.length&&!n.data("timepicker")&&void 0!==e.fn.TimePicker&&(i&&t.options.defaultEndTime&&(t.options.timepickerOptions.defaultTime=t.options.defaultEndTime),n.TimePicker(t.options.timepickerOptions,e(this)),t.onAfterRegenerate.push(function(){n.TimePicker("regenerate")}),n.on("change",function(){var e=t.picker.find(".period_picker_submit_dates .period_picker_time input").eq(i);e.is(":focus")||e.val()===this.value||e.val(this.value).trigger("change")}).trigger("change"))})},a.prototype.generateCalendars=function(e,t){function n(){var e,t=[];for(e=0;e<d.length;e+=1)t.push('<th class="'+(-1!==r.options.weekEnds.indexOf(e+r.options.dayOfWeekStart>7?(e+r.options.dayOfWeekStart)%7:e+r.options.dayOfWeekStart)?"period_picker_holiday":"")+'">'+d[e]+"</th>");return t.join("")}moment.locale(this.options.lang);var a,r=this,s=[],o=r.getRealDateTime(),d=(new i).weekdays(r.options.dayOfWeekStart);for(o[1]>r.options.yearsPeriod[1]&&(r.year=r.options.yearsPeriod[1],t=r.year,r.month=12-r.monthcount,e=r.month),o[1]<r.options.yearsPeriod[0]&&(r.year=r.options.yearsPeriod[0],t=r.year,r.month=1,e=r.month),s.push('<tr class="period_picker_first_letters_tr">'),a=0;a<r.options.cells[1];a+=1)s.push('<td class="period_picker_first_letters_td"><table class="period_picker_first_letters_table"><tbody><tr><th class="period_picker_selector_week_cap"><span class="period_picker_selector_week_cap"></span></th>'+n()+"</tr></tbody></table></td>");for(s.push("</tr>"),a=0;a<r.options.cells[0];a+=1)s.push("<tr>"),s.push(r.generateCalendarLine(e+a*r.options.cells[1],t,r.options.cells[1])),s.push("</tr>");r.calendarbox.html(s.join("")),r.highlightPeriod()},a.prototype.i18n=function(e){return void 0!==this.options.i18n[this.options.lang]&&void 0!==this.options.i18n[this.options.lang][e]?this.options.i18n[this.options.lang][e]:e},a.prototype.calcPixelOffsetForPeriodDragger=function(){var e=this.getRealDateTime();return(e[1]-this.options.yearsPeriod[0])*this.options.yearSizeInPixels+e[0]*Math.floor(this.options.yearSizeInPixels/12)},a.prototype.calcMonthOffsetFromPeriodDragger=function(e){this.year=Math.floor(e/this.options.yearSizeInPixels)+this.options.yearsPeriod[0],this.month=Math.floor(e%this.options.yearSizeInPixels/Math.floor(this.options.yearSizeInPixels/12))+1},a.prototype.generateYearsLine=function(){if(this.options.yearsLine){var t,n=[],i=0;if(n.push('<div class="period_picker_years_dragger" title="'+this.i18n("Move to select the desired period")+'" style="left: '+this.calcPixelOffsetForPeriodDragger()+"px; width: "+Math.floor(this.options.yearSizeInPixels/12)*this.monthcount+'px;"></div>'),n.push('<div class="period_picker_years_period" style="display: block; width: 0px; left: 300px;"></div>'),this.options.yearsPeriod&&e.isArray(this.options.yearsPeriod))for(t=this.options.yearsPeriod[0];t<=this.options.yearsPeriod[1];t+=1)n.push('<div class="period_picker_year" style="left:'+i*this.options.yearSizeInPixels+'px">'+t+"</div>"),i+=1;this.yearsline.css("width",i*this.options.yearSizeInPixels+"px"),this.yearsline.html(n.join(""))}},a.prototype.generateCalendarLine=function(e,t,n){var a,r,s,o,d,_,u=[],l=new i,m=(new i).format("DD.MM.YYYY");for(l.setDate(1),l.setFullYear(t),l.setMonth(e-1),a=0;n>a;a+=1){for(d=l.getMonth()+1,o=l.countDaysInMonth(),u.push('<td class="period_picker_month'+l.format("M")+'"><table><tbody>'),u.push('<tr><th class="period_picker_month" data-datestart="'+l.format(this.options.formatDate)+'"  data-dateend="'+l.clone(0,0,o).format(this.options.formatDate)+'" colspan="8" title="'+l.format(this.options.formatMonth)+'">'+l.format(this.options.formatMonth)+"<b>"+l.format("M.YYYY")+"</b></th></tr>"),_=0;l.format("E")!==this.options.dayOfWeekStart&&7>_;)l.setDate(l.getDate()-1),_+=1;for(r=1,_=0;o>=r&&100>_;){for(u.push('<tr data-week="'+l.format("W")+'">'),u.push('<td class="period_picker_selector_week" title="'+this.i18n("Select week #")+" "+l.format("W")+'"><span class="period_picker_selector_week"></span></td>'),s=1;7>=s;s+=1)l.format("M")!==d?u.push('<td class="period_picker_empty">&nbsp;</td>'):((!this.maxdate||l<this.maxdate)&&(!this.mindate||l>this.mindate)&&-1===this.options.disableDays.indexOf(l.format(this.options.formatDate))?(u.push('<td data-date="'+l.format(this.options.formatDate)+'"'),u.push('    class="period_picker_cell '),u.push(-1!==this.options.weekEnds.indexOf(l.format("E"))||-1!==this.options.holidays.indexOf(l.format(this.options.formatDate))?" period_picker_holiday":" period_picker_weekday"),l.format("DD.MM.YYYY")===m&&u.push(" period_picker_cell_today "),u.push((7===s||l.format("D")===o?" period_picker_last_cell":"")+'">'+l.format("D")+"</td>")):u.push('<td class="period_picker_gray_period">'+l.format("D")+"</td>"),r+=1),l.setDate(l.getDate()+1);_+=1,u.push("</tr>")}e+=1,l.setDate(1),l.setFullYear(t),l.setMonth(e-1),u.push("</tbody></table></td>")}return u.join("")},a.prototype.toggle=function(){this.picker.hasClass("active")?this.hide():this.show()},a.prototype.clear=function(){this.addRange(),this.options.onClearButtonClick&&e.isFunction(this.options.onClearButtonClick)&&this.options.onClearButtonClick.call(this),this.options.closeAfterClear&&!this.options.inline&&this.hide()},a.prototype.getPosition=function(n){var i=this.options.likeXDSoftDateTimePicker?e(n).offset():this.button.offset(),a=i.top+(this.options.likeXDSoftDateTimePicker?e(n).outerHeight():this.button.outerHeight())-1,r=i.left;return a+this.picker.outerHeight()>e(t).height()+e(t).scrollTop()&&(a=i.top-this.picker.outerHeight()-1),0>a&&(a=0),r+this.picker.outerWidth()>e(t).width()&&(r=e(t).width()-this.picker.outerWidth()),{left:r,top:a}},a.prototype.show=function(e){var t,n=this;for(n.options.inline||(n.picker.addClass("visible"),setTimeout(function(){n.picker.addClass("active")},100),n.options.fullsize?n.picker.addClass("period_picker_maximize"):n.picker.hasClass("xdsoft_i_moved")||n.picker.css(n.getPosition(e))),this.regenerate(),t=0;t<this.onAfterShow.length;t+=1)this.onAfterShow[t].call(this)},a.prototype.hide=function(){var e,t=this;if(t.picker.hasClass("visible")&&(t.picker.removeClass("active"),t.picker.hasClass("animation")?setTimeout(function(){t.picker.hasClass("active")||t.picker.removeClass("visible")},300):t.picker.removeClass("visible"),void 0!==this.onAfterHide&&this.onAfterHide.length))for(e=0;e<this.onAfterHide.length;e+=1)this.onAfterHide[e].call(this)},a.prototype.destroy=function(){this.picker.remove(),this.button.remove(),this.startinput.off(".xdsoftpp").show().removeData("periodpicker"),this.endinput.off(".xdsoftpp").show(),e(t).off(".xdsoftpp"+this.uniqueid)},e.fn.periodpicker=function(n,r,s){if(void 0===t.moment)throw new Error("PeriodPicker's JavaScript requires MomentJS");var o=this;return this.each(function(){var t,d,_=[],u=e(this),l=u.data("periodpicker");if(l)switch(t=l.options,n){case"picker":o=l;break;case"regenerate":l.regenerate(r);break;case"setOption":l.options[r]=s,l.applyOptions();break;case"setOptions":l.options=e.extend(!0,{},l.options,r),l.applyOptions();break;case"clear":l.addRange();break;case"change":d=new i,_[0]=d.parseStr(l.startinput.val(),t.timepicker?t.formatDateTime:t.formatDate)||d.parseStr(l.startinput.val(),t.formatDate),l.endinput.length&&(_[1]=d.parseStr(l.endinput.val(),t.timepicker?t.formatDateTime:t.formatDate)||d.parseStr(l.endinput.val(),t.formatDate)),l.addRange(_);break;case"destroy":l.destroy();break;case"hide":l.hide();break;case"show":l.show();break;case"value":void 0!==r?(d=new i,e.isArray(r)?(_[0]=d.parseStr(r[0],t.timepicker?t.formatDateTime:t.formatDate)||d.parseStr(r[0],t.formatDate),void 0!==r[1]&&(_[1]=d.parseStr(r[1],t.timepicker?t.formatDateTime:t.formatDate)||d.parseStr(r[1],t.formatDate))):_[0]=d.parseStr(r,t.timepicker?t.formatDateTime:t.formatDate)||d.parseStr(r,t.formatDate),l.addRange(_),t.timepicker&&void 0!==e.fn.TimePicker&&l.addRangeTime(_[0],_[1]||_[0])):o=l.period;break;case"valueStringStrong":o=l.getInputsValue().join("-");break;case"valueString":o=l.getLabel().join("-");break;case"disable":l.button.attr("disabled",!0),l.startinput.add(l.endinput).attr("disabled",!0).attr("readonly",!0);break;case"enable":l.button.removeAttr("disabled"),l.startinput.add(l.endinput).removeAttr("disabled").removeAttr("readonly")}else t=e.extend(!0,{},e.fn.periodpicker.defaultOptions,n),l=new a(this,t),u.data("periodpicker",l)}),o},e.fn.periodpicker.defaultOptions={tabIndex:0,animation:!0,lang:"en",i18n:{en:{"Select week #":"Select week #","Select period":"Select period","Select date":"Select date","Choose period":"Select period","Choose date":"Select date",Clear:"Clear"},ru:{"Move to select the desired period":"Переместите, чтобы выбрать нужный период","Select week #":"Выбрать неделю №","Select period":"Выбрать период","Select date":"Выбрать дату","Open fullscreen":"Открыть на весь экран",Close:"Закрыть",OK:"OK","Choose period":"Выбрать период","Choose date":"Выбрать дату",Clear:"Отчистить"},fr:{"Move to select the desired period":"Déplacer pour sélectionner la période désirée","Select week #":"Sélectionner la semaine #","Select period":"Choisissez une date","Select date":"Sélectionner la date","Open fullscreen":"Ouvrir en plein écran",Close:"Fermer",OK:"OK","Choose period":"Choisir la période","Choose date":"Choisir une date",Clear:"Propre"}},withoutBottomPanel:!1,showTimepickerInputs:!0,showDatepickerInputs:!0,timepicker:!1,useTimepickerLimits:!0,timepickerOptions:{inputFormat:"HH:mm"},defaultEndTime:!1,yearsLine:!0,title:!0,inline:!1,clearButtonInButton:!1,clearButton:!1,closeAfterClear:!0,okButton:!0,todayButton:!1,closeButton:!0,fullsizeButton:!0,resizeButton:!0,navigate:!0,fullsizeOnDblClick:!0,fullsize:!1,draggable:!0,mousewheel:!0,mousewheelYearsLine:!0,reverseMouseWheel:!0,hideAfterSelect:!1,hideOnBlur:!0,norange:!1,formatMonth:"MMMM YYYY",formatDecoreDate:"D MMMM",formatDecoreDateWithYear:"D MMMM YYYY",formatDecoreDateWithoutMonth:"D",formatDecoreDateTimeWithoutMonth:"HH:mm D",formatDecoreDateTime:"HH:mm D MMMM",formatDecoreDateTimeWithYear:"HH:mm D MMMM YYYY",formatDateTime:"HH:mm YYYY/MM/D",formatDate:"YYYY/MM/D",end:"",noHideSourceInputs:!1,likeXDSoftDateTimePicker:!1,startMonth:(new Date).getMonth()+1,startYear:(new Date).getFullYear(),dayOfWeekStart:1,yearSizeInPixels:120,timepickerWidthInPixels:50,monthWidthInPixels:184,monthHeightInPixels:174,someYOffset:150,yearsPeriod:[2e3,(new Date).getFullYear()+20],weekEnds:[6,7],holidays:[],disableDays:[],minDate:!1,maxDate:!1,cells:[1,3],utcOffset:null,onTodayButtonClick:!1,onOkButtonClick:!1,onAfterShow:!1,onAfterHide:!1,onAfterRegenerate:!1},void 0===Array.prototype.indexOf&&(Array.prototype.indexOf=function(e,t){var n,i;for(i=this.length,n=t||0;i>n;n+=1)if(this[n]===e)return n;return-1})}(jQuery,window,document),!function(e,t,n){"use strict";function i(n){var i=new Date,a=0,r=this;return r.onChange=[],r.validate=function(){n.minTime&&(n.minTime instanceof Date||(n.minTime=r.parse(n.minTime)),r.isValid(n.minTime)?(n.minTime=r.cloneTime(n.minTime),i<n.minTime&&(i=r.cloneTime(n.minTime))):n.minTime=!1),n.maxTime&&(n.maxTime instanceof Date||(n.maxTime=r.parse(n.maxTime)),r.isValid(n.maxTime)?(n.maxTime=r.cloneTime(n.maxTime),i>n.maxTime&&(i=r.cloneTime(n.maxTime))):n.maxTime=!1)},r.cloneTime=function(e){var t=new Date;return t.setHours(e.getHours()),t.setMinutes(e.getMinutes()),t.setSeconds(e.getSeconds()),t},r.isValid=function(e){return"[object Date]"!==Object.prototype.toString.call(e)?!1:!isNaN(e.getTime())},r.hours12Format=function(){var e=i.getHours();return 0===e?12:e>0&&13>e?e:e>12&&23>=e?e-12:void 0},r.to12Format=function(e){return 12!==e||a?a&&12>e?e+12:e:0},r.change=function(t){var n;if(r.onChange.length)for(n=0;n<r.onChange.length;n+=1)e.isFunction(r.onChange[n])&&r.onChange[n].call(r,r.get(),i,t)},r.index=function(e,t){var s,o=i.getTime();if(void 0!==t&&null!==t){switch(t=parseInt(t,10),e){case 1:i.setMinutes(t);break;case 2:i.setSeconds(t);break;case 3:s=i.getHours(),a=t,12>s&&t?i.setHours(s+12):s>=12&&!t&&i.setHours(s-12);break;default:i.setHours(n.twelveHoursFormat?r.to12Format(t):t)}a=r.index(3),r.validate(),o!==i.getTime()&&r.change()}switch(e){case 1:return i.getMinutes();case 2:return i.getSeconds();case 3:return a=i.getHours()>=12?1:0;default:return n.twelveHoursFormat?r.hours12Format():i.getHours()}},r.parse=function(e){return void 0!==t.moment?moment(e,n.inputFormat).toDate():Date.parse(e)},r.set=function(e,t){var n=i.getTime(),a=r.isValid(e)?r.cloneTime(e):r.parse(e);r.isValid(a)&&(i=a,n!==i.getTime()&&(r.validate(),r.change(t)))},r.get=function(){return void 0!==t.moment?moment(i).format(n.inputFormat):String(i)},r.getTime=function(){return i.getTime()},r}function a(t,i,a){var r=this;r.box=a||n.body,r.options=i,r.startinput=e(t),r.uniqueid=s,s+=1,r.init()}function r(i,a){var r=this;r.uniqueid=s,s+=1,r.options=a,r.startinput=e(i),r.picker=e('<div class="periodpicker_timepicker_dialog"></div>'),r.startinput.TimePicker(a,r.picker),r.options.inline?(r.picker.addClass("periodpicker_timepicker_inline"),r.startinput.after(r.picker).hide(),r.startinput.TimePicker("regenerate")):(e(n.body).append(r.picker),r.startinput.on("focus.xdsoft"+r.uniqueid,function(){r.show()}),e(t).on("mousedown.xdsoft"+r.uniqueid,function(){r.hide()}))}var s=1;a.prototype.getRealOffset=function(e){var t=this.getIndex(e);return-1!==this.indexes[e].indexOf(t)?this.indexes[e].indexOf(t)*this.itemHeight():0},a.prototype.getIndex=function(e){return Math.floor(this.currentime.index(e)/this.options.steps[e])*this.options.steps[e]},a.prototype.height=function(){return this.timepicker?parseInt(this.timepicker.get(0).offsetHeight,10):0},a.prototype.itemHeight=function(){return this.items[0][0]?parseInt(this.items[0][0].get(0).offsetHeight,10):22},a.prototype.highlight=function(){var e,t;for(void 0===this.last&&(this.last=[]),e=0;e<this.boxes.length;e+=1)t=this.getIndex(e),void 0!==this.items[e][this.indexes[e].indexOf(t)]&&this.items[e][this.indexes[e].indexOf(t)].addClass("active"),void 0!==this.last[e]&&this.last[e]!==this.indexes[e].indexOf(t)&&void 0!==this.items[e][this.last[e]]&&this.items[e][this.last[e]].removeClass("active"),this.last[e]=this.indexes[e].indexOf(t)},a.prototype.setTime=function(e){var t,n;if(void 0!==e&&e&&e.length)for(n=this.boxes.length-1;n>=0;n-=1)this.currentime.index(n,e[n]);for(n=0;n<this.boxes.length;n+=1)void 0!==this.boxes[n]&&(t=-this.getRealOffset(n)+Math.ceil(this.height()-this.itemHeight())/2,this.boxes[n].css("margin-top",t+"px"));this.highlight()},a.prototype.xy=function(e){var t,n={x:0,y:0};return"touchstart"===e.type||"touchmove"===e.type||"touchend"===e.type||"touchcancel"===e.type?(t=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0],n.x=t.clientX,n.y=t.clientY):("mousedown"===e.type||"mouseup"===e.type||"mousemove"===e.type||"mouseover"===e.type||"mouseout"===e.type||"mouseenter"===e.type||"mouseleave"===e.type)&&(n.x=e.clientX,n.y=e.clientY),n},a.prototype.init=function(){var n,a,r,s=this;s.timepicker=e('<div class="periodpicker_timepicker xdsoft_noselect"><div class="periodpicker_timepicker_sliders">'+(s.options.hours?'<div data-index="0" class="periodpicker_hourspicker_box"><div class="periodpicker_hourspicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.minutes?'<div data-index="1" class="periodpicker_minutespicker_box"><div class="periodpicker_minutespicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.seconds?'<div data-index="2" class="periodpicker_secondspicker_box"><div class="periodpicker_secondspicker"></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+(s.options.ampm?'<div data-index="3" class="periodpicker_ampmpicker_box"><div class="periodpicker_ampmpicker"><div data-value="0" class="periodpicker_0 periodpicker_item">AM</div><div data-value="1" class="periodpicker_1 periodpicker_item">PM</div></div><input class="periodpicker_key_hooker" readonly="true" type="text"/></div>':"")+'</div><div class="periodpicker_timepicker_center"></div></div>'),s.currentime=new i(s.options),s.startinput.length&&s.startinput.val()?s.currentime.set(s.startinput.val()):(s.startinput.val(s.options.defaultTime),s.currentime.set(s.options.defaultTime)),s.options.onChange&&s.currentime.onChange.push(s.options.onChange),s.options.saveOnChange&&s.currentime.onChange.push(function(e,t,n){var i=s.startinput.val();s.startinput.val(e),e===i||n||s.startinput.trigger("change")}),s.boxes={},r=0,s.timepicker.find(".periodpicker_timepicker_sliders>div>div").each(function(){r=Math.max(r,parseInt(e(this).parent().data("index"),10)),s.boxes[parseInt(e(this).parent().data("index"),10)]=e(this)}),s.boxes.length=r+1,s.timepicker.find(".periodpicker_timepicker_sliders>div").addClass("periodpicker_col"+s.timepicker.find(".periodpicker_timepicker_sliders>div>div").length),s.timer2=0,s.timepicker.on("mousewheel",function(e){s.options.mouseWheel&&(e.preventDefault(),e.stopPropagation())}),s.timepicker.find(".periodpicker_timepicker_sliders>div").on("mousewheel",function(t){if(s.options.mouseWheel){var n=e(this),i=[null,null,null,null],a=parseInt(e(this).data("index"),10);n.addClass("draggable"),3>a?i[a]=s.currentime.index(a)+-t.deltaY*(s.options.inverseMouseWheel?-1:1)*s.options.steps[a]:i[a]=s.currentime.index(a)-1,s.setTime(i),clearTimeout(s.timer2),s.timer2=setTimeout(function(){n.removeClass("draggable")},300),t.preventDefault(),t.stopPropagation()}}),s.timepicker.find(".periodpicker_timepicker_sliders").on("click",".periodpicker_item",function(){if(s.options.clickAndSelect){var t=parseInt(e(this).data("value"),10),n=[null,null,null,null],i=parseInt(e(this).parent().parent().data("index"),10);s.iwasdragged||isNaN(t)||(n[i]=t,s.setTime(n))}}),s.timer=0,s.timepicker.find(".periodpicker_timepicker_sliders>div input.periodpicker_key_hooker").on("keydown",function(t){if(s.options.listenKeyPress){var n=[null,null,null,null],i=e(this),a=parseInt(i.parent().data("index"),10),r=!1;switch(t.keyCode){case 38:n[a]=s.currentime.index(a)-s.options.steps[a],s.setTime(n),r=!0;break;case 39:e(this).parent().next().length&&e(this).parent().next().find("input.periodpicker_key_hooker").eq(0).focus(),r=!0;break;case 37:e(this).parent().prev().length&&e(this).parent().prev().find("input.periodpicker_key_hooker").eq(0).focus(),r=!0;break;case 40:n[a]=s.currentime.index(a)+s.options.steps[a],s.setTime(n),r=!0;break;default:/[0-9amp]/i.test(String.fromCharCode(t.keyCode))&&(i.val(i.val()+String.fromCharCode(t.keyCode)),r=!0),clearTimeout(s.timer),s.timer=setTimeout(function(){var e=i.val();i.val(""),3===a&&e.length&&(e="p"===e.toLowerCase().substr(0,1)?1:0),e=parseInt(e,10),isNaN(e)||(n[a]=e,s.setTime(n))},300)}r&&(t.preventDefault(),t.stopImmediatePropagation())}}),s.timepicker.find(".periodpicker_timepicker_sliders>div").on("mousedown.xdsoft touchstart.xdsoft",function(t){s.options.dragAndDrop&&(s.drag=!0,n=[s.xy(t).x,s.xy(t).y],n[4]=parseInt(e(this).data("index"),10),n[3]=s.boxes[n[4]],n[2]=parseInt(n[3].css("margin-top"),10),n[3].find("div").removeClass("active"),n[3].parent().addClass("draggable"),s.iwasdragged=!1,t.preventDefault(),t.stopImmediatePropagation()),e(this).find("input.periodpicker_key_hooker").focus()}),s.iwasdragged=!1,e(t).on("mouseup.xdsoft"+s.uniqueid+" touchend.xdsoft"+s.uniqueid,function(e){s.options.dragAndDrop&&s.drag&&(s.drag=!1,s.setTime(),n[3].parent().removeClass("draggable"),e.stopImmediatePropagation())}).on("mousemove.xdsoft"+s.uniqueid+" touchmove.xdsoft"+s.uniqueid,function(e){if(s.drag&&s.options.dragAndDrop){a=[s.xy(e).x-n[0],s.xy(e).y-n[1]],n[3].css({marginTop:n[2]+a[1]}),a[1]>10&&(s.iwasdragged=!0);var t=-Math.round((-(s.height()-s.itemHeight())/2+n[2]+a[1])/s.itemHeight());0>t&&(t=0),t>=s.items[n[4]].length&&(t=s.items[n[4]].length-1),t=parseInt(s.items[n[4]][t].data("value"),10),s.currentime.index(n[4],t),s.highlight(),e.preventDefault()}}),e(s.box).append(s.timepicker),s.generateTimepicker(),s.setTime()},a.prototype.destroy=function(){var n=this;e(t).off("mouseup.xdsoft"+n.uniqueid+" touchend.xdsoft"+n.uniqueid).off("mousemove.xdsoft"+n.uniqueid+" touchmove.xdsoft"+n.uniqueid),n.timepicker.remove(),delete n.timepicker,delete n.boxes,delete n.currentime},a.prototype.generateTimepicker=function(){var t,n,i=this;for(i.items=[[],[],[],[]],i.indexes=[[],[],[],[0,1]],t=0;2>=t;t+=1)if(void 0!==i.options.parts[t]&&void 0!==i.boxes[t]){if(!i.options.twelveHoursFormat||t>0)for(n=i.options.parts[t][0][0];n<=i.options.parts[t][0][1];n+=i.options.steps[t])i.items[t].push(e('<div data-value="'+n+'" class="periodpicker_'+n+' periodpicker_item">'+(10>n?"0":"")+n+"</div>")),i.indexes[t].push(n);else for(i.items[t].push(e('<div data-value="12" class="periodpicker_12 periodpicker_item">12</div>')),i.indexes[t].push(12),n=1;11>=n;n+=i.options.steps[t])i.items[t].push(e('<div data-value="'+n+'" class="periodpicker_'+n+' periodpicker_item">'+(10>n?"0":"")+n+"</div>")),i.indexes[t].push(n);i.boxes[t].html(i.items[t])};i.boxes[3]&&i.boxes[3].length&&i.boxes[t].find("div").each(function(){i.items[3].push(e(this))})},e.fn.TimePicker=function(t,n,i){var r,s=this;return this.each(function(){var o,d=e(this),_=d.data("timepicker");if(_||"string"!=typeof t)if(_)switch(t){case"stopDrag":_.drag=!1,_.timepicker.find(".draggable").removeClass("draggable"),_.setTime();break;case"regenerate":_.setTime();break;case"destroy":_.destroy();break;case"save":d.val(_.currentime.get());break;case"setValue":_.currentime.set(n,i),_.setTime();break;case"setMin":;case"setMax":r=_.currentime.getTime(),_.options["setMin"===t?"minTime":"maxTime"]=n,_.currentime.validate(),_.setTime(),r!==_.currentime.getTime()&&_.currentime.change();break;case"getValue":s=_.currentime.get()}else o=e.extend(!0,{},e.fn.TimePicker.defaultOptions,t),_=new a(this,o,n),d.data("timepicker",_)}),s},e.fn.timepicker=e.fn.TimePicker,e.fn.TimePicker.defaultOptions={clickAndSelect:!0,dragAndDrop:!0,mouseWheel:!0,inverseMouseWheel:!1,listenKeyPress:!0,saveOnChange:!0,onChange:function(){return!0},twelveHoursFormat:!0,inputFormat:"HH:mm:ss",defaultTime:"00:00:00",minTime:!1,maxTime:!1,hours:!0,minutes:!0,seconds:!1,ampm:!0,parts:[[[0,23]],[[0,59]],[[0,59]],[[0,1]]],steps:[1,1,1,1]},r.prototype.destroy=function(){this.startinput.TimePicker("destroy"),this.picker.remove()},r.prototype.hide=function(){if(this.picker.hasClass("visible")){var t=!0;this.options.onHide&&e.isFunction(this.options.onHide)&&(t=!(this.options.onHide.call(this,this.startinput)===!1)),t&&this.picker.removeClass("visible")}},r.prototype.show=function(){if(!this.picker.hasClass("visible")){var n,i,a=this.startinput.offset();n=a.top+this.startinput.outerHeight()-1,i=a.left,n+this.picker.outerHeight()>e(t).height()+e(t).scrollTop()&&(n=a.top-this.picker.outerHeight()-1),0>n&&(n=0),i+this.picker.outerWidth()>e(t).width()&&(i=e(t).width()-this.picker.outerWidth()),this.picker.css({left:i,top:n}),this.picker.addClass("visible"),this.startinput.TimePicker("regenerate")}},e.fn.TimePickerAlone=function(t,n,i){var a=this;return this.each(function(){var a,s=e(this),o=s.data("timepickeralone");if(o)switch(t){case"destroy":o.destroy();break;default:return o.startinput.TimePicker(t,n,i)}else a=e.extend(!0,{},e.fn.TimePicker.defaultOptions,e.fn.TimePickerAlone.defaultOptions,t),o=new r(this,a),s.data("timepickeralone",o)}),a},e.fn.timepickeralone=e.fn.TimePickerAlone,e.fn.TimePickerAlone.defaultOptions={inline:!1,onHide:function(){return!0}}}(jQuery,window,document),jQuery(function(e){"use strict";var t=jQuery("#mdp-assignInput");function n(){var e='';try{var n=jQuery(t).val();n=n.replace(/\|/g,'"');e=JSON.parse(n);var i=e.matchingMethod;jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-button").removeClass("mdp-active");i==0&&jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-all").addClass("mdp-active");i==1&&jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-any").addClass("mdp-active");var a=e.WPContent,r=e.WPContentVal+'';jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-button").removeClass("mdp-active");a==0&&jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-ignore").addClass("mdp-active");a==1&&jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-include").addClass("mdp-active");a==2&&jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-exclude").addClass("mdp-active");var s=r.split(",");r!=''&&jQuery("#mdp-assign-box .mdp-wp-content select.wp-content").val(s).trigger("chosen:updated");var o=e.homePage;jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-button").removeClass("mdp-active");o==0&&jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-ignore").addClass("mdp-active");o==1&&jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-include").addClass("mdp-active");o==2&&jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-exclude").addClass("mdp-active");var d=e.menuItems,_=e.menuItemsVal+'';jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-button").removeClass("mdp-active");d==0&&jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-ignore").addClass("mdp-active");d==1&&jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-include").addClass("mdp-active");d==2&&jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-exclude").addClass("mdp-active");var u=_.split(",");_!=''&&jQuery("#mdp-assign-box .mdp-menu-items select.menuitems").val(u).trigger("chosen:updated");var l=e.dateTime,m=e.dateTimeStart,p=e.dateTimeEnd;jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-button').removeClass('mdp-active');l==0&&jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-ignore').addClass('mdp-active');l==1&&jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-include').addClass('mdp-active');l==2&&jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-exclude').addClass('mdp-active');jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-start').val(m);jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-end').val(p);var c=e.userRoles,f=e.userRolesVal+'';jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-button").removeClass("mdp-active");c==0&&jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-ignore").addClass("mdp-active");c==1&&jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-include").addClass("mdp-active");c==2&&jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-exclude").addClass("mdp-active");var h=f.split(",");f!=''&&jQuery("#mdp-assign-box .mdp-user-roles select.user-roles").val(h).trigger("chosen:updated");var M=e.URL,Y=e.URLVal;jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-button").removeClass("mdp-active");M==0&&jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-ignore").addClass("mdp-active");M==1&&jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-include").addClass("mdp-active");M==2&&jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-exclude").addClass("mdp-active");jQuery("#mdp-assign-box .mdp-url textarea.mdp-url-field").val(Y);var g=e.devices,b=e.devicesVal+'';jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-button').removeClass('mdp-active');g==0&&jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-ignore').addClass('mdp-active');g==1&&jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-include').addClass('mdp-active');g==2&&jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-exclude').addClass('mdp-active');var k=b.split(',');b!=''&&jQuery('#mdp-assign-box .mdp-devices select.devices').val(k).trigger('chosen:updated');var v=e.PHP,D=e.PHPVal;jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-button').removeClass('mdp-active');v==0&&jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-ignore').addClass('mdp-active');v==1&&jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-include').addClass('mdp-active');v==2&&jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-exclude').addClass('mdp-active');jQuery('#mdp-assign-box .mdp-php textarea.mdp-php-field').val(D)}catch(e){jQuery("#mdp-assign-box .mdp-button-group .mdp-button").removeClass("mdp-active"),jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-all").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-ignore").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-wp-content select.wp-content").val("").trigger("chosen:updated"),jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-ignore").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-ignore").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-menu-items select.menuitems").val("").trigger("chosen:updated"),jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-ignore').addClass('mdp-active'),jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-start').val(''),jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-end').val(''),jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-ignore").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-user-roles select.user-roles").val("").trigger("chosen:updated"),jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-ignore").addClass("mdp-active"),jQuery("#mdp-assign-box .mdp-url textarea.mdp-url-field").val(""),jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-ignore').addClass('mdp-active'),jQuery('#mdp-assign-box .mdp-devices select.devices').val('').trigger('chosen:updated'),jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-ignore').addClass('mdp-active'),jQuery('#mdp-assign-box .mdp-php textarea.mdp-php-field').val('')}}function i(){var e=0;jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-all").hasClass("mdp-active")&&(e=0);jQuery("#mdp-assign-box .mdp-matching-method .mdp-button-group .mdp-any").hasClass("mdp-active")&&(e=1);var n=0;jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-ignore").hasClass("mdp-active")&&(n=0);jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-include").hasClass("mdp-active")&&(n=1);jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-exclude").hasClass("mdp-active")&&(n=2);var i='';n&&(i=jQuery("#mdp-assign-box .mdp-wp-content select.wp-content").val());var a=0;jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-ignore").hasClass("mdp-active")&&(a=0);jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-include").hasClass("mdp-active")&&(a=1);jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-exclude").hasClass("mdp-active")&&(a=2);var r=0;jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-ignore").hasClass("mdp-active")&&(r=0);jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-include").hasClass("mdp-active")&&(r=1);jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-exclude").hasClass("mdp-active")&&(r=2);var s='';r&&(s=jQuery("#mdp-assign-box .mdp-menu-items select.menuitems").val());var o=0;jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-ignore').hasClass('mdp-active')&&(o=0);jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-include').hasClass('mdp-active')&&(o=1);jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-exclude').hasClass('mdp-active')&&(o=2);var d='',_='';o&&(d=jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-start').val(),_=jQuery('#mdp-assign-box .mdp-date-time input.mdp-period-picker-end').val());var u=0;jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-ignore").hasClass("mdp-active")&&(u=0);jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-include").hasClass("mdp-active")&&(u=1);jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-exclude").hasClass("mdp-active")&&(u=2);var l='';u&&(l=jQuery("#mdp-assign-box .mdp-user-roles select.user-roles").val());var m=0;jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-ignore").hasClass("mdp-active")&&(m=0);jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-include").hasClass("mdp-active")&&(m=1);jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-exclude").hasClass("mdp-active")&&(m=2);var p='';m&&(p=jQuery("#mdp-assign-box .mdp-url textarea.mdp-url-field").val());var c=0;jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-ignore').hasClass('mdp-active')&&(c=0);jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-include').hasClass('mdp-active')&&(c=1);jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-exclude').hasClass('mdp-active')&&(c=2);var f='';c&&(f=jQuery('#mdp-assign-box .mdp-devices select.devices').val());var h=0;jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-ignore').hasClass('mdp-active')&&(h=0);jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-include').hasClass('mdp-active')&&(h=1);jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-exclude').hasClass('mdp-active')&&(h=2);var M='';h&&(M=jQuery('#mdp-assign-box .mdp-php textarea.mdp-php-field').val());var Y={matchingMethod:e,WPContent:n,WPContentVal:i,homePage:a,menuItems:r,menuItemsVal:s,dateTime:o,dateTimeStart:d,dateTimeEnd:_,userRoles:u,userRolesVal:l,URL:m,URLVal:p,devices:c,devicesVal:f,PHP:h,PHPVal:M},g=JSON.stringify(Y);g=g.replace(/\"/g,'|');t.val(g);t.change()}function a(){jQuery('#mdp-assign-box .mdp-date-time .mdp-period-picker-start').periodpicker({end:'#mdp-period-picker-end',todayButton:!0,formatDate:'D.MM.YYYY',timepicker:!0,timepickerOptions:{twelveHoursFormat:!1,hours:!0,minutes:!0,seconds:!1,ampm:!1}});jQuery("#mdp-assign-box select.chosen-select").chosen({width:'100%',search_contains:!0,disable_search_threshold:7,inherit_select_classes:!0,no_results_text:"Oops, nothing found"});jQuery('#mdp-assign-box .mdp-button.mdp-active').click()}jQuery("#mdp-assign-box .mdp-matchingMethod .mdp-button").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-matchingMethod button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");i()});jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-ignore").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-menu-items button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-menu-items .mdp-menuitems-selection").hide(200);jQuery(this).closest(".mdp-menu-items").removeClass("mdp-red mdp-green");i()});jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-include").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-menu-items button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-menu-items .mdp-menuitems-selection").show(200);jQuery(this).closest(".mdp-menu-items").removeClass("mdp-red").addClass("mdp-green");i()});jQuery("#mdp-assign-box .mdp-menu-items .mdp-button-group .mdp-exclude").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-menu-items button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-menu-items .mdp-menuitems-selection").show(200);jQuery(this).closest(".mdp-menu-items").removeClass("mdp-green").addClass("mdp-red");i()});jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-ignore').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-date-time button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-date-time').removeClass('mdp-green mdp-red');jQuery('#mdp-assign-box .mdp-date-time .mdp-period-picker-box').hide(200);i()});jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-include').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-date-time button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-date-time').removeClass('mdp-red').addClass('mdp-green');jQuery('#mdp-assign-box .mdp-date-time .mdp-period-picker-box').show(200);i()});jQuery('#mdp-assign-box .mdp-date-time .mdp-button-group .mdp-exclude').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-date-time button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-date-time').removeClass('mdp-green').addClass('mdp-red');jQuery('#mdp-assign-box .mdp-date-time .mdp-period-picker-box').show(200);i()});jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-ignore").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-user-roles button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-user-roles .user-roles-box").hide(200);jQuery(this).closest(".mdp-user-roles").removeClass("mdp-red mdp-green");i()});jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-include").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-user-roles button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-user-roles .user-roles-box").show(200);jQuery(this).closest(".mdp-user-roles").removeClass("mdp-red").addClass("mdp-green");i()});jQuery("#mdp-assign-box .mdp-user-roles .mdp-button-group .mdp-exclude").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-user-roles button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery("#mdp-assign-box .mdp-user-roles .user-roles-box").show(200);jQuery(this).closest(".mdp-user-roles").removeClass("mdp-green").addClass("mdp-red");i()});jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-ignore").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-home-page").removeClass("mdp-green mdp-red");i()});jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-include").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-home-page").removeClass("mdp-red").addClass("mdp-green");i()});jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group .mdp-exclude").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-home-page .mdp-button-group button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-home-page").removeClass("mdp-green").addClass("mdp-red");i()});jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-ignore").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-url button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-url").removeClass("mdp-green mdp-red");jQuery("#mdp-assign-box .mdp-url .mdp-url-box").hide(200);i()});jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-include").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-url button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-url").removeClass("mdp-red").addClass("mdp-green");jQuery("#mdp-assign-box .mdp-url .mdp-url-box").show(200);i()});jQuery("#mdp-assign-box .mdp-url .mdp-button-group .mdp-exclude").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-url button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-url").removeClass("mdp-green").addClass("mdp-red");jQuery("#mdp-assign-box .mdp-url .mdp-url-box").show(200);i()});jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-ignore").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-wp-content button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-wp-content").removeClass("mdp-green mdp-red");jQuery("#mdp-assign-box .mdp-wp-content .mdp-wp-content-box").hide(200);i()});jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-include").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-wp-content button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-wp-content").removeClass("mdp-red").addClass("mdp-green");jQuery("#mdp-assign-box .mdp-wp-content .mdp-wp-content-box").show(200);i()});jQuery("#mdp-assign-box .mdp-wp-content .mdp-button-group .mdp-exclude").on('click',function(e){e.preventDefault();jQuery("#mdp-assign-box .mdp-wp-content button").removeClass("mdp-active");jQuery(this).addClass("mdp-active");jQuery(this).closest(".mdp-wp-content").removeClass("mdp-green").addClass("mdp-red");jQuery("#mdp-assign-box .mdp-wp-content .mdp-wp-content-box").show(200);i()});jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-ignore').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-devices button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery('#mdp-assign-box .mdp-devices .mdp-devices-box').hide(200);jQuery(this).closest('.mdp-devices').removeClass('mdp-red mdp-green');i()});jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-include').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-devices button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery('#mdp-assign-box .mdp-devices .mdp-devices-box').show(200);jQuery(this).closest('.mdp-devices').removeClass('mdp-red').addClass('mdp-green');i()});jQuery('#mdp-assign-box .mdp-devices .mdp-button-group .mdp-exclude').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-devices button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery('#mdp-assign-box .mdp-devices .mdp-devices-box').show(200);jQuery(this).closest('.mdp-devices').removeClass('mdp-green').addClass('mdp-red');i()});jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-ignore').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-php button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-php').removeClass('mdp-green mdp-red');jQuery('#mdp-assign-box .mdp-php .mdp-php-box').hide(200);i()});jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-include').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-php button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-php').removeClass('mdp-red').addClass('mdp-green');jQuery('#mdp-assign-box .mdp-php .mdp-php-box').show(200);i()});jQuery('#mdp-assign-box .mdp-php .mdp-button-group .mdp-exclude').on('click',function(e){e.preventDefault();jQuery('#mdp-assign-box .mdp-php button').removeClass('mdp-active');jQuery(this).addClass('mdp-active');jQuery(this).closest('.mdp-php').removeClass('mdp-green').addClass('mdp-red');jQuery('#mdp-assign-box .mdp-php .mdp-php-box').show(200);i()});jQuery("select.wp-content, select.menuitems, .mdp-period-picker-start,  .mdp-period-picker-end,  select.user-roles,  textarea.mdp-url-field,  select.devices,  textarea.mdp-php-field").on('input propertychange',function(){i()});jQuery(document).ready(function(){var e=!1;jQuery(':input').on('change',function(){e=!0});window.addEventListener('beforeunload',t=>{e&&(t.returnValue='Are you sure you want to leave?')});var t;jQuery('#mdp-php-field').length&&(t=wp.codeEditor.initialize('mdp-php-field'));jQuery('#submit').on('click',function(n){t&&(t.codemirror.save(),i());e=!1});n();a();e=!1})})