<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  mod_surveyform
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ROOT . '/components/com_communitysurveys/router.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/constants.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/route.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/query.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/helper.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/pagination.php';
require_once __DIR__ . '/helper.php';

////////////////////////////////////////// CjLib Includes ///////////////////////////////////////////////
require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
CJLib::import('corejoomla.framework.core');
////////////////////////////////////////// CjLib Includes ///////////////////////////////////////////////

JHtml::_('bootstrap.framework');
JHtml::_('behavior.caption');
JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

// Load language
$language = JFactory::getLanguage();
$language->load('com_communitysurveys', JPATH_ADMINISTRATOR);
$language->load('com_communitysurveys');

// Initialize module parameters.
$surveyId 		= $params->get('survey_id', 0);
$displayTitle 	= $params->get('display_title', 1);
$data 			= SurveyFormHelper::getSurveyData($params);
$appParams		= JComponentHelper::getParams('com_communitysurveys');
$loadCss 		= $appParams->get('load_bootstrap_css', false);
$custom_tag 	= $appParams->get('custom_tag', true);

if($data)
{
	$data->item->params->set('show_title', $displayTitle);
}

CjLib::behavior('bootstrap', array('loadcss' => $loadCss));
if($appParams->get('ui_layout', 'default') == 'default')
{
	CJLib::behavior('bscore', array('customtag'=>$custom_tag));
}

$document = JFactory::getDocument();

JHtml::_('jquery.ui', array('core', 'sortable'));
CjScript::_('form', array('custom_tag'=>$custom_tag));
CjScript::_('validate', array('custom_tag'=>$custom_tag));
CjScript::_('blockui', array('custom_tag'=>$custom_tag));
CjScript::_('datetime', array('custom'=>$custom_tag, 'version' => CS_MAJOR_VERSION < 4 ? 3 : 4));
CjScript::_('signaturepad', array('custom'=>$custom_tag));
CjScript::_('slider', array('custom'=>$custom_tag));
CjScript::_('noty', array('custom'=>$custom_tag));
CjScript::_('raty', array('custom'=>$custom_tag));

CJFunctions::add_script(JUri::base(true).'/media/system/js/core.js', $custom_tag);
CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.plugin.min.js', $custom_tag);
CJFunctions::add_script(JUri::base(true).'/media/com_cjlib/jquery/json2.js', $custom_tag);
CJFunctions::add_script(JUri::base(true).'/media/com_communitysurveys/js/jquery.ui.touch-punch.min.js', $custom_tag);
CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/cj.surveys.min.js', $custom_tag);
CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/cj.surveys.min.css', $custom_tag);

if($appParams->get('enable_captcha', 0))
{
	JPluginHelper::importPlugin('captcha');
	JFactory::getApplication()->triggerEvent('onInit', array('cjsurvey_captcha'));
}

// trigger cron
CJFunctions::send_messages_from_queue();

// Get Smart Search query object.
require JModuleHelper::getLayoutPath('mod_surveyform', $params->get('layout', 'default'));
