var CjSurveyAdminFactory = {};

(function($){
	CjSurveyAdminFactory.init = function(){
		$('.tooltip-hover').tooltip();
		//$(".collapse").collapse();

		$('div.btn-group[data-toggle-name]').each(function(){
			var group   = $(this);
		    var field   = group.closest('.controls');
		    var name    = group.attr('data-toggle-name');
		    var hidden  = field.find('input[name="' + name + '"]');
		    
		    $('button', group).each(function(){
		    	var button = $(this);
		    	button.live('click', function(){
		    		hidden.val($(this).val());
		    		group.find('button').attr('class', 'btn');
		    		$(this).addClass($(this).attr('data-toggle-class'));
		    	});

		    	if(button.val() == hidden.val()) {
		    		button.addClass($(this).attr('data-toggle-class'));
		    	}
		    });
		});
		
		$('body').on('mouseover', '.tooltip-hover', function(){$(this).tooltip('show');});
	};
	
	CjSurveyAdminFactory.init_surveys = function(){
		$('.btn-publish').click(function(event){
			event.preventDefault();
			var button = $(this).addClass('btn-progress');
			$.ajax({
				url: (button.hasClass('btn-success') ? $('#url-unpublish-survey').text() : $('#url-publish-survey').text()),
				dataType: 'json',
				data: {'cid': button.parent().find('input').val()},
				success: function(data, status, xhr, form){
					if(typeof data.error != 'undefined' && data.error.length > 0){
						$('#message-modal').find('.modal-body').html(data.error);
						$('#message-modal').modal('show');
					}else{
						button.toggleClass('btn-success').toggleClass('btn-danger');
						button.find('i').toggleClass('icon-ok').toggleClass('icon-remove');
					}
					button.removeClass('btn-progress');
				}
			});
			return false;
		});
		
		$('.btn-reset').click(function(){
			$(this).closest('.input-append').find('input[type="text"]').val('');
			$(this).closest('form').submit();
		});
	};
})(jQuery);

jQuery(document).ready(function($){
	CjSurveyAdminFactory.init();
	var pageid = $('#cjsurvey_page_id').val();
	if(pageid == 'surveys') CjSurveyAdminFactory.init_surveys();
});

(function() {
	"use strict";
	window.jSelectSurvey = function (id, title, catid, object, link, lang) {
		var hreflang = '', editor, tag;

		if (!Joomla.getOptions('xtd-surveys')) {
			// Something went wrong!
			window.parent.jModalClose();
			return false;
		}

		editor = Joomla.getOptions('xtd-surveys').editor;

		if (lang !== '')
		{
			hreflang = ' hreflang="' + lang + '"';
		}

		tag = '<a' + hreflang + ' href="' + link + '">' + title + '</a>';

		/** Use the API, if editor supports it **/
		if (window.parent.Joomla && window.parent.Joomla.editors && window.parent.Joomla.editors.instances && window.parent.Joomla.editors.instances.hasOwnProperty(editor)) {
			window.parent.Joomla.editors.instances[editor].replaceSelection(tag)
		} else {
			window.parent.jInsertEditorText(tag, editor);
		}

		window.parent.jModalClose();
	};

	document.addEventListener('DOMContentLoaded', function(){
		// Get the elements
		var elements = document.querySelectorAll('.select-link');
	
		for(var i = 0, l = elements.length; l>i; i++) {
			// Listen for click event
			elements[i].addEventListener('click', function (event) {
				event.preventDefault();
				var functionName = event.target.getAttribute('data-function');
	
				if (functionName === 'jSelectSurvey') {
					// Used in xtd_contacts
					window[functionName](event.target.getAttribute('data-id'), event.target.getAttribute('data-title'), event.target.getAttribute('data-cat-id'), null, event.target.getAttribute('data-uri'), event.target.getAttribute('data-language'));
				} else {
					// Used in com_menus
					window.parent[functionName](event.target.getAttribute('data-id'), event.target.getAttribute('data-title'), event.target.getAttribute('data-cat-id'), null, event.target.getAttribute('data-uri'), event.target.getAttribute('data-language'));
				}
			})
		}
	});
})();
