<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysController extends JControllerLegacy
{
	protected $default_view = 'dashboard';

	public function display ($cachable = false, $urlparams = false)
	{
		$layout 		= $this->input->get('layout');
		$id 			= $this->input->getInt('id');
		$view 			= $this->input->get('view', 'dashboard');
		
		// Check for edit form.
		if ($view == 'survey' && $layout == 'edit' && ! $this->checkEditId('com_communitysurveys.edit.survey', $id))
		{
			// Somehow the person just went to the form - we don't allow that.
		    $message = JText::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id);
		    $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), $message, 'error');
			return false;
		}
		
		$document = JFactory::getDocument();
		if(method_exists($document, 'addCustomTag') && $document->getType() != 'pdf' && $document->getType() != 'feed')
		{
		    $params = JComponentHelper::getParams('com_communitysurveys');
		    $custom_tag = $params->get('custom_tag', false);
		    
		    CjLib::behavior('bootstrap', array('loadcss' => false));
			CJLib::behavior('bscore', array('customtag'=>$custom_tag));
			CjScript::_('datetime', array('custom'=>$custom_tag, 'version' => CS_MAJOR_VERSION < 4 ? 3 : 4));
			CjScript::_('noty', array('custom'=>$custom_tag));
			CjScript::_('chartjs', array('custom'=>$custom_tag));
			CjScript::_('querybuilder', array('custom'=>$custom_tag));
			CjScript::_('fontawesome', array('custom'=>$custom_tag));
			CjScript::_('form', array('custom'=>$custom_tag));
			CjScript::_('validate', array('custom'=>$custom_tag));
			CjScript::_('blockui', array('custom'=>$custom_tag));
			CjScript::_('message', array('custom'=>$custom_tag));

			if(version_compare(CJLIB_VER, '2.8.9', '>'))
			{
			    CjScript::_('rating', array('custom' => $custom_tag, 'style' => 'fontawesome-stars-o'));
			}
			else
			{
			    CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/fontawesome-stars-o.css', $custom_tag);
			    CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/jquery.barrating.min.js', $custom_tag);
			}

			CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/cj.surveys.min.css', $custom_tag);
			CJFunctions::add_script(JUri::root(true).'/administrator/components/com_communitysurveys/assets/js/cj.surveys.admin.min.js', $custom_tag);
			CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/cj.surveys.min.js', $custom_tag);
			
			CJFunctions::send_messages_from_queue();
		}
		
		parent::display();
		return $this;
	}
}
