<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

jimport('joomla.application.component.controller');

class CommunitySurveysControllerImport extends JControllerForm 
{
	protected $view_item = 'surveys'; 
	
	function __construct() 
	{
		parent::__construct();
	}

	function save($key = null, $urlVar = 'id')
	{
		$user = JFactory::getUser();
		$message = '';
		$msgtyp = 'message';
		
		if(!$user->authorise('core.create', 'com_communitysurveys') && !$user->authorise('core.manage', 'com_communitysurveys'))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
		}
		else
		{
			$model = $this->getModel();
			$app = JFactory::getApplication();
			
			$file = $app->input->files->get('xmlfile', array(), 'array');
			
			if ($file['error'] > 0)
			{
				$message =  'File/File Size Error. File Error='.$file['error'].'| File Size='.$file['size'];
				$msgtyp = 'error';
			}
			else if (JFile::getExt($file['name']) != 'xml')
			{
				$message = 'Invalid file extension.';
				$msgtyp = 'error';
			}
			else
			{
				$xml = simplexml_load_file($file['tmp_name']);
				if(!empty($xml) && $model->importSurvey($xml))
				{
					$message = JText::_('COM_COMMUNITYSURVEYS_SURVEY_IMPORT_SUCCESS');
				}
				else
				{
					$message = JText::_('COM_COMMUNITYSURVEYS_SURVEY_IMPORT_FAILURE');
					$msgtyp = 'error';
				}
			}
		}
		
		$this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=surveys', false), $message, $msgtyp);
	}
	
	public function cancel($key = null)
	{
		return parent::cancel();
	}
}
?>
