<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
require_once JPATH_ADMINISTRATOR.'/components/com_communitysurveys/controllers/questions.php';

class CommunitySurveysControllerQuestion extends CommunitySurveysControllerQuestions
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}

	public function execute ($task)
	{
		try
		{
			switch ($task)
			{
				case 'save':
				case 'add':
					$this->save();
					break;
						
				case 'remove':
					$this->remove();
					break;
	
				case 'move':
					$this->move();
					break;
	
				case 'copy':
					$this->copy();
					break;
	
				case 'reorder':
					$this->reorder();
					break;
					
				case 'reorderpages':
					$this->reorderPages();
					break;
						
				case 'addpage':
					$this->addPage();
					break;
						
				case 'deletepage':
					$this->deletePage();
					break;
						
				case 'loadpage':
					$this->loadPage();
					break;
						
				case 'savepagetitle':
					$this->savePageTitle();
					break;
						
				case 'upload':
					$this->uploadImage();
					break;
					
				case 'saverule':
				    $this->saveRule();
				    break;
				    
				case 'deleterule':
					$this->deleteRule();
					break;
			}
		}
		catch (Exception $e)
		{
			echo new JResponseJson($e);
		}
		jexit();
	}
	
	public function getModel ($name = 'question', $prefix = '', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
}